#ifndef A6XX_XML
#define A6XX_XML

/* Autogenerated file, DO NOT EDIT manually! */

#ifdef __KERNEL__
#include <linux/bug.h>
#define assert(x) BUG_ON(!(x))
#else
#include <assert.h>
#endif

#ifdef __cplusplus
#define __struct_cast(X)
#define CONSTEXPR constexpr
#else
#define __struct_cast(X) (struct X)
#define CONSTEXPR
#endif

#if defined(__clang__) && !defined(FD_NO_DEPRECATED_PACK)
#define __FD_DEPRECATED _Pragma ("GCC warning \"Deprecated reg builder\"")
#else
#define __FD_DEPRECATED
#endif

enum a7xx_bin_scale {
	NOSCALE = 0,
	SCALE2X = 1,
	SCALE4X = 2,
};

enum a6xx_shift_amount {
	NO_SHIFT = 0,
	HALF_PIXEL_SHIFT = 1,
	FULL_PIXEL_SHIFT = 2,
};

enum a6xx_sequenced_thread_dist {
	DIST_SCREEN_COORD = 0,
	DIST_ALL_TO_RB0 = 1,
};

enum a6xx_single_prim_mode {
	NO_FLUSH = 0,
	FLUSH_PER_OVERLAP_AND_OVERWRITE = 1,
	FLUSH_PER_OVERLAP = 3,
};

enum a6xx_raster_mode {
	TYPE_TILED = 0,
	TYPE_WRITER = 1,
};

enum a6xx_raster_direction {
	LR_TB = 0,
	RL_TB = 1,
	LR_BT = 2,
	RB_BT = 3,
};

enum a6xx_render_mode {
	RENDERING_PASS = 0,
	BINNING_PASS = 1,
};

enum a6xx_buffers_location {
	BUFFERS_IN_GMEM = 0,
	BUFFERS_IN_SYSMEM = 3,
};

enum a6xx_lrz_feedback_mask {
	LRZ_FEEDBACK_NONE = 0,
	LRZ_FEEDBACK_EARLY_Z = 1,
	LRZ_FEEDBACK_EARLY_Z_LATE_Z = 2,
	LRZ_FEEDBACK_EARLY_Z_OR_EARLY_Z_LATE_Z = 3,
	LRZ_FEEDBACK_LATE_Z = 4,
};

enum a6xx_fsr_combiner {
	FSR_COMBINER_OP_KEEP = 0,
	FSR_COMBINER_OP_REPLACE = 1,
	FSR_COMBINER_OP_MIN = 2,
	FSR_COMBINER_OP_MAX = 3,
	FSR_COMBINER_OP_MUL = 4,
};

enum a6xx_fsr_combiner_clamp_mode {
	FSR_COMBINER_CLAMP_4x4 = 0,
	FSR_COMBINER_CLAMP_2x2 = 1,
	FSR_COMBINER_CLAMP_16_SAMP = 2,
};

enum a6xx_lrz_dir_status {
	LRZ_DIR_LE = 1,
	LRZ_DIR_GE = 2,
	LRZ_DIR_INVALID = 3,
};

enum a6xx_fragcoord_sample_mode {
	FRAGCOORD_CENTER = 0,
	FRAGCOORD_SAMPLE = 3,
};

enum a6xx_rotation {
	ROTATE_0 = 0,
	ROTATE_90 = 1,
	ROTATE_180 = 2,
	ROTATE_270 = 3,
	ROTATE_HFLIP = 4,
	ROTATE_VFLIP = 5,
};

enum a6xx_blit_event_type {
	BLIT_EVENT_STORE = 0,
	BLIT_EVENT_STORE_AND_CLEAR = 1,
	BLIT_EVENT_CLEAR = 2,
	BLIT_EVENT_LOAD = 3,
};

enum a7xx_blit_clear_mode {
	CLEAR_MODE_SYSMEM = 0,
	CLEAR_MODE_GMEM = 1,
};

enum a6xx_ccu_cache_size {
	CCU_CACHE_SIZE_FULL = 0,
	CCU_CACHE_SIZE_HALF = 1,
	CCU_CACHE_SIZE_QUARTER = 2,
	CCU_CACHE_SIZE_EIGHTH = 3,
	CCU_CACHE_SIZE_THREE_QUARTER = 3,
};

enum a7xx_concurrent_resolve_mode {
	CONCURRENT_RESOLVE_MODE_DISABLED = 0,
	CONCURRENT_RESOLVE_MODE_1 = 1,
	CONCURRENT_RESOLVE_MODE_2 = 2,
};

enum a7xx_concurrent_unresolve_mode {
	CONCURRENT_UNRESOLVE_MODE_DISABLED = 0,
	CONCURRENT_UNRESOLVE_MODE_PARTIAL = 1,
	CONCURRENT_UNRESOLVE_MODE_FULL = 3,
};

enum a6xx_varying_interp_mode {
	INTERP_SMOOTH = 0,
	INTERP_FLAT = 1,
	INTERP_ZERO = 2,
	INTERP_ONE = 3,
};

enum a6xx_varying_ps_repl_mode {
	PS_REPL_NONE = 0,
	PS_REPL_S = 1,
	PS_REPL_T = 2,
	PS_REPL_ONE_MINUS_T = 3,
};

enum a6xx_threadsize {
	THREAD64 = 0,
	THREAD128 = 1,
};

enum a6xx_const_ram_mode {
	CONSTLEN_128 = 0,
	CONSTLEN_192 = 1,
	CONSTLEN_256 = 2,
	CONSTLEN_512 = 3,
};

enum a7xx_workitem_rast_order {
	WORKITEMRASTORDER_LINEAR = 0,
	WORKITEMRASTORDER_TILED = 1,
};

enum a6xx_bindless_descriptor_size {
	BINDLESS_DESCRIPTOR_16B = 1,
	BINDLESS_DESCRIPTOR_64B = 3,
};

enum a6xx_isam_mode {
	ISAMMODE_CL = 1,
	ISAMMODE_GL = 2,
};

enum a6xx_sp_a2d_output_ifmt_type {
	OUTPUT_IFMT_2D_FLOAT = 0,
	OUTPUT_IFMT_2D_SINT = 1,
	OUTPUT_IFMT_2D_UINT = 2,
};

enum a6xx_coord_round {
	COORD_TRUNCATE = 0,
	COORD_ROUND_NEAREST_EVEN = 1,
	ROUND_FLOAT_TO_INT = 2,
};

enum a6xx_nearest_mode {
	ROUND_CLAMP_TRUNCATE = 0,
	CLAMP_ROUND_TRUNCATE = 1,
};

enum a7xx_cs_yalign {
	CS_YALIGN_1 = 8,
	CS_YALIGN_2 = 4,
	CS_YALIGN_4 = 2,
	CS_YALIGN_8 = 1,
};

#define A6XX_RBBM_INT_0_MASK_RBBM_GPU_IDLE			0x00000001
#define A6XX_RBBM_INT_0_MASK_CP_AHB_ERROR			0x00000002
#define A6XX_RBBM_INT_0_MASK_CP_IPC_INTR_0			0x00000010
#define A6XX_RBBM_INT_0_MASK_CP_IPC_INTR_1			0x00000020
#define A6XX_RBBM_INT_0_MASK_RBBM_ATB_ASYNCFIFO_OVERFLOW	0x00000040
#define A6XX_RBBM_INT_0_MASK_RBBM_GPC_ERROR			0x00000080
#define A6XX_RBBM_INT_0_MASK_CP_SW				0x00000100
#define A6XX_RBBM_INT_0_MASK_CP_HW_ERROR			0x00000200
#define A6XX_RBBM_INT_0_MASK_CP_CCU_FLUSH_DEPTH_TS		0x00000400
#define A6XX_RBBM_INT_0_MASK_CP_CCU_FLUSH_COLOR_TS		0x00000800
#define A6XX_RBBM_INT_0_MASK_CP_CCU_RESOLVE_TS			0x00001000
#define A6XX_RBBM_INT_0_MASK_CP_IB2				0x00002000
#define A6XX_RBBM_INT_0_MASK_CP_IB1				0x00004000
#define A6XX_RBBM_INT_0_MASK_CP_RB				0x00008000
#define A6XX_RBBM_INT_0_MASK_PM4CPINTERRUPT			0x00008000
#define A6XX_RBBM_INT_0_MASK_PM4CPINTERRUPTLPAC			0x00010000
#define A6XX_RBBM_INT_0_MASK_CP_RB_DONE_TS			0x00020000
#define A6XX_RBBM_INT_0_MASK_CP_WT_DONE_TS			0x00040000
#define A6XX_RBBM_INT_0_MASK_CP_CACHE_FLUSH_TS			0x00100000
#define A6XX_RBBM_INT_0_MASK_CP_CACHE_FLUSH_TS_LPAC		0x00200000
#define A6XX_RBBM_INT_0_MASK_RBBM_ATB_BUS_OVERFLOW		0x00400000
#define A6XX_RBBM_INT_0_MASK_RBBM_HANG_DETECT			0x00800000
#define A6XX_RBBM_INT_0_MASK_UCHE_OOB_ACCESS			0x01000000
#define A6XX_RBBM_INT_0_MASK_UCHE_TRAP_INTR			0x02000000
#define A6XX_RBBM_INT_0_MASK_DEBBUS_INTR_0			0x04000000
#define A6XX_RBBM_INT_0_MASK_DEBBUS_INTR_1			0x08000000
#define A6XX_RBBM_INT_0_MASK_TSBWRITEERROR			0x10000000
#define A6XX_RBBM_INT_0_MASK_SWFUSEVIOLATION			0x20000000
#define A6XX_RBBM_INT_0_MASK_ISDB_CPU_IRQ			0x40000000
#define A6XX_RBBM_INT_0_MASK_ISDB_UNDER_DEBUG			0x80000000

#define A6XX_CP_INT_CP_OPCODE_ERROR				0x00000001
#define A6XX_CP_INT_CP_UCODE_ERROR				0x00000002
#define A6XX_CP_INT_CP_HW_FAULT_ERROR				0x00000004
#define A6XX_CP_INT_CP_REGISTER_PROTECTION_ERROR		0x00000010
#define A6XX_CP_INT_CP_AHB_ERROR				0x00000020
#define A6XX_CP_INT_CP_VSD_PARITY_ERROR				0x00000040
#define A6XX_CP_INT_CP_ILLEGAL_INSTR_ERROR			0x00000080
#define A6XX_CP_INT_CP_OPCODE_ERROR_LPAC			0x00000100
#define A6XX_CP_INT_CP_UCODE_ERROR_LPAC				0x00000200
#define A6XX_CP_INT_CP_HW_FAULT_ERROR_LPAC			0x00000400
#define A6XX_CP_INT_CP_REGISTER_PROTECTION_ERROR_LPAC		0x00000800
#define A6XX_CP_INT_CP_ILLEGAL_INSTR_ERROR_LPAC			0x00001000
#define A6XX_CP_INT_CP_OPCODE_ERROR_BV				0x00002000
#define A6XX_CP_INT_CP_UCODE_ERROR_BV				0x00004000
#define A6XX_CP_INT_CP_HW_FAULT_ERROR_BV			0x00008000
#define A6XX_CP_INT_CP_REGISTER_PROTECTION_ERROR_BV		0x00010000
#define A6XX_CP_INT_CP_ILLEGAL_INSTR_ERROR_BV			0x00020000

#define A8XX_CP_GLOBAL_INT_MASK_HWFAULTBR			0x00000001
#define A8XX_CP_GLOBAL_INT_MASK_HWFAULTBV			0x00000002
#define A8XX_CP_GLOBAL_INT_MASK_HWFAULTLPAC			0x00000004
#define A8XX_CP_GLOBAL_INT_MASK_HWFAULTAQE0			0x00000008
#define A8XX_CP_GLOBAL_INT_MASK_HWFAULTAQE1			0x00000010
#define A8XX_CP_GLOBAL_INT_MASK_HWFAULTDDEBR			0x00000020
#define A8XX_CP_GLOBAL_INT_MASK_HWFAULTDDEBV			0x00000040
#define A8XX_CP_GLOBAL_INT_MASK_SWFAULTBR			0x00010000
#define A8XX_CP_GLOBAL_INT_MASK_SWFAULTBV			0x00020000
#define A8XX_CP_GLOBAL_INT_MASK_SWFAULTLPAC			0x00040000
#define A8XX_CP_GLOBAL_INT_MASK_SWFAULTAQE0			0x00080000
#define A8XX_CP_GLOBAL_INT_MASK_SWFAULTAQE1			0x00100000
#define A8XX_CP_GLOBAL_INT_MASK_SWFAULTDDEBR			0x00200000
#define A8XX_CP_GLOBAL_INT_MASK_SWFAULTDDEBV			0x00400000

#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE_CSFRBWRAP		0x00000001
#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE_CSFIB1WRAP		0x00000002
#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE_CSFIB2WRAP		0x00000004
#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE_CSFIB3WRAP		0x00000008
#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE_CSFSDSWRAP		0x00000010
#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE_CSFMRBWRAP		0x00000020
#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE_CSFVSDWRAP		0x00000040
#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE_OPCODEERROR		0x00000100
#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE_VSDPARITYERROR	0x00000200
#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE_REGISTERPROTECTIONERROR	0x00000400
#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE_ILLEGALINSTRUCTION	0x00000800
#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE_SMMUFAULT		0x00001000
#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE_VBIFRESP		0x00400000
#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE_RTWROVF		0x00800000
#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE_LRZRTWROVF		0x01000000
#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE_LRZRTREFCNTOVF	0x02000000
#define A8XX_CP_INTERRUPT_STATUS_MASK_PIPE_LRZRTCLRRESMISS	0x04000000

#define A8XX_CP_HW_FAULT_STATUS_MASK_PIPE_CSFRBFAULT		0x00000001
#define A8XX_CP_HW_FAULT_STATUS_MASK_PIPE_CSFIB1FAULT		0x00000002
#define A8XX_CP_HW_FAULT_STATUS_MASK_PIPE_CSFIB2FAULT		0x00000004
#define A8XX_CP_HW_FAULT_STATUS_MASK_PIPE_CSFIB3FAULT		0x00000008
#define A8XX_CP_HW_FAULT_STATUS_MASK_PIPE_CSFSDSFAULT		0x00000010
#define A8XX_CP_HW_FAULT_STATUS_MASK_PIPE_CSFMRBFAULT		0x00000020
#define A8XX_CP_HW_FAULT_STATUS_MASK_PIPE_CSFVSDFAULT		0x00000040
#define A8XX_CP_HW_FAULT_STATUS_MASK_PIPE_SQEREADBURSTOVF	0x00000100
#define A8XX_CP_HW_FAULT_STATUS_MASK_PIPE_EVENTENGINEOVF	0x00000200
#define A8XX_CP_HW_FAULT_STATUS_MASK_PIPE_UCODEERROR		0x00000400

#define a6xx_gras_cl_guardband_clip_adj_HORZ__MASK		0x000001ffull
#define a6xx_gras_cl_guardband_clip_adj_HORZ__SHIFT		0
static CONSTEXPR inline uint32_t a6xx_gras_cl_guardband_clip_adj_HORZ(uint32_t val)
{
	return ((val) << a6xx_gras_cl_guardband_clip_adj_HORZ__SHIFT) & a6xx_gras_cl_guardband_clip_adj_HORZ__MASK;
}
#define a6xx_gras_cl_guardband_clip_adj_VERT__MASK		0x0007fc00ull
#define a6xx_gras_cl_guardband_clip_adj_VERT__SHIFT		10
static CONSTEXPR inline uint32_t a6xx_gras_cl_guardband_clip_adj_VERT(uint32_t val)
{
	return ((val) << a6xx_gras_cl_guardband_clip_adj_VERT__SHIFT) & a6xx_gras_cl_guardband_clip_adj_VERT__MASK;
}

#define REG_A6XX_CP_RB_BASE					0x00000800
static CONSTEXPR inline uint32_t A6XX_CP_RB_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_CP_RB_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_CP_RB_CNTL					0x00000802


#define REG_A7XX_CP_RB_RPTR_WR					__FD_DEPRECATED 0x00000803


#define REG_A6XX_CP_RB_RPTR_ADDR				0x00000804
static CONSTEXPR inline uint32_t A6XX_CP_RB_RPTR_ADDR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_CP_RB_RPTR_ADDR_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_CP_RB_RPTR					0x00000806


#define REG_A6XX_CP_RB_WPTR					0x00000807


#define REG_A8XX_CP_RB_RPTR_ADDR_BV				__FD_DEPRECATED 0x00000808


#define REG_A8XX_CP_RB_RPTR_BV					__FD_DEPRECATED 0x0000080a


#define REG_A8XX_CP_RB_BASE_LPAC				__FD_DEPRECATED 0x0000080b
static CONSTEXPR inline uint32_t A8XX_CP_RB_BASE_LPAC_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_CP_RB_BASE_LPAC_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_CP_RB_CNTL_LPAC				__FD_DEPRECATED 0x0000080d


#define REG_A8XX_CP_RB_RPTR_WR_LPAC				__FD_DEPRECATED 0x0000080e


#define REG_A8XX_CP_RB_RPTR_ADDR_LPAC				__FD_DEPRECATED 0x0000080f
static CONSTEXPR inline uint32_t A8XX_CP_RB_RPTR_ADDR_LPAC_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_CP_RB_RPTR_ADDR_LPAC_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_CP_RB_RPTR_LPAC				__FD_DEPRECATED 0x00000811


#define REG_A8XX_CP_RB_WPTR_LPAC				__FD_DEPRECATED 0x00000812


#define REG_A8XX_CP_SMMU_STREAM_ID_LPAC				__FD_DEPRECATED 0x00000814


#define REG_A6XX_CP_SQE_CNTL					__FD_DEPRECATED 0x00000808


#define REG_A8XX_CP_SQE_CNTL					__FD_DEPRECATED 0x00000815


#define REG_A8XX_CP_SQE_INSTR_BASE				__FD_DEPRECATED 0x00000816
static CONSTEXPR inline uint32_t A8XX_CP_SQE_INSTR_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_CP_SQE_INSTR_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_CP_AQE_INSTR_BASE_0				__FD_DEPRECATED 0x00000818
static CONSTEXPR inline uint32_t A8XX_CP_AQE_INSTR_BASE_0_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_CP_AQE_INSTR_BASE_0_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_CP_AQE_INSTR_BASE_1				__FD_DEPRECATED 0x0000081a
static CONSTEXPR inline uint32_t A8XX_CP_AQE_INSTR_BASE_1_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_CP_AQE_INSTR_BASE_1_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_CP_CP2GMU_STATUS				__FD_DEPRECATED 0x00000812
#define A6XX_CP_CP2GMU_STATUS_IFPC				0x00000001


#define REG_A8XX_CP_CP2GMU_STATUS				__FD_DEPRECATED 0x00000822
#define A8XX_CP_CP2GMU_STATUS_IFPC				0x00000001


#define REG_A6XX_CP_HW_FAULT					__FD_DEPRECATED 0x00000821


#define REG_A6XX_CP_INTERRUPT_STATUS				__FD_DEPRECATED 0x00000823

#define REG_A6XX_CP_PROTECT_STATUS				__FD_DEPRECATED 0x00000824
#define A6XX_CP_PROTECT_STATUS_ADDR__MASK			0x0003ffffull
#define A6XX_CP_PROTECT_STATUS_ADDR__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_CP_PROTECT_STATUS_ADDR(uint32_t val)
{
	return ((val) << A6XX_CP_PROTECT_STATUS_ADDR__SHIFT) & A6XX_CP_PROTECT_STATUS_ADDR__MASK;
}
#define A6XX_CP_PROTECT_STATUS_READ				0x00100000
#define A6XX_CP_PROTECT_STATUS_CP_HALTED			0x00200000
#define A6XX_CP_PROTECT_STATUS_ACCESS_VIOLATION			0x00400000


#define REG_A8XX_CP_PROTECT_STATUS_PIPE				__FD_DEPRECATED 0x0000084f
#define A8XX_CP_PROTECT_STATUS_PIPE_ADDR__MASK			0x0003ffffull
#define A8XX_CP_PROTECT_STATUS_PIPE_ADDR__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_CP_PROTECT_STATUS_PIPE_ADDR(uint32_t val)
{
	return ((val) << A8XX_CP_PROTECT_STATUS_PIPE_ADDR__SHIFT) & A8XX_CP_PROTECT_STATUS_PIPE_ADDR__MASK;
}
#define A8XX_CP_PROTECT_STATUS_PIPE_READ			0x00100000
#define A8XX_CP_PROTECT_STATUS_PIPE_CP_HALTED			0x00200000
#define A8XX_CP_PROTECT_STATUS_PIPE_ACCESS_VIOLATION		0x00400000


#define REG_A6XX_CP_STATUS_1					__FD_DEPRECATED 0x00000825


#define REG_A8XX_CP_SEMAPHORE_REG_0				__FD_DEPRECATED 0x00000825


#define REG_A8XX_CP_SCRATCH_GLOBAL(i0)				(0x0000082a + 0x1*i0 )



#define REG_A8XX_CP_SCRATCH_PIPE(i0)				(0x00000830 + 0x1*i0 )



#define REG_A8XX_CP_RL_ERROR_DETAILS_0				__FD_DEPRECATED 0x00000840


#define REG_A8XX_CP_RL_ERROR_DETAILS_1				__FD_DEPRECATED 0x00000841


#define REG_A6XX_CP_SQE_INSTR_BASE				__FD_DEPRECATED 0x00000830
static CONSTEXPR inline uint32_t A6XX_CP_SQE_INSTR_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_CP_SQE_INSTR_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_CP_MISC_CNTL					__FD_DEPRECATED 0x00000840


#define REG_A8XX_CP_MISC_CNTL					__FD_DEPRECATED 0x0000084c


#define REG_A8XX_CP_SQE_ICACHE_CNTL_PIPE			__FD_DEPRECATED 0x000008b0


#define REG_A8XX_CP_SQE_DCACHE_CNTL_PIPE			__FD_DEPRECATED 0x000008b1


#define REG_A8XX_CP_HW_FAULT_STATUS_PIPE			__FD_DEPRECATED 0x000008b3


#define REG_A8XX_CP_HW_FAULT_STATUS_MASK_PIPE			__FD_DEPRECATED 0x000008b4


#define REG_A8XX_CP_INTERRUPT_STATUS_GLOBAL			__FD_DEPRECATED 0x000008b5

#define REG_A8XX_CP_INTERRUPT_STATUS_MASK_GLOBAL		__FD_DEPRECATED 0x000008b6

#define REG_A8XX_CP_INTERRUPT_STATUS_PIPE			__FD_DEPRECATED 0x000008b7

#define REG_A8XX_CP_INTERRUPT_STATUS_MASK_PIPE			__FD_DEPRECATED 0x000008b8


#define REG_A8XX_CP_PIPE_STATUS_PIPE				__FD_DEPRECATED 0x000008b9


#define REG_A8XX_CP_GPU_BATCH_ID_PIPE				__FD_DEPRECATED 0x000008ba


#define REG_A8XX_CP_SQE_STATUS_PIPE				__FD_DEPRECATED 0x000008bb


#define REG_A6XX_CP_APRIV_CNTL					__FD_DEPRECATED 0x00000844
#define A6XX_CP_APRIV_CNTL_CDWRITE				0x00000040
#define A6XX_CP_APRIV_CNTL_CDREAD				0x00000020
#define A6XX_CP_APRIV_CNTL_SCRATCHWT				0x00000010
#define A6XX_CP_APRIV_CNTL_RBRPWB				0x00000008
#define A6XX_CP_APRIV_CNTL_RBPRIVLEVEL				0x00000004
#define A6XX_CP_APRIV_CNTL_RBFETCH				0x00000002
#define A6XX_CP_APRIV_CNTL_ICACHE				0x00000001


#define REG_A8XX_CP_APRIV_CNTL_PIPE				__FD_DEPRECATED 0x0000084d
#define A8XX_CP_APRIV_CNTL_PIPE_CDWRITE				0x00000040
#define A8XX_CP_APRIV_CNTL_PIPE_CDREAD				0x00000020
#define A8XX_CP_APRIV_CNTL_PIPE_SCRATCHWT			0x00000010
#define A8XX_CP_APRIV_CNTL_PIPE_RBRPWB				0x00000008
#define A8XX_CP_APRIV_CNTL_PIPE_RBPRIVLEVEL			0x00000004
#define A8XX_CP_APRIV_CNTL_PIPE_RBFETCH				0x00000002
#define A8XX_CP_APRIV_CNTL_PIPE_ICACHE				0x00000001


#define REG_A6XX_CP_PREEMPT_THRESHOLD				__FD_DEPRECATED 0x000008c0


#define REG_A8XX_CP_PREEMPT_THRESHOLD				__FD_DEPRECATED 0x000008ec


#define REG_A6XX_CP_ROQ_THRESHOLDS_1				__FD_DEPRECATED 0x000008c1
#define A6XX_CP_ROQ_THRESHOLDS_1_MRB_START__MASK		0x000000ffull
#define A6XX_CP_ROQ_THRESHOLDS_1_MRB_START__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_THRESHOLDS_1_MRB_START(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A6XX_CP_ROQ_THRESHOLDS_1_MRB_START__SHIFT) & A6XX_CP_ROQ_THRESHOLDS_1_MRB_START__MASK;
}
#define A6XX_CP_ROQ_THRESHOLDS_1_VSD_START__MASK		0x0000ff00ull
#define A6XX_CP_ROQ_THRESHOLDS_1_VSD_START__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_THRESHOLDS_1_VSD_START(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A6XX_CP_ROQ_THRESHOLDS_1_VSD_START__SHIFT) & A6XX_CP_ROQ_THRESHOLDS_1_VSD_START__MASK;
}
#define A6XX_CP_ROQ_THRESHOLDS_1_IB1_START__MASK		0x00ff0000ull
#define A6XX_CP_ROQ_THRESHOLDS_1_IB1_START__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_THRESHOLDS_1_IB1_START(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A6XX_CP_ROQ_THRESHOLDS_1_IB1_START__SHIFT) & A6XX_CP_ROQ_THRESHOLDS_1_IB1_START__MASK;
}
#define A6XX_CP_ROQ_THRESHOLDS_1_IB2_START__MASK		0xff000000ull
#define A6XX_CP_ROQ_THRESHOLDS_1_IB2_START__SHIFT		24
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_THRESHOLDS_1_IB2_START(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A6XX_CP_ROQ_THRESHOLDS_1_IB2_START__SHIFT) & A6XX_CP_ROQ_THRESHOLDS_1_IB2_START__MASK;
}


#define REG_A6XX_CP_ROQ_THRESHOLDS_2				__FD_DEPRECATED 0x000008c2
#define A6XX_CP_ROQ_THRESHOLDS_2_SDS_START__MASK		0x000001ffull
#define A6XX_CP_ROQ_THRESHOLDS_2_SDS_START__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_THRESHOLDS_2_SDS_START(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A6XX_CP_ROQ_THRESHOLDS_2_SDS_START__SHIFT) & A6XX_CP_ROQ_THRESHOLDS_2_SDS_START__MASK;
}
#define A6XX_CP_ROQ_THRESHOLDS_2_ROQ_SIZE__MASK			0xffff0000ull
#define A6XX_CP_ROQ_THRESHOLDS_2_ROQ_SIZE__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_THRESHOLDS_2_ROQ_SIZE(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A6XX_CP_ROQ_THRESHOLDS_2_ROQ_SIZE__SHIFT) & A6XX_CP_ROQ_THRESHOLDS_2_ROQ_SIZE__MASK;
}


#define REG_A6XX_CP_MEM_POOL_SIZE				__FD_DEPRECATED 0x000008c3


#define REG_A6XX_CP_CHICKEN_DBG					__FD_DEPRECATED 0x00000841


#define REG_A8XX_CP_CHICKEN_DBG_PIPE				__FD_DEPRECATED 0x000008b2


#define REG_A6XX_CP_ADDR_MODE_CNTL				__FD_DEPRECATED 0x00000842


#define REG_A6XX_CP_DBG_ECO_CNTL				__FD_DEPRECATED 0x00000843


#define REG_A8XX_CP_DBG_ECO_CNTL				__FD_DEPRECATED 0x0000084b


#define REG_A6XX_CP_PROTECT_CNTL				__FD_DEPRECATED 0x0000084f
#define A6XX_CP_PROTECT_CNTL_LAST_SPAN_INF_RANGE		0x00000008
#define A6XX_CP_PROTECT_CNTL_ACCESS_FAULT_ON_VIOL_EN		0x00000002
#define A6XX_CP_PROTECT_CNTL_ACCESS_PROT_EN			0x00000001


#define REG_A8XX_CP_PROTECT_CNTL_PIPE				__FD_DEPRECATED 0x0000084e
#define A8XX_CP_PROTECT_CNTL_PIPE_HALT_SQE_RANGE__MASK		0xffff0000ull
#define A8XX_CP_PROTECT_CNTL_PIPE_HALT_SQE_RANGE__SHIFT		16
static CONSTEXPR inline uint32_t A8XX_CP_PROTECT_CNTL_PIPE_HALT_SQE_RANGE(uint32_t val)
{
	return ((val) << A8XX_CP_PROTECT_CNTL_PIPE_HALT_SQE_RANGE__SHIFT) & A8XX_CP_PROTECT_CNTL_PIPE_HALT_SQE_RANGE__MASK;
}
#define A8XX_CP_PROTECT_CNTL_PIPE_LAST_SPAN_INF_RANGE		0x00000008
#define A8XX_CP_PROTECT_CNTL_PIPE_ACCESS_FAULT_ON_VIOL_EN	0x00000002
#define A8XX_CP_PROTECT_CNTL_PIPE_ACCESS_PROT_EN		0x00000001


#define REG_A6XX_CP_SCRATCH(i0)					(0x00000883 + 0x1*i0 )



#define REG_A6XX_CP_PROTECT(i0)					(0x00000850 + 0x1*i0 )

#define A6XX_CP_PROTECT_REG_BASE_ADDR__MASK			0x0003ffffull
#define A6XX_CP_PROTECT_REG_BASE_ADDR__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_CP_PROTECT_REG_BASE_ADDR(uint32_t val)
{
	return ((val) << A6XX_CP_PROTECT_REG_BASE_ADDR__SHIFT) & A6XX_CP_PROTECT_REG_BASE_ADDR__MASK;
}
#define A6XX_CP_PROTECT_REG_MASK_LEN__MASK			0x7ffc0000ull
#define A6XX_CP_PROTECT_REG_MASK_LEN__SHIFT			18
static CONSTEXPR inline uint32_t A6XX_CP_PROTECT_REG_MASK_LEN(uint32_t val)
{
	return ((val) << A6XX_CP_PROTECT_REG_MASK_LEN__SHIFT) & A6XX_CP_PROTECT_REG_MASK_LEN__MASK;
}
#define A6XX_CP_PROTECT_REG_READ				0x80000000


#define REG_A8XX_CP_PROTECT_GLOBAL(i0)				(0x00000850 + 0x1*i0 )

#define A8XX_CP_PROTECT_GLOBAL_REG_BASE_ADDR__MASK		0x0003ffffull
#define A8XX_CP_PROTECT_GLOBAL_REG_BASE_ADDR__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_CP_PROTECT_GLOBAL_REG_BASE_ADDR(uint32_t val)
{
	return ((val) << A8XX_CP_PROTECT_GLOBAL_REG_BASE_ADDR__SHIFT) & A8XX_CP_PROTECT_GLOBAL_REG_BASE_ADDR__MASK;
}
#define A8XX_CP_PROTECT_GLOBAL_REG_MASK_LEN__MASK		0x7ffc0000ull
#define A8XX_CP_PROTECT_GLOBAL_REG_MASK_LEN__SHIFT		18
static CONSTEXPR inline uint32_t A8XX_CP_PROTECT_GLOBAL_REG_MASK_LEN(uint32_t val)
{
	return ((val) << A8XX_CP_PROTECT_GLOBAL_REG_MASK_LEN__SHIFT) & A8XX_CP_PROTECT_GLOBAL_REG_MASK_LEN__MASK;
}
#define A8XX_CP_PROTECT_GLOBAL_REG_READ				0x80000000


#define REG_A8XX_CP_PROTECT_PIPE(i0)				(0x000008a0 + 0x1*i0 )

#define A8XX_CP_PROTECT_PIPE_REG_BASE_ADDR__MASK		0x0003ffffull
#define A8XX_CP_PROTECT_PIPE_REG_BASE_ADDR__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_CP_PROTECT_PIPE_REG_BASE_ADDR(uint32_t val)
{
	return ((val) << A8XX_CP_PROTECT_PIPE_REG_BASE_ADDR__SHIFT) & A8XX_CP_PROTECT_PIPE_REG_BASE_ADDR__MASK;
}
#define A8XX_CP_PROTECT_PIPE_REG_MASK_LEN__MASK			0x7ffc0000ull
#define A8XX_CP_PROTECT_PIPE_REG_MASK_LEN__SHIFT		18
static CONSTEXPR inline uint32_t A8XX_CP_PROTECT_PIPE_REG_MASK_LEN(uint32_t val)
{
	return ((val) << A8XX_CP_PROTECT_PIPE_REG_MASK_LEN__SHIFT) & A8XX_CP_PROTECT_PIPE_REG_MASK_LEN__MASK;
}
#define A8XX_CP_PROTECT_PIPE_REG_READ				0x80000000


#define REG_A6XX_CP_CONTEXT_SWITCH_CNTL				__FD_DEPRECATED 0x000008a0
#define A6XX_CP_CONTEXT_SWITCH_CNTL_STOP			0x00000001
#define A6XX_CP_CONTEXT_SWITCH_CNTL_LEVEL__MASK			0x000000c0ull
#define A6XX_CP_CONTEXT_SWITCH_CNTL_LEVEL__SHIFT		6
static CONSTEXPR inline uint32_t A6XX_CP_CONTEXT_SWITCH_CNTL_LEVEL(uint32_t val)
{
	return ((val) << A6XX_CP_CONTEXT_SWITCH_CNTL_LEVEL__SHIFT) & A6XX_CP_CONTEXT_SWITCH_CNTL_LEVEL__MASK;
}
#define A6XX_CP_CONTEXT_SWITCH_CNTL_USES_GMEM			0x00000100
#define A6XX_CP_CONTEXT_SWITCH_CNTL_SKIP_SAVE_RESTORE		0x00000200


#define REG_A8XX_CP_CONTEXT_SWITCH_CNTL				__FD_DEPRECATED 0x000008c0
#define A8XX_CP_CONTEXT_SWITCH_CNTL_STOP			0x00000001
#define A8XX_CP_CONTEXT_SWITCH_CNTL_LEVEL__MASK			0x000000c0ull
#define A8XX_CP_CONTEXT_SWITCH_CNTL_LEVEL__SHIFT		6
static CONSTEXPR inline uint32_t A8XX_CP_CONTEXT_SWITCH_CNTL_LEVEL(uint32_t val)
{
	return ((val) << A8XX_CP_CONTEXT_SWITCH_CNTL_LEVEL__SHIFT) & A8XX_CP_CONTEXT_SWITCH_CNTL_LEVEL__MASK;
}
#define A8XX_CP_CONTEXT_SWITCH_CNTL_USES_GMEM			0x00000100
#define A8XX_CP_CONTEXT_SWITCH_CNTL_SKIP_SAVE_RESTORE		0x00000200


#define REG_A6XX_CP_CONTEXT_SWITCH_SMMU_INFO			__FD_DEPRECATED 0x000008a1
static CONSTEXPR inline uint32_t A6XX_CP_CONTEXT_SWITCH_SMMU_INFO_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_CP_CONTEXT_SWITCH_SMMU_INFO_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR	__FD_DEPRECATED 0x000008a3
static CONSTEXPR inline uint32_t A6XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR	__FD_DEPRECATED 0x000008a5
static CONSTEXPR inline uint32_t A6XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR	__FD_DEPRECATED 0x000008a7
static CONSTEXPR inline uint32_t A6XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR_HI(uint32_t val)
{
	return val;
}


#define REG_A7XX_CP_CONTEXT_SWITCH_LEVEL_STATUS			__FD_DEPRECATED 0x000008ab


#define REG_A8XX_CP_CONTEXT_SWITCH_SMMU_INFO			__FD_DEPRECATED 0x000008c1
static CONSTEXPR inline uint32_t A8XX_CP_CONTEXT_SWITCH_SMMU_INFO_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_CP_CONTEXT_SWITCH_SMMU_INFO_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR	__FD_DEPRECATED 0x000008c3
static CONSTEXPR inline uint32_t A8XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR	__FD_DEPRECATED 0x000008c5
static CONSTEXPR inline uint32_t A8XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR	__FD_DEPRECATED 0x000008c7
static CONSTEXPR inline uint32_t A8XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_CP_CONTEXT_SWITCH_LEVEL_STATUS			__FD_DEPRECATED 0x000008cb


#define REG_A6XX_CP_PERFCTR_CP_SEL(i0)				(0x000008d0 + 0x1*i0 )



#define REG_A8XX_CP_PERFCTR_CP_SEL(i0)				(0x000008d0 + 0x1*i0 )



#define REG_A7XX_CP_BV_PERFCTR_CP_SEL(i0)			(0x000008e0 + 0x1*i0 )



#define REG_A6XX_CP_CRASH_DUMP_SCRIPT_BASE			__FD_DEPRECATED 0x00000900
static CONSTEXPR inline uint32_t A6XX_CP_CRASH_DUMP_SCRIPT_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_CP_CRASH_DUMP_SCRIPT_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_CP_CRASH_DUMP_CNTL				__FD_DEPRECATED 0x00000902


#define REG_A6XX_CP_CRASH_DUMP_STATUS				__FD_DEPRECATED 0x00000903


#define REG_A8XX_CP_CRASH_DUMP_SCRIPT_BASE			__FD_DEPRECATED 0x00000842
static CONSTEXPR inline uint32_t A8XX_CP_CRASH_DUMP_SCRIPT_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_CP_CRASH_DUMP_SCRIPT_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_CP_CRASH_DUMP_CNTL				__FD_DEPRECATED 0x00000844


#define REG_A8XX_CP_CRASH_DUMP_STATUS				__FD_DEPRECATED 0x00000845


#define REG_A6XX_CP_SQE_STAT_ADDR				__FD_DEPRECATED 0x00000908


#define REG_A6XX_CP_SQE_STAT_DATA				__FD_DEPRECATED 0x00000909


#define REG_A6XX_CP_DRAW_STATE_ADDR				__FD_DEPRECATED 0x0000090a


#define REG_A6XX_CP_DRAW_STATE_DATA				__FD_DEPRECATED 0x0000090b


#define REG_A6XX_CP_ROQ_DBG_ADDR				__FD_DEPRECATED 0x0000090c


#define REG_A6XX_CP_ROQ_DBG_DATA				__FD_DEPRECATED 0x0000090d


#define REG_A6XX_CP_MEM_POOL_DBG_ADDR				__FD_DEPRECATED 0x0000090e


#define REG_A6XX_CP_MEM_POOL_DBG_DATA				__FD_DEPRECATED 0x0000090f


#define REG_A6XX_CP_SQE_UCODE_DBG_ADDR				__FD_DEPRECATED 0x00000910


#define REG_A6XX_CP_SQE_UCODE_DBG_DATA				__FD_DEPRECATED 0x00000911


#define REG_A8XX_CP_SQE_STAT_ADDR_PIPE				__FD_DEPRECATED 0x000008f0


#define REG_A8XX_CP_SQE_STAT_DATA_PIPE				__FD_DEPRECATED 0x000008f1


#define REG_A8XX_CP_DRAW_STATE_ADDR_PIPE			__FD_DEPRECATED 0x000008f2


#define REG_A8XX_CP_DRAW_STATE_DATA_PIPE			__FD_DEPRECATED 0x000008f3


#define REG_A8XX_CP_ROQ_DBG_ADDR_PIPE				__FD_DEPRECATED 0x000008f4


#define REG_A8XX_CP_ROQ_DBG_DATA_PIPE				__FD_DEPRECATED 0x000008f5


#define REG_A8XX_CP_MEM_POOL_DBG_ADDR_PIPE			__FD_DEPRECATED 0x000008f6


#define REG_A8XX_CP_MEM_POOL_DBG_DATA_PIPE			__FD_DEPRECATED 0x000008f7


#define REG_A8XX_CP_SQE_UCODE_DBG_ADDR_PIPE			__FD_DEPRECATED 0x000008f8


#define REG_A8XX_CP_SQE_UCODE_DBG_DATA_PIPE			__FD_DEPRECATED 0x000008f9


#define REG_A8XX_CP_RESOURCE_TABLE_DBG_ADDR_BV			__FD_DEPRECATED 0x000008fa


#define REG_A8XX_CP_RESOURCE_TABLE_DBG_DATA_BV			__FD_DEPRECATED 0x000008fb


#define REG_A8XX_CP_FIFO_DBG_ADDR_LPAC				__FD_DEPRECATED 0x000008fc


#define REG_A8XX_CP_FIFO_DBG_DATA_LPAC				__FD_DEPRECATED 0x000008fd


#define REG_A8XX_CP_FIFO_DBG_ADDR_DDE_PIPE			__FD_DEPRECATED 0x000008fe


#define REG_A8XX_CP_FIFO_DBG_DATA_DDE_PIPE			__FD_DEPRECATED 0x000008ff


#define REG_A8XX_CP_SLICE_MEM_POOL_DBG_ADDR_PIPE		__FD_DEPRECATED 0x00000b00


#define REG_A8XX_CP_SLICE_MEM_POOL_DBG_DATA_PIPE		__FD_DEPRECATED 0x00000b01


#define REG_A8XX_CP_SLICE_CHICKEN_DBG_PIPE			__FD_DEPRECATED 0x00000b93


#define REG_A6XX_CP_IB1_BASE					__FD_DEPRECATED 0x00000928
static CONSTEXPR inline uint32_t A6XX_CP_IB1_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_CP_IB1_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_CP_IB1_REM_SIZE				__FD_DEPRECATED 0x0000092a


#define REG_A6XX_CP_IB2_BASE					__FD_DEPRECATED 0x0000092b
static CONSTEXPR inline uint32_t A6XX_CP_IB2_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_CP_IB2_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_CP_IB2_REM_SIZE				__FD_DEPRECATED 0x0000092d


#define REG_A6XX_CP_SDS_BASE					__FD_DEPRECATED 0x0000092e
static CONSTEXPR inline uint32_t A6XX_CP_SDS_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_CP_SDS_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_CP_SDS_REM_SIZE				__FD_DEPRECATED 0x00000930


#define REG_A6XX_CP_MRB_BASE					__FD_DEPRECATED 0x00000931
static CONSTEXPR inline uint32_t A6XX_CP_MRB_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_CP_MRB_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_CP_MRB_REM_SIZE				__FD_DEPRECATED 0x00000933


#define REG_A6XX_CP_VSD_BASE					__FD_DEPRECATED 0x00000934
static CONSTEXPR inline uint32_t A6XX_CP_VSD_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_CP_VSD_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_CP_IB1_BASE					__FD_DEPRECATED 0x00000900
static CONSTEXPR inline uint32_t A8XX_CP_IB1_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_CP_IB1_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_CP_IB1_REM_SIZE				__FD_DEPRECATED 0x00000902


#define REG_A8XX_CP_IB1_INIT_SIZE				__FD_DEPRECATED 0x00000903


#define REG_A8XX_CP_IB2_BASE					__FD_DEPRECATED 0x00000904
static CONSTEXPR inline uint32_t A8XX_CP_IB2_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_CP_IB2_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_CP_IB2_REM_SIZE				__FD_DEPRECATED 0x00000906


#define REG_A8XX_CP_IB2_INIT_SIZE				__FD_DEPRECATED 0x00000907


#define REG_A8XX_CP_IB3_BASE					__FD_DEPRECATED 0x00000908
static CONSTEXPR inline uint32_t A8XX_CP_IB3_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_CP_IB3_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_CP_IB3_REM_SIZE				__FD_DEPRECATED 0x0000090a


#define REG_A8XX_CP_IB3_INIT_SIZE				__FD_DEPRECATED 0x0000090b


#define REG_A8XX_CP_SDS_BASE					__FD_DEPRECATED 0x0000090c
static CONSTEXPR inline uint32_t A8XX_CP_SDS_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_CP_SDS_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_CP_SDS_REM_SIZE				__FD_DEPRECATED 0x0000090e


#define REG_A8XX_CP_SDS_INIT_SIZE				__FD_DEPRECATED 0x0000090f


#define REG_A8XX_CP_MRB_BASE					__FD_DEPRECATED 0x00000910
static CONSTEXPR inline uint32_t A8XX_CP_MRB_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_CP_MRB_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_CP_MRB_REM_SIZE				__FD_DEPRECATED 0x00000912


#define REG_A8XX_CP_MRB_INIT_SIZE				__FD_DEPRECATED 0x00000913


#define REG_A8XX_CP_VSD_BASE					__FD_DEPRECATED 0x00000914
static CONSTEXPR inline uint32_t A8XX_CP_VSD_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_CP_VSD_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_CP_VSD_REM_SIZE				__FD_DEPRECATED 0x00000916


#define REG_A8XX_CP_VSD_INIT_SIZE				__FD_DEPRECATED 0x00000917


#define REG_A6XX_CP_ROQ_RB_STATUS				__FD_DEPRECATED 0x00000939
#define A6XX_CP_ROQ_RB_STATUS_RPTR__MASK			0x000003ffull
#define A6XX_CP_ROQ_RB_STATUS_RPTR__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_RB_STATUS_RPTR(uint32_t val)
{
	return ((val) << A6XX_CP_ROQ_RB_STATUS_RPTR__SHIFT) & A6XX_CP_ROQ_RB_STATUS_RPTR__MASK;
}
#define A6XX_CP_ROQ_RB_STATUS_WPTR__MASK			0x03ff0000ull
#define A6XX_CP_ROQ_RB_STATUS_WPTR__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_RB_STATUS_WPTR(uint32_t val)
{
	return ((val) << A6XX_CP_ROQ_RB_STATUS_WPTR__SHIFT) & A6XX_CP_ROQ_RB_STATUS_WPTR__MASK;
}


#define REG_A6XX_CP_ROQ_IB1_STATUS				__FD_DEPRECATED 0x0000093a
#define A6XX_CP_ROQ_IB1_STATUS_RPTR__MASK			0x000003ffull
#define A6XX_CP_ROQ_IB1_STATUS_RPTR__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_IB1_STATUS_RPTR(uint32_t val)
{
	return ((val) << A6XX_CP_ROQ_IB1_STATUS_RPTR__SHIFT) & A6XX_CP_ROQ_IB1_STATUS_RPTR__MASK;
}
#define A6XX_CP_ROQ_IB1_STATUS_WPTR__MASK			0x03ff0000ull
#define A6XX_CP_ROQ_IB1_STATUS_WPTR__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_IB1_STATUS_WPTR(uint32_t val)
{
	return ((val) << A6XX_CP_ROQ_IB1_STATUS_WPTR__SHIFT) & A6XX_CP_ROQ_IB1_STATUS_WPTR__MASK;
}


#define REG_A6XX_CP_ROQ_IB2_STATUS				__FD_DEPRECATED 0x0000093b
#define A6XX_CP_ROQ_IB2_STATUS_RPTR__MASK			0x000003ffull
#define A6XX_CP_ROQ_IB2_STATUS_RPTR__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_IB2_STATUS_RPTR(uint32_t val)
{
	return ((val) << A6XX_CP_ROQ_IB2_STATUS_RPTR__SHIFT) & A6XX_CP_ROQ_IB2_STATUS_RPTR__MASK;
}
#define A6XX_CP_ROQ_IB2_STATUS_WPTR__MASK			0x03ff0000ull
#define A6XX_CP_ROQ_IB2_STATUS_WPTR__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_IB2_STATUS_WPTR(uint32_t val)
{
	return ((val) << A6XX_CP_ROQ_IB2_STATUS_WPTR__SHIFT) & A6XX_CP_ROQ_IB2_STATUS_WPTR__MASK;
}


#define REG_A6XX_CP_ROQ_SDS_STATUS				__FD_DEPRECATED 0x0000093c
#define A6XX_CP_ROQ_SDS_STATUS_RPTR__MASK			0x000003ffull
#define A6XX_CP_ROQ_SDS_STATUS_RPTR__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_SDS_STATUS_RPTR(uint32_t val)
{
	return ((val) << A6XX_CP_ROQ_SDS_STATUS_RPTR__SHIFT) & A6XX_CP_ROQ_SDS_STATUS_RPTR__MASK;
}
#define A6XX_CP_ROQ_SDS_STATUS_WPTR__MASK			0x03ff0000ull
#define A6XX_CP_ROQ_SDS_STATUS_WPTR__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_SDS_STATUS_WPTR(uint32_t val)
{
	return ((val) << A6XX_CP_ROQ_SDS_STATUS_WPTR__SHIFT) & A6XX_CP_ROQ_SDS_STATUS_WPTR__MASK;
}


#define REG_A6XX_CP_ROQ_MRB_STATUS				__FD_DEPRECATED 0x0000093d
#define A6XX_CP_ROQ_MRB_STATUS_RPTR__MASK			0x000003ffull
#define A6XX_CP_ROQ_MRB_STATUS_RPTR__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_MRB_STATUS_RPTR(uint32_t val)
{
	return ((val) << A6XX_CP_ROQ_MRB_STATUS_RPTR__SHIFT) & A6XX_CP_ROQ_MRB_STATUS_RPTR__MASK;
}
#define A6XX_CP_ROQ_MRB_STATUS_WPTR__MASK			0x03ff0000ull
#define A6XX_CP_ROQ_MRB_STATUS_WPTR__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_MRB_STATUS_WPTR(uint32_t val)
{
	return ((val) << A6XX_CP_ROQ_MRB_STATUS_WPTR__SHIFT) & A6XX_CP_ROQ_MRB_STATUS_WPTR__MASK;
}


#define REG_A6XX_CP_ROQ_VSD_STATUS				__FD_DEPRECATED 0x0000093e
#define A6XX_CP_ROQ_VSD_STATUS_RPTR__MASK			0x000003ffull
#define A6XX_CP_ROQ_VSD_STATUS_RPTR__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_VSD_STATUS_RPTR(uint32_t val)
{
	return ((val) << A6XX_CP_ROQ_VSD_STATUS_RPTR__SHIFT) & A6XX_CP_ROQ_VSD_STATUS_RPTR__MASK;
}
#define A6XX_CP_ROQ_VSD_STATUS_WPTR__MASK			0x03ff0000ull
#define A6XX_CP_ROQ_VSD_STATUS_WPTR__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_VSD_STATUS_WPTR(uint32_t val)
{
	return ((val) << A6XX_CP_ROQ_VSD_STATUS_WPTR__SHIFT) & A6XX_CP_ROQ_VSD_STATUS_WPTR__MASK;
}


#define REG_A8XX_CP_ROQ_RB_STATUS				__FD_DEPRECATED 0x00000920
#define A8XX_CP_ROQ_RB_STATUS_RPTR__MASK			0x000003ffull
#define A8XX_CP_ROQ_RB_STATUS_RPTR__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_RB_STATUS_RPTR(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_RB_STATUS_RPTR__SHIFT) & A8XX_CP_ROQ_RB_STATUS_RPTR__MASK;
}
#define A8XX_CP_ROQ_RB_STATUS_WPTR__MASK			0x03ff0000ull
#define A8XX_CP_ROQ_RB_STATUS_WPTR__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_RB_STATUS_WPTR(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_RB_STATUS_WPTR__SHIFT) & A8XX_CP_ROQ_RB_STATUS_WPTR__MASK;
}


#define REG_A8XX_CP_ROQ_IB1_STATUS				__FD_DEPRECATED 0x00000921
#define A8XX_CP_ROQ_IB1_STATUS_RPTR__MASK			0x000003ffull
#define A8XX_CP_ROQ_IB1_STATUS_RPTR__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_IB1_STATUS_RPTR(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_IB1_STATUS_RPTR__SHIFT) & A8XX_CP_ROQ_IB1_STATUS_RPTR__MASK;
}
#define A8XX_CP_ROQ_IB1_STATUS_WPTR__MASK			0x03ff0000ull
#define A8XX_CP_ROQ_IB1_STATUS_WPTR__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_IB1_STATUS_WPTR(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_IB1_STATUS_WPTR__SHIFT) & A8XX_CP_ROQ_IB1_STATUS_WPTR__MASK;
}


#define REG_A8XX_CP_ROQ_IB2_STATUS				__FD_DEPRECATED 0x00000922
#define A8XX_CP_ROQ_IB2_STATUS_RPTR__MASK			0x000003ffull
#define A8XX_CP_ROQ_IB2_STATUS_RPTR__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_IB2_STATUS_RPTR(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_IB2_STATUS_RPTR__SHIFT) & A8XX_CP_ROQ_IB2_STATUS_RPTR__MASK;
}
#define A8XX_CP_ROQ_IB2_STATUS_WPTR__MASK			0x03ff0000ull
#define A8XX_CP_ROQ_IB2_STATUS_WPTR__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_IB2_STATUS_WPTR(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_IB2_STATUS_WPTR__SHIFT) & A8XX_CP_ROQ_IB2_STATUS_WPTR__MASK;
}


#define REG_A8XX_CP_ROQ_IB3_STATUS				__FD_DEPRECATED 0x00000923
#define A8XX_CP_ROQ_IB3_STATUS_RPTR__MASK			0x000003ffull
#define A8XX_CP_ROQ_IB3_STATUS_RPTR__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_IB3_STATUS_RPTR(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_IB3_STATUS_RPTR__SHIFT) & A8XX_CP_ROQ_IB3_STATUS_RPTR__MASK;
}
#define A8XX_CP_ROQ_IB3_STATUS_WPTR__MASK			0x03ff0000ull
#define A8XX_CP_ROQ_IB3_STATUS_WPTR__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_IB3_STATUS_WPTR(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_IB3_STATUS_WPTR__SHIFT) & A8XX_CP_ROQ_IB3_STATUS_WPTR__MASK;
}


#define REG_A8XX_CP_ROQ_SDS_STATUS				__FD_DEPRECATED 0x00000924
#define A8XX_CP_ROQ_SDS_STATUS_RPTR__MASK			0x000003ffull
#define A8XX_CP_ROQ_SDS_STATUS_RPTR__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_SDS_STATUS_RPTR(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_SDS_STATUS_RPTR__SHIFT) & A8XX_CP_ROQ_SDS_STATUS_RPTR__MASK;
}
#define A8XX_CP_ROQ_SDS_STATUS_WPTR__MASK			0x03ff0000ull
#define A8XX_CP_ROQ_SDS_STATUS_WPTR__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_SDS_STATUS_WPTR(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_SDS_STATUS_WPTR__SHIFT) & A8XX_CP_ROQ_SDS_STATUS_WPTR__MASK;
}


#define REG_A8XX_CP_ROQ_MRB_STATUS				__FD_DEPRECATED 0x00000925
#define A8XX_CP_ROQ_MRB_STATUS_RPTR__MASK			0x000003ffull
#define A8XX_CP_ROQ_MRB_STATUS_RPTR__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_MRB_STATUS_RPTR(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_MRB_STATUS_RPTR__SHIFT) & A8XX_CP_ROQ_MRB_STATUS_RPTR__MASK;
}
#define A8XX_CP_ROQ_MRB_STATUS_WPTR__MASK			0x03ff0000ull
#define A8XX_CP_ROQ_MRB_STATUS_WPTR__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_MRB_STATUS_WPTR(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_MRB_STATUS_WPTR__SHIFT) & A8XX_CP_ROQ_MRB_STATUS_WPTR__MASK;
}


#define REG_A8XX_CP_ROQ_VSD_STATUS				__FD_DEPRECATED 0x00000926
#define A8XX_CP_ROQ_VSD_STATUS_RPTR__MASK			0x000003ffull
#define A8XX_CP_ROQ_VSD_STATUS_RPTR__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_VSD_STATUS_RPTR(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_VSD_STATUS_RPTR__SHIFT) & A8XX_CP_ROQ_VSD_STATUS_RPTR__MASK;
}
#define A8XX_CP_ROQ_VSD_STATUS_WPTR__MASK			0x03ff0000ull
#define A8XX_CP_ROQ_VSD_STATUS_WPTR__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_VSD_STATUS_WPTR(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_VSD_STATUS_WPTR__SHIFT) & A8XX_CP_ROQ_VSD_STATUS_WPTR__MASK;
}


#define REG_A6XX_CP_IB1_INIT_SIZE				__FD_DEPRECATED 0x00000943


#define REG_A6XX_CP_IB2_INIT_SIZE				__FD_DEPRECATED 0x00000944


#define REG_A6XX_CP_SDS_INIT_SIZE				__FD_DEPRECATED 0x00000945


#define REG_A6XX_CP_MRB_INIT_SIZE				__FD_DEPRECATED 0x00000946


#define REG_A6XX_CP_VSD_INIT_SIZE				__FD_DEPRECATED 0x00000947


#define REG_A6XX_CP_ROQ_AVAIL_RB				__FD_DEPRECATED 0x00000948
#define A6XX_CP_ROQ_AVAIL_RB_REM__MASK				0xffff0000ull
#define A6XX_CP_ROQ_AVAIL_RB_REM__SHIFT				16
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_AVAIL_RB_REM(uint32_t val)
{
	return ((val) << A6XX_CP_ROQ_AVAIL_RB_REM__SHIFT) & A6XX_CP_ROQ_AVAIL_RB_REM__MASK;
}


#define REG_A6XX_CP_ROQ_AVAIL_IB1				__FD_DEPRECATED 0x00000949
#define A6XX_CP_ROQ_AVAIL_IB1_REM__MASK				0xffff0000ull
#define A6XX_CP_ROQ_AVAIL_IB1_REM__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_AVAIL_IB1_REM(uint32_t val)
{
	return ((val) << A6XX_CP_ROQ_AVAIL_IB1_REM__SHIFT) & A6XX_CP_ROQ_AVAIL_IB1_REM__MASK;
}


#define REG_A6XX_CP_ROQ_AVAIL_IB2				__FD_DEPRECATED 0x0000094a
#define A6XX_CP_ROQ_AVAIL_IB2_REM__MASK				0xffff0000ull
#define A6XX_CP_ROQ_AVAIL_IB2_REM__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_AVAIL_IB2_REM(uint32_t val)
{
	return ((val) << A6XX_CP_ROQ_AVAIL_IB2_REM__SHIFT) & A6XX_CP_ROQ_AVAIL_IB2_REM__MASK;
}


#define REG_A6XX_CP_ROQ_AVAIL_SDS				__FD_DEPRECATED 0x0000094b
#define A6XX_CP_ROQ_AVAIL_SDS_REM__MASK				0xffff0000ull
#define A6XX_CP_ROQ_AVAIL_SDS_REM__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_AVAIL_SDS_REM(uint32_t val)
{
	return ((val) << A6XX_CP_ROQ_AVAIL_SDS_REM__SHIFT) & A6XX_CP_ROQ_AVAIL_SDS_REM__MASK;
}


#define REG_A6XX_CP_ROQ_AVAIL_MRB				__FD_DEPRECATED 0x0000094c
#define A6XX_CP_ROQ_AVAIL_MRB_REM__MASK				0xffff0000ull
#define A6XX_CP_ROQ_AVAIL_MRB_REM__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_AVAIL_MRB_REM(uint32_t val)
{
	return ((val) << A6XX_CP_ROQ_AVAIL_MRB_REM__SHIFT) & A6XX_CP_ROQ_AVAIL_MRB_REM__MASK;
}


#define REG_A6XX_CP_ROQ_AVAIL_VSD				__FD_DEPRECATED 0x0000094d
#define A6XX_CP_ROQ_AVAIL_VSD_REM__MASK				0xffff0000ull
#define A6XX_CP_ROQ_AVAIL_VSD_REM__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_CP_ROQ_AVAIL_VSD_REM(uint32_t val)
{
	return ((val) << A6XX_CP_ROQ_AVAIL_VSD_REM__SHIFT) & A6XX_CP_ROQ_AVAIL_VSD_REM__MASK;
}


#define REG_A8XX_CP_ROQ_AVAIL_RB				__FD_DEPRECATED 0x00000918
#define A8XX_CP_ROQ_AVAIL_RB_REM__MASK				0xffff0000ull
#define A8XX_CP_ROQ_AVAIL_RB_REM__SHIFT				16
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_AVAIL_RB_REM(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_AVAIL_RB_REM__SHIFT) & A8XX_CP_ROQ_AVAIL_RB_REM__MASK;
}


#define REG_A8XX_CP_ROQ_AVAIL_IB1				__FD_DEPRECATED 0x00000919
#define A8XX_CP_ROQ_AVAIL_IB1_REM__MASK				0xffff0000ull
#define A8XX_CP_ROQ_AVAIL_IB1_REM__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_AVAIL_IB1_REM(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_AVAIL_IB1_REM__SHIFT) & A8XX_CP_ROQ_AVAIL_IB1_REM__MASK;
}


#define REG_A8XX_CP_ROQ_AVAIL_IB2				__FD_DEPRECATED 0x0000091a
#define A8XX_CP_ROQ_AVAIL_IB2_REM__MASK				0xffff0000ull
#define A8XX_CP_ROQ_AVAIL_IB2_REM__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_AVAIL_IB2_REM(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_AVAIL_IB2_REM__SHIFT) & A8XX_CP_ROQ_AVAIL_IB2_REM__MASK;
}


#define REG_A8XX_CP_ROQ_AVAIL_IB3				__FD_DEPRECATED 0x0000091b
#define A8XX_CP_ROQ_AVAIL_IB3_REM__MASK				0xffff0000ull
#define A8XX_CP_ROQ_AVAIL_IB3_REM__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_AVAIL_IB3_REM(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_AVAIL_IB3_REM__SHIFT) & A8XX_CP_ROQ_AVAIL_IB3_REM__MASK;
}


#define REG_A8XX_CP_ROQ_AVAIL_SDS				__FD_DEPRECATED 0x0000091c
#define A8XX_CP_ROQ_AVAIL_SDS_REM__MASK				0xffff0000ull
#define A8XX_CP_ROQ_AVAIL_SDS_REM__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_AVAIL_SDS_REM(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_AVAIL_SDS_REM__SHIFT) & A8XX_CP_ROQ_AVAIL_SDS_REM__MASK;
}


#define REG_A8XX_CP_ROQ_AVAIL_MRB				__FD_DEPRECATED 0x0000091d
#define A8XX_CP_ROQ_AVAIL_MRB_REM__MASK				0xffff0000ull
#define A8XX_CP_ROQ_AVAIL_MRB_REM__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_AVAIL_MRB_REM(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_AVAIL_MRB_REM__SHIFT) & A8XX_CP_ROQ_AVAIL_MRB_REM__MASK;
}


#define REG_A8XX_CP_ROQ_AVAIL_VSD				__FD_DEPRECATED 0x0000091e
#define A8XX_CP_ROQ_AVAIL_VSD_REM__MASK				0xffff0000ull
#define A8XX_CP_ROQ_AVAIL_VSD_REM__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_CP_ROQ_AVAIL_VSD_REM(uint32_t val)
{
	return ((val) << A8XX_CP_ROQ_AVAIL_VSD_REM__SHIFT) & A8XX_CP_ROQ_AVAIL_VSD_REM__MASK;
}


#define REG_A6XX_CP_ALWAYS_ON_COUNTER				__FD_DEPRECATED 0x00000980
static CONSTEXPR inline uint32_t A6XX_CP_ALWAYS_ON_COUNTER_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_CP_ALWAYS_ON_COUNTER_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_CP_ALWAYS_ON_CONTEXT				__FD_DEPRECATED 0x00000982
static CONSTEXPR inline uint32_t A6XX_CP_ALWAYS_ON_CONTEXT_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_CP_ALWAYS_ON_CONTEXT_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_CP_ALWAYS_ON_COUNTER				__FD_DEPRECATED 0x000008e7
static CONSTEXPR inline uint32_t A8XX_CP_ALWAYS_ON_COUNTER_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_CP_ALWAYS_ON_COUNTER_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_CP_ALWAYS_ON_CONTEXT				__FD_DEPRECATED 0x000008e9
static CONSTEXPR inline uint32_t A8XX_CP_ALWAYS_ON_CONTEXT_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_CP_ALWAYS_ON_CONTEXT_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_CP_AHB_CNTL					__FD_DEPRECATED 0x0000098d


#define REG_A8XX_CP_AHB_CNTL					__FD_DEPRECATED 0x00000838


#define REG_A6XX_CP_APERTURE_CNTL_HOST				__FD_DEPRECATED 0x00000a00


#define REG_A7XX_CP_APERTURE_CNTL_HOST				__FD_DEPRECATED 0x00000a00
#define A7XX_CP_APERTURE_CNTL_HOST_PIPE__MASK			0x00003000ull
#define A7XX_CP_APERTURE_CNTL_HOST_PIPE__SHIFT			12
static CONSTEXPR inline uint32_t A7XX_CP_APERTURE_CNTL_HOST_PIPE(enum adreno_pipe val)
{
	return ((val) << A7XX_CP_APERTURE_CNTL_HOST_PIPE__SHIFT) & A7XX_CP_APERTURE_CNTL_HOST_PIPE__MASK;
}
#define A7XX_CP_APERTURE_CNTL_HOST_CLUSTER__MASK		0x00000700ull
#define A7XX_CP_APERTURE_CNTL_HOST_CLUSTER__SHIFT		8
static CONSTEXPR inline uint32_t A7XX_CP_APERTURE_CNTL_HOST_CLUSTER(enum a7xx_cluster val)
{
	return ((val) << A7XX_CP_APERTURE_CNTL_HOST_CLUSTER__SHIFT) & A7XX_CP_APERTURE_CNTL_HOST_CLUSTER__MASK;
}
#define A7XX_CP_APERTURE_CNTL_HOST_CONTEXT__MASK		0x00000030ull
#define A7XX_CP_APERTURE_CNTL_HOST_CONTEXT__SHIFT		4
static CONSTEXPR inline uint32_t A7XX_CP_APERTURE_CNTL_HOST_CONTEXT(uint32_t val)
{
	return ((val) << A7XX_CP_APERTURE_CNTL_HOST_CONTEXT__SHIFT) & A7XX_CP_APERTURE_CNTL_HOST_CONTEXT__MASK;
}


#define REG_A6XX_CP_APERTURE_CNTL_SQE				__FD_DEPRECATED 0x00000a01


#define REG_A6XX_CP_APERTURE_CNTL_CD				__FD_DEPRECATED 0x00000a03


#define REG_A7XX_CP_APERTURE_CNTL_CD				__FD_DEPRECATED 0x00000a03
#define A7XX_CP_APERTURE_CNTL_CD_PIPE__MASK			0x00003000ull
#define A7XX_CP_APERTURE_CNTL_CD_PIPE__SHIFT			12
static CONSTEXPR inline uint32_t A7XX_CP_APERTURE_CNTL_CD_PIPE(enum adreno_pipe val)
{
	return ((val) << A7XX_CP_APERTURE_CNTL_CD_PIPE__SHIFT) & A7XX_CP_APERTURE_CNTL_CD_PIPE__MASK;
}
#define A7XX_CP_APERTURE_CNTL_CD_CLUSTER__MASK			0x00000700ull
#define A7XX_CP_APERTURE_CNTL_CD_CLUSTER__SHIFT			8
static CONSTEXPR inline uint32_t A7XX_CP_APERTURE_CNTL_CD_CLUSTER(enum a7xx_cluster val)
{
	return ((val) << A7XX_CP_APERTURE_CNTL_CD_CLUSTER__SHIFT) & A7XX_CP_APERTURE_CNTL_CD_CLUSTER__MASK;
}
#define A7XX_CP_APERTURE_CNTL_CD_CONTEXT__MASK			0x00000030ull
#define A7XX_CP_APERTURE_CNTL_CD_CONTEXT__SHIFT			4
static CONSTEXPR inline uint32_t A7XX_CP_APERTURE_CNTL_CD_CONTEXT(uint32_t val)
{
	return ((val) << A7XX_CP_APERTURE_CNTL_CD_CONTEXT__SHIFT) & A7XX_CP_APERTURE_CNTL_CD_CONTEXT__MASK;
}


#define REG_A7XX_CP_RESERVED_REG(i0)				(0x00000a9c + 0x1*i0 )



#define REG_A8XX_CP_RESERVED_REG(i0)				(0x00000958 + 0x1*i0 )



#define REG_A8XX_CP_APERTURE_CNTL_HOST				__FD_DEPRECATED 0x0000081c
#define A8XX_CP_APERTURE_CNTL_HOST_CONTEXTID3D__MASK		0x00000030ull
#define A8XX_CP_APERTURE_CNTL_HOST_CONTEXTID3D__SHIFT		4
static CONSTEXPR inline uint32_t A8XX_CP_APERTURE_CNTL_HOST_CONTEXTID3D(uint32_t val)
{
	return ((val) << A8XX_CP_APERTURE_CNTL_HOST_CONTEXTID3D__SHIFT) & A8XX_CP_APERTURE_CNTL_HOST_CONTEXTID3D__MASK;
}
#define A8XX_CP_APERTURE_CNTL_HOST_CLUSTERID__MASK		0x00000f00ull
#define A8XX_CP_APERTURE_CNTL_HOST_CLUSTERID__SHIFT		8
static CONSTEXPR inline uint32_t A8XX_CP_APERTURE_CNTL_HOST_CLUSTERID(uint32_t val)
{
	return ((val) << A8XX_CP_APERTURE_CNTL_HOST_CLUSTERID__SHIFT) & A8XX_CP_APERTURE_CNTL_HOST_CLUSTERID__MASK;
}
#define A8XX_CP_APERTURE_CNTL_HOST_PIPEID__MASK			0x0000f000ull
#define A8XX_CP_APERTURE_CNTL_HOST_PIPEID__SHIFT		12
static CONSTEXPR inline uint32_t A8XX_CP_APERTURE_CNTL_HOST_PIPEID(uint32_t val)
{
	return ((val) << A8XX_CP_APERTURE_CNTL_HOST_PIPEID__SHIFT) & A8XX_CP_APERTURE_CNTL_HOST_PIPEID__MASK;
}
#define A8XX_CP_APERTURE_CNTL_HOST_SLICEID__MASK		0x00070000ull
#define A8XX_CP_APERTURE_CNTL_HOST_SLICEID__SHIFT		16
static CONSTEXPR inline uint32_t A8XX_CP_APERTURE_CNTL_HOST_SLICEID(uint32_t val)
{
	return ((val) << A8XX_CP_APERTURE_CNTL_HOST_SLICEID__SHIFT) & A8XX_CP_APERTURE_CNTL_HOST_SLICEID__MASK;
}
#define A8XX_CP_APERTURE_CNTL_HOST_USESLICEID			0x00800000


#define REG_A8XX_CP_APERTURE_CNTL_GMU				__FD_DEPRECATED 0x0000081d
#define A8XX_CP_APERTURE_CNTL_GMU_CONTEXTID3D__MASK		0x00000030ull
#define A8XX_CP_APERTURE_CNTL_GMU_CONTEXTID3D__SHIFT		4
static CONSTEXPR inline uint32_t A8XX_CP_APERTURE_CNTL_GMU_CONTEXTID3D(uint32_t val)
{
	return ((val) << A8XX_CP_APERTURE_CNTL_GMU_CONTEXTID3D__SHIFT) & A8XX_CP_APERTURE_CNTL_GMU_CONTEXTID3D__MASK;
}
#define A8XX_CP_APERTURE_CNTL_GMU_CLUSTERID__MASK		0x00000f00ull
#define A8XX_CP_APERTURE_CNTL_GMU_CLUSTERID__SHIFT		8
static CONSTEXPR inline uint32_t A8XX_CP_APERTURE_CNTL_GMU_CLUSTERID(uint32_t val)
{
	return ((val) << A8XX_CP_APERTURE_CNTL_GMU_CLUSTERID__SHIFT) & A8XX_CP_APERTURE_CNTL_GMU_CLUSTERID__MASK;
}
#define A8XX_CP_APERTURE_CNTL_GMU_PIPEID__MASK			0x0000f000ull
#define A8XX_CP_APERTURE_CNTL_GMU_PIPEID__SHIFT			12
static CONSTEXPR inline uint32_t A8XX_CP_APERTURE_CNTL_GMU_PIPEID(uint32_t val)
{
	return ((val) << A8XX_CP_APERTURE_CNTL_GMU_PIPEID__SHIFT) & A8XX_CP_APERTURE_CNTL_GMU_PIPEID__MASK;
}
#define A8XX_CP_APERTURE_CNTL_GMU_SLICEID__MASK			0x00070000ull
#define A8XX_CP_APERTURE_CNTL_GMU_SLICEID__SHIFT		16
static CONSTEXPR inline uint32_t A8XX_CP_APERTURE_CNTL_GMU_SLICEID(uint32_t val)
{
	return ((val) << A8XX_CP_APERTURE_CNTL_GMU_SLICEID__SHIFT) & A8XX_CP_APERTURE_CNTL_GMU_SLICEID__MASK;
}
#define A8XX_CP_APERTURE_CNTL_GMU_USESLICEID			0x00800000


#define REG_A8XX_CP_APERTURE_CNTL_CD				__FD_DEPRECATED 0x0000081e
#define A8XX_CP_APERTURE_CNTL_CD_CONTEXTID3D__MASK		0x00000030ull
#define A8XX_CP_APERTURE_CNTL_CD_CONTEXTID3D__SHIFT		4
static CONSTEXPR inline uint32_t A8XX_CP_APERTURE_CNTL_CD_CONTEXTID3D(uint32_t val)
{
	return ((val) << A8XX_CP_APERTURE_CNTL_CD_CONTEXTID3D__SHIFT) & A8XX_CP_APERTURE_CNTL_CD_CONTEXTID3D__MASK;
}
#define A8XX_CP_APERTURE_CNTL_CD_CLUSTERID__MASK		0x00000f00ull
#define A8XX_CP_APERTURE_CNTL_CD_CLUSTERID__SHIFT		8
static CONSTEXPR inline uint32_t A8XX_CP_APERTURE_CNTL_CD_CLUSTERID(uint32_t val)
{
	return ((val) << A8XX_CP_APERTURE_CNTL_CD_CLUSTERID__SHIFT) & A8XX_CP_APERTURE_CNTL_CD_CLUSTERID__MASK;
}
#define A8XX_CP_APERTURE_CNTL_CD_PIPEID__MASK			0x0000f000ull
#define A8XX_CP_APERTURE_CNTL_CD_PIPEID__SHIFT			12
static CONSTEXPR inline uint32_t A8XX_CP_APERTURE_CNTL_CD_PIPEID(uint32_t val)
{
	return ((val) << A8XX_CP_APERTURE_CNTL_CD_PIPEID__SHIFT) & A8XX_CP_APERTURE_CNTL_CD_PIPEID__MASK;
}
#define A8XX_CP_APERTURE_CNTL_CD_SLICEID__MASK			0x00070000ull
#define A8XX_CP_APERTURE_CNTL_CD_SLICEID__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_CP_APERTURE_CNTL_CD_SLICEID(uint32_t val)
{
	return ((val) << A8XX_CP_APERTURE_CNTL_CD_SLICEID__SHIFT) & A8XX_CP_APERTURE_CNTL_CD_SLICEID__MASK;
}
#define A8XX_CP_APERTURE_CNTL_CD_USESLICEID			0x00800000


#define REG_A7XX_CP_BV_PROTECT_STATUS				__FD_DEPRECATED 0x00000a61


#define REG_A7XX_CP_BV_HW_FAULT					__FD_DEPRECATED 0x00000a64


#define REG_A7XX_CP_BV_RB_RPTR					__FD_DEPRECATED 0x00000a66


#define REG_A7XX_CP_BV_IB1_BASE					__FD_DEPRECATED 0x00000a6d
static CONSTEXPR inline uint32_t A7XX_CP_BV_IB1_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_CP_BV_IB1_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A7XX_CP_BV_IB1_REM_SIZE				__FD_DEPRECATED 0x00000a70


#define REG_A7XX_CP_BV_IB2_BASE					__FD_DEPRECATED 0x00000a71
static CONSTEXPR inline uint32_t A7XX_CP_BV_IB2_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_CP_BV_IB2_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A7XX_CP_BV_IB2_REM_SIZE				__FD_DEPRECATED 0x00000a74


#define REG_A7XX_CP_BV_DRAW_STATE_ADDR				__FD_DEPRECATED 0x00000a81


#define REG_A7XX_CP_BV_DRAW_STATE_DATA				__FD_DEPRECATED 0x00000a82


#define REG_A7XX_CP_BV_ROQ_DBG_ADDR				__FD_DEPRECATED 0x00000a83


#define REG_A7XX_CP_BV_ROQ_DBG_DATA				__FD_DEPRECATED 0x00000a84


#define REG_A7XX_CP_BV_SQE_UCODE_DBG_ADDR			__FD_DEPRECATED 0x00000a85


#define REG_A7XX_CP_BV_SQE_UCODE_DBG_DATA			__FD_DEPRECATED 0x00000a86


#define REG_A7XX_CP_BV_SQE_STAT_ADDR				__FD_DEPRECATED 0x00000a87


#define REG_A7XX_CP_BV_SQE_STAT_DATA				__FD_DEPRECATED 0x00000a88


#define REG_A7XX_CP_BV_ROQ_AVAIL_RB				__FD_DEPRECATED 0x00000a8f
#define A7XX_CP_BV_ROQ_AVAIL_RB_REM__MASK			0xffff0000ull
#define A7XX_CP_BV_ROQ_AVAIL_RB_REM__SHIFT			16
static CONSTEXPR inline uint32_t A7XX_CP_BV_ROQ_AVAIL_RB_REM(uint32_t val)
{
	return ((val) << A7XX_CP_BV_ROQ_AVAIL_RB_REM__SHIFT) & A7XX_CP_BV_ROQ_AVAIL_RB_REM__MASK;
}


#define REG_A7XX_CP_BV_ROQ_AVAIL_IB1				__FD_DEPRECATED 0x00000a90
#define A7XX_CP_BV_ROQ_AVAIL_IB1_REM__MASK			0xffff0000ull
#define A7XX_CP_BV_ROQ_AVAIL_IB1_REM__SHIFT			16
static CONSTEXPR inline uint32_t A7XX_CP_BV_ROQ_AVAIL_IB1_REM(uint32_t val)
{
	return ((val) << A7XX_CP_BV_ROQ_AVAIL_IB1_REM__SHIFT) & A7XX_CP_BV_ROQ_AVAIL_IB1_REM__MASK;
}


#define REG_A7XX_CP_BV_ROQ_AVAIL_IB2				__FD_DEPRECATED 0x00000a91
#define A7XX_CP_BV_ROQ_AVAIL_IB2_REM__MASK			0xffff0000ull
#define A7XX_CP_BV_ROQ_AVAIL_IB2_REM__SHIFT			16
static CONSTEXPR inline uint32_t A7XX_CP_BV_ROQ_AVAIL_IB2_REM(uint32_t val)
{
	return ((val) << A7XX_CP_BV_ROQ_AVAIL_IB2_REM__SHIFT) & A7XX_CP_BV_ROQ_AVAIL_IB2_REM__MASK;
}


#define REG_A7XX_CP_BV_MEM_POOL_DBG_ADDR			__FD_DEPRECATED 0x00000a96


#define REG_A7XX_CP_BV_MEM_POOL_DBG_DATA			__FD_DEPRECATED 0x00000a97


#define REG_A7XX_CP_BV_RB_RPTR_ADDR				__FD_DEPRECATED 0x00000a98
static CONSTEXPR inline uint32_t A7XX_CP_BV_RB_RPTR_ADDR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_CP_BV_RB_RPTR_ADDR_HI(uint32_t val)
{
	return val;
}


#define REG_A7XX_CP_RESOURCE_TABLE_DBG_ADDR			__FD_DEPRECATED 0x00000a9a


#define REG_A7XX_CP_RESOURCE_TABLE_DBG_DATA			__FD_DEPRECATED 0x00000a9b


#define REG_A7XX_CP_BV_APRIV_CNTL				__FD_DEPRECATED 0x00000ad0


#define REG_A7XX_CP_BV_CHICKEN_DBG				__FD_DEPRECATED 0x00000ada


#define REG_A7XX_CP_LPAC_DRAW_STATE_ADDR			__FD_DEPRECATED 0x00000b0a


#define REG_A7XX_CP_LPAC_DRAW_STATE_DATA			__FD_DEPRECATED 0x00000b0b


#define REG_A7XX_CP_LPAC_ROQ_DBG_ADDR				__FD_DEPRECATED 0x00000b0c


#define REG_A7XX_CP_SQE_AC_UCODE_DBG_ADDR			__FD_DEPRECATED 0x00000b27


#define REG_A7XX_CP_SQE_AC_UCODE_DBG_DATA			__FD_DEPRECATED 0x00000b28


#define REG_A7XX_CP_SQE_AC_STAT_ADDR				__FD_DEPRECATED 0x00000b29


#define REG_A7XX_CP_SQE_AC_STAT_DATA				__FD_DEPRECATED 0x00000b2a


#define REG_A7XX_CP_LPAC_APRIV_CNTL				__FD_DEPRECATED 0x00000b31


#define REG_A7XX_CP_LPAC_PROG_FIFO_SIZE				__FD_DEPRECATED 0x00000b34


#define REG_A7XX_CP_LPAC_ROQ_DBG_DATA				__FD_DEPRECATED 0x00000b35


#define REG_A7XX_CP_LPAC_FIFO_DBG_DATA				__FD_DEPRECATED 0x00000b36


#define REG_A7XX_CP_LPAC_FIFO_DBG_ADDR				__FD_DEPRECATED 0x00000b40


#define REG_A6XX_CP_LPAC_SQE_CNTL				__FD_DEPRECATED 0x00000b81


#define REG_A6XX_CP_LPAC_SQE_INSTR_BASE				__FD_DEPRECATED 0x00000b82
static CONSTEXPR inline uint32_t A6XX_CP_LPAC_SQE_INSTR_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_CP_LPAC_SQE_INSTR_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A7XX_CP_AQE_INSTR_BASE_0				__FD_DEPRECATED 0x00000b70
static CONSTEXPR inline uint32_t A7XX_CP_AQE_INSTR_BASE_0_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_CP_AQE_INSTR_BASE_0_HI(uint32_t val)
{
	return val;
}


#define REG_A7XX_CP_AQE_INSTR_BASE_1				__FD_DEPRECATED 0x00000b72
static CONSTEXPR inline uint32_t A7XX_CP_AQE_INSTR_BASE_1_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_CP_AQE_INSTR_BASE_1_HI(uint32_t val)
{
	return val;
}


#define REG_A7XX_CP_AQE_APRIV_CNTL				__FD_DEPRECATED 0x00000b78


#define REG_A7XX_CP_AQE_ROQ_DBG_ADDR_0				__FD_DEPRECATED 0x00000ba8


#define REG_A7XX_CP_AQE_ROQ_DBG_ADDR_1				__FD_DEPRECATED 0x00000ba9


#define REG_A7XX_CP_AQE_ROQ_DBG_DATA_0				__FD_DEPRECATED 0x00000bac


#define REG_A7XX_CP_AQE_ROQ_DBG_DATA_1				__FD_DEPRECATED 0x00000bad


#define REG_A7XX_CP_AQE_UCODE_DBG_ADDR_0			__FD_DEPRECATED 0x00000bb0


#define REG_A7XX_CP_AQE_UCODE_DBG_ADDR_1			__FD_DEPRECATED 0x00000bb1


#define REG_A7XX_CP_AQE_UCODE_DBG_DATA_0			__FD_DEPRECATED 0x00000bb4


#define REG_A7XX_CP_AQE_UCODE_DBG_DATA_1			__FD_DEPRECATED 0x00000bb5


#define REG_A7XX_CP_AQE_STAT_ADDR_0				__FD_DEPRECATED 0x00000bb8


#define REG_A7XX_CP_AQE_STAT_ADDR_1				__FD_DEPRECATED 0x00000bb9


#define REG_A7XX_CP_AQE_STAT_DATA_0				__FD_DEPRECATED 0x00000bbc


#define REG_A7XX_CP_AQE_STAT_DATA_1				__FD_DEPRECATED 0x00000bbd


#define REG_A6XX_VSC_ADDR_MODE_CNTL				__FD_DEPRECATED 0x00000c01


#define REG_A6XX_RBBM_GPR0_CNTL					__FD_DEPRECATED 0x00000018


#define REG_A6XX_RBBM_INT_0_STATUS				__FD_DEPRECATED 0x00000201

#define REG_A8XX_RBBM_INT_0_STATUS				__FD_DEPRECATED 0x0000006a

#define REG_A6XX_RBBM_STATUS					__FD_DEPRECATED 0x00000210
#define A6XX_RBBM_STATUS_GPU_BUSY_IGN_AHB			0x00800000
#define A6XX_RBBM_STATUS_GPU_BUSY_IGN_AHB_CP			0x00400000
#define A6XX_RBBM_STATUS_HLSQ_BUSY				0x00200000
#define A6XX_RBBM_STATUS_VSC_BUSY				0x00100000
#define A6XX_RBBM_STATUS_TPL1_BUSY				0x00080000
#define A6XX_RBBM_STATUS_SP_BUSY				0x00040000
#define A6XX_RBBM_STATUS_UCHE_BUSY				0x00020000
#define A6XX_RBBM_STATUS_VPC_BUSY				0x00010000
#define A6XX_RBBM_STATUS_VFD_BUSY				0x00008000
#define A6XX_RBBM_STATUS_TESS_BUSY				0x00004000
#define A6XX_RBBM_STATUS_PC_VSD_BUSY				0x00002000
#define A6XX_RBBM_STATUS_PC_DCALL_BUSY				0x00001000
#define A6XX_RBBM_STATUS_COM_DCOM_BUSY				0x00000800
#define A6XX_RBBM_STATUS_LRZ_BUSY				0x00000400
#define A6XX_RBBM_STATUS_A2D_BUSY				0x00000200
#define A6XX_RBBM_STATUS_CCU_BUSY				0x00000100
#define A6XX_RBBM_STATUS_RB_BUSY				0x00000080
#define A6XX_RBBM_STATUS_RAS_BUSY				0x00000040
#define A6XX_RBBM_STATUS_TSE_BUSY				0x00000020
#define A6XX_RBBM_STATUS_VBIF_BUSY				0x00000010
#define A6XX_RBBM_STATUS_GFX_DBGC_BUSY				0x00000008
#define A6XX_RBBM_STATUS_CP_BUSY				0x00000004
#define A6XX_RBBM_STATUS_CP_AHB_BUSY_CP_MASTER			0x00000002
#define A6XX_RBBM_STATUS_CP_AHB_BUSY_CX_MASTER			0x00000001


#define REG_A6XX_RBBM_STATUS1					__FD_DEPRECATED 0x00000211


#define REG_A6XX_RBBM_STATUS2					__FD_DEPRECATED 0x00000212


#define REG_A6XX_RBBM_STATUS3					__FD_DEPRECATED 0x00000213
#define A6XX_RBBM_STATUS3_SMMU_STALLED_ON_FAULT			0x01000000


#define REG_A8XX_RBBM_STATUS					__FD_DEPRECATED 0x00000012
#define A8XX_RBBM_STATUS_GPU_BUSY_IGN_AHB			0x00800000
#define A8XX_RBBM_STATUS_GPU_BUSY_IGN_AHB_CP			0x00400000
#define A8XX_RBBM_STATUS_SLICE_BUSY_IGN_CP			0x00200000
#define A8XX_RBBM_STATUS_CP_SLICE_BUSY				0x00100000
#define A8XX_RBBM_STATUS_UNSLICE_BUSY_IGN_AHB			0x00080000
#define A8XX_RBBM_STATUS_UNSLICE_BUSY_IGN_AHB_CP		0x00040000
#define A8XX_RBBM_STATUS_CP_SLICE_RL_BUSY			0x00020000
#define A8XX_RBBM_STATUS_UNSLICE_TOP_BUSY			0x00004000
#define A8XX_RBBM_STATUS_UFC_BUSY				0x00002000
#define A8XX_RBBM_STATUS_HLSQ_BUSY				0x00001000
#define A8XX_RBBM_STATUS_VSC_BUSY				0x00000800
#define A8XX_RBBM_STATUS_UCHE_BUSY				0x00000400
#define A8XX_RBBM_STATUS_VPC_BUSY				0x00000200
#define A8XX_RBBM_STATUS_PC_BUSY				0x00000100
#define A8XX_RBBM_STATUS_CMP_BUSY				0x00000080
#define A8XX_RBBM_STATUS_DCMP_BUSY				0x00000040
#define A8XX_RBBM_STATUS_VBIF_GX_BUSY				0x00000020
#define A8XX_RBBM_STATUS_DBGC_PERF_BUSY				0x00000010
#define A8XX_RBBM_STATUS_GFX_DBGC_BUSY				0x00000008
#define A8XX_RBBM_STATUS_CP_BUSY				0x00000004
#define A8XX_RBBM_STATUS_CP_AHB_BUSY_CP_MASTER			0x00000002
#define A8XX_RBBM_STATUS_CP_AHB_BUSY_CX_MASTER			0x00000001


#define REG_A8XX_RBBM_STATUS1					__FD_DEPRECATED 0x00000013


#define REG_A8XX_RBBM_GFX_STATUS				__FD_DEPRECATED 0x00000015


#define REG_A8XX_RBBM_GFX_STATUS1				__FD_DEPRECATED 0x00000016


#define REG_A8XX_RBBM_LPAC_STATUS				__FD_DEPRECATED 0x00000018


#define REG_A8XX_RBBM_GFX_BR_STATUS				__FD_DEPRECATED 0x0000001a


#define REG_A8XX_RBBM_GFX_BV_STATUS				__FD_DEPRECATED 0x0000001c


#define REG_A8XX_RBBM_MISC_STATUS				__FD_DEPRECATED 0x0000001e
#define A8XX_RBBM_MISC_STATUS_SMMU_STALLED_ON_FAULT		0x00000001


#define REG_A6XX_RBBM_VBIF_GX_RESET_STATUS			__FD_DEPRECATED 0x00000215


#define REG_A7XX_RBBM_CLOCK_MODE_CP				__FD_DEPRECATED 0x00000260


#define REG_A7XX_RBBM_CLOCK_MODE_BV_LRZ				__FD_DEPRECATED 0x00000284


#define REG_A7XX_RBBM_CLOCK_MODE_BV_GRAS			__FD_DEPRECATED 0x00000285


#define REG_A7XX_RBBM_CLOCK_MODE2_GRAS				__FD_DEPRECATED 0x00000286


#define REG_A7XX_RBBM_CLOCK_MODE_BV_VFD				__FD_DEPRECATED 0x00000287


#define REG_A7XX_RBBM_CLOCK_MODE_BV_GPC				__FD_DEPRECATED 0x00000288


#define REG_A7XX_RBBM_SW_FUSE_INT_STATUS			__FD_DEPRECATED 0x000002c0


#define REG_A7XX_RBBM_SW_FUSE_INT_MASK				__FD_DEPRECATED 0x000002c1


#define REG_A8XX_RBBM_SW_FUSE_INT_STATUS			__FD_DEPRECATED 0x00000071


#define REG_A8XX_RBBM_SW_FUSE_INT_MASK				__FD_DEPRECATED 0x00000072


#define REG_A6XX_RBBM_PERFCTR_CP(i0)				(0x00000400 + 0x2*i0 )



#define REG_A6XX_RBBM_PERFCTR_RBBM(i0)				(0x0000041c + 0x2*i0 )



#define REG_A6XX_RBBM_PERFCTR_PC(i0)				(0x00000424 + 0x2*i0 )



#define REG_A6XX_RBBM_PERFCTR_VFD(i0)				(0x00000434 + 0x2*i0 )



#define REG_A6XX_RBBM_PERFCTR_HLSQ(i0)				(0x00000444 + 0x2*i0 )



#define REG_A6XX_RBBM_PERFCTR_VPC(i0)				(0x00000450 + 0x2*i0 )



#define REG_A6XX_RBBM_PERFCTR_CCU(i0)				(0x0000045c + 0x2*i0 )



#define REG_A6XX_RBBM_PERFCTR_TSE(i0)				(0x00000466 + 0x2*i0 )



#define REG_A6XX_RBBM_PERFCTR_RAS(i0)				(0x0000046e + 0x2*i0 )



#define REG_A6XX_RBBM_PERFCTR_UCHE(i0)				(0x00000476 + 0x2*i0 )



#define REG_A6XX_RBBM_PERFCTR_TP(i0)				(0x0000048e + 0x2*i0 )



#define REG_A6XX_RBBM_PERFCTR_SP(i0)				(0x000004a6 + 0x2*i0 )



#define REG_A6XX_RBBM_PERFCTR_RB(i0)				(0x000004d6 + 0x2*i0 )



#define REG_A6XX_RBBM_PERFCTR_VSC(i0)				(0x000004e6 + 0x2*i0 )



#define REG_A6XX_RBBM_PERFCTR_LRZ(i0)				(0x000004ea + 0x2*i0 )



#define REG_A6XX_RBBM_PERFCTR_CMP(i0)				(0x000004f2 + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_CP(i0)				(0x00000300 + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_RBBM(i0)				(0x0000031c + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_PC(i0)				(0x00000324 + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_VFD(i0)				(0x00000334 + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_HLSQ(i0)				(0x00000344 + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_VPC(i0)				(0x00000350 + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_CCU(i0)				(0x0000035c + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_TSE(i0)				(0x00000366 + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_RAS(i0)				(0x0000036e + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_UCHE(i0)				(0x00000376 + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_TP(i0)				(0x0000038e + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_SP(i0)				(0x000003a6 + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_RB(i0)				(0x000003d6 + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_VSC(i0)				(0x000003e6 + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_LRZ(i0)				(0x000003ea + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_CMP(i0)				(0x000003f2 + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_UFC(i0)				(0x000003fa + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR2_HLSQ(i0)				(0x00000410 + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR2_CP(i0)				(0x0000041c + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR2_SP(i0)				(0x0000042a + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR2_TP(i0)				(0x00000442 + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR2_UFC(i0)				(0x0000044e + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_BV_PC(i0)				(0x00000460 + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_BV_VFD(i0)			(0x00000470 + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_BV_VPC(i0)			(0x00000480 + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_BV_TSE(i0)			(0x0000048c + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_BV_RAS(i0)			(0x00000494 + 0x2*i0 )



#define REG_A7XX_RBBM_PERFCTR_BV_LRZ(i0)			(0x0000049c + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_CP(i0)				(0x000001b0 + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_RBBM(i0)				(0x000001cc + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_PC(i0)				(0x000001d4 + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_VFD(i0)				(0x000001e4 + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_HLSQ(i0)				(0x000001f4 + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_VPC(i0)				(0x00000200 + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_CCU(i0)				(0x0000020c + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_TSE(i0)				(0x00000216 + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_RAS(i0)				(0x0000021e + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_UCHE(i0)				(0x00000226 + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_TP(i0)				(0x00000256 + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_SP(i0)				(0x0000026e + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_RB(i0)				(0x0000029e + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_VSC(i0)				(0x000002ae + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_LRZ(i0)				(0x000002b2 + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_CMP(i0)				(0x000002ba + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_UFC(i0)				(0x000002c2 + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR2_HLSQ(i0)				(0x000002e2 + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR2_CP(i0)				(0x000002ee + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR2_SP(i0)				(0x000002fc + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR2_TP(i0)				(0x00000314 + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR2_UFC(i0)				(0x00000324 + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_BV_PC(i0)				(0x00000328 + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_BV_VFD(i0)			(0x00000338 + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_BV_VPC(i0)			(0x00000348 + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_BV_TSE(i0)			(0x00000354 + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_BV_RAS(i0)			(0x0000035c + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_BV_LRZ(i0)			(0x00000364 + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_BV_CCU(i0)			(0x0000036c + 0x2*i0 )



#define REG_A8XX_RBBM_PERFCTR_BV_RB(i0)				(0x00000372 + 0x2*i0 )



#define REG_A6XX_RBBM_PERFCTR_CNTL				__FD_DEPRECATED 0x00000500


#define REG_A8XX_RBBM_PERFCTR_CNTL				__FD_DEPRECATED 0x00000460


#define REG_A6XX_RBBM_PERFCTR_LOAD_CMD0				__FD_DEPRECATED 0x00000501


#define REG_A6XX_RBBM_PERFCTR_LOAD_CMD1				__FD_DEPRECATED 0x00000502


#define REG_A6XX_RBBM_PERFCTR_LOAD_CMD2				__FD_DEPRECATED 0x00000503


#define REG_A6XX_RBBM_PERFCTR_LOAD_CMD3				__FD_DEPRECATED 0x00000504


#define REG_A6XX_RBBM_PERFCTR_LOAD_VALUE			__FD_DEPRECATED 0x00000505
static CONSTEXPR inline uint32_t A6XX_RBBM_PERFCTR_LOAD_VALUE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RBBM_PERFCTR_LOAD_VALUE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RBBM_PERFCTR_RBBM_SEL(i0)			(0x00000507 + 0x1*i0 )



#define REG_A8XX_RBBM_PERFCTR_RBBM_SEL(i0)			(0x00000441 + 0x1*i0 )



#define REG_A6XX_RBBM_PERFCTR_GPU_BUSY_MASKED			__FD_DEPRECATED 0x0000050b


#define REG_A8XX_RBBM_PERFCTR_GPU_BUSY_MASKED			__FD_DEPRECATED 0x0000019e


#define REG_A6XX_RBBM_PERFCTR_SRAM_INIT_CMD			__FD_DEPRECATED 0x0000050e


#define REG_A8XX_RBBM_PERFCTR_SRAM_INIT_CMD			__FD_DEPRECATED 0x00000449


#define REG_A6XX_RBBM_PERFCTR_SRAM_INIT_STATUS			__FD_DEPRECATED 0x0000050f


#define REG_A8XX_RBBM_PERFCTR_SRAM_INIT_STATUS			__FD_DEPRECATED 0x0000019f


#define REG_A8XX_RBBM_PERFCTR_FLUSH_HOST_STATUS			__FD_DEPRECATED 0x000001a1


#define REG_A8XX_RBBM_PERFCTR_FLUSH_HOST_CMD			__FD_DEPRECATED 0x0000044c


#define REG_A6XX_RBBM_ISDB_CNT					__FD_DEPRECATED 0x00000533


#define REG_A8XX_RBBM_ISDB_CNT					__FD_DEPRECATED 0x0000002d


#define REG_A6XX_RBBM_NC_MODE_CNTL				__FD_DEPRECATED 0x00000534


#define REG_A8XX_RBBM_NC_MODE_CNTL				__FD_DEPRECATED 0x00000440


#define REG_A7XX_RBBM_SNAPSHOT_STATUS				__FD_DEPRECATED 0x00000535


#define REG_A8XX_RBBM_SNAPSHOT_STATUS				__FD_DEPRECATED 0x0000002e


#define REG_A8XX_RBBM_SLICE_PERFCTR_CNTL			__FD_DEPRECATED 0x00000500


#define REG_A8XX_RBBM_SLICE_INTERFACE_HANG_INT_CNTL		__FD_DEPRECATED 0x0000058f


#define REG_A8XX_RBBM_SLICE_PERFCTR_RBBM_SEL(i0)		(0x000005e0 + 0x1*i0 )



#define REG_A8XX_RBBM_SLICE_PERFCTR_SRAM_INIT_CMD		__FD_DEPRECATED 0x000005e8


#define REG_A8XX_RBBM_SLICE_PERFCTR_FLUSH_HOST_CMD		__FD_DEPRECATED 0x000005eb


#define REG_A8XX_RBBM_SLICE_NC_MODE_CNTL			__FD_DEPRECATED 0x000005ec


#define REG_A6XX_RBBM_PIPESTAT_IAVERTICES			__FD_DEPRECATED 0x00000540
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_IAVERTICES_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_IAVERTICES_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RBBM_PIPESTAT_IAPRIMITIVES			__FD_DEPRECATED 0x00000542
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_IAPRIMITIVES_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_IAPRIMITIVES_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RBBM_PIPESTAT_VSINVOCATIONS			__FD_DEPRECATED 0x00000544
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_VSINVOCATIONS_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_VSINVOCATIONS_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RBBM_PIPESTAT_HSINVOCATIONS			__FD_DEPRECATED 0x00000546
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_HSINVOCATIONS_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_HSINVOCATIONS_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RBBM_PIPESTAT_DSINVOCATIONS			__FD_DEPRECATED 0x00000548
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_DSINVOCATIONS_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_DSINVOCATIONS_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RBBM_PIPESTAT_GSINVOCATIONS			__FD_DEPRECATED 0x0000054a
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_GSINVOCATIONS_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_GSINVOCATIONS_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RBBM_PIPESTAT_GSPRIMITIVES			__FD_DEPRECATED 0x0000054c
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_GSPRIMITIVES_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_GSPRIMITIVES_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RBBM_PIPESTAT_CINVOCATIONS			__FD_DEPRECATED 0x0000054e
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_CINVOCATIONS_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_CINVOCATIONS_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RBBM_PIPESTAT_CPRIMITIVES			__FD_DEPRECATED 0x00000550
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_CPRIMITIVES_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_CPRIMITIVES_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RBBM_PIPESTAT_PSINVOCATIONS			__FD_DEPRECATED 0x00000552
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_PSINVOCATIONS_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_PSINVOCATIONS_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RBBM_PIPESTAT_CSINVOCATIONS			__FD_DEPRECATED 0x00000554
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_CSINVOCATIONS_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RBBM_PIPESTAT_CSINVOCATIONS_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_RBBM_PIPESTAT_IAVERTICES			__FD_DEPRECATED 0x00000380
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_IAVERTICES_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_IAVERTICES_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_RBBM_PIPESTAT_IAPRIMITIVES			__FD_DEPRECATED 0x00000382
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_IAPRIMITIVES_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_IAPRIMITIVES_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_RBBM_PIPESTAT_VSINVOCATIONS			__FD_DEPRECATED 0x00000384
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_VSINVOCATIONS_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_VSINVOCATIONS_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_RBBM_PIPESTAT_GSINVOCATIONS			__FD_DEPRECATED 0x00000386
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_GSINVOCATIONS_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_GSINVOCATIONS_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_RBBM_PIPESTAT_GSPRIMITIVES			__FD_DEPRECATED 0x00000388
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_GSPRIMITIVES_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_GSPRIMITIVES_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_RBBM_PIPESTAT_CINVOCATIONS			__FD_DEPRECATED 0x0000038a
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_CINVOCATIONS_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_CINVOCATIONS_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_RBBM_PIPESTAT_CPRIMITIVES			__FD_DEPRECATED 0x0000038c
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_CPRIMITIVES_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_CPRIMITIVES_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_RBBM_PIPESTAT_PSINVOCATIONS			__FD_DEPRECATED 0x0000038e
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_PSINVOCATIONS_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_PSINVOCATIONS_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_RBBM_PIPESTAT_HSINVOCATIONS			__FD_DEPRECATED 0x00000390
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_HSINVOCATIONS_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_HSINVOCATIONS_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_RBBM_PIPESTAT_DSINVOCATIONS			__FD_DEPRECATED 0x00000392
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_DSINVOCATIONS_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_DSINVOCATIONS_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_RBBM_PIPESTAT_CSINVOCATIONS			__FD_DEPRECATED 0x00000394
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_CSINVOCATIONS_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_CSINVOCATIONS_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_RBBM_PIPESTAT_ASINVOCATIONS			__FD_DEPRECATED 0x00000396
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_ASINVOCATIONS_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_ASINVOCATIONS_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_RBBM_PIPESTAT_MSINVOCATIONS			__FD_DEPRECATED 0x00000398
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_MSINVOCATIONS_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_MSINVOCATIONS_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_RBBM_PIPESTAT_MSPRIMITIVES			__FD_DEPRECATED 0x0000039a
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_MSPRIMITIVES_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_RBBM_PIPESTAT_MSPRIMITIVES_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RBBM_SECVID_TRUST_CNTL				0x0000f400


#define REG_A6XX_RBBM_SECVID_TSB_TRUSTED_BASE			0x0000f800
static CONSTEXPR inline uint32_t A6XX_RBBM_SECVID_TSB_TRUSTED_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RBBM_SECVID_TSB_TRUSTED_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RBBM_SECVID_TSB_TRUSTED_SIZE			0x0000f802


#define REG_A6XX_RBBM_SECVID_TSB_CNTL				0x0000f803


#define REG_A6XX_RBBM_SECVID_TSB_ADDR_MODE_CNTL			__FD_DEPRECATED 0x0000f810


#define REG_A7XX_RBBM_SECVID_TSB_STATUS				__FD_DEPRECATED 0x0000fc00
static CONSTEXPR inline uint32_t A7XX_RBBM_SECVID_TSB_STATUS_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_RBBM_SECVID_TSB_STATUS_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RBBM_VBIF_CLIENT_QOS_CNTL			__FD_DEPRECATED 0x00000010


#define REG_A6XX_RBBM_GBIF_CLIENT_QOS_CNTL			__FD_DEPRECATED 0x00000011


#define REG_A8XX_RBBM_GBIF_CLIENT_QOS_CNTL			__FD_DEPRECATED 0x00000008


#define REG_A6XX_RBBM_GBIF_HALT					__FD_DEPRECATED 0x00000016


#define REG_A8XX_RBBM_GBIF_HALT					__FD_DEPRECATED 0x0000000a


#define REG_A6XX_RBBM_GBIF_HALT_ACK				__FD_DEPRECATED 0x00000017


#define REG_A8XX_RBBM_GBIF_HALT_ACK				__FD_DEPRECATED 0x0000000b


#define REG_A6XX_RBBM_WAIT_FOR_GPU_IDLE_CMD			__FD_DEPRECATED 0x0000001c
#define A6XX_RBBM_WAIT_FOR_GPU_IDLE_CMD_WAIT_GPU_IDLE		0x00000001


#define REG_A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL			__FD_DEPRECATED 0x0000001a


#define REG_A6XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2			__FD_DEPRECATED 0x0000001b


#define REG_A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL			__FD_DEPRECATED 0x00000010


#define REG_A8XX_RBBM_WAIT_IDLE_CLOCKS_CNTL2			__FD_DEPRECATED 0x00000011


#define REG_A6XX_RBBM_INTERFACE_HANG_INT_CNTL			__FD_DEPRECATED 0x0000001f


#define REG_A8XX_RBBM_INTERFACE_HANG_INT_CNTL			__FD_DEPRECATED 0x0000002f


#define REG_A6XX_RBBM_INT_CLEAR_CMD				__FD_DEPRECATED 0x00000037

#define REG_A8XX_RBBM_INT_CLEAR_CMD				__FD_DEPRECATED 0x00000061

#define REG_A6XX_RBBM_INT_0_MASK				__FD_DEPRECATED 0x00000038

#define REG_A8XX_RBBM_INT_0_MASK				__FD_DEPRECATED 0x00000062

#define REG_A7XX_RBBM_INT_2_MASK				__FD_DEPRECATED 0x0000003a


#define REG_A8XX_RBBM_INT_2_MASK				__FD_DEPRECATED 0x00000064


#define REG_A6XX_RBBM_SP_HYST_CNT				__FD_DEPRECATED 0x00000042


#define REG_A6XX_RBBM_SW_RESET_CMD				__FD_DEPRECATED 0x00000043


#define REG_A8XX_RBBM_SW_RESET_CMD				__FD_DEPRECATED 0x00000073


#define REG_A6XX_RBBM_RAC_THRESHOLD_CNT				__FD_DEPRECATED 0x00000044


#define REG_A8XX_RBBM_RAC_THRESHOLD_CNT				__FD_DEPRECATED 0x00000029


#define REG_A6XX_RBBM_BLOCK_SW_RESET_CMD			__FD_DEPRECATED 0x00000045


#define REG_A6XX_RBBM_BLOCK_SW_RESET_CMD2			__FD_DEPRECATED 0x00000046


#define REG_A7XX_RBBM_CLOCK_CNTL_GLOBAL				__FD_DEPRECATED 0x000000ad


#define REG_A8XX_RBBM_CLOCK_CNTL_GLOBAL				__FD_DEPRECATED 0x0000009a


#define REG_A8XX_RBBM_POWER_UP_RESET_SW_OVERRIDE		__FD_DEPRECATED 0x0000007d


#define REG_A8XX_RBBM_POWER_UP_RESET_SW_BV_OVERRIDE		__FD_DEPRECATED 0x0000007e


#define REG_A6XX_RBBM_CLOCK_CNTL				__FD_DEPRECATED 0x000000ae


#define REG_A6XX_RBBM_CLOCK_CNTL_SP0				__FD_DEPRECATED 0x000000b0


#define REG_A6XX_RBBM_CLOCK_CNTL_SP1				__FD_DEPRECATED 0x000000b1


#define REG_A6XX_RBBM_CLOCK_CNTL_SP2				__FD_DEPRECATED 0x000000b2


#define REG_A6XX_RBBM_CLOCK_CNTL_SP3				__FD_DEPRECATED 0x000000b3


#define REG_A6XX_RBBM_CLOCK_CNTL2_SP0				__FD_DEPRECATED 0x000000b4


#define REG_A6XX_RBBM_CLOCK_CNTL2_SP1				__FD_DEPRECATED 0x000000b5


#define REG_A6XX_RBBM_CLOCK_CNTL2_SP2				__FD_DEPRECATED 0x000000b6


#define REG_A6XX_RBBM_CLOCK_CNTL2_SP3				__FD_DEPRECATED 0x000000b7


#define REG_A6XX_RBBM_CLOCK_DELAY_SP0				__FD_DEPRECATED 0x000000b8


#define REG_A6XX_RBBM_CLOCK_DELAY_SP1				__FD_DEPRECATED 0x000000b9


#define REG_A6XX_RBBM_CLOCK_DELAY_SP2				__FD_DEPRECATED 0x000000ba


#define REG_A6XX_RBBM_CLOCK_DELAY_SP3				__FD_DEPRECATED 0x000000bb


#define REG_A6XX_RBBM_CLOCK_HYST_SP0				__FD_DEPRECATED 0x000000bc


#define REG_A6XX_RBBM_CLOCK_HYST_SP1				__FD_DEPRECATED 0x000000bd


#define REG_A6XX_RBBM_CLOCK_HYST_SP2				__FD_DEPRECATED 0x000000be


#define REG_A6XX_RBBM_CLOCK_HYST_SP3				__FD_DEPRECATED 0x000000bf


#define REG_A6XX_RBBM_CLOCK_CNTL_TP0				__FD_DEPRECATED 0x000000c0


#define REG_A6XX_RBBM_CLOCK_CNTL_TP1				__FD_DEPRECATED 0x000000c1


#define REG_A6XX_RBBM_CLOCK_CNTL_TP2				__FD_DEPRECATED 0x000000c2


#define REG_A6XX_RBBM_CLOCK_CNTL_TP3				__FD_DEPRECATED 0x000000c3


#define REG_A6XX_RBBM_CLOCK_CNTL2_TP0				__FD_DEPRECATED 0x000000c4


#define REG_A6XX_RBBM_CLOCK_CNTL2_TP1				__FD_DEPRECATED 0x000000c5


#define REG_A6XX_RBBM_CLOCK_CNTL2_TP2				__FD_DEPRECATED 0x000000c6


#define REG_A6XX_RBBM_CLOCK_CNTL2_TP3				__FD_DEPRECATED 0x000000c7


#define REG_A6XX_RBBM_CLOCK_CNTL3_TP0				__FD_DEPRECATED 0x000000c8


#define REG_A6XX_RBBM_CLOCK_CNTL3_TP1				__FD_DEPRECATED 0x000000c9


#define REG_A6XX_RBBM_CLOCK_CNTL3_TP2				__FD_DEPRECATED 0x000000ca


#define REG_A6XX_RBBM_CLOCK_CNTL3_TP3				__FD_DEPRECATED 0x000000cb


#define REG_A6XX_RBBM_CLOCK_CNTL4_TP0				__FD_DEPRECATED 0x000000cc


#define REG_A6XX_RBBM_CLOCK_CNTL4_TP1				__FD_DEPRECATED 0x000000cd


#define REG_A6XX_RBBM_CLOCK_CNTL4_TP2				__FD_DEPRECATED 0x000000ce


#define REG_A6XX_RBBM_CLOCK_CNTL4_TP3				__FD_DEPRECATED 0x000000cf


#define REG_A6XX_RBBM_CLOCK_DELAY_TP0				__FD_DEPRECATED 0x000000d0


#define REG_A6XX_RBBM_CLOCK_DELAY_TP1				__FD_DEPRECATED 0x000000d1


#define REG_A6XX_RBBM_CLOCK_DELAY_TP2				__FD_DEPRECATED 0x000000d2


#define REG_A6XX_RBBM_CLOCK_DELAY_TP3				__FD_DEPRECATED 0x000000d3


#define REG_A6XX_RBBM_CLOCK_DELAY2_TP0				__FD_DEPRECATED 0x000000d4


#define REG_A6XX_RBBM_CLOCK_DELAY2_TP1				__FD_DEPRECATED 0x000000d5


#define REG_A6XX_RBBM_CLOCK_DELAY2_TP2				__FD_DEPRECATED 0x000000d6


#define REG_A6XX_RBBM_CLOCK_DELAY2_TP3				__FD_DEPRECATED 0x000000d7


#define REG_A6XX_RBBM_CLOCK_DELAY3_TP0				__FD_DEPRECATED 0x000000d8


#define REG_A6XX_RBBM_CLOCK_DELAY3_TP1				__FD_DEPRECATED 0x000000d9


#define REG_A6XX_RBBM_CLOCK_DELAY3_TP2				__FD_DEPRECATED 0x000000da


#define REG_A6XX_RBBM_CLOCK_DELAY3_TP3				__FD_DEPRECATED 0x000000db


#define REG_A6XX_RBBM_CLOCK_DELAY4_TP0				__FD_DEPRECATED 0x000000dc


#define REG_A6XX_RBBM_CLOCK_DELAY4_TP1				__FD_DEPRECATED 0x000000dd


#define REG_A6XX_RBBM_CLOCK_DELAY4_TP2				__FD_DEPRECATED 0x000000de


#define REG_A6XX_RBBM_CLOCK_DELAY4_TP3				__FD_DEPRECATED 0x000000df


#define REG_A6XX_RBBM_CLOCK_HYST_TP0				__FD_DEPRECATED 0x000000e0


#define REG_A6XX_RBBM_CLOCK_HYST_TP1				__FD_DEPRECATED 0x000000e1


#define REG_A6XX_RBBM_CLOCK_HYST_TP2				__FD_DEPRECATED 0x000000e2


#define REG_A6XX_RBBM_CLOCK_HYST_TP3				__FD_DEPRECATED 0x000000e3


#define REG_A6XX_RBBM_CLOCK_HYST2_TP0				__FD_DEPRECATED 0x000000e4


#define REG_A6XX_RBBM_CLOCK_HYST2_TP1				__FD_DEPRECATED 0x000000e5


#define REG_A6XX_RBBM_CLOCK_HYST2_TP2				__FD_DEPRECATED 0x000000e6


#define REG_A6XX_RBBM_CLOCK_HYST2_TP3				__FD_DEPRECATED 0x000000e7


#define REG_A6XX_RBBM_CLOCK_HYST3_TP0				__FD_DEPRECATED 0x000000e8


#define REG_A6XX_RBBM_CLOCK_HYST3_TP1				__FD_DEPRECATED 0x000000e9


#define REG_A6XX_RBBM_CLOCK_HYST3_TP2				__FD_DEPRECATED 0x000000ea


#define REG_A6XX_RBBM_CLOCK_HYST3_TP3				__FD_DEPRECATED 0x000000eb


#define REG_A6XX_RBBM_CLOCK_HYST4_TP0				__FD_DEPRECATED 0x000000ec


#define REG_A6XX_RBBM_CLOCK_HYST4_TP1				__FD_DEPRECATED 0x000000ed


#define REG_A6XX_RBBM_CLOCK_HYST4_TP2				__FD_DEPRECATED 0x000000ee


#define REG_A6XX_RBBM_CLOCK_HYST4_TP3				__FD_DEPRECATED 0x000000ef


#define REG_A6XX_RBBM_CLOCK_CNTL_RB0				__FD_DEPRECATED 0x000000f0


#define REG_A6XX_RBBM_CLOCK_CNTL_RB1				__FD_DEPRECATED 0x000000f1


#define REG_A6XX_RBBM_CLOCK_CNTL_RB2				__FD_DEPRECATED 0x000000f2


#define REG_A6XX_RBBM_CLOCK_CNTL_RB3				__FD_DEPRECATED 0x000000f3


#define REG_A6XX_RBBM_CLOCK_CNTL2_RB0				__FD_DEPRECATED 0x000000f4


#define REG_A6XX_RBBM_CLOCK_CNTL2_RB1				__FD_DEPRECATED 0x000000f5


#define REG_A6XX_RBBM_CLOCK_CNTL2_RB2				__FD_DEPRECATED 0x000000f6


#define REG_A6XX_RBBM_CLOCK_CNTL2_RB3				__FD_DEPRECATED 0x000000f7


#define REG_A6XX_RBBM_CLOCK_CNTL_CCU0				__FD_DEPRECATED 0x000000f8


#define REG_A6XX_RBBM_CLOCK_CNTL_CCU1				__FD_DEPRECATED 0x000000f9


#define REG_A6XX_RBBM_CLOCK_CNTL_CCU2				__FD_DEPRECATED 0x000000fa


#define REG_A6XX_RBBM_CLOCK_CNTL_CCU3				__FD_DEPRECATED 0x000000fb


#define REG_A6XX_RBBM_CLOCK_HYST_RB_CCU0			__FD_DEPRECATED 0x00000100


#define REG_A6XX_RBBM_CLOCK_HYST_RB_CCU1			__FD_DEPRECATED 0x00000101


#define REG_A6XX_RBBM_CLOCK_HYST_RB_CCU2			__FD_DEPRECATED 0x00000102


#define REG_A6XX_RBBM_CLOCK_HYST_RB_CCU3			__FD_DEPRECATED 0x00000103


#define REG_A6XX_RBBM_CLOCK_CNTL_RAC				__FD_DEPRECATED 0x00000104


#define REG_A6XX_RBBM_CLOCK_CNTL2_RAC				__FD_DEPRECATED 0x00000105


#define REG_A6XX_RBBM_CLOCK_DELAY_RAC				__FD_DEPRECATED 0x00000106


#define REG_A6XX_RBBM_CLOCK_HYST_RAC				__FD_DEPRECATED 0x00000107


#define REG_A6XX_RBBM_CLOCK_CNTL_TSE_RAS_RBBM			__FD_DEPRECATED 0x00000108


#define REG_A6XX_RBBM_CLOCK_DELAY_TSE_RAS_RBBM			__FD_DEPRECATED 0x00000109


#define REG_A6XX_RBBM_CLOCK_HYST_TSE_RAS_RBBM			__FD_DEPRECATED 0x0000010a


#define REG_A6XX_RBBM_CLOCK_CNTL_UCHE				__FD_DEPRECATED 0x0000010b


#define REG_A6XX_RBBM_CLOCK_CNTL2_UCHE				__FD_DEPRECATED 0x0000010c


#define REG_A6XX_RBBM_CLOCK_CNTL3_UCHE				__FD_DEPRECATED 0x0000010d


#define REG_A6XX_RBBM_CLOCK_CNTL4_UCHE				__FD_DEPRECATED 0x0000010e


#define REG_A6XX_RBBM_CLOCK_DELAY_UCHE				__FD_DEPRECATED 0x0000010f


#define REG_A6XX_RBBM_CLOCK_HYST_UCHE				__FD_DEPRECATED 0x00000110


#define REG_A6XX_RBBM_CLOCK_MODE_VFD				__FD_DEPRECATED 0x00000111


#define REG_A6XX_RBBM_CLOCK_DELAY_VFD				__FD_DEPRECATED 0x00000112


#define REG_A6XX_RBBM_CLOCK_HYST_VFD				__FD_DEPRECATED 0x00000113


#define REG_A6XX_RBBM_CLOCK_MODE_GPC				__FD_DEPRECATED 0x00000114


#define REG_A6XX_RBBM_CLOCK_DELAY_GPC				__FD_DEPRECATED 0x00000115


#define REG_A6XX_RBBM_CLOCK_HYST_GPC				__FD_DEPRECATED 0x00000116


#define REG_A6XX_RBBM_CLOCK_DELAY_HLSQ_2			__FD_DEPRECATED 0x00000117


#define REG_A6XX_RBBM_CLOCK_CNTL_GMU_GX				__FD_DEPRECATED 0x00000118


#define REG_A6XX_RBBM_CLOCK_DELAY_GMU_GX			__FD_DEPRECATED 0x00000119


#define REG_A6XX_RBBM_CLOCK_HYST_GMU_GX				__FD_DEPRECATED 0x0000011a


#define REG_A6XX_RBBM_CLOCK_MODE_HLSQ				__FD_DEPRECATED 0x0000011b


#define REG_A6XX_RBBM_CLOCK_DELAY_HLSQ				__FD_DEPRECATED 0x0000011c


#define REG_A6XX_RBBM_CLOCK_HYST_HLSQ				__FD_DEPRECATED 0x0000011d


#define REG_A7XX_RBBM_CGC_GLOBAL_LOAD_CMD			__FD_DEPRECATED 0x0000011e


#define REG_A8XX_RBBM_CGC_GLOBAL_LOAD_CMD			__FD_DEPRECATED 0x0000009b


#define REG_A7XX_RBBM_CGC_P2S_TRIG_CMD				__FD_DEPRECATED 0x0000011f


#define REG_A8XX_RBBM_CGC_P2S_TRIG_CMD				__FD_DEPRECATED 0x0000009c


#define REG_A7XX_RBBM_CGC_P2S_CNTL				__FD_DEPRECATED 0x00000120


#define REG_A8XX_RBBM_CGC_P2S_CNTL				__FD_DEPRECATED 0x0000009d


#define REG_A6XX_RBBM_CLOCK_CNTL_TEX_FCHE			__FD_DEPRECATED 0x00000120


#define REG_A6XX_RBBM_CLOCK_DELAY_TEX_FCHE			__FD_DEPRECATED 0x00000121


#define REG_A6XX_RBBM_CLOCK_HYST_TEX_FCHE			__FD_DEPRECATED 0x00000122


#define REG_A7XX_RBBM_CGC_P2S_STATUS				__FD_DEPRECATED 0x00000122
#define A7XX_RBBM_CGC_P2S_STATUS_TXDONE				0x00000001


#define REG_A8XX_RBBM_CGC_P2S_STATUS				__FD_DEPRECATED 0x0000009f
#define A8XX_RBBM_CGC_P2S_STATUS_TXDONE				0x00000001


#define REG_A6XX_RBBM_CLOCK_CNTL_FCHE				__FD_DEPRECATED 0x00000123


#define REG_A6XX_RBBM_CLOCK_DELAY_FCHE				__FD_DEPRECATED 0x00000124


#define REG_A6XX_RBBM_CLOCK_HYST_FCHE				__FD_DEPRECATED 0x00000125


#define REG_A6XX_RBBM_CLOCK_CNTL_MHUB				__FD_DEPRECATED 0x00000126


#define REG_A6XX_RBBM_CLOCK_DELAY_MHUB				__FD_DEPRECATED 0x00000127


#define REG_A6XX_RBBM_CLOCK_HYST_MHUB				__FD_DEPRECATED 0x00000128


#define REG_A6XX_RBBM_CLOCK_DELAY_GLC				__FD_DEPRECATED 0x00000129


#define REG_A6XX_RBBM_CLOCK_HYST_GLC				__FD_DEPRECATED 0x0000012a


#define REG_A6XX_RBBM_CLOCK_CNTL_GLC				__FD_DEPRECATED 0x0000012b


#define REG_A7XX_RBBM_CLOCK_HYST2_VFD				__FD_DEPRECATED 0x0000012f


#define REG_A7XX_RBBM_CGC_0_PC					__FD_DEPRECATED 0x00000195


#define REG_A8XX_RBBM_CGC_0_PC					__FD_DEPRECATED 0x0000010b


#define REG_A6XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL			__FD_DEPRECATED 0x000005ff


#define REG_A8XX_RBBM_LPAC_GBIF_CLIENT_QOS_CNTL			__FD_DEPRECATED 0x00000009


#define REG_A6XX_DBGC_CFG_DBGBUS_SEL_A				0x00000600


#define REG_A6XX_DBGC_CFG_DBGBUS_SEL_B				0x00000601


#define REG_A6XX_DBGC_CFG_DBGBUS_SEL_C				0x00000602


#define REG_A6XX_DBGC_CFG_DBGBUS_SEL_D				__FD_DEPRECATED 0x00000603
#define A6XX_DBGC_CFG_DBGBUS_SEL_D_PING_INDEX__MASK		0x000000ffull
#define A6XX_DBGC_CFG_DBGBUS_SEL_D_PING_INDEX__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_SEL_D_PING_INDEX(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_SEL_D_PING_INDEX__SHIFT) & A6XX_DBGC_CFG_DBGBUS_SEL_D_PING_INDEX__MASK;
}
#define A6XX_DBGC_CFG_DBGBUS_SEL_D_PING_BLK_SEL__MASK		0x0000ff00ull
#define A6XX_DBGC_CFG_DBGBUS_SEL_D_PING_BLK_SEL__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_SEL_D_PING_BLK_SEL(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_SEL_D_PING_BLK_SEL__SHIFT) & A6XX_DBGC_CFG_DBGBUS_SEL_D_PING_BLK_SEL__MASK;
}


#define REG_A7XX_DBGC_CFG_DBGBUS_SEL_D				__FD_DEPRECATED 0x00000603
#define A7XX_DBGC_CFG_DBGBUS_SEL_D_PING_INDEX__MASK		0x000000ffull
#define A7XX_DBGC_CFG_DBGBUS_SEL_D_PING_INDEX__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_DBGC_CFG_DBGBUS_SEL_D_PING_INDEX(uint32_t val)
{
	return ((val) << A7XX_DBGC_CFG_DBGBUS_SEL_D_PING_INDEX__SHIFT) & A7XX_DBGC_CFG_DBGBUS_SEL_D_PING_INDEX__MASK;
}
#define A7XX_DBGC_CFG_DBGBUS_SEL_D_PING_BLK_SEL__MASK		0x01ff0000ull
#define A7XX_DBGC_CFG_DBGBUS_SEL_D_PING_BLK_SEL__SHIFT		16
static CONSTEXPR inline uint32_t A7XX_DBGC_CFG_DBGBUS_SEL_D_PING_BLK_SEL(uint32_t val)
{
	return ((val) << A7XX_DBGC_CFG_DBGBUS_SEL_D_PING_BLK_SEL__SHIFT) & A7XX_DBGC_CFG_DBGBUS_SEL_D_PING_BLK_SEL__MASK;
}


#define REG_A6XX_DBGC_CFG_DBGBUS_CNTLT				0x00000604
#define A6XX_DBGC_CFG_DBGBUS_CNTLT_TRACEEN__MASK		0x0000003full
#define A6XX_DBGC_CFG_DBGBUS_CNTLT_TRACEEN__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_CNTLT_TRACEEN(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_CNTLT_TRACEEN__SHIFT) & A6XX_DBGC_CFG_DBGBUS_CNTLT_TRACEEN__MASK;
}
#define A6XX_DBGC_CFG_DBGBUS_CNTLT_GRANU__MASK			0x00007000ull
#define A6XX_DBGC_CFG_DBGBUS_CNTLT_GRANU__SHIFT			12
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_CNTLT_GRANU(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_CNTLT_GRANU__SHIFT) & A6XX_DBGC_CFG_DBGBUS_CNTLT_GRANU__MASK;
}
#define A6XX_DBGC_CFG_DBGBUS_CNTLT_SEGT__MASK			0xf0000000ull
#define A6XX_DBGC_CFG_DBGBUS_CNTLT_SEGT__SHIFT			28
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_CNTLT_SEGT(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_CNTLT_SEGT__SHIFT) & A6XX_DBGC_CFG_DBGBUS_CNTLT_SEGT__MASK;
}


#define REG_A6XX_DBGC_CFG_DBGBUS_CNTLM				0x00000605
#define A6XX_DBGC_CFG_DBGBUS_CNTLM_ENABLE__MASK			0x0f000000ull
#define A6XX_DBGC_CFG_DBGBUS_CNTLM_ENABLE__SHIFT		24
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_CNTLM_ENABLE(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_CNTLM_ENABLE__SHIFT) & A6XX_DBGC_CFG_DBGBUS_CNTLM_ENABLE__MASK;
}


#define REG_A6XX_DBGC_CFG_DBGBUS_OPL				0x00000606


#define REG_A6XX_DBGC_CFG_DBGBUS_OPE				0x00000607


#define REG_A6XX_DBGC_CFG_DBGBUS_IVTL_0				0x00000608


#define REG_A6XX_DBGC_CFG_DBGBUS_IVTL_1				0x00000609


#define REG_A6XX_DBGC_CFG_DBGBUS_IVTL_2				0x0000060a


#define REG_A6XX_DBGC_CFG_DBGBUS_IVTL_3				0x0000060b


#define REG_A6XX_DBGC_CFG_DBGBUS_MASKL_0			0x0000060c


#define REG_A6XX_DBGC_CFG_DBGBUS_MASKL_1			0x0000060d


#define REG_A6XX_DBGC_CFG_DBGBUS_MASKL_2			0x0000060e


#define REG_A6XX_DBGC_CFG_DBGBUS_MASKL_3			0x0000060f


#define REG_A6XX_DBGC_CFG_DBGBUS_BYTEL_0			0x00000610
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL0__MASK		0x0000000full
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL0__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL0(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL0__SHIFT) & A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL0__MASK;
}
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL1__MASK		0x000000f0ull
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL1__SHIFT		4
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL1(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL1__SHIFT) & A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL1__MASK;
}
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL2__MASK		0x00000f00ull
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL2__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL2(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL2__SHIFT) & A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL2__MASK;
}
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL3__MASK		0x0000f000ull
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL3__SHIFT		12
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL3(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL3__SHIFT) & A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL3__MASK;
}
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL4__MASK		0x000f0000ull
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL4__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL4(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL4__SHIFT) & A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL4__MASK;
}
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL5__MASK		0x00f00000ull
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL5__SHIFT		20
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL5(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL5__SHIFT) & A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL5__MASK;
}
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL6__MASK		0x0f000000ull
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL6__SHIFT		24
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL6(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL6__SHIFT) & A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL6__MASK;
}
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL7__MASK		0xf0000000ull
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL7__SHIFT		28
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL7(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL7__SHIFT) & A6XX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL7__MASK;
}


#define REG_A6XX_DBGC_CFG_DBGBUS_BYTEL_1			0x00000611
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL8__MASK		0x0000000full
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL8__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL8(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL8__SHIFT) & A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL8__MASK;
}
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL9__MASK		0x000000f0ull
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL9__SHIFT		4
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL9(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL9__SHIFT) & A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL9__MASK;
}
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL10__MASK		0x00000f00ull
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL10__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL10(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL10__SHIFT) & A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL10__MASK;
}
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL11__MASK		0x0000f000ull
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL11__SHIFT		12
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL11(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL11__SHIFT) & A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL11__MASK;
}
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL12__MASK		0x000f0000ull
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL12__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL12(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL12__SHIFT) & A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL12__MASK;
}
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL13__MASK		0x00f00000ull
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL13__SHIFT		20
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL13(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL13__SHIFT) & A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL13__MASK;
}
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL14__MASK		0x0f000000ull
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL14__SHIFT		24
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL14(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL14__SHIFT) & A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL14__MASK;
}
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL15__MASK		0xf0000000ull
#define A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL15__SHIFT		28
static CONSTEXPR inline uint32_t A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL15(uint32_t val)
{
	return ((val) << A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL15__SHIFT) & A6XX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL15__MASK;
}


#define REG_A6XX_DBGC_CFG_DBGBUS_IVTE_0				0x00000612


#define REG_A6XX_DBGC_CFG_DBGBUS_IVTE_1				0x00000613


#define REG_A6XX_DBGC_CFG_DBGBUS_IVTE_2				0x00000614


#define REG_A6XX_DBGC_CFG_DBGBUS_IVTE_3				0x00000615


#define REG_A6XX_DBGC_CFG_DBGBUS_MASKE_0			0x00000616


#define REG_A6XX_DBGC_CFG_DBGBUS_MASKE_1			0x00000617


#define REG_A6XX_DBGC_CFG_DBGBUS_MASKE_2			0x00000618


#define REG_A6XX_DBGC_CFG_DBGBUS_MASKE_3			0x00000619


#define REG_A6XX_DBGC_CFG_DBGBUS_NIBBLEE			0x0000061a


#define REG_A6XX_DBGC_CFG_DBGBUS_PTRC0				0x0000061b


#define REG_A6XX_DBGC_CFG_DBGBUS_PTRC1				0x0000061c


#define REG_A6XX_DBGC_CFG_DBGBUS_LOADREG			0x0000061d


#define REG_A6XX_DBGC_CFG_DBGBUS_IDX				0x0000061e


#define REG_A6XX_DBGC_CFG_DBGBUS_CLRC				0x0000061f


#define REG_A6XX_DBGC_CFG_DBGBUS_LOADIVT			0x00000620


#define REG_A6XX_DBGC_VBIF_DBG_CNTL				0x00000621


#define REG_A6XX_DBGC_DBG_LO_HI_GPIO				0x00000622


#define REG_A6XX_DBGC_EXT_TRACE_BUS_CNTL			0x00000623


#define REG_A6XX_DBGC_READ_AHB_THROUGH_DBG			0x00000624


#define REG_A6XX_DBGC_CFG_DBGBUS_EVENT_LOGIC			0x00000625


#define REG_A6XX_DBGC_CFG_DBGBUS_OVER				0x00000626


#define REG_A6XX_DBGC_CFG_DBGBUS_COUNT0				0x00000627


#define REG_A6XX_DBGC_CFG_DBGBUS_COUNT1				0x00000628


#define REG_A6XX_DBGC_CFG_DBGBUS_COUNT2				0x00000629


#define REG_A6XX_DBGC_CFG_DBGBUS_COUNT3				0x0000062a


#define REG_A6XX_DBGC_CFG_DBGBUS_COUNT4				0x0000062b


#define REG_A6XX_DBGC_CFG_DBGBUS_COUNT5				0x0000062c


#define REG_A6XX_DBGC_CFG_DBGBUS_TRACE_ADDR			0x0000062d


#define REG_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF0			0x0000062e


#define REG_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF1			0x0000062f


#define REG_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF2			0x00000630


#define REG_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF3			0x00000631


#define REG_A6XX_DBGC_CFG_DBGBUS_TRACE_BUF4			0x00000632


#define REG_A6XX_DBGC_CFG_DBGBUS_MISR0				0x00000633


#define REG_A6XX_DBGC_CFG_DBGBUS_MISR1				0x00000634


#define REG_A6XX_DBGC_EVT_CFG					0x00000635


#define REG_A6XX_DBGC_EVT_INTF_SEL_0				0x00000636


#define REG_A6XX_DBGC_EVT_INTF_SEL_1				0x00000637


#define REG_A6XX_DBGC_EVT_SLICE_CFG				0x00000638


#define REG_A6XX_DBGC_QDSS_TIMESTAMP_0				0x00000639


#define REG_A6XX_DBGC_QDSS_TIMESTAMP_1				0x0000063a


#define REG_A6XX_DBGC_ECO_CNTL					0x0000063b


#define REG_A6XX_DBGC_AHB_DBG_CNTL				0x0000063c


#define REG_A6XX_DBGC_EVT_INTF_SEL_2				0x0000063d


#define REG_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_A			0x00000640


#define REG_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_B			0x00000641


#define REG_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_C			0x00000642


#define REG_A6XX_DBGC_CFG_DBGBUS_PONG_SEL_D			0x00000643


#define REG_A6XX_DBGC_CFG_DBGBUS_MISC_MODE			0x00000644


#define REG_A6XX_DBGC_EVT_INTF_SEL_3_0				0x00000650


#define REG_A6XX_DBGC_EVT_INTF_SEL_3_1				0x00000651


#define REG_A6XX_DBGC_EVT_INTF_SEL_3_2				0x00000652


#define REG_A6XX_DBGC_EVT_INTF_SEL_3_3				0x00000653


#define REG_A6XX_DBGC_EVT_INTF_SEL_3_4				0x00000654


#define REG_A6XX_DBGC_EVT_INTF_SEL_3_5				0x00000655


#define REG_A6XX_DBGC_TRACE_BUFFER_STATUS			0x00000660


#define REG_A6XX_DBGC_TRACE_BUFFER_CMD				0x00000661


#define REG_A6XX_DBGC_DBG_TRACE_BUFFER_RD_ADDR			0x00000662


#define REG_A6XX_DBGC_DBG_TRACE_BUFFER_RD_DATA			0x00000663


#define REG_A6XX_DBGC_TRACE_BUFFER_ATB_RD_STATUS		0x00000664


#define REG_A6XX_DBGC_SMMU_FAULT_BLOCK_HALT_CFG			0x00000665


#define REG_A6XX_DBGC_DBG_LOPC_SB_RD_ADDR			0x00000666


#define REG_A6XX_DBGC_DBG_LOPC_SB_RD_DATA			0x00000667


#define REG_A6XX_DBGC_DBG_LOPC_SB_WR_ADDR			0x00000668


#define REG_A6XX_DBGC_DBG_LOPC_SB_WR_DATA			0x00000669


#define REG_A6XX_DBGC_INTERRUPT_STATUS				0x0000066a


#define REG_A6XX_DBGC_GBIF_DBG_BASE				0x00000680
static CONSTEXPR inline uint32_t A6XX_DBGC_GBIF_DBG_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_DBGC_GBIF_DBG_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_DBGC_GBIF_DBG_BUFF_SIZE			0x00000682


#define REG_A6XX_DBGC_GBIF_DBG_CNTL				0x00000683


#define REG_A6XX_DBGC_GBIF_DBG_CMD				0x00000684


#define REG_A6XX_DBGC_GBIF_DBG_STATUS				0x00000685


#define REG_A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_US			__FD_DEPRECATED 0x00000700


#define REG_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_US		__FD_DEPRECATED 0x00000701


#define REG_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_US		__FD_DEPRECATED 0x00000702


#define REG_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS_US		__FD_DEPRECATED 0x00000703


#define REG_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS_US		__FD_DEPRECATED 0x00000704


#define REG_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_NONE_US		__FD_DEPRECATED 0x00000707


#define REG_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_US		__FD_DEPRECATED 0x00000708


#define REG_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_US		__FD_DEPRECATED 0x00000709


#define REG_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS_US		__FD_DEPRECATED 0x0000070a


#define REG_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_NONE_US		__FD_DEPRECATED 0x0000070f


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US		__FD_DEPRECATED 0x00000710


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_1		__FD_DEPRECATED 0x00000711


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_US_2		__FD_DEPRECATED 0x00000712


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US		__FD_DEPRECATED 0x00000713


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_US_1		__FD_DEPRECATED 0x00000714


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_US		__FD_DEPRECATED 0x00000715


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_US		__FD_DEPRECATED 0x00000716


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US		__FD_DEPRECATED 0x00000720


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_NONE_US_1		__FD_DEPRECATED 0x00000721


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US		__FD_DEPRECATED 0x00000722


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_1		__FD_DEPRECATED 0x00000723


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_US_2		__FD_DEPRECATED 0x00000724


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US		__FD_DEPRECATED 0x00000730


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_US_1		__FD_DEPRECATED 0x00000731


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_US		__FD_DEPRECATED 0x00000732


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_NONE_US		__FD_DEPRECATED 0x00000740


#define REG_A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_US		__FD_DEPRECATED 0x00000742


#define REG_A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_US		__FD_DEPRECATED 0x00000743


#define REG_A8XX_DBGC_CFG_GBIF_BR_PERF_CNTR_BASE		__FD_DEPRECATED 0x00000744
static CONSTEXPR inline uint32_t A8XX_DBGC_CFG_GBIF_BR_PERF_CNTR_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_DBGC_CFG_GBIF_BR_PERF_CNTR_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_DBGC_CFG_GBIF_BR_BUFFER_SIZE			__FD_DEPRECATED 0x00000746


#define REG_A8XX_DBGC_CFG_GBIF_BV_PERF_CNTR_BASE		__FD_DEPRECATED 0x00000747
static CONSTEXPR inline uint32_t A8XX_DBGC_CFG_GBIF_BV_PERF_CNTR_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_DBGC_CFG_GBIF_BV_PERF_CNTR_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_DBGC_CFG_GBIF_BV_BUFFER_SIZE			__FD_DEPRECATED 0x00000749


#define REG_A8XX_DBGC_CFG_GBIF_QOS_CTRL				__FD_DEPRECATED 0x0000074a


#define REG_A8XX_DBGC_GBIF_BR_PERF_CNTR_WRITE_POINTER		__FD_DEPRECATED 0x00000750


#define REG_A8XX_DBGC_GBIF_BV_PERF_CNTR_WRITE_POINTER		__FD_DEPRECATED 0x00000751


#define REG_A8XX_DBGC_PERF_COUNTER_FE_LOCAL_BATCH_ID		__FD_DEPRECATED 0x00000752


#define REG_A8XX_DBGC_CFG_PERF_WAIT_IDLE_CLOCKS_CNTL		__FD_DEPRECATED 0x00000753


#define REG_A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_US		__FD_DEPRECATED 0x00000754


#define REG_A8XX_DBGC_PERF_SKEW_BUFFER_INIT_CMD			__FD_DEPRECATED 0x00000755


#define REG_A8XX_DBGC_LOPC_INTERRUPT_STATUS			__FD_DEPRECATED 0x00000759


#define REG_A8XX_DBGC_LOPC_BUFFER_PTR_STATUS			__FD_DEPRECATED 0x0000075a


#define REG_A8XX_DBGC_PERF_SCOPING_STATUS			__FD_DEPRECATED 0x0000075b


#define REG_A8XX_DBGC_PERF_COUNTER_PKT_STATUS			__FD_DEPRECATED 0x0000075c


#define REG_A8XX_DBGC_GC_LIVE_MBX_PKT_STATUS			__FD_DEPRECATED 0x00000760


#define REG_A8XX_DBGC_GC_ALW_MBX_PKT_STATUS			__FD_DEPRECATED 0x00000761


#define REG_A8XX_DBGC_AO_CNTR_LO_STATUS				__FD_DEPRECATED 0x00000762


#define REG_A8XX_DBGC_AO_CNTR_HI_STATUS				__FD_DEPRECATED 0x00000763


#define REG_A8XX_DBGC_LOPC_GC_SB_DEPTH_STATUS			__FD_DEPRECATED 0x00000770


#define REG_A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_US		__FD_DEPRECATED 0x00000780


#define REG_A8XX_DBGC_CFG_PERF_TRIG_LPAC_US			__FD_DEPRECATED 0x00000781


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US		__FD_DEPRECATED 0x00000782


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_1		__FD_DEPRECATED 0x00000783


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_US_2		__FD_DEPRECATED 0x00000784


#define REG_A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_US	__FD_DEPRECATED 0x00000785


#define REG_A8XX_DBGC_CFG_GBIF_LPAC_PERF_CNTR_BASE		__FD_DEPRECATED 0x00000786
static CONSTEXPR inline uint32_t A8XX_DBGC_CFG_GBIF_LPAC_PERF_CNTR_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_DBGC_CFG_GBIF_LPAC_PERF_CNTR_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_DBGC_CFG_GBIF_LPAC_BUFFER_SIZE			__FD_DEPRECATED 0x00000788


#define REG_A8XX_DBGC_GBIF_LPAC_PERF_CNTR_WRITE_POINTER		__FD_DEPRECATED 0x00000789


#define REG_A8XX_DBGC_CFG_LPAC_PERF_WAIT_IDLE_CLOCKS_CNTL	__FD_DEPRECATED 0x0000078a


#define REG_A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_US		__FD_DEPRECATED 0x0000078b


#define REG_A8XX_DBGC_LPAC_MBX_PKT_STATUS			__FD_DEPRECATED 0x0000078c


#define REG_A8XX_DBGC_LPAC_PERF_SCOPING_STATUS			__FD_DEPRECATED 0x0000078d


#define REG_A8XX_DBGC_LOPC_LPAC_SB_DEPTH_STATUS			__FD_DEPRECATED 0x00000790


#define REG_A8XX_DBGC_SCOPE_PERF_COUNTER_CFG_S			__FD_DEPRECATED 0x000007a0


#define REG_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_FE_S		__FD_DEPRECATED 0x000007a1


#define REG_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_VS		__FD_DEPRECATED 0x000007a2


#define REG_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_VS		__FD_DEPRECATED 0x000007a3


#define REG_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_GRAS		__FD_DEPRECATED 0x000007a4


#define REG_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_SP_PS		__FD_DEPRECATED 0x000007a5


#define REG_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_VPC_PS		__FD_DEPRECATED 0x000007a6


#define REG_A8XX_DBGC_CFG_PERF_TRIG_CLUSTER_PS			__FD_DEPRECATED 0x000007a7


#define REG_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_FE_S		__FD_DEPRECATED 0x000007a8


#define REG_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_SP_VS		__FD_DEPRECATED 0x000007a9


#define REG_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_VS		__FD_DEPRECATED 0x000007aa


#define REG_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_GRAS		__FD_DEPRECATED 0x000007ab


#define REG_A8XX_DBGC_CFG_BV_PERF_TRIG_CLUSTER_VPC_PS		__FD_DEPRECATED 0x000007ac


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S			__FD_DEPRECATED 0x000007ad


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_1		__FD_DEPRECATED 0x000007ae


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_2		__FD_DEPRECATED 0x000007af


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_FE_S_3		__FD_DEPRECATED 0x000007b0


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS		__FD_DEPRECATED 0x000007b1


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_1		__FD_DEPRECATED 0x000007b2


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_2		__FD_DEPRECATED 0x000007b3


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_VS_3		__FD_DEPRECATED 0x000007b4


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS		__FD_DEPRECATED 0x000007b5


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_VS_1		__FD_DEPRECATED 0x000007b6


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS			__FD_DEPRECATED 0x000007b7


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_1		__FD_DEPRECATED 0x000007b8


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_GRAS_2		__FD_DEPRECATED 0x000007b9


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS		__FD_DEPRECATED 0x000007ba


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_1		__FD_DEPRECATED 0x000007bb


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_2		__FD_DEPRECATED 0x000007bc


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_SP_PS_3		__FD_DEPRECATED 0x000007bd


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS		__FD_DEPRECATED 0x000007be


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_VPC_PS_1		__FD_DEPRECATED 0x000007bf


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS			__FD_DEPRECATED 0x000007c0


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_1			__FD_DEPRECATED 0x000007c1


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_2			__FD_DEPRECATED 0x000007c2


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_PS_3			__FD_DEPRECATED 0x000007c3


#define REG_A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_S		__FD_DEPRECATED 0x000007c4


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S		__FD_DEPRECATED 0x000007c5


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_1		__FD_DEPRECATED 0x000007c6


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_2		__FD_DEPRECATED 0x000007c7


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_FE_S_3		__FD_DEPRECATED 0x000007c8


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS		__FD_DEPRECATED 0x000007c9


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_1		__FD_DEPRECATED 0x000007ca


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_2		__FD_DEPRECATED 0x000007cb


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_SP_VS_3		__FD_DEPRECATED 0x000007cc


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS		__FD_DEPRECATED 0x000007cd


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_VS_1		__FD_DEPRECATED 0x000007ce


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS		__FD_DEPRECATED 0x000007cf


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_1		__FD_DEPRECATED 0x000007d0


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_GRAS_2		__FD_DEPRECATED 0x000007d1


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS		__FD_DEPRECATED 0x000007d2


#define REG_A8XX_DBGC_CFG_BV_PERF_COUNTER_SEL_VPC_PS_1		__FD_DEPRECATED 0x000007d3


#define REG_A8XX_DBGC_CFG_BV_PERF_TIMESTAMP_TRIG_SEL_S		__FD_DEPRECATED 0x000007d4


#define REG_A8XX_DBGC_PERF_COUNTER_SCOPING_CMD_S		__FD_DEPRECATED 0x000007d5


#define REG_A8XX_DBGC_LPAC_SCOPE_PERF_COUNTER_CFG_S		__FD_DEPRECATED 0x000007e0


#define REG_A8XX_DBGC_CFG_PERF_TRIG_LPAC_S			__FD_DEPRECATED 0x000007e1


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S		__FD_DEPRECATED 0x000007e2


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_1		__FD_DEPRECATED 0x000007e3


#define REG_A8XX_DBGC_CFG_PERF_COUNTER_SEL_LPAC_S_2		__FD_DEPRECATED 0x000007e4


#define REG_A8XX_DBGC_CFG_PERF_TIMESTAMP_TRIG_SEL_LPAC_S	__FD_DEPRECATED 0x000007e5


#define REG_A8XX_DBGC_LPAC_PERF_COUNTER_SCOPING_CMD_S		__FD_DEPRECATED 0x000007e6


#define REG_A6XX_VSC_PERFCTR_VSC_SEL(i0)			(0x00000cd8 + 0x1*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_VSC_PERFCTR_VSC_SEL_REG(uint32_t i0) { return 0x00000cd8 + 0x1*i0; }


#define REG_A6XX_HLSQ_DBG_AHB_READ_APERTURE			0x0000c800


#define REG_A6XX_HLSQ_DBG_READ_SEL				0x0000d000


#define REG_A6XX_UCHE_ADDR_MODE_CNTL				__FD_DEPRECATED 0x00000e00


#define REG_A6XX_UCHE_MODE_CNTL					0x00000e01


#define REG_A6XX_UCHE_WRITE_RANGE_MAX				__FD_DEPRECATED 0x00000e05
static CONSTEXPR inline uint32_t A6XX_UCHE_WRITE_RANGE_MAX_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_UCHE_WRITE_RANGE_MAX_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_UCHE_WRITE_THRU_BASE				__FD_DEPRECATED 0x00000e07
static CONSTEXPR inline uint32_t A6XX_UCHE_WRITE_THRU_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_UCHE_WRITE_THRU_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_UCHE_WRITE_THRU_BASE				__FD_DEPRECATED 0x00000e06
static CONSTEXPR inline uint32_t A8XX_UCHE_WRITE_THRU_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_UCHE_WRITE_THRU_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_UCHE_TRAP_BASE					__FD_DEPRECATED 0x00000e09
static CONSTEXPR inline uint32_t A6XX_UCHE_TRAP_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_UCHE_TRAP_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_UCHE_TRAP_BASE					__FD_DEPRECATED 0x00000e08
static CONSTEXPR inline uint32_t A8XX_UCHE_TRAP_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_UCHE_TRAP_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_UCHE_GMEM_RANGE_MIN				__FD_DEPRECATED 0x00000e0b
static CONSTEXPR inline uint32_t A6XX_UCHE_GMEM_RANGE_MIN_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_UCHE_GMEM_RANGE_MIN_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_UCHE_GMEM_RANGE_MAX				__FD_DEPRECATED 0x00000e0d
static CONSTEXPR inline uint32_t A6XX_UCHE_GMEM_RANGE_MAX_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_UCHE_GMEM_RANGE_MAX_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_UCHE_CACHE_WAYS				__FD_DEPRECATED 0x00000e17


#define REG_A8XX_UCHE_CACHE_WAYS				__FD_DEPRECATED 0x00000e04


#define REG_A6XX_UCHE_FILTER_CNTL				0x00000e18


#define REG_A6XX_UCHE_CLIENT_PF					__FD_DEPRECATED 0x00000e19
#define A6XX_UCHE_CLIENT_PF_PERFSEL__MASK			0x000000ffull
#define A6XX_UCHE_CLIENT_PF_PERFSEL__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_UCHE_CLIENT_PF_PERFSEL(uint32_t val)
{
	return ((val) << A6XX_UCHE_CLIENT_PF_PERFSEL__SHIFT) & A6XX_UCHE_CLIENT_PF_PERFSEL__MASK;
}


#define REG_A6XX_UCHE_PERFCTR_UCHE_SEL(i0)			(0x00000e1c + 0x1*i0 )



#define REG_A8XX_UCHE_PERFCTR_UCHE_SEL(i0)			(0x00000e20 + 0x1*i0 )



#define REG_A6XX_UCHE_GBIF_GX_CONFIG				__FD_DEPRECATED 0x00000e3a


#define REG_A8XX_UCHE_GBIF_GX_CONFIG				__FD_DEPRECATED 0x00000e12


#define REG_A6XX_UCHE_CMDQ_CONFIG				__FD_DEPRECATED 0x00000e3c


#define REG_A8XX_UCHE_CCHE_MODE_CNTL				__FD_DEPRECATED 0x00000f01


#define REG_A8XX_UCHE_CCHE_CACHE_WAYS				__FD_DEPRECATED 0x00000f02


#define REG_A8XX_UCHE_CCHE_WRITE_THRU_BASE			__FD_DEPRECATED 0x00000f04
static CONSTEXPR inline uint32_t A8XX_UCHE_CCHE_WRITE_THRU_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_UCHE_CCHE_WRITE_THRU_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_UCHE_CCHE_TRAP_BASE				__FD_DEPRECATED 0x00000f06
static CONSTEXPR inline uint32_t A8XX_UCHE_CCHE_TRAP_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_UCHE_CCHE_TRAP_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_UCHE_CCHE_GC_GMEM_RANGE_MIN			__FD_DEPRECATED 0x00000f08
static CONSTEXPR inline uint32_t A8XX_UCHE_CCHE_GC_GMEM_RANGE_MIN_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_UCHE_CCHE_GC_GMEM_RANGE_MIN_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_UCHE_CCHE_LPAC_GMEM_RANGE_MIN			__FD_DEPRECATED 0x00000f0a
static CONSTEXPR inline uint32_t A8XX_UCHE_CCHE_LPAC_GMEM_RANGE_MIN_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_UCHE_CCHE_LPAC_GMEM_RANGE_MIN_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_UCHE_CCHE_HW_DBG_CNTL				__FD_DEPRECATED 0x00000f0c


#define REG_A6XX_VBIF_VERSION					__FD_DEPRECATED 0x00003000


#define REG_A6XX_VBIF_CLKON					__FD_DEPRECATED 0x00003001
#define A6XX_VBIF_CLKON_FORCE_ON_TESTBUS			0x00000002


#define REG_A6XX_VBIF_GATE_OFF_WRREQ_EN				__FD_DEPRECATED 0x0000302a


#define REG_A6XX_VBIF_XIN_HALT_CTRL0				__FD_DEPRECATED 0x00003080


#define REG_A6XX_VBIF_XIN_HALT_CTRL1				__FD_DEPRECATED 0x00003081


#define REG_A6XX_VBIF_TEST_BUS_OUT_CTRL				__FD_DEPRECATED 0x00003084


#define REG_A6XX_VBIF_TEST_BUS1_CTRL0				__FD_DEPRECATED 0x00003085


#define REG_A6XX_VBIF_TEST_BUS1_CTRL1				__FD_DEPRECATED 0x00003086
#define A6XX_VBIF_TEST_BUS1_CTRL1_DATA_SEL__MASK		0x0000000full
#define A6XX_VBIF_TEST_BUS1_CTRL1_DATA_SEL__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_VBIF_TEST_BUS1_CTRL1_DATA_SEL(uint32_t val)
{
	return ((val) << A6XX_VBIF_TEST_BUS1_CTRL1_DATA_SEL__SHIFT) & A6XX_VBIF_TEST_BUS1_CTRL1_DATA_SEL__MASK;
}


#define REG_A6XX_VBIF_TEST_BUS2_CTRL0				__FD_DEPRECATED 0x00003087


#define REG_A6XX_VBIF_TEST_BUS2_CTRL1				__FD_DEPRECATED 0x00003088
#define A6XX_VBIF_TEST_BUS2_CTRL1_DATA_SEL__MASK		0x000001ffull
#define A6XX_VBIF_TEST_BUS2_CTRL1_DATA_SEL__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_VBIF_TEST_BUS2_CTRL1_DATA_SEL(uint32_t val)
{
	return ((val) << A6XX_VBIF_TEST_BUS2_CTRL1_DATA_SEL__SHIFT) & A6XX_VBIF_TEST_BUS2_CTRL1_DATA_SEL__MASK;
}


#define REG_A6XX_VBIF_TEST_BUS_OUT				__FD_DEPRECATED 0x0000308c


#define REG_A6XX_VBIF_PERF_CNT_SEL0				__FD_DEPRECATED 0x000030d0


#define REG_A6XX_VBIF_PERF_CNT_SEL1				__FD_DEPRECATED 0x000030d1


#define REG_A6XX_VBIF_PERF_CNT_SEL2				__FD_DEPRECATED 0x000030d2


#define REG_A6XX_VBIF_PERF_CNT_SEL3				__FD_DEPRECATED 0x000030d3


#define REG_A6XX_VBIF_PERF_CNT_LOW0				__FD_DEPRECATED 0x000030d8


#define REG_A6XX_VBIF_PERF_CNT_LOW1				__FD_DEPRECATED 0x000030d9


#define REG_A6XX_VBIF_PERF_CNT_LOW2				__FD_DEPRECATED 0x000030da


#define REG_A6XX_VBIF_PERF_CNT_LOW3				__FD_DEPRECATED 0x000030db


#define REG_A6XX_VBIF_PERF_CNT_HIGH0				__FD_DEPRECATED 0x000030e0


#define REG_A6XX_VBIF_PERF_CNT_HIGH1				__FD_DEPRECATED 0x000030e1


#define REG_A6XX_VBIF_PERF_CNT_HIGH2				__FD_DEPRECATED 0x000030e2


#define REG_A6XX_VBIF_PERF_CNT_HIGH3				__FD_DEPRECATED 0x000030e3


#define REG_A6XX_VBIF_PERF_PWR_CNT_EN0				__FD_DEPRECATED 0x00003100


#define REG_A6XX_VBIF_PERF_PWR_CNT_EN1				__FD_DEPRECATED 0x00003101


#define REG_A6XX_VBIF_PERF_PWR_CNT_EN2				__FD_DEPRECATED 0x00003102


#define REG_A6XX_VBIF_PERF_PWR_CNT_LOW0				__FD_DEPRECATED 0x00003110


#define REG_A6XX_VBIF_PERF_PWR_CNT_LOW1				__FD_DEPRECATED 0x00003111


#define REG_A6XX_VBIF_PERF_PWR_CNT_LOW2				__FD_DEPRECATED 0x00003112


#define REG_A6XX_VBIF_PERF_PWR_CNT_HIGH0			__FD_DEPRECATED 0x00003118


#define REG_A6XX_VBIF_PERF_PWR_CNT_HIGH1			__FD_DEPRECATED 0x00003119


#define REG_A6XX_VBIF_PERF_PWR_CNT_HIGH2			__FD_DEPRECATED 0x0000311a


#define REG_A8XX_GBIF_CX_CONFIG					__FD_DEPRECATED 0x00003c00


#define REG_A6XX_GBIF_SCACHE_CNTL0				0x00003c01


#define REG_A6XX_GBIF_SCACHE_CNTL1				0x00003c02


#define REG_A6XX_GBIF_QSB_SIDE0					0x00003c03


#define REG_A6XX_GBIF_QSB_SIDE1					0x00003c04


#define REG_A6XX_GBIF_QSB_SIDE2					0x00003c05


#define REG_A6XX_GBIF_QSB_SIDE3					0x00003c06


#define REG_A6XX_GBIF_HALT					0x00003c45


#define REG_A6XX_GBIF_HALT_ACK					0x00003c46


#define REG_A8XX_GBIF_REINIT_ENABLE				__FD_DEPRECATED 0x00003c49


#define REG_A8XX_GBIF_REINIT_DONE				__FD_DEPRECATED 0x00003c4a


#define REG_A6XX_GBIF_PERF_PWR_CNT_EN				0x00003cc0


#define REG_A6XX_GBIF_PERF_PWR_CNT_CLR				0x00003cc1


#define REG_A6XX_GBIF_PERF_CNT_SEL				0x00003cc2


#define REG_A8XX_GBIF_PERF_CNT_SEL_1				__FD_DEPRECATED 0x00003cc3


#define REG_A6XX_GBIF_PERF_PWR_CNT_SEL				__FD_DEPRECATED 0x00003cc3


#define REG_A6XX_GBIF_PERF_CNT_LOW0				__FD_DEPRECATED 0x00003cc4


#define REG_A6XX_GBIF_PERF_CNT_LOW1				__FD_DEPRECATED 0x00003cc5


#define REG_A6XX_GBIF_PERF_CNT_LOW2				__FD_DEPRECATED 0x00003cc6


#define REG_A6XX_GBIF_PERF_CNT_LOW3				__FD_DEPRECATED 0x00003cc7


#define REG_A6XX_GBIF_PERF_CNT_HIGH0				__FD_DEPRECATED 0x00003cc8


#define REG_A6XX_GBIF_PERF_CNT_HIGH1				__FD_DEPRECATED 0x00003cc9


#define REG_A6XX_GBIF_PERF_CNT_HIGH2				__FD_DEPRECATED 0x00003cca


#define REG_A6XX_GBIF_PERF_CNT_HIGH3				__FD_DEPRECATED 0x00003ccb


#define REG_A6XX_GBIF_PWR_CNT_LOW0				__FD_DEPRECATED 0x00003ccc


#define REG_A6XX_GBIF_PWR_CNT_LOW1				__FD_DEPRECATED 0x00003ccd


#define REG_A6XX_GBIF_PWR_CNT_LOW2				__FD_DEPRECATED 0x00003cce


#define REG_A6XX_GBIF_PWR_CNT_HIGH0				__FD_DEPRECATED 0x00003ccf


#define REG_A6XX_GBIF_PWR_CNT_HIGH1				__FD_DEPRECATED 0x00003cd0


#define REG_A6XX_GBIF_PWR_CNT_HIGH2				__FD_DEPRECATED 0x00003cd1


#define REG_A8XX_GBIF_PWR_CNT_SEL				__FD_DEPRECATED 0x00003cc4


#define REG_A8XX_GBIF_PERF_CNT_LO_0				__FD_DEPRECATED 0x00003cc6


#define REG_A8XX_GBIF_PERF_CNT_HI_0				__FD_DEPRECATED 0x00003cc7


#define REG_A8XX_GBIF_PERF_CNT_LO_1				__FD_DEPRECATED 0x00003cc8


#define REG_A8XX_GBIF_PERF_CNT_HI_1				__FD_DEPRECATED 0x00003cc9


#define REG_A8XX_GBIF_PERF_CNT_LO_2				__FD_DEPRECATED 0x00003cca


#define REG_A8XX_GBIF_PERF_CNT_HI_2				__FD_DEPRECATED 0x00003ccb


#define REG_A8XX_GBIF_PERF_CNT_LO_3				__FD_DEPRECATED 0x00003ccc


#define REG_A8XX_GBIF_PERF_CNT_HI_3				__FD_DEPRECATED 0x00003ccd


#define REG_A8XX_GBIF_PERF_CNT_LO_4				__FD_DEPRECATED 0x00003cce


#define REG_A8XX_GBIF_PERF_CNT_HI_4				__FD_DEPRECATED 0x00003ccf


#define REG_A8XX_GBIF_PERF_CNT_LO_5				__FD_DEPRECATED 0x00003cd0


#define REG_A8XX_GBIF_PERF_CNT_HI_5				__FD_DEPRECATED 0x00003cd1


#define REG_A8XX_GBIF_PERF_CNT_LO_6				__FD_DEPRECATED 0x00003cd2


#define REG_A8XX_GBIF_PERF_CNT_HI_6				__FD_DEPRECATED 0x00003cd3


#define REG_A8XX_GBIF_PERF_CNT_LO_7				__FD_DEPRECATED 0x00003cd4


#define REG_A8XX_GBIF_PERF_CNT_HI_7				__FD_DEPRECATED 0x00003cd5


#define REG_A8XX_GBIF_PWR_CNT_LO_0				__FD_DEPRECATED 0x00003ce0


#define REG_A8XX_GBIF_PWR_CNT_LO_1				__FD_DEPRECATED 0x00003ce1


#define REG_A8XX_GBIF_PWR_CNT_LO_2				__FD_DEPRECATED 0x00003ce2


#define REG_A8XX_GBIF_PWR_CNT_HI_0				__FD_DEPRECATED 0x00003ce3


#define REG_A8XX_GBIF_PWR_CNT_HI_1				__FD_DEPRECATED 0x00003ce4


#define REG_A8XX_GBIF_PWR_CNT_HI_2				__FD_DEPRECATED 0x00003ce5


#define REG_A6XX_VSC_DBG_ECO_CNTL				0x00000c00


#define REG_A8XX_VSC_KMD_DBG_ECO_CNTL				__FD_DEPRECATED 0x00000df0


#define REG_A6XX_VSC_BIN_SIZE					__FD_DEPRECATED 0x00000c02
#define A6XX_VSC_BIN_SIZE_BINW__MASK				0x000000ffull
#define A6XX_VSC_BIN_SIZE_BINW__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_VSC_BIN_SIZE_BINW(uint32_t val)
{
	assert(!(val & 0x1f));
	return (((val >> 5)) << A6XX_VSC_BIN_SIZE_BINW__SHIFT) & A6XX_VSC_BIN_SIZE_BINW__MASK;
}
#define A6XX_VSC_BIN_SIZE_BINH__MASK				0x0001ff00ull
#define A6XX_VSC_BIN_SIZE_BINH__SHIFT				8
static CONSTEXPR inline uint32_t A6XX_VSC_BIN_SIZE_BINH(uint32_t val)
{
	assert(!(val & 0xf));
	return (((val >> 4)) << A6XX_VSC_BIN_SIZE_BINH__SHIFT) & A6XX_VSC_BIN_SIZE_BINH__MASK;
}


#define REG_A8XX_VSC_BIN_SIZE					__FD_DEPRECATED 0x00000c02
#define A8XX_VSC_BIN_SIZE_BINW__MASK				0x000003ffull
#define A8XX_VSC_BIN_SIZE_BINW__SHIFT				0
static CONSTEXPR inline uint32_t A8XX_VSC_BIN_SIZE_BINW(uint32_t val)
{
	assert(!(val & 0x1f));
	return (((val >> 5)) << A8XX_VSC_BIN_SIZE_BINW__SHIFT) & A8XX_VSC_BIN_SIZE_BINW__MASK;
}
#define A8XX_VSC_BIN_SIZE_BINH__MASK				0x07ff0000ull
#define A8XX_VSC_BIN_SIZE_BINH__SHIFT				16
static CONSTEXPR inline uint32_t A8XX_VSC_BIN_SIZE_BINH(uint32_t val)
{
	assert(!(val & 0xf));
	return (((val >> 4)) << A8XX_VSC_BIN_SIZE_BINH__SHIFT) & A8XX_VSC_BIN_SIZE_BINH__MASK;
}


#define REG_A6XX_VSC_SIZE_BASE					0x00000c03
static CONSTEXPR inline uint32_t A6XX_VSC_SIZE_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_VSC_SIZE_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_VSC_EXPANDED_BIN_CNTL				0x00000c06
#define A6XX_VSC_EXPANDED_BIN_CNTL_NX__MASK			0x000007feull
#define A6XX_VSC_EXPANDED_BIN_CNTL_NX__SHIFT			1
static CONSTEXPR inline uint32_t A6XX_VSC_EXPANDED_BIN_CNTL_NX(uint32_t val)
{
	return ((val) << A6XX_VSC_EXPANDED_BIN_CNTL_NX__SHIFT) & A6XX_VSC_EXPANDED_BIN_CNTL_NX__MASK;
}
#define A6XX_VSC_EXPANDED_BIN_CNTL_NY__MASK			0x001ff800ull
#define A6XX_VSC_EXPANDED_BIN_CNTL_NY__SHIFT			11
static CONSTEXPR inline uint32_t A6XX_VSC_EXPANDED_BIN_CNTL_NY(uint32_t val)
{
	return ((val) << A6XX_VSC_EXPANDED_BIN_CNTL_NY__SHIFT) & A6XX_VSC_EXPANDED_BIN_CNTL_NY__MASK;
}


#define REG_A6XX_VSC_PIPE_CONFIG(i0)				(0x00000c10 + 0x1*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_VSC_PIPE_CONFIG_REG(uint32_t i0) { return 0x00000c10 + 0x1*i0; }
#define A6XX_VSC_PIPE_CONFIG_REG_X__MASK			0x000003ffull
#define A6XX_VSC_PIPE_CONFIG_REG_X__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VSC_PIPE_CONFIG_REG_X(uint32_t val)
{
	return ((val) << A6XX_VSC_PIPE_CONFIG_REG_X__SHIFT) & A6XX_VSC_PIPE_CONFIG_REG_X__MASK;
}
#define A6XX_VSC_PIPE_CONFIG_REG_Y__MASK			0x000ffc00ull
#define A6XX_VSC_PIPE_CONFIG_REG_Y__SHIFT			10
static CONSTEXPR inline uint32_t A6XX_VSC_PIPE_CONFIG_REG_Y(uint32_t val)
{
	return ((val) << A6XX_VSC_PIPE_CONFIG_REG_Y__SHIFT) & A6XX_VSC_PIPE_CONFIG_REG_Y__MASK;
}
#define A6XX_VSC_PIPE_CONFIG_REG_W__MASK			0x03f00000ull
#define A6XX_VSC_PIPE_CONFIG_REG_W__SHIFT			20
static CONSTEXPR inline uint32_t A6XX_VSC_PIPE_CONFIG_REG_W(uint32_t val)
{
	return ((val) << A6XX_VSC_PIPE_CONFIG_REG_W__SHIFT) & A6XX_VSC_PIPE_CONFIG_REG_W__MASK;
}
#define A6XX_VSC_PIPE_CONFIG_REG_H__MASK			0xfc000000ull
#define A6XX_VSC_PIPE_CONFIG_REG_H__SHIFT			26
static CONSTEXPR inline uint32_t A6XX_VSC_PIPE_CONFIG_REG_H(uint32_t val)
{
	return ((val) << A6XX_VSC_PIPE_CONFIG_REG_H__SHIFT) & A6XX_VSC_PIPE_CONFIG_REG_H__MASK;
}


#define REG_A6XX_VSC_PIPE_DATA_PRIM_BASE			0x00000c30
static CONSTEXPR inline uint32_t A6XX_VSC_PIPE_DATA_PRIM_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_VSC_PIPE_DATA_PRIM_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_VSC_PIPE_DATA_PRIM_STRIDE			0x00000c32


#define REG_A6XX_VSC_PIPE_DATA_PRIM_LENGTH			0x00000c33


#define REG_A6XX_VSC_PIPE_DATA_DRAW_BASE			0x00000c34
static CONSTEXPR inline uint32_t A6XX_VSC_PIPE_DATA_DRAW_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_VSC_PIPE_DATA_DRAW_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_VSC_PIPE_DATA_DRAW_STRIDE			0x00000c36


#define REG_A6XX_VSC_PIPE_DATA_DRAW_LENGTH			0x00000c37


#define REG_A6XX_VSC_CHANNEL_VISIBILITY(i0)			(0x00000c38 + 0x1*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_VSC_CHANNEL_VISIBILITY_REG(uint32_t i0) { return 0x00000c38 + 0x1*i0; }


#define REG_A6XX_VSC_PIPE_DATA_PRIM_SIZE(i0)			(0x00000c58 + 0x1*i0 )



#define REG_A6XX_VSC_PIPE_DATA_DRAW_SIZE(i0)			(0x00000c78 + 0x1*i0 )



#define REG_A7XX_VSC_UNKNOWN_0D08				__FD_DEPRECATED 0x00000d08


#define REG_A7XX_UCHE_UNKNOWN_0E10				__FD_DEPRECATED 0x00000e10


#define REG_A8XX_UCHE_VARB_IDLE_TIMEOUT				__FD_DEPRECATED 0x00000e10


#define REG_A7XX_UCHE_UNKNOWN_0E11				__FD_DEPRECATED 0x00000e11


#define REG_A8XX_UCHE_CLIENT_PF					__FD_DEPRECATED 0x00000e11


#define REG_A6XX_UCHE_UNKNOWN_0E12				__FD_DEPRECATED 0x00000e12


#define REG_A8XX_UCHE_DBG_ECO_CNTL_0				__FD_DEPRECATED 0x00000e15


#define REG_A8XX_UCHE_HW_DBG_CNTL				__FD_DEPRECATED 0x00000e16


#define REG_A6XX_GRAS_CL_CNTL					__FD_DEPRECATED 0x00008000
#define A6XX_GRAS_CL_CNTL_CLIP_DISABLE				0x00000001
#define A6XX_GRAS_CL_CNTL_ZNEAR_CLIP_DISABLE			0x00000002
#define A6XX_GRAS_CL_CNTL_ZFAR_CLIP_DISABLE			0x00000004
#define A6XX_GRAS_CL_CNTL_Z_CLAMP_ENABLE			0x00000020
#define A6XX_GRAS_CL_CNTL_ZERO_GB_SCALE_Z			0x00000040
#define A6XX_GRAS_CL_CNTL_VP_CLIP_CODE_IGNORE			0x00000080
#define A6XX_GRAS_CL_CNTL_VP_XFORM_DISABLE			0x00000100
#define A6XX_GRAS_CL_CNTL_PERSP_DIVISION_DISABLE		0x00000200


#define REG_A8XX_GRAS_CL_CNTL					__FD_DEPRECATED 0x00008200
#define A8XX_GRAS_CL_CNTL_CLIP_DISABLE				0x00000001
#define A8XX_GRAS_CL_CNTL_ZNEAR_CLIP_DISABLE			0x00000002
#define A8XX_GRAS_CL_CNTL_ZFAR_CLIP_DISABLE			0x00000004
#define A8XX_GRAS_CL_CNTL_Z_CLAMP_ENABLE			0x00000020
#define A8XX_GRAS_CL_CNTL_ZERO_GB_SCALE_Z			0x00000040
#define A8XX_GRAS_CL_CNTL_VP_CLIP_CODE_IGNORE			0x00000080
#define A8XX_GRAS_CL_CNTL_VP_XFORM_DISABLE			0x00000100
#define A8XX_GRAS_CL_CNTL_PERSP_DIVISION_DISABLE		0x00000200


#define REG_A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE			__FD_DEPRECATED 0x00008001
#define A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CLIP_MASK__MASK	0x000000ffull
#define A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CLIP_MASK__SHIFT	0
static CONSTEXPR inline uint32_t A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CLIP_MASK(uint32_t val)
{
	return ((val) << A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CLIP_MASK__SHIFT) & A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CLIP_MASK__MASK;
}
#define A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CULL_MASK__MASK	0x0000ff00ull
#define A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CULL_MASK__SHIFT	8
static CONSTEXPR inline uint32_t A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CULL_MASK(uint32_t val)
{
	return ((val) << A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CULL_MASK__SHIFT) & A6XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CULL_MASK__MASK;
}


#define REG_A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE			__FD_DEPRECATED 0x00008002
#define A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CLIP_MASK__MASK	0x000000ffull
#define A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CLIP_MASK__SHIFT	0
static CONSTEXPR inline uint32_t A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CLIP_MASK(uint32_t val)
{
	return ((val) << A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CLIP_MASK__SHIFT) & A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CLIP_MASK__MASK;
}
#define A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CULL_MASK__MASK	0x0000ff00ull
#define A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CULL_MASK__SHIFT	8
static CONSTEXPR inline uint32_t A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CULL_MASK(uint32_t val)
{
	return ((val) << A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CULL_MASK__SHIFT) & A6XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CULL_MASK__MASK;
}


#define REG_A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE			__FD_DEPRECATED 0x00008003
#define A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CLIP_MASK__MASK	0x000000ffull
#define A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CLIP_MASK__SHIFT	0
static CONSTEXPR inline uint32_t A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CLIP_MASK(uint32_t val)
{
	return ((val) << A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CLIP_MASK__SHIFT) & A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CLIP_MASK__MASK;
}
#define A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CULL_MASK__MASK	0x0000ff00ull
#define A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CULL_MASK__SHIFT	8
static CONSTEXPR inline uint32_t A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CULL_MASK(uint32_t val)
{
	return ((val) << A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CULL_MASK__SHIFT) & A6XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CULL_MASK__MASK;
}


#define REG_A6XX_GRAS_CL_ARRAY_SIZE				__FD_DEPRECATED 0x00008004


#define REG_A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE			__FD_DEPRECATED 0x00008201
#define A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CLIP_MASK__MASK	0x000000ffull
#define A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CLIP_MASK__SHIFT	0
static CONSTEXPR inline uint32_t A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CLIP_MASK(uint32_t val)
{
	return ((val) << A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CLIP_MASK__SHIFT) & A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CLIP_MASK__MASK;
}
#define A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CULL_MASK__MASK	0x0000ff00ull
#define A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CULL_MASK__SHIFT	8
static CONSTEXPR inline uint32_t A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CULL_MASK(uint32_t val)
{
	return ((val) << A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CULL_MASK__SHIFT) & A8XX_GRAS_CL_VS_CLIP_CULL_DISTANCE_CULL_MASK__MASK;
}


#define REG_A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE			__FD_DEPRECATED 0x00008202
#define A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CLIP_MASK__MASK	0x000000ffull
#define A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CLIP_MASK__SHIFT	0
static CONSTEXPR inline uint32_t A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CLIP_MASK(uint32_t val)
{
	return ((val) << A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CLIP_MASK__SHIFT) & A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CLIP_MASK__MASK;
}
#define A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CULL_MASK__MASK	0x0000ff00ull
#define A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CULL_MASK__SHIFT	8
static CONSTEXPR inline uint32_t A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CULL_MASK(uint32_t val)
{
	return ((val) << A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CULL_MASK__SHIFT) & A8XX_GRAS_CL_DS_CLIP_CULL_DISTANCE_CULL_MASK__MASK;
}


#define REG_A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE			__FD_DEPRECATED 0x00008203
#define A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CLIP_MASK__MASK	0x000000ffull
#define A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CLIP_MASK__SHIFT	0
static CONSTEXPR inline uint32_t A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CLIP_MASK(uint32_t val)
{
	return ((val) << A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CLIP_MASK__SHIFT) & A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CLIP_MASK__MASK;
}
#define A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CULL_MASK__MASK	0x0000ff00ull
#define A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CULL_MASK__SHIFT	8
static CONSTEXPR inline uint32_t A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CULL_MASK(uint32_t val)
{
	return ((val) << A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CULL_MASK__SHIFT) & A8XX_GRAS_CL_GS_CLIP_CULL_DISTANCE_CULL_MASK__MASK;
}


#define REG_A8XX_GRAS_CL_ARRAY_SIZE				__FD_DEPRECATED 0x00008204


#define REG_A6XX_GRAS_CL_INTERP_CNTL				__FD_DEPRECATED 0x00008005
#define A6XX_GRAS_CL_INTERP_CNTL_IJ_PERSP_PIXEL			0x00000001
#define A6XX_GRAS_CL_INTERP_CNTL_IJ_PERSP_CENTROID		0x00000002
#define A6XX_GRAS_CL_INTERP_CNTL_IJ_PERSP_SAMPLE		0x00000004
#define A6XX_GRAS_CL_INTERP_CNTL_IJ_LINEAR_PIXEL		0x00000008
#define A6XX_GRAS_CL_INTERP_CNTL_IJ_LINEAR_CENTROID		0x00000010
#define A6XX_GRAS_CL_INTERP_CNTL_IJ_LINEAR_SAMPLE		0x00000020
#define A6XX_GRAS_CL_INTERP_CNTL_COORD_MASK__MASK		0x000003c0ull
#define A6XX_GRAS_CL_INTERP_CNTL_COORD_MASK__SHIFT		6
static CONSTEXPR inline uint32_t A6XX_GRAS_CL_INTERP_CNTL_COORD_MASK(uint32_t val)
{
	return ((val) << A6XX_GRAS_CL_INTERP_CNTL_COORD_MASK__SHIFT) & A6XX_GRAS_CL_INTERP_CNTL_COORD_MASK__MASK;
}
#define A6XX_GRAS_CL_INTERP_CNTL_UNK10				0x00000400
#define A6XX_GRAS_CL_INTERP_CNTL_UNK11				0x00000800


#define REG_A8XX_GRAS_CL_INTERP_CNTL				__FD_DEPRECATED 0x00008080
#define A8XX_GRAS_CL_INTERP_CNTL_IJ_PERSP_PIXEL			0x00000001
#define A8XX_GRAS_CL_INTERP_CNTL_IJ_PERSP_CENTROID		0x00000002
#define A8XX_GRAS_CL_INTERP_CNTL_IJ_PERSP_SAMPLE		0x00000004
#define A8XX_GRAS_CL_INTERP_CNTL_IJ_LINEAR_PIXEL		0x00000008
#define A8XX_GRAS_CL_INTERP_CNTL_IJ_LINEAR_CENTROID		0x00000010
#define A8XX_GRAS_CL_INTERP_CNTL_IJ_LINEAR_SAMPLE		0x00000020
#define A8XX_GRAS_CL_INTERP_CNTL_COORD_MASK__MASK		0x000003c0ull
#define A8XX_GRAS_CL_INTERP_CNTL_COORD_MASK__SHIFT		6
static CONSTEXPR inline uint32_t A8XX_GRAS_CL_INTERP_CNTL_COORD_MASK(uint32_t val)
{
	return ((val) << A8XX_GRAS_CL_INTERP_CNTL_COORD_MASK__SHIFT) & A8XX_GRAS_CL_INTERP_CNTL_COORD_MASK__MASK;
}
#define A8XX_GRAS_CL_INTERP_CNTL_UNK10				0x00000400
#define A8XX_GRAS_CL_INTERP_CNTL_UNK11				0x00000800


#define REG_A6XX_GRAS_CL_GUARDBAND_CLIP_ADJ			__FD_DEPRECATED 0x00008006

#define REG_A8XX_GRAS_CL_GUARDBAND_CLIP_ADJ			__FD_DEPRECATED 0x00008205

#define REG_A7XX_GRAS_BIN_FOVEAT				__FD_DEPRECATED 0x00008008
#define A7XX_GRAS_BIN_FOVEAT_BINSCALEEN				0x00000040
#define A7XX_GRAS_BIN_FOVEAT_XSCALE_0__MASK			0x00000300ull
#define A7XX_GRAS_BIN_FOVEAT_XSCALE_0__SHIFT			8
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_XSCALE_0(enum a7xx_bin_scale val)
{
	return ((val) << A7XX_GRAS_BIN_FOVEAT_XSCALE_0__SHIFT) & A7XX_GRAS_BIN_FOVEAT_XSCALE_0__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_YSCALE_0__MASK			0x00000c00ull
#define A7XX_GRAS_BIN_FOVEAT_YSCALE_0__SHIFT			10
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_YSCALE_0(enum a7xx_bin_scale val)
{
	return ((val) << A7XX_GRAS_BIN_FOVEAT_YSCALE_0__SHIFT) & A7XX_GRAS_BIN_FOVEAT_YSCALE_0__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_XSCALE_1__MASK			0x00003000ull
#define A7XX_GRAS_BIN_FOVEAT_XSCALE_1__SHIFT			12
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_XSCALE_1(enum a7xx_bin_scale val)
{
	return ((val) << A7XX_GRAS_BIN_FOVEAT_XSCALE_1__SHIFT) & A7XX_GRAS_BIN_FOVEAT_XSCALE_1__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_YSCALE_1__MASK			0x0000c000ull
#define A7XX_GRAS_BIN_FOVEAT_YSCALE_1__SHIFT			14
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_YSCALE_1(enum a7xx_bin_scale val)
{
	return ((val) << A7XX_GRAS_BIN_FOVEAT_YSCALE_1__SHIFT) & A7XX_GRAS_BIN_FOVEAT_YSCALE_1__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_XSCALE_2__MASK			0x00030000ull
#define A7XX_GRAS_BIN_FOVEAT_XSCALE_2__SHIFT			16
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_XSCALE_2(enum a7xx_bin_scale val)
{
	return ((val) << A7XX_GRAS_BIN_FOVEAT_XSCALE_2__SHIFT) & A7XX_GRAS_BIN_FOVEAT_XSCALE_2__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_YSCALE_2__MASK			0x000c0000ull
#define A7XX_GRAS_BIN_FOVEAT_YSCALE_2__SHIFT			18
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_YSCALE_2(enum a7xx_bin_scale val)
{
	return ((val) << A7XX_GRAS_BIN_FOVEAT_YSCALE_2__SHIFT) & A7XX_GRAS_BIN_FOVEAT_YSCALE_2__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_XSCALE_3__MASK			0x00300000ull
#define A7XX_GRAS_BIN_FOVEAT_XSCALE_3__SHIFT			20
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_XSCALE_3(enum a7xx_bin_scale val)
{
	return ((val) << A7XX_GRAS_BIN_FOVEAT_XSCALE_3__SHIFT) & A7XX_GRAS_BIN_FOVEAT_XSCALE_3__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_YSCALE_3__MASK			0x00c00000ull
#define A7XX_GRAS_BIN_FOVEAT_YSCALE_3__SHIFT			22
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_YSCALE_3(enum a7xx_bin_scale val)
{
	return ((val) << A7XX_GRAS_BIN_FOVEAT_YSCALE_3__SHIFT) & A7XX_GRAS_BIN_FOVEAT_YSCALE_3__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_XSCALE_4__MASK			0x03000000ull
#define A7XX_GRAS_BIN_FOVEAT_XSCALE_4__SHIFT			24
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_XSCALE_4(enum a7xx_bin_scale val)
{
	return ((val) << A7XX_GRAS_BIN_FOVEAT_XSCALE_4__SHIFT) & A7XX_GRAS_BIN_FOVEAT_XSCALE_4__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_YSCALE_4__MASK			0x0c000000ull
#define A7XX_GRAS_BIN_FOVEAT_YSCALE_4__SHIFT			26
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_YSCALE_4(enum a7xx_bin_scale val)
{
	return ((val) << A7XX_GRAS_BIN_FOVEAT_YSCALE_4__SHIFT) & A7XX_GRAS_BIN_FOVEAT_YSCALE_4__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_XSCALE_5__MASK			0x30000000ull
#define A7XX_GRAS_BIN_FOVEAT_XSCALE_5__SHIFT			28
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_XSCALE_5(enum a7xx_bin_scale val)
{
	return ((val) << A7XX_GRAS_BIN_FOVEAT_XSCALE_5__SHIFT) & A7XX_GRAS_BIN_FOVEAT_XSCALE_5__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_YSCALE_5__MASK			0xc0000000ull
#define A7XX_GRAS_BIN_FOVEAT_YSCALE_5__SHIFT			30
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_YSCALE_5(enum a7xx_bin_scale val)
{
	return ((val) << A7XX_GRAS_BIN_FOVEAT_YSCALE_5__SHIFT) & A7XX_GRAS_BIN_FOVEAT_YSCALE_5__MASK;
}


#define REG_A8XX_GRAS_BIN_FOVEAT				__FD_DEPRECATED 0x00008206
#define A8XX_GRAS_BIN_FOVEAT_BINSCALEEN				0x00000040
#define A8XX_GRAS_BIN_FOVEAT_XSCALE_0__MASK			0x00000300ull
#define A8XX_GRAS_BIN_FOVEAT_XSCALE_0__SHIFT			8
static CONSTEXPR inline uint32_t A8XX_GRAS_BIN_FOVEAT_XSCALE_0(enum a7xx_bin_scale val)
{
	return ((val) << A8XX_GRAS_BIN_FOVEAT_XSCALE_0__SHIFT) & A8XX_GRAS_BIN_FOVEAT_XSCALE_0__MASK;
}
#define A8XX_GRAS_BIN_FOVEAT_YSCALE_0__MASK			0x00000c00ull
#define A8XX_GRAS_BIN_FOVEAT_YSCALE_0__SHIFT			10
static CONSTEXPR inline uint32_t A8XX_GRAS_BIN_FOVEAT_YSCALE_0(enum a7xx_bin_scale val)
{
	return ((val) << A8XX_GRAS_BIN_FOVEAT_YSCALE_0__SHIFT) & A8XX_GRAS_BIN_FOVEAT_YSCALE_0__MASK;
}
#define A8XX_GRAS_BIN_FOVEAT_XSCALE_1__MASK			0x00003000ull
#define A8XX_GRAS_BIN_FOVEAT_XSCALE_1__SHIFT			12
static CONSTEXPR inline uint32_t A8XX_GRAS_BIN_FOVEAT_XSCALE_1(enum a7xx_bin_scale val)
{
	return ((val) << A8XX_GRAS_BIN_FOVEAT_XSCALE_1__SHIFT) & A8XX_GRAS_BIN_FOVEAT_XSCALE_1__MASK;
}
#define A8XX_GRAS_BIN_FOVEAT_YSCALE_1__MASK			0x0000c000ull
#define A8XX_GRAS_BIN_FOVEAT_YSCALE_1__SHIFT			14
static CONSTEXPR inline uint32_t A8XX_GRAS_BIN_FOVEAT_YSCALE_1(enum a7xx_bin_scale val)
{
	return ((val) << A8XX_GRAS_BIN_FOVEAT_YSCALE_1__SHIFT) & A8XX_GRAS_BIN_FOVEAT_YSCALE_1__MASK;
}
#define A8XX_GRAS_BIN_FOVEAT_XSCALE_2__MASK			0x00030000ull
#define A8XX_GRAS_BIN_FOVEAT_XSCALE_2__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_GRAS_BIN_FOVEAT_XSCALE_2(enum a7xx_bin_scale val)
{
	return ((val) << A8XX_GRAS_BIN_FOVEAT_XSCALE_2__SHIFT) & A8XX_GRAS_BIN_FOVEAT_XSCALE_2__MASK;
}
#define A8XX_GRAS_BIN_FOVEAT_YSCALE_2__MASK			0x000c0000ull
#define A8XX_GRAS_BIN_FOVEAT_YSCALE_2__SHIFT			18
static CONSTEXPR inline uint32_t A8XX_GRAS_BIN_FOVEAT_YSCALE_2(enum a7xx_bin_scale val)
{
	return ((val) << A8XX_GRAS_BIN_FOVEAT_YSCALE_2__SHIFT) & A8XX_GRAS_BIN_FOVEAT_YSCALE_2__MASK;
}
#define A8XX_GRAS_BIN_FOVEAT_XSCALE_3__MASK			0x00300000ull
#define A8XX_GRAS_BIN_FOVEAT_XSCALE_3__SHIFT			20
static CONSTEXPR inline uint32_t A8XX_GRAS_BIN_FOVEAT_XSCALE_3(enum a7xx_bin_scale val)
{
	return ((val) << A8XX_GRAS_BIN_FOVEAT_XSCALE_3__SHIFT) & A8XX_GRAS_BIN_FOVEAT_XSCALE_3__MASK;
}
#define A8XX_GRAS_BIN_FOVEAT_YSCALE_3__MASK			0x00c00000ull
#define A8XX_GRAS_BIN_FOVEAT_YSCALE_3__SHIFT			22
static CONSTEXPR inline uint32_t A8XX_GRAS_BIN_FOVEAT_YSCALE_3(enum a7xx_bin_scale val)
{
	return ((val) << A8XX_GRAS_BIN_FOVEAT_YSCALE_3__SHIFT) & A8XX_GRAS_BIN_FOVEAT_YSCALE_3__MASK;
}
#define A8XX_GRAS_BIN_FOVEAT_XSCALE_4__MASK			0x03000000ull
#define A8XX_GRAS_BIN_FOVEAT_XSCALE_4__SHIFT			24
static CONSTEXPR inline uint32_t A8XX_GRAS_BIN_FOVEAT_XSCALE_4(enum a7xx_bin_scale val)
{
	return ((val) << A8XX_GRAS_BIN_FOVEAT_XSCALE_4__SHIFT) & A8XX_GRAS_BIN_FOVEAT_XSCALE_4__MASK;
}
#define A8XX_GRAS_BIN_FOVEAT_YSCALE_4__MASK			0x0c000000ull
#define A8XX_GRAS_BIN_FOVEAT_YSCALE_4__SHIFT			26
static CONSTEXPR inline uint32_t A8XX_GRAS_BIN_FOVEAT_YSCALE_4(enum a7xx_bin_scale val)
{
	return ((val) << A8XX_GRAS_BIN_FOVEAT_YSCALE_4__SHIFT) & A8XX_GRAS_BIN_FOVEAT_YSCALE_4__MASK;
}
#define A8XX_GRAS_BIN_FOVEAT_XSCALE_5__MASK			0x30000000ull
#define A8XX_GRAS_BIN_FOVEAT_XSCALE_5__SHIFT			28
static CONSTEXPR inline uint32_t A8XX_GRAS_BIN_FOVEAT_XSCALE_5(enum a7xx_bin_scale val)
{
	return ((val) << A8XX_GRAS_BIN_FOVEAT_XSCALE_5__SHIFT) & A8XX_GRAS_BIN_FOVEAT_XSCALE_5__MASK;
}
#define A8XX_GRAS_BIN_FOVEAT_YSCALE_5__MASK			0xc0000000ull
#define A8XX_GRAS_BIN_FOVEAT_YSCALE_5__SHIFT			30
static CONSTEXPR inline uint32_t A8XX_GRAS_BIN_FOVEAT_YSCALE_5(enum a7xx_bin_scale val)
{
	return ((val) << A8XX_GRAS_BIN_FOVEAT_YSCALE_5__SHIFT) & A8XX_GRAS_BIN_FOVEAT_YSCALE_5__MASK;
}


#define REG_A7XX_GRAS_BIN_FOVEAT_OFFSET_0			__FD_DEPRECATED 0x00008009
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_0_XOFFSET_0__MASK		0x000003ffull
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_0_XOFFSET_0__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_OFFSET_0_XOFFSET_0(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A7XX_GRAS_BIN_FOVEAT_OFFSET_0_XOFFSET_0__SHIFT) & A7XX_GRAS_BIN_FOVEAT_OFFSET_0_XOFFSET_0__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_0_XOFFSET_1__MASK		0x000ffc00ull
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_0_XOFFSET_1__SHIFT		10
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_OFFSET_0_XOFFSET_1(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A7XX_GRAS_BIN_FOVEAT_OFFSET_0_XOFFSET_1__SHIFT) & A7XX_GRAS_BIN_FOVEAT_OFFSET_0_XOFFSET_1__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_0_XOFFSET_2__MASK		0x3ff00000ull
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_0_XOFFSET_2__SHIFT		20
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_OFFSET_0_XOFFSET_2(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A7XX_GRAS_BIN_FOVEAT_OFFSET_0_XOFFSET_2__SHIFT) & A7XX_GRAS_BIN_FOVEAT_OFFSET_0_XOFFSET_2__MASK;
}


#define REG_A7XX_GRAS_BIN_FOVEAT_OFFSET_1			__FD_DEPRECATED 0x0000800a
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_1_XOFFSET_3__MASK		0x000003ffull
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_1_XOFFSET_3__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_OFFSET_1_XOFFSET_3(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A7XX_GRAS_BIN_FOVEAT_OFFSET_1_XOFFSET_3__SHIFT) & A7XX_GRAS_BIN_FOVEAT_OFFSET_1_XOFFSET_3__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_1_XOFFSET_4__MASK		0x000ffc00ull
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_1_XOFFSET_4__SHIFT		10
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_OFFSET_1_XOFFSET_4(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A7XX_GRAS_BIN_FOVEAT_OFFSET_1_XOFFSET_4__SHIFT) & A7XX_GRAS_BIN_FOVEAT_OFFSET_1_XOFFSET_4__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_1_XOFFSET_5__MASK		0x3ff00000ull
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_1_XOFFSET_5__SHIFT		20
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_OFFSET_1_XOFFSET_5(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A7XX_GRAS_BIN_FOVEAT_OFFSET_1_XOFFSET_5__SHIFT) & A7XX_GRAS_BIN_FOVEAT_OFFSET_1_XOFFSET_5__MASK;
}


#define REG_A7XX_GRAS_BIN_FOVEAT_OFFSET_2			__FD_DEPRECATED 0x0000800b
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_2_YOFFSET_0__MASK		0x000003ffull
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_2_YOFFSET_0__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_OFFSET_2_YOFFSET_0(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A7XX_GRAS_BIN_FOVEAT_OFFSET_2_YOFFSET_0__SHIFT) & A7XX_GRAS_BIN_FOVEAT_OFFSET_2_YOFFSET_0__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_2_YOFFSET_1__MASK		0x000ffc00ull
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_2_YOFFSET_1__SHIFT		10
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_OFFSET_2_YOFFSET_1(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A7XX_GRAS_BIN_FOVEAT_OFFSET_2_YOFFSET_1__SHIFT) & A7XX_GRAS_BIN_FOVEAT_OFFSET_2_YOFFSET_1__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_2_YOFFSET_2__MASK		0x3ff00000ull
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_2_YOFFSET_2__SHIFT		20
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_OFFSET_2_YOFFSET_2(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A7XX_GRAS_BIN_FOVEAT_OFFSET_2_YOFFSET_2__SHIFT) & A7XX_GRAS_BIN_FOVEAT_OFFSET_2_YOFFSET_2__MASK;
}


#define REG_A7XX_GRAS_BIN_FOVEAT_OFFSET_3			__FD_DEPRECATED 0x0000800c
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_3_YOFFSET_3__MASK		0x000003ffull
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_3_YOFFSET_3__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_OFFSET_3_YOFFSET_3(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A7XX_GRAS_BIN_FOVEAT_OFFSET_3_YOFFSET_3__SHIFT) & A7XX_GRAS_BIN_FOVEAT_OFFSET_3_YOFFSET_3__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_3_YOFFSET_4__MASK		0x000ffc00ull
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_3_YOFFSET_4__SHIFT		10
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_OFFSET_3_YOFFSET_4(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A7XX_GRAS_BIN_FOVEAT_OFFSET_3_YOFFSET_4__SHIFT) & A7XX_GRAS_BIN_FOVEAT_OFFSET_3_YOFFSET_4__MASK;
}
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_3_YOFFSET_5__MASK		0x3ff00000ull
#define A7XX_GRAS_BIN_FOVEAT_OFFSET_3_YOFFSET_5__SHIFT		20
static CONSTEXPR inline uint32_t A7XX_GRAS_BIN_FOVEAT_OFFSET_3_YOFFSET_5(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A7XX_GRAS_BIN_FOVEAT_OFFSET_3_YOFFSET_5__SHIFT) & A7XX_GRAS_BIN_FOVEAT_OFFSET_3_YOFFSET_5__MASK;
}


#define REG_A8XX_GRAS_BIN_FOVEAT_XY(i0)				(0x00008220 + 0x1*i0 )

#define A8XX_GRAS_BIN_FOVEAT_XY_OFFSET_XOFFSET__MASK		0x00003fffull
#define A8XX_GRAS_BIN_FOVEAT_XY_OFFSET_XOFFSET__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_GRAS_BIN_FOVEAT_XY_OFFSET_XOFFSET(uint32_t val)
{
	return ((val) << A8XX_GRAS_BIN_FOVEAT_XY_OFFSET_XOFFSET__SHIFT) & A8XX_GRAS_BIN_FOVEAT_XY_OFFSET_XOFFSET__MASK;
}
#define A8XX_GRAS_BIN_FOVEAT_XY_OFFSET_YOFFSET__MASK		0x3fff0000ull
#define A8XX_GRAS_BIN_FOVEAT_XY_OFFSET_YOFFSET__SHIFT		16
static CONSTEXPR inline uint32_t A8XX_GRAS_BIN_FOVEAT_XY_OFFSET_YOFFSET(uint32_t val)
{
	return ((val) << A8XX_GRAS_BIN_FOVEAT_XY_OFFSET_YOFFSET__SHIFT) & A8XX_GRAS_BIN_FOVEAT_XY_OFFSET_YOFFSET__MASK;
}


#define REG_A8XX_GRAS_BIN_FOVEAT_XY_FDM(i0)			(0x00008228 + 0x1*i0 )

#define A8XX_GRAS_BIN_FOVEAT_XY_FDM_OFFSET_XOFFSET__MASK	0x00003fffull
#define A8XX_GRAS_BIN_FOVEAT_XY_FDM_OFFSET_XOFFSET__SHIFT	0
static CONSTEXPR inline uint32_t A8XX_GRAS_BIN_FOVEAT_XY_FDM_OFFSET_XOFFSET(uint32_t val)
{
	return ((val) << A8XX_GRAS_BIN_FOVEAT_XY_FDM_OFFSET_XOFFSET__SHIFT) & A8XX_GRAS_BIN_FOVEAT_XY_FDM_OFFSET_XOFFSET__MASK;
}
#define A8XX_GRAS_BIN_FOVEAT_XY_FDM_OFFSET_YOFFSET__MASK	0x3fff0000ull
#define A8XX_GRAS_BIN_FOVEAT_XY_FDM_OFFSET_YOFFSET__SHIFT	16
static CONSTEXPR inline uint32_t A8XX_GRAS_BIN_FOVEAT_XY_FDM_OFFSET_YOFFSET(uint32_t val)
{
	return ((val) << A8XX_GRAS_BIN_FOVEAT_XY_FDM_OFFSET_YOFFSET__SHIFT) & A8XX_GRAS_BIN_FOVEAT_XY_FDM_OFFSET_YOFFSET__MASK;
}


#define REG_A6XX_GRAS_CL_VIEWPORT(i0)				(0x00008010 + 0x6*i0 )

#define A6XX_GRAS_CL_VIEWPORT_XOFFSET__MASK			0xffffffffull
#define A6XX_GRAS_CL_VIEWPORT_XOFFSET__SHIFT			0
static inline uint32_t A6XX_GRAS_CL_VIEWPORT_XOFFSET(float val)
{
	return ((fui(val)) << A6XX_GRAS_CL_VIEWPORT_XOFFSET__SHIFT) & A6XX_GRAS_CL_VIEWPORT_XOFFSET__MASK;
}


#define A6XX_GRAS_CL_VIEWPORT_XSCALE__MASK			0xffffffffull
#define A6XX_GRAS_CL_VIEWPORT_XSCALE__SHIFT			0
static inline uint32_t A6XX_GRAS_CL_VIEWPORT_XSCALE(float val)
{
	return ((fui(val)) << A6XX_GRAS_CL_VIEWPORT_XSCALE__SHIFT) & A6XX_GRAS_CL_VIEWPORT_XSCALE__MASK;
}


#define A6XX_GRAS_CL_VIEWPORT_YOFFSET__MASK			0xffffffffull
#define A6XX_GRAS_CL_VIEWPORT_YOFFSET__SHIFT			0
static inline uint32_t A6XX_GRAS_CL_VIEWPORT_YOFFSET(float val)
{
	return ((fui(val)) << A6XX_GRAS_CL_VIEWPORT_YOFFSET__SHIFT) & A6XX_GRAS_CL_VIEWPORT_YOFFSET__MASK;
}


#define A6XX_GRAS_CL_VIEWPORT_YSCALE__MASK			0xffffffffull
#define A6XX_GRAS_CL_VIEWPORT_YSCALE__SHIFT			0
static inline uint32_t A6XX_GRAS_CL_VIEWPORT_YSCALE(float val)
{
	return ((fui(val)) << A6XX_GRAS_CL_VIEWPORT_YSCALE__SHIFT) & A6XX_GRAS_CL_VIEWPORT_YSCALE__MASK;
}


#define A6XX_GRAS_CL_VIEWPORT_ZOFFSET__MASK			0xffffffffull
#define A6XX_GRAS_CL_VIEWPORT_ZOFFSET__SHIFT			0
static inline uint32_t A6XX_GRAS_CL_VIEWPORT_ZOFFSET(float val)
{
	return ((fui(val)) << A6XX_GRAS_CL_VIEWPORT_ZOFFSET__SHIFT) & A6XX_GRAS_CL_VIEWPORT_ZOFFSET__MASK;
}


#define A6XX_GRAS_CL_VIEWPORT_ZSCALE__MASK			0xffffffffull
#define A6XX_GRAS_CL_VIEWPORT_ZSCALE__SHIFT			0
static inline uint32_t A6XX_GRAS_CL_VIEWPORT_ZSCALE(float val)
{
	return ((fui(val)) << A6XX_GRAS_CL_VIEWPORT_ZSCALE__SHIFT) & A6XX_GRAS_CL_VIEWPORT_ZSCALE__MASK;
}


#define REG_A8XX_GRAS_CL_VIEWPORT(i0)				(0x000082d0 + 0x6*i0 )

#define A8XX_GRAS_CL_VIEWPORT_XOFFSET__MASK			0xffffffffull
#define A8XX_GRAS_CL_VIEWPORT_XOFFSET__SHIFT			0
static inline uint32_t A8XX_GRAS_CL_VIEWPORT_XOFFSET(float val)
{
	return ((fui(val)) << A8XX_GRAS_CL_VIEWPORT_XOFFSET__SHIFT) & A8XX_GRAS_CL_VIEWPORT_XOFFSET__MASK;
}


#define A8XX_GRAS_CL_VIEWPORT_XSCALE__MASK			0xffffffffull
#define A8XX_GRAS_CL_VIEWPORT_XSCALE__SHIFT			0
static inline uint32_t A8XX_GRAS_CL_VIEWPORT_XSCALE(float val)
{
	return ((fui(val)) << A8XX_GRAS_CL_VIEWPORT_XSCALE__SHIFT) & A8XX_GRAS_CL_VIEWPORT_XSCALE__MASK;
}


#define A8XX_GRAS_CL_VIEWPORT_YOFFSET__MASK			0xffffffffull
#define A8XX_GRAS_CL_VIEWPORT_YOFFSET__SHIFT			0
static inline uint32_t A8XX_GRAS_CL_VIEWPORT_YOFFSET(float val)
{
	return ((fui(val)) << A8XX_GRAS_CL_VIEWPORT_YOFFSET__SHIFT) & A8XX_GRAS_CL_VIEWPORT_YOFFSET__MASK;
}


#define A8XX_GRAS_CL_VIEWPORT_YSCALE__MASK			0xffffffffull
#define A8XX_GRAS_CL_VIEWPORT_YSCALE__SHIFT			0
static inline uint32_t A8XX_GRAS_CL_VIEWPORT_YSCALE(float val)
{
	return ((fui(val)) << A8XX_GRAS_CL_VIEWPORT_YSCALE__SHIFT) & A8XX_GRAS_CL_VIEWPORT_YSCALE__MASK;
}


#define A8XX_GRAS_CL_VIEWPORT_ZOFFSET__MASK			0xffffffffull
#define A8XX_GRAS_CL_VIEWPORT_ZOFFSET__SHIFT			0
static inline uint32_t A8XX_GRAS_CL_VIEWPORT_ZOFFSET(float val)
{
	return ((fui(val)) << A8XX_GRAS_CL_VIEWPORT_ZOFFSET__SHIFT) & A8XX_GRAS_CL_VIEWPORT_ZOFFSET__MASK;
}


#define A8XX_GRAS_CL_VIEWPORT_ZSCALE__MASK			0xffffffffull
#define A8XX_GRAS_CL_VIEWPORT_ZSCALE__SHIFT			0
static inline uint32_t A8XX_GRAS_CL_VIEWPORT_ZSCALE(float val)
{
	return ((fui(val)) << A8XX_GRAS_CL_VIEWPORT_ZSCALE__SHIFT) & A8XX_GRAS_CL_VIEWPORT_ZSCALE__MASK;
}


#define REG_A6XX_GRAS_CL_VIEWPORT_ZCLAMP(i0)			(0x00008070 + 0x2*i0 )

#define A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN__MASK			0xffffffffull
#define A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN__SHIFT			0
static inline uint32_t A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN(float val)
{
	return ((fui(val)) << A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN__SHIFT) & A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN__MASK;
}


#define A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX__MASK			0xffffffffull
#define A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX__SHIFT			0
static inline uint32_t A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX(float val)
{
	return ((fui(val)) << A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX__SHIFT) & A6XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX__MASK;
}


#define REG_A8XX_GRAS_CL_VIEWPORT_ZCLAMP(i0)			(0x000080c0 + 0x2*i0 )

#define A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN__MASK			0xffffffffull
#define A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN__SHIFT			0
static inline uint32_t A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN(float val)
{
	return ((fui(val)) << A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN__SHIFT) & A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MIN__MASK;
}


#define A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX__MASK			0xffffffffull
#define A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX__SHIFT			0
static inline uint32_t A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX(float val)
{
	return ((fui(val)) << A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX__SHIFT) & A8XX_GRAS_CL_VIEWPORT_ZCLAMP_MAX__MASK;
}


#define REG_A6XX_GRAS_SU_CNTL					__FD_DEPRECATED 0x00008090
#define A6XX_GRAS_SU_CNTL_CULL_FRONT				0x00000001
#define A6XX_GRAS_SU_CNTL_CULL_BACK				0x00000002
#define A6XX_GRAS_SU_CNTL_FRONT_CW				0x00000004
#define A6XX_GRAS_SU_CNTL_LINEHALFWIDTH__MASK			0x000007f8ull
#define A6XX_GRAS_SU_CNTL_LINEHALFWIDTH__SHIFT			3
static inline uint32_t A6XX_GRAS_SU_CNTL_LINEHALFWIDTH(float val)
{
	return ((((int32_t)(val * 4.0))) << A6XX_GRAS_SU_CNTL_LINEHALFWIDTH__SHIFT) & A6XX_GRAS_SU_CNTL_LINEHALFWIDTH__MASK;
}
#define A6XX_GRAS_SU_CNTL_POLY_OFFSET				0x00000800
#define A6XX_GRAS_SU_CNTL_UNK12					0x00001000
#define A6XX_GRAS_SU_CNTL_LINE_MODE__MASK			0x00002000ull
#define A6XX_GRAS_SU_CNTL_LINE_MODE__SHIFT			13
static CONSTEXPR inline uint32_t A6XX_GRAS_SU_CNTL_LINE_MODE(enum a5xx_line_mode val)
{
	return ((val) << A6XX_GRAS_SU_CNTL_LINE_MODE__SHIFT) & A6XX_GRAS_SU_CNTL_LINE_MODE__MASK;
}
#define A6XX_GRAS_SU_CNTL_UNK15__MASK				0x00018000ull
#define A6XX_GRAS_SU_CNTL_UNK15__SHIFT				15
static CONSTEXPR inline uint32_t A6XX_GRAS_SU_CNTL_UNK15(uint32_t val)
{
	return ((val) << A6XX_GRAS_SU_CNTL_UNK15__SHIFT) & A6XX_GRAS_SU_CNTL_UNK15__MASK;
}
#define A6XX_GRAS_SU_CNTL_MULTIVIEW_ENABLE			0x00020000
#define A6XX_GRAS_SU_CNTL_RENDERTARGETINDEXINCR			0x00040000
#define A6XX_GRAS_SU_CNTL_VIEWPORTINDEXINCR			0x00080000
#define A6XX_GRAS_SU_CNTL_UNK20__MASK				0x00700000ull
#define A6XX_GRAS_SU_CNTL_UNK20__SHIFT				20
static CONSTEXPR inline uint32_t A6XX_GRAS_SU_CNTL_UNK20(uint32_t val)
{
	return ((val) << A6XX_GRAS_SU_CNTL_UNK20__SHIFT) & A6XX_GRAS_SU_CNTL_UNK20__MASK;
}


#define REG_A8XX_GRAS_SU_CNTL					__FD_DEPRECATED 0x00008209
#define A8XX_GRAS_SU_CNTL_CULL_FRONT				0x00000001
#define A8XX_GRAS_SU_CNTL_CULL_BACK				0x00000002
#define A8XX_GRAS_SU_CNTL_FRONT_CW				0x00000004
#define A8XX_GRAS_SU_CNTL_LINEHALFWIDTH__MASK			0x000007f8ull
#define A8XX_GRAS_SU_CNTL_LINEHALFWIDTH__SHIFT			3
static inline uint32_t A8XX_GRAS_SU_CNTL_LINEHALFWIDTH(float val)
{
	return ((((int32_t)(val * 4.0))) << A8XX_GRAS_SU_CNTL_LINEHALFWIDTH__SHIFT) & A8XX_GRAS_SU_CNTL_LINEHALFWIDTH__MASK;
}
#define A8XX_GRAS_SU_CNTL_POLY_OFFSET				0x00000800
#define A8XX_GRAS_SU_CNTL_UNK12					0x00001000
#define A8XX_GRAS_SU_CNTL_LINE_MODE__MASK			0x00002000ull
#define A8XX_GRAS_SU_CNTL_LINE_MODE__SHIFT			13
static CONSTEXPR inline uint32_t A8XX_GRAS_SU_CNTL_LINE_MODE(enum a5xx_line_mode val)
{
	return ((val) << A8XX_GRAS_SU_CNTL_LINE_MODE__SHIFT) & A8XX_GRAS_SU_CNTL_LINE_MODE__MASK;
}
#define A8XX_GRAS_SU_CNTL_UNK15__MASK				0x00018000ull
#define A8XX_GRAS_SU_CNTL_UNK15__SHIFT				15
static CONSTEXPR inline uint32_t A8XX_GRAS_SU_CNTL_UNK15(uint32_t val)
{
	return ((val) << A8XX_GRAS_SU_CNTL_UNK15__SHIFT) & A8XX_GRAS_SU_CNTL_UNK15__MASK;
}
#define A8XX_GRAS_SU_CNTL_MULTIVIEW_ENABLE			0x00020000


#define REG_A8XX_GRAS_SU_STEREO_CNTL				__FD_DEPRECATED 0x0000820c
#define A8XX_GRAS_SU_STEREO_CNTL_RENDERTARGETINDEXINCR		0x00000001
#define A8XX_GRAS_SU_STEREO_CNTL_VIEWPORTINDEXINCR		0x00000002


#define REG_A6XX_GRAS_SU_POINT_MINMAX				__FD_DEPRECATED 0x00008091
#define A6XX_GRAS_SU_POINT_MINMAX_MIN__MASK			0x0000ffffull
#define A6XX_GRAS_SU_POINT_MINMAX_MIN__SHIFT			0
static inline uint32_t A6XX_GRAS_SU_POINT_MINMAX_MIN(float val)
{
	return ((((uint32_t)(val * 16.0))) << A6XX_GRAS_SU_POINT_MINMAX_MIN__SHIFT) & A6XX_GRAS_SU_POINT_MINMAX_MIN__MASK;
}
#define A6XX_GRAS_SU_POINT_MINMAX_MAX__MASK			0xffff0000ull
#define A6XX_GRAS_SU_POINT_MINMAX_MAX__SHIFT			16
static inline uint32_t A6XX_GRAS_SU_POINT_MINMAX_MAX(float val)
{
	return ((((uint32_t)(val * 16.0))) << A6XX_GRAS_SU_POINT_MINMAX_MAX__SHIFT) & A6XX_GRAS_SU_POINT_MINMAX_MAX__MASK;
}


#define REG_A8XX_GRAS_SU_POINT_MINMAX				__FD_DEPRECATED 0x0000820a
#define A8XX_GRAS_SU_POINT_MINMAX_MIN__MASK			0x0000ffffull
#define A8XX_GRAS_SU_POINT_MINMAX_MIN__SHIFT			0
static inline uint32_t A8XX_GRAS_SU_POINT_MINMAX_MIN(float val)
{
	return ((((uint32_t)(val * 16.0))) << A8XX_GRAS_SU_POINT_MINMAX_MIN__SHIFT) & A8XX_GRAS_SU_POINT_MINMAX_MIN__MASK;
}
#define A8XX_GRAS_SU_POINT_MINMAX_MAX__MASK			0xffff0000ull
#define A8XX_GRAS_SU_POINT_MINMAX_MAX__SHIFT			16
static inline uint32_t A8XX_GRAS_SU_POINT_MINMAX_MAX(float val)
{
	return ((((uint32_t)(val * 16.0))) << A8XX_GRAS_SU_POINT_MINMAX_MAX__SHIFT) & A8XX_GRAS_SU_POINT_MINMAX_MAX__MASK;
}


#define REG_A6XX_GRAS_SU_POINT_SIZE				__FD_DEPRECATED 0x00008092
#define A6XX_GRAS_SU_POINT_SIZE__MASK				0x0000ffffull
#define A6XX_GRAS_SU_POINT_SIZE__SHIFT				0
static inline uint32_t A6XX_GRAS_SU_POINT_SIZE(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_GRAS_SU_POINT_SIZE__SHIFT) & A6XX_GRAS_SU_POINT_SIZE__MASK;
}


#define REG_A8XX_GRAS_SU_POINT_SIZE				__FD_DEPRECATED 0x0000820b
#define A8XX_GRAS_SU_POINT_SIZE__MASK				0x0000ffffull
#define A8XX_GRAS_SU_POINT_SIZE__SHIFT				0
static inline uint32_t A8XX_GRAS_SU_POINT_SIZE(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SU_POINT_SIZE__SHIFT) & A8XX_GRAS_SU_POINT_SIZE__MASK;
}


#define REG_A6XX_GRAS_SU_DEPTH_CNTL				__FD_DEPRECATED 0x00008114
#define A6XX_GRAS_SU_DEPTH_CNTL_Z_TEST_ENABLE			0x00000001


#define REG_A8XX_GRAS_SU_DEPTH_CNTL				__FD_DEPRECATED 0x00008086
#define A8XX_GRAS_SU_DEPTH_CNTL_Z_TEST_ENABLE			0x00000001


#define REG_A6XX_GRAS_SU_STENCIL_CNTL				__FD_DEPRECATED 0x00008115
#define A6XX_GRAS_SU_STENCIL_CNTL_STENCIL_ENABLE		0x00000001


#define REG_A8XX_GRAS_SU_STENCIL_CNTL				__FD_DEPRECATED 0x00008087
#define A8XX_GRAS_SU_STENCIL_CNTL_STENCIL_ENABLE		0x00000001


#define REG_A7XX_GRAS_SU_RENDER_CNTL				__FD_DEPRECATED 0x00008116
#define A7XX_GRAS_SU_RENDER_CNTL_FS_DISABLE			0x00000080


#define REG_A8XX_GRAS_SU_RENDER_CNTL				__FD_DEPRECATED 0x00008088
#define A8XX_GRAS_SU_RENDER_CNTL_FS_DISABLE			0x00000080


#define REG_A6XX_GRAS_SU_DEPTH_PLANE_CNTL			__FD_DEPRECATED 0x00008094
#define A6XX_GRAS_SU_DEPTH_PLANE_CNTL_Z_MODE__MASK		0x00000003ull
#define A6XX_GRAS_SU_DEPTH_PLANE_CNTL_Z_MODE__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_GRAS_SU_DEPTH_PLANE_CNTL_Z_MODE(enum a6xx_ztest_mode val)
{
	return ((val) << A6XX_GRAS_SU_DEPTH_PLANE_CNTL_Z_MODE__SHIFT) & A6XX_GRAS_SU_DEPTH_PLANE_CNTL_Z_MODE__MASK;
}


#define REG_A8XX_GRAS_SU_DEPTH_PLANE_CNTL			__FD_DEPRECATED 0x00008089
#define A8XX_GRAS_SU_DEPTH_PLANE_CNTL_Z_MODE__MASK		0x00000003ull
#define A8XX_GRAS_SU_DEPTH_PLANE_CNTL_Z_MODE__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_GRAS_SU_DEPTH_PLANE_CNTL_Z_MODE(enum a6xx_ztest_mode val)
{
	return ((val) << A8XX_GRAS_SU_DEPTH_PLANE_CNTL_Z_MODE__SHIFT) & A8XX_GRAS_SU_DEPTH_PLANE_CNTL_Z_MODE__MASK;
}


#define REG_A6XX_GRAS_SU_POLY_OFFSET_SCALE			__FD_DEPRECATED 0x00008095
#define A6XX_GRAS_SU_POLY_OFFSET_SCALE__MASK			0xffffffffull
#define A6XX_GRAS_SU_POLY_OFFSET_SCALE__SHIFT			0
static inline uint32_t A6XX_GRAS_SU_POLY_OFFSET_SCALE(float val)
{
	return ((fui(val)) << A6XX_GRAS_SU_POLY_OFFSET_SCALE__SHIFT) & A6XX_GRAS_SU_POLY_OFFSET_SCALE__MASK;
}


#define REG_A8XX_GRAS_SU_POLY_OFFSET_SCALE			__FD_DEPRECATED 0x0000808a
#define A8XX_GRAS_SU_POLY_OFFSET_SCALE__MASK			0xffffffffull
#define A8XX_GRAS_SU_POLY_OFFSET_SCALE__SHIFT			0
static inline uint32_t A8XX_GRAS_SU_POLY_OFFSET_SCALE(float val)
{
	return ((fui(val)) << A8XX_GRAS_SU_POLY_OFFSET_SCALE__SHIFT) & A8XX_GRAS_SU_POLY_OFFSET_SCALE__MASK;
}


#define REG_A6XX_GRAS_SU_POLY_OFFSET_OFFSET			__FD_DEPRECATED 0x00008096
#define A6XX_GRAS_SU_POLY_OFFSET_OFFSET__MASK			0xffffffffull
#define A6XX_GRAS_SU_POLY_OFFSET_OFFSET__SHIFT			0
static inline uint32_t A6XX_GRAS_SU_POLY_OFFSET_OFFSET(float val)
{
	return ((fui(val)) << A6XX_GRAS_SU_POLY_OFFSET_OFFSET__SHIFT) & A6XX_GRAS_SU_POLY_OFFSET_OFFSET__MASK;
}


#define REG_A8XX_GRAS_SU_POLY_OFFSET_OFFSET			__FD_DEPRECATED 0x0000808b
#define A8XX_GRAS_SU_POLY_OFFSET_OFFSET__MASK			0xffffffffull
#define A8XX_GRAS_SU_POLY_OFFSET_OFFSET__SHIFT			0
static inline uint32_t A8XX_GRAS_SU_POLY_OFFSET_OFFSET(float val)
{
	return ((fui(val)) << A8XX_GRAS_SU_POLY_OFFSET_OFFSET__SHIFT) & A8XX_GRAS_SU_POLY_OFFSET_OFFSET__MASK;
}


#define REG_A6XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP		__FD_DEPRECATED 0x00008097
#define A6XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP__MASK		0xffffffffull
#define A6XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP__SHIFT		0
static inline uint32_t A6XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP(float val)
{
	return ((fui(val)) << A6XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP__SHIFT) & A6XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP__MASK;
}


#define REG_A8XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP		__FD_DEPRECATED 0x0000808c
#define A8XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP__MASK		0xffffffffull
#define A8XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP__SHIFT		0
static inline uint32_t A8XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP(float val)
{
	return ((fui(val)) << A8XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP__SHIFT) & A8XX_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP__MASK;
}


#define REG_A6XX_GRAS_SU_DEPTH_BUFFER_INFO			__FD_DEPRECATED 0x00008098
#define A6XX_GRAS_SU_DEPTH_BUFFER_INFO_DEPTH_FORMAT__MASK	0x00000007ull
#define A6XX_GRAS_SU_DEPTH_BUFFER_INFO_DEPTH_FORMAT__SHIFT	0
static CONSTEXPR inline uint32_t A6XX_GRAS_SU_DEPTH_BUFFER_INFO_DEPTH_FORMAT(enum a6xx_depth_format val)
{
	return ((val) << A6XX_GRAS_SU_DEPTH_BUFFER_INFO_DEPTH_FORMAT__SHIFT) & A6XX_GRAS_SU_DEPTH_BUFFER_INFO_DEPTH_FORMAT__MASK;
}
#define A6XX_GRAS_SU_DEPTH_BUFFER_INFO_READ_ONLY		0x00000008


#define REG_A8XX_GRAS_SU_DEPTH_BUFFER_INFO			__FD_DEPRECATED 0x0000808d
#define A8XX_GRAS_SU_DEPTH_BUFFER_INFO_DEPTH_FORMAT__MASK	0x00000007ull
#define A8XX_GRAS_SU_DEPTH_BUFFER_INFO_DEPTH_FORMAT__SHIFT	0
static CONSTEXPR inline uint32_t A8XX_GRAS_SU_DEPTH_BUFFER_INFO_DEPTH_FORMAT(enum a6xx_depth_format val)
{
	return ((val) << A8XX_GRAS_SU_DEPTH_BUFFER_INFO_DEPTH_FORMAT__SHIFT) & A8XX_GRAS_SU_DEPTH_BUFFER_INFO_DEPTH_FORMAT__MASK;
}
#define A8XX_GRAS_SU_DEPTH_BUFFER_INFO_READ_ONLY		0x00000008


#define REG_A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL			__FD_DEPRECATED 0x00008099
#define A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_CONSERVATIVERASEN	0x00000001
#define A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_SHIFTAMOUNT__MASK	0x00000006ull
#define A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_SHIFTAMOUNT__SHIFT	1
static CONSTEXPR inline uint32_t A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_SHIFTAMOUNT(enum a6xx_shift_amount val)
{
	return ((val) << A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_SHIFTAMOUNT__SHIFT) & A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_SHIFTAMOUNT__MASK;
}
#define A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_INNERCONSERVATIVERASEN	0x00000008
#define A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_UNK4__MASK		0x00000030ull
#define A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_UNK4__SHIFT		4
static CONSTEXPR inline uint32_t A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_UNK4(uint32_t val)
{
	return ((val) << A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_UNK4__SHIFT) & A6XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_UNK4__MASK;
}


#define REG_A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL			__FD_DEPRECATED 0x0000820d
#define A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_CONSERVATIVERASEN	0x00000001
#define A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_SHIFTAMOUNT__MASK	0x00000006ull
#define A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_SHIFTAMOUNT__SHIFT	1
static CONSTEXPR inline uint32_t A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_SHIFTAMOUNT(enum a6xx_shift_amount val)
{
	return ((val) << A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_SHIFTAMOUNT__SHIFT) & A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_SHIFTAMOUNT__MASK;
}
#define A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_INNERCONSERVATIVERASEN	0x00000008
#define A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_UNK4__MASK		0x00000030ull
#define A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_UNK4__SHIFT		4
static CONSTEXPR inline uint32_t A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_UNK4(uint32_t val)
{
	return ((val) << A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_UNK4__SHIFT) & A8XX_GRAS_SU_CONSERVATIVE_RAS_CNTL_UNK4__MASK;
}


#define REG_A6XX_GRAS_SU_PATH_RENDERING_CNTL			0x0000809a
#define A6XX_GRAS_SU_PATH_RENDERING_CNTL_UNK0			0x00000001
#define A6XX_GRAS_SU_PATH_RENDERING_CNTL_LINELENGTHEN		0x00000002


#define REG_A6XX_GRAS_SU_VS_SIV_CNTL				__FD_DEPRECATED 0x0000809b
#define A6XX_GRAS_SU_VS_SIV_CNTL_WRITES_LAYER			0x00000001
#define A6XX_GRAS_SU_VS_SIV_CNTL_WRITES_VIEW			0x00000002


#define REG_A6XX_GRAS_SU_GS_SIV_CNTL				__FD_DEPRECATED 0x0000809c
#define A6XX_GRAS_SU_GS_SIV_CNTL_WRITES_LAYER			0x00000001
#define A6XX_GRAS_SU_GS_SIV_CNTL_WRITES_VIEW			0x00000002


#define REG_A6XX_GRAS_SU_DS_SIV_CNTL				__FD_DEPRECATED 0x0000809d
#define A6XX_GRAS_SU_DS_SIV_CNTL_WRITES_LAYER			0x00000001
#define A6XX_GRAS_SU_DS_SIV_CNTL_WRITES_VIEW			0x00000002


#define REG_A8XX_GRAS_SU_VS_SIV_CNTL				__FD_DEPRECATED 0x0000820e
#define A8XX_GRAS_SU_VS_SIV_CNTL_WRITES_LAYER			0x00000001
#define A8XX_GRAS_SU_VS_SIV_CNTL_WRITES_VIEW			0x00000002


#define REG_A8XX_GRAS_SU_GS_SIV_CNTL				__FD_DEPRECATED 0x0000820f
#define A8XX_GRAS_SU_GS_SIV_CNTL_WRITES_LAYER			0x00000001
#define A8XX_GRAS_SU_GS_SIV_CNTL_WRITES_VIEW			0x00000002


#define REG_A8XX_GRAS_SU_DS_SIV_CNTL				__FD_DEPRECATED 0x00008210
#define A8XX_GRAS_SU_DS_SIV_CNTL_WRITES_LAYER			0x00000001
#define A8XX_GRAS_SU_DS_SIV_CNTL_WRITES_VIEW			0x00000002


#define REG_A8XX_GRAS_RAST_CNTL					__FD_DEPRECATED 0x00008211
#define A8XX_GRAS_RAST_CNTL_MODE__MASK				0x00000003ull
#define A8XX_GRAS_RAST_CNTL_MODE__SHIFT				0
static CONSTEXPR inline uint32_t A8XX_GRAS_RAST_CNTL_MODE(enum a6xx_polygon_mode val)
{
	return ((val) << A8XX_GRAS_RAST_CNTL_MODE__SHIFT) & A8XX_GRAS_RAST_CNTL_MODE__MASK;
}


#define REG_A6XX_GRAS_SC_CNTL					__FD_DEPRECATED 0x000080a0
#define A6XX_GRAS_SC_CNTL_SINGLE_PRIM_MODE__MASK		0x00000018ull
#define A6XX_GRAS_SC_CNTL_SINGLE_PRIM_MODE__SHIFT		3
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_CNTL_SINGLE_PRIM_MODE(enum a6xx_single_prim_mode val)
{
	return ((val) << A6XX_GRAS_SC_CNTL_SINGLE_PRIM_MODE__SHIFT) & A6XX_GRAS_SC_CNTL_SINGLE_PRIM_MODE__MASK;
}
#define A6XX_GRAS_SC_CNTL_RASTER_MODE__MASK			0x00000020ull
#define A6XX_GRAS_SC_CNTL_RASTER_MODE__SHIFT			5
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_CNTL_RASTER_MODE(enum a6xx_raster_mode val)
{
	return ((val) << A6XX_GRAS_SC_CNTL_RASTER_MODE__SHIFT) & A6XX_GRAS_SC_CNTL_RASTER_MODE__MASK;
}
#define A6XX_GRAS_SC_CNTL_RASTER_DIRECTION__MASK		0x000000c0ull
#define A6XX_GRAS_SC_CNTL_RASTER_DIRECTION__SHIFT		6
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_CNTL_RASTER_DIRECTION(enum a6xx_raster_direction val)
{
	return ((val) << A6XX_GRAS_SC_CNTL_RASTER_DIRECTION__SHIFT) & A6XX_GRAS_SC_CNTL_RASTER_DIRECTION__MASK;
}
#define A6XX_GRAS_SC_CNTL_SEQUENCED_THREAD_DISTRIBUTION__MASK	0x00000100ull
#define A6XX_GRAS_SC_CNTL_SEQUENCED_THREAD_DISTRIBUTION__SHIFT	8
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_CNTL_SEQUENCED_THREAD_DISTRIBUTION(enum a6xx_sequenced_thread_dist val)
{
	return ((val) << A6XX_GRAS_SC_CNTL_SEQUENCED_THREAD_DISTRIBUTION__SHIFT) & A6XX_GRAS_SC_CNTL_SEQUENCED_THREAD_DISTRIBUTION__MASK;
}
#define A6XX_GRAS_SC_CNTL_UNK9					0x00000200
#define A6XX_GRAS_SC_CNTL_ROTATION__MASK			0x00000c00ull
#define A6XX_GRAS_SC_CNTL_ROTATION__SHIFT			10
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_CNTL_ROTATION(uint32_t val)
{
	return ((val) << A6XX_GRAS_SC_CNTL_ROTATION__SHIFT) & A6XX_GRAS_SC_CNTL_ROTATION__MASK;
}
#define A6XX_GRAS_SC_CNTL_EARLYVIZOUTEN				0x00001000
#define A6XX_GRAS_SC_CNTL_CCUSINGLECACHELINESIZE__MASK		0x00000007ull
#define A6XX_GRAS_SC_CNTL_CCUSINGLECACHELINESIZE__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_CNTL_CCUSINGLECACHELINESIZE(uint32_t val)
{
	return ((val) << A6XX_GRAS_SC_CNTL_CCUSINGLECACHELINESIZE__SHIFT) & A6XX_GRAS_SC_CNTL_CCUSINGLECACHELINESIZE__MASK;
}


#define REG_A8XX_GRAS_SC_CNTL					__FD_DEPRECATED 0x00008230
#define A8XX_GRAS_SC_CNTL_SINGLE_PRIM_MODE__MASK		0x00000018ull
#define A8XX_GRAS_SC_CNTL_SINGLE_PRIM_MODE__SHIFT		3
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_CNTL_SINGLE_PRIM_MODE(enum a6xx_single_prim_mode val)
{
	return ((val) << A8XX_GRAS_SC_CNTL_SINGLE_PRIM_MODE__SHIFT) & A8XX_GRAS_SC_CNTL_SINGLE_PRIM_MODE__MASK;
}
#define A8XX_GRAS_SC_CNTL_RASTER_MODE__MASK			0x00000020ull
#define A8XX_GRAS_SC_CNTL_RASTER_MODE__SHIFT			5
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_CNTL_RASTER_MODE(enum a6xx_raster_mode val)
{
	return ((val) << A8XX_GRAS_SC_CNTL_RASTER_MODE__SHIFT) & A8XX_GRAS_SC_CNTL_RASTER_MODE__MASK;
}
#define A8XX_GRAS_SC_CNTL_RASTER_DIRECTION__MASK		0x000000c0ull
#define A8XX_GRAS_SC_CNTL_RASTER_DIRECTION__SHIFT		6
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_CNTL_RASTER_DIRECTION(enum a6xx_raster_direction val)
{
	return ((val) << A8XX_GRAS_SC_CNTL_RASTER_DIRECTION__SHIFT) & A8XX_GRAS_SC_CNTL_RASTER_DIRECTION__MASK;
}
#define A8XX_GRAS_SC_CNTL_SEQUENCED_THREAD_DISTRIBUTION__MASK	0x00000100ull
#define A8XX_GRAS_SC_CNTL_SEQUENCED_THREAD_DISTRIBUTION__SHIFT	8
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_CNTL_SEQUENCED_THREAD_DISTRIBUTION(enum a6xx_sequenced_thread_dist val)
{
	return ((val) << A8XX_GRAS_SC_CNTL_SEQUENCED_THREAD_DISTRIBUTION__SHIFT) & A8XX_GRAS_SC_CNTL_SEQUENCED_THREAD_DISTRIBUTION__MASK;
}
#define A8XX_GRAS_SC_CNTL_UNK9					0x00000200
#define A8XX_GRAS_SC_CNTL_ROTATION__MASK			0x00000c00ull
#define A8XX_GRAS_SC_CNTL_ROTATION__SHIFT			10
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_CNTL_ROTATION(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_CNTL_ROTATION__SHIFT) & A8XX_GRAS_SC_CNTL_ROTATION__MASK;
}
#define A8XX_GRAS_SC_CNTL_EARLYVIZOUTEN				0x00001000


#define REG_A6XX_GRAS_SC_BIN_CNTL				__FD_DEPRECATED 0x000080a1
#define A6XX_GRAS_SC_BIN_CNTL_BINW__MASK			0x0000003full
#define A6XX_GRAS_SC_BIN_CNTL_BINW__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_BIN_CNTL_BINW(uint32_t val)
{
	assert(!(val & 0x1f));
	return (((val >> 5)) << A6XX_GRAS_SC_BIN_CNTL_BINW__SHIFT) & A6XX_GRAS_SC_BIN_CNTL_BINW__MASK;
}
#define A6XX_GRAS_SC_BIN_CNTL_BINH__MASK			0x00007f00ull
#define A6XX_GRAS_SC_BIN_CNTL_BINH__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_BIN_CNTL_BINH(uint32_t val)
{
	assert(!(val & 0xf));
	return (((val >> 4)) << A6XX_GRAS_SC_BIN_CNTL_BINH__SHIFT) & A6XX_GRAS_SC_BIN_CNTL_BINH__MASK;
}
#define A6XX_GRAS_SC_BIN_CNTL_RENDER_MODE__MASK			0x001c0000ull
#define A6XX_GRAS_SC_BIN_CNTL_RENDER_MODE__SHIFT		18
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_BIN_CNTL_RENDER_MODE(enum a6xx_render_mode val)
{
	return ((val) << A6XX_GRAS_SC_BIN_CNTL_RENDER_MODE__SHIFT) & A6XX_GRAS_SC_BIN_CNTL_RENDER_MODE__MASK;
}
#define A6XX_GRAS_SC_BIN_CNTL_FORCE_LRZ_WRITE_DIS		0x00200000
#define A6XX_GRAS_SC_BIN_CNTL_BUFFERS_LOCATION__MASK		0x00c00000ull
#define A6XX_GRAS_SC_BIN_CNTL_BUFFERS_LOCATION__SHIFT		22
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_BIN_CNTL_BUFFERS_LOCATION(enum a6xx_buffers_location val)
{
	return ((val) << A6XX_GRAS_SC_BIN_CNTL_BUFFERS_LOCATION__SHIFT) & A6XX_GRAS_SC_BIN_CNTL_BUFFERS_LOCATION__MASK;
}
#define A6XX_GRAS_SC_BIN_CNTL_LRZ_FEEDBACK_ZMODE_MASK__MASK	0x07000000ull
#define A6XX_GRAS_SC_BIN_CNTL_LRZ_FEEDBACK_ZMODE_MASK__SHIFT	24
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_BIN_CNTL_LRZ_FEEDBACK_ZMODE_MASK(enum a6xx_lrz_feedback_mask val)
{
	return ((val) << A6XX_GRAS_SC_BIN_CNTL_LRZ_FEEDBACK_ZMODE_MASK__SHIFT) & A6XX_GRAS_SC_BIN_CNTL_LRZ_FEEDBACK_ZMODE_MASK__MASK;
}
#define A6XX_GRAS_SC_BIN_CNTL_FORCE_LRZ_DIS			0x08000000


#define REG_A8XX_GRAS_SC_BIN_CNTL				__FD_DEPRECATED 0x00008231
#define A8XX_GRAS_SC_BIN_CNTL_BINW__MASK			0x000003ffull
#define A8XX_GRAS_SC_BIN_CNTL_BINW__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_BIN_CNTL_BINW(uint32_t val)
{
	assert(!(val & 0x1f));
	return (((val >> 5)) << A8XX_GRAS_SC_BIN_CNTL_BINW__SHIFT) & A8XX_GRAS_SC_BIN_CNTL_BINW__MASK;
}
#define A8XX_GRAS_SC_BIN_CNTL_BINH__MASK			0x07ff0000ull
#define A8XX_GRAS_SC_BIN_CNTL_BINH__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_BIN_CNTL_BINH(uint32_t val)
{
	assert(!(val & 0xf));
	return (((val >> 4)) << A8XX_GRAS_SC_BIN_CNTL_BINH__SHIFT) & A8XX_GRAS_SC_BIN_CNTL_BINH__MASK;
}
#define A8XX_GRAS_SC_BIN_CNTL_RENDER_MODE__MASK			0x00003800ull
#define A8XX_GRAS_SC_BIN_CNTL_RENDER_MODE__SHIFT		11
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_BIN_CNTL_RENDER_MODE(enum a6xx_render_mode val)
{
	return ((val) << A8XX_GRAS_SC_BIN_CNTL_RENDER_MODE__SHIFT) & A8XX_GRAS_SC_BIN_CNTL_RENDER_MODE__MASK;
}
#define A8XX_GRAS_SC_BIN_CNTL_LRZ_FEEDBACK_ZMODE_MASK__MASK	0x70000000ull
#define A8XX_GRAS_SC_BIN_CNTL_LRZ_FEEDBACK_ZMODE_MASK__SHIFT	28
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_BIN_CNTL_LRZ_FEEDBACK_ZMODE_MASK(enum a6xx_lrz_feedback_mask val)
{
	return ((val) << A8XX_GRAS_SC_BIN_CNTL_LRZ_FEEDBACK_ZMODE_MASK__SHIFT) & A8XX_GRAS_SC_BIN_CNTL_LRZ_FEEDBACK_ZMODE_MASK__MASK;
}
#define A8XX_GRAS_SC_BIN_CNTL_FORCE_LRZ_WRITE_DIS		0x80000000
#define A8XX_GRAS_SC_BIN_CNTL_CONS_VIS_IN_BINNING		0x00000400
#define A8XX_GRAS_SC_BIN_CNTL_FORCE_BI_DIR_LRZ_DISABLE		0x00004000
#define A8XX_GRAS_SC_BIN_CNTL_FORCE_LRZ_DIS			0x00008000
#define A8XX_GRAS_SC_BIN_CNTL_BIN_VRS_DIS			0x08000000


#define REG_A6XX_GRAS_SC_RAS_MSAA_CNTL				__FD_DEPRECATED 0x000080a2
#define A6XX_GRAS_SC_RAS_MSAA_CNTL_SAMPLES__MASK		0x00000003ull
#define A6XX_GRAS_SC_RAS_MSAA_CNTL_SAMPLES__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_RAS_MSAA_CNTL_SAMPLES(enum a3xx_msaa_samples val)
{
	return ((val) << A6XX_GRAS_SC_RAS_MSAA_CNTL_SAMPLES__SHIFT) & A6XX_GRAS_SC_RAS_MSAA_CNTL_SAMPLES__MASK;
}
#define A6XX_GRAS_SC_RAS_MSAA_CNTL_UNK2				0x00000004
#define A6XX_GRAS_SC_RAS_MSAA_CNTL_UNK3				0x00000008


#define REG_A8XX_GRAS_SC_RAS_MSAA_CNTL				__FD_DEPRECATED 0x00008232
#define A8XX_GRAS_SC_RAS_MSAA_CNTL_SAMPLES__MASK		0x00000003ull
#define A8XX_GRAS_SC_RAS_MSAA_CNTL_SAMPLES__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_RAS_MSAA_CNTL_SAMPLES(enum a3xx_msaa_samples val)
{
	return ((val) << A8XX_GRAS_SC_RAS_MSAA_CNTL_SAMPLES__SHIFT) & A8XX_GRAS_SC_RAS_MSAA_CNTL_SAMPLES__MASK;
}
#define A8XX_GRAS_SC_RAS_MSAA_CNTL_UNK2				0x00000004
#define A8XX_GRAS_SC_RAS_MSAA_CNTL_UNK3				0x00000008


#define REG_A6XX_GRAS_SC_DEST_MSAA_CNTL				__FD_DEPRECATED 0x000080a3
#define A6XX_GRAS_SC_DEST_MSAA_CNTL_SAMPLES__MASK		0x00000003ull
#define A6XX_GRAS_SC_DEST_MSAA_CNTL_SAMPLES__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_DEST_MSAA_CNTL_SAMPLES(enum a3xx_msaa_samples val)
{
	return ((val) << A6XX_GRAS_SC_DEST_MSAA_CNTL_SAMPLES__SHIFT) & A6XX_GRAS_SC_DEST_MSAA_CNTL_SAMPLES__MASK;
}
#define A6XX_GRAS_SC_DEST_MSAA_CNTL_MSAA_DISABLE		0x00000004


#define REG_A8XX_GRAS_SC_DEST_MSAA_CNTL				__FD_DEPRECATED 0x00008233
#define A8XX_GRAS_SC_DEST_MSAA_CNTL_SAMPLES__MASK		0x00000003ull
#define A8XX_GRAS_SC_DEST_MSAA_CNTL_SAMPLES__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_DEST_MSAA_CNTL_SAMPLES(enum a3xx_msaa_samples val)
{
	return ((val) << A8XX_GRAS_SC_DEST_MSAA_CNTL_SAMPLES__SHIFT) & A8XX_GRAS_SC_DEST_MSAA_CNTL_SAMPLES__MASK;
}
#define A8XX_GRAS_SC_DEST_MSAA_CNTL_MSAA_DISABLE		0x00000004


#define REG_A6XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL			__FD_DEPRECATED 0x000080a4
#define A6XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL_UNK0			0x00000001
#define A6XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL_LOCATION_ENABLE	0x00000002


#define REG_A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0		__FD_DEPRECATED 0x000080a5
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X__MASK	0x0000000full
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X__SHIFT	0
static inline uint32_t A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X__SHIFT) & A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X__MASK;
}
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y__MASK	0x000000f0ull
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y__SHIFT	4
static inline uint32_t A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y__SHIFT) & A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y__MASK;
}
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X__MASK	0x00000f00ull
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X__SHIFT	8
static inline uint32_t A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X__SHIFT) & A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X__MASK;
}
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y__MASK	0x0000f000ull
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y__SHIFT	12
static inline uint32_t A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y__SHIFT) & A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y__MASK;
}
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X__MASK	0x000f0000ull
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X__SHIFT	16
static inline uint32_t A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X__SHIFT) & A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X__MASK;
}
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y__MASK	0x00f00000ull
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y__SHIFT	20
static inline uint32_t A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y__SHIFT) & A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y__MASK;
}
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X__MASK	0x0f000000ull
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X__SHIFT	24
static inline uint32_t A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X__SHIFT) & A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X__MASK;
}
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y__MASK	0xf0000000ull
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y__SHIFT	28
static inline uint32_t A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y__SHIFT) & A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y__MASK;
}


#define REG_A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1		__FD_DEPRECATED 0x000080a6
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X__MASK	0x0000000full
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X__SHIFT	0
static inline uint32_t A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X__SHIFT) & A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X__MASK;
}
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y__MASK	0x000000f0ull
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y__SHIFT	4
static inline uint32_t A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y__SHIFT) & A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y__MASK;
}
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X__MASK	0x00000f00ull
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X__SHIFT	8
static inline uint32_t A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X__SHIFT) & A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X__MASK;
}
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y__MASK	0x0000f000ull
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y__SHIFT	12
static inline uint32_t A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y__SHIFT) & A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y__MASK;
}
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X__MASK	0x000f0000ull
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X__SHIFT	16
static inline uint32_t A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X__SHIFT) & A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X__MASK;
}
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y__MASK	0x00f00000ull
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y__SHIFT	20
static inline uint32_t A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y__SHIFT) & A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y__MASK;
}
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X__MASK	0x0f000000ull
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X__SHIFT	24
static inline uint32_t A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X__SHIFT) & A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X__MASK;
}
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y__MASK	0xf0000000ull
#define A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y__SHIFT	28
static inline uint32_t A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y__SHIFT) & A6XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y__MASK;
}


#define REG_A8XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL			__FD_DEPRECATED 0x00008237
#define A8XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL_UNK0			0x00000001
#define A8XX_GRAS_SC_MSAA_SAMPLE_POS_CNTL_LOCATION_ENABLE	0x00000002


#define REG_A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0		__FD_DEPRECATED 0x00008238
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X__MASK	0x0000000full
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X__SHIFT	0
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y__MASK	0x000000f0ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y__SHIFT	4
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X__MASK	0x00000f00ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X__SHIFT	8
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y__MASK	0x0000f000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y__SHIFT	12
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X__MASK	0x000f0000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X__SHIFT	16
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y__MASK	0x00f00000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y__SHIFT	20
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X__MASK	0x0f000000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X__SHIFT	24
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y__MASK	0xf0000000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y__SHIFT	28
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y__MASK;
}


#define REG_A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1		__FD_DEPRECATED 0x00008239
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X__MASK	0x0000000full
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X__SHIFT	0
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y__MASK	0x000000f0ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y__SHIFT	4
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X__MASK	0x00000f00ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X__SHIFT	8
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y__MASK	0x0000f000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y__SHIFT	12
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X__MASK	0x000f0000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X__SHIFT	16
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y__MASK	0x00f00000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y__SHIFT	20
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X__MASK	0x0f000000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X__SHIFT	24
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y__MASK	0xf0000000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y__SHIFT	28
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y__MASK;
}


#define REG_A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2		__FD_DEPRECATED 0x0000823a
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_X__MASK	0x0000000full
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_X__SHIFT	0
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_X__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_X__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_Y__MASK	0x000000f0ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_Y__SHIFT	4
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_Y__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_Y__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_X__MASK	0x00000f00ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_X__SHIFT	8
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_X__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_X__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_Y__MASK	0x0000f000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_Y__SHIFT	12
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_Y__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_Y__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_X__MASK	0x000f0000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_X__SHIFT	16
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_X__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_X__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_Y__MASK	0x00f00000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_Y__SHIFT	20
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_Y__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_Y__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_X__MASK	0x0f000000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_X__SHIFT	24
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_X__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_X__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_Y__MASK	0xf0000000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_Y__SHIFT	28
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_Y__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_Y__MASK;
}


#define REG_A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3		__FD_DEPRECATED 0x0000823b
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_X__MASK	0x0000000full
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_X__SHIFT	0
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_X__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_X__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_Y__MASK	0x000000f0ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_Y__SHIFT	4
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_Y__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_Y__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_X__MASK	0x00000f00ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_X__SHIFT	8
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_X__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_X__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_Y__MASK	0x0000f000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_Y__SHIFT	12
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_Y__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_Y__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_X__MASK	0x000f0000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_X__SHIFT	16
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_X__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_X__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_Y__MASK	0x00f00000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_Y__SHIFT	20
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_Y__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_Y__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_X__MASK	0x0f000000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_X__SHIFT	24
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_X__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_X__MASK;
}
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_Y__MASK	0xf0000000ull
#define A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_Y__SHIFT	28
static inline uint32_t A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_Y__SHIFT) & A8XX_GRAS_SC_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_Y__MASK;
}


#define REG_A7XX_GRAS_ROTATION_CNTL				__FD_DEPRECATED 0x000080a7


#define REG_A8XX_GRAS_ROTATION_CNTL				__FD_DEPRECATED 0x00008207


#define REG_A6XX_GRAS_SC_SCREEN_SCISSOR_CNTL			__FD_DEPRECATED 0x000080af
#define A6XX_GRAS_SC_SCREEN_SCISSOR_CNTL_SCISSOR_DISABLE	0x00000001


#define REG_A8XX_GRAS_SC_SCREEN_SCISSOR_CNTL			__FD_DEPRECATED 0x00008234
#define A8XX_GRAS_SC_SCREEN_SCISSOR_CNTL_SCISSOR_DISABLE	0x00000001


#define REG_A6XX_GRAS_SC_SCREEN_SCISSOR(i0)			(0x000080b0 + 0x2*i0 )

#define A6XX_GRAS_SC_SCREEN_SCISSOR_TL_X__MASK			0x0000ffffull
#define A6XX_GRAS_SC_SCREEN_SCISSOR_TL_X__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_SCREEN_SCISSOR_TL_X(uint32_t val)
{
	return ((val) << A6XX_GRAS_SC_SCREEN_SCISSOR_TL_X__SHIFT) & A6XX_GRAS_SC_SCREEN_SCISSOR_TL_X__MASK;
}
#define A6XX_GRAS_SC_SCREEN_SCISSOR_TL_Y__MASK			0xffff0000ull
#define A6XX_GRAS_SC_SCREEN_SCISSOR_TL_Y__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_SCREEN_SCISSOR_TL_Y(uint32_t val)
{
	return ((val) << A6XX_GRAS_SC_SCREEN_SCISSOR_TL_Y__SHIFT) & A6XX_GRAS_SC_SCREEN_SCISSOR_TL_Y__MASK;
}


#define A6XX_GRAS_SC_SCREEN_SCISSOR_BR_X__MASK			0x0000ffffull
#define A6XX_GRAS_SC_SCREEN_SCISSOR_BR_X__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_SCREEN_SCISSOR_BR_X(uint32_t val)
{
	return ((val) << A6XX_GRAS_SC_SCREEN_SCISSOR_BR_X__SHIFT) & A6XX_GRAS_SC_SCREEN_SCISSOR_BR_X__MASK;
}
#define A6XX_GRAS_SC_SCREEN_SCISSOR_BR_Y__MASK			0xffff0000ull
#define A6XX_GRAS_SC_SCREEN_SCISSOR_BR_Y__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_SCREEN_SCISSOR_BR_Y(uint32_t val)
{
	return ((val) << A6XX_GRAS_SC_SCREEN_SCISSOR_BR_Y__SHIFT) & A6XX_GRAS_SC_SCREEN_SCISSOR_BR_Y__MASK;
}


#define REG_A8XX_GRAS_SC_SCREEN_SCISSOR(i0)			(0x00008240 + 0x2*i0 )

#define A8XX_GRAS_SC_SCREEN_SCISSOR_TL_X__MASK			0x0000ffffull
#define A8XX_GRAS_SC_SCREEN_SCISSOR_TL_X__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_SCREEN_SCISSOR_TL_X(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_SCREEN_SCISSOR_TL_X__SHIFT) & A8XX_GRAS_SC_SCREEN_SCISSOR_TL_X__MASK;
}
#define A8XX_GRAS_SC_SCREEN_SCISSOR_TL_Y__MASK			0xffff0000ull
#define A8XX_GRAS_SC_SCREEN_SCISSOR_TL_Y__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_SCREEN_SCISSOR_TL_Y(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_SCREEN_SCISSOR_TL_Y__SHIFT) & A8XX_GRAS_SC_SCREEN_SCISSOR_TL_Y__MASK;
}


#define A8XX_GRAS_SC_SCREEN_SCISSOR_BR_X__MASK			0x0000ffffull
#define A8XX_GRAS_SC_SCREEN_SCISSOR_BR_X__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_SCREEN_SCISSOR_BR_X(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_SCREEN_SCISSOR_BR_X__SHIFT) & A8XX_GRAS_SC_SCREEN_SCISSOR_BR_X__MASK;
}
#define A8XX_GRAS_SC_SCREEN_SCISSOR_BR_Y__MASK			0xffff0000ull
#define A8XX_GRAS_SC_SCREEN_SCISSOR_BR_Y__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_SCREEN_SCISSOR_BR_Y(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_SCREEN_SCISSOR_BR_Y__SHIFT) & A8XX_GRAS_SC_SCREEN_SCISSOR_BR_Y__MASK;
}


#define REG_A6XX_GRAS_SC_VIEWPORT_SCISSOR(i0)			(0x000080d0 + 0x2*i0 )

#define A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL_X__MASK		0x0000ffffull
#define A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL_X__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL_X(uint32_t val)
{
	return ((val) << A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL_X__SHIFT) & A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL_X__MASK;
}
#define A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL_Y__MASK		0xffff0000ull
#define A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL_Y__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL_Y(uint32_t val)
{
	return ((val) << A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL_Y__SHIFT) & A6XX_GRAS_SC_VIEWPORT_SCISSOR_TL_Y__MASK;
}


#define A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR_X__MASK		0x0000ffffull
#define A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR_X__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR_X(uint32_t val)
{
	return ((val) << A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR_X__SHIFT) & A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR_X__MASK;
}
#define A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR_Y__MASK		0xffff0000ull
#define A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR_Y__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR_Y(uint32_t val)
{
	return ((val) << A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR_Y__SHIFT) & A6XX_GRAS_SC_VIEWPORT_SCISSOR_BR_Y__MASK;
}


#define REG_A8XX_GRAS_SC_VIEWPORT_SCISSOR(i0)			(0x00008270 + 0x2*i0 )

#define A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL_X__MASK		0x0000ffffull
#define A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL_X__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL_X(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL_X__SHIFT) & A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL_X__MASK;
}
#define A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL_Y__MASK		0xffff0000ull
#define A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL_Y__SHIFT		16
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL_Y(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL_Y__SHIFT) & A8XX_GRAS_SC_VIEWPORT_SCISSOR_TL_Y__MASK;
}


#define A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR_X__MASK		0x0000ffffull
#define A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR_X__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR_X(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR_X__SHIFT) & A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR_X__MASK;
}
#define A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR_Y__MASK		0xffff0000ull
#define A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR_Y__SHIFT		16
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR_Y(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR_Y__SHIFT) & A8XX_GRAS_SC_VIEWPORT_SCISSOR_BR_Y__MASK;
}


#define REG_A8XX_GRAS_SC_WINDOW_INV_SCISSOR_CNTL		__FD_DEPRECATED 0x0000829f
#define A8XX_GRAS_SC_WINDOW_INV_SCISSOR_CNTL_INCLUSION		0x00000001
#define A8XX_GRAS_SC_WINDOW_INV_SCISSOR_CNTL_VP0_INV_SCISSOR_0_EN	0x00000010
#define A8XX_GRAS_SC_WINDOW_INV_SCISSOR_CNTL_VP0_INV_SCISSOR_1_EN	0x00000020
#define A8XX_GRAS_SC_WINDOW_INV_SCISSOR_CNTL_VP1_INV_SCISSOR_0_EN	0x00000040
#define A8XX_GRAS_SC_WINDOW_INV_SCISSOR_CNTL_VP1_INV_SCISSOR_1_EN	0x00000080
#define A8XX_GRAS_SC_WINDOW_INV_SCISSOR_CNTL_VP2_INV_SCISSOR_0_EN	0x00000100
#define A8XX_GRAS_SC_WINDOW_INV_SCISSOR_CNTL_VP2_INV_SCISSOR_1_EN	0x00000200
#define A8XX_GRAS_SC_WINDOW_INV_SCISSOR_CNTL_VP3_INV_SCISSOR_0_EN	0x00000400
#define A8XX_GRAS_SC_WINDOW_INV_SCISSOR_CNTL_VP3_INV_SCISSOR_1_EN	0x00000800
#define A8XX_GRAS_SC_WINDOW_INV_SCISSOR_CNTL_VP4_INV_SCISSOR_0_EN	0x00001000
#define A8XX_GRAS_SC_WINDOW_INV_SCISSOR_CNTL_VP4_INV_SCISSOR_1_EN	0x00002000
#define A8XX_GRAS_SC_WINDOW_INV_SCISSOR_CNTL_VP5_INV_SCISSOR_0_EN	0x00004000
#define A8XX_GRAS_SC_WINDOW_INV_SCISSOR_CNTL_VP5_INV_SCISSOR_1_EN	0x00008000


#define REG_A8XX_GRAS_SC_WINDOW_VP(i0)				(0x000082a0 + 0x4*i0 )

#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_TL_X__MASK		0x0000ffffull
#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_TL_X__SHIFT	0
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_TL_X(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_TL_X__SHIFT) & A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_TL_X__MASK;
}
#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_TL_Y__MASK		0xffff0000ull
#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_TL_Y__SHIFT	16
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_TL_Y(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_TL_Y__SHIFT) & A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_TL_Y__MASK;
}


#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_BR_X__MASK		0x0000ffffull
#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_BR_X__SHIFT	0
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_BR_X(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_BR_X__SHIFT) & A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_BR_X__MASK;
}
#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_BR_Y__MASK		0xffff0000ull
#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_BR_Y__SHIFT	16
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_BR_Y(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_BR_Y__SHIFT) & A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_0_BR_Y__MASK;
}


#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_TL_X__MASK		0x0000ffffull
#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_TL_X__SHIFT	0
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_TL_X(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_TL_X__SHIFT) & A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_TL_X__MASK;
}
#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_TL_Y__MASK		0xffff0000ull
#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_TL_Y__SHIFT	16
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_TL_Y(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_TL_Y__SHIFT) & A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_TL_Y__MASK;
}


#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_BR_X__MASK		0x0000ffffull
#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_BR_X__SHIFT	0
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_BR_X(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_BR_X__SHIFT) & A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_BR_X__MASK;
}
#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_BR_Y__MASK		0xffff0000ull
#define A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_BR_Y__SHIFT	16
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_BR_Y(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_BR_Y__SHIFT) & A8XX_GRAS_SC_WINDOW_VP_INV_SCISSOR_1_BR_Y__MASK;
}


#define REG_A6XX_GRAS_SC_WINDOW_SCISSOR_TL			__FD_DEPRECATED 0x000080f0
#define A6XX_GRAS_SC_WINDOW_SCISSOR_TL_X__MASK			0x00003fffull
#define A6XX_GRAS_SC_WINDOW_SCISSOR_TL_X__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_WINDOW_SCISSOR_TL_X(uint32_t val)
{
	return ((val) << A6XX_GRAS_SC_WINDOW_SCISSOR_TL_X__SHIFT) & A6XX_GRAS_SC_WINDOW_SCISSOR_TL_X__MASK;
}
#define A6XX_GRAS_SC_WINDOW_SCISSOR_TL_Y__MASK			0x3fff0000ull
#define A6XX_GRAS_SC_WINDOW_SCISSOR_TL_Y__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_WINDOW_SCISSOR_TL_Y(uint32_t val)
{
	return ((val) << A6XX_GRAS_SC_WINDOW_SCISSOR_TL_Y__SHIFT) & A6XX_GRAS_SC_WINDOW_SCISSOR_TL_Y__MASK;
}


#define REG_A6XX_GRAS_SC_WINDOW_SCISSOR_BR			__FD_DEPRECATED 0x000080f1
#define A6XX_GRAS_SC_WINDOW_SCISSOR_BR_X__MASK			0x00003fffull
#define A6XX_GRAS_SC_WINDOW_SCISSOR_BR_X__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_WINDOW_SCISSOR_BR_X(uint32_t val)
{
	return ((val) << A6XX_GRAS_SC_WINDOW_SCISSOR_BR_X__SHIFT) & A6XX_GRAS_SC_WINDOW_SCISSOR_BR_X__MASK;
}
#define A6XX_GRAS_SC_WINDOW_SCISSOR_BR_Y__MASK			0x3fff0000ull
#define A6XX_GRAS_SC_WINDOW_SCISSOR_BR_Y__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_GRAS_SC_WINDOW_SCISSOR_BR_Y(uint32_t val)
{
	return ((val) << A6XX_GRAS_SC_WINDOW_SCISSOR_BR_Y__SHIFT) & A6XX_GRAS_SC_WINDOW_SCISSOR_BR_Y__MASK;
}


#define REG_A8XX_GRAS_SC_WINDOW_SCISSOR_TL			__FD_DEPRECATED 0x00008235
#define A8XX_GRAS_SC_WINDOW_SCISSOR_TL_X__MASK			0x00003fffull
#define A8XX_GRAS_SC_WINDOW_SCISSOR_TL_X__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_WINDOW_SCISSOR_TL_X(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_WINDOW_SCISSOR_TL_X__SHIFT) & A8XX_GRAS_SC_WINDOW_SCISSOR_TL_X__MASK;
}
#define A8XX_GRAS_SC_WINDOW_SCISSOR_TL_Y__MASK			0x3fff0000ull
#define A8XX_GRAS_SC_WINDOW_SCISSOR_TL_Y__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_WINDOW_SCISSOR_TL_Y(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_WINDOW_SCISSOR_TL_Y__SHIFT) & A8XX_GRAS_SC_WINDOW_SCISSOR_TL_Y__MASK;
}


#define REG_A8XX_GRAS_SC_WINDOW_SCISSOR_BR			__FD_DEPRECATED 0x00008236
#define A8XX_GRAS_SC_WINDOW_SCISSOR_BR_X__MASK			0x00003fffull
#define A8XX_GRAS_SC_WINDOW_SCISSOR_BR_X__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_WINDOW_SCISSOR_BR_X(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_WINDOW_SCISSOR_BR_X__SHIFT) & A8XX_GRAS_SC_WINDOW_SCISSOR_BR_X__MASK;
}
#define A8XX_GRAS_SC_WINDOW_SCISSOR_BR_Y__MASK			0x3fff0000ull
#define A8XX_GRAS_SC_WINDOW_SCISSOR_BR_Y__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_GRAS_SC_WINDOW_SCISSOR_BR_Y(uint32_t val)
{
	return ((val) << A8XX_GRAS_SC_WINDOW_SCISSOR_BR_Y__SHIFT) & A8XX_GRAS_SC_WINDOW_SCISSOR_BR_Y__MASK;
}


#define REG_A7XX_GRAS_VRS_CONFIG				__FD_DEPRECATED 0x000080f4
#define A7XX_GRAS_VRS_CONFIG_PIPELINE_FSR_ENABLE		0x00000001
#define A7XX_GRAS_VRS_CONFIG_FRAG_SIZE_X__MASK			0x00000006ull
#define A7XX_GRAS_VRS_CONFIG_FRAG_SIZE_X__SHIFT			1
static CONSTEXPR inline uint32_t A7XX_GRAS_VRS_CONFIG_FRAG_SIZE_X(uint32_t val)
{
	return ((val) << A7XX_GRAS_VRS_CONFIG_FRAG_SIZE_X__SHIFT) & A7XX_GRAS_VRS_CONFIG_FRAG_SIZE_X__MASK;
}
#define A7XX_GRAS_VRS_CONFIG_FRAG_SIZE_Y__MASK			0x00000018ull
#define A7XX_GRAS_VRS_CONFIG_FRAG_SIZE_Y__SHIFT			3
static CONSTEXPR inline uint32_t A7XX_GRAS_VRS_CONFIG_FRAG_SIZE_Y(uint32_t val)
{
	return ((val) << A7XX_GRAS_VRS_CONFIG_FRAG_SIZE_Y__SHIFT) & A7XX_GRAS_VRS_CONFIG_FRAG_SIZE_Y__MASK;
}
#define A7XX_GRAS_VRS_CONFIG_COMBINER_OP_1__MASK		0x000000e0ull
#define A7XX_GRAS_VRS_CONFIG_COMBINER_OP_1__SHIFT		5
static CONSTEXPR inline uint32_t A7XX_GRAS_VRS_CONFIG_COMBINER_OP_1(enum a6xx_fsr_combiner val)
{
	return ((val) << A7XX_GRAS_VRS_CONFIG_COMBINER_OP_1__SHIFT) & A7XX_GRAS_VRS_CONFIG_COMBINER_OP_1__MASK;
}
#define A7XX_GRAS_VRS_CONFIG_COMBINER_OP_2__MASK		0x00000700ull
#define A7XX_GRAS_VRS_CONFIG_COMBINER_OP_2__SHIFT		8
static CONSTEXPR inline uint32_t A7XX_GRAS_VRS_CONFIG_COMBINER_OP_2(enum a6xx_fsr_combiner val)
{
	return ((val) << A7XX_GRAS_VRS_CONFIG_COMBINER_OP_2__SHIFT) & A7XX_GRAS_VRS_CONFIG_COMBINER_OP_2__MASK;
}
#define A7XX_GRAS_VRS_CONFIG_COMBINER_CLAMP_MODE__MASK		0x00001800ull
#define A7XX_GRAS_VRS_CONFIG_COMBINER_CLAMP_MODE__SHIFT		11
static CONSTEXPR inline uint32_t A7XX_GRAS_VRS_CONFIG_COMBINER_CLAMP_MODE(enum a6xx_fsr_combiner_clamp_mode val)
{
	return ((val) << A7XX_GRAS_VRS_CONFIG_COMBINER_CLAMP_MODE__SHIFT) & A7XX_GRAS_VRS_CONFIG_COMBINER_CLAMP_MODE__MASK;
}
#define A7XX_GRAS_VRS_CONFIG_ATTACHMENT_FSR_ENABLE		0x00002000
#define A7XX_GRAS_VRS_CONFIG_PRIMITIVE_FSR_ENABLE		0x00100000
#define A7XX_GRAS_VRS_CONFIG_QUALITY_BUFFER_SHIFT_X__MASK	0x0000c000ull
#define A7XX_GRAS_VRS_CONFIG_QUALITY_BUFFER_SHIFT_X__SHIFT	14
static CONSTEXPR inline uint32_t A7XX_GRAS_VRS_CONFIG_QUALITY_BUFFER_SHIFT_X(uint32_t val)
{
	return ((val) << A7XX_GRAS_VRS_CONFIG_QUALITY_BUFFER_SHIFT_X__SHIFT) & A7XX_GRAS_VRS_CONFIG_QUALITY_BUFFER_SHIFT_X__MASK;
}
#define A7XX_GRAS_VRS_CONFIG_QUALITY_BUFFER_SHIFT_Y__MASK	0x00030000ull
#define A7XX_GRAS_VRS_CONFIG_QUALITY_BUFFER_SHIFT_Y__SHIFT	16
static CONSTEXPR inline uint32_t A7XX_GRAS_VRS_CONFIG_QUALITY_BUFFER_SHIFT_Y(uint32_t val)
{
	return ((val) << A7XX_GRAS_VRS_CONFIG_QUALITY_BUFFER_SHIFT_Y__SHIFT) & A7XX_GRAS_VRS_CONFIG_QUALITY_BUFFER_SHIFT_Y__MASK;
}


#define REG_A8XX_GRAS_VRS_CONFIG				__FD_DEPRECATED 0x00008208
#define A8XX_GRAS_VRS_CONFIG_PIPELINE_FSR_ENABLE		0x00000001
#define A8XX_GRAS_VRS_CONFIG_FRAG_SIZE_X__MASK			0x00000006ull
#define A8XX_GRAS_VRS_CONFIG_FRAG_SIZE_X__SHIFT			1
static CONSTEXPR inline uint32_t A8XX_GRAS_VRS_CONFIG_FRAG_SIZE_X(uint32_t val)
{
	return ((val) << A8XX_GRAS_VRS_CONFIG_FRAG_SIZE_X__SHIFT) & A8XX_GRAS_VRS_CONFIG_FRAG_SIZE_X__MASK;
}
#define A8XX_GRAS_VRS_CONFIG_FRAG_SIZE_Y__MASK			0x00000018ull
#define A8XX_GRAS_VRS_CONFIG_FRAG_SIZE_Y__SHIFT			3
static CONSTEXPR inline uint32_t A8XX_GRAS_VRS_CONFIG_FRAG_SIZE_Y(uint32_t val)
{
	return ((val) << A8XX_GRAS_VRS_CONFIG_FRAG_SIZE_Y__SHIFT) & A8XX_GRAS_VRS_CONFIG_FRAG_SIZE_Y__MASK;
}
#define A8XX_GRAS_VRS_CONFIG_COMBINER_OP_1__MASK		0x000000e0ull
#define A8XX_GRAS_VRS_CONFIG_COMBINER_OP_1__SHIFT		5
static CONSTEXPR inline uint32_t A8XX_GRAS_VRS_CONFIG_COMBINER_OP_1(enum a6xx_fsr_combiner val)
{
	return ((val) << A8XX_GRAS_VRS_CONFIG_COMBINER_OP_1__SHIFT) & A8XX_GRAS_VRS_CONFIG_COMBINER_OP_1__MASK;
}
#define A8XX_GRAS_VRS_CONFIG_COMBINER_OP_2__MASK		0x00000700ull
#define A8XX_GRAS_VRS_CONFIG_COMBINER_OP_2__SHIFT		8
static CONSTEXPR inline uint32_t A8XX_GRAS_VRS_CONFIG_COMBINER_OP_2(enum a6xx_fsr_combiner val)
{
	return ((val) << A8XX_GRAS_VRS_CONFIG_COMBINER_OP_2__SHIFT) & A8XX_GRAS_VRS_CONFIG_COMBINER_OP_2__MASK;
}
#define A8XX_GRAS_VRS_CONFIG_COMBINER_CLAMP_MODE__MASK		0x00001800ull
#define A8XX_GRAS_VRS_CONFIG_COMBINER_CLAMP_MODE__SHIFT		11
static CONSTEXPR inline uint32_t A8XX_GRAS_VRS_CONFIG_COMBINER_CLAMP_MODE(enum a6xx_fsr_combiner_clamp_mode val)
{
	return ((val) << A8XX_GRAS_VRS_CONFIG_COMBINER_CLAMP_MODE__SHIFT) & A8XX_GRAS_VRS_CONFIG_COMBINER_CLAMP_MODE__MASK;
}
#define A8XX_GRAS_VRS_CONFIG_ATTACHMENT_FSR_ENABLE		0x00002000
#define A8XX_GRAS_VRS_CONFIG_PRIMITIVE_FSR_ENABLE		0x00100000


#define REG_A7XX_GRAS_QUALITY_BUFFER_INFO			__FD_DEPRECATED 0x000080f5
#define A7XX_GRAS_QUALITY_BUFFER_INFO_LAYERED			0x00000001
#define A7XX_GRAS_QUALITY_BUFFER_INFO_TILE_MODE__MASK		0x00000006ull
#define A7XX_GRAS_QUALITY_BUFFER_INFO_TILE_MODE__SHIFT		1
static CONSTEXPR inline uint32_t A7XX_GRAS_QUALITY_BUFFER_INFO_TILE_MODE(enum a6xx_tile_mode val)
{
	return ((val) << A7XX_GRAS_QUALITY_BUFFER_INFO_TILE_MODE__SHIFT) & A7XX_GRAS_QUALITY_BUFFER_INFO_TILE_MODE__MASK;
}


#define REG_A8XX_GRAS_QUALITY_BUFFER_INFO			__FD_DEPRECATED 0x0000808e
#define A8XX_GRAS_QUALITY_BUFFER_INFO_LAYERED			0x00000001
#define A8XX_GRAS_QUALITY_BUFFER_INFO_TILE_MODE__MASK		0x00000006ull
#define A8XX_GRAS_QUALITY_BUFFER_INFO_TILE_MODE__SHIFT		1
static CONSTEXPR inline uint32_t A8XX_GRAS_QUALITY_BUFFER_INFO_TILE_MODE(enum a6xx_tile_mode val)
{
	return ((val) << A8XX_GRAS_QUALITY_BUFFER_INFO_TILE_MODE__SHIFT) & A8XX_GRAS_QUALITY_BUFFER_INFO_TILE_MODE__MASK;
}
#define A8XX_GRAS_QUALITY_BUFFER_INFO_QUALITY_BUFFER_SHIFT_X__MASK	0x00000030ull
#define A8XX_GRAS_QUALITY_BUFFER_INFO_QUALITY_BUFFER_SHIFT_X__SHIFT	4
static CONSTEXPR inline uint32_t A8XX_GRAS_QUALITY_BUFFER_INFO_QUALITY_BUFFER_SHIFT_X(uint32_t val)
{
	return ((val) << A8XX_GRAS_QUALITY_BUFFER_INFO_QUALITY_BUFFER_SHIFT_X__SHIFT) & A8XX_GRAS_QUALITY_BUFFER_INFO_QUALITY_BUFFER_SHIFT_X__MASK;
}
#define A8XX_GRAS_QUALITY_BUFFER_INFO_QUALITY_BUFFER_SHIFT_Y__MASK	0x000000c0ull
#define A8XX_GRAS_QUALITY_BUFFER_INFO_QUALITY_BUFFER_SHIFT_Y__SHIFT	6
static CONSTEXPR inline uint32_t A8XX_GRAS_QUALITY_BUFFER_INFO_QUALITY_BUFFER_SHIFT_Y(uint32_t val)
{
	return ((val) << A8XX_GRAS_QUALITY_BUFFER_INFO_QUALITY_BUFFER_SHIFT_Y__SHIFT) & A8XX_GRAS_QUALITY_BUFFER_INFO_QUALITY_BUFFER_SHIFT_Y__MASK;
}


#define REG_A7XX_GRAS_QUALITY_BUFFER_DIMENSION			__FD_DEPRECATED 0x000080f6
#define A7XX_GRAS_QUALITY_BUFFER_DIMENSION_WIDTH__MASK		0x0000ffffull
#define A7XX_GRAS_QUALITY_BUFFER_DIMENSION_WIDTH__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_GRAS_QUALITY_BUFFER_DIMENSION_WIDTH(uint32_t val)
{
	return ((val) << A7XX_GRAS_QUALITY_BUFFER_DIMENSION_WIDTH__SHIFT) & A7XX_GRAS_QUALITY_BUFFER_DIMENSION_WIDTH__MASK;
}
#define A7XX_GRAS_QUALITY_BUFFER_DIMENSION_HEIGHT__MASK		0xffff0000ull
#define A7XX_GRAS_QUALITY_BUFFER_DIMENSION_HEIGHT__SHIFT	16
static CONSTEXPR inline uint32_t A7XX_GRAS_QUALITY_BUFFER_DIMENSION_HEIGHT(uint32_t val)
{
	return ((val) << A7XX_GRAS_QUALITY_BUFFER_DIMENSION_HEIGHT__SHIFT) & A7XX_GRAS_QUALITY_BUFFER_DIMENSION_HEIGHT__MASK;
}


#define REG_A8XX_GRAS_QUALITY_BUFFER_DIMENSION			__FD_DEPRECATED 0x0000808f
#define A8XX_GRAS_QUALITY_BUFFER_DIMENSION_WIDTH__MASK		0x0000ffffull
#define A8XX_GRAS_QUALITY_BUFFER_DIMENSION_WIDTH__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_GRAS_QUALITY_BUFFER_DIMENSION_WIDTH(uint32_t val)
{
	return ((val) << A8XX_GRAS_QUALITY_BUFFER_DIMENSION_WIDTH__SHIFT) & A8XX_GRAS_QUALITY_BUFFER_DIMENSION_WIDTH__MASK;
}
#define A8XX_GRAS_QUALITY_BUFFER_DIMENSION_HEIGHT__MASK		0xffff0000ull
#define A8XX_GRAS_QUALITY_BUFFER_DIMENSION_HEIGHT__SHIFT	16
static CONSTEXPR inline uint32_t A8XX_GRAS_QUALITY_BUFFER_DIMENSION_HEIGHT(uint32_t val)
{
	return ((val) << A8XX_GRAS_QUALITY_BUFFER_DIMENSION_HEIGHT__SHIFT) & A8XX_GRAS_QUALITY_BUFFER_DIMENSION_HEIGHT__MASK;
}


#define REG_A7XX_GRAS_QUALITY_BUFFER_BASE			__FD_DEPRECATED 0x000080f8
static CONSTEXPR inline uint32_t A7XX_GRAS_QUALITY_BUFFER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_GRAS_QUALITY_BUFFER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_GRAS_QUALITY_BUFFER_BASE			__FD_DEPRECATED 0x00008090
static CONSTEXPR inline uint32_t A8XX_GRAS_QUALITY_BUFFER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_GRAS_QUALITY_BUFFER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A7XX_GRAS_QUALITY_BUFFER_PITCH			__FD_DEPRECATED 0x000080fa
#define A7XX_GRAS_QUALITY_BUFFER_PITCH_PITCH__MASK		0x000000ffull
#define A7XX_GRAS_QUALITY_BUFFER_PITCH_PITCH__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_GRAS_QUALITY_BUFFER_PITCH_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A7XX_GRAS_QUALITY_BUFFER_PITCH_PITCH__SHIFT) & A7XX_GRAS_QUALITY_BUFFER_PITCH_PITCH__MASK;
}
#define A7XX_GRAS_QUALITY_BUFFER_PITCH_ARRAY_PITCH__MASK	0x1ffffc00ull
#define A7XX_GRAS_QUALITY_BUFFER_PITCH_ARRAY_PITCH__SHIFT	10
static CONSTEXPR inline uint32_t A7XX_GRAS_QUALITY_BUFFER_PITCH_ARRAY_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A7XX_GRAS_QUALITY_BUFFER_PITCH_ARRAY_PITCH__SHIFT) & A7XX_GRAS_QUALITY_BUFFER_PITCH_ARRAY_PITCH__MASK;
}


#define REG_A8XX_GRAS_QUALITY_BUFFER_PITCH			__FD_DEPRECATED 0x00008092
#define A8XX_GRAS_QUALITY_BUFFER_PITCH_PITCH__MASK		0x000000ffull
#define A8XX_GRAS_QUALITY_BUFFER_PITCH_PITCH__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_GRAS_QUALITY_BUFFER_PITCH_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A8XX_GRAS_QUALITY_BUFFER_PITCH_PITCH__SHIFT) & A8XX_GRAS_QUALITY_BUFFER_PITCH_PITCH__MASK;
}
#define A8XX_GRAS_QUALITY_BUFFER_PITCH_ARRAY_PITCH__MASK	0x1ffffc00ull
#define A8XX_GRAS_QUALITY_BUFFER_PITCH_ARRAY_PITCH__SHIFT	10
static CONSTEXPR inline uint32_t A8XX_GRAS_QUALITY_BUFFER_PITCH_ARRAY_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A8XX_GRAS_QUALITY_BUFFER_PITCH_ARRAY_PITCH__SHIFT) & A8XX_GRAS_QUALITY_BUFFER_PITCH_ARRAY_PITCH__MASK;
}


#define REG_A6XX_GRAS_LRZ_CNTL					__FD_DEPRECATED 0x00008100
#define A6XX_GRAS_LRZ_CNTL_ENABLE				0x00000001
#define A6XX_GRAS_LRZ_CNTL_LRZ_WRITE				0x00000002
#define A6XX_GRAS_LRZ_CNTL_GREATER				0x00000004
#define A6XX_GRAS_LRZ_CNTL_Z_WRITE_ENABLE			0x00000010
#define A6XX_GRAS_LRZ_CNTL_Z_BOUNDS_ENABLE			0x00000020
#define A6XX_GRAS_LRZ_CNTL_DIR__MASK				0x000000c0ull
#define A6XX_GRAS_LRZ_CNTL_DIR__SHIFT				6
static CONSTEXPR inline uint32_t A6XX_GRAS_LRZ_CNTL_DIR(enum a6xx_lrz_dir_status val)
{
	return ((val) << A6XX_GRAS_LRZ_CNTL_DIR__SHIFT) & A6XX_GRAS_LRZ_CNTL_DIR__MASK;
}
#define A6XX_GRAS_LRZ_CNTL_DIR_WRITE				0x00000100
#define A6XX_GRAS_LRZ_CNTL_Z_FUNC__MASK				0x00003800ull
#define A6XX_GRAS_LRZ_CNTL_Z_FUNC__SHIFT			11
static CONSTEXPR inline uint32_t A6XX_GRAS_LRZ_CNTL_Z_FUNC(enum adreno_compare_func val)
{
	return ((val) << A6XX_GRAS_LRZ_CNTL_Z_FUNC__SHIFT) & A6XX_GRAS_LRZ_CNTL_Z_FUNC__MASK;
}
#define A6XX_GRAS_LRZ_CNTL_FC_ENABLE				0x00000008
#define A6XX_GRAS_LRZ_CNTL_DISABLE_ON_WRONG_DIR			0x00000200


#define REG_A7XX_GRAS_LRZ_CNTL					__FD_DEPRECATED 0x00008100
#define A7XX_GRAS_LRZ_CNTL_ENABLE				0x00000001
#define A7XX_GRAS_LRZ_CNTL_LRZ_WRITE				0x00000002
#define A7XX_GRAS_LRZ_CNTL_GREATER				0x00000004
#define A7XX_GRAS_LRZ_CNTL_Z_WRITE_ENABLE			0x00000010
#define A7XX_GRAS_LRZ_CNTL_Z_BOUNDS_ENABLE			0x00000020
#define A7XX_GRAS_LRZ_CNTL_DIR__MASK				0x000000c0ull
#define A7XX_GRAS_LRZ_CNTL_DIR__SHIFT				6
static CONSTEXPR inline uint32_t A7XX_GRAS_LRZ_CNTL_DIR(enum a6xx_lrz_dir_status val)
{
	return ((val) << A7XX_GRAS_LRZ_CNTL_DIR__SHIFT) & A7XX_GRAS_LRZ_CNTL_DIR__MASK;
}
#define A7XX_GRAS_LRZ_CNTL_DIR_WRITE				0x00000100
#define A7XX_GRAS_LRZ_CNTL_Z_FUNC__MASK				0x00003800ull
#define A7XX_GRAS_LRZ_CNTL_Z_FUNC__SHIFT			11
static CONSTEXPR inline uint32_t A7XX_GRAS_LRZ_CNTL_Z_FUNC(enum adreno_compare_func val)
{
	return ((val) << A7XX_GRAS_LRZ_CNTL_Z_FUNC__SHIFT) & A7XX_GRAS_LRZ_CNTL_Z_FUNC__MASK;
}


#define REG_A8XX_GRAS_LRZ_CNTL					__FD_DEPRECATED 0x00008212
#define A8XX_GRAS_LRZ_CNTL_ENABLE				0x00000001
#define A8XX_GRAS_LRZ_CNTL_LRZ_WRITE				0x00000002
#define A8XX_GRAS_LRZ_CNTL_GREATER				0x00000004
#define A8XX_GRAS_LRZ_CNTL_Z_WRITE_ENABLE			0x00000010
#define A8XX_GRAS_LRZ_CNTL_Z_BOUNDS_ENABLE			0x00000020
#define A8XX_GRAS_LRZ_CNTL_DIR__MASK				0x000000c0ull
#define A8XX_GRAS_LRZ_CNTL_DIR__SHIFT				6
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_CNTL_DIR(enum a6xx_lrz_dir_status val)
{
	return ((val) << A8XX_GRAS_LRZ_CNTL_DIR__SHIFT) & A8XX_GRAS_LRZ_CNTL_DIR__MASK;
}
#define A8XX_GRAS_LRZ_CNTL_DIR_WRITE				0x00000100
#define A8XX_GRAS_LRZ_CNTL_Z_FUNC__MASK				0x00003800ull
#define A8XX_GRAS_LRZ_CNTL_Z_FUNC__SHIFT			11
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_CNTL_Z_FUNC(enum adreno_compare_func val)
{
	return ((val) << A8XX_GRAS_LRZ_CNTL_Z_FUNC__SHIFT) & A8XX_GRAS_LRZ_CNTL_Z_FUNC__MASK;
}


#define REG_A7XX_GRAS_LRZ_CB_CNTL				__FD_DEPRECATED 0x00008007
#define A7XX_GRAS_LRZ_CB_CNTL_DOUBLE_BUFFER_PITCH__MASK		0xffffff00ull
#define A7XX_GRAS_LRZ_CB_CNTL_DOUBLE_BUFFER_PITCH__SHIFT	8
static CONSTEXPR inline uint32_t A7XX_GRAS_LRZ_CB_CNTL_DOUBLE_BUFFER_PITCH(uint32_t val)
{
	assert(!(val & 0xff));
	return (((val >> 8)) << A7XX_GRAS_LRZ_CB_CNTL_DOUBLE_BUFFER_PITCH__SHIFT) & A7XX_GRAS_LRZ_CB_CNTL_DOUBLE_BUFFER_PITCH__MASK;
}


#define REG_A8XX_GRAS_LRZ_CB_CNTL				__FD_DEPRECATED 0x00008101
#define A8XX_GRAS_LRZ_CB_CNTL_DOUBLE_BUFFER_PITCH__MASK		0xffffff00ull
#define A8XX_GRAS_LRZ_CB_CNTL_DOUBLE_BUFFER_PITCH__SHIFT	8
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_CB_CNTL_DOUBLE_BUFFER_PITCH(uint32_t val)
{
	assert(!(val & 0xff));
	return (((val >> 8)) << A8XX_GRAS_LRZ_CB_CNTL_DOUBLE_BUFFER_PITCH__SHIFT) & A8XX_GRAS_LRZ_CB_CNTL_DOUBLE_BUFFER_PITCH__MASK;
}


#define REG_A6XX_GRAS_LRZ_PS_INPUT_CNTL				__FD_DEPRECATED 0x00008101
#define A6XX_GRAS_LRZ_PS_INPUT_CNTL_SAMPLEID			0x00000001
#define A6XX_GRAS_LRZ_PS_INPUT_CNTL_FRAGCOORDSAMPLEMODE__MASK	0x00000006ull
#define A6XX_GRAS_LRZ_PS_INPUT_CNTL_FRAGCOORDSAMPLEMODE__SHIFT	1
static CONSTEXPR inline uint32_t A6XX_GRAS_LRZ_PS_INPUT_CNTL_FRAGCOORDSAMPLEMODE(enum a6xx_fragcoord_sample_mode val)
{
	return ((val) << A6XX_GRAS_LRZ_PS_INPUT_CNTL_FRAGCOORDSAMPLEMODE__SHIFT) & A6XX_GRAS_LRZ_PS_INPUT_CNTL_FRAGCOORDSAMPLEMODE__MASK;
}


#define REG_A8XX_GRAS_LRZ_PS_INPUT_CNTL				__FD_DEPRECATED 0x00008102
#define A8XX_GRAS_LRZ_PS_INPUT_CNTL_SAMPLEID			0x00000001
#define A8XX_GRAS_LRZ_PS_INPUT_CNTL_FRAGCOORDSAMPLEMODE__MASK	0x00000006ull
#define A8XX_GRAS_LRZ_PS_INPUT_CNTL_FRAGCOORDSAMPLEMODE__SHIFT	1
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_PS_INPUT_CNTL_FRAGCOORDSAMPLEMODE(enum a6xx_fragcoord_sample_mode val)
{
	return ((val) << A8XX_GRAS_LRZ_PS_INPUT_CNTL_FRAGCOORDSAMPLEMODE__SHIFT) & A8XX_GRAS_LRZ_PS_INPUT_CNTL_FRAGCOORDSAMPLEMODE__MASK;
}


#define REG_A6XX_GRAS_LRZ_MRT_BUFFER_INFO_0			__FD_DEPRECATED 0x00008102
#define A6XX_GRAS_LRZ_MRT_BUFFER_INFO_0_COLOR_FORMAT__MASK	0x000000ffull
#define A6XX_GRAS_LRZ_MRT_BUFFER_INFO_0_COLOR_FORMAT__SHIFT	0
static CONSTEXPR inline uint32_t A6XX_GRAS_LRZ_MRT_BUFFER_INFO_0_COLOR_FORMAT(enum a6xx_format val)
{
	return ((val) << A6XX_GRAS_LRZ_MRT_BUFFER_INFO_0_COLOR_FORMAT__SHIFT) & A6XX_GRAS_LRZ_MRT_BUFFER_INFO_0_COLOR_FORMAT__MASK;
}


#define REG_A8XX_GRAS_LRZ_MRT_BUFFER_INFO_0			__FD_DEPRECATED 0x00008103
#define A8XX_GRAS_LRZ_MRT_BUFFER_INFO_0_COLOR_FORMAT__MASK	0x000000ffull
#define A8XX_GRAS_LRZ_MRT_BUFFER_INFO_0_COLOR_FORMAT__SHIFT	0
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_MRT_BUFFER_INFO_0_COLOR_FORMAT(enum a6xx_format val)
{
	return ((val) << A8XX_GRAS_LRZ_MRT_BUFFER_INFO_0_COLOR_FORMAT__SHIFT) & A8XX_GRAS_LRZ_MRT_BUFFER_INFO_0_COLOR_FORMAT__MASK;
}


#define REG_A6XX_GRAS_LRZ_BUFFER_BASE				__FD_DEPRECATED 0x00008103
static CONSTEXPR inline uint32_t A6XX_GRAS_LRZ_BUFFER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_GRAS_LRZ_BUFFER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_GRAS_LRZ_BUFFER_BASE				__FD_DEPRECATED 0x00008104
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_BUFFER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_BUFFER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_GRAS_LRZ_BUFFER_PITCH				__FD_DEPRECATED 0x00008105
#define A6XX_GRAS_LRZ_BUFFER_PITCH_PITCH__MASK			0x000000ffull
#define A6XX_GRAS_LRZ_BUFFER_PITCH_PITCH__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_GRAS_LRZ_BUFFER_PITCH_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_GRAS_LRZ_BUFFER_PITCH_PITCH__SHIFT) & A6XX_GRAS_LRZ_BUFFER_PITCH_PITCH__MASK;
}
#define A6XX_GRAS_LRZ_BUFFER_PITCH_ARRAY_PITCH__MASK		0x1ffffc00ull
#define A6XX_GRAS_LRZ_BUFFER_PITCH_ARRAY_PITCH__SHIFT		10
static CONSTEXPR inline uint32_t A6XX_GRAS_LRZ_BUFFER_PITCH_ARRAY_PITCH(uint32_t val)
{
	assert(!(val & 0xff));
	return (((val >> 8)) << A6XX_GRAS_LRZ_BUFFER_PITCH_ARRAY_PITCH__SHIFT) & A6XX_GRAS_LRZ_BUFFER_PITCH_ARRAY_PITCH__MASK;
}


#define REG_A8XX_GRAS_LRZ_BUFFER_PITCH				__FD_DEPRECATED 0x00008108
#define A8XX_GRAS_LRZ_BUFFER_PITCH_PITCH__MASK			0x000000ffull
#define A8XX_GRAS_LRZ_BUFFER_PITCH_PITCH__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_BUFFER_PITCH_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A8XX_GRAS_LRZ_BUFFER_PITCH_PITCH__SHIFT) & A8XX_GRAS_LRZ_BUFFER_PITCH_PITCH__MASK;
}
#define A8XX_GRAS_LRZ_BUFFER_PITCH_ARRAY_PITCH__MASK		0x1ffffc00ull
#define A8XX_GRAS_LRZ_BUFFER_PITCH_ARRAY_PITCH__SHIFT		10
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_BUFFER_PITCH_ARRAY_PITCH(uint32_t val)
{
	assert(!(val & 0xff));
	return (((val >> 8)) << A8XX_GRAS_LRZ_BUFFER_PITCH_ARRAY_PITCH__SHIFT) & A8XX_GRAS_LRZ_BUFFER_PITCH_ARRAY_PITCH__MASK;
}


#define REG_A8XX_GRAS_LRZ_BUFFER_STRIDE				__FD_DEPRECATED 0x0000810e


#define REG_A6XX_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE		0x00008106
static CONSTEXPR inline uint32_t A6XX_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_GRAS_LRZ_PS_SAMPLEFREQ_CNTL			0x00008109
#define A6XX_GRAS_LRZ_PS_SAMPLEFREQ_CNTL_PER_SAMP_MODE		0x00000001


#define REG_A6XX_GRAS_LRZ_VIEW_INFO				0x0000810a
#define A6XX_GRAS_LRZ_VIEW_INFO_BASE_LAYER__MASK		0x000007ffull
#define A6XX_GRAS_LRZ_VIEW_INFO_BASE_LAYER__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_GRAS_LRZ_VIEW_INFO_BASE_LAYER(uint32_t val)
{
	return ((val) << A6XX_GRAS_LRZ_VIEW_INFO_BASE_LAYER__SHIFT) & A6XX_GRAS_LRZ_VIEW_INFO_BASE_LAYER__MASK;
}
#define A6XX_GRAS_LRZ_VIEW_INFO_LAYER_COUNT__MASK		0x07ff0000ull
#define A6XX_GRAS_LRZ_VIEW_INFO_LAYER_COUNT__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_GRAS_LRZ_VIEW_INFO_LAYER_COUNT(uint32_t val)
{
	return ((val) << A6XX_GRAS_LRZ_VIEW_INFO_LAYER_COUNT__SHIFT) & A6XX_GRAS_LRZ_VIEW_INFO_LAYER_COUNT__MASK;
}
#define A6XX_GRAS_LRZ_VIEW_INFO_BASE_MIP_LEVEL__MASK		0xf0000000ull
#define A6XX_GRAS_LRZ_VIEW_INFO_BASE_MIP_LEVEL__SHIFT		28
static CONSTEXPR inline uint32_t A6XX_GRAS_LRZ_VIEW_INFO_BASE_MIP_LEVEL(uint32_t val)
{
	return ((val) << A6XX_GRAS_LRZ_VIEW_INFO_BASE_MIP_LEVEL__SHIFT) & A6XX_GRAS_LRZ_VIEW_INFO_BASE_MIP_LEVEL__MASK;
}


#define REG_A7XX_GRAS_LRZ_CNTL2					__FD_DEPRECATED 0x0000810b
#define A7XX_GRAS_LRZ_CNTL2_DISABLE_ON_WRONG_DIR		0x00000001
#define A7XX_GRAS_LRZ_CNTL2_FC_ENABLE				0x00000002


#define REG_A8XX_GRAS_LRZ_BUFFER_SLICE_PITCH			__FD_DEPRECATED 0x00008110
#define A8XX_GRAS_LRZ_BUFFER_SLICE_PITCH__MASK			0xffffff00ull
#define A8XX_GRAS_LRZ_BUFFER_SLICE_PITCH__SHIFT			8
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_BUFFER_SLICE_PITCH(uint32_t val)
{
	assert(!(val & 0xff));
	return (((val >> 8)) << A8XX_GRAS_LRZ_BUFFER_SLICE_PITCH__SHIFT) & A8XX_GRAS_LRZ_BUFFER_SLICE_PITCH__MASK;
}


#define REG_A6XX_GRAS_MODE_CNTL					__FD_DEPRECATED 0x00008110


#define REG_A8XX_GRAS_MODE_CNTL					__FD_DEPRECATED 0x00008213


#define REG_A7XX_GRAS_LRZ_DEPTH_CLEAR				__FD_DEPRECATED 0x00008111
#define A7XX_GRAS_LRZ_DEPTH_CLEAR__MASK				0xffffffffull
#define A7XX_GRAS_LRZ_DEPTH_CLEAR__SHIFT			0
static inline uint32_t A7XX_GRAS_LRZ_DEPTH_CLEAR(float val)
{
	return ((fui(val)) << A7XX_GRAS_LRZ_DEPTH_CLEAR__SHIFT) & A7XX_GRAS_LRZ_DEPTH_CLEAR__MASK;
}


#define REG_A8XX_GRAS_LRZ_DEPTH_CLEAR				__FD_DEPRECATED 0x0000810d
#define A8XX_GRAS_LRZ_DEPTH_CLEAR__MASK				0xffffffffull
#define A8XX_GRAS_LRZ_DEPTH_CLEAR__SHIFT			0
static inline uint32_t A8XX_GRAS_LRZ_DEPTH_CLEAR(float val)
{
	return ((fui(val)) << A8XX_GRAS_LRZ_DEPTH_CLEAR__SHIFT) & A8XX_GRAS_LRZ_DEPTH_CLEAR__MASK;
}


#define REG_A7XX_GRAS_LRZ_DEPTH_BUFFER_INFO			__FD_DEPRECATED 0x00008113
#define A7XX_GRAS_LRZ_DEPTH_BUFFER_INFO_DEPTH_FORMAT__MASK	0x00000007ull
#define A7XX_GRAS_LRZ_DEPTH_BUFFER_INFO_DEPTH_FORMAT__SHIFT	0
static CONSTEXPR inline uint32_t A7XX_GRAS_LRZ_DEPTH_BUFFER_INFO_DEPTH_FORMAT(enum a6xx_depth_format val)
{
	return ((val) << A7XX_GRAS_LRZ_DEPTH_BUFFER_INFO_DEPTH_FORMAT__SHIFT) & A7XX_GRAS_LRZ_DEPTH_BUFFER_INFO_DEPTH_FORMAT__MASK;
}
#define A7XX_GRAS_LRZ_DEPTH_BUFFER_INFO_READ_ONLY		0x00000008


#define REG_A8XX_GRAS_LRZ_DEPTH_BUFFER_INFO			__FD_DEPRECATED 0x0000810f
#define A8XX_GRAS_LRZ_DEPTH_BUFFER_INFO_DEPTH_FORMAT__MASK	0x00000007ull
#define A8XX_GRAS_LRZ_DEPTH_BUFFER_INFO_DEPTH_FORMAT__SHIFT	0
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_DEPTH_BUFFER_INFO_DEPTH_FORMAT(enum a6xx_depth_format val)
{
	return ((val) << A8XX_GRAS_LRZ_DEPTH_BUFFER_INFO_DEPTH_FORMAT__SHIFT) & A8XX_GRAS_LRZ_DEPTH_BUFFER_INFO_DEPTH_FORMAT__MASK;
}
#define A8XX_GRAS_LRZ_DEPTH_BUFFER_INFO_READ_ONLY		0x00000008


#define REG_A7XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE(i0)		(0x00008120 + 0x1*i0 )



#define REG_A8XX_GRAS_LRZ_QUALITY_LOOKUP_TABLE(i0)		(0x00008130 + 0x1*i0 )



#define REG_A8XX_GRAS_LRZ_COLOR_COMP_MASK			__FD_DEPRECATED 0x0000810c
#define A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT0__MASK		0x0000000full
#define A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT0__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT0(uint32_t val)
{
	return ((val) << A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT0__SHIFT) & A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT0__MASK;
}
#define A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT1__MASK		0x000000f0ull
#define A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT1__SHIFT		4
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT1(uint32_t val)
{
	return ((val) << A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT1__SHIFT) & A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT1__MASK;
}
#define A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT2__MASK		0x00000f00ull
#define A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT2__SHIFT		8
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT2(uint32_t val)
{
	return ((val) << A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT2__SHIFT) & A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT2__MASK;
}
#define A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT3__MASK		0x0000f000ull
#define A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT3__SHIFT		12
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT3(uint32_t val)
{
	return ((val) << A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT3__SHIFT) & A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT3__MASK;
}
#define A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT4__MASK		0x000f0000ull
#define A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT4__SHIFT		16
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT4(uint32_t val)
{
	return ((val) << A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT4__SHIFT) & A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT4__MASK;
}
#define A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT5__MASK		0x00f00000ull
#define A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT5__SHIFT		20
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT5(uint32_t val)
{
	return ((val) << A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT5__SHIFT) & A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT5__MASK;
}
#define A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT6__MASK		0x0f000000ull
#define A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT6__SHIFT		24
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT6(uint32_t val)
{
	return ((val) << A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT6__SHIFT) & A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT6__MASK;
}
#define A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT7__MASK		0xf0000000ull
#define A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT7__SHIFT		28
static CONSTEXPR inline uint32_t A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT7(uint32_t val)
{
	return ((val) << A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT7__SHIFT) & A8XX_GRAS_LRZ_COLOR_COMP_MASK_MRT7__MASK;
}


#define REG_A6XX_GRAS_A2D_BLT_CNTL				__FD_DEPRECATED 0x00008400
#define A6XX_GRAS_A2D_BLT_CNTL_ROTATE__MASK			0x00000007ull
#define A6XX_GRAS_A2D_BLT_CNTL_ROTATE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_BLT_CNTL_ROTATE(enum a6xx_rotation val)
{
	return ((val) << A6XX_GRAS_A2D_BLT_CNTL_ROTATE__SHIFT) & A6XX_GRAS_A2D_BLT_CNTL_ROTATE__MASK;
}
#define A6XX_GRAS_A2D_BLT_CNTL_OVERWRITEEN			0x00000008
#define A6XX_GRAS_A2D_BLT_CNTL_UNK4__MASK			0x00000070ull
#define A6XX_GRAS_A2D_BLT_CNTL_UNK4__SHIFT			4
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_BLT_CNTL_UNK4(uint32_t val)
{
	return ((val) << A6XX_GRAS_A2D_BLT_CNTL_UNK4__SHIFT) & A6XX_GRAS_A2D_BLT_CNTL_UNK4__MASK;
}
#define A6XX_GRAS_A2D_BLT_CNTL_SOLID_COLOR			0x00000080
#define A6XX_GRAS_A2D_BLT_CNTL_COLOR_FORMAT__MASK		0x0000ff00ull
#define A6XX_GRAS_A2D_BLT_CNTL_COLOR_FORMAT__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_BLT_CNTL_COLOR_FORMAT(enum a6xx_format val)
{
	return ((val) << A6XX_GRAS_A2D_BLT_CNTL_COLOR_FORMAT__SHIFT) & A6XX_GRAS_A2D_BLT_CNTL_COLOR_FORMAT__MASK;
}
#define A6XX_GRAS_A2D_BLT_CNTL_SCISSOR				0x00010000
#define A6XX_GRAS_A2D_BLT_CNTL_UNK17__MASK			0x00060000ull
#define A6XX_GRAS_A2D_BLT_CNTL_UNK17__SHIFT			17
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_BLT_CNTL_UNK17(uint32_t val)
{
	return ((val) << A6XX_GRAS_A2D_BLT_CNTL_UNK17__SHIFT) & A6XX_GRAS_A2D_BLT_CNTL_UNK17__MASK;
}
#define A6XX_GRAS_A2D_BLT_CNTL_D24S8				0x00080000
#define A6XX_GRAS_A2D_BLT_CNTL_MASK__MASK			0x00f00000ull
#define A6XX_GRAS_A2D_BLT_CNTL_MASK__SHIFT			20
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_BLT_CNTL_MASK(uint32_t val)
{
	return ((val) << A6XX_GRAS_A2D_BLT_CNTL_MASK__SHIFT) & A6XX_GRAS_A2D_BLT_CNTL_MASK__MASK;
}
#define A6XX_GRAS_A2D_BLT_CNTL_IFMT__MASK			0x07000000ull
#define A6XX_GRAS_A2D_BLT_CNTL_IFMT__SHIFT			24
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_BLT_CNTL_IFMT(enum a6xx_2d_ifmt val)
{
	return ((val) << A6XX_GRAS_A2D_BLT_CNTL_IFMT__SHIFT) & A6XX_GRAS_A2D_BLT_CNTL_IFMT__MASK;
}
#define A6XX_GRAS_A2D_BLT_CNTL_UNK27				0x08000000
#define A6XX_GRAS_A2D_BLT_CNTL_UNK28				0x10000000
#define A6XX_GRAS_A2D_BLT_CNTL_RASTER_MODE__MASK		0x20000000ull
#define A6XX_GRAS_A2D_BLT_CNTL_RASTER_MODE__SHIFT		29
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_BLT_CNTL_RASTER_MODE(enum a6xx_raster_mode val)
{
	return ((val) << A6XX_GRAS_A2D_BLT_CNTL_RASTER_MODE__SHIFT) & A6XX_GRAS_A2D_BLT_CNTL_RASTER_MODE__MASK;
}
#define A6XX_GRAS_A2D_BLT_CNTL_COPY				0x40000000


#define REG_A6XX_GRAS_A2D_SRC_XMIN				__FD_DEPRECATED 0x00008401
#define A6XX_GRAS_A2D_SRC_XMIN__MASK				0x01ffff00ull
#define A6XX_GRAS_A2D_SRC_XMIN__SHIFT				8
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_SRC_XMIN(int32_t val)
{
	return ((val) << A6XX_GRAS_A2D_SRC_XMIN__SHIFT) & A6XX_GRAS_A2D_SRC_XMIN__MASK;
}


#define REG_A6XX_GRAS_A2D_SRC_XMAX				__FD_DEPRECATED 0x00008402
#define A6XX_GRAS_A2D_SRC_XMAX__MASK				0x01ffff00ull
#define A6XX_GRAS_A2D_SRC_XMAX__SHIFT				8
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_SRC_XMAX(int32_t val)
{
	return ((val) << A6XX_GRAS_A2D_SRC_XMAX__SHIFT) & A6XX_GRAS_A2D_SRC_XMAX__MASK;
}


#define REG_A6XX_GRAS_A2D_SRC_YMIN				__FD_DEPRECATED 0x00008403
#define A6XX_GRAS_A2D_SRC_YMIN__MASK				0x01ffff00ull
#define A6XX_GRAS_A2D_SRC_YMIN__SHIFT				8
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_SRC_YMIN(int32_t val)
{
	return ((val) << A6XX_GRAS_A2D_SRC_YMIN__SHIFT) & A6XX_GRAS_A2D_SRC_YMIN__MASK;
}


#define REG_A6XX_GRAS_A2D_SRC_YMAX				__FD_DEPRECATED 0x00008404
#define A6XX_GRAS_A2D_SRC_YMAX__MASK				0x01ffff00ull
#define A6XX_GRAS_A2D_SRC_YMAX__SHIFT				8
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_SRC_YMAX(int32_t val)
{
	return ((val) << A6XX_GRAS_A2D_SRC_YMAX__SHIFT) & A6XX_GRAS_A2D_SRC_YMAX__MASK;
}


#define REG_A6XX_GRAS_A2D_DEST_TL				__FD_DEPRECATED 0x00008405
#define A6XX_GRAS_A2D_DEST_TL_X__MASK				0x00003fffull
#define A6XX_GRAS_A2D_DEST_TL_X__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_DEST_TL_X(uint32_t val)
{
	return ((val) << A6XX_GRAS_A2D_DEST_TL_X__SHIFT) & A6XX_GRAS_A2D_DEST_TL_X__MASK;
}
#define A6XX_GRAS_A2D_DEST_TL_Y__MASK				0x3fff0000ull
#define A6XX_GRAS_A2D_DEST_TL_Y__SHIFT				16
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_DEST_TL_Y(uint32_t val)
{
	return ((val) << A6XX_GRAS_A2D_DEST_TL_Y__SHIFT) & A6XX_GRAS_A2D_DEST_TL_Y__MASK;
}


#define REG_A6XX_GRAS_A2D_DEST_BR				__FD_DEPRECATED 0x00008406
#define A6XX_GRAS_A2D_DEST_BR_X__MASK				0x00003fffull
#define A6XX_GRAS_A2D_DEST_BR_X__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_DEST_BR_X(uint32_t val)
{
	return ((val) << A6XX_GRAS_A2D_DEST_BR_X__SHIFT) & A6XX_GRAS_A2D_DEST_BR_X__MASK;
}
#define A6XX_GRAS_A2D_DEST_BR_Y__MASK				0x3fff0000ull
#define A6XX_GRAS_A2D_DEST_BR_Y__SHIFT				16
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_DEST_BR_Y(uint32_t val)
{
	return ((val) << A6XX_GRAS_A2D_DEST_BR_Y__SHIFT) & A6XX_GRAS_A2D_DEST_BR_Y__MASK;
}


#define REG_A6XX_GRAS_2D_UNKNOWN_8407				0x00008407


#define REG_A6XX_GRAS_2D_UNKNOWN_8408				0x00008408


#define REG_A6XX_GRAS_2D_UNKNOWN_8409				0x00008409


#define REG_A6XX_GRAS_A2D_SCISSOR_TL				__FD_DEPRECATED 0x0000840a
#define A6XX_GRAS_A2D_SCISSOR_TL_X__MASK			0x00003fffull
#define A6XX_GRAS_A2D_SCISSOR_TL_X__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_SCISSOR_TL_X(uint32_t val)
{
	return ((val) << A6XX_GRAS_A2D_SCISSOR_TL_X__SHIFT) & A6XX_GRAS_A2D_SCISSOR_TL_X__MASK;
}
#define A6XX_GRAS_A2D_SCISSOR_TL_Y__MASK			0x3fff0000ull
#define A6XX_GRAS_A2D_SCISSOR_TL_Y__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_SCISSOR_TL_Y(uint32_t val)
{
	return ((val) << A6XX_GRAS_A2D_SCISSOR_TL_Y__SHIFT) & A6XX_GRAS_A2D_SCISSOR_TL_Y__MASK;
}


#define REG_A6XX_GRAS_A2D_SCISSOR_BR				__FD_DEPRECATED 0x0000840b
#define A6XX_GRAS_A2D_SCISSOR_BR_X__MASK			0x00003fffull
#define A6XX_GRAS_A2D_SCISSOR_BR_X__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_SCISSOR_BR_X(uint32_t val)
{
	return ((val) << A6XX_GRAS_A2D_SCISSOR_BR_X__SHIFT) & A6XX_GRAS_A2D_SCISSOR_BR_X__MASK;
}
#define A6XX_GRAS_A2D_SCISSOR_BR_Y__MASK			0x3fff0000ull
#define A6XX_GRAS_A2D_SCISSOR_BR_Y__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_GRAS_A2D_SCISSOR_BR_Y(uint32_t val)
{
	return ((val) << A6XX_GRAS_A2D_SCISSOR_BR_Y__SHIFT) & A6XX_GRAS_A2D_SCISSOR_BR_Y__MASK;
}


#define REG_A8XX_GRAS_A2D_BLT_CNTL				__FD_DEPRECATED 0x00008500
#define A8XX_GRAS_A2D_BLT_CNTL_ROTATE__MASK			0x00000007ull
#define A8XX_GRAS_A2D_BLT_CNTL_ROTATE__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_BLT_CNTL_ROTATE(enum a6xx_rotation val)
{
	return ((val) << A8XX_GRAS_A2D_BLT_CNTL_ROTATE__SHIFT) & A8XX_GRAS_A2D_BLT_CNTL_ROTATE__MASK;
}
#define A8XX_GRAS_A2D_BLT_CNTL_OVERWRITEEN			0x00000008
#define A8XX_GRAS_A2D_BLT_CNTL_UNK4__MASK			0x00000070ull
#define A8XX_GRAS_A2D_BLT_CNTL_UNK4__SHIFT			4
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_BLT_CNTL_UNK4(uint32_t val)
{
	return ((val) << A8XX_GRAS_A2D_BLT_CNTL_UNK4__SHIFT) & A8XX_GRAS_A2D_BLT_CNTL_UNK4__MASK;
}
#define A8XX_GRAS_A2D_BLT_CNTL_SOLID_COLOR			0x00000080
#define A8XX_GRAS_A2D_BLT_CNTL_COLOR_FORMAT__MASK		0x0000ff00ull
#define A8XX_GRAS_A2D_BLT_CNTL_COLOR_FORMAT__SHIFT		8
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_BLT_CNTL_COLOR_FORMAT(enum a6xx_format val)
{
	return ((val) << A8XX_GRAS_A2D_BLT_CNTL_COLOR_FORMAT__SHIFT) & A8XX_GRAS_A2D_BLT_CNTL_COLOR_FORMAT__MASK;
}
#define A8XX_GRAS_A2D_BLT_CNTL_SCISSOR				0x00010000
#define A8XX_GRAS_A2D_BLT_CNTL_UNK17__MASK			0x00060000ull
#define A8XX_GRAS_A2D_BLT_CNTL_UNK17__SHIFT			17
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_BLT_CNTL_UNK17(uint32_t val)
{
	return ((val) << A8XX_GRAS_A2D_BLT_CNTL_UNK17__SHIFT) & A8XX_GRAS_A2D_BLT_CNTL_UNK17__MASK;
}
#define A8XX_GRAS_A2D_BLT_CNTL_D24S8				0x00080000
#define A8XX_GRAS_A2D_BLT_CNTL_MASK__MASK			0x00f00000ull
#define A8XX_GRAS_A2D_BLT_CNTL_MASK__SHIFT			20
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_BLT_CNTL_MASK(uint32_t val)
{
	return ((val) << A8XX_GRAS_A2D_BLT_CNTL_MASK__SHIFT) & A8XX_GRAS_A2D_BLT_CNTL_MASK__MASK;
}
#define A8XX_GRAS_A2D_BLT_CNTL_IFMT__MASK			0x07000000ull
#define A8XX_GRAS_A2D_BLT_CNTL_IFMT__SHIFT			24
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_BLT_CNTL_IFMT(enum a6xx_2d_ifmt val)
{
	return ((val) << A8XX_GRAS_A2D_BLT_CNTL_IFMT__SHIFT) & A8XX_GRAS_A2D_BLT_CNTL_IFMT__MASK;
}
#define A8XX_GRAS_A2D_BLT_CNTL_UNK27				0x08000000
#define A8XX_GRAS_A2D_BLT_CNTL_UNK28				0x10000000
#define A8XX_GRAS_A2D_BLT_CNTL_RASTER_MODE__MASK		0x20000000ull
#define A8XX_GRAS_A2D_BLT_CNTL_RASTER_MODE__SHIFT		29
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_BLT_CNTL_RASTER_MODE(enum a6xx_raster_mode val)
{
	return ((val) << A8XX_GRAS_A2D_BLT_CNTL_RASTER_MODE__SHIFT) & A8XX_GRAS_A2D_BLT_CNTL_RASTER_MODE__MASK;
}
#define A8XX_GRAS_A2D_BLT_CNTL_COPY				0x40000000


#define REG_A8XX_GRAS_A2D_SRC_XMIN				__FD_DEPRECATED 0x00008501
#define A8XX_GRAS_A2D_SRC_XMIN__MASK				0x01ffff00ull
#define A8XX_GRAS_A2D_SRC_XMIN__SHIFT				8
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_SRC_XMIN(int32_t val)
{
	return ((val) << A8XX_GRAS_A2D_SRC_XMIN__SHIFT) & A8XX_GRAS_A2D_SRC_XMIN__MASK;
}


#define REG_A8XX_GRAS_A2D_SRC_XMAX				__FD_DEPRECATED 0x00008502
#define A8XX_GRAS_A2D_SRC_XMAX__MASK				0x01ffff00ull
#define A8XX_GRAS_A2D_SRC_XMAX__SHIFT				8
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_SRC_XMAX(int32_t val)
{
	return ((val) << A8XX_GRAS_A2D_SRC_XMAX__SHIFT) & A8XX_GRAS_A2D_SRC_XMAX__MASK;
}


#define REG_A8XX_GRAS_A2D_SRC_YMIN				__FD_DEPRECATED 0x00008503
#define A8XX_GRAS_A2D_SRC_YMIN__MASK				0x01ffff00ull
#define A8XX_GRAS_A2D_SRC_YMIN__SHIFT				8
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_SRC_YMIN(int32_t val)
{
	return ((val) << A8XX_GRAS_A2D_SRC_YMIN__SHIFT) & A8XX_GRAS_A2D_SRC_YMIN__MASK;
}


#define REG_A8XX_GRAS_A2D_SRC_YMAX				__FD_DEPRECATED 0x00008504
#define A8XX_GRAS_A2D_SRC_YMAX__MASK				0x01ffff00ull
#define A8XX_GRAS_A2D_SRC_YMAX__SHIFT				8
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_SRC_YMAX(int32_t val)
{
	return ((val) << A8XX_GRAS_A2D_SRC_YMAX__SHIFT) & A8XX_GRAS_A2D_SRC_YMAX__MASK;
}


#define REG_A8XX_GRAS_A2D_DEST_TL				__FD_DEPRECATED 0x00008505
#define A8XX_GRAS_A2D_DEST_TL_X__MASK				0x00003fffull
#define A8XX_GRAS_A2D_DEST_TL_X__SHIFT				0
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_DEST_TL_X(uint32_t val)
{
	return ((val) << A8XX_GRAS_A2D_DEST_TL_X__SHIFT) & A8XX_GRAS_A2D_DEST_TL_X__MASK;
}
#define A8XX_GRAS_A2D_DEST_TL_Y__MASK				0x3fff0000ull
#define A8XX_GRAS_A2D_DEST_TL_Y__SHIFT				16
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_DEST_TL_Y(uint32_t val)
{
	return ((val) << A8XX_GRAS_A2D_DEST_TL_Y__SHIFT) & A8XX_GRAS_A2D_DEST_TL_Y__MASK;
}


#define REG_A8XX_GRAS_A2D_DEST_BR				__FD_DEPRECATED 0x00008506
#define A8XX_GRAS_A2D_DEST_BR_X__MASK				0x00003fffull
#define A8XX_GRAS_A2D_DEST_BR_X__SHIFT				0
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_DEST_BR_X(uint32_t val)
{
	return ((val) << A8XX_GRAS_A2D_DEST_BR_X__SHIFT) & A8XX_GRAS_A2D_DEST_BR_X__MASK;
}
#define A8XX_GRAS_A2D_DEST_BR_Y__MASK				0x3fff0000ull
#define A8XX_GRAS_A2D_DEST_BR_Y__SHIFT				16
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_DEST_BR_Y(uint32_t val)
{
	return ((val) << A8XX_GRAS_A2D_DEST_BR_Y__SHIFT) & A8XX_GRAS_A2D_DEST_BR_Y__MASK;
}


#define REG_A8XX_GRAS_A2D_SCISSOR_TL				__FD_DEPRECATED 0x00008507
#define A8XX_GRAS_A2D_SCISSOR_TL_X__MASK			0x00003fffull
#define A8XX_GRAS_A2D_SCISSOR_TL_X__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_SCISSOR_TL_X(uint32_t val)
{
	return ((val) << A8XX_GRAS_A2D_SCISSOR_TL_X__SHIFT) & A8XX_GRAS_A2D_SCISSOR_TL_X__MASK;
}
#define A8XX_GRAS_A2D_SCISSOR_TL_Y__MASK			0x3fff0000ull
#define A8XX_GRAS_A2D_SCISSOR_TL_Y__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_SCISSOR_TL_Y(uint32_t val)
{
	return ((val) << A8XX_GRAS_A2D_SCISSOR_TL_Y__SHIFT) & A8XX_GRAS_A2D_SCISSOR_TL_Y__MASK;
}


#define REG_A8XX_GRAS_A2D_SCISSOR_BR				__FD_DEPRECATED 0x00008508
#define A8XX_GRAS_A2D_SCISSOR_BR_X__MASK			0x00003fffull
#define A8XX_GRAS_A2D_SCISSOR_BR_X__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_SCISSOR_BR_X(uint32_t val)
{
	return ((val) << A8XX_GRAS_A2D_SCISSOR_BR_X__SHIFT) & A8XX_GRAS_A2D_SCISSOR_BR_X__MASK;
}
#define A8XX_GRAS_A2D_SCISSOR_BR_Y__MASK			0x3fff0000ull
#define A8XX_GRAS_A2D_SCISSOR_BR_Y__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_GRAS_A2D_SCISSOR_BR_Y(uint32_t val)
{
	return ((val) << A8XX_GRAS_A2D_SCISSOR_BR_Y__SHIFT) & A8XX_GRAS_A2D_SCISSOR_BR_Y__MASK;
}


#define REG_A6XX_GRAS_DBG_ECO_CNTL				__FD_DEPRECATED 0x00008600
#define A6XX_GRAS_DBG_ECO_CNTL_UNK7				0x00000080
#define A6XX_GRAS_DBG_ECO_CNTL_LRZCACHELOCKDIS			0x00000800


#define REG_A8XX_GRAS_TSEFE_DBG_ECO_CNTL			__FD_DEPRECATED 0x00008600


#define REG_A8XX_GRAS_DBG_ECO_CNTL				__FD_DEPRECATED 0x00008702


#define REG_A6XX_GRAS_ADDR_MODE_CNTL				__FD_DEPRECATED 0x00008601


#define REG_A7XX_GRAS_NC_MODE_CNTL				__FD_DEPRECATED 0x00008602


#define REG_A8XX_GRAS_NC_MODE_CNTL				__FD_DEPRECATED 0x00008700


#define REG_A6XX_GRAS_PERFCTR_TSE_SEL(i0)			(0x00008610 + 0x1*i0 )



#define REG_A6XX_GRAS_PERFCTR_RAS_SEL(i0)			(0x00008614 + 0x1*i0 )



#define REG_A6XX_GRAS_PERFCTR_LRZ_SEL(i0)			(0x00008618 + 0x1*i0 )



#define REG_A8XX_GRAS_PERFCTR_TSEFE_SEL(i0)			(0x00008610 + 0x1*i0 )



#define REG_A8XX_GRAS_PERFCTR_TSE_SEL(i0)			(0x00008710 + 0x1*i0 )



#define REG_A8XX_GRAS_PERFCTR_RAS_SEL(i0)			(0x00008720 + 0x1*i0 )



#define REG_A8XX_GRAS_PERFCTR_LRZ_SEL(i0)			(0x00008730 + 0x1*i0 )



#define REG_A6XX_RB_CNTL					__FD_DEPRECATED 0x00008800
#define A6XX_RB_CNTL_BINW__MASK					0x0000003full
#define A6XX_RB_CNTL_BINW__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_RB_CNTL_BINW(uint32_t val)
{
	assert(!(val & 0x1f));
	return (((val >> 5)) << A6XX_RB_CNTL_BINW__SHIFT) & A6XX_RB_CNTL_BINW__MASK;
}
#define A6XX_RB_CNTL_BINH__MASK					0x00007f00ull
#define A6XX_RB_CNTL_BINH__SHIFT				8
static CONSTEXPR inline uint32_t A6XX_RB_CNTL_BINH(uint32_t val)
{
	assert(!(val & 0xf));
	return (((val >> 4)) << A6XX_RB_CNTL_BINH__SHIFT) & A6XX_RB_CNTL_BINH__MASK;
}
#define A6XX_RB_CNTL_RENDER_MODE__MASK				0x001c0000ull
#define A6XX_RB_CNTL_RENDER_MODE__SHIFT				18
static CONSTEXPR inline uint32_t A6XX_RB_CNTL_RENDER_MODE(enum a6xx_render_mode val)
{
	return ((val) << A6XX_RB_CNTL_RENDER_MODE__SHIFT) & A6XX_RB_CNTL_RENDER_MODE__MASK;
}
#define A6XX_RB_CNTL_FORCE_LRZ_WRITE_DIS			0x00200000
#define A6XX_RB_CNTL_BUFFERS_LOCATION__MASK			0x00c00000ull
#define A6XX_RB_CNTL_BUFFERS_LOCATION__SHIFT			22
static CONSTEXPR inline uint32_t A6XX_RB_CNTL_BUFFERS_LOCATION(enum a6xx_buffers_location val)
{
	return ((val) << A6XX_RB_CNTL_BUFFERS_LOCATION__SHIFT) & A6XX_RB_CNTL_BUFFERS_LOCATION__MASK;
}
#define A6XX_RB_CNTL_LRZ_FEEDBACK_ZMODE_MASK__MASK		0x07000000ull
#define A6XX_RB_CNTL_LRZ_FEEDBACK_ZMODE_MASK__SHIFT		24
static CONSTEXPR inline uint32_t A6XX_RB_CNTL_LRZ_FEEDBACK_ZMODE_MASK(enum a6xx_lrz_feedback_mask val)
{
	return ((val) << A6XX_RB_CNTL_LRZ_FEEDBACK_ZMODE_MASK__SHIFT) & A6XX_RB_CNTL_LRZ_FEEDBACK_ZMODE_MASK__MASK;
}
#define A6XX_RB_CNTL_FORCE_LRZ_DIS				0x08000000


#define REG_A8XX_RB_CNTL					__FD_DEPRECATED 0x00008800
#define A8XX_RB_CNTL_BINW__MASK					0x000003ffull
#define A8XX_RB_CNTL_BINW__SHIFT				0
static CONSTEXPR inline uint32_t A8XX_RB_CNTL_BINW(uint32_t val)
{
	assert(!(val & 0x1f));
	return (((val >> 5)) << A8XX_RB_CNTL_BINW__SHIFT) & A8XX_RB_CNTL_BINW__MASK;
}
#define A8XX_RB_CNTL_BINH__MASK					0x07ff0000ull
#define A8XX_RB_CNTL_BINH__SHIFT				16
static CONSTEXPR inline uint32_t A8XX_RB_CNTL_BINH(uint32_t val)
{
	assert(!(val & 0xf));
	return (((val >> 4)) << A8XX_RB_CNTL_BINH__SHIFT) & A8XX_RB_CNTL_BINH__MASK;
}
#define A8XX_RB_CNTL_RENDER_MODE__MASK				0x00003800ull
#define A8XX_RB_CNTL_RENDER_MODE__SHIFT				11
static CONSTEXPR inline uint32_t A8XX_RB_CNTL_RENDER_MODE(enum a6xx_render_mode val)
{
	return ((val) << A8XX_RB_CNTL_RENDER_MODE__SHIFT) & A8XX_RB_CNTL_RENDER_MODE__MASK;
}
#define A8XX_RB_CNTL_LRZ_FEEDBACK_ZMODE_MASK__MASK		0x70000000ull
#define A8XX_RB_CNTL_LRZ_FEEDBACK_ZMODE_MASK__SHIFT		28
static CONSTEXPR inline uint32_t A8XX_RB_CNTL_LRZ_FEEDBACK_ZMODE_MASK(enum a6xx_lrz_feedback_mask val)
{
	return ((val) << A8XX_RB_CNTL_LRZ_FEEDBACK_ZMODE_MASK__SHIFT) & A8XX_RB_CNTL_LRZ_FEEDBACK_ZMODE_MASK__MASK;
}
#define A8XX_RB_CNTL_FORCE_LRZ_WRITE_DIS			0x80000000


#define REG_A6XX_RB_RENDER_CNTL					__FD_DEPRECATED 0x00008801
#define A6XX_RB_RENDER_CNTL_CCUSINGLECACHELINESIZE__MASK	0x00000038ull
#define A6XX_RB_RENDER_CNTL_CCUSINGLECACHELINESIZE__SHIFT	3
static CONSTEXPR inline uint32_t A6XX_RB_RENDER_CNTL_CCUSINGLECACHELINESIZE(uint32_t val)
{
	return ((val) << A6XX_RB_RENDER_CNTL_CCUSINGLECACHELINESIZE__SHIFT) & A6XX_RB_RENDER_CNTL_CCUSINGLECACHELINESIZE__MASK;
}
#define A6XX_RB_RENDER_CNTL_EARLYVIZOUTEN			0x00000040
#define A6XX_RB_RENDER_CNTL_FS_DISABLE				0x00000080
#define A6XX_RB_RENDER_CNTL_UNK8__MASK				0x00000700ull
#define A6XX_RB_RENDER_CNTL_UNK8__SHIFT				8
static CONSTEXPR inline uint32_t A6XX_RB_RENDER_CNTL_UNK8(uint32_t val)
{
	return ((val) << A6XX_RB_RENDER_CNTL_UNK8__SHIFT) & A6XX_RB_RENDER_CNTL_UNK8__MASK;
}
#define A6XX_RB_RENDER_CNTL_RASTER_MODE__MASK			0x00000100ull
#define A6XX_RB_RENDER_CNTL_RASTER_MODE__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_RB_RENDER_CNTL_RASTER_MODE(enum a6xx_raster_mode val)
{
	return ((val) << A6XX_RB_RENDER_CNTL_RASTER_MODE__SHIFT) & A6XX_RB_RENDER_CNTL_RASTER_MODE__MASK;
}
#define A6XX_RB_RENDER_CNTL_RASTER_DIRECTION__MASK		0x00000600ull
#define A6XX_RB_RENDER_CNTL_RASTER_DIRECTION__SHIFT		9
static CONSTEXPR inline uint32_t A6XX_RB_RENDER_CNTL_RASTER_DIRECTION(enum a6xx_raster_direction val)
{
	return ((val) << A6XX_RB_RENDER_CNTL_RASTER_DIRECTION__SHIFT) & A6XX_RB_RENDER_CNTL_RASTER_DIRECTION__MASK;
}
#define A6XX_RB_RENDER_CNTL_CONSERVATIVERASEN			0x00000800
#define A6XX_RB_RENDER_CNTL_INNERCONSERVATIVERASEN		0x00001000
#define A6XX_RB_RENDER_CNTL_FLAG_DEPTH				0x00004000
#define A6XX_RB_RENDER_CNTL_FLAG_MRTS__MASK			0x00ff0000ull
#define A6XX_RB_RENDER_CNTL_FLAG_MRTS__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_RB_RENDER_CNTL_FLAG_MRTS(uint32_t val)
{
	return ((val) << A6XX_RB_RENDER_CNTL_FLAG_MRTS__SHIFT) & A6XX_RB_RENDER_CNTL_FLAG_MRTS__MASK;
}


#define REG_A7XX_RB_RENDER_CNTL					__FD_DEPRECATED 0x00008801
#define A7XX_RB_RENDER_CNTL_EARLYVIZOUTEN			0x00000040
#define A7XX_RB_RENDER_CNTL_FS_DISABLE				0x00000080
#define A7XX_RB_RENDER_CNTL_RASTER_MODE__MASK			0x00000100ull
#define A7XX_RB_RENDER_CNTL_RASTER_MODE__SHIFT			8
static CONSTEXPR inline uint32_t A7XX_RB_RENDER_CNTL_RASTER_MODE(enum a6xx_raster_mode val)
{
	return ((val) << A7XX_RB_RENDER_CNTL_RASTER_MODE__SHIFT) & A7XX_RB_RENDER_CNTL_RASTER_MODE__MASK;
}
#define A7XX_RB_RENDER_CNTL_RASTER_DIRECTION__MASK		0x00000600ull
#define A7XX_RB_RENDER_CNTL_RASTER_DIRECTION__SHIFT		9
static CONSTEXPR inline uint32_t A7XX_RB_RENDER_CNTL_RASTER_DIRECTION(enum a6xx_raster_direction val)
{
	return ((val) << A7XX_RB_RENDER_CNTL_RASTER_DIRECTION__SHIFT) & A7XX_RB_RENDER_CNTL_RASTER_DIRECTION__MASK;
}
#define A7XX_RB_RENDER_CNTL_CONSERVATIVERASEN			0x00000800
#define A7XX_RB_RENDER_CNTL_INNERCONSERVATIVERASEN		0x00001000


#define REG_A6XX_RB_RAS_MSAA_CNTL				0x00008802
#define A6XX_RB_RAS_MSAA_CNTL_SAMPLES__MASK			0x00000003ull
#define A6XX_RB_RAS_MSAA_CNTL_SAMPLES__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_RB_RAS_MSAA_CNTL_SAMPLES(enum a3xx_msaa_samples val)
{
	return ((val) << A6XX_RB_RAS_MSAA_CNTL_SAMPLES__SHIFT) & A6XX_RB_RAS_MSAA_CNTL_SAMPLES__MASK;
}
#define A6XX_RB_RAS_MSAA_CNTL_UNK2				0x00000004
#define A6XX_RB_RAS_MSAA_CNTL_UNK3				0x00000008


#define REG_A6XX_RB_DEST_MSAA_CNTL				0x00008803
#define A6XX_RB_DEST_MSAA_CNTL_SAMPLES__MASK			0x00000003ull
#define A6XX_RB_DEST_MSAA_CNTL_SAMPLES__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_RB_DEST_MSAA_CNTL_SAMPLES(enum a3xx_msaa_samples val)
{
	return ((val) << A6XX_RB_DEST_MSAA_CNTL_SAMPLES__SHIFT) & A6XX_RB_DEST_MSAA_CNTL_SAMPLES__MASK;
}
#define A6XX_RB_DEST_MSAA_CNTL_MSAA_DISABLE			0x00000004


#define REG_A6XX_RB_MSAA_SAMPLE_POS_CNTL			0x00008804
#define A6XX_RB_MSAA_SAMPLE_POS_CNTL_UNK0			0x00000001
#define A6XX_RB_MSAA_SAMPLE_POS_CNTL_LOCATION_ENABLE		0x00000002


#define REG_A6XX_RB_PROGRAMMABLE_MSAA_POS_0			0x00008805
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X__MASK	0x0000000full
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X__SHIFT	0
static inline uint32_t A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X__SHIFT) & A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X__MASK;
}
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y__MASK	0x000000f0ull
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y__SHIFT	4
static inline uint32_t A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y__SHIFT) & A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y__MASK;
}
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X__MASK	0x00000f00ull
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X__SHIFT	8
static inline uint32_t A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X__SHIFT) & A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X__MASK;
}
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y__MASK	0x0000f000ull
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y__SHIFT	12
static inline uint32_t A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y__SHIFT) & A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y__MASK;
}
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X__MASK	0x000f0000ull
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X__SHIFT	16
static inline uint32_t A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X__SHIFT) & A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X__MASK;
}
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y__MASK	0x00f00000ull
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y__SHIFT	20
static inline uint32_t A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y__SHIFT) & A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y__MASK;
}
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X__MASK	0x0f000000ull
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X__SHIFT	24
static inline uint32_t A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X__SHIFT) & A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X__MASK;
}
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y__MASK	0xf0000000ull
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y__SHIFT	28
static inline uint32_t A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y__SHIFT) & A6XX_RB_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y__MASK;
}


#define REG_A6XX_RB_PROGRAMMABLE_MSAA_POS_1			0x00008806
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X__MASK	0x0000000full
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X__SHIFT	0
static inline uint32_t A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X__SHIFT) & A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X__MASK;
}
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y__MASK	0x000000f0ull
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y__SHIFT	4
static inline uint32_t A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y__SHIFT) & A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y__MASK;
}
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X__MASK	0x00000f00ull
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X__SHIFT	8
static inline uint32_t A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X__SHIFT) & A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X__MASK;
}
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y__MASK	0x0000f000ull
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y__SHIFT	12
static inline uint32_t A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y__SHIFT) & A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y__MASK;
}
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X__MASK	0x000f0000ull
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X__SHIFT	16
static inline uint32_t A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X__SHIFT) & A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X__MASK;
}
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y__MASK	0x00f00000ull
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y__SHIFT	20
static inline uint32_t A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y__SHIFT) & A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y__MASK;
}
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X__MASK	0x0f000000ull
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X__SHIFT	24
static inline uint32_t A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X__SHIFT) & A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X__MASK;
}
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y__MASK	0xf0000000ull
#define A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y__SHIFT	28
static inline uint32_t A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y__SHIFT) & A6XX_RB_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y__MASK;
}


#define REG_A8XX_RB_PROGRAMMABLE_MSAA_POS_2			__FD_DEPRECATED 0x00008807
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_X__MASK	0x0000000full
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_X__SHIFT	0
static inline uint32_t A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_X__SHIFT) & A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_X__MASK;
}
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_Y__MASK	0x000000f0ull
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_Y__SHIFT	4
static inline uint32_t A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_Y__SHIFT) & A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_0_Y__MASK;
}
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_X__MASK	0x00000f00ull
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_X__SHIFT	8
static inline uint32_t A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_X__SHIFT) & A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_X__MASK;
}
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_Y__MASK	0x0000f000ull
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_Y__SHIFT	12
static inline uint32_t A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_Y__SHIFT) & A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_1_Y__MASK;
}
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_X__MASK	0x000f0000ull
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_X__SHIFT	16
static inline uint32_t A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_X__SHIFT) & A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_X__MASK;
}
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_Y__MASK	0x00f00000ull
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_Y__SHIFT	20
static inline uint32_t A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_Y__SHIFT) & A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_2_Y__MASK;
}
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_X__MASK	0x0f000000ull
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_X__SHIFT	24
static inline uint32_t A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_X__SHIFT) & A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_X__MASK;
}
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_Y__MASK	0xf0000000ull
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_Y__SHIFT	28
static inline uint32_t A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_Y__SHIFT) & A8XX_RB_PROGRAMMABLE_MSAA_POS_2_SAMPLE_3_Y__MASK;
}


#define REG_A8XX_RB_PROGRAMMABLE_MSAA_POS_3			__FD_DEPRECATED 0x00008808
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_X__MASK	0x0000000full
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_X__SHIFT	0
static inline uint32_t A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_X__SHIFT) & A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_X__MASK;
}
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_Y__MASK	0x000000f0ull
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_Y__SHIFT	4
static inline uint32_t A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_Y__SHIFT) & A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_0_Y__MASK;
}
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_X__MASK	0x00000f00ull
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_X__SHIFT	8
static inline uint32_t A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_X__SHIFT) & A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_X__MASK;
}
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_Y__MASK	0x0000f000ull
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_Y__SHIFT	12
static inline uint32_t A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_Y__SHIFT) & A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_1_Y__MASK;
}
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_X__MASK	0x000f0000ull
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_X__SHIFT	16
static inline uint32_t A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_X__SHIFT) & A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_X__MASK;
}
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_Y__MASK	0x00f00000ull
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_Y__SHIFT	20
static inline uint32_t A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_Y__SHIFT) & A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_2_Y__MASK;
}
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_X__MASK	0x0f000000ull
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_X__SHIFT	24
static inline uint32_t A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_X__SHIFT) & A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_X__MASK;
}
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_Y__MASK	0xf0000000ull
#define A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_Y__SHIFT	28
static inline uint32_t A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_Y__SHIFT) & A8XX_RB_PROGRAMMABLE_MSAA_POS_3_SAMPLE_3_Y__MASK;
}


#define REG_A6XX_RB_INTERP_CNTL					0x00008809
#define A6XX_RB_INTERP_CNTL_IJ_PERSP_PIXEL			0x00000001
#define A6XX_RB_INTERP_CNTL_IJ_PERSP_CENTROID			0x00000002
#define A6XX_RB_INTERP_CNTL_IJ_PERSP_SAMPLE			0x00000004
#define A6XX_RB_INTERP_CNTL_IJ_LINEAR_PIXEL			0x00000008
#define A6XX_RB_INTERP_CNTL_IJ_LINEAR_CENTROID			0x00000010
#define A6XX_RB_INTERP_CNTL_IJ_LINEAR_SAMPLE			0x00000020
#define A6XX_RB_INTERP_CNTL_COORD_MASK__MASK			0x000003c0ull
#define A6XX_RB_INTERP_CNTL_COORD_MASK__SHIFT			6
static CONSTEXPR inline uint32_t A6XX_RB_INTERP_CNTL_COORD_MASK(uint32_t val)
{
	return ((val) << A6XX_RB_INTERP_CNTL_COORD_MASK__SHIFT) & A6XX_RB_INTERP_CNTL_COORD_MASK__MASK;
}
#define A6XX_RB_INTERP_CNTL_INTERP_EN				0x00000400


#define REG_A6XX_RB_PS_INPUT_CNTL				0x0000880a
#define A6XX_RB_PS_INPUT_CNTL_SAMPLEMASK			0x00000001
#define A6XX_RB_PS_INPUT_CNTL_POSTDEPTHCOVERAGE			0x00000002
#define A6XX_RB_PS_INPUT_CNTL_FACENESS				0x00000004
#define A6XX_RB_PS_INPUT_CNTL_SAMPLEID				0x00000008
#define A6XX_RB_PS_INPUT_CNTL_FRAGCOORDSAMPLEMODE__MASK		0x00000030ull
#define A6XX_RB_PS_INPUT_CNTL_FRAGCOORDSAMPLEMODE__SHIFT	4
static CONSTEXPR inline uint32_t A6XX_RB_PS_INPUT_CNTL_FRAGCOORDSAMPLEMODE(enum a6xx_fragcoord_sample_mode val)
{
	return ((val) << A6XX_RB_PS_INPUT_CNTL_FRAGCOORDSAMPLEMODE__SHIFT) & A6XX_RB_PS_INPUT_CNTL_FRAGCOORDSAMPLEMODE__MASK;
}
#define A6XX_RB_PS_INPUT_CNTL_CENTERRHW				0x00000040
#define A6XX_RB_PS_INPUT_CNTL_LINELENGTHEN			0x00000080
#define A6XX_RB_PS_INPUT_CNTL_FOVEATION				0x00000100


#define REG_A6XX_RB_PS_OUTPUT_CNTL				0x0000880b
#define A6XX_RB_PS_OUTPUT_CNTL_DUAL_COLOR_IN_ENABLE		0x00000001
#define A6XX_RB_PS_OUTPUT_CNTL_FRAG_WRITES_Z			0x00000002
#define A6XX_RB_PS_OUTPUT_CNTL_FRAG_WRITES_SAMPMASK		0x00000004
#define A6XX_RB_PS_OUTPUT_CNTL_FRAG_WRITES_STENCILREF		0x00000008


#define REG_A6XX_RB_PS_MRT_CNTL					0x0000880c
#define A6XX_RB_PS_MRT_CNTL_MRT__MASK				0x0000000full
#define A6XX_RB_PS_MRT_CNTL_MRT__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_RB_PS_MRT_CNTL_MRT(uint32_t val)
{
	return ((val) << A6XX_RB_PS_MRT_CNTL_MRT__SHIFT) & A6XX_RB_PS_MRT_CNTL_MRT__MASK;
}


#define REG_A6XX_RB_PS_OUTPUT_MASK				0x0000880d
#define A6XX_RB_PS_OUTPUT_MASK_RT0__MASK			0x0000000full
#define A6XX_RB_PS_OUTPUT_MASK_RT0__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_RB_PS_OUTPUT_MASK_RT0(uint32_t val)
{
	return ((val) << A6XX_RB_PS_OUTPUT_MASK_RT0__SHIFT) & A6XX_RB_PS_OUTPUT_MASK_RT0__MASK;
}
#define A6XX_RB_PS_OUTPUT_MASK_RT1__MASK			0x000000f0ull
#define A6XX_RB_PS_OUTPUT_MASK_RT1__SHIFT			4
static CONSTEXPR inline uint32_t A6XX_RB_PS_OUTPUT_MASK_RT1(uint32_t val)
{
	return ((val) << A6XX_RB_PS_OUTPUT_MASK_RT1__SHIFT) & A6XX_RB_PS_OUTPUT_MASK_RT1__MASK;
}
#define A6XX_RB_PS_OUTPUT_MASK_RT2__MASK			0x00000f00ull
#define A6XX_RB_PS_OUTPUT_MASK_RT2__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_RB_PS_OUTPUT_MASK_RT2(uint32_t val)
{
	return ((val) << A6XX_RB_PS_OUTPUT_MASK_RT2__SHIFT) & A6XX_RB_PS_OUTPUT_MASK_RT2__MASK;
}
#define A6XX_RB_PS_OUTPUT_MASK_RT3__MASK			0x0000f000ull
#define A6XX_RB_PS_OUTPUT_MASK_RT3__SHIFT			12
static CONSTEXPR inline uint32_t A6XX_RB_PS_OUTPUT_MASK_RT3(uint32_t val)
{
	return ((val) << A6XX_RB_PS_OUTPUT_MASK_RT3__SHIFT) & A6XX_RB_PS_OUTPUT_MASK_RT3__MASK;
}
#define A6XX_RB_PS_OUTPUT_MASK_RT4__MASK			0x000f0000ull
#define A6XX_RB_PS_OUTPUT_MASK_RT4__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_RB_PS_OUTPUT_MASK_RT4(uint32_t val)
{
	return ((val) << A6XX_RB_PS_OUTPUT_MASK_RT4__SHIFT) & A6XX_RB_PS_OUTPUT_MASK_RT4__MASK;
}
#define A6XX_RB_PS_OUTPUT_MASK_RT5__MASK			0x00f00000ull
#define A6XX_RB_PS_OUTPUT_MASK_RT5__SHIFT			20
static CONSTEXPR inline uint32_t A6XX_RB_PS_OUTPUT_MASK_RT5(uint32_t val)
{
	return ((val) << A6XX_RB_PS_OUTPUT_MASK_RT5__SHIFT) & A6XX_RB_PS_OUTPUT_MASK_RT5__MASK;
}
#define A6XX_RB_PS_OUTPUT_MASK_RT6__MASK			0x0f000000ull
#define A6XX_RB_PS_OUTPUT_MASK_RT6__SHIFT			24
static CONSTEXPR inline uint32_t A6XX_RB_PS_OUTPUT_MASK_RT6(uint32_t val)
{
	return ((val) << A6XX_RB_PS_OUTPUT_MASK_RT6__SHIFT) & A6XX_RB_PS_OUTPUT_MASK_RT6__MASK;
}
#define A6XX_RB_PS_OUTPUT_MASK_RT7__MASK			0xf0000000ull
#define A6XX_RB_PS_OUTPUT_MASK_RT7__SHIFT			28
static CONSTEXPR inline uint32_t A6XX_RB_PS_OUTPUT_MASK_RT7(uint32_t val)
{
	return ((val) << A6XX_RB_PS_OUTPUT_MASK_RT7__SHIFT) & A6XX_RB_PS_OUTPUT_MASK_RT7__MASK;
}


#define REG_A6XX_RB_DITHER_CNTL					0x0000880e
#define A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT0__MASK		0x00000003ull
#define A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT0__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT0(enum adreno_rb_dither_mode val)
{
	return ((val) << A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT0__SHIFT) & A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT0__MASK;
}
#define A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT1__MASK		0x0000000cull
#define A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT1__SHIFT		2
static CONSTEXPR inline uint32_t A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT1(enum adreno_rb_dither_mode val)
{
	return ((val) << A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT1__SHIFT) & A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT1__MASK;
}
#define A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT2__MASK		0x00000030ull
#define A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT2__SHIFT		4
static CONSTEXPR inline uint32_t A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT2(enum adreno_rb_dither_mode val)
{
	return ((val) << A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT2__SHIFT) & A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT2__MASK;
}
#define A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT3__MASK		0x000000c0ull
#define A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT3__SHIFT		6
static CONSTEXPR inline uint32_t A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT3(enum adreno_rb_dither_mode val)
{
	return ((val) << A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT3__SHIFT) & A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT3__MASK;
}
#define A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT4__MASK		0x00000300ull
#define A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT4__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT4(enum adreno_rb_dither_mode val)
{
	return ((val) << A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT4__SHIFT) & A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT4__MASK;
}
#define A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT5__MASK		0x00000c00ull
#define A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT5__SHIFT		10
static CONSTEXPR inline uint32_t A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT5(enum adreno_rb_dither_mode val)
{
	return ((val) << A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT5__SHIFT) & A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT5__MASK;
}
#define A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT6__MASK		0x00003000ull
#define A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT6__SHIFT		12
static CONSTEXPR inline uint32_t A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT6(enum adreno_rb_dither_mode val)
{
	return ((val) << A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT6__SHIFT) & A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT6__MASK;
}
#define A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT7__MASK		0x0000c000ull
#define A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT7__SHIFT		14
static CONSTEXPR inline uint32_t A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT7(enum adreno_rb_dither_mode val)
{
	return ((val) << A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT7__SHIFT) & A6XX_RB_DITHER_CNTL_DITHER_MODE_MRT7__MASK;
}


#define REG_A6XX_RB_SRGB_CNTL					0x0000880f
#define A6XX_RB_SRGB_CNTL_SRGB_MRT0				0x00000001
#define A6XX_RB_SRGB_CNTL_SRGB_MRT1				0x00000002
#define A6XX_RB_SRGB_CNTL_SRGB_MRT2				0x00000004
#define A6XX_RB_SRGB_CNTL_SRGB_MRT3				0x00000008
#define A6XX_RB_SRGB_CNTL_SRGB_MRT4				0x00000010
#define A6XX_RB_SRGB_CNTL_SRGB_MRT5				0x00000020
#define A6XX_RB_SRGB_CNTL_SRGB_MRT6				0x00000040
#define A6XX_RB_SRGB_CNTL_SRGB_MRT7				0x00000080


#define REG_A6XX_RB_PS_SAMPLEFREQ_CNTL				0x00008810
#define A6XX_RB_PS_SAMPLEFREQ_CNTL_PER_SAMP_MODE		0x00000001


#define REG_A6XX_RB_MODE_CNTL					0x00008811


#define REG_A7XX_RB_BUFFER_CNTL					__FD_DEPRECATED 0x00008812
#define A7XX_RB_BUFFER_CNTL_Z_SYSMEM				0x00000001
#define A7XX_RB_BUFFER_CNTL_S_SYSMEM				0x00000002
#define A7XX_RB_BUFFER_CNTL_RT0_SYSMEM				0x00000004
#define A7XX_RB_BUFFER_CNTL_RT1_SYSMEM				0x00000008
#define A7XX_RB_BUFFER_CNTL_RT2_SYSMEM				0x00000010
#define A7XX_RB_BUFFER_CNTL_RT3_SYSMEM				0x00000020
#define A7XX_RB_BUFFER_CNTL_RT4_SYSMEM				0x00000040
#define A7XX_RB_BUFFER_CNTL_RT5_SYSMEM				0x00000080
#define A7XX_RB_BUFFER_CNTL_RT6_SYSMEM				0x00000100
#define A7XX_RB_BUFFER_CNTL_RT7_SYSMEM				0x00000200
#define A7XX_RB_BUFFER_CNTL_Z_FULL_IN_GMEM			0x00000400
#define A7XX_RB_BUFFER_CNTL_S_FULL_IN_GMEM			0x00000800
#define A7XX_RB_BUFFER_CNTL_RT0_FULL_IN_GMEM			0x00001000
#define A7XX_RB_BUFFER_CNTL_RT1_FULL_IN_GMEM			0x00002000
#define A7XX_RB_BUFFER_CNTL_RT2_FULL_IN_GMEM			0x00004000
#define A7XX_RB_BUFFER_CNTL_RT3_FULL_IN_GMEM			0x00008000
#define A7XX_RB_BUFFER_CNTL_RT4_FULL_IN_GMEM			0x00010000
#define A7XX_RB_BUFFER_CNTL_RT5_FULL_IN_GMEM			0x00020000
#define A7XX_RB_BUFFER_CNTL_RT6_FULL_IN_GMEM			0x00040000
#define A7XX_RB_BUFFER_CNTL_RT7_FULL_IN_GMEM			0x00080000


#define REG_A8XX_RB_RESOLVE_CR_CNTL				__FD_DEPRECATED 0x00008816


#define REG_A6XX_RB_UNKNOWN_8818				0x00008818


#define REG_A6XX_RB_UNKNOWN_8819				0x00008819


#define REG_A6XX_RB_UNKNOWN_881A				0x0000881a


#define REG_A6XX_RB_UNKNOWN_881B				0x0000881b


#define REG_A6XX_RB_UNKNOWN_881C				0x0000881c


#define REG_A6XX_RB_UNKNOWN_881D				0x0000881d


#define REG_A6XX_RB_UNKNOWN_881E				0x0000881e


#define REG_A8XX_RB_PS_CNTL					__FD_DEPRECATED 0x0000881f
#define A8XX_RB_PS_CNTL_PIXLODENABLE				0x00000001
#define A8XX_RB_PS_CNTL_LODPIXMASK				0x00000002


#define REG_A6XX_RB_MRT(i0)					(0x00008820 + 0x8*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_RB_MRT_CONTROL(uint32_t i0) { return 0x00008820 + 0x8*i0; }
#define A6XX_RB_MRT_CONTROL_COLOR_BLEND_EN			0x00000001
#define A6XX_RB_MRT_CONTROL_ALPHA_BLEND_EN			0x00000002
#define A6XX_RB_MRT_CONTROL_ROP_ENABLE				0x00000004
#define A6XX_RB_MRT_CONTROL_ROP_CODE__MASK			0x00000078ull
#define A6XX_RB_MRT_CONTROL_ROP_CODE__SHIFT			3
static CONSTEXPR inline uint32_t A6XX_RB_MRT_CONTROL_ROP_CODE(enum a3xx_rop_code val)
{
	return ((val) << A6XX_RB_MRT_CONTROL_ROP_CODE__SHIFT) & A6XX_RB_MRT_CONTROL_ROP_CODE__MASK;
}
#define A6XX_RB_MRT_CONTROL_COMPONENT_ENABLE__MASK		0x00000780ull
#define A6XX_RB_MRT_CONTROL_COMPONENT_ENABLE__SHIFT		7
static CONSTEXPR inline uint32_t A6XX_RB_MRT_CONTROL_COMPONENT_ENABLE(uint32_t val)
{
	return ((val) << A6XX_RB_MRT_CONTROL_COMPONENT_ENABLE__SHIFT) & A6XX_RB_MRT_CONTROL_COMPONENT_ENABLE__MASK;
}


static CONSTEXPR inline uint32_t REG_A6XX_RB_MRT_BLEND_CONTROL(uint32_t i0) { return 0x00008821 + 0x8*i0; }
#define A6XX_RB_MRT_BLEND_CONTROL_RGB_SRC_FACTOR__MASK		0x0000001full
#define A6XX_RB_MRT_BLEND_CONTROL_RGB_SRC_FACTOR__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_RB_MRT_BLEND_CONTROL_RGB_SRC_FACTOR(enum adreno_rb_blend_factor val)
{
	return ((val) << A6XX_RB_MRT_BLEND_CONTROL_RGB_SRC_FACTOR__SHIFT) & A6XX_RB_MRT_BLEND_CONTROL_RGB_SRC_FACTOR__MASK;
}
#define A6XX_RB_MRT_BLEND_CONTROL_RGB_BLEND_OPCODE__MASK	0x000000e0ull
#define A6XX_RB_MRT_BLEND_CONTROL_RGB_BLEND_OPCODE__SHIFT	5
static CONSTEXPR inline uint32_t A6XX_RB_MRT_BLEND_CONTROL_RGB_BLEND_OPCODE(enum a3xx_rb_blend_opcode val)
{
	return ((val) << A6XX_RB_MRT_BLEND_CONTROL_RGB_BLEND_OPCODE__SHIFT) & A6XX_RB_MRT_BLEND_CONTROL_RGB_BLEND_OPCODE__MASK;
}
#define A6XX_RB_MRT_BLEND_CONTROL_RGB_DEST_FACTOR__MASK		0x00001f00ull
#define A6XX_RB_MRT_BLEND_CONTROL_RGB_DEST_FACTOR__SHIFT	8
static CONSTEXPR inline uint32_t A6XX_RB_MRT_BLEND_CONTROL_RGB_DEST_FACTOR(enum adreno_rb_blend_factor val)
{
	return ((val) << A6XX_RB_MRT_BLEND_CONTROL_RGB_DEST_FACTOR__SHIFT) & A6XX_RB_MRT_BLEND_CONTROL_RGB_DEST_FACTOR__MASK;
}
#define A6XX_RB_MRT_BLEND_CONTROL_ALPHA_SRC_FACTOR__MASK	0x001f0000ull
#define A6XX_RB_MRT_BLEND_CONTROL_ALPHA_SRC_FACTOR__SHIFT	16
static CONSTEXPR inline uint32_t A6XX_RB_MRT_BLEND_CONTROL_ALPHA_SRC_FACTOR(enum adreno_rb_blend_factor val)
{
	return ((val) << A6XX_RB_MRT_BLEND_CONTROL_ALPHA_SRC_FACTOR__SHIFT) & A6XX_RB_MRT_BLEND_CONTROL_ALPHA_SRC_FACTOR__MASK;
}
#define A6XX_RB_MRT_BLEND_CONTROL_ALPHA_BLEND_OPCODE__MASK	0x00e00000ull
#define A6XX_RB_MRT_BLEND_CONTROL_ALPHA_BLEND_OPCODE__SHIFT	21
static CONSTEXPR inline uint32_t A6XX_RB_MRT_BLEND_CONTROL_ALPHA_BLEND_OPCODE(enum a3xx_rb_blend_opcode val)
{
	return ((val) << A6XX_RB_MRT_BLEND_CONTROL_ALPHA_BLEND_OPCODE__SHIFT) & A6XX_RB_MRT_BLEND_CONTROL_ALPHA_BLEND_OPCODE__MASK;
}
#define A6XX_RB_MRT_BLEND_CONTROL_ALPHA_DEST_FACTOR__MASK	0x1f000000ull
#define A6XX_RB_MRT_BLEND_CONTROL_ALPHA_DEST_FACTOR__SHIFT	24
static CONSTEXPR inline uint32_t A6XX_RB_MRT_BLEND_CONTROL_ALPHA_DEST_FACTOR(enum adreno_rb_blend_factor val)
{
	return ((val) << A6XX_RB_MRT_BLEND_CONTROL_ALPHA_DEST_FACTOR__SHIFT) & A6XX_RB_MRT_BLEND_CONTROL_ALPHA_DEST_FACTOR__MASK;
}


#define A6XX_RB_MRT_BUF_INFO_COLOR_FORMAT__MASK			0x000000ffull
#define A6XX_RB_MRT_BUF_INFO_COLOR_FORMAT__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_RB_MRT_BUF_INFO_COLOR_FORMAT(enum a6xx_format val)
{
	return ((val) << A6XX_RB_MRT_BUF_INFO_COLOR_FORMAT__SHIFT) & A6XX_RB_MRT_BUF_INFO_COLOR_FORMAT__MASK;
}
#define A6XX_RB_MRT_BUF_INFO_COLOR_TILE_MODE__MASK		0x00000300ull
#define A6XX_RB_MRT_BUF_INFO_COLOR_TILE_MODE__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_RB_MRT_BUF_INFO_COLOR_TILE_MODE(enum a6xx_tile_mode val)
{
	return ((val) << A6XX_RB_MRT_BUF_INFO_COLOR_TILE_MODE__SHIFT) & A6XX_RB_MRT_BUF_INFO_COLOR_TILE_MODE__MASK;
}
#define A6XX_RB_MRT_BUF_INFO_UNK10				0x00000400
#define A6XX_RB_MRT_BUF_INFO_COLOR_SWAP__MASK			0x00006000ull
#define A6XX_RB_MRT_BUF_INFO_COLOR_SWAP__SHIFT			13
static CONSTEXPR inline uint32_t A6XX_RB_MRT_BUF_INFO_COLOR_SWAP(enum a3xx_color_swap val)
{
	return ((val) << A6XX_RB_MRT_BUF_INFO_COLOR_SWAP__SHIFT) & A6XX_RB_MRT_BUF_INFO_COLOR_SWAP__MASK;
}


#define A7XX_RB_MRT_BUF_INFO_COLOR_FORMAT__MASK			0x000000ffull
#define A7XX_RB_MRT_BUF_INFO_COLOR_FORMAT__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_RB_MRT_BUF_INFO_COLOR_FORMAT(enum a6xx_format val)
{
	return ((val) << A7XX_RB_MRT_BUF_INFO_COLOR_FORMAT__SHIFT) & A7XX_RB_MRT_BUF_INFO_COLOR_FORMAT__MASK;
}
#define A7XX_RB_MRT_BUF_INFO_COLOR_TILE_MODE__MASK		0x00000300ull
#define A7XX_RB_MRT_BUF_INFO_COLOR_TILE_MODE__SHIFT		8
static CONSTEXPR inline uint32_t A7XX_RB_MRT_BUF_INFO_COLOR_TILE_MODE(enum a6xx_tile_mode val)
{
	return ((val) << A7XX_RB_MRT_BUF_INFO_COLOR_TILE_MODE__SHIFT) & A7XX_RB_MRT_BUF_INFO_COLOR_TILE_MODE__MASK;
}
#define A7XX_RB_MRT_BUF_INFO_UNK10				0x00000400
#define A7XX_RB_MRT_BUF_INFO_LOSSLESSCOMPEN			0x00000800
#define A7XX_RB_MRT_BUF_INFO_COLOR_SWAP__MASK			0x00006000ull
#define A7XX_RB_MRT_BUF_INFO_COLOR_SWAP__SHIFT			13
static CONSTEXPR inline uint32_t A7XX_RB_MRT_BUF_INFO_COLOR_SWAP(enum a3xx_color_swap val)
{
	return ((val) << A7XX_RB_MRT_BUF_INFO_COLOR_SWAP__SHIFT) & A7XX_RB_MRT_BUF_INFO_COLOR_SWAP__MASK;
}
#define A7XX_RB_MRT_BUF_INFO_MUTABLEEN				0x00010000


static CONSTEXPR inline uint32_t REG_A6XX_RB_MRT_PITCH(uint32_t i0) { return 0x00008823 + 0x8*i0; }
#define A6XX_RB_MRT_PITCH__MASK					0xffffffffull
#define A6XX_RB_MRT_PITCH__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_RB_MRT_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_RB_MRT_PITCH__SHIFT) & A6XX_RB_MRT_PITCH__MASK;
}


static CONSTEXPR inline uint32_t REG_A6XX_RB_MRT_ARRAY_PITCH(uint32_t i0) { return 0x00008824 + 0x8*i0; }
#define A6XX_RB_MRT_ARRAY_PITCH__MASK				0xffffffffull
#define A6XX_RB_MRT_ARRAY_PITCH__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_RB_MRT_ARRAY_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_RB_MRT_ARRAY_PITCH__SHIFT) & A6XX_RB_MRT_ARRAY_PITCH__MASK;
}


static CONSTEXPR inline uint32_t REG_A6XX_RB_MRT_BASE(uint32_t i0) { return 0x00008825 + 0x8*i0; }
static CONSTEXPR inline uint32_t A6XX_RB_MRT_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RB_MRT_BASE_HI(uint32_t val)
{
	return val;
}


static CONSTEXPR inline uint32_t REG_A6XX_RB_MRT_BASE_GMEM(uint32_t i0) { return 0x00008827 + 0x8*i0; }


#define REG_A6XX_RB_BLEND_CONSTANT_RED_FP32			0x00008860
#define A6XX_RB_BLEND_CONSTANT_RED_FP32__MASK			0xffffffffull
#define A6XX_RB_BLEND_CONSTANT_RED_FP32__SHIFT			0
static inline uint32_t A6XX_RB_BLEND_CONSTANT_RED_FP32(float val)
{
	return ((fui(val)) << A6XX_RB_BLEND_CONSTANT_RED_FP32__SHIFT) & A6XX_RB_BLEND_CONSTANT_RED_FP32__MASK;
}


#define REG_A6XX_RB_BLEND_CONSTANT_GREEN_FP32			0x00008861
#define A6XX_RB_BLEND_CONSTANT_GREEN_FP32__MASK			0xffffffffull
#define A6XX_RB_BLEND_CONSTANT_GREEN_FP32__SHIFT		0
static inline uint32_t A6XX_RB_BLEND_CONSTANT_GREEN_FP32(float val)
{
	return ((fui(val)) << A6XX_RB_BLEND_CONSTANT_GREEN_FP32__SHIFT) & A6XX_RB_BLEND_CONSTANT_GREEN_FP32__MASK;
}


#define REG_A6XX_RB_BLEND_CONSTANT_BLUE_FP32			0x00008862
#define A6XX_RB_BLEND_CONSTANT_BLUE_FP32__MASK			0xffffffffull
#define A6XX_RB_BLEND_CONSTANT_BLUE_FP32__SHIFT			0
static inline uint32_t A6XX_RB_BLEND_CONSTANT_BLUE_FP32(float val)
{
	return ((fui(val)) << A6XX_RB_BLEND_CONSTANT_BLUE_FP32__SHIFT) & A6XX_RB_BLEND_CONSTANT_BLUE_FP32__MASK;
}


#define REG_A6XX_RB_BLEND_CONSTANT_ALPHA_FP32			0x00008863
#define A6XX_RB_BLEND_CONSTANT_ALPHA_FP32__MASK			0xffffffffull
#define A6XX_RB_BLEND_CONSTANT_ALPHA_FP32__SHIFT		0
static inline uint32_t A6XX_RB_BLEND_CONSTANT_ALPHA_FP32(float val)
{
	return ((fui(val)) << A6XX_RB_BLEND_CONSTANT_ALPHA_FP32__SHIFT) & A6XX_RB_BLEND_CONSTANT_ALPHA_FP32__MASK;
}


#define REG_A6XX_RB_ALPHA_TEST_CNTL				0x00008864
#define A6XX_RB_ALPHA_TEST_CNTL_ALPHA_REF__MASK			0x000000ffull
#define A6XX_RB_ALPHA_TEST_CNTL_ALPHA_REF__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_RB_ALPHA_TEST_CNTL_ALPHA_REF(uint32_t val)
{
	return ((val) << A6XX_RB_ALPHA_TEST_CNTL_ALPHA_REF__SHIFT) & A6XX_RB_ALPHA_TEST_CNTL_ALPHA_REF__MASK;
}
#define A6XX_RB_ALPHA_TEST_CNTL_ALPHA_TEST			0x00000100
#define A6XX_RB_ALPHA_TEST_CNTL_ALPHA_TEST_FUNC__MASK		0x00000e00ull
#define A6XX_RB_ALPHA_TEST_CNTL_ALPHA_TEST_FUNC__SHIFT		9
static CONSTEXPR inline uint32_t A6XX_RB_ALPHA_TEST_CNTL_ALPHA_TEST_FUNC(enum adreno_compare_func val)
{
	return ((val) << A6XX_RB_ALPHA_TEST_CNTL_ALPHA_TEST_FUNC__SHIFT) & A6XX_RB_ALPHA_TEST_CNTL_ALPHA_TEST_FUNC__MASK;
}


#define REG_A6XX_RB_BLEND_CNTL					0x00008865
#define A6XX_RB_BLEND_CNTL_BLEND_READS_DEST__MASK		0x000000ffull
#define A6XX_RB_BLEND_CNTL_BLEND_READS_DEST__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_RB_BLEND_CNTL_BLEND_READS_DEST(uint32_t val)
{
	return ((val) << A6XX_RB_BLEND_CNTL_BLEND_READS_DEST__SHIFT) & A6XX_RB_BLEND_CNTL_BLEND_READS_DEST__MASK;
}
#define A6XX_RB_BLEND_CNTL_INDEPENDENT_BLEND			0x00000100
#define A6XX_RB_BLEND_CNTL_DUAL_COLOR_IN_ENABLE			0x00000200
#define A6XX_RB_BLEND_CNTL_ALPHA_TO_COVERAGE			0x00000400
#define A6XX_RB_BLEND_CNTL_ALPHA_TO_ONE				0x00000800
#define A6XX_RB_BLEND_CNTL_SAMPLE_MASK__MASK			0xffff0000ull
#define A6XX_RB_BLEND_CNTL_SAMPLE_MASK__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_RB_BLEND_CNTL_SAMPLE_MASK(uint32_t val)
{
	return ((val) << A6XX_RB_BLEND_CNTL_SAMPLE_MASK__SHIFT) & A6XX_RB_BLEND_CNTL_SAMPLE_MASK__MASK;
}


#define REG_A8XX_RB_LB_PARAM_LIMIT				__FD_DEPRECATED 0x00008866
#define A8XX_RB_LB_PARAM_LIMIT_PRIMALLOCTHRESHOLD__MASK		0x00000007ull
#define A8XX_RB_LB_PARAM_LIMIT_PRIMALLOCTHRESHOLD__SHIFT	0
static CONSTEXPR inline uint32_t A8XX_RB_LB_PARAM_LIMIT_PRIMALLOCTHRESHOLD(uint32_t val)
{
	return ((val) << A8XX_RB_LB_PARAM_LIMIT_PRIMALLOCTHRESHOLD__SHIFT) & A8XX_RB_LB_PARAM_LIMIT_PRIMALLOCTHRESHOLD__MASK;
}


#define REG_A6XX_RB_DEPTH_PLANE_CNTL				0x00008870
#define A6XX_RB_DEPTH_PLANE_CNTL_Z_MODE__MASK			0x00000003ull
#define A6XX_RB_DEPTH_PLANE_CNTL_Z_MODE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_RB_DEPTH_PLANE_CNTL_Z_MODE(enum a6xx_ztest_mode val)
{
	return ((val) << A6XX_RB_DEPTH_PLANE_CNTL_Z_MODE__SHIFT) & A6XX_RB_DEPTH_PLANE_CNTL_Z_MODE__MASK;
}


#define REG_A6XX_RB_DEPTH_CNTL					0x00008871
#define A6XX_RB_DEPTH_CNTL_Z_TEST_ENABLE			0x00000001
#define A6XX_RB_DEPTH_CNTL_Z_WRITE_ENABLE			0x00000002
#define A6XX_RB_DEPTH_CNTL_ZFUNC__MASK				0x0000001cull
#define A6XX_RB_DEPTH_CNTL_ZFUNC__SHIFT				2
static CONSTEXPR inline uint32_t A6XX_RB_DEPTH_CNTL_ZFUNC(enum adreno_compare_func val)
{
	return ((val) << A6XX_RB_DEPTH_CNTL_ZFUNC__SHIFT) & A6XX_RB_DEPTH_CNTL_ZFUNC__MASK;
}
#define A6XX_RB_DEPTH_CNTL_Z_CLAMP_ENABLE			0x00000020
#define A6XX_RB_DEPTH_CNTL_Z_READ_ENABLE			0x00000040
#define A6XX_RB_DEPTH_CNTL_Z_BOUNDS_ENABLE			0x00000080
#define A6XX_RB_DEPTH_CNTL_O_DEPTH_01_CLAMP_EN			0x00000100


#define REG_A6XX_RB_DEPTH_BUFFER_INFO				__FD_DEPRECATED 0x00008872
#define A6XX_RB_DEPTH_BUFFER_INFO_DEPTH_FORMAT__MASK		0x00000007ull
#define A6XX_RB_DEPTH_BUFFER_INFO_DEPTH_FORMAT__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_RB_DEPTH_BUFFER_INFO_DEPTH_FORMAT(enum a6xx_depth_format val)
{
	return ((val) << A6XX_RB_DEPTH_BUFFER_INFO_DEPTH_FORMAT__SHIFT) & A6XX_RB_DEPTH_BUFFER_INFO_DEPTH_FORMAT__MASK;
}
#define A6XX_RB_DEPTH_BUFFER_INFO_READ_ONLY			0x00000008


#define REG_A7XX_RB_DEPTH_BUFFER_INFO				__FD_DEPRECATED 0x00008872
#define A7XX_RB_DEPTH_BUFFER_INFO_DEPTH_FORMAT__MASK		0x00000007ull
#define A7XX_RB_DEPTH_BUFFER_INFO_DEPTH_FORMAT__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_RB_DEPTH_BUFFER_INFO_DEPTH_FORMAT(enum a6xx_depth_format val)
{
	return ((val) << A7XX_RB_DEPTH_BUFFER_INFO_DEPTH_FORMAT__SHIFT) & A7XX_RB_DEPTH_BUFFER_INFO_DEPTH_FORMAT__MASK;
}
#define A7XX_RB_DEPTH_BUFFER_INFO_READ_ONLY			0x00000008
#define A7XX_RB_DEPTH_BUFFER_INFO_PRT__MASK			0x00000018ull
#define A7XX_RB_DEPTH_BUFFER_INFO_PRT__SHIFT			3
static CONSTEXPR inline uint32_t A7XX_RB_DEPTH_BUFFER_INFO_PRT(uint32_t val)
{
	return ((val) << A7XX_RB_DEPTH_BUFFER_INFO_PRT__SHIFT) & A7XX_RB_DEPTH_BUFFER_INFO_PRT__MASK;
}
#define A7XX_RB_DEPTH_BUFFER_INFO_TILEMODE__MASK		0x00000060ull
#define A7XX_RB_DEPTH_BUFFER_INFO_TILEMODE__SHIFT		5
static CONSTEXPR inline uint32_t A7XX_RB_DEPTH_BUFFER_INFO_TILEMODE(enum a6xx_tile_mode val)
{
	return ((val) << A7XX_RB_DEPTH_BUFFER_INFO_TILEMODE__SHIFT) & A7XX_RB_DEPTH_BUFFER_INFO_TILEMODE__MASK;
}
#define A7XX_RB_DEPTH_BUFFER_INFO_LOSSLESSCOMPEN		0x00000080


#define REG_A6XX_RB_DEPTH_BUFFER_PITCH				0x00008873
#define A6XX_RB_DEPTH_BUFFER_PITCH__MASK			0x00003fffull
#define A6XX_RB_DEPTH_BUFFER_PITCH__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_RB_DEPTH_BUFFER_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_RB_DEPTH_BUFFER_PITCH__SHIFT) & A6XX_RB_DEPTH_BUFFER_PITCH__MASK;
}


#define REG_A6XX_RB_DEPTH_BUFFER_ARRAY_PITCH			0x00008874
#define A6XX_RB_DEPTH_BUFFER_ARRAY_PITCH__MASK			0x0fffffffull
#define A6XX_RB_DEPTH_BUFFER_ARRAY_PITCH__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_RB_DEPTH_BUFFER_ARRAY_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_RB_DEPTH_BUFFER_ARRAY_PITCH__SHIFT) & A6XX_RB_DEPTH_BUFFER_ARRAY_PITCH__MASK;
}


#define REG_A6XX_RB_DEPTH_BUFFER_BASE				0x00008875
static CONSTEXPR inline uint32_t A6XX_RB_DEPTH_BUFFER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RB_DEPTH_BUFFER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RB_DEPTH_GMEM_BASE				0x00008877


#define REG_A6XX_RB_DEPTH_BOUND_MIN				0x00008878
#define A6XX_RB_DEPTH_BOUND_MIN__MASK				0xffffffffull
#define A6XX_RB_DEPTH_BOUND_MIN__SHIFT				0
static inline uint32_t A6XX_RB_DEPTH_BOUND_MIN(float val)
{
	return ((fui(val)) << A6XX_RB_DEPTH_BOUND_MIN__SHIFT) & A6XX_RB_DEPTH_BOUND_MIN__MASK;
}


#define REG_A6XX_RB_DEPTH_BOUND_MAX				0x00008879
#define A6XX_RB_DEPTH_BOUND_MAX__MASK				0xffffffffull
#define A6XX_RB_DEPTH_BOUND_MAX__SHIFT				0
static inline uint32_t A6XX_RB_DEPTH_BOUND_MAX(float val)
{
	return ((fui(val)) << A6XX_RB_DEPTH_BOUND_MAX__SHIFT) & A6XX_RB_DEPTH_BOUND_MAX__MASK;
}


#define REG_A6XX_RB_STENCIL_CNTL				0x00008880
#define A6XX_RB_STENCIL_CNTL_STENCIL_ENABLE			0x00000001
#define A6XX_RB_STENCIL_CNTL_STENCIL_ENABLE_BF			0x00000002
#define A6XX_RB_STENCIL_CNTL_STENCIL_READ			0x00000004
#define A6XX_RB_STENCIL_CNTL_FUNC__MASK				0x00000700ull
#define A6XX_RB_STENCIL_CNTL_FUNC__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_RB_STENCIL_CNTL_FUNC(enum adreno_compare_func val)
{
	return ((val) << A6XX_RB_STENCIL_CNTL_FUNC__SHIFT) & A6XX_RB_STENCIL_CNTL_FUNC__MASK;
}
#define A6XX_RB_STENCIL_CNTL_FAIL__MASK				0x00003800ull
#define A6XX_RB_STENCIL_CNTL_FAIL__SHIFT			11
static CONSTEXPR inline uint32_t A6XX_RB_STENCIL_CNTL_FAIL(enum adreno_stencil_op val)
{
	return ((val) << A6XX_RB_STENCIL_CNTL_FAIL__SHIFT) & A6XX_RB_STENCIL_CNTL_FAIL__MASK;
}
#define A6XX_RB_STENCIL_CNTL_ZPASS__MASK			0x0001c000ull
#define A6XX_RB_STENCIL_CNTL_ZPASS__SHIFT			14
static CONSTEXPR inline uint32_t A6XX_RB_STENCIL_CNTL_ZPASS(enum adreno_stencil_op val)
{
	return ((val) << A6XX_RB_STENCIL_CNTL_ZPASS__SHIFT) & A6XX_RB_STENCIL_CNTL_ZPASS__MASK;
}
#define A6XX_RB_STENCIL_CNTL_ZFAIL__MASK			0x000e0000ull
#define A6XX_RB_STENCIL_CNTL_ZFAIL__SHIFT			17
static CONSTEXPR inline uint32_t A6XX_RB_STENCIL_CNTL_ZFAIL(enum adreno_stencil_op val)
{
	return ((val) << A6XX_RB_STENCIL_CNTL_ZFAIL__SHIFT) & A6XX_RB_STENCIL_CNTL_ZFAIL__MASK;
}
#define A6XX_RB_STENCIL_CNTL_FUNC_BF__MASK			0x00700000ull
#define A6XX_RB_STENCIL_CNTL_FUNC_BF__SHIFT			20
static CONSTEXPR inline uint32_t A6XX_RB_STENCIL_CNTL_FUNC_BF(enum adreno_compare_func val)
{
	return ((val) << A6XX_RB_STENCIL_CNTL_FUNC_BF__SHIFT) & A6XX_RB_STENCIL_CNTL_FUNC_BF__MASK;
}
#define A6XX_RB_STENCIL_CNTL_FAIL_BF__MASK			0x03800000ull
#define A6XX_RB_STENCIL_CNTL_FAIL_BF__SHIFT			23
static CONSTEXPR inline uint32_t A6XX_RB_STENCIL_CNTL_FAIL_BF(enum adreno_stencil_op val)
{
	return ((val) << A6XX_RB_STENCIL_CNTL_FAIL_BF__SHIFT) & A6XX_RB_STENCIL_CNTL_FAIL_BF__MASK;
}
#define A6XX_RB_STENCIL_CNTL_ZPASS_BF__MASK			0x1c000000ull
#define A6XX_RB_STENCIL_CNTL_ZPASS_BF__SHIFT			26
static CONSTEXPR inline uint32_t A6XX_RB_STENCIL_CNTL_ZPASS_BF(enum adreno_stencil_op val)
{
	return ((val) << A6XX_RB_STENCIL_CNTL_ZPASS_BF__SHIFT) & A6XX_RB_STENCIL_CNTL_ZPASS_BF__MASK;
}
#define A6XX_RB_STENCIL_CNTL_ZFAIL_BF__MASK			0xe0000000ull
#define A6XX_RB_STENCIL_CNTL_ZFAIL_BF__SHIFT			29
static CONSTEXPR inline uint32_t A6XX_RB_STENCIL_CNTL_ZFAIL_BF(enum adreno_stencil_op val)
{
	return ((val) << A6XX_RB_STENCIL_CNTL_ZFAIL_BF__SHIFT) & A6XX_RB_STENCIL_CNTL_ZFAIL_BF__MASK;
}


#define REG_A6XX_RB_STENCIL_BUFFER_INFO				__FD_DEPRECATED 0x00008881
#define A6XX_RB_STENCIL_BUFFER_INFO_SEPARATE_STENCIL		0x00000001
#define A6XX_RB_STENCIL_BUFFER_INFO_UNK1			0x00000002


#define REG_A7XX_RB_STENCIL_BUFFER_INFO				__FD_DEPRECATED 0x00008881
#define A7XX_RB_STENCIL_BUFFER_INFO_SEPARATE_STENCIL		0x00000001
#define A7XX_RB_STENCIL_BUFFER_INFO_UNK1			0x00000002
#define A7XX_RB_STENCIL_BUFFER_INFO_TILEMODE__MASK		0x0000000cull
#define A7XX_RB_STENCIL_BUFFER_INFO_TILEMODE__SHIFT		2
static CONSTEXPR inline uint32_t A7XX_RB_STENCIL_BUFFER_INFO_TILEMODE(enum a6xx_tile_mode val)
{
	return ((val) << A7XX_RB_STENCIL_BUFFER_INFO_TILEMODE__SHIFT) & A7XX_RB_STENCIL_BUFFER_INFO_TILEMODE__MASK;
}


#define REG_A6XX_RB_STENCIL_BUFFER_PITCH			0x00008882
#define A6XX_RB_STENCIL_BUFFER_PITCH__MASK			0x00000fffull
#define A6XX_RB_STENCIL_BUFFER_PITCH__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_RB_STENCIL_BUFFER_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_RB_STENCIL_BUFFER_PITCH__SHIFT) & A6XX_RB_STENCIL_BUFFER_PITCH__MASK;
}


#define REG_A6XX_RB_STENCIL_BUFFER_ARRAY_PITCH			0x00008883
#define A6XX_RB_STENCIL_BUFFER_ARRAY_PITCH__MASK		0x00ffffffull
#define A6XX_RB_STENCIL_BUFFER_ARRAY_PITCH__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_RB_STENCIL_BUFFER_ARRAY_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_RB_STENCIL_BUFFER_ARRAY_PITCH__SHIFT) & A6XX_RB_STENCIL_BUFFER_ARRAY_PITCH__MASK;
}


#define REG_A6XX_RB_STENCIL_BUFFER_BASE				0x00008884
static CONSTEXPR inline uint32_t A6XX_RB_STENCIL_BUFFER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RB_STENCIL_BUFFER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RB_STENCIL_GMEM_BASE				0x00008886


#define REG_A6XX_RB_STENCIL_REF_CNTL				0x00008887
#define A6XX_RB_STENCIL_REF_CNTL_REF__MASK			0x000000ffull
#define A6XX_RB_STENCIL_REF_CNTL_REF__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_RB_STENCIL_REF_CNTL_REF(uint32_t val)
{
	return ((val) << A6XX_RB_STENCIL_REF_CNTL_REF__SHIFT) & A6XX_RB_STENCIL_REF_CNTL_REF__MASK;
}
#define A6XX_RB_STENCIL_REF_CNTL_BFREF__MASK			0x0000ff00ull
#define A6XX_RB_STENCIL_REF_CNTL_BFREF__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_RB_STENCIL_REF_CNTL_BFREF(uint32_t val)
{
	return ((val) << A6XX_RB_STENCIL_REF_CNTL_BFREF__SHIFT) & A6XX_RB_STENCIL_REF_CNTL_BFREF__MASK;
}


#define REG_A6XX_RB_STENCIL_MASK				0x00008888
#define A6XX_RB_STENCIL_MASK_MASK__MASK				0x000000ffull
#define A6XX_RB_STENCIL_MASK_MASK__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_RB_STENCIL_MASK_MASK(uint32_t val)
{
	return ((val) << A6XX_RB_STENCIL_MASK_MASK__SHIFT) & A6XX_RB_STENCIL_MASK_MASK__MASK;
}
#define A6XX_RB_STENCIL_MASK_BFMASK__MASK			0x0000ff00ull
#define A6XX_RB_STENCIL_MASK_BFMASK__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_RB_STENCIL_MASK_BFMASK(uint32_t val)
{
	return ((val) << A6XX_RB_STENCIL_MASK_BFMASK__SHIFT) & A6XX_RB_STENCIL_MASK_BFMASK__MASK;
}


#define REG_A6XX_RB_STENCIL_WRITE_MASK				0x00008889
#define A6XX_RB_STENCIL_WRITE_MASK_WRMASK__MASK			0x000000ffull
#define A6XX_RB_STENCIL_WRITE_MASK_WRMASK__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_RB_STENCIL_WRITE_MASK_WRMASK(uint32_t val)
{
	return ((val) << A6XX_RB_STENCIL_WRITE_MASK_WRMASK__SHIFT) & A6XX_RB_STENCIL_WRITE_MASK_WRMASK__MASK;
}
#define A6XX_RB_STENCIL_WRITE_MASK_BFWRMASK__MASK		0x0000ff00ull
#define A6XX_RB_STENCIL_WRITE_MASK_BFWRMASK__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_RB_STENCIL_WRITE_MASK_BFWRMASK(uint32_t val)
{
	return ((val) << A6XX_RB_STENCIL_WRITE_MASK_BFWRMASK__SHIFT) & A6XX_RB_STENCIL_WRITE_MASK_BFWRMASK__MASK;
}


#define REG_A6XX_RB_WINDOW_OFFSET				0x00008890
#define A6XX_RB_WINDOW_OFFSET_X__MASK				0x00003fffull
#define A6XX_RB_WINDOW_OFFSET_X__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_RB_WINDOW_OFFSET_X(uint32_t val)
{
	return ((val) << A6XX_RB_WINDOW_OFFSET_X__SHIFT) & A6XX_RB_WINDOW_OFFSET_X__MASK;
}
#define A6XX_RB_WINDOW_OFFSET_Y__MASK				0x3fff0000ull
#define A6XX_RB_WINDOW_OFFSET_Y__SHIFT				16
static CONSTEXPR inline uint32_t A6XX_RB_WINDOW_OFFSET_Y(uint32_t val)
{
	return ((val) << A6XX_RB_WINDOW_OFFSET_Y__SHIFT) & A6XX_RB_WINDOW_OFFSET_Y__MASK;
}


#define REG_A6XX_RB_SAMPLE_COUNTER_CNTL				0x00008891
#define A6XX_RB_SAMPLE_COUNTER_CNTL_DISABLE			0x00000001
#define A6XX_RB_SAMPLE_COUNTER_CNTL_COPY			0x00000002


#define REG_A6XX_RB_LRZ_CNTL					0x00008898
#define A6XX_RB_LRZ_CNTL_ENABLE					0x00000001


#define REG_A7XX_RB_LRZ_CNTL2					__FD_DEPRECATED 0x00008899
#define A7XX_RB_LRZ_CNTL2_ENABLE_BIDIRECTIONAL_LRZ		0x00000001


#define REG_A6XX_RB_VIEWPORT_ZCLAMP_MIN				__FD_DEPRECATED 0x000088c0
#define A6XX_RB_VIEWPORT_ZCLAMP_MIN__MASK			0xffffffffull
#define A6XX_RB_VIEWPORT_ZCLAMP_MIN__SHIFT			0
static inline uint32_t A6XX_RB_VIEWPORT_ZCLAMP_MIN(float val)
{
	return ((fui(val)) << A6XX_RB_VIEWPORT_ZCLAMP_MIN__SHIFT) & A6XX_RB_VIEWPORT_ZCLAMP_MIN__MASK;
}


#define REG_A6XX_RB_VIEWPORT_ZCLAMP_MAX				__FD_DEPRECATED 0x000088c1
#define A6XX_RB_VIEWPORT_ZCLAMP_MAX__MASK			0xffffffffull
#define A6XX_RB_VIEWPORT_ZCLAMP_MAX__SHIFT			0
static inline uint32_t A6XX_RB_VIEWPORT_ZCLAMP_MAX(float val)
{
	return ((fui(val)) << A6XX_RB_VIEWPORT_ZCLAMP_MAX__SHIFT) & A6XX_RB_VIEWPORT_ZCLAMP_MAX__MASK;
}


#define REG_A8XX_RB_VIEWPORT_ZCLAMP_MIN(i0)			__FD_DEPRECATED (0x000088b0 + 0x1*i0 )

#define A8XX_RB_VIEWPORT_ZCLAMP_MIN_REG__MASK			0xffffffffull
#define A8XX_RB_VIEWPORT_ZCLAMP_MIN_REG__SHIFT			0
static inline uint32_t A8XX_RB_VIEWPORT_ZCLAMP_MIN_REG(float val)
{
	return ((fui(val)) << A8XX_RB_VIEWPORT_ZCLAMP_MIN_REG__SHIFT) & A8XX_RB_VIEWPORT_ZCLAMP_MIN_REG__MASK;
}


#define REG_A8XX_RB_VIEWPORT_ZCLAMP_MAX(i0)			__FD_DEPRECATED (0x000088c0 + 0x1*i0 )

#define A8XX_RB_VIEWPORT_ZCLAMP_MAX_REG__MASK			0xffffffffull
#define A8XX_RB_VIEWPORT_ZCLAMP_MAX_REG__SHIFT			0
static inline uint32_t A8XX_RB_VIEWPORT_ZCLAMP_MAX_REG(float val)
{
	return ((fui(val)) << A8XX_RB_VIEWPORT_ZCLAMP_MAX_REG__SHIFT) & A8XX_RB_VIEWPORT_ZCLAMP_MAX_REG__MASK;
}


#define REG_A6XX_RB_RESOLVE_CNTL_0				0x000088d0
#define A6XX_RB_RESOLVE_CNTL_0_UNK0__MASK			0x00001fffull
#define A6XX_RB_RESOLVE_CNTL_0_UNK0__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_CNTL_0_UNK0(uint32_t val)
{
	return ((val) << A6XX_RB_RESOLVE_CNTL_0_UNK0__SHIFT) & A6XX_RB_RESOLVE_CNTL_0_UNK0__MASK;
}
#define A6XX_RB_RESOLVE_CNTL_0_UNK16__MASK			0x07ff0000ull
#define A6XX_RB_RESOLVE_CNTL_0_UNK16__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_CNTL_0_UNK16(uint32_t val)
{
	return ((val) << A6XX_RB_RESOLVE_CNTL_0_UNK16__SHIFT) & A6XX_RB_RESOLVE_CNTL_0_UNK16__MASK;
}


#define REG_A6XX_RB_RESOLVE_CNTL_1				0x000088d1
#define A6XX_RB_RESOLVE_CNTL_1_X__MASK				0x00003fffull
#define A6XX_RB_RESOLVE_CNTL_1_X__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_CNTL_1_X(uint32_t val)
{
	return ((val) << A6XX_RB_RESOLVE_CNTL_1_X__SHIFT) & A6XX_RB_RESOLVE_CNTL_1_X__MASK;
}
#define A6XX_RB_RESOLVE_CNTL_1_Y__MASK				0x3fff0000ull
#define A6XX_RB_RESOLVE_CNTL_1_Y__SHIFT				16
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_CNTL_1_Y(uint32_t val)
{
	return ((val) << A6XX_RB_RESOLVE_CNTL_1_Y__SHIFT) & A6XX_RB_RESOLVE_CNTL_1_Y__MASK;
}


#define REG_A6XX_RB_RESOLVE_CNTL_2				0x000088d2
#define A6XX_RB_RESOLVE_CNTL_2_X__MASK				0x00003fffull
#define A6XX_RB_RESOLVE_CNTL_2_X__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_CNTL_2_X(uint32_t val)
{
	return ((val) << A6XX_RB_RESOLVE_CNTL_2_X__SHIFT) & A6XX_RB_RESOLVE_CNTL_2_X__MASK;
}
#define A6XX_RB_RESOLVE_CNTL_2_Y__MASK				0x3fff0000ull
#define A6XX_RB_RESOLVE_CNTL_2_Y__SHIFT				16
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_CNTL_2_Y(uint32_t val)
{
	return ((val) << A6XX_RB_RESOLVE_CNTL_2_Y__SHIFT) & A6XX_RB_RESOLVE_CNTL_2_Y__MASK;
}


#define REG_A6XX_RB_RESOLVE_CNTL_3				__FD_DEPRECATED 0x000088d3
#define A6XX_RB_RESOLVE_CNTL_3_BINW__MASK			0x0000003full
#define A6XX_RB_RESOLVE_CNTL_3_BINW__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_CNTL_3_BINW(uint32_t val)
{
	assert(!(val & 0x1f));
	return (((val >> 5)) << A6XX_RB_RESOLVE_CNTL_3_BINW__SHIFT) & A6XX_RB_RESOLVE_CNTL_3_BINW__MASK;
}
#define A6XX_RB_RESOLVE_CNTL_3_BINH__MASK			0x00007f00ull
#define A6XX_RB_RESOLVE_CNTL_3_BINH__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_CNTL_3_BINH(uint32_t val)
{
	assert(!(val & 0xf));
	return (((val >> 4)) << A6XX_RB_RESOLVE_CNTL_3_BINH__SHIFT) & A6XX_RB_RESOLVE_CNTL_3_BINH__MASK;
}


#define REG_A8XX_RB_RESOLVE_CNTL_3				__FD_DEPRECATED 0x000088d3
#define A8XX_RB_RESOLVE_CNTL_3_BINW__MASK			0x000003ffull
#define A8XX_RB_RESOLVE_CNTL_3_BINW__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_RB_RESOLVE_CNTL_3_BINW(uint32_t val)
{
	assert(!(val & 0x1f));
	return (((val >> 5)) << A8XX_RB_RESOLVE_CNTL_3_BINW__SHIFT) & A8XX_RB_RESOLVE_CNTL_3_BINW__MASK;
}
#define A8XX_RB_RESOLVE_CNTL_3_BINH__MASK			0x07ff0000ull
#define A8XX_RB_RESOLVE_CNTL_3_BINH__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_RB_RESOLVE_CNTL_3_BINH(uint32_t val)
{
	assert(!(val & 0xf));
	return (((val >> 4)) << A8XX_RB_RESOLVE_CNTL_3_BINH__SHIFT) & A8XX_RB_RESOLVE_CNTL_3_BINH__MASK;
}


#define REG_A8XX_RB_RESOLVE_CNTL_4				__FD_DEPRECATED 0x000088f0


#define REG_A8XX_RB_RESOLVE_CNTL_5				__FD_DEPRECATED 0x000088f1


#define REG_A6XX_RB_RESOLVE_WINDOW_OFFSET			0x000088d4
#define A6XX_RB_RESOLVE_WINDOW_OFFSET_X__MASK			0x00003fffull
#define A6XX_RB_RESOLVE_WINDOW_OFFSET_X__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_WINDOW_OFFSET_X(uint32_t val)
{
	return ((val) << A6XX_RB_RESOLVE_WINDOW_OFFSET_X__SHIFT) & A6XX_RB_RESOLVE_WINDOW_OFFSET_X__MASK;
}
#define A6XX_RB_RESOLVE_WINDOW_OFFSET_Y__MASK			0x3fff0000ull
#define A6XX_RB_RESOLVE_WINDOW_OFFSET_Y__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_WINDOW_OFFSET_Y(uint32_t val)
{
	return ((val) << A6XX_RB_RESOLVE_WINDOW_OFFSET_Y__SHIFT) & A6XX_RB_RESOLVE_WINDOW_OFFSET_Y__MASK;
}


#define REG_A6XX_RB_RESOLVE_GMEM_BUFFER_INFO			0x000088d5
#define A6XX_RB_RESOLVE_GMEM_BUFFER_INFO_SAMPLES__MASK		0x00000018ull
#define A6XX_RB_RESOLVE_GMEM_BUFFER_INFO_SAMPLES__SHIFT		3
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_GMEM_BUFFER_INFO_SAMPLES(enum a3xx_msaa_samples val)
{
	return ((val) << A6XX_RB_RESOLVE_GMEM_BUFFER_INFO_SAMPLES__SHIFT) & A6XX_RB_RESOLVE_GMEM_BUFFER_INFO_SAMPLES__MASK;
}


#define REG_A6XX_RB_RESOLVE_GMEM_BUFFER_BASE			0x000088d6


#define REG_A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO			0x000088d7
#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_TILE_MODE__MASK	0x00000003ull
#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_TILE_MODE__SHIFT	0
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_TILE_MODE(enum a6xx_tile_mode val)
{
	return ((val) << A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_TILE_MODE__SHIFT) & A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_TILE_MODE__MASK;
}
#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_FLAGS		0x00000004
#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_SAMPLES__MASK	0x00000018ull
#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_SAMPLES__SHIFT	3
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_SAMPLES(enum a3xx_msaa_samples val)
{
	return ((val) << A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_SAMPLES__SHIFT) & A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_SAMPLES__MASK;
}
#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_COLOR_SWAP__MASK	0x00000060ull
#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_COLOR_SWAP__SHIFT	5
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_COLOR_SWAP(enum a3xx_color_swap val)
{
	return ((val) << A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_COLOR_SWAP__SHIFT) & A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_COLOR_SWAP__MASK;
}
#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_COLOR_FORMAT__MASK	0x00007f80ull
#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_COLOR_FORMAT__SHIFT	7
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_COLOR_FORMAT(enum a6xx_format val)
{
	return ((val) << A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_COLOR_FORMAT__SHIFT) & A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_COLOR_FORMAT__MASK;
}
#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_UNK15		0x00008000
#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_INFO_MUTABLEEN		0x00010000


#define REG_A6XX_RB_RESOLVE_SYSTEM_BUFFER_BASE			0x000088d8
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_SYSTEM_BUFFER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_SYSTEM_BUFFER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RB_RESOLVE_SYSTEM_BUFFER_PITCH			0x000088da
#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_PITCH__MASK		0x0000ffffull
#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_PITCH__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_SYSTEM_BUFFER_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_RB_RESOLVE_SYSTEM_BUFFER_PITCH__SHIFT) & A6XX_RB_RESOLVE_SYSTEM_BUFFER_PITCH__MASK;
}


#define REG_A6XX_RB_RESOLVE_SYSTEM_BUFFER_ARRAY_PITCH		0x000088db
#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_ARRAY_PITCH__MASK		0x1fffffffull
#define A6XX_RB_RESOLVE_SYSTEM_BUFFER_ARRAY_PITCH__SHIFT	0
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_SYSTEM_BUFFER_ARRAY_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_RB_RESOLVE_SYSTEM_BUFFER_ARRAY_PITCH__SHIFT) & A6XX_RB_RESOLVE_SYSTEM_BUFFER_ARRAY_PITCH__MASK;
}


#define REG_A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_BASE		0x000088dc
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH		0x000088de
#define A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH_PITCH__MASK	0x000007ffull
#define A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH_PITCH__SHIFT	0
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH_PITCH__SHIFT) & A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH_PITCH__MASK;
}
#define A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH_ARRAY_PITCH__MASK	0x1ffff800ull
#define A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH_ARRAY_PITCH__SHIFT	11
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH_ARRAY_PITCH(uint32_t val)
{
	assert(!(val & 0x7f));
	return (((val >> 7)) << A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH_ARRAY_PITCH__SHIFT) & A6XX_RB_RESOLVE_SYSTEM_FLAG_BUFFER_PITCH_ARRAY_PITCH__MASK;
}


#define REG_A6XX_RB_RESOLVE_CLEAR_COLOR_DW0			0x000088df


#define REG_A6XX_RB_RESOLVE_CLEAR_COLOR_DW1			0x000088e0


#define REG_A6XX_RB_RESOLVE_CLEAR_COLOR_DW2			0x000088e1


#define REG_A6XX_RB_RESOLVE_CLEAR_COLOR_DW3			0x000088e2


#define REG_A6XX_RB_RESOLVE_OPERATION				0x000088e3
#define A6XX_RB_RESOLVE_OPERATION_TYPE__MASK			0x00000003ull
#define A6XX_RB_RESOLVE_OPERATION_TYPE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_OPERATION_TYPE(enum a6xx_blit_event_type val)
{
	return ((val) << A6XX_RB_RESOLVE_OPERATION_TYPE__SHIFT) & A6XX_RB_RESOLVE_OPERATION_TYPE__MASK;
}
#define A6XX_RB_RESOLVE_OPERATION_SAMPLE_0			0x00000004
#define A6XX_RB_RESOLVE_OPERATION_DEPTH				0x00000008
#define A6XX_RB_RESOLVE_OPERATION_CLEAR_MASK__MASK		0x000000f0ull
#define A6XX_RB_RESOLVE_OPERATION_CLEAR_MASK__SHIFT		4
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_OPERATION_CLEAR_MASK(uint32_t val)
{
	return ((val) << A6XX_RB_RESOLVE_OPERATION_CLEAR_MASK__SHIFT) & A6XX_RB_RESOLVE_OPERATION_CLEAR_MASK__MASK;
}
#define A6XX_RB_RESOLVE_OPERATION_LAST__MASK			0x00000300ull
#define A6XX_RB_RESOLVE_OPERATION_LAST__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_OPERATION_LAST(uint32_t val)
{
	return ((val) << A6XX_RB_RESOLVE_OPERATION_LAST__SHIFT) & A6XX_RB_RESOLVE_OPERATION_LAST__MASK;
}
#define A6XX_RB_RESOLVE_OPERATION_BUFFER_ID__MASK		0x0000f000ull
#define A6XX_RB_RESOLVE_OPERATION_BUFFER_ID__SHIFT		12
static CONSTEXPR inline uint32_t A6XX_RB_RESOLVE_OPERATION_BUFFER_ID(uint32_t val)
{
	return ((val) << A6XX_RB_RESOLVE_OPERATION_BUFFER_ID__SHIFT) & A6XX_RB_RESOLVE_OPERATION_BUFFER_ID__MASK;
}


#define REG_A7XX_RB_CLEAR_TARGET				__FD_DEPRECATED 0x000088e4
#define A7XX_RB_CLEAR_TARGET_CLEAR_MODE__MASK			0x00000001ull
#define A7XX_RB_CLEAR_TARGET_CLEAR_MODE__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_RB_CLEAR_TARGET_CLEAR_MODE(enum a7xx_blit_clear_mode val)
{
	return ((val) << A7XX_RB_CLEAR_TARGET_CLEAR_MODE__SHIFT) & A7XX_RB_CLEAR_TARGET_CLEAR_MODE__MASK;
}


#define REG_A7XX_RB_CCU_CACHE_CNTL				__FD_DEPRECATED 0x000088e5
#define A7XX_RB_CCU_CACHE_CNTL_DEPTH_OFFSET_HI__MASK		0x00000001ull
#define A7XX_RB_CCU_CACHE_CNTL_DEPTH_OFFSET_HI__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_RB_CCU_CACHE_CNTL_DEPTH_OFFSET_HI(uint32_t val)
{
	return ((val) << A7XX_RB_CCU_CACHE_CNTL_DEPTH_OFFSET_HI__SHIFT) & A7XX_RB_CCU_CACHE_CNTL_DEPTH_OFFSET_HI__MASK;
}
#define A7XX_RB_CCU_CACHE_CNTL_COLOR_OFFSET_HI__MASK		0x00000004ull
#define A7XX_RB_CCU_CACHE_CNTL_COLOR_OFFSET_HI__SHIFT		2
static CONSTEXPR inline uint32_t A7XX_RB_CCU_CACHE_CNTL_COLOR_OFFSET_HI(uint32_t val)
{
	return ((val) << A7XX_RB_CCU_CACHE_CNTL_COLOR_OFFSET_HI__SHIFT) & A7XX_RB_CCU_CACHE_CNTL_COLOR_OFFSET_HI__MASK;
}
#define A7XX_RB_CCU_CACHE_CNTL_DEPTH_CACHE_SIZE__MASK		0x00000c00ull
#define A7XX_RB_CCU_CACHE_CNTL_DEPTH_CACHE_SIZE__SHIFT		10
static CONSTEXPR inline uint32_t A7XX_RB_CCU_CACHE_CNTL_DEPTH_CACHE_SIZE(enum a6xx_ccu_cache_size val)
{
	return ((val) << A7XX_RB_CCU_CACHE_CNTL_DEPTH_CACHE_SIZE__SHIFT) & A7XX_RB_CCU_CACHE_CNTL_DEPTH_CACHE_SIZE__MASK;
}
#define A7XX_RB_CCU_CACHE_CNTL_DEPTH_OFFSET__MASK		0x001ff000ull
#define A7XX_RB_CCU_CACHE_CNTL_DEPTH_OFFSET__SHIFT		12
static CONSTEXPR inline uint32_t A7XX_RB_CCU_CACHE_CNTL_DEPTH_OFFSET(uint32_t val)
{
	assert(!(val & 0xfff));
	return (((val >> 12)) << A7XX_RB_CCU_CACHE_CNTL_DEPTH_OFFSET__SHIFT) & A7XX_RB_CCU_CACHE_CNTL_DEPTH_OFFSET__MASK;
}
#define A7XX_RB_CCU_CACHE_CNTL_COLOR_CACHE_SIZE__MASK		0x00600000ull
#define A7XX_RB_CCU_CACHE_CNTL_COLOR_CACHE_SIZE__SHIFT		21
static CONSTEXPR inline uint32_t A7XX_RB_CCU_CACHE_CNTL_COLOR_CACHE_SIZE(enum a6xx_ccu_cache_size val)
{
	return ((val) << A7XX_RB_CCU_CACHE_CNTL_COLOR_CACHE_SIZE__SHIFT) & A7XX_RB_CCU_CACHE_CNTL_COLOR_CACHE_SIZE__MASK;
}
#define A7XX_RB_CCU_CACHE_CNTL_COLOR_OFFSET__MASK		0xff800000ull
#define A7XX_RB_CCU_CACHE_CNTL_COLOR_OFFSET__SHIFT		23
static CONSTEXPR inline uint32_t A7XX_RB_CCU_CACHE_CNTL_COLOR_OFFSET(uint32_t val)
{
	assert(!(val & 0xfff));
	return (((val >> 12)) << A7XX_RB_CCU_CACHE_CNTL_COLOR_OFFSET__SHIFT) & A7XX_RB_CCU_CACHE_CNTL_COLOR_OFFSET__MASK;
}


#define REG_A8XX_RB_CCU_CACHE_CNTL				__FD_DEPRECATED 0x000088e5
#define A8XX_RB_CCU_CACHE_CNTL_COLOR_OFFSET__MASK		0x00003fffull
#define A8XX_RB_CCU_CACHE_CNTL_COLOR_OFFSET__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_RB_CCU_CACHE_CNTL_COLOR_OFFSET(uint32_t val)
{
	assert(!(val & 0xfff));
	return (((val >> 12)) << A8XX_RB_CCU_CACHE_CNTL_COLOR_OFFSET__SHIFT) & A8XX_RB_CCU_CACHE_CNTL_COLOR_OFFSET__MASK;
}
#define A8XX_RB_CCU_CACHE_CNTL_COLOR_CACHE_SIZE__MASK		0x0000c000ull
#define A8XX_RB_CCU_CACHE_CNTL_COLOR_CACHE_SIZE__SHIFT		14
static CONSTEXPR inline uint32_t A8XX_RB_CCU_CACHE_CNTL_COLOR_CACHE_SIZE(enum a6xx_ccu_cache_size val)
{
	return ((val) << A8XX_RB_CCU_CACHE_CNTL_COLOR_CACHE_SIZE__SHIFT) & A8XX_RB_CCU_CACHE_CNTL_COLOR_CACHE_SIZE__MASK;
}
#define A8XX_RB_CCU_CACHE_CNTL_DEPTH_OFFSET__MASK		0x3fff0000ull
#define A8XX_RB_CCU_CACHE_CNTL_DEPTH_OFFSET__SHIFT		16
static CONSTEXPR inline uint32_t A8XX_RB_CCU_CACHE_CNTL_DEPTH_OFFSET(uint32_t val)
{
	assert(!(val & 0xfff));
	return (((val >> 12)) << A8XX_RB_CCU_CACHE_CNTL_DEPTH_OFFSET__SHIFT) & A8XX_RB_CCU_CACHE_CNTL_DEPTH_OFFSET__MASK;
}
#define A8XX_RB_CCU_CACHE_CNTL_DEPTH_CACHE_SIZE__MASK		0xc0000000ull
#define A8XX_RB_CCU_CACHE_CNTL_DEPTH_CACHE_SIZE__SHIFT		30
static CONSTEXPR inline uint32_t A8XX_RB_CCU_CACHE_CNTL_DEPTH_CACHE_SIZE(enum a6xx_ccu_cache_size val)
{
	return ((val) << A8XX_RB_CCU_CACHE_CNTL_DEPTH_CACHE_SIZE__SHIFT) & A8XX_RB_CCU_CACHE_CNTL_DEPTH_CACHE_SIZE__MASK;
}


#define REG_A8XX_RB_RESOLVE_GMEM_BUFFER_CNTL			__FD_DEPRECATED 0x000088e6
#define A8XX_RB_RESOLVE_GMEM_BUFFER_CNTL_FULL_IN_GMEM		0x00000001


#define REG_A6XX_RB_UNKNOWN_88F0				__FD_DEPRECATED 0x000088f0


#define REG_A6XX_RB_UNK_FLAG_BUFFER_BASE			__FD_DEPRECATED 0x000088f1
static CONSTEXPR inline uint32_t A6XX_RB_UNK_FLAG_BUFFER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RB_UNK_FLAG_BUFFER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RB_UNK_FLAG_BUFFER_PITCH			__FD_DEPRECATED 0x000088f3
#define A6XX_RB_UNK_FLAG_BUFFER_PITCH_PITCH__MASK		0x000007ffull
#define A6XX_RB_UNK_FLAG_BUFFER_PITCH_PITCH__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_RB_UNK_FLAG_BUFFER_PITCH_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_RB_UNK_FLAG_BUFFER_PITCH_PITCH__SHIFT) & A6XX_RB_UNK_FLAG_BUFFER_PITCH_PITCH__MASK;
}
#define A6XX_RB_UNK_FLAG_BUFFER_PITCH_ARRAY_PITCH__MASK		0x1ffff800ull
#define A6XX_RB_UNK_FLAG_BUFFER_PITCH_ARRAY_PITCH__SHIFT	11
static CONSTEXPR inline uint32_t A6XX_RB_UNK_FLAG_BUFFER_PITCH_ARRAY_PITCH(uint32_t val)
{
	assert(!(val & 0x7f));
	return (((val >> 7)) << A6XX_RB_UNK_FLAG_BUFFER_PITCH_ARRAY_PITCH__SHIFT) & A6XX_RB_UNK_FLAG_BUFFER_PITCH_ARRAY_PITCH__MASK;
}


#define REG_A6XX_RB_VRS_CONFIG					0x000088f4
#define A6XX_RB_VRS_CONFIG_UNK2					0x00000004
#define A6XX_RB_VRS_CONFIG_PIPELINE_FSR_ENABLE			0x00000010
#define A6XX_RB_VRS_CONFIG_ATTACHMENT_FSR_ENABLE		0x00000020
#define A6XX_RB_VRS_CONFIG_PRIMITIVE_FSR_ENABLE			0x00040000


#define REG_A7XX_RB_BIN_FOVEAT					__FD_DEPRECATED 0x000088f5
#define A7XX_RB_BIN_FOVEAT_BINSCALEEN				0x00000040


#define REG_A8XX_RB_BIN_FOVEAT_XY(i0)				(0x00008950 + 0x1*i0 )

#define A8XX_RB_BIN_FOVEAT_XY_OFFSET_XOFFSET__MASK		0x00003fffull
#define A8XX_RB_BIN_FOVEAT_XY_OFFSET_XOFFSET__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_RB_BIN_FOVEAT_XY_OFFSET_XOFFSET(uint32_t val)
{
	return ((val) << A8XX_RB_BIN_FOVEAT_XY_OFFSET_XOFFSET__SHIFT) & A8XX_RB_BIN_FOVEAT_XY_OFFSET_XOFFSET__MASK;
}
#define A8XX_RB_BIN_FOVEAT_XY_OFFSET_YOFFSET__MASK		0x3fff0000ull
#define A8XX_RB_BIN_FOVEAT_XY_OFFSET_YOFFSET__SHIFT		16
static CONSTEXPR inline uint32_t A8XX_RB_BIN_FOVEAT_XY_OFFSET_YOFFSET(uint32_t val)
{
	return ((val) << A8XX_RB_BIN_FOVEAT_XY_OFFSET_YOFFSET__SHIFT) & A8XX_RB_BIN_FOVEAT_XY_OFFSET_YOFFSET__MASK;
}


#define REG_A8XX_RB_BIN_FOVEAT_XY_FDM(i0)			(0x00008960 + 0x1*i0 )

#define A8XX_RB_BIN_FOVEAT_XY_FDM_OFFSET_XOFFSET__MASK		0x00003fffull
#define A8XX_RB_BIN_FOVEAT_XY_FDM_OFFSET_XOFFSET__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_RB_BIN_FOVEAT_XY_FDM_OFFSET_XOFFSET(uint32_t val)
{
	return ((val) << A8XX_RB_BIN_FOVEAT_XY_FDM_OFFSET_XOFFSET__SHIFT) & A8XX_RB_BIN_FOVEAT_XY_FDM_OFFSET_XOFFSET__MASK;
}
#define A8XX_RB_BIN_FOVEAT_XY_FDM_OFFSET_YOFFSET__MASK		0x3fff0000ull
#define A8XX_RB_BIN_FOVEAT_XY_FDM_OFFSET_YOFFSET__SHIFT		16
static CONSTEXPR inline uint32_t A8XX_RB_BIN_FOVEAT_XY_FDM_OFFSET_YOFFSET(uint32_t val)
{
	return ((val) << A8XX_RB_BIN_FOVEAT_XY_FDM_OFFSET_YOFFSET__SHIFT) & A8XX_RB_BIN_FOVEAT_XY_FDM_OFFSET_YOFFSET__MASK;
}


#define REG_A6XX_RB_DEPTH_FLAG_BUFFER_BASE			0x00008900
static CONSTEXPR inline uint32_t A6XX_RB_DEPTH_FLAG_BUFFER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RB_DEPTH_FLAG_BUFFER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RB_DEPTH_FLAG_BUFFER_PITCH			0x00008902
#define A6XX_RB_DEPTH_FLAG_BUFFER_PITCH_PITCH__MASK		0x0000007full
#define A6XX_RB_DEPTH_FLAG_BUFFER_PITCH_PITCH__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_RB_DEPTH_FLAG_BUFFER_PITCH_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_RB_DEPTH_FLAG_BUFFER_PITCH_PITCH__SHIFT) & A6XX_RB_DEPTH_FLAG_BUFFER_PITCH_PITCH__MASK;
}
#define A6XX_RB_DEPTH_FLAG_BUFFER_PITCH_UNK8__MASK		0x00000700ull
#define A6XX_RB_DEPTH_FLAG_BUFFER_PITCH_UNK8__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_RB_DEPTH_FLAG_BUFFER_PITCH_UNK8(uint32_t val)
{
	return ((val) << A6XX_RB_DEPTH_FLAG_BUFFER_PITCH_UNK8__SHIFT) & A6XX_RB_DEPTH_FLAG_BUFFER_PITCH_UNK8__MASK;
}
#define A6XX_RB_DEPTH_FLAG_BUFFER_PITCH_ARRAY_PITCH__MASK	0x0ffff800ull
#define A6XX_RB_DEPTH_FLAG_BUFFER_PITCH_ARRAY_PITCH__SHIFT	11
static CONSTEXPR inline uint32_t A6XX_RB_DEPTH_FLAG_BUFFER_PITCH_ARRAY_PITCH(uint32_t val)
{
	assert(!(val & 0x7f));
	return (((val >> 7)) << A6XX_RB_DEPTH_FLAG_BUFFER_PITCH_ARRAY_PITCH__SHIFT) & A6XX_RB_DEPTH_FLAG_BUFFER_PITCH_ARRAY_PITCH__MASK;
}


#define REG_A6XX_RB_COLOR_FLAG_BUFFER(i0)			(0x00008903 + 0x3*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_RB_COLOR_FLAG_BUFFER_ADDR(uint32_t i0) { return 0x00008903 + 0x3*i0; }
static CONSTEXPR inline uint32_t A6XX_RB_COLOR_FLAG_BUFFER_ADDR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RB_COLOR_FLAG_BUFFER_ADDR_HI(uint32_t val)
{
	return val;
}


static CONSTEXPR inline uint32_t REG_A6XX_RB_COLOR_FLAG_BUFFER_PITCH(uint32_t i0) { return 0x00008905 + 0x3*i0; }
#define A6XX_RB_COLOR_FLAG_BUFFER_PITCH_PITCH__MASK		0x000007ffull
#define A6XX_RB_COLOR_FLAG_BUFFER_PITCH_PITCH__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_RB_COLOR_FLAG_BUFFER_PITCH_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_RB_COLOR_FLAG_BUFFER_PITCH_PITCH__SHIFT) & A6XX_RB_COLOR_FLAG_BUFFER_PITCH_PITCH__MASK;
}
#define A6XX_RB_COLOR_FLAG_BUFFER_PITCH_ARRAY_PITCH__MASK	0x1ffff800ull
#define A6XX_RB_COLOR_FLAG_BUFFER_PITCH_ARRAY_PITCH__SHIFT	11
static CONSTEXPR inline uint32_t A6XX_RB_COLOR_FLAG_BUFFER_PITCH_ARRAY_PITCH(uint32_t val)
{
	assert(!(val & 0x7f));
	return (((val >> 7)) << A6XX_RB_COLOR_FLAG_BUFFER_PITCH_ARRAY_PITCH__SHIFT) & A6XX_RB_COLOR_FLAG_BUFFER_PITCH_ARRAY_PITCH__MASK;
}


#define REG_A6XX_RB_SAMPLE_COUNTER_BASE				0x00008927
static CONSTEXPR inline uint32_t A6XX_RB_SAMPLE_COUNTER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RB_SAMPLE_COUNTER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_RB_DEPTH_GMEM_DIMENSION			__FD_DEPRECATED 0x00008813
#define A8XX_RB_DEPTH_GMEM_DIMENSION_WIDTH__MASK		0x00007fffull
#define A8XX_RB_DEPTH_GMEM_DIMENSION_WIDTH__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_RB_DEPTH_GMEM_DIMENSION_WIDTH(uint32_t val)
{
	return ((val) << A8XX_RB_DEPTH_GMEM_DIMENSION_WIDTH__SHIFT) & A8XX_RB_DEPTH_GMEM_DIMENSION_WIDTH__MASK;
}
#define A8XX_RB_DEPTH_GMEM_DIMENSION_HEIGHT__MASK		0x7fff0000ull
#define A8XX_RB_DEPTH_GMEM_DIMENSION_HEIGHT__SHIFT		16
static CONSTEXPR inline uint32_t A8XX_RB_DEPTH_GMEM_DIMENSION_HEIGHT(uint32_t val)
{
	return ((val) << A8XX_RB_DEPTH_GMEM_DIMENSION_HEIGHT__SHIFT) & A8XX_RB_DEPTH_GMEM_DIMENSION_HEIGHT__MASK;
}


#define REG_A8XX_RB_STENCIL_GMEM_DIMENSION			__FD_DEPRECATED 0x00008814
#define A8XX_RB_STENCIL_GMEM_DIMENSION_WIDTH__MASK		0x00007fffull
#define A8XX_RB_STENCIL_GMEM_DIMENSION_WIDTH__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_RB_STENCIL_GMEM_DIMENSION_WIDTH(uint32_t val)
{
	return ((val) << A8XX_RB_STENCIL_GMEM_DIMENSION_WIDTH__SHIFT) & A8XX_RB_STENCIL_GMEM_DIMENSION_WIDTH__MASK;
}
#define A8XX_RB_STENCIL_GMEM_DIMENSION_HEIGHT__MASK		0x7fff0000ull
#define A8XX_RB_STENCIL_GMEM_DIMENSION_HEIGHT__SHIFT		16
static CONSTEXPR inline uint32_t A8XX_RB_STENCIL_GMEM_DIMENSION_HEIGHT(uint32_t val)
{
	return ((val) << A8XX_RB_STENCIL_GMEM_DIMENSION_HEIGHT__SHIFT) & A8XX_RB_STENCIL_GMEM_DIMENSION_HEIGHT__MASK;
}


#define REG_A8XX_RB_RESOLVE_GMEM_DIMENSION			__FD_DEPRECATED 0x00008815
#define A8XX_RB_RESOLVE_GMEM_DIMENSION_WIDTH__MASK		0x00007fffull
#define A8XX_RB_RESOLVE_GMEM_DIMENSION_WIDTH__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_RB_RESOLVE_GMEM_DIMENSION_WIDTH(uint32_t val)
{
	return ((val) << A8XX_RB_RESOLVE_GMEM_DIMENSION_WIDTH__SHIFT) & A8XX_RB_RESOLVE_GMEM_DIMENSION_WIDTH__MASK;
}
#define A8XX_RB_RESOLVE_GMEM_DIMENSION_HEIGHT__MASK		0x7fff0000ull
#define A8XX_RB_RESOLVE_GMEM_DIMENSION_HEIGHT__SHIFT		16
static CONSTEXPR inline uint32_t A8XX_RB_RESOLVE_GMEM_DIMENSION_HEIGHT(uint32_t val)
{
	return ((val) << A8XX_RB_RESOLVE_GMEM_DIMENSION_HEIGHT__SHIFT) & A8XX_RB_RESOLVE_GMEM_DIMENSION_HEIGHT__MASK;
}


#define REG_A8XX_RB_MRT_GMEM_DIMENSION(i0)			(0x00008930 + 0x1*i0 )

#define A8XX_RB_MRT_GMEM_DIMENSION_REG_WIDTH__MASK		0x00007fffull
#define A8XX_RB_MRT_GMEM_DIMENSION_REG_WIDTH__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_RB_MRT_GMEM_DIMENSION_REG_WIDTH(uint32_t val)
{
	return ((val) << A8XX_RB_MRT_GMEM_DIMENSION_REG_WIDTH__SHIFT) & A8XX_RB_MRT_GMEM_DIMENSION_REG_WIDTH__MASK;
}
#define A8XX_RB_MRT_GMEM_DIMENSION_REG_HEIGHT__MASK		0x7fff0000ull
#define A8XX_RB_MRT_GMEM_DIMENSION_REG_HEIGHT__SHIFT		16
static CONSTEXPR inline uint32_t A8XX_RB_MRT_GMEM_DIMENSION_REG_HEIGHT(uint32_t val)
{
	return ((val) << A8XX_RB_MRT_GMEM_DIMENSION_REG_HEIGHT__SHIFT) & A8XX_RB_MRT_GMEM_DIMENSION_REG_HEIGHT__MASK;
}


#define REG_A6XX_RB_UNKNOWN_8A00				__FD_DEPRECATED 0x00008a00


#define REG_A6XX_RB_UNKNOWN_8A10				__FD_DEPRECATED 0x00008a10


#define REG_A6XX_RB_UNKNOWN_8A20				__FD_DEPRECATED 0x00008a20


#define REG_A6XX_RB_UNKNOWN_8A30				__FD_DEPRECATED 0x00008a30


#define REG_A6XX_RB_A2D_BLT_CNTL				0x00008c00
#define A6XX_RB_A2D_BLT_CNTL_ROTATE__MASK			0x00000007ull
#define A6XX_RB_A2D_BLT_CNTL_ROTATE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_RB_A2D_BLT_CNTL_ROTATE(enum a6xx_rotation val)
{
	return ((val) << A6XX_RB_A2D_BLT_CNTL_ROTATE__SHIFT) & A6XX_RB_A2D_BLT_CNTL_ROTATE__MASK;
}
#define A6XX_RB_A2D_BLT_CNTL_OVERWRITEEN			0x00000008
#define A6XX_RB_A2D_BLT_CNTL_UNK4__MASK				0x00000070ull
#define A6XX_RB_A2D_BLT_CNTL_UNK4__SHIFT			4
static CONSTEXPR inline uint32_t A6XX_RB_A2D_BLT_CNTL_UNK4(uint32_t val)
{
	return ((val) << A6XX_RB_A2D_BLT_CNTL_UNK4__SHIFT) & A6XX_RB_A2D_BLT_CNTL_UNK4__MASK;
}
#define A6XX_RB_A2D_BLT_CNTL_SOLID_COLOR			0x00000080
#define A6XX_RB_A2D_BLT_CNTL_COLOR_FORMAT__MASK			0x0000ff00ull
#define A6XX_RB_A2D_BLT_CNTL_COLOR_FORMAT__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_RB_A2D_BLT_CNTL_COLOR_FORMAT(enum a6xx_format val)
{
	return ((val) << A6XX_RB_A2D_BLT_CNTL_COLOR_FORMAT__SHIFT) & A6XX_RB_A2D_BLT_CNTL_COLOR_FORMAT__MASK;
}
#define A6XX_RB_A2D_BLT_CNTL_SCISSOR				0x00010000
#define A6XX_RB_A2D_BLT_CNTL_UNK17__MASK			0x00060000ull
#define A6XX_RB_A2D_BLT_CNTL_UNK17__SHIFT			17
static CONSTEXPR inline uint32_t A6XX_RB_A2D_BLT_CNTL_UNK17(uint32_t val)
{
	return ((val) << A6XX_RB_A2D_BLT_CNTL_UNK17__SHIFT) & A6XX_RB_A2D_BLT_CNTL_UNK17__MASK;
}
#define A6XX_RB_A2D_BLT_CNTL_D24S8				0x00080000
#define A6XX_RB_A2D_BLT_CNTL_MASK__MASK				0x00f00000ull
#define A6XX_RB_A2D_BLT_CNTL_MASK__SHIFT			20
static CONSTEXPR inline uint32_t A6XX_RB_A2D_BLT_CNTL_MASK(uint32_t val)
{
	return ((val) << A6XX_RB_A2D_BLT_CNTL_MASK__SHIFT) & A6XX_RB_A2D_BLT_CNTL_MASK__MASK;
}
#define A6XX_RB_A2D_BLT_CNTL_IFMT__MASK				0x07000000ull
#define A6XX_RB_A2D_BLT_CNTL_IFMT__SHIFT			24
static CONSTEXPR inline uint32_t A6XX_RB_A2D_BLT_CNTL_IFMT(enum a6xx_2d_ifmt val)
{
	return ((val) << A6XX_RB_A2D_BLT_CNTL_IFMT__SHIFT) & A6XX_RB_A2D_BLT_CNTL_IFMT__MASK;
}
#define A6XX_RB_A2D_BLT_CNTL_UNK27				0x08000000
#define A6XX_RB_A2D_BLT_CNTL_UNK28				0x10000000
#define A6XX_RB_A2D_BLT_CNTL_RASTER_MODE__MASK			0x20000000ull
#define A6XX_RB_A2D_BLT_CNTL_RASTER_MODE__SHIFT			29
static CONSTEXPR inline uint32_t A6XX_RB_A2D_BLT_CNTL_RASTER_MODE(enum a6xx_raster_mode val)
{
	return ((val) << A6XX_RB_A2D_BLT_CNTL_RASTER_MODE__SHIFT) & A6XX_RB_A2D_BLT_CNTL_RASTER_MODE__MASK;
}
#define A6XX_RB_A2D_BLT_CNTL_COPY				0x40000000


#define REG_A6XX_RB_A2D_PIXEL_CNTL				0x00008c01


#define REG_A6XX_RB_A2D_DEST_BUFFER_INFO			0x00008c17
#define A6XX_RB_A2D_DEST_BUFFER_INFO_COLOR_FORMAT__MASK		0x000000ffull
#define A6XX_RB_A2D_DEST_BUFFER_INFO_COLOR_FORMAT__SHIFT	0
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_BUFFER_INFO_COLOR_FORMAT(enum a6xx_format val)
{
	return ((val) << A6XX_RB_A2D_DEST_BUFFER_INFO_COLOR_FORMAT__SHIFT) & A6XX_RB_A2D_DEST_BUFFER_INFO_COLOR_FORMAT__MASK;
}
#define A6XX_RB_A2D_DEST_BUFFER_INFO_TILE_MODE__MASK		0x00000300ull
#define A6XX_RB_A2D_DEST_BUFFER_INFO_TILE_MODE__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_BUFFER_INFO_TILE_MODE(enum a6xx_tile_mode val)
{
	return ((val) << A6XX_RB_A2D_DEST_BUFFER_INFO_TILE_MODE__SHIFT) & A6XX_RB_A2D_DEST_BUFFER_INFO_TILE_MODE__MASK;
}
#define A6XX_RB_A2D_DEST_BUFFER_INFO_COLOR_SWAP__MASK		0x00000c00ull
#define A6XX_RB_A2D_DEST_BUFFER_INFO_COLOR_SWAP__SHIFT		10
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_BUFFER_INFO_COLOR_SWAP(enum a3xx_color_swap val)
{
	return ((val) << A6XX_RB_A2D_DEST_BUFFER_INFO_COLOR_SWAP__SHIFT) & A6XX_RB_A2D_DEST_BUFFER_INFO_COLOR_SWAP__MASK;
}
#define A6XX_RB_A2D_DEST_BUFFER_INFO_FLAGS			0x00001000
#define A6XX_RB_A2D_DEST_BUFFER_INFO_SRGB			0x00002000
#define A6XX_RB_A2D_DEST_BUFFER_INFO_SAMPLES__MASK		0x0000c000ull
#define A6XX_RB_A2D_DEST_BUFFER_INFO_SAMPLES__SHIFT		14
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_BUFFER_INFO_SAMPLES(enum a3xx_msaa_samples val)
{
	return ((val) << A6XX_RB_A2D_DEST_BUFFER_INFO_SAMPLES__SHIFT) & A6XX_RB_A2D_DEST_BUFFER_INFO_SAMPLES__MASK;
}
#define A6XX_RB_A2D_DEST_BUFFER_INFO_MUTABLEEN			0x00020000


#define REG_A6XX_RB_A2D_DEST_BUFFER_BASE			0x00008c18
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_BUFFER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_BUFFER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RB_A2D_DEST_BUFFER_PITCH			0x00008c1a
#define A6XX_RB_A2D_DEST_BUFFER_PITCH__MASK			0x0000ffffull
#define A6XX_RB_A2D_DEST_BUFFER_PITCH__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_BUFFER_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_RB_A2D_DEST_BUFFER_PITCH__SHIFT) & A6XX_RB_A2D_DEST_BUFFER_PITCH__MASK;
}


#define REG_A6XX_RB_A2D_DEST_BUFFER_BASE_1			0x00008c1b
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_BUFFER_BASE_1_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_BUFFER_BASE_1_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RB_A2D_DEST_BUFFER_PITCH_1			0x00008c1d
#define A6XX_RB_A2D_DEST_BUFFER_PITCH_1__MASK			0x0000ffffull
#define A6XX_RB_A2D_DEST_BUFFER_PITCH_1__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_BUFFER_PITCH_1(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_RB_A2D_DEST_BUFFER_PITCH_1__SHIFT) & A6XX_RB_A2D_DEST_BUFFER_PITCH_1__MASK;
}


#define REG_A6XX_RB_A2D_DEST_BUFFER_BASE_2			0x00008c1e
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_BUFFER_BASE_2_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_BUFFER_BASE_2_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE			0x00008c20
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH			0x00008c22
#define A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_PITCH__MASK		0x000007ffull
#define A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_PITCH__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_PITCH__SHIFT) & A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_PITCH__MASK;
}
#define A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_ARRAY_PITCH__MASK	0x1ffff800ull
#define A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_ARRAY_PITCH__SHIFT	11
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_ARRAY_PITCH(uint32_t val)
{
	assert(!(val & 0x7f));
	return (((val >> 7)) << A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_ARRAY_PITCH__SHIFT) & A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_ARRAY_PITCH__MASK;
}


#define REG_A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE_1			0x00008c23
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE_1_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_FLAG_BUFFER_BASE_1_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_1		0x00008c25
#define A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_1__MASK		0x000000ffull
#define A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_1__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_1(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_1__SHIFT) & A6XX_RB_A2D_DEST_FLAG_BUFFER_PITCH_1__MASK;
}


#define REG_A6XX_RB_A2D_CLEAR_COLOR_DW0				0x00008c2c


#define REG_A6XX_RB_A2D_CLEAR_COLOR_DW1				0x00008c2d


#define REG_A6XX_RB_A2D_CLEAR_COLOR_DW2				0x00008c2e


#define REG_A6XX_RB_A2D_CLEAR_COLOR_DW3				0x00008c2f


#define REG_A7XX_RB_UNKNOWN_8C34				__FD_DEPRECATED 0x00008c34


#define REG_A6XX_RB_RBP_CNTL					0x00008e01


#define REG_A6XX_RB_DBG_ECO_CNTL				0x00008e04


#define REG_A6XX_RB_ADDR_MODE_CNTL				__FD_DEPRECATED 0x00008e05


#define REG_A7XX_RB_CCU_DBG_ECO_CNTL				__FD_DEPRECATED 0x00008e06


#define REG_A6XX_RB_CCU_CNTL					__FD_DEPRECATED 0x00008e07
#define A6XX_RB_CCU_CNTL_GMEM_FAST_CLEAR_DISABLE		0x00000001
#define A6XX_RB_CCU_CNTL_CONCURRENT_RESOLVE			0x00000004
#define A6XX_RB_CCU_CNTL_DEPTH_OFFSET_HI__MASK			0x00000080ull
#define A6XX_RB_CCU_CNTL_DEPTH_OFFSET_HI__SHIFT			7
static CONSTEXPR inline uint32_t A6XX_RB_CCU_CNTL_DEPTH_OFFSET_HI(uint32_t val)
{
	return ((val) << A6XX_RB_CCU_CNTL_DEPTH_OFFSET_HI__SHIFT) & A6XX_RB_CCU_CNTL_DEPTH_OFFSET_HI__MASK;
}
#define A6XX_RB_CCU_CNTL_COLOR_OFFSET_HI__MASK			0x00000200ull
#define A6XX_RB_CCU_CNTL_COLOR_OFFSET_HI__SHIFT			9
static CONSTEXPR inline uint32_t A6XX_RB_CCU_CNTL_COLOR_OFFSET_HI(uint32_t val)
{
	return ((val) << A6XX_RB_CCU_CNTL_COLOR_OFFSET_HI__SHIFT) & A6XX_RB_CCU_CNTL_COLOR_OFFSET_HI__MASK;
}
#define A6XX_RB_CCU_CNTL_DEPTH_CACHE_SIZE__MASK			0x00000c00ull
#define A6XX_RB_CCU_CNTL_DEPTH_CACHE_SIZE__SHIFT		10
static CONSTEXPR inline uint32_t A6XX_RB_CCU_CNTL_DEPTH_CACHE_SIZE(enum a6xx_ccu_cache_size val)
{
	return ((val) << A6XX_RB_CCU_CNTL_DEPTH_CACHE_SIZE__SHIFT) & A6XX_RB_CCU_CNTL_DEPTH_CACHE_SIZE__MASK;
}
#define A6XX_RB_CCU_CNTL_DEPTH_OFFSET__MASK			0x001ff000ull
#define A6XX_RB_CCU_CNTL_DEPTH_OFFSET__SHIFT			12
static CONSTEXPR inline uint32_t A6XX_RB_CCU_CNTL_DEPTH_OFFSET(uint32_t val)
{
	assert(!(val & 0xfff));
	return (((val >> 12)) << A6XX_RB_CCU_CNTL_DEPTH_OFFSET__SHIFT) & A6XX_RB_CCU_CNTL_DEPTH_OFFSET__MASK;
}
#define A6XX_RB_CCU_CNTL_COLOR_CACHE_SIZE__MASK			0x00600000ull
#define A6XX_RB_CCU_CNTL_COLOR_CACHE_SIZE__SHIFT		21
static CONSTEXPR inline uint32_t A6XX_RB_CCU_CNTL_COLOR_CACHE_SIZE(enum a6xx_ccu_cache_size val)
{
	return ((val) << A6XX_RB_CCU_CNTL_COLOR_CACHE_SIZE__SHIFT) & A6XX_RB_CCU_CNTL_COLOR_CACHE_SIZE__MASK;
}
#define A6XX_RB_CCU_CNTL_COLOR_OFFSET__MASK			0xff800000ull
#define A6XX_RB_CCU_CNTL_COLOR_OFFSET__SHIFT			23
static CONSTEXPR inline uint32_t A6XX_RB_CCU_CNTL_COLOR_OFFSET(uint32_t val)
{
	assert(!(val & 0xfff));
	return (((val >> 12)) << A6XX_RB_CCU_CNTL_COLOR_OFFSET__SHIFT) & A6XX_RB_CCU_CNTL_COLOR_OFFSET__MASK;
}


#define REG_A7XX_RB_CCU_CNTL					__FD_DEPRECATED 0x00008e07
#define A7XX_RB_CCU_CNTL_GMEM_FAST_CLEAR_DISABLE		0x00000001
#define A7XX_RB_CCU_CNTL_CONCURRENT_RESOLVE_MODE__MASK		0x0000000cull
#define A7XX_RB_CCU_CNTL_CONCURRENT_RESOLVE_MODE__SHIFT		2
static CONSTEXPR inline uint32_t A7XX_RB_CCU_CNTL_CONCURRENT_RESOLVE_MODE(enum a7xx_concurrent_resolve_mode val)
{
	return ((val) << A7XX_RB_CCU_CNTL_CONCURRENT_RESOLVE_MODE__SHIFT) & A7XX_RB_CCU_CNTL_CONCURRENT_RESOLVE_MODE__MASK;
}
#define A7XX_RB_CCU_CNTL_CONCURRENT_UNRESOLVE_MODE__MASK	0x00000060ull
#define A7XX_RB_CCU_CNTL_CONCURRENT_UNRESOLVE_MODE__SHIFT	5
static CONSTEXPR inline uint32_t A7XX_RB_CCU_CNTL_CONCURRENT_UNRESOLVE_MODE(enum a7xx_concurrent_unresolve_mode val)
{
	return ((val) << A7XX_RB_CCU_CNTL_CONCURRENT_UNRESOLVE_MODE__SHIFT) & A7XX_RB_CCU_CNTL_CONCURRENT_UNRESOLVE_MODE__MASK;
}


#define REG_A6XX_RB_NC_MODE_CNTL				__FD_DEPRECATED 0x00008e08
#define A6XX_RB_NC_MODE_CNTL_MODE				0x00000001
#define A6XX_RB_NC_MODE_CNTL_LOWER_BIT__MASK			0x00000006ull
#define A6XX_RB_NC_MODE_CNTL_LOWER_BIT__SHIFT			1
static CONSTEXPR inline uint32_t A6XX_RB_NC_MODE_CNTL_LOWER_BIT(uint32_t val)
{
	return ((val) << A6XX_RB_NC_MODE_CNTL_LOWER_BIT__SHIFT) & A6XX_RB_NC_MODE_CNTL_LOWER_BIT__MASK;
}
#define A6XX_RB_NC_MODE_CNTL_MIN_ACCESS_LENGTH			0x00000008
#define A6XX_RB_NC_MODE_CNTL_AMSBC				0x00000010
#define A6XX_RB_NC_MODE_CNTL_UPPER_BIT__MASK			0x00000400ull
#define A6XX_RB_NC_MODE_CNTL_UPPER_BIT__SHIFT			10
static CONSTEXPR inline uint32_t A6XX_RB_NC_MODE_CNTL_UPPER_BIT(uint32_t val)
{
	return ((val) << A6XX_RB_NC_MODE_CNTL_UPPER_BIT__SHIFT) & A6XX_RB_NC_MODE_CNTL_UPPER_BIT__MASK;
}
#define A6XX_RB_NC_MODE_CNTL_RGB565_PREDICATOR			0x00000800
#define A6XX_RB_NC_MODE_CNTL_UNK12__MASK			0x00003000ull
#define A6XX_RB_NC_MODE_CNTL_UNK12__SHIFT			12
static CONSTEXPR inline uint32_t A6XX_RB_NC_MODE_CNTL_UNK12(uint32_t val)
{
	return ((val) << A6XX_RB_NC_MODE_CNTL_UNK12__SHIFT) & A6XX_RB_NC_MODE_CNTL_UNK12__MASK;
}


#define REG_A8XX_RB_CCU_NC_MODE_CNTL				__FD_DEPRECATED 0x00008e08


#define REG_A7XX_RB_UNKNOWN_8E09				__FD_DEPRECATED 0x00008e09


#define REG_A8XX_RB_GC_GMEM_PROTECT				__FD_DEPRECATED 0x00008e09


#define REG_A8XX_RB_LPAC_GMEM_PROTECT				__FD_DEPRECATED 0x00008e0a


#define REG_A6XX_RB_PERFCTR_RB_SEL(i0)				(0x00008e10 + 0x1*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_RB_PERFCTR_RB_SEL_REG(uint32_t i0) { return 0x00008e10 + 0x1*i0; }


#define REG_A6XX_RB_PERFCTR_CCU_SEL(i0)				(0x00008e18 + 0x1*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_RB_PERFCTR_CCU_SEL_REG(uint32_t i0) { return 0x00008e18 + 0x1*i0; }


#define REG_A8XX_RB_CMP_NC_MODE_CNTL				__FD_DEPRECATED 0x00008f00


#define REG_A8XX_RB_RESOLVE_PREFETCH_CNTL			__FD_DEPRECATED 0x00008f01


#define REG_A8XX_RB_CMP_DBG_ECO_CNTL				__FD_DEPRECATED 0x00008f02


#define REG_A8XX_RB_UNSLICE_STATUS				__FD_DEPRECATED 0x00008f03


#define REG_A6XX_RB_CMP_DBG_ECO_CNTL				__FD_DEPRECATED 0x00008e28


#define REG_A6XX_RB_PERFCTR_CMP_SEL(i0)				(0x00008e2c + 0x1*i0 )



#define REG_A7XX_RB_PERFCTR_UFC_SEL(i0)				(0x00008e30 + 0x1*i0 )



#define REG_A8XX_RB_PERFCTR_CMP_SEL(i0)				(0x00008f04 + 0x1*i0 )



#define REG_A8XX_RB_PERFCTR_UFC_SEL(i0)				(0x00008f10 + 0x1*i0 )



#define REG_A6XX_RB_SUB_BLOCK_SEL_CNTL_HOST			0x00008e3b


#define REG_A6XX_RB_SUB_BLOCK_SEL_CNTL_CD			0x00008e3d


#define REG_A8XX_RB_UFC_DBG_CNTL				__FD_DEPRECATED 0x00008f29


#define REG_A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ENABLE	0x00008e50


#define REG_A6XX_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE_ADDR	0x00008e51


#define REG_A8XX_RB_SLICE_UFC_PREFETCH_CNTL			__FD_DEPRECATED 0x00008e77


#define REG_A8XX_RB_SLICE_UFC_DBG_CNTL				__FD_DEPRECATED 0x00008e78


#define REG_A7XX_RB_UNKNOWN_8E79				__FD_DEPRECATED 0x00008e79


#define REG_A6XX_VPC_GS_PARAM					__FD_DEPRECATED 0x00009100
#define A6XX_VPC_GS_PARAM_LINELENGTHLOC__MASK			0x000000ffull
#define A6XX_VPC_GS_PARAM_LINELENGTHLOC__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VPC_GS_PARAM_LINELENGTHLOC(uint32_t val)
{
	return ((val) << A6XX_VPC_GS_PARAM_LINELENGTHLOC__SHIFT) & A6XX_VPC_GS_PARAM_LINELENGTHLOC__MASK;
}


#define REG_A6XX_VPC_VS_CLIP_CULL_CNTL				__FD_DEPRECATED 0x00009101
#define A6XX_VPC_VS_CLIP_CULL_CNTL_CLIP_MASK__MASK		0x000000ffull
#define A6XX_VPC_VS_CLIP_CULL_CNTL_CLIP_MASK__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_VPC_VS_CLIP_CULL_CNTL_CLIP_MASK(uint32_t val)
{
	return ((val) << A6XX_VPC_VS_CLIP_CULL_CNTL_CLIP_MASK__SHIFT) & A6XX_VPC_VS_CLIP_CULL_CNTL_CLIP_MASK__MASK;
}
#define A6XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__MASK	0x0000ff00ull
#define A6XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__SHIFT	8
static CONSTEXPR inline uint32_t A6XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC(uint32_t val)
{
	return ((val) << A6XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__SHIFT) & A6XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__MASK;
}
#define A6XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__MASK	0x00ff0000ull
#define A6XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__SHIFT	16
static CONSTEXPR inline uint32_t A6XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC(uint32_t val)
{
	return ((val) << A6XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__SHIFT) & A6XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__MASK;
}


#define REG_A6XX_VPC_GS_CLIP_CULL_CNTL				__FD_DEPRECATED 0x00009102
#define A6XX_VPC_GS_CLIP_CULL_CNTL_CLIP_MASK__MASK		0x000000ffull
#define A6XX_VPC_GS_CLIP_CULL_CNTL_CLIP_MASK__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_VPC_GS_CLIP_CULL_CNTL_CLIP_MASK(uint32_t val)
{
	return ((val) << A6XX_VPC_GS_CLIP_CULL_CNTL_CLIP_MASK__SHIFT) & A6XX_VPC_GS_CLIP_CULL_CNTL_CLIP_MASK__MASK;
}
#define A6XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__MASK	0x0000ff00ull
#define A6XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__SHIFT	8
static CONSTEXPR inline uint32_t A6XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC(uint32_t val)
{
	return ((val) << A6XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__SHIFT) & A6XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__MASK;
}
#define A6XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__MASK	0x00ff0000ull
#define A6XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__SHIFT	16
static CONSTEXPR inline uint32_t A6XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC(uint32_t val)
{
	return ((val) << A6XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__SHIFT) & A6XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__MASK;
}


#define REG_A6XX_VPC_DS_CLIP_CULL_CNTL				__FD_DEPRECATED 0x00009103
#define A6XX_VPC_DS_CLIP_CULL_CNTL_CLIP_MASK__MASK		0x000000ffull
#define A6XX_VPC_DS_CLIP_CULL_CNTL_CLIP_MASK__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_VPC_DS_CLIP_CULL_CNTL_CLIP_MASK(uint32_t val)
{
	return ((val) << A6XX_VPC_DS_CLIP_CULL_CNTL_CLIP_MASK__SHIFT) & A6XX_VPC_DS_CLIP_CULL_CNTL_CLIP_MASK__MASK;
}
#define A6XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__MASK	0x0000ff00ull
#define A6XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__SHIFT	8
static CONSTEXPR inline uint32_t A6XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC(uint32_t val)
{
	return ((val) << A6XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__SHIFT) & A6XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__MASK;
}
#define A6XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__MASK	0x00ff0000ull
#define A6XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__SHIFT	16
static CONSTEXPR inline uint32_t A6XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC(uint32_t val)
{
	return ((val) << A6XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__SHIFT) & A6XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__MASK;
}


#define REG_A8XX_VPC_VS_CLIP_CULL_CNTL				__FD_DEPRECATED 0x00009307
#define A8XX_VPC_VS_CLIP_CULL_CNTL_CLIP_MASK__MASK		0x000000ffull
#define A8XX_VPC_VS_CLIP_CULL_CNTL_CLIP_MASK__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_VPC_VS_CLIP_CULL_CNTL_CLIP_MASK(uint32_t val)
{
	return ((val) << A8XX_VPC_VS_CLIP_CULL_CNTL_CLIP_MASK__SHIFT) & A8XX_VPC_VS_CLIP_CULL_CNTL_CLIP_MASK__MASK;
}
#define A8XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__MASK	0x0000ff00ull
#define A8XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__SHIFT	8
static CONSTEXPR inline uint32_t A8XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC(uint32_t val)
{
	return ((val) << A8XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__SHIFT) & A8XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__MASK;
}
#define A8XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__MASK	0x00ff0000ull
#define A8XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__SHIFT	16
static CONSTEXPR inline uint32_t A8XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC(uint32_t val)
{
	return ((val) << A8XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__SHIFT) & A8XX_VPC_VS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__MASK;
}


#define REG_A8XX_VPC_GS_CLIP_CULL_CNTL				__FD_DEPRECATED 0x00009308
#define A8XX_VPC_GS_CLIP_CULL_CNTL_CLIP_MASK__MASK		0x000000ffull
#define A8XX_VPC_GS_CLIP_CULL_CNTL_CLIP_MASK__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_VPC_GS_CLIP_CULL_CNTL_CLIP_MASK(uint32_t val)
{
	return ((val) << A8XX_VPC_GS_CLIP_CULL_CNTL_CLIP_MASK__SHIFT) & A8XX_VPC_GS_CLIP_CULL_CNTL_CLIP_MASK__MASK;
}
#define A8XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__MASK	0x0000ff00ull
#define A8XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__SHIFT	8
static CONSTEXPR inline uint32_t A8XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC(uint32_t val)
{
	return ((val) << A8XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__SHIFT) & A8XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__MASK;
}
#define A8XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__MASK	0x00ff0000ull
#define A8XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__SHIFT	16
static CONSTEXPR inline uint32_t A8XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC(uint32_t val)
{
	return ((val) << A8XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__SHIFT) & A8XX_VPC_GS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__MASK;
}


#define REG_A8XX_VPC_DS_CLIP_CULL_CNTL				__FD_DEPRECATED 0x00009309
#define A8XX_VPC_DS_CLIP_CULL_CNTL_CLIP_MASK__MASK		0x000000ffull
#define A8XX_VPC_DS_CLIP_CULL_CNTL_CLIP_MASK__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_VPC_DS_CLIP_CULL_CNTL_CLIP_MASK(uint32_t val)
{
	return ((val) << A8XX_VPC_DS_CLIP_CULL_CNTL_CLIP_MASK__SHIFT) & A8XX_VPC_DS_CLIP_CULL_CNTL_CLIP_MASK__MASK;
}
#define A8XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__MASK	0x0000ff00ull
#define A8XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__SHIFT	8
static CONSTEXPR inline uint32_t A8XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC(uint32_t val)
{
	return ((val) << A8XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__SHIFT) & A8XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_03_LOC__MASK;
}
#define A8XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__MASK	0x00ff0000ull
#define A8XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__SHIFT	16
static CONSTEXPR inline uint32_t A8XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC(uint32_t val)
{
	return ((val) << A8XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__SHIFT) & A8XX_VPC_DS_CLIP_CULL_CNTL_CLIP_DIST_47_LOC__MASK;
}


#define REG_A6XX_VPC_VS_CLIP_CULL_CNTL_V2			__FD_DEPRECATED 0x00009311
#define A6XX_VPC_VS_CLIP_CULL_CNTL_V2_CLIP_MASK__MASK		0x000000ffull
#define A6XX_VPC_VS_CLIP_CULL_CNTL_V2_CLIP_MASK__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_VPC_VS_CLIP_CULL_CNTL_V2_CLIP_MASK(uint32_t val)
{
	return ((val) << A6XX_VPC_VS_CLIP_CULL_CNTL_V2_CLIP_MASK__SHIFT) & A6XX_VPC_VS_CLIP_CULL_CNTL_V2_CLIP_MASK__MASK;
}
#define A6XX_VPC_VS_CLIP_CULL_CNTL_V2_CLIP_DIST_03_LOC__MASK	0x0000ff00ull
#define A6XX_VPC_VS_CLIP_CULL_CNTL_V2_CLIP_DIST_03_LOC__SHIFT	8
static CONSTEXPR inline uint32_t A6XX_VPC_VS_CLIP_CULL_CNTL_V2_CLIP_DIST_03_LOC(uint32_t val)
{
	return ((val) << A6XX_VPC_VS_CLIP_CULL_CNTL_V2_CLIP_DIST_03_LOC__SHIFT) & A6XX_VPC_VS_CLIP_CULL_CNTL_V2_CLIP_DIST_03_LOC__MASK;
}
#define A6XX_VPC_VS_CLIP_CULL_CNTL_V2_CLIP_DIST_47_LOC__MASK	0x00ff0000ull
#define A6XX_VPC_VS_CLIP_CULL_CNTL_V2_CLIP_DIST_47_LOC__SHIFT	16
static CONSTEXPR inline uint32_t A6XX_VPC_VS_CLIP_CULL_CNTL_V2_CLIP_DIST_47_LOC(uint32_t val)
{
	return ((val) << A6XX_VPC_VS_CLIP_CULL_CNTL_V2_CLIP_DIST_47_LOC__SHIFT) & A6XX_VPC_VS_CLIP_CULL_CNTL_V2_CLIP_DIST_47_LOC__MASK;
}


#define REG_A6XX_VPC_GS_CLIP_CULL_CNTL_V2			__FD_DEPRECATED 0x00009312
#define A6XX_VPC_GS_CLIP_CULL_CNTL_V2_CLIP_MASK__MASK		0x000000ffull
#define A6XX_VPC_GS_CLIP_CULL_CNTL_V2_CLIP_MASK__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_VPC_GS_CLIP_CULL_CNTL_V2_CLIP_MASK(uint32_t val)
{
	return ((val) << A6XX_VPC_GS_CLIP_CULL_CNTL_V2_CLIP_MASK__SHIFT) & A6XX_VPC_GS_CLIP_CULL_CNTL_V2_CLIP_MASK__MASK;
}
#define A6XX_VPC_GS_CLIP_CULL_CNTL_V2_CLIP_DIST_03_LOC__MASK	0x0000ff00ull
#define A6XX_VPC_GS_CLIP_CULL_CNTL_V2_CLIP_DIST_03_LOC__SHIFT	8
static CONSTEXPR inline uint32_t A6XX_VPC_GS_CLIP_CULL_CNTL_V2_CLIP_DIST_03_LOC(uint32_t val)
{
	return ((val) << A6XX_VPC_GS_CLIP_CULL_CNTL_V2_CLIP_DIST_03_LOC__SHIFT) & A6XX_VPC_GS_CLIP_CULL_CNTL_V2_CLIP_DIST_03_LOC__MASK;
}
#define A6XX_VPC_GS_CLIP_CULL_CNTL_V2_CLIP_DIST_47_LOC__MASK	0x00ff0000ull
#define A6XX_VPC_GS_CLIP_CULL_CNTL_V2_CLIP_DIST_47_LOC__SHIFT	16
static CONSTEXPR inline uint32_t A6XX_VPC_GS_CLIP_CULL_CNTL_V2_CLIP_DIST_47_LOC(uint32_t val)
{
	return ((val) << A6XX_VPC_GS_CLIP_CULL_CNTL_V2_CLIP_DIST_47_LOC__SHIFT) & A6XX_VPC_GS_CLIP_CULL_CNTL_V2_CLIP_DIST_47_LOC__MASK;
}


#define REG_A6XX_VPC_DS_CLIP_CULL_CNTL_V2			__FD_DEPRECATED 0x00009313
#define A6XX_VPC_DS_CLIP_CULL_CNTL_V2_CLIP_MASK__MASK		0x000000ffull
#define A6XX_VPC_DS_CLIP_CULL_CNTL_V2_CLIP_MASK__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_VPC_DS_CLIP_CULL_CNTL_V2_CLIP_MASK(uint32_t val)
{
	return ((val) << A6XX_VPC_DS_CLIP_CULL_CNTL_V2_CLIP_MASK__SHIFT) & A6XX_VPC_DS_CLIP_CULL_CNTL_V2_CLIP_MASK__MASK;
}
#define A6XX_VPC_DS_CLIP_CULL_CNTL_V2_CLIP_DIST_03_LOC__MASK	0x0000ff00ull
#define A6XX_VPC_DS_CLIP_CULL_CNTL_V2_CLIP_DIST_03_LOC__SHIFT	8
static CONSTEXPR inline uint32_t A6XX_VPC_DS_CLIP_CULL_CNTL_V2_CLIP_DIST_03_LOC(uint32_t val)
{
	return ((val) << A6XX_VPC_DS_CLIP_CULL_CNTL_V2_CLIP_DIST_03_LOC__SHIFT) & A6XX_VPC_DS_CLIP_CULL_CNTL_V2_CLIP_DIST_03_LOC__MASK;
}
#define A6XX_VPC_DS_CLIP_CULL_CNTL_V2_CLIP_DIST_47_LOC__MASK	0x00ff0000ull
#define A6XX_VPC_DS_CLIP_CULL_CNTL_V2_CLIP_DIST_47_LOC__SHIFT	16
static CONSTEXPR inline uint32_t A6XX_VPC_DS_CLIP_CULL_CNTL_V2_CLIP_DIST_47_LOC(uint32_t val)
{
	return ((val) << A6XX_VPC_DS_CLIP_CULL_CNTL_V2_CLIP_DIST_47_LOC__SHIFT) & A6XX_VPC_DS_CLIP_CULL_CNTL_V2_CLIP_DIST_47_LOC__MASK;
}


#define REG_A6XX_VPC_VS_SIV_CNTL				__FD_DEPRECATED 0x00009104
#define A6XX_VPC_VS_SIV_CNTL_LAYERLOC__MASK			0x000000ffull
#define A6XX_VPC_VS_SIV_CNTL_LAYERLOC__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VPC_VS_SIV_CNTL_LAYERLOC(uint32_t val)
{
	return ((val) << A6XX_VPC_VS_SIV_CNTL_LAYERLOC__SHIFT) & A6XX_VPC_VS_SIV_CNTL_LAYERLOC__MASK;
}
#define A6XX_VPC_VS_SIV_CNTL_VIEWLOC__MASK			0x0000ff00ull
#define A6XX_VPC_VS_SIV_CNTL_VIEWLOC__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_VPC_VS_SIV_CNTL_VIEWLOC(uint32_t val)
{
	return ((val) << A6XX_VPC_VS_SIV_CNTL_VIEWLOC__SHIFT) & A6XX_VPC_VS_SIV_CNTL_VIEWLOC__MASK;
}
#define A6XX_VPC_VS_SIV_CNTL_SHADINGRATELOC__MASK		0x00ff0000ull
#define A6XX_VPC_VS_SIV_CNTL_SHADINGRATELOC__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_VPC_VS_SIV_CNTL_SHADINGRATELOC(uint32_t val)
{
	return ((val) << A6XX_VPC_VS_SIV_CNTL_SHADINGRATELOC__SHIFT) & A6XX_VPC_VS_SIV_CNTL_SHADINGRATELOC__MASK;
}


#define REG_A6XX_VPC_GS_SIV_CNTL				__FD_DEPRECATED 0x00009105
#define A6XX_VPC_GS_SIV_CNTL_LAYERLOC__MASK			0x000000ffull
#define A6XX_VPC_GS_SIV_CNTL_LAYERLOC__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VPC_GS_SIV_CNTL_LAYERLOC(uint32_t val)
{
	return ((val) << A6XX_VPC_GS_SIV_CNTL_LAYERLOC__SHIFT) & A6XX_VPC_GS_SIV_CNTL_LAYERLOC__MASK;
}
#define A6XX_VPC_GS_SIV_CNTL_VIEWLOC__MASK			0x0000ff00ull
#define A6XX_VPC_GS_SIV_CNTL_VIEWLOC__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_VPC_GS_SIV_CNTL_VIEWLOC(uint32_t val)
{
	return ((val) << A6XX_VPC_GS_SIV_CNTL_VIEWLOC__SHIFT) & A6XX_VPC_GS_SIV_CNTL_VIEWLOC__MASK;
}
#define A6XX_VPC_GS_SIV_CNTL_SHADINGRATELOC__MASK		0x00ff0000ull
#define A6XX_VPC_GS_SIV_CNTL_SHADINGRATELOC__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_VPC_GS_SIV_CNTL_SHADINGRATELOC(uint32_t val)
{
	return ((val) << A6XX_VPC_GS_SIV_CNTL_SHADINGRATELOC__SHIFT) & A6XX_VPC_GS_SIV_CNTL_SHADINGRATELOC__MASK;
}


#define REG_A6XX_VPC_DS_SIV_CNTL				__FD_DEPRECATED 0x00009106
#define A6XX_VPC_DS_SIV_CNTL_LAYERLOC__MASK			0x000000ffull
#define A6XX_VPC_DS_SIV_CNTL_LAYERLOC__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VPC_DS_SIV_CNTL_LAYERLOC(uint32_t val)
{
	return ((val) << A6XX_VPC_DS_SIV_CNTL_LAYERLOC__SHIFT) & A6XX_VPC_DS_SIV_CNTL_LAYERLOC__MASK;
}
#define A6XX_VPC_DS_SIV_CNTL_VIEWLOC__MASK			0x0000ff00ull
#define A6XX_VPC_DS_SIV_CNTL_VIEWLOC__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_VPC_DS_SIV_CNTL_VIEWLOC(uint32_t val)
{
	return ((val) << A6XX_VPC_DS_SIV_CNTL_VIEWLOC__SHIFT) & A6XX_VPC_DS_SIV_CNTL_VIEWLOC__MASK;
}
#define A6XX_VPC_DS_SIV_CNTL_SHADINGRATELOC__MASK		0x00ff0000ull
#define A6XX_VPC_DS_SIV_CNTL_SHADINGRATELOC__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_VPC_DS_SIV_CNTL_SHADINGRATELOC(uint32_t val)
{
	return ((val) << A6XX_VPC_DS_SIV_CNTL_SHADINGRATELOC__SHIFT) & A6XX_VPC_DS_SIV_CNTL_SHADINGRATELOC__MASK;
}


#define REG_A8XX_VPC_VS_SIV_CNTL				__FD_DEPRECATED 0x0000930a
#define A8XX_VPC_VS_SIV_CNTL_LAYERLOC__MASK			0x000000ffull
#define A8XX_VPC_VS_SIV_CNTL_LAYERLOC__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_VPC_VS_SIV_CNTL_LAYERLOC(uint32_t val)
{
	return ((val) << A8XX_VPC_VS_SIV_CNTL_LAYERLOC__SHIFT) & A8XX_VPC_VS_SIV_CNTL_LAYERLOC__MASK;
}
#define A8XX_VPC_VS_SIV_CNTL_VIEWLOC__MASK			0x0000ff00ull
#define A8XX_VPC_VS_SIV_CNTL_VIEWLOC__SHIFT			8
static CONSTEXPR inline uint32_t A8XX_VPC_VS_SIV_CNTL_VIEWLOC(uint32_t val)
{
	return ((val) << A8XX_VPC_VS_SIV_CNTL_VIEWLOC__SHIFT) & A8XX_VPC_VS_SIV_CNTL_VIEWLOC__MASK;
}
#define A8XX_VPC_VS_SIV_CNTL_SHADINGRATELOC__MASK		0x00ff0000ull
#define A8XX_VPC_VS_SIV_CNTL_SHADINGRATELOC__SHIFT		16
static CONSTEXPR inline uint32_t A8XX_VPC_VS_SIV_CNTL_SHADINGRATELOC(uint32_t val)
{
	return ((val) << A8XX_VPC_VS_SIV_CNTL_SHADINGRATELOC__SHIFT) & A8XX_VPC_VS_SIV_CNTL_SHADINGRATELOC__MASK;
}


#define REG_A8XX_VPC_GS_SIV_CNTL				__FD_DEPRECATED 0x0000930b
#define A8XX_VPC_GS_SIV_CNTL_LAYERLOC__MASK			0x000000ffull
#define A8XX_VPC_GS_SIV_CNTL_LAYERLOC__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_VPC_GS_SIV_CNTL_LAYERLOC(uint32_t val)
{
	return ((val) << A8XX_VPC_GS_SIV_CNTL_LAYERLOC__SHIFT) & A8XX_VPC_GS_SIV_CNTL_LAYERLOC__MASK;
}
#define A8XX_VPC_GS_SIV_CNTL_VIEWLOC__MASK			0x0000ff00ull
#define A8XX_VPC_GS_SIV_CNTL_VIEWLOC__SHIFT			8
static CONSTEXPR inline uint32_t A8XX_VPC_GS_SIV_CNTL_VIEWLOC(uint32_t val)
{
	return ((val) << A8XX_VPC_GS_SIV_CNTL_VIEWLOC__SHIFT) & A8XX_VPC_GS_SIV_CNTL_VIEWLOC__MASK;
}
#define A8XX_VPC_GS_SIV_CNTL_SHADINGRATELOC__MASK		0x00ff0000ull
#define A8XX_VPC_GS_SIV_CNTL_SHADINGRATELOC__SHIFT		16
static CONSTEXPR inline uint32_t A8XX_VPC_GS_SIV_CNTL_SHADINGRATELOC(uint32_t val)
{
	return ((val) << A8XX_VPC_GS_SIV_CNTL_SHADINGRATELOC__SHIFT) & A8XX_VPC_GS_SIV_CNTL_SHADINGRATELOC__MASK;
}


#define REG_A8XX_VPC_DS_SIV_CNTL				__FD_DEPRECATED 0x0000930c
#define A8XX_VPC_DS_SIV_CNTL_LAYERLOC__MASK			0x000000ffull
#define A8XX_VPC_DS_SIV_CNTL_LAYERLOC__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_VPC_DS_SIV_CNTL_LAYERLOC(uint32_t val)
{
	return ((val) << A8XX_VPC_DS_SIV_CNTL_LAYERLOC__SHIFT) & A8XX_VPC_DS_SIV_CNTL_LAYERLOC__MASK;
}
#define A8XX_VPC_DS_SIV_CNTL_VIEWLOC__MASK			0x0000ff00ull
#define A8XX_VPC_DS_SIV_CNTL_VIEWLOC__SHIFT			8
static CONSTEXPR inline uint32_t A8XX_VPC_DS_SIV_CNTL_VIEWLOC(uint32_t val)
{
	return ((val) << A8XX_VPC_DS_SIV_CNTL_VIEWLOC__SHIFT) & A8XX_VPC_DS_SIV_CNTL_VIEWLOC__MASK;
}
#define A8XX_VPC_DS_SIV_CNTL_SHADINGRATELOC__MASK		0x00ff0000ull
#define A8XX_VPC_DS_SIV_CNTL_SHADINGRATELOC__SHIFT		16
static CONSTEXPR inline uint32_t A8XX_VPC_DS_SIV_CNTL_SHADINGRATELOC(uint32_t val)
{
	return ((val) << A8XX_VPC_DS_SIV_CNTL_SHADINGRATELOC__SHIFT) & A8XX_VPC_DS_SIV_CNTL_SHADINGRATELOC__MASK;
}


#define REG_A6XX_VPC_VS_SIV_CNTL_V2				__FD_DEPRECATED 0x00009314
#define A6XX_VPC_VS_SIV_CNTL_V2_LAYERLOC__MASK			0x000000ffull
#define A6XX_VPC_VS_SIV_CNTL_V2_LAYERLOC__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VPC_VS_SIV_CNTL_V2_LAYERLOC(uint32_t val)
{
	return ((val) << A6XX_VPC_VS_SIV_CNTL_V2_LAYERLOC__SHIFT) & A6XX_VPC_VS_SIV_CNTL_V2_LAYERLOC__MASK;
}
#define A6XX_VPC_VS_SIV_CNTL_V2_VIEWLOC__MASK			0x0000ff00ull
#define A6XX_VPC_VS_SIV_CNTL_V2_VIEWLOC__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_VPC_VS_SIV_CNTL_V2_VIEWLOC(uint32_t val)
{
	return ((val) << A6XX_VPC_VS_SIV_CNTL_V2_VIEWLOC__SHIFT) & A6XX_VPC_VS_SIV_CNTL_V2_VIEWLOC__MASK;
}
#define A6XX_VPC_VS_SIV_CNTL_V2_SHADINGRATELOC__MASK		0x00ff0000ull
#define A6XX_VPC_VS_SIV_CNTL_V2_SHADINGRATELOC__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_VPC_VS_SIV_CNTL_V2_SHADINGRATELOC(uint32_t val)
{
	return ((val) << A6XX_VPC_VS_SIV_CNTL_V2_SHADINGRATELOC__SHIFT) & A6XX_VPC_VS_SIV_CNTL_V2_SHADINGRATELOC__MASK;
}


#define REG_A6XX_VPC_GS_SIV_CNTL_V2				__FD_DEPRECATED 0x00009315
#define A6XX_VPC_GS_SIV_CNTL_V2_LAYERLOC__MASK			0x000000ffull
#define A6XX_VPC_GS_SIV_CNTL_V2_LAYERLOC__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VPC_GS_SIV_CNTL_V2_LAYERLOC(uint32_t val)
{
	return ((val) << A6XX_VPC_GS_SIV_CNTL_V2_LAYERLOC__SHIFT) & A6XX_VPC_GS_SIV_CNTL_V2_LAYERLOC__MASK;
}
#define A6XX_VPC_GS_SIV_CNTL_V2_VIEWLOC__MASK			0x0000ff00ull
#define A6XX_VPC_GS_SIV_CNTL_V2_VIEWLOC__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_VPC_GS_SIV_CNTL_V2_VIEWLOC(uint32_t val)
{
	return ((val) << A6XX_VPC_GS_SIV_CNTL_V2_VIEWLOC__SHIFT) & A6XX_VPC_GS_SIV_CNTL_V2_VIEWLOC__MASK;
}
#define A6XX_VPC_GS_SIV_CNTL_V2_SHADINGRATELOC__MASK		0x00ff0000ull
#define A6XX_VPC_GS_SIV_CNTL_V2_SHADINGRATELOC__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_VPC_GS_SIV_CNTL_V2_SHADINGRATELOC(uint32_t val)
{
	return ((val) << A6XX_VPC_GS_SIV_CNTL_V2_SHADINGRATELOC__SHIFT) & A6XX_VPC_GS_SIV_CNTL_V2_SHADINGRATELOC__MASK;
}


#define REG_A6XX_VPC_DS_SIV_CNTL_V2				__FD_DEPRECATED 0x00009316
#define A6XX_VPC_DS_SIV_CNTL_V2_LAYERLOC__MASK			0x000000ffull
#define A6XX_VPC_DS_SIV_CNTL_V2_LAYERLOC__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VPC_DS_SIV_CNTL_V2_LAYERLOC(uint32_t val)
{
	return ((val) << A6XX_VPC_DS_SIV_CNTL_V2_LAYERLOC__SHIFT) & A6XX_VPC_DS_SIV_CNTL_V2_LAYERLOC__MASK;
}
#define A6XX_VPC_DS_SIV_CNTL_V2_VIEWLOC__MASK			0x0000ff00ull
#define A6XX_VPC_DS_SIV_CNTL_V2_VIEWLOC__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_VPC_DS_SIV_CNTL_V2_VIEWLOC(uint32_t val)
{
	return ((val) << A6XX_VPC_DS_SIV_CNTL_V2_VIEWLOC__SHIFT) & A6XX_VPC_DS_SIV_CNTL_V2_VIEWLOC__MASK;
}
#define A6XX_VPC_DS_SIV_CNTL_V2_SHADINGRATELOC__MASK		0x00ff0000ull
#define A6XX_VPC_DS_SIV_CNTL_V2_SHADINGRATELOC__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_VPC_DS_SIV_CNTL_V2_SHADINGRATELOC(uint32_t val)
{
	return ((val) << A6XX_VPC_DS_SIV_CNTL_V2_SHADINGRATELOC__SHIFT) & A6XX_VPC_DS_SIV_CNTL_V2_SHADINGRATELOC__MASK;
}


#define REG_A6XX_VPC_RAST_STREAM_CNTL				__FD_DEPRECATED 0x00009980
#define A6XX_VPC_RAST_STREAM_CNTL_STREAM__MASK			0x00000003ull
#define A6XX_VPC_RAST_STREAM_CNTL_STREAM__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VPC_RAST_STREAM_CNTL_STREAM(uint32_t val)
{
	return ((val) << A6XX_VPC_RAST_STREAM_CNTL_STREAM__SHIFT) & A6XX_VPC_RAST_STREAM_CNTL_STREAM__MASK;
}
#define A6XX_VPC_RAST_STREAM_CNTL_DISCARD			0x00000004


#define REG_A7XX_VPC_RAST_STREAM_CNTL				__FD_DEPRECATED 0x00009107
#define A7XX_VPC_RAST_STREAM_CNTL_STREAM__MASK			0x00000003ull
#define A7XX_VPC_RAST_STREAM_CNTL_STREAM__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_VPC_RAST_STREAM_CNTL_STREAM(uint32_t val)
{
	return ((val) << A7XX_VPC_RAST_STREAM_CNTL_STREAM__SHIFT) & A7XX_VPC_RAST_STREAM_CNTL_STREAM__MASK;
}
#define A7XX_VPC_RAST_STREAM_CNTL_DISCARD			0x00000004


#define REG_A8XX_VPC_RAST_STREAM_CNTL				__FD_DEPRECATED 0x0000930d
#define A8XX_VPC_RAST_STREAM_CNTL_STREAM__MASK			0x00000003ull
#define A8XX_VPC_RAST_STREAM_CNTL_STREAM__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_VPC_RAST_STREAM_CNTL_STREAM(uint32_t val)
{
	return ((val) << A8XX_VPC_RAST_STREAM_CNTL_STREAM__SHIFT) & A8XX_VPC_RAST_STREAM_CNTL_STREAM__MASK;
}
#define A8XX_VPC_RAST_STREAM_CNTL_DISCARD			0x00000004


#define REG_A7XX_VPC_RAST_STREAM_CNTL_V2			__FD_DEPRECATED 0x00009317
#define A7XX_VPC_RAST_STREAM_CNTL_V2_STREAM__MASK		0x00000003ull
#define A7XX_VPC_RAST_STREAM_CNTL_V2_STREAM__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_VPC_RAST_STREAM_CNTL_V2_STREAM(uint32_t val)
{
	return ((val) << A7XX_VPC_RAST_STREAM_CNTL_V2_STREAM__SHIFT) & A7XX_VPC_RAST_STREAM_CNTL_V2_STREAM__MASK;
}
#define A7XX_VPC_RAST_STREAM_CNTL_V2_DISCARD			0x00000004


#define REG_A6XX_VPC_UNKNOWN_9107				__FD_DEPRECATED 0x00009107
#define A6XX_VPC_UNKNOWN_9107_RASTER_DISCARD			0x00000001
#define A6XX_VPC_UNKNOWN_9107_UNK2				0x00000004


#define REG_A6XX_VPC_RAST_CNTL					__FD_DEPRECATED 0x00009108
#define A6XX_VPC_RAST_CNTL_MODE__MASK				0x00000003ull
#define A6XX_VPC_RAST_CNTL_MODE__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_VPC_RAST_CNTL_MODE(enum a6xx_polygon_mode val)
{
	return ((val) << A6XX_VPC_RAST_CNTL_MODE__SHIFT) & A6XX_VPC_RAST_CNTL_MODE__MASK;
}


#define REG_A8XX_VPC_RAST_CNTL					__FD_DEPRECATED 0x0000930e
#define A8XX_VPC_RAST_CNTL_MODE__MASK				0x00000003ull
#define A8XX_VPC_RAST_CNTL_MODE__SHIFT				0
static CONSTEXPR inline uint32_t A8XX_VPC_RAST_CNTL_MODE(enum a6xx_polygon_mode val)
{
	return ((val) << A8XX_VPC_RAST_CNTL_MODE__SHIFT) & A8XX_VPC_RAST_CNTL_MODE__MASK;
}


#define REG_A7XX_VPC_PC_CNTL					__FD_DEPRECATED 0x00009109
#define A7XX_VPC_PC_CNTL_PRIMITIVE_RESTART			0x00000001
#define A7XX_VPC_PC_CNTL_PROVOKING_VTX_LAST			0x00000002
#define A7XX_VPC_PC_CNTL_D3D_VERTEX_ORDERING			0x00000004
#define A7XX_VPC_PC_CNTL_UNK3					0x00000008


#define REG_A8XX_VPC_PC_CNTL					__FD_DEPRECATED 0x0000930f
#define A8XX_VPC_PC_CNTL_PRIMITIVE_RESTART			0x00000001
#define A8XX_VPC_PC_CNTL_PROVOKING_VTX_LAST			0x00000002
#define A8XX_VPC_PC_CNTL_D3D_VERTEX_ORDERING			0x00000004
#define A8XX_VPC_PC_CNTL_UNK3					0x00000008


#define REG_A7XX_VPC_GS_PARAM_0					__FD_DEPRECATED 0x0000910a
#define A7XX_VPC_GS_PARAM_0_GS_VERTICES_OUT__MASK		0x000000ffull
#define A7XX_VPC_GS_PARAM_0_GS_VERTICES_OUT__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_VPC_GS_PARAM_0_GS_VERTICES_OUT(uint32_t val)
{
	return ((val) << A7XX_VPC_GS_PARAM_0_GS_VERTICES_OUT__SHIFT) & A7XX_VPC_GS_PARAM_0_GS_VERTICES_OUT__MASK;
}
#define A7XX_VPC_GS_PARAM_0_GS_INVOCATIONS__MASK		0x00007c00ull
#define A7XX_VPC_GS_PARAM_0_GS_INVOCATIONS__SHIFT		10
static CONSTEXPR inline uint32_t A7XX_VPC_GS_PARAM_0_GS_INVOCATIONS(uint32_t val)
{
	return ((val) << A7XX_VPC_GS_PARAM_0_GS_INVOCATIONS__SHIFT) & A7XX_VPC_GS_PARAM_0_GS_INVOCATIONS__MASK;
}
#define A7XX_VPC_GS_PARAM_0_LINELENGTHEN			0x00008000
#define A7XX_VPC_GS_PARAM_0_GS_OUTPUT__MASK			0x00030000ull
#define A7XX_VPC_GS_PARAM_0_GS_OUTPUT__SHIFT			16
static CONSTEXPR inline uint32_t A7XX_VPC_GS_PARAM_0_GS_OUTPUT(enum a6xx_tess_output val)
{
	return ((val) << A7XX_VPC_GS_PARAM_0_GS_OUTPUT__SHIFT) & A7XX_VPC_GS_PARAM_0_GS_OUTPUT__MASK;
}
#define A7XX_VPC_GS_PARAM_0_UNK18				0x00040000


#define REG_A8XX_VPC_GS_PARAM_0					__FD_DEPRECATED 0x000090c0
#define A8XX_VPC_GS_PARAM_0_GS_VERTICES_OUT__MASK		0x000000ffull
#define A8XX_VPC_GS_PARAM_0_GS_VERTICES_OUT__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_VPC_GS_PARAM_0_GS_VERTICES_OUT(uint32_t val)
{
	return ((val) << A8XX_VPC_GS_PARAM_0_GS_VERTICES_OUT__SHIFT) & A8XX_VPC_GS_PARAM_0_GS_VERTICES_OUT__MASK;
}
#define A8XX_VPC_GS_PARAM_0_GS_INVOCATIONS__MASK		0x00007c00ull
#define A8XX_VPC_GS_PARAM_0_GS_INVOCATIONS__SHIFT		10
static CONSTEXPR inline uint32_t A8XX_VPC_GS_PARAM_0_GS_INVOCATIONS(uint32_t val)
{
	return ((val) << A8XX_VPC_GS_PARAM_0_GS_INVOCATIONS__SHIFT) & A8XX_VPC_GS_PARAM_0_GS_INVOCATIONS__MASK;
}
#define A8XX_VPC_GS_PARAM_0_LINELENGTHEN			0x00008000
#define A8XX_VPC_GS_PARAM_0_GS_OUTPUT__MASK			0x00030000ull
#define A8XX_VPC_GS_PARAM_0_GS_OUTPUT__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_VPC_GS_PARAM_0_GS_OUTPUT(enum a6xx_tess_output val)
{
	return ((val) << A8XX_VPC_GS_PARAM_0_GS_OUTPUT__SHIFT) & A8XX_VPC_GS_PARAM_0_GS_OUTPUT__MASK;
}
#define A8XX_VPC_GS_PARAM_0_UNK18				0x00040000


#define REG_A7XX_VPC_STEREO_RENDERING_VIEWMASK			__FD_DEPRECATED 0x0000910b


#define REG_A8XX_VPC_STEREO_RENDERING_VIEWMASK			__FD_DEPRECATED 0x000090c1


#define REG_A7XX_VPC_STEREO_RENDERING_CNTL			__FD_DEPRECATED 0x0000910c
#define A7XX_VPC_STEREO_RENDERING_CNTL_ENABLE			0x00000001
#define A7XX_VPC_STEREO_RENDERING_CNTL_DISABLEMULTIPOS		0x00000002
#define A7XX_VPC_STEREO_RENDERING_CNTL_VIEWS__MASK		0x0000007cull
#define A7XX_VPC_STEREO_RENDERING_CNTL_VIEWS__SHIFT		2
static CONSTEXPR inline uint32_t A7XX_VPC_STEREO_RENDERING_CNTL_VIEWS(uint32_t val)
{
	return ((val) << A7XX_VPC_STEREO_RENDERING_CNTL_VIEWS__SHIFT) & A7XX_VPC_STEREO_RENDERING_CNTL_VIEWS__MASK;
}


#define REG_A8XX_VPC_STEREO_RENDERING_CNTL			__FD_DEPRECATED 0x0000931a
#define A8XX_VPC_STEREO_RENDERING_CNTL_ENABLE			0x00000001
#define A8XX_VPC_STEREO_RENDERING_CNTL_DISABLEMULTIPOS		0x00000002
#define A8XX_VPC_STEREO_RENDERING_CNTL_VIEWS__MASK		0x0000007cull
#define A8XX_VPC_STEREO_RENDERING_CNTL_VIEWS__SHIFT		2
static CONSTEXPR inline uint32_t A8XX_VPC_STEREO_RENDERING_CNTL_VIEWS(uint32_t val)
{
	return ((val) << A8XX_VPC_STEREO_RENDERING_CNTL_VIEWS__SHIFT) & A8XX_VPC_STEREO_RENDERING_CNTL_VIEWS__MASK;
}


#define REG_A6XX_VPC_VARYING_INTERP_MODE(i0)			(0x00009200 + 0x1*i0 )



#define REG_A6XX_VPC_VARYING_REPLACE_MODE(i0)			(0x00009208 + 0x1*i0 )



#define REG_A8XX_VPC_VARYING_INTERP_MODE(i0)			(0x00009240 + 0x1*i0 )



#define REG_A8XX_VPC_VARYING_REPLACE_MODE(i0)			(0x00009248 + 0x1*i0 )



#define REG_A6XX_VPC_UNKNOWN_9210				__FD_DEPRECATED 0x00009210


#define REG_A6XX_VPC_UNKNOWN_9211				__FD_DEPRECATED 0x00009211


#define REG_A6XX_VPC_VARYING_LM_TRANSFER_CNTL(i0)		(0x00009212 + 0x1*i0 )



#define REG_A8XX_VPC_VARYING_LM_TRANSFER_CNTL(i0)		(0x00009252 + 0x1*i0 )



#define REG_A6XX_VPC_SO_MAPPING_WPTR				__FD_DEPRECATED 0x00009216
#define A6XX_VPC_SO_MAPPING_WPTR_ADDR__MASK			0x000000ffull
#define A6XX_VPC_SO_MAPPING_WPTR_ADDR__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VPC_SO_MAPPING_WPTR_ADDR(uint32_t val)
{
	return ((val) << A6XX_VPC_SO_MAPPING_WPTR_ADDR__SHIFT) & A6XX_VPC_SO_MAPPING_WPTR_ADDR__MASK;
}
#define A6XX_VPC_SO_MAPPING_WPTR_RESET				0x00010000


#define REG_A8XX_VPC_SO_MAPPING_WPTR				__FD_DEPRECATED 0x00009180
#define A8XX_VPC_SO_MAPPING_WPTR_ADDR__MASK			0x000000ffull
#define A8XX_VPC_SO_MAPPING_WPTR_ADDR__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_VPC_SO_MAPPING_WPTR_ADDR(uint32_t val)
{
	return ((val) << A8XX_VPC_SO_MAPPING_WPTR_ADDR__SHIFT) & A8XX_VPC_SO_MAPPING_WPTR_ADDR__MASK;
}
#define A8XX_VPC_SO_MAPPING_WPTR_RESET				0x00010000


#define REG_A6XX_VPC_SO_MAPPING_PORT				__FD_DEPRECATED 0x00009217
#define A6XX_VPC_SO_MAPPING_PORT_A_BUF__MASK			0x00000003ull
#define A6XX_VPC_SO_MAPPING_PORT_A_BUF__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VPC_SO_MAPPING_PORT_A_BUF(uint32_t val)
{
	return ((val) << A6XX_VPC_SO_MAPPING_PORT_A_BUF__SHIFT) & A6XX_VPC_SO_MAPPING_PORT_A_BUF__MASK;
}
#define A6XX_VPC_SO_MAPPING_PORT_A_OFF__MASK			0x000007fcull
#define A6XX_VPC_SO_MAPPING_PORT_A_OFF__SHIFT			2
static CONSTEXPR inline uint32_t A6XX_VPC_SO_MAPPING_PORT_A_OFF(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A6XX_VPC_SO_MAPPING_PORT_A_OFF__SHIFT) & A6XX_VPC_SO_MAPPING_PORT_A_OFF__MASK;
}
#define A6XX_VPC_SO_MAPPING_PORT_A_EN				0x00000800
#define A6XX_VPC_SO_MAPPING_PORT_B_BUF__MASK			0x00003000ull
#define A6XX_VPC_SO_MAPPING_PORT_B_BUF__SHIFT			12
static CONSTEXPR inline uint32_t A6XX_VPC_SO_MAPPING_PORT_B_BUF(uint32_t val)
{
	return ((val) << A6XX_VPC_SO_MAPPING_PORT_B_BUF__SHIFT) & A6XX_VPC_SO_MAPPING_PORT_B_BUF__MASK;
}
#define A6XX_VPC_SO_MAPPING_PORT_B_OFF__MASK			0x007fc000ull
#define A6XX_VPC_SO_MAPPING_PORT_B_OFF__SHIFT			14
static CONSTEXPR inline uint32_t A6XX_VPC_SO_MAPPING_PORT_B_OFF(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A6XX_VPC_SO_MAPPING_PORT_B_OFF__SHIFT) & A6XX_VPC_SO_MAPPING_PORT_B_OFF__MASK;
}
#define A6XX_VPC_SO_MAPPING_PORT_B_EN				0x00800000


#define REG_A8XX_VPC_SO_MAPPING_PORT				__FD_DEPRECATED 0x00009181
#define A8XX_VPC_SO_MAPPING_PORT_A_BUF__MASK			0x00000003ull
#define A8XX_VPC_SO_MAPPING_PORT_A_BUF__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_VPC_SO_MAPPING_PORT_A_BUF(uint32_t val)
{
	return ((val) << A8XX_VPC_SO_MAPPING_PORT_A_BUF__SHIFT) & A8XX_VPC_SO_MAPPING_PORT_A_BUF__MASK;
}
#define A8XX_VPC_SO_MAPPING_PORT_A_OFF__MASK			0x000007fcull
#define A8XX_VPC_SO_MAPPING_PORT_A_OFF__SHIFT			2
static CONSTEXPR inline uint32_t A8XX_VPC_SO_MAPPING_PORT_A_OFF(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A8XX_VPC_SO_MAPPING_PORT_A_OFF__SHIFT) & A8XX_VPC_SO_MAPPING_PORT_A_OFF__MASK;
}
#define A8XX_VPC_SO_MAPPING_PORT_A_EN				0x00000800
#define A8XX_VPC_SO_MAPPING_PORT_B_BUF__MASK			0x00003000ull
#define A8XX_VPC_SO_MAPPING_PORT_B_BUF__SHIFT			12
static CONSTEXPR inline uint32_t A8XX_VPC_SO_MAPPING_PORT_B_BUF(uint32_t val)
{
	return ((val) << A8XX_VPC_SO_MAPPING_PORT_B_BUF__SHIFT) & A8XX_VPC_SO_MAPPING_PORT_B_BUF__MASK;
}
#define A8XX_VPC_SO_MAPPING_PORT_B_OFF__MASK			0x007fc000ull
#define A8XX_VPC_SO_MAPPING_PORT_B_OFF__SHIFT			14
static CONSTEXPR inline uint32_t A8XX_VPC_SO_MAPPING_PORT_B_OFF(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A8XX_VPC_SO_MAPPING_PORT_B_OFF__SHIFT) & A8XX_VPC_SO_MAPPING_PORT_B_OFF__MASK;
}
#define A8XX_VPC_SO_MAPPING_PORT_B_EN				0x00800000


#define REG_A6XX_VPC_SO_QUERY_BASE				__FD_DEPRECATED 0x00009218
static CONSTEXPR inline uint32_t A6XX_VPC_SO_QUERY_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_VPC_SO_QUERY_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_VPC_SO_QUERY_BASE				__FD_DEPRECATED 0x00009182
static CONSTEXPR inline uint32_t A8XX_VPC_SO_QUERY_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_VPC_SO_QUERY_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_VPC_SO(i0)					(0x0000921a + 0x7*i0 )

static CONSTEXPR inline uint32_t A6XX_VPC_SO_BUFFER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_VPC_SO_BUFFER_BASE_HI(uint32_t val)
{
	return val;
}








static CONSTEXPR inline uint32_t A6XX_VPC_SO_FLUSH_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_VPC_SO_FLUSH_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_VPC_SO(i0)					(0x00009184 + 0x7*i0 )

static CONSTEXPR inline uint32_t A8XX_VPC_SO_BUFFER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_VPC_SO_BUFFER_BASE_HI(uint32_t val)
{
	return val;
}








static CONSTEXPR inline uint32_t A8XX_VPC_SO_FLUSH_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_VPC_SO_FLUSH_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_VPC_REPLACE_MODE_CNTL				__FD_DEPRECATED 0x00009236
#define A6XX_VPC_REPLACE_MODE_CNTL_INVERT			0x00000001


#define REG_A8XX_VPC_REPLACE_MODE_CNTL				__FD_DEPRECATED 0x00009310
#define A8XX_VPC_REPLACE_MODE_CNTL_INVERT			0x00000001


#define REG_A6XX_VPC_ROTATION_CNTL				__FD_DEPRECATED 0x00009300


#define REG_A8XX_VPC_ROTATION_CNTL				__FD_DEPRECATED 0x00009312


#define REG_A6XX_VPC_VS_CNTL					__FD_DEPRECATED 0x00009301
#define A6XX_VPC_VS_CNTL_STRIDE_IN_VPC__MASK			0x000000ffull
#define A6XX_VPC_VS_CNTL_STRIDE_IN_VPC__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VPC_VS_CNTL_STRIDE_IN_VPC(uint32_t val)
{
	return ((val) << A6XX_VPC_VS_CNTL_STRIDE_IN_VPC__SHIFT) & A6XX_VPC_VS_CNTL_STRIDE_IN_VPC__MASK;
}
#define A6XX_VPC_VS_CNTL_POSITIONLOC__MASK			0x0000ff00ull
#define A6XX_VPC_VS_CNTL_POSITIONLOC__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_VPC_VS_CNTL_POSITIONLOC(uint32_t val)
{
	return ((val) << A6XX_VPC_VS_CNTL_POSITIONLOC__SHIFT) & A6XX_VPC_VS_CNTL_POSITIONLOC__MASK;
}
#define A6XX_VPC_VS_CNTL_PSIZELOC__MASK				0x00ff0000ull
#define A6XX_VPC_VS_CNTL_PSIZELOC__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_VPC_VS_CNTL_PSIZELOC(uint32_t val)
{
	return ((val) << A6XX_VPC_VS_CNTL_PSIZELOC__SHIFT) & A6XX_VPC_VS_CNTL_PSIZELOC__MASK;
}
#define A6XX_VPC_VS_CNTL_EXTRAPOS__MASK				0x0f000000ull
#define A6XX_VPC_VS_CNTL_EXTRAPOS__SHIFT			24
static CONSTEXPR inline uint32_t A6XX_VPC_VS_CNTL_EXTRAPOS(uint32_t val)
{
	return ((val) << A6XX_VPC_VS_CNTL_EXTRAPOS__SHIFT) & A6XX_VPC_VS_CNTL_EXTRAPOS__MASK;
}


#define REG_A6XX_VPC_GS_CNTL					__FD_DEPRECATED 0x00009302
#define A6XX_VPC_GS_CNTL_STRIDE_IN_VPC__MASK			0x000000ffull
#define A6XX_VPC_GS_CNTL_STRIDE_IN_VPC__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VPC_GS_CNTL_STRIDE_IN_VPC(uint32_t val)
{
	return ((val) << A6XX_VPC_GS_CNTL_STRIDE_IN_VPC__SHIFT) & A6XX_VPC_GS_CNTL_STRIDE_IN_VPC__MASK;
}
#define A6XX_VPC_GS_CNTL_POSITIONLOC__MASK			0x0000ff00ull
#define A6XX_VPC_GS_CNTL_POSITIONLOC__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_VPC_GS_CNTL_POSITIONLOC(uint32_t val)
{
	return ((val) << A6XX_VPC_GS_CNTL_POSITIONLOC__SHIFT) & A6XX_VPC_GS_CNTL_POSITIONLOC__MASK;
}
#define A6XX_VPC_GS_CNTL_PSIZELOC__MASK				0x00ff0000ull
#define A6XX_VPC_GS_CNTL_PSIZELOC__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_VPC_GS_CNTL_PSIZELOC(uint32_t val)
{
	return ((val) << A6XX_VPC_GS_CNTL_PSIZELOC__SHIFT) & A6XX_VPC_GS_CNTL_PSIZELOC__MASK;
}
#define A6XX_VPC_GS_CNTL_EXTRAPOS__MASK				0x0f000000ull
#define A6XX_VPC_GS_CNTL_EXTRAPOS__SHIFT			24
static CONSTEXPR inline uint32_t A6XX_VPC_GS_CNTL_EXTRAPOS(uint32_t val)
{
	return ((val) << A6XX_VPC_GS_CNTL_EXTRAPOS__SHIFT) & A6XX_VPC_GS_CNTL_EXTRAPOS__MASK;
}


#define REG_A6XX_VPC_DS_CNTL					__FD_DEPRECATED 0x00009303
#define A6XX_VPC_DS_CNTL_STRIDE_IN_VPC__MASK			0x000000ffull
#define A6XX_VPC_DS_CNTL_STRIDE_IN_VPC__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VPC_DS_CNTL_STRIDE_IN_VPC(uint32_t val)
{
	return ((val) << A6XX_VPC_DS_CNTL_STRIDE_IN_VPC__SHIFT) & A6XX_VPC_DS_CNTL_STRIDE_IN_VPC__MASK;
}
#define A6XX_VPC_DS_CNTL_POSITIONLOC__MASK			0x0000ff00ull
#define A6XX_VPC_DS_CNTL_POSITIONLOC__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_VPC_DS_CNTL_POSITIONLOC(uint32_t val)
{
	return ((val) << A6XX_VPC_DS_CNTL_POSITIONLOC__SHIFT) & A6XX_VPC_DS_CNTL_POSITIONLOC__MASK;
}
#define A6XX_VPC_DS_CNTL_PSIZELOC__MASK				0x00ff0000ull
#define A6XX_VPC_DS_CNTL_PSIZELOC__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_VPC_DS_CNTL_PSIZELOC(uint32_t val)
{
	return ((val) << A6XX_VPC_DS_CNTL_PSIZELOC__SHIFT) & A6XX_VPC_DS_CNTL_PSIZELOC__MASK;
}
#define A6XX_VPC_DS_CNTL_EXTRAPOS__MASK				0x0f000000ull
#define A6XX_VPC_DS_CNTL_EXTRAPOS__SHIFT			24
static CONSTEXPR inline uint32_t A6XX_VPC_DS_CNTL_EXTRAPOS(uint32_t val)
{
	return ((val) << A6XX_VPC_DS_CNTL_EXTRAPOS__SHIFT) & A6XX_VPC_DS_CNTL_EXTRAPOS__MASK;
}


#define REG_A8XX_VPC_VS_CNTL					__FD_DEPRECATED 0x00009300
#define A8XX_VPC_VS_CNTL_STRIDE_IN_VPC__MASK			0x000000ffull
#define A8XX_VPC_VS_CNTL_STRIDE_IN_VPC__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_VPC_VS_CNTL_STRIDE_IN_VPC(uint32_t val)
{
	return ((val) << A8XX_VPC_VS_CNTL_STRIDE_IN_VPC__SHIFT) & A8XX_VPC_VS_CNTL_STRIDE_IN_VPC__MASK;
}
#define A8XX_VPC_VS_CNTL_POSITIONLOC__MASK			0x0000ff00ull
#define A8XX_VPC_VS_CNTL_POSITIONLOC__SHIFT			8
static CONSTEXPR inline uint32_t A8XX_VPC_VS_CNTL_POSITIONLOC(uint32_t val)
{
	return ((val) << A8XX_VPC_VS_CNTL_POSITIONLOC__SHIFT) & A8XX_VPC_VS_CNTL_POSITIONLOC__MASK;
}
#define A8XX_VPC_VS_CNTL_PSIZELOC__MASK				0x00ff0000ull
#define A8XX_VPC_VS_CNTL_PSIZELOC__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_VPC_VS_CNTL_PSIZELOC(uint32_t val)
{
	return ((val) << A8XX_VPC_VS_CNTL_PSIZELOC__SHIFT) & A8XX_VPC_VS_CNTL_PSIZELOC__MASK;
}
#define A8XX_VPC_VS_CNTL_EXTRAPOS__MASK				0x0f000000ull
#define A8XX_VPC_VS_CNTL_EXTRAPOS__SHIFT			24
static CONSTEXPR inline uint32_t A8XX_VPC_VS_CNTL_EXTRAPOS(uint32_t val)
{
	return ((val) << A8XX_VPC_VS_CNTL_EXTRAPOS__SHIFT) & A8XX_VPC_VS_CNTL_EXTRAPOS__MASK;
}


#define REG_A8XX_VPC_GS_CNTL					__FD_DEPRECATED 0x00009301
#define A8XX_VPC_GS_CNTL_STRIDE_IN_VPC__MASK			0x000000ffull
#define A8XX_VPC_GS_CNTL_STRIDE_IN_VPC__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_VPC_GS_CNTL_STRIDE_IN_VPC(uint32_t val)
{
	return ((val) << A8XX_VPC_GS_CNTL_STRIDE_IN_VPC__SHIFT) & A8XX_VPC_GS_CNTL_STRIDE_IN_VPC__MASK;
}
#define A8XX_VPC_GS_CNTL_POSITIONLOC__MASK			0x0000ff00ull
#define A8XX_VPC_GS_CNTL_POSITIONLOC__SHIFT			8
static CONSTEXPR inline uint32_t A8XX_VPC_GS_CNTL_POSITIONLOC(uint32_t val)
{
	return ((val) << A8XX_VPC_GS_CNTL_POSITIONLOC__SHIFT) & A8XX_VPC_GS_CNTL_POSITIONLOC__MASK;
}
#define A8XX_VPC_GS_CNTL_PSIZELOC__MASK				0x00ff0000ull
#define A8XX_VPC_GS_CNTL_PSIZELOC__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_VPC_GS_CNTL_PSIZELOC(uint32_t val)
{
	return ((val) << A8XX_VPC_GS_CNTL_PSIZELOC__SHIFT) & A8XX_VPC_GS_CNTL_PSIZELOC__MASK;
}
#define A8XX_VPC_GS_CNTL_EXTRAPOS__MASK				0x0f000000ull
#define A8XX_VPC_GS_CNTL_EXTRAPOS__SHIFT			24
static CONSTEXPR inline uint32_t A8XX_VPC_GS_CNTL_EXTRAPOS(uint32_t val)
{
	return ((val) << A8XX_VPC_GS_CNTL_EXTRAPOS__SHIFT) & A8XX_VPC_GS_CNTL_EXTRAPOS__MASK;
}


#define REG_A8XX_VPC_DS_CNTL					__FD_DEPRECATED 0x00009302
#define A8XX_VPC_DS_CNTL_STRIDE_IN_VPC__MASK			0x000000ffull
#define A8XX_VPC_DS_CNTL_STRIDE_IN_VPC__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_VPC_DS_CNTL_STRIDE_IN_VPC(uint32_t val)
{
	return ((val) << A8XX_VPC_DS_CNTL_STRIDE_IN_VPC__SHIFT) & A8XX_VPC_DS_CNTL_STRIDE_IN_VPC__MASK;
}
#define A8XX_VPC_DS_CNTL_POSITIONLOC__MASK			0x0000ff00ull
#define A8XX_VPC_DS_CNTL_POSITIONLOC__SHIFT			8
static CONSTEXPR inline uint32_t A8XX_VPC_DS_CNTL_POSITIONLOC(uint32_t val)
{
	return ((val) << A8XX_VPC_DS_CNTL_POSITIONLOC__SHIFT) & A8XX_VPC_DS_CNTL_POSITIONLOC__MASK;
}
#define A8XX_VPC_DS_CNTL_PSIZELOC__MASK				0x00ff0000ull
#define A8XX_VPC_DS_CNTL_PSIZELOC__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_VPC_DS_CNTL_PSIZELOC(uint32_t val)
{
	return ((val) << A8XX_VPC_DS_CNTL_PSIZELOC__SHIFT) & A8XX_VPC_DS_CNTL_PSIZELOC__MASK;
}
#define A8XX_VPC_DS_CNTL_EXTRAPOS__MASK				0x0f000000ull
#define A8XX_VPC_DS_CNTL_EXTRAPOS__SHIFT			24
static CONSTEXPR inline uint32_t A8XX_VPC_DS_CNTL_EXTRAPOS(uint32_t val)
{
	return ((val) << A8XX_VPC_DS_CNTL_EXTRAPOS__SHIFT) & A8XX_VPC_DS_CNTL_EXTRAPOS__MASK;
}


#define REG_A6XX_VPC_PS_CNTL					__FD_DEPRECATED 0x00009304
#define A6XX_VPC_PS_CNTL_NUMNONPOSVAR__MASK			0x000000ffull
#define A6XX_VPC_PS_CNTL_NUMNONPOSVAR__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VPC_PS_CNTL_NUMNONPOSVAR(uint32_t val)
{
	return ((val) << A6XX_VPC_PS_CNTL_NUMNONPOSVAR__SHIFT) & A6XX_VPC_PS_CNTL_NUMNONPOSVAR__MASK;
}
#define A6XX_VPC_PS_CNTL_PRIMIDLOC__MASK			0x0000ff00ull
#define A6XX_VPC_PS_CNTL_PRIMIDLOC__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_VPC_PS_CNTL_PRIMIDLOC(uint32_t val)
{
	return ((val) << A6XX_VPC_PS_CNTL_PRIMIDLOC__SHIFT) & A6XX_VPC_PS_CNTL_PRIMIDLOC__MASK;
}
#define A6XX_VPC_PS_CNTL_VARYING				0x00010000
#define A6XX_VPC_PS_CNTL_VIEWIDLOC__MASK			0xff000000ull
#define A6XX_VPC_PS_CNTL_VIEWIDLOC__SHIFT			24
static CONSTEXPR inline uint32_t A6XX_VPC_PS_CNTL_VIEWIDLOC(uint32_t val)
{
	return ((val) << A6XX_VPC_PS_CNTL_VIEWIDLOC__SHIFT) & A6XX_VPC_PS_CNTL_VIEWIDLOC__MASK;
}


#define REG_A8XX_VPC_PS_CNTL					__FD_DEPRECATED 0x00009303
#define A8XX_VPC_PS_CNTL_NUMNONPOSVAR__MASK			0x000000ffull
#define A8XX_VPC_PS_CNTL_NUMNONPOSVAR__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_VPC_PS_CNTL_NUMNONPOSVAR(uint32_t val)
{
	return ((val) << A8XX_VPC_PS_CNTL_NUMNONPOSVAR__SHIFT) & A8XX_VPC_PS_CNTL_NUMNONPOSVAR__MASK;
}
#define A8XX_VPC_PS_CNTL_PRIMIDLOC__MASK			0x0000ff00ull
#define A8XX_VPC_PS_CNTL_PRIMIDLOC__SHIFT			8
static CONSTEXPR inline uint32_t A8XX_VPC_PS_CNTL_PRIMIDLOC(uint32_t val)
{
	return ((val) << A8XX_VPC_PS_CNTL_PRIMIDLOC__SHIFT) & A8XX_VPC_PS_CNTL_PRIMIDLOC__MASK;
}
#define A8XX_VPC_PS_CNTL_VARYING				0x00010000
#define A8XX_VPC_PS_CNTL_VIEWIDLOC__MASK			0xff000000ull
#define A8XX_VPC_PS_CNTL_VIEWIDLOC__SHIFT			24
static CONSTEXPR inline uint32_t A8XX_VPC_PS_CNTL_VIEWIDLOC(uint32_t val)
{
	return ((val) << A8XX_VPC_PS_CNTL_VIEWIDLOC__SHIFT) & A8XX_VPC_PS_CNTL_VIEWIDLOC__MASK;
}


#define REG_A6XX_VPC_SO_CNTL					__FD_DEPRECATED 0x00009305
#define A6XX_VPC_SO_CNTL_BUF0_STREAM__MASK			0x00000007ull
#define A6XX_VPC_SO_CNTL_BUF0_STREAM__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VPC_SO_CNTL_BUF0_STREAM(uint32_t val)
{
	return ((val) << A6XX_VPC_SO_CNTL_BUF0_STREAM__SHIFT) & A6XX_VPC_SO_CNTL_BUF0_STREAM__MASK;
}
#define A6XX_VPC_SO_CNTL_BUF1_STREAM__MASK			0x00000038ull
#define A6XX_VPC_SO_CNTL_BUF1_STREAM__SHIFT			3
static CONSTEXPR inline uint32_t A6XX_VPC_SO_CNTL_BUF1_STREAM(uint32_t val)
{
	return ((val) << A6XX_VPC_SO_CNTL_BUF1_STREAM__SHIFT) & A6XX_VPC_SO_CNTL_BUF1_STREAM__MASK;
}
#define A6XX_VPC_SO_CNTL_BUF2_STREAM__MASK			0x000001c0ull
#define A6XX_VPC_SO_CNTL_BUF2_STREAM__SHIFT			6
static CONSTEXPR inline uint32_t A6XX_VPC_SO_CNTL_BUF2_STREAM(uint32_t val)
{
	return ((val) << A6XX_VPC_SO_CNTL_BUF2_STREAM__SHIFT) & A6XX_VPC_SO_CNTL_BUF2_STREAM__MASK;
}
#define A6XX_VPC_SO_CNTL_BUF3_STREAM__MASK			0x00000e00ull
#define A6XX_VPC_SO_CNTL_BUF3_STREAM__SHIFT			9
static CONSTEXPR inline uint32_t A6XX_VPC_SO_CNTL_BUF3_STREAM(uint32_t val)
{
	return ((val) << A6XX_VPC_SO_CNTL_BUF3_STREAM__SHIFT) & A6XX_VPC_SO_CNTL_BUF3_STREAM__MASK;
}
#define A6XX_VPC_SO_CNTL_STREAM_ENABLE__MASK			0x00078000ull
#define A6XX_VPC_SO_CNTL_STREAM_ENABLE__SHIFT			15
static CONSTEXPR inline uint32_t A6XX_VPC_SO_CNTL_STREAM_ENABLE(uint32_t val)
{
	return ((val) << A6XX_VPC_SO_CNTL_STREAM_ENABLE__SHIFT) & A6XX_VPC_SO_CNTL_STREAM_ENABLE__MASK;
}


#define REG_A8XX_VPC_SO_CNTL					__FD_DEPRECATED 0x00009304
#define A8XX_VPC_SO_CNTL_BUF0_STREAM__MASK			0x00000007ull
#define A8XX_VPC_SO_CNTL_BUF0_STREAM__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_VPC_SO_CNTL_BUF0_STREAM(uint32_t val)
{
	return ((val) << A8XX_VPC_SO_CNTL_BUF0_STREAM__SHIFT) & A8XX_VPC_SO_CNTL_BUF0_STREAM__MASK;
}
#define A8XX_VPC_SO_CNTL_BUF1_STREAM__MASK			0x00000038ull
#define A8XX_VPC_SO_CNTL_BUF1_STREAM__SHIFT			3
static CONSTEXPR inline uint32_t A8XX_VPC_SO_CNTL_BUF1_STREAM(uint32_t val)
{
	return ((val) << A8XX_VPC_SO_CNTL_BUF1_STREAM__SHIFT) & A8XX_VPC_SO_CNTL_BUF1_STREAM__MASK;
}
#define A8XX_VPC_SO_CNTL_BUF2_STREAM__MASK			0x000001c0ull
#define A8XX_VPC_SO_CNTL_BUF2_STREAM__SHIFT			6
static CONSTEXPR inline uint32_t A8XX_VPC_SO_CNTL_BUF2_STREAM(uint32_t val)
{
	return ((val) << A8XX_VPC_SO_CNTL_BUF2_STREAM__SHIFT) & A8XX_VPC_SO_CNTL_BUF2_STREAM__MASK;
}
#define A8XX_VPC_SO_CNTL_BUF3_STREAM__MASK			0x00000e00ull
#define A8XX_VPC_SO_CNTL_BUF3_STREAM__SHIFT			9
static CONSTEXPR inline uint32_t A8XX_VPC_SO_CNTL_BUF3_STREAM(uint32_t val)
{
	return ((val) << A8XX_VPC_SO_CNTL_BUF3_STREAM__SHIFT) & A8XX_VPC_SO_CNTL_BUF3_STREAM__MASK;
}
#define A8XX_VPC_SO_CNTL_STREAM_ENABLE__MASK			0x00078000ull
#define A8XX_VPC_SO_CNTL_STREAM_ENABLE__SHIFT			15
static CONSTEXPR inline uint32_t A8XX_VPC_SO_CNTL_STREAM_ENABLE(uint32_t val)
{
	return ((val) << A8XX_VPC_SO_CNTL_STREAM_ENABLE__SHIFT) & A8XX_VPC_SO_CNTL_STREAM_ENABLE__MASK;
}


#define REG_A6XX_VPC_SO_OVERRIDE				__FD_DEPRECATED 0x00009306
#define A6XX_VPC_SO_OVERRIDE_DISABLE				0x00000001


#define REG_A8XX_VPC_SO_OVERRIDE				__FD_DEPRECATED 0x00009305
#define A8XX_VPC_SO_OVERRIDE_DISABLE				0x00000001


#define REG_A7XX_PC_DGEN_SO_OVERRIDE				__FD_DEPRECATED 0x00009807
#define A7XX_PC_DGEN_SO_OVERRIDE_DISABLE			0x00000001


#define REG_A8XX_PC_DGEN_SO_OVERRIDE				__FD_DEPRECATED 0x00009b0a
#define A8XX_PC_DGEN_SO_OVERRIDE_DISABLE			0x00000001


#define REG_A6XX_VPC_PS_RAST_CNTL				__FD_DEPRECATED 0x00009307
#define A6XX_VPC_PS_RAST_CNTL_MODE__MASK			0x00000003ull
#define A6XX_VPC_PS_RAST_CNTL_MODE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VPC_PS_RAST_CNTL_MODE(enum a6xx_polygon_mode val)
{
	return ((val) << A6XX_VPC_PS_RAST_CNTL_MODE__SHIFT) & A6XX_VPC_PS_RAST_CNTL_MODE__MASK;
}


#define REG_A8XX_VPC_PS_RAST_CNTL				__FD_DEPRECATED 0x00009306
#define A8XX_VPC_PS_RAST_CNTL_MODE__MASK			0x00000003ull
#define A8XX_VPC_PS_RAST_CNTL_MODE__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_VPC_PS_RAST_CNTL_MODE(enum a6xx_polygon_mode val)
{
	return ((val) << A8XX_VPC_PS_RAST_CNTL_MODE__SHIFT) & A8XX_VPC_PS_RAST_CNTL_MODE__MASK;
}


#define REG_A7XX_VPC_ATTR_BUF_GMEM_SIZE				__FD_DEPRECATED 0x00009308


#define REG_A7XX_VPC_ATTR_BUF_GMEM_BASE				__FD_DEPRECATED 0x00009309


#define REG_A8XX_VPC_ATTR_BUF_GMEM_SIZE				__FD_DEPRECATED 0x00009314


#define REG_A8XX_VPC_ATTR_BUF_GMEM_BASE				__FD_DEPRECATED 0x00009315


#define REG_A8XX_VPC_POS_BUF_GMEM_SIZE				__FD_DEPRECATED 0x00009316


#define REG_A8XX_VPC_POS_BUF_GMEM_BASE				__FD_DEPRECATED 0x00009317


#define REG_A8XX_VPC_BV_POS_BUF_GMEM_SIZE			__FD_DEPRECATED 0x00009318


#define REG_A8XX_VPC_BV_POS_BUF_GMEM_BASE			__FD_DEPRECATED 0x00009319


#define REG_A7XX_PC_ATTR_BUF_GMEM_SIZE				__FD_DEPRECATED 0x00009b09


#define REG_A8XX_PC_ATTR_BUF_GMEM_SIZE				__FD_DEPRECATED 0x00009b16


#define REG_A8XX_PC_POS_BUF_GMEM_SIZE				__FD_DEPRECATED 0x00009b17


#define REG_A8XX_PC_BV_POS_BUF_GMEM_SIZE			__FD_DEPRECATED 0x00009b18


#define REG_A7XX_VPC_UNKNOWN_930A				__FD_DEPRECATED 0x0000930a


#define REG_A8XX_VPC_UNKNOWN_9313				__FD_DEPRECATED 0x00009313


#define REG_A8XX_PC_UNKNOWN_9E17				__FD_DEPRECATED 0x00009e17


#define REG_A7XX_VPC_FLATSHADE_MODE_CNTL			__FD_DEPRECATED 0x0000960a


#define REG_A8XX_VPC_FLATSHADE_MODE_CNTL			__FD_DEPRECATED 0x00009741


#define REG_A6XX_VPC_DBG_ECO_CNTL				__FD_DEPRECATED 0x00009600


#define REG_A6XX_VPC_ADDR_MODE_CNTL				__FD_DEPRECATED 0x00009601


#define REG_A8XX_VPC_DBG_ECO_CNTL				__FD_DEPRECATED 0x00009680


#define REG_A8XX_VPC_DBG_ECO_CNTL_2				__FD_DEPRECATED 0x00009604


#define REG_A8XX_VPC_DBG_ECO_CNTL_1				__FD_DEPRECATED 0x00009742


#define REG_A8XX_VPC_DBG_ECO_CNTL_3				__FD_DEPRECATED 0x00009745


#define REG_A6XX_VPC_LB_MODE_CNTL				__FD_DEPRECATED 0x00009602


#define REG_A8XX_VPC_LB_MODE_CNTL				__FD_DEPRECATED 0x00009740


#define REG_A6XX_VPC_STATUS					__FD_DEPRECATED 0x00009603


#define REG_A8XX_VPC_STATUS					__FD_DEPRECATED 0x00009600


#define REG_A6XX_VPC_PERFCTR_VPC_SEL(i0)			(0x00009604 + 0x1*i0 )



#define REG_A7XX_VPC_PERFCTR_VPC_SEL(i0)			(0x0000960b + 0x1*i0 )



#define REG_A8XX_VPC_PERFCTR_VPC_SEL_2(i0)			(0x00009670 + 0x1*i0 )



#define REG_A8XX_VPC_PERFCTR_VPC_SEL(i0)			(0x00009690 + 0x1*i0 )



#define REG_A8XX_VPC_PERFCTR_VPC_SEL_1(i0)			(0x00009750 + 0x1*i0 )



#define REG_A6XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR		__FD_DEPRECATED 0x00009634
static CONSTEXPR inline uint32_t A6XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR		__FD_DEPRECATED 0x00009602
static CONSTEXPR inline uint32_t A8XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_VPC_CONTEXT_SWITCH_SO_SAVE_ADDR_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_PC_UNKNOWN_980B				__FD_DEPRECATED 0x0000980b


#define REG_A6XX_PC_HS_PARAM_0					__FD_DEPRECATED 0x00009800


#define REG_A8XX_PC_HS_PARAM_0					__FD_DEPRECATED 0x00009b10


#define REG_A6XX_PC_HS_PARAM_1					__FD_DEPRECATED 0x00009801
#define A6XX_PC_HS_PARAM_1_SIZE__MASK				0x000007ffull
#define A6XX_PC_HS_PARAM_1_SIZE__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_PC_HS_PARAM_1_SIZE(uint32_t val)
{
	return ((val) << A6XX_PC_HS_PARAM_1_SIZE__SHIFT) & A6XX_PC_HS_PARAM_1_SIZE__MASK;
}
#define A6XX_PC_HS_PARAM_1_UNK13				0x00002000


#define REG_A8XX_PC_HS_PARAM_1					__FD_DEPRECATED 0x00009b11
#define A8XX_PC_HS_PARAM_1_SIZE__MASK				0x000007ffull
#define A8XX_PC_HS_PARAM_1_SIZE__SHIFT				0
static CONSTEXPR inline uint32_t A8XX_PC_HS_PARAM_1_SIZE(uint32_t val)
{
	return ((val) << A8XX_PC_HS_PARAM_1_SIZE__SHIFT) & A8XX_PC_HS_PARAM_1_SIZE__MASK;
}
#define A8XX_PC_HS_PARAM_1_UNK13				0x00002000


#define REG_A6XX_PC_DS_PARAM					__FD_DEPRECATED 0x00009802
#define A6XX_PC_DS_PARAM_SPACING__MASK				0x00000003ull
#define A6XX_PC_DS_PARAM_SPACING__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_PC_DS_PARAM_SPACING(enum a6xx_tess_spacing val)
{
	return ((val) << A6XX_PC_DS_PARAM_SPACING__SHIFT) & A6XX_PC_DS_PARAM_SPACING__MASK;
}
#define A6XX_PC_DS_PARAM_OUTPUT__MASK				0x0000000cull
#define A6XX_PC_DS_PARAM_OUTPUT__SHIFT				2
static CONSTEXPR inline uint32_t A6XX_PC_DS_PARAM_OUTPUT(enum a6xx_tess_output val)
{
	return ((val) << A6XX_PC_DS_PARAM_OUTPUT__SHIFT) & A6XX_PC_DS_PARAM_OUTPUT__MASK;
}


#define REG_A8XX_PC_DS_PARAM					__FD_DEPRECATED 0x00009b12
#define A8XX_PC_DS_PARAM_SPACING__MASK				0x00000003ull
#define A8XX_PC_DS_PARAM_SPACING__SHIFT				0
static CONSTEXPR inline uint32_t A8XX_PC_DS_PARAM_SPACING(enum a6xx_tess_spacing val)
{
	return ((val) << A8XX_PC_DS_PARAM_SPACING__SHIFT) & A8XX_PC_DS_PARAM_SPACING__MASK;
}
#define A8XX_PC_DS_PARAM_OUTPUT__MASK				0x0000000cull
#define A8XX_PC_DS_PARAM_OUTPUT__SHIFT				2
static CONSTEXPR inline uint32_t A8XX_PC_DS_PARAM_OUTPUT(enum a6xx_tess_output val)
{
	return ((val) << A8XX_PC_DS_PARAM_OUTPUT__SHIFT) & A8XX_PC_DS_PARAM_OUTPUT__MASK;
}


#define REG_A6XX_PC_RESTART_INDEX				__FD_DEPRECATED 0x00009803


#define REG_A8XX_PC_RESTART_INDEX				__FD_DEPRECATED 0x00009b15


#define REG_A6XX_PC_MODE_CNTL					__FD_DEPRECATED 0x00009804


#define REG_A8XX_PC_MODE_CNTL					__FD_DEPRECATED 0x00009b00


#define REG_A6XX_PC_POWER_CNTL					__FD_DEPRECATED 0x00009805


#define REG_A6XX_PC_PS_CNTL					__FD_DEPRECATED 0x00009806
#define A6XX_PC_PS_CNTL_PRIMITIVEIDEN				0x00000001


#define REG_A8XX_PC_PS_CNTL					__FD_DEPRECATED 0x00009b06
#define A8XX_PC_PS_CNTL_PRIMITIVEIDEN				0x00000001


#define REG_A6XX_PC_DGEN_SO_CNTL				__FD_DEPRECATED 0x00009808
#define A6XX_PC_DGEN_SO_CNTL_STREAM_ENABLE__MASK		0x00078000ull
#define A6XX_PC_DGEN_SO_CNTL_STREAM_ENABLE__SHIFT		15
static CONSTEXPR inline uint32_t A6XX_PC_DGEN_SO_CNTL_STREAM_ENABLE(uint32_t val)
{
	return ((val) << A6XX_PC_DGEN_SO_CNTL_STREAM_ENABLE__SHIFT) & A6XX_PC_DGEN_SO_CNTL_STREAM_ENABLE__MASK;
}


#define REG_A8XX_PC_DGEN_SO_CNTL				__FD_DEPRECATED 0x00009b0b
#define A8XX_PC_DGEN_SO_CNTL_STREAM_ENABLE__MASK		0x00078000ull
#define A8XX_PC_DGEN_SO_CNTL_STREAM_ENABLE__SHIFT		15
static CONSTEXPR inline uint32_t A8XX_PC_DGEN_SO_CNTL_STREAM_ENABLE(uint32_t val)
{
	return ((val) << A8XX_PC_DGEN_SO_CNTL_STREAM_ENABLE__SHIFT) & A8XX_PC_DGEN_SO_CNTL_STREAM_ENABLE__MASK;
}


#define REG_A6XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL		__FD_DEPRECATED 0x0000980a
#define A6XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL_CONSERVATIVERASEN	0x00000001


#define REG_A8XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL		__FD_DEPRECATED 0x00009b08
#define A8XX_PC_DGEN_SU_CONSERVATIVE_RAS_CNTL_CONSERVATIVERASEN	0x00000001


#define REG_A8XX_PC_VS_INPUT_CNTL				__FD_DEPRECATED 0x00009b0c
#define A8XX_PC_VS_INPUT_CNTL_INSTR_CNT__MASK			0x0000003full
#define A8XX_PC_VS_INPUT_CNTL_INSTR_CNT__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_PC_VS_INPUT_CNTL_INSTR_CNT(uint32_t val)
{
	return ((val) << A8XX_PC_VS_INPUT_CNTL_INSTR_CNT__SHIFT) & A8XX_PC_VS_INPUT_CNTL_INSTR_CNT__MASK;
}
#define A8XX_PC_VS_INPUT_CNTL_SIDEBAND_CNT__MASK		0x000001c0ull
#define A8XX_PC_VS_INPUT_CNTL_SIDEBAND_CNT__SHIFT		6
static CONSTEXPR inline uint32_t A8XX_PC_VS_INPUT_CNTL_SIDEBAND_CNT(uint32_t val)
{
	return ((val) << A8XX_PC_VS_INPUT_CNTL_SIDEBAND_CNT__SHIFT) & A8XX_PC_VS_INPUT_CNTL_SIDEBAND_CNT__MASK;
}


#define REG_A6XX_PC_DRAW_INITIATOR				__FD_DEPRECATED 0x00009840
#define A6XX_PC_DRAW_INITIATOR_STATE_ID__MASK			0x000000ffull
#define A6XX_PC_DRAW_INITIATOR_STATE_ID__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_PC_DRAW_INITIATOR_STATE_ID(uint32_t val)
{
	return ((val) << A6XX_PC_DRAW_INITIATOR_STATE_ID__SHIFT) & A6XX_PC_DRAW_INITIATOR_STATE_ID__MASK;
}


#define REG_A6XX_PC_KERNEL_INITIATOR				__FD_DEPRECATED 0x00009841
#define A6XX_PC_KERNEL_INITIATOR_STATE_ID__MASK			0x000000ffull
#define A6XX_PC_KERNEL_INITIATOR_STATE_ID__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_PC_KERNEL_INITIATOR_STATE_ID(uint32_t val)
{
	return ((val) << A6XX_PC_KERNEL_INITIATOR_STATE_ID__SHIFT) & A6XX_PC_KERNEL_INITIATOR_STATE_ID__MASK;
}


#define REG_A8XX_PC_DRAW_INITIATOR				__FD_DEPRECATED 0x00009800
#define A8XX_PC_DRAW_INITIATOR_STATE_ID__MASK			0x000000ffull
#define A8XX_PC_DRAW_INITIATOR_STATE_ID__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_PC_DRAW_INITIATOR_STATE_ID(uint32_t val)
{
	return ((val) << A8XX_PC_DRAW_INITIATOR_STATE_ID__SHIFT) & A8XX_PC_DRAW_INITIATOR_STATE_ID__MASK;
}


#define REG_A8XX_PC_KERNEL_INITIATOR				__FD_DEPRECATED 0x00009801
#define A8XX_PC_KERNEL_INITIATOR_STATE_ID__MASK			0x000000ffull
#define A8XX_PC_KERNEL_INITIATOR_STATE_ID__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_PC_KERNEL_INITIATOR_STATE_ID(uint32_t val)
{
	return ((val) << A8XX_PC_KERNEL_INITIATOR_STATE_ID__SHIFT) & A8XX_PC_KERNEL_INITIATOR_STATE_ID__MASK;
}


#define REG_A6XX_PC_EVENT_INITIATOR				__FD_DEPRECATED 0x00009842
#define A6XX_PC_EVENT_INITIATOR_STATE_ID__MASK			0x00ff0000ull
#define A6XX_PC_EVENT_INITIATOR_STATE_ID__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_PC_EVENT_INITIATOR_STATE_ID(uint32_t val)
{
	return ((val) << A6XX_PC_EVENT_INITIATOR_STATE_ID__SHIFT) & A6XX_PC_EVENT_INITIATOR_STATE_ID__MASK;
}
#define A6XX_PC_EVENT_INITIATOR_EVENT__MASK			0x0000007full
#define A6XX_PC_EVENT_INITIATOR_EVENT__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_PC_EVENT_INITIATOR_EVENT(enum vgt_event_type val)
{
	return ((val) << A6XX_PC_EVENT_INITIATOR_EVENT__SHIFT) & A6XX_PC_EVENT_INITIATOR_EVENT__MASK;
}


#define REG_A8XX_PC_EVENT_INITIATOR				__FD_DEPRECATED 0x00009802
#define A8XX_PC_EVENT_INITIATOR_STATE_ID__MASK			0x00ff0000ull
#define A8XX_PC_EVENT_INITIATOR_STATE_ID__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_PC_EVENT_INITIATOR_STATE_ID(uint32_t val)
{
	return ((val) << A8XX_PC_EVENT_INITIATOR_STATE_ID__SHIFT) & A8XX_PC_EVENT_INITIATOR_STATE_ID__MASK;
}
#define A8XX_PC_EVENT_INITIATOR_EVENT__MASK			0x0000007full
#define A8XX_PC_EVENT_INITIATOR_EVENT__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_PC_EVENT_INITIATOR_EVENT(enum vgt_event_type val)
{
	return ((val) << A8XX_PC_EVENT_INITIATOR_EVENT__SHIFT) & A8XX_PC_EVENT_INITIATOR_EVENT__MASK;
}


#define REG_A6XX_PC_MARKER					0x00009880


#define REG_A6XX_PC_DGEN_RAST_CNTL				__FD_DEPRECATED 0x00009981
#define A6XX_PC_DGEN_RAST_CNTL_MODE__MASK			0x00000003ull
#define A6XX_PC_DGEN_RAST_CNTL_MODE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_PC_DGEN_RAST_CNTL_MODE(enum a6xx_polygon_mode val)
{
	return ((val) << A6XX_PC_DGEN_RAST_CNTL_MODE__SHIFT) & A6XX_PC_DGEN_RAST_CNTL_MODE__MASK;
}


#define REG_A7XX_PC_DGEN_RAST_CNTL				__FD_DEPRECATED 0x00009809
#define A7XX_PC_DGEN_RAST_CNTL_MODE__MASK			0x00000003ull
#define A7XX_PC_DGEN_RAST_CNTL_MODE__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_PC_DGEN_RAST_CNTL_MODE(enum a6xx_polygon_mode val)
{
	return ((val) << A7XX_PC_DGEN_RAST_CNTL_MODE__SHIFT) & A7XX_PC_DGEN_RAST_CNTL_MODE__MASK;
}


#define REG_A8XX_PC_DGEN_RAST_CNTL				__FD_DEPRECATED 0x00009812
#define A8XX_PC_DGEN_RAST_CNTL_MODE__MASK			0x00000003ull
#define A8XX_PC_DGEN_RAST_CNTL_MODE__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_PC_DGEN_RAST_CNTL_MODE(enum a6xx_polygon_mode val)
{
	return ((val) << A8XX_PC_DGEN_RAST_CNTL_MODE__SHIFT) & A8XX_PC_DGEN_RAST_CNTL_MODE__MASK;
}


#define REG_A7XX_PC_HS_PATCH_SIZE				__FD_DEPRECATED 0x00009884


#define REG_A8XX_PC_HS_PATCH_SIZE				__FD_DEPRECATED 0x00009813


#define REG_A7XX_PC_HS_BUFFER_SIZE				__FD_DEPRECATED 0x00009885


#define REG_A8XX_PC_HS_BUFFER_SIZE				__FD_DEPRECATED 0x00009814


#define REG_A7XX_PC_TF_BUFFER_SIZE				__FD_DEPRECATED 0x00009886


#define REG_A8XX_PC_TF_BUFFER_SIZE				__FD_DEPRECATED 0x00009815


#define REG_A6XX_PC_CNTL					__FD_DEPRECATED 0x00009b00
#define A6XX_PC_CNTL_PRIMITIVE_RESTART				0x00000001
#define A6XX_PC_CNTL_PROVOKING_VTX_LAST				0x00000002
#define A6XX_PC_CNTL_D3D_VERTEX_ORDERING			0x00000004
#define A6XX_PC_CNTL_UNK3					0x00000008


#define REG_A8XX_PC_CNTL					__FD_DEPRECATED 0x00009b01
#define A8XX_PC_CNTL_PRIMITIVE_RESTART				0x00000001
#define A8XX_PC_CNTL_PROVOKING_VTX_LAST				0x00000002
#define A8XX_PC_CNTL_D3D_VERTEX_ORDERING			0x00000004
#define A8XX_PC_CNTL_UNK3					0x00000008


#define REG_A6XX_PC_VS_CNTL					__FD_DEPRECATED 0x00009b01
#define A6XX_PC_VS_CNTL_STRIDE_IN_VPC__MASK			0x000000ffull
#define A6XX_PC_VS_CNTL_STRIDE_IN_VPC__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_PC_VS_CNTL_STRIDE_IN_VPC(uint32_t val)
{
	return ((val) << A6XX_PC_VS_CNTL_STRIDE_IN_VPC__SHIFT) & A6XX_PC_VS_CNTL_STRIDE_IN_VPC__MASK;
}
#define A6XX_PC_VS_CNTL_PSIZE					0x00000100
#define A6XX_PC_VS_CNTL_LAYER					0x00000200
#define A6XX_PC_VS_CNTL_VIEW					0x00000400
#define A6XX_PC_VS_CNTL_PRIMITIVE_ID				0x00000800
#define A6XX_PC_VS_CNTL_CLIP_MASK__MASK				0x00ff0000ull
#define A6XX_PC_VS_CNTL_CLIP_MASK__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_PC_VS_CNTL_CLIP_MASK(uint32_t val)
{
	return ((val) << A6XX_PC_VS_CNTL_CLIP_MASK__SHIFT) & A6XX_PC_VS_CNTL_CLIP_MASK__MASK;
}
#define A6XX_PC_VS_CNTL_SHADINGRATE				0x01000000


#define REG_A6XX_PC_GS_CNTL					__FD_DEPRECATED 0x00009b02
#define A6XX_PC_GS_CNTL_STRIDE_IN_VPC__MASK			0x000000ffull
#define A6XX_PC_GS_CNTL_STRIDE_IN_VPC__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_PC_GS_CNTL_STRIDE_IN_VPC(uint32_t val)
{
	return ((val) << A6XX_PC_GS_CNTL_STRIDE_IN_VPC__SHIFT) & A6XX_PC_GS_CNTL_STRIDE_IN_VPC__MASK;
}
#define A6XX_PC_GS_CNTL_PSIZE					0x00000100
#define A6XX_PC_GS_CNTL_LAYER					0x00000200
#define A6XX_PC_GS_CNTL_VIEW					0x00000400
#define A6XX_PC_GS_CNTL_PRIMITIVE_ID				0x00000800
#define A6XX_PC_GS_CNTL_CLIP_MASK__MASK				0x00ff0000ull
#define A6XX_PC_GS_CNTL_CLIP_MASK__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_PC_GS_CNTL_CLIP_MASK(uint32_t val)
{
	return ((val) << A6XX_PC_GS_CNTL_CLIP_MASK__SHIFT) & A6XX_PC_GS_CNTL_CLIP_MASK__MASK;
}
#define A6XX_PC_GS_CNTL_SHADINGRATE				0x01000000


#define REG_A6XX_PC_HS_CNTL					__FD_DEPRECATED 0x00009b03
#define A6XX_PC_HS_CNTL_STRIDE_IN_VPC__MASK			0x000000ffull
#define A6XX_PC_HS_CNTL_STRIDE_IN_VPC__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_PC_HS_CNTL_STRIDE_IN_VPC(uint32_t val)
{
	return ((val) << A6XX_PC_HS_CNTL_STRIDE_IN_VPC__SHIFT) & A6XX_PC_HS_CNTL_STRIDE_IN_VPC__MASK;
}
#define A6XX_PC_HS_CNTL_PSIZE					0x00000100
#define A6XX_PC_HS_CNTL_LAYER					0x00000200
#define A6XX_PC_HS_CNTL_VIEW					0x00000400
#define A6XX_PC_HS_CNTL_PRIMITIVE_ID				0x00000800
#define A6XX_PC_HS_CNTL_CLIP_MASK__MASK				0x00ff0000ull
#define A6XX_PC_HS_CNTL_CLIP_MASK__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_PC_HS_CNTL_CLIP_MASK(uint32_t val)
{
	return ((val) << A6XX_PC_HS_CNTL_CLIP_MASK__SHIFT) & A6XX_PC_HS_CNTL_CLIP_MASK__MASK;
}
#define A6XX_PC_HS_CNTL_SHADINGRATE				0x01000000


#define REG_A6XX_PC_DS_CNTL					__FD_DEPRECATED 0x00009b04
#define A6XX_PC_DS_CNTL_STRIDE_IN_VPC__MASK			0x000000ffull
#define A6XX_PC_DS_CNTL_STRIDE_IN_VPC__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_PC_DS_CNTL_STRIDE_IN_VPC(uint32_t val)
{
	return ((val) << A6XX_PC_DS_CNTL_STRIDE_IN_VPC__SHIFT) & A6XX_PC_DS_CNTL_STRIDE_IN_VPC__MASK;
}
#define A6XX_PC_DS_CNTL_PSIZE					0x00000100
#define A6XX_PC_DS_CNTL_LAYER					0x00000200
#define A6XX_PC_DS_CNTL_VIEW					0x00000400
#define A6XX_PC_DS_CNTL_PRIMITIVE_ID				0x00000800
#define A6XX_PC_DS_CNTL_CLIP_MASK__MASK				0x00ff0000ull
#define A6XX_PC_DS_CNTL_CLIP_MASK__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_PC_DS_CNTL_CLIP_MASK(uint32_t val)
{
	return ((val) << A6XX_PC_DS_CNTL_CLIP_MASK__SHIFT) & A6XX_PC_DS_CNTL_CLIP_MASK__MASK;
}
#define A6XX_PC_DS_CNTL_SHADINGRATE				0x01000000


#define REG_A8XX_PC_VS_CNTL					__FD_DEPRECATED 0x00009b02
#define A8XX_PC_VS_CNTL_STRIDE_IN_VPC__MASK			0x000000ffull
#define A8XX_PC_VS_CNTL_STRIDE_IN_VPC__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_PC_VS_CNTL_STRIDE_IN_VPC(uint32_t val)
{
	return ((val) << A8XX_PC_VS_CNTL_STRIDE_IN_VPC__SHIFT) & A8XX_PC_VS_CNTL_STRIDE_IN_VPC__MASK;
}
#define A8XX_PC_VS_CNTL_PSIZE					0x00000100
#define A8XX_PC_VS_CNTL_LAYER					0x00000200
#define A8XX_PC_VS_CNTL_VIEW					0x00000400
#define A8XX_PC_VS_CNTL_PRIMITIVE_ID				0x00000800
#define A8XX_PC_VS_CNTL_CLIP_MASK__MASK				0x00ff0000ull
#define A8XX_PC_VS_CNTL_CLIP_MASK__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_PC_VS_CNTL_CLIP_MASK(uint32_t val)
{
	return ((val) << A8XX_PC_VS_CNTL_CLIP_MASK__SHIFT) & A8XX_PC_VS_CNTL_CLIP_MASK__MASK;
}
#define A8XX_PC_VS_CNTL_SHADINGRATE				0x01000000


#define REG_A8XX_PC_GS_CNTL					__FD_DEPRECATED 0x00009b03
#define A8XX_PC_GS_CNTL_STRIDE_IN_VPC__MASK			0x000000ffull
#define A8XX_PC_GS_CNTL_STRIDE_IN_VPC__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_PC_GS_CNTL_STRIDE_IN_VPC(uint32_t val)
{
	return ((val) << A8XX_PC_GS_CNTL_STRIDE_IN_VPC__SHIFT) & A8XX_PC_GS_CNTL_STRIDE_IN_VPC__MASK;
}
#define A8XX_PC_GS_CNTL_PSIZE					0x00000100
#define A8XX_PC_GS_CNTL_LAYER					0x00000200
#define A8XX_PC_GS_CNTL_VIEW					0x00000400
#define A8XX_PC_GS_CNTL_PRIMITIVE_ID				0x00000800
#define A8XX_PC_GS_CNTL_CLIP_MASK__MASK				0x00ff0000ull
#define A8XX_PC_GS_CNTL_CLIP_MASK__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_PC_GS_CNTL_CLIP_MASK(uint32_t val)
{
	return ((val) << A8XX_PC_GS_CNTL_CLIP_MASK__SHIFT) & A8XX_PC_GS_CNTL_CLIP_MASK__MASK;
}
#define A8XX_PC_GS_CNTL_SHADINGRATE				0x01000000


#define REG_A8XX_PC_HS_CNTL					__FD_DEPRECATED 0x00009b04
#define A8XX_PC_HS_CNTL_STRIDE_IN_VPC__MASK			0x000000ffull
#define A8XX_PC_HS_CNTL_STRIDE_IN_VPC__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_PC_HS_CNTL_STRIDE_IN_VPC(uint32_t val)
{
	return ((val) << A8XX_PC_HS_CNTL_STRIDE_IN_VPC__SHIFT) & A8XX_PC_HS_CNTL_STRIDE_IN_VPC__MASK;
}
#define A8XX_PC_HS_CNTL_PSIZE					0x00000100
#define A8XX_PC_HS_CNTL_LAYER					0x00000200
#define A8XX_PC_HS_CNTL_VIEW					0x00000400
#define A8XX_PC_HS_CNTL_PRIMITIVE_ID				0x00000800
#define A8XX_PC_HS_CNTL_CLIP_MASK__MASK				0x00ff0000ull
#define A8XX_PC_HS_CNTL_CLIP_MASK__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_PC_HS_CNTL_CLIP_MASK(uint32_t val)
{
	return ((val) << A8XX_PC_HS_CNTL_CLIP_MASK__SHIFT) & A8XX_PC_HS_CNTL_CLIP_MASK__MASK;
}
#define A8XX_PC_HS_CNTL_SHADINGRATE				0x01000000


#define REG_A8XX_PC_DS_CNTL					__FD_DEPRECATED 0x00009b05
#define A8XX_PC_DS_CNTL_STRIDE_IN_VPC__MASK			0x000000ffull
#define A8XX_PC_DS_CNTL_STRIDE_IN_VPC__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_PC_DS_CNTL_STRIDE_IN_VPC(uint32_t val)
{
	return ((val) << A8XX_PC_DS_CNTL_STRIDE_IN_VPC__SHIFT) & A8XX_PC_DS_CNTL_STRIDE_IN_VPC__MASK;
}
#define A8XX_PC_DS_CNTL_PSIZE					0x00000100
#define A8XX_PC_DS_CNTL_LAYER					0x00000200
#define A8XX_PC_DS_CNTL_VIEW					0x00000400
#define A8XX_PC_DS_CNTL_PRIMITIVE_ID				0x00000800
#define A8XX_PC_DS_CNTL_CLIP_MASK__MASK				0x00ff0000ull
#define A8XX_PC_DS_CNTL_CLIP_MASK__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_PC_DS_CNTL_CLIP_MASK(uint32_t val)
{
	return ((val) << A8XX_PC_DS_CNTL_CLIP_MASK__SHIFT) & A8XX_PC_DS_CNTL_CLIP_MASK__MASK;
}
#define A8XX_PC_DS_CNTL_SHADINGRATE				0x01000000


#define REG_A6XX_PC_GS_PARAM_0					__FD_DEPRECATED 0x00009b05
#define A6XX_PC_GS_PARAM_0_GS_VERTICES_OUT__MASK		0x000000ffull
#define A6XX_PC_GS_PARAM_0_GS_VERTICES_OUT__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_PC_GS_PARAM_0_GS_VERTICES_OUT(uint32_t val)
{
	return ((val) << A6XX_PC_GS_PARAM_0_GS_VERTICES_OUT__SHIFT) & A6XX_PC_GS_PARAM_0_GS_VERTICES_OUT__MASK;
}
#define A6XX_PC_GS_PARAM_0_GS_INVOCATIONS__MASK			0x00007c00ull
#define A6XX_PC_GS_PARAM_0_GS_INVOCATIONS__SHIFT		10
static CONSTEXPR inline uint32_t A6XX_PC_GS_PARAM_0_GS_INVOCATIONS(uint32_t val)
{
	return ((val) << A6XX_PC_GS_PARAM_0_GS_INVOCATIONS__SHIFT) & A6XX_PC_GS_PARAM_0_GS_INVOCATIONS__MASK;
}
#define A6XX_PC_GS_PARAM_0_LINELENGTHEN				0x00008000
#define A6XX_PC_GS_PARAM_0_GS_OUTPUT__MASK			0x00030000ull
#define A6XX_PC_GS_PARAM_0_GS_OUTPUT__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_PC_GS_PARAM_0_GS_OUTPUT(enum a6xx_tess_output val)
{
	return ((val) << A6XX_PC_GS_PARAM_0_GS_OUTPUT__SHIFT) & A6XX_PC_GS_PARAM_0_GS_OUTPUT__MASK;
}
#define A6XX_PC_GS_PARAM_0_UNK18				0x00040000


#define REG_A8XX_PC_GS_PARAM_0					__FD_DEPRECATED 0x00009b13
#define A8XX_PC_GS_PARAM_0_GS_VERTICES_OUT__MASK		0x000000ffull
#define A8XX_PC_GS_PARAM_0_GS_VERTICES_OUT__SHIFT		0
static CONSTEXPR inline uint32_t A8XX_PC_GS_PARAM_0_GS_VERTICES_OUT(uint32_t val)
{
	return ((val) << A8XX_PC_GS_PARAM_0_GS_VERTICES_OUT__SHIFT) & A8XX_PC_GS_PARAM_0_GS_VERTICES_OUT__MASK;
}
#define A8XX_PC_GS_PARAM_0_GS_INVOCATIONS__MASK			0x00007c00ull
#define A8XX_PC_GS_PARAM_0_GS_INVOCATIONS__SHIFT		10
static CONSTEXPR inline uint32_t A8XX_PC_GS_PARAM_0_GS_INVOCATIONS(uint32_t val)
{
	return ((val) << A8XX_PC_GS_PARAM_0_GS_INVOCATIONS__SHIFT) & A8XX_PC_GS_PARAM_0_GS_INVOCATIONS__MASK;
}
#define A8XX_PC_GS_PARAM_0_LINELENGTHEN				0x00008000
#define A8XX_PC_GS_PARAM_0_GS_OUTPUT__MASK			0x00030000ull
#define A8XX_PC_GS_PARAM_0_GS_OUTPUT__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_PC_GS_PARAM_0_GS_OUTPUT(enum a6xx_tess_output val)
{
	return ((val) << A8XX_PC_GS_PARAM_0_GS_OUTPUT__SHIFT) & A8XX_PC_GS_PARAM_0_GS_OUTPUT__MASK;
}
#define A8XX_PC_GS_PARAM_0_UNK18				0x00040000


#define REG_A6XX_PC_PRIMITIVE_CNTL_6				__FD_DEPRECATED 0x00009b06
#define A6XX_PC_PRIMITIVE_CNTL_6_STRIDE_IN_VPC__MASK		0x000007ffull
#define A6XX_PC_PRIMITIVE_CNTL_6_STRIDE_IN_VPC__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_PC_PRIMITIVE_CNTL_6_STRIDE_IN_VPC(uint32_t val)
{
	return ((val) << A6XX_PC_PRIMITIVE_CNTL_6_STRIDE_IN_VPC__SHIFT) & A6XX_PC_PRIMITIVE_CNTL_6_STRIDE_IN_VPC__MASK;
}


#define REG_A6XX_PC_STEREO_RENDERING_CNTL			__FD_DEPRECATED 0x00009b07
#define A6XX_PC_STEREO_RENDERING_CNTL_ENABLE			0x00000001
#define A6XX_PC_STEREO_RENDERING_CNTL_DISABLEMULTIPOS		0x00000002
#define A6XX_PC_STEREO_RENDERING_CNTL_VIEWS__MASK		0x0000007cull
#define A6XX_PC_STEREO_RENDERING_CNTL_VIEWS__SHIFT		2
static CONSTEXPR inline uint32_t A6XX_PC_STEREO_RENDERING_CNTL_VIEWS(uint32_t val)
{
	return ((val) << A6XX_PC_STEREO_RENDERING_CNTL_VIEWS__SHIFT) & A6XX_PC_STEREO_RENDERING_CNTL_VIEWS__MASK;
}


#define REG_A8XX_PC_STEREO_RENDERING_CNTL			__FD_DEPRECATED 0x00009b09
#define A8XX_PC_STEREO_RENDERING_CNTL_ENABLE			0x00000001
#define A8XX_PC_STEREO_RENDERING_CNTL_DISABLEMULTIPOS		0x00000002
#define A8XX_PC_STEREO_RENDERING_CNTL_VIEWS__MASK		0x0000007cull
#define A8XX_PC_STEREO_RENDERING_CNTL_VIEWS__SHIFT		2
static CONSTEXPR inline uint32_t A8XX_PC_STEREO_RENDERING_CNTL_VIEWS(uint32_t val)
{
	return ((val) << A8XX_PC_STEREO_RENDERING_CNTL_VIEWS__SHIFT) & A8XX_PC_STEREO_RENDERING_CNTL_VIEWS__MASK;
}


#define REG_A6XX_PC_STEREO_RENDERING_VIEWMASK			__FD_DEPRECATED 0x00009b08


#define REG_A8XX_PC_STEREO_RENDERING_VIEWMASK			__FD_DEPRECATED 0x00009b0d


#define REG_A6XX_PC_2D_EVENT_CMD				0x00009c00
#define A6XX_PC_2D_EVENT_CMD_EVENT__MASK			0x0000007full
#define A6XX_PC_2D_EVENT_CMD_EVENT__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_PC_2D_EVENT_CMD_EVENT(enum vgt_event_type val)
{
	return ((val) << A6XX_PC_2D_EVENT_CMD_EVENT__SHIFT) & A6XX_PC_2D_EVENT_CMD_EVENT__MASK;
}
#define A6XX_PC_2D_EVENT_CMD_STATE_ID__MASK			0x0000ff00ull
#define A6XX_PC_2D_EVENT_CMD_STATE_ID__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_PC_2D_EVENT_CMD_STATE_ID(uint32_t val)
{
	return ((val) << A6XX_PC_2D_EVENT_CMD_STATE_ID__SHIFT) & A6XX_PC_2D_EVENT_CMD_STATE_ID__MASK;
}


#define REG_A8XX_PC_CHICKEN_BITS_1				__FD_DEPRECATED 0x00009e50


#define REG_A8XX_PC_CHICKEN_BITS_2				__FD_DEPRECATED 0x00009f20


#define REG_A8XX_PC_CHICKEN_BITS_3				__FD_DEPRECATED 0x00009e22


#define REG_A8XX_PC_CHICKEN_BITS_4				__FD_DEPRECATED 0x00009e23


#define REG_A8XX_PC_CHICKEN_BITS_5				__FD_DEPRECATED 0x00009f23


#define REG_A6XX_PC_DBG_ECO_CNTL				__FD_DEPRECATED 0x00009e00


#define REG_A8XX_PC_DBG_ECO_CNTL				__FD_DEPRECATED 0x00009e53


#define REG_A6XX_PC_ADDR_MODE_CNTL				__FD_DEPRECATED 0x00009e01


#define REG_A6XX_PC_DMA_BASE					__FD_DEPRECATED 0x00009e04
static CONSTEXPR inline uint32_t A6XX_PC_DMA_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_PC_DMA_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_PC_DMA_OFFSET					__FD_DEPRECATED 0x00009e06


#define REG_A6XX_PC_DMA_SIZE					__FD_DEPRECATED 0x00009e07


#define REG_A8XX_PC_DMA_BASE					__FD_DEPRECATED 0x00009e06
static CONSTEXPR inline uint32_t A8XX_PC_DMA_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_PC_DMA_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_PC_DMA_OFFSET					__FD_DEPRECATED 0x00009e08


#define REG_A8XX_PC_DMA_SIZE					__FD_DEPRECATED 0x00009e09


#define REG_A6XX_PC_TESS_BASE					__FD_DEPRECATED 0x00009e08
static CONSTEXPR inline uint32_t A6XX_PC_TESS_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_PC_TESS_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A7XX_PC_TESS_BASE					__FD_DEPRECATED 0x00009810
static CONSTEXPR inline uint32_t A7XX_PC_TESS_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_PC_TESS_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_PC_TESS_BASE					__FD_DEPRECATED 0x00009816
static CONSTEXPR inline uint32_t A8XX_PC_TESS_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_PC_TESS_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_PC_DRAWCALL_CNTL				__FD_DEPRECATED 0x00009e0b
#define A6XX_PC_DRAWCALL_CNTL_PRIM_TYPE__MASK			0x0000003full
#define A6XX_PC_DRAWCALL_CNTL_PRIM_TYPE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_PC_DRAWCALL_CNTL_PRIM_TYPE(enum pc_di_primtype val)
{
	return ((val) << A6XX_PC_DRAWCALL_CNTL_PRIM_TYPE__SHIFT) & A6XX_PC_DRAWCALL_CNTL_PRIM_TYPE__MASK;
}
#define A6XX_PC_DRAWCALL_CNTL_SOURCE_SELECT__MASK		0x000000c0ull
#define A6XX_PC_DRAWCALL_CNTL_SOURCE_SELECT__SHIFT		6
static CONSTEXPR inline uint32_t A6XX_PC_DRAWCALL_CNTL_SOURCE_SELECT(enum pc_di_src_sel val)
{
	return ((val) << A6XX_PC_DRAWCALL_CNTL_SOURCE_SELECT__SHIFT) & A6XX_PC_DRAWCALL_CNTL_SOURCE_SELECT__MASK;
}
#define A6XX_PC_DRAWCALL_CNTL_VIS_CULL__MASK			0x00000300ull
#define A6XX_PC_DRAWCALL_CNTL_VIS_CULL__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_PC_DRAWCALL_CNTL_VIS_CULL(enum pc_di_vis_cull_mode val)
{
	return ((val) << A6XX_PC_DRAWCALL_CNTL_VIS_CULL__SHIFT) & A6XX_PC_DRAWCALL_CNTL_VIS_CULL__MASK;
}
#define A6XX_PC_DRAWCALL_CNTL_INDEX_SIZE__MASK			0x00000c00ull
#define A6XX_PC_DRAWCALL_CNTL_INDEX_SIZE__SHIFT			10
static CONSTEXPR inline uint32_t A6XX_PC_DRAWCALL_CNTL_INDEX_SIZE(enum a4xx_index_size val)
{
	return ((val) << A6XX_PC_DRAWCALL_CNTL_INDEX_SIZE__SHIFT) & A6XX_PC_DRAWCALL_CNTL_INDEX_SIZE__MASK;
}
#define A6XX_PC_DRAWCALL_CNTL_PATCH_TYPE__MASK			0x00003000ull
#define A6XX_PC_DRAWCALL_CNTL_PATCH_TYPE__SHIFT			12
static CONSTEXPR inline uint32_t A6XX_PC_DRAWCALL_CNTL_PATCH_TYPE(enum a6xx_patch_type val)
{
	return ((val) << A6XX_PC_DRAWCALL_CNTL_PATCH_TYPE__SHIFT) & A6XX_PC_DRAWCALL_CNTL_PATCH_TYPE__MASK;
}
#define A6XX_PC_DRAWCALL_CNTL_GS_ENABLE				0x00010000
#define A6XX_PC_DRAWCALL_CNTL_TESS_ENABLE			0x00020000


#define REG_A6XX_PC_DRAWCALL_INSTANCE_NUM			__FD_DEPRECATED 0x00009e0c


#define REG_A6XX_PC_DRAWCALL_SIZE				__FD_DEPRECATED 0x00009e0d


#define REG_A8XX_PC_DRAWCALL_CNTL				__FD_DEPRECATED 0x00009e00
#define A8XX_PC_DRAWCALL_CNTL_PRIM_TYPE__MASK			0x0000003full
#define A8XX_PC_DRAWCALL_CNTL_PRIM_TYPE__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_PC_DRAWCALL_CNTL_PRIM_TYPE(enum pc_di_primtype val)
{
	return ((val) << A8XX_PC_DRAWCALL_CNTL_PRIM_TYPE__SHIFT) & A8XX_PC_DRAWCALL_CNTL_PRIM_TYPE__MASK;
}
#define A8XX_PC_DRAWCALL_CNTL_SOURCE_SELECT__MASK		0x000000c0ull
#define A8XX_PC_DRAWCALL_CNTL_SOURCE_SELECT__SHIFT		6
static CONSTEXPR inline uint32_t A8XX_PC_DRAWCALL_CNTL_SOURCE_SELECT(enum pc_di_src_sel val)
{
	return ((val) << A8XX_PC_DRAWCALL_CNTL_SOURCE_SELECT__SHIFT) & A8XX_PC_DRAWCALL_CNTL_SOURCE_SELECT__MASK;
}
#define A8XX_PC_DRAWCALL_CNTL_VIS_CULL__MASK			0x00000300ull
#define A8XX_PC_DRAWCALL_CNTL_VIS_CULL__SHIFT			8
static CONSTEXPR inline uint32_t A8XX_PC_DRAWCALL_CNTL_VIS_CULL(enum pc_di_vis_cull_mode val)
{
	return ((val) << A8XX_PC_DRAWCALL_CNTL_VIS_CULL__SHIFT) & A8XX_PC_DRAWCALL_CNTL_VIS_CULL__MASK;
}
#define A8XX_PC_DRAWCALL_CNTL_INDEX_SIZE__MASK			0x00000c00ull
#define A8XX_PC_DRAWCALL_CNTL_INDEX_SIZE__SHIFT			10
static CONSTEXPR inline uint32_t A8XX_PC_DRAWCALL_CNTL_INDEX_SIZE(enum a4xx_index_size val)
{
	return ((val) << A8XX_PC_DRAWCALL_CNTL_INDEX_SIZE__SHIFT) & A8XX_PC_DRAWCALL_CNTL_INDEX_SIZE__MASK;
}
#define A8XX_PC_DRAWCALL_CNTL_PATCH_TYPE__MASK			0x00003000ull
#define A8XX_PC_DRAWCALL_CNTL_PATCH_TYPE__SHIFT			12
static CONSTEXPR inline uint32_t A8XX_PC_DRAWCALL_CNTL_PATCH_TYPE(enum a6xx_patch_type val)
{
	return ((val) << A8XX_PC_DRAWCALL_CNTL_PATCH_TYPE__SHIFT) & A8XX_PC_DRAWCALL_CNTL_PATCH_TYPE__MASK;
}
#define A8XX_PC_DRAWCALL_CNTL_GS_ENABLE				0x00010000
#define A8XX_PC_DRAWCALL_CNTL_TESS_ENABLE			0x00020000


#define REG_A8XX_PC_DRAWCALL_INSTANCE_NUM			__FD_DEPRECATED 0x00009e01


#define REG_A8XX_PC_DRAWCALL_SIZE				__FD_DEPRECATED 0x00009e02


#define REG_A6XX_PC_VIS_STREAM_CNTL				__FD_DEPRECATED 0x00009e11
#define A6XX_PC_VIS_STREAM_CNTL_UNK0__MASK			0x0000ffffull
#define A6XX_PC_VIS_STREAM_CNTL_UNK0__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_PC_VIS_STREAM_CNTL_UNK0(uint32_t val)
{
	return ((val) << A6XX_PC_VIS_STREAM_CNTL_UNK0__SHIFT) & A6XX_PC_VIS_STREAM_CNTL_UNK0__MASK;
}
#define A6XX_PC_VIS_STREAM_CNTL_VSC_SIZE__MASK			0x003f0000ull
#define A6XX_PC_VIS_STREAM_CNTL_VSC_SIZE__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_PC_VIS_STREAM_CNTL_VSC_SIZE(uint32_t val)
{
	return ((val) << A6XX_PC_VIS_STREAM_CNTL_VSC_SIZE__SHIFT) & A6XX_PC_VIS_STREAM_CNTL_VSC_SIZE__MASK;
}
#define A6XX_PC_VIS_STREAM_CNTL_VSC_N__MASK			0x07c00000ull
#define A6XX_PC_VIS_STREAM_CNTL_VSC_N__SHIFT			22
static CONSTEXPR inline uint32_t A6XX_PC_VIS_STREAM_CNTL_VSC_N(uint32_t val)
{
	return ((val) << A6XX_PC_VIS_STREAM_CNTL_VSC_N__SHIFT) & A6XX_PC_VIS_STREAM_CNTL_VSC_N__MASK;
}


#define REG_A6XX_PC_PVIS_STREAM_BIN_BASE			__FD_DEPRECATED 0x00009e12
static CONSTEXPR inline uint32_t A6XX_PC_PVIS_STREAM_BIN_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_PC_PVIS_STREAM_BIN_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_PC_DVIS_STREAM_BIN_BASE			__FD_DEPRECATED 0x00009e14
static CONSTEXPR inline uint32_t A6XX_PC_DVIS_STREAM_BIN_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_PC_DVIS_STREAM_BIN_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_PC_AUTO_VERTEX_STRIDE				0x00009e0a


#define REG_A8XX_PC_VIS_STREAM_CNTL				__FD_DEPRECATED 0x00009e0d
#define A8XX_PC_VIS_STREAM_CNTL_UNK0__MASK			0x0000ffffull
#define A8XX_PC_VIS_STREAM_CNTL_UNK0__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_PC_VIS_STREAM_CNTL_UNK0(uint32_t val)
{
	return ((val) << A8XX_PC_VIS_STREAM_CNTL_UNK0__SHIFT) & A8XX_PC_VIS_STREAM_CNTL_UNK0__MASK;
}
#define A8XX_PC_VIS_STREAM_CNTL_VSC_SIZE__MASK			0x003f0000ull
#define A8XX_PC_VIS_STREAM_CNTL_VSC_SIZE__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_PC_VIS_STREAM_CNTL_VSC_SIZE(uint32_t val)
{
	return ((val) << A8XX_PC_VIS_STREAM_CNTL_VSC_SIZE__SHIFT) & A8XX_PC_VIS_STREAM_CNTL_VSC_SIZE__MASK;
}
#define A8XX_PC_VIS_STREAM_CNTL_VSC_N__MASK			0x07c00000ull
#define A8XX_PC_VIS_STREAM_CNTL_VSC_N__SHIFT			22
static CONSTEXPR inline uint32_t A8XX_PC_VIS_STREAM_CNTL_VSC_N(uint32_t val)
{
	return ((val) << A8XX_PC_VIS_STREAM_CNTL_VSC_N__SHIFT) & A8XX_PC_VIS_STREAM_CNTL_VSC_N__MASK;
}


#define REG_A8XX_PC_PVIS_STREAM_BIN_BASE			__FD_DEPRECATED 0x00009e0e
static CONSTEXPR inline uint32_t A8XX_PC_PVIS_STREAM_BIN_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_PC_PVIS_STREAM_BIN_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_PC_DVIS_STREAM_BIN_BASE			__FD_DEPRECATED 0x00009e10
static CONSTEXPR inline uint32_t A8XX_PC_DVIS_STREAM_BIN_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_PC_DVIS_STREAM_BIN_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_PC_DRAWCALL_CNTL_OVERRIDE			__FD_DEPRECATED 0x00009e1c
#define A6XX_PC_DRAWCALL_CNTL_OVERRIDE_OVERRIDE			0x00000001


#define REG_A8XX_PC_DRAWCALL_CNTL_OVERRIDE			__FD_DEPRECATED 0x00009e04
#define A8XX_PC_DRAWCALL_CNTL_OVERRIDE_OVERRIDE			0x00000001


#define REG_A7XX_PC_UNKNOWN_9E24				__FD_DEPRECATED 0x00009e24


#define REG_A6XX_PC_PERFCTR_PC_SEL(i0)				(0x00009e34 + 0x1*i0 )



#define REG_A7XX_PC_PERFCTR_PC_SEL(i0)				(0x00009e42 + 0x1*i0 )



#define REG_A8XX_PC_PERFCTR_PC_SEL(i0)				(0x00009e30 + 0x1*i0 )



#define REG_A8XX_PC_SLICE_PERFCTR_PC_SEL(i0)			(0x00009f00 + 0x1*i0 )



#define REG_A6XX_PC_CONTEXT_SWITCH_GFX_PREEMPTION_MODE		__FD_DEPRECATED 0x00009e72


#define REG_A8XX_PC_CONTEXT_SWITCH_GFX_PREEMPTION_MODE		__FD_DEPRECATED 0x00009e63


#define REG_A8XX_PC_CONTEXT_SWITCH_STABILIZE_CNTL_1		__FD_DEPRECATED 0x00009e64


#define REG_A6XX_VFD_CNTL_0					0x0000a000
#define A6XX_VFD_CNTL_0_FETCH_CNT__MASK				0x0000003full
#define A6XX_VFD_CNTL_0_FETCH_CNT__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VFD_CNTL_0_FETCH_CNT(uint32_t val)
{
	return ((val) << A6XX_VFD_CNTL_0_FETCH_CNT__SHIFT) & A6XX_VFD_CNTL_0_FETCH_CNT__MASK;
}
#define A6XX_VFD_CNTL_0_DECODE_CNT__MASK			0x00003f00ull
#define A6XX_VFD_CNTL_0_DECODE_CNT__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_VFD_CNTL_0_DECODE_CNT(uint32_t val)
{
	return ((val) << A6XX_VFD_CNTL_0_DECODE_CNT__SHIFT) & A6XX_VFD_CNTL_0_DECODE_CNT__MASK;
}


#define REG_A6XX_VFD_CNTL_1					0x0000a001
#define A6XX_VFD_CNTL_1_REGID4VTX__MASK				0x000000ffull
#define A6XX_VFD_CNTL_1_REGID4VTX__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VFD_CNTL_1_REGID4VTX(uint32_t val)
{
	return ((val) << A6XX_VFD_CNTL_1_REGID4VTX__SHIFT) & A6XX_VFD_CNTL_1_REGID4VTX__MASK;
}
#define A6XX_VFD_CNTL_1_REGID4INST__MASK			0x0000ff00ull
#define A6XX_VFD_CNTL_1_REGID4INST__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_VFD_CNTL_1_REGID4INST(uint32_t val)
{
	return ((val) << A6XX_VFD_CNTL_1_REGID4INST__SHIFT) & A6XX_VFD_CNTL_1_REGID4INST__MASK;
}
#define A6XX_VFD_CNTL_1_REGID4PRIMID__MASK			0x00ff0000ull
#define A6XX_VFD_CNTL_1_REGID4PRIMID__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_VFD_CNTL_1_REGID4PRIMID(uint32_t val)
{
	return ((val) << A6XX_VFD_CNTL_1_REGID4PRIMID__SHIFT) & A6XX_VFD_CNTL_1_REGID4PRIMID__MASK;
}
#define A6XX_VFD_CNTL_1_REGID4VIEWID__MASK			0xff000000ull
#define A6XX_VFD_CNTL_1_REGID4VIEWID__SHIFT			24
static CONSTEXPR inline uint32_t A6XX_VFD_CNTL_1_REGID4VIEWID(uint32_t val)
{
	return ((val) << A6XX_VFD_CNTL_1_REGID4VIEWID__SHIFT) & A6XX_VFD_CNTL_1_REGID4VIEWID__MASK;
}


#define REG_A6XX_VFD_CNTL_2					0x0000a002
#define A6XX_VFD_CNTL_2_REGID_HSRELPATCHID__MASK		0x000000ffull
#define A6XX_VFD_CNTL_2_REGID_HSRELPATCHID__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_VFD_CNTL_2_REGID_HSRELPATCHID(uint32_t val)
{
	return ((val) << A6XX_VFD_CNTL_2_REGID_HSRELPATCHID__SHIFT) & A6XX_VFD_CNTL_2_REGID_HSRELPATCHID__MASK;
}
#define A6XX_VFD_CNTL_2_REGID_INVOCATIONID__MASK		0x0000ff00ull
#define A6XX_VFD_CNTL_2_REGID_INVOCATIONID__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_VFD_CNTL_2_REGID_INVOCATIONID(uint32_t val)
{
	return ((val) << A6XX_VFD_CNTL_2_REGID_INVOCATIONID__SHIFT) & A6XX_VFD_CNTL_2_REGID_INVOCATIONID__MASK;
}


#define REG_A6XX_VFD_CNTL_3					0x0000a003
#define A6XX_VFD_CNTL_3_REGID_DSPRIMID__MASK			0x000000ffull
#define A6XX_VFD_CNTL_3_REGID_DSPRIMID__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VFD_CNTL_3_REGID_DSPRIMID(uint32_t val)
{
	return ((val) << A6XX_VFD_CNTL_3_REGID_DSPRIMID__SHIFT) & A6XX_VFD_CNTL_3_REGID_DSPRIMID__MASK;
}
#define A6XX_VFD_CNTL_3_REGID_DSRELPATCHID__MASK		0x0000ff00ull
#define A6XX_VFD_CNTL_3_REGID_DSRELPATCHID__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_VFD_CNTL_3_REGID_DSRELPATCHID(uint32_t val)
{
	return ((val) << A6XX_VFD_CNTL_3_REGID_DSRELPATCHID__SHIFT) & A6XX_VFD_CNTL_3_REGID_DSRELPATCHID__MASK;
}
#define A6XX_VFD_CNTL_3_REGID_TESSX__MASK			0x00ff0000ull
#define A6XX_VFD_CNTL_3_REGID_TESSX__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_VFD_CNTL_3_REGID_TESSX(uint32_t val)
{
	return ((val) << A6XX_VFD_CNTL_3_REGID_TESSX__SHIFT) & A6XX_VFD_CNTL_3_REGID_TESSX__MASK;
}
#define A6XX_VFD_CNTL_3_REGID_TESSY__MASK			0xff000000ull
#define A6XX_VFD_CNTL_3_REGID_TESSY__SHIFT			24
static CONSTEXPR inline uint32_t A6XX_VFD_CNTL_3_REGID_TESSY(uint32_t val)
{
	return ((val) << A6XX_VFD_CNTL_3_REGID_TESSY__SHIFT) & A6XX_VFD_CNTL_3_REGID_TESSY__MASK;
}


#define REG_A6XX_VFD_CNTL_4					0x0000a004
#define A6XX_VFD_CNTL_4_UNK0__MASK				0x000000ffull
#define A6XX_VFD_CNTL_4_UNK0__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_VFD_CNTL_4_UNK0(uint32_t val)
{
	return ((val) << A6XX_VFD_CNTL_4_UNK0__SHIFT) & A6XX_VFD_CNTL_4_UNK0__MASK;
}


#define REG_A6XX_VFD_CNTL_5					0x0000a005
#define A6XX_VFD_CNTL_5_REGID_GSHEADER__MASK			0x000000ffull
#define A6XX_VFD_CNTL_5_REGID_GSHEADER__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VFD_CNTL_5_REGID_GSHEADER(uint32_t val)
{
	return ((val) << A6XX_VFD_CNTL_5_REGID_GSHEADER__SHIFT) & A6XX_VFD_CNTL_5_REGID_GSHEADER__MASK;
}
#define A6XX_VFD_CNTL_5_UNK8__MASK				0x0000ff00ull
#define A6XX_VFD_CNTL_5_UNK8__SHIFT				8
static CONSTEXPR inline uint32_t A6XX_VFD_CNTL_5_UNK8(uint32_t val)
{
	return ((val) << A6XX_VFD_CNTL_5_UNK8__SHIFT) & A6XX_VFD_CNTL_5_UNK8__MASK;
}


#define REG_A6XX_VFD_CNTL_6					0x0000a006
#define A6XX_VFD_CNTL_6_PRIMID4PSEN				0x00000001


#define REG_A6XX_VFD_RENDER_MODE				0x0000a007
#define A6XX_VFD_RENDER_MODE_RENDER_MODE__MASK			0x00000007ull
#define A6XX_VFD_RENDER_MODE_RENDER_MODE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VFD_RENDER_MODE_RENDER_MODE(enum a6xx_render_mode val)
{
	return ((val) << A6XX_VFD_RENDER_MODE_RENDER_MODE__SHIFT) & A6XX_VFD_RENDER_MODE_RENDER_MODE__MASK;
}


#define REG_A6XX_VFD_STEREO_RENDERING_CNTL			0x0000a008
#define A6XX_VFD_STEREO_RENDERING_CNTL_ENABLE			0x00000001
#define A6XX_VFD_STEREO_RENDERING_CNTL_DISABLEMULTIPOS		0x00000002
#define A6XX_VFD_STEREO_RENDERING_CNTL_VIEWS__MASK		0x0000007cull
#define A6XX_VFD_STEREO_RENDERING_CNTL_VIEWS__SHIFT		2
static CONSTEXPR inline uint32_t A6XX_VFD_STEREO_RENDERING_CNTL_VIEWS(uint32_t val)
{
	return ((val) << A6XX_VFD_STEREO_RENDERING_CNTL_VIEWS__SHIFT) & A6XX_VFD_STEREO_RENDERING_CNTL_VIEWS__MASK;
}


#define REG_A6XX_VFD_MODE_CNTL					0x0000a009
#define A6XX_VFD_MODE_CNTL_VERTEX				0x00000001
#define A6XX_VFD_MODE_CNTL_INSTANCE				0x00000002


#define REG_A6XX_VFD_INDEX_OFFSET				0x0000a00e


#define REG_A6XX_VFD_INSTANCE_START_OFFSET			0x0000a00f


#define REG_A6XX_VFD_VERTEX_BUFFER(i0)				(0x0000a010 + 0x4*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_VFD_VERTEX_BUFFER_BASE(uint32_t i0) { return 0x0000a010 + 0x4*i0; }
static CONSTEXPR inline uint32_t A6XX_VFD_VERTEX_BUFFER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_VFD_VERTEX_BUFFER_BASE_HI(uint32_t val)
{
	return val;
}


static CONSTEXPR inline uint32_t REG_A6XX_VFD_VERTEX_BUFFER_SIZE(uint32_t i0) { return 0x0000a012 + 0x4*i0; }


static CONSTEXPR inline uint32_t REG_A6XX_VFD_VERTEX_BUFFER_STRIDE(uint32_t i0) { return 0x0000a013 + 0x4*i0; }


#define REG_A6XX_VFD_FETCH_INSTR(i0)				(0x0000a090 + 0x2*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_VFD_FETCH_INSTR_INSTR(uint32_t i0) { return 0x0000a090 + 0x2*i0; }
#define A6XX_VFD_FETCH_INSTR_INSTR_IDX__MASK			0x0000001full
#define A6XX_VFD_FETCH_INSTR_INSTR_IDX__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_VFD_FETCH_INSTR_INSTR_IDX(uint32_t val)
{
	return ((val) << A6XX_VFD_FETCH_INSTR_INSTR_IDX__SHIFT) & A6XX_VFD_FETCH_INSTR_INSTR_IDX__MASK;
}
#define A6XX_VFD_FETCH_INSTR_INSTR_OFFSET__MASK			0x0001ffe0ull
#define A6XX_VFD_FETCH_INSTR_INSTR_OFFSET__SHIFT		5
static CONSTEXPR inline uint32_t A6XX_VFD_FETCH_INSTR_INSTR_OFFSET(uint32_t val)
{
	return ((val) << A6XX_VFD_FETCH_INSTR_INSTR_OFFSET__SHIFT) & A6XX_VFD_FETCH_INSTR_INSTR_OFFSET__MASK;
}
#define A6XX_VFD_FETCH_INSTR_INSTR_INSTANCED			0x00020000
#define A6XX_VFD_FETCH_INSTR_INSTR_FORMAT__MASK			0x0ff00000ull
#define A6XX_VFD_FETCH_INSTR_INSTR_FORMAT__SHIFT		20
static CONSTEXPR inline uint32_t A6XX_VFD_FETCH_INSTR_INSTR_FORMAT(enum a6xx_format val)
{
	return ((val) << A6XX_VFD_FETCH_INSTR_INSTR_FORMAT__SHIFT) & A6XX_VFD_FETCH_INSTR_INSTR_FORMAT__MASK;
}
#define A6XX_VFD_FETCH_INSTR_INSTR_SWAP__MASK			0x30000000ull
#define A6XX_VFD_FETCH_INSTR_INSTR_SWAP__SHIFT			28
static CONSTEXPR inline uint32_t A6XX_VFD_FETCH_INSTR_INSTR_SWAP(enum a3xx_color_swap val)
{
	return ((val) << A6XX_VFD_FETCH_INSTR_INSTR_SWAP__SHIFT) & A6XX_VFD_FETCH_INSTR_INSTR_SWAP__MASK;
}
#define A6XX_VFD_FETCH_INSTR_INSTR_UNK30			0x40000000
#define A6XX_VFD_FETCH_INSTR_INSTR_FLOAT			0x80000000


static CONSTEXPR inline uint32_t REG_A6XX_VFD_FETCH_INSTR_STEP_RATE(uint32_t i0) { return 0x0000a091 + 0x2*i0; }


#define REG_A6XX_VFD_DEST_CNTL(i0)				(0x0000a0d0 + 0x1*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_VFD_DEST_CNTL_INSTR(uint32_t i0) { return 0x0000a0d0 + 0x1*i0; }
#define A6XX_VFD_DEST_CNTL_INSTR_WRITEMASK__MASK		0x0000000full
#define A6XX_VFD_DEST_CNTL_INSTR_WRITEMASK__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_VFD_DEST_CNTL_INSTR_WRITEMASK(uint32_t val)
{
	return ((val) << A6XX_VFD_DEST_CNTL_INSTR_WRITEMASK__SHIFT) & A6XX_VFD_DEST_CNTL_INSTR_WRITEMASK__MASK;
}
#define A6XX_VFD_DEST_CNTL_INSTR_REGID__MASK			0x00000ff0ull
#define A6XX_VFD_DEST_CNTL_INSTR_REGID__SHIFT			4
static CONSTEXPR inline uint32_t A6XX_VFD_DEST_CNTL_INSTR_REGID(uint32_t val)
{
	return ((val) << A6XX_VFD_DEST_CNTL_INSTR_REGID__SHIFT) & A6XX_VFD_DEST_CNTL_INSTR_REGID__MASK;
}


#define REG_A6XX_VFD_POWER_CNTL					__FD_DEPRECATED 0x0000a0f8


#define REG_A7XX_VFD_DBG_ECO_CNTL				__FD_DEPRECATED 0x0000a600


#define REG_A6XX_VFD_ADDR_MODE_CNTL				__FD_DEPRECATED 0x0000a601


#define REG_A6XX_VFD_PERFCTR_VFD_SEL(i0)			(0x0000a610 + 0x1*i0 )



#define REG_A7XX_VFD_PERFCTR_VFD_SEL(i0)			(0x0000a610 + 0x1*i0 )



#define REG_A8XX_VFD_CB_BV_THRESHOLD				__FD_DEPRECATED 0x0000a639


#define REG_A8XX_VFD_CB_BR_THRESHOLD				__FD_DEPRECATED 0x0000a63a


#define REG_A8XX_VFD_CB_BUSY_REQ_CNT				__FD_DEPRECATED 0x0000a63b


#define REG_A8XX_VFD_CB_LP_REQ_CNT				__FD_DEPRECATED 0x0000a63c


#define REG_A6XX_SP_VS_CNTL_0					0x0000a800
#define A6XX_SP_VS_CNTL_0_THREADMODE__MASK			0x00000001ull
#define A6XX_SP_VS_CNTL_0_THREADMODE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_VS_CNTL_0_THREADMODE(enum a3xx_threadmode val)
{
	return ((val) << A6XX_SP_VS_CNTL_0_THREADMODE__SHIFT) & A6XX_SP_VS_CNTL_0_THREADMODE__MASK;
}
#define A6XX_SP_VS_CNTL_0_HALFREGFOOTPRINT__MASK		0x0000007eull
#define A6XX_SP_VS_CNTL_0_HALFREGFOOTPRINT__SHIFT		1
static CONSTEXPR inline uint32_t A6XX_SP_VS_CNTL_0_HALFREGFOOTPRINT(uint32_t val)
{
	return ((val) << A6XX_SP_VS_CNTL_0_HALFREGFOOTPRINT__SHIFT) & A6XX_SP_VS_CNTL_0_HALFREGFOOTPRINT__MASK;
}
#define A6XX_SP_VS_CNTL_0_FULLREGFOOTPRINT__MASK		0x00001f80ull
#define A6XX_SP_VS_CNTL_0_FULLREGFOOTPRINT__SHIFT		7
static CONSTEXPR inline uint32_t A6XX_SP_VS_CNTL_0_FULLREGFOOTPRINT(uint32_t val)
{
	return ((val) << A6XX_SP_VS_CNTL_0_FULLREGFOOTPRINT__SHIFT) & A6XX_SP_VS_CNTL_0_FULLREGFOOTPRINT__MASK;
}
#define A6XX_SP_VS_CNTL_0_UNK13					0x00002000
#define A6XX_SP_VS_CNTL_0_BRANCHSTACK__MASK			0x000fc000ull
#define A6XX_SP_VS_CNTL_0_BRANCHSTACK__SHIFT			14
static CONSTEXPR inline uint32_t A6XX_SP_VS_CNTL_0_BRANCHSTACK(uint32_t val)
{
	return ((val) << A6XX_SP_VS_CNTL_0_BRANCHSTACK__SHIFT) & A6XX_SP_VS_CNTL_0_BRANCHSTACK__MASK;
}
#define A6XX_SP_VS_CNTL_0_FULLREGFOOTPRINT_LSB__MASK		0x08000000ull
#define A6XX_SP_VS_CNTL_0_FULLREGFOOTPRINT_LSB__SHIFT		27
static CONSTEXPR inline uint32_t A6XX_SP_VS_CNTL_0_FULLREGFOOTPRINT_LSB(uint32_t val)
{
	return ((val) << A6XX_SP_VS_CNTL_0_FULLREGFOOTPRINT_LSB__SHIFT) & A6XX_SP_VS_CNTL_0_FULLREGFOOTPRINT_LSB__MASK;
}
#define A6XX_SP_VS_CNTL_0_HALFREGFOOTPRINT_LSB__MASK		0x40000000ull
#define A6XX_SP_VS_CNTL_0_HALFREGFOOTPRINT_LSB__SHIFT		30
static CONSTEXPR inline uint32_t A6XX_SP_VS_CNTL_0_HALFREGFOOTPRINT_LSB(uint32_t val)
{
	return ((val) << A6XX_SP_VS_CNTL_0_HALFREGFOOTPRINT_LSB__SHIFT) & A6XX_SP_VS_CNTL_0_HALFREGFOOTPRINT_LSB__MASK;
}
#define A6XX_SP_VS_CNTL_0_MERGEDREGS				0x00100000
#define A6XX_SP_VS_CNTL_0_EARLYPREAMBLE				0x00200000


#define REG_A6XX_SP_VS_BOOLEAN_CF_MASK				0x0000a801


#define REG_A6XX_SP_VS_OUTPUT_CNTL				0x0000a802
#define A6XX_SP_VS_OUTPUT_CNTL_OUT__MASK			0x0000003full
#define A6XX_SP_VS_OUTPUT_CNTL_OUT__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_VS_OUTPUT_CNTL_OUT(uint32_t val)
{
	return ((val) << A6XX_SP_VS_OUTPUT_CNTL_OUT__SHIFT) & A6XX_SP_VS_OUTPUT_CNTL_OUT__MASK;
}


#define REG_A6XX_SP_VS_OUTPUT(i0)				(0x0000a803 + 0x1*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_SP_VS_OUTPUT_REG(uint32_t i0) { return 0x0000a803 + 0x1*i0; }
#define A6XX_SP_VS_OUTPUT_REG_A_REGID__MASK			0x000000ffull
#define A6XX_SP_VS_OUTPUT_REG_A_REGID__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_VS_OUTPUT_REG_A_REGID(uint32_t val)
{
	return ((val) << A6XX_SP_VS_OUTPUT_REG_A_REGID__SHIFT) & A6XX_SP_VS_OUTPUT_REG_A_REGID__MASK;
}
#define A6XX_SP_VS_OUTPUT_REG_A_COMPMASK__MASK			0x00000f00ull
#define A6XX_SP_VS_OUTPUT_REG_A_COMPMASK__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_SP_VS_OUTPUT_REG_A_COMPMASK(uint32_t val)
{
	return ((val) << A6XX_SP_VS_OUTPUT_REG_A_COMPMASK__SHIFT) & A6XX_SP_VS_OUTPUT_REG_A_COMPMASK__MASK;
}
#define A6XX_SP_VS_OUTPUT_REG_B_REGID__MASK			0x00ff0000ull
#define A6XX_SP_VS_OUTPUT_REG_B_REGID__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_SP_VS_OUTPUT_REG_B_REGID(uint32_t val)
{
	return ((val) << A6XX_SP_VS_OUTPUT_REG_B_REGID__SHIFT) & A6XX_SP_VS_OUTPUT_REG_B_REGID__MASK;
}
#define A6XX_SP_VS_OUTPUT_REG_B_COMPMASK__MASK			0x0f000000ull
#define A6XX_SP_VS_OUTPUT_REG_B_COMPMASK__SHIFT			24
static CONSTEXPR inline uint32_t A6XX_SP_VS_OUTPUT_REG_B_COMPMASK(uint32_t val)
{
	return ((val) << A6XX_SP_VS_OUTPUT_REG_B_COMPMASK__SHIFT) & A6XX_SP_VS_OUTPUT_REG_B_COMPMASK__MASK;
}


#define REG_A6XX_SP_VS_VPC_DEST(i0)				(0x0000a813 + 0x1*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_SP_VS_VPC_DEST_REG(uint32_t i0) { return 0x0000a813 + 0x1*i0; }
#define A6XX_SP_VS_VPC_DEST_REG_OUTLOC0__MASK			0x000000ffull
#define A6XX_SP_VS_VPC_DEST_REG_OUTLOC0__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_VS_VPC_DEST_REG_OUTLOC0(uint32_t val)
{
	return ((val) << A6XX_SP_VS_VPC_DEST_REG_OUTLOC0__SHIFT) & A6XX_SP_VS_VPC_DEST_REG_OUTLOC0__MASK;
}
#define A6XX_SP_VS_VPC_DEST_REG_OUTLOC1__MASK			0x0000ff00ull
#define A6XX_SP_VS_VPC_DEST_REG_OUTLOC1__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_SP_VS_VPC_DEST_REG_OUTLOC1(uint32_t val)
{
	return ((val) << A6XX_SP_VS_VPC_DEST_REG_OUTLOC1__SHIFT) & A6XX_SP_VS_VPC_DEST_REG_OUTLOC1__MASK;
}
#define A6XX_SP_VS_VPC_DEST_REG_OUTLOC2__MASK			0x00ff0000ull
#define A6XX_SP_VS_VPC_DEST_REG_OUTLOC2__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_SP_VS_VPC_DEST_REG_OUTLOC2(uint32_t val)
{
	return ((val) << A6XX_SP_VS_VPC_DEST_REG_OUTLOC2__SHIFT) & A6XX_SP_VS_VPC_DEST_REG_OUTLOC2__MASK;
}
#define A6XX_SP_VS_VPC_DEST_REG_OUTLOC3__MASK			0xff000000ull
#define A6XX_SP_VS_VPC_DEST_REG_OUTLOC3__SHIFT			24
static CONSTEXPR inline uint32_t A6XX_SP_VS_VPC_DEST_REG_OUTLOC3(uint32_t val)
{
	return ((val) << A6XX_SP_VS_VPC_DEST_REG_OUTLOC3__SHIFT) & A6XX_SP_VS_VPC_DEST_REG_OUTLOC3__MASK;
}


#define REG_A6XX_SP_VS_PROGRAM_COUNTER_OFFSET			0x0000a81b


#define REG_A6XX_SP_VS_BASE					0x0000a81c
static CONSTEXPR inline uint32_t A6XX_SP_VS_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_VS_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_VS_PVT_MEM_PARAM				0x0000a81e
#define A6XX_SP_VS_PVT_MEM_PARAM_MEMSIZEPERITEM__MASK		0x000000ffull
#define A6XX_SP_VS_PVT_MEM_PARAM_MEMSIZEPERITEM__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_VS_PVT_MEM_PARAM_MEMSIZEPERITEM(uint32_t val)
{
	assert(!(val & 0x1ff));
	return (((val >> 9)) << A6XX_SP_VS_PVT_MEM_PARAM_MEMSIZEPERITEM__SHIFT) & A6XX_SP_VS_PVT_MEM_PARAM_MEMSIZEPERITEM__MASK;
}
#define A6XX_SP_VS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__MASK	0xff000000ull
#define A6XX_SP_VS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__SHIFT	24
static CONSTEXPR inline uint32_t A6XX_SP_VS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD(uint32_t val)
{
	return ((val) << A6XX_SP_VS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__SHIFT) & A6XX_SP_VS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__MASK;
}


#define REG_A6XX_SP_VS_PVT_MEM_BASE				0x0000a81f
static CONSTEXPR inline uint32_t A6XX_SP_VS_PVT_MEM_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_VS_PVT_MEM_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_VS_PVT_MEM_SIZE				0x0000a821
#define A6XX_SP_VS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__MASK		0x0003ffffull
#define A6XX_SP_VS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_VS_PVT_MEM_SIZE_TOTALPVTMEMSIZE(uint32_t val)
{
	assert(!(val & 0xfff));
	return (((val >> 12)) << A6XX_SP_VS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__SHIFT) & A6XX_SP_VS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__MASK;
}
#define A6XX_SP_VS_PVT_MEM_SIZE_PERWAVEMEMLAYOUT		0x80000000


#define REG_A6XX_SP_VS_TSIZE					0x0000a822


#define REG_A6XX_SP_VS_CONFIG					0x0000a823
#define A6XX_SP_VS_CONFIG_BINDLESS_TEX				0x00000001
#define A6XX_SP_VS_CONFIG_BINDLESS_SAMP				0x00000002
#define A6XX_SP_VS_CONFIG_BINDLESS_UAV				0x00000004
#define A6XX_SP_VS_CONFIG_BINDLESS_UBO				0x00000008
#define A6XX_SP_VS_CONFIG_ENABLED				0x00000100
#define A6XX_SP_VS_CONFIG_NTEX__MASK				0x0001fe00ull
#define A6XX_SP_VS_CONFIG_NTEX__SHIFT				9
static CONSTEXPR inline uint32_t A6XX_SP_VS_CONFIG_NTEX(uint32_t val)
{
	return ((val) << A6XX_SP_VS_CONFIG_NTEX__SHIFT) & A6XX_SP_VS_CONFIG_NTEX__MASK;
}
#define A6XX_SP_VS_CONFIG_NSAMP__MASK				0x003e0000ull
#define A6XX_SP_VS_CONFIG_NSAMP__SHIFT				17
static CONSTEXPR inline uint32_t A6XX_SP_VS_CONFIG_NSAMP(uint32_t val)
{
	return ((val) << A6XX_SP_VS_CONFIG_NSAMP__SHIFT) & A6XX_SP_VS_CONFIG_NSAMP__MASK;
}
#define A6XX_SP_VS_CONFIG_NUAV__MASK				0x1fc00000ull
#define A6XX_SP_VS_CONFIG_NUAV__SHIFT				22
static CONSTEXPR inline uint32_t A6XX_SP_VS_CONFIG_NUAV(uint32_t val)
{
	return ((val) << A6XX_SP_VS_CONFIG_NUAV__SHIFT) & A6XX_SP_VS_CONFIG_NUAV__MASK;
}


#define REG_A6XX_SP_VS_INSTR_SIZE				0x0000a824


#define REG_A6XX_SP_VS_PVT_MEM_STACK_OFFSET			0x0000a825
#define A6XX_SP_VS_PVT_MEM_STACK_OFFSET_OFFSET__MASK		0x0007ffffull
#define A6XX_SP_VS_PVT_MEM_STACK_OFFSET_OFFSET__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_VS_PVT_MEM_STACK_OFFSET_OFFSET(uint32_t val)
{
	assert(!(val & 0x7ff));
	return (((val >> 11)) << A6XX_SP_VS_PVT_MEM_STACK_OFFSET_OFFSET__SHIFT) & A6XX_SP_VS_PVT_MEM_STACK_OFFSET_OFFSET__MASK;
}


#define REG_A6XX_SP_VS_HYSTERESIS				__FD_DEPRECATED 0x0000a826


#define REG_A8XX_SP_VS_HYSTERESIS				__FD_DEPRECATED 0x0000a826


#define REG_A7XX_SP_VS_VGS_CNTL					__FD_DEPRECATED 0x0000a82d


#define REG_A6XX_SP_HS_CNTL_0					0x0000a830
#define A6XX_SP_HS_CNTL_0_THREADMODE__MASK			0x00000001ull
#define A6XX_SP_HS_CNTL_0_THREADMODE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_HS_CNTL_0_THREADMODE(enum a3xx_threadmode val)
{
	return ((val) << A6XX_SP_HS_CNTL_0_THREADMODE__SHIFT) & A6XX_SP_HS_CNTL_0_THREADMODE__MASK;
}
#define A6XX_SP_HS_CNTL_0_HALFREGFOOTPRINT__MASK		0x0000007eull
#define A6XX_SP_HS_CNTL_0_HALFREGFOOTPRINT__SHIFT		1
static CONSTEXPR inline uint32_t A6XX_SP_HS_CNTL_0_HALFREGFOOTPRINT(uint32_t val)
{
	return ((val) << A6XX_SP_HS_CNTL_0_HALFREGFOOTPRINT__SHIFT) & A6XX_SP_HS_CNTL_0_HALFREGFOOTPRINT__MASK;
}
#define A6XX_SP_HS_CNTL_0_FULLREGFOOTPRINT__MASK		0x00001f80ull
#define A6XX_SP_HS_CNTL_0_FULLREGFOOTPRINT__SHIFT		7
static CONSTEXPR inline uint32_t A6XX_SP_HS_CNTL_0_FULLREGFOOTPRINT(uint32_t val)
{
	return ((val) << A6XX_SP_HS_CNTL_0_FULLREGFOOTPRINT__SHIFT) & A6XX_SP_HS_CNTL_0_FULLREGFOOTPRINT__MASK;
}
#define A6XX_SP_HS_CNTL_0_UNK13					0x00002000
#define A6XX_SP_HS_CNTL_0_BRANCHSTACK__MASK			0x000fc000ull
#define A6XX_SP_HS_CNTL_0_BRANCHSTACK__SHIFT			14
static CONSTEXPR inline uint32_t A6XX_SP_HS_CNTL_0_BRANCHSTACK(uint32_t val)
{
	return ((val) << A6XX_SP_HS_CNTL_0_BRANCHSTACK__SHIFT) & A6XX_SP_HS_CNTL_0_BRANCHSTACK__MASK;
}
#define A6XX_SP_HS_CNTL_0_FULLREGFOOTPRINT_LSB__MASK		0x08000000ull
#define A6XX_SP_HS_CNTL_0_FULLREGFOOTPRINT_LSB__SHIFT		27
static CONSTEXPR inline uint32_t A6XX_SP_HS_CNTL_0_FULLREGFOOTPRINT_LSB(uint32_t val)
{
	return ((val) << A6XX_SP_HS_CNTL_0_FULLREGFOOTPRINT_LSB__SHIFT) & A6XX_SP_HS_CNTL_0_FULLREGFOOTPRINT_LSB__MASK;
}
#define A6XX_SP_HS_CNTL_0_HALFREGFOOTPRINT_LSB__MASK		0x40000000ull
#define A6XX_SP_HS_CNTL_0_HALFREGFOOTPRINT_LSB__SHIFT		30
static CONSTEXPR inline uint32_t A6XX_SP_HS_CNTL_0_HALFREGFOOTPRINT_LSB(uint32_t val)
{
	return ((val) << A6XX_SP_HS_CNTL_0_HALFREGFOOTPRINT_LSB__SHIFT) & A6XX_SP_HS_CNTL_0_HALFREGFOOTPRINT_LSB__MASK;
}
#define A6XX_SP_HS_CNTL_0_EARLYPREAMBLE				0x00100000


#define REG_A6XX_SP_HS_CNTL_1					0x0000a831


#define REG_A6XX_SP_HS_BOOLEAN_CF_MASK				0x0000a832


#define REG_A6XX_SP_HS_PROGRAM_COUNTER_OFFSET			0x0000a833


#define REG_A6XX_SP_HS_BASE					0x0000a834
static CONSTEXPR inline uint32_t A6XX_SP_HS_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_HS_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_HS_PVT_MEM_PARAM				0x0000a836
#define A6XX_SP_HS_PVT_MEM_PARAM_MEMSIZEPERITEM__MASK		0x000000ffull
#define A6XX_SP_HS_PVT_MEM_PARAM_MEMSIZEPERITEM__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_HS_PVT_MEM_PARAM_MEMSIZEPERITEM(uint32_t val)
{
	assert(!(val & 0x1ff));
	return (((val >> 9)) << A6XX_SP_HS_PVT_MEM_PARAM_MEMSIZEPERITEM__SHIFT) & A6XX_SP_HS_PVT_MEM_PARAM_MEMSIZEPERITEM__MASK;
}
#define A6XX_SP_HS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__MASK	0xff000000ull
#define A6XX_SP_HS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__SHIFT	24
static CONSTEXPR inline uint32_t A6XX_SP_HS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD(uint32_t val)
{
	return ((val) << A6XX_SP_HS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__SHIFT) & A6XX_SP_HS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__MASK;
}


#define REG_A6XX_SP_HS_PVT_MEM_BASE				0x0000a837
static CONSTEXPR inline uint32_t A6XX_SP_HS_PVT_MEM_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_HS_PVT_MEM_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_HS_PVT_MEM_SIZE				0x0000a839
#define A6XX_SP_HS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__MASK		0x0003ffffull
#define A6XX_SP_HS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_HS_PVT_MEM_SIZE_TOTALPVTMEMSIZE(uint32_t val)
{
	assert(!(val & 0xfff));
	return (((val >> 12)) << A6XX_SP_HS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__SHIFT) & A6XX_SP_HS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__MASK;
}
#define A6XX_SP_HS_PVT_MEM_SIZE_PERWAVEMEMLAYOUT		0x80000000


#define REG_A6XX_SP_HS_TSIZE					0x0000a83a


#define REG_A6XX_SP_HS_CONFIG					0x0000a83b
#define A6XX_SP_HS_CONFIG_BINDLESS_TEX				0x00000001
#define A6XX_SP_HS_CONFIG_BINDLESS_SAMP				0x00000002
#define A6XX_SP_HS_CONFIG_BINDLESS_UAV				0x00000004
#define A6XX_SP_HS_CONFIG_BINDLESS_UBO				0x00000008
#define A6XX_SP_HS_CONFIG_ENABLED				0x00000100
#define A6XX_SP_HS_CONFIG_NTEX__MASK				0x0001fe00ull
#define A6XX_SP_HS_CONFIG_NTEX__SHIFT				9
static CONSTEXPR inline uint32_t A6XX_SP_HS_CONFIG_NTEX(uint32_t val)
{
	return ((val) << A6XX_SP_HS_CONFIG_NTEX__SHIFT) & A6XX_SP_HS_CONFIG_NTEX__MASK;
}
#define A6XX_SP_HS_CONFIG_NSAMP__MASK				0x003e0000ull
#define A6XX_SP_HS_CONFIG_NSAMP__SHIFT				17
static CONSTEXPR inline uint32_t A6XX_SP_HS_CONFIG_NSAMP(uint32_t val)
{
	return ((val) << A6XX_SP_HS_CONFIG_NSAMP__SHIFT) & A6XX_SP_HS_CONFIG_NSAMP__MASK;
}
#define A6XX_SP_HS_CONFIG_NUAV__MASK				0x1fc00000ull
#define A6XX_SP_HS_CONFIG_NUAV__SHIFT				22
static CONSTEXPR inline uint32_t A6XX_SP_HS_CONFIG_NUAV(uint32_t val)
{
	return ((val) << A6XX_SP_HS_CONFIG_NUAV__SHIFT) & A6XX_SP_HS_CONFIG_NUAV__MASK;
}


#define REG_A6XX_SP_HS_INSTR_SIZE				0x0000a83c


#define REG_A6XX_SP_HS_PVT_MEM_STACK_OFFSET			0x0000a83d
#define A6XX_SP_HS_PVT_MEM_STACK_OFFSET_OFFSET__MASK		0x0007ffffull
#define A6XX_SP_HS_PVT_MEM_STACK_OFFSET_OFFSET__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_HS_PVT_MEM_STACK_OFFSET_OFFSET(uint32_t val)
{
	assert(!(val & 0x7ff));
	return (((val >> 11)) << A6XX_SP_HS_PVT_MEM_STACK_OFFSET_OFFSET__SHIFT) & A6XX_SP_HS_PVT_MEM_STACK_OFFSET_OFFSET__MASK;
}


#define REG_A6XX_SP_HS_HYSTERESIS				__FD_DEPRECATED 0x0000a83e


#define REG_A8XX_SP_HS_HYSTERESIS				__FD_DEPRECATED 0x0000a83e


#define REG_A7XX_SP_HS_VGS_CNTL					__FD_DEPRECATED 0x0000a82f


#define REG_A6XX_SP_DS_CNTL_0					0x0000a840
#define A6XX_SP_DS_CNTL_0_THREADMODE__MASK			0x00000001ull
#define A6XX_SP_DS_CNTL_0_THREADMODE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_DS_CNTL_0_THREADMODE(enum a3xx_threadmode val)
{
	return ((val) << A6XX_SP_DS_CNTL_0_THREADMODE__SHIFT) & A6XX_SP_DS_CNTL_0_THREADMODE__MASK;
}
#define A6XX_SP_DS_CNTL_0_HALFREGFOOTPRINT__MASK		0x0000007eull
#define A6XX_SP_DS_CNTL_0_HALFREGFOOTPRINT__SHIFT		1
static CONSTEXPR inline uint32_t A6XX_SP_DS_CNTL_0_HALFREGFOOTPRINT(uint32_t val)
{
	return ((val) << A6XX_SP_DS_CNTL_0_HALFREGFOOTPRINT__SHIFT) & A6XX_SP_DS_CNTL_0_HALFREGFOOTPRINT__MASK;
}
#define A6XX_SP_DS_CNTL_0_FULLREGFOOTPRINT__MASK		0x00001f80ull
#define A6XX_SP_DS_CNTL_0_FULLREGFOOTPRINT__SHIFT		7
static CONSTEXPR inline uint32_t A6XX_SP_DS_CNTL_0_FULLREGFOOTPRINT(uint32_t val)
{
	return ((val) << A6XX_SP_DS_CNTL_0_FULLREGFOOTPRINT__SHIFT) & A6XX_SP_DS_CNTL_0_FULLREGFOOTPRINT__MASK;
}
#define A6XX_SP_DS_CNTL_0_UNK13					0x00002000
#define A6XX_SP_DS_CNTL_0_BRANCHSTACK__MASK			0x000fc000ull
#define A6XX_SP_DS_CNTL_0_BRANCHSTACK__SHIFT			14
static CONSTEXPR inline uint32_t A6XX_SP_DS_CNTL_0_BRANCHSTACK(uint32_t val)
{
	return ((val) << A6XX_SP_DS_CNTL_0_BRANCHSTACK__SHIFT) & A6XX_SP_DS_CNTL_0_BRANCHSTACK__MASK;
}
#define A6XX_SP_DS_CNTL_0_FULLREGFOOTPRINT_LSB__MASK		0x08000000ull
#define A6XX_SP_DS_CNTL_0_FULLREGFOOTPRINT_LSB__SHIFT		27
static CONSTEXPR inline uint32_t A6XX_SP_DS_CNTL_0_FULLREGFOOTPRINT_LSB(uint32_t val)
{
	return ((val) << A6XX_SP_DS_CNTL_0_FULLREGFOOTPRINT_LSB__SHIFT) & A6XX_SP_DS_CNTL_0_FULLREGFOOTPRINT_LSB__MASK;
}
#define A6XX_SP_DS_CNTL_0_HALFREGFOOTPRINT_LSB__MASK		0x40000000ull
#define A6XX_SP_DS_CNTL_0_HALFREGFOOTPRINT_LSB__SHIFT		30
static CONSTEXPR inline uint32_t A6XX_SP_DS_CNTL_0_HALFREGFOOTPRINT_LSB(uint32_t val)
{
	return ((val) << A6XX_SP_DS_CNTL_0_HALFREGFOOTPRINT_LSB__SHIFT) & A6XX_SP_DS_CNTL_0_HALFREGFOOTPRINT_LSB__MASK;
}
#define A6XX_SP_DS_CNTL_0_EARLYPREAMBLE				0x00100000


#define REG_A6XX_SP_DS_BOOLEAN_CF_MASK				0x0000a841


#define REG_A6XX_SP_DS_OUTPUT_CNTL				0x0000a842
#define A6XX_SP_DS_OUTPUT_CNTL_OUT__MASK			0x0000003full
#define A6XX_SP_DS_OUTPUT_CNTL_OUT__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_DS_OUTPUT_CNTL_OUT(uint32_t val)
{
	return ((val) << A6XX_SP_DS_OUTPUT_CNTL_OUT__SHIFT) & A6XX_SP_DS_OUTPUT_CNTL_OUT__MASK;
}


#define REG_A6XX_SP_DS_OUTPUT(i0)				(0x0000a843 + 0x1*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_SP_DS_OUTPUT_REG(uint32_t i0) { return 0x0000a843 + 0x1*i0; }
#define A6XX_SP_DS_OUTPUT_REG_A_REGID__MASK			0x000000ffull
#define A6XX_SP_DS_OUTPUT_REG_A_REGID__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_DS_OUTPUT_REG_A_REGID(uint32_t val)
{
	return ((val) << A6XX_SP_DS_OUTPUT_REG_A_REGID__SHIFT) & A6XX_SP_DS_OUTPUT_REG_A_REGID__MASK;
}
#define A6XX_SP_DS_OUTPUT_REG_A_COMPMASK__MASK			0x00000f00ull
#define A6XX_SP_DS_OUTPUT_REG_A_COMPMASK__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_SP_DS_OUTPUT_REG_A_COMPMASK(uint32_t val)
{
	return ((val) << A6XX_SP_DS_OUTPUT_REG_A_COMPMASK__SHIFT) & A6XX_SP_DS_OUTPUT_REG_A_COMPMASK__MASK;
}
#define A6XX_SP_DS_OUTPUT_REG_B_REGID__MASK			0x00ff0000ull
#define A6XX_SP_DS_OUTPUT_REG_B_REGID__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_SP_DS_OUTPUT_REG_B_REGID(uint32_t val)
{
	return ((val) << A6XX_SP_DS_OUTPUT_REG_B_REGID__SHIFT) & A6XX_SP_DS_OUTPUT_REG_B_REGID__MASK;
}
#define A6XX_SP_DS_OUTPUT_REG_B_COMPMASK__MASK			0x0f000000ull
#define A6XX_SP_DS_OUTPUT_REG_B_COMPMASK__SHIFT			24
static CONSTEXPR inline uint32_t A6XX_SP_DS_OUTPUT_REG_B_COMPMASK(uint32_t val)
{
	return ((val) << A6XX_SP_DS_OUTPUT_REG_B_COMPMASK__SHIFT) & A6XX_SP_DS_OUTPUT_REG_B_COMPMASK__MASK;
}


#define REG_A6XX_SP_DS_VPC_DEST(i0)				(0x0000a853 + 0x1*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_SP_DS_VPC_DEST_REG(uint32_t i0) { return 0x0000a853 + 0x1*i0; }
#define A6XX_SP_DS_VPC_DEST_REG_OUTLOC0__MASK			0x000000ffull
#define A6XX_SP_DS_VPC_DEST_REG_OUTLOC0__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_DS_VPC_DEST_REG_OUTLOC0(uint32_t val)
{
	return ((val) << A6XX_SP_DS_VPC_DEST_REG_OUTLOC0__SHIFT) & A6XX_SP_DS_VPC_DEST_REG_OUTLOC0__MASK;
}
#define A6XX_SP_DS_VPC_DEST_REG_OUTLOC1__MASK			0x0000ff00ull
#define A6XX_SP_DS_VPC_DEST_REG_OUTLOC1__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_SP_DS_VPC_DEST_REG_OUTLOC1(uint32_t val)
{
	return ((val) << A6XX_SP_DS_VPC_DEST_REG_OUTLOC1__SHIFT) & A6XX_SP_DS_VPC_DEST_REG_OUTLOC1__MASK;
}
#define A6XX_SP_DS_VPC_DEST_REG_OUTLOC2__MASK			0x00ff0000ull
#define A6XX_SP_DS_VPC_DEST_REG_OUTLOC2__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_SP_DS_VPC_DEST_REG_OUTLOC2(uint32_t val)
{
	return ((val) << A6XX_SP_DS_VPC_DEST_REG_OUTLOC2__SHIFT) & A6XX_SP_DS_VPC_DEST_REG_OUTLOC2__MASK;
}
#define A6XX_SP_DS_VPC_DEST_REG_OUTLOC3__MASK			0xff000000ull
#define A6XX_SP_DS_VPC_DEST_REG_OUTLOC3__SHIFT			24
static CONSTEXPR inline uint32_t A6XX_SP_DS_VPC_DEST_REG_OUTLOC3(uint32_t val)
{
	return ((val) << A6XX_SP_DS_VPC_DEST_REG_OUTLOC3__SHIFT) & A6XX_SP_DS_VPC_DEST_REG_OUTLOC3__MASK;
}


#define REG_A6XX_SP_DS_PROGRAM_COUNTER_OFFSET			0x0000a85b


#define REG_A6XX_SP_DS_BASE					0x0000a85c
static CONSTEXPR inline uint32_t A6XX_SP_DS_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_DS_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_DS_PVT_MEM_PARAM				0x0000a85e
#define A6XX_SP_DS_PVT_MEM_PARAM_MEMSIZEPERITEM__MASK		0x000000ffull
#define A6XX_SP_DS_PVT_MEM_PARAM_MEMSIZEPERITEM__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_DS_PVT_MEM_PARAM_MEMSIZEPERITEM(uint32_t val)
{
	assert(!(val & 0x1ff));
	return (((val >> 9)) << A6XX_SP_DS_PVT_MEM_PARAM_MEMSIZEPERITEM__SHIFT) & A6XX_SP_DS_PVT_MEM_PARAM_MEMSIZEPERITEM__MASK;
}
#define A6XX_SP_DS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__MASK	0xff000000ull
#define A6XX_SP_DS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__SHIFT	24
static CONSTEXPR inline uint32_t A6XX_SP_DS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD(uint32_t val)
{
	return ((val) << A6XX_SP_DS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__SHIFT) & A6XX_SP_DS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__MASK;
}


#define REG_A6XX_SP_DS_PVT_MEM_BASE				0x0000a85f
static CONSTEXPR inline uint32_t A6XX_SP_DS_PVT_MEM_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_DS_PVT_MEM_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_DS_PVT_MEM_SIZE				0x0000a861
#define A6XX_SP_DS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__MASK		0x0003ffffull
#define A6XX_SP_DS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_DS_PVT_MEM_SIZE_TOTALPVTMEMSIZE(uint32_t val)
{
	assert(!(val & 0xfff));
	return (((val >> 12)) << A6XX_SP_DS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__SHIFT) & A6XX_SP_DS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__MASK;
}
#define A6XX_SP_DS_PVT_MEM_SIZE_PERWAVEMEMLAYOUT		0x80000000


#define REG_A6XX_SP_DS_TSIZE					0x0000a862


#define REG_A6XX_SP_DS_CONFIG					0x0000a863
#define A6XX_SP_DS_CONFIG_BINDLESS_TEX				0x00000001
#define A6XX_SP_DS_CONFIG_BINDLESS_SAMP				0x00000002
#define A6XX_SP_DS_CONFIG_BINDLESS_UAV				0x00000004
#define A6XX_SP_DS_CONFIG_BINDLESS_UBO				0x00000008
#define A6XX_SP_DS_CONFIG_ENABLED				0x00000100
#define A6XX_SP_DS_CONFIG_NTEX__MASK				0x0001fe00ull
#define A6XX_SP_DS_CONFIG_NTEX__SHIFT				9
static CONSTEXPR inline uint32_t A6XX_SP_DS_CONFIG_NTEX(uint32_t val)
{
	return ((val) << A6XX_SP_DS_CONFIG_NTEX__SHIFT) & A6XX_SP_DS_CONFIG_NTEX__MASK;
}
#define A6XX_SP_DS_CONFIG_NSAMP__MASK				0x003e0000ull
#define A6XX_SP_DS_CONFIG_NSAMP__SHIFT				17
static CONSTEXPR inline uint32_t A6XX_SP_DS_CONFIG_NSAMP(uint32_t val)
{
	return ((val) << A6XX_SP_DS_CONFIG_NSAMP__SHIFT) & A6XX_SP_DS_CONFIG_NSAMP__MASK;
}
#define A6XX_SP_DS_CONFIG_NUAV__MASK				0x1fc00000ull
#define A6XX_SP_DS_CONFIG_NUAV__SHIFT				22
static CONSTEXPR inline uint32_t A6XX_SP_DS_CONFIG_NUAV(uint32_t val)
{
	return ((val) << A6XX_SP_DS_CONFIG_NUAV__SHIFT) & A6XX_SP_DS_CONFIG_NUAV__MASK;
}


#define REG_A6XX_SP_DS_INSTR_SIZE				0x0000a864


#define REG_A6XX_SP_DS_PVT_MEM_STACK_OFFSET			0x0000a865
#define A6XX_SP_DS_PVT_MEM_STACK_OFFSET_OFFSET__MASK		0x0007ffffull
#define A6XX_SP_DS_PVT_MEM_STACK_OFFSET_OFFSET__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_DS_PVT_MEM_STACK_OFFSET_OFFSET(uint32_t val)
{
	assert(!(val & 0x7ff));
	return (((val >> 11)) << A6XX_SP_DS_PVT_MEM_STACK_OFFSET_OFFSET__SHIFT) & A6XX_SP_DS_PVT_MEM_STACK_OFFSET_OFFSET__MASK;
}


#define REG_A6XX_SP_DS_HYSTERESIS				__FD_DEPRECATED 0x0000a866


#define REG_A8XX_SP_DS_HYSTERESIS				__FD_DEPRECATED 0x0000a866


#define REG_A7XX_SP_DS_VGS_CNTL					__FD_DEPRECATED 0x0000a868


#define REG_A6XX_SP_GS_CNTL_0					0x0000a870
#define A6XX_SP_GS_CNTL_0_THREADMODE__MASK			0x00000001ull
#define A6XX_SP_GS_CNTL_0_THREADMODE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_GS_CNTL_0_THREADMODE(enum a3xx_threadmode val)
{
	return ((val) << A6XX_SP_GS_CNTL_0_THREADMODE__SHIFT) & A6XX_SP_GS_CNTL_0_THREADMODE__MASK;
}
#define A6XX_SP_GS_CNTL_0_HALFREGFOOTPRINT__MASK		0x0000007eull
#define A6XX_SP_GS_CNTL_0_HALFREGFOOTPRINT__SHIFT		1
static CONSTEXPR inline uint32_t A6XX_SP_GS_CNTL_0_HALFREGFOOTPRINT(uint32_t val)
{
	return ((val) << A6XX_SP_GS_CNTL_0_HALFREGFOOTPRINT__SHIFT) & A6XX_SP_GS_CNTL_0_HALFREGFOOTPRINT__MASK;
}
#define A6XX_SP_GS_CNTL_0_FULLREGFOOTPRINT__MASK		0x00001f80ull
#define A6XX_SP_GS_CNTL_0_FULLREGFOOTPRINT__SHIFT		7
static CONSTEXPR inline uint32_t A6XX_SP_GS_CNTL_0_FULLREGFOOTPRINT(uint32_t val)
{
	return ((val) << A6XX_SP_GS_CNTL_0_FULLREGFOOTPRINT__SHIFT) & A6XX_SP_GS_CNTL_0_FULLREGFOOTPRINT__MASK;
}
#define A6XX_SP_GS_CNTL_0_UNK13					0x00002000
#define A6XX_SP_GS_CNTL_0_BRANCHSTACK__MASK			0x000fc000ull
#define A6XX_SP_GS_CNTL_0_BRANCHSTACK__SHIFT			14
static CONSTEXPR inline uint32_t A6XX_SP_GS_CNTL_0_BRANCHSTACK(uint32_t val)
{
	return ((val) << A6XX_SP_GS_CNTL_0_BRANCHSTACK__SHIFT) & A6XX_SP_GS_CNTL_0_BRANCHSTACK__MASK;
}
#define A6XX_SP_GS_CNTL_0_FULLREGFOOTPRINT_LSB__MASK		0x08000000ull
#define A6XX_SP_GS_CNTL_0_FULLREGFOOTPRINT_LSB__SHIFT		27
static CONSTEXPR inline uint32_t A6XX_SP_GS_CNTL_0_FULLREGFOOTPRINT_LSB(uint32_t val)
{
	return ((val) << A6XX_SP_GS_CNTL_0_FULLREGFOOTPRINT_LSB__SHIFT) & A6XX_SP_GS_CNTL_0_FULLREGFOOTPRINT_LSB__MASK;
}
#define A6XX_SP_GS_CNTL_0_HALFREGFOOTPRINT_LSB__MASK		0x40000000ull
#define A6XX_SP_GS_CNTL_0_HALFREGFOOTPRINT_LSB__SHIFT		30
static CONSTEXPR inline uint32_t A6XX_SP_GS_CNTL_0_HALFREGFOOTPRINT_LSB(uint32_t val)
{
	return ((val) << A6XX_SP_GS_CNTL_0_HALFREGFOOTPRINT_LSB__SHIFT) & A6XX_SP_GS_CNTL_0_HALFREGFOOTPRINT_LSB__MASK;
}
#define A6XX_SP_GS_CNTL_0_EARLYPREAMBLE				0x00100000


#define REG_A6XX_SP_GS_CNTL_1					0x0000a871


#define REG_A6XX_SP_GS_BOOLEAN_CF_MASK				0x0000a872


#define REG_A6XX_SP_GS_OUTPUT_CNTL				0x0000a873
#define A6XX_SP_GS_OUTPUT_CNTL_OUT__MASK			0x0000003full
#define A6XX_SP_GS_OUTPUT_CNTL_OUT__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_GS_OUTPUT_CNTL_OUT(uint32_t val)
{
	return ((val) << A6XX_SP_GS_OUTPUT_CNTL_OUT__SHIFT) & A6XX_SP_GS_OUTPUT_CNTL_OUT__MASK;
}
#define A6XX_SP_GS_OUTPUT_CNTL_FLAGS_REGID__MASK		0x00003fc0ull
#define A6XX_SP_GS_OUTPUT_CNTL_FLAGS_REGID__SHIFT		6
static CONSTEXPR inline uint32_t A6XX_SP_GS_OUTPUT_CNTL_FLAGS_REGID(uint32_t val)
{
	return ((val) << A6XX_SP_GS_OUTPUT_CNTL_FLAGS_REGID__SHIFT) & A6XX_SP_GS_OUTPUT_CNTL_FLAGS_REGID__MASK;
}


#define REG_A6XX_SP_GS_OUTPUT(i0)				(0x0000a874 + 0x1*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_SP_GS_OUTPUT_REG(uint32_t i0) { return 0x0000a874 + 0x1*i0; }
#define A6XX_SP_GS_OUTPUT_REG_A_REGID__MASK			0x000000ffull
#define A6XX_SP_GS_OUTPUT_REG_A_REGID__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_GS_OUTPUT_REG_A_REGID(uint32_t val)
{
	return ((val) << A6XX_SP_GS_OUTPUT_REG_A_REGID__SHIFT) & A6XX_SP_GS_OUTPUT_REG_A_REGID__MASK;
}
#define A6XX_SP_GS_OUTPUT_REG_A_COMPMASK__MASK			0x00000f00ull
#define A6XX_SP_GS_OUTPUT_REG_A_COMPMASK__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_SP_GS_OUTPUT_REG_A_COMPMASK(uint32_t val)
{
	return ((val) << A6XX_SP_GS_OUTPUT_REG_A_COMPMASK__SHIFT) & A6XX_SP_GS_OUTPUT_REG_A_COMPMASK__MASK;
}
#define A6XX_SP_GS_OUTPUT_REG_B_REGID__MASK			0x00ff0000ull
#define A6XX_SP_GS_OUTPUT_REG_B_REGID__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_SP_GS_OUTPUT_REG_B_REGID(uint32_t val)
{
	return ((val) << A6XX_SP_GS_OUTPUT_REG_B_REGID__SHIFT) & A6XX_SP_GS_OUTPUT_REG_B_REGID__MASK;
}
#define A6XX_SP_GS_OUTPUT_REG_B_COMPMASK__MASK			0x0f000000ull
#define A6XX_SP_GS_OUTPUT_REG_B_COMPMASK__SHIFT			24
static CONSTEXPR inline uint32_t A6XX_SP_GS_OUTPUT_REG_B_COMPMASK(uint32_t val)
{
	return ((val) << A6XX_SP_GS_OUTPUT_REG_B_COMPMASK__SHIFT) & A6XX_SP_GS_OUTPUT_REG_B_COMPMASK__MASK;
}


#define REG_A6XX_SP_GS_VPC_DEST(i0)				(0x0000a884 + 0x1*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_SP_GS_VPC_DEST_REG(uint32_t i0) { return 0x0000a884 + 0x1*i0; }
#define A6XX_SP_GS_VPC_DEST_REG_OUTLOC0__MASK			0x000000ffull
#define A6XX_SP_GS_VPC_DEST_REG_OUTLOC0__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_GS_VPC_DEST_REG_OUTLOC0(uint32_t val)
{
	return ((val) << A6XX_SP_GS_VPC_DEST_REG_OUTLOC0__SHIFT) & A6XX_SP_GS_VPC_DEST_REG_OUTLOC0__MASK;
}
#define A6XX_SP_GS_VPC_DEST_REG_OUTLOC1__MASK			0x0000ff00ull
#define A6XX_SP_GS_VPC_DEST_REG_OUTLOC1__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_SP_GS_VPC_DEST_REG_OUTLOC1(uint32_t val)
{
	return ((val) << A6XX_SP_GS_VPC_DEST_REG_OUTLOC1__SHIFT) & A6XX_SP_GS_VPC_DEST_REG_OUTLOC1__MASK;
}
#define A6XX_SP_GS_VPC_DEST_REG_OUTLOC2__MASK			0x00ff0000ull
#define A6XX_SP_GS_VPC_DEST_REG_OUTLOC2__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_SP_GS_VPC_DEST_REG_OUTLOC2(uint32_t val)
{
	return ((val) << A6XX_SP_GS_VPC_DEST_REG_OUTLOC2__SHIFT) & A6XX_SP_GS_VPC_DEST_REG_OUTLOC2__MASK;
}
#define A6XX_SP_GS_VPC_DEST_REG_OUTLOC3__MASK			0xff000000ull
#define A6XX_SP_GS_VPC_DEST_REG_OUTLOC3__SHIFT			24
static CONSTEXPR inline uint32_t A6XX_SP_GS_VPC_DEST_REG_OUTLOC3(uint32_t val)
{
	return ((val) << A6XX_SP_GS_VPC_DEST_REG_OUTLOC3__SHIFT) & A6XX_SP_GS_VPC_DEST_REG_OUTLOC3__MASK;
}


#define REG_A6XX_SP_GS_PROGRAM_COUNTER_OFFSET			0x0000a88c


#define REG_A6XX_SP_GS_BASE					0x0000a88d
static CONSTEXPR inline uint32_t A6XX_SP_GS_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_GS_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_GS_PVT_MEM_PARAM				0x0000a88f
#define A6XX_SP_GS_PVT_MEM_PARAM_MEMSIZEPERITEM__MASK		0x000000ffull
#define A6XX_SP_GS_PVT_MEM_PARAM_MEMSIZEPERITEM__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_GS_PVT_MEM_PARAM_MEMSIZEPERITEM(uint32_t val)
{
	assert(!(val & 0x1ff));
	return (((val >> 9)) << A6XX_SP_GS_PVT_MEM_PARAM_MEMSIZEPERITEM__SHIFT) & A6XX_SP_GS_PVT_MEM_PARAM_MEMSIZEPERITEM__MASK;
}
#define A6XX_SP_GS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__MASK	0xff000000ull
#define A6XX_SP_GS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__SHIFT	24
static CONSTEXPR inline uint32_t A6XX_SP_GS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD(uint32_t val)
{
	return ((val) << A6XX_SP_GS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__SHIFT) & A6XX_SP_GS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__MASK;
}


#define REG_A6XX_SP_GS_PVT_MEM_BASE				0x0000a890
static CONSTEXPR inline uint32_t A6XX_SP_GS_PVT_MEM_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_GS_PVT_MEM_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_GS_PVT_MEM_SIZE				0x0000a892
#define A6XX_SP_GS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__MASK		0x0003ffffull
#define A6XX_SP_GS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_GS_PVT_MEM_SIZE_TOTALPVTMEMSIZE(uint32_t val)
{
	assert(!(val & 0xfff));
	return (((val >> 12)) << A6XX_SP_GS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__SHIFT) & A6XX_SP_GS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__MASK;
}
#define A6XX_SP_GS_PVT_MEM_SIZE_PERWAVEMEMLAYOUT		0x80000000


#define REG_A6XX_SP_GS_TSIZE					0x0000a893


#define REG_A6XX_SP_GS_CONFIG					0x0000a894
#define A6XX_SP_GS_CONFIG_BINDLESS_TEX				0x00000001
#define A6XX_SP_GS_CONFIG_BINDLESS_SAMP				0x00000002
#define A6XX_SP_GS_CONFIG_BINDLESS_UAV				0x00000004
#define A6XX_SP_GS_CONFIG_BINDLESS_UBO				0x00000008
#define A6XX_SP_GS_CONFIG_ENABLED				0x00000100
#define A6XX_SP_GS_CONFIG_NTEX__MASK				0x0001fe00ull
#define A6XX_SP_GS_CONFIG_NTEX__SHIFT				9
static CONSTEXPR inline uint32_t A6XX_SP_GS_CONFIG_NTEX(uint32_t val)
{
	return ((val) << A6XX_SP_GS_CONFIG_NTEX__SHIFT) & A6XX_SP_GS_CONFIG_NTEX__MASK;
}
#define A6XX_SP_GS_CONFIG_NSAMP__MASK				0x003e0000ull
#define A6XX_SP_GS_CONFIG_NSAMP__SHIFT				17
static CONSTEXPR inline uint32_t A6XX_SP_GS_CONFIG_NSAMP(uint32_t val)
{
	return ((val) << A6XX_SP_GS_CONFIG_NSAMP__SHIFT) & A6XX_SP_GS_CONFIG_NSAMP__MASK;
}
#define A6XX_SP_GS_CONFIG_NUAV__MASK				0x1fc00000ull
#define A6XX_SP_GS_CONFIG_NUAV__SHIFT				22
static CONSTEXPR inline uint32_t A6XX_SP_GS_CONFIG_NUAV(uint32_t val)
{
	return ((val) << A6XX_SP_GS_CONFIG_NUAV__SHIFT) & A6XX_SP_GS_CONFIG_NUAV__MASK;
}


#define REG_A6XX_SP_GS_INSTR_SIZE				0x0000a895


#define REG_A6XX_SP_GS_PVT_MEM_STACK_OFFSET			0x0000a896
#define A6XX_SP_GS_PVT_MEM_STACK_OFFSET_OFFSET__MASK		0x0007ffffull
#define A6XX_SP_GS_PVT_MEM_STACK_OFFSET_OFFSET__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_GS_PVT_MEM_STACK_OFFSET_OFFSET(uint32_t val)
{
	assert(!(val & 0x7ff));
	return (((val >> 11)) << A6XX_SP_GS_PVT_MEM_STACK_OFFSET_OFFSET__SHIFT) & A6XX_SP_GS_PVT_MEM_STACK_OFFSET_OFFSET__MASK;
}


#define REG_A6XX_SP_GS_HYSTERESIS				__FD_DEPRECATED 0x0000a897


#define REG_A8XX_SP_GS_HYSTERESIS				__FD_DEPRECATED 0x0000a897


#define REG_A7XX_SP_GS_VGS_CNTL					__FD_DEPRECATED 0x0000a899


#define REG_A6XX_SP_VS_SAMPLER_BASE				0x0000a8a0
static CONSTEXPR inline uint32_t A6XX_SP_VS_SAMPLER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_VS_SAMPLER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_HS_SAMPLER_BASE				0x0000a8a2
static CONSTEXPR inline uint32_t A6XX_SP_HS_SAMPLER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_HS_SAMPLER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_DS_SAMPLER_BASE				0x0000a8a4
static CONSTEXPR inline uint32_t A6XX_SP_DS_SAMPLER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_DS_SAMPLER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_GS_SAMPLER_BASE				0x0000a8a6
static CONSTEXPR inline uint32_t A6XX_SP_GS_SAMPLER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_GS_SAMPLER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_VS_TEXMEMOBJ_BASE				0x0000a8a8
static CONSTEXPR inline uint32_t A6XX_SP_VS_TEXMEMOBJ_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_VS_TEXMEMOBJ_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_HS_TEXMEMOBJ_BASE				0x0000a8aa
static CONSTEXPR inline uint32_t A6XX_SP_HS_TEXMEMOBJ_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_HS_TEXMEMOBJ_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_DS_TEXMEMOBJ_BASE				0x0000a8ac
static CONSTEXPR inline uint32_t A6XX_SP_DS_TEXMEMOBJ_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_DS_TEXMEMOBJ_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_GS_TEXMEMOBJ_BASE				0x0000a8ae
static CONSTEXPR inline uint32_t A6XX_SP_GS_TEXMEMOBJ_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_GS_TEXMEMOBJ_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_PS_CNTL_0					0x0000a980
#define A6XX_SP_PS_CNTL_0_THREADMODE__MASK			0x00000001ull
#define A6XX_SP_PS_CNTL_0_THREADMODE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_PS_CNTL_0_THREADMODE(enum a3xx_threadmode val)
{
	return ((val) << A6XX_SP_PS_CNTL_0_THREADMODE__SHIFT) & A6XX_SP_PS_CNTL_0_THREADMODE__MASK;
}
#define A6XX_SP_PS_CNTL_0_HALFREGFOOTPRINT__MASK		0x0000007eull
#define A6XX_SP_PS_CNTL_0_HALFREGFOOTPRINT__SHIFT		1
static CONSTEXPR inline uint32_t A6XX_SP_PS_CNTL_0_HALFREGFOOTPRINT(uint32_t val)
{
	return ((val) << A6XX_SP_PS_CNTL_0_HALFREGFOOTPRINT__SHIFT) & A6XX_SP_PS_CNTL_0_HALFREGFOOTPRINT__MASK;
}
#define A6XX_SP_PS_CNTL_0_FULLREGFOOTPRINT__MASK		0x00001f80ull
#define A6XX_SP_PS_CNTL_0_FULLREGFOOTPRINT__SHIFT		7
static CONSTEXPR inline uint32_t A6XX_SP_PS_CNTL_0_FULLREGFOOTPRINT(uint32_t val)
{
	return ((val) << A6XX_SP_PS_CNTL_0_FULLREGFOOTPRINT__SHIFT) & A6XX_SP_PS_CNTL_0_FULLREGFOOTPRINT__MASK;
}
#define A6XX_SP_PS_CNTL_0_UNK13					0x00002000
#define A6XX_SP_PS_CNTL_0_BRANCHSTACK__MASK			0x000fc000ull
#define A6XX_SP_PS_CNTL_0_BRANCHSTACK__SHIFT			14
static CONSTEXPR inline uint32_t A6XX_SP_PS_CNTL_0_BRANCHSTACK(uint32_t val)
{
	return ((val) << A6XX_SP_PS_CNTL_0_BRANCHSTACK__SHIFT) & A6XX_SP_PS_CNTL_0_BRANCHSTACK__MASK;
}
#define A6XX_SP_PS_CNTL_0_FULLREGFOOTPRINT_LSB__MASK		0x08000000ull
#define A6XX_SP_PS_CNTL_0_FULLREGFOOTPRINT_LSB__SHIFT		27
static CONSTEXPR inline uint32_t A6XX_SP_PS_CNTL_0_FULLREGFOOTPRINT_LSB(uint32_t val)
{
	return ((val) << A6XX_SP_PS_CNTL_0_FULLREGFOOTPRINT_LSB__SHIFT) & A6XX_SP_PS_CNTL_0_FULLREGFOOTPRINT_LSB__MASK;
}
#define A6XX_SP_PS_CNTL_0_HALFREGFOOTPRINT_LSB__MASK		0x40000000ull
#define A6XX_SP_PS_CNTL_0_HALFREGFOOTPRINT_LSB__SHIFT		30
static CONSTEXPR inline uint32_t A6XX_SP_PS_CNTL_0_HALFREGFOOTPRINT_LSB(uint32_t val)
{
	return ((val) << A6XX_SP_PS_CNTL_0_HALFREGFOOTPRINT_LSB__SHIFT) & A6XX_SP_PS_CNTL_0_HALFREGFOOTPRINT_LSB__MASK;
}
#define A6XX_SP_PS_CNTL_0_THREADSIZE__MASK			0x00100000ull
#define A6XX_SP_PS_CNTL_0_THREADSIZE__SHIFT			20
static CONSTEXPR inline uint32_t A6XX_SP_PS_CNTL_0_THREADSIZE(enum a6xx_threadsize val)
{
	return ((val) << A6XX_SP_PS_CNTL_0_THREADSIZE__SHIFT) & A6XX_SP_PS_CNTL_0_THREADSIZE__MASK;
}
#define A6XX_SP_PS_CNTL_0_UNK21					0x00200000
#define A6XX_SP_PS_CNTL_0_VARYING				0x00400000
#define A6XX_SP_PS_CNTL_0_LODPIXMASK				0x00800000
#define A6XX_SP_PS_CNTL_0_INOUTREGOVERLAP			0x01000000
#define A6XX_SP_PS_CNTL_0_UNK25					0x02000000
#define A6XX_SP_PS_CNTL_0_PIXLODENABLE				0x04000000
#define A6XX_SP_PS_CNTL_0_EARLYPREAMBLE				0x10000000
#define A6XX_SP_PS_CNTL_0_MERGEDREGS				0x80000000


#define REG_A6XX_SP_PS_BOOLEAN_CF_MASK				0x0000a981


#define REG_A6XX_SP_PS_PROGRAM_COUNTER_OFFSET			0x0000a982


#define REG_A6XX_SP_PS_BASE					0x0000a983
static CONSTEXPR inline uint32_t A6XX_SP_PS_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_PS_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_PS_PVT_MEM_PARAM				0x0000a985
#define A6XX_SP_PS_PVT_MEM_PARAM_MEMSIZEPERITEM__MASK		0x000000ffull
#define A6XX_SP_PS_PVT_MEM_PARAM_MEMSIZEPERITEM__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_PS_PVT_MEM_PARAM_MEMSIZEPERITEM(uint32_t val)
{
	assert(!(val & 0x1ff));
	return (((val >> 9)) << A6XX_SP_PS_PVT_MEM_PARAM_MEMSIZEPERITEM__SHIFT) & A6XX_SP_PS_PVT_MEM_PARAM_MEMSIZEPERITEM__MASK;
}
#define A6XX_SP_PS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__MASK	0xff000000ull
#define A6XX_SP_PS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__SHIFT	24
static CONSTEXPR inline uint32_t A6XX_SP_PS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD(uint32_t val)
{
	return ((val) << A6XX_SP_PS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__SHIFT) & A6XX_SP_PS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__MASK;
}


#define REG_A6XX_SP_PS_PVT_MEM_BASE				0x0000a986
static CONSTEXPR inline uint32_t A6XX_SP_PS_PVT_MEM_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_PS_PVT_MEM_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_PS_PVT_MEM_SIZE				0x0000a988
#define A6XX_SP_PS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__MASK		0x0003ffffull
#define A6XX_SP_PS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_PS_PVT_MEM_SIZE_TOTALPVTMEMSIZE(uint32_t val)
{
	assert(!(val & 0xfff));
	return (((val >> 12)) << A6XX_SP_PS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__SHIFT) & A6XX_SP_PS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__MASK;
}
#define A6XX_SP_PS_PVT_MEM_SIZE_PERWAVEMEMLAYOUT		0x80000000


#define REG_A6XX_SP_BLEND_CNTL					__FD_DEPRECATED 0x0000a989
#define A6XX_SP_BLEND_CNTL_ENABLE_BLEND__MASK			0x000000ffull
#define A6XX_SP_BLEND_CNTL_ENABLE_BLEND__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_BLEND_CNTL_ENABLE_BLEND(uint32_t val)
{
	return ((val) << A6XX_SP_BLEND_CNTL_ENABLE_BLEND__SHIFT) & A6XX_SP_BLEND_CNTL_ENABLE_BLEND__MASK;
}
#define A6XX_SP_BLEND_CNTL_INDEPENDENT_BLEND_EN			0x00000100
#define A6XX_SP_BLEND_CNTL_DUAL_COLOR_IN_ENABLE			0x00000200
#define A6XX_SP_BLEND_CNTL_ALPHA_TO_COVERAGE			0x00000400


#define REG_A8XX_SP_BLEND_CNTL					__FD_DEPRECATED 0x0000a989
#define A8XX_SP_BLEND_CNTL_ENABLE_BLEND__MASK			0x000000ffull
#define A8XX_SP_BLEND_CNTL_ENABLE_BLEND__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_SP_BLEND_CNTL_ENABLE_BLEND(uint32_t val)
{
	return ((val) << A8XX_SP_BLEND_CNTL_ENABLE_BLEND__SHIFT) & A8XX_SP_BLEND_CNTL_ENABLE_BLEND__MASK;
}
#define A8XX_SP_BLEND_CNTL_INDEPENDENT_BLEND_EN			0x00000100
#define A8XX_SP_BLEND_CNTL_DUAL_COLOR_IN_ENABLE			0x00000200
#define A8XX_SP_BLEND_CNTL_ALPHA_TO_COVERAGE			0x00000400
#define A8XX_SP_BLEND_CNTL_ALPHA_TO_ONE				0x00000800


#define REG_A6XX_SP_SRGB_CNTL					0x0000a98a
#define A6XX_SP_SRGB_CNTL_SRGB_MRT0				0x00000001
#define A6XX_SP_SRGB_CNTL_SRGB_MRT1				0x00000002
#define A6XX_SP_SRGB_CNTL_SRGB_MRT2				0x00000004
#define A6XX_SP_SRGB_CNTL_SRGB_MRT3				0x00000008
#define A6XX_SP_SRGB_CNTL_SRGB_MRT4				0x00000010
#define A6XX_SP_SRGB_CNTL_SRGB_MRT5				0x00000020
#define A6XX_SP_SRGB_CNTL_SRGB_MRT6				0x00000040
#define A6XX_SP_SRGB_CNTL_SRGB_MRT7				0x00000080


#define REG_A6XX_SP_PS_OUTPUT_MASK				0x0000a98b
#define A6XX_SP_PS_OUTPUT_MASK_RT0__MASK			0x0000000full
#define A6XX_SP_PS_OUTPUT_MASK_RT0__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_PS_OUTPUT_MASK_RT0(uint32_t val)
{
	return ((val) << A6XX_SP_PS_OUTPUT_MASK_RT0__SHIFT) & A6XX_SP_PS_OUTPUT_MASK_RT0__MASK;
}
#define A6XX_SP_PS_OUTPUT_MASK_RT1__MASK			0x000000f0ull
#define A6XX_SP_PS_OUTPUT_MASK_RT1__SHIFT			4
static CONSTEXPR inline uint32_t A6XX_SP_PS_OUTPUT_MASK_RT1(uint32_t val)
{
	return ((val) << A6XX_SP_PS_OUTPUT_MASK_RT1__SHIFT) & A6XX_SP_PS_OUTPUT_MASK_RT1__MASK;
}
#define A6XX_SP_PS_OUTPUT_MASK_RT2__MASK			0x00000f00ull
#define A6XX_SP_PS_OUTPUT_MASK_RT2__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_SP_PS_OUTPUT_MASK_RT2(uint32_t val)
{
	return ((val) << A6XX_SP_PS_OUTPUT_MASK_RT2__SHIFT) & A6XX_SP_PS_OUTPUT_MASK_RT2__MASK;
}
#define A6XX_SP_PS_OUTPUT_MASK_RT3__MASK			0x0000f000ull
#define A6XX_SP_PS_OUTPUT_MASK_RT3__SHIFT			12
static CONSTEXPR inline uint32_t A6XX_SP_PS_OUTPUT_MASK_RT3(uint32_t val)
{
	return ((val) << A6XX_SP_PS_OUTPUT_MASK_RT3__SHIFT) & A6XX_SP_PS_OUTPUT_MASK_RT3__MASK;
}
#define A6XX_SP_PS_OUTPUT_MASK_RT4__MASK			0x000f0000ull
#define A6XX_SP_PS_OUTPUT_MASK_RT4__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_SP_PS_OUTPUT_MASK_RT4(uint32_t val)
{
	return ((val) << A6XX_SP_PS_OUTPUT_MASK_RT4__SHIFT) & A6XX_SP_PS_OUTPUT_MASK_RT4__MASK;
}
#define A6XX_SP_PS_OUTPUT_MASK_RT5__MASK			0x00f00000ull
#define A6XX_SP_PS_OUTPUT_MASK_RT5__SHIFT			20
static CONSTEXPR inline uint32_t A6XX_SP_PS_OUTPUT_MASK_RT5(uint32_t val)
{
	return ((val) << A6XX_SP_PS_OUTPUT_MASK_RT5__SHIFT) & A6XX_SP_PS_OUTPUT_MASK_RT5__MASK;
}
#define A6XX_SP_PS_OUTPUT_MASK_RT6__MASK			0x0f000000ull
#define A6XX_SP_PS_OUTPUT_MASK_RT6__SHIFT			24
static CONSTEXPR inline uint32_t A6XX_SP_PS_OUTPUT_MASK_RT6(uint32_t val)
{
	return ((val) << A6XX_SP_PS_OUTPUT_MASK_RT6__SHIFT) & A6XX_SP_PS_OUTPUT_MASK_RT6__MASK;
}
#define A6XX_SP_PS_OUTPUT_MASK_RT7__MASK			0xf0000000ull
#define A6XX_SP_PS_OUTPUT_MASK_RT7__SHIFT			28
static CONSTEXPR inline uint32_t A6XX_SP_PS_OUTPUT_MASK_RT7(uint32_t val)
{
	return ((val) << A6XX_SP_PS_OUTPUT_MASK_RT7__SHIFT) & A6XX_SP_PS_OUTPUT_MASK_RT7__MASK;
}


#define REG_A6XX_SP_PS_OUTPUT_CNTL				0x0000a98c
#define A6XX_SP_PS_OUTPUT_CNTL_DUAL_COLOR_IN_ENABLE		0x00000001
#define A6XX_SP_PS_OUTPUT_CNTL_DEPTH_REGID__MASK		0x0000ff00ull
#define A6XX_SP_PS_OUTPUT_CNTL_DEPTH_REGID__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_SP_PS_OUTPUT_CNTL_DEPTH_REGID(uint32_t val)
{
	return ((val) << A6XX_SP_PS_OUTPUT_CNTL_DEPTH_REGID__SHIFT) & A6XX_SP_PS_OUTPUT_CNTL_DEPTH_REGID__MASK;
}
#define A6XX_SP_PS_OUTPUT_CNTL_SAMPMASK_REGID__MASK		0x00ff0000ull
#define A6XX_SP_PS_OUTPUT_CNTL_SAMPMASK_REGID__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_SP_PS_OUTPUT_CNTL_SAMPMASK_REGID(uint32_t val)
{
	return ((val) << A6XX_SP_PS_OUTPUT_CNTL_SAMPMASK_REGID__SHIFT) & A6XX_SP_PS_OUTPUT_CNTL_SAMPMASK_REGID__MASK;
}
#define A6XX_SP_PS_OUTPUT_CNTL_STENCILREF_REGID__MASK		0xff000000ull
#define A6XX_SP_PS_OUTPUT_CNTL_STENCILREF_REGID__SHIFT		24
static CONSTEXPR inline uint32_t A6XX_SP_PS_OUTPUT_CNTL_STENCILREF_REGID(uint32_t val)
{
	return ((val) << A6XX_SP_PS_OUTPUT_CNTL_STENCILREF_REGID__SHIFT) & A6XX_SP_PS_OUTPUT_CNTL_STENCILREF_REGID__MASK;
}


#define REG_A6XX_SP_PS_MRT_CNTL					0x0000a98d
#define A6XX_SP_PS_MRT_CNTL_MRT__MASK				0x0000000full
#define A6XX_SP_PS_MRT_CNTL_MRT__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_SP_PS_MRT_CNTL_MRT(uint32_t val)
{
	return ((val) << A6XX_SP_PS_MRT_CNTL_MRT__SHIFT) & A6XX_SP_PS_MRT_CNTL_MRT__MASK;
}


#define REG_A6XX_SP_PS_OUTPUT(i0)				(0x0000a98e + 0x1*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_SP_PS_OUTPUT_REG(uint32_t i0) { return 0x0000a98e + 0x1*i0; }
#define A6XX_SP_PS_OUTPUT_REG_REGID__MASK			0x000000ffull
#define A6XX_SP_PS_OUTPUT_REG_REGID__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_PS_OUTPUT_REG_REGID(uint32_t val)
{
	return ((val) << A6XX_SP_PS_OUTPUT_REG_REGID__SHIFT) & A6XX_SP_PS_OUTPUT_REG_REGID__MASK;
}
#define A6XX_SP_PS_OUTPUT_REG_HALF_PRECISION			0x00000100


#define REG_A6XX_SP_PS_MRT(i0)					(0x0000a996 + 0x1*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_SP_PS_MRT_REG(uint32_t i0) { return 0x0000a996 + 0x1*i0; }
#define A6XX_SP_PS_MRT_REG_COLOR_FORMAT__MASK			0x000000ffull
#define A6XX_SP_PS_MRT_REG_COLOR_FORMAT__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_PS_MRT_REG_COLOR_FORMAT(enum a6xx_format val)
{
	return ((val) << A6XX_SP_PS_MRT_REG_COLOR_FORMAT__SHIFT) & A6XX_SP_PS_MRT_REG_COLOR_FORMAT__MASK;
}
#define A6XX_SP_PS_MRT_REG_COLOR_SINT				0x00000100
#define A6XX_SP_PS_MRT_REG_COLOR_UINT				0x00000200
#define A6XX_SP_PS_MRT_REG_UNK10				0x00000400


#define REG_A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL			0x0000a99e
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL_COUNT__MASK		0x00000007ull
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL_COUNT__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL_COUNT(uint32_t val)
{
	return ((val) << A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL_COUNT__SHIFT) & A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL_COUNT__MASK;
}
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL_IJ_WRITE_DISABLE	0x00000008
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL_ENDOFQUAD		0x00000010
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL_WRITE_COLOR_TO_OUTPUT	0x00000020
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL_CONSTSLOTID__MASK	0x00007fc0ull
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL_CONSTSLOTID__SHIFT	6
static CONSTEXPR inline uint32_t A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL_CONSTSLOTID(uint32_t val)
{
	return ((val) << A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL_CONSTSLOTID__SHIFT) & A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL_CONSTSLOTID__MASK;
}
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL_CONSTSLOTID4COORD__MASK	0x01ff0000ull
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL_CONSTSLOTID4COORD__SHIFT	16
static CONSTEXPR inline uint32_t A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL_CONSTSLOTID4COORD(uint32_t val)
{
	return ((val) << A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL_CONSTSLOTID4COORD__SHIFT) & A6XX_SP_PS_INITIAL_TEX_LOAD_CNTL_CONSTSLOTID4COORD__MASK;
}


#define REG_A6XX_SP_PS_INITIAL_TEX_LOAD(i0)			(0x0000a99f + 0x1*i0 )

#define A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_SRC__MASK		0x0000007full
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_SRC__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_SRC(uint32_t val)
{
	return ((val) << A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_SRC__SHIFT) & A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_SRC__MASK;
}
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_SAMP_ID__MASK		0x00000780ull
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_SAMP_ID__SHIFT		7
static CONSTEXPR inline uint32_t A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_SAMP_ID(uint32_t val)
{
	return ((val) << A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_SAMP_ID__SHIFT) & A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_SAMP_ID__MASK;
}
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_TEX_ID__MASK		0x0000f800ull
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_TEX_ID__SHIFT		11
static CONSTEXPR inline uint32_t A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_TEX_ID(uint32_t val)
{
	return ((val) << A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_TEX_ID__SHIFT) & A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_TEX_ID__MASK;
}
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_DST__MASK		0x003f0000ull
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_DST__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_DST(uint32_t val)
{
	return ((val) << A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_DST__SHIFT) & A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_DST__MASK;
}
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_WRMASK__MASK		0x03c00000ull
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_WRMASK__SHIFT		22
static CONSTEXPR inline uint32_t A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_WRMASK(uint32_t val)
{
	return ((val) << A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_WRMASK__SHIFT) & A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_WRMASK__MASK;
}
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_HALF			0x04000000
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_UNK27			0x08000000
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_BINDLESS		0x10000000
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_CMD__MASK		0xe0000000ull
#define A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_CMD__SHIFT		29
static CONSTEXPR inline uint32_t A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_CMD(enum a6xx_tex_prefetch_cmd val)
{
	return ((val) << A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_CMD__SHIFT) & A6XX_SP_PS_INITIAL_TEX_LOAD_CMD_CMD__MASK;
}


#define REG_A7XX_SP_PS_INITIAL_TEX_LOAD(i0)			(0x0000a99f + 0x1*i0 )

#define A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_SRC__MASK		0x0000007full
#define A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_SRC__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_SRC(uint32_t val)
{
	return ((val) << A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_SRC__SHIFT) & A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_SRC__MASK;
}
#define A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_SAMP_ID__MASK		0x00000380ull
#define A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_SAMP_ID__SHIFT		7
static CONSTEXPR inline uint32_t A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_SAMP_ID(uint32_t val)
{
	return ((val) << A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_SAMP_ID__SHIFT) & A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_SAMP_ID__MASK;
}
#define A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_TEX_ID__MASK		0x00001c00ull
#define A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_TEX_ID__SHIFT		10
static CONSTEXPR inline uint32_t A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_TEX_ID(uint32_t val)
{
	return ((val) << A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_TEX_ID__SHIFT) & A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_TEX_ID__MASK;
}
#define A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_DST__MASK		0x0007e000ull
#define A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_DST__SHIFT		13
static CONSTEXPR inline uint32_t A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_DST(uint32_t val)
{
	return ((val) << A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_DST__SHIFT) & A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_DST__MASK;
}
#define A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_WRMASK__MASK		0x00780000ull
#define A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_WRMASK__SHIFT		19
static CONSTEXPR inline uint32_t A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_WRMASK(uint32_t val)
{
	return ((val) << A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_WRMASK__SHIFT) & A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_WRMASK__MASK;
}
#define A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_HALF			0x00800000
#define A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_BINDLESS		0x02000000
#define A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_CMD__MASK		0x3c000000ull
#define A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_CMD__SHIFT		26
static CONSTEXPR inline uint32_t A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_CMD(enum a6xx_tex_prefetch_cmd val)
{
	return ((val) << A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_CMD__SHIFT) & A7XX_SP_PS_INITIAL_TEX_LOAD_CMD_CMD__MASK;
}


#define REG_A6XX_SP_PS_INITIAL_TEX_INDEX(i0)			(0x0000a9a3 + 0x1*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_SP_PS_INITIAL_TEX_INDEX_CMD(uint32_t i0) { return 0x0000a9a3 + 0x1*i0; }
#define A6XX_SP_PS_INITIAL_TEX_INDEX_CMD_SAMP_ID__MASK		0x0000ffffull
#define A6XX_SP_PS_INITIAL_TEX_INDEX_CMD_SAMP_ID__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_PS_INITIAL_TEX_INDEX_CMD_SAMP_ID(uint32_t val)
{
	return ((val) << A6XX_SP_PS_INITIAL_TEX_INDEX_CMD_SAMP_ID__SHIFT) & A6XX_SP_PS_INITIAL_TEX_INDEX_CMD_SAMP_ID__MASK;
}
#define A6XX_SP_PS_INITIAL_TEX_INDEX_CMD_TEX_ID__MASK		0xffff0000ull
#define A6XX_SP_PS_INITIAL_TEX_INDEX_CMD_TEX_ID__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_SP_PS_INITIAL_TEX_INDEX_CMD_TEX_ID(uint32_t val)
{
	return ((val) << A6XX_SP_PS_INITIAL_TEX_INDEX_CMD_TEX_ID__SHIFT) & A6XX_SP_PS_INITIAL_TEX_INDEX_CMD_TEX_ID__MASK;
}


#define REG_A6XX_SP_PS_TSIZE					0x0000a9a7


#define REG_A6XX_SP_UNKNOWN_A9A8				0x0000a9a8


#define REG_A6XX_SP_PS_PVT_MEM_STACK_OFFSET			0x0000a9a9
#define A6XX_SP_PS_PVT_MEM_STACK_OFFSET_OFFSET__MASK		0x0007ffffull
#define A6XX_SP_PS_PVT_MEM_STACK_OFFSET_OFFSET__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_PS_PVT_MEM_STACK_OFFSET_OFFSET(uint32_t val)
{
	assert(!(val & 0x7ff));
	return (((val >> 11)) << A6XX_SP_PS_PVT_MEM_STACK_OFFSET_OFFSET__SHIFT) & A6XX_SP_PS_PVT_MEM_STACK_OFFSET_OFFSET__MASK;
}


#define REG_A6XX_SP_PS_HYSTERESIS				__FD_DEPRECATED 0x0000a9ab


#define REG_A8XX_SP_PS_HYSTERESIS				__FD_DEPRECATED 0x0000a9ab


#define REG_A6XX_SP_CS_CNTL_0					0x0000a9b0
#define A6XX_SP_CS_CNTL_0_THREADMODE__MASK			0x00000001ull
#define A6XX_SP_CS_CNTL_0_THREADMODE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_CS_CNTL_0_THREADMODE(enum a3xx_threadmode val)
{
	return ((val) << A6XX_SP_CS_CNTL_0_THREADMODE__SHIFT) & A6XX_SP_CS_CNTL_0_THREADMODE__MASK;
}
#define A6XX_SP_CS_CNTL_0_HALFREGFOOTPRINT__MASK		0x0000007eull
#define A6XX_SP_CS_CNTL_0_HALFREGFOOTPRINT__SHIFT		1
static CONSTEXPR inline uint32_t A6XX_SP_CS_CNTL_0_HALFREGFOOTPRINT(uint32_t val)
{
	return ((val) << A6XX_SP_CS_CNTL_0_HALFREGFOOTPRINT__SHIFT) & A6XX_SP_CS_CNTL_0_HALFREGFOOTPRINT__MASK;
}
#define A6XX_SP_CS_CNTL_0_FULLREGFOOTPRINT__MASK		0x00001f80ull
#define A6XX_SP_CS_CNTL_0_FULLREGFOOTPRINT__SHIFT		7
static CONSTEXPR inline uint32_t A6XX_SP_CS_CNTL_0_FULLREGFOOTPRINT(uint32_t val)
{
	return ((val) << A6XX_SP_CS_CNTL_0_FULLREGFOOTPRINT__SHIFT) & A6XX_SP_CS_CNTL_0_FULLREGFOOTPRINT__MASK;
}
#define A6XX_SP_CS_CNTL_0_UNK13					0x00002000
#define A6XX_SP_CS_CNTL_0_BRANCHSTACK__MASK			0x000fc000ull
#define A6XX_SP_CS_CNTL_0_BRANCHSTACK__SHIFT			14
static CONSTEXPR inline uint32_t A6XX_SP_CS_CNTL_0_BRANCHSTACK(uint32_t val)
{
	return ((val) << A6XX_SP_CS_CNTL_0_BRANCHSTACK__SHIFT) & A6XX_SP_CS_CNTL_0_BRANCHSTACK__MASK;
}
#define A6XX_SP_CS_CNTL_0_FULLREGFOOTPRINT_LSB__MASK		0x08000000ull
#define A6XX_SP_CS_CNTL_0_FULLREGFOOTPRINT_LSB__SHIFT		27
static CONSTEXPR inline uint32_t A6XX_SP_CS_CNTL_0_FULLREGFOOTPRINT_LSB(uint32_t val)
{
	return ((val) << A6XX_SP_CS_CNTL_0_FULLREGFOOTPRINT_LSB__SHIFT) & A6XX_SP_CS_CNTL_0_FULLREGFOOTPRINT_LSB__MASK;
}
#define A6XX_SP_CS_CNTL_0_HALFREGFOOTPRINT_LSB__MASK		0x40000000ull
#define A6XX_SP_CS_CNTL_0_HALFREGFOOTPRINT_LSB__SHIFT		30
static CONSTEXPR inline uint32_t A6XX_SP_CS_CNTL_0_HALFREGFOOTPRINT_LSB(uint32_t val)
{
	return ((val) << A6XX_SP_CS_CNTL_0_HALFREGFOOTPRINT_LSB__SHIFT) & A6XX_SP_CS_CNTL_0_HALFREGFOOTPRINT_LSB__MASK;
}
#define A6XX_SP_CS_CNTL_0_THREADSIZE__MASK			0x00100000ull
#define A6XX_SP_CS_CNTL_0_THREADSIZE__SHIFT			20
static CONSTEXPR inline uint32_t A6XX_SP_CS_CNTL_0_THREADSIZE(enum a6xx_threadsize val)
{
	return ((val) << A6XX_SP_CS_CNTL_0_THREADSIZE__SHIFT) & A6XX_SP_CS_CNTL_0_THREADSIZE__MASK;
}
#define A6XX_SP_CS_CNTL_0_UNK21					0x00200000
#define A6XX_SP_CS_CNTL_0_UNK22					0x00400000
#define A6XX_SP_CS_CNTL_0_EARLYPREAMBLE				0x00800000
#define A6XX_SP_CS_CNTL_0_MERGEDREGS				0x80000000


#define REG_A6XX_SP_CS_CNTL_1					0x0000a9b1
#define A6XX_SP_CS_CNTL_1_SHARED_SIZE__MASK			0x0000001full
#define A6XX_SP_CS_CNTL_1_SHARED_SIZE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_CS_CNTL_1_SHARED_SIZE(uint32_t val)
{
	return ((val) << A6XX_SP_CS_CNTL_1_SHARED_SIZE__SHIFT) & A6XX_SP_CS_CNTL_1_SHARED_SIZE__MASK;
}
#define A6XX_SP_CS_CNTL_1_CONSTANTRAMMODE__MASK			0x00000060ull
#define A6XX_SP_CS_CNTL_1_CONSTANTRAMMODE__SHIFT		5
static CONSTEXPR inline uint32_t A6XX_SP_CS_CNTL_1_CONSTANTRAMMODE(enum a6xx_const_ram_mode val)
{
	return ((val) << A6XX_SP_CS_CNTL_1_CONSTANTRAMMODE__SHIFT) & A6XX_SP_CS_CNTL_1_CONSTANTRAMMODE__MASK;
}
#define A6XX_SP_CS_CNTL_1_ALT_LM_ENCODE				0x04000000


#define REG_A6XX_SP_CS_BOOLEAN_CF_MASK				0x0000a9b2


#define REG_A6XX_SP_CS_PROGRAM_COUNTER_OFFSET			0x0000a9b3


#define REG_A6XX_SP_CS_BASE					0x0000a9b4
static CONSTEXPR inline uint32_t A6XX_SP_CS_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_CS_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_CS_PVT_MEM_PARAM				0x0000a9b6
#define A6XX_SP_CS_PVT_MEM_PARAM_MEMSIZEPERITEM__MASK		0x000000ffull
#define A6XX_SP_CS_PVT_MEM_PARAM_MEMSIZEPERITEM__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_CS_PVT_MEM_PARAM_MEMSIZEPERITEM(uint32_t val)
{
	assert(!(val & 0x1ff));
	return (((val >> 9)) << A6XX_SP_CS_PVT_MEM_PARAM_MEMSIZEPERITEM__SHIFT) & A6XX_SP_CS_PVT_MEM_PARAM_MEMSIZEPERITEM__MASK;
}
#define A6XX_SP_CS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__MASK	0xff000000ull
#define A6XX_SP_CS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__SHIFT	24
static CONSTEXPR inline uint32_t A6XX_SP_CS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD(uint32_t val)
{
	return ((val) << A6XX_SP_CS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__SHIFT) & A6XX_SP_CS_PVT_MEM_PARAM_HWSTACKSIZEPERTHREAD__MASK;
}


#define REG_A6XX_SP_CS_PVT_MEM_BASE				0x0000a9b7
static CONSTEXPR inline uint32_t A6XX_SP_CS_PVT_MEM_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_CS_PVT_MEM_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_CS_PVT_MEM_SIZE				0x0000a9b9
#define A6XX_SP_CS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__MASK		0x0003ffffull
#define A6XX_SP_CS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_CS_PVT_MEM_SIZE_TOTALPVTMEMSIZE(uint32_t val)
{
	assert(!(val & 0xfff));
	return (((val >> 12)) << A6XX_SP_CS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__SHIFT) & A6XX_SP_CS_PVT_MEM_SIZE_TOTALPVTMEMSIZE__MASK;
}
#define A6XX_SP_CS_PVT_MEM_SIZE_PERWAVEMEMLAYOUT		0x80000000


#define REG_A6XX_SP_CS_TSIZE					0x0000a9ba


#define REG_A6XX_SP_CS_CONFIG					0x0000a9bb
#define A6XX_SP_CS_CONFIG_BINDLESS_TEX				0x00000001
#define A6XX_SP_CS_CONFIG_BINDLESS_SAMP				0x00000002
#define A6XX_SP_CS_CONFIG_BINDLESS_UAV				0x00000004
#define A6XX_SP_CS_CONFIG_BINDLESS_UBO				0x00000008
#define A6XX_SP_CS_CONFIG_ENABLED				0x00000100
#define A6XX_SP_CS_CONFIG_NTEX__MASK				0x0001fe00ull
#define A6XX_SP_CS_CONFIG_NTEX__SHIFT				9
static CONSTEXPR inline uint32_t A6XX_SP_CS_CONFIG_NTEX(uint32_t val)
{
	return ((val) << A6XX_SP_CS_CONFIG_NTEX__SHIFT) & A6XX_SP_CS_CONFIG_NTEX__MASK;
}
#define A6XX_SP_CS_CONFIG_NSAMP__MASK				0x003e0000ull
#define A6XX_SP_CS_CONFIG_NSAMP__SHIFT				17
static CONSTEXPR inline uint32_t A6XX_SP_CS_CONFIG_NSAMP(uint32_t val)
{
	return ((val) << A6XX_SP_CS_CONFIG_NSAMP__SHIFT) & A6XX_SP_CS_CONFIG_NSAMP__MASK;
}
#define A6XX_SP_CS_CONFIG_NUAV__MASK				0x1fc00000ull
#define A6XX_SP_CS_CONFIG_NUAV__SHIFT				22
static CONSTEXPR inline uint32_t A6XX_SP_CS_CONFIG_NUAV(uint32_t val)
{
	return ((val) << A6XX_SP_CS_CONFIG_NUAV__SHIFT) & A6XX_SP_CS_CONFIG_NUAV__MASK;
}


#define REG_A6XX_SP_CS_INSTR_SIZE				0x0000a9bc


#define REG_A6XX_SP_CS_PVT_MEM_STACK_OFFSET			0x0000a9bd
#define A6XX_SP_CS_PVT_MEM_STACK_OFFSET_OFFSET__MASK		0x0007ffffull
#define A6XX_SP_CS_PVT_MEM_STACK_OFFSET_OFFSET__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_CS_PVT_MEM_STACK_OFFSET_OFFSET(uint32_t val)
{
	assert(!(val & 0x7ff));
	return (((val >> 11)) << A6XX_SP_CS_PVT_MEM_STACK_OFFSET_OFFSET__SHIFT) & A6XX_SP_CS_PVT_MEM_STACK_OFFSET_OFFSET__MASK;
}


#define REG_A6XX_SP_CS_HYSTERESIS				__FD_DEPRECATED 0x0000a9be


#define REG_A8XX_SP_CS_HYSTERESIS				__FD_DEPRECATED 0x0000a9be


#define REG_A7XX_SP_CS_VGS_CNTL					__FD_DEPRECATED 0x0000a9c5


#define REG_A6XX_SP_CS_WIE_CNTL_0				0x0000a9c2
#define A6XX_SP_CS_WIE_CNTL_0_WGIDCONSTID__MASK			0x000000ffull
#define A6XX_SP_CS_WIE_CNTL_0_WGIDCONSTID__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_CS_WIE_CNTL_0_WGIDCONSTID(uint32_t val)
{
	return ((val) << A6XX_SP_CS_WIE_CNTL_0_WGIDCONSTID__SHIFT) & A6XX_SP_CS_WIE_CNTL_0_WGIDCONSTID__MASK;
}
#define A6XX_SP_CS_WIE_CNTL_0_WGSIZECONSTID__MASK		0x0000ff00ull
#define A6XX_SP_CS_WIE_CNTL_0_WGSIZECONSTID__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_SP_CS_WIE_CNTL_0_WGSIZECONSTID(uint32_t val)
{
	return ((val) << A6XX_SP_CS_WIE_CNTL_0_WGSIZECONSTID__SHIFT) & A6XX_SP_CS_WIE_CNTL_0_WGSIZECONSTID__MASK;
}
#define A6XX_SP_CS_WIE_CNTL_0_WGOFFSETCONSTID__MASK		0x00ff0000ull
#define A6XX_SP_CS_WIE_CNTL_0_WGOFFSETCONSTID__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_SP_CS_WIE_CNTL_0_WGOFFSETCONSTID(uint32_t val)
{
	return ((val) << A6XX_SP_CS_WIE_CNTL_0_WGOFFSETCONSTID__SHIFT) & A6XX_SP_CS_WIE_CNTL_0_WGOFFSETCONSTID__MASK;
}
#define A6XX_SP_CS_WIE_CNTL_0_LOCALIDREGID__MASK		0xff000000ull
#define A6XX_SP_CS_WIE_CNTL_0_LOCALIDREGID__SHIFT		24
static CONSTEXPR inline uint32_t A6XX_SP_CS_WIE_CNTL_0_LOCALIDREGID(uint32_t val)
{
	return ((val) << A6XX_SP_CS_WIE_CNTL_0_LOCALIDREGID__SHIFT) & A6XX_SP_CS_WIE_CNTL_0_LOCALIDREGID__MASK;
}


#define REG_A6XX_SP_CS_WIE_CNTL_1				__FD_DEPRECATED 0x0000a9c3
#define A6XX_SP_CS_WIE_CNTL_1_LINEARLOCALIDREGID__MASK		0x000000ffull
#define A6XX_SP_CS_WIE_CNTL_1_LINEARLOCALIDREGID__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_CS_WIE_CNTL_1_LINEARLOCALIDREGID(uint32_t val)
{
	return ((val) << A6XX_SP_CS_WIE_CNTL_1_LINEARLOCALIDREGID__SHIFT) & A6XX_SP_CS_WIE_CNTL_1_LINEARLOCALIDREGID__MASK;
}
#define A6XX_SP_CS_WIE_CNTL_1_SINGLE_SP_CORE			0x00000100
#define A6XX_SP_CS_WIE_CNTL_1_THREADSIZE__MASK			0x00000200ull
#define A6XX_SP_CS_WIE_CNTL_1_THREADSIZE__SHIFT			9
static CONSTEXPR inline uint32_t A6XX_SP_CS_WIE_CNTL_1_THREADSIZE(enum a6xx_threadsize val)
{
	return ((val) << A6XX_SP_CS_WIE_CNTL_1_THREADSIZE__SHIFT) & A6XX_SP_CS_WIE_CNTL_1_THREADSIZE__MASK;
}
#define A6XX_SP_CS_WIE_CNTL_1_THREADSIZE_SCALAR			0x00000400


#define REG_A7XX_SP_CS_WIE_CNTL_1				__FD_DEPRECATED 0x0000a9c3
#define A7XX_SP_CS_WIE_CNTL_1_LINEARLOCALIDREGID__MASK		0x000000ffull
#define A7XX_SP_CS_WIE_CNTL_1_LINEARLOCALIDREGID__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_SP_CS_WIE_CNTL_1_LINEARLOCALIDREGID(uint32_t val)
{
	return ((val) << A7XX_SP_CS_WIE_CNTL_1_LINEARLOCALIDREGID__SHIFT) & A7XX_SP_CS_WIE_CNTL_1_LINEARLOCALIDREGID__MASK;
}
#define A7XX_SP_CS_WIE_CNTL_1_THREADSIZE__MASK			0x00000100ull
#define A7XX_SP_CS_WIE_CNTL_1_THREADSIZE__SHIFT			8
static CONSTEXPR inline uint32_t A7XX_SP_CS_WIE_CNTL_1_THREADSIZE(enum a6xx_threadsize val)
{
	return ((val) << A7XX_SP_CS_WIE_CNTL_1_THREADSIZE__SHIFT) & A7XX_SP_CS_WIE_CNTL_1_THREADSIZE__MASK;
}
#define A7XX_SP_CS_WIE_CNTL_1_THREADSIZE_SCALAR			0x00000200
#define A7XX_SP_CS_WIE_CNTL_1_WORKITEMRASTORDER__MASK		0x00008000ull
#define A7XX_SP_CS_WIE_CNTL_1_WORKITEMRASTORDER__SHIFT		15
static CONSTEXPR inline uint32_t A7XX_SP_CS_WIE_CNTL_1_WORKITEMRASTORDER(enum a7xx_workitem_rast_order val)
{
	return ((val) << A7XX_SP_CS_WIE_CNTL_1_WORKITEMRASTORDER__SHIFT) & A7XX_SP_CS_WIE_CNTL_1_WORKITEMRASTORDER__MASK;
}


#define REG_A6XX_SP_PS_SAMPLER_BASE				0x0000a9e0
static CONSTEXPR inline uint32_t A6XX_SP_PS_SAMPLER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_PS_SAMPLER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_CS_SAMPLER_BASE				0x0000a9e2
static CONSTEXPR inline uint32_t A6XX_SP_CS_SAMPLER_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_CS_SAMPLER_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_PS_TEXMEMOBJ_BASE				0x0000a9e4
static CONSTEXPR inline uint32_t A6XX_SP_PS_TEXMEMOBJ_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_PS_TEXMEMOBJ_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_CS_TEXMEMOBJ_BASE				0x0000a9e6
static CONSTEXPR inline uint32_t A6XX_SP_CS_TEXMEMOBJ_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_CS_TEXMEMOBJ_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_CS_BINDLESS_BASE(i0)			(0x0000a9e8 + 0x2*i0 )

static CONSTEXPR inline uint32_t A6XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_HI(uint32_t val)
{
	return val;
}
#define A6XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__MASK	0x00000003ull
#define A6XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__SHIFT	0
static CONSTEXPR inline uint64_t A6XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE(enum a6xx_bindless_descriptor_size val)
{
	return ((uint64_t)(val) << A6XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__SHIFT) & A6XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__MASK;
}
#define A6XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_ADDR__MASK		0xfffffffffffffffcull
#define A6XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_ADDR__SHIFT		2
static CONSTEXPR inline uint64_t A6XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_ADDR(uint64_t val)
{
	assert(!(val & 0x3));
	return ((uint64_t)((val >> 2)) << A6XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_ADDR__SHIFT) & A6XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_ADDR__MASK;
}


#define REG_A7XX_SP_CS_BINDLESS_BASE(i0)			(0x0000a9e8 + 0x2*i0 )

static CONSTEXPR inline uint32_t A7XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_HI(uint32_t val)
{
	return val;
}
#define A7XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__MASK	0x00000003ull
#define A7XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__SHIFT	0
static CONSTEXPR inline uint64_t A7XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE(enum a6xx_bindless_descriptor_size val)
{
	return ((uint64_t)(val) << A7XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__SHIFT) & A7XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__MASK;
}
#define A7XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_ADDR__MASK		0xfffffffffffffffcull
#define A7XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_ADDR__SHIFT		2
static CONSTEXPR inline uint64_t A7XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_ADDR(uint64_t val)
{
	assert(!(val & 0x3));
	return ((uint64_t)((val >> 2)) << A7XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_ADDR__SHIFT) & A7XX_SP_CS_BINDLESS_BASE_DESCRIPTOR_ADDR__MASK;
}


#define REG_A6XX_SP_CS_UAV_BASE					__FD_DEPRECATED 0x0000a9f2
static CONSTEXPR inline uint32_t A6XX_SP_CS_UAV_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_CS_UAV_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A7XX_SP_CS_UAV_BASE					__FD_DEPRECATED 0x0000a9f8
static CONSTEXPR inline uint32_t A7XX_SP_CS_UAV_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_SP_CS_UAV_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_CS_USIZE					0x0000aa00


#define REG_A7XX_SP_PS_VGS_CNTL					__FD_DEPRECATED 0x0000aa01


#define REG_A7XX_SP_PS_OUTPUT_CONST_CNTL			__FD_DEPRECATED 0x0000aa02
#define A7XX_SP_PS_OUTPUT_CONST_CNTL_ENABLED			0x00000001


#define REG_A7XX_SP_PS_OUTPUT_CONST_MASK			__FD_DEPRECATED 0x0000aa03
#define A7XX_SP_PS_OUTPUT_CONST_MASK_RT0__MASK			0x0000000full
#define A7XX_SP_PS_OUTPUT_CONST_MASK_RT0__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_SP_PS_OUTPUT_CONST_MASK_RT0(uint32_t val)
{
	return ((val) << A7XX_SP_PS_OUTPUT_CONST_MASK_RT0__SHIFT) & A7XX_SP_PS_OUTPUT_CONST_MASK_RT0__MASK;
}
#define A7XX_SP_PS_OUTPUT_CONST_MASK_RT1__MASK			0x000000f0ull
#define A7XX_SP_PS_OUTPUT_CONST_MASK_RT1__SHIFT			4
static CONSTEXPR inline uint32_t A7XX_SP_PS_OUTPUT_CONST_MASK_RT1(uint32_t val)
{
	return ((val) << A7XX_SP_PS_OUTPUT_CONST_MASK_RT1__SHIFT) & A7XX_SP_PS_OUTPUT_CONST_MASK_RT1__MASK;
}
#define A7XX_SP_PS_OUTPUT_CONST_MASK_RT2__MASK			0x00000f00ull
#define A7XX_SP_PS_OUTPUT_CONST_MASK_RT2__SHIFT			8
static CONSTEXPR inline uint32_t A7XX_SP_PS_OUTPUT_CONST_MASK_RT2(uint32_t val)
{
	return ((val) << A7XX_SP_PS_OUTPUT_CONST_MASK_RT2__SHIFT) & A7XX_SP_PS_OUTPUT_CONST_MASK_RT2__MASK;
}
#define A7XX_SP_PS_OUTPUT_CONST_MASK_RT3__MASK			0x0000f000ull
#define A7XX_SP_PS_OUTPUT_CONST_MASK_RT3__SHIFT			12
static CONSTEXPR inline uint32_t A7XX_SP_PS_OUTPUT_CONST_MASK_RT3(uint32_t val)
{
	return ((val) << A7XX_SP_PS_OUTPUT_CONST_MASK_RT3__SHIFT) & A7XX_SP_PS_OUTPUT_CONST_MASK_RT3__MASK;
}
#define A7XX_SP_PS_OUTPUT_CONST_MASK_RT4__MASK			0x000f0000ull
#define A7XX_SP_PS_OUTPUT_CONST_MASK_RT4__SHIFT			16
static CONSTEXPR inline uint32_t A7XX_SP_PS_OUTPUT_CONST_MASK_RT4(uint32_t val)
{
	return ((val) << A7XX_SP_PS_OUTPUT_CONST_MASK_RT4__SHIFT) & A7XX_SP_PS_OUTPUT_CONST_MASK_RT4__MASK;
}
#define A7XX_SP_PS_OUTPUT_CONST_MASK_RT5__MASK			0x00f00000ull
#define A7XX_SP_PS_OUTPUT_CONST_MASK_RT5__SHIFT			20
static CONSTEXPR inline uint32_t A7XX_SP_PS_OUTPUT_CONST_MASK_RT5(uint32_t val)
{
	return ((val) << A7XX_SP_PS_OUTPUT_CONST_MASK_RT5__SHIFT) & A7XX_SP_PS_OUTPUT_CONST_MASK_RT5__MASK;
}
#define A7XX_SP_PS_OUTPUT_CONST_MASK_RT6__MASK			0x0f000000ull
#define A7XX_SP_PS_OUTPUT_CONST_MASK_RT6__SHIFT			24
static CONSTEXPR inline uint32_t A7XX_SP_PS_OUTPUT_CONST_MASK_RT6(uint32_t val)
{
	return ((val) << A7XX_SP_PS_OUTPUT_CONST_MASK_RT6__SHIFT) & A7XX_SP_PS_OUTPUT_CONST_MASK_RT6__MASK;
}
#define A7XX_SP_PS_OUTPUT_CONST_MASK_RT7__MASK			0xf0000000ull
#define A7XX_SP_PS_OUTPUT_CONST_MASK_RT7__SHIFT			28
static CONSTEXPR inline uint32_t A7XX_SP_PS_OUTPUT_CONST_MASK_RT7(uint32_t val)
{
	return ((val) << A7XX_SP_PS_OUTPUT_CONST_MASK_RT7__SHIFT) & A7XX_SP_PS_OUTPUT_CONST_MASK_RT7__MASK;
}


#define REG_A8XX_SP_MRT_BLEND_CNTL(i0)				(0x0000aa04 + 0x1*i0 )

#define A8XX_SP_MRT_BLEND_CNTL_REG_COLOR_BLEND_EN		0x00000001
#define A8XX_SP_MRT_BLEND_CNTL_REG_ALPHA_BLEND_EN		0x00000002
#define A8XX_SP_MRT_BLEND_CNTL_REG_COMPONENT_WRITE_MASK__MASK	0x00000780ull
#define A8XX_SP_MRT_BLEND_CNTL_REG_COMPONENT_WRITE_MASK__SHIFT	7
static CONSTEXPR inline uint32_t A8XX_SP_MRT_BLEND_CNTL_REG_COMPONENT_WRITE_MASK(uint32_t val)
{
	return ((val) << A8XX_SP_MRT_BLEND_CNTL_REG_COMPONENT_WRITE_MASK__SHIFT) & A8XX_SP_MRT_BLEND_CNTL_REG_COMPONENT_WRITE_MASK__MASK;
}


#define REG_A8XX_SP_ALPHA_TEST_CNTL				__FD_DEPRECATED 0x0000aa0c
#define A8XX_SP_ALPHA_TEST_CNTL_ALPHA_TEST			0x00000100


#define REG_A6XX_SP_UNKNOWN_AAF2				0x0000aaf2


#define REG_A6XX_SP_MODE_CNTL					0x0000ab00
#define A6XX_SP_MODE_CNTL_CONSTANT_DEMOTION_ENABLE		0x00000001
#define A6XX_SP_MODE_CNTL_ISAMMODE__MASK			0x00000006ull
#define A6XX_SP_MODE_CNTL_ISAMMODE__SHIFT			1
static CONSTEXPR inline uint32_t A6XX_SP_MODE_CNTL_ISAMMODE(enum a6xx_isam_mode val)
{
	return ((val) << A6XX_SP_MODE_CNTL_ISAMMODE__SHIFT) & A6XX_SP_MODE_CNTL_ISAMMODE__MASK;
}
#define A6XX_SP_MODE_CNTL_SHARED_CONSTS_ENABLE			0x00000008


#define REG_A7XX_SP_UNKNOWN_AB01				__FD_DEPRECATED 0x0000ab01


#define REG_A7XX_SP_HLSQ_MODE_CNTL				__FD_DEPRECATED 0x0000ab02
#define A7XX_SP_HLSQ_MODE_CNTL_SHARED_CONSTS_ENABLE		0x00000001


#define REG_A6XX_SP_PS_CONFIG					0x0000ab04
#define A6XX_SP_PS_CONFIG_BINDLESS_TEX				0x00000001
#define A6XX_SP_PS_CONFIG_BINDLESS_SAMP				0x00000002
#define A6XX_SP_PS_CONFIG_BINDLESS_UAV				0x00000004
#define A6XX_SP_PS_CONFIG_BINDLESS_UBO				0x00000008
#define A6XX_SP_PS_CONFIG_ENABLED				0x00000100
#define A6XX_SP_PS_CONFIG_NTEX__MASK				0x0001fe00ull
#define A6XX_SP_PS_CONFIG_NTEX__SHIFT				9
static CONSTEXPR inline uint32_t A6XX_SP_PS_CONFIG_NTEX(uint32_t val)
{
	return ((val) << A6XX_SP_PS_CONFIG_NTEX__SHIFT) & A6XX_SP_PS_CONFIG_NTEX__MASK;
}
#define A6XX_SP_PS_CONFIG_NSAMP__MASK				0x003e0000ull
#define A6XX_SP_PS_CONFIG_NSAMP__SHIFT				17
static CONSTEXPR inline uint32_t A6XX_SP_PS_CONFIG_NSAMP(uint32_t val)
{
	return ((val) << A6XX_SP_PS_CONFIG_NSAMP__SHIFT) & A6XX_SP_PS_CONFIG_NSAMP__MASK;
}
#define A6XX_SP_PS_CONFIG_NUAV__MASK				0x1fc00000ull
#define A6XX_SP_PS_CONFIG_NUAV__SHIFT				22
static CONSTEXPR inline uint32_t A6XX_SP_PS_CONFIG_NUAV(uint32_t val)
{
	return ((val) << A6XX_SP_PS_CONFIG_NUAV__SHIFT) & A6XX_SP_PS_CONFIG_NUAV__MASK;
}


#define REG_A6XX_SP_PS_INSTR_SIZE				0x0000ab05


#define REG_A8XX_SP_BIN_SIZE					__FD_DEPRECATED 0x0000ab06
#define A8XX_SP_BIN_SIZE_BINW__MASK				0x000003ffull
#define A8XX_SP_BIN_SIZE_BINW__SHIFT				0
static CONSTEXPR inline uint32_t A8XX_SP_BIN_SIZE_BINW(uint32_t val)
{
	assert(!(val & 0x1f));
	return (((val >> 5)) << A8XX_SP_BIN_SIZE_BINW__SHIFT) & A8XX_SP_BIN_SIZE_BINW__MASK;
}
#define A8XX_SP_BIN_SIZE_BINH__MASK				0x07ff0000ull
#define A8XX_SP_BIN_SIZE_BINH__SHIFT				16
static CONSTEXPR inline uint32_t A8XX_SP_BIN_SIZE_BINH(uint32_t val)
{
	assert(!(val & 0xf));
	return (((val >> 4)) << A8XX_SP_BIN_SIZE_BINH__SHIFT) & A8XX_SP_BIN_SIZE_BINH__MASK;
}


#define REG_A6XX_SP_GFX_BINDLESS_BASE(i0)			(0x0000ab10 + 0x2*i0 )

static CONSTEXPR inline uint32_t A6XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_HI(uint32_t val)
{
	return val;
}
#define A6XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__MASK	0x00000003ull
#define A6XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__SHIFT	0
static CONSTEXPR inline uint64_t A6XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE(enum a6xx_bindless_descriptor_size val)
{
	return ((uint64_t)(val) << A6XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__SHIFT) & A6XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__MASK;
}
#define A6XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_ADDR__MASK		0xfffffffffffffffcull
#define A6XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_ADDR__SHIFT	2
static CONSTEXPR inline uint64_t A6XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_ADDR(uint64_t val)
{
	assert(!(val & 0x3));
	return ((uint64_t)((val >> 2)) << A6XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_ADDR__SHIFT) & A6XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_ADDR__MASK;
}


#define REG_A7XX_SP_GFX_BINDLESS_BASE(i0)			(0x0000ab0a + 0x2*i0 )

static CONSTEXPR inline uint32_t A7XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_HI(uint32_t val)
{
	return val;
}
#define A7XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__MASK	0x00000003ull
#define A7XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__SHIFT	0
static CONSTEXPR inline uint64_t A7XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE(enum a6xx_bindless_descriptor_size val)
{
	return ((uint64_t)(val) << A7XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__SHIFT) & A7XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__MASK;
}
#define A7XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_ADDR__MASK		0xfffffffffffffffcull
#define A7XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_ADDR__SHIFT	2
static CONSTEXPR inline uint64_t A7XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_ADDR(uint64_t val)
{
	assert(!(val & 0x3));
	return ((uint64_t)((val >> 2)) << A7XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_ADDR__SHIFT) & A7XX_SP_GFX_BINDLESS_BASE_DESCRIPTOR_ADDR__MASK;
}


#define REG_A6XX_SP_GFX_UAV_BASE				0x0000ab1a
static CONSTEXPR inline uint32_t A6XX_SP_GFX_UAV_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_SP_GFX_UAV_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_SP_GFX_USIZE					__FD_DEPRECATED 0x0000ab20


#define REG_A8XX_SP_GFX_USIZE					__FD_DEPRECATED 0x0000ab09


#define REG_A7XX_SP_UNKNOWN_AB22				__FD_DEPRECATED 0x0000ab22


#define REG_A8XX_SP_UNKNOWN_AB23				__FD_DEPRECATED 0x0000ab23


#define REG_A6XX_SP_A2D_OUTPUT_INFO				__FD_DEPRECATED 0x0000acc0
#define A6XX_SP_A2D_OUTPUT_INFO_HALF_PRECISION			0x00000001
#define A6XX_SP_A2D_OUTPUT_INFO_IFMT_TYPE__MASK			0x00000006ull
#define A6XX_SP_A2D_OUTPUT_INFO_IFMT_TYPE__SHIFT		1
static CONSTEXPR inline uint32_t A6XX_SP_A2D_OUTPUT_INFO_IFMT_TYPE(enum a6xx_sp_a2d_output_ifmt_type val)
{
	return ((val) << A6XX_SP_A2D_OUTPUT_INFO_IFMT_TYPE__SHIFT) & A6XX_SP_A2D_OUTPUT_INFO_IFMT_TYPE__MASK;
}
#define A6XX_SP_A2D_OUTPUT_INFO_COLOR_FORMAT__MASK		0x000007f8ull
#define A6XX_SP_A2D_OUTPUT_INFO_COLOR_FORMAT__SHIFT		3
static CONSTEXPR inline uint32_t A6XX_SP_A2D_OUTPUT_INFO_COLOR_FORMAT(enum a6xx_format val)
{
	return ((val) << A6XX_SP_A2D_OUTPUT_INFO_COLOR_FORMAT__SHIFT) & A6XX_SP_A2D_OUTPUT_INFO_COLOR_FORMAT__MASK;
}
#define A6XX_SP_A2D_OUTPUT_INFO_SRGB				0x00000800
#define A6XX_SP_A2D_OUTPUT_INFO_MASK__MASK			0x0000f000ull
#define A6XX_SP_A2D_OUTPUT_INFO_MASK__SHIFT			12
static CONSTEXPR inline uint32_t A6XX_SP_A2D_OUTPUT_INFO_MASK(uint32_t val)
{
	return ((val) << A6XX_SP_A2D_OUTPUT_INFO_MASK__SHIFT) & A6XX_SP_A2D_OUTPUT_INFO_MASK__MASK;
}


#define REG_A7XX_SP_A2D_OUTPUT_INFO				__FD_DEPRECATED 0x0000a9bf
#define A7XX_SP_A2D_OUTPUT_INFO_HALF_PRECISION			0x00000001
#define A7XX_SP_A2D_OUTPUT_INFO_IFMT_TYPE__MASK			0x00000006ull
#define A7XX_SP_A2D_OUTPUT_INFO_IFMT_TYPE__SHIFT		1
static CONSTEXPR inline uint32_t A7XX_SP_A2D_OUTPUT_INFO_IFMT_TYPE(enum a6xx_sp_a2d_output_ifmt_type val)
{
	return ((val) << A7XX_SP_A2D_OUTPUT_INFO_IFMT_TYPE__SHIFT) & A7XX_SP_A2D_OUTPUT_INFO_IFMT_TYPE__MASK;
}
#define A7XX_SP_A2D_OUTPUT_INFO_COLOR_FORMAT__MASK		0x000007f8ull
#define A7XX_SP_A2D_OUTPUT_INFO_COLOR_FORMAT__SHIFT		3
static CONSTEXPR inline uint32_t A7XX_SP_A2D_OUTPUT_INFO_COLOR_FORMAT(enum a6xx_format val)
{
	return ((val) << A7XX_SP_A2D_OUTPUT_INFO_COLOR_FORMAT__SHIFT) & A7XX_SP_A2D_OUTPUT_INFO_COLOR_FORMAT__MASK;
}
#define A7XX_SP_A2D_OUTPUT_INFO_SRGB				0x00000800
#define A7XX_SP_A2D_OUTPUT_INFO_MASK__MASK			0x0000f000ull
#define A7XX_SP_A2D_OUTPUT_INFO_MASK__SHIFT			12
static CONSTEXPR inline uint32_t A7XX_SP_A2D_OUTPUT_INFO_MASK(uint32_t val)
{
	return ((val) << A7XX_SP_A2D_OUTPUT_INFO_MASK__SHIFT) & A7XX_SP_A2D_OUTPUT_INFO_MASK__MASK;
}


#define REG_A6XX_SP_DBG_ECO_CNTL				0x0000ae00


#define REG_A6XX_SP_ADDR_MODE_CNTL				__FD_DEPRECATED 0x0000ae01


#define REG_A8XX_SP_SHADER_PROFILING				__FD_DEPRECATED 0x0000ae01


#define REG_A6XX_SP_NC_MODE_CNTL				0x0000ae02


#define REG_A6XX_SP_CHICKEN_BITS				0x0000ae03
#define A6XX_SP_CHICKEN_BITS_EOLM_ENABLE			0x00000002


#define REG_A6XX_SP_NC_MODE_CNTL_2				0x0000ae04
#define A6XX_SP_NC_MODE_CNTL_2_F16_NO_INF			0x00000008


#define REG_A8XX_SP_SS_CHICKEN_BITS_0				__FD_DEPRECATED 0x0000ae05


#define REG_A7XX_SP_ISDB_CNTL					__FD_DEPRECATED 0x0000ae06


#define REG_A6XX_SP_PERFCTR_CNTL				0x0000ae07


#define REG_A7XX_SP_CHICKEN_BITS_1				__FD_DEPRECATED 0x0000ae08


#define REG_A7XX_SP_CHICKEN_BITS_2				__FD_DEPRECATED 0x0000ae09


#define REG_A7XX_SP_CHICKEN_BITS_3				__FD_DEPRECATED 0x0000ae0a


#define REG_A8XX_SP_CHICKEN_BITS_4				__FD_DEPRECATED 0x0000ae0b


#define REG_A6XX_SP_STATUS					0x0000ae0c


#define REG_A6XX_SP_PERFCTR_SHADER_MASK				0x0000ae0f
#define A6XX_SP_PERFCTR_SHADER_MASK_VS				0x00000001
#define A6XX_SP_PERFCTR_SHADER_MASK_HS				0x00000002
#define A6XX_SP_PERFCTR_SHADER_MASK_DS				0x00000004
#define A6XX_SP_PERFCTR_SHADER_MASK_GS				0x00000008
#define A6XX_SP_PERFCTR_SHADER_MASK_FS				0x00000010
#define A6XX_SP_PERFCTR_SHADER_MASK_CS				0x00000020


#define REG_A6XX_SP_PERFCTR_SP_SEL(i0)				(0x0000ae10 + 0x1*i0 )



#define REG_A7XX_SP_PERFCTR_HLSQ_SEL(i0)			(0x0000ae60 + 0x1*i0 )



#define REG_A7XX_SP_UNKNOWN_AE6A				__FD_DEPRECATED 0x0000ae6a


#define REG_A7XX_SP_HLSQ_TIMEOUT_THRESHOLD_DP			__FD_DEPRECATED 0x0000ae6b


#define REG_A7XX_SP_HLSQ_DBG_ECO_CNTL				__FD_DEPRECATED 0x0000ae6c


#define REG_A7XX_SP_READ_SEL					__FD_DEPRECATED 0x0000ae6d
#define A7XX_SP_READ_SEL_CONTEXT__MASK				0x7c000000ull
#define A7XX_SP_READ_SEL_CONTEXT__SHIFT				26
static CONSTEXPR inline uint32_t A7XX_SP_READ_SEL_CONTEXT(uint32_t val)
{
	return ((val) << A7XX_SP_READ_SEL_CONTEXT__SHIFT) & A7XX_SP_READ_SEL_CONTEXT__MASK;
}
#define A7XX_SP_READ_SEL_SLICE__MASK				0x03e00000ull
#define A7XX_SP_READ_SEL_SLICE__SHIFT				21
static CONSTEXPR inline uint32_t A7XX_SP_READ_SEL_SLICE(uint32_t val)
{
	return ((val) << A7XX_SP_READ_SEL_SLICE__SHIFT) & A7XX_SP_READ_SEL_SLICE__MASK;
}
#define A7XX_SP_READ_SEL_LOCATION__MASK				0x001c0000ull
#define A7XX_SP_READ_SEL_LOCATION__SHIFT			18
static CONSTEXPR inline uint32_t A7XX_SP_READ_SEL_LOCATION(enum a7xx_state_location val)
{
	return ((val) << A7XX_SP_READ_SEL_LOCATION__SHIFT) & A7XX_SP_READ_SEL_LOCATION__MASK;
}
#define A7XX_SP_READ_SEL_PIPE__MASK				0x00030000ull
#define A7XX_SP_READ_SEL_PIPE__SHIFT				16
static CONSTEXPR inline uint32_t A7XX_SP_READ_SEL_PIPE(enum adreno_pipe val)
{
	return ((val) << A7XX_SP_READ_SEL_PIPE__SHIFT) & A7XX_SP_READ_SEL_PIPE__MASK;
}
#define A7XX_SP_READ_SEL_STATETYPE__MASK			0x0000ff00ull
#define A7XX_SP_READ_SEL_STATETYPE__SHIFT			8
static CONSTEXPR inline uint32_t A7XX_SP_READ_SEL_STATETYPE(enum a7xx_statetype_id val)
{
	return ((val) << A7XX_SP_READ_SEL_STATETYPE__SHIFT) & A7XX_SP_READ_SEL_STATETYPE__MASK;
}
#define A7XX_SP_READ_SEL_USPTP__MASK				0x000000f0ull
#define A7XX_SP_READ_SEL_USPTP__SHIFT				4
static CONSTEXPR inline uint32_t A7XX_SP_READ_SEL_USPTP(uint32_t val)
{
	return ((val) << A7XX_SP_READ_SEL_USPTP__SHIFT) & A7XX_SP_READ_SEL_USPTP__MASK;
}
#define A7XX_SP_READ_SEL_SPTP__MASK				0x0000000full
#define A7XX_SP_READ_SEL_SPTP__SHIFT				0
static CONSTEXPR inline uint32_t A7XX_SP_READ_SEL_SPTP(uint32_t val)
{
	return ((val) << A7XX_SP_READ_SEL_SPTP__SHIFT) & A7XX_SP_READ_SEL_SPTP__MASK;
}


#define REG_A7XX_SP_DBG_CNTL					__FD_DEPRECATED 0x0000ae71


#define REG_A7XX_SP_HLSQ_DBG_ECO_CNTL_1				__FD_DEPRECATED 0x0000ae73


#define REG_A7XX_SP_HLSQ_DBG_ECO_CNTL_2				__FD_DEPRECATED 0x0000ae74


#define REG_A8XX_SP_HLSQ_DBG_ECO_CNTL_3				__FD_DEPRECATED 0x0000ae76


#define REG_A7XX_SP_PERFCTR_SP_SEL(i0)				(0x0000ae80 + 0x1*i0 )



#define REG_A6XX_SP_CONTEXT_SWITCH_GFX_PREEMPTION_SAFE_MODE	0x0000ae52


#define REG_A8XX_SP_HLSQ_GC_GMEM_RANGE_MIN			__FD_DEPRECATED 0x0000ae10
static CONSTEXPR inline uint32_t A8XX_SP_HLSQ_GC_GMEM_RANGE_MIN_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_SP_HLSQ_GC_GMEM_RANGE_MIN_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_SP_HLSQ_LPAC_GMEM_RANGE_MIN			__FD_DEPRECATED 0x0000ae12
static CONSTEXPR inline uint32_t A8XX_SP_HLSQ_LPAC_GMEM_RANGE_MIN_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_SP_HLSQ_LPAC_GMEM_RANGE_MIN_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_SP_LPAC_CPI_STATUS				__FD_DEPRECATED 0x0000ae15


#define REG_A8XX_SP_LPAC_DBG_STATUS				__FD_DEPRECATED 0x0000ae16


#define REG_A8XX_SP_LPAC_ISDB_BATCH_COUNT			__FD_DEPRECATED 0x0000ae17


#define REG_A8XX_SP_LPAC_ISDB_BATCH_COUNT_INCR_EN		__FD_DEPRECATED 0x0000ae18


#define REG_A8XX_SP_LPAC_ISDB_BATCH_COUNT_SHADERS		__FD_DEPRECATED 0x0000ae19


#define REG_A7XX_SP_ISDB_BATCH_COUNT				__FD_DEPRECATED 0x0000ae30


#define REG_A7XX_SP_ISDB_BATCH_COUNT_INCR_EN			__FD_DEPRECATED 0x0000ae31


#define REG_A7XX_SP_ISDB_BATCH_COUNT_SHADERS			__FD_DEPRECATED 0x0000ae32


#define REG_A7XX_SP_ISDB_DEBUG_CONFIG				__FD_DEPRECATED 0x0000ae35


#define REG_A7XX_SP_SELF_THROTTLE_CONTROL			__FD_DEPRECATED 0x0000ae3a


#define REG_A7XX_SP_DISPATCH_CNTL				__FD_DEPRECATED 0x0000ae3b


#define REG_A7XX_SP_SW_DEBUG_ADDR				__FD_DEPRECATED 0x0000ae3c
static CONSTEXPR inline uint32_t A7XX_SP_SW_DEBUG_ADDR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_SP_SW_DEBUG_ADDR_HI(uint32_t val)
{
	return val;
}


#define REG_A7XX_SP_ISDB_DEBUG_ADDR				__FD_DEPRECATED 0x0000ae3e
static CONSTEXPR inline uint32_t A7XX_SP_ISDB_DEBUG_ADDR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_SP_ISDB_DEBUG_ADDR_HI(uint32_t val)
{
	return val;
}


#define REG_A7XX_SP_PERFCTR_HLSQ_SEL_2_0(i0)			(0x0000aec0 + 0x1*i0 )



#define REG_A6XX_TPL1_CS_BORDER_COLOR_BASE			0x0000b180
static CONSTEXPR inline uint32_t A6XX_TPL1_CS_BORDER_COLOR_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_TPL1_CS_BORDER_COLOR_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_TPL1_PS_ROTATION_CNTL				0x0000b182


#define REG_A6XX_TPL1_PS_SWIZZLE_CNTL				0x0000b183


#define REG_A6XX_SP_UNKNOWN_B190				0x0000b190


#define REG_A6XX_SP_UNKNOWN_B191				0x0000b191


#define REG_A8XX_TPL1_A2D_BIN_SIZE				__FD_DEPRECATED 0x0000b2d6
#define A8XX_TPL1_A2D_BIN_SIZE_BINW__MASK			0x000003ffull
#define A8XX_TPL1_A2D_BIN_SIZE_BINW__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_TPL1_A2D_BIN_SIZE_BINW(uint32_t val)
{
	assert(!(val & 0x1f));
	return (((val >> 5)) << A8XX_TPL1_A2D_BIN_SIZE_BINW__SHIFT) & A8XX_TPL1_A2D_BIN_SIZE_BINW__MASK;
}
#define A8XX_TPL1_A2D_BIN_SIZE_BINH__MASK			0x07ff0000ull
#define A8XX_TPL1_A2D_BIN_SIZE_BINH__SHIFT			16
static CONSTEXPR inline uint32_t A8XX_TPL1_A2D_BIN_SIZE_BINH(uint32_t val)
{
	assert(!(val & 0xf));
	return (((val >> 4)) << A8XX_TPL1_A2D_BIN_SIZE_BINH__SHIFT) & A8XX_TPL1_A2D_BIN_SIZE_BINH__MASK;
}


#define REG_A8XX_TPL1_A2D_FILTER_CNTL				__FD_DEPRECATED 0x0000b2d7


#define REG_A6XX_TPL1_RAS_MSAA_CNTL				0x0000b300
#define A6XX_TPL1_RAS_MSAA_CNTL_SAMPLES__MASK			0x00000003ull
#define A6XX_TPL1_RAS_MSAA_CNTL_SAMPLES__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_TPL1_RAS_MSAA_CNTL_SAMPLES(enum a3xx_msaa_samples val)
{
	return ((val) << A6XX_TPL1_RAS_MSAA_CNTL_SAMPLES__SHIFT) & A6XX_TPL1_RAS_MSAA_CNTL_SAMPLES__MASK;
}
#define A6XX_TPL1_RAS_MSAA_CNTL_UNK2__MASK			0x0000000cull
#define A6XX_TPL1_RAS_MSAA_CNTL_UNK2__SHIFT			2
static CONSTEXPR inline uint32_t A6XX_TPL1_RAS_MSAA_CNTL_UNK2(uint32_t val)
{
	return ((val) << A6XX_TPL1_RAS_MSAA_CNTL_UNK2__SHIFT) & A6XX_TPL1_RAS_MSAA_CNTL_UNK2__MASK;
}


#define REG_A6XX_TPL1_DEST_MSAA_CNTL				0x0000b301
#define A6XX_TPL1_DEST_MSAA_CNTL_SAMPLES__MASK			0x00000003ull
#define A6XX_TPL1_DEST_MSAA_CNTL_SAMPLES__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_TPL1_DEST_MSAA_CNTL_SAMPLES(enum a3xx_msaa_samples val)
{
	return ((val) << A6XX_TPL1_DEST_MSAA_CNTL_SAMPLES__SHIFT) & A6XX_TPL1_DEST_MSAA_CNTL_SAMPLES__MASK;
}
#define A6XX_TPL1_DEST_MSAA_CNTL_MSAA_DISABLE			0x00000004


#define REG_A6XX_TPL1_GFX_BORDER_COLOR_BASE			0x0000b302
static CONSTEXPR inline uint32_t A6XX_TPL1_GFX_BORDER_COLOR_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_TPL1_GFX_BORDER_COLOR_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_TPL1_MSAA_SAMPLE_POS_CNTL			__FD_DEPRECATED 0x0000b304
#define A6XX_TPL1_MSAA_SAMPLE_POS_CNTL_UNK0			0x00000001
#define A6XX_TPL1_MSAA_SAMPLE_POS_CNTL_LOCATION_ENABLE		0x00000002


#define REG_A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0			__FD_DEPRECATED 0x0000b305
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X__MASK	0x0000000full
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X__SHIFT	0
static inline uint32_t A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X__SHIFT) & A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_X__MASK;
}
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y__MASK	0x000000f0ull
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y__SHIFT	4
static inline uint32_t A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y__SHIFT) & A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_0_Y__MASK;
}
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X__MASK	0x00000f00ull
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X__SHIFT	8
static inline uint32_t A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X__SHIFT) & A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_X__MASK;
}
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y__MASK	0x0000f000ull
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y__SHIFT	12
static inline uint32_t A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y__SHIFT) & A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_1_Y__MASK;
}
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X__MASK	0x000f0000ull
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X__SHIFT	16
static inline uint32_t A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X__SHIFT) & A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_X__MASK;
}
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y__MASK	0x00f00000ull
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y__SHIFT	20
static inline uint32_t A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y__SHIFT) & A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_2_Y__MASK;
}
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X__MASK	0x0f000000ull
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X__SHIFT	24
static inline uint32_t A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X__SHIFT) & A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_X__MASK;
}
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y__MASK	0xf0000000ull
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y__SHIFT	28
static inline uint32_t A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y__SHIFT) & A6XX_TPL1_PROGRAMMABLE_MSAA_POS_0_SAMPLE_3_Y__MASK;
}


#define REG_A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1			__FD_DEPRECATED 0x0000b306
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X__MASK	0x0000000full
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X__SHIFT	0
static inline uint32_t A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X__SHIFT) & A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_X__MASK;
}
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y__MASK	0x000000f0ull
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y__SHIFT	4
static inline uint32_t A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y__SHIFT) & A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_0_Y__MASK;
}
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X__MASK	0x00000f00ull
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X__SHIFT	8
static inline uint32_t A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X__SHIFT) & A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_X__MASK;
}
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y__MASK	0x0000f000ull
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y__SHIFT	12
static inline uint32_t A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y__SHIFT) & A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_1_Y__MASK;
}
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X__MASK	0x000f0000ull
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X__SHIFT	16
static inline uint32_t A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X__SHIFT) & A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_X__MASK;
}
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y__MASK	0x00f00000ull
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y__SHIFT	20
static inline uint32_t A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y__SHIFT) & A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_2_Y__MASK;
}
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X__MASK	0x0f000000ull
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X__SHIFT	24
static inline uint32_t A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X__SHIFT) & A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_X__MASK;
}
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y__MASK	0xf0000000ull
#define A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y__SHIFT	28
static inline uint32_t A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y(float val)
{
	return ((((int32_t)(val * 16.0))) << A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y__SHIFT) & A6XX_TPL1_PROGRAMMABLE_MSAA_POS_1_SAMPLE_3_Y__MASK;
}


#define REG_A6XX_TPL1_WINDOW_OFFSET				0x0000b307
#define A6XX_TPL1_WINDOW_OFFSET_X__MASK				0x00003fffull
#define A6XX_TPL1_WINDOW_OFFSET_X__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_TPL1_WINDOW_OFFSET_X(uint32_t val)
{
	return ((val) << A6XX_TPL1_WINDOW_OFFSET_X__SHIFT) & A6XX_TPL1_WINDOW_OFFSET_X__MASK;
}
#define A6XX_TPL1_WINDOW_OFFSET_Y__MASK				0x3fff0000ull
#define A6XX_TPL1_WINDOW_OFFSET_Y__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_TPL1_WINDOW_OFFSET_Y(uint32_t val)
{
	return ((val) << A6XX_TPL1_WINDOW_OFFSET_Y__SHIFT) & A6XX_TPL1_WINDOW_OFFSET_Y__MASK;
}


#define REG_A8XX_TPL1_BIN_SIZE					__FD_DEPRECATED 0x0000b304
#define A8XX_TPL1_BIN_SIZE_BINW__MASK				0x000003ffull
#define A8XX_TPL1_BIN_SIZE_BINW__SHIFT				0
static CONSTEXPR inline uint32_t A8XX_TPL1_BIN_SIZE_BINW(uint32_t val)
{
	assert(!(val & 0x1f));
	return (((val >> 5)) << A8XX_TPL1_BIN_SIZE_BINW__SHIFT) & A8XX_TPL1_BIN_SIZE_BINW__MASK;
}
#define A8XX_TPL1_BIN_SIZE_BINH__MASK				0x07ff0000ull
#define A8XX_TPL1_BIN_SIZE_BINH__SHIFT				16
static CONSTEXPR inline uint32_t A8XX_TPL1_BIN_SIZE_BINH(uint32_t val)
{
	assert(!(val & 0xf));
	return (((val >> 4)) << A8XX_TPL1_BIN_SIZE_BINH__SHIFT) & A8XX_TPL1_BIN_SIZE_BINH__MASK;
}


#define REG_A6XX_TPL1_MODE_CNTL					__FD_DEPRECATED 0x0000b309
#define A6XX_TPL1_MODE_CNTL_ISAMMODE__MASK			0x00000003ull
#define A6XX_TPL1_MODE_CNTL_ISAMMODE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_TPL1_MODE_CNTL_ISAMMODE(enum a6xx_isam_mode val)
{
	return ((val) << A6XX_TPL1_MODE_CNTL_ISAMMODE__SHIFT) & A6XX_TPL1_MODE_CNTL_ISAMMODE__MASK;
}
#define A6XX_TPL1_MODE_CNTL_TEXCOORDROUNDMODE__MASK		0x00000004ull
#define A6XX_TPL1_MODE_CNTL_TEXCOORDROUNDMODE__SHIFT		2
static CONSTEXPR inline uint32_t A6XX_TPL1_MODE_CNTL_TEXCOORDROUNDMODE(enum a6xx_coord_round val)
{
	return ((val) << A6XX_TPL1_MODE_CNTL_TEXCOORDROUNDMODE__SHIFT) & A6XX_TPL1_MODE_CNTL_TEXCOORDROUNDMODE__MASK;
}
#define A6XX_TPL1_MODE_CNTL_ARRAYCOORDROUNDMODE__MASK		0x00000018ull
#define A6XX_TPL1_MODE_CNTL_ARRAYCOORDROUNDMODE__SHIFT		3
static CONSTEXPR inline uint32_t A6XX_TPL1_MODE_CNTL_ARRAYCOORDROUNDMODE(enum a6xx_coord_round val)
{
	return ((val) << A6XX_TPL1_MODE_CNTL_ARRAYCOORDROUNDMODE__SHIFT) & A6XX_TPL1_MODE_CNTL_ARRAYCOORDROUNDMODE__MASK;
}
#define A6XX_TPL1_MODE_CNTL_NEARESTMIPSNAP__MASK		0x00000020ull
#define A6XX_TPL1_MODE_CNTL_NEARESTMIPSNAP__SHIFT		5
static CONSTEXPR inline uint32_t A6XX_TPL1_MODE_CNTL_NEARESTMIPSNAP(enum a6xx_nearest_mode val)
{
	return ((val) << A6XX_TPL1_MODE_CNTL_NEARESTMIPSNAP__SHIFT) & A6XX_TPL1_MODE_CNTL_NEARESTMIPSNAP__MASK;
}
#define A6XX_TPL1_MODE_CNTL_SAMPLEREPLICATE			0x00000040
#define A6XX_TPL1_MODE_CNTL_DESTDATATYPEOVERRIDE		0x00000080
#define A6XX_TPL1_MODE_CNTL_PACK_SAMP_REDUCED_PRECISION		0x00000100


#define REG_A8XX_TPL1_MODE_CNTL					__FD_DEPRECATED 0x0000b309
#define A8XX_TPL1_MODE_CNTL_ISAMMODE__MASK			0x00000003ull
#define A8XX_TPL1_MODE_CNTL_ISAMMODE__SHIFT			0
static CONSTEXPR inline uint32_t A8XX_TPL1_MODE_CNTL_ISAMMODE(enum a6xx_isam_mode val)
{
	return ((val) << A8XX_TPL1_MODE_CNTL_ISAMMODE__SHIFT) & A8XX_TPL1_MODE_CNTL_ISAMMODE__MASK;
}
#define A8XX_TPL1_MODE_CNTL_TEXCOORDROUNDMODE__MASK		0x00000004ull
#define A8XX_TPL1_MODE_CNTL_TEXCOORDROUNDMODE__SHIFT		2
static CONSTEXPR inline uint32_t A8XX_TPL1_MODE_CNTL_TEXCOORDROUNDMODE(enum a6xx_coord_round val)
{
	return ((val) << A8XX_TPL1_MODE_CNTL_TEXCOORDROUNDMODE__SHIFT) & A8XX_TPL1_MODE_CNTL_TEXCOORDROUNDMODE__MASK;
}
#define A8XX_TPL1_MODE_CNTL_ARRAYCOORDROUNDMODE__MASK		0x00000018ull
#define A8XX_TPL1_MODE_CNTL_ARRAYCOORDROUNDMODE__SHIFT		3
static CONSTEXPR inline uint32_t A8XX_TPL1_MODE_CNTL_ARRAYCOORDROUNDMODE(enum a6xx_coord_round val)
{
	return ((val) << A8XX_TPL1_MODE_CNTL_ARRAYCOORDROUNDMODE__SHIFT) & A8XX_TPL1_MODE_CNTL_ARRAYCOORDROUNDMODE__MASK;
}
#define A8XX_TPL1_MODE_CNTL_NEARESTMIPSNAP__MASK		0x00000020ull
#define A8XX_TPL1_MODE_CNTL_NEARESTMIPSNAP__SHIFT		5
static CONSTEXPR inline uint32_t A8XX_TPL1_MODE_CNTL_NEARESTMIPSNAP(enum a6xx_nearest_mode val)
{
	return ((val) << A8XX_TPL1_MODE_CNTL_NEARESTMIPSNAP__SHIFT) & A8XX_TPL1_MODE_CNTL_NEARESTMIPSNAP__MASK;
}
#define A8XX_TPL1_MODE_CNTL_SAMPLEREPLICATE			0x00000040
#define A8XX_TPL1_MODE_CNTL_DESTDATATYPEOVERRIDE		0x00000080
#define A8XX_TPL1_MODE_CNTL_PACK_SAMP_REDUCED_PRECISION		0x00000100
#define A8XX_TPL1_MODE_CNTL_CLAMP_DISABLE			0x00001000


#define REG_A7XX_SP_UNKNOWN_B310				__FD_DEPRECATED 0x0000b310


#define REG_A6XX_TPL1_A2D_SRC_TEXTURE_INFO			__FD_DEPRECATED 0x0000b4c0
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_FORMAT__MASK	0x000000ffull
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_FORMAT__SHIFT	0
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_FORMAT(enum a6xx_format val)
{
	return ((val) << A6XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_FORMAT__SHIFT) & A6XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_FORMAT__MASK;
}
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_TILE_MODE__MASK		0x00000300ull
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_TILE_MODE__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_INFO_TILE_MODE(enum a6xx_tile_mode val)
{
	return ((val) << A6XX_TPL1_A2D_SRC_TEXTURE_INFO_TILE_MODE__SHIFT) & A6XX_TPL1_A2D_SRC_TEXTURE_INFO_TILE_MODE__MASK;
}
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_SWAP__MASK		0x00000c00ull
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_SWAP__SHIFT	10
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_SWAP(enum a3xx_color_swap val)
{
	return ((val) << A6XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_SWAP__SHIFT) & A6XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_SWAP__MASK;
}
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_FLAGS			0x00001000
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_SRGB			0x00002000
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_SAMPLES__MASK		0x0000c000ull
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_SAMPLES__SHIFT		14
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_INFO_SAMPLES(enum a3xx_msaa_samples val)
{
	return ((val) << A6XX_TPL1_A2D_SRC_TEXTURE_INFO_SAMPLES__SHIFT) & A6XX_TPL1_A2D_SRC_TEXTURE_INFO_SAMPLES__MASK;
}
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_FILTER			0x00010000
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK17			0x00020000
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_SAMPLES_AVERAGE		0x00040000
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK19			0x00080000
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK20			0x00100000
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK21			0x00200000
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK22			0x00400000
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK23__MASK		0x07800000ull
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK23__SHIFT		23
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK23(uint32_t val)
{
	return ((val) << A6XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK23__SHIFT) & A6XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK23__MASK;
}
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK28			0x10000000
#define A6XX_TPL1_A2D_SRC_TEXTURE_INFO_MUTABLEEN		0x20000000


#define REG_A6XX_TPL1_A2D_SRC_TEXTURE_SIZE			__FD_DEPRECATED 0x0000b4c1
#define A6XX_TPL1_A2D_SRC_TEXTURE_SIZE_WIDTH__MASK		0x00007fffull
#define A6XX_TPL1_A2D_SRC_TEXTURE_SIZE_WIDTH__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_SIZE_WIDTH(uint32_t val)
{
	return ((val) << A6XX_TPL1_A2D_SRC_TEXTURE_SIZE_WIDTH__SHIFT) & A6XX_TPL1_A2D_SRC_TEXTURE_SIZE_WIDTH__MASK;
}
#define A6XX_TPL1_A2D_SRC_TEXTURE_SIZE_HEIGHT__MASK		0x3fff8000ull
#define A6XX_TPL1_A2D_SRC_TEXTURE_SIZE_HEIGHT__SHIFT		15
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_SIZE_HEIGHT(uint32_t val)
{
	return ((val) << A6XX_TPL1_A2D_SRC_TEXTURE_SIZE_HEIGHT__SHIFT) & A6XX_TPL1_A2D_SRC_TEXTURE_SIZE_HEIGHT__MASK;
}


#define REG_A6XX_TPL1_A2D_SRC_TEXTURE_BASE			__FD_DEPRECATED 0x0000b4c2
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_TPL1_A2D_SRC_TEXTURE_PITCH			__FD_DEPRECATED 0x0000b4c4
#define A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_UNK0__MASK		0x000001ffull
#define A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_UNK0__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_UNK0(uint32_t val)
{
	return ((val) << A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_UNK0__SHIFT) & A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_UNK0__MASK;
}
#define A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_PITCH__MASK		0x00fffe00ull
#define A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_PITCH__SHIFT		9
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_PITCH__SHIFT) & A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_PITCH__MASK;
}


#define REG_A7XX_TPL1_A2D_SRC_TEXTURE_INFO			__FD_DEPRECATED 0x0000b2c0
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_FORMAT__MASK	0x000000ffull
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_FORMAT__SHIFT	0
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_FORMAT(enum a6xx_format val)
{
	return ((val) << A7XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_FORMAT__SHIFT) & A7XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_FORMAT__MASK;
}
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_TILE_MODE__MASK		0x00000300ull
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_TILE_MODE__SHIFT		8
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_SRC_TEXTURE_INFO_TILE_MODE(enum a6xx_tile_mode val)
{
	return ((val) << A7XX_TPL1_A2D_SRC_TEXTURE_INFO_TILE_MODE__SHIFT) & A7XX_TPL1_A2D_SRC_TEXTURE_INFO_TILE_MODE__MASK;
}
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_SWAP__MASK		0x00000c00ull
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_SWAP__SHIFT	10
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_SWAP(enum a3xx_color_swap val)
{
	return ((val) << A7XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_SWAP__SHIFT) & A7XX_TPL1_A2D_SRC_TEXTURE_INFO_COLOR_SWAP__MASK;
}
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_FLAGS			0x00001000
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_SRGB			0x00002000
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_SAMPLES__MASK		0x0000c000ull
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_SAMPLES__SHIFT		14
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_SRC_TEXTURE_INFO_SAMPLES(enum a3xx_msaa_samples val)
{
	return ((val) << A7XX_TPL1_A2D_SRC_TEXTURE_INFO_SAMPLES__SHIFT) & A7XX_TPL1_A2D_SRC_TEXTURE_INFO_SAMPLES__MASK;
}
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_FILTER			0x00010000
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK17			0x00020000
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_SAMPLES_AVERAGE		0x00040000
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK19			0x00080000
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK20			0x00100000
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK21			0x00200000
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK22			0x00400000
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK23__MASK		0x07800000ull
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK23__SHIFT		23
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK23(uint32_t val)
{
	return ((val) << A7XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK23__SHIFT) & A7XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK23__MASK;
}
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_UNK28			0x10000000
#define A7XX_TPL1_A2D_SRC_TEXTURE_INFO_MUTABLEEN		0x20000000


#define REG_A7XX_TPL1_A2D_SRC_TEXTURE_SIZE			__FD_DEPRECATED 0x0000b2c1
#define A7XX_TPL1_A2D_SRC_TEXTURE_SIZE_WIDTH__MASK		0x00007fffull
#define A7XX_TPL1_A2D_SRC_TEXTURE_SIZE_WIDTH__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_SRC_TEXTURE_SIZE_WIDTH(uint32_t val)
{
	return ((val) << A7XX_TPL1_A2D_SRC_TEXTURE_SIZE_WIDTH__SHIFT) & A7XX_TPL1_A2D_SRC_TEXTURE_SIZE_WIDTH__MASK;
}
#define A7XX_TPL1_A2D_SRC_TEXTURE_SIZE_HEIGHT__MASK		0x3fff8000ull
#define A7XX_TPL1_A2D_SRC_TEXTURE_SIZE_HEIGHT__SHIFT		15
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_SRC_TEXTURE_SIZE_HEIGHT(uint32_t val)
{
	return ((val) << A7XX_TPL1_A2D_SRC_TEXTURE_SIZE_HEIGHT__SHIFT) & A7XX_TPL1_A2D_SRC_TEXTURE_SIZE_HEIGHT__MASK;
}


#define REG_A7XX_TPL1_A2D_SRC_TEXTURE_BASE			__FD_DEPRECATED 0x0000b2c2
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_SRC_TEXTURE_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_SRC_TEXTURE_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A8XX_TPL1_A2D_SRC_TEXTURE_BASE			__FD_DEPRECATED 0x0000b2c2
static CONSTEXPR inline uint32_t A8XX_TPL1_A2D_SRC_TEXTURE_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A8XX_TPL1_A2D_SRC_TEXTURE_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A7XX_TPL1_A2D_SRC_TEXTURE_PITCH			__FD_DEPRECATED 0x0000b2c4
#define A7XX_TPL1_A2D_SRC_TEXTURE_PITCH_PITCH__MASK		0x00fffff8ull
#define A7XX_TPL1_A2D_SRC_TEXTURE_PITCH_PITCH__SHIFT		3
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_SRC_TEXTURE_PITCH_PITCH(uint32_t val)
{
	return ((val) << A7XX_TPL1_A2D_SRC_TEXTURE_PITCH_PITCH__SHIFT) & A7XX_TPL1_A2D_SRC_TEXTURE_PITCH_PITCH__MASK;
}


#define REG_A6XX_TPL1_A2D_SRC_TEXTURE_BASE_1			__FD_DEPRECATED 0x0000b4c5
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_BASE_1_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_BASE_1_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_1			__FD_DEPRECATED 0x0000b4c7
#define A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_1__MASK			0x00000fffull
#define A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_1__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_1(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_1__SHIFT) & A6XX_TPL1_A2D_SRC_TEXTURE_PITCH_1__MASK;
}


#define REG_A6XX_TPL1_A2D_SRC_TEXTURE_BASE_2			__FD_DEPRECATED 0x0000b4c8
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_BASE_2_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_BASE_2_HI(uint32_t val)
{
	return val;
}


#define REG_A7XX_TPL1_A2D_SRC_TEXTURE_BASE_1			__FD_DEPRECATED 0x0000b2c5
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_SRC_TEXTURE_BASE_1_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_SRC_TEXTURE_BASE_1_HI(uint32_t val)
{
	return val;
}


#define REG_A7XX_TPL1_A2D_SRC_TEXTURE_PITCH_1			__FD_DEPRECATED 0x0000b2c7
#define A7XX_TPL1_A2D_SRC_TEXTURE_PITCH_1__MASK			0x00000fffull
#define A7XX_TPL1_A2D_SRC_TEXTURE_PITCH_1__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_SRC_TEXTURE_PITCH_1(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A7XX_TPL1_A2D_SRC_TEXTURE_PITCH_1__SHIFT) & A7XX_TPL1_A2D_SRC_TEXTURE_PITCH_1__MASK;
}


#define REG_A7XX_TPL1_A2D_SRC_TEXTURE_BASE_2			__FD_DEPRECATED 0x0000b2c8
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_SRC_TEXTURE_BASE_2_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_SRC_TEXTURE_BASE_2_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_TPL1_A2D_SRC_TEXTURE_FLAG_BASE			__FD_DEPRECATED 0x0000b4ca
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_FLAG_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_FLAG_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH		__FD_DEPRECATED 0x0000b4cc
#define A6XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH__MASK		0x000000ffull
#define A6XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A6XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH__SHIFT) & A6XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH__MASK;
}


#define REG_A7XX_TPL1_A2D_SRC_TEXTURE_FLAG_BASE			__FD_DEPRECATED 0x0000b2ca
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_SRC_TEXTURE_FLAG_BASE_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_SRC_TEXTURE_FLAG_BASE_HI(uint32_t val)
{
	return val;
}


#define REG_A7XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH		__FD_DEPRECATED 0x0000b2cc
#define A7XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH__MASK		0x000000ffull
#define A7XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH(uint32_t val)
{
	assert(!(val & 0x3f));
	return (((val >> 6)) << A7XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH__SHIFT) & A7XX_TPL1_A2D_SRC_TEXTURE_FLAG_PITCH__MASK;
}


#define REG_A6XX_SP_PS_UNKNOWN_B4CD				__FD_DEPRECATED 0x0000b4cd


#define REG_A6XX_SP_PS_UNKNOWN_B4CE				__FD_DEPRECATED 0x0000b4ce


#define REG_A6XX_SP_PS_UNKNOWN_B4CF				__FD_DEPRECATED 0x0000b4cf


#define REG_A6XX_SP_PS_UNKNOWN_B4D0				__FD_DEPRECATED 0x0000b4d0


#define REG_A6XX_SP_WINDOW_OFFSET				__FD_DEPRECATED 0x0000b4d1
#define A6XX_SP_WINDOW_OFFSET_X__MASK				0x00003fffull
#define A6XX_SP_WINDOW_OFFSET_X__SHIFT				0
static CONSTEXPR inline uint32_t A6XX_SP_WINDOW_OFFSET_X(uint32_t val)
{
	return ((val) << A6XX_SP_WINDOW_OFFSET_X__SHIFT) & A6XX_SP_WINDOW_OFFSET_X__MASK;
}
#define A6XX_SP_WINDOW_OFFSET_Y__MASK				0x3fff0000ull
#define A6XX_SP_WINDOW_OFFSET_Y__SHIFT				16
static CONSTEXPR inline uint32_t A6XX_SP_WINDOW_OFFSET_Y(uint32_t val)
{
	return ((val) << A6XX_SP_WINDOW_OFFSET_Y__SHIFT) & A6XX_SP_WINDOW_OFFSET_Y__MASK;
}


#define REG_A7XX_SP_PS_UNKNOWN_B4CD				__FD_DEPRECATED 0x0000b2cd


#define REG_A7XX_SP_PS_UNKNOWN_B4CE				__FD_DEPRECATED 0x0000b2ce


#define REG_A7XX_SP_PS_UNKNOWN_B4CF				__FD_DEPRECATED 0x0000b2cf


#define REG_A7XX_SP_PS_UNKNOWN_B4D0				__FD_DEPRECATED 0x0000b2d0


#define REG_A7XX_TPL1_A2D_WINDOW_OFFSET				__FD_DEPRECATED 0x0000b2d1
#define A7XX_TPL1_A2D_WINDOW_OFFSET_X__MASK			0x00003fffull
#define A7XX_TPL1_A2D_WINDOW_OFFSET_X__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_WINDOW_OFFSET_X(uint32_t val)
{
	return ((val) << A7XX_TPL1_A2D_WINDOW_OFFSET_X__SHIFT) & A7XX_TPL1_A2D_WINDOW_OFFSET_X__MASK;
}
#define A7XX_TPL1_A2D_WINDOW_OFFSET_Y__MASK			0x3fff0000ull
#define A7XX_TPL1_A2D_WINDOW_OFFSET_Y__SHIFT			16
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_WINDOW_OFFSET_Y(uint32_t val)
{
	return ((val) << A7XX_TPL1_A2D_WINDOW_OFFSET_Y__SHIFT) & A7XX_TPL1_A2D_WINDOW_OFFSET_Y__MASK;
}


#define REG_A7XX_TPL1_A2D_BLT_CNTL				__FD_DEPRECATED 0x0000b2d2
#define A7XX_TPL1_A2D_BLT_CNTL_RAW_COPY				0x00000001
#define A7XX_TPL1_A2D_BLT_CNTL_TYPE__MASK			0xe0000000ull
#define A7XX_TPL1_A2D_BLT_CNTL_TYPE__SHIFT			29
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_BLT_CNTL_TYPE(enum a6xx_tex_type val)
{
	return ((val) << A7XX_TPL1_A2D_BLT_CNTL_TYPE__SHIFT) & A7XX_TPL1_A2D_BLT_CNTL_TYPE__MASK;
}
#define A7XX_TPL1_A2D_BLT_CNTL_START_OFFSET_TEXELS__MASK	0x003f0000ull
#define A7XX_TPL1_A2D_BLT_CNTL_START_OFFSET_TEXELS__SHIFT	16
static CONSTEXPR inline uint32_t A7XX_TPL1_A2D_BLT_CNTL_START_OFFSET_TEXELS(uint32_t val)
{
	return ((val) << A7XX_TPL1_A2D_BLT_CNTL_START_OFFSET_TEXELS__SHIFT) & A7XX_TPL1_A2D_BLT_CNTL_START_OFFSET_TEXELS__MASK;
}


#define REG_A8XX_TPL1_A2D_BLT_CNTL				__FD_DEPRECATED 0x0000b2d2
#define A8XX_TPL1_A2D_BLT_CNTL_RAW_COPY				0x00000001
#define A8XX_TPL1_A2D_BLT_CNTL_TYPE__MASK			0xe0000000ull
#define A8XX_TPL1_A2D_BLT_CNTL_TYPE__SHIFT			29
static CONSTEXPR inline uint32_t A8XX_TPL1_A2D_BLT_CNTL_TYPE(enum a6xx_tex_type val)
{
	return ((val) << A8XX_TPL1_A2D_BLT_CNTL_TYPE__SHIFT) & A8XX_TPL1_A2D_BLT_CNTL_TYPE__MASK;
}


#define REG_A7XX_SP_WINDOW_OFFSET				__FD_DEPRECATED 0x0000ab21
#define A7XX_SP_WINDOW_OFFSET_X__MASK				0x00003fffull
#define A7XX_SP_WINDOW_OFFSET_X__SHIFT				0
static CONSTEXPR inline uint32_t A7XX_SP_WINDOW_OFFSET_X(uint32_t val)
{
	return ((val) << A7XX_SP_WINDOW_OFFSET_X__SHIFT) & A7XX_SP_WINDOW_OFFSET_X__MASK;
}
#define A7XX_SP_WINDOW_OFFSET_Y__MASK				0x3fff0000ull
#define A7XX_SP_WINDOW_OFFSET_Y__SHIFT				16
static CONSTEXPR inline uint32_t A7XX_SP_WINDOW_OFFSET_Y(uint32_t val)
{
	return ((val) << A7XX_SP_WINDOW_OFFSET_Y__SHIFT) & A7XX_SP_WINDOW_OFFSET_Y__MASK;
}


#define REG_A8XX_SP_WINDOW_OFFSET				__FD_DEPRECATED 0x0000ab07
#define A8XX_SP_WINDOW_OFFSET_X__MASK				0x00003fffull
#define A8XX_SP_WINDOW_OFFSET_X__SHIFT				0
static CONSTEXPR inline uint32_t A8XX_SP_WINDOW_OFFSET_X(uint32_t val)
{
	return ((val) << A8XX_SP_WINDOW_OFFSET_X__SHIFT) & A8XX_SP_WINDOW_OFFSET_X__MASK;
}
#define A8XX_SP_WINDOW_OFFSET_Y__MASK				0x3fff0000ull
#define A8XX_SP_WINDOW_OFFSET_Y__SHIFT				16
static CONSTEXPR inline uint32_t A8XX_SP_WINDOW_OFFSET_Y(uint32_t val)
{
	return ((val) << A8XX_SP_WINDOW_OFFSET_Y__SHIFT) & A8XX_SP_WINDOW_OFFSET_Y__MASK;
}


#define REG_A6XX_TPL1_DBG_ECO_CNTL				0x0000b600
#define A6XX_TPL1_DBG_ECO_CNTL_LINEAR_MIPMAP_FALLBACK_IN_BLOCKS	0x02000000


#define REG_A6XX_TPL1_ADDR_MODE_CNTL				__FD_DEPRECATED 0x0000b601


#define REG_A6XX_TPL1_DBG_ECO_CNTL1				0x0000b602
#define A6XX_TPL1_DBG_ECO_CNTL1_TP_UBWC_FLAG_HINT		0x00040000


#define REG_A6XX_TPL1_NC_MODE_CNTL				0x0000b604
#define A6XX_TPL1_NC_MODE_CNTL_MODE				0x00000001
#define A6XX_TPL1_NC_MODE_CNTL_LOWER_BIT__MASK			0x00000006ull
#define A6XX_TPL1_NC_MODE_CNTL_LOWER_BIT__SHIFT			1
static CONSTEXPR inline uint32_t A6XX_TPL1_NC_MODE_CNTL_LOWER_BIT(uint32_t val)
{
	return ((val) << A6XX_TPL1_NC_MODE_CNTL_LOWER_BIT__SHIFT) & A6XX_TPL1_NC_MODE_CNTL_LOWER_BIT__MASK;
}
#define A6XX_TPL1_NC_MODE_CNTL_MIN_ACCESS_LENGTH		0x00000008
#define A6XX_TPL1_NC_MODE_CNTL_UPPER_BIT__MASK			0x00000010ull
#define A6XX_TPL1_NC_MODE_CNTL_UPPER_BIT__SHIFT			4
static CONSTEXPR inline uint32_t A6XX_TPL1_NC_MODE_CNTL_UPPER_BIT(uint32_t val)
{
	return ((val) << A6XX_TPL1_NC_MODE_CNTL_UPPER_BIT__SHIFT) & A6XX_TPL1_NC_MODE_CNTL_UPPER_BIT__MASK;
}
#define A6XX_TPL1_NC_MODE_CNTL_UNK6__MASK			0x000000c0ull
#define A6XX_TPL1_NC_MODE_CNTL_UNK6__SHIFT			6
static CONSTEXPR inline uint32_t A6XX_TPL1_NC_MODE_CNTL_UNK6(uint32_t val)
{
	return ((val) << A6XX_TPL1_NC_MODE_CNTL_UNK6__SHIFT) & A6XX_TPL1_NC_MODE_CNTL_UNK6__MASK;
}


#define REG_A6XX_TPL1_UNKNOWN_B605				__FD_DEPRECATED 0x0000b605


#define REG_A6XX_TPL1_BICUBIC_WEIGHTS_TABLE(i0)			(0x0000b608 + 0x1*i0 )



#define REG_A7XX_TPL1_BICUBIC_WEIGHTS_TABLE(i0)			(0x0000b608 + 0x1*i0 )



#define REG_A8XX_TPL1_BICUBIC_WEIGHTS_TABLE(i0)			(0x0000b606 + 0x1*i0 )



#define REG_A6XX_TPL1_PERFCTR_TP_SEL(i0)			(0x0000b610 + 0x1*i0 )



#define REG_A7XX_TPL1_PERFCTR_TP_SEL(i0)			(0x0000b610 + 0x1*i0 )



#define REG_A8XX_TPL1_PERFCTR_TP_SEL(i0)			(0x0000b620 + 0x1*i0 )



#define REG_A6XX_SP_VS_CONST_CONFIG				__FD_DEPRECATED 0x0000b800
#define A6XX_SP_VS_CONST_CONFIG_CONSTLEN__MASK			0x000000ffull
#define A6XX_SP_VS_CONST_CONFIG_CONSTLEN__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_VS_CONST_CONFIG_CONSTLEN(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A6XX_SP_VS_CONST_CONFIG_CONSTLEN__SHIFT) & A6XX_SP_VS_CONST_CONFIG_CONSTLEN__MASK;
}
#define A6XX_SP_VS_CONST_CONFIG_ENABLED				0x00000100
#define A6XX_SP_VS_CONST_CONFIG_READ_IMM_SHARED_CONSTS		0x00000200


#define REG_A6XX_SP_HS_CONST_CONFIG				__FD_DEPRECATED 0x0000b801
#define A6XX_SP_HS_CONST_CONFIG_CONSTLEN__MASK			0x000000ffull
#define A6XX_SP_HS_CONST_CONFIG_CONSTLEN__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_HS_CONST_CONFIG_CONSTLEN(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A6XX_SP_HS_CONST_CONFIG_CONSTLEN__SHIFT) & A6XX_SP_HS_CONST_CONFIG_CONSTLEN__MASK;
}
#define A6XX_SP_HS_CONST_CONFIG_ENABLED				0x00000100
#define A6XX_SP_HS_CONST_CONFIG_READ_IMM_SHARED_CONSTS		0x00000200


#define REG_A6XX_SP_DS_CONST_CONFIG				__FD_DEPRECATED 0x0000b802
#define A6XX_SP_DS_CONST_CONFIG_CONSTLEN__MASK			0x000000ffull
#define A6XX_SP_DS_CONST_CONFIG_CONSTLEN__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_DS_CONST_CONFIG_CONSTLEN(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A6XX_SP_DS_CONST_CONFIG_CONSTLEN__SHIFT) & A6XX_SP_DS_CONST_CONFIG_CONSTLEN__MASK;
}
#define A6XX_SP_DS_CONST_CONFIG_ENABLED				0x00000100
#define A6XX_SP_DS_CONST_CONFIG_READ_IMM_SHARED_CONSTS		0x00000200


#define REG_A6XX_SP_GS_CONST_CONFIG				__FD_DEPRECATED 0x0000b803
#define A6XX_SP_GS_CONST_CONFIG_CONSTLEN__MASK			0x000000ffull
#define A6XX_SP_GS_CONST_CONFIG_CONSTLEN__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_GS_CONST_CONFIG_CONSTLEN(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A6XX_SP_GS_CONST_CONFIG_CONSTLEN__SHIFT) & A6XX_SP_GS_CONST_CONFIG_CONSTLEN__MASK;
}
#define A6XX_SP_GS_CONST_CONFIG_ENABLED				0x00000100
#define A6XX_SP_GS_CONST_CONFIG_READ_IMM_SHARED_CONSTS		0x00000200


#define REG_A7XX_SP_VS_CONST_CONFIG				__FD_DEPRECATED 0x0000a827
#define A7XX_SP_VS_CONST_CONFIG_CONSTLEN__MASK			0x000000ffull
#define A7XX_SP_VS_CONST_CONFIG_CONSTLEN__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_SP_VS_CONST_CONFIG_CONSTLEN(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A7XX_SP_VS_CONST_CONFIG_CONSTLEN__SHIFT) & A7XX_SP_VS_CONST_CONFIG_CONSTLEN__MASK;
}
#define A7XX_SP_VS_CONST_CONFIG_ENABLED				0x00000100
#define A7XX_SP_VS_CONST_CONFIG_READ_IMM_SHARED_CONSTS		0x00000200


#define REG_A7XX_SP_HS_CONST_CONFIG				__FD_DEPRECATED 0x0000a83f
#define A7XX_SP_HS_CONST_CONFIG_CONSTLEN__MASK			0x000000ffull
#define A7XX_SP_HS_CONST_CONFIG_CONSTLEN__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_SP_HS_CONST_CONFIG_CONSTLEN(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A7XX_SP_HS_CONST_CONFIG_CONSTLEN__SHIFT) & A7XX_SP_HS_CONST_CONFIG_CONSTLEN__MASK;
}
#define A7XX_SP_HS_CONST_CONFIG_ENABLED				0x00000100
#define A7XX_SP_HS_CONST_CONFIG_READ_IMM_SHARED_CONSTS		0x00000200


#define REG_A7XX_SP_DS_CONST_CONFIG				__FD_DEPRECATED 0x0000a867
#define A7XX_SP_DS_CONST_CONFIG_CONSTLEN__MASK			0x000000ffull
#define A7XX_SP_DS_CONST_CONFIG_CONSTLEN__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_SP_DS_CONST_CONFIG_CONSTLEN(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A7XX_SP_DS_CONST_CONFIG_CONSTLEN__SHIFT) & A7XX_SP_DS_CONST_CONFIG_CONSTLEN__MASK;
}
#define A7XX_SP_DS_CONST_CONFIG_ENABLED				0x00000100
#define A7XX_SP_DS_CONST_CONFIG_READ_IMM_SHARED_CONSTS		0x00000200


#define REG_A7XX_SP_GS_CONST_CONFIG				__FD_DEPRECATED 0x0000a898
#define A7XX_SP_GS_CONST_CONFIG_CONSTLEN__MASK			0x000000ffull
#define A7XX_SP_GS_CONST_CONFIG_CONSTLEN__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_SP_GS_CONST_CONFIG_CONSTLEN(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A7XX_SP_GS_CONST_CONFIG_CONSTLEN__SHIFT) & A7XX_SP_GS_CONST_CONFIG_CONSTLEN__MASK;
}
#define A7XX_SP_GS_CONST_CONFIG_ENABLED				0x00000100
#define A7XX_SP_GS_CONST_CONFIG_READ_IMM_SHARED_CONSTS		0x00000200


#define REG_A7XX_SP_RENDER_CNTL					__FD_DEPRECATED 0x0000a9aa
#define A7XX_SP_RENDER_CNTL_FS_DISABLE				0x00000001


#define REG_A7XX_SP_DITHER_CNTL					__FD_DEPRECATED 0x0000a9ac
#define A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT0__MASK		0x00000003ull
#define A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT0__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT0(enum adreno_rb_dither_mode val)
{
	return ((val) << A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT0__SHIFT) & A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT0__MASK;
}
#define A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT1__MASK		0x0000000cull
#define A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT1__SHIFT		2
static CONSTEXPR inline uint32_t A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT1(enum adreno_rb_dither_mode val)
{
	return ((val) << A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT1__SHIFT) & A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT1__MASK;
}
#define A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT2__MASK		0x00000030ull
#define A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT2__SHIFT		4
static CONSTEXPR inline uint32_t A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT2(enum adreno_rb_dither_mode val)
{
	return ((val) << A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT2__SHIFT) & A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT2__MASK;
}
#define A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT3__MASK		0x000000c0ull
#define A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT3__SHIFT		6
static CONSTEXPR inline uint32_t A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT3(enum adreno_rb_dither_mode val)
{
	return ((val) << A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT3__SHIFT) & A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT3__MASK;
}
#define A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT4__MASK		0x00000300ull
#define A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT4__SHIFT		8
static CONSTEXPR inline uint32_t A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT4(enum adreno_rb_dither_mode val)
{
	return ((val) << A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT4__SHIFT) & A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT4__MASK;
}
#define A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT5__MASK		0x00000c00ull
#define A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT5__SHIFT		10
static CONSTEXPR inline uint32_t A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT5(enum adreno_rb_dither_mode val)
{
	return ((val) << A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT5__SHIFT) & A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT5__MASK;
}
#define A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT6__MASK		0x00003000ull
#define A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT6__SHIFT		12
static CONSTEXPR inline uint32_t A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT6(enum adreno_rb_dither_mode val)
{
	return ((val) << A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT6__SHIFT) & A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT6__MASK;
}
#define A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT7__MASK		0x0000c000ull
#define A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT7__SHIFT		14
static CONSTEXPR inline uint32_t A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT7(enum adreno_rb_dither_mode val)
{
	return ((val) << A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT7__SHIFT) & A7XX_SP_DITHER_CNTL_DITHER_MODE_MRT7__MASK;
}


#define REG_A7XX_SP_VRS_CONFIG					__FD_DEPRECATED 0x0000a9ad
#define A7XX_SP_VRS_CONFIG_PIPELINE_FSR_ENABLE			0x00000001
#define A7XX_SP_VRS_CONFIG_ATTACHMENT_FSR_ENABLE		0x00000002
#define A7XX_SP_VRS_CONFIG_PRIMITIVE_FSR_ENABLE			0x00000008


#define REG_A7XX_SP_PS_CNTL_1					__FD_DEPRECATED 0x0000a9ae
#define A7XX_SP_PS_CNTL_1_SYSVAL_REGS_COUNT__MASK		0x000000ffull
#define A7XX_SP_PS_CNTL_1_SYSVAL_REGS_COUNT__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_SP_PS_CNTL_1_SYSVAL_REGS_COUNT(uint32_t val)
{
	return ((val) << A7XX_SP_PS_CNTL_1_SYSVAL_REGS_COUNT__SHIFT) & A7XX_SP_PS_CNTL_1_SYSVAL_REGS_COUNT__MASK;
}
#define A7XX_SP_PS_CNTL_1_DEFER_WAVE_ALLOC_DIS			0x00000100
#define A7XX_SP_PS_CNTL_1_EVICT_BUF_MODE__MASK			0x00000600ull
#define A7XX_SP_PS_CNTL_1_EVICT_BUF_MODE__SHIFT			9
static CONSTEXPR inline uint32_t A7XX_SP_PS_CNTL_1_EVICT_BUF_MODE(uint32_t val)
{
	return ((val) << A7XX_SP_PS_CNTL_1_EVICT_BUF_MODE__SHIFT) & A7XX_SP_PS_CNTL_1_EVICT_BUF_MODE__MASK;
}
#define A7XX_SP_PS_CNTL_1_WAVE_PAIR_MODE__MASK			0x00001800ull
#define A7XX_SP_PS_CNTL_1_WAVE_PAIR_MODE__SHIFT			11
static CONSTEXPR inline uint32_t A7XX_SP_PS_CNTL_1_WAVE_PAIR_MODE(uint32_t val)
{
	return ((val) << A7XX_SP_PS_CNTL_1_WAVE_PAIR_MODE__SHIFT) & A7XX_SP_PS_CNTL_1_WAVE_PAIR_MODE__MASK;
}
#define A7XX_SP_PS_CNTL_1_NUM_TOTAL_VAR__MASK			0x001fe000ull
#define A7XX_SP_PS_CNTL_1_NUM_TOTAL_VAR__SHIFT			13
static CONSTEXPR inline uint32_t A7XX_SP_PS_CNTL_1_NUM_TOTAL_VAR(uint32_t val)
{
	return ((val) << A7XX_SP_PS_CNTL_1_NUM_TOTAL_VAR__SHIFT) & A7XX_SP_PS_CNTL_1_NUM_TOTAL_VAR__MASK;
}


#define REG_A6XX_HLSQ_LOAD_STATE_GEOM_CMD			0x0000b820


#define REG_A6XX_HLSQ_LOAD_STATE_GEOM_EXT_SRC_ADDR		0x0000b821
static CONSTEXPR inline uint32_t A6XX_HLSQ_LOAD_STATE_GEOM_EXT_SRC_ADDR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_HLSQ_LOAD_STATE_GEOM_EXT_SRC_ADDR_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_HLSQ_LOAD_STATE_GEOM_DATA			0x0000b823


#define REG_A6XX_SP_PS_WAVE_CNTL				__FD_DEPRECATED 0x0000b980
#define A6XX_SP_PS_WAVE_CNTL_THREADSIZE__MASK			0x00000001ull
#define A6XX_SP_PS_WAVE_CNTL_THREADSIZE__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_PS_WAVE_CNTL_THREADSIZE(enum a6xx_threadsize val)
{
	return ((val) << A6XX_SP_PS_WAVE_CNTL_THREADSIZE__SHIFT) & A6XX_SP_PS_WAVE_CNTL_THREADSIZE__MASK;
}
#define A6XX_SP_PS_WAVE_CNTL_VARYINGS				0x00000002
#define A6XX_SP_PS_WAVE_CNTL_UNK2__MASK				0x00000ffcull
#define A6XX_SP_PS_WAVE_CNTL_UNK2__SHIFT			2
static CONSTEXPR inline uint32_t A6XX_SP_PS_WAVE_CNTL_UNK2(uint32_t val)
{
	return ((val) << A6XX_SP_PS_WAVE_CNTL_UNK2__SHIFT) & A6XX_SP_PS_WAVE_CNTL_UNK2__MASK;
}


#define REG_A6XX_HLSQ_UNKNOWN_B981				__FD_DEPRECATED 0x0000b981


#define REG_A6XX_SP_LB_PARAM_LIMIT				__FD_DEPRECATED 0x0000b982
#define A6XX_SP_LB_PARAM_LIMIT_PRIMALLOCTHRESHOLD__MASK		0x00000007ull
#define A6XX_SP_LB_PARAM_LIMIT_PRIMALLOCTHRESHOLD__SHIFT	0
static CONSTEXPR inline uint32_t A6XX_SP_LB_PARAM_LIMIT_PRIMALLOCTHRESHOLD(uint32_t val)
{
	return ((val) << A6XX_SP_LB_PARAM_LIMIT_PRIMALLOCTHRESHOLD__SHIFT) & A6XX_SP_LB_PARAM_LIMIT_PRIMALLOCTHRESHOLD__MASK;
}


#define REG_A6XX_SP_REG_PROG_ID_0				__FD_DEPRECATED 0x0000b983
#define A6XX_SP_REG_PROG_ID_0_FACEREGID__MASK			0x000000ffull
#define A6XX_SP_REG_PROG_ID_0_FACEREGID__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_REG_PROG_ID_0_FACEREGID(uint32_t val)
{
	return ((val) << A6XX_SP_REG_PROG_ID_0_FACEREGID__SHIFT) & A6XX_SP_REG_PROG_ID_0_FACEREGID__MASK;
}
#define A6XX_SP_REG_PROG_ID_0_SAMPLEID__MASK			0x0000ff00ull
#define A6XX_SP_REG_PROG_ID_0_SAMPLEID__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_SP_REG_PROG_ID_0_SAMPLEID(uint32_t val)
{
	return ((val) << A6XX_SP_REG_PROG_ID_0_SAMPLEID__SHIFT) & A6XX_SP_REG_PROG_ID_0_SAMPLEID__MASK;
}
#define A6XX_SP_REG_PROG_ID_0_SAMPLEMASK__MASK			0x00ff0000ull
#define A6XX_SP_REG_PROG_ID_0_SAMPLEMASK__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_SP_REG_PROG_ID_0_SAMPLEMASK(uint32_t val)
{
	return ((val) << A6XX_SP_REG_PROG_ID_0_SAMPLEMASK__SHIFT) & A6XX_SP_REG_PROG_ID_0_SAMPLEMASK__MASK;
}
#define A6XX_SP_REG_PROG_ID_0_CENTERRHW__MASK			0xff000000ull
#define A6XX_SP_REG_PROG_ID_0_CENTERRHW__SHIFT			24
static CONSTEXPR inline uint32_t A6XX_SP_REG_PROG_ID_0_CENTERRHW(uint32_t val)
{
	return ((val) << A6XX_SP_REG_PROG_ID_0_CENTERRHW__SHIFT) & A6XX_SP_REG_PROG_ID_0_CENTERRHW__MASK;
}


#define REG_A6XX_SP_REG_PROG_ID_1				__FD_DEPRECATED 0x0000b984
#define A6XX_SP_REG_PROG_ID_1_IJ_PERSP_PIXEL__MASK		0x000000ffull
#define A6XX_SP_REG_PROG_ID_1_IJ_PERSP_PIXEL__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_REG_PROG_ID_1_IJ_PERSP_PIXEL(uint32_t val)
{
	return ((val) << A6XX_SP_REG_PROG_ID_1_IJ_PERSP_PIXEL__SHIFT) & A6XX_SP_REG_PROG_ID_1_IJ_PERSP_PIXEL__MASK;
}
#define A6XX_SP_REG_PROG_ID_1_IJ_LINEAR_PIXEL__MASK		0x0000ff00ull
#define A6XX_SP_REG_PROG_ID_1_IJ_LINEAR_PIXEL__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_SP_REG_PROG_ID_1_IJ_LINEAR_PIXEL(uint32_t val)
{
	return ((val) << A6XX_SP_REG_PROG_ID_1_IJ_LINEAR_PIXEL__SHIFT) & A6XX_SP_REG_PROG_ID_1_IJ_LINEAR_PIXEL__MASK;
}
#define A6XX_SP_REG_PROG_ID_1_IJ_PERSP_CENTROID__MASK		0x00ff0000ull
#define A6XX_SP_REG_PROG_ID_1_IJ_PERSP_CENTROID__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_SP_REG_PROG_ID_1_IJ_PERSP_CENTROID(uint32_t val)
{
	return ((val) << A6XX_SP_REG_PROG_ID_1_IJ_PERSP_CENTROID__SHIFT) & A6XX_SP_REG_PROG_ID_1_IJ_PERSP_CENTROID__MASK;
}
#define A6XX_SP_REG_PROG_ID_1_IJ_LINEAR_CENTROID__MASK		0xff000000ull
#define A6XX_SP_REG_PROG_ID_1_IJ_LINEAR_CENTROID__SHIFT		24
static CONSTEXPR inline uint32_t A6XX_SP_REG_PROG_ID_1_IJ_LINEAR_CENTROID(uint32_t val)
{
	return ((val) << A6XX_SP_REG_PROG_ID_1_IJ_LINEAR_CENTROID__SHIFT) & A6XX_SP_REG_PROG_ID_1_IJ_LINEAR_CENTROID__MASK;
}


#define REG_A6XX_SP_REG_PROG_ID_2				__FD_DEPRECATED 0x0000b985
#define A6XX_SP_REG_PROG_ID_2_IJ_PERSP_SAMPLE__MASK		0x000000ffull
#define A6XX_SP_REG_PROG_ID_2_IJ_PERSP_SAMPLE__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_REG_PROG_ID_2_IJ_PERSP_SAMPLE(uint32_t val)
{
	return ((val) << A6XX_SP_REG_PROG_ID_2_IJ_PERSP_SAMPLE__SHIFT) & A6XX_SP_REG_PROG_ID_2_IJ_PERSP_SAMPLE__MASK;
}
#define A6XX_SP_REG_PROG_ID_2_IJ_LINEAR_SAMPLE__MASK		0x0000ff00ull
#define A6XX_SP_REG_PROG_ID_2_IJ_LINEAR_SAMPLE__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_SP_REG_PROG_ID_2_IJ_LINEAR_SAMPLE(uint32_t val)
{
	return ((val) << A6XX_SP_REG_PROG_ID_2_IJ_LINEAR_SAMPLE__SHIFT) & A6XX_SP_REG_PROG_ID_2_IJ_LINEAR_SAMPLE__MASK;
}
#define A6XX_SP_REG_PROG_ID_2_XYCOORDREGID__MASK		0x00ff0000ull
#define A6XX_SP_REG_PROG_ID_2_XYCOORDREGID__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_SP_REG_PROG_ID_2_XYCOORDREGID(uint32_t val)
{
	return ((val) << A6XX_SP_REG_PROG_ID_2_XYCOORDREGID__SHIFT) & A6XX_SP_REG_PROG_ID_2_XYCOORDREGID__MASK;
}
#define A6XX_SP_REG_PROG_ID_2_ZWCOORDREGID__MASK		0xff000000ull
#define A6XX_SP_REG_PROG_ID_2_ZWCOORDREGID__SHIFT		24
static CONSTEXPR inline uint32_t A6XX_SP_REG_PROG_ID_2_ZWCOORDREGID(uint32_t val)
{
	return ((val) << A6XX_SP_REG_PROG_ID_2_ZWCOORDREGID__SHIFT) & A6XX_SP_REG_PROG_ID_2_ZWCOORDREGID__MASK;
}


#define REG_A6XX_SP_REG_PROG_ID_3				__FD_DEPRECATED 0x0000b986
#define A6XX_SP_REG_PROG_ID_3_LINELENGTHREGID__MASK		0x000000ffull
#define A6XX_SP_REG_PROG_ID_3_LINELENGTHREGID__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_REG_PROG_ID_3_LINELENGTHREGID(uint32_t val)
{
	return ((val) << A6XX_SP_REG_PROG_ID_3_LINELENGTHREGID__SHIFT) & A6XX_SP_REG_PROG_ID_3_LINELENGTHREGID__MASK;
}
#define A6XX_SP_REG_PROG_ID_3_FOVEATIONQUALITYREGID__MASK	0x0000ff00ull
#define A6XX_SP_REG_PROG_ID_3_FOVEATIONQUALITYREGID__SHIFT	8
static CONSTEXPR inline uint32_t A6XX_SP_REG_PROG_ID_3_FOVEATIONQUALITYREGID(uint32_t val)
{
	return ((val) << A6XX_SP_REG_PROG_ID_3_FOVEATIONQUALITYREGID__SHIFT) & A6XX_SP_REG_PROG_ID_3_FOVEATIONQUALITYREGID__MASK;
}


#define REG_A6XX_SP_CS_CONST_CONFIG				__FD_DEPRECATED 0x0000b987
#define A6XX_SP_CS_CONST_CONFIG_CONSTLEN__MASK			0x000000ffull
#define A6XX_SP_CS_CONST_CONFIG_CONSTLEN__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_CS_CONST_CONFIG_CONSTLEN(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A6XX_SP_CS_CONST_CONFIG_CONSTLEN__SHIFT) & A6XX_SP_CS_CONST_CONFIG_CONSTLEN__MASK;
}
#define A6XX_SP_CS_CONST_CONFIG_ENABLED				0x00000100
#define A6XX_SP_CS_CONST_CONFIG_READ_IMM_SHARED_CONSTS		0x00000200


#define REG_A7XX_SP_PS_WAVE_CNTL				__FD_DEPRECATED 0x0000a9c6
#define A7XX_SP_PS_WAVE_CNTL_THREADSIZE__MASK			0x00000001ull
#define A7XX_SP_PS_WAVE_CNTL_THREADSIZE__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_SP_PS_WAVE_CNTL_THREADSIZE(enum a6xx_threadsize val)
{
	return ((val) << A7XX_SP_PS_WAVE_CNTL_THREADSIZE__SHIFT) & A7XX_SP_PS_WAVE_CNTL_THREADSIZE__MASK;
}
#define A7XX_SP_PS_WAVE_CNTL_VARYINGS				0x00000002
#define A7XX_SP_PS_WAVE_CNTL_UNK2__MASK				0x00000ffcull
#define A7XX_SP_PS_WAVE_CNTL_UNK2__SHIFT			2
static CONSTEXPR inline uint32_t A7XX_SP_PS_WAVE_CNTL_UNK2(uint32_t val)
{
	return ((val) << A7XX_SP_PS_WAVE_CNTL_UNK2__SHIFT) & A7XX_SP_PS_WAVE_CNTL_UNK2__MASK;
}


#define REG_A8XX_SP_PS_WAVE_CNTL				__FD_DEPRECATED 0x0000a9c6
#define A8XX_SP_PS_WAVE_CNTL_VARYINGS				0x00000002


#define REG_A7XX_SP_LB_PARAM_LIMIT				__FD_DEPRECATED 0x0000a9c7
#define A7XX_SP_LB_PARAM_LIMIT_PRIMALLOCTHRESHOLD__MASK		0x00000007ull
#define A7XX_SP_LB_PARAM_LIMIT_PRIMALLOCTHRESHOLD__SHIFT	0
static CONSTEXPR inline uint32_t A7XX_SP_LB_PARAM_LIMIT_PRIMALLOCTHRESHOLD(uint32_t val)
{
	return ((val) << A7XX_SP_LB_PARAM_LIMIT_PRIMALLOCTHRESHOLD__SHIFT) & A7XX_SP_LB_PARAM_LIMIT_PRIMALLOCTHRESHOLD__MASK;
}


#define REG_A7XX_SP_REG_PROG_ID_0				__FD_DEPRECATED 0x0000a9c8
#define A7XX_SP_REG_PROG_ID_0_FACEREGID__MASK			0x000000ffull
#define A7XX_SP_REG_PROG_ID_0_FACEREGID__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_SP_REG_PROG_ID_0_FACEREGID(uint32_t val)
{
	return ((val) << A7XX_SP_REG_PROG_ID_0_FACEREGID__SHIFT) & A7XX_SP_REG_PROG_ID_0_FACEREGID__MASK;
}
#define A7XX_SP_REG_PROG_ID_0_SAMPLEID__MASK			0x0000ff00ull
#define A7XX_SP_REG_PROG_ID_0_SAMPLEID__SHIFT			8
static CONSTEXPR inline uint32_t A7XX_SP_REG_PROG_ID_0_SAMPLEID(uint32_t val)
{
	return ((val) << A7XX_SP_REG_PROG_ID_0_SAMPLEID__SHIFT) & A7XX_SP_REG_PROG_ID_0_SAMPLEID__MASK;
}
#define A7XX_SP_REG_PROG_ID_0_SAMPLEMASK__MASK			0x00ff0000ull
#define A7XX_SP_REG_PROG_ID_0_SAMPLEMASK__SHIFT			16
static CONSTEXPR inline uint32_t A7XX_SP_REG_PROG_ID_0_SAMPLEMASK(uint32_t val)
{
	return ((val) << A7XX_SP_REG_PROG_ID_0_SAMPLEMASK__SHIFT) & A7XX_SP_REG_PROG_ID_0_SAMPLEMASK__MASK;
}
#define A7XX_SP_REG_PROG_ID_0_CENTERRHW__MASK			0xff000000ull
#define A7XX_SP_REG_PROG_ID_0_CENTERRHW__SHIFT			24
static CONSTEXPR inline uint32_t A7XX_SP_REG_PROG_ID_0_CENTERRHW(uint32_t val)
{
	return ((val) << A7XX_SP_REG_PROG_ID_0_CENTERRHW__SHIFT) & A7XX_SP_REG_PROG_ID_0_CENTERRHW__MASK;
}


#define REG_A7XX_SP_REG_PROG_ID_1				__FD_DEPRECATED 0x0000a9c9
#define A7XX_SP_REG_PROG_ID_1_IJ_PERSP_PIXEL__MASK		0x000000ffull
#define A7XX_SP_REG_PROG_ID_1_IJ_PERSP_PIXEL__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_SP_REG_PROG_ID_1_IJ_PERSP_PIXEL(uint32_t val)
{
	return ((val) << A7XX_SP_REG_PROG_ID_1_IJ_PERSP_PIXEL__SHIFT) & A7XX_SP_REG_PROG_ID_1_IJ_PERSP_PIXEL__MASK;
}
#define A7XX_SP_REG_PROG_ID_1_IJ_LINEAR_PIXEL__MASK		0x0000ff00ull
#define A7XX_SP_REG_PROG_ID_1_IJ_LINEAR_PIXEL__SHIFT		8
static CONSTEXPR inline uint32_t A7XX_SP_REG_PROG_ID_1_IJ_LINEAR_PIXEL(uint32_t val)
{
	return ((val) << A7XX_SP_REG_PROG_ID_1_IJ_LINEAR_PIXEL__SHIFT) & A7XX_SP_REG_PROG_ID_1_IJ_LINEAR_PIXEL__MASK;
}
#define A7XX_SP_REG_PROG_ID_1_IJ_PERSP_CENTROID__MASK		0x00ff0000ull
#define A7XX_SP_REG_PROG_ID_1_IJ_PERSP_CENTROID__SHIFT		16
static CONSTEXPR inline uint32_t A7XX_SP_REG_PROG_ID_1_IJ_PERSP_CENTROID(uint32_t val)
{
	return ((val) << A7XX_SP_REG_PROG_ID_1_IJ_PERSP_CENTROID__SHIFT) & A7XX_SP_REG_PROG_ID_1_IJ_PERSP_CENTROID__MASK;
}
#define A7XX_SP_REG_PROG_ID_1_IJ_LINEAR_CENTROID__MASK		0xff000000ull
#define A7XX_SP_REG_PROG_ID_1_IJ_LINEAR_CENTROID__SHIFT		24
static CONSTEXPR inline uint32_t A7XX_SP_REG_PROG_ID_1_IJ_LINEAR_CENTROID(uint32_t val)
{
	return ((val) << A7XX_SP_REG_PROG_ID_1_IJ_LINEAR_CENTROID__SHIFT) & A7XX_SP_REG_PROG_ID_1_IJ_LINEAR_CENTROID__MASK;
}


#define REG_A7XX_SP_REG_PROG_ID_2				__FD_DEPRECATED 0x0000a9ca
#define A7XX_SP_REG_PROG_ID_2_IJ_PERSP_SAMPLE__MASK		0x000000ffull
#define A7XX_SP_REG_PROG_ID_2_IJ_PERSP_SAMPLE__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_SP_REG_PROG_ID_2_IJ_PERSP_SAMPLE(uint32_t val)
{
	return ((val) << A7XX_SP_REG_PROG_ID_2_IJ_PERSP_SAMPLE__SHIFT) & A7XX_SP_REG_PROG_ID_2_IJ_PERSP_SAMPLE__MASK;
}
#define A7XX_SP_REG_PROG_ID_2_IJ_LINEAR_SAMPLE__MASK		0x0000ff00ull
#define A7XX_SP_REG_PROG_ID_2_IJ_LINEAR_SAMPLE__SHIFT		8
static CONSTEXPR inline uint32_t A7XX_SP_REG_PROG_ID_2_IJ_LINEAR_SAMPLE(uint32_t val)
{
	return ((val) << A7XX_SP_REG_PROG_ID_2_IJ_LINEAR_SAMPLE__SHIFT) & A7XX_SP_REG_PROG_ID_2_IJ_LINEAR_SAMPLE__MASK;
}
#define A7XX_SP_REG_PROG_ID_2_XYCOORDREGID__MASK		0x00ff0000ull
#define A7XX_SP_REG_PROG_ID_2_XYCOORDREGID__SHIFT		16
static CONSTEXPR inline uint32_t A7XX_SP_REG_PROG_ID_2_XYCOORDREGID(uint32_t val)
{
	return ((val) << A7XX_SP_REG_PROG_ID_2_XYCOORDREGID__SHIFT) & A7XX_SP_REG_PROG_ID_2_XYCOORDREGID__MASK;
}
#define A7XX_SP_REG_PROG_ID_2_ZWCOORDREGID__MASK		0xff000000ull
#define A7XX_SP_REG_PROG_ID_2_ZWCOORDREGID__SHIFT		24
static CONSTEXPR inline uint32_t A7XX_SP_REG_PROG_ID_2_ZWCOORDREGID(uint32_t val)
{
	return ((val) << A7XX_SP_REG_PROG_ID_2_ZWCOORDREGID__SHIFT) & A7XX_SP_REG_PROG_ID_2_ZWCOORDREGID__MASK;
}


#define REG_A7XX_SP_REG_PROG_ID_3				__FD_DEPRECATED 0x0000a9cb
#define A7XX_SP_REG_PROG_ID_3_LINELENGTHREGID__MASK		0x000000ffull
#define A7XX_SP_REG_PROG_ID_3_LINELENGTHREGID__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_SP_REG_PROG_ID_3_LINELENGTHREGID(uint32_t val)
{
	return ((val) << A7XX_SP_REG_PROG_ID_3_LINELENGTHREGID__SHIFT) & A7XX_SP_REG_PROG_ID_3_LINELENGTHREGID__MASK;
}
#define A7XX_SP_REG_PROG_ID_3_FOVEATIONQUALITYREGID__MASK	0x0000ff00ull
#define A7XX_SP_REG_PROG_ID_3_FOVEATIONQUALITYREGID__SHIFT	8
static CONSTEXPR inline uint32_t A7XX_SP_REG_PROG_ID_3_FOVEATIONQUALITYREGID(uint32_t val)
{
	return ((val) << A7XX_SP_REG_PROG_ID_3_FOVEATIONQUALITYREGID__SHIFT) & A7XX_SP_REG_PROG_ID_3_FOVEATIONQUALITYREGID__MASK;
}


#define REG_A7XX_SP_CS_CONST_CONFIG				__FD_DEPRECATED 0x0000a9cd
#define A7XX_SP_CS_CONST_CONFIG_CONSTLEN__MASK			0x000000ffull
#define A7XX_SP_CS_CONST_CONFIG_CONSTLEN__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_SP_CS_CONST_CONFIG_CONSTLEN(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A7XX_SP_CS_CONST_CONFIG_CONSTLEN__SHIFT) & A7XX_SP_CS_CONST_CONFIG_CONSTLEN__MASK;
}
#define A7XX_SP_CS_CONST_CONFIG_ENABLED				0x00000100
#define A7XX_SP_CS_CONST_CONFIG_READ_IMM_SHARED_CONSTS		0x00000200


#define REG_A6XX_SP_CS_NDRANGE_0				__FD_DEPRECATED 0x0000b990
#define A6XX_SP_CS_NDRANGE_0_KERNELDIM__MASK			0x00000003ull
#define A6XX_SP_CS_NDRANGE_0_KERNELDIM__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_CS_NDRANGE_0_KERNELDIM(uint32_t val)
{
	return ((val) << A6XX_SP_CS_NDRANGE_0_KERNELDIM__SHIFT) & A6XX_SP_CS_NDRANGE_0_KERNELDIM__MASK;
}
#define A6XX_SP_CS_NDRANGE_0_LOCALSIZEX__MASK			0x00000ffcull
#define A6XX_SP_CS_NDRANGE_0_LOCALSIZEX__SHIFT			2
static CONSTEXPR inline uint32_t A6XX_SP_CS_NDRANGE_0_LOCALSIZEX(uint32_t val)
{
	return ((val) << A6XX_SP_CS_NDRANGE_0_LOCALSIZEX__SHIFT) & A6XX_SP_CS_NDRANGE_0_LOCALSIZEX__MASK;
}
#define A6XX_SP_CS_NDRANGE_0_LOCALSIZEY__MASK			0x003ff000ull
#define A6XX_SP_CS_NDRANGE_0_LOCALSIZEY__SHIFT			12
static CONSTEXPR inline uint32_t A6XX_SP_CS_NDRANGE_0_LOCALSIZEY(uint32_t val)
{
	return ((val) << A6XX_SP_CS_NDRANGE_0_LOCALSIZEY__SHIFT) & A6XX_SP_CS_NDRANGE_0_LOCALSIZEY__MASK;
}
#define A6XX_SP_CS_NDRANGE_0_LOCALSIZEZ__MASK			0xffc00000ull
#define A6XX_SP_CS_NDRANGE_0_LOCALSIZEZ__SHIFT			22
static CONSTEXPR inline uint32_t A6XX_SP_CS_NDRANGE_0_LOCALSIZEZ(uint32_t val)
{
	return ((val) << A6XX_SP_CS_NDRANGE_0_LOCALSIZEZ__SHIFT) & A6XX_SP_CS_NDRANGE_0_LOCALSIZEZ__MASK;
}


#define REG_A6XX_SP_CS_NDRANGE_1				__FD_DEPRECATED 0x0000b991
#define A6XX_SP_CS_NDRANGE_1_GLOBALSIZE_X__MASK			0xffffffffull
#define A6XX_SP_CS_NDRANGE_1_GLOBALSIZE_X__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_CS_NDRANGE_1_GLOBALSIZE_X(uint32_t val)
{
	return ((val) << A6XX_SP_CS_NDRANGE_1_GLOBALSIZE_X__SHIFT) & A6XX_SP_CS_NDRANGE_1_GLOBALSIZE_X__MASK;
}


#define REG_A6XX_SP_CS_NDRANGE_2				__FD_DEPRECATED 0x0000b992
#define A6XX_SP_CS_NDRANGE_2_GLOBALOFF_X__MASK			0xffffffffull
#define A6XX_SP_CS_NDRANGE_2_GLOBALOFF_X__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_CS_NDRANGE_2_GLOBALOFF_X(uint32_t val)
{
	return ((val) << A6XX_SP_CS_NDRANGE_2_GLOBALOFF_X__SHIFT) & A6XX_SP_CS_NDRANGE_2_GLOBALOFF_X__MASK;
}


#define REG_A6XX_SP_CS_NDRANGE_3				__FD_DEPRECATED 0x0000b993
#define A6XX_SP_CS_NDRANGE_3_GLOBALSIZE_Y__MASK			0xffffffffull
#define A6XX_SP_CS_NDRANGE_3_GLOBALSIZE_Y__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_CS_NDRANGE_3_GLOBALSIZE_Y(uint32_t val)
{
	return ((val) << A6XX_SP_CS_NDRANGE_3_GLOBALSIZE_Y__SHIFT) & A6XX_SP_CS_NDRANGE_3_GLOBALSIZE_Y__MASK;
}


#define REG_A6XX_SP_CS_NDRANGE_4				__FD_DEPRECATED 0x0000b994
#define A6XX_SP_CS_NDRANGE_4_GLOBALOFF_Y__MASK			0xffffffffull
#define A6XX_SP_CS_NDRANGE_4_GLOBALOFF_Y__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_CS_NDRANGE_4_GLOBALOFF_Y(uint32_t val)
{
	return ((val) << A6XX_SP_CS_NDRANGE_4_GLOBALOFF_Y__SHIFT) & A6XX_SP_CS_NDRANGE_4_GLOBALOFF_Y__MASK;
}


#define REG_A6XX_SP_CS_NDRANGE_5				__FD_DEPRECATED 0x0000b995
#define A6XX_SP_CS_NDRANGE_5_GLOBALSIZE_Z__MASK			0xffffffffull
#define A6XX_SP_CS_NDRANGE_5_GLOBALSIZE_Z__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_CS_NDRANGE_5_GLOBALSIZE_Z(uint32_t val)
{
	return ((val) << A6XX_SP_CS_NDRANGE_5_GLOBALSIZE_Z__SHIFT) & A6XX_SP_CS_NDRANGE_5_GLOBALSIZE_Z__MASK;
}


#define REG_A6XX_SP_CS_NDRANGE_6				__FD_DEPRECATED 0x0000b996
#define A6XX_SP_CS_NDRANGE_6_GLOBALOFF_Z__MASK			0xffffffffull
#define A6XX_SP_CS_NDRANGE_6_GLOBALOFF_Z__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_CS_NDRANGE_6_GLOBALOFF_Z(uint32_t val)
{
	return ((val) << A6XX_SP_CS_NDRANGE_6_GLOBALOFF_Z__SHIFT) & A6XX_SP_CS_NDRANGE_6_GLOBALOFF_Z__MASK;
}


#define REG_A6XX_SP_CS_CONST_CONFIG_0				__FD_DEPRECATED 0x0000b997
#define A6XX_SP_CS_CONST_CONFIG_0_WGIDCONSTID__MASK		0x000000ffull
#define A6XX_SP_CS_CONST_CONFIG_0_WGIDCONSTID__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_CS_CONST_CONFIG_0_WGIDCONSTID(uint32_t val)
{
	return ((val) << A6XX_SP_CS_CONST_CONFIG_0_WGIDCONSTID__SHIFT) & A6XX_SP_CS_CONST_CONFIG_0_WGIDCONSTID__MASK;
}
#define A6XX_SP_CS_CONST_CONFIG_0_WGSIZECONSTID__MASK		0x0000ff00ull
#define A6XX_SP_CS_CONST_CONFIG_0_WGSIZECONSTID__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_SP_CS_CONST_CONFIG_0_WGSIZECONSTID(uint32_t val)
{
	return ((val) << A6XX_SP_CS_CONST_CONFIG_0_WGSIZECONSTID__SHIFT) & A6XX_SP_CS_CONST_CONFIG_0_WGSIZECONSTID__MASK;
}
#define A6XX_SP_CS_CONST_CONFIG_0_WGOFFSETCONSTID__MASK		0x00ff0000ull
#define A6XX_SP_CS_CONST_CONFIG_0_WGOFFSETCONSTID__SHIFT	16
static CONSTEXPR inline uint32_t A6XX_SP_CS_CONST_CONFIG_0_WGOFFSETCONSTID(uint32_t val)
{
	return ((val) << A6XX_SP_CS_CONST_CONFIG_0_WGOFFSETCONSTID__SHIFT) & A6XX_SP_CS_CONST_CONFIG_0_WGOFFSETCONSTID__MASK;
}
#define A6XX_SP_CS_CONST_CONFIG_0_LOCALIDREGID__MASK		0xff000000ull
#define A6XX_SP_CS_CONST_CONFIG_0_LOCALIDREGID__SHIFT		24
static CONSTEXPR inline uint32_t A6XX_SP_CS_CONST_CONFIG_0_LOCALIDREGID(uint32_t val)
{
	return ((val) << A6XX_SP_CS_CONST_CONFIG_0_LOCALIDREGID__SHIFT) & A6XX_SP_CS_CONST_CONFIG_0_LOCALIDREGID__MASK;
}


#define REG_A6XX_SP_CS_WGE_CNTL					__FD_DEPRECATED 0x0000b998
#define A6XX_SP_CS_WGE_CNTL_LINEARLOCALIDREGID__MASK		0x000000ffull
#define A6XX_SP_CS_WGE_CNTL_LINEARLOCALIDREGID__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_CS_WGE_CNTL_LINEARLOCALIDREGID(uint32_t val)
{
	return ((val) << A6XX_SP_CS_WGE_CNTL_LINEARLOCALIDREGID__SHIFT) & A6XX_SP_CS_WGE_CNTL_LINEARLOCALIDREGID__MASK;
}
#define A6XX_SP_CS_WGE_CNTL_SINGLE_SP_CORE			0x00000100
#define A6XX_SP_CS_WGE_CNTL_THREADSIZE__MASK			0x00000200ull
#define A6XX_SP_CS_WGE_CNTL_THREADSIZE__SHIFT			9
static CONSTEXPR inline uint32_t A6XX_SP_CS_WGE_CNTL_THREADSIZE(enum a6xx_threadsize val)
{
	return ((val) << A6XX_SP_CS_WGE_CNTL_THREADSIZE__SHIFT) & A6XX_SP_CS_WGE_CNTL_THREADSIZE__MASK;
}
#define A6XX_SP_CS_WGE_CNTL_THREADSIZE_SCALAR			0x00000400


#define REG_A6XX_SP_CS_KERNEL_GROUP_X				__FD_DEPRECATED 0x0000b999


#define REG_A6XX_SP_CS_KERNEL_GROUP_Y				__FD_DEPRECATED 0x0000b99a


#define REG_A6XX_SP_CS_KERNEL_GROUP_Z				__FD_DEPRECATED 0x0000b99b


#define REG_A7XX_SP_CS_NDRANGE_0				__FD_DEPRECATED 0x0000a9d4
#define A7XX_SP_CS_NDRANGE_0_KERNELDIM__MASK			0x00000003ull
#define A7XX_SP_CS_NDRANGE_0_KERNELDIM__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_SP_CS_NDRANGE_0_KERNELDIM(uint32_t val)
{
	return ((val) << A7XX_SP_CS_NDRANGE_0_KERNELDIM__SHIFT) & A7XX_SP_CS_NDRANGE_0_KERNELDIM__MASK;
}
#define A7XX_SP_CS_NDRANGE_0_LOCALSIZEX__MASK			0x00000ffcull
#define A7XX_SP_CS_NDRANGE_0_LOCALSIZEX__SHIFT			2
static CONSTEXPR inline uint32_t A7XX_SP_CS_NDRANGE_0_LOCALSIZEX(uint32_t val)
{
	return ((val) << A7XX_SP_CS_NDRANGE_0_LOCALSIZEX__SHIFT) & A7XX_SP_CS_NDRANGE_0_LOCALSIZEX__MASK;
}
#define A7XX_SP_CS_NDRANGE_0_LOCALSIZEY__MASK			0x003ff000ull
#define A7XX_SP_CS_NDRANGE_0_LOCALSIZEY__SHIFT			12
static CONSTEXPR inline uint32_t A7XX_SP_CS_NDRANGE_0_LOCALSIZEY(uint32_t val)
{
	return ((val) << A7XX_SP_CS_NDRANGE_0_LOCALSIZEY__SHIFT) & A7XX_SP_CS_NDRANGE_0_LOCALSIZEY__MASK;
}
#define A7XX_SP_CS_NDRANGE_0_LOCALSIZEZ__MASK			0xffc00000ull
#define A7XX_SP_CS_NDRANGE_0_LOCALSIZEZ__SHIFT			22
static CONSTEXPR inline uint32_t A7XX_SP_CS_NDRANGE_0_LOCALSIZEZ(uint32_t val)
{
	return ((val) << A7XX_SP_CS_NDRANGE_0_LOCALSIZEZ__SHIFT) & A7XX_SP_CS_NDRANGE_0_LOCALSIZEZ__MASK;
}


#define REG_A7XX_SP_CS_NDRANGE_1				__FD_DEPRECATED 0x0000a9d5
#define A7XX_SP_CS_NDRANGE_1_GLOBALSIZE_X__MASK			0xffffffffull
#define A7XX_SP_CS_NDRANGE_1_GLOBALSIZE_X__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_SP_CS_NDRANGE_1_GLOBALSIZE_X(uint32_t val)
{
	return ((val) << A7XX_SP_CS_NDRANGE_1_GLOBALSIZE_X__SHIFT) & A7XX_SP_CS_NDRANGE_1_GLOBALSIZE_X__MASK;
}


#define REG_A7XX_SP_CS_NDRANGE_2				__FD_DEPRECATED 0x0000a9d6
#define A7XX_SP_CS_NDRANGE_2_GLOBALOFF_X__MASK			0xffffffffull
#define A7XX_SP_CS_NDRANGE_2_GLOBALOFF_X__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_SP_CS_NDRANGE_2_GLOBALOFF_X(uint32_t val)
{
	return ((val) << A7XX_SP_CS_NDRANGE_2_GLOBALOFF_X__SHIFT) & A7XX_SP_CS_NDRANGE_2_GLOBALOFF_X__MASK;
}


#define REG_A7XX_SP_CS_NDRANGE_3				__FD_DEPRECATED 0x0000a9d7
#define A7XX_SP_CS_NDRANGE_3_GLOBALSIZE_Y__MASK			0xffffffffull
#define A7XX_SP_CS_NDRANGE_3_GLOBALSIZE_Y__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_SP_CS_NDRANGE_3_GLOBALSIZE_Y(uint32_t val)
{
	return ((val) << A7XX_SP_CS_NDRANGE_3_GLOBALSIZE_Y__SHIFT) & A7XX_SP_CS_NDRANGE_3_GLOBALSIZE_Y__MASK;
}


#define REG_A7XX_SP_CS_NDRANGE_4				__FD_DEPRECATED 0x0000a9d8
#define A7XX_SP_CS_NDRANGE_4_GLOBALOFF_Y__MASK			0xffffffffull
#define A7XX_SP_CS_NDRANGE_4_GLOBALOFF_Y__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_SP_CS_NDRANGE_4_GLOBALOFF_Y(uint32_t val)
{
	return ((val) << A7XX_SP_CS_NDRANGE_4_GLOBALOFF_Y__SHIFT) & A7XX_SP_CS_NDRANGE_4_GLOBALOFF_Y__MASK;
}


#define REG_A7XX_SP_CS_NDRANGE_5				__FD_DEPRECATED 0x0000a9d9
#define A7XX_SP_CS_NDRANGE_5_GLOBALSIZE_Z__MASK			0xffffffffull
#define A7XX_SP_CS_NDRANGE_5_GLOBALSIZE_Z__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_SP_CS_NDRANGE_5_GLOBALSIZE_Z(uint32_t val)
{
	return ((val) << A7XX_SP_CS_NDRANGE_5_GLOBALSIZE_Z__SHIFT) & A7XX_SP_CS_NDRANGE_5_GLOBALSIZE_Z__MASK;
}


#define REG_A7XX_SP_CS_NDRANGE_6				__FD_DEPRECATED 0x0000a9da
#define A7XX_SP_CS_NDRANGE_6_GLOBALOFF_Z__MASK			0xffffffffull
#define A7XX_SP_CS_NDRANGE_6_GLOBALOFF_Z__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_SP_CS_NDRANGE_6_GLOBALOFF_Z(uint32_t val)
{
	return ((val) << A7XX_SP_CS_NDRANGE_6_GLOBALOFF_Z__SHIFT) & A7XX_SP_CS_NDRANGE_6_GLOBALOFF_Z__MASK;
}


#define REG_A7XX_SP_CS_KERNEL_GROUP_X				__FD_DEPRECATED 0x0000a9dc


#define REG_A7XX_SP_CS_KERNEL_GROUP_Y				__FD_DEPRECATED 0x0000a9dd


#define REG_A7XX_SP_CS_KERNEL_GROUP_Z				__FD_DEPRECATED 0x0000a9de


#define REG_A7XX_SP_CS_WGE_CNTL					__FD_DEPRECATED 0x0000a9db
#define A7XX_SP_CS_WGE_CNTL_LINEARLOCALIDREGID__MASK		0x000000ffull
#define A7XX_SP_CS_WGE_CNTL_LINEARLOCALIDREGID__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_SP_CS_WGE_CNTL_LINEARLOCALIDREGID(uint32_t val)
{
	return ((val) << A7XX_SP_CS_WGE_CNTL_LINEARLOCALIDREGID__SHIFT) & A7XX_SP_CS_WGE_CNTL_LINEARLOCALIDREGID__MASK;
}
#define A7XX_SP_CS_WGE_CNTL_THREADSIZE__MASK			0x00000200ull
#define A7XX_SP_CS_WGE_CNTL_THREADSIZE__SHIFT			9
static CONSTEXPR inline uint32_t A7XX_SP_CS_WGE_CNTL_THREADSIZE(enum a6xx_threadsize val)
{
	return ((val) << A7XX_SP_CS_WGE_CNTL_THREADSIZE__SHIFT) & A7XX_SP_CS_WGE_CNTL_THREADSIZE__MASK;
}
#define A7XX_SP_CS_WGE_CNTL_WORKGROUPRASTORDERZFIRSTEN		0x00000800
#define A7XX_SP_CS_WGE_CNTL_WGTILEWIDTH__MASK			0x03f00000ull
#define A7XX_SP_CS_WGE_CNTL_WGTILEWIDTH__SHIFT			20
static CONSTEXPR inline uint32_t A7XX_SP_CS_WGE_CNTL_WGTILEWIDTH(uint32_t val)
{
	return ((val) << A7XX_SP_CS_WGE_CNTL_WGTILEWIDTH__SHIFT) & A7XX_SP_CS_WGE_CNTL_WGTILEWIDTH__MASK;
}
#define A7XX_SP_CS_WGE_CNTL_WGTILEHEIGHT__MASK			0xfc000000ull
#define A7XX_SP_CS_WGE_CNTL_WGTILEHEIGHT__SHIFT			26
static CONSTEXPR inline uint32_t A7XX_SP_CS_WGE_CNTL_WGTILEHEIGHT(uint32_t val)
{
	return ((val) << A7XX_SP_CS_WGE_CNTL_WGTILEHEIGHT__SHIFT) & A7XX_SP_CS_WGE_CNTL_WGTILEHEIGHT__MASK;
}


#define REG_A7XX_SP_CS_NDRANGE_7				__FD_DEPRECATED 0x0000a9df
#define A7XX_SP_CS_NDRANGE_7_LOCALSIZEX__MASK			0x00000ffcull
#define A7XX_SP_CS_NDRANGE_7_LOCALSIZEX__SHIFT			2
static CONSTEXPR inline uint32_t A7XX_SP_CS_NDRANGE_7_LOCALSIZEX(uint32_t val)
{
	return ((val) << A7XX_SP_CS_NDRANGE_7_LOCALSIZEX__SHIFT) & A7XX_SP_CS_NDRANGE_7_LOCALSIZEX__MASK;
}
#define A7XX_SP_CS_NDRANGE_7_LOCALSIZEY__MASK			0x003ff000ull
#define A7XX_SP_CS_NDRANGE_7_LOCALSIZEY__SHIFT			12
static CONSTEXPR inline uint32_t A7XX_SP_CS_NDRANGE_7_LOCALSIZEY(uint32_t val)
{
	return ((val) << A7XX_SP_CS_NDRANGE_7_LOCALSIZEY__SHIFT) & A7XX_SP_CS_NDRANGE_7_LOCALSIZEY__MASK;
}
#define A7XX_SP_CS_NDRANGE_7_LOCALSIZEZ__MASK			0xffc00000ull
#define A7XX_SP_CS_NDRANGE_7_LOCALSIZEZ__SHIFT			22
static CONSTEXPR inline uint32_t A7XX_SP_CS_NDRANGE_7_LOCALSIZEZ(uint32_t val)
{
	return ((val) << A7XX_SP_CS_NDRANGE_7_LOCALSIZEZ__SHIFT) & A7XX_SP_CS_NDRANGE_7_LOCALSIZEZ__MASK;
}


#define REG_A6XX_HLSQ_LOAD_STATE_FRAG_CMD			0x0000b9a0


#define REG_A6XX_HLSQ_LOAD_STATE_FRAG_EXT_SRC_ADDR		0x0000b9a1
static CONSTEXPR inline uint32_t A6XX_HLSQ_LOAD_STATE_FRAG_EXT_SRC_ADDR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_HLSQ_LOAD_STATE_FRAG_EXT_SRC_ADDR_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_HLSQ_LOAD_STATE_FRAG_DATA			0x0000b9a3


#define REG_A6XX_HLSQ_CS_BINDLESS_BASE(i0)			(0x0000b9c0 + 0x2*i0 )

static CONSTEXPR inline uint32_t A6XX_HLSQ_CS_BINDLESS_BASE_DESCRIPTOR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_HLSQ_CS_BINDLESS_BASE_DESCRIPTOR_HI(uint32_t val)
{
	return val;
}
#define A6XX_HLSQ_CS_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__MASK	0x00000003ull
#define A6XX_HLSQ_CS_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__SHIFT	0
static CONSTEXPR inline uint64_t A6XX_HLSQ_CS_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE(enum a6xx_bindless_descriptor_size val)
{
	return ((uint64_t)(val) << A6XX_HLSQ_CS_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__SHIFT) & A6XX_HLSQ_CS_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__MASK;
}
#define A6XX_HLSQ_CS_BINDLESS_BASE_DESCRIPTOR_ADDR__MASK	0xfffffffffffffffcull
#define A6XX_HLSQ_CS_BINDLESS_BASE_DESCRIPTOR_ADDR__SHIFT	2
static CONSTEXPR inline uint64_t A6XX_HLSQ_CS_BINDLESS_BASE_DESCRIPTOR_ADDR(uint64_t val)
{
	assert(!(val & 0x3));
	return ((uint64_t)((val >> 2)) << A6XX_HLSQ_CS_BINDLESS_BASE_DESCRIPTOR_ADDR__SHIFT) & A6XX_HLSQ_CS_BINDLESS_BASE_DESCRIPTOR_ADDR__MASK;
}


#define REG_A6XX_HLSQ_CS_CTRL_REG1				__FD_DEPRECATED 0x0000b9d0
#define A6XX_HLSQ_CS_CTRL_REG1_SHARED_SIZE__MASK		0x0000001full
#define A6XX_HLSQ_CS_CTRL_REG1_SHARED_SIZE__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_HLSQ_CS_CTRL_REG1_SHARED_SIZE(uint32_t val)
{
	return ((val) << A6XX_HLSQ_CS_CTRL_REG1_SHARED_SIZE__SHIFT) & A6XX_HLSQ_CS_CTRL_REG1_SHARED_SIZE__MASK;
}
#define A6XX_HLSQ_CS_CTRL_REG1_CONSTANTRAMMODE__MASK		0x00000060ull
#define A6XX_HLSQ_CS_CTRL_REG1_CONSTANTRAMMODE__SHIFT		5
static CONSTEXPR inline uint32_t A6XX_HLSQ_CS_CTRL_REG1_CONSTANTRAMMODE(enum a6xx_const_ram_mode val)
{
	return ((val) << A6XX_HLSQ_CS_CTRL_REG1_CONSTANTRAMMODE__SHIFT) & A6XX_HLSQ_CS_CTRL_REG1_CONSTANTRAMMODE__MASK;
}


#define REG_A6XX_SP_DRAW_INITIATOR				__FD_DEPRECATED 0x0000bb00
#define A6XX_SP_DRAW_INITIATOR_STATE_ID__MASK			0x000000ffull
#define A6XX_SP_DRAW_INITIATOR_STATE_ID__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_DRAW_INITIATOR_STATE_ID(uint32_t val)
{
	return ((val) << A6XX_SP_DRAW_INITIATOR_STATE_ID__SHIFT) & A6XX_SP_DRAW_INITIATOR_STATE_ID__MASK;
}


#define REG_A6XX_SP_KERNEL_INITIATOR				__FD_DEPRECATED 0x0000bb01
#define A6XX_SP_KERNEL_INITIATOR_STATE_ID__MASK			0x000000ffull
#define A6XX_SP_KERNEL_INITIATOR_STATE_ID__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_SP_KERNEL_INITIATOR_STATE_ID(uint32_t val)
{
	return ((val) << A6XX_SP_KERNEL_INITIATOR_STATE_ID__SHIFT) & A6XX_SP_KERNEL_INITIATOR_STATE_ID__MASK;
}


#define REG_A6XX_SP_EVENT_INITIATOR				__FD_DEPRECATED 0x0000bb02
#define A6XX_SP_EVENT_INITIATOR_STATE_ID__MASK			0x00ff0000ull
#define A6XX_SP_EVENT_INITIATOR_STATE_ID__SHIFT			16
static CONSTEXPR inline uint32_t A6XX_SP_EVENT_INITIATOR_STATE_ID(uint32_t val)
{
	return ((val) << A6XX_SP_EVENT_INITIATOR_STATE_ID__SHIFT) & A6XX_SP_EVENT_INITIATOR_STATE_ID__MASK;
}
#define A6XX_SP_EVENT_INITIATOR_EVENT__MASK			0x0000007full
#define A6XX_SP_EVENT_INITIATOR_EVENT__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_EVENT_INITIATOR_EVENT(enum vgt_event_type val)
{
	return ((val) << A6XX_SP_EVENT_INITIATOR_EVENT__SHIFT) & A6XX_SP_EVENT_INITIATOR_EVENT__MASK;
}


#define REG_A6XX_SP_UPDATE_CNTL					__FD_DEPRECATED 0x0000bb08
#define A6XX_SP_UPDATE_CNTL_VS_STATE				0x00000001
#define A6XX_SP_UPDATE_CNTL_HS_STATE				0x00000002
#define A6XX_SP_UPDATE_CNTL_DS_STATE				0x00000004
#define A6XX_SP_UPDATE_CNTL_GS_STATE				0x00000008
#define A6XX_SP_UPDATE_CNTL_FS_STATE				0x00000010
#define A6XX_SP_UPDATE_CNTL_CS_STATE				0x00000020
#define A6XX_SP_UPDATE_CNTL_CS_UAV				0x00000040
#define A6XX_SP_UPDATE_CNTL_GFX_UAV				0x00000080
#define A6XX_SP_UPDATE_CNTL_CS_SHARED_CONST			0x00080000
#define A6XX_SP_UPDATE_CNTL_GFX_SHARED_CONST			0x00000100
#define A6XX_SP_UPDATE_CNTL_CS_BINDLESS__MASK			0x00003e00ull
#define A6XX_SP_UPDATE_CNTL_CS_BINDLESS__SHIFT			9
static CONSTEXPR inline uint32_t A6XX_SP_UPDATE_CNTL_CS_BINDLESS(uint32_t val)
{
	return ((val) << A6XX_SP_UPDATE_CNTL_CS_BINDLESS__SHIFT) & A6XX_SP_UPDATE_CNTL_CS_BINDLESS__MASK;
}
#define A6XX_SP_UPDATE_CNTL_GFX_BINDLESS__MASK			0x0007c000ull
#define A6XX_SP_UPDATE_CNTL_GFX_BINDLESS__SHIFT			14
static CONSTEXPR inline uint32_t A6XX_SP_UPDATE_CNTL_GFX_BINDLESS(uint32_t val)
{
	return ((val) << A6XX_SP_UPDATE_CNTL_GFX_BINDLESS__SHIFT) & A6XX_SP_UPDATE_CNTL_GFX_BINDLESS__MASK;
}


#define REG_A7XX_SP_DRAW_INITIATOR				__FD_DEPRECATED 0x0000ab1c
#define A7XX_SP_DRAW_INITIATOR_STATE_ID__MASK			0x000000ffull
#define A7XX_SP_DRAW_INITIATOR_STATE_ID__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_SP_DRAW_INITIATOR_STATE_ID(uint32_t val)
{
	return ((val) << A7XX_SP_DRAW_INITIATOR_STATE_ID__SHIFT) & A7XX_SP_DRAW_INITIATOR_STATE_ID__MASK;
}


#define REG_A7XX_SP_KERNEL_INITIATOR				__FD_DEPRECATED 0x0000ab1d
#define A7XX_SP_KERNEL_INITIATOR_STATE_ID__MASK			0x000000ffull
#define A7XX_SP_KERNEL_INITIATOR_STATE_ID__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_SP_KERNEL_INITIATOR_STATE_ID(uint32_t val)
{
	return ((val) << A7XX_SP_KERNEL_INITIATOR_STATE_ID__SHIFT) & A7XX_SP_KERNEL_INITIATOR_STATE_ID__MASK;
}


#define REG_A7XX_SP_EVENT_INITIATOR				__FD_DEPRECATED 0x0000ab1e
#define A7XX_SP_EVENT_INITIATOR_STATE_ID__MASK			0x00ff0000ull
#define A7XX_SP_EVENT_INITIATOR_STATE_ID__SHIFT			16
static CONSTEXPR inline uint32_t A7XX_SP_EVENT_INITIATOR_STATE_ID(uint32_t val)
{
	return ((val) << A7XX_SP_EVENT_INITIATOR_STATE_ID__SHIFT) & A7XX_SP_EVENT_INITIATOR_STATE_ID__MASK;
}
#define A7XX_SP_EVENT_INITIATOR_EVENT__MASK			0x0000007full
#define A7XX_SP_EVENT_INITIATOR_EVENT__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_SP_EVENT_INITIATOR_EVENT(enum vgt_event_type val)
{
	return ((val) << A7XX_SP_EVENT_INITIATOR_EVENT__SHIFT) & A7XX_SP_EVENT_INITIATOR_EVENT__MASK;
}


#define REG_A7XX_SP_UPDATE_CNTL					__FD_DEPRECATED 0x0000ab1f
#define A7XX_SP_UPDATE_CNTL_VS_STATE				0x00000001
#define A7XX_SP_UPDATE_CNTL_HS_STATE				0x00000002
#define A7XX_SP_UPDATE_CNTL_DS_STATE				0x00000004
#define A7XX_SP_UPDATE_CNTL_GS_STATE				0x00000008
#define A7XX_SP_UPDATE_CNTL_FS_STATE				0x00000010
#define A7XX_SP_UPDATE_CNTL_CS_STATE				0x00000020
#define A7XX_SP_UPDATE_CNTL_CS_UAV				0x00000040
#define A7XX_SP_UPDATE_CNTL_GFX_UAV				0x00000080
#define A7XX_SP_UPDATE_CNTL_CS_BINDLESS__MASK			0x0001fe00ull
#define A7XX_SP_UPDATE_CNTL_CS_BINDLESS__SHIFT			9
static CONSTEXPR inline uint32_t A7XX_SP_UPDATE_CNTL_CS_BINDLESS(uint32_t val)
{
	return ((val) << A7XX_SP_UPDATE_CNTL_CS_BINDLESS__SHIFT) & A7XX_SP_UPDATE_CNTL_CS_BINDLESS__MASK;
}
#define A7XX_SP_UPDATE_CNTL_GFX_BINDLESS__MASK			0x01fe0000ull
#define A7XX_SP_UPDATE_CNTL_GFX_BINDLESS__SHIFT			17
static CONSTEXPR inline uint32_t A7XX_SP_UPDATE_CNTL_GFX_BINDLESS(uint32_t val)
{
	return ((val) << A7XX_SP_UPDATE_CNTL_GFX_BINDLESS__SHIFT) & A7XX_SP_UPDATE_CNTL_GFX_BINDLESS__MASK;
}


#define REG_A8XX_SP_UPDATE_CNTL					__FD_DEPRECATED 0x0000ab1f
#define A8XX_SP_UPDATE_CNTL_VS_STATE				0x00000001
#define A8XX_SP_UPDATE_CNTL_HS_STATE				0x00000002
#define A8XX_SP_UPDATE_CNTL_DS_STATE				0x00000004
#define A8XX_SP_UPDATE_CNTL_GS_STATE				0x00000008
#define A8XX_SP_UPDATE_CNTL_FS_STATE				0x00000010
#define A8XX_SP_UPDATE_CNTL_CS_STATE				0x00000020


#define REG_A6XX_SP_CS_BINDLESS_INVALIDATE			0x0000a9c0


#define REG_A6XX_SP_GFX_BINDLESS_INVALIDATE			0x0000ab08


#define REG_A6XX_SP_PS_CONST_CONFIG				__FD_DEPRECATED 0x0000bb10
#define A6XX_SP_PS_CONST_CONFIG_CONSTLEN__MASK			0x000000ffull
#define A6XX_SP_PS_CONST_CONFIG_CONSTLEN__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_SP_PS_CONST_CONFIG_CONSTLEN(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A6XX_SP_PS_CONST_CONFIG_CONSTLEN__SHIFT) & A6XX_SP_PS_CONST_CONFIG_CONSTLEN__MASK;
}
#define A6XX_SP_PS_CONST_CONFIG_ENABLED				0x00000100
#define A6XX_SP_PS_CONST_CONFIG_READ_IMM_SHARED_CONSTS		0x00000200


#define REG_A7XX_SP_PS_CONST_CONFIG				__FD_DEPRECATED 0x0000ab03
#define A7XX_SP_PS_CONST_CONFIG_CONSTLEN__MASK			0x000000ffull
#define A7XX_SP_PS_CONST_CONFIG_CONSTLEN__SHIFT			0
static CONSTEXPR inline uint32_t A7XX_SP_PS_CONST_CONFIG_CONSTLEN(uint32_t val)
{
	assert(!(val & 0x3));
	return (((val >> 2)) << A7XX_SP_PS_CONST_CONFIG_CONSTLEN__SHIFT) & A7XX_SP_PS_CONST_CONFIG_CONSTLEN__MASK;
}
#define A7XX_SP_PS_CONST_CONFIG_ENABLED				0x00000100
#define A7XX_SP_PS_CONST_CONFIG_READ_IMM_SHARED_CONSTS		0x00000200


#define REG_A7XX_SP_SHARED_CONSTANT_GFX(i0)			(0x0000ab40 + 0x1*i0 )



#define REG_A8XX_SP_SHARED_CONSTANT_GFX(i0)			(0x0000ab30 + 0x1*i0 )



#define REG_A6XX_HLSQ_SHARED_CONSTS				__FD_DEPRECATED 0x0000bb11
#define A6XX_HLSQ_SHARED_CONSTS_ENABLE				0x00000001


#define REG_A6XX_HLSQ_BINDLESS_BASE(i0)				(0x0000bb20 + 0x2*i0 )

static CONSTEXPR inline uint32_t A6XX_HLSQ_BINDLESS_BASE_DESCRIPTOR_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A6XX_HLSQ_BINDLESS_BASE_DESCRIPTOR_HI(uint32_t val)
{
	return val;
}
#define A6XX_HLSQ_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__MASK	0x00000003ull
#define A6XX_HLSQ_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__SHIFT	0
static CONSTEXPR inline uint64_t A6XX_HLSQ_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE(enum a6xx_bindless_descriptor_size val)
{
	return ((uint64_t)(val) << A6XX_HLSQ_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__SHIFT) & A6XX_HLSQ_BINDLESS_BASE_DESCRIPTOR_DESC_SIZE__MASK;
}
#define A6XX_HLSQ_BINDLESS_BASE_DESCRIPTOR_ADDR__MASK		0xfffffffffffffffcull
#define A6XX_HLSQ_BINDLESS_BASE_DESCRIPTOR_ADDR__SHIFT		2
static CONSTEXPR inline uint64_t A6XX_HLSQ_BINDLESS_BASE_DESCRIPTOR_ADDR(uint64_t val)
{
	assert(!(val & 0x3));
	return ((uint64_t)((val >> 2)) << A6XX_HLSQ_BINDLESS_BASE_DESCRIPTOR_ADDR__SHIFT) & A6XX_HLSQ_BINDLESS_BASE_DESCRIPTOR_ADDR__MASK;
}


#define REG_A6XX_HLSQ_2D_EVENT_CMD				0x0000bd80
#define A6XX_HLSQ_2D_EVENT_CMD_STATE_ID__MASK			0x0000ff00ull
#define A6XX_HLSQ_2D_EVENT_CMD_STATE_ID__SHIFT			8
static CONSTEXPR inline uint32_t A6XX_HLSQ_2D_EVENT_CMD_STATE_ID(uint32_t val)
{
	return ((val) << A6XX_HLSQ_2D_EVENT_CMD_STATE_ID__SHIFT) & A6XX_HLSQ_2D_EVENT_CMD_STATE_ID__MASK;
}
#define A6XX_HLSQ_2D_EVENT_CMD_EVENT__MASK			0x0000007full
#define A6XX_HLSQ_2D_EVENT_CMD_EVENT__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_HLSQ_2D_EVENT_CMD_EVENT(enum vgt_event_type val)
{
	return ((val) << A6XX_HLSQ_2D_EVENT_CMD_EVENT__SHIFT) & A6XX_HLSQ_2D_EVENT_CMD_EVENT__MASK;
}


#define REG_A6XX_HLSQ_UNKNOWN_BE00				__FD_DEPRECATED 0x0000be00


#define REG_A6XX_HLSQ_UNKNOWN_BE01				__FD_DEPRECATED 0x0000be01


#define REG_A6XX_HLSQ_DBG_ECO_CNTL				__FD_DEPRECATED 0x0000be04


#define REG_A6XX_HLSQ_ADDR_MODE_CNTL				__FD_DEPRECATED 0x0000be05


#define REG_A6XX_HLSQ_UNKNOWN_BE08				0x0000be08


#define REG_A6XX_HLSQ_PERFCTR_HLSQ_SEL(i0)			(0x0000be10 + 0x1*i0 )

static CONSTEXPR inline uint32_t REG_A6XX_HLSQ_PERFCTR_HLSQ_SEL_REG(uint32_t i0) { return 0x0000be10 + 0x1*i0; }


#define REG_A6XX_HLSQ_CONTEXT_SWITCH_GFX_PREEMPTION_SAFE_MODE	__FD_DEPRECATED 0x0000be22


#define REG_A7XX_SP_AHB_READ_APERTURE				__FD_DEPRECATED 0x0000c000


#define REG_A7XX_SP_UNKNOWN_0CE2				__FD_DEPRECATED 0x00000ce2
static CONSTEXPR inline uint32_t A7XX_SP_UNKNOWN_0CE2_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_SP_UNKNOWN_0CE2_HI(uint32_t val)
{
	return val;
}


#define REG_A7XX_SP_UNKNOWN_0CE4				__FD_DEPRECATED 0x00000ce4
static CONSTEXPR inline uint32_t A7XX_SP_UNKNOWN_0CE4_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_SP_UNKNOWN_0CE4_HI(uint32_t val)
{
	return val;
}


#define REG_A7XX_SP_UNKNOWN_0CE6				__FD_DEPRECATED 0x00000ce6
static CONSTEXPR inline uint32_t A7XX_SP_UNKNOWN_0CE6_LO(uint32_t val)
{
	return val;
}
static CONSTEXPR inline uint32_t A7XX_SP_UNKNOWN_0CE6_HI(uint32_t val)
{
	return val;
}


#define REG_A6XX_CP_EVENT_START					0x0000d600
#define A6XX_CP_EVENT_START_STATE_ID__MASK			0x000000ffull
#define A6XX_CP_EVENT_START_STATE_ID__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_CP_EVENT_START_STATE_ID(uint32_t val)
{
	return ((val) << A6XX_CP_EVENT_START_STATE_ID__SHIFT) & A6XX_CP_EVENT_START_STATE_ID__MASK;
}


#define REG_A6XX_CP_EVENT_END					0x0000d601
#define A6XX_CP_EVENT_END_STATE_ID__MASK			0x000000ffull
#define A6XX_CP_EVENT_END_STATE_ID__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_CP_EVENT_END_STATE_ID(uint32_t val)
{
	return ((val) << A6XX_CP_EVENT_END_STATE_ID__SHIFT) & A6XX_CP_EVENT_END_STATE_ID__MASK;
}


#define REG_A6XX_CP_2D_EVENT_START				0x0000d700
#define A6XX_CP_2D_EVENT_START_STATE_ID__MASK			0x000000ffull
#define A6XX_CP_2D_EVENT_START_STATE_ID__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_CP_2D_EVENT_START_STATE_ID(uint32_t val)
{
	return ((val) << A6XX_CP_2D_EVENT_START_STATE_ID__SHIFT) & A6XX_CP_2D_EVENT_START_STATE_ID__MASK;
}


#define REG_A6XX_CP_2D_EVENT_END				0x0000d701
#define A6XX_CP_2D_EVENT_END_STATE_ID__MASK			0x000000ffull
#define A6XX_CP_2D_EVENT_END_STATE_ID__SHIFT			0
static CONSTEXPR inline uint32_t A6XX_CP_2D_EVENT_END_STATE_ID(uint32_t val)
{
	return ((val) << A6XX_CP_2D_EVENT_END_STATE_ID__SHIFT) & A6XX_CP_2D_EVENT_END_STATE_ID__MASK;
}


#define REG_A6XX_PDC_GPU_ENABLE_PDC				0x00001140


#define REG_A6XX_PDC_GPU_SEQ_START_ADDR				0x00001148


#define REG_A6XX_PDC_GPU_TCS0_CONTROL				0x00001540


#define REG_A6XX_PDC_GPU_TCS0_CMD_ENABLE_BANK			0x00001541


#define REG_A6XX_PDC_GPU_TCS0_CMD_WAIT_FOR_CMPL_BANK		0x00001542


#define REG_A6XX_PDC_GPU_TCS0_CMD0_MSGID			0x00001543


#define REG_A6XX_PDC_GPU_TCS0_CMD0_ADDR				0x00001544


#define REG_A6XX_PDC_GPU_TCS0_CMD0_DATA				0x00001545


#define REG_A6XX_PDC_GPU_TCS1_CONTROL				0x00001572


#define REG_A6XX_PDC_GPU_TCS1_CMD_ENABLE_BANK			0x00001573


#define REG_A6XX_PDC_GPU_TCS1_CMD_WAIT_FOR_CMPL_BANK		0x00001574


#define REG_A6XX_PDC_GPU_TCS1_CMD0_MSGID			0x00001575


#define REG_A6XX_PDC_GPU_TCS1_CMD0_ADDR				0x00001576


#define REG_A6XX_PDC_GPU_TCS1_CMD0_DATA				0x00001577


#define REG_A6XX_PDC_GPU_TCS2_CONTROL				0x000015a4


#define REG_A6XX_PDC_GPU_TCS2_CMD_ENABLE_BANK			0x000015a5


#define REG_A6XX_PDC_GPU_TCS2_CMD_WAIT_FOR_CMPL_BANK		0x000015a6


#define REG_A6XX_PDC_GPU_TCS2_CMD0_MSGID			0x000015a7


#define REG_A6XX_PDC_GPU_TCS2_CMD0_ADDR				0x000015a8


#define REG_A6XX_PDC_GPU_TCS2_CMD0_DATA				0x000015a9


#define REG_A6XX_PDC_GPU_TCS3_CONTROL				0x000015d6


#define REG_A6XX_PDC_GPU_TCS3_CMD_ENABLE_BANK			0x000015d7


#define REG_A6XX_PDC_GPU_TCS3_CMD_WAIT_FOR_CMPL_BANK		0x000015d8


#define REG_A6XX_PDC_GPU_TCS3_CMD0_MSGID			0x000015d9


#define REG_A6XX_PDC_GPU_TCS3_CMD0_ADDR				0x000015da


#define REG_A6XX_PDC_GPU_TCS3_CMD0_DATA				0x000015db


#define REG_A6XX_PDC_GPU_SEQ_MEM_0				0x00000000


#define REG_A6XX_CX_DBGC_CFG_DBGBUS_SEL_A			__FD_DEPRECATED 0x00000000
#define A6XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_INDEX__MASK		0x000000ffull
#define A6XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_INDEX__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_INDEX(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_INDEX__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_INDEX__MASK;
}
#define A6XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_BLK_SEL__MASK	0x0000ff00ull
#define A6XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_BLK_SEL__SHIFT	8
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_BLK_SEL(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_BLK_SEL__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_BLK_SEL__MASK;
}


#define REG_A6XX_CX_DBGC_CFG_DBGBUS_SEL_B			0x00000001


#define REG_A6XX_CX_DBGC_CFG_DBGBUS_SEL_C			0x00000002


#define REG_A6XX_CX_DBGC_CFG_DBGBUS_SEL_D			0x00000003


#define REG_A6XX_CX_DBGC_CFG_DBGBUS_CNTLT			0x00000004
#define A6XX_CX_DBGC_CFG_DBGBUS_CNTLT_TRACEEN__MASK		0x0000003full
#define A6XX_CX_DBGC_CFG_DBGBUS_CNTLT_TRACEEN__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_CNTLT_TRACEEN(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_CNTLT_TRACEEN__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_CNTLT_TRACEEN__MASK;
}
#define A6XX_CX_DBGC_CFG_DBGBUS_CNTLT_GRANU__MASK		0x00007000ull
#define A6XX_CX_DBGC_CFG_DBGBUS_CNTLT_GRANU__SHIFT		12
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_CNTLT_GRANU(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_CNTLT_GRANU__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_CNTLT_GRANU__MASK;
}
#define A6XX_CX_DBGC_CFG_DBGBUS_CNTLT_SEGT__MASK		0xf0000000ull
#define A6XX_CX_DBGC_CFG_DBGBUS_CNTLT_SEGT__SHIFT		28
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_CNTLT_SEGT(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_CNTLT_SEGT__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_CNTLT_SEGT__MASK;
}


#define REG_A6XX_CX_DBGC_CFG_DBGBUS_CNTLM			0x00000005
#define A6XX_CX_DBGC_CFG_DBGBUS_CNTLM_ENABLE__MASK		0x0f000000ull
#define A6XX_CX_DBGC_CFG_DBGBUS_CNTLM_ENABLE__SHIFT		24
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_CNTLM_ENABLE(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_CNTLM_ENABLE__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_CNTLM_ENABLE__MASK;
}


#define REG_A6XX_CX_DBGC_CFG_DBGBUS_IVTL_0			0x00000008


#define REG_A6XX_CX_DBGC_CFG_DBGBUS_IVTL_1			0x00000009


#define REG_A6XX_CX_DBGC_CFG_DBGBUS_IVTL_2			0x0000000a


#define REG_A6XX_CX_DBGC_CFG_DBGBUS_IVTL_3			0x0000000b


#define REG_A6XX_CX_DBGC_CFG_DBGBUS_MASKL_0			0x0000000c


#define REG_A6XX_CX_DBGC_CFG_DBGBUS_MASKL_1			0x0000000d


#define REG_A6XX_CX_DBGC_CFG_DBGBUS_MASKL_2			0x0000000e


#define REG_A6XX_CX_DBGC_CFG_DBGBUS_MASKL_3			0x0000000f


#define REG_A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0			0x00000010
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL0__MASK		0x0000000full
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL0__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL0(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL0__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL0__MASK;
}
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL1__MASK		0x000000f0ull
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL1__SHIFT		4
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL1(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL1__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL1__MASK;
}
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL2__MASK		0x00000f00ull
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL2__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL2(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL2__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL2__MASK;
}
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL3__MASK		0x0000f000ull
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL3__SHIFT		12
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL3(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL3__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL3__MASK;
}
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL4__MASK		0x000f0000ull
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL4__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL4(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL4__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL4__MASK;
}
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL5__MASK		0x00f00000ull
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL5__SHIFT		20
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL5(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL5__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL5__MASK;
}
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL6__MASK		0x0f000000ull
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL6__SHIFT		24
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL6(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL6__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL6__MASK;
}
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL7__MASK		0xf0000000ull
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL7__SHIFT		28
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL7(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL7__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_0_BYTEL7__MASK;
}


#define REG_A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1			0x00000011
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL8__MASK		0x0000000full
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL8__SHIFT		0
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL8(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL8__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL8__MASK;
}
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL9__MASK		0x000000f0ull
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL9__SHIFT		4
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL9(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL9__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL9__MASK;
}
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL10__MASK		0x00000f00ull
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL10__SHIFT		8
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL10(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL10__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL10__MASK;
}
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL11__MASK		0x0000f000ull
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL11__SHIFT		12
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL11(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL11__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL11__MASK;
}
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL12__MASK		0x000f0000ull
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL12__SHIFT		16
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL12(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL12__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL12__MASK;
}
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL13__MASK		0x00f00000ull
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL13__SHIFT		20
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL13(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL13__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL13__MASK;
}
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL14__MASK		0x0f000000ull
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL14__SHIFT		24
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL14(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL14__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL14__MASK;
}
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL15__MASK		0xf0000000ull
#define A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL15__SHIFT		28
static CONSTEXPR inline uint32_t A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL15(uint32_t val)
{
	return ((val) << A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL15__SHIFT) & A6XX_CX_DBGC_CFG_DBGBUS_BYTEL_1_BYTEL15__MASK;
}


#define REG_A6XX_CX_DBGC_CFG_DBGBUS_TRACE_BUF1			0x0000002f


#define REG_A6XX_CX_DBGC_CFG_DBGBUS_TRACE_BUF2			0x00000030


#define REG_A7XX_CX_DBGC_CFG_DBGBUS_SEL_A			__FD_DEPRECATED 0x00000000
#define A7XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_INDEX__MASK		0x000000ffull
#define A7XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_INDEX__SHIFT		0
static CONSTEXPR inline uint32_t A7XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_INDEX(uint32_t val)
{
	return ((val) << A7XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_INDEX__SHIFT) & A7XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_INDEX__MASK;
}
#define A7XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_BLK_SEL__MASK	0x01ff0000ull
#define A7XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_BLK_SEL__SHIFT	16
static CONSTEXPR inline uint32_t A7XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_BLK_SEL(uint32_t val)
{
	return ((val) << A7XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_BLK_SEL__SHIFT) & A7XX_CX_DBGC_CFG_DBGBUS_SEL_A_PING_BLK_SEL__MASK;
}


#define REG_A6XX_CX_MISC_SYSTEM_CACHE_CNTL_0			0x00000001


#define REG_A6XX_CX_MISC_SYSTEM_CACHE_CNTL_1			0x00000002


#define REG_A7XX_CX_MISC_TCM_RET_CNTL				__FD_DEPRECATED 0x00000039


#define REG_A8XX_CX_MISC_SLICE_ENABLE_FINAL			__FD_DEPRECATED 0x00000087


#define REG_A7XX_CX_MISC_SW_FUSE_VALUE				__FD_DEPRECATED 0x00000400
#define A7XX_CX_MISC_SW_FUSE_VALUE_FASTBLEND			0x00000001
#define A7XX_CX_MISC_SW_FUSE_VALUE_LPAC				0x00000002
#define A7XX_CX_MISC_SW_FUSE_VALUE_RAYTRACING			0x00000004


#ifdef __cplusplus
template<chip CHIP> constexpr inline uint16_t INIT_REGS[] = {};
template<chip CHIP> constexpr inline uint16_t RP_BLIT_REGS[] = {};
template<chip CHIP> constexpr inline uint16_t CMD_REGS[] = {};
template<> constexpr inline uint16_t INIT_REGS<A6XX>[] = {
	0xe12,
	0xe17,
	0xe19,
	0x8600,
	0x9602,
	0x9e72,
	0xae00,
	0xae03,
	0xae04,
	0xae0f,
	0xb600,
	0xb602,
	0xb605,
	0xbe00,
	0xbe01,
	0xbe04,
};
template<> constexpr inline uint16_t INIT_REGS<A7XX>[] = {
	0xe10,
	0xe11,
	0x8e79,
	0x9e24,
	0xa600,
	0xae00,
	0xae03,
	0xae04,
	0xae06,
	0xae08,
	0xae09,
	0xae0a,
	0xae0f,
	0xae6a,
	0xae6b,
	0xae6c,
	0xb600,
	0xb602,
};
template<> constexpr inline uint16_t INIT_REGS<A8XX>[] = {
	0xae00,
	0xae03,
	0xae04,
	0xae0f,
	0xb600,
	0xb602,
};
template<> constexpr inline uint16_t RP_BLIT_REGS<A6XX>[] = {
	0xc02,
	0xc06,
	0xc10,
	0xc11,
	0xc12,
	0xc13,
	0xc14,
	0xc15,
	0xc16,
	0xc17,
	0xc18,
	0xc19,
	0xc1a,
	0xc1b,
	0xc1c,
	0xc1d,
	0xc1e,
	0xc1f,
	0xc20,
	0xc21,
	0xc22,
	0xc23,
	0xc24,
	0xc25,
	0xc26,
	0xc27,
	0xc28,
	0xc29,
	0xc2a,
	0xc2b,
	0xc2c,
	0xc2d,
	0xc2e,
	0xc2f,
	0xc38,
	0xc39,
	0xc3a,
	0xc3b,
	0xc3c,
	0xc3d,
	0xc3e,
	0xc3f,
	0xc40,
	0xc41,
	0xc42,
	0xc43,
	0xc44,
	0xc45,
	0xc46,
	0xc47,
	0xc48,
	0xc49,
	0xc4a,
	0xc4b,
	0xc4c,
	0xc4d,
	0xc4e,
	0xc4f,
	0xc50,
	0xc51,
	0xc52,
	0xc53,
	0xc54,
	0xc55,
	0xc56,
	0xc57,
	0xc58,
	0xc59,
	0xc5a,
	0xc5b,
	0xc5c,
	0xc5d,
	0xc5e,
	0xc5f,
	0xc60,
	0xc61,
	0xc62,
	0xc63,
	0xc64,
	0xc65,
	0xc66,
	0xc67,
	0xc68,
	0xc69,
	0xc6a,
	0xc6b,
	0xc6c,
	0xc6d,
	0xc6e,
	0xc6f,
	0xc70,
	0xc71,
	0xc72,
	0xc73,
	0xc74,
	0xc75,
	0xc76,
	0xc77,
	0xc78,
	0xc79,
	0xc7a,
	0xc7b,
	0xc7c,
	0xc7d,
	0xc7e,
	0xc7f,
	0xc80,
	0xc81,
	0xc82,
	0xc83,
	0xc84,
	0xc85,
	0xc86,
	0xc87,
	0xc88,
	0xc89,
	0xc8a,
	0xc8b,
	0xc8c,
	0xc8d,
	0xc8e,
	0xc8f,
	0xc90,
	0xc91,
	0xc92,
	0xc93,
	0xc94,
	0xc95,
	0xc96,
	0xc97,
	0x8000,
	0x8001,
	0x8002,
	0x8003,
	0x8004,
	0x8005,
	0x8006,
	0x8010,
	0x8011,
	0x8012,
	0x8013,
	0x8014,
	0x8015,
	0x8016,
	0x8017,
	0x8018,
	0x8019,
	0x801a,
	0x801b,
	0x801c,
	0x801d,
	0x801e,
	0x801f,
	0x8020,
	0x8021,
	0x8022,
	0x8023,
	0x8024,
	0x8025,
	0x8026,
	0x8027,
	0x8028,
	0x8029,
	0x802a,
	0x802b,
	0x802c,
	0x802d,
	0x802e,
	0x802f,
	0x8030,
	0x8031,
	0x8032,
	0x8033,
	0x8034,
	0x8035,
	0x8036,
	0x8037,
	0x8038,
	0x8039,
	0x803a,
	0x803b,
	0x803c,
	0x803d,
	0x803e,
	0x803f,
	0x8040,
	0x8041,
	0x8042,
	0x8043,
	0x8044,
	0x8045,
	0x8046,
	0x8047,
	0x8048,
	0x8049,
	0x804a,
	0x804b,
	0x804c,
	0x804d,
	0x804e,
	0x804f,
	0x8050,
	0x8051,
	0x8052,
	0x8053,
	0x8054,
	0x8055,
	0x8056,
	0x8057,
	0x8058,
	0x8059,
	0x805a,
	0x805b,
	0x805c,
	0x805d,
	0x805e,
	0x805f,
	0x8060,
	0x8061,
	0x8062,
	0x8063,
	0x8064,
	0x8065,
	0x8066,
	0x8067,
	0x8068,
	0x8069,
	0x806a,
	0x806b,
	0x806c,
	0x806d,
	0x806e,
	0x806f,
	0x8070,
	0x8071,
	0x8072,
	0x8073,
	0x8074,
	0x8075,
	0x8076,
	0x8077,
	0x8078,
	0x8079,
	0x807a,
	0x807b,
	0x807c,
	0x807d,
	0x807e,
	0x807f,
	0x8080,
	0x8081,
	0x8082,
	0x8083,
	0x8084,
	0x8085,
	0x8086,
	0x8087,
	0x8088,
	0x8089,
	0x808a,
	0x808b,
	0x808c,
	0x808d,
	0x808e,
	0x808f,
	0x8090,
	0x8091,
	0x8092,
	0x8094,
	0x8095,
	0x8096,
	0x8097,
	0x8098,
	0x809b,
	0x809c,
	0x809d,
	0x80a0,
	0x80a1,
	0x80a2,
	0x80a3,
	0x80a4,
	0x80a5,
	0x80a6,
	0x80b0,
	0x80b1,
	0x80b2,
	0x80b3,
	0x80b4,
	0x80b5,
	0x80b6,
	0x80b7,
	0x80b8,
	0x80b9,
	0x80ba,
	0x80bb,
	0x80bc,
	0x80bd,
	0x80be,
	0x80bf,
	0x80c0,
	0x80c1,
	0x80c2,
	0x80c3,
	0x80c4,
	0x80c5,
	0x80c6,
	0x80c7,
	0x80c8,
	0x80c9,
	0x80ca,
	0x80cb,
	0x80cc,
	0x80cd,
	0x80ce,
	0x80cf,
	0x80d0,
	0x80d1,
	0x80d2,
	0x80d3,
	0x80d4,
	0x80d5,
	0x80d6,
	0x80d7,
	0x80d8,
	0x80d9,
	0x80da,
	0x80db,
	0x80dc,
	0x80dd,
	0x80de,
	0x80df,
	0x80e0,
	0x80e1,
	0x80e2,
	0x80e3,
	0x80e4,
	0x80e5,
	0x80e6,
	0x80e7,
	0x80e8,
	0x80e9,
	0x80ea,
	0x80eb,
	0x80ec,
	0x80ed,
	0x80ee,
	0x80ef,
	0x80f0,
	0x80f1,
	0x8100,
	0x8101,
	0x8102,
	0x8103,
	0x8104,
	0x8105,
	0x8106,
	0x8107,
	0x8109,
	0x8114,
	0x8115,
	0x8400,
	0x8401,
	0x8402,
	0x8403,
	0x8404,
	0x8405,
	0x8406,
	0x840a,
	0x840b,
	0x8800,
	0x8801,
	0x8802,
	0x8803,
	0x8804,
	0x8805,
	0x8806,
	0x8809,
	0x880a,
	0x880b,
	0x880c,
	0x880d,
	0x880f,
	0x8810,
	0x8820,
	0x8821,
	0x8822,
	0x8823,
	0x8824,
	0x8825,
	0x8826,
	0x8827,
	0x8828,
	0x8829,
	0x882a,
	0x882b,
	0x882c,
	0x882d,
	0x882e,
	0x882f,
	0x8830,
	0x8831,
	0x8832,
	0x8833,
	0x8834,
	0x8835,
	0x8836,
	0x8837,
	0x8838,
	0x8839,
	0x883a,
	0x883b,
	0x883c,
	0x883d,
	0x883e,
	0x883f,
	0x8840,
	0x8841,
	0x8842,
	0x8843,
	0x8844,
	0x8845,
	0x8846,
	0x8847,
	0x8848,
	0x8849,
	0x884a,
	0x884b,
	0x884c,
	0x884d,
	0x884e,
	0x884f,
	0x8850,
	0x8851,
	0x8852,
	0x8853,
	0x8854,
	0x8855,
	0x8856,
	0x8857,
	0x8858,
	0x8859,
	0x885a,
	0x885b,
	0x885c,
	0x885d,
	0x885e,
	0x885f,
	0x8860,
	0x8861,
	0x8862,
	0x8863,
	0x8865,
	0x8870,
	0x8871,
	0x8872,
	0x8873,
	0x8874,
	0x8875,
	0x8876,
	0x8877,
	0x8878,
	0x8879,
	0x8880,
	0x8881,
	0x8882,
	0x8883,
	0x8884,
	0x8885,
	0x8886,
	0x8887,
	0x8888,
	0x8889,
	0x8890,
	0x8898,
	0x88c0,
	0x88c1,
	0x88d0,
	0x88d1,
	0x88d2,
	0x88d3,
	0x88d4,
	0x88d5,
	0x88d6,
	0x88d7,
	0x88d8,
	0x88d9,
	0x88da,
	0x88db,
	0x88dc,
	0x88dd,
	0x88de,
	0x88df,
	0x88e0,
	0x88e1,
	0x88e2,
	0x88e3,
	0x88f4,
	0x8900,
	0x8901,
	0x8902,
	0x8903,
	0x8904,
	0x8905,
	0x8906,
	0x8907,
	0x8908,
	0x8909,
	0x890a,
	0x890b,
	0x890c,
	0x890d,
	0x890e,
	0x890f,
	0x8910,
	0x8911,
	0x8912,
	0x8913,
	0x8914,
	0x8915,
	0x8916,
	0x8917,
	0x8918,
	0x8919,
	0x891a,
	0x8a00,
	0x8a10,
	0x8a20,
	0x8a30,
	0x8c00,
	0x8c01,
	0x8c17,
	0x8c18,
	0x8c19,
	0x8c1a,
	0x8c1b,
	0x8c1c,
	0x8c1d,
	0x8c1e,
	0x8c1f,
	0x8c20,
	0x8c21,
	0x8c22,
	0x8c23,
	0x8c24,
	0x8c25,
	0x8c2c,
	0x8c2d,
	0x8c2e,
	0x8c2f,
	0x9100,
	0x9101,
	0x9102,
	0x9103,
	0x9104,
	0x9105,
	0x9106,
	0x9107,
	0x9108,
	0x9200,
	0x9201,
	0x9202,
	0x9203,
	0x9204,
	0x9205,
	0x9206,
	0x9207,
	0x9208,
	0x9209,
	0x920a,
	0x920b,
	0x920c,
	0x920d,
	0x920e,
	0x920f,
	0x9212,
	0x9213,
	0x9214,
	0x9215,
	0x9216,
	0x9217,
	0x9301,
	0x9302,
	0x9303,
	0x9304,
	0x9305,
	0x9306,
	0x9307,
	0x9311,
	0x9312,
	0x9313,
	0x9314,
	0x9315,
	0x9316,
	0x9800,
	0x9801,
	0x9802,
	0x9803,
	0x9804,
	0x9805,
	0x9806,
	0x9808,
	0x9980,
	0x9981,
	0x9b00,
	0x9b01,
	0x9b02,
	0x9b03,
	0x9b04,
	0x9b05,
	0x9b06,
	0x9b07,
	0x9b08,
	0xa000,
	0xa001,
	0xa002,
	0xa003,
	0xa004,
	0xa005,
	0xa006,
	0xa008,
	0xa00e,
	0xa00f,
	0xa010,
	0xa011,
	0xa012,
	0xa013,
	0xa014,
	0xa015,
	0xa016,
	0xa017,
	0xa018,
	0xa019,
	0xa01a,
	0xa01b,
	0xa01c,
	0xa01d,
	0xa01e,
	0xa01f,
	0xa020,
	0xa021,
	0xa022,
	0xa023,
	0xa024,
	0xa025,
	0xa026,
	0xa027,
	0xa028,
	0xa029,
	0xa02a,
	0xa02b,
	0xa02c,
	0xa02d,
	0xa02e,
	0xa02f,
	0xa030,
	0xa031,
	0xa032,
	0xa033,
	0xa034,
	0xa035,
	0xa036,
	0xa037,
	0xa038,
	0xa039,
	0xa03a,
	0xa03b,
	0xa03c,
	0xa03d,
	0xa03e,
	0xa03f,
	0xa040,
	0xa041,
	0xa042,
	0xa043,
	0xa044,
	0xa045,
	0xa046,
	0xa047,
	0xa048,
	0xa049,
	0xa04a,
	0xa04b,
	0xa04c,
	0xa04d,
	0xa04e,
	0xa04f,
	0xa050,
	0xa051,
	0xa052,
	0xa053,
	0xa054,
	0xa055,
	0xa056,
	0xa057,
	0xa058,
	0xa059,
	0xa05a,
	0xa05b,
	0xa05c,
	0xa05d,
	0xa05e,
	0xa05f,
	0xa060,
	0xa061,
	0xa062,
	0xa063,
	0xa064,
	0xa065,
	0xa066,
	0xa067,
	0xa068,
	0xa069,
	0xa06a,
	0xa06b,
	0xa06c,
	0xa06d,
	0xa06e,
	0xa06f,
	0xa070,
	0xa071,
	0xa072,
	0xa073,
	0xa074,
	0xa075,
	0xa076,
	0xa077,
	0xa078,
	0xa079,
	0xa07a,
	0xa07b,
	0xa07c,
	0xa07d,
	0xa07e,
	0xa07f,
	0xa080,
	0xa081,
	0xa082,
	0xa083,
	0xa084,
	0xa085,
	0xa086,
	0xa087,
	0xa088,
	0xa089,
	0xa08a,
	0xa08b,
	0xa08c,
	0xa08d,
	0xa08e,
	0xa08f,
	0xa090,
	0xa091,
	0xa092,
	0xa093,
	0xa094,
	0xa095,
	0xa096,
	0xa097,
	0xa098,
	0xa099,
	0xa09a,
	0xa09b,
	0xa09c,
	0xa09d,
	0xa09e,
	0xa09f,
	0xa0a0,
	0xa0a1,
	0xa0a2,
	0xa0a3,
	0xa0a4,
	0xa0a5,
	0xa0a6,
	0xa0a7,
	0xa0a8,
	0xa0a9,
	0xa0aa,
	0xa0ab,
	0xa0ac,
	0xa0ad,
	0xa0ae,
	0xa0af,
	0xa0b0,
	0xa0b1,
	0xa0b2,
	0xa0b3,
	0xa0b4,
	0xa0b5,
	0xa0b6,
	0xa0b7,
	0xa0b8,
	0xa0b9,
	0xa0ba,
	0xa0bb,
	0xa0bc,
	0xa0bd,
	0xa0be,
	0xa0bf,
	0xa0c0,
	0xa0c1,
	0xa0c2,
	0xa0c3,
	0xa0c4,
	0xa0c5,
	0xa0c6,
	0xa0c7,
	0xa0c8,
	0xa0c9,
	0xa0ca,
	0xa0cb,
	0xa0cc,
	0xa0cd,
	0xa0ce,
	0xa0cf,
	0xa0d0,
	0xa0d1,
	0xa0d2,
	0xa0d3,
	0xa0d4,
	0xa0d5,
	0xa0d6,
	0xa0d7,
	0xa0d8,
	0xa0d9,
	0xa0da,
	0xa0db,
	0xa0dc,
	0xa0dd,
	0xa0de,
	0xa0df,
	0xa0e0,
	0xa0e1,
	0xa0e2,
	0xa0e3,
	0xa0e4,
	0xa0e5,
	0xa0e6,
	0xa0e7,
	0xa0e8,
	0xa0e9,
	0xa0ea,
	0xa0eb,
	0xa0ec,
	0xa0ed,
	0xa0ee,
	0xa0ef,
	0xa0f8,
	0xa800,
	0xa802,
	0xa803,
	0xa804,
	0xa805,
	0xa806,
	0xa807,
	0xa808,
	0xa809,
	0xa80a,
	0xa80b,
	0xa80c,
	0xa80d,
	0xa80e,
	0xa80f,
	0xa810,
	0xa811,
	0xa812,
	0xa813,
	0xa814,
	0xa815,
	0xa816,
	0xa817,
	0xa818,
	0xa819,
	0xa81a,
	0xa81b,
	0xa81c,
	0xa81d,
	0xa81e,
	0xa81f,
	0xa820,
	0xa821,
	0xa822,
	0xa823,
	0xa824,
	0xa825,
	0xa830,
	0xa831,
	0xa832,
	0xa833,
	0xa834,
	0xa835,
	0xa836,
	0xa837,
	0xa838,
	0xa839,
	0xa83a,
	0xa83b,
	0xa83c,
	0xa83d,
	0xa840,
	0xa842,
	0xa843,
	0xa844,
	0xa845,
	0xa846,
	0xa847,
	0xa848,
	0xa849,
	0xa84a,
	0xa84b,
	0xa84c,
	0xa84d,
	0xa84e,
	0xa84f,
	0xa850,
	0xa851,
	0xa852,
	0xa853,
	0xa854,
	0xa855,
	0xa856,
	0xa857,
	0xa858,
	0xa859,
	0xa85a,
	0xa85b,
	0xa85c,
	0xa85d,
	0xa85e,
	0xa85f,
	0xa860,
	0xa861,
	0xa862,
	0xa863,
	0xa864,
	0xa865,
	0xa870,
	0xa871,
	0xa872,
	0xa873,
	0xa874,
	0xa875,
	0xa876,
	0xa877,
	0xa878,
	0xa879,
	0xa87a,
	0xa87b,
	0xa87c,
	0xa87d,
	0xa87e,
	0xa87f,
	0xa880,
	0xa881,
	0xa882,
	0xa883,
	0xa884,
	0xa885,
	0xa886,
	0xa887,
	0xa888,
	0xa889,
	0xa88a,
	0xa88b,
	0xa88c,
	0xa88d,
	0xa88e,
	0xa88f,
	0xa890,
	0xa891,
	0xa892,
	0xa893,
	0xa894,
	0xa895,
	0xa896,
	0xa980,
	0xa982,
	0xa983,
	0xa984,
	0xa985,
	0xa986,
	0xa987,
	0xa988,
	0xa989,
	0xa98a,
	0xa98b,
	0xa98c,
	0xa98d,
	0xa98e,
	0xa98f,
	0xa990,
	0xa991,
	0xa992,
	0xa993,
	0xa994,
	0xa995,
	0xa996,
	0xa997,
	0xa998,
	0xa999,
	0xa99a,
	0xa99b,
	0xa99c,
	0xa99d,
	0xa99e,
	0xa99f,
	0xa9a0,
	0xa9a1,
	0xa9a2,
	0xa9a3,
	0xa9a4,
	0xa9a5,
	0xa9a6,
	0xa9a7,
	0xa9a9,
	0xa9e0,
	0xa9e1,
	0xa9e4,
	0xa9e5,
	0xab00,
	0xab04,
	0xab05,
	0xab10,
	0xab11,
	0xab12,
	0xab13,
	0xab14,
	0xab15,
	0xab16,
	0xab17,
	0xab18,
	0xab19,
	0xacc0,
	0xb300,
	0xb301,
	0xb304,
	0xb305,
	0xb306,
	0xb307,
	0xb4c0,
	0xb4c1,
	0xb4c2,
	0xb4c3,
	0xb4c4,
	0xb4ca,
	0xb4cb,
	0xb4cc,
	0xb4d1,
	0xb800,
	0xb801,
	0xb802,
	0xb803,
	0xb980,
	0xb982,
	0xb983,
	0xb984,
	0xb985,
	0xb986,
	0xb990,
	0xb991,
	0xb992,
	0xb993,
	0xb994,
	0xb995,
	0xb996,
	0xb997,
	0xb998,
	0xb999,
	0xb99a,
	0xb99b,
	0xb9c0,
	0xb9c1,
	0xb9c2,
	0xb9c3,
	0xb9c4,
	0xb9c5,
	0xb9c6,
	0xb9c7,
	0xb9c8,
	0xb9c9,
	0xbb10,
};
template<> constexpr inline uint16_t RP_BLIT_REGS<A8XX>[] = {
	0xc02,
	0xc06,
	0xc10,
	0xc11,
	0xc12,
	0xc13,
	0xc14,
	0xc15,
	0xc16,
	0xc17,
	0xc18,
	0xc19,
	0xc1a,
	0xc1b,
	0xc1c,
	0xc1d,
	0xc1e,
	0xc1f,
	0xc20,
	0xc21,
	0xc22,
	0xc23,
	0xc24,
	0xc25,
	0xc26,
	0xc27,
	0xc28,
	0xc29,
	0xc2a,
	0xc2b,
	0xc2c,
	0xc2d,
	0xc2e,
	0xc2f,
	0xc38,
	0xc39,
	0xc3a,
	0xc3b,
	0xc3c,
	0xc3d,
	0xc3e,
	0xc3f,
	0xc40,
	0xc41,
	0xc42,
	0xc43,
	0xc44,
	0xc45,
	0xc46,
	0xc47,
	0xc48,
	0xc49,
	0xc4a,
	0xc4b,
	0xc4c,
	0xc4d,
	0xc4e,
	0xc4f,
	0xc50,
	0xc51,
	0xc52,
	0xc53,
	0xc54,
	0xc55,
	0xc56,
	0xc57,
	0x8080,
	0x8086,
	0x8087,
	0x8088,
	0x8089,
	0x808a,
	0x808b,
	0x808c,
	0x808d,
	0x808e,
	0x808f,
	0x8090,
	0x8091,
	0x8092,
	0x80c0,
	0x80c1,
	0x80c2,
	0x80c3,
	0x80c4,
	0x80c5,
	0x80c6,
	0x80c7,
	0x80c8,
	0x80c9,
	0x80ca,
	0x80cb,
	0x80cc,
	0x80cd,
	0x80ce,
	0x80cf,
	0x80d0,
	0x80d1,
	0x80d2,
	0x80d3,
	0x80d4,
	0x80d5,
	0x80d6,
	0x80d7,
	0x80d8,
	0x80d9,
	0x80da,
	0x80db,
	0x80dc,
	0x80dd,
	0x80de,
	0x80df,
	0x8101,
	0x8102,
	0x8103,
	0x8104,
	0x8105,
	0x8106,
	0x8107,
	0x8108,
	0x8109,
	0x810e,
	0x810f,
	0x8200,
	0x8201,
	0x8202,
	0x8203,
	0x8204,
	0x8205,
	0x8208,
	0x8209,
	0x820a,
	0x820b,
	0x820c,
	0x820e,
	0x820f,
	0x8210,
	0x8211,
	0x8212,
	0x8230,
	0x8231,
	0x8232,
	0x8233,
	0x8235,
	0x8236,
	0x8237,
	0x8238,
	0x8239,
	0x823a,
	0x823b,
	0x8240,
	0x8241,
	0x8242,
	0x8243,
	0x8244,
	0x8245,
	0x8246,
	0x8247,
	0x8248,
	0x8249,
	0x824a,
	0x824b,
	0x824c,
	0x824d,
	0x824e,
	0x824f,
	0x8250,
	0x8251,
	0x8252,
	0x8253,
	0x8254,
	0x8255,
	0x8256,
	0x8257,
	0x8258,
	0x8259,
	0x825a,
	0x825b,
	0x825c,
	0x825d,
	0x825e,
	0x825f,
	0x8270,
	0x8271,
	0x8272,
	0x8273,
	0x8274,
	0x8275,
	0x8276,
	0x8277,
	0x8278,
	0x8279,
	0x827a,
	0x827b,
	0x827c,
	0x827d,
	0x827e,
	0x827f,
	0x8280,
	0x8281,
	0x8282,
	0x8283,
	0x8284,
	0x8285,
	0x8286,
	0x8287,
	0x8288,
	0x8289,
	0x828a,
	0x828b,
	0x828c,
	0x828d,
	0x828e,
	0x828f,
	0x82d0,
	0x82d1,
	0x82d2,
	0x82d3,
	0x82d4,
	0x82d5,
	0x82d6,
	0x82d7,
	0x82d8,
	0x82d9,
	0x82da,
	0x82db,
	0x82dc,
	0x82dd,
	0x82de,
	0x82df,
	0x82e0,
	0x82e1,
	0x82e2,
	0x82e3,
	0x82e4,
	0x82e5,
	0x82e6,
	0x82e7,
	0x82e8,
	0x82e9,
	0x82ea,
	0x82eb,
	0x82ec,
	0x82ed,
	0x82ee,
	0x82ef,
	0x82f0,
	0x82f1,
	0x82f2,
	0x82f3,
	0x82f4,
	0x82f5,
	0x82f6,
	0x82f7,
	0x82f8,
	0x82f9,
	0x82fa,
	0x82fb,
	0x82fc,
	0x82fd,
	0x82fe,
	0x82ff,
	0x8300,
	0x8301,
	0x8302,
	0x8303,
	0x8304,
	0x8305,
	0x8306,
	0x8307,
	0x8308,
	0x8309,
	0x830a,
	0x830b,
	0x830c,
	0x830d,
	0x830e,
	0x830f,
	0x8310,
	0x8311,
	0x8312,
	0x8313,
	0x8314,
	0x8315,
	0x8316,
	0x8317,
	0x8318,
	0x8319,
	0x831a,
	0x831b,
	0x831c,
	0x831d,
	0x831e,
	0x831f,
	0x8320,
	0x8321,
	0x8322,
	0x8323,
	0x8324,
	0x8325,
	0x8326,
	0x8327,
	0x8328,
	0x8329,
	0x832a,
	0x832b,
	0x832c,
	0x832d,
	0x832e,
	0x832f,
	0x8500,
	0x8501,
	0x8502,
	0x8503,
	0x8504,
	0x8505,
	0x8506,
	0x8507,
	0x8508,
	0x8800,
	0x8802,
	0x8803,
	0x8804,
	0x8805,
	0x8806,
	0x8807,
	0x8808,
	0x8809,
	0x880a,
	0x880b,
	0x880c,
	0x880d,
	0x880f,
	0x8810,
	0x8816,
	0x881f,
	0x8820,
	0x8821,
	0x8823,
	0x8824,
	0x8825,
	0x8826,
	0x8827,
	0x8828,
	0x8829,
	0x882b,
	0x882c,
	0x882d,
	0x882e,
	0x882f,
	0x8830,
	0x8831,
	0x8833,
	0x8834,
	0x8835,
	0x8836,
	0x8837,
	0x8838,
	0x8839,
	0x883b,
	0x883c,
	0x883d,
	0x883e,
	0x883f,
	0x8840,
	0x8841,
	0x8843,
	0x8844,
	0x8845,
	0x8846,
	0x8847,
	0x8848,
	0x8849,
	0x884b,
	0x884c,
	0x884d,
	0x884e,
	0x884f,
	0x8850,
	0x8851,
	0x8853,
	0x8854,
	0x8855,
	0x8856,
	0x8857,
	0x8858,
	0x8859,
	0x885b,
	0x885c,
	0x885d,
	0x885e,
	0x885f,
	0x8860,
	0x8861,
	0x8862,
	0x8863,
	0x8865,
	0x8866,
	0x8870,
	0x8871,
	0x8873,
	0x8874,
	0x8875,
	0x8876,
	0x8877,
	0x8878,
	0x8879,
	0x8880,
	0x8882,
	0x8883,
	0x8884,
	0x8885,
	0x8886,
	0x8887,
	0x8888,
	0x8889,
	0x8890,
	0x8898,
	0x88b0,
	0x88b1,
	0x88b2,
	0x88b3,
	0x88b4,
	0x88b5,
	0x88b6,
	0x88b7,
	0x88b8,
	0x88b9,
	0x88ba,
	0x88bb,
	0x88bc,
	0x88bd,
	0x88be,
	0x88bf,
	0x88c0,
	0x88c1,
	0x88c2,
	0x88c3,
	0x88c4,
	0x88c5,
	0x88c6,
	0x88c7,
	0x88c8,
	0x88c9,
	0x88ca,
	0x88cb,
	0x88cc,
	0x88cd,
	0x88ce,
	0x88cf,
	0x88d0,
	0x88d1,
	0x88d2,
	0x88d3,
	0x88d4,
	0x88d5,
	0x88d6,
	0x88d7,
	0x88d8,
	0x88d9,
	0x88da,
	0x88db,
	0x88dc,
	0x88dd,
	0x88de,
	0x88df,
	0x88e0,
	0x88e1,
	0x88e2,
	0x88e3,
	0x88f0,
	0x88f1,
	0x88f4,
	0x8900,
	0x8901,
	0x8902,
	0x8903,
	0x8904,
	0x8905,
	0x8906,
	0x8907,
	0x8908,
	0x8909,
	0x890a,
	0x890b,
	0x890c,
	0x890d,
	0x890e,
	0x890f,
	0x8910,
	0x8911,
	0x8912,
	0x8913,
	0x8914,
	0x8915,
	0x8916,
	0x8917,
	0x8918,
	0x8919,
	0x891a,
	0x8c00,
	0x8c01,
	0x8c17,
	0x8c18,
	0x8c19,
	0x8c1a,
	0x8c1b,
	0x8c1c,
	0x8c1d,
	0x8c1e,
	0x8c1f,
	0x8c20,
	0x8c21,
	0x8c22,
	0x8c23,
	0x8c24,
	0x8c25,
	0x8c2c,
	0x8c2d,
	0x8c2e,
	0x8c2f,
	0x90c0,
	0x90c1,
	0x9180,
	0x9181,
	0x9240,
	0x9241,
	0x9242,
	0x9243,
	0x9244,
	0x9245,
	0x9246,
	0x9247,
	0x9248,
	0x9249,
	0x924a,
	0x924b,
	0x924c,
	0x924d,
	0x924e,
	0x924f,
	0x9252,
	0x9253,
	0x9254,
	0x9255,
	0x9300,
	0x9301,
	0x9302,
	0x9303,
	0x9304,
	0x9305,
	0x9306,
	0x9307,
	0x9308,
	0x9309,
	0x930a,
	0x930b,
	0x930c,
	0x930d,
	0x930e,
	0x930f,
	0x931a,
	0x9812,
	0x9b00,
	0x9b01,
	0x9b02,
	0x9b03,
	0x9b04,
	0x9b05,
	0x9b06,
	0x9b09,
	0x9b0a,
	0x9b0b,
	0x9b0c,
	0x9b0d,
	0x9b10,
	0x9b11,
	0x9b12,
	0x9b13,
	0x9b15,
	0xa000,
	0xa001,
	0xa002,
	0xa003,
	0xa004,
	0xa005,
	0xa006,
	0xa008,
	0xa00e,
	0xa00f,
	0xa010,
	0xa011,
	0xa012,
	0xa013,
	0xa014,
	0xa015,
	0xa016,
	0xa017,
	0xa018,
	0xa019,
	0xa01a,
	0xa01b,
	0xa01c,
	0xa01d,
	0xa01e,
	0xa01f,
	0xa020,
	0xa021,
	0xa022,
	0xa023,
	0xa024,
	0xa025,
	0xa026,
	0xa027,
	0xa028,
	0xa029,
	0xa02a,
	0xa02b,
	0xa02c,
	0xa02d,
	0xa02e,
	0xa02f,
	0xa030,
	0xa031,
	0xa032,
	0xa033,
	0xa034,
	0xa035,
	0xa036,
	0xa037,
	0xa038,
	0xa039,
	0xa03a,
	0xa03b,
	0xa03c,
	0xa03d,
	0xa03e,
	0xa03f,
	0xa040,
	0xa041,
	0xa042,
	0xa043,
	0xa044,
	0xa045,
	0xa046,
	0xa047,
	0xa048,
	0xa049,
	0xa04a,
	0xa04b,
	0xa04c,
	0xa04d,
	0xa04e,
	0xa04f,
	0xa050,
	0xa051,
	0xa052,
	0xa053,
	0xa054,
	0xa055,
	0xa056,
	0xa057,
	0xa058,
	0xa059,
	0xa05a,
	0xa05b,
	0xa05c,
	0xa05d,
	0xa05e,
	0xa05f,
	0xa060,
	0xa061,
	0xa062,
	0xa063,
	0xa064,
	0xa065,
	0xa066,
	0xa067,
	0xa068,
	0xa069,
	0xa06a,
	0xa06b,
	0xa06c,
	0xa06d,
	0xa06e,
	0xa06f,
	0xa070,
	0xa071,
	0xa072,
	0xa073,
	0xa074,
	0xa075,
	0xa076,
	0xa077,
	0xa078,
	0xa079,
	0xa07a,
	0xa07b,
	0xa07c,
	0xa07d,
	0xa07e,
	0xa07f,
	0xa080,
	0xa081,
	0xa082,
	0xa083,
	0xa084,
	0xa085,
	0xa086,
	0xa087,
	0xa088,
	0xa089,
	0xa08a,
	0xa08b,
	0xa08c,
	0xa08d,
	0xa08e,
	0xa08f,
	0xa090,
	0xa091,
	0xa092,
	0xa093,
	0xa094,
	0xa095,
	0xa096,
	0xa097,
	0xa098,
	0xa099,
	0xa09a,
	0xa09b,
	0xa09c,
	0xa09d,
	0xa09e,
	0xa09f,
	0xa0a0,
	0xa0a1,
	0xa0a2,
	0xa0a3,
	0xa0a4,
	0xa0a5,
	0xa0a6,
	0xa0a7,
	0xa0a8,
	0xa0a9,
	0xa0aa,
	0xa0ab,
	0xa0ac,
	0xa0ad,
	0xa0ae,
	0xa0af,
	0xa0b0,
	0xa0b1,
	0xa0b2,
	0xa0b3,
	0xa0b4,
	0xa0b5,
	0xa0b6,
	0xa0b7,
	0xa0b8,
	0xa0b9,
	0xa0ba,
	0xa0bb,
	0xa0bc,
	0xa0bd,
	0xa0be,
	0xa0bf,
	0xa0c0,
	0xa0c1,
	0xa0c2,
	0xa0c3,
	0xa0c4,
	0xa0c5,
	0xa0c6,
	0xa0c7,
	0xa0c8,
	0xa0c9,
	0xa0ca,
	0xa0cb,
	0xa0cc,
	0xa0cd,
	0xa0ce,
	0xa0cf,
	0xa0d0,
	0xa0d1,
	0xa0d2,
	0xa0d3,
	0xa0d4,
	0xa0d5,
	0xa0d6,
	0xa0d7,
	0xa0d8,
	0xa0d9,
	0xa0da,
	0xa0db,
	0xa0dc,
	0xa0dd,
	0xa0de,
	0xa0df,
	0xa0e0,
	0xa0e1,
	0xa0e2,
	0xa0e3,
	0xa0e4,
	0xa0e5,
	0xa0e6,
	0xa0e7,
	0xa0e8,
	0xa0e9,
	0xa0ea,
	0xa0eb,
	0xa0ec,
	0xa0ed,
	0xa0ee,
	0xa0ef,
	0xa800,
	0xa802,
	0xa803,
	0xa804,
	0xa805,
	0xa806,
	0xa807,
	0xa808,
	0xa809,
	0xa80a,
	0xa80b,
	0xa80c,
	0xa80d,
	0xa80e,
	0xa80f,
	0xa810,
	0xa811,
	0xa812,
	0xa813,
	0xa814,
	0xa815,
	0xa816,
	0xa817,
	0xa818,
	0xa819,
	0xa81a,
	0xa81b,
	0xa81c,
	0xa81d,
	0xa81e,
	0xa81f,
	0xa820,
	0xa821,
	0xa822,
	0xa823,
	0xa824,
	0xa825,
	0xa830,
	0xa831,
	0xa832,
	0xa833,
	0xa834,
	0xa835,
	0xa836,
	0xa837,
	0xa838,
	0xa839,
	0xa83a,
	0xa83b,
	0xa83c,
	0xa83d,
	0xa840,
	0xa842,
	0xa843,
	0xa844,
	0xa845,
	0xa846,
	0xa847,
	0xa848,
	0xa849,
	0xa84a,
	0xa84b,
	0xa84c,
	0xa84d,
	0xa84e,
	0xa84f,
	0xa850,
	0xa851,
	0xa852,
	0xa853,
	0xa854,
	0xa855,
	0xa856,
	0xa857,
	0xa858,
	0xa859,
	0xa85a,
	0xa85b,
	0xa85c,
	0xa85d,
	0xa85e,
	0xa85f,
	0xa860,
	0xa861,
	0xa862,
	0xa863,
	0xa864,
	0xa865,
	0xa870,
	0xa871,
	0xa872,
	0xa873,
	0xa874,
	0xa875,
	0xa876,
	0xa877,
	0xa878,
	0xa879,
	0xa87a,
	0xa87b,
	0xa87c,
	0xa87d,
	0xa87e,
	0xa87f,
	0xa880,
	0xa881,
	0xa882,
	0xa883,
	0xa884,
	0xa885,
	0xa886,
	0xa887,
	0xa888,
	0xa889,
	0xa88a,
	0xa88b,
	0xa88c,
	0xa88d,
	0xa88e,
	0xa88f,
	0xa890,
	0xa891,
	0xa892,
	0xa893,
	0xa894,
	0xa895,
	0xa896,
	0xa980,
	0xa982,
	0xa983,
	0xa984,
	0xa985,
	0xa986,
	0xa987,
	0xa988,
	0xa989,
	0xa98a,
	0xa98b,
	0xa98c,
	0xa98d,
	0xa98e,
	0xa98f,
	0xa990,
	0xa991,
	0xa992,
	0xa993,
	0xa994,
	0xa995,
	0xa996,
	0xa997,
	0xa998,
	0xa999,
	0xa99a,
	0xa99b,
	0xa99c,
	0xa99d,
	0xa99e,
	0xa9a3,
	0xa9a4,
	0xa9a5,
	0xa9a6,
	0xa9a7,
	0xa9a9,
	0xa9c6,
	0xa9e0,
	0xa9e1,
	0xa9e4,
	0xa9e5,
	0xab00,
	0xab04,
	0xab05,
	0xab06,
	0xab07,
	0xb2c2,
	0xb2c3,
	0xb2d2,
	0xb2d6,
	0xb2d7,
	0xb300,
	0xb301,
	0xb304,
	0xb307,
};
template<> constexpr inline uint16_t RP_BLIT_REGS<A7XX>[] = {
	0xc06,
	0xc10,
	0xc11,
	0xc12,
	0xc13,
	0xc14,
	0xc15,
	0xc16,
	0xc17,
	0xc18,
	0xc19,
	0xc1a,
	0xc1b,
	0xc1c,
	0xc1d,
	0xc1e,
	0xc1f,
	0xc20,
	0xc21,
	0xc22,
	0xc23,
	0xc24,
	0xc25,
	0xc26,
	0xc27,
	0xc28,
	0xc29,
	0xc2a,
	0xc2b,
	0xc2c,
	0xc2d,
	0xc2e,
	0xc2f,
	0xc38,
	0xc39,
	0xc3a,
	0xc3b,
	0xc3c,
	0xc3d,
	0xc3e,
	0xc3f,
	0xc40,
	0xc41,
	0xc42,
	0xc43,
	0xc44,
	0xc45,
	0xc46,
	0xc47,
	0xc48,
	0xc49,
	0xc4a,
	0xc4b,
	0xc4c,
	0xc4d,
	0xc4e,
	0xc4f,
	0xc50,
	0xc51,
	0xc52,
	0xc53,
	0xc54,
	0xc55,
	0xc56,
	0xc57,
	0xd08,
	0x8007,
	0x80f4,
	0x80f5,
	0x80f6,
	0x80f8,
	0x80f9,
	0x80fa,
	0x8100,
	0x8106,
	0x8107,
	0x8109,
	0x810b,
	0x8113,
	0x8116,
	0x8801,
	0x8802,
	0x8803,
	0x8804,
	0x8805,
	0x8806,
	0x8809,
	0x880a,
	0x880b,
	0x880c,
	0x880d,
	0x880f,
	0x8810,
	0x8812,
	0x8820,
	0x8821,
	0x8822,
	0x8823,
	0x8824,
	0x8825,
	0x8826,
	0x8827,
	0x8828,
	0x8829,
	0x882a,
	0x882b,
	0x882c,
	0x882d,
	0x882e,
	0x882f,
	0x8830,
	0x8831,
	0x8832,
	0x8833,
	0x8834,
	0x8835,
	0x8836,
	0x8837,
	0x8838,
	0x8839,
	0x883a,
	0x883b,
	0x883c,
	0x883d,
	0x883e,
	0x883f,
	0x8840,
	0x8841,
	0x8842,
	0x8843,
	0x8844,
	0x8845,
	0x8846,
	0x8847,
	0x8848,
	0x8849,
	0x884a,
	0x884b,
	0x884c,
	0x884d,
	0x884e,
	0x884f,
	0x8850,
	0x8851,
	0x8852,
	0x8853,
	0x8854,
	0x8855,
	0x8856,
	0x8857,
	0x8858,
	0x8859,
	0x885a,
	0x885b,
	0x885c,
	0x885d,
	0x885e,
	0x885f,
	0x8860,
	0x8861,
	0x8862,
	0x8863,
	0x8865,
	0x8870,
	0x8871,
	0x8872,
	0x8873,
	0x8874,
	0x8875,
	0x8876,
	0x8877,
	0x8878,
	0x8879,
	0x8880,
	0x8881,
	0x8882,
	0x8883,
	0x8884,
	0x8885,
	0x8886,
	0x8887,
	0x8888,
	0x8889,
	0x8890,
	0x8898,
	0x88d0,
	0x88d1,
	0x88d2,
	0x88d4,
	0x88d5,
	0x88d6,
	0x88d7,
	0x88d8,
	0x88d9,
	0x88da,
	0x88db,
	0x88dc,
	0x88dd,
	0x88de,
	0x88df,
	0x88e0,
	0x88e1,
	0x88e2,
	0x88e3,
	0x88e4,
	0x88f4,
	0x8900,
	0x8901,
	0x8902,
	0x8903,
	0x8904,
	0x8905,
	0x8906,
	0x8907,
	0x8908,
	0x8909,
	0x890a,
	0x890b,
	0x890c,
	0x890d,
	0x890e,
	0x890f,
	0x8910,
	0x8911,
	0x8912,
	0x8913,
	0x8914,
	0x8915,
	0x8916,
	0x8917,
	0x8918,
	0x8919,
	0x891a,
	0x8c00,
	0x8c01,
	0x8c17,
	0x8c18,
	0x8c19,
	0x8c1a,
	0x8c1b,
	0x8c1c,
	0x8c1d,
	0x8c1e,
	0x8c1f,
	0x8c20,
	0x8c21,
	0x8c22,
	0x8c23,
	0x8c24,
	0x8c25,
	0x8c2c,
	0x8c2d,
	0x8c2e,
	0x8c2f,
	0x9107,
	0x9109,
	0x910a,
	0x910b,
	0x910c,
	0x9317,
	0x9807,
	0x9809,
	0xa000,
	0xa001,
	0xa002,
	0xa003,
	0xa004,
	0xa005,
	0xa006,
	0xa008,
	0xa00e,
	0xa00f,
	0xa010,
	0xa011,
	0xa012,
	0xa013,
	0xa014,
	0xa015,
	0xa016,
	0xa017,
	0xa018,
	0xa019,
	0xa01a,
	0xa01b,
	0xa01c,
	0xa01d,
	0xa01e,
	0xa01f,
	0xa020,
	0xa021,
	0xa022,
	0xa023,
	0xa024,
	0xa025,
	0xa026,
	0xa027,
	0xa028,
	0xa029,
	0xa02a,
	0xa02b,
	0xa02c,
	0xa02d,
	0xa02e,
	0xa02f,
	0xa030,
	0xa031,
	0xa032,
	0xa033,
	0xa034,
	0xa035,
	0xa036,
	0xa037,
	0xa038,
	0xa039,
	0xa03a,
	0xa03b,
	0xa03c,
	0xa03d,
	0xa03e,
	0xa03f,
	0xa040,
	0xa041,
	0xa042,
	0xa043,
	0xa044,
	0xa045,
	0xa046,
	0xa047,
	0xa048,
	0xa049,
	0xa04a,
	0xa04b,
	0xa04c,
	0xa04d,
	0xa04e,
	0xa04f,
	0xa050,
	0xa051,
	0xa052,
	0xa053,
	0xa054,
	0xa055,
	0xa056,
	0xa057,
	0xa058,
	0xa059,
	0xa05a,
	0xa05b,
	0xa05c,
	0xa05d,
	0xa05e,
	0xa05f,
	0xa060,
	0xa061,
	0xa062,
	0xa063,
	0xa064,
	0xa065,
	0xa066,
	0xa067,
	0xa068,
	0xa069,
	0xa06a,
	0xa06b,
	0xa06c,
	0xa06d,
	0xa06e,
	0xa06f,
	0xa070,
	0xa071,
	0xa072,
	0xa073,
	0xa074,
	0xa075,
	0xa076,
	0xa077,
	0xa078,
	0xa079,
	0xa07a,
	0xa07b,
	0xa07c,
	0xa07d,
	0xa07e,
	0xa07f,
	0xa080,
	0xa081,
	0xa082,
	0xa083,
	0xa084,
	0xa085,
	0xa086,
	0xa087,
	0xa088,
	0xa089,
	0xa08a,
	0xa08b,
	0xa08c,
	0xa08d,
	0xa08e,
	0xa08f,
	0xa090,
	0xa091,
	0xa092,
	0xa093,
	0xa094,
	0xa095,
	0xa096,
	0xa097,
	0xa098,
	0xa099,
	0xa09a,
	0xa09b,
	0xa09c,
	0xa09d,
	0xa09e,
	0xa09f,
	0xa0a0,
	0xa0a1,
	0xa0a2,
	0xa0a3,
	0xa0a4,
	0xa0a5,
	0xa0a6,
	0xa0a7,
	0xa0a8,
	0xa0a9,
	0xa0aa,
	0xa0ab,
	0xa0ac,
	0xa0ad,
	0xa0ae,
	0xa0af,
	0xa0b0,
	0xa0b1,
	0xa0b2,
	0xa0b3,
	0xa0b4,
	0xa0b5,
	0xa0b6,
	0xa0b7,
	0xa0b8,
	0xa0b9,
	0xa0ba,
	0xa0bb,
	0xa0bc,
	0xa0bd,
	0xa0be,
	0xa0bf,
	0xa0c0,
	0xa0c1,
	0xa0c2,
	0xa0c3,
	0xa0c4,
	0xa0c5,
	0xa0c6,
	0xa0c7,
	0xa0c8,
	0xa0c9,
	0xa0ca,
	0xa0cb,
	0xa0cc,
	0xa0cd,
	0xa0ce,
	0xa0cf,
	0xa0d0,
	0xa0d1,
	0xa0d2,
	0xa0d3,
	0xa0d4,
	0xa0d5,
	0xa0d6,
	0xa0d7,
	0xa0d8,
	0xa0d9,
	0xa0da,
	0xa0db,
	0xa0dc,
	0xa0dd,
	0xa0de,
	0xa0df,
	0xa0e0,
	0xa0e1,
	0xa0e2,
	0xa0e3,
	0xa0e4,
	0xa0e5,
	0xa0e6,
	0xa0e7,
	0xa0e8,
	0xa0e9,
	0xa0ea,
	0xa0eb,
	0xa0ec,
	0xa0ed,
	0xa0ee,
	0xa0ef,
	0xa800,
	0xa802,
	0xa803,
	0xa804,
	0xa805,
	0xa806,
	0xa807,
	0xa808,
	0xa809,
	0xa80a,
	0xa80b,
	0xa80c,
	0xa80d,
	0xa80e,
	0xa80f,
	0xa810,
	0xa811,
	0xa812,
	0xa813,
	0xa814,
	0xa815,
	0xa816,
	0xa817,
	0xa818,
	0xa819,
	0xa81a,
	0xa81b,
	0xa81c,
	0xa81d,
	0xa81e,
	0xa81f,
	0xa820,
	0xa821,
	0xa822,
	0xa823,
	0xa824,
	0xa825,
	0xa827,
	0xa830,
	0xa831,
	0xa832,
	0xa833,
	0xa834,
	0xa835,
	0xa836,
	0xa837,
	0xa838,
	0xa839,
	0xa83a,
	0xa83b,
	0xa83c,
	0xa83d,
	0xa83f,
	0xa840,
	0xa842,
	0xa843,
	0xa844,
	0xa845,
	0xa846,
	0xa847,
	0xa848,
	0xa849,
	0xa84a,
	0xa84b,
	0xa84c,
	0xa84d,
	0xa84e,
	0xa84f,
	0xa850,
	0xa851,
	0xa852,
	0xa853,
	0xa854,
	0xa855,
	0xa856,
	0xa857,
	0xa858,
	0xa859,
	0xa85a,
	0xa85b,
	0xa85c,
	0xa85d,
	0xa85e,
	0xa85f,
	0xa860,
	0xa861,
	0xa862,
	0xa863,
	0xa864,
	0xa865,
	0xa867,
	0xa870,
	0xa871,
	0xa872,
	0xa873,
	0xa874,
	0xa875,
	0xa876,
	0xa877,
	0xa878,
	0xa879,
	0xa87a,
	0xa87b,
	0xa87c,
	0xa87d,
	0xa87e,
	0xa87f,
	0xa880,
	0xa881,
	0xa882,
	0xa883,
	0xa884,
	0xa885,
	0xa886,
	0xa887,
	0xa888,
	0xa889,
	0xa88a,
	0xa88b,
	0xa88c,
	0xa88d,
	0xa88e,
	0xa88f,
	0xa890,
	0xa891,
	0xa892,
	0xa893,
	0xa894,
	0xa895,
	0xa896,
	0xa898,
	0xa980,
	0xa982,
	0xa983,
	0xa984,
	0xa985,
	0xa986,
	0xa987,
	0xa988,
	0xa98a,
	0xa98b,
	0xa98c,
	0xa98d,
	0xa98e,
	0xa98f,
	0xa990,
	0xa991,
	0xa992,
	0xa993,
	0xa994,
	0xa995,
	0xa996,
	0xa997,
	0xa998,
	0xa999,
	0xa99a,
	0xa99b,
	0xa99c,
	0xa99d,
	0xa99e,
	0xa99f,
	0xa9a0,
	0xa9a1,
	0xa9a2,
	0xa9a3,
	0xa9a4,
	0xa9a5,
	0xa9a6,
	0xa9a7,
	0xa9a9,
	0xa9aa,
	0xa9ad,
	0xa9ae,
	0xa9bf,
	0xa9c6,
	0xa9c7,
	0xa9c8,
	0xa9c9,
	0xa9ca,
	0xa9cb,
	0xa9d4,
	0xa9d5,
	0xa9d6,
	0xa9d7,
	0xa9d8,
	0xa9d9,
	0xa9da,
	0xa9db,
	0xa9dc,
	0xa9dd,
	0xa9de,
	0xa9e0,
	0xa9e1,
	0xa9e4,
	0xa9e5,
	0xab00,
	0xab03,
	0xab04,
	0xab05,
	0xab0a,
	0xab0b,
	0xab0c,
	0xab0d,
	0xab0e,
	0xab0f,
	0xab10,
	0xab11,
	0xab12,
	0xab13,
	0xab14,
	0xab15,
	0xab16,
	0xab17,
	0xab18,
	0xab19,
	0xab21,
	0xb2c0,
	0xb2c2,
	0xb2c3,
	0xb2ca,
	0xb2cb,
	0xb2cc,
	0xb2d2,
	0xb300,
	0xb301,
	0xb307,
};
template<> constexpr inline uint16_t CMD_REGS<A6XX>[] = {
	0xc03,
	0xc04,
	0xc30,
	0xc31,
	0xc32,
	0xc33,
	0xc34,
	0xc35,
	0xc36,
	0xc37,
	0x8099,
	0x80af,
	0x810a,
	0x8110,
	0x880e,
	0x8811,
	0x8818,
	0x8819,
	0x881a,
	0x881b,
	0x881c,
	0x881d,
	0x881e,
	0x8864,
	0x8891,
	0x88f0,
	0x8927,
	0x8928,
	0x8e01,
	0x8e04,
	0x8e07,
	0x9210,
	0x9211,
	0x9218,
	0x9219,
	0x921a,
	0x921b,
	0x921c,
	0x921d,
	0x921e,
	0x921f,
	0x9220,
	0x9221,
	0x9222,
	0x9223,
	0x9224,
	0x9225,
	0x9226,
	0x9227,
	0x9228,
	0x9229,
	0x922a,
	0x922b,
	0x922c,
	0x922d,
	0x922e,
	0x922f,
	0x9230,
	0x9231,
	0x9232,
	0x9233,
	0x9234,
	0x9235,
	0x9236,
	0x9300,
	0x9600,
	0x9601,
	0x9e08,
	0x9e09,
	0xa007,
	0xa009,
	0xa8a0,
	0xa8a1,
	0xa8a2,
	0xa8a3,
	0xa8a4,
	0xa8a5,
	0xa8a6,
	0xa8a7,
	0xa8a8,
	0xa8a9,
	0xa8aa,
	0xa8ab,
	0xa8ac,
	0xa8ad,
	0xa8ae,
	0xa8af,
	0xa9a8,
	0xa9b0,
	0xa9b1,
	0xa9b2,
	0xa9b3,
	0xa9b4,
	0xa9b5,
	0xa9b6,
	0xa9b7,
	0xa9b8,
	0xa9b9,
	0xa9ba,
	0xa9bb,
	0xa9bc,
	0xa9bd,
	0xa9c2,
	0xa9c3,
	0xa9e2,
	0xa9e3,
	0xa9e6,
	0xa9e7,
	0xa9e8,
	0xa9e9,
	0xa9ea,
	0xa9eb,
	0xa9ec,
	0xa9ed,
	0xa9ee,
	0xa9ef,
	0xa9f0,
	0xa9f1,
	0xaaf2,
	0xab1a,
	0xab1b,
	0xab20,
	0xb180,
	0xb181,
	0xb182,
	0xb183,
	0xb302,
	0xb303,
	0xb309,
	0xb987,
	0xb9d0,
	0xbb08,
	0xbb11,
	0xbb20,
	0xbb21,
	0xbb22,
	0xbb23,
	0xbb24,
	0xbb25,
	0xbb26,
	0xbb27,
	0xbb28,
	0xbb29,
};
template<> constexpr inline uint16_t CMD_REGS<A7XX>[] = {
	0xc03,
	0xc04,
	0xc30,
	0xc31,
	0xc32,
	0xc33,
	0xc34,
	0xc35,
	0xc36,
	0xc37,
	0xce2,
	0xce3,
	0xce4,
	0xce5,
	0xce6,
	0xce7,
	0x8008,
	0x8009,
	0x800a,
	0x800b,
	0x800c,
	0x80a7,
	0x810a,
	0x880e,
	0x8811,
	0x8818,
	0x8819,
	0x881a,
	0x881b,
	0x881c,
	0x881d,
	0x881e,
	0x8864,
	0x8891,
	0x8899,
	0x88e5,
	0x88f5,
	0x8927,
	0x8928,
	0x8c34,
	0x8e01,
	0x8e04,
	0x8e06,
	0x8e07,
	0x8e09,
	0x9308,
	0x9309,
	0x9810,
	0x9811,
	0x9884,
	0x9885,
	0x9886,
	0x9b09,
	0xa007,
	0xa009,
	0xa82d,
	0xa82f,
	0xa868,
	0xa899,
	0xa8a0,
	0xa8a1,
	0xa8a2,
	0xa8a3,
	0xa8a4,
	0xa8a5,
	0xa8a6,
	0xa8a7,
	0xa8a8,
	0xa8a9,
	0xa8aa,
	0xa8ab,
	0xa8ac,
	0xa8ad,
	0xa8ae,
	0xa8af,
	0xa9a8,
	0xa9ac,
	0xa9b0,
	0xa9b1,
	0xa9b2,
	0xa9b3,
	0xa9b4,
	0xa9b5,
	0xa9b6,
	0xa9b7,
	0xa9b8,
	0xa9b9,
	0xa9ba,
	0xa9bb,
	0xa9bc,
	0xa9bd,
	0xa9c2,
	0xa9c3,
	0xa9c5,
	0xa9cd,
	0xa9df,
	0xa9e2,
	0xa9e3,
	0xa9e6,
	0xa9e7,
	0xa9e8,
	0xa9e9,
	0xa9ea,
	0xa9eb,
	0xa9ec,
	0xa9ed,
	0xa9ee,
	0xa9ef,
	0xa9f0,
	0xa9f1,
	0xa9f2,
	0xa9f3,
	0xa9f4,
	0xa9f5,
	0xa9f6,
	0xa9f7,
	0xaa01,
	0xaa02,
	0xaa03,
	0xaaf2,
	0xab01,
	0xab02,
	0xab1a,
	0xab1b,
	0xab1f,
	0xab22,
	0xb180,
	0xb181,
	0xb182,
	0xb183,
	0xb302,
	0xb303,
	0xb310,
	0xb608,
	0xb609,
	0xb60a,
	0xb60b,
	0xb60c,
};
template<> constexpr inline uint16_t CMD_REGS<A8XX>[] = {
	0xc03,
	0xc04,
	0xc30,
	0xc31,
	0xc32,
	0xc33,
	0xc34,
	0xc35,
	0xc36,
	0xc37,
	0x810a,
	0x8206,
	0x8207,
	0x820d,
	0x8213,
	0x8220,
	0x8221,
	0x8222,
	0x8223,
	0x8224,
	0x8225,
	0x8228,
	0x8229,
	0x822a,
	0x822b,
	0x822c,
	0x822d,
	0x8234,
	0x880e,
	0x8811,
	0x8818,
	0x8819,
	0x881a,
	0x881b,
	0x881c,
	0x881d,
	0x881e,
	0x8864,
	0x8891,
	0x88e5,
	0x8927,
	0x8928,
	0x8950,
	0x8951,
	0x8952,
	0x8953,
	0x8954,
	0x8955,
	0x8960,
	0x8961,
	0x8962,
	0x8963,
	0x8964,
	0x8965,
	0x8e01,
	0x8e04,
	0x9182,
	0x9183,
	0x9184,
	0x9185,
	0x9186,
	0x9187,
	0x9188,
	0x9189,
	0x918a,
	0x918b,
	0x918c,
	0x918d,
	0x918e,
	0x918f,
	0x9190,
	0x9191,
	0x9192,
	0x9193,
	0x9194,
	0x9195,
	0x9196,
	0x9197,
	0x9198,
	0x9199,
	0x919a,
	0x919b,
	0x919c,
	0x919d,
	0x919e,
	0x919f,
	0x9310,
	0x9312,
	0x9314,
	0x9315,
	0x9316,
	0x9317,
	0x9318,
	0x9319,
	0x9813,
	0x9814,
	0x9815,
	0x9816,
	0x9817,
	0x9b16,
	0x9b17,
	0x9b18,
	0xa007,
	0xa009,
	0xa8a0,
	0xa8a1,
	0xa8a2,
	0xa8a3,
	0xa8a4,
	0xa8a5,
	0xa8a6,
	0xa8a7,
	0xa8a8,
	0xa8a9,
	0xa8aa,
	0xa8ab,
	0xa8ac,
	0xa8ad,
	0xa8ae,
	0xa8af,
	0xa9a8,
	0xa9b0,
	0xa9b1,
	0xa9b2,
	0xa9b3,
	0xa9b4,
	0xa9b5,
	0xa9b6,
	0xa9b7,
	0xa9b8,
	0xa9b9,
	0xa9ba,
	0xa9bb,
	0xa9bc,
	0xa9bd,
	0xa9c2,
	0xa9e2,
	0xa9e3,
	0xa9e6,
	0xa9e7,
	0xaaf2,
	0xab09,
	0xab1a,
	0xab1b,
	0xab1f,
	0xb180,
	0xb181,
	0xb182,
	0xb183,
	0xb302,
	0xb303,
	0xb309,
};
#endif
#endif /* A6XX_XML */
