// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "BackgroundProperty.h"

#include <QRegularExpression>

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::BackgroundPropertyPrivate
{
public:
    std::optional<Union::Color> color;
    std::unique_ptr<ImageProperty> image;
};

BackgroundProperty::BackgroundProperty()
    : d(std::make_unique<BackgroundPropertyPrivate>())
{
}

BackgroundProperty::BackgroundProperty(const BackgroundProperty &other)
    : d(std::make_unique<BackgroundPropertyPrivate>())
{
    d->color = other.d->color;
    d->image = std::make_unique<ImageProperty>();
    *(d->image) = *(other.d->image);
}

BackgroundProperty::BackgroundProperty(BackgroundProperty &&other)
    : d(std::move(other.d))
{
}

BackgroundProperty::~BackgroundProperty() = default;

BackgroundProperty &BackgroundProperty::operator=(const BackgroundProperty &other)
{
    if (this != &other) {
        d->color = other.d->color;
        *(d->image) = *(other.d->image);
    }
    return *this;
}

BackgroundProperty &BackgroundProperty::operator=(BackgroundProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

std::optional<Union::Color> BackgroundProperty::color() const
{
    return d->color;
}

void BackgroundProperty::setColor(const std::optional<Union::Color> &newValue)
{
    if (newValue == d->color) {
        return;
    }

    d->color = newValue;
}

ImageProperty *BackgroundProperty::image() const
{
    return d->image.get();
}

void BackgroundProperty::setImage(std::unique_ptr<ImageProperty> &&newValue)
{
    d->image = std::move(newValue);
}

bool BackgroundProperty::hasAnyValue() const
{
    if (d->color.has_value()) {
        return true;
    }
    if (d->image && d->image->hasAnyValue()) {
        return true;
    }
    return false;
}

bool BackgroundProperty::isEmpty() const
{
    if (!hasAnyValue()) {
        return true;
    }

    if (d->color.has_value() && d->color.value() != emptyValue<Union::Color>()) {
        return false;
    }
    if (d->image && !d->image->isEmpty()) {
        return false;
    }

    return true;
}

QString BackgroundProperty::toString(int indentation, ToStringFlags flags) const
{
    if (!hasAnyValue()) {
        return u"(empty)"_s;
    }

    const bool multiline = flags & ToStringFlag::MultiLine;
    const bool types = flags & ToStringFlag::Types;

    QString result;
    QTextStream out(&result);

    constexpr auto indent = [](int amount, bool multiline, bool first) {
        if (multiline) {
            return QByteArray(amount, ' ');
        } else if (!first) {
            return QByteArray(", ");
        } else {
            return QByteArray(" ");
        }
    };

    const QByteArray maybeNewLine = multiline ? "\n" : "";
    const QByteArray empty = "(empty)";

    if (types) {
        out << "BackgroundProperty(" << maybeNewLine;
    } else if (indentation > 0) {
        out << maybeNewLine;
    }

    out << indent(indentation, multiline, true) << "color: ";
    if (d->color) {
        out << d->color->toString() << maybeNewLine;
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "image: ";
    if (d->image) {
        out << d->image->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }

    if (types) {
        out << indent(indentation - 2, multiline, true) << ")";
    }
    out << maybeNewLine;

    out.flush();

    return result;
}

void BackgroundProperty::resolveProperties(const BackgroundProperty *source, BackgroundProperty *destination)
{
    if (!source || !destination) {
        return;
    }

    if (!destination->d->color.has_value()) {
        destination->d->color = source->d->color;
    }
    if (source->d->image) {
        if (!destination->d->image) {
            destination->d->image = std::make_unique<ImageProperty>();
        }
        ImageProperty::resolveProperties(source->d->image.get(), destination->d->image.get());
    }
}

std::unique_ptr<BackgroundProperty> BackgroundProperty::empty()
{
    auto result = std::make_unique<BackgroundProperty>();
    result->d->color = emptyValue<Union::Color>();
    result->d->image = ImageProperty::empty();
    return result;
}

bool Union::Properties::operator==(const BackgroundProperty &left, const BackgroundProperty &right)
{
    if (left.color() != right.color()) {
        return false;
    }
    if (left.image() && right.image()) {
        if (*(left.image()) != *(right.image())) {
            return false;
        }
    } else if (left.image() != right.image()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, Union::Properties::BackgroundProperty *type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << qPrintable(type->toString(0, ToStringFlag::Types));
    return debug;
}