// ui/gfx/mojom/selection_bound.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_SELECTION_BOUND_MOJOM_H_
#define UI_GFX_MOJOM_SELECTION_BOUND_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/selection_bound.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/mojom/selection_bound.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/mojom/selection_bound.mojom-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>




#include "ui/gfx/mojom/selection_bound_mojom_traits.h"




namespace gfx::mojom {








class  SelectionBound {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SelectionBound, T>::value>;
  using DataView = SelectionBoundDataView;
  using Data_ = internal::SelectionBound_Data;

  template <typename... Args>
  static SelectionBoundPtr New(Args&&... args) {
    return SelectionBoundPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SelectionBoundPtr From(const U& u) {
    return mojo::TypeConverter<SelectionBoundPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SelectionBound>::Convert(*this);
  }


  SelectionBound();

  SelectionBound(
      SelectionBoundType type,
      const ::gfx::PointF& edge_start,
      const ::gfx::PointF& edge_end,
      const ::gfx::PointF& visible_edge_start,
      const ::gfx::PointF& visible_edge_end,
      bool visible);


  ~SelectionBound();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SelectionBoundPtr>
  SelectionBoundPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SelectionBound::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SelectionBound::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SelectionBound::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectionBound::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SelectionBound::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SelectionBound_UnserializedMessageContext<
            UserType, SelectionBound::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SelectionBound::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SelectionBound::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SelectionBound_UnserializedMessageContext<
            UserType, SelectionBound::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SelectionBound::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  SelectionBoundType type;
  
  ::gfx::PointF edge_start;
  
  ::gfx::PointF edge_end;
  
  ::gfx::PointF visible_edge_start;
  
  ::gfx::PointF visible_edge_end;
  
  bool visible;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SelectionBound::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SelectionBound::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SelectionBound::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SelectionBound::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SelectionBoundPtr SelectionBound::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(edge_start),
      mojo::Clone(edge_end),
      mojo::Clone(visible_edge_start),
      mojo::Clone(visible_edge_end),
      mojo::Clone(visible)
  );
}

template <typename T, SelectionBound::EnableIfSame<T>*>
bool SelectionBound::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->edge_start, other_struct.edge_start))
    return false;
  if (!mojo::Equals(this->edge_end, other_struct.edge_end))
    return false;
  if (!mojo::Equals(this->visible_edge_start, other_struct.visible_edge_start))
    return false;
  if (!mojo::Equals(this->visible_edge_end, other_struct.visible_edge_end))
    return false;
  if (!mojo::Equals(this->visible, other_struct.visible))
    return false;
  return true;
}

template <typename T, SelectionBound::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.edge_start < rhs.edge_start)
    return true;
  if (rhs.edge_start < lhs.edge_start)
    return false;
  if (lhs.edge_end < rhs.edge_end)
    return true;
  if (rhs.edge_end < lhs.edge_end)
    return false;
  if (lhs.visible_edge_start < rhs.visible_edge_start)
    return true;
  if (rhs.visible_edge_start < lhs.visible_edge_start)
    return false;
  if (lhs.visible_edge_end < rhs.visible_edge_end)
    return true;
  if (rhs.visible_edge_end < lhs.visible_edge_end)
    return false;
  if (lhs.visible < rhs.visible)
    return true;
  if (rhs.visible < lhs.visible)
    return false;
  return false;
}


}  // gfx::mojom

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::SelectionBound::DataView,
                                         ::gfx::mojom::SelectionBoundPtr> {
  static bool IsNull(const ::gfx::mojom::SelectionBoundPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::SelectionBoundPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::SelectionBound::type) type(
      const ::gfx::mojom::SelectionBoundPtr& input) {
    return input->type;
  }

  static const decltype(::gfx::mojom::SelectionBound::edge_start)& edge_start(
      const ::gfx::mojom::SelectionBoundPtr& input) {
    return input->edge_start;
  }

  static const decltype(::gfx::mojom::SelectionBound::edge_end)& edge_end(
      const ::gfx::mojom::SelectionBoundPtr& input) {
    return input->edge_end;
  }

  static const decltype(::gfx::mojom::SelectionBound::visible_edge_start)& visible_edge_start(
      const ::gfx::mojom::SelectionBoundPtr& input) {
    return input->visible_edge_start;
  }

  static const decltype(::gfx::mojom::SelectionBound::visible_edge_end)& visible_edge_end(
      const ::gfx::mojom::SelectionBoundPtr& input) {
    return input->visible_edge_end;
  }

  static decltype(::gfx::mojom::SelectionBound::visible) visible(
      const ::gfx::mojom::SelectionBoundPtr& input) {
    return input->visible;
  }

  static bool Read(::gfx::mojom::SelectionBound::DataView input, ::gfx::mojom::SelectionBoundPtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_SELECTION_BOUND_MOJOM_H_