// ui/display/mojom/display_layout.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_DISPLAY_LAYOUT_MOJOM_SHARED_H_
#define UI_DISPLAY_MOJOM_DISPLAY_LAYOUT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/display/mojom/display_layout.mojom-shared-internal.h"







namespace display::mojom {
class DisplayPlacementDataView;

class DisplayLayoutDataView;



}  // display::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::display::mojom::DisplayPlacementDataView> {
  using Data = ::display::mojom::internal::DisplayPlacement_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::display::mojom::DisplayLayoutDataView> {
  using Data = ::display::mojom::internal::DisplayLayout_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace display::mojom {


enum class Position : int32_t {
  
  TOP = 0,
  
  RIGHT = 1,
  
  BOTTOM = 2,
  
  LEFT = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, Position value);
inline bool IsKnownEnumValue(Position value) {
  return internal::Position_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class OffsetReference : int32_t {
  
  TOP_LEFT = 0,
  
  BOTTOM_RIGHT = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, OffsetReference value);
inline bool IsKnownEnumValue(OffsetReference value) {
  return internal::OffsetReference_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class DisplayPlacementDataView {
 public:
  DisplayPlacementDataView() = default;

  DisplayPlacementDataView(
      internal::DisplayPlacement_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t display_id() const {
    return data_->display_id;
  }
  int64_t parent_display_id() const {
    return data_->parent_display_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPosition(UserType* output) const {
    auto data_value = data_->position;
    return mojo::internal::Deserialize<::display::mojom::Position>(
        data_value, output);
  }
  Position position() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::display::mojom::Position>(data_->position));
  }
  int32_t offset() const {
    return data_->offset;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOffsetReference(UserType* output) const {
    auto data_value = data_->offset_reference;
    return mojo::internal::Deserialize<::display::mojom::OffsetReference>(
        data_value, output);
  }
  OffsetReference offset_reference() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::display::mojom::OffsetReference>(data_->offset_reference));
  }
 private:
  internal::DisplayPlacement_Data* data_ = nullptr;
};


class DisplayLayoutDataView {
 public:
  DisplayLayoutDataView() = default;

  DisplayLayoutDataView(
      internal::DisplayLayout_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool default_unified() const {
    return data_->default_unified;
  }
  int64_t primary_display_id() const {
    return data_->primary_display_id;
  }
  inline void GetPlacementListDataView(
      mojo::ArrayDataView<DisplayPlacementDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlacementList(UserType* output) {
    
    auto* pointer = data_->placement_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::display::mojom::DisplayPlacementDataView>>(
        pointer, output, message_);
  }
 private:
  internal::DisplayLayout_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // display::mojom

namespace std {

template <>
struct hash<::display::mojom::Position>
    : public mojo::internal::EnumHashImpl<::display::mojom::Position> {};

template <>
struct hash<::display::mojom::OffsetReference>
    : public mojo::internal::EnumHashImpl<::display::mojom::OffsetReference> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::display::mojom::Position, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::display::mojom::Position, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::display::mojom::Position>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::display::mojom::OffsetReference, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::display::mojom::OffsetReference, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::display::mojom::OffsetReference>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::display::mojom::DisplayPlacementDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::display::mojom::DisplayPlacementDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::display::mojom::internal::DisplayPlacement_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->display_id = Traits::display_id(input);
    fragment->parent_display_id = Traits::parent_display_id(input);
    mojo::internal::Serialize<::display::mojom::Position>(
        Traits::position(input), &fragment->position);
    fragment->offset = Traits::offset(input);
    mojo::internal::Serialize<::display::mojom::OffsetReference>(
        Traits::offset_reference(input), &fragment->offset_reference);
  }

  static bool Deserialize(::display::mojom::internal::DisplayPlacement_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::display::mojom::DisplayPlacementDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::display::mojom::DisplayLayoutDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::display::mojom::DisplayLayoutDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::display::mojom::internal::DisplayLayout_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->default_unified = Traits::default_unified(input);
    fragment->primary_display_id = Traits::primary_display_id(input);
    decltype(Traits::placement_list(input)) in_placement_list = Traits::placement_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->placement_list)::BaseType>
        placement_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& placement_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::display::mojom::DisplayPlacementDataView>>(
        in_placement_list, placement_list_fragment, &placement_list_validate_params);
    fragment->placement_list.Set(
        placement_list_fragment.is_null() ? nullptr : placement_list_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->placement_list.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null placement_list in DisplayLayout struct");
  }

  static bool Deserialize(::display::mojom::internal::DisplayLayout_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::display::mojom::DisplayLayoutDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace display::mojom {



inline void DisplayLayoutDataView::GetPlacementListDataView(
    mojo::ArrayDataView<DisplayPlacementDataView>* output) {
  auto pointer = data_->placement_list.Get();
  *output = mojo::ArrayDataView<DisplayPlacementDataView>(pointer, message_);
}



}  // display::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::display::mojom::Position> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::display::mojom::Position value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::display::mojom::OffsetReference> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::display::mojom::OffsetReference value);
};

} // namespace perfetto

#endif  // UI_DISPLAY_MOJOM_DISPLAY_LAYOUT_MOJOM_SHARED_H_