// ui/accessibility/mojom/ax_mode.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_MODE_MOJOM_BLINK_H_
#define UI_ACCESSIBILITY_MOJOM_AX_MODE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_mode.mojom-features.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_mode.mojom-shared.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_mode.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace ax::mojom::blink {





class  AXMode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AXMode, T>::value>;
  using DataView = AXModeDataView;
  using Data_ = internal::AXMode_Data;

  template <typename... Args>
  static AXModePtr New(Args&&... args) {
    return AXModePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AXModePtr From(const U& u) {
    return mojo::TypeConverter<AXModePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AXMode>::Convert(*this);
  }


  AXMode();

  AXMode(
      uint32_t flags,
      uint32_t experimental_flags);


  ~AXMode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AXModePtr>
  AXModePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AXMode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AXMode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AXMode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AXMode::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AXMode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AXMode_UnserializedMessageContext<
            UserType, AXMode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AXMode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AXMode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AXMode_UnserializedMessageContext<
            UserType, AXMode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AXMode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t flags;
  
  uint32_t experimental_flags;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AXMode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AXMode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AXMode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AXMode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
AXModePtr AXMode::Clone() const {
  return New(
      mojo::Clone(flags),
      mojo::Clone(experimental_flags)
  );
}

template <typename T, AXMode::EnableIfSame<T>*>
bool AXMode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->flags, other_struct.flags))
    return false;
  if (!mojo::Equals(this->experimental_flags, other_struct.experimental_flags))
    return false;
  return true;
}

template <typename T, AXMode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.flags < rhs.flags)
    return true;
  if (rhs.flags < lhs.flags)
    return false;
  if (lhs.experimental_flags < rhs.experimental_flags)
    return true;
  if (rhs.experimental_flags < lhs.experimental_flags)
    return false;
  return false;
}


}  // ax::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::ax::mojom::blink::AXMode::DataView,
                                         ::ax::mojom::blink::AXModePtr> {
  static bool IsNull(const ::ax::mojom::blink::AXModePtr& input) { return !input; }
  static void SetToNull(::ax::mojom::blink::AXModePtr* output) { output->reset(); }

  static decltype(::ax::mojom::blink::AXMode::flags) flags(
      const ::ax::mojom::blink::AXModePtr& input) {
    return input->flags;
  }

  static decltype(::ax::mojom::blink::AXMode::experimental_flags) experimental_flags(
      const ::ax::mojom::blink::AXModePtr& input) {
    return input->experimental_flags;
  }

  static bool Read(::ax::mojom::blink::AXMode::DataView input, ::ax::mojom::blink::AXModePtr* output);
};

}  // namespace mojo

#endif  // UI_ACCESSIBILITY_MOJOM_AX_MODE_MOJOM_BLINK_H_