// third_party/blink/public/mojom/shared_storage/shared_storage.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* SharedStorageGetStatusToStringHelper(SharedStorageGetStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SharedStorageGetStatus::kSuccess:
      return "kSuccess";
    case SharedStorageGetStatus::kNotFound:
      return "kNotFound";
    case SharedStorageGetStatus::kError:
      return "kError";
    default:
      return nullptr;
  }
}

std::string SharedStorageGetStatusToString(SharedStorageGetStatus value) {
  const char *str = SharedStorageGetStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SharedStorageGetStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SharedStorageGetStatus value) {
  return os << SharedStorageGetStatusToString(value);
}

NOINLINE static const char* SharedStorageWorkletCreationMethodToStringHelper(SharedStorageWorkletCreationMethod value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SharedStorageWorkletCreationMethod::kAddModule:
      return "kAddModule";
    case SharedStorageWorkletCreationMethod::kCreateWorklet:
      return "kCreateWorklet";
    default:
      return nullptr;
  }
}

std::string SharedStorageWorkletCreationMethodToString(SharedStorageWorkletCreationMethod value) {
  const char *str = SharedStorageWorkletCreationMethodToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SharedStorageWorkletCreationMethod value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SharedStorageWorkletCreationMethod value) {
  return os << SharedStorageWorkletCreationMethodToString(value);
}

namespace internal {


// static
bool SharedStorageUrlWithMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageUrlWithMetadata_Data* object =
      static_cast<const SharedStorageUrlWithMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reporting_metadata, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& reporting_metadata_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->reporting_metadata, validation_context,
                                         &reporting_metadata_validate_params)) {
    return false;
  }

  return true;
}

SharedStorageUrlWithMetadata_Data::SharedStorageUrlWithMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrivateAggregationConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrivateAggregationConfig_Data* object =
      static_cast<const PrivateAggregationConfig_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->aggregation_coordinator_origin, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& context_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->context_id, validation_context,
                                         &context_id_validate_params)) {
    return false;
  }

  return true;
}

PrivateAggregationConfig_Data::PrivateAggregationConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletHost_SelectURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletHost_SelectURL_Params_Data* object =
      static_cast<const SharedStorageWorkletHost_SelectURL_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urls_with_metadata, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& urls_with_metadata_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->urls_with_metadata, validation_context,
                                         &urls_with_metadata_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->serialized_data, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->serialized_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->private_aggregation_config, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->private_aggregation_config, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->saved_query_name, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->saved_query_name, validation_context))
    return false;

  return true;
}

SharedStorageWorkletHost_SelectURL_Params_Data::SharedStorageWorkletHost_SelectURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletHost_SelectURL_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletHost_SelectURL_ResponseParams_Data* object =
      static_cast<const SharedStorageWorkletHost_SelectURL_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  return true;
}

SharedStorageWorkletHost_SelectURL_ResponseParams_Data::SharedStorageWorkletHost_SelectURL_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletHost_Run_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletHost_Run_Params_Data* object =
      static_cast<const SharedStorageWorkletHost_Run_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->serialized_data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->serialized_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->private_aggregation_config, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->private_aggregation_config, validation_context))
    return false;

  return true;
}

SharedStorageWorkletHost_Run_Params_Data::SharedStorageWorkletHost_Run_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletHost_Run_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletHost_Run_ResponseParams_Data* object =
      static_cast<const SharedStorageWorkletHost_Run_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

SharedStorageWorkletHost_Run_ResponseParams_Data::SharedStorageWorkletHost_Run_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageDocumentService_CreateWorklet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageDocumentService_CreateWorklet_Params_Data* object =
      static_cast<const SharedStorageDocumentService_CreateWorklet_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->script_source_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->script_source_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data_origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data_origin, validation_context))
    return false;


  if (!::network::mojom::internal::CredentialsMode_Data
        ::Validate(object->credentials_mode, validation_context))
    return false;


  if (!::blink::mojom::internal::SharedStorageWorkletCreationMethod_Data
        ::Validate(object->creation_method, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin_trial_features, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& origin_trial_features_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::OriginTrialFeature_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->origin_trial_features, validation_context,
                                         &origin_trial_features_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->worklet_host, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->worklet_host,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SharedStorageDocumentService_CreateWorklet_Params_Data::SharedStorageDocumentService_CreateWorklet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageDocumentService_CreateWorklet_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageDocumentService_CreateWorklet_ResponseParams_Data* object =
      static_cast<const SharedStorageDocumentService_CreateWorklet_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

SharedStorageDocumentService_CreateWorklet_ResponseParams_Data::SharedStorageDocumentService_CreateWorklet_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageDocumentService_SharedStorageGet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageDocumentService_SharedStorageGet_Params_Data* object =
      static_cast<const SharedStorageDocumentService_SharedStorageGet_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key, validation_context))
    return false;

  return true;
}

SharedStorageDocumentService_SharedStorageGet_Params_Data::SharedStorageDocumentService_SharedStorageGet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageDocumentService_SharedStorageGet_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageDocumentService_SharedStorageGet_ResponseParams_Data* object =
      static_cast<const SharedStorageDocumentService_SharedStorageGet_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::SharedStorageGetStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

SharedStorageDocumentService_SharedStorageGet_ResponseParams_Data::SharedStorageDocumentService_SharedStorageGet_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageDocumentService_SharedStorageUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageDocumentService_SharedStorageUpdate_Params_Data* object =
      static_cast<const SharedStorageDocumentService_SharedStorageUpdate_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method_with_options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->method_with_options, validation_context))
    return false;

  return true;
}

SharedStorageDocumentService_SharedStorageUpdate_Params_Data::SharedStorageDocumentService_SharedStorageUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageDocumentService_SharedStorageUpdate_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageDocumentService_SharedStorageUpdate_ResponseParams_Data* object =
      static_cast<const SharedStorageDocumentService_SharedStorageUpdate_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

SharedStorageDocumentService_SharedStorageUpdate_ResponseParams_Data::SharedStorageDocumentService_SharedStorageUpdate_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageDocumentService_SharedStorageBatchUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageDocumentService_SharedStorageBatchUpdate_Params_Data* object =
      static_cast<const SharedStorageDocumentService_SharedStorageBatchUpdate_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->methods_with_options, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& methods_with_options_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->methods_with_options, validation_context,
                                         &methods_with_options_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->with_lock, validation_context))
    return false;

  return true;
}

SharedStorageDocumentService_SharedStorageBatchUpdate_Params_Data::SharedStorageDocumentService_SharedStorageBatchUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams_Data* object =
      static_cast<const SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams_Data::SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::SharedStorageGetStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::SharedStorageGetStatus value) {
  return std::move(context).WriteString(::blink::mojom::SharedStorageGetStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::SharedStorageWorkletCreationMethod>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::SharedStorageWorkletCreationMethod value) {
  return std::move(context).WriteString(::blink::mojom::SharedStorageWorkletCreationMethodToString(value));
}

} // namespace perfetto