// third_party/blink/public/mojom/quota/quota_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_QUOTA_QUOTA_TYPES_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_QUOTA_QUOTA_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/quota/quota_types.mojom-shared-internal.h"



#include "base/component_export.h"




namespace blink::mojom {
class UsageBreakdownDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::UsageBreakdownDataView> {
  using Data = ::blink::mojom::internal::UsageBreakdown_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class StorageType : int32_t {
  
  kTemporary = 0,
  
  kDeprecatedPersistent = 1,
  
  kSyncable = 2,
  
  kDeprecatedQuotaNotManaged = 3,
  
  kUnknown = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, StorageType value);
inline bool IsKnownEnumValue(StorageType value) {
  return internal::StorageType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BucketDurability : int32_t {
  
  kRelaxed = 0,
  
  kStrict = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, BucketDurability value);
inline bool IsKnownEnumValue(BucketDurability value) {
  return internal::BucketDurability_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class QuotaStatusCode : int32_t {
  
  kOk = 0,
  
  kErrorNotSupported = 9,
  
  kErrorInvalidModification = 13,
  
  kErrorInvalidAccess = 15,
  
  kErrorAbort = 20,
  
  kUnknown = -1,
  kMinValue = -1,
  kMaxValue = 20,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, QuotaStatusCode value);
inline bool IsKnownEnumValue(QuotaStatusCode value) {
  return internal::QuotaStatusCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class UsageBreakdownDataView {
 public:
  UsageBreakdownDataView() = default;

  UsageBreakdownDataView(
      internal::UsageBreakdown_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t fileSystem() const {
    return data_->fileSystem;
  }
  int64_t webSql() const {
    return data_->webSql;
  }
  int64_t indexedDatabase() const {
    return data_->indexedDatabase;
  }
  int64_t serviceWorkerCache() const {
    return data_->serviceWorkerCache;
  }
  int64_t serviceWorker() const {
    return data_->serviceWorker;
  }
  int64_t backgroundFetch() const {
    return data_->backgroundFetch;
  }
 private:
  internal::UsageBreakdown_Data* data_ = nullptr;
};


}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::StorageType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::StorageType> {};

template <>
struct hash<::blink::mojom::BucketDurability>
    : public mojo::internal::EnumHashImpl<::blink::mojom::BucketDurability> {};

template <>
struct hash<::blink::mojom::QuotaStatusCode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::QuotaStatusCode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::StorageType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::StorageType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::StorageType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BucketDurability, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::BucketDurability, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::BucketDurability>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::QuotaStatusCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::QuotaStatusCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::QuotaStatusCode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::UsageBreakdownDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::UsageBreakdownDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::UsageBreakdown_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->fileSystem = Traits::fileSystem(input);
    fragment->webSql = Traits::webSql(input);
    fragment->indexedDatabase = Traits::indexedDatabase(input);
    fragment->serviceWorkerCache = Traits::serviceWorkerCache(input);
    fragment->serviceWorker = Traits::serviceWorker(input);
    fragment->backgroundFetch = Traits::backgroundFetch(input);
  }

  static bool Deserialize(::blink::mojom::internal::UsageBreakdown_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::UsageBreakdownDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {




}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::StorageType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::StorageType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::BucketDurability> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::BucketDurability value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::QuotaStatusCode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::QuotaStatusCode value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_QUOTA_QUOTA_TYPES_MOJOM_SHARED_H_