// third_party/blink/public/mojom/opengraph/metadata.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_OPENGRAPH_METADATA_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_OPENGRAPH_METADATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/opengraph/metadata.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/opengraph/metadata.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/opengraph/metadata.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT OpenGraphMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OpenGraphMetadata, T>::value>;
  using DataView = OpenGraphMetadataDataView;
  using Data_ = internal::OpenGraphMetadata_Data;

  template <typename... Args>
  static OpenGraphMetadataPtr New(Args&&... args) {
    return OpenGraphMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OpenGraphMetadataPtr From(const U& u) {
    return mojo::TypeConverter<OpenGraphMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OpenGraphMetadata>::Convert(*this);
  }


  OpenGraphMetadata();

  explicit OpenGraphMetadata(
      const std::optional<::GURL>& image);


  ~OpenGraphMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OpenGraphMetadataPtr>
  OpenGraphMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OpenGraphMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OpenGraphMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OpenGraphMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OpenGraphMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OpenGraphMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OpenGraphMetadata_UnserializedMessageContext<
            UserType, OpenGraphMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OpenGraphMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OpenGraphMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OpenGraphMetadata_UnserializedMessageContext<
            UserType, OpenGraphMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OpenGraphMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::GURL> image;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OpenGraphMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OpenGraphMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OpenGraphMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OpenGraphMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
OpenGraphMetadataPtr OpenGraphMetadata::Clone() const {
  return New(
      mojo::Clone(image)
  );
}

template <typename T, OpenGraphMetadata::EnableIfSame<T>*>
bool OpenGraphMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->image, other_struct.image))
    return false;
  return true;
}

template <typename T, OpenGraphMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.image < rhs.image)
    return true;
  if (rhs.image < lhs.image)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::OpenGraphMetadata::DataView,
                                         ::blink::mojom::OpenGraphMetadataPtr> {
  static bool IsNull(const ::blink::mojom::OpenGraphMetadataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::OpenGraphMetadataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::OpenGraphMetadata::image)& image(
      const ::blink::mojom::OpenGraphMetadataPtr& input) {
    return input->image;
  }

  static bool Read(::blink::mojom::OpenGraphMetadata::DataView input, ::blink::mojom::OpenGraphMetadataPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_OPENGRAPH_METADATA_MOJOM_H_