// third_party/blink/public/mojom/frame/remote_frame.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/frame/remote_frame.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/remote_frame.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {


// static
bool RemoteMainFrameInterfaces_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteMainFrameInterfaces_Data* object =
      static_cast<const RemoteMainFrameInterfaces_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->main_frame_host, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->main_frame_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->main_frame, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->main_frame,
                                                 validation_context)) {
    return false;
  }

  return true;
}

RemoteMainFrameInterfaces_Data::RemoteMainFrameInterfaces_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameInterfacesFromRenderer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrameInterfacesFromRenderer_Data* object =
      static_cast<const RemoteFrameInterfacesFromRenderer_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->frame, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->frame,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->frame_host_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->frame_host_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

RemoteFrameInterfacesFromRenderer_Data::RemoteFrameInterfacesFromRenderer_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameInterfacesFromBrowser_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrameInterfacesFromBrowser_Data* object =
      static_cast<const RemoteFrameInterfacesFromBrowser_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->frame_receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->frame_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->frame_host, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->frame_host,
                                                 validation_context)) {
    return false;
  }

  return true;
}

RemoteFrameInterfacesFromBrowser_Data::RemoteFrameInterfacesFromBrowser_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreateRemoteChildParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CreateRemoteChildParams_Data* object =
      static_cast<const CreateRemoteChildParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->opener_frame_token, validation_context))
    return false;


  if (!::blink::mojom::internal::TreeScopeType_Data
        ::Validate(object->tree_scope_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replication_state, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->replication_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->owner_properties, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->owner_properties, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtools_frame_token, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtools_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_interfaces, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_interfaces, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->child_params, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& child_params_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->child_params, validation_context,
                                         &child_params_validate_params)) {
    return false;
  }

  return true;
}

CreateRemoteChildParams_Data::CreateRemoteChildParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OpenURLParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 136, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OpenURLParams_Data* object =
      static_cast<const OpenURLParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initiator_origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->initiator_origin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->initiator_base_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->initiator_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->post_body, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extra_headers, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extra_headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extra_headers, validation_context,
                                         &extra_headers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referrer, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;


  if (!::ui::mojom::internal::WindowOpenDisposition_Data
        ::Validate(object->disposition, validation_context))
    return false;


  if (!::blink::mojom::internal::TriggeringEventInfo_Data
        ::Validate(object->triggering_event_info, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->blob_url_token,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->href_translate, 15, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& href_translate_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->href_translate, validation_context,
                                         &href_translate_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->impression, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->download_policy, 17, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->download_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_location, 18, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_location, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->initiator_navigation_state_keep_alive_handle,
                                                 validation_context)) {
    return false;
  }


  if (!::blink::mojom::internal::NavigationInitiatorActivationAndAdStatus_Data
        ::Validate(object->initiator_activation_and_ad_status, validation_context))
    return false;


  if (!::network::mojom::internal::StorageAccessApiStatus_Data
        ::Validate(object->storage_access_api_status, validation_context))
    return false;

  return true;
}

OpenURLParams_Data::OpenURLParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data* object =
      static_cast<const RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data*>(data);


  if (!::cc::mojom::internal::TouchAction_Data
        ::Validate(object->touch_action, validation_context))
    return false;

  return true;
}

RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data::RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data* object =
      static_cast<const RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data*>(data);

  return true;
}

RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data::RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_VisibilityChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrameHost_VisibilityChanged_Params_Data* object =
      static_cast<const RemoteFrameHost_VisibilityChanged_Params_Data*>(data);


  if (!::blink::mojom::internal::FrameVisibility_Data
        ::Validate(object->visibility, validation_context))
    return false;

  return true;
}

RemoteFrameHost_VisibilityChanged_Params_Data::RemoteFrameHost_VisibilityChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_DidFocusFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrameHost_DidFocusFrame_Params_Data* object =
      static_cast<const RemoteFrameHost_DidFocusFrame_Params_Data*>(data);

  return true;
}

RemoteFrameHost_DidFocusFrame_Params_Data::RemoteFrameHost_DidFocusFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_CheckCompleted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrameHost_CheckCompleted_Params_Data* object =
      static_cast<const RemoteFrameHost_CheckCompleted_Params_Data*>(data);

  return true;
}

RemoteFrameHost_CheckCompleted_Params_Data::RemoteFrameHost_CheckCompleted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data* object =
      static_cast<const RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->clip_rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->clip_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->guid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->guid, validation_context))
    return false;

  return true;
}

RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data::RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_SetIsInert_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrameHost_SetIsInert_Params_Data* object =
      static_cast<const RemoteFrameHost_SetIsInert_Params_Data*>(data);

  return true;
}

RemoteFrameHost_SetIsInert_Params_Data::RemoteFrameHost_SetIsInert_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_DidChangeOpener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrameHost_DidChangeOpener_Params_Data* object =
      static_cast<const RemoteFrameHost_DidChangeOpener_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->opener_frame, validation_context))
    return false;

  return true;
}

RemoteFrameHost_DidChangeOpener_Params_Data::RemoteFrameHost_DidChangeOpener_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_AdvanceFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrameHost_AdvanceFocus_Params_Data* object =
      static_cast<const RemoteFrameHost_AdvanceFocus_Params_Data*>(data);


  if (!::blink::mojom::internal::FocusType_Data
        ::Validate(object->focus_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_frame_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_frame_token, validation_context))
    return false;

  return true;
}

RemoteFrameHost_AdvanceFocus_Params_Data::RemoteFrameHost_AdvanceFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_RouteMessageEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrameHost_RouteMessageEvent_Params_Data* object =
      static_cast<const RemoteFrameHost_RouteMessageEvent_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->source_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->target_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message, validation_context))
    return false;

  return true;
}

RemoteFrameHost_RouteMessageEvent_Params_Data::RemoteFrameHost_RouteMessageEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_PrintCrossProcessSubframe_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrameHost_PrintCrossProcessSubframe_Params_Data* object =
      static_cast<const RemoteFrameHost_PrintCrossProcessSubframe_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_content_rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_content_rect, validation_context))
    return false;

  return true;
}

RemoteFrameHost_PrintCrossProcessSubframe_Params_Data::RemoteFrameHost_PrintCrossProcessSubframe_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_Detach_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrameHost_Detach_Params_Data* object =
      static_cast<const RemoteFrameHost_Detach_Params_Data*>(data);

  return true;
}

RemoteFrameHost_Detach_Params_Data::RemoteFrameHost_Detach_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_UpdateViewportIntersection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrameHost_UpdateViewportIntersection_Params_Data* object =
      static_cast<const RemoteFrameHost_UpdateViewportIntersection_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->intersection_state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->intersection_state, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->visual_properties, validation_context))
    return false;

  return true;
}

RemoteFrameHost_UpdateViewportIntersection_Params_Data::RemoteFrameHost_UpdateViewportIntersection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_SynchronizeVisualProperties_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrameHost_SynchronizeVisualProperties_Params_Data* object =
      static_cast<const RemoteFrameHost_SynchronizeVisualProperties_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->properties, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->properties, validation_context))
    return false;

  return true;
}

RemoteFrameHost_SynchronizeVisualProperties_Params_Data::RemoteFrameHost_SynchronizeVisualProperties_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameHost_OpenURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrameHost_OpenURL_Params_Data* object =
      static_cast<const RemoteFrameHost_OpenURL_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

RemoteFrameHost_OpenURL_Params_Data::RemoteFrameHost_OpenURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_WillEnterFullscreen_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_WillEnterFullscreen_Params_Data* object =
      static_cast<const RemoteFrame_WillEnterFullscreen_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

RemoteFrame_WillEnterFullscreen_Params_Data::RemoteFrame_WillEnterFullscreen_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_EnforceInsecureNavigationsSet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_EnforceInsecureNavigationsSet_Params_Data* object =
      static_cast<const RemoteFrame_EnforceInsecureNavigationsSet_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->set, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& set_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->set, validation_context,
                                         &set_validate_params)) {
    return false;
  }

  return true;
}

RemoteFrame_EnforceInsecureNavigationsSet_Params_Data::RemoteFrame_EnforceInsecureNavigationsSet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_SetFrameOwnerProperties_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_SetFrameOwnerProperties_Params_Data* object =
      static_cast<const RemoteFrame_SetFrameOwnerProperties_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->properties, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->properties, validation_context))
    return false;

  return true;
}

RemoteFrame_SetFrameOwnerProperties_Params_Data::RemoteFrame_SetFrameOwnerProperties_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_EnforceInsecureRequestPolicy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_EnforceInsecureRequestPolicy_Params_Data* object =
      static_cast<const RemoteFrame_EnforceInsecureRequestPolicy_Params_Data*>(data);


  if (!::blink::mojom::internal::InsecureRequestPolicy_Data
        ::Validate(object->policy, validation_context))
    return false;

  return true;
}

RemoteFrame_EnforceInsecureRequestPolicy_Params_Data::RemoteFrame_EnforceInsecureRequestPolicy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_SetReplicatedOrigin_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_SetReplicatedOrigin_Params_Data* object =
      static_cast<const RemoteFrame_SetReplicatedOrigin_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

RemoteFrame_SetReplicatedOrigin_Params_Data::RemoteFrame_SetReplicatedOrigin_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_SetReplicatedIsAdFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_SetReplicatedIsAdFrame_Params_Data* object =
      static_cast<const RemoteFrame_SetReplicatedIsAdFrame_Params_Data*>(data);

  return true;
}

RemoteFrame_SetReplicatedIsAdFrame_Params_Data::RemoteFrame_SetReplicatedIsAdFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_SetReplicatedName_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_SetReplicatedName_Params_Data* object =
      static_cast<const RemoteFrame_SetReplicatedName_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->unique_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& unique_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->unique_name, validation_context,
                                         &unique_name_validate_params)) {
    return false;
  }

  return true;
}

RemoteFrame_SetReplicatedName_Params_Data::RemoteFrame_SetReplicatedName_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data* object =
      static_cast<const RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data*>(data);

  return true;
}

RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data::RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_SetNeedsOcclusionTracking_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_SetNeedsOcclusionTracking_Params_Data* object =
      static_cast<const RemoteFrame_SetNeedsOcclusionTracking_Params_Data*>(data);

  return true;
}

RemoteFrame_SetNeedsOcclusionTracking_Params_Data::RemoteFrame_SetNeedsOcclusionTracking_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_Collapse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_Collapse_Params_Data* object =
      static_cast<const RemoteFrame_Collapse_Params_Data*>(data);

  return true;
}

RemoteFrame_Collapse_Params_Data::RemoteFrame_Collapse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_Focus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_Focus_Params_Data* object =
      static_cast<const RemoteFrame_Focus_Params_Data*>(data);

  return true;
}

RemoteFrame_Focus_Params_Data::RemoteFrame_Focus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data* object =
      static_cast<const RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data*>(data);

  return true;
}

RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data::RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_BubbleLogicalScroll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_BubbleLogicalScroll_Params_Data* object =
      static_cast<const RemoteFrame_BubbleLogicalScroll_Params_Data*>(data);


  if (!::blink::mojom::internal::ScrollDirection_Data
        ::Validate(object->direction, validation_context))
    return false;


  if (!::ui::mojom::internal::ScrollGranularity_Data
        ::Validate(object->granularity, validation_context))
    return false;

  return true;
}

RemoteFrame_BubbleLogicalScroll_Params_Data::RemoteFrame_BubbleLogicalScroll_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_UpdateUserActivationState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_UpdateUserActivationState_Params_Data* object =
      static_cast<const RemoteFrame_UpdateUserActivationState_Params_Data*>(data);


  if (!::blink::mojom::internal::UserActivationUpdateType_Data
        ::Validate(object->state_update_type, validation_context))
    return false;


  if (!::blink::mojom::internal::UserActivationNotificationType_Data
        ::Validate(object->notification_type, validation_context))
    return false;

  return true;
}

RemoteFrame_UpdateUserActivationState_Params_Data::RemoteFrame_UpdateUserActivationState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_SetEmbeddingToken_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_SetEmbeddingToken_Params_Data* object =
      static_cast<const RemoteFrame_SetEmbeddingToken_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->embedding_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->embedding_token, validation_context))
    return false;

  return true;
}

RemoteFrame_SetEmbeddingToken_Params_Data::RemoteFrame_SetEmbeddingToken_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_SetPageFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_SetPageFocus_Params_Data* object =
      static_cast<const RemoteFrame_SetPageFocus_Params_Data*>(data);

  return true;
}

RemoteFrame_SetPageFocus_Params_Data::RemoteFrame_SetPageFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_RenderFallbackContent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_RenderFallbackContent_Params_Data* object =
      static_cast<const RemoteFrame_RenderFallbackContent_Params_Data*>(data);

  return true;
}

RemoteFrame_RenderFallbackContent_Params_Data::RemoteFrame_RenderFallbackContent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_AddResourceTimingFromChild_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_AddResourceTimingFromChild_Params_Data* object =
      static_cast<const RemoteFrame_AddResourceTimingFromChild_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timing, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timing, validation_context))
    return false;

  return true;
}

RemoteFrame_AddResourceTimingFromChild_Params_Data::RemoteFrame_AddResourceTimingFromChild_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_ScrollRectToVisible_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_ScrollRectToVisible_Params_Data* object =
      static_cast<const RemoteFrame_ScrollRectToVisible_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

RemoteFrame_ScrollRectToVisible_Params_Data::RemoteFrame_ScrollRectToVisible_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_DidStartLoading_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_DidStartLoading_Params_Data* object =
      static_cast<const RemoteFrame_DidStartLoading_Params_Data*>(data);

  return true;
}

RemoteFrame_DidStartLoading_Params_Data::RemoteFrame_DidStartLoading_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_DidStopLoading_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_DidStopLoading_Params_Data* object =
      static_cast<const RemoteFrame_DidStopLoading_Params_Data*>(data);

  return true;
}

RemoteFrame_DidStopLoading_Params_Data::RemoteFrame_DidStopLoading_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data* object =
      static_cast<const RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sizing_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sizing_info, validation_context))
    return false;

  return true;
}

RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data::RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_DidSetFramePolicyHeaders_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_DidSetFramePolicyHeaders_Params_Data* object =
      static_cast<const RemoteFrame_DidSetFramePolicyHeaders_Params_Data*>(data);


  if (!::network::mojom::internal::WebSandboxFlags_Data
        ::Validate(object->sandbox_flags, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parsed_permissions_policy, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& parsed_permissions_policy_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->parsed_permissions_policy, validation_context,
                                         &parsed_permissions_policy_validate_params)) {
    return false;
  }

  return true;
}

RemoteFrame_DidSetFramePolicyHeaders_Params_Data::RemoteFrame_DidSetFramePolicyHeaders_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_DidUpdateFramePolicy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_DidUpdateFramePolicy_Params_Data* object =
      static_cast<const RemoteFrame_DidUpdateFramePolicy_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_policy, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_policy, validation_context))
    return false;

  return true;
}

RemoteFrame_DidUpdateFramePolicy_Params_Data::RemoteFrame_DidUpdateFramePolicy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_UpdateOpener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_UpdateOpener_Params_Data* object =
      static_cast<const RemoteFrame_UpdateOpener_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnion(object->opener_frame_token, validation_context))
    return false;

  return true;
}

RemoteFrame_UpdateOpener_Params_Data::RemoteFrame_UpdateOpener_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_DetachAndDispose_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_DetachAndDispose_Params_Data* object =
      static_cast<const RemoteFrame_DetachAndDispose_Params_Data*>(data);

  return true;
}

RemoteFrame_DetachAndDispose_Params_Data::RemoteFrame_DetachAndDispose_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_EnableAutoResize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_EnableAutoResize_Params_Data* object =
      static_cast<const RemoteFrame_EnableAutoResize_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->min_size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->min_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->max_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->max_size, validation_context))
    return false;

  return true;
}

RemoteFrame_EnableAutoResize_Params_Data::RemoteFrame_EnableAutoResize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_DisableAutoResize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_DisableAutoResize_Params_Data* object =
      static_cast<const RemoteFrame_DisableAutoResize_Params_Data*>(data);

  return true;
}

RemoteFrame_DisableAutoResize_Params_Data::RemoteFrame_DisableAutoResize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_DidUpdateVisualProperties_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_DidUpdateVisualProperties_Params_Data* object =
      static_cast<const RemoteFrame_DidUpdateVisualProperties_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

RemoteFrame_DidUpdateVisualProperties_Params_Data::RemoteFrame_DidUpdateVisualProperties_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_SetFrameSinkId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_SetFrameSinkId_Params_Data* object =
      static_cast<const RemoteFrame_SetFrameSinkId_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_sink_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_sink_id, validation_context))
    return false;

  return true;
}

RemoteFrame_SetFrameSinkId_Params_Data::RemoteFrame_SetFrameSinkId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_ChildProcessGone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_ChildProcessGone_Params_Data* object =
      static_cast<const RemoteFrame_ChildProcessGone_Params_Data*>(data);

  return true;
}

RemoteFrame_ChildProcessGone_Params_Data::RemoteFrame_ChildProcessGone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_CreateRemoteChild_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_CreateRemoteChild_Params_Data* object =
      static_cast<const RemoteFrame_CreateRemoteChild_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->opener_frame_token, validation_context))
    return false;


  if (!::blink::mojom::internal::TreeScopeType_Data
        ::Validate(object->tree_scope_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replication_state, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->replication_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->owner_properties, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->owner_properties, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtools_frame_token, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtools_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_frame_interfaces, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_frame_interfaces, validation_context))
    return false;

  return true;
}

RemoteFrame_CreateRemoteChild_Params_Data::RemoteFrame_CreateRemoteChild_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_CreateRemoteChildren_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_CreateRemoteChildren_Params_Data* object =
      static_cast<const RemoteFrame_CreateRemoteChildren_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& params_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->params, validation_context,
                                         &params_validate_params)) {
    return false;
  }

  return true;
}

RemoteFrame_CreateRemoteChildren_Params_Data::RemoteFrame_CreateRemoteChildren_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrame_ForwardFencedFrameEventToEmbedder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrame_ForwardFencedFrameEventToEmbedder_Params_Data* object =
      static_cast<const RemoteFrame_ForwardFencedFrameEventToEmbedder_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_type, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& event_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->event_type, validation_context,
                                         &event_type_validate_params)) {
    return false;
  }

  return true;
}

RemoteFrame_ForwardFencedFrameEventToEmbedder_Params_Data::RemoteFrame_ForwardFencedFrameEventToEmbedder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data* object =
      static_cast<const RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->page_info, validation_context))
    return false;

  return true;
}

RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data::RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteMainFrameHost_FocusPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteMainFrameHost_FocusPage_Params_Data* object =
      static_cast<const RemoteMainFrameHost_FocusPage_Params_Data*>(data);

  return true;
}

RemoteMainFrameHost_FocusPage_Params_Data::RemoteMainFrameHost_FocusPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteMainFrameHost_TakeFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteMainFrameHost_TakeFocus_Params_Data* object =
      static_cast<const RemoteMainFrameHost_TakeFocus_Params_Data*>(data);

  return true;
}

RemoteMainFrameHost_TakeFocus_Params_Data::RemoteMainFrameHost_TakeFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteMainFrameHost_UpdateTargetURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteMainFrameHost_UpdateTargetURL_Params_Data* object =
      static_cast<const RemoteMainFrameHost_UpdateTargetURL_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

RemoteMainFrameHost_UpdateTargetURL_Params_Data::RemoteMainFrameHost_UpdateTargetURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data* object =
      static_cast<const RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data*>(data);

  return true;
}

RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data::RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteMainFrameHost_RouteCloseEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteMainFrameHost_RouteCloseEvent_Params_Data* object =
      static_cast<const RemoteMainFrameHost_RouteCloseEvent_Params_Data*>(data);

  return true;
}

RemoteMainFrameHost_RouteCloseEvent_Params_Data::RemoteMainFrameHost_RouteCloseEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink