// third_party/blink/public/mojom/frame/frame_visual_properties.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_VISUAL_PROPERTIES_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_VISUAL_PROPERTIES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/frame_visual_properties.mojom-shared-internal.h"
#include "cc/mojom/browser_controls_params.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "ui/display/mojom/screen_infos.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class FrameVisualPropertiesDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FrameVisualPropertiesDataView> {
  using Data = ::blink::mojom::internal::FrameVisualProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class FrameVisualPropertiesDataView {
 public:
  FrameVisualPropertiesDataView() = default;

  FrameVisualPropertiesDataView(
      internal::FrameVisualProperties_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScreenInfosDataView(
      ::display::mojom::ScreenInfosDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScreenInfos(UserType* output) {
    
    auto* pointer = data_->screen_infos.Get();
    return mojo::internal::Deserialize<::display::mojom::ScreenInfosDataView>(
        pointer, output, message_);
  }
  bool auto_resize_enabled() const {
    return data_->auto_resize_enabled;
  }
  bool is_pinch_gesture_active() const {
    return data_->is_pinch_gesture_active;
  }
  uint32_t capture_sequence_number() const {
    return data_->capture_sequence_number;
  }
  double zoom_level() const {
    return data_->zoom_level;
  }
  double css_zoom_factor() const {
    return data_->css_zoom_factor;
  }
  float page_scale_factor() const {
    return data_->page_scale_factor;
  }
  float compositing_scale_factor() const {
    return data_->compositing_scale_factor;
  }
  float cursor_accessibility_scale_factor() const {
    return data_->cursor_accessibility_scale_factor;
  }
  inline void GetVisibleViewportSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleViewportSize(UserType* output) {
    
    auto* pointer = data_->visible_viewport_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetMinSizeForAutoResizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMinSizeForAutoResize(UserType* output) {
    
    auto* pointer = data_->min_size_for_auto_resize.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetMaxSizeForAutoResizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxSizeForAutoResize(UserType* output) {
    
    auto* pointer = data_->max_size_for_auto_resize.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetRootWidgetViewportSegmentsDataView(
      mojo::ArrayDataView<::gfx::mojom::RectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootWidgetViewportSegments(UserType* output) {
    
    auto* pointer = data_->root_widget_viewport_segments.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
        pointer, output, message_);
  }
  inline void GetCompositorViewportDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCompositorViewport(UserType* output) {
    
    auto* pointer = data_->compositor_viewport.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetRectInLocalRootDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRectInLocalRoot(UserType* output) {
    
    auto* pointer = data_->rect_in_local_root.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetLocalFrameSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalFrameSize(UserType* output) {
    
    auto* pointer = data_->local_frame_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetLocalSurfaceIdDataView(
      ::viz::mojom::LocalSurfaceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalSurfaceId(UserType* output) {
    
    auto* pointer = data_->local_surface_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::LocalSurfaceIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::FrameVisualProperties_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FrameVisualPropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FrameVisualPropertiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FrameVisualProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::screen_infos(input)) in_screen_infos = Traits::screen_infos(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->screen_infos)::BaseType> screen_infos_fragment(
            fragment.message());
    mojo::internal::Serialize<::display::mojom::ScreenInfosDataView>(
        in_screen_infos, screen_infos_fragment);
    fragment->screen_infos.Set(
        screen_infos_fragment.is_null() ? nullptr : screen_infos_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->screen_infos.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null screen_infos in FrameVisualProperties struct");
    fragment->auto_resize_enabled = Traits::auto_resize_enabled(input);
    fragment->is_pinch_gesture_active = Traits::is_pinch_gesture_active(input);
    fragment->capture_sequence_number = Traits::capture_sequence_number(input);
    fragment->zoom_level = Traits::zoom_level(input);
    fragment->css_zoom_factor = Traits::css_zoom_factor(input);
    fragment->page_scale_factor = Traits::page_scale_factor(input);
    fragment->compositing_scale_factor = Traits::compositing_scale_factor(input);
    fragment->cursor_accessibility_scale_factor = Traits::cursor_accessibility_scale_factor(input);
    decltype(Traits::visible_viewport_size(input)) in_visible_viewport_size = Traits::visible_viewport_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visible_viewport_size)::BaseType> visible_viewport_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_visible_viewport_size, visible_viewport_size_fragment);
    fragment->visible_viewport_size.Set(
        visible_viewport_size_fragment.is_null() ? nullptr : visible_viewport_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->visible_viewport_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visible_viewport_size in FrameVisualProperties struct");
    decltype(Traits::min_size_for_auto_resize(input)) in_min_size_for_auto_resize = Traits::min_size_for_auto_resize(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->min_size_for_auto_resize)::BaseType> min_size_for_auto_resize_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_min_size_for_auto_resize, min_size_for_auto_resize_fragment);
    fragment->min_size_for_auto_resize.Set(
        min_size_for_auto_resize_fragment.is_null() ? nullptr : min_size_for_auto_resize_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->min_size_for_auto_resize.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null min_size_for_auto_resize in FrameVisualProperties struct");
    decltype(Traits::max_size_for_auto_resize(input)) in_max_size_for_auto_resize = Traits::max_size_for_auto_resize(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->max_size_for_auto_resize)::BaseType> max_size_for_auto_resize_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_max_size_for_auto_resize, max_size_for_auto_resize_fragment);
    fragment->max_size_for_auto_resize.Set(
        max_size_for_auto_resize_fragment.is_null() ? nullptr : max_size_for_auto_resize_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->max_size_for_auto_resize.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null max_size_for_auto_resize in FrameVisualProperties struct");
    decltype(Traits::root_widget_viewport_segments(input)) in_root_widget_viewport_segments = Traits::root_widget_viewport_segments(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->root_widget_viewport_segments)::BaseType>
        root_widget_viewport_segments_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& root_widget_viewport_segments_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
        in_root_widget_viewport_segments, root_widget_viewport_segments_fragment, &root_widget_viewport_segments_validate_params);
    fragment->root_widget_viewport_segments.Set(
        root_widget_viewport_segments_fragment.is_null() ? nullptr : root_widget_viewport_segments_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->root_widget_viewport_segments.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null root_widget_viewport_segments in FrameVisualProperties struct");
    decltype(Traits::compositor_viewport(input)) in_compositor_viewport = Traits::compositor_viewport(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->compositor_viewport)::BaseType> compositor_viewport_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_compositor_viewport, compositor_viewport_fragment);
    fragment->compositor_viewport.Set(
        compositor_viewport_fragment.is_null() ? nullptr : compositor_viewport_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->compositor_viewport.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null compositor_viewport in FrameVisualProperties struct");
    decltype(Traits::rect_in_local_root(input)) in_rect_in_local_root = Traits::rect_in_local_root(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rect_in_local_root)::BaseType> rect_in_local_root_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_rect_in_local_root, rect_in_local_root_fragment);
    fragment->rect_in_local_root.Set(
        rect_in_local_root_fragment.is_null() ? nullptr : rect_in_local_root_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->rect_in_local_root.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rect_in_local_root in FrameVisualProperties struct");
    decltype(Traits::local_frame_size(input)) in_local_frame_size = Traits::local_frame_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->local_frame_size)::BaseType> local_frame_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_local_frame_size, local_frame_size_fragment);
    fragment->local_frame_size.Set(
        local_frame_size_fragment.is_null() ? nullptr : local_frame_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->local_frame_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null local_frame_size in FrameVisualProperties struct");
    decltype(Traits::local_surface_id(input)) in_local_surface_id = Traits::local_surface_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->local_surface_id)::BaseType> local_surface_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
        in_local_surface_id, local_surface_id_fragment);
    fragment->local_surface_id.Set(
        local_surface_id_fragment.is_null() ? nullptr : local_surface_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->local_surface_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null local_surface_id in FrameVisualProperties struct");
  }

  static bool Deserialize(::blink::mojom::internal::FrameVisualProperties_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FrameVisualPropertiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void FrameVisualPropertiesDataView::GetScreenInfosDataView(
    ::display::mojom::ScreenInfosDataView* output) {
  auto pointer = data_->screen_infos.Get();
  *output = ::display::mojom::ScreenInfosDataView(pointer, message_);
}
inline void FrameVisualPropertiesDataView::GetVisibleViewportSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->visible_viewport_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void FrameVisualPropertiesDataView::GetMinSizeForAutoResizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->min_size_for_auto_resize.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void FrameVisualPropertiesDataView::GetMaxSizeForAutoResizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->max_size_for_auto_resize.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void FrameVisualPropertiesDataView::GetRootWidgetViewportSegmentsDataView(
    mojo::ArrayDataView<::gfx::mojom::RectDataView>* output) {
  auto pointer = data_->root_widget_viewport_segments.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::RectDataView>(pointer, message_);
}
inline void FrameVisualPropertiesDataView::GetCompositorViewportDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->compositor_viewport.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void FrameVisualPropertiesDataView::GetRectInLocalRootDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->rect_in_local_root.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void FrameVisualPropertiesDataView::GetLocalFrameSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->local_frame_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void FrameVisualPropertiesDataView::GetLocalSurfaceIdDataView(
    ::viz::mojom::LocalSurfaceIdDataView* output) {
  auto pointer = data_->local_surface_id.Get();
  *output = ::viz::mojom::LocalSurfaceIdDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_VISUAL_PROPERTIES_MOJOM_SHARED_H_