// third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* RequestContextTypeToStringHelper(RequestContextType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RequestContextType::UNSPECIFIED:
      return "UNSPECIFIED";
    case RequestContextType::ATTRIBUTION_SRC:
      return "ATTRIBUTION_SRC";
    case RequestContextType::AUDIO:
      return "AUDIO";
    case RequestContextType::BEACON:
      return "BEACON";
    case RequestContextType::CSP_REPORT:
      return "CSP_REPORT";
    case RequestContextType::DOWNLOAD:
      return "DOWNLOAD";
    case RequestContextType::EMBED:
      return "EMBED";
    case RequestContextType::EVENT_SOURCE:
      return "EVENT_SOURCE";
    case RequestContextType::FAVICON:
      return "FAVICON";
    case RequestContextType::FETCH:
      return "FETCH";
    case RequestContextType::FONT:
      return "FONT";
    case RequestContextType::FORM:
      return "FORM";
    case RequestContextType::FRAME:
      return "FRAME";
    case RequestContextType::HYPERLINK:
      return "HYPERLINK";
    case RequestContextType::IFRAME:
      return "IFRAME";
    case RequestContextType::IMAGE:
      return "IMAGE";
    case RequestContextType::IMAGE_SET:
      return "IMAGE_SET";
    case RequestContextType::INTERNAL:
      return "INTERNAL";
    case RequestContextType::JSON:
      return "JSON";
    case RequestContextType::LOCATION:
      return "LOCATION";
    case RequestContextType::MANIFEST:
      return "MANIFEST";
    case RequestContextType::OBJECT:
      return "OBJECT";
    case RequestContextType::PING:
      return "PING";
    case RequestContextType::PLUGIN:
      return "PLUGIN";
    case RequestContextType::PREFETCH:
      return "PREFETCH";
    case RequestContextType::SCRIPT:
      return "SCRIPT";
    case RequestContextType::SERVICE_WORKER:
      return "SERVICE_WORKER";
    case RequestContextType::SHARED_WORKER:
      return "SHARED_WORKER";
    case RequestContextType::SPECULATION_RULES:
      return "SPECULATION_RULES";
    case RequestContextType::SUBRESOURCE:
      return "SUBRESOURCE";
    case RequestContextType::SUBRESOURCE_WEBBUNDLE:
      return "SUBRESOURCE_WEBBUNDLE";
    case RequestContextType::STYLE:
      return "STYLE";
    case RequestContextType::TRACK:
      return "TRACK";
    case RequestContextType::VIDEO:
      return "VIDEO";
    case RequestContextType::WORKER:
      return "WORKER";
    case RequestContextType::XML_HTTP_REQUEST:
      return "XML_HTTP_REQUEST";
    case RequestContextType::XSLT:
      return "XSLT";
    default:
      return nullptr;
  }
}

std::string RequestContextTypeToString(RequestContextType value) {
  const char *str = RequestContextTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RequestContextType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RequestContextType value) {
  return os << RequestContextTypeToString(value);
}

NOINLINE static const char* FetchCacheModeToStringHelper(FetchCacheMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FetchCacheMode::kDefault:
      return "kDefault";
    case FetchCacheMode::kNoStore:
      return "kNoStore";
    case FetchCacheMode::kBypassCache:
      return "kBypassCache";
    case FetchCacheMode::kValidateCache:
      return "kValidateCache";
    case FetchCacheMode::kForceCache:
      return "kForceCache";
    case FetchCacheMode::kOnlyIfCached:
      return "kOnlyIfCached";
    case FetchCacheMode::kUnspecifiedOnlyIfCachedStrict:
      return "kUnspecifiedOnlyIfCachedStrict";
    case FetchCacheMode::kUnspecifiedForceCacheMiss:
      return "kUnspecifiedForceCacheMiss";
    default:
      return nullptr;
  }
}

std::string FetchCacheModeToString(FetchCacheMode value) {
  const char *str = FetchCacheModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FetchCacheMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FetchCacheMode value) {
  return os << FetchCacheModeToString(value);
}

NOINLINE static const char* FetchPriorityHintToStringHelper(FetchPriorityHint value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FetchPriorityHint::kLow:
      return "kLow";
    case FetchPriorityHint::kAuto:
      return "kAuto";
    case FetchPriorityHint::kHigh:
      return "kHigh";
    default:
      return nullptr;
  }
}

std::string FetchPriorityHintToString(FetchPriorityHint value) {
  const char *str = FetchPriorityHintToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FetchPriorityHint value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FetchPriorityHint value) {
  return os << FetchPriorityHintToString(value);
}

namespace internal {


// static
bool FetchAPIRequestHeaders_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FetchAPIRequestHeaders_Data* object =
      static_cast<const FetchAPIRequestHeaders_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->headers, validation_context,
                                         &headers_validate_params)) {
    return false;
  }

  return true;
}

FetchAPIRequestHeaders_Data::FetchAPIRequestHeaders_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FetchAPIRequestBody_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FetchAPIRequestBody_Data* object =
      static_cast<const FetchAPIRequestBody_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->elements, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& elements_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->elements, validation_context,
                                         &elements_validate_params)) {
    return false;
  }

  return true;
}

FetchAPIRequestBody_Data::FetchAPIRequestBody_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FetchAPIRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 160, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FetchAPIRequest_Data* object =
      static_cast<const FetchAPIRequest_Data*>(data);


  if (!::network::mojom::internal::RequestMode_Data
        ::Validate(object->mode, validation_context))
    return false;


  if (!::network::mojom::internal::RequestDestination_Data
        ::Validate(object->destination, validation_context))
    return false;


  if (!::blink::mojom::internal::RequestContextFrameType_Data
        ::Validate(object->frame_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& method_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->method, validation_context,
                                         &method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->headers, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->blob, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->body, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->request_initiator, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->navigation_redirect_chain, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& navigation_redirect_chain_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->navigation_redirect_chain, validation_context,
                                         &navigation_redirect_chain_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;


  if (!::network::mojom::internal::CredentialsMode_Data
        ::Validate(object->credentials_mode, validation_context))
    return false;


  if (!::blink::mojom::internal::FetchCacheMode_Data
        ::Validate(object->cache_mode, validation_context))
    return false;


  if (!::network::mojom::internal::RedirectMode_Data
        ::Validate(object->redirect_mode, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& integrity_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->integrity, validation_context,
                                         &integrity_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::RequestPriority_Data
        ::Validate(object->priority, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->fetch_window_id, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& devtools_stack_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->devtools_stack_id, validation_context,
                                         &devtools_stack_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->trust_token_params, validation_context))
    return false;


  if (!::network::mojom::internal::IPAddressSpace_Data
        ::Validate(object->target_address_space, validation_context))
    return false;


  if (!::network::mojom::internal::AttributionReportingEligibility_Data
        ::Validate(object->attribution_reporting_eligibility, validation_context))
    return false;


  if (!::network::mojom::internal::AttributionSupport_Data
        ::Validate(object->attribution_reporting_support, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->service_worker_race_network_request_token, validation_context))
    return false;

  return true;
}

FetchAPIRequest_Data::FetchAPIRequest_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::RequestContextType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::RequestContextType value) {
  return std::move(context).WriteString(::blink::mojom::RequestContextTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FetchCacheMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::FetchCacheMode value) {
  return std::move(context).WriteString(::blink::mojom::FetchCacheModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FetchPriorityHint>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::FetchPriorityHint value) {
  return std::move(context).WriteString(::blink::mojom::FetchPriorityHintToString(value));
}

} // namespace perfetto