// services/viz/privileged/mojom/gl/gpu_host.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/gl/gpu_host.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/gl/gpu_host.mojom-params-data.h"
#include "services/viz/privileged/mojom/gl/gpu_host.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/gl/gpu_host.mojom-import-headers.h"
#include "services/viz/privileged/mojom/gl/gpu_host.mojom-test-utils.h"


namespace viz::mojom {
const char GpuHost::Name_[] = "viz.mojom.GpuHost";

GpuHost::IPCStableHashFunction GpuHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GpuHost>(message.name())) {
    case messages::GpuHost::kDidInitialize: {
      return &GpuHost::DidInitialize_Sym::IPCStableHash;
    }
    case messages::GpuHost::kDidFailInitialize: {
      return &GpuHost::DidFailInitialize_Sym::IPCStableHash;
    }
    case messages::GpuHost::kDidCreateContextSuccessfully: {
      return &GpuHost::DidCreateContextSuccessfully_Sym::IPCStableHash;
    }
    case messages::GpuHost::kDidCreateOffscreenContext: {
      return &GpuHost::DidCreateOffscreenContext_Sym::IPCStableHash;
    }
    case messages::GpuHost::kDidDestroyOffscreenContext: {
      return &GpuHost::DidDestroyOffscreenContext_Sym::IPCStableHash;
    }
    case messages::GpuHost::kDidDestroyChannel: {
      return &GpuHost::DidDestroyChannel_Sym::IPCStableHash;
    }
    case messages::GpuHost::kDidDestroyAllChannels: {
      return &GpuHost::DidDestroyAllChannels_Sym::IPCStableHash;
    }
    case messages::GpuHost::kDidLoseContext: {
      return &GpuHost::DidLoseContext_Sym::IPCStableHash;
    }
    case messages::GpuHost::kDidUpdateGPUInfo: {
      return &GpuHost::DidUpdateGPUInfo_Sym::IPCStableHash;
    }
    case messages::GpuHost::kDisableGpuCompositing: {
      return &GpuHost::DisableGpuCompositing_Sym::IPCStableHash;
    }
    case messages::GpuHost::kGetIsolationKey: {
      return &GpuHost::GetIsolationKey_Sym::IPCStableHash;
    }
    case messages::GpuHost::kStoreBlobToDisk: {
      return &GpuHost::StoreBlobToDisk_Sym::IPCStableHash;
    }
    case messages::GpuHost::kRecordLogMessage: {
      return &GpuHost::RecordLogMessage_Sym::IPCStableHash;
    }
    case messages::GpuHost::kClearGrShaderDiskCache: {
      return &GpuHost::ClearGrShaderDiskCache_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GpuHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GpuHost>(message.name())) {
      case messages::GpuHost::kDidInitialize:
            return "Receive viz::mojom::GpuHost::DidInitialize";
      case messages::GpuHost::kDidFailInitialize:
            return "Receive viz::mojom::GpuHost::DidFailInitialize";
      case messages::GpuHost::kDidCreateContextSuccessfully:
            return "Receive viz::mojom::GpuHost::DidCreateContextSuccessfully";
      case messages::GpuHost::kDidCreateOffscreenContext:
            return "Receive viz::mojom::GpuHost::DidCreateOffscreenContext";
      case messages::GpuHost::kDidDestroyOffscreenContext:
            return "Receive viz::mojom::GpuHost::DidDestroyOffscreenContext";
      case messages::GpuHost::kDidDestroyChannel:
            return "Receive viz::mojom::GpuHost::DidDestroyChannel";
      case messages::GpuHost::kDidDestroyAllChannels:
            return "Receive viz::mojom::GpuHost::DidDestroyAllChannels";
      case messages::GpuHost::kDidLoseContext:
            return "Receive viz::mojom::GpuHost::DidLoseContext";
      case messages::GpuHost::kDidUpdateGPUInfo:
            return "Receive viz::mojom::GpuHost::DidUpdateGPUInfo";
      case messages::GpuHost::kDisableGpuCompositing:
            return "Receive viz::mojom::GpuHost::DisableGpuCompositing";
      case messages::GpuHost::kGetIsolationKey:
            return "Receive viz::mojom::GpuHost::GetIsolationKey";
      case messages::GpuHost::kStoreBlobToDisk:
            return "Receive viz::mojom::GpuHost::StoreBlobToDisk";
      case messages::GpuHost::kRecordLogMessage:
            return "Receive viz::mojom::GpuHost::RecordLogMessage";
      case messages::GpuHost::kClearGrShaderDiskCache:
            return "Receive viz::mojom::GpuHost::ClearGrShaderDiskCache";
    }
  } else {
    switch (static_cast<messages::GpuHost>(message.name())) {
      case messages::GpuHost::kDidInitialize:
            return "Receive reply viz::mojom::GpuHost::DidInitialize";
      case messages::GpuHost::kDidFailInitialize:
            return "Receive reply viz::mojom::GpuHost::DidFailInitialize";
      case messages::GpuHost::kDidCreateContextSuccessfully:
            return "Receive reply viz::mojom::GpuHost::DidCreateContextSuccessfully";
      case messages::GpuHost::kDidCreateOffscreenContext:
            return "Receive reply viz::mojom::GpuHost::DidCreateOffscreenContext";
      case messages::GpuHost::kDidDestroyOffscreenContext:
            return "Receive reply viz::mojom::GpuHost::DidDestroyOffscreenContext";
      case messages::GpuHost::kDidDestroyChannel:
            return "Receive reply viz::mojom::GpuHost::DidDestroyChannel";
      case messages::GpuHost::kDidDestroyAllChannels:
            return "Receive reply viz::mojom::GpuHost::DidDestroyAllChannels";
      case messages::GpuHost::kDidLoseContext:
            return "Receive reply viz::mojom::GpuHost::DidLoseContext";
      case messages::GpuHost::kDidUpdateGPUInfo:
            return "Receive reply viz::mojom::GpuHost::DidUpdateGPUInfo";
      case messages::GpuHost::kDisableGpuCompositing:
            return "Receive reply viz::mojom::GpuHost::DisableGpuCompositing";
      case messages::GpuHost::kGetIsolationKey:
            return "Receive reply viz::mojom::GpuHost::GetIsolationKey";
      case messages::GpuHost::kStoreBlobToDisk:
            return "Receive reply viz::mojom::GpuHost::StoreBlobToDisk";
      case messages::GpuHost::kRecordLogMessage:
            return "Receive reply viz::mojom::GpuHost::RecordLogMessage";
      case messages::GpuHost::kClearGrShaderDiskCache:
            return "Receive reply viz::mojom::GpuHost::ClearGrShaderDiskCache";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GpuHost::DidInitialize_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::GpuHost::DidInitialize");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuHost::DidFailInitialize_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::GpuHost::DidFailInitialize");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuHost::DidCreateContextSuccessfully_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::GpuHost::DidCreateContextSuccessfully");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuHost::DidCreateOffscreenContext_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::GpuHost::DidCreateOffscreenContext");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuHost::DidDestroyOffscreenContext_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::GpuHost::DidDestroyOffscreenContext");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuHost::DidDestroyChannel_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::GpuHost::DidDestroyChannel");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuHost::DidDestroyAllChannels_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::GpuHost::DidDestroyAllChannels");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuHost::DidLoseContext_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::GpuHost::DidLoseContext");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuHost::DidUpdateGPUInfo_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::GpuHost::DidUpdateGPUInfo");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuHost::DisableGpuCompositing_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::GpuHost::DisableGpuCompositing");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuHost::GetIsolationKey_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::GpuHost::GetIsolationKey");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuHost::StoreBlobToDisk_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::GpuHost::StoreBlobToDisk");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuHost::RecordLogMessage_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::GpuHost::RecordLogMessage");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuHost::ClearGrShaderDiskCache_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::GpuHost::ClearGrShaderDiskCache");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class GpuHost_GetIsolationKey_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuHost_GetIsolationKey_ForwardToCallback(
      GpuHost::GetIsolationKeyCallback callback
      ) : callback_(std::move(callback)) {
  }

  GpuHost_GetIsolationKey_ForwardToCallback(const GpuHost_GetIsolationKey_ForwardToCallback&) = delete;
  GpuHost_GetIsolationKey_ForwardToCallback& operator=(const GpuHost_GetIsolationKey_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GpuHost::GetIsolationKeyCallback callback_;
};

GpuHostProxy::GpuHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GpuHostProxy::DidInitialize(
    const ::gpu::GPUInfo& in_gpu_info, const ::gpu::GpuFeatureInfo& in_gpu_feature_info, const std::optional<::gpu::GPUInfo>& in_gpu_info_for_hardware_gpu, const std::optional<::gpu::GpuFeatureInfo>& in_gpu_feature_info_for_hardware_gpu, const ::gfx::GpuExtraInfo& in_gpu_extra_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuHost::DidInitialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_info"), in_gpu_info,
                        "<value of type const ::gpu::GPUInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_feature_info"), in_gpu_feature_info,
                        "<value of type const ::gpu::GpuFeatureInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_info_for_hardware_gpu"), in_gpu_info_for_hardware_gpu,
                        "<value of type const std::optional<::gpu::GPUInfo>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_feature_info_for_hardware_gpu"), in_gpu_feature_info_for_hardware_gpu,
                        "<value of type const std::optional<::gpu::GpuFeatureInfo>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_extra_info"), in_gpu_extra_info,
                        "<value of type const ::gfx::GpuExtraInfo&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuHost::kDidInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DidInitialize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_info)::BaseType> gpu_info_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::GpuInfoDataView>(
      in_gpu_info, gpu_info_fragment);
  params->gpu_info.Set(
      gpu_info_fragment.is_null() ? nullptr : gpu_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gpu_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gpu_info in GpuHost.DidInitialize request");
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_feature_info)::BaseType> gpu_feature_info_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::GpuFeatureInfoDataView>(
      in_gpu_feature_info, gpu_feature_info_fragment);
  params->gpu_feature_info.Set(
      gpu_feature_info_fragment.is_null() ? nullptr : gpu_feature_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gpu_feature_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gpu_feature_info in GpuHost.DidInitialize request");
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_info_for_hardware_gpu)::BaseType> gpu_info_for_hardware_gpu_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::GpuInfoDataView>(
      in_gpu_info_for_hardware_gpu, gpu_info_for_hardware_gpu_fragment);
  params->gpu_info_for_hardware_gpu.Set(
      gpu_info_for_hardware_gpu_fragment.is_null() ? nullptr : gpu_info_for_hardware_gpu_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_feature_info_for_hardware_gpu)::BaseType> gpu_feature_info_for_hardware_gpu_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::GpuFeatureInfoDataView>(
      in_gpu_feature_info_for_hardware_gpu, gpu_feature_info_for_hardware_gpu_fragment);
  params->gpu_feature_info_for_hardware_gpu.Set(
      gpu_feature_info_for_hardware_gpu_fragment.is_null() ? nullptr : gpu_feature_info_for_hardware_gpu_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_extra_info)::BaseType> gpu_extra_info_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuExtraInfoDataView>(
      in_gpu_extra_info, gpu_extra_info_fragment);
  params->gpu_extra_info.Set(
      gpu_extra_info_fragment.is_null() ? nullptr : gpu_extra_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gpu_extra_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gpu_extra_info in GpuHost.DidInitialize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DidInitialize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuHostProxy::DidFailInitialize(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuHost::DidFailInitialize");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuHost::kDidFailInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DidFailInitialize_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DidFailInitialize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuHostProxy::DidCreateContextSuccessfully(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuHost::DidCreateContextSuccessfully");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuHost::kDidCreateContextSuccessfully), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DidCreateContextSuccessfully_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DidCreateContextSuccessfully");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuHostProxy::DidCreateOffscreenContext(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuHost::DidCreateOffscreenContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuHost::kDidCreateOffscreenContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DidCreateOffscreenContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in GpuHost.DidCreateOffscreenContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DidCreateOffscreenContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuHostProxy::DidDestroyOffscreenContext(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuHost::DidDestroyOffscreenContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuHost::kDidDestroyOffscreenContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DidDestroyOffscreenContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in GpuHost.DidDestroyOffscreenContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DidDestroyOffscreenContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuHostProxy::DidDestroyChannel(
    int32_t in_client_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuHost::DidDestroyChannel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuHost::kDidDestroyChannel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DidDestroyChannel_Params_Data> params(
          message);
  params.Allocate();
  params->client_id = in_client_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DidDestroyChannel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuHostProxy::DidDestroyAllChannels(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuHost::DidDestroyAllChannels");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuHost::kDidDestroyAllChannels), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DidDestroyAllChannels_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DidDestroyAllChannels");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuHostProxy::DidLoseContext(
    ::gpu::error::ContextLostReason in_reason, const ::GURL& in_active_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuHost::DidLoseContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::gpu::error::ContextLostReason>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("active_url"), in_active_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuHost::kDidLoseContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DidLoseContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::viz::mojom::ContextLostReason>(
      in_reason, &params->reason);
  mojo::internal::MessageFragment<
      typename decltype(params->active_url)::BaseType> active_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_active_url, active_url_fragment);
  params->active_url.Set(
      active_url_fragment.is_null() ? nullptr : active_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->active_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null active_url in GpuHost.DidLoseContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DidLoseContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuHostProxy::DidUpdateGPUInfo(
    const ::gpu::GPUInfo& in_gpu_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuHost::DidUpdateGPUInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_info"), in_gpu_info,
                        "<value of type const ::gpu::GPUInfo&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuHost::kDidUpdateGPUInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DidUpdateGPUInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_info)::BaseType> gpu_info_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::GpuInfoDataView>(
      in_gpu_info, gpu_info_fragment);
  params->gpu_info.Set(
      gpu_info_fragment.is_null() ? nullptr : gpu_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->gpu_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gpu_info in GpuHost.DidUpdateGPUInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DidUpdateGPUInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuHostProxy::DisableGpuCompositing(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuHost::DisableGpuCompositing");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuHost::kDisableGpuCompositing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_DisableGpuCompositing_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("DisableGpuCompositing");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuHostProxy::GetIsolationKey(
    int32_t in_client_id, const ::blink::WebGPUExecutionContextToken& in_wgpu_context_token, GetIsolationKeyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuHost::GetIsolationKey", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wgpu_context_token"), in_wgpu_context_token,
                        "<value of type const ::blink::WebGPUExecutionContextToken&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuHost::kGetIsolationKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_GetIsolationKey_Params_Data> params(
          message);
  params.Allocate();
  params->client_id = in_client_id;
  mojo::internal::MessageFragment<decltype(params->wgpu_context_token)>
      wgpu_context_token_fragment(params.message());
  wgpu_context_token_fragment.Claim(&params->wgpu_context_token);
  mojo::internal::Serialize<::blink::mojom::WebGPUExecutionContextTokenDataView>(
      in_wgpu_context_token, wgpu_context_token_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->wgpu_context_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null wgpu_context_token in GpuHost.GetIsolationKey request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("GetIsolationKey");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuHost_GetIsolationKey_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GpuHostProxy::StoreBlobToDisk(
    const ::gpu::GpuDiskCacheHandle& in_cache_handle, const std::string& in_key, const std::string& in_blob) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuHost::StoreBlobToDisk", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_handle"), in_cache_handle,
                        "<value of type const ::gpu::GpuDiskCacheHandle&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuHost::kStoreBlobToDisk), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_StoreBlobToDisk_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->cache_handle)>
      cache_handle_fragment(params.message());
  cache_handle_fragment.Claim(&params->cache_handle);
  mojo::internal::Serialize<::gpu::mojom::GpuDiskCacheHandleDataView>(
      in_cache_handle, cache_handle_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cache_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cache_handle in GpuHost.StoreBlobToDisk request");
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
      in_key, key_fragment);
  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in GpuHost.StoreBlobToDisk request");
  mojo::internal::MessageFragment<
      typename decltype(params->blob)::BaseType> blob_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
      in_blob, blob_fragment);
  params->blob.Set(
      blob_fragment.is_null() ? nullptr : blob_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->blob.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null blob in GpuHost.StoreBlobToDisk request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("StoreBlobToDisk");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuHostProxy::RecordLogMessage(
    int32_t in_severity, const std::string& in_header, const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuHost::RecordLogMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("severity"), in_severity,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("header"), in_header,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuHost::kRecordLogMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_RecordLogMessage_Params_Data> params(
          message);
  params.Allocate();
  params->severity = in_severity;
  mojo::internal::MessageFragment<
      typename decltype(params->header)::BaseType> header_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_header, header_fragment);
  params->header.Set(
      header_fragment.is_null() ? nullptr : header_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->header.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null header in GpuHost.RecordLogMessage request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in GpuHost.RecordLogMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("RecordLogMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuHostProxy::ClearGrShaderDiskCache(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuHost::ClearGrShaderDiskCache");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuHost::kClearGrShaderDiskCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_ClearGrShaderDiskCache_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("ClearGrShaderDiskCache");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class GpuHost_GetIsolationKey_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GpuHost::GetIsolationKeyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GpuHost_GetIsolationKey_ProxyToResponder> proxy(
        new GpuHost_GetIsolationKey_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GpuHost_GetIsolationKey_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuHost_GetIsolationKey_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GpuHost_GetIsolationKey_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuHost::GetIsolationKeyCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_isolation_key);
};

bool GpuHost_GetIsolationKey_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuHost_GetIsolationKey_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuHost_GetIsolationKey_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for GpuHost.10
  bool success = true;
  std::string p_isolation_key{};
  GpuHost_GetIsolationKey_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadIsolationKey(&p_isolation_key))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuHost::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_isolation_key));
  return true;
}

void GpuHost_GetIsolationKey_ProxyToResponder::Run(
    const std::string& in_isolation_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply viz::mojom::GpuHost::GetIsolationKey", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("isolation_key"), in_isolation_key,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuHost::kGetIsolationKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuHost_GetIsolationKey_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->isolation_key)::BaseType> isolation_key_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_isolation_key, isolation_key_fragment);
  params->isolation_key.Set(
      isolation_key_fragment.is_null() ? nullptr : isolation_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->isolation_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null isolation_key in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuHost::Name_);
  message.set_method_name("GetIsolationKey");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GpuHostStubDispatch::Accept(
    GpuHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GpuHost>(message->header()->name)) {
    case messages::GpuHost::kDidInitialize: {
      DCHECK(message->is_serialized());
      internal::GpuHost_DidInitialize_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DidInitialize_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for GpuHost.0
      bool success = true;
      ::gpu::GPUInfo p_gpu_info{};
      ::gpu::GpuFeatureInfo p_gpu_feature_info{};
      std::optional<::gpu::GPUInfo> p_gpu_info_for_hardware_gpu{};
      std::optional<::gpu::GpuFeatureInfo> p_gpu_feature_info_for_hardware_gpu{};
      ::gfx::GpuExtraInfo p_gpu_extra_info{};
      GpuHost_DidInitialize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGpuInfo(&p_gpu_info))
        success = false;
      if (success && !input_data_view.ReadGpuFeatureInfo(&p_gpu_feature_info))
        success = false;
      if (success && !input_data_view.ReadGpuInfoForHardwareGpu(&p_gpu_info_for_hardware_gpu))
        success = false;
      if (success && !input_data_view.ReadGpuFeatureInfoForHardwareGpu(&p_gpu_feature_info_for_hardware_gpu))
        success = false;
      if (success && !input_data_view.ReadGpuExtraInfo(&p_gpu_extra_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidInitialize(        
        std::move(p_gpu_info), 
        std::move(p_gpu_feature_info), 
        std::move(p_gpu_info_for_hardware_gpu), 
        std::move(p_gpu_feature_info_for_hardware_gpu), 
        std::move(p_gpu_extra_info));
      return true;
    }
    case messages::GpuHost::kDidFailInitialize: {
      DCHECK(message->is_serialized());
      internal::GpuHost_DidFailInitialize_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DidFailInitialize_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for GpuHost.1
      bool success = true;
      GpuHost_DidFailInitialize_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFailInitialize(        );
      return true;
    }
    case messages::GpuHost::kDidCreateContextSuccessfully: {
      DCHECK(message->is_serialized());
      internal::GpuHost_DidCreateContextSuccessfully_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DidCreateContextSuccessfully_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for GpuHost.2
      bool success = true;
      GpuHost_DidCreateContextSuccessfully_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCreateContextSuccessfully(        );
      return true;
    }
    case messages::GpuHost::kDidCreateOffscreenContext: {
      DCHECK(message->is_serialized());
      internal::GpuHost_DidCreateOffscreenContext_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DidCreateOffscreenContext_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for GpuHost.3
      bool success = true;
      ::GURL p_url{};
      GpuHost_DidCreateOffscreenContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCreateOffscreenContext(        
        std::move(p_url));
      return true;
    }
    case messages::GpuHost::kDidDestroyOffscreenContext: {
      DCHECK(message->is_serialized());
      internal::GpuHost_DidDestroyOffscreenContext_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DidDestroyOffscreenContext_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for GpuHost.4
      bool success = true;
      ::GURL p_url{};
      GpuHost_DidDestroyOffscreenContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidDestroyOffscreenContext(        
        std::move(p_url));
      return true;
    }
    case messages::GpuHost::kDidDestroyChannel: {
      DCHECK(message->is_serialized());
      internal::GpuHost_DidDestroyChannel_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DidDestroyChannel_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for GpuHost.5
      bool success = true;
      int32_t p_client_id{};
      GpuHost_DidDestroyChannel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_client_id = input_data_view.client_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidDestroyChannel(        
        std::move(p_client_id));
      return true;
    }
    case messages::GpuHost::kDidDestroyAllChannels: {
      DCHECK(message->is_serialized());
      internal::GpuHost_DidDestroyAllChannels_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DidDestroyAllChannels_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for GpuHost.6
      bool success = true;
      GpuHost_DidDestroyAllChannels_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidDestroyAllChannels(        );
      return true;
    }
    case messages::GpuHost::kDidLoseContext: {
      DCHECK(message->is_serialized());
      internal::GpuHost_DidLoseContext_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DidLoseContext_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for GpuHost.7
      bool success = true;
      ::gpu::error::ContextLostReason p_reason{};
      ::GURL p_active_url{};
      GpuHost_DidLoseContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (success && !input_data_view.ReadActiveUrl(&p_active_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidLoseContext(        
        std::move(p_reason), 
        std::move(p_active_url));
      return true;
    }
    case messages::GpuHost::kDidUpdateGPUInfo: {
      DCHECK(message->is_serialized());
      internal::GpuHost_DidUpdateGPUInfo_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DidUpdateGPUInfo_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for GpuHost.8
      bool success = true;
      ::gpu::GPUInfo p_gpu_info{};
      GpuHost_DidUpdateGPUInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGpuInfo(&p_gpu_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidUpdateGPUInfo(        
        std::move(p_gpu_info));
      return true;
    }
    case messages::GpuHost::kDisableGpuCompositing: {
      DCHECK(message->is_serialized());
      internal::GpuHost_DisableGpuCompositing_Params_Data* params =
          reinterpret_cast<internal::GpuHost_DisableGpuCompositing_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for GpuHost.9
      bool success = true;
      GpuHost_DisableGpuCompositing_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableGpuCompositing(        );
      return true;
    }
    case messages::GpuHost::kGetIsolationKey: {
      break;
    }
    case messages::GpuHost::kStoreBlobToDisk: {
      DCHECK(message->is_serialized());
      internal::GpuHost_StoreBlobToDisk_Params_Data* params =
          reinterpret_cast<internal::GpuHost_StoreBlobToDisk_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for GpuHost.11
      bool success = true;
      ::gpu::GpuDiskCacheHandle p_cache_handle{};
      std::string p_key{};
      std::string p_blob{};
      GpuHost_StoreBlobToDisk_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCacheHandle(&p_cache_handle))
        success = false;
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadBlob(&p_blob))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StoreBlobToDisk(        
        std::move(p_cache_handle), 
        std::move(p_key), 
        std::move(p_blob));
      return true;
    }
    case messages::GpuHost::kRecordLogMessage: {
      DCHECK(message->is_serialized());
      internal::GpuHost_RecordLogMessage_Params_Data* params =
          reinterpret_cast<internal::GpuHost_RecordLogMessage_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for GpuHost.12
      bool success = true;
      int32_t p_severity{};
      std::string p_header{};
      std::string p_message{};
      GpuHost_RecordLogMessage_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_severity = input_data_view.severity();
      if (success && !input_data_view.ReadHeader(&p_header))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordLogMessage(        
        std::move(p_severity), 
        std::move(p_header), 
        std::move(p_message));
      return true;
    }
    case messages::GpuHost::kClearGrShaderDiskCache: {
      DCHECK(message->is_serialized());
      internal::GpuHost_ClearGrShaderDiskCache_Params_Data* params =
          reinterpret_cast<internal::GpuHost_ClearGrShaderDiskCache_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for GpuHost.13
      bool success = true;
      GpuHost_ClearGrShaderDiskCache_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearGrShaderDiskCache(        );
      return true;
    }
  }
  return false;
}

// static
bool GpuHostStubDispatch::AcceptWithResponder(
    GpuHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GpuHost>(message->header()->name)) {
    case messages::GpuHost::kDidInitialize: {
      break;
    }
    case messages::GpuHost::kDidFailInitialize: {
      break;
    }
    case messages::GpuHost::kDidCreateContextSuccessfully: {
      break;
    }
    case messages::GpuHost::kDidCreateOffscreenContext: {
      break;
    }
    case messages::GpuHost::kDidDestroyOffscreenContext: {
      break;
    }
    case messages::GpuHost::kDidDestroyChannel: {
      break;
    }
    case messages::GpuHost::kDidDestroyAllChannels: {
      break;
    }
    case messages::GpuHost::kDidLoseContext: {
      break;
    }
    case messages::GpuHost::kDidUpdateGPUInfo: {
      break;
    }
    case messages::GpuHost::kDisableGpuCompositing: {
      break;
    }
    case messages::GpuHost::kGetIsolationKey: {
      internal::GpuHost_GetIsolationKey_Params_Data* params =
          reinterpret_cast<
              internal::GpuHost_GetIsolationKey_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for GpuHost.10
      bool success = true;
      int32_t p_client_id{};
      ::blink::WebGPUExecutionContextToken p_wgpu_context_token{};
      GpuHost_GetIsolationKey_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_client_id = input_data_view.client_id();
      if (success && !input_data_view.ReadWgpuContextToken(&p_wgpu_context_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuHost::Name_, 10, false);
        return false;
      }
      GpuHost::GetIsolationKeyCallback callback =
          GpuHost_GetIsolationKey_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetIsolationKey(        
        std::move(p_client_id), 
        std::move(p_wgpu_context_token), std::move(callback));
      return true;
    }
    case messages::GpuHost::kStoreBlobToDisk: {
      break;
    }
    case messages::GpuHost::kRecordLogMessage: {
      break;
    }
    case messages::GpuHost::kClearGrShaderDiskCache: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGpuHostValidationInfo[] = {
    {base::to_underlying(messages::GpuHost::kDidInitialize),
     { &internal::GpuHost_DidInitialize_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuHost::kDidFailInitialize),
     { &internal::GpuHost_DidFailInitialize_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuHost::kDidCreateContextSuccessfully),
     { &internal::GpuHost_DidCreateContextSuccessfully_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuHost::kDidCreateOffscreenContext),
     { &internal::GpuHost_DidCreateOffscreenContext_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuHost::kDidDestroyOffscreenContext),
     { &internal::GpuHost_DidDestroyOffscreenContext_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuHost::kDidDestroyChannel),
     { &internal::GpuHost_DidDestroyChannel_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuHost::kDidDestroyAllChannels),
     { &internal::GpuHost_DidDestroyAllChannels_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuHost::kDidLoseContext),
     { &internal::GpuHost_DidLoseContext_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuHost::kDidUpdateGPUInfo),
     { &internal::GpuHost_DidUpdateGPUInfo_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuHost::kDisableGpuCompositing),
     { &internal::GpuHost_DisableGpuCompositing_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuHost::kGetIsolationKey),
     { &internal::GpuHost_GetIsolationKey_Params_Data::Validate,
      &internal::GpuHost_GetIsolationKey_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::GpuHost::kStoreBlobToDisk),
     { &internal::GpuHost_StoreBlobToDisk_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuHost::kRecordLogMessage),
     { &internal::GpuHost_RecordLogMessage_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GpuHost::kClearGrShaderDiskCache),
     { &internal::GpuHost_ClearGrShaderDiskCache_Params_Data::Validate,
      nullptr /* no response */}},
};

bool GpuHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::GpuHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGpuHostValidationInfo);
}

bool GpuHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::GpuHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kGpuHostValidationInfo);

}


}  // viz::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {


void GpuHostInterceptorForTesting::DidInitialize(const ::gpu::GPUInfo& gpu_info, const ::gpu::GpuFeatureInfo& gpu_feature_info, const std::optional<::gpu::GPUInfo>& gpu_info_for_hardware_gpu, const std::optional<::gpu::GpuFeatureInfo>& gpu_feature_info_for_hardware_gpu, const ::gfx::GpuExtraInfo& gpu_extra_info) {
  GetForwardingInterface()->DidInitialize(
    std::move(gpu_info)
    , 
    std::move(gpu_feature_info)
    , 
    std::move(gpu_info_for_hardware_gpu)
    , 
    std::move(gpu_feature_info_for_hardware_gpu)
    , 
    std::move(gpu_extra_info)
    );
}
void GpuHostInterceptorForTesting::DidFailInitialize() {
  GetForwardingInterface()->DidFailInitialize();
}
void GpuHostInterceptorForTesting::DidCreateContextSuccessfully() {
  GetForwardingInterface()->DidCreateContextSuccessfully();
}
void GpuHostInterceptorForTesting::DidCreateOffscreenContext(const ::GURL& url) {
  GetForwardingInterface()->DidCreateOffscreenContext(
    std::move(url)
    );
}
void GpuHostInterceptorForTesting::DidDestroyOffscreenContext(const ::GURL& url) {
  GetForwardingInterface()->DidDestroyOffscreenContext(
    std::move(url)
    );
}
void GpuHostInterceptorForTesting::DidDestroyChannel(int32_t client_id) {
  GetForwardingInterface()->DidDestroyChannel(
    std::move(client_id)
    );
}
void GpuHostInterceptorForTesting::DidDestroyAllChannels() {
  GetForwardingInterface()->DidDestroyAllChannels();
}
void GpuHostInterceptorForTesting::DidLoseContext(::gpu::error::ContextLostReason reason, const ::GURL& active_url) {
  GetForwardingInterface()->DidLoseContext(
    std::move(reason)
    , 
    std::move(active_url)
    );
}
void GpuHostInterceptorForTesting::DidUpdateGPUInfo(const ::gpu::GPUInfo& gpu_info) {
  GetForwardingInterface()->DidUpdateGPUInfo(
    std::move(gpu_info)
    );
}
void GpuHostInterceptorForTesting::DisableGpuCompositing() {
  GetForwardingInterface()->DisableGpuCompositing();
}
void GpuHostInterceptorForTesting::GetIsolationKey(int32_t client_id, const ::blink::WebGPUExecutionContextToken& wgpu_context_token, GetIsolationKeyCallback callback) {
  GetForwardingInterface()->GetIsolationKey(
    std::move(client_id)
    , 
    std::move(wgpu_context_token)
    , std::move(callback));
}
void GpuHostInterceptorForTesting::StoreBlobToDisk(const ::gpu::GpuDiskCacheHandle& cache_handle, const std::string& key, const std::string& blob) {
  GetForwardingInterface()->StoreBlobToDisk(
    std::move(cache_handle)
    , 
    std::move(key)
    , 
    std::move(blob)
    );
}
void GpuHostInterceptorForTesting::RecordLogMessage(int32_t severity, const std::string& header, const std::string& message) {
  GetForwardingInterface()->RecordLogMessage(
    std::move(severity)
    , 
    std::move(header)
    , 
    std::move(message)
    );
}
void GpuHostInterceptorForTesting::ClearGrShaderDiskCache() {
  GetForwardingInterface()->ClearGrShaderDiskCache();
}
GpuHostAsyncWaiter::GpuHostAsyncWaiter(
    GpuHost* proxy) : proxy_(proxy) {}

GpuHostAsyncWaiter::~GpuHostAsyncWaiter() = default;

void GpuHostAsyncWaiter::GetIsolationKey(
    int32_t client_id, const ::blink::WebGPUExecutionContextToken& wgpu_context_token, std::string* out_isolation_key) {
  base::RunLoop loop;
  proxy_->GetIsolationKey(
      std::move(client_id),
      std::move(wgpu_context_token),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_isolation_key
,
             const std::string& isolation_key) {*out_isolation_key = std::move(isolation_key);
            loop->Quit();
          },
          &loop,
          out_isolation_key));
  loop.Run();
}

std::string GpuHostAsyncWaiter::GetIsolationKey(
    int32_t client_id, const ::blink::WebGPUExecutionContextToken& wgpu_context_token) {
  std::string async_wait_result;
  GetIsolationKey(std::move(client_id),std::move(wgpu_context_token),&async_wait_result);
  return async_wait_result;
}






}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif