// services/viz/privileged/mojom/compositing/renderer_settings.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_RENDERER_SETTINGS_MOJOM_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_RENDERER_SETTINGS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-features.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-forward.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/compositing/overlay_strategy.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-forward.h"
#include "ui/gfx/mojom/color_space.mojom-forward.h"
#include <string>
#include <vector>




#include "services/viz/privileged/cpp/renderer_settings_mojom_traits.h"




namespace viz::mojom {





class  OcclusionCullerSettings {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OcclusionCullerSettings, T>::value>;
  using DataView = OcclusionCullerSettingsDataView;
  using Data_ = internal::OcclusionCullerSettings_Data;

  template <typename... Args>
  static OcclusionCullerSettingsPtr New(Args&&... args) {
    return OcclusionCullerSettingsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OcclusionCullerSettingsPtr From(const U& u) {
    return mojo::TypeConverter<OcclusionCullerSettingsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OcclusionCullerSettings>::Convert(*this);
  }


  OcclusionCullerSettings();

  OcclusionCullerSettings(
      uint16_t quad_split_limit,
      uint16_t maximum_occluder_complexity,
      uint16_t minimum_fragments_reduced);


  ~OcclusionCullerSettings();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OcclusionCullerSettingsPtr>
  OcclusionCullerSettingsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OcclusionCullerSettings::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OcclusionCullerSettings::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OcclusionCullerSettings::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OcclusionCullerSettings::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OcclusionCullerSettings::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OcclusionCullerSettings_UnserializedMessageContext<
            UserType, OcclusionCullerSettings::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OcclusionCullerSettings::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OcclusionCullerSettings::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OcclusionCullerSettings_UnserializedMessageContext<
            UserType, OcclusionCullerSettings::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OcclusionCullerSettings::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint16_t quad_split_limit;
  
  uint16_t maximum_occluder_complexity;
  
  uint16_t minimum_fragments_reduced;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OcclusionCullerSettings::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OcclusionCullerSettings::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OcclusionCullerSettings::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OcclusionCullerSettings::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  RendererSettings {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RendererSettings, T>::value>;
  using DataView = RendererSettingsDataView;
  using Data_ = internal::RendererSettings_Data;

  template <typename... Args>
  static RendererSettingsPtr New(Args&&... args) {
    return RendererSettingsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RendererSettingsPtr From(const U& u) {
    return mojo::TypeConverter<RendererSettingsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RendererSettings>::Convert(*this);
  }


  RendererSettings();

  RendererSettings(
      bool allow_antialiasing,
      bool force_antialiasing,
      bool force_blending_with_shaders,
      int32_t highp_threshold_min,
      bool partial_swap_enabled,
      bool release_overlay_resources_after_gpu_query,
      bool should_clear_root_render_pass,
      int32_t slow_down_compositing_scale_factor,
      bool auto_resize_output_surface,
      bool requires_alpha_channel,
      OcclusionCullerSettingsPtr occlusion_culler_settings,
      std::vector<::viz::mojom::OverlayStrategy> overlay_strategies);

RendererSettings(const RendererSettings&) = delete;
RendererSettings& operator=(const RendererSettings&) = delete;

  ~RendererSettings();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RendererSettingsPtr>
  RendererSettingsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RendererSettings::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RendererSettings::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RendererSettings::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RendererSettings::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RendererSettings::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RendererSettings_UnserializedMessageContext<
            UserType, RendererSettings::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RendererSettings::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RendererSettings::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RendererSettings_UnserializedMessageContext<
            UserType, RendererSettings::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RendererSettings::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool allow_antialiasing;
  
  bool force_antialiasing;
  
  bool force_blending_with_shaders;
  
  int32_t highp_threshold_min;
  
  bool partial_swap_enabled;
  
  bool release_overlay_resources_after_gpu_query;
  
  bool should_clear_root_render_pass;
  
  int32_t slow_down_compositing_scale_factor;
  
  bool auto_resize_output_surface;
  
  bool requires_alpha_channel;
  
  OcclusionCullerSettingsPtr occlusion_culler_settings;
  
  std::vector<::viz::mojom::OverlayStrategy> overlay_strategies;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RendererSettings::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RendererSettings::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RendererSettings::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RendererSettings::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DebugRendererSettings {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DebugRendererSettings, T>::value>;
  using DataView = DebugRendererSettingsDataView;
  using Data_ = internal::DebugRendererSettings_Data;

  template <typename... Args>
  static DebugRendererSettingsPtr New(Args&&... args) {
    return DebugRendererSettingsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DebugRendererSettingsPtr From(const U& u) {
    return mojo::TypeConverter<DebugRendererSettingsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DebugRendererSettings>::Convert(*this);
  }


  DebugRendererSettings();

  DebugRendererSettings(
      bool tint_composited_content,
      bool tint_composited_content_modulate,
      bool show_overdraw_feedback,
      bool show_dc_layer_debug_borders,
      bool show_aggregated_damage);


  ~DebugRendererSettings();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DebugRendererSettingsPtr>
  DebugRendererSettingsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DebugRendererSettings::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DebugRendererSettings::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DebugRendererSettings::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DebugRendererSettings::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DebugRendererSettings::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DebugRendererSettings_UnserializedMessageContext<
            UserType, DebugRendererSettings::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DebugRendererSettings::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DebugRendererSettings::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DebugRendererSettings_UnserializedMessageContext<
            UserType, DebugRendererSettings::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DebugRendererSettings::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool tint_composited_content;
  
  bool tint_composited_content_modulate;
  
  bool show_overdraw_feedback;
  
  bool show_dc_layer_debug_borders;
  
  bool show_aggregated_damage;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DebugRendererSettings::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DebugRendererSettings::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DebugRendererSettings::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DebugRendererSettings::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
OcclusionCullerSettingsPtr OcclusionCullerSettings::Clone() const {
  return New(
      mojo::Clone(quad_split_limit),
      mojo::Clone(maximum_occluder_complexity),
      mojo::Clone(minimum_fragments_reduced)
  );
}

template <typename T, OcclusionCullerSettings::EnableIfSame<T>*>
bool OcclusionCullerSettings::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->quad_split_limit, other_struct.quad_split_limit))
    return false;
  if (!mojo::Equals(this->maximum_occluder_complexity, other_struct.maximum_occluder_complexity))
    return false;
  if (!mojo::Equals(this->minimum_fragments_reduced, other_struct.minimum_fragments_reduced))
    return false;
  return true;
}

template <typename T, OcclusionCullerSettings::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.quad_split_limit < rhs.quad_split_limit)
    return true;
  if (rhs.quad_split_limit < lhs.quad_split_limit)
    return false;
  if (lhs.maximum_occluder_complexity < rhs.maximum_occluder_complexity)
    return true;
  if (rhs.maximum_occluder_complexity < lhs.maximum_occluder_complexity)
    return false;
  if (lhs.minimum_fragments_reduced < rhs.minimum_fragments_reduced)
    return true;
  if (rhs.minimum_fragments_reduced < lhs.minimum_fragments_reduced)
    return false;
  return false;
}
template <typename StructPtrType>
RendererSettingsPtr RendererSettings::Clone() const {
  return New(
      mojo::Clone(allow_antialiasing),
      mojo::Clone(force_antialiasing),
      mojo::Clone(force_blending_with_shaders),
      mojo::Clone(highp_threshold_min),
      mojo::Clone(partial_swap_enabled),
      mojo::Clone(release_overlay_resources_after_gpu_query),
      mojo::Clone(should_clear_root_render_pass),
      mojo::Clone(slow_down_compositing_scale_factor),
      mojo::Clone(auto_resize_output_surface),
      mojo::Clone(requires_alpha_channel),
      mojo::Clone(occlusion_culler_settings),
      mojo::Clone(overlay_strategies)
  );
}

template <typename T, RendererSettings::EnableIfSame<T>*>
bool RendererSettings::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allow_antialiasing, other_struct.allow_antialiasing))
    return false;
  if (!mojo::Equals(this->force_antialiasing, other_struct.force_antialiasing))
    return false;
  if (!mojo::Equals(this->force_blending_with_shaders, other_struct.force_blending_with_shaders))
    return false;
  if (!mojo::Equals(this->highp_threshold_min, other_struct.highp_threshold_min))
    return false;
  if (!mojo::Equals(this->partial_swap_enabled, other_struct.partial_swap_enabled))
    return false;
  if (!mojo::Equals(this->release_overlay_resources_after_gpu_query, other_struct.release_overlay_resources_after_gpu_query))
    return false;
  if (!mojo::Equals(this->should_clear_root_render_pass, other_struct.should_clear_root_render_pass))
    return false;
  if (!mojo::Equals(this->slow_down_compositing_scale_factor, other_struct.slow_down_compositing_scale_factor))
    return false;
  if (!mojo::Equals(this->auto_resize_output_surface, other_struct.auto_resize_output_surface))
    return false;
  if (!mojo::Equals(this->requires_alpha_channel, other_struct.requires_alpha_channel))
    return false;
  if (!mojo::Equals(this->occlusion_culler_settings, other_struct.occlusion_culler_settings))
    return false;
  if (!mojo::Equals(this->overlay_strategies, other_struct.overlay_strategies))
    return false;
  return true;
}

template <typename T, RendererSettings::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.allow_antialiasing < rhs.allow_antialiasing)
    return true;
  if (rhs.allow_antialiasing < lhs.allow_antialiasing)
    return false;
  if (lhs.force_antialiasing < rhs.force_antialiasing)
    return true;
  if (rhs.force_antialiasing < lhs.force_antialiasing)
    return false;
  if (lhs.force_blending_with_shaders < rhs.force_blending_with_shaders)
    return true;
  if (rhs.force_blending_with_shaders < lhs.force_blending_with_shaders)
    return false;
  if (lhs.highp_threshold_min < rhs.highp_threshold_min)
    return true;
  if (rhs.highp_threshold_min < lhs.highp_threshold_min)
    return false;
  if (lhs.partial_swap_enabled < rhs.partial_swap_enabled)
    return true;
  if (rhs.partial_swap_enabled < lhs.partial_swap_enabled)
    return false;
  if (lhs.release_overlay_resources_after_gpu_query < rhs.release_overlay_resources_after_gpu_query)
    return true;
  if (rhs.release_overlay_resources_after_gpu_query < lhs.release_overlay_resources_after_gpu_query)
    return false;
  if (lhs.should_clear_root_render_pass < rhs.should_clear_root_render_pass)
    return true;
  if (rhs.should_clear_root_render_pass < lhs.should_clear_root_render_pass)
    return false;
  if (lhs.slow_down_compositing_scale_factor < rhs.slow_down_compositing_scale_factor)
    return true;
  if (rhs.slow_down_compositing_scale_factor < lhs.slow_down_compositing_scale_factor)
    return false;
  if (lhs.auto_resize_output_surface < rhs.auto_resize_output_surface)
    return true;
  if (rhs.auto_resize_output_surface < lhs.auto_resize_output_surface)
    return false;
  if (lhs.requires_alpha_channel < rhs.requires_alpha_channel)
    return true;
  if (rhs.requires_alpha_channel < lhs.requires_alpha_channel)
    return false;
  if (lhs.occlusion_culler_settings < rhs.occlusion_culler_settings)
    return true;
  if (rhs.occlusion_culler_settings < lhs.occlusion_culler_settings)
    return false;
  if (lhs.overlay_strategies < rhs.overlay_strategies)
    return true;
  if (rhs.overlay_strategies < lhs.overlay_strategies)
    return false;
  return false;
}
template <typename StructPtrType>
DebugRendererSettingsPtr DebugRendererSettings::Clone() const {
  return New(
      mojo::Clone(tint_composited_content),
      mojo::Clone(tint_composited_content_modulate),
      mojo::Clone(show_overdraw_feedback),
      mojo::Clone(show_dc_layer_debug_borders),
      mojo::Clone(show_aggregated_damage)
  );
}

template <typename T, DebugRendererSettings::EnableIfSame<T>*>
bool DebugRendererSettings::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tint_composited_content, other_struct.tint_composited_content))
    return false;
  if (!mojo::Equals(this->tint_composited_content_modulate, other_struct.tint_composited_content_modulate))
    return false;
  if (!mojo::Equals(this->show_overdraw_feedback, other_struct.show_overdraw_feedback))
    return false;
  if (!mojo::Equals(this->show_dc_layer_debug_borders, other_struct.show_dc_layer_debug_borders))
    return false;
  if (!mojo::Equals(this->show_aggregated_damage, other_struct.show_aggregated_damage))
    return false;
  return true;
}

template <typename T, DebugRendererSettings::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tint_composited_content < rhs.tint_composited_content)
    return true;
  if (rhs.tint_composited_content < lhs.tint_composited_content)
    return false;
  if (lhs.tint_composited_content_modulate < rhs.tint_composited_content_modulate)
    return true;
  if (rhs.tint_composited_content_modulate < lhs.tint_composited_content_modulate)
    return false;
  if (lhs.show_overdraw_feedback < rhs.show_overdraw_feedback)
    return true;
  if (rhs.show_overdraw_feedback < lhs.show_overdraw_feedback)
    return false;
  if (lhs.show_dc_layer_debug_borders < rhs.show_dc_layer_debug_borders)
    return true;
  if (rhs.show_dc_layer_debug_borders < lhs.show_dc_layer_debug_borders)
    return false;
  if (lhs.show_aggregated_damage < rhs.show_aggregated_damage)
    return true;
  if (rhs.show_aggregated_damage < lhs.show_aggregated_damage)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::OcclusionCullerSettings::DataView,
                                         ::viz::mojom::OcclusionCullerSettingsPtr> {
  static bool IsNull(const ::viz::mojom::OcclusionCullerSettingsPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::OcclusionCullerSettingsPtr* output) { output->reset(); }

  static decltype(::viz::mojom::OcclusionCullerSettings::quad_split_limit) quad_split_limit(
      const ::viz::mojom::OcclusionCullerSettingsPtr& input) {
    return input->quad_split_limit;
  }

  static decltype(::viz::mojom::OcclusionCullerSettings::maximum_occluder_complexity) maximum_occluder_complexity(
      const ::viz::mojom::OcclusionCullerSettingsPtr& input) {
    return input->maximum_occluder_complexity;
  }

  static decltype(::viz::mojom::OcclusionCullerSettings::minimum_fragments_reduced) minimum_fragments_reduced(
      const ::viz::mojom::OcclusionCullerSettingsPtr& input) {
    return input->minimum_fragments_reduced;
  }

  static bool Read(::viz::mojom::OcclusionCullerSettings::DataView input, ::viz::mojom::OcclusionCullerSettingsPtr* output);
};


template <>
struct  StructTraits<::viz::mojom::RendererSettings::DataView,
                                         ::viz::mojom::RendererSettingsPtr> {
  static bool IsNull(const ::viz::mojom::RendererSettingsPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::RendererSettingsPtr* output) { output->reset(); }

  static decltype(::viz::mojom::RendererSettings::allow_antialiasing) allow_antialiasing(
      const ::viz::mojom::RendererSettingsPtr& input) {
    return input->allow_antialiasing;
  }

  static decltype(::viz::mojom::RendererSettings::force_antialiasing) force_antialiasing(
      const ::viz::mojom::RendererSettingsPtr& input) {
    return input->force_antialiasing;
  }

  static decltype(::viz::mojom::RendererSettings::force_blending_with_shaders) force_blending_with_shaders(
      const ::viz::mojom::RendererSettingsPtr& input) {
    return input->force_blending_with_shaders;
  }

  static decltype(::viz::mojom::RendererSettings::highp_threshold_min) highp_threshold_min(
      const ::viz::mojom::RendererSettingsPtr& input) {
    return input->highp_threshold_min;
  }

  static decltype(::viz::mojom::RendererSettings::partial_swap_enabled) partial_swap_enabled(
      const ::viz::mojom::RendererSettingsPtr& input) {
    return input->partial_swap_enabled;
  }

  static decltype(::viz::mojom::RendererSettings::release_overlay_resources_after_gpu_query) release_overlay_resources_after_gpu_query(
      const ::viz::mojom::RendererSettingsPtr& input) {
    return input->release_overlay_resources_after_gpu_query;
  }

  static decltype(::viz::mojom::RendererSettings::should_clear_root_render_pass) should_clear_root_render_pass(
      const ::viz::mojom::RendererSettingsPtr& input) {
    return input->should_clear_root_render_pass;
  }

  static decltype(::viz::mojom::RendererSettings::slow_down_compositing_scale_factor) slow_down_compositing_scale_factor(
      const ::viz::mojom::RendererSettingsPtr& input) {
    return input->slow_down_compositing_scale_factor;
  }

  static decltype(::viz::mojom::RendererSettings::auto_resize_output_surface) auto_resize_output_surface(
      const ::viz::mojom::RendererSettingsPtr& input) {
    return input->auto_resize_output_surface;
  }

  static decltype(::viz::mojom::RendererSettings::requires_alpha_channel) requires_alpha_channel(
      const ::viz::mojom::RendererSettingsPtr& input) {
    return input->requires_alpha_channel;
  }

  static const decltype(::viz::mojom::RendererSettings::occlusion_culler_settings)& occlusion_culler_settings(
      const ::viz::mojom::RendererSettingsPtr& input) {
    return input->occlusion_culler_settings;
  }

  static const decltype(::viz::mojom::RendererSettings::overlay_strategies)& overlay_strategies(
      const ::viz::mojom::RendererSettingsPtr& input) {
    return input->overlay_strategies;
  }

  static bool Read(::viz::mojom::RendererSettings::DataView input, ::viz::mojom::RendererSettingsPtr* output);
};


template <>
struct  StructTraits<::viz::mojom::DebugRendererSettings::DataView,
                                         ::viz::mojom::DebugRendererSettingsPtr> {
  static bool IsNull(const ::viz::mojom::DebugRendererSettingsPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::DebugRendererSettingsPtr* output) { output->reset(); }

  static decltype(::viz::mojom::DebugRendererSettings::tint_composited_content) tint_composited_content(
      const ::viz::mojom::DebugRendererSettingsPtr& input) {
    return input->tint_composited_content;
  }

  static decltype(::viz::mojom::DebugRendererSettings::tint_composited_content_modulate) tint_composited_content_modulate(
      const ::viz::mojom::DebugRendererSettingsPtr& input) {
    return input->tint_composited_content_modulate;
  }

  static decltype(::viz::mojom::DebugRendererSettings::show_overdraw_feedback) show_overdraw_feedback(
      const ::viz::mojom::DebugRendererSettingsPtr& input) {
    return input->show_overdraw_feedback;
  }

  static decltype(::viz::mojom::DebugRendererSettings::show_dc_layer_debug_borders) show_dc_layer_debug_borders(
      const ::viz::mojom::DebugRendererSettingsPtr& input) {
    return input->show_dc_layer_debug_borders;
  }

  static decltype(::viz::mojom::DebugRendererSettings::show_aggregated_damage) show_aggregated_damage(
      const ::viz::mojom::DebugRendererSettingsPtr& input) {
    return input->show_aggregated_damage;
  }

  static bool Read(::viz::mojom::DebugRendererSettings::DataView input, ::viz::mojom::DebugRendererSettingsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_RENDERER_SETTINGS_MOJOM_H_