// services/network/public/mojom/websocket.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/websocket.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace network::mojom {
class HttpHeaderDataView;

class WebSocketHandshakeRequestDataView;

class WebSocketHandshakeResponseDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::HttpHeaderDataView> {
  using Data = ::network::mojom::internal::HttpHeader_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::WebSocketHandshakeRequestDataView> {
  using Data = ::network::mojom::internal::WebSocketHandshakeRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::WebSocketHandshakeResponseDataView> {
  using Data = ::network::mojom::internal::WebSocketHandshakeResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class WebSocketMessageType : int32_t {
  
  CONTINUATION = 0,
  
  TEXT = 1,
  
  BINARY = 2,
  
  LAST = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, WebSocketMessageType value);
inline bool IsKnownEnumValue(WebSocketMessageType value) {
  return internal::WebSocketMessageType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WebSocketAuthenticationHandlerInterfaceBase {};

using WebSocketAuthenticationHandlerPtrDataView =
    mojo::InterfacePtrDataView<WebSocketAuthenticationHandlerInterfaceBase>;
using WebSocketAuthenticationHandlerRequestDataView =
    mojo::InterfaceRequestDataView<WebSocketAuthenticationHandlerInterfaceBase>;
using WebSocketAuthenticationHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebSocketAuthenticationHandlerInterfaceBase>;
using WebSocketAuthenticationHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebSocketAuthenticationHandlerInterfaceBase>;
class WebSocketHandshakeClientInterfaceBase {};

using WebSocketHandshakeClientPtrDataView =
    mojo::InterfacePtrDataView<WebSocketHandshakeClientInterfaceBase>;
using WebSocketHandshakeClientRequestDataView =
    mojo::InterfaceRequestDataView<WebSocketHandshakeClientInterfaceBase>;
using WebSocketHandshakeClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebSocketHandshakeClientInterfaceBase>;
using WebSocketHandshakeClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebSocketHandshakeClientInterfaceBase>;
class WebSocketClientInterfaceBase {};

using WebSocketClientPtrDataView =
    mojo::InterfacePtrDataView<WebSocketClientInterfaceBase>;
using WebSocketClientRequestDataView =
    mojo::InterfaceRequestDataView<WebSocketClientInterfaceBase>;
using WebSocketClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebSocketClientInterfaceBase>;
using WebSocketClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebSocketClientInterfaceBase>;
class WebSocketInterfaceBase {};

using WebSocketPtrDataView =
    mojo::InterfacePtrDataView<WebSocketInterfaceBase>;
using WebSocketRequestDataView =
    mojo::InterfaceRequestDataView<WebSocketInterfaceBase>;
using WebSocketAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebSocketInterfaceBase>;
using WebSocketAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebSocketInterfaceBase>;


class HttpHeaderDataView {
 public:
  HttpHeaderDataView() = default;

  HttpHeaderDataView(
      internal::HttpHeader_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::HttpHeader_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebSocketHandshakeRequestDataView {
 public:
  WebSocketHandshakeRequestDataView() = default;

  WebSocketHandshakeRequestDataView(
      internal::WebSocketHandshakeRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetHeadersDataView(
      mojo::ArrayDataView<HttpHeaderDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::HttpHeaderDataView>>(
        pointer, output, message_);
  }
  inline void GetHeadersTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeadersText(UserType* output) {
    
    auto* pointer = data_->headers_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebSocketHandshakeRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebSocketHandshakeResponseDataView {
 public:
  WebSocketHandshakeResponseDataView() = default;

  WebSocketHandshakeResponseDataView(
      internal::WebSocketHandshakeResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetHttpVersionDataView(
      ::network::mojom::HttpVersionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHttpVersion(UserType* output) {
    
    auto* pointer = data_->http_version.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpVersionDataView>(
        pointer, output, message_);
  }
  int32_t status_code() const {
    return data_->status_code;
  }
  inline void GetStatusTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatusText(UserType* output) {
    
    auto* pointer = data_->status_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRemoteEndpointDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemoteEndpoint(UserType* output) {
    
    auto* pointer = data_->remote_endpoint.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, message_);
  }
  inline void GetHeadersDataView(
      mojo::ArrayDataView<HttpHeaderDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::HttpHeaderDataView>>(
        pointer, output, message_);
  }
  inline void GetHeadersTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeadersText(UserType* output) {
    
    auto* pointer = data_->headers_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSelectedProtocolDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectedProtocol(UserType* output) {
    
    auto* pointer = data_->selected_protocol.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetExtensionsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensions(UserType* output) {
    
    auto* pointer = data_->extensions.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebSocketHandshakeResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

template <>
struct hash<::network::mojom::WebSocketMessageType>
    : public mojo::internal::EnumHashImpl<::network::mojom::WebSocketMessageType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::WebSocketMessageType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::WebSocketMessageType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::WebSocketMessageType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::HttpHeaderDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::HttpHeaderDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::HttpHeader_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in HttpHeader struct");
    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_value, value_fragment);
    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in HttpHeader struct");
  }

  static bool Deserialize(::network::mojom::internal::HttpHeader_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::HttpHeaderDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::WebSocketHandshakeRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::WebSocketHandshakeRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::WebSocketHandshakeRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in WebSocketHandshakeRequest struct");
    decltype(Traits::headers(input)) in_headers = Traits::headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->headers)::BaseType>
        headers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HttpHeaderDataView>>(
        in_headers, headers_fragment, &headers_validate_params);
    fragment->headers.Set(
        headers_fragment.is_null() ? nullptr : headers_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in WebSocketHandshakeRequest struct");
    decltype(Traits::headers_text(input)) in_headers_text = Traits::headers_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->headers_text)::BaseType> headers_text_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_headers_text, headers_text_fragment);
    fragment->headers_text.Set(
        headers_text_fragment.is_null() ? nullptr : headers_text_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->headers_text.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers_text in WebSocketHandshakeRequest struct");
  }

  static bool Deserialize(::network::mojom::internal::WebSocketHandshakeRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::WebSocketHandshakeRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::WebSocketHandshakeResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::WebSocketHandshakeResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::WebSocketHandshakeResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in WebSocketHandshakeResponse struct");
    decltype(Traits::http_version(input)) in_http_version = Traits::http_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->http_version)::BaseType> http_version_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::HttpVersionDataView>(
        in_http_version, http_version_fragment);
    fragment->http_version.Set(
        http_version_fragment.is_null() ? nullptr : http_version_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->http_version.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null http_version in WebSocketHandshakeResponse struct");
    fragment->status_code = Traits::status_code(input);
    decltype(Traits::status_text(input)) in_status_text = Traits::status_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->status_text)::BaseType> status_text_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_status_text, status_text_fragment);
    fragment->status_text.Set(
        status_text_fragment.is_null() ? nullptr : status_text_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->status_text.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null status_text in WebSocketHandshakeResponse struct");
    decltype(Traits::remote_endpoint(input)) in_remote_endpoint = Traits::remote_endpoint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->remote_endpoint)::BaseType> remote_endpoint_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
        in_remote_endpoint, remote_endpoint_fragment);
    fragment->remote_endpoint.Set(
        remote_endpoint_fragment.is_null() ? nullptr : remote_endpoint_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->remote_endpoint.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null remote_endpoint in WebSocketHandshakeResponse struct");
    decltype(Traits::headers(input)) in_headers = Traits::headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->headers)::BaseType>
        headers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HttpHeaderDataView>>(
        in_headers, headers_fragment, &headers_validate_params);
    fragment->headers.Set(
        headers_fragment.is_null() ? nullptr : headers_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in WebSocketHandshakeResponse struct");
    decltype(Traits::headers_text(input)) in_headers_text = Traits::headers_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->headers_text)::BaseType> headers_text_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_headers_text, headers_text_fragment);
    fragment->headers_text.Set(
        headers_text_fragment.is_null() ? nullptr : headers_text_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->headers_text.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers_text in WebSocketHandshakeResponse struct");
    decltype(Traits::selected_protocol(input)) in_selected_protocol = Traits::selected_protocol(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selected_protocol)::BaseType> selected_protocol_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_selected_protocol, selected_protocol_fragment);
    fragment->selected_protocol.Set(
        selected_protocol_fragment.is_null() ? nullptr : selected_protocol_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->selected_protocol.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null selected_protocol in WebSocketHandshakeResponse struct");
    decltype(Traits::extensions(input)) in_extensions = Traits::extensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extensions)::BaseType> extensions_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_extensions, extensions_fragment);
    fragment->extensions.Set(
        extensions_fragment.is_null() ? nullptr : extensions_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->extensions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extensions in WebSocketHandshakeResponse struct");
  }

  static bool Deserialize(::network::mojom::internal::WebSocketHandshakeResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::WebSocketHandshakeResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void HttpHeaderDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HttpHeaderDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WebSocketHandshakeRequestDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void WebSocketHandshakeRequestDataView::GetHeadersDataView(
    mojo::ArrayDataView<HttpHeaderDataView>* output) {
  auto pointer = data_->headers.Get();
  *output = mojo::ArrayDataView<HttpHeaderDataView>(pointer, message_);
}
inline void WebSocketHandshakeRequestDataView::GetHeadersTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->headers_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WebSocketHandshakeResponseDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void WebSocketHandshakeResponseDataView::GetHttpVersionDataView(
    ::network::mojom::HttpVersionDataView* output) {
  auto pointer = data_->http_version.Get();
  *output = ::network::mojom::HttpVersionDataView(pointer, message_);
}
inline void WebSocketHandshakeResponseDataView::GetStatusTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->status_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebSocketHandshakeResponseDataView::GetRemoteEndpointDataView(
    ::network::mojom::IPEndPointDataView* output) {
  auto pointer = data_->remote_endpoint.Get();
  *output = ::network::mojom::IPEndPointDataView(pointer, message_);
}
inline void WebSocketHandshakeResponseDataView::GetHeadersDataView(
    mojo::ArrayDataView<HttpHeaderDataView>* output) {
  auto pointer = data_->headers.Get();
  *output = mojo::ArrayDataView<HttpHeaderDataView>(pointer, message_);
}
inline void WebSocketHandshakeResponseDataView::GetHeadersTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->headers_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebSocketHandshakeResponseDataView::GetSelectedProtocolDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->selected_protocol.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebSocketHandshakeResponseDataView::GetExtensionsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->extensions.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::WebSocketMessageType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::WebSocketMessageType value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_SHARED_H_