// services/network/public/mojom/url_loader.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/url_loader.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "services/network/public/mojom/early_hints.mojom-shared.h"
#include "services/network/public/mojom/http_request_headers.mojom-shared.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "services/network/public/mojom/url_loader_completion_status.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"




namespace network::mojom {
using URLRequestRedirectInfoDataView = mojo::native::NativeStructDataView;

class URLLoaderClientEndpointsDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::URLLoaderClientEndpointsDataView> {
  using Data = ::network::mojom::internal::URLLoaderClientEndpoints_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {
// Interface base classes. They are used for type safety check.
class URLLoaderInterfaceBase {};

using URLLoaderPtrDataView =
    mojo::InterfacePtrDataView<URLLoaderInterfaceBase>;
using URLLoaderRequestDataView =
    mojo::InterfaceRequestDataView<URLLoaderInterfaceBase>;
using URLLoaderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<URLLoaderInterfaceBase>;
using URLLoaderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<URLLoaderInterfaceBase>;
class URLLoaderClientInterfaceBase {};

using URLLoaderClientPtrDataView =
    mojo::InterfacePtrDataView<URLLoaderClientInterfaceBase>;
using URLLoaderClientRequestDataView =
    mojo::InterfaceRequestDataView<URLLoaderClientInterfaceBase>;
using URLLoaderClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<URLLoaderClientInterfaceBase>;
using URLLoaderClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<URLLoaderClientInterfaceBase>;


class URLLoaderClientEndpointsDataView {
 public:
  URLLoaderClientEndpointsDataView() = default;

  URLLoaderClientEndpointsDataView(
      internal::URLLoaderClientEndpoints_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeUrlLoader() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderInterfaceBase>>(
            &data_->url_loader, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeUrlLoaderClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderClientInterfaceBase>>(
            &data_->url_loader_client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::URLLoaderClientEndpoints_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::URLLoaderClientEndpointsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::URLLoaderClientEndpointsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::URLLoaderClientEndpoints_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::url_loader(input)) in_url_loader = Traits::url_loader(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderInterfaceBase>>(
        in_url_loader, &fragment->url_loader, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->url_loader),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid url_loader in URLLoaderClientEndpoints struct");
    decltype(Traits::url_loader_client(input)) in_url_loader_client = Traits::url_loader_client(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderClientInterfaceBase>>(
        in_url_loader_client, &fragment->url_loader_client, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->url_loader_client),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid url_loader_client in URLLoaderClientEndpoints struct");
  }

  static bool Deserialize(::network::mojom::internal::URLLoaderClientEndpoints_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::URLLoaderClientEndpointsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {




}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_SHARED_H_