// services/network/public/mojom/url_loader.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/url_loader.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/url_loader.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {


// static
bool URLLoaderClientEndpoints_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URLLoaderClientEndpoints_Data* object =
      static_cast<const URLLoaderClientEndpoints_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->url_loader, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->url_loader,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->url_loader_client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->url_loader_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

URLLoaderClientEndpoints_Data::URLLoaderClientEndpoints_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoader_FollowRedirect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URLLoader_FollowRedirect_Params_Data* object =
      static_cast<const URLLoader_FollowRedirect_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->removed_headers, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& removed_headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->removed_headers, validation_context,
                                         &removed_headers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->modified_headers, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->modified_headers, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->modified_cors_exempt_headers, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->modified_cors_exempt_headers, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->new_url, validation_context))
    return false;

  return true;
}

URLLoader_FollowRedirect_Params_Data::URLLoader_FollowRedirect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoader_SetPriority_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URLLoader_SetPriority_Params_Data* object =
      static_cast<const URLLoader_SetPriority_Params_Data*>(data);


  if (!::network::mojom::internal::RequestPriority_Data
        ::Validate(object->priority, validation_context))
    return false;

  return true;
}

URLLoader_SetPriority_Params_Data::URLLoader_SetPriority_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderClient_OnReceiveEarlyHints_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URLLoaderClient_OnReceiveEarlyHints_Params_Data* object =
      static_cast<const URLLoaderClient_OnReceiveEarlyHints_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->early_hints, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->early_hints, validation_context))
    return false;

  return true;
}

URLLoaderClient_OnReceiveEarlyHints_Params_Data::URLLoaderClient_OnReceiveEarlyHints_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderClient_OnReceiveResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URLLoaderClient_OnReceiveResponse_Params_Data* object =
      static_cast<const URLLoaderClient_OnReceiveResponse_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->head, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->head, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->body,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->cached_metadata, validation_context))
    return false;

  return true;
}

URLLoaderClient_OnReceiveResponse_Params_Data::URLLoaderClient_OnReceiveResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderClient_OnReceiveRedirect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URLLoaderClient_OnReceiveRedirect_Params_Data* object =
      static_cast<const URLLoaderClient_OnReceiveRedirect_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->redirect_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->redirect_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->head, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->head, validation_context))
    return false;

  return true;
}

URLLoaderClient_OnReceiveRedirect_Params_Data::URLLoaderClient_OnReceiveRedirect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderClient_OnUploadProgress_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URLLoaderClient_OnUploadProgress_Params_Data* object =
      static_cast<const URLLoaderClient_OnUploadProgress_Params_Data*>(data);

  return true;
}

URLLoaderClient_OnUploadProgress_Params_Data::URLLoaderClient_OnUploadProgress_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderClient_OnUploadProgress_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URLLoaderClient_OnUploadProgress_ResponseParams_Data* object =
      static_cast<const URLLoaderClient_OnUploadProgress_ResponseParams_Data*>(data);

  return true;
}

URLLoaderClient_OnUploadProgress_ResponseParams_Data::URLLoaderClient_OnUploadProgress_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderClient_OnTransferSizeUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URLLoaderClient_OnTransferSizeUpdated_Params_Data* object =
      static_cast<const URLLoaderClient_OnTransferSizeUpdated_Params_Data*>(data);

  return true;
}

URLLoaderClient_OnTransferSizeUpdated_Params_Data::URLLoaderClient_OnTransferSizeUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderClient_OnComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URLLoaderClient_OnComplete_Params_Data* object =
      static_cast<const URLLoaderClient_OnComplete_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

URLLoaderClient_OnComplete_Params_Data::URLLoaderClient_OnComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network