// services/network/public/mojom/integrity_algorithm.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/integrity_algorithm.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/integrity_algorithm.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* IntegrityAlgorithmToStringHelper(IntegrityAlgorithm value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IntegrityAlgorithm::kSha256:
      return "kSha256";
    case IntegrityAlgorithm::kSha384:
      return "kSha384";
    case IntegrityAlgorithm::kSha512:
      return "kSha512";
    case IntegrityAlgorithm::kEd25519:
      return "kEd25519";
    default:
      return nullptr;
  }
}

std::string IntegrityAlgorithmToString(IntegrityAlgorithm value) {
  const char *str = IntegrityAlgorithmToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IntegrityAlgorithm value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IntegrityAlgorithm value) {
  return os << IntegrityAlgorithmToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::IntegrityAlgorithm>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::IntegrityAlgorithm value) {
  return std::move(context).WriteString(::network::mojom::IntegrityAlgorithmToString(value));
}

} // namespace perfetto