// services/network/public/mojom/cookie_access_observer.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/cookie_access_observer.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cookie_access_observer.mojom-params-data.h"
#include "services/network/public/mojom/cookie_access_observer.mojom-shared-message-ids.h"

#include "services/network/public/mojom/cookie_access_observer.mojom-blink-import-headers.h"
#include "services/network/public/mojom/cookie_access_observer.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
CookieAccessDetails::CookieAccessDetails()
    : type(),
      url(),
      top_frame_origin(),
      site_for_cookies(),
      cookie_list(),
      devtools_request_id(),
      is_ad_tagged(),
      cookie_setting_overrides() {}

CookieAccessDetails::CookieAccessDetails(
    CookieAccessDetails::Type type_in,
    const ::blink::KURL& url_in,
    const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin_in,
    const ::net::SiteForCookies& site_for_cookies_in,
    WTF::Vector<::network::mojom::blink::CookieOrLineWithAccessResultPtr> cookie_list_in,
    const WTF::String& devtools_request_id_in,
    bool is_ad_tagged_in,
    ::network::mojom::blink::CookieSettingOverridesPtr cookie_setting_overrides_in)
    : type(std::move(type_in)),
      url(std::move(url_in)),
      top_frame_origin(std::move(top_frame_origin_in)),
      site_for_cookies(std::move(site_for_cookies_in)),
      cookie_list(std::move(cookie_list_in)),
      devtools_request_id(std::move(devtools_request_id_in)),
      is_ad_tagged(std::move(is_ad_tagged_in)),
      cookie_setting_overrides(std::move(cookie_setting_overrides_in)) {}

CookieAccessDetails::~CookieAccessDetails() = default;

void CookieAccessDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieAccessDetails::Type>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_frame_origin"), this->top_frame_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site_for_cookies"), this->site_for_cookies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::SiteForCookies&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_list"), this->cookie_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<::network::mojom::blink::CookieOrLineWithAccessResultPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_request_id"), this->devtools_request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_ad_tagged"), this->is_ad_tagged,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_setting_overrides"), this->cookie_setting_overrides,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::CookieSettingOverridesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookieAccessDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char CookieAccessObserver::Name_[] = "network.mojom.CookieAccessObserver";

CookieAccessObserver::IPCStableHashFunction CookieAccessObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CookieAccessObserver>(message.name())) {
    case messages::CookieAccessObserver::kOnCookiesAccessed: {
      return &CookieAccessObserver::OnCookiesAccessed_Sym::IPCStableHash;
    }
    case messages::CookieAccessObserver::kClone: {
      return &CookieAccessObserver::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CookieAccessObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CookieAccessObserver>(message.name())) {
      case messages::CookieAccessObserver::kOnCookiesAccessed:
            return "Receive network::mojom::CookieAccessObserver::OnCookiesAccessed";
      case messages::CookieAccessObserver::kClone:
            return "Receive network::mojom::CookieAccessObserver::Clone";
    }
  } else {
    switch (static_cast<messages::CookieAccessObserver>(message.name())) {
      case messages::CookieAccessObserver::kOnCookiesAccessed:
            return "Receive reply network::mojom::CookieAccessObserver::OnCookiesAccessed";
      case messages::CookieAccessObserver::kClone:
            return "Receive reply network::mojom::CookieAccessObserver::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CookieAccessObserver::OnCookiesAccessed_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::CookieAccessObserver::OnCookiesAccessed");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CookieAccessObserver::Clone_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::CookieAccessObserver::Clone");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CookieAccessObserverProxy::CookieAccessObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CookieAccessObserverProxy::OnCookiesAccessed(
    WTF::Vector<CookieAccessDetailsPtr> in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CookieAccessObserver::OnCookiesAccessed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type WTF::Vector<CookieAccessDetailsPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieAccessObserver::kOnCookiesAccessed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieAccessObserver_OnCookiesAccessed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType>
      details_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieAccessDetailsDataView>>(
      in_details, details_fragment, &details_validate_params);
  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in CookieAccessObserver.OnCookiesAccessed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieAccessObserver::Name_);
  message.set_method_name("OnCookiesAccessed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CookieAccessObserverProxy::Clone(
    ::mojo::PendingReceiver<CookieAccessObserver> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CookieAccessObserver::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingReceiver<CookieAccessObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CookieAccessObserver::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieAccessObserver_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::CookieAccessObserverInterfaceBase>>(
      in_listener, &params->listener, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->listener),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid listener in CookieAccessObserver.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieAccessObserver::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CookieAccessObserverStubDispatch::Accept(
    CookieAccessObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CookieAccessObserver>(message->header()->name)) {
    case messages::CookieAccessObserver::kOnCookiesAccessed: {
      DCHECK(message->is_serialized());
      internal::CookieAccessObserver_OnCookiesAccessed_Params_Data* params =
          reinterpret_cast<internal::CookieAccessObserver_OnCookiesAccessed_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CookieAccessObserver.0
      bool success = true;
      WTF::Vector<CookieAccessDetailsPtr> p_details{};
      CookieAccessObserver_OnCookiesAccessed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieAccessObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCookiesAccessed(        
        std::move(p_details));
      return true;
    }
    case messages::CookieAccessObserver::kClone: {
      DCHECK(message->is_serialized());
      internal::CookieAccessObserver_Clone_Params_Data* params =
          reinterpret_cast<internal::CookieAccessObserver_Clone_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CookieAccessObserver.1
      bool success = true;
      ::mojo::PendingReceiver<CookieAccessObserver> p_listener{};
      CookieAccessObserver_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieAccessObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_listener));
      return true;
    }
  }
  return false;
}

// static
bool CookieAccessObserverStubDispatch::AcceptWithResponder(
    CookieAccessObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CookieAccessObserver>(message->header()->name)) {
    case messages::CookieAccessObserver::kOnCookiesAccessed: {
      break;
    }
    case messages::CookieAccessObserver::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCookieAccessObserverValidationInfo[] = {
    {base::to_underlying(messages::CookieAccessObserver::kOnCookiesAccessed),
     { &internal::CookieAccessObserver_OnCookiesAccessed_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CookieAccessObserver::kClone),
     { &internal::CookieAccessObserver_Clone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CookieAccessObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::CookieAccessObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCookieAccessObserverValidationInfo);
}



}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::CookieAccessDetails::DataView, ::network::mojom::blink::CookieAccessDetailsPtr>::Read(
    ::network::mojom::blink::CookieAccessDetails::DataView input,
    ::network::mojom::blink::CookieAccessDetailsPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieAccessDetailsPtr result(::network::mojom::blink::CookieAccessDetails::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadTopFrameOrigin(&result->top_frame_origin))
        success = false;
      if (success && !input.ReadSiteForCookies(&result->site_for_cookies))
        success = false;
      if (success && !input.ReadCookieList(&result->cookie_list))
        success = false;
      if (success && !input.ReadDevtoolsRequestId(&result->devtools_request_id))
        success = false;
      if (success)
        result->is_ad_tagged = input.is_ad_tagged();
      if (success && !input.ReadCookieSettingOverrides(&result->cookie_setting_overrides))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void CookieAccessObserverInterceptorForTesting::OnCookiesAccessed(WTF::Vector<CookieAccessDetailsPtr> details) {
  GetForwardingInterface()->OnCookiesAccessed(
    std::move(details)
    );
}
void CookieAccessObserverInterceptorForTesting::Clone(::mojo::PendingReceiver<CookieAccessObserver> listener) {
  GetForwardingInterface()->Clone(
    std::move(listener)
    );
}
CookieAccessObserverAsyncWaiter::CookieAccessObserverAsyncWaiter(
    CookieAccessObserver* proxy) : proxy_(proxy) {}

CookieAccessObserverAsyncWaiter::~CookieAccessObserverAsyncWaiter() = default;






}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif