// services/data_decoder/public/mojom/image_decoder.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_PARAMS_DATA_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace data_decoder::mojom {
namespace internal {
class  ImageDecoder_DecodeImage_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  ::mojo_base::mojom::internal::BigBuffer_Data encoded_data;
  int32_t codec;
  uint8_t shrink_to_fit : 1;
  uint8_t pad2_[3];
  int64_t max_size_in_bytes;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> desired_image_frame_size;

 private:
  friend class mojo::internal::MessageFragment<ImageDecoder_DecodeImage_Params_Data>;

  ImageDecoder_DecodeImage_Params_Data();
  ~ImageDecoder_DecodeImage_Params_Data() = delete;
};
static_assert(sizeof(ImageDecoder_DecodeImage_Params_Data) == 48,
              "Bad sizeof(ImageDecoder_DecodeImage_Params_Data)");
class  ImageDecoder_DecodeImage_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> decoding_duration;
  mojo::internal::Pointer<::skia::mojom::internal::BitmapN32_Data> decoded_image;

 private:
  friend class mojo::internal::MessageFragment<ImageDecoder_DecodeImage_ResponseParams_Data>;

  ImageDecoder_DecodeImage_ResponseParams_Data();
  ~ImageDecoder_DecodeImage_ResponseParams_Data() = delete;
};
static_assert(sizeof(ImageDecoder_DecodeImage_ResponseParams_Data) == 24,
              "Bad sizeof(ImageDecoder_DecodeImage_ResponseParams_Data)");
class  ImageDecoder_DecodeAnimation_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  ::mojo_base::mojom::internal::BigBuffer_Data encoded_data;
  uint8_t shrink_to_fit : 1;
  uint8_t pad1_[7];
  int64_t max_size_in_bytes;

 private:
  friend class mojo::internal::MessageFragment<ImageDecoder_DecodeAnimation_Params_Data>;

  ImageDecoder_DecodeAnimation_Params_Data();
  ~ImageDecoder_DecodeAnimation_Params_Data() = delete;
};
static_assert(sizeof(ImageDecoder_DecodeAnimation_Params_Data) == 40,
              "Bad sizeof(ImageDecoder_DecodeAnimation_Params_Data)");
class  ImageDecoder_DecodeAnimation_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::AnimationFrame_Data>>> decoded_image;

 private:
  friend class mojo::internal::MessageFragment<ImageDecoder_DecodeAnimation_ResponseParams_Data>;

  ImageDecoder_DecodeAnimation_ResponseParams_Data();
  ~ImageDecoder_DecodeAnimation_ResponseParams_Data() = delete;
};
static_assert(sizeof(ImageDecoder_DecodeAnimation_ResponseParams_Data) == 16,
              "Bad sizeof(ImageDecoder_DecodeAnimation_ResponseParams_Data)");

}  // namespace internal


class ImageDecoder_DecodeImage_ParamsDataView {
 public:
  ImageDecoder_DecodeImage_ParamsDataView() = default;

  ImageDecoder_DecodeImage_ParamsDataView(
      internal::ImageDecoder_DecodeImage_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEncodedDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncodedData(UserType* output) {
    
    auto* pointer = !data_->encoded_data.is_null() ? &data_->encoded_data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCodec(UserType* output) const {
    auto data_value = data_->codec;
    return mojo::internal::Deserialize<::data_decoder::mojom::ImageCodec>(
        data_value, output);
  }
  ImageCodec codec() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::data_decoder::mojom::ImageCodec>(data_->codec));
  }
  bool shrink_to_fit() const {
    return data_->shrink_to_fit;
  }
  int64_t max_size_in_bytes() const {
    return data_->max_size_in_bytes;
  }
  inline void GetDesiredImageFrameSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDesiredImageFrameSize(UserType* output) {
    
    auto* pointer = data_->desired_image_frame_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
 private:
  internal::ImageDecoder_DecodeImage_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ImageDecoder_DecodeImage_ResponseParamsDataView {
 public:
  ImageDecoder_DecodeImage_ResponseParamsDataView() = default;

  ImageDecoder_DecodeImage_ResponseParamsDataView(
      internal::ImageDecoder_DecodeImage_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDecodingDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDecodingDuration(UserType* output) {
    
    auto* pointer = data_->decoding_duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetDecodedImageDataView(
      ::skia::mojom::BitmapN32DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDecodedImage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::BitmapN32DataView, UserType>(),
    "Attempting to read the optional `decoded_image` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDecodedImage` instead "
    "of `ReadDecodedImage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->decoded_image.Get();
    return mojo::internal::Deserialize<::skia::mojom::BitmapN32DataView>(
        pointer, output, message_);
  }
 private:
  internal::ImageDecoder_DecodeImage_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ImageDecoder_DecodeAnimation_ParamsDataView {
 public:
  ImageDecoder_DecodeAnimation_ParamsDataView() = default;

  ImageDecoder_DecodeAnimation_ParamsDataView(
      internal::ImageDecoder_DecodeAnimation_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEncodedDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncodedData(UserType* output) {
    
    auto* pointer = !data_->encoded_data.is_null() ? &data_->encoded_data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
  bool shrink_to_fit() const {
    return data_->shrink_to_fit;
  }
  int64_t max_size_in_bytes() const {
    return data_->max_size_in_bytes;
  }
 private:
  internal::ImageDecoder_DecodeAnimation_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ImageDecoder_DecodeAnimation_ResponseParamsDataView {
 public:
  ImageDecoder_DecodeAnimation_ResponseParamsDataView() = default;

  ImageDecoder_DecodeAnimation_ResponseParamsDataView(
      internal::ImageDecoder_DecodeAnimation_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDecodedImageDataView(
      mojo::ArrayDataView<AnimationFrameDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDecodedImage(UserType* output) {
    
    auto* pointer = data_->decoded_image.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::data_decoder::mojom::AnimationFrameDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ImageDecoder_DecodeAnimation_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void ImageDecoder_DecodeImage_ParamsDataView::GetEncodedDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->encoded_data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}
inline void ImageDecoder_DecodeImage_ParamsDataView::GetDesiredImageFrameSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->desired_image_frame_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void ImageDecoder_DecodeImage_ResponseParamsDataView::GetDecodingDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->decoding_duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void ImageDecoder_DecodeImage_ResponseParamsDataView::GetDecodedImageDataView(
    ::skia::mojom::BitmapN32DataView* output) {
  auto pointer = data_->decoded_image.Get();
  *output = ::skia::mojom::BitmapN32DataView(pointer, message_);
}


inline void ImageDecoder_DecodeAnimation_ParamsDataView::GetEncodedDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->encoded_data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}


inline void ImageDecoder_DecodeAnimation_ResponseParamsDataView::GetDecodedImageDataView(
    mojo::ArrayDataView<AnimationFrameDataView>* output) {
  auto pointer = data_->decoded_image.Get();
  *output = mojo::ArrayDataView<AnimationFrameDataView>(pointer, message_);
}



}  // data_decoder::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_PARAMS_DATA_H_