// media/mojo/mojom/stable/stable_video_decoder.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/stable/stable_video_decoder.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/stable/stable_video_decoder.mojom-params-data.h"
namespace media {
namespace stable {
namespace mojom {

namespace internal {


// static
bool MediaLog_AddLogRecord_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaLog_AddLogRecord_Params_Data* object =
      static_cast<const MediaLog_AddLogRecord_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

MediaLog_AddLogRecord_Params_Data::MediaLog_AddLogRecord_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data* object =
      static_cast<const VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->release_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->release_token, validation_context))
    return false;

  return true;
}

VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data::VideoFrameHandleReleaser_ReleaseVideoFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoDecoderClient_OnVideoFrameDecoded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoDecoderClient_OnVideoFrameDecoded_Params_Data* object =
      static_cast<const VideoDecoderClient_OnVideoFrameDecoded_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->release_token, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->release_token, validation_context))
    return false;

  return true;
}

VideoDecoderClient_OnVideoFrameDecoded_Params_Data::VideoDecoderClient_OnVideoFrameDecoded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoDecoderClient_OnWaiting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoDecoderClient_OnWaiting_Params_Data* object =
      static_cast<const VideoDecoderClient_OnWaiting_Params_Data*>(data);


  if (!::media::stable::mojom::internal::WaitingReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

VideoDecoderClient_OnWaiting_Params_Data::VideoDecoderClient_OnWaiting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CdmContextEventCallback_EventCallback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CdmContextEventCallback_EventCallback_Params_Data* object =
      static_cast<const CdmContextEventCallback_EventCallback_Params_Data*>(data);


  if (!::media::stable::mojom::internal::CdmContextEvent_Data
        ::Validate(object->event, validation_context))
    return false;

  return true;
}

CdmContextEventCallback_EventCallback_Params_Data::CdmContextEventCallback_EventCallback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableCdmContext_GetHwKeyData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableCdmContext_GetHwKeyData_Params_Data* object =
      static_cast<const StableCdmContext_GetHwKeyData_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->decrypt_config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->decrypt_config, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hw_identifier, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hw_identifier_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->hw_identifier, validation_context,
                                         &hw_identifier_validate_params)) {
    return false;
  }

  return true;
}

StableCdmContext_GetHwKeyData_Params_Data::StableCdmContext_GetHwKeyData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableCdmContext_GetHwKeyData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableCdmContext_GetHwKeyData_ResponseParams_Data* object =
      static_cast<const StableCdmContext_GetHwKeyData_ResponseParams_Data*>(data);


  if (!::media::stable::mojom::internal::DecryptStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key_data, validation_context,
                                         &key_data_validate_params)) {
    return false;
  }

  return true;
}

StableCdmContext_GetHwKeyData_ResponseParams_Data::StableCdmContext_GetHwKeyData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableCdmContext_RegisterEventCallback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableCdmContext_RegisterEventCallback_Params_Data* object =
      static_cast<const StableCdmContext_RegisterEventCallback_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->callback, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->callback,
                                                 validation_context)) {
    return false;
  }

  return true;
}

StableCdmContext_RegisterEventCallback_Params_Data::StableCdmContext_RegisterEventCallback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableCdmContext_GetHwConfigData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableCdmContext_GetHwConfigData_Params_Data* object =
      static_cast<const StableCdmContext_GetHwConfigData_Params_Data*>(data);

  return true;
}

StableCdmContext_GetHwConfigData_Params_Data::StableCdmContext_GetHwConfigData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableCdmContext_GetHwConfigData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableCdmContext_GetHwConfigData_ResponseParams_Data* object =
      static_cast<const StableCdmContext_GetHwConfigData_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& config_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->config_data, validation_context,
                                         &config_data_validate_params)) {
    return false;
  }

  return true;
}

StableCdmContext_GetHwConfigData_ResponseParams_Data::StableCdmContext_GetHwConfigData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableCdmContext_GetScreenResolutions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableCdmContext_GetScreenResolutions_Params_Data* object =
      static_cast<const StableCdmContext_GetScreenResolutions_Params_Data*>(data);

  return true;
}

StableCdmContext_GetScreenResolutions_Params_Data::StableCdmContext_GetScreenResolutions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableCdmContext_GetScreenResolutions_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableCdmContext_GetScreenResolutions_ResponseParams_Data* object =
      static_cast<const StableCdmContext_GetScreenResolutions_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resolutions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& resolutions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->resolutions, validation_context,
                                         &resolutions_validate_params)) {
    return false;
  }

  return true;
}

StableCdmContext_GetScreenResolutions_ResponseParams_Data::StableCdmContext_GetScreenResolutions_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableCdmContext_AllocateSecureBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableCdmContext_AllocateSecureBuffer_Params_Data* object =
      static_cast<const StableCdmContext_AllocateSecureBuffer_Params_Data*>(data);

  return true;
}

StableCdmContext_AllocateSecureBuffer_Params_Data::StableCdmContext_AllocateSecureBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableCdmContext_AllocateSecureBuffer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableCdmContext_AllocateSecureBuffer_ResponseParams_Data* object =
      static_cast<const StableCdmContext_AllocateSecureBuffer_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->secure_buffer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

StableCdmContext_AllocateSecureBuffer_ResponseParams_Data::StableCdmContext_AllocateSecureBuffer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableCdmContext_ParseEncryptedSliceHeader_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableCdmContext_ParseEncryptedSliceHeader_Params_Data* object =
      static_cast<const StableCdmContext_ParseEncryptedSliceHeader_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stream_data, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& stream_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->stream_data, validation_context,
                                         &stream_data_validate_params)) {
    return false;
  }

  return true;
}

StableCdmContext_ParseEncryptedSliceHeader_Params_Data::StableCdmContext_ParseEncryptedSliceHeader_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableCdmContext_ParseEncryptedSliceHeader_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableCdmContext_ParseEncryptedSliceHeader_ResponseParams_Data* object =
      static_cast<const StableCdmContext_ParseEncryptedSliceHeader_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->slice_header, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& slice_header_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->slice_header, validation_context,
                                         &slice_header_validate_params)) {
    return false;
  }

  return true;
}

StableCdmContext_ParseEncryptedSliceHeader_ResponseParams_Data::StableCdmContext_ParseEncryptedSliceHeader_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableCdmContext_DecryptVideoBuffer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableCdmContext_DecryptVideoBuffer_Params_Data* object =
      static_cast<const StableCdmContext_DecryptVideoBuffer_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bytes, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->bytes, validation_context,
                                         &bytes_validate_params)) {
    return false;
  }

  return true;
}

StableCdmContext_DecryptVideoBuffer_Params_Data::StableCdmContext_DecryptVideoBuffer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableCdmContext_DecryptVideoBuffer_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableCdmContext_DecryptVideoBuffer_ResponseParams_Data* object =
      static_cast<const StableCdmContext_DecryptVideoBuffer_ResponseParams_Data*>(data);


  if (!::media::stable::mojom::internal::DecryptStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->decoder_buffer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bytes, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->bytes, validation_context,
                                         &bytes_validate_params)) {
    return false;
  }

  return true;
}

StableCdmContext_DecryptVideoBuffer_ResponseParams_Data::StableCdmContext_DecryptVideoBuffer_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableVideoDecoder_GetSupportedConfigs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableVideoDecoder_GetSupportedConfigs_Params_Data* object =
      static_cast<const StableVideoDecoder_GetSupportedConfigs_Params_Data*>(data);

  return true;
}

StableVideoDecoder_GetSupportedConfigs_Params_Data::StableVideoDecoder_GetSupportedConfigs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data* object =
      static_cast<const StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->supported_configs, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& supported_configs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->supported_configs, validation_context,
                                         &supported_configs_validate_params)) {
    return false;
  }


  if (!::media::stable::mojom::internal::VideoDecoderType_Data
        ::Validate(object->decoder_type, validation_context))
    return false;

  return true;
}

StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data::StableVideoDecoder_GetSupportedConfigs_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableVideoDecoder_Construct_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableVideoDecoder_Construct_Params_Data* object =
      static_cast<const StableVideoDecoder_Construct_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->media_log, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->media_log,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->video_frame_handle_releaser, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->video_frame_handle_releaser,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->decoder_buffer_pipe, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->decoder_buffer_pipe,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_color_space, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->target_color_space, validation_context))
    return false;

  return true;
}

StableVideoDecoder_Construct_Params_Data::StableVideoDecoder_Construct_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableVideoDecoder_Initialize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableVideoDecoder_Initialize_Params_Data* object =
      static_cast<const StableVideoDecoder_Initialize_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->cdm_context,
                                                 validation_context)) {
    return false;
  }

  return true;
}

StableVideoDecoder_Initialize_Params_Data::StableVideoDecoder_Initialize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableVideoDecoder_Initialize_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 32 },
    { 1, 32 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableVideoDecoder_Initialize_ResponseParams_Data* object =
      static_cast<const StableVideoDecoder_Initialize_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;


  if (!::media::stable::mojom::internal::VideoDecoderType_Data
        ::Validate(object->decoder_type, validation_context))
    return false;

  return true;
}

StableVideoDecoder_Initialize_ResponseParams_Data::StableVideoDecoder_Initialize_ResponseParams_Data()
    : header_({sizeof(*this), 1}) {}


// static
bool StableVideoDecoder_Decode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableVideoDecoder_Decode_Params_Data* object =
      static_cast<const StableVideoDecoder_Decode_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer, validation_context))
    return false;

  return true;
}

StableVideoDecoder_Decode_Params_Data::StableVideoDecoder_Decode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableVideoDecoder_Decode_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableVideoDecoder_Decode_ResponseParams_Data* object =
      static_cast<const StableVideoDecoder_Decode_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

StableVideoDecoder_Decode_ResponseParams_Data::StableVideoDecoder_Decode_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableVideoDecoder_Reset_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableVideoDecoder_Reset_Params_Data* object =
      static_cast<const StableVideoDecoder_Reset_Params_Data*>(data);

  return true;
}

StableVideoDecoder_Reset_Params_Data::StableVideoDecoder_Reset_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableVideoDecoder_Reset_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableVideoDecoder_Reset_ResponseParams_Data* object =
      static_cast<const StableVideoDecoder_Reset_ResponseParams_Data*>(data);

  return true;
}

StableVideoDecoder_Reset_ResponseParams_Data::StableVideoDecoder_Reset_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StableVideoDecoderFactory_CreateStableVideoDecoder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 16 },
    { 1, 24 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableVideoDecoderFactory_CreateStableVideoDecoder_Params_Data* object =
      static_cast<const StableVideoDecoderFactory_CreateStableVideoDecoder_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }
  if (object->header_.version < 1)
    return true;

  if (!mojo::internal::ValidateHandleOrInterface(object->tracker,
                                                 validation_context)) {
    return false;
  }

  return true;
}

StableVideoDecoderFactory_CreateStableVideoDecoder_Params_Data::StableVideoDecoderFactory_CreateStableVideoDecoder_Params_Data()
    : header_({sizeof(*this), 1}) {}


// static
bool StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_Params_Data* object =
      static_cast<const StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gpu_feature_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gpu_feature_info, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_Params_Data::StableVideoDecoderFactoryProcess_InitializeStableVideoDecoderFactory_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace stable
}  // namespace media