// media/mojo/mojom/stable/native_pixmap_handle.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_STABLE_NATIVE_PIXMAP_HANDLE_MOJOM_H_
#define MEDIA_MOJO_MOJOM_STABLE_NATIVE_PIXMAP_HANDLE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/stable/native_pixmap_handle.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/stable/native_pixmap_handle.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/stable/native_pixmap_handle.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "media/mojo/mojom/stable/native_pixmap_handle_mojom_traits.h"
#include "ui/gfx/native_pixmap_handle.h"




namespace media::stable::mojom {









class  NativePixmapPlane {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NativePixmapPlane, T>::value>;
  using DataView = NativePixmapPlaneDataView;
  using Data_ = internal::NativePixmapPlane_Data;

  template <typename... Args>
  static NativePixmapPlanePtr New(Args&&... args) {
    return NativePixmapPlanePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NativePixmapPlanePtr From(const U& u) {
    return mojo::TypeConverter<NativePixmapPlanePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NativePixmapPlane>::Convert(*this);
  }


  NativePixmapPlane();

  NativePixmapPlane(
      uint32_t stride,
      uint64_t offset,
      uint64_t size,
      ::mojo::PlatformHandle buffer_handle);

NativePixmapPlane(const NativePixmapPlane&) = delete;
NativePixmapPlane& operator=(const NativePixmapPlane&) = delete;

  ~NativePixmapPlane();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NativePixmapPlanePtr>
  NativePixmapPlanePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NativePixmapPlane::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NativePixmapPlane::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NativePixmapPlane::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NativePixmapPlane::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NativePixmapPlane_UnserializedMessageContext<
            UserType, NativePixmapPlane::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NativePixmapPlane::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NativePixmapPlane::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NativePixmapPlane_UnserializedMessageContext<
            UserType, NativePixmapPlane::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NativePixmapPlane::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t stride;
  
  uint64_t offset;
  
  uint64_t size;
  
  ::mojo::PlatformHandle buffer_handle;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NativePixmapPlane::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NativePixmapPlane::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NativePixmapPlane::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NativePixmapPlane::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NativePixmapHandle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NativePixmapHandle, T>::value>;
  using DataView = NativePixmapHandleDataView;
  using Data_ = internal::NativePixmapHandle_Data;

  template <typename... Args>
  static NativePixmapHandlePtr New(Args&&... args) {
    return NativePixmapHandlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NativePixmapHandlePtr From(const U& u) {
    return mojo::TypeConverter<NativePixmapHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NativePixmapHandle>::Convert(*this);
  }


  NativePixmapHandle();

  NativePixmapHandle(
      std::vector<::gfx::NativePixmapPlane> planes,
      uint64_t modifier);

NativePixmapHandle(const NativePixmapHandle&) = delete;
NativePixmapHandle& operator=(const NativePixmapHandle&) = delete;

  ~NativePixmapHandle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NativePixmapHandlePtr>
  NativePixmapHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NativePixmapHandle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NativePixmapHandle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NativePixmapHandle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NativePixmapHandle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NativePixmapHandle_UnserializedMessageContext<
            UserType, NativePixmapHandle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NativePixmapHandle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NativePixmapHandle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NativePixmapHandle_UnserializedMessageContext<
            UserType, NativePixmapHandle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NativePixmapHandle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::gfx::NativePixmapPlane> planes;
  
  uint64_t modifier;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NativePixmapHandle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NativePixmapHandle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NativePixmapHandle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NativePixmapHandle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
NativePixmapPlanePtr NativePixmapPlane::Clone() const {
  return New(
      mojo::Clone(stride),
      mojo::Clone(offset),
      mojo::Clone(size),
      mojo::Clone(buffer_handle)
  );
}

template <typename T, NativePixmapPlane::EnableIfSame<T>*>
bool NativePixmapPlane::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->stride, other_struct.stride))
    return false;
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->buffer_handle, other_struct.buffer_handle))
    return false;
  return true;
}

template <typename T, NativePixmapPlane::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.stride < rhs.stride)
    return true;
  if (rhs.stride < lhs.stride)
    return false;
  if (lhs.offset < rhs.offset)
    return true;
  if (rhs.offset < lhs.offset)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.buffer_handle < rhs.buffer_handle)
    return true;
  if (rhs.buffer_handle < lhs.buffer_handle)
    return false;
  return false;
}
template <typename StructPtrType>
NativePixmapHandlePtr NativePixmapHandle::Clone() const {
  return New(
      mojo::Clone(planes),
      mojo::Clone(modifier)
  );
}

template <typename T, NativePixmapHandle::EnableIfSame<T>*>
bool NativePixmapHandle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->planes, other_struct.planes))
    return false;
  if (!mojo::Equals(this->modifier, other_struct.modifier))
    return false;
  return true;
}

template <typename T, NativePixmapHandle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.planes < rhs.planes)
    return true;
  if (rhs.planes < lhs.planes)
    return false;
  if (lhs.modifier < rhs.modifier)
    return true;
  if (rhs.modifier < lhs.modifier)
    return false;
  return false;
}


}  // media::stable::mojom

namespace mojo {


template <>
struct  StructTraits<::media::stable::mojom::NativePixmapPlane::DataView,
                                         ::media::stable::mojom::NativePixmapPlanePtr> {
  static bool IsNull(const ::media::stable::mojom::NativePixmapPlanePtr& input) { return !input; }
  static void SetToNull(::media::stable::mojom::NativePixmapPlanePtr* output) { output->reset(); }

  static decltype(::media::stable::mojom::NativePixmapPlane::stride) stride(
      const ::media::stable::mojom::NativePixmapPlanePtr& input) {
    return input->stride;
  }

  static decltype(::media::stable::mojom::NativePixmapPlane::offset) offset(
      const ::media::stable::mojom::NativePixmapPlanePtr& input) {
    return input->offset;
  }

  static decltype(::media::stable::mojom::NativePixmapPlane::size) size(
      const ::media::stable::mojom::NativePixmapPlanePtr& input) {
    return input->size;
  }

  static  decltype(::media::stable::mojom::NativePixmapPlane::buffer_handle)& buffer_handle(
       ::media::stable::mojom::NativePixmapPlanePtr& input) {
    return input->buffer_handle;
  }

  static bool Read(::media::stable::mojom::NativePixmapPlane::DataView input, ::media::stable::mojom::NativePixmapPlanePtr* output);
};


template <>
struct  StructTraits<::media::stable::mojom::NativePixmapHandle::DataView,
                                         ::media::stable::mojom::NativePixmapHandlePtr> {
  static bool IsNull(const ::media::stable::mojom::NativePixmapHandlePtr& input) { return !input; }
  static void SetToNull(::media::stable::mojom::NativePixmapHandlePtr* output) { output->reset(); }

  static  decltype(::media::stable::mojom::NativePixmapHandle::planes)& planes(
       ::media::stable::mojom::NativePixmapHandlePtr& input) {
    return input->planes;
  }

  static decltype(::media::stable::mojom::NativePixmapHandle::modifier) modifier(
      const ::media::stable::mojom::NativePixmapHandlePtr& input) {
    return input->modifier;
  }

  static bool Read(::media::stable::mojom::NativePixmapHandle::DataView input, ::media::stable::mojom::NativePixmapHandlePtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_STABLE_NATIVE_PIXMAP_HANDLE_MOJOM_H_