// content/services/auction_worklet/public/mojom/bidder_worklet.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-features.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-shared.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-forward.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-forward.h"
#include "content/services/auction_worklet/public/mojom/real_time_reporting.mojom-forward.h"
#include "content/services/auction_worklet/public/mojom/reject_reason.mojom-forward.h"
#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/url_loader_factory.mojom-forward.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-forward.h"
#include "third_party/blink/public/mojom/interest_group/ad_display_size.mojom.h"
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace auction_worklet::mojom {

class GenerateBidClientProxy;

template <typename ImplRefTraits>
class GenerateBidClientStub;

class GenerateBidClientRequestValidator;
class GenerateBidClientResponseValidator;


class CONTENT_EXPORT GenerateBidClient
    : public GenerateBidClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GenerateBidClientInterfaceBase;
  using Proxy_ = GenerateBidClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = GenerateBidClientStub<ImplRefTraits>;

  using RequestValidator_ = GenerateBidClientRequestValidator;
  using ResponseValidator_ = GenerateBidClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnBiddingSignalsReceivedMinVersion = 0,
    kOnGenerateBidCompleteMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnBiddingSignalsReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnGenerateBidComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GenerateBidClient() = default;


  using OnBiddingSignalsReceivedCallback = base::OnceCallback<void()>;
  
  virtual void OnBiddingSignalsReceived(const base::flat_map<std::string, double>& priority_vector, ::base::TimeDelta trusted_signals_fetch_latency, std::optional<::base::TimeDelta> update_if_older_than, OnBiddingSignalsReceivedCallback callback) = 0;

  
  virtual void OnGenerateBidComplete(std::vector<BidderWorkletBidPtr> bids, std::optional<uint32_t> bidding_signals_data_version, const std::optional<::GURL>& debug_loss_report_url, const std::optional<::GURL>& debug_win_report_url, std::optional<double> set_priority, base::flat_map<std::string, PrioritySignalsDoublePtr> update_priority_signals_overrides, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> pa_requests, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> non_kanon_pa_requests, std::vector<::auction_worklet::mojom::RealTimeReportingContributionPtr> real_time_contributions, BidderTimingMetricsPtr generate_bid_timing_metrics, GenerateBidDependencyLatenciesPtr generate_bid_dependency_latencies, ::auction_worklet::mojom::RejectReason reject_reason, const std::vector<std::string>& errors) = 0;
};

class GenerateBidFinalizerProxy;

template <typename ImplRefTraits>
class GenerateBidFinalizerStub;

class GenerateBidFinalizerRequestValidator;


class CONTENT_EXPORT GenerateBidFinalizer
    : public GenerateBidFinalizerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GenerateBidFinalizerInterfaceBase;
  using Proxy_ = GenerateBidFinalizerProxy;

  template <typename ImplRefTraits>
  using Stub_ = GenerateBidFinalizerStub<ImplRefTraits>;

  using RequestValidator_ = GenerateBidFinalizerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kFinishGenerateBidMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct FinishGenerateBid_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GenerateBidFinalizer() = default;

  
  virtual void FinishGenerateBid(const std::optional<std::string>& auction_signals_json, const std::optional<std::string>& per_buyer_signals_json, std::optional<::base::TimeDelta> per_buyer_timeout, const std::optional<::blink::AdCurrency>& expected_buyer_currency, const std::optional<::GURL>& direct_from_seller_per_buyer_signals, const std::optional<std::string>& direct_from_seller_per_buyer_signals_header_ad_slot, const std::optional<::GURL>& direct_from_seller_auction_signals, const std::optional<std::string>& direct_from_seller_auction_signals_header_ad_slot) = 0;
};

class BidderWorkletProxy;

template <typename ImplRefTraits>
class BidderWorkletStub;

class BidderWorkletRequestValidator;
class BidderWorkletResponseValidator;


class CONTENT_EXPORT BidderWorklet
    : public BidderWorkletInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BidderWorkletInterfaceBase;
  using Proxy_ = BidderWorkletProxy;

  template <typename ImplRefTraits>
  using Stub_ = BidderWorkletStub<ImplRefTraits>;

  using RequestValidator_ = BidderWorkletRequestValidator;
  using ResponseValidator_ = BidderWorkletResponseValidator;
  enum MethodMinVersions : uint32_t {
    kBeginGenerateBidMinVersion = 0,
    kSendPendingSignalsRequestsMinVersion = 0,
    kReportWinMinVersion = 0,
    kConnectDevToolsAgentMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BeginGenerateBid_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendPendingSignalsRequests_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportWin_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ConnectDevToolsAgent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BidderWorklet() = default;

  
  virtual void BeginGenerateBid(BidderWorkletNonSharedParamsPtr bidder_worklet_non_shared_params, ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr key_value_signals_cache_key, KAnonymityBidMode kanon_mode, const ::url::Origin& interest_group_join_origin, const std::optional<::GURL>& direct_from_seller_per_buyer_signals, const std::optional<::GURL>& direct_from_seller_auction_signals, const ::url::Origin& browser_signal_seller_origin, const std::optional<::url::Origin>& browser_signal_top_level_seller_origin, ::base::TimeDelta browser_signal_recency, ::blink::mojom::BiddingBrowserSignalsPtr bidding_browser_signals, ::base::Time auction_start_time, const std::optional<::blink::AdSize>& requested_ad_size, uint16_t multi_bid_limit, uint64_t trace_id, ::mojo::PendingAssociatedRemote<GenerateBidClient> generate_bid_client, ::mojo::PendingAssociatedReceiver<GenerateBidFinalizer> bid_finalizer) = 0;

  
  virtual void SendPendingSignalsRequests() = 0;


  using ReportWinCallback = base::OnceCallback<void(const std::optional<::GURL>&, const base::flat_map<std::string, ::GURL>&, const base::flat_map<std::string, std::string>&, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr>, BidderTimingMetricsPtr, const std::vector<std::string>&)>;
  
  virtual void ReportWin(bool is_for_additional_bid, const std::optional<std::string>& interest_group_name_reporting_id, const std::optional<std::string>& buyer_reporting_id, const std::optional<std::string>& buyer_and_seller_reporting_id, const std::optional<std::string>& selected_buyer_and_seller_reporting_id, const std::optional<std::string>& auction_signals_json, const std::optional<std::string>& per_buyer_signals_json, const std::optional<::GURL>& direct_from_seller_per_buyer_signals, const std::optional<std::string>& direct_from_seller_per_buyer_signals_header_ad_slot, const std::optional<::GURL>& direct_from_seller_auction_signals, const std::optional<std::string>& direct_from_seller_auction_signals_header_ad_slot, const std::string& seller_signals_json, KAnonymityBidMode kanon_mode, bool bid_is_kanon, const ::GURL& browser_signal_render_url, double browser_signal_bid, const std::optional<::blink::AdCurrency>& browser_signal_bid_currency, double browser_signal_highest_scoring_other_bid, const std::optional<::blink::AdCurrency>& browser_signal_highest_scoring_other_bid_currency, bool browser_signal_made_highest_scoring_other_bid, std::optional<double> browser_signal_ad_cost, std::optional<uint16_t> browser_signal_modeling_signals, uint8_t browser_signal_join_count, uint8_t browser_signal_recency, const ::url::Origin& browser_signal_seller_origin, const std::optional<::url::Origin>& browser_signal_top_level_seller_origin, std::optional<::base::TimeDelta> browser_signal_reporting_timeout, std::optional<uint32_t> bidding_signals_data_version, const std::optional<std::string>& aggregate_win_signals, uint64_t trace_id, ReportWinCallback callback) = 0;

  
  virtual void ConnectDevToolsAgent(::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> agent, uint32_t thread_index) = 0;
};



class CONTENT_EXPORT GenerateBidClientProxy
    : public GenerateBidClient {
 public:
  using InterfaceType = GenerateBidClient;

  explicit GenerateBidClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnBiddingSignalsReceived(const base::flat_map<std::string, double>& priority_vector, ::base::TimeDelta trusted_signals_fetch_latency, std::optional<::base::TimeDelta> update_if_older_than, OnBiddingSignalsReceivedCallback callback) final;
  
  void OnGenerateBidComplete(std::vector<BidderWorkletBidPtr> bids, std::optional<uint32_t> bidding_signals_data_version, const std::optional<::GURL>& debug_loss_report_url, const std::optional<::GURL>& debug_win_report_url, std::optional<double> set_priority, base::flat_map<std::string, PrioritySignalsDoublePtr> update_priority_signals_overrides, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> pa_requests, std::vector<::auction_worklet::mojom::PrivateAggregationRequestPtr> non_kanon_pa_requests, std::vector<::auction_worklet::mojom::RealTimeReportingContributionPtr> real_time_contributions, BidderTimingMetricsPtr generate_bid_timing_metrics, GenerateBidDependencyLatenciesPtr generate_bid_dependency_latencies, ::auction_worklet::mojom::RejectReason reject_reason, const std::vector<std::string>& errors) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT GenerateBidFinalizerProxy
    : public GenerateBidFinalizer {
 public:
  using InterfaceType = GenerateBidFinalizer;

  explicit GenerateBidFinalizerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void FinishGenerateBid(const std::optional<std::string>& auction_signals_json, const std::optional<std::string>& per_buyer_signals_json, std::optional<::base::TimeDelta> per_buyer_timeout, const std::optional<::blink::AdCurrency>& expected_buyer_currency, const std::optional<::GURL>& direct_from_seller_per_buyer_signals, const std::optional<std::string>& direct_from_seller_per_buyer_signals_header_ad_slot, const std::optional<::GURL>& direct_from_seller_auction_signals, const std::optional<std::string>& direct_from_seller_auction_signals_header_ad_slot) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT BidderWorkletProxy
    : public BidderWorklet {
 public:
  using InterfaceType = BidderWorklet;

  explicit BidderWorkletProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BeginGenerateBid(BidderWorkletNonSharedParamsPtr bidder_worklet_non_shared_params, ::auction_worklet::mojom::TrustedSignalsCacheKeyPtr key_value_signals_cache_key, KAnonymityBidMode kanon_mode, const ::url::Origin& interest_group_join_origin, const std::optional<::GURL>& direct_from_seller_per_buyer_signals, const std::optional<::GURL>& direct_from_seller_auction_signals, const ::url::Origin& browser_signal_seller_origin, const std::optional<::url::Origin>& browser_signal_top_level_seller_origin, ::base::TimeDelta browser_signal_recency, ::blink::mojom::BiddingBrowserSignalsPtr bidding_browser_signals, ::base::Time auction_start_time, const std::optional<::blink::AdSize>& requested_ad_size, uint16_t multi_bid_limit, uint64_t trace_id, ::mojo::PendingAssociatedRemote<GenerateBidClient> generate_bid_client, ::mojo::PendingAssociatedReceiver<GenerateBidFinalizer> bid_finalizer) final;
  
  void SendPendingSignalsRequests() final;
  
  void ReportWin(bool is_for_additional_bid, const std::optional<std::string>& interest_group_name_reporting_id, const std::optional<std::string>& buyer_reporting_id, const std::optional<std::string>& buyer_and_seller_reporting_id, const std::optional<std::string>& selected_buyer_and_seller_reporting_id, const std::optional<std::string>& auction_signals_json, const std::optional<std::string>& per_buyer_signals_json, const std::optional<::GURL>& direct_from_seller_per_buyer_signals, const std::optional<std::string>& direct_from_seller_per_buyer_signals_header_ad_slot, const std::optional<::GURL>& direct_from_seller_auction_signals, const std::optional<std::string>& direct_from_seller_auction_signals_header_ad_slot, const std::string& seller_signals_json, KAnonymityBidMode kanon_mode, bool bid_is_kanon, const ::GURL& browser_signal_render_url, double browser_signal_bid, const std::optional<::blink::AdCurrency>& browser_signal_bid_currency, double browser_signal_highest_scoring_other_bid, const std::optional<::blink::AdCurrency>& browser_signal_highest_scoring_other_bid_currency, bool browser_signal_made_highest_scoring_other_bid, std::optional<double> browser_signal_ad_cost, std::optional<uint16_t> browser_signal_modeling_signals, uint8_t browser_signal_join_count, uint8_t browser_signal_recency, const ::url::Origin& browser_signal_seller_origin, const std::optional<::url::Origin>& browser_signal_top_level_seller_origin, std::optional<::base::TimeDelta> browser_signal_reporting_timeout, std::optional<uint32_t> bidding_signals_data_version, const std::optional<std::string>& aggregate_win_signals, uint64_t trace_id, ReportWinCallback callback) final;
  
  void ConnectDevToolsAgent(::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> agent, uint32_t thread_index) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT GenerateBidClientStubDispatch {
 public:
  static bool Accept(GenerateBidClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GenerateBidClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GenerateBidClient>>
class GenerateBidClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GenerateBidClientStub() = default;
  ~GenerateBidClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GenerateBidClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GenerateBidClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT GenerateBidFinalizerStubDispatch {
 public:
  static bool Accept(GenerateBidFinalizer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GenerateBidFinalizer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GenerateBidFinalizer>>
class GenerateBidFinalizerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GenerateBidFinalizerStub() = default;
  ~GenerateBidFinalizerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GenerateBidFinalizerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GenerateBidFinalizerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT BidderWorkletStubDispatch {
 public:
  static bool Accept(BidderWorklet* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BidderWorklet* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BidderWorklet>>
class BidderWorkletStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BidderWorkletStub() = default;
  ~BidderWorkletStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BidderWorkletStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BidderWorkletStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT GenerateBidClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT GenerateBidFinalizerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT BidderWorkletRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT GenerateBidClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT BidderWorkletResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class CONTENT_EXPORT KAnonKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<KAnonKey, T>::value>;
  using DataView = KAnonKeyDataView;
  using Data_ = internal::KAnonKey_Data;

  template <typename... Args>
  static KAnonKeyPtr New(Args&&... args) {
    return KAnonKeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static KAnonKeyPtr From(const U& u) {
    return mojo::TypeConverter<KAnonKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, KAnonKey>::Convert(*this);
  }


  KAnonKey();

  explicit KAnonKey(
      const std::string& data);


  ~KAnonKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = KAnonKeyPtr>
  KAnonKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, KAnonKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, KAnonKey::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, KAnonKey::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        KAnonKey::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        KAnonKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::KAnonKey_UnserializedMessageContext<
            UserType, KAnonKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<KAnonKey::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return KAnonKey::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::KAnonKey_UnserializedMessageContext<
            UserType, KAnonKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<KAnonKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, KAnonKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, KAnonKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, KAnonKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, KAnonKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class CONTENT_EXPORT PrioritySignalsDouble {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrioritySignalsDouble, T>::value>;
  using DataView = PrioritySignalsDoubleDataView;
  using Data_ = internal::PrioritySignalsDouble_Data;

  template <typename... Args>
  static PrioritySignalsDoublePtr New(Args&&... args) {
    return PrioritySignalsDoublePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrioritySignalsDoublePtr From(const U& u) {
    return mojo::TypeConverter<PrioritySignalsDoublePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrioritySignalsDouble>::Convert(*this);
  }


  PrioritySignalsDouble();

  explicit PrioritySignalsDouble(
      double value);


  ~PrioritySignalsDouble();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrioritySignalsDoublePtr>
  PrioritySignalsDoublePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrioritySignalsDouble::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrioritySignalsDouble::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrioritySignalsDouble::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrioritySignalsDouble::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrioritySignalsDouble::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrioritySignalsDouble_UnserializedMessageContext<
            UserType, PrioritySignalsDouble::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrioritySignalsDouble::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrioritySignalsDouble::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrioritySignalsDouble_UnserializedMessageContext<
            UserType, PrioritySignalsDouble::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrioritySignalsDouble::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrioritySignalsDouble::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrioritySignalsDouble::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrioritySignalsDouble::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrioritySignalsDouble::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class CONTENT_EXPORT BidderWorkletNonSharedParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BidderWorkletNonSharedParams, T>::value>;
  using DataView = BidderWorkletNonSharedParamsDataView;
  using Data_ = internal::BidderWorkletNonSharedParams_Data;

  template <typename... Args>
  static BidderWorkletNonSharedParamsPtr New(Args&&... args) {
    return BidderWorkletNonSharedParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BidderWorkletNonSharedParamsPtr From(const U& u) {
    return mojo::TypeConverter<BidderWorkletNonSharedParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BidderWorkletNonSharedParams>::Convert(*this);
  }


  BidderWorkletNonSharedParams();

  BidderWorkletNonSharedParams(
      const std::string& name,
      ::blink::mojom::InterestGroup::TrustedBiddingSignalsSlotSizeMode trusted_bidding_signals_slot_size_mode,
      bool enable_bidding_signals_prioritization,
      const std::optional<base::flat_map<std::string, double>>& priority_vector,
      ::blink::mojom::InterestGroup::ExecutionMode execution_mode,
      const std::optional<::GURL>& update_url,
      std::optional<std::vector<std::string>> trusted_bidding_signals_keys,
      int32_t max_trusted_bidding_signals_url_length,
      const std::optional<std::string>& user_bidding_signals,
      std::optional<std::vector<::blink::InterestGroup::Ad>> ads,
      std::optional<std::vector<::blink::InterestGroup::Ad>> ad_components,
      std::vector<KAnonKeyPtr> kanon_keys);

BidderWorkletNonSharedParams(const BidderWorkletNonSharedParams&) = delete;
BidderWorkletNonSharedParams& operator=(const BidderWorkletNonSharedParams&) = delete;

  ~BidderWorkletNonSharedParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BidderWorkletNonSharedParamsPtr>
  BidderWorkletNonSharedParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BidderWorkletNonSharedParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BidderWorkletNonSharedParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BidderWorkletNonSharedParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BidderWorkletNonSharedParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BidderWorkletNonSharedParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BidderWorkletNonSharedParams_UnserializedMessageContext<
            UserType, BidderWorkletNonSharedParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BidderWorkletNonSharedParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BidderWorkletNonSharedParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BidderWorkletNonSharedParams_UnserializedMessageContext<
            UserType, BidderWorkletNonSharedParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BidderWorkletNonSharedParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  ::blink::mojom::InterestGroup::TrustedBiddingSignalsSlotSizeMode trusted_bidding_signals_slot_size_mode;
  
  bool enable_bidding_signals_prioritization;
  
  std::optional<base::flat_map<std::string, double>> priority_vector;
  
  ::blink::mojom::InterestGroup::ExecutionMode execution_mode;
  
  std::optional<::GURL> update_url;
  
  std::optional<std::vector<std::string>> trusted_bidding_signals_keys;
  
  int32_t max_trusted_bidding_signals_url_length;
  
  std::optional<std::string> user_bidding_signals;
  
  std::optional<std::vector<::blink::InterestGroup::Ad>> ads;
  
  std::optional<std::vector<::blink::InterestGroup::Ad>> ad_components;
  
  std::vector<KAnonKeyPtr> kanon_keys;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BidderWorkletNonSharedParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BidderWorkletNonSharedParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BidderWorkletNonSharedParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BidderWorkletNonSharedParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT BidderWorkletBid {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BidderWorkletBid, T>::value>;
  using DataView = BidderWorkletBidDataView;
  using Data_ = internal::BidderWorkletBid_Data;

  template <typename... Args>
  static BidderWorkletBidPtr New(Args&&... args) {
    return BidderWorkletBidPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BidderWorkletBidPtr From(const U& u) {
    return mojo::TypeConverter<BidderWorkletBidPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BidderWorkletBid>::Convert(*this);
  }


  BidderWorkletBid();

  BidderWorkletBid(
      BidRole bid_role,
      const std::string& ad,
      double bid,
      const std::optional<::blink::AdCurrency>& bid_currency,
      std::optional<double> ad_cost,
      const ::blink::AdDescriptor& ad_descriptor,
      const std::optional<std::string>& selected_buyer_and_seller_reporting_id,
      std::optional<std::vector<::blink::AdDescriptor>> ad_component_descriptors,
      std::optional<uint16_t> modeling_signals,
      const std::optional<std::string>& aggregate_win_signals,
      ::base::TimeDelta bid_duration);


  ~BidderWorkletBid();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BidderWorkletBidPtr>
  BidderWorkletBidPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BidderWorkletBid::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BidderWorkletBid::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BidderWorkletBid::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BidderWorkletBid::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BidderWorkletBid::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BidderWorkletBid_UnserializedMessageContext<
            UserType, BidderWorkletBid::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BidderWorkletBid::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BidderWorkletBid::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BidderWorkletBid_UnserializedMessageContext<
            UserType, BidderWorkletBid::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BidderWorkletBid::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  BidRole bid_role;
  
  std::string ad;
  
  double bid;
  
  std::optional<::blink::AdCurrency> bid_currency;
  
  std::optional<double> ad_cost;
  
  ::blink::AdDescriptor ad_descriptor;
  
  std::optional<std::string> selected_buyer_and_seller_reporting_id;
  
  std::optional<std::vector<::blink::AdDescriptor>> ad_component_descriptors;
  
  std::optional<uint16_t> modeling_signals;
  
  std::optional<std::string> aggregate_win_signals;
  
  ::base::TimeDelta bid_duration;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BidderWorkletBid::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BidderWorkletBid::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BidderWorkletBid::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BidderWorkletBid::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class CONTENT_EXPORT GenerateBidDependencyLatencies {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GenerateBidDependencyLatencies, T>::value>;
  using DataView = GenerateBidDependencyLatenciesDataView;
  using Data_ = internal::GenerateBidDependencyLatencies_Data;

  template <typename... Args>
  static GenerateBidDependencyLatenciesPtr New(Args&&... args) {
    return GenerateBidDependencyLatenciesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GenerateBidDependencyLatenciesPtr From(const U& u) {
    return mojo::TypeConverter<GenerateBidDependencyLatenciesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GenerateBidDependencyLatencies>::Convert(*this);
  }


  GenerateBidDependencyLatencies();

  GenerateBidDependencyLatencies(
      std::optional<::base::TimeDelta> code_ready_latency,
      std::optional<::base::TimeDelta> config_promises_latency,
      std::optional<::base::TimeDelta> direct_from_seller_signals_latency,
      std::optional<::base::TimeDelta> trusted_bidding_signals_latency,
      ::base::TimeTicks deps_wait_start_time,
      ::base::TimeTicks generate_bid_start_time,
      ::base::TimeTicks generate_bid_finish_time);


  ~GenerateBidDependencyLatencies();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GenerateBidDependencyLatenciesPtr>
  GenerateBidDependencyLatenciesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GenerateBidDependencyLatencies::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GenerateBidDependencyLatencies::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GenerateBidDependencyLatencies::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GenerateBidDependencyLatencies::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GenerateBidDependencyLatencies::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GenerateBidDependencyLatencies_UnserializedMessageContext<
            UserType, GenerateBidDependencyLatencies::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GenerateBidDependencyLatencies::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GenerateBidDependencyLatencies::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GenerateBidDependencyLatencies_UnserializedMessageContext<
            UserType, GenerateBidDependencyLatencies::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GenerateBidDependencyLatencies::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::TimeDelta> code_ready_latency;
  
  std::optional<::base::TimeDelta> config_promises_latency;
  
  std::optional<::base::TimeDelta> direct_from_seller_signals_latency;
  
  std::optional<::base::TimeDelta> trusted_bidding_signals_latency;
  
  ::base::TimeTicks deps_wait_start_time;
  
  ::base::TimeTicks generate_bid_start_time;
  
  ::base::TimeTicks generate_bid_finish_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GenerateBidDependencyLatencies::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GenerateBidDependencyLatencies::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GenerateBidDependencyLatencies::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GenerateBidDependencyLatencies::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT BidderTimingMetrics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BidderTimingMetrics, T>::value>;
  using DataView = BidderTimingMetricsDataView;
  using Data_ = internal::BidderTimingMetrics_Data;

  template <typename... Args>
  static BidderTimingMetricsPtr New(Args&&... args) {
    return BidderTimingMetricsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BidderTimingMetricsPtr From(const U& u) {
    return mojo::TypeConverter<BidderTimingMetricsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BidderTimingMetrics>::Convert(*this);
  }


  BidderTimingMetrics();

  BidderTimingMetrics(
      std::optional<::base::TimeDelta> js_fetch_latency,
      std::optional<::base::TimeDelta> wasm_fetch_latency,
      ::base::TimeDelta script_latency,
      bool script_timed_out);


  ~BidderTimingMetrics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BidderTimingMetricsPtr>
  BidderTimingMetricsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BidderTimingMetrics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BidderTimingMetrics::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BidderTimingMetrics::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BidderTimingMetrics::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BidderTimingMetrics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BidderTimingMetrics_UnserializedMessageContext<
            UserType, BidderTimingMetrics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BidderTimingMetrics::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BidderTimingMetrics::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BidderTimingMetrics_UnserializedMessageContext<
            UserType, BidderTimingMetrics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BidderTimingMetrics::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::TimeDelta> js_fetch_latency;
  
  std::optional<::base::TimeDelta> wasm_fetch_latency;
  
  ::base::TimeDelta script_latency;
  
  bool script_timed_out;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BidderTimingMetrics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BidderTimingMetrics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BidderTimingMetrics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BidderTimingMetrics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
KAnonKeyPtr KAnonKey::Clone() const {
  return New(
      mojo::Clone(data)
  );
}

template <typename T, KAnonKey::EnableIfSame<T>*>
bool KAnonKey::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, KAnonKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
BidderWorkletNonSharedParamsPtr BidderWorkletNonSharedParams::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(trusted_bidding_signals_slot_size_mode),
      mojo::Clone(enable_bidding_signals_prioritization),
      mojo::Clone(priority_vector),
      mojo::Clone(execution_mode),
      mojo::Clone(update_url),
      mojo::Clone(trusted_bidding_signals_keys),
      mojo::Clone(max_trusted_bidding_signals_url_length),
      mojo::Clone(user_bidding_signals),
      mojo::Clone(ads),
      mojo::Clone(ad_components),
      mojo::Clone(kanon_keys)
  );
}

template <typename T, BidderWorkletNonSharedParams::EnableIfSame<T>*>
bool BidderWorkletNonSharedParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->trusted_bidding_signals_slot_size_mode, other_struct.trusted_bidding_signals_slot_size_mode))
    return false;
  if (!mojo::Equals(this->enable_bidding_signals_prioritization, other_struct.enable_bidding_signals_prioritization))
    return false;
  if (!mojo::Equals(this->priority_vector, other_struct.priority_vector))
    return false;
  if (!mojo::Equals(this->execution_mode, other_struct.execution_mode))
    return false;
  if (!mojo::Equals(this->update_url, other_struct.update_url))
    return false;
  if (!mojo::Equals(this->trusted_bidding_signals_keys, other_struct.trusted_bidding_signals_keys))
    return false;
  if (!mojo::Equals(this->max_trusted_bidding_signals_url_length, other_struct.max_trusted_bidding_signals_url_length))
    return false;
  if (!mojo::Equals(this->user_bidding_signals, other_struct.user_bidding_signals))
    return false;
  if (!mojo::Equals(this->ads, other_struct.ads))
    return false;
  if (!mojo::Equals(this->ad_components, other_struct.ad_components))
    return false;
  if (!mojo::Equals(this->kanon_keys, other_struct.kanon_keys))
    return false;
  return true;
}

template <typename T, BidderWorkletNonSharedParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.trusted_bidding_signals_slot_size_mode < rhs.trusted_bidding_signals_slot_size_mode)
    return true;
  if (rhs.trusted_bidding_signals_slot_size_mode < lhs.trusted_bidding_signals_slot_size_mode)
    return false;
  if (lhs.enable_bidding_signals_prioritization < rhs.enable_bidding_signals_prioritization)
    return true;
  if (rhs.enable_bidding_signals_prioritization < lhs.enable_bidding_signals_prioritization)
    return false;
  if (lhs.priority_vector < rhs.priority_vector)
    return true;
  if (rhs.priority_vector < lhs.priority_vector)
    return false;
  if (lhs.execution_mode < rhs.execution_mode)
    return true;
  if (rhs.execution_mode < lhs.execution_mode)
    return false;
  if (lhs.update_url < rhs.update_url)
    return true;
  if (rhs.update_url < lhs.update_url)
    return false;
  if (lhs.trusted_bidding_signals_keys < rhs.trusted_bidding_signals_keys)
    return true;
  if (rhs.trusted_bidding_signals_keys < lhs.trusted_bidding_signals_keys)
    return false;
  if (lhs.max_trusted_bidding_signals_url_length < rhs.max_trusted_bidding_signals_url_length)
    return true;
  if (rhs.max_trusted_bidding_signals_url_length < lhs.max_trusted_bidding_signals_url_length)
    return false;
  if (lhs.user_bidding_signals < rhs.user_bidding_signals)
    return true;
  if (rhs.user_bidding_signals < lhs.user_bidding_signals)
    return false;
  if (lhs.ads < rhs.ads)
    return true;
  if (rhs.ads < lhs.ads)
    return false;
  if (lhs.ad_components < rhs.ad_components)
    return true;
  if (rhs.ad_components < lhs.ad_components)
    return false;
  if (lhs.kanon_keys < rhs.kanon_keys)
    return true;
  if (rhs.kanon_keys < lhs.kanon_keys)
    return false;
  return false;
}
template <typename StructPtrType>
BidderWorkletBidPtr BidderWorkletBid::Clone() const {
  return New(
      mojo::Clone(bid_role),
      mojo::Clone(ad),
      mojo::Clone(bid),
      mojo::Clone(bid_currency),
      mojo::Clone(ad_cost),
      mojo::Clone(ad_descriptor),
      mojo::Clone(selected_buyer_and_seller_reporting_id),
      mojo::Clone(ad_component_descriptors),
      mojo::Clone(modeling_signals),
      mojo::Clone(aggregate_win_signals),
      mojo::Clone(bid_duration)
  );
}

template <typename T, BidderWorkletBid::EnableIfSame<T>*>
bool BidderWorkletBid::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bid_role, other_struct.bid_role))
    return false;
  if (!mojo::Equals(this->ad, other_struct.ad))
    return false;
  if (!mojo::Equals(this->bid, other_struct.bid))
    return false;
  if (!mojo::Equals(this->bid_currency, other_struct.bid_currency))
    return false;
  if (!mojo::Equals(this->ad_cost, other_struct.ad_cost))
    return false;
  if (!mojo::Equals(this->ad_descriptor, other_struct.ad_descriptor))
    return false;
  if (!mojo::Equals(this->selected_buyer_and_seller_reporting_id, other_struct.selected_buyer_and_seller_reporting_id))
    return false;
  if (!mojo::Equals(this->ad_component_descriptors, other_struct.ad_component_descriptors))
    return false;
  if (!mojo::Equals(this->modeling_signals, other_struct.modeling_signals))
    return false;
  if (!mojo::Equals(this->aggregate_win_signals, other_struct.aggregate_win_signals))
    return false;
  if (!mojo::Equals(this->bid_duration, other_struct.bid_duration))
    return false;
  return true;
}

template <typename T, BidderWorkletBid::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bid_role < rhs.bid_role)
    return true;
  if (rhs.bid_role < lhs.bid_role)
    return false;
  if (lhs.ad < rhs.ad)
    return true;
  if (rhs.ad < lhs.ad)
    return false;
  if (lhs.bid < rhs.bid)
    return true;
  if (rhs.bid < lhs.bid)
    return false;
  if (lhs.bid_currency < rhs.bid_currency)
    return true;
  if (rhs.bid_currency < lhs.bid_currency)
    return false;
  if (lhs.ad_cost < rhs.ad_cost)
    return true;
  if (rhs.ad_cost < lhs.ad_cost)
    return false;
  if (lhs.ad_descriptor < rhs.ad_descriptor)
    return true;
  if (rhs.ad_descriptor < lhs.ad_descriptor)
    return false;
  if (lhs.selected_buyer_and_seller_reporting_id < rhs.selected_buyer_and_seller_reporting_id)
    return true;
  if (rhs.selected_buyer_and_seller_reporting_id < lhs.selected_buyer_and_seller_reporting_id)
    return false;
  if (lhs.ad_component_descriptors < rhs.ad_component_descriptors)
    return true;
  if (rhs.ad_component_descriptors < lhs.ad_component_descriptors)
    return false;
  if (lhs.modeling_signals < rhs.modeling_signals)
    return true;
  if (rhs.modeling_signals < lhs.modeling_signals)
    return false;
  if (lhs.aggregate_win_signals < rhs.aggregate_win_signals)
    return true;
  if (rhs.aggregate_win_signals < lhs.aggregate_win_signals)
    return false;
  if (lhs.bid_duration < rhs.bid_duration)
    return true;
  if (rhs.bid_duration < lhs.bid_duration)
    return false;
  return false;
}
template <typename StructPtrType>
PrioritySignalsDoublePtr PrioritySignalsDouble::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, PrioritySignalsDouble::EnableIfSame<T>*>
bool PrioritySignalsDouble::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, PrioritySignalsDouble::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
GenerateBidDependencyLatenciesPtr GenerateBidDependencyLatencies::Clone() const {
  return New(
      mojo::Clone(code_ready_latency),
      mojo::Clone(config_promises_latency),
      mojo::Clone(direct_from_seller_signals_latency),
      mojo::Clone(trusted_bidding_signals_latency),
      mojo::Clone(deps_wait_start_time),
      mojo::Clone(generate_bid_start_time),
      mojo::Clone(generate_bid_finish_time)
  );
}

template <typename T, GenerateBidDependencyLatencies::EnableIfSame<T>*>
bool GenerateBidDependencyLatencies::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->code_ready_latency, other_struct.code_ready_latency))
    return false;
  if (!mojo::Equals(this->config_promises_latency, other_struct.config_promises_latency))
    return false;
  if (!mojo::Equals(this->direct_from_seller_signals_latency, other_struct.direct_from_seller_signals_latency))
    return false;
  if (!mojo::Equals(this->trusted_bidding_signals_latency, other_struct.trusted_bidding_signals_latency))
    return false;
  if (!mojo::Equals(this->deps_wait_start_time, other_struct.deps_wait_start_time))
    return false;
  if (!mojo::Equals(this->generate_bid_start_time, other_struct.generate_bid_start_time))
    return false;
  if (!mojo::Equals(this->generate_bid_finish_time, other_struct.generate_bid_finish_time))
    return false;
  return true;
}

template <typename T, GenerateBidDependencyLatencies::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.code_ready_latency < rhs.code_ready_latency)
    return true;
  if (rhs.code_ready_latency < lhs.code_ready_latency)
    return false;
  if (lhs.config_promises_latency < rhs.config_promises_latency)
    return true;
  if (rhs.config_promises_latency < lhs.config_promises_latency)
    return false;
  if (lhs.direct_from_seller_signals_latency < rhs.direct_from_seller_signals_latency)
    return true;
  if (rhs.direct_from_seller_signals_latency < lhs.direct_from_seller_signals_latency)
    return false;
  if (lhs.trusted_bidding_signals_latency < rhs.trusted_bidding_signals_latency)
    return true;
  if (rhs.trusted_bidding_signals_latency < lhs.trusted_bidding_signals_latency)
    return false;
  if (lhs.deps_wait_start_time < rhs.deps_wait_start_time)
    return true;
  if (rhs.deps_wait_start_time < lhs.deps_wait_start_time)
    return false;
  if (lhs.generate_bid_start_time < rhs.generate_bid_start_time)
    return true;
  if (rhs.generate_bid_start_time < lhs.generate_bid_start_time)
    return false;
  if (lhs.generate_bid_finish_time < rhs.generate_bid_finish_time)
    return true;
  if (rhs.generate_bid_finish_time < lhs.generate_bid_finish_time)
    return false;
  return false;
}
template <typename StructPtrType>
BidderTimingMetricsPtr BidderTimingMetrics::Clone() const {
  return New(
      mojo::Clone(js_fetch_latency),
      mojo::Clone(wasm_fetch_latency),
      mojo::Clone(script_latency),
      mojo::Clone(script_timed_out)
  );
}

template <typename T, BidderTimingMetrics::EnableIfSame<T>*>
bool BidderTimingMetrics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->js_fetch_latency, other_struct.js_fetch_latency))
    return false;
  if (!mojo::Equals(this->wasm_fetch_latency, other_struct.wasm_fetch_latency))
    return false;
  if (!mojo::Equals(this->script_latency, other_struct.script_latency))
    return false;
  if (!mojo::Equals(this->script_timed_out, other_struct.script_timed_out))
    return false;
  return true;
}

template <typename T, BidderTimingMetrics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.js_fetch_latency < rhs.js_fetch_latency)
    return true;
  if (rhs.js_fetch_latency < lhs.js_fetch_latency)
    return false;
  if (lhs.wasm_fetch_latency < rhs.wasm_fetch_latency)
    return true;
  if (rhs.wasm_fetch_latency < lhs.wasm_fetch_latency)
    return false;
  if (lhs.script_latency < rhs.script_latency)
    return true;
  if (rhs.script_latency < lhs.script_latency)
    return false;
  if (lhs.script_timed_out < rhs.script_timed_out)
    return true;
  if (rhs.script_timed_out < lhs.script_timed_out)
    return false;
  return false;
}


}  // auction_worklet::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::KAnonKey::DataView,
                                         ::auction_worklet::mojom::KAnonKeyPtr> {
  static bool IsNull(const ::auction_worklet::mojom::KAnonKeyPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::KAnonKeyPtr* output) { output->reset(); }

  static const decltype(::auction_worklet::mojom::KAnonKey::data)& data(
      const ::auction_worklet::mojom::KAnonKeyPtr& input) {
    return input->data;
  }

  static bool Read(::auction_worklet::mojom::KAnonKey::DataView input, ::auction_worklet::mojom::KAnonKeyPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::BidderWorkletNonSharedParams::DataView,
                                         ::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr> {
  static bool IsNull(const ::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr* output) { output->reset(); }

  static const decltype(::auction_worklet::mojom::BidderWorkletNonSharedParams::name)& name(
      const ::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr& input) {
    return input->name;
  }

  static decltype(::auction_worklet::mojom::BidderWorkletNonSharedParams::trusted_bidding_signals_slot_size_mode) trusted_bidding_signals_slot_size_mode(
      const ::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr& input) {
    return input->trusted_bidding_signals_slot_size_mode;
  }

  static decltype(::auction_worklet::mojom::BidderWorkletNonSharedParams::enable_bidding_signals_prioritization) enable_bidding_signals_prioritization(
      const ::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr& input) {
    return input->enable_bidding_signals_prioritization;
  }

  static const decltype(::auction_worklet::mojom::BidderWorkletNonSharedParams::priority_vector)& priority_vector(
      const ::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr& input) {
    return input->priority_vector;
  }

  static decltype(::auction_worklet::mojom::BidderWorkletNonSharedParams::execution_mode) execution_mode(
      const ::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr& input) {
    return input->execution_mode;
  }

  static const decltype(::auction_worklet::mojom::BidderWorkletNonSharedParams::update_url)& update_url(
      const ::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr& input) {
    return input->update_url;
  }

  static const decltype(::auction_worklet::mojom::BidderWorkletNonSharedParams::trusted_bidding_signals_keys)& trusted_bidding_signals_keys(
      const ::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr& input) {
    return input->trusted_bidding_signals_keys;
  }

  static decltype(::auction_worklet::mojom::BidderWorkletNonSharedParams::max_trusted_bidding_signals_url_length) max_trusted_bidding_signals_url_length(
      const ::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr& input) {
    return input->max_trusted_bidding_signals_url_length;
  }

  static const decltype(::auction_worklet::mojom::BidderWorkletNonSharedParams::user_bidding_signals)& user_bidding_signals(
      const ::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr& input) {
    return input->user_bidding_signals;
  }

  static const decltype(::auction_worklet::mojom::BidderWorkletNonSharedParams::ads)& ads(
      const ::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr& input) {
    return input->ads;
  }

  static const decltype(::auction_worklet::mojom::BidderWorkletNonSharedParams::ad_components)& ad_components(
      const ::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr& input) {
    return input->ad_components;
  }

  static const decltype(::auction_worklet::mojom::BidderWorkletNonSharedParams::kanon_keys)& kanon_keys(
      const ::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr& input) {
    return input->kanon_keys;
  }

  static bool Read(::auction_worklet::mojom::BidderWorkletNonSharedParams::DataView input, ::auction_worklet::mojom::BidderWorkletNonSharedParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::BidderWorkletBid::DataView,
                                         ::auction_worklet::mojom::BidderWorkletBidPtr> {
  static bool IsNull(const ::auction_worklet::mojom::BidderWorkletBidPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::BidderWorkletBidPtr* output) { output->reset(); }

  static decltype(::auction_worklet::mojom::BidderWorkletBid::bid_role) bid_role(
      const ::auction_worklet::mojom::BidderWorkletBidPtr& input) {
    return input->bid_role;
  }

  static const decltype(::auction_worklet::mojom::BidderWorkletBid::ad)& ad(
      const ::auction_worklet::mojom::BidderWorkletBidPtr& input) {
    return input->ad;
  }

  static decltype(::auction_worklet::mojom::BidderWorkletBid::bid) bid(
      const ::auction_worklet::mojom::BidderWorkletBidPtr& input) {
    return input->bid;
  }

  static const decltype(::auction_worklet::mojom::BidderWorkletBid::bid_currency)& bid_currency(
      const ::auction_worklet::mojom::BidderWorkletBidPtr& input) {
    return input->bid_currency;
  }

  static decltype(::auction_worklet::mojom::BidderWorkletBid::ad_cost) ad_cost(
      const ::auction_worklet::mojom::BidderWorkletBidPtr& input) {
    return input->ad_cost;
  }

  static const decltype(::auction_worklet::mojom::BidderWorkletBid::ad_descriptor)& ad_descriptor(
      const ::auction_worklet::mojom::BidderWorkletBidPtr& input) {
    return input->ad_descriptor;
  }

  static const decltype(::auction_worklet::mojom::BidderWorkletBid::selected_buyer_and_seller_reporting_id)& selected_buyer_and_seller_reporting_id(
      const ::auction_worklet::mojom::BidderWorkletBidPtr& input) {
    return input->selected_buyer_and_seller_reporting_id;
  }

  static const decltype(::auction_worklet::mojom::BidderWorkletBid::ad_component_descriptors)& ad_component_descriptors(
      const ::auction_worklet::mojom::BidderWorkletBidPtr& input) {
    return input->ad_component_descriptors;
  }

  static decltype(::auction_worklet::mojom::BidderWorkletBid::modeling_signals) modeling_signals(
      const ::auction_worklet::mojom::BidderWorkletBidPtr& input) {
    return input->modeling_signals;
  }

  static const decltype(::auction_worklet::mojom::BidderWorkletBid::aggregate_win_signals)& aggregate_win_signals(
      const ::auction_worklet::mojom::BidderWorkletBidPtr& input) {
    return input->aggregate_win_signals;
  }

  static const decltype(::auction_worklet::mojom::BidderWorkletBid::bid_duration)& bid_duration(
      const ::auction_worklet::mojom::BidderWorkletBidPtr& input) {
    return input->bid_duration;
  }

  static bool Read(::auction_worklet::mojom::BidderWorkletBid::DataView input, ::auction_worklet::mojom::BidderWorkletBidPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::PrioritySignalsDouble::DataView,
                                         ::auction_worklet::mojom::PrioritySignalsDoublePtr> {
  static bool IsNull(const ::auction_worklet::mojom::PrioritySignalsDoublePtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::PrioritySignalsDoublePtr* output) { output->reset(); }

  static decltype(::auction_worklet::mojom::PrioritySignalsDouble::value) value(
      const ::auction_worklet::mojom::PrioritySignalsDoublePtr& input) {
    return input->value;
  }

  static bool Read(::auction_worklet::mojom::PrioritySignalsDouble::DataView input, ::auction_worklet::mojom::PrioritySignalsDoublePtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::GenerateBidDependencyLatencies::DataView,
                                         ::auction_worklet::mojom::GenerateBidDependencyLatenciesPtr> {
  static bool IsNull(const ::auction_worklet::mojom::GenerateBidDependencyLatenciesPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::GenerateBidDependencyLatenciesPtr* output) { output->reset(); }

  static const decltype(::auction_worklet::mojom::GenerateBidDependencyLatencies::code_ready_latency)& code_ready_latency(
      const ::auction_worklet::mojom::GenerateBidDependencyLatenciesPtr& input) {
    return input->code_ready_latency;
  }

  static const decltype(::auction_worklet::mojom::GenerateBidDependencyLatencies::config_promises_latency)& config_promises_latency(
      const ::auction_worklet::mojom::GenerateBidDependencyLatenciesPtr& input) {
    return input->config_promises_latency;
  }

  static const decltype(::auction_worklet::mojom::GenerateBidDependencyLatencies::direct_from_seller_signals_latency)& direct_from_seller_signals_latency(
      const ::auction_worklet::mojom::GenerateBidDependencyLatenciesPtr& input) {
    return input->direct_from_seller_signals_latency;
  }

  static const decltype(::auction_worklet::mojom::GenerateBidDependencyLatencies::trusted_bidding_signals_latency)& trusted_bidding_signals_latency(
      const ::auction_worklet::mojom::GenerateBidDependencyLatenciesPtr& input) {
    return input->trusted_bidding_signals_latency;
  }

  static const decltype(::auction_worklet::mojom::GenerateBidDependencyLatencies::deps_wait_start_time)& deps_wait_start_time(
      const ::auction_worklet::mojom::GenerateBidDependencyLatenciesPtr& input) {
    return input->deps_wait_start_time;
  }

  static const decltype(::auction_worklet::mojom::GenerateBidDependencyLatencies::generate_bid_start_time)& generate_bid_start_time(
      const ::auction_worklet::mojom::GenerateBidDependencyLatenciesPtr& input) {
    return input->generate_bid_start_time;
  }

  static const decltype(::auction_worklet::mojom::GenerateBidDependencyLatencies::generate_bid_finish_time)& generate_bid_finish_time(
      const ::auction_worklet::mojom::GenerateBidDependencyLatenciesPtr& input) {
    return input->generate_bid_finish_time;
  }

  static bool Read(::auction_worklet::mojom::GenerateBidDependencyLatencies::DataView input, ::auction_worklet::mojom::GenerateBidDependencyLatenciesPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::BidderTimingMetrics::DataView,
                                         ::auction_worklet::mojom::BidderTimingMetricsPtr> {
  static bool IsNull(const ::auction_worklet::mojom::BidderTimingMetricsPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::BidderTimingMetricsPtr* output) { output->reset(); }

  static const decltype(::auction_worklet::mojom::BidderTimingMetrics::js_fetch_latency)& js_fetch_latency(
      const ::auction_worklet::mojom::BidderTimingMetricsPtr& input) {
    return input->js_fetch_latency;
  }

  static const decltype(::auction_worklet::mojom::BidderTimingMetrics::wasm_fetch_latency)& wasm_fetch_latency(
      const ::auction_worklet::mojom::BidderTimingMetricsPtr& input) {
    return input->wasm_fetch_latency;
  }

  static const decltype(::auction_worklet::mojom::BidderTimingMetrics::script_latency)& script_latency(
      const ::auction_worklet::mojom::BidderTimingMetricsPtr& input) {
    return input->script_latency;
  }

  static decltype(::auction_worklet::mojom::BidderTimingMetrics::script_timed_out) script_timed_out(
      const ::auction_worklet::mojom::BidderTimingMetricsPtr& input) {
    return input->script_timed_out;
  }

  static bool Read(::auction_worklet::mojom::BidderTimingMetrics::DataView input, ::auction_worklet::mojom::BidderTimingMetricsPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_H_