// content/common/renderer_variations_configuration.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDERER_VARIATIONS_CONFIGURATION_MOJOM_H_
#define CONTENT_COMMON_RENDERER_VARIATIONS_CONFIGURATION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/renderer_variations_configuration.mojom-features.h"  // IWYU pragma: export
#include "content/common/renderer_variations_configuration.mojom-shared.h"  // IWYU pragma: export
#include "content/common/renderer_variations_configuration.mojom-forward.h"  // IWYU pragma: export
#include "components/variations/variations.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace content::mojom {

class RendererVariationsConfigurationProxy;

template <typename ImplRefTraits>
class RendererVariationsConfigurationStub;

class RendererVariationsConfigurationRequestValidator;


class CONTENT_EXPORT RendererVariationsConfiguration
    : public RendererVariationsConfigurationInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RendererVariationsConfigurationInterfaceBase;
  using Proxy_ = RendererVariationsConfigurationProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererVariationsConfigurationStub<ImplRefTraits>;

  using RequestValidator_ = RendererVariationsConfigurationRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetVariationsHeadersMinVersion = 0,
    kSetFieldTrialGroupMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetVariationsHeaders_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetFieldTrialGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RendererVariationsConfiguration() = default;

  
  virtual void SetVariationsHeaders(::variations::mojom::VariationsHeadersPtr variations_headers) = 0;

  
  virtual void SetFieldTrialGroup(const std::string& trial_name, const std::string& group_name) = 0;
};



class CONTENT_EXPORT RendererVariationsConfigurationProxy
    : public RendererVariationsConfiguration {
 public:
  using InterfaceType = RendererVariationsConfiguration;

  explicit RendererVariationsConfigurationProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetVariationsHeaders(::variations::mojom::VariationsHeadersPtr variations_headers) final;
  
  void SetFieldTrialGroup(const std::string& trial_name, const std::string& group_name) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT RendererVariationsConfigurationStubDispatch {
 public:
  static bool Accept(RendererVariationsConfiguration* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RendererVariationsConfiguration* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RendererVariationsConfiguration>>
class RendererVariationsConfigurationStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererVariationsConfigurationStub() = default;
  ~RendererVariationsConfigurationStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererVariationsConfigurationStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererVariationsConfigurationStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT RendererVariationsConfigurationRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // content::mojom

namespace mojo {

}  // namespace mojo

#endif  // CONTENT_COMMON_RENDERER_VARIATIONS_CONFIGURATION_MOJOM_H_