// content/common/input/input_injector.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_INPUT_INPUT_INJECTOR_MOJOM_H_
#define CONTENT_COMMON_INPUT_INPUT_INJECTOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/input/input_injector.mojom-features.h"  // IWYU pragma: export
#include "content/common/input/input_injector.mojom-shared.h"  // IWYU pragma: export
#include "content/common/input/input_injector.mojom-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/events/mojom/scroll_granularity.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "content/common/frame_owner_element_type_mojom_traits.h"
#include "content/common/input/input_injector_mojom_traits.h"
#include "content/common/input/synthetic_pinch_gesture_params.h"
#include "content/common/input/synthetic_pointer_action_list_params.h"
#include "content/common/input/synthetic_smooth_drag_gesture_params.h"
#include "content/common/input/synthetic_smooth_scroll_gesture_params.h"
#include "content/common/input/synthetic_tap_gesture_params.h"
#include "content/common/navigation_gesture.h"
#include "net/base/network_change_notifier.h"
#include "third_party/blink/public/common/navigation/impression.h"
#include "third_party/blink/public/common/widget/visual_properties.h"
#include "ui/events/types/scroll_types.h"
#include "ui/native_theme/native_theme.h"
#include "content/common/content_export.h"




namespace content::mojom {

class InputInjectorProxy;

template <typename ImplRefTraits>
class InputInjectorStub;

class InputInjectorRequestValidator;
class InputInjectorResponseValidator;


class CONTENT_EXPORT InputInjector
    : public InputInjectorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = InputInjectorInterfaceBase;
  using Proxy_ = InputInjectorProxy;

  template <typename ImplRefTraits>
  using Stub_ = InputInjectorStub<ImplRefTraits>;

  using RequestValidator_ = InputInjectorRequestValidator;
  using ResponseValidator_ = InputInjectorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kQueueSyntheticSmoothDragMinVersion = 0,
    kQueueSyntheticSmoothScrollMinVersion = 0,
    kQueueSyntheticPinchMinVersion = 0,
    kQueueSyntheticTapMinVersion = 0,
    kQueueSyntheticPointerActionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct QueueSyntheticSmoothDrag_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueueSyntheticSmoothScroll_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueueSyntheticPinch_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueueSyntheticTap_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueueSyntheticPointerAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~InputInjector() = default;


  using QueueSyntheticSmoothDragCallback = base::OnceCallback<void()>;
  
  virtual void QueueSyntheticSmoothDrag(const ::content::SyntheticSmoothDragGestureParams& drag, QueueSyntheticSmoothDragCallback callback) = 0;


  using QueueSyntheticSmoothScrollCallback = base::OnceCallback<void()>;
  
  virtual void QueueSyntheticSmoothScroll(const ::content::SyntheticSmoothScrollGestureParams& scroll, QueueSyntheticSmoothScrollCallback callback) = 0;


  using QueueSyntheticPinchCallback = base::OnceCallback<void()>;
  
  virtual void QueueSyntheticPinch(const ::content::SyntheticPinchGestureParams& pinch, QueueSyntheticPinchCallback callback) = 0;


  using QueueSyntheticTapCallback = base::OnceCallback<void()>;
  
  virtual void QueueSyntheticTap(const ::content::SyntheticTapGestureParams& tap, QueueSyntheticTapCallback callback) = 0;


  using QueueSyntheticPointerActionCallback = base::OnceCallback<void()>;
  
  virtual void QueueSyntheticPointerAction(const ::content::SyntheticPointerActionListParams& pointer_action, QueueSyntheticPointerActionCallback callback) = 0;
};



class CONTENT_EXPORT InputInjectorProxy
    : public InputInjector {
 public:
  using InterfaceType = InputInjector;

  explicit InputInjectorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void QueueSyntheticSmoothDrag(const ::content::SyntheticSmoothDragGestureParams& drag, QueueSyntheticSmoothDragCallback callback) final;
  
  void QueueSyntheticSmoothScroll(const ::content::SyntheticSmoothScrollGestureParams& scroll, QueueSyntheticSmoothScrollCallback callback) final;
  
  void QueueSyntheticPinch(const ::content::SyntheticPinchGestureParams& pinch, QueueSyntheticPinchCallback callback) final;
  
  void QueueSyntheticTap(const ::content::SyntheticTapGestureParams& tap, QueueSyntheticTapCallback callback) final;
  
  void QueueSyntheticPointerAction(const ::content::SyntheticPointerActionListParams& pointer_action, QueueSyntheticPointerActionCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT InputInjectorStubDispatch {
 public:
  static bool Accept(InputInjector* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      InputInjector* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<InputInjector>>
class InputInjectorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  InputInjectorStub() = default;
  ~InputInjectorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return InputInjectorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return InputInjectorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT InputInjectorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT InputInjectorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};













class CONTENT_EXPORT SyntheticSmoothDrag {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SyntheticSmoothDrag, T>::value>;
  using DataView = SyntheticSmoothDragDataView;
  using Data_ = internal::SyntheticSmoothDrag_Data;

  template <typename... Args>
  static SyntheticSmoothDragPtr New(Args&&... args) {
    return SyntheticSmoothDragPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SyntheticSmoothDragPtr From(const U& u) {
    return mojo::TypeConverter<SyntheticSmoothDragPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SyntheticSmoothDrag>::Convert(*this);
  }


  SyntheticSmoothDrag();

  SyntheticSmoothDrag(
      GestureSourceType gesture_source_type,
      const ::gfx::PointF& start_point,
      std::vector<::gfx::Vector2dF> distances,
      float speed_in_pixels_s,
      float vsync_offset_ms,
      InputEventPattern input_event_pattern);


  ~SyntheticSmoothDrag();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SyntheticSmoothDragPtr>
  SyntheticSmoothDragPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SyntheticSmoothDrag::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SyntheticSmoothDrag::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SyntheticSmoothDrag::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SyntheticSmoothDrag::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SyntheticSmoothDrag::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SyntheticSmoothDrag_UnserializedMessageContext<
            UserType, SyntheticSmoothDrag::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SyntheticSmoothDrag::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SyntheticSmoothDrag::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SyntheticSmoothDrag_UnserializedMessageContext<
            UserType, SyntheticSmoothDrag::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SyntheticSmoothDrag::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  GestureSourceType gesture_source_type;
  
  ::gfx::PointF start_point;
  
  std::vector<::gfx::Vector2dF> distances;
  
  float speed_in_pixels_s;
  
  float vsync_offset_ms;
  
  InputEventPattern input_event_pattern;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SyntheticSmoothDrag::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SyntheticSmoothDrag::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SyntheticSmoothDrag::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SyntheticSmoothDrag::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT SyntheticSmoothScroll {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SyntheticSmoothScroll, T>::value>;
  using DataView = SyntheticSmoothScrollDataView;
  using Data_ = internal::SyntheticSmoothScroll_Data;

  template <typename... Args>
  static SyntheticSmoothScrollPtr New(Args&&... args) {
    return SyntheticSmoothScrollPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SyntheticSmoothScrollPtr From(const U& u) {
    return mojo::TypeConverter<SyntheticSmoothScrollPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SyntheticSmoothScroll>::Convert(*this);
  }


  SyntheticSmoothScroll();

  SyntheticSmoothScroll(
      GestureSourceType gesture_source_type,
      const ::gfx::PointF& anchor,
      std::vector<::gfx::Vector2dF> distances,
      bool prevent_fling,
      float speed_in_pixels_s,
      float fling_velocity_x,
      float fling_velocity_y,
      ::ui::ScrollGranularity granularity,
      int32_t modifiers,
      float vsync_offset_ms,
      InputEventPattern input_event_pattern);


  ~SyntheticSmoothScroll();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SyntheticSmoothScrollPtr>
  SyntheticSmoothScrollPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SyntheticSmoothScroll::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SyntheticSmoothScroll::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SyntheticSmoothScroll::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SyntheticSmoothScroll::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SyntheticSmoothScroll::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SyntheticSmoothScroll_UnserializedMessageContext<
            UserType, SyntheticSmoothScroll::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SyntheticSmoothScroll::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SyntheticSmoothScroll::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SyntheticSmoothScroll_UnserializedMessageContext<
            UserType, SyntheticSmoothScroll::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SyntheticSmoothScroll::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  GestureSourceType gesture_source_type;
  
  ::gfx::PointF anchor;
  
  std::vector<::gfx::Vector2dF> distances;
  
  bool prevent_fling;
  
  float speed_in_pixels_s;
  
  float fling_velocity_x;
  
  float fling_velocity_y;
  
  ::ui::ScrollGranularity granularity;
  
  int32_t modifiers;
  
  float vsync_offset_ms;
  
  InputEventPattern input_event_pattern;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SyntheticSmoothScroll::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SyntheticSmoothScroll::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SyntheticSmoothScroll::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SyntheticSmoothScroll::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT SyntheticPinch {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SyntheticPinch, T>::value>;
  using DataView = SyntheticPinchDataView;
  using Data_ = internal::SyntheticPinch_Data;

  template <typename... Args>
  static SyntheticPinchPtr New(Args&&... args) {
    return SyntheticPinchPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SyntheticPinchPtr From(const U& u) {
    return mojo::TypeConverter<SyntheticPinchPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SyntheticPinch>::Convert(*this);
  }


  SyntheticPinch();

  SyntheticPinch(
      float scale_factor,
      const ::gfx::PointF& anchor,
      float relative_pointer_speed_in_pixels_s,
      float vsync_offset_ms,
      InputEventPattern input_event_pattern);


  ~SyntheticPinch();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SyntheticPinchPtr>
  SyntheticPinchPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SyntheticPinch::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SyntheticPinch::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SyntheticPinch::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SyntheticPinch::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SyntheticPinch::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SyntheticPinch_UnserializedMessageContext<
            UserType, SyntheticPinch::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SyntheticPinch::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SyntheticPinch::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SyntheticPinch_UnserializedMessageContext<
            UserType, SyntheticPinch::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SyntheticPinch::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float scale_factor;
  
  ::gfx::PointF anchor;
  
  float relative_pointer_speed_in_pixels_s;
  
  float vsync_offset_ms;
  
  InputEventPattern input_event_pattern;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SyntheticPinch::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SyntheticPinch::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SyntheticPinch::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SyntheticPinch::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT SyntheticTap {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SyntheticTap, T>::value>;
  using DataView = SyntheticTapDataView;
  using Data_ = internal::SyntheticTap_Data;

  template <typename... Args>
  static SyntheticTapPtr New(Args&&... args) {
    return SyntheticTapPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SyntheticTapPtr From(const U& u) {
    return mojo::TypeConverter<SyntheticTapPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SyntheticTap>::Convert(*this);
  }


  SyntheticTap();

  SyntheticTap(
      GestureSourceType gesture_source_type,
      const ::gfx::PointF& position,
      float duration_ms);


  ~SyntheticTap();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SyntheticTapPtr>
  SyntheticTapPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SyntheticTap::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SyntheticTap::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SyntheticTap::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SyntheticTap::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SyntheticTap::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SyntheticTap_UnserializedMessageContext<
            UserType, SyntheticTap::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SyntheticTap::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SyntheticTap::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SyntheticTap_UnserializedMessageContext<
            UserType, SyntheticTap::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SyntheticTap::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  GestureSourceType gesture_source_type;
  
  ::gfx::PointF position;
  
  float duration_ms;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SyntheticTap::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SyntheticTap::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SyntheticTap::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SyntheticTap::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT SyntheticPointerActionParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SyntheticPointerActionParams, T>::value>;
  using DataView = SyntheticPointerActionParamsDataView;
  using Data_ = internal::SyntheticPointerActionParams_Data;

  template <typename... Args>
  static SyntheticPointerActionParamsPtr New(Args&&... args) {
    return SyntheticPointerActionParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SyntheticPointerActionParamsPtr From(const U& u) {
    return mojo::TypeConverter<SyntheticPointerActionParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SyntheticPointerActionParams>::Convert(*this);
  }


  SyntheticPointerActionParams();

  SyntheticPointerActionParams(
      PointerActionType pointer_action_type,
      const ::gfx::PointF& position,
      uint32_t pointer_id,
      SyntheticButton button,
      int32_t key_modifiers,
      float width,
      float height,
      float rotation_angle,
      float force,
      float tangential_pressure,
      int32_t tilt_x,
      int32_t tilt_y,
      ::base::TimeTicks timestamp,
      ::base::TimeDelta duration);


  ~SyntheticPointerActionParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SyntheticPointerActionParamsPtr>
  SyntheticPointerActionParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SyntheticPointerActionParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SyntheticPointerActionParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SyntheticPointerActionParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SyntheticPointerActionParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SyntheticPointerActionParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SyntheticPointerActionParams_UnserializedMessageContext<
            UserType, SyntheticPointerActionParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SyntheticPointerActionParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SyntheticPointerActionParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SyntheticPointerActionParams_UnserializedMessageContext<
            UserType, SyntheticPointerActionParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SyntheticPointerActionParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PointerActionType pointer_action_type;
  
  ::gfx::PointF position;
  
  uint32_t pointer_id;
  
  SyntheticButton button;
  
  int32_t key_modifiers;
  
  float width;
  
  float height;
  
  float rotation_angle;
  
  float force;
  
  float tangential_pressure;
  
  int32_t tilt_x;
  
  int32_t tilt_y;
  
  ::base::TimeTicks timestamp;
  
  ::base::TimeDelta duration;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SyntheticPointerActionParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SyntheticPointerActionParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SyntheticPointerActionParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SyntheticPointerActionParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT SyntheticPointerAction {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SyntheticPointerAction, T>::value>;
  using DataView = SyntheticPointerActionDataView;
  using Data_ = internal::SyntheticPointerAction_Data;

  template <typename... Args>
  static SyntheticPointerActionPtr New(Args&&... args) {
    return SyntheticPointerActionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SyntheticPointerActionPtr From(const U& u) {
    return mojo::TypeConverter<SyntheticPointerActionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SyntheticPointerAction>::Convert(*this);
  }


  SyntheticPointerAction();

  SyntheticPointerAction(
      GestureSourceType gesture_source_type,
      std::vector<std::vector<SyntheticPointerActionParamsPtr>> params);

SyntheticPointerAction(const SyntheticPointerAction&) = delete;
SyntheticPointerAction& operator=(const SyntheticPointerAction&) = delete;

  ~SyntheticPointerAction();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SyntheticPointerActionPtr>
  SyntheticPointerActionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SyntheticPointerAction::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SyntheticPointerAction::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SyntheticPointerAction::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SyntheticPointerAction::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SyntheticPointerAction::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SyntheticPointerAction_UnserializedMessageContext<
            UserType, SyntheticPointerAction::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SyntheticPointerAction::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SyntheticPointerAction::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SyntheticPointerAction_UnserializedMessageContext<
            UserType, SyntheticPointerAction::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SyntheticPointerAction::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  GestureSourceType gesture_source_type;
  
  std::vector<std::vector<SyntheticPointerActionParamsPtr>> params;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SyntheticPointerAction::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SyntheticPointerAction::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SyntheticPointerAction::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SyntheticPointerAction::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SyntheticSmoothDragPtr SyntheticSmoothDrag::Clone() const {
  return New(
      mojo::Clone(gesture_source_type),
      mojo::Clone(start_point),
      mojo::Clone(distances),
      mojo::Clone(speed_in_pixels_s),
      mojo::Clone(vsync_offset_ms),
      mojo::Clone(input_event_pattern)
  );
}

template <typename T, SyntheticSmoothDrag::EnableIfSame<T>*>
bool SyntheticSmoothDrag::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->gesture_source_type, other_struct.gesture_source_type))
    return false;
  if (!mojo::Equals(this->start_point, other_struct.start_point))
    return false;
  if (!mojo::Equals(this->distances, other_struct.distances))
    return false;
  if (!mojo::Equals(this->speed_in_pixels_s, other_struct.speed_in_pixels_s))
    return false;
  if (!mojo::Equals(this->vsync_offset_ms, other_struct.vsync_offset_ms))
    return false;
  if (!mojo::Equals(this->input_event_pattern, other_struct.input_event_pattern))
    return false;
  return true;
}

template <typename T, SyntheticSmoothDrag::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.gesture_source_type < rhs.gesture_source_type)
    return true;
  if (rhs.gesture_source_type < lhs.gesture_source_type)
    return false;
  if (lhs.start_point < rhs.start_point)
    return true;
  if (rhs.start_point < lhs.start_point)
    return false;
  if (lhs.distances < rhs.distances)
    return true;
  if (rhs.distances < lhs.distances)
    return false;
  if (lhs.speed_in_pixels_s < rhs.speed_in_pixels_s)
    return true;
  if (rhs.speed_in_pixels_s < lhs.speed_in_pixels_s)
    return false;
  if (lhs.vsync_offset_ms < rhs.vsync_offset_ms)
    return true;
  if (rhs.vsync_offset_ms < lhs.vsync_offset_ms)
    return false;
  if (lhs.input_event_pattern < rhs.input_event_pattern)
    return true;
  if (rhs.input_event_pattern < lhs.input_event_pattern)
    return false;
  return false;
}
template <typename StructPtrType>
SyntheticSmoothScrollPtr SyntheticSmoothScroll::Clone() const {
  return New(
      mojo::Clone(gesture_source_type),
      mojo::Clone(anchor),
      mojo::Clone(distances),
      mojo::Clone(prevent_fling),
      mojo::Clone(speed_in_pixels_s),
      mojo::Clone(fling_velocity_x),
      mojo::Clone(fling_velocity_y),
      mojo::Clone(granularity),
      mojo::Clone(modifiers),
      mojo::Clone(vsync_offset_ms),
      mojo::Clone(input_event_pattern)
  );
}

template <typename T, SyntheticSmoothScroll::EnableIfSame<T>*>
bool SyntheticSmoothScroll::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->gesture_source_type, other_struct.gesture_source_type))
    return false;
  if (!mojo::Equals(this->anchor, other_struct.anchor))
    return false;
  if (!mojo::Equals(this->distances, other_struct.distances))
    return false;
  if (!mojo::Equals(this->prevent_fling, other_struct.prevent_fling))
    return false;
  if (!mojo::Equals(this->speed_in_pixels_s, other_struct.speed_in_pixels_s))
    return false;
  if (!mojo::Equals(this->fling_velocity_x, other_struct.fling_velocity_x))
    return false;
  if (!mojo::Equals(this->fling_velocity_y, other_struct.fling_velocity_y))
    return false;
  if (!mojo::Equals(this->granularity, other_struct.granularity))
    return false;
  if (!mojo::Equals(this->modifiers, other_struct.modifiers))
    return false;
  if (!mojo::Equals(this->vsync_offset_ms, other_struct.vsync_offset_ms))
    return false;
  if (!mojo::Equals(this->input_event_pattern, other_struct.input_event_pattern))
    return false;
  return true;
}

template <typename T, SyntheticSmoothScroll::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.gesture_source_type < rhs.gesture_source_type)
    return true;
  if (rhs.gesture_source_type < lhs.gesture_source_type)
    return false;
  if (lhs.anchor < rhs.anchor)
    return true;
  if (rhs.anchor < lhs.anchor)
    return false;
  if (lhs.distances < rhs.distances)
    return true;
  if (rhs.distances < lhs.distances)
    return false;
  if (lhs.prevent_fling < rhs.prevent_fling)
    return true;
  if (rhs.prevent_fling < lhs.prevent_fling)
    return false;
  if (lhs.speed_in_pixels_s < rhs.speed_in_pixels_s)
    return true;
  if (rhs.speed_in_pixels_s < lhs.speed_in_pixels_s)
    return false;
  if (lhs.fling_velocity_x < rhs.fling_velocity_x)
    return true;
  if (rhs.fling_velocity_x < lhs.fling_velocity_x)
    return false;
  if (lhs.fling_velocity_y < rhs.fling_velocity_y)
    return true;
  if (rhs.fling_velocity_y < lhs.fling_velocity_y)
    return false;
  if (lhs.granularity < rhs.granularity)
    return true;
  if (rhs.granularity < lhs.granularity)
    return false;
  if (lhs.modifiers < rhs.modifiers)
    return true;
  if (rhs.modifiers < lhs.modifiers)
    return false;
  if (lhs.vsync_offset_ms < rhs.vsync_offset_ms)
    return true;
  if (rhs.vsync_offset_ms < lhs.vsync_offset_ms)
    return false;
  if (lhs.input_event_pattern < rhs.input_event_pattern)
    return true;
  if (rhs.input_event_pattern < lhs.input_event_pattern)
    return false;
  return false;
}
template <typename StructPtrType>
SyntheticPinchPtr SyntheticPinch::Clone() const {
  return New(
      mojo::Clone(scale_factor),
      mojo::Clone(anchor),
      mojo::Clone(relative_pointer_speed_in_pixels_s),
      mojo::Clone(vsync_offset_ms),
      mojo::Clone(input_event_pattern)
  );
}

template <typename T, SyntheticPinch::EnableIfSame<T>*>
bool SyntheticPinch::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scale_factor, other_struct.scale_factor))
    return false;
  if (!mojo::Equals(this->anchor, other_struct.anchor))
    return false;
  if (!mojo::Equals(this->relative_pointer_speed_in_pixels_s, other_struct.relative_pointer_speed_in_pixels_s))
    return false;
  if (!mojo::Equals(this->vsync_offset_ms, other_struct.vsync_offset_ms))
    return false;
  if (!mojo::Equals(this->input_event_pattern, other_struct.input_event_pattern))
    return false;
  return true;
}

template <typename T, SyntheticPinch::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scale_factor < rhs.scale_factor)
    return true;
  if (rhs.scale_factor < lhs.scale_factor)
    return false;
  if (lhs.anchor < rhs.anchor)
    return true;
  if (rhs.anchor < lhs.anchor)
    return false;
  if (lhs.relative_pointer_speed_in_pixels_s < rhs.relative_pointer_speed_in_pixels_s)
    return true;
  if (rhs.relative_pointer_speed_in_pixels_s < lhs.relative_pointer_speed_in_pixels_s)
    return false;
  if (lhs.vsync_offset_ms < rhs.vsync_offset_ms)
    return true;
  if (rhs.vsync_offset_ms < lhs.vsync_offset_ms)
    return false;
  if (lhs.input_event_pattern < rhs.input_event_pattern)
    return true;
  if (rhs.input_event_pattern < lhs.input_event_pattern)
    return false;
  return false;
}
template <typename StructPtrType>
SyntheticTapPtr SyntheticTap::Clone() const {
  return New(
      mojo::Clone(gesture_source_type),
      mojo::Clone(position),
      mojo::Clone(duration_ms)
  );
}

template <typename T, SyntheticTap::EnableIfSame<T>*>
bool SyntheticTap::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->gesture_source_type, other_struct.gesture_source_type))
    return false;
  if (!mojo::Equals(this->position, other_struct.position))
    return false;
  if (!mojo::Equals(this->duration_ms, other_struct.duration_ms))
    return false;
  return true;
}

template <typename T, SyntheticTap::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.gesture_source_type < rhs.gesture_source_type)
    return true;
  if (rhs.gesture_source_type < lhs.gesture_source_type)
    return false;
  if (lhs.position < rhs.position)
    return true;
  if (rhs.position < lhs.position)
    return false;
  if (lhs.duration_ms < rhs.duration_ms)
    return true;
  if (rhs.duration_ms < lhs.duration_ms)
    return false;
  return false;
}
template <typename StructPtrType>
SyntheticPointerActionParamsPtr SyntheticPointerActionParams::Clone() const {
  return New(
      mojo::Clone(pointer_action_type),
      mojo::Clone(position),
      mojo::Clone(pointer_id),
      mojo::Clone(button),
      mojo::Clone(key_modifiers),
      mojo::Clone(width),
      mojo::Clone(height),
      mojo::Clone(rotation_angle),
      mojo::Clone(force),
      mojo::Clone(tangential_pressure),
      mojo::Clone(tilt_x),
      mojo::Clone(tilt_y),
      mojo::Clone(timestamp),
      mojo::Clone(duration)
  );
}

template <typename T, SyntheticPointerActionParams::EnableIfSame<T>*>
bool SyntheticPointerActionParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->pointer_action_type, other_struct.pointer_action_type))
    return false;
  if (!mojo::Equals(this->position, other_struct.position))
    return false;
  if (!mojo::Equals(this->pointer_id, other_struct.pointer_id))
    return false;
  if (!mojo::Equals(this->button, other_struct.button))
    return false;
  if (!mojo::Equals(this->key_modifiers, other_struct.key_modifiers))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->rotation_angle, other_struct.rotation_angle))
    return false;
  if (!mojo::Equals(this->force, other_struct.force))
    return false;
  if (!mojo::Equals(this->tangential_pressure, other_struct.tangential_pressure))
    return false;
  if (!mojo::Equals(this->tilt_x, other_struct.tilt_x))
    return false;
  if (!mojo::Equals(this->tilt_y, other_struct.tilt_y))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->duration, other_struct.duration))
    return false;
  return true;
}

template <typename T, SyntheticPointerActionParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.pointer_action_type < rhs.pointer_action_type)
    return true;
  if (rhs.pointer_action_type < lhs.pointer_action_type)
    return false;
  if (lhs.position < rhs.position)
    return true;
  if (rhs.position < lhs.position)
    return false;
  if (lhs.pointer_id < rhs.pointer_id)
    return true;
  if (rhs.pointer_id < lhs.pointer_id)
    return false;
  if (lhs.button < rhs.button)
    return true;
  if (rhs.button < lhs.button)
    return false;
  if (lhs.key_modifiers < rhs.key_modifiers)
    return true;
  if (rhs.key_modifiers < lhs.key_modifiers)
    return false;
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  if (lhs.rotation_angle < rhs.rotation_angle)
    return true;
  if (rhs.rotation_angle < lhs.rotation_angle)
    return false;
  if (lhs.force < rhs.force)
    return true;
  if (rhs.force < lhs.force)
    return false;
  if (lhs.tangential_pressure < rhs.tangential_pressure)
    return true;
  if (rhs.tangential_pressure < lhs.tangential_pressure)
    return false;
  if (lhs.tilt_x < rhs.tilt_x)
    return true;
  if (rhs.tilt_x < lhs.tilt_x)
    return false;
  if (lhs.tilt_y < rhs.tilt_y)
    return true;
  if (rhs.tilt_y < lhs.tilt_y)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.duration < rhs.duration)
    return true;
  if (rhs.duration < lhs.duration)
    return false;
  return false;
}
template <typename StructPtrType>
SyntheticPointerActionPtr SyntheticPointerAction::Clone() const {
  return New(
      mojo::Clone(gesture_source_type),
      mojo::Clone(params)
  );
}

template <typename T, SyntheticPointerAction::EnableIfSame<T>*>
bool SyntheticPointerAction::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->gesture_source_type, other_struct.gesture_source_type))
    return false;
  if (!mojo::Equals(this->params, other_struct.params))
    return false;
  return true;
}

template <typename T, SyntheticPointerAction::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.gesture_source_type < rhs.gesture_source_type)
    return true;
  if (rhs.gesture_source_type < lhs.gesture_source_type)
    return false;
  if (lhs.params < rhs.params)
    return true;
  if (rhs.params < lhs.params)
    return false;
  return false;
}


}  // content::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::SyntheticSmoothDrag::DataView,
                                         ::content::mojom::SyntheticSmoothDragPtr> {
  static bool IsNull(const ::content::mojom::SyntheticSmoothDragPtr& input) { return !input; }
  static void SetToNull(::content::mojom::SyntheticSmoothDragPtr* output) { output->reset(); }

  static decltype(::content::mojom::SyntheticSmoothDrag::gesture_source_type) gesture_source_type(
      const ::content::mojom::SyntheticSmoothDragPtr& input) {
    return input->gesture_source_type;
  }

  static const decltype(::content::mojom::SyntheticSmoothDrag::start_point)& start_point(
      const ::content::mojom::SyntheticSmoothDragPtr& input) {
    return input->start_point;
  }

  static const decltype(::content::mojom::SyntheticSmoothDrag::distances)& distances(
      const ::content::mojom::SyntheticSmoothDragPtr& input) {
    return input->distances;
  }

  static decltype(::content::mojom::SyntheticSmoothDrag::speed_in_pixels_s) speed_in_pixels_s(
      const ::content::mojom::SyntheticSmoothDragPtr& input) {
    return input->speed_in_pixels_s;
  }

  static decltype(::content::mojom::SyntheticSmoothDrag::vsync_offset_ms) vsync_offset_ms(
      const ::content::mojom::SyntheticSmoothDragPtr& input) {
    return input->vsync_offset_ms;
  }

  static decltype(::content::mojom::SyntheticSmoothDrag::input_event_pattern) input_event_pattern(
      const ::content::mojom::SyntheticSmoothDragPtr& input) {
    return input->input_event_pattern;
  }

  static bool Read(::content::mojom::SyntheticSmoothDrag::DataView input, ::content::mojom::SyntheticSmoothDragPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::SyntheticSmoothScroll::DataView,
                                         ::content::mojom::SyntheticSmoothScrollPtr> {
  static bool IsNull(const ::content::mojom::SyntheticSmoothScrollPtr& input) { return !input; }
  static void SetToNull(::content::mojom::SyntheticSmoothScrollPtr* output) { output->reset(); }

  static decltype(::content::mojom::SyntheticSmoothScroll::gesture_source_type) gesture_source_type(
      const ::content::mojom::SyntheticSmoothScrollPtr& input) {
    return input->gesture_source_type;
  }

  static const decltype(::content::mojom::SyntheticSmoothScroll::anchor)& anchor(
      const ::content::mojom::SyntheticSmoothScrollPtr& input) {
    return input->anchor;
  }

  static const decltype(::content::mojom::SyntheticSmoothScroll::distances)& distances(
      const ::content::mojom::SyntheticSmoothScrollPtr& input) {
    return input->distances;
  }

  static decltype(::content::mojom::SyntheticSmoothScroll::prevent_fling) prevent_fling(
      const ::content::mojom::SyntheticSmoothScrollPtr& input) {
    return input->prevent_fling;
  }

  static decltype(::content::mojom::SyntheticSmoothScroll::speed_in_pixels_s) speed_in_pixels_s(
      const ::content::mojom::SyntheticSmoothScrollPtr& input) {
    return input->speed_in_pixels_s;
  }

  static decltype(::content::mojom::SyntheticSmoothScroll::fling_velocity_x) fling_velocity_x(
      const ::content::mojom::SyntheticSmoothScrollPtr& input) {
    return input->fling_velocity_x;
  }

  static decltype(::content::mojom::SyntheticSmoothScroll::fling_velocity_y) fling_velocity_y(
      const ::content::mojom::SyntheticSmoothScrollPtr& input) {
    return input->fling_velocity_y;
  }

  static decltype(::content::mojom::SyntheticSmoothScroll::granularity) granularity(
      const ::content::mojom::SyntheticSmoothScrollPtr& input) {
    return input->granularity;
  }

  static decltype(::content::mojom::SyntheticSmoothScroll::modifiers) modifiers(
      const ::content::mojom::SyntheticSmoothScrollPtr& input) {
    return input->modifiers;
  }

  static decltype(::content::mojom::SyntheticSmoothScroll::vsync_offset_ms) vsync_offset_ms(
      const ::content::mojom::SyntheticSmoothScrollPtr& input) {
    return input->vsync_offset_ms;
  }

  static decltype(::content::mojom::SyntheticSmoothScroll::input_event_pattern) input_event_pattern(
      const ::content::mojom::SyntheticSmoothScrollPtr& input) {
    return input->input_event_pattern;
  }

  static bool Read(::content::mojom::SyntheticSmoothScroll::DataView input, ::content::mojom::SyntheticSmoothScrollPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::SyntheticPinch::DataView,
                                         ::content::mojom::SyntheticPinchPtr> {
  static bool IsNull(const ::content::mojom::SyntheticPinchPtr& input) { return !input; }
  static void SetToNull(::content::mojom::SyntheticPinchPtr* output) { output->reset(); }

  static decltype(::content::mojom::SyntheticPinch::scale_factor) scale_factor(
      const ::content::mojom::SyntheticPinchPtr& input) {
    return input->scale_factor;
  }

  static const decltype(::content::mojom::SyntheticPinch::anchor)& anchor(
      const ::content::mojom::SyntheticPinchPtr& input) {
    return input->anchor;
  }

  static decltype(::content::mojom::SyntheticPinch::relative_pointer_speed_in_pixels_s) relative_pointer_speed_in_pixels_s(
      const ::content::mojom::SyntheticPinchPtr& input) {
    return input->relative_pointer_speed_in_pixels_s;
  }

  static decltype(::content::mojom::SyntheticPinch::vsync_offset_ms) vsync_offset_ms(
      const ::content::mojom::SyntheticPinchPtr& input) {
    return input->vsync_offset_ms;
  }

  static decltype(::content::mojom::SyntheticPinch::input_event_pattern) input_event_pattern(
      const ::content::mojom::SyntheticPinchPtr& input) {
    return input->input_event_pattern;
  }

  static bool Read(::content::mojom::SyntheticPinch::DataView input, ::content::mojom::SyntheticPinchPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::SyntheticTap::DataView,
                                         ::content::mojom::SyntheticTapPtr> {
  static bool IsNull(const ::content::mojom::SyntheticTapPtr& input) { return !input; }
  static void SetToNull(::content::mojom::SyntheticTapPtr* output) { output->reset(); }

  static decltype(::content::mojom::SyntheticTap::gesture_source_type) gesture_source_type(
      const ::content::mojom::SyntheticTapPtr& input) {
    return input->gesture_source_type;
  }

  static const decltype(::content::mojom::SyntheticTap::position)& position(
      const ::content::mojom::SyntheticTapPtr& input) {
    return input->position;
  }

  static decltype(::content::mojom::SyntheticTap::duration_ms) duration_ms(
      const ::content::mojom::SyntheticTapPtr& input) {
    return input->duration_ms;
  }

  static bool Read(::content::mojom::SyntheticTap::DataView input, ::content::mojom::SyntheticTapPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::SyntheticPointerActionParams::DataView,
                                         ::content::mojom::SyntheticPointerActionParamsPtr> {
  static bool IsNull(const ::content::mojom::SyntheticPointerActionParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::SyntheticPointerActionParamsPtr* output) { output->reset(); }

  static decltype(::content::mojom::SyntheticPointerActionParams::pointer_action_type) pointer_action_type(
      const ::content::mojom::SyntheticPointerActionParamsPtr& input) {
    return input->pointer_action_type;
  }

  static const decltype(::content::mojom::SyntheticPointerActionParams::position)& position(
      const ::content::mojom::SyntheticPointerActionParamsPtr& input) {
    return input->position;
  }

  static decltype(::content::mojom::SyntheticPointerActionParams::pointer_id) pointer_id(
      const ::content::mojom::SyntheticPointerActionParamsPtr& input) {
    return input->pointer_id;
  }

  static decltype(::content::mojom::SyntheticPointerActionParams::button) button(
      const ::content::mojom::SyntheticPointerActionParamsPtr& input) {
    return input->button;
  }

  static decltype(::content::mojom::SyntheticPointerActionParams::key_modifiers) key_modifiers(
      const ::content::mojom::SyntheticPointerActionParamsPtr& input) {
    return input->key_modifiers;
  }

  static decltype(::content::mojom::SyntheticPointerActionParams::width) width(
      const ::content::mojom::SyntheticPointerActionParamsPtr& input) {
    return input->width;
  }

  static decltype(::content::mojom::SyntheticPointerActionParams::height) height(
      const ::content::mojom::SyntheticPointerActionParamsPtr& input) {
    return input->height;
  }

  static decltype(::content::mojom::SyntheticPointerActionParams::rotation_angle) rotation_angle(
      const ::content::mojom::SyntheticPointerActionParamsPtr& input) {
    return input->rotation_angle;
  }

  static decltype(::content::mojom::SyntheticPointerActionParams::force) force(
      const ::content::mojom::SyntheticPointerActionParamsPtr& input) {
    return input->force;
  }

  static decltype(::content::mojom::SyntheticPointerActionParams::tangential_pressure) tangential_pressure(
      const ::content::mojom::SyntheticPointerActionParamsPtr& input) {
    return input->tangential_pressure;
  }

  static decltype(::content::mojom::SyntheticPointerActionParams::tilt_x) tilt_x(
      const ::content::mojom::SyntheticPointerActionParamsPtr& input) {
    return input->tilt_x;
  }

  static decltype(::content::mojom::SyntheticPointerActionParams::tilt_y) tilt_y(
      const ::content::mojom::SyntheticPointerActionParamsPtr& input) {
    return input->tilt_y;
  }

  static const decltype(::content::mojom::SyntheticPointerActionParams::timestamp)& timestamp(
      const ::content::mojom::SyntheticPointerActionParamsPtr& input) {
    return input->timestamp;
  }

  static const decltype(::content::mojom::SyntheticPointerActionParams::duration)& duration(
      const ::content::mojom::SyntheticPointerActionParamsPtr& input) {
    return input->duration;
  }

  static bool Read(::content::mojom::SyntheticPointerActionParams::DataView input, ::content::mojom::SyntheticPointerActionParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::SyntheticPointerAction::DataView,
                                         ::content::mojom::SyntheticPointerActionPtr> {
  static bool IsNull(const ::content::mojom::SyntheticPointerActionPtr& input) { return !input; }
  static void SetToNull(::content::mojom::SyntheticPointerActionPtr* output) { output->reset(); }

  static decltype(::content::mojom::SyntheticPointerAction::gesture_source_type) gesture_source_type(
      const ::content::mojom::SyntheticPointerActionPtr& input) {
    return input->gesture_source_type;
  }

  static const decltype(::content::mojom::SyntheticPointerAction::params)& params(
      const ::content::mojom::SyntheticPointerActionPtr& input) {
    return input->params;
  }

  static bool Read(::content::mojom::SyntheticPointerAction::DataView input, ::content::mojom::SyntheticPointerActionPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_COMMON_INPUT_INPUT_INJECTOR_MOJOM_H_