// content/browser/tracing/trace_report/trace_report.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_TRACING_TRACE_REPORT_TRACE_REPORT_MOJOM_SHARED_H_
#define CONTENT_BROWSER_TRACING_TRACE_REPORT_TRACE_REPORT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/browser/tracing/trace_report/trace_report.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace trace_report::mojom {
class ClientTraceReportDataView;

class ScenarioDataView;



}  // trace_report::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::trace_report::mojom::ClientTraceReportDataView> {
  using Data = ::trace_report::mojom::internal::ClientTraceReport_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::trace_report::mojom::ScenarioDataView> {
  using Data = ::trace_report::mojom::internal::Scenario_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace trace_report::mojom {


enum class ReportUploadState : int32_t {
  
  kNotUploaded = 0,
  
  kPending = 1,
  
  kPending_UserRequested = 2,
  
  kUploaded = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, ReportUploadState value);
inline bool IsKnownEnumValue(ReportUploadState value) {
  return internal::ReportUploadState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SkipUploadReason : int32_t {
  
  kNoSkip = 0,
  
  kSizeLimitExceeded = 1,
  
  kNotAnonymized = 2,
  
  kScenarioQuotaExceeded = 3,
  
  kUploadTimedOut = 4,
  
  kLocalScenario = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, SkipUploadReason value);
inline bool IsKnownEnumValue(SkipUploadReason value) {
  return internal::SkipUploadReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class TraceReportHandlerFactoryInterfaceBase {};

using TraceReportHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<TraceReportHandlerFactoryInterfaceBase>;
using TraceReportHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<TraceReportHandlerFactoryInterfaceBase>;
using TraceReportHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TraceReportHandlerFactoryInterfaceBase>;
using TraceReportHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TraceReportHandlerFactoryInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class ClientTraceReportDataView {
 public:
  ClientTraceReportDataView() = default;

  ClientTraceReportDataView(
      internal::ClientTraceReport_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUuidDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUuid(UserType* output) {
    
    auto* pointer = data_->uuid.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
  inline void GetCreationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCreationTime(UserType* output) {
    
    auto* pointer = data_->creation_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetScenarioNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScenarioName(UserType* output) {
    
    auto* pointer = data_->scenario_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUploadRuleNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUploadRuleName(UserType* output) {
    
    auto* pointer = data_->upload_rule_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  std::optional<int32_t> upload_rule_value() const {

    return data_->upload_rule_value_$flag
        ? std::make_optional(data_->upload_rule_value_$value)
        : std::nullopt;
  }
  int64_t total_size() const {
    return data_->total_size;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUploadState(UserType* output) const {
    auto data_value = data_->upload_state;
    return mojo::internal::Deserialize<::trace_report::mojom::ReportUploadState>(
        data_value, output);
  }
  ReportUploadState upload_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::trace_report::mojom::ReportUploadState>(data_->upload_state));
  }
  inline void GetUploadTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUploadTime(UserType* output) {
    
    auto* pointer = data_->upload_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSkipReason(UserType* output) const {
    auto data_value = data_->skip_reason;
    return mojo::internal::Deserialize<::trace_report::mojom::SkipUploadReason>(
        data_value, output);
  }
  SkipUploadReason skip_reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::trace_report::mojom::SkipUploadReason>(data_->skip_reason));
  }
  bool has_trace_content() const {
    return data_->has_trace_content;
  }
 private:
  internal::ClientTraceReport_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScenarioDataView {
 public:
  ScenarioDataView() = default;

  ScenarioDataView(
      internal::Scenario_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScenarioNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScenarioName(UserType* output) {
    
    auto* pointer = data_->scenario_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Scenario_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // trace_report::mojom

namespace std {

template <>
struct hash<::trace_report::mojom::ReportUploadState>
    : public mojo::internal::EnumHashImpl<::trace_report::mojom::ReportUploadState> {};

template <>
struct hash<::trace_report::mojom::SkipUploadReason>
    : public mojo::internal::EnumHashImpl<::trace_report::mojom::SkipUploadReason> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::trace_report::mojom::ReportUploadState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::trace_report::mojom::ReportUploadState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::trace_report::mojom::ReportUploadState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::trace_report::mojom::SkipUploadReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::trace_report::mojom::SkipUploadReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::trace_report::mojom::SkipUploadReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::trace_report::mojom::ClientTraceReportDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::trace_report::mojom::ClientTraceReportDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::trace_report::mojom::internal::ClientTraceReport_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::uuid(input)) in_uuid = Traits::uuid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->uuid)::BaseType> uuid_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
        in_uuid, uuid_fragment);
    fragment->uuid.Set(
        uuid_fragment.is_null() ? nullptr : uuid_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->uuid.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null uuid in ClientTraceReport struct");
    decltype(Traits::creation_time(input)) in_creation_time = Traits::creation_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->creation_time)::BaseType> creation_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_creation_time, creation_time_fragment);
    fragment->creation_time.Set(
        creation_time_fragment.is_null() ? nullptr : creation_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->creation_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null creation_time in ClientTraceReport struct");
    decltype(Traits::scenario_name(input)) in_scenario_name = Traits::scenario_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scenario_name)::BaseType> scenario_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_scenario_name, scenario_name_fragment);
    fragment->scenario_name.Set(
        scenario_name_fragment.is_null() ? nullptr : scenario_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scenario_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scenario_name in ClientTraceReport struct");
    decltype(Traits::upload_rule_name(input)) in_upload_rule_name = Traits::upload_rule_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->upload_rule_name)::BaseType> upload_rule_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_upload_rule_name, upload_rule_name_fragment);
    fragment->upload_rule_name.Set(
        upload_rule_name_fragment.is_null() ? nullptr : upload_rule_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->upload_rule_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null upload_rule_name in ClientTraceReport struct");
    fragment->upload_rule_value_$flag = Traits::upload_rule_value(input).has_value();
    if (Traits::upload_rule_value(input).has_value()) {
      fragment->upload_rule_value_$value = Traits::upload_rule_value(input).value();
    }
    fragment->total_size = Traits::total_size(input);
    mojo::internal::Serialize<::trace_report::mojom::ReportUploadState>(
        Traits::upload_state(input), &fragment->upload_state);
    decltype(Traits::upload_time(input)) in_upload_time = Traits::upload_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->upload_time)::BaseType> upload_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_upload_time, upload_time_fragment);
    fragment->upload_time.Set(
        upload_time_fragment.is_null() ? nullptr : upload_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->upload_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null upload_time in ClientTraceReport struct");
    mojo::internal::Serialize<::trace_report::mojom::SkipUploadReason>(
        Traits::skip_reason(input), &fragment->skip_reason);
    fragment->has_trace_content = Traits::has_trace_content(input);
  }

  static bool Deserialize(::trace_report::mojom::internal::ClientTraceReport_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::trace_report::mojom::ClientTraceReportDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::trace_report::mojom::ScenarioDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::trace_report::mojom::ScenarioDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::trace_report::mojom::internal::Scenario_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::scenario_name(input)) in_scenario_name = Traits::scenario_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scenario_name)::BaseType> scenario_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_scenario_name, scenario_name_fragment);
    fragment->scenario_name.Set(
        scenario_name_fragment.is_null() ? nullptr : scenario_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scenario_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scenario_name in Scenario struct");
  }

  static bool Deserialize(::trace_report::mojom::internal::Scenario_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::trace_report::mojom::ScenarioDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace trace_report::mojom {

inline void ClientTraceReportDataView::GetUuidDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->uuid.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}
inline void ClientTraceReportDataView::GetCreationTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->creation_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void ClientTraceReportDataView::GetScenarioNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->scenario_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ClientTraceReportDataView::GetUploadRuleNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->upload_rule_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ClientTraceReportDataView::GetUploadTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->upload_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void ScenarioDataView::GetScenarioNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->scenario_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // trace_report::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::trace_report::mojom::ReportUploadState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::trace_report::mojom::ReportUploadState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::trace_report::mojom::SkipUploadReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::trace_report::mojom::SkipUploadReason value);
};

} // namespace perfetto

#endif  // CONTENT_BROWSER_TRACING_TRACE_REPORT_TRACE_REPORT_MOJOM_SHARED_H_