// components/services/storage/public/mojom/filesystem/directory.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/filesystem/directory.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_string.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_error.mojom-shared.h"
#include "mojo/public/mojom/base/file_info.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace storage::mojom {
class StrictRelativePathDataView;

class PathAccessInfoDataView;



}  // storage::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::storage::mojom::StrictRelativePathDataView> {
  using Data = ::storage::mojom::internal::StrictRelativePath_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::storage::mojom::PathAccessInfoDataView> {
  using Data = ::storage::mojom::internal::PathAccessInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace storage::mojom {


enum class GetEntriesMode : int32_t {
  
  kFilesOnly = 0,
  
  kFilesAndDirectories = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, GetEntriesMode value);
inline bool IsKnownEnumValue(GetEntriesMode value) {
  return internal::GetEntriesMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FileOpenMode : int32_t {
  
  kOpenIfExists = 0,
  
  kCreateAndOpenOnlyIfNotExists = 1,
  
  kAlwaysOpen = 2,
  
  kAlwaysCreate = 3,
  
  kOpenIfExistsAndTruncate = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, FileOpenMode value);
inline bool IsKnownEnumValue(FileOpenMode value) {
  return internal::FileOpenMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FileReadAccess : int32_t {
  
  kReadNotAllowed = 0,
  
  kReadAllowed = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, FileReadAccess value);
inline bool IsKnownEnumValue(FileReadAccess value) {
  return internal::FileReadAccess_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FileWriteAccess : int32_t {
  
  kWriteNotAllowed = 0,
  
  kWriteAllowed = 1,
  
  kAppendOnly = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, FileWriteAccess value);
inline bool IsKnownEnumValue(FileWriteAccess value) {
  return internal::FileWriteAccess_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FileLockInterfaceBase {};

using FileLockPtrDataView =
    mojo::InterfacePtrDataView<FileLockInterfaceBase>;
using FileLockRequestDataView =
    mojo::InterfaceRequestDataView<FileLockInterfaceBase>;
using FileLockAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FileLockInterfaceBase>;
using FileLockAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FileLockInterfaceBase>;
class DirectoryInterfaceBase {};

using DirectoryPtrDataView =
    mojo::InterfacePtrDataView<DirectoryInterfaceBase>;
using DirectoryRequestDataView =
    mojo::InterfaceRequestDataView<DirectoryInterfaceBase>;
using DirectoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DirectoryInterfaceBase>;
using DirectoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DirectoryInterfaceBase>;


class StrictRelativePathDataView {
 public:
  StrictRelativePathDataView() = default;

  StrictRelativePathDataView(
      internal::StrictRelativePath_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::StrictRelativePath_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PathAccessInfoDataView {
 public:
  PathAccessInfoDataView() = default;

  PathAccessInfoDataView(
      internal::PathAccessInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool can_read() const {
    return data_->can_read;
  }
  bool can_write() const {
    return data_->can_write;
  }
 private:
  internal::PathAccessInfo_Data* data_ = nullptr;
};


}  // storage::mojom

namespace std {

template <>
struct hash<::storage::mojom::GetEntriesMode>
    : public mojo::internal::EnumHashImpl<::storage::mojom::GetEntriesMode> {};

template <>
struct hash<::storage::mojom::FileOpenMode>
    : public mojo::internal::EnumHashImpl<::storage::mojom::FileOpenMode> {};

template <>
struct hash<::storage::mojom::FileReadAccess>
    : public mojo::internal::EnumHashImpl<::storage::mojom::FileReadAccess> {};

template <>
struct hash<::storage::mojom::FileWriteAccess>
    : public mojo::internal::EnumHashImpl<::storage::mojom::FileWriteAccess> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::GetEntriesMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::GetEntriesMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::storage::mojom::GetEntriesMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::FileOpenMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::FileOpenMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::storage::mojom::FileOpenMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::FileReadAccess, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::FileReadAccess, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::storage::mojom::FileReadAccess>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::FileWriteAccess, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::FileWriteAccess, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::storage::mojom::FileWriteAccess>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::StrictRelativePathDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::StrictRelativePathDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::StrictRelativePath_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::path(input)) in_path = Traits::path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path)::BaseType> path_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_path, path_fragment);
    fragment->path.Set(
        path_fragment.is_null() ? nullptr : path_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->path.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in StrictRelativePath struct");
  }

  static bool Deserialize(::storage::mojom::internal::StrictRelativePath_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::StrictRelativePathDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::PathAccessInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::PathAccessInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::PathAccessInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->can_read = Traits::can_read(input);
    fragment->can_write = Traits::can_write(input);
  }

  static bool Deserialize(::storage::mojom::internal::PathAccessInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::PathAccessInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace storage::mojom {

inline void StrictRelativePathDataView::GetPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}





}  // storage::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) TraceFormatTraits<::storage::mojom::GetEntriesMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::storage::mojom::GetEntriesMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) TraceFormatTraits<::storage::mojom::FileOpenMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::storage::mojom::FileOpenMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) TraceFormatTraits<::storage::mojom::FileReadAccess> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::storage::mojom::FileReadAccess value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) TraceFormatTraits<::storage::mojom::FileWriteAccess> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::storage::mojom::FileWriteAccess value);
};

} // namespace perfetto

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_SHARED_H_