// components/services/storage/public/mojom/buckets/bucket_locator.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BUCKETS_BUCKET_LOCATOR_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BUCKETS_BUCKET_LOCATOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/buckets/bucket_locator.mojom-features.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/buckets/bucket_locator.mojom-shared.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/buckets/bucket_locator.mojom-forward.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/buckets/bucket_id.mojom.h"
#include "third_party/blink/public/mojom/quota/quota_types.mojom-forward.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom.h"
#include <string>
#include <vector>




#include "components/services/storage/public/mojom/buckets/bucket_id_mojom_traits.h"
#include "components/services/storage/public/mojom/buckets/bucket_info_mojom_traits.h"
#include "components/services/storage/public/mojom/buckets/bucket_locator_mojom_traits.h"




namespace storage::mojom {








class  BucketLocator {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BucketLocator, T>::value>;
  using DataView = BucketLocatorDataView;
  using Data_ = internal::BucketLocator_Data;

  template <typename... Args>
  static BucketLocatorPtr New(Args&&... args) {
    return BucketLocatorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BucketLocatorPtr From(const U& u) {
    return mojo::TypeConverter<BucketLocatorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BucketLocator>::Convert(*this);
  }


  BucketLocator();

  BucketLocator(
      ::storage::BucketId id,
      const ::blink::StorageKey& storage_key,
      ::blink::mojom::StorageType type,
      bool is_default);


  ~BucketLocator();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BucketLocatorPtr>
  BucketLocatorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BucketLocator::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BucketLocator::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BucketLocator::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BucketLocator::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BucketLocator::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BucketLocator_UnserializedMessageContext<
            UserType, BucketLocator::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BucketLocator::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BucketLocator::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BucketLocator_UnserializedMessageContext<
            UserType, BucketLocator::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BucketLocator::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::storage::BucketId id;
  
  ::blink::StorageKey storage_key;
  
  ::blink::mojom::StorageType type;
  
  bool is_default;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BucketLocator::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BucketLocator::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BucketLocator::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BucketLocator::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BucketLocatorPtr BucketLocator::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(storage_key),
      mojo::Clone(type),
      mojo::Clone(is_default)
  );
}

template <typename T, BucketLocator::EnableIfSame<T>*>
bool BucketLocator::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->storage_key, other_struct.storage_key))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->is_default, other_struct.is_default))
    return false;
  return true;
}

template <typename T, BucketLocator::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.storage_key < rhs.storage_key)
    return true;
  if (rhs.storage_key < lhs.storage_key)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.is_default < rhs.is_default)
    return true;
  if (rhs.is_default < lhs.is_default)
    return false;
  return false;
}


}  // storage::mojom

namespace mojo {


template <>
struct  StructTraits<::storage::mojom::BucketLocator::DataView,
                                         ::storage::mojom::BucketLocatorPtr> {
  static bool IsNull(const ::storage::mojom::BucketLocatorPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::BucketLocatorPtr* output) { output->reset(); }

  static const decltype(::storage::mojom::BucketLocator::id)& id(
      const ::storage::mojom::BucketLocatorPtr& input) {
    return input->id;
  }

  static const decltype(::storage::mojom::BucketLocator::storage_key)& storage_key(
      const ::storage::mojom::BucketLocatorPtr& input) {
    return input->storage_key;
  }

  static decltype(::storage::mojom::BucketLocator::type) type(
      const ::storage::mojom::BucketLocatorPtr& input) {
    return input->type;
  }

  static decltype(::storage::mojom::BucketLocator::is_default) is_default(
      const ::storage::mojom::BucketLocatorPtr& input) {
    return input->is_default;
  }

  static bool Read(::storage::mojom::BucketLocator::DataView input, ::storage::mojom::BucketLocatorPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BUCKETS_BUCKET_LOCATOR_MOJOM_H_