// components/content_settings/core/common/content_settings.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_CONTENT_SETTINGS_MOJOM_SHARED_H_
#define COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_CONTENT_SETTINGS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/content_settings/core/common/content_settings.mojom-shared-internal.h"
#include "components/content_settings/core/common/content_settings_enums.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"







namespace content_settings::mojom {
class PatternPartsDataView;

class ContentSettingsPatternDataView;

class RuleMetaDataDataView;

class ContentSettingPatternSourceDataView;

class RendererContentSettingRulesDataView;



}  // content_settings::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content_settings::mojom::PatternPartsDataView> {
  using Data = ::content_settings::mojom::internal::PatternParts_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content_settings::mojom::ContentSettingsPatternDataView> {
  using Data = ::content_settings::mojom::internal::ContentSettingsPattern_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content_settings::mojom::RuleMetaDataDataView> {
  using Data = ::content_settings::mojom::internal::RuleMetaData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content_settings::mojom::ContentSettingPatternSourceDataView> {
  using Data = ::content_settings::mojom::internal::ContentSettingPatternSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content_settings::mojom::RendererContentSettingRulesDataView> {
  using Data = ::content_settings::mojom::internal::RendererContentSettingRules_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace content_settings::mojom {


enum class ContentSetting : int32_t {
  
  DEFAULT = 0,
  
  ALLOW = 1,
  
  BLOCK = 2,
  
  ASK = 3,
  
  SESSION_ONLY = 4,
  
  DETECT_IMPORTANT_CONTENT = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, ContentSetting value);
inline bool IsKnownEnumValue(ContentSetting value) {
  return internal::ContentSetting_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class PatternPartsDataView {
 public:
  PatternPartsDataView() = default;

  PatternPartsDataView(
      internal::PatternParts_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSchemeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScheme(UserType* output) {
    
    auto* pointer = data_->scheme.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_scheme_wildcard() const {
    return data_->is_scheme_wildcard;
  }
  inline void GetHostDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHost(UserType* output) {
    
    auto* pointer = data_->host.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool has_domain_wildcard() const {
    return data_->has_domain_wildcard;
  }
  inline void GetPortDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPort(UserType* output) {
    
    auto* pointer = data_->port.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_port_wildcard() const {
    return data_->is_port_wildcard;
  }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_path_wildcard() const {
    return data_->is_path_wildcard;
  }
 private:
  internal::PatternParts_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentSettingsPatternDataView {
 public:
  ContentSettingsPatternDataView() = default;

  ContentSettingsPatternDataView(
      internal::ContentSettingsPattern_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPartsDataView(
      PatternPartsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParts(UserType* output) {
    
    auto* pointer = data_->parts.Get();
    return mojo::internal::Deserialize<::content_settings::mojom::PatternPartsDataView>(
        pointer, output, message_);
  }
  bool is_valid() const {
    return data_->is_valid;
  }
 private:
  internal::ContentSettingsPattern_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RuleMetaDataDataView {
 public:
  RuleMetaDataDataView() = default;

  RuleMetaDataDataView(
      internal::RuleMetaData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLastModifiedDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastModified(UserType* output) {
    
    auto* pointer = data_->last_modified.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetLastUsedDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastUsed(UserType* output) {
    
    auto* pointer = data_->last_used.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetLastVisitedDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastVisited(UserType* output) {
    
    auto* pointer = data_->last_visited.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetExpirationDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpiration(UserType* output) {
    
    auto* pointer = data_->expiration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSessionModel(UserType* output) const {
    auto data_value = data_->session_model;
    return mojo::internal::Deserialize<::content_settings::mojom::SessionModel>(
        data_value, output);
  }
  ::content_settings::mojom::SessionModel session_model() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content_settings::mojom::SessionModel>(data_->session_model));
  }
  inline void GetLifetimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLifetime(UserType* output) {
    
    auto* pointer = data_->lifetime.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTpcdMetadataRuleSource(UserType* output) const {
    auto data_value = data_->tpcd_metadata_rule_source;
    return mojo::internal::Deserialize<::content_settings::mojom::TpcdMetadataRuleSource>(
        data_value, output);
  }
  ::content_settings::mojom::TpcdMetadataRuleSource tpcd_metadata_rule_source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content_settings::mojom::TpcdMetadataRuleSource>(data_->tpcd_metadata_rule_source));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTpcdMetadataCohort(UserType* output) const {
    auto data_value = data_->tpcd_metadata_cohort;
    return mojo::internal::Deserialize<::content_settings::mojom::TpcdMetadataCohort>(
        data_value, output);
  }
  ::content_settings::mojom::TpcdMetadataCohort tpcd_metadata_cohort() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content_settings::mojom::TpcdMetadataCohort>(data_->tpcd_metadata_cohort));
  }
  bool decided_by_related_website_sets() const {
    return data_->decided_by_related_website_sets;
  }
 private:
  internal::RuleMetaData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentSettingPatternSourceDataView {
 public:
  ContentSettingPatternSourceDataView() = default;

  ContentSettingPatternSourceDataView(
      internal::ContentSettingPatternSource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPrimaryPatternDataView(
      ContentSettingsPatternDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrimaryPattern(UserType* output) {
    
    auto* pointer = data_->primary_pattern.Get();
    return mojo::internal::Deserialize<::content_settings::mojom::ContentSettingsPatternDataView>(
        pointer, output, message_);
  }
  inline void GetSecondaryPatternDataView(
      ContentSettingsPatternDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSecondaryPattern(UserType* output) {
    
    auto* pointer = data_->secondary_pattern.Get();
    return mojo::internal::Deserialize<::content_settings::mojom::ContentSettingsPatternDataView>(
        pointer, output, message_);
  }
  inline void GetSettingValueDataView(
      ::mojo_base::mojom::ValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSettingValue(UserType* output) {
    
    auto* pointer = !data_->setting_value.is_null() ? &data_->setting_value : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::ValueDataView>(
        pointer, output, message_);
  }
  inline void GetMetadataDataView(
      RuleMetaDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::content_settings::mojom::RuleMetaDataDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSource(UserType* output) const {
    auto data_value = data_->source;
    return mojo::internal::Deserialize<::content_settings::mojom::ProviderType>(
        data_value, output);
  }
  ::content_settings::mojom::ProviderType source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content_settings::mojom::ProviderType>(data_->source));
  }
  bool incognito() const {
    return data_->incognito;
  }
 private:
  internal::ContentSettingPatternSource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RendererContentSettingRulesDataView {
 public:
  RendererContentSettingRulesDataView() = default;

  RendererContentSettingRulesDataView(
      internal::RendererContentSettingRules_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMixedContentRulesDataView(
      mojo::ArrayDataView<ContentSettingPatternSourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMixedContentRules(UserType* output) {
    
    auto* pointer = data_->mixed_content_rules.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
        pointer, output, message_);
  }
 private:
  internal::RendererContentSettingRules_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // content_settings::mojom

namespace std {

template <>
struct hash<::content_settings::mojom::ContentSetting>
    : public mojo::internal::EnumHashImpl<::content_settings::mojom::ContentSetting> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content_settings::mojom::ContentSetting, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content_settings::mojom::ContentSetting, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::content_settings::mojom::ContentSetting>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content_settings::mojom::PatternPartsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content_settings::mojom::PatternPartsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content_settings::mojom::internal::PatternParts_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::scheme(input)) in_scheme = Traits::scheme(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scheme)::BaseType> scheme_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_scheme, scheme_fragment);
    fragment->scheme.Set(
        scheme_fragment.is_null() ? nullptr : scheme_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scheme.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scheme in PatternParts struct");
    fragment->is_scheme_wildcard = Traits::is_scheme_wildcard(input);
    decltype(Traits::host(input)) in_host = Traits::host(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host)::BaseType> host_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_host, host_fragment);
    fragment->host.Set(
        host_fragment.is_null() ? nullptr : host_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->host.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host in PatternParts struct");
    fragment->has_domain_wildcard = Traits::has_domain_wildcard(input);
    decltype(Traits::port(input)) in_port = Traits::port(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->port)::BaseType> port_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_port, port_fragment);
    fragment->port.Set(
        port_fragment.is_null() ? nullptr : port_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->port.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null port in PatternParts struct");
    fragment->is_port_wildcard = Traits::is_port_wildcard(input);
    decltype(Traits::path(input)) in_path = Traits::path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path)::BaseType> path_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_path, path_fragment);
    fragment->path.Set(
        path_fragment.is_null() ? nullptr : path_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->path.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in PatternParts struct");
    fragment->is_path_wildcard = Traits::is_path_wildcard(input);
  }

  static bool Deserialize(::content_settings::mojom::internal::PatternParts_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content_settings::mojom::PatternPartsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content_settings::mojom::ContentSettingsPatternDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content_settings::mojom::ContentSettingsPatternDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content_settings::mojom::internal::ContentSettingsPattern_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::parts(input)) in_parts = Traits::parts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parts)::BaseType> parts_fragment(
            fragment.message());
    mojo::internal::Serialize<::content_settings::mojom::PatternPartsDataView>(
        in_parts, parts_fragment);
    fragment->parts.Set(
        parts_fragment.is_null() ? nullptr : parts_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->parts.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null parts in ContentSettingsPattern struct");
    fragment->is_valid = Traits::is_valid(input);
  }

  static bool Deserialize(::content_settings::mojom::internal::ContentSettingsPattern_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content_settings::mojom::ContentSettingsPatternDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content_settings::mojom::RuleMetaDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content_settings::mojom::RuleMetaDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content_settings::mojom::internal::RuleMetaData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::last_modified(input)) in_last_modified = Traits::last_modified(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_modified)::BaseType> last_modified_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_last_modified, last_modified_fragment);
    fragment->last_modified.Set(
        last_modified_fragment.is_null() ? nullptr : last_modified_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->last_modified.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_modified in RuleMetaData struct");
    decltype(Traits::last_used(input)) in_last_used = Traits::last_used(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_used)::BaseType> last_used_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_last_used, last_used_fragment);
    fragment->last_used.Set(
        last_used_fragment.is_null() ? nullptr : last_used_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->last_used.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_used in RuleMetaData struct");
    decltype(Traits::last_visited(input)) in_last_visited = Traits::last_visited(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_visited)::BaseType> last_visited_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_last_visited, last_visited_fragment);
    fragment->last_visited.Set(
        last_visited_fragment.is_null() ? nullptr : last_visited_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->last_visited.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_visited in RuleMetaData struct");
    decltype(Traits::expiration(input)) in_expiration = Traits::expiration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expiration)::BaseType> expiration_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_expiration, expiration_fragment);
    fragment->expiration.Set(
        expiration_fragment.is_null() ? nullptr : expiration_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->expiration.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null expiration in RuleMetaData struct");
    mojo::internal::Serialize<::content_settings::mojom::SessionModel>(
        Traits::session_model(input), &fragment->session_model);
    decltype(Traits::lifetime(input)) in_lifetime = Traits::lifetime(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lifetime)::BaseType> lifetime_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_lifetime, lifetime_fragment);
    fragment->lifetime.Set(
        lifetime_fragment.is_null() ? nullptr : lifetime_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->lifetime.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lifetime in RuleMetaData struct");
    mojo::internal::Serialize<::content_settings::mojom::TpcdMetadataRuleSource>(
        Traits::tpcd_metadata_rule_source(input), &fragment->tpcd_metadata_rule_source);
    mojo::internal::Serialize<::content_settings::mojom::TpcdMetadataCohort>(
        Traits::tpcd_metadata_cohort(input), &fragment->tpcd_metadata_cohort);
    fragment->decided_by_related_website_sets = Traits::decided_by_related_website_sets(input);
  }

  static bool Deserialize(::content_settings::mojom::internal::RuleMetaData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content_settings::mojom::RuleMetaDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content_settings::mojom::ContentSettingPatternSourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content_settings::mojom::ContentSettingPatternSourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content_settings::mojom::internal::ContentSettingPatternSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::primary_pattern(input)) in_primary_pattern = Traits::primary_pattern(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->primary_pattern)::BaseType> primary_pattern_fragment(
            fragment.message());
    mojo::internal::Serialize<::content_settings::mojom::ContentSettingsPatternDataView>(
        in_primary_pattern, primary_pattern_fragment);
    fragment->primary_pattern.Set(
        primary_pattern_fragment.is_null() ? nullptr : primary_pattern_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->primary_pattern.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null primary_pattern in ContentSettingPatternSource struct");
    decltype(Traits::secondary_pattern(input)) in_secondary_pattern = Traits::secondary_pattern(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->secondary_pattern)::BaseType> secondary_pattern_fragment(
            fragment.message());
    mojo::internal::Serialize<::content_settings::mojom::ContentSettingsPatternDataView>(
        in_secondary_pattern, secondary_pattern_fragment);
    fragment->secondary_pattern.Set(
        secondary_pattern_fragment.is_null() ? nullptr : secondary_pattern_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->secondary_pattern.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null secondary_pattern in ContentSettingPatternSource struct");
    decltype(Traits::setting_value(input)) in_setting_value = Traits::setting_value(input);
    mojo::internal::MessageFragment<decltype(fragment->setting_value)>
        setting_value_fragment(fragment.message());
    setting_value_fragment.Claim(&fragment->setting_value);
    mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
        in_setting_value, setting_value_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->setting_value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null setting_value in ContentSettingPatternSource struct");
    decltype(Traits::metadata(input)) in_metadata = Traits::metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->metadata)::BaseType> metadata_fragment(
            fragment.message());
    mojo::internal::Serialize<::content_settings::mojom::RuleMetaDataDataView>(
        in_metadata, metadata_fragment);
    fragment->metadata.Set(
        metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->metadata.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null metadata in ContentSettingPatternSource struct");
    mojo::internal::Serialize<::content_settings::mojom::ProviderType>(
        Traits::source(input), &fragment->source);
    fragment->incognito = Traits::incognito(input);
  }

  static bool Deserialize(::content_settings::mojom::internal::ContentSettingPatternSource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content_settings::mojom::ContentSettingPatternSourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content_settings::mojom::RendererContentSettingRulesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content_settings::mojom::RendererContentSettingRulesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content_settings::mojom::internal::RendererContentSettingRules_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::mixed_content_rules(input)) in_mixed_content_rules = Traits::mixed_content_rules(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mixed_content_rules)::BaseType>
        mixed_content_rules_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& mixed_content_rules_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
        in_mixed_content_rules, mixed_content_rules_fragment, &mixed_content_rules_validate_params);
    fragment->mixed_content_rules.Set(
        mixed_content_rules_fragment.is_null() ? nullptr : mixed_content_rules_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->mixed_content_rules.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mixed_content_rules in RendererContentSettingRules struct");
  }

  static bool Deserialize(::content_settings::mojom::internal::RendererContentSettingRules_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content_settings::mojom::RendererContentSettingRulesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content_settings::mojom {

inline void PatternPartsDataView::GetSchemeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->scheme.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PatternPartsDataView::GetHostDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->host.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PatternPartsDataView::GetPortDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->port.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PatternPartsDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ContentSettingsPatternDataView::GetPartsDataView(
    PatternPartsDataView* output) {
  auto pointer = data_->parts.Get();
  *output = PatternPartsDataView(pointer, message_);
}


inline void RuleMetaDataDataView::GetLastModifiedDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_modified.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void RuleMetaDataDataView::GetLastUsedDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_used.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void RuleMetaDataDataView::GetLastVisitedDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_visited.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void RuleMetaDataDataView::GetExpirationDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->expiration.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void RuleMetaDataDataView::GetLifetimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->lifetime.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void ContentSettingPatternSourceDataView::GetPrimaryPatternDataView(
    ContentSettingsPatternDataView* output) {
  auto pointer = data_->primary_pattern.Get();
  *output = ContentSettingsPatternDataView(pointer, message_);
}
inline void ContentSettingPatternSourceDataView::GetSecondaryPatternDataView(
    ContentSettingsPatternDataView* output) {
  auto pointer = data_->secondary_pattern.Get();
  *output = ContentSettingsPatternDataView(pointer, message_);
}
inline void ContentSettingPatternSourceDataView::GetSettingValueDataView(
    ::mojo_base::mojom::ValueDataView* output) {
  auto pointer = &data_->setting_value;
  *output = ::mojo_base::mojom::ValueDataView(pointer, message_);
}
inline void ContentSettingPatternSourceDataView::GetMetadataDataView(
    RuleMetaDataDataView* output) {
  auto pointer = data_->metadata.Get();
  *output = RuleMetaDataDataView(pointer, message_);
}


inline void RendererContentSettingRulesDataView::GetMixedContentRulesDataView(
    mojo::ArrayDataView<ContentSettingPatternSourceDataView>* output) {
  auto pointer = data_->mixed_content_rules.Get();
  *output = mojo::ArrayDataView<ContentSettingPatternSourceDataView>(pointer, message_);
}



}  // content_settings::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::content_settings::mojom::ContentSetting> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::content_settings::mojom::ContentSetting value);
};

} // namespace perfetto

#endif  // COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_CONTENT_SETTINGS_MOJOM_SHARED_H_