/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.saml.common.AbstractSignableSAMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.xmlsec.signature.Signature;

public class EntitiesDescriptorImpl
extends AbstractSignableSAMLObject
implements EntitiesDescriptor {
    @Nullable
    private String name;
    @Nullable
    private String id;
    @Nullable
    private Instant validUntil;
    @Nullable
    private Duration cacheDuration;
    @Nullable
    private Extensions extensions;
    @Nonnull
    private final IndexedXMLObjectChildrenList<SAMLObject> orderedDescriptors = new IndexedXMLObjectChildrenList(this);

    protected EntitiesDescriptorImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@Nullable String newName) {
        this.name = this.prepareForAssignment(this.name, newName);
    }

    @Override
    @Nullable
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(@Nullable String newID) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newID);
        this.registerOwnID(oldID, this.id);
    }

    @Override
    public boolean isValid() {
        if (null == this.validUntil) {
            return true;
        }
        return Instant.now().isBefore(this.validUntil);
    }

    @Override
    @Nullable
    public Instant getValidUntil() {
        return this.validUntil;
    }

    @Override
    public void setValidUntil(@Nullable Instant newValidUntil) {
        this.validUntil = this.prepareForAssignment(this.validUntil, newValidUntil);
    }

    @Override
    @Nullable
    public Duration getCacheDuration() {
        return this.cacheDuration;
    }

    @Override
    public void setCacheDuration(@Nullable Duration duration) {
        this.cacheDuration = this.prepareForAssignment(this.cacheDuration, duration);
    }

    @Override
    @Nullable
    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public void setExtensions(@Nullable Extensions newExtensions) {
        this.extensions = this.prepareForAssignment(this.extensions, newExtensions);
    }

    @Override
    @Nonnull
    @Live
    public List<EntitiesDescriptor> getEntitiesDescriptors() {
        return this.orderedDescriptors.subList(EntitiesDescriptor.ELEMENT_QNAME);
    }

    @Override
    @Nonnull
    @Live
    public List<EntityDescriptor> getEntityDescriptors() {
        return this.orderedDescriptors.subList(EntityDescriptor.ELEMENT_QNAME);
    }

    @Override
    public String getSignatureReferenceID() {
        return this.id;
    }

    @Override
    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        ArrayList<XMLObject> children = new ArrayList<XMLObject>();
        Signature sig = this.getSignature();
        if (sig != null) {
            children.add(sig);
        }
        if (this.extensions != null) {
            children.add(this.extensions);
        }
        children.addAll(this.orderedDescriptors);
        return CollectionSupport.copyToList(children);
    }
}

