/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.UnicodeUtil;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchParseException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.bulk.TransportBulkAction;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.ingest.DeletePipelineRequest;
import org.opensearch.action.ingest.PutPipelineRequest;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.cluster.AckedClusterStateUpdateTask;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateApplier;
import org.opensearch.cluster.ack.AckedRequest;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexTemplateMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.MetadataIndexTemplateService;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterManagerTask;
import org.opensearch.cluster.service.ClusterManagerTaskThrottler;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.metrics.OperationMetrics;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.service.ReportingService;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.gateway.GatewayService;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.VersionType;
import org.opensearch.index.analysis.AnalysisRegistry;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.indices.IndicesService;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.CompoundProcessor;
import org.opensearch.ingest.ConditionalProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IndexRequestWrapper;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.IngestDocumentWrapper;
import org.opensearch.ingest.IngestInfo;
import org.opensearch.ingest.IngestMetadata;
import org.opensearch.ingest.IngestPipelineInfo;
import org.opensearch.ingest.IngestPipelineType;
import org.opensearch.ingest.IngestStats;
import org.opensearch.ingest.Pipeline;
import org.opensearch.ingest.PipelineConfiguration;
import org.opensearch.ingest.PipelineProcessor;
import org.opensearch.ingest.Processor;
import org.opensearch.ingest.ProcessorInfo;
import org.opensearch.ingest.SystemIngestPipelineCache;
import org.opensearch.ingest.WrappingProcessor;
import org.opensearch.plugins.IngestPlugin;
import org.opensearch.script.ScriptService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import reactor.util.annotation.NonNull;

public class IngestService
implements ClusterStateApplier,
ReportingService<IngestInfo> {
    public static final String NOOP_PIPELINE_NAME = "_none";
    public static final String INGEST_ORIGIN = "ingest";
    private static final int MAX_PIPELINE_ID_BYTES = 512;
    public static final Setting<Integer> MAX_NUMBER_OF_INGEST_PROCESSORS = Setting.intSetting("cluster.ingest.max_number_processors", Integer.MAX_VALUE, 1, Integer.MAX_VALUE, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Boolean> SYSTEM_INGEST_PIPELINE_ENABLED = Setting.boolSetting("cluster.ingest.system_pipeline_enabled", true, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private static final Logger logger = LogManager.getLogger(IngestService.class);
    private final ClusterService clusterService;
    private final ScriptService scriptService;
    private final Map<String, Processor.Factory> processorFactories;
    private Map<String, Processor.Factory> systemIngestProcessorFactories = null;
    private volatile Map<String, PipelineHolder> pipelines = Collections.emptyMap();
    private final ThreadPool threadPool;
    private final OperationMetrics totalMetrics = new OperationMetrics();
    private final List<Consumer<ClusterState>> ingestClusterStateListeners = new CopyOnWriteArrayList<Consumer<ClusterState>>();
    private final ClusterManagerTaskThrottler.ThrottlingKey putPipelineTaskKey;
    private final ClusterManagerTaskThrottler.ThrottlingKey deletePipelineTaskKey;
    private volatile ClusterState state;
    private volatile int maxIngestProcessorCount;
    private volatile boolean isSystemIngestPipelineEnabled;
    private final SystemIngestPipelineCache systemIngestPipelineCache;
    private final NamedXContentRegistry xContentRegistry;

    public IngestService(ClusterService clusterService, ThreadPool threadPool, Environment env, ScriptService scriptService, AnalysisRegistry analysisRegistry, List<IngestPlugin> ingestPlugins, Client client, IndicesService indicesService, NamedXContentRegistry xContentRegistry, SystemIngestPipelineCache systemIngestPipelineCache) {
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.xContentRegistry = xContentRegistry;
        Processor.Parameters processorParameters = new Processor.Parameters(env, scriptService, analysisRegistry, threadPool.getThreadContext(), threadPool::relativeTimeInMillis, (delay, command) -> threadPool.schedule((Runnable)command, TimeValue.timeValueMillis((long)delay), "generic"), this, client, threadPool.generic()::execute, indicesService);
        this.processorFactories = IngestService.processorFactories(ingestPlugins, processorParameters);
        this.systemIngestProcessorFactories = IngestService.systemProcessorFactories(ingestPlugins, processorParameters);
        this.systemIngestPipelineCache = systemIngestPipelineCache;
        this.threadPool = threadPool;
        this.putPipelineTaskKey = clusterService.registerClusterManagerTask(ClusterManagerTask.PUT_PIPELINE, true);
        this.deletePipelineTaskKey = clusterService.registerClusterManagerTask(ClusterManagerTask.DELETE_PIPELINE, true);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_NUMBER_OF_INGEST_PROCESSORS, this::setMaxIngestProcessorCount);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SYSTEM_INGEST_PIPELINE_ENABLED, this::setIsSystemIngestPipelineEnabled);
        this.setMaxIngestProcessorCount(clusterService.getClusterSettings().get(MAX_NUMBER_OF_INGEST_PROCESSORS));
        this.setIsSystemIngestPipelineEnabled(clusterService.getClusterSettings().get(SYSTEM_INGEST_PIPELINE_ENABLED));
    }

    private void setMaxIngestProcessorCount(Integer maxIngestProcessorCount) {
        this.maxIngestProcessorCount = maxIngestProcessorCount;
    }

    private void setIsSystemIngestPipelineEnabled(boolean isSystemIngestPipelineEnabled) {
        this.isSystemIngestPipelineEnabled = isSystemIngestPipelineEnabled;
    }

    private static Map<String, Processor.Factory> processorFactories(List<IngestPlugin> ingestPlugins, Processor.Parameters parameters) {
        HashMap<String, Processor.Factory> processorFactories = new HashMap<String, Processor.Factory>();
        for (IngestPlugin ingestPlugin : ingestPlugins) {
            Map<String, Processor.Factory> newProcessors = ingestPlugin.getProcessors(parameters);
            for (Map.Entry<String, Processor.Factory> entry : newProcessors.entrySet()) {
                if (processorFactories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Ingest processor [" + entry.getKey() + "] is already registered");
            }
        }
        return Collections.unmodifiableMap(processorFactories);
    }

    private static Map<String, Processor.Factory> systemProcessorFactories(List<IngestPlugin> ingestPlugins, Processor.Parameters parameters) {
        HashMap<String, Processor.Factory> processorFactories = new HashMap<String, Processor.Factory>();
        for (IngestPlugin ingestPlugin : ingestPlugins) {
            Map<String, Processor.Factory> newProcessors = ingestPlugin.getSystemIngestProcessors(parameters);
            for (Map.Entry<String, Processor.Factory> entry : newProcessors.entrySet()) {
                Processor.Factory processorFactory = entry.getValue();
                if (!processorFactory.isSystemGenerated()) {
                    throw new RuntimeException("[" + entry.getKey() + "] is not a system generated processor factory.");
                }
                if (processorFactories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new RuntimeException("System ingest processor [" + entry.getKey() + "] is already registered");
            }
        }
        return Collections.unmodifiableMap(processorFactories);
    }

    public boolean resolveSystemIngestPipeline(DocWriteRequest<?> originalRequest, IndexRequest indexRequest, Metadata metadata) {
        String systemIngestPipelineId = null;
        if (!indexRequest.isPipelineResolved() && this.isSystemIngestPipelineEnabled) {
            IndexMetadata indexMetadata = this.getIndexMetadata(originalRequest, indexRequest, metadata);
            if (indexMetadata != null) {
                systemIngestPipelineId = this.getSystemIngestPipelineForExistingIndex(indexMetadata, indexRequest);
            } else if (indexRequest.index() != null) {
                String v2Template = MetadataIndexTemplateService.findV2Template(metadata, indexRequest.index(), false);
                if (v2Template != null) {
                    Settings settings = MetadataIndexTemplateService.resolveSettings(metadata, v2Template);
                    systemIngestPipelineId = this.getSystemIngestPipelineForTemplateV2(v2Template, indexRequest, settings);
                } else {
                    List<IndexTemplateMetadata> templates = MetadataIndexTemplateService.findV1Templates(metadata, indexRequest.index(), null);
                    systemIngestPipelineId = this.getSystemIngestPipelineForTemplateV1(templates, indexRequest);
                }
            }
        }
        indexRequest.setSystemIngestPipeline(systemIngestPipelineId != null ? systemIngestPipelineId : NOOP_PIPELINE_NAME);
        indexRequest.isPipelineResolved(true);
        if (indexRequest.getPipeline() == null) {
            indexRequest.setPipeline(NOOP_PIPELINE_NAME);
        }
        if (indexRequest.getFinalPipeline() == null) {
            indexRequest.setFinalPipeline(NOOP_PIPELINE_NAME);
        }
        return !NOOP_PIPELINE_NAME.equals(indexRequest.getSystemIngestPipeline());
    }

    public boolean resolvePipelines(DocWriteRequest<?> originalRequest, IndexRequest indexRequest, Metadata metadata) {
        if (!indexRequest.isPipelineResolved()) {
            String requestPipeline = indexRequest.getPipeline();
            String defaultPipeline = null;
            String finalPipeline = null;
            String systemIngestPipelineId = null;
            IndexMetadata indexMetadata = this.getIndexMetadata(originalRequest, indexRequest, metadata);
            if (indexMetadata != null) {
                Settings indexSettings = indexMetadata.getSettings();
                if (IndexSettings.DEFAULT_PIPELINE.exists(indexSettings)) {
                    defaultPipeline = IndexSettings.DEFAULT_PIPELINE.get(indexSettings);
                }
                if (IndexSettings.FINAL_PIPELINE.exists(indexSettings)) {
                    finalPipeline = IndexSettings.FINAL_PIPELINE.get(indexSettings);
                }
                if (this.isSystemIngestPipelineEnabled) {
                    systemIngestPipelineId = this.getSystemIngestPipelineForExistingIndex(indexMetadata, indexRequest);
                }
            } else if (indexRequest.index() != null) {
                String v2Template = MetadataIndexTemplateService.findV2Template(metadata, indexRequest.index(), false);
                if (v2Template != null) {
                    Settings settings = MetadataIndexTemplateService.resolveSettings(metadata, v2Template);
                    if (IndexSettings.DEFAULT_PIPELINE.exists(settings)) {
                        defaultPipeline = IndexSettings.DEFAULT_PIPELINE.get(settings);
                    }
                    if (IndexSettings.FINAL_PIPELINE.exists(settings)) {
                        finalPipeline = IndexSettings.FINAL_PIPELINE.get(settings);
                    }
                    if (this.isSystemIngestPipelineEnabled) {
                        systemIngestPipelineId = this.getSystemIngestPipelineForTemplateV2(v2Template, indexRequest, settings);
                    }
                } else {
                    List<IndexTemplateMetadata> templates = MetadataIndexTemplateService.findV1Templates(metadata, indexRequest.index(), null);
                    for (IndexTemplateMetadata template : templates) {
                        Settings settings = template.settings();
                        if (defaultPipeline == null && IndexSettings.DEFAULT_PIPELINE.exists(settings)) {
                            defaultPipeline = IndexSettings.DEFAULT_PIPELINE.get(settings);
                        }
                        if (finalPipeline == null && IndexSettings.FINAL_PIPELINE.exists(settings)) {
                            finalPipeline = IndexSettings.FINAL_PIPELINE.get(settings);
                        }
                        if (defaultPipeline == null || finalPipeline == null) continue;
                        break;
                    }
                    if (this.isSystemIngestPipelineEnabled) {
                        systemIngestPipelineId = this.getSystemIngestPipelineForTemplateV1(templates, indexRequest);
                    }
                }
            }
            indexRequest.setPipeline(defaultPipeline != null ? defaultPipeline : NOOP_PIPELINE_NAME);
            indexRequest.setFinalPipeline(finalPipeline != null ? finalPipeline : NOOP_PIPELINE_NAME);
            indexRequest.setSystemIngestPipeline(systemIngestPipelineId != null ? systemIngestPipelineId : NOOP_PIPELINE_NAME);
            if (requestPipeline != null) {
                indexRequest.setPipeline(requestPipeline);
            }
            indexRequest.isPipelineResolved(true);
        }
        return !NOOP_PIPELINE_NAME.equals(indexRequest.getPipeline()) || !NOOP_PIPELINE_NAME.equals(indexRequest.getFinalPipeline()) || !NOOP_PIPELINE_NAME.equals(indexRequest.getSystemIngestPipeline());
    }

    private IndexMetadata getIndexMetadata(DocWriteRequest<?> originalRequest, IndexRequest indexRequest, Metadata metadata) {
        IndexAbstraction indexAbstraction;
        IndexMetadata indexMetadata = null;
        if (originalRequest != null) {
            indexMetadata = metadata.indices().get(originalRequest.index());
        }
        if (indexMetadata == null && indexRequest.index() != null && (indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(indexRequest.index())) != null) {
            indexMetadata = indexAbstraction.getWriteIndex();
        }
        if (indexMetadata == null && originalRequest != null && originalRequest.index() != null && (indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(originalRequest.index())) != null) {
            indexMetadata = indexAbstraction.getWriteIndex();
        }
        return indexMetadata;
    }

    private String getSystemIngestPipelineForTemplateV1(@NonNull List<IndexTemplateMetadata> templates, @NonNull IndexRequest indexRequest) {
        String indexId = this.createIndexIdWithTemplateSuffix(indexRequest.index());
        Pipeline ingestPipeline = this.systemIngestPipelineCache.getSystemIngestPipeline(indexId);
        if (ingestPipeline == null) {
            ArrayList<Settings> settingsList = new ArrayList<Settings>();
            ArrayList<Map<String, Object>> mappingsMap = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> pipelineConfig = new HashMap<String, Object>();
            for (IndexTemplateMetadata template : templates) {
                if (template.settings() != null) {
                    settingsList.add(template.settings());
                }
                if (template.mappings() == null) continue;
                try {
                    mappingsMap.add(MapperService.parseMapping(this.xContentRegistry, template.mappings().string()));
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to resolve system ingest pipeline due to failed to parse the mappings [" + template.mappings().string() + "] of the index template: " + template.name(), e);
                }
            }
            pipelineConfig.put("index_template_mappings", mappingsMap);
            pipelineConfig.put("index_template_settings", settingsList);
            ingestPipeline = this.createSystemIngestPipeline(indexId, pipelineConfig);
        }
        return ingestPipeline.getProcessors().isEmpty() ? null : indexId;
    }

    private String getSystemIngestPipelineForTemplateV2(@NonNull String templateName, @NonNull IndexRequest indexRequest, Settings settings) {
        String indexId = this.createIndexIdWithTemplateSuffix(indexRequest.index());
        Pipeline ingestPipeline = this.systemIngestPipelineCache.getSystemIngestPipeline(indexId);
        if (ingestPipeline == null) {
            List<CompressedXContent> mappings;
            ArrayList<Map<String, Object>> mappingsMap = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> pipelineConfig = new HashMap<String, Object>();
            try {
                mappings = MetadataIndexTemplateService.collectMappings(this.state, templateName, indexRequest.index());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to resolve system ingest pipeline due to not able to collect mappings for template: " + templateName + ". Root cause: " + e.getMessage(), e);
            }
            for (CompressedXContent mapping : mappings) {
                try {
                    mappingsMap.add(MapperService.parseMapping(this.xContentRegistry, mapping.string()));
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to parse the mappings [" + String.valueOf(mapping) + "] of the index template: " + templateName, e);
                }
            }
            pipelineConfig.put("index_template_mappings", mappingsMap);
            pipelineConfig.put("index_template_settings", settings == null ? Collections.emptyList() : List.of(settings));
            ingestPipeline = this.createSystemIngestPipeline(indexId, pipelineConfig);
        }
        return ingestPipeline.getProcessors().isEmpty() ? null : indexId;
    }

    private String createIndexIdWithTemplateSuffix(@NonNull String indexName) {
        return "[" + indexName + "/template]";
    }

    private Pipeline createSystemIngestPipeline(@NonNull String indexId, @NonNull Map<String, Object> pipelineConfig) {
        Pipeline pipeline = Pipeline.createSystemIngestPipeline(indexId, this.systemIngestProcessorFactories, pipelineConfig);
        this.systemIngestPipelineCache.cachePipeline(indexId, pipeline, this.maxIngestProcessorCount);
        return pipeline;
    }

    private String getSystemIngestPipelineForExistingIndex(@NonNull IndexMetadata indexMetadata, IndexRequest indexRequest) {
        String indexId = indexMetadata.getIndex().toString();
        Pipeline ingestPipeline = this.systemIngestPipelineCache.getSystemIngestPipeline(indexId);
        if (ingestPipeline == null) {
            MappingMetadata mappingMetadata = indexMetadata.mapping();
            Settings settings = indexMetadata.getSettings();
            HashMap<String, Object> pipelineConfig = new HashMap<String, Object>();
            if (mappingMetadata != null) {
                pipelineConfig.put("index_mappings", mappingMetadata.getSourceAsMap());
            }
            if (settings != null) {
                pipelineConfig.put("index_settings", settings);
            }
            ingestPipeline = this.createSystemIngestPipeline(indexId, pipelineConfig);
        }
        return ingestPipeline.getProcessors().isEmpty() ? null : indexId;
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void delete(final DeletePipelineRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.clusterService.submitStateUpdateTask("delete-pipeline-" + request.getId(), new AckedClusterStateUpdateTask<AcknowledgedResponse>((AckedRequest)request, listener){

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                return IngestService.innerDelete(request, currentState);
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return IngestService.this.deletePipelineTaskKey;
            }
        });
    }

    static ClusterState innerDelete(DeletePipelineRequest request, ClusterState currentState) {
        IngestMetadata currentIngestMetadata = (IngestMetadata)currentState.metadata().custom(INGEST_ORIGIN);
        if (currentIngestMetadata == null) {
            return currentState;
        }
        Map<String, PipelineConfiguration> pipelines = currentIngestMetadata.getPipelines();
        HashSet<String> toRemove = new HashSet<String>();
        for (String string : pipelines.keySet()) {
            if (!Regex.simpleMatch(request.getId(), string)) continue;
            toRemove.add(string);
        }
        if (toRemove.isEmpty() && !Regex.isMatchAllPattern(request.getId())) {
            throw new ResourceNotFoundException("pipeline [{}] is missing", request.getId());
        }
        if (toRemove.isEmpty()) {
            return currentState;
        }
        HashMap<String, PipelineConfiguration> pipelinesCopy = new HashMap<String, PipelineConfiguration>(pipelines);
        for (String key : toRemove) {
            pipelinesCopy.remove(key);
        }
        ClusterState.Builder builder = ClusterState.builder(currentState);
        builder.metadata(Metadata.builder(currentState.getMetadata()).putCustom(INGEST_ORIGIN, new IngestMetadata(pipelinesCopy)).build());
        return builder.build();
    }

    public static List<PipelineConfiguration> getPipelines(ClusterState clusterState, String ... ids) {
        IngestMetadata ingestMetadata = (IngestMetadata)clusterState.getMetadata().custom(INGEST_ORIGIN);
        return IngestService.innerGetPipelines(ingestMetadata, ids);
    }

    static List<PipelineConfiguration> innerGetPipelines(IngestMetadata ingestMetadata, String ... ids) {
        if (ingestMetadata == null) {
            return Collections.emptyList();
        }
        if (ids.length == 0) {
            return new ArrayList<PipelineConfiguration>(ingestMetadata.getPipelines().values());
        }
        ArrayList<PipelineConfiguration> result = new ArrayList<PipelineConfiguration>(ids.length);
        for (String id : ids) {
            if (Regex.isSimpleMatchPattern(id)) {
                for (Map.Entry<String, PipelineConfiguration> entry : ingestMetadata.getPipelines().entrySet()) {
                    if (!Regex.simpleMatch(id, entry.getKey())) continue;
                    result.add(entry.getValue());
                }
                continue;
            }
            PipelineConfiguration pipeline = ingestMetadata.getPipelines().get(id);
            if (pipeline == null) continue;
            result.add(pipeline);
        }
        return result;
    }

    public void putPipeline(Map<DiscoveryNode, IngestInfo> ingestInfos, final PutPipelineRequest request, ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.validatePipeline(ingestInfos, request);
        this.clusterService.submitStateUpdateTask("put-pipeline-" + request.getId(), new AckedClusterStateUpdateTask<AcknowledgedResponse>((AckedRequest)request, listener){

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                return IngestService.innerPut(request, currentState);
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return IngestService.this.putPipelineTaskKey;
            }
        });
    }

    public Pipeline getPipeline(String id) {
        PipelineHolder holder = this.pipelines.get(id);
        if (holder != null) {
            return holder.pipeline;
        }
        return null;
    }

    public Map<String, Processor.Factory> getProcessorFactories() {
        return this.processorFactories;
    }

    public Map<String, Processor.Factory> getSystemProcessorFactories() {
        return this.systemIngestProcessorFactories;
    }

    protected SystemIngestPipelineCache getSystemIngestPipelineCache() {
        return this.systemIngestPipelineCache;
    }

    public IngestInfo info() {
        Map<String, Processor.Factory> processorFactories = this.getProcessorFactories();
        ArrayList<ProcessorInfo> processorInfoList = new ArrayList<ProcessorInfo>(processorFactories.size());
        for (Map.Entry<String, Processor.Factory> entry : processorFactories.entrySet()) {
            processorInfoList.add(new ProcessorInfo(entry.getKey()));
        }
        return new IngestInfo(processorInfoList);
    }

    Map<String, PipelineHolder> pipelines() {
        return this.pipelines;
    }

    private static List<Tuple<Processor, OperationMetrics>> getProcessorMetrics(CompoundProcessor compoundProcessor, List<Tuple<Processor, OperationMetrics>> processorMetrics) {
        for (Tuple<Processor, OperationMetrics> processorWithMetric : compoundProcessor.getProcessorsWithMetrics()) {
            Processor processor = (Processor)processorWithMetric.v1();
            OperationMetrics metric = (OperationMetrics)processorWithMetric.v2();
            if (processor instanceof CompoundProcessor) {
                IngestService.getProcessorMetrics((CompoundProcessor)processor, processorMetrics);
                continue;
            }
            if (processor instanceof ConditionalProcessor) {
                metric = ((ConditionalProcessor)processor).getMetric();
            }
            processorMetrics.add((Tuple<Processor, OperationMetrics>)new Tuple((Object)processor, (Object)metric));
        }
        return processorMetrics;
    }

    public static ClusterState innerPut(PutPipelineRequest request, ClusterState currentState) {
        IngestMetadata currentIngestMetadata = (IngestMetadata)currentState.metadata().custom(INGEST_ORIGIN);
        HashMap<String, PipelineConfiguration> pipelines = currentIngestMetadata != null ? new HashMap<String, PipelineConfiguration>(currentIngestMetadata.getPipelines()) : new HashMap<String, PipelineConfiguration>();
        pipelines.put(request.getId(), new PipelineConfiguration(request.getId(), request.getSource(), request.getMediaType()));
        ClusterState.Builder newState = ClusterState.builder(currentState);
        newState.metadata(Metadata.builder(currentState.getMetadata()).putCustom(INGEST_ORIGIN, new IngestMetadata(pipelines)).build());
        return newState.build();
    }

    void validatePipeline(Map<DiscoveryNode, IngestInfo> ingestInfos, PutPipelineRequest request) throws Exception {
        if (ingestInfos.isEmpty()) {
            throw new IllegalStateException("Ingest info is empty");
        }
        int pipelineIdLength = UnicodeUtil.calcUTF16toUTF8Length((CharSequence)request.getId(), (int)0, (int)request.getId().length());
        if (pipelineIdLength > 512) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Pipeline id [%s] exceeds maximum length of %d UTF-8 bytes (actual: %d bytes)", request.getId(), 512, pipelineIdLength));
        }
        Map pipelineConfig = (Map)XContentHelper.convertToMap(request.getSource(), false, request.getMediaType()).v2();
        Pipeline pipeline = Pipeline.create(request.getId(), pipelineConfig, this.processorFactories, this.scriptService);
        this.validateProcessorCountForIngestPipeline(pipeline);
        ArrayList<OpenSearchException> exceptions = new ArrayList<OpenSearchException>();
        for (Processor processor : pipeline.flattenAllProcessors()) {
            for (Map.Entry<DiscoveryNode, IngestInfo> entry : ingestInfos.entrySet()) {
                String type = processor.getType();
                if (entry.getValue().containsProcessor(type) || "conditional".equals(type)) continue;
                String message = "Processor type [" + processor.getType() + "] is not installed on node [" + String.valueOf(entry.getKey()) + "]";
                exceptions.add(ConfigurationUtils.newConfigurationException(processor.getType(), processor.getTag(), null, message));
            }
        }
        ExceptionsHelper.rethrowAndSuppress(exceptions);
    }

    public void validateProcessorCountForIngestPipeline(Pipeline pipeline) {
        List<Processor> processors = pipeline.flattenAllProcessors();
        if (processors.size() > this.maxIngestProcessorCount) {
            throw new IllegalStateException("Cannot use more than the maximum processors allowed. Number of processors being configured is [" + processors.size() + "] which exceeds the maximum allowed configuration of [" + this.maxIngestProcessorCount + "] processors.");
        }
    }

    public void executeBulkRequest(final int numberOfActionRequests, final Iterable<DocWriteRequest<?>> actionRequests, final BiConsumer<Integer, Exception> onFailure, final BiConsumer<Thread, Exception> onCompletion, final IntConsumer onDropped, String executorName) {
        this.threadPool.executor(executorName).execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                onCompletion.accept(null, e);
            }

            @Override
            protected void doRun() {
                IngestService.this.runBulkRequestInBatch(numberOfActionRequests, actionRequests, onFailure, onCompletion, onDropped);
            }
        });
    }

    private void runBulkRequestInBatch(int numberOfActionRequests, Iterable<DocWriteRequest<?>> actionRequests, BiConsumer<Integer, Exception> onFailure, BiConsumer<Thread, Exception> onCompletion, IntConsumer onDropped) {
        Thread originalThread = Thread.currentThread();
        int slot = 0;
        ArrayList<IndexRequestWrapper> indexRequestWrappers = new ArrayList<IndexRequestWrapper>();
        for (DocWriteRequest<?> actionRequest : actionRequests) {
            List<IndexRequest> childIndexRequests = this.getChildIndexRequests(actionRequest);
            if (childIndexRequests.isEmpty()) {
                ++slot;
                continue;
            }
            for (int childSlot = 0; childSlot < childIndexRequests.size(); ++childSlot) {
                IndexRequest indexRequest = childIndexRequests.get(childSlot);
                String pipelineId = indexRequest.getPipeline();
                indexRequest.setPipeline(NOOP_PIPELINE_NAME);
                String finalPipelineId = indexRequest.getFinalPipeline();
                indexRequest.setFinalPipeline(NOOP_PIPELINE_NAME);
                String systemPipelineId = indexRequest.getSystemIngestPipeline();
                indexRequest.setSystemIngestPipeline(NOOP_PIPELINE_NAME);
                ArrayList<IngestPipelineInfo> pipelinesInfoList = new ArrayList<IngestPipelineInfo>();
                if (pipelineId != null && !NOOP_PIPELINE_NAME.equals(pipelineId)) {
                    pipelinesInfoList.add(new IngestPipelineInfo(pipelineId, IngestPipelineType.DEFAULT));
                }
                if (finalPipelineId != null && !NOOP_PIPELINE_NAME.equals(finalPipelineId)) {
                    pipelinesInfoList.add(new IngestPipelineInfo(finalPipelineId, IngestPipelineType.FINAL));
                }
                if (systemPipelineId != null && !NOOP_PIPELINE_NAME.equals(systemPipelineId)) {
                    pipelinesInfoList.add(new IngestPipelineInfo(systemPipelineId, IngestPipelineType.SYSTEM_FINAL));
                }
                if (pipelinesInfoList.isEmpty()) continue;
                indexRequestWrappers.add(new IndexRequestWrapper(slot, childSlot, indexRequest, actionRequest, pipelinesInfoList));
            }
            ++slot;
        }
        if (indexRequestWrappers.isEmpty()) {
            onCompletion.accept(originalThread, null);
            return;
        }
        AtomicInteger totalIndexRequestCounter = new AtomicInteger(indexRequestWrappers.size());
        int batchSize = numberOfActionRequests;
        List<List<IndexRequestWrapper>> batches = IngestService.prepareBatches(batchSize, indexRequestWrappers);
        logger.debug("batchSize: {}, batches: {}", (Object)batchSize, (Object)batches.size());
        for (List<IndexRequestWrapper> batch : batches) {
            this.executePipelinesInBatchRequests(batch.stream().map(IndexRequestWrapper::getSlot).collect(Collectors.toList()), batch.stream().map(IndexRequestWrapper::getChildSlot).collect(Collectors.toList()), batch.get(0).getIngestPipelineInfoList().iterator(), batch.stream().map(IndexRequestWrapper::getIndexRequest).collect(Collectors.toList()), batch.stream().map(IndexRequestWrapper::getActionRequest).collect(Collectors.toList()), onDropped, onFailure, totalIndexRequestCounter, onCompletion, originalThread);
        }
    }

    static List<List<IndexRequestWrapper>> prepareBatches(int batchSize, List<IndexRequestWrapper> indexRequestWrappers) {
        HashMap indexRequestsPerIndexAndPipelines = new HashMap();
        for (IndexRequestWrapper indexRequestWrapper : indexRequestWrappers) {
            ArrayList<String> indexAndPipelineIds = new ArrayList<String>();
            String index = indexRequestWrapper.getIndexRequest().index();
            List<String> pipelineInfo = indexRequestWrapper.getIngestPipelineInfoList().stream().map(IngestPipelineInfo::toString).toList();
            indexAndPipelineIds.add(index);
            indexAndPipelineIds.addAll(pipelineInfo);
            int hashCode = indexAndPipelineIds.hashCode();
            indexRequestsPerIndexAndPipelines.putIfAbsent(hashCode, new ArrayList());
            ((List)indexRequestsPerIndexAndPipelines.get(hashCode)).add(indexRequestWrapper);
        }
        ArrayList<List<IndexRequestWrapper>> batchedIndexRequests = new ArrayList<List<IndexRequestWrapper>>();
        for (Map.Entry indexRequestsPerKey : indexRequestsPerIndexAndPipelines.entrySet()) {
            for (int i = 0; i < ((List)indexRequestsPerKey.getValue()).size(); i += Math.min(((List)indexRequestsPerKey.getValue()).size(), batchSize)) {
                batchedIndexRequests.add(new ArrayList(((List)indexRequestsPerKey.getValue()).subList(i, i + Math.min(batchSize, ((List)indexRequestsPerKey.getValue()).size() - i))));
            }
        }
        return batchedIndexRequests;
    }

    private void executePipelinesInBatchRequests(List<Integer> slots, List<Integer> childSlot, Iterator<IngestPipelineInfo> pipelineInfoIterator, List<IndexRequest> indexRequests, List<DocWriteRequest<?>> actionRequests, IntConsumer onDropped, BiConsumer<Integer, Exception> onFailure, AtomicInteger totalIndexRequestCounter, BiConsumer<Thread, Exception> onCompletion, Thread originalThread) {
        if (indexRequests.size() == 1) {
            this.executePipelines(slots.get(0), pipelineInfoIterator, indexRequests.get(0), actionRequests.get(0), onDropped, onFailure, totalIndexRequestCounter, onCompletion, originalThread);
            return;
        }
        if (!pipelineInfoIterator.hasNext()) {
            throw new RuntimeException("Should not executePipelinesInBatchRequests when the pipeline iterator does not have next pipeline.");
        }
        IngestPipelineInfo pipelineInfo = pipelineInfoIterator.next();
        String pipelineId = pipelineInfo.getPipelineId();
        IngestPipelineType pipelineInfoType = pipelineInfo.getType();
        try {
            Pipeline pipeline = this.getPipeline(pipelineId, pipelineInfoType, actionRequests.get(0), indexRequests.get(0));
            if (pipeline == null) {
                if (!pipelineInfoIterator.hasNext()) {
                    this.completeExecution(totalIndexRequestCounter, onCompletion, originalThread, indexRequests.size());
                }
                return;
            }
            String originalIndex = indexRequests.get(0).indices()[0];
            Map<SlotKey, IndexRequest> slotIndexRequestMap = IngestService.createSlotIndexRequestMap(slots, childSlot, indexRequests);
            this.innerBatchExecute(slots, childSlot, indexRequests, pipeline, onDropped, results -> {
                for (int i = 0; i < results.size(); ++i) {
                    if (((IngestDocumentWrapper)results.get(i)).getException() == null) continue;
                    SlotKey slotKey = new SlotKey(((IngestDocumentWrapper)results.get(i)).getSlot(), ((IngestDocumentWrapper)results.get(i)).getChildSlot());
                    IndexRequest indexRequest = (IndexRequest)slotIndexRequestMap.get(slotKey);
                    logger.debug(() -> new ParameterizedMessage("failed to execute pipeline [{}] for document [{}/{}]", new Object[]{pipelineId, indexRequest != null ? indexRequest.index() : null, indexRequest != null ? indexRequest.id() : null}), (Throwable)((IngestDocumentWrapper)results.get(i)).getException());
                    onFailure.accept(((IngestDocumentWrapper)results.get(i)).getSlot(), ((IngestDocumentWrapper)results.get(i)).getException());
                }
                boolean hasTargetIndexChanged = false;
                boolean hasInvalidTargetIndexChange = false;
                ArrayList<IndexRequest> indexRequestsTargetIndexUnchanged = new ArrayList<IndexRequest>();
                ArrayList actionRequestsTargetIndexUnchanged = new ArrayList();
                for (int i = 0; i < indexRequests.size(); ++i) {
                    IndexRequest indexRequest = (IndexRequest)indexRequests.get(i);
                    if (!Objects.equals(originalIndex, indexRequest.indices()[0])) {
                        hasTargetIndexChanged = true;
                        if (IngestPipelineType.FINAL.equals((Object)pipelineInfoType) || IngestPipelineType.SYSTEM_FINAL.equals((Object)pipelineInfoType)) {
                            hasInvalidTargetIndexChange = true;
                            onFailure.accept(i, new IllegalStateException(String.valueOf((Object)pipelineInfoType) + " pipeline [" + pipelineId + "] can't change the target index"));
                            continue;
                        }
                        this.resetPipelineAfterIndexChange(indexRequest);
                        continue;
                    }
                    indexRequestsTargetIndexUnchanged.add(indexRequest);
                    actionRequestsTargetIndexUnchanged.add((DocWriteRequest)actionRequests.get(i));
                }
                if (hasTargetIndexChanged) {
                    if (hasInvalidTargetIndexChange) {
                        this.totalMetrics.failed();
                    }
                    if (indexRequestsTargetIndexUnchanged.isEmpty()) {
                        pipelineInfoIterator.forEachRemaining($ -> {});
                    }
                    if (pipelineInfoIterator.hasNext()) {
                        if (totalIndexRequestCounter.addAndGet(-(indexRequests.size() - indexRequestsTargetIndexUnchanged.size())) == 0) {
                            onCompletion.accept(originalThread, null);
                            return;
                        }
                        assert (totalIndexRequestCounter.get() >= 0);
                    }
                }
                if (pipelineInfoIterator.hasNext()) {
                    this.executePipelinesInBatchRequests(slots, childSlot, pipelineInfoIterator, indexRequestsTargetIndexUnchanged, actionRequestsTargetIndexUnchanged, onDropped, onFailure, totalIndexRequestCounter, onCompletion, originalThread);
                } else {
                    this.completeExecution(totalIndexRequestCounter, onCompletion, originalThread, results.size());
                }
            });
        }
        catch (Exception e) {
            StringBuilder documentLogBuilder = new StringBuilder();
            for (int i = 0; i < indexRequests.size(); ++i) {
                IndexRequest indexRequest = indexRequests.get(i);
                documentLogBuilder.append(indexRequest.index());
                documentLogBuilder.append("/");
                documentLogBuilder.append(indexRequest.id());
                if (i < indexRequests.size() - 1) {
                    documentLogBuilder.append(", ");
                }
                onFailure.accept(slots.get(i), e);
            }
            logger.debug(() -> new ParameterizedMessage("failed to execute pipeline [{}] for documents [{}]", (Object)pipelineId, (Object)documentLogBuilder.toString()), (Throwable)e);
            this.completeExecution(totalIndexRequestCounter, onCompletion, originalThread, indexRequests.size());
        }
    }

    private List<IndexRequest> getChildIndexRequests(DocWriteRequest<?> actionRequest) {
        if (actionRequest instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)actionRequest;
            return updateRequest.getChildIndexRequests();
        }
        IndexRequest childIndexRequest = TransportBulkAction.getIndexWriteRequest(actionRequest);
        if (childIndexRequest != null) {
            return List.of(childIndexRequest);
        }
        return Collections.emptyList();
    }

    private void executePipelines(int slot, Iterator<IngestPipelineInfo> pipelineInfoIterator, IndexRequest indexRequest, DocWriteRequest<?> actionRequest, IntConsumer onDropped, BiConsumer<Integer, Exception> onFailure, AtomicInteger counter, BiConsumer<Thread, Exception> onCompletion, Thread originalThread) {
        if (!pipelineInfoIterator.hasNext()) {
            throw new RuntimeException("Should not executePipelines when the pipeline iterator does not have next pipeline.");
        }
        IngestPipelineInfo pipelineInfo = pipelineInfoIterator.next();
        String pipelineId = pipelineInfo.getPipelineId();
        try {
            IngestPipelineType pipelineType = pipelineInfo.getType();
            Pipeline pipeline = this.getPipeline(pipelineId, pipelineType, actionRequest, indexRequest);
            if (pipeline == null) {
                if (!pipelineInfoIterator.hasNext()) {
                    this.completeExecution(counter, onCompletion, originalThread, 1);
                }
                return;
            }
            String originalIndex = indexRequest.indices()[0];
            this.innerExecute(slot, indexRequest, pipeline, onDropped, e -> {
                String newIndex;
                if (e != null) {
                    logger.debug(() -> new ParameterizedMessage("failed to execute pipeline [{}] for document [{}/{}]", new Object[]{pipelineId, indexRequest.index(), indexRequest.id()}), (Throwable)e);
                    onFailure.accept(slot, (Exception)e);
                }
                if (!Objects.equals(originalIndex, newIndex = indexRequest.indices()[0])) {
                    if (IngestPipelineType.FINAL.equals((Object)pipelineType) || IngestPipelineType.SYSTEM_FINAL.equals((Object)pipelineType)) {
                        this.totalMetrics.failed();
                        onFailure.accept(slot, new IllegalStateException(String.valueOf((Object)pipelineType) + " pipeline [" + pipelineId + "] can't change the target index"));
                    } else {
                        this.resetPipelineAfterIndexChange(indexRequest);
                    }
                    pipelineInfoIterator.forEachRemaining($ -> {});
                }
                if (pipelineInfoIterator.hasNext()) {
                    this.executePipelines(slot, pipelineInfoIterator, indexRequest, actionRequest, onDropped, onFailure, counter, onCompletion, originalThread);
                } else {
                    this.completeExecution(counter, onCompletion, originalThread, 1);
                }
            });
        }
        catch (Exception e2) {
            logger.debug(() -> new ParameterizedMessage("failed to execute pipeline [{}] for document [{}/{}]", new Object[]{pipelineId, indexRequest.index(), indexRequest.id()}), (Throwable)e2);
            onFailure.accept(slot, e2);
            this.completeExecution(counter, onCompletion, originalThread, 1);
        }
    }

    private void resetPipelineAfterIndexChange(IndexRequest indexRequest) {
        indexRequest.isPipelineResolved(false);
        indexRequest.setFinalPipeline(null);
        indexRequest.setSystemIngestPipeline(null);
    }

    private Pipeline getPipeline(String pipelineId, IngestPipelineType pipelineType, DocWriteRequest<?> actionRequest, IndexRequest indexRequest) {
        PipelineHolder holder = this.pipelines.get(pipelineId);
        if (IngestPipelineType.SYSTEM_FINAL.equals((Object)pipelineType)) {
            Pipeline indexPipeline = this.systemIngestPipelineCache.getSystemIngestPipeline(pipelineId);
            if (indexPipeline == null) {
                indexRequest.isPipelineResolved(false);
                this.resolveSystemIngestPipeline(actionRequest, indexRequest, this.state.metadata());
                String newPipelineId = indexRequest.getSystemIngestPipeline();
                indexRequest.setSystemIngestPipeline(NOOP_PIPELINE_NAME);
                indexPipeline = this.systemIngestPipelineCache.getSystemIngestPipeline(newPipelineId);
            }
            return indexPipeline;
        }
        return this.getPipelineFromHolder(holder, pipelineId);
    }

    private void completeExecution(@NonNull AtomicInteger counter, @NonNull BiConsumer<Thread, Exception> onCompletion, @NonNull Thread originalThread, int completedRequestSize) {
        if (counter.addAndGet(-completedRequestSize) == 0) {
            onCompletion.accept(originalThread, null);
        }
        assert (counter.get() >= 0);
    }

    private Pipeline getPipelineFromHolder(PipelineHolder holder, @NonNull String pipelineId) {
        if (holder == null) {
            throw new IllegalArgumentException("pipeline with id [" + pipelineId + "] does not exist");
        }
        return holder.pipeline;
    }

    public IngestStats stats() {
        IngestStats.Builder statsBuilder = new IngestStats.Builder();
        statsBuilder.addTotalMetrics(this.totalMetrics);
        this.pipelines.forEach((id, holder) -> {
            Pipeline pipeline = holder.pipeline;
            CompoundProcessor rootProcessor = pipeline.getCompoundProcessor();
            statsBuilder.addPipelineMetrics((String)id, pipeline.getMetrics());
            ArrayList<Tuple<Processor, OperationMetrics>> processorMetrics = new ArrayList<Tuple<Processor, OperationMetrics>>();
            IngestService.getProcessorMetrics(rootProcessor, processorMetrics);
            processorMetrics.forEach(t -> {
                Processor processor = (Processor)t.v1();
                OperationMetrics processorMetric = (OperationMetrics)t.v2();
                statsBuilder.addProcessorMetrics((String)id, IngestService.getProcessorName(processor), processor.getType(), processorMetric);
            });
        });
        return statsBuilder.build();
    }

    public void addIngestClusterStateListener(Consumer<ClusterState> listener) {
        this.ingestClusterStateListeners.add(listener);
    }

    static String getProcessorName(Processor processor) {
        String tag;
        if (processor instanceof ConditionalProcessor) {
            processor = ((ConditionalProcessor)processor).getInnerProcessor();
        }
        StringBuilder sb = new StringBuilder(5);
        sb.append(processor.getType());
        if (processor instanceof PipelineProcessor) {
            String pipelineName = ((PipelineProcessor)processor).getPipelineTemplate().newInstance(Collections.emptyMap()).execute();
            sb.append(":");
            sb.append(pipelineName);
        }
        if ((tag = processor.getTag()) != null && !tag.isEmpty()) {
            sb.append(":");
            sb.append(tag);
        }
        return sb.toString();
    }

    private void innerExecute(int slot, IndexRequest indexRequest, Pipeline pipeline, IntConsumer itemDroppedHandler, Consumer<Exception> handler) {
        if (pipeline.getProcessors().isEmpty()) {
            handler.accept(null);
            return;
        }
        long startTimeInNanos = System.nanoTime();
        this.totalMetrics.before();
        String index = indexRequest.index();
        String id = indexRequest.id();
        String routing = indexRequest.routing();
        Long version = indexRequest.version();
        VersionType versionType = indexRequest.versionType();
        Map<String, Object> sourceAsMap = indexRequest.sourceAsMap();
        IngestDocument ingestDocument = new IngestDocument(index, id, routing, version, versionType, sourceAsMap);
        ingestDocument.executePipeline(pipeline, (result, e) -> {
            long ingestTimeInMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeInNanos);
            this.totalMetrics.after(ingestTimeInMillis);
            if (e != null) {
                this.totalMetrics.failed();
                handler.accept((Exception)e);
            } else if (result == null) {
                itemDroppedHandler.accept(slot);
                handler.accept(null);
            } else {
                IngestService.updateIndexRequestWithIngestDocument(indexRequest, ingestDocument);
                handler.accept(null);
            }
        });
    }

    private void innerBatchExecute(List<Integer> slots, List<Integer> childSlots, List<IndexRequest> indexRequests, Pipeline pipeline, IntConsumer itemDroppedHandler, Consumer<List<IngestDocumentWrapper>> handler) {
        if (pipeline.getProcessors().isEmpty()) {
            handler.accept(IngestService.toIngestDocumentWrappers(slots, childSlots, indexRequests));
            return;
        }
        int size = indexRequests.size();
        long startTimeInNanos = System.nanoTime();
        this.totalMetrics.beforeN(size);
        ArrayList<IngestDocumentWrapper> ingestDocumentWrappers = new ArrayList<IngestDocumentWrapper>();
        HashMap<SlotKey, IndexRequest> slotToindexRequestMap = new HashMap<SlotKey, IndexRequest>();
        for (int i = 0; i < slots.size(); ++i) {
            slotToindexRequestMap.put(new SlotKey(slots.get(i), childSlots.get(i)), indexRequests.get(i));
            ingestDocumentWrappers.add(IngestService.toIngestDocumentWrapper(slots.get(i), childSlots.get(i), indexRequests.get(i)));
        }
        AtomicInteger counter = new AtomicInteger(size);
        List allResults = Collections.synchronizedList(new ArrayList());
        pipeline.batchExecute(ingestDocumentWrappers, results -> {
            if (results.isEmpty()) {
                return;
            }
            allResults.addAll(results);
            if (counter.addAndGet(-results.size()) == 0) {
                long ingestTimeInMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeInNanos);
                this.totalMetrics.afterN(size, ingestTimeInMillis);
                ArrayList<IngestDocumentWrapper> succeeded = new ArrayList<IngestDocumentWrapper>();
                ArrayList<IngestDocumentWrapper> dropped = new ArrayList<IngestDocumentWrapper>();
                ArrayList<IngestDocumentWrapper> exceptions = new ArrayList<IngestDocumentWrapper>();
                for (IngestDocumentWrapper result : allResults) {
                    if (result.getException() != null) {
                        exceptions.add(result);
                        continue;
                    }
                    if (result.getIngestDocument() == null) {
                        dropped.add(result);
                        continue;
                    }
                    succeeded.add(result);
                }
                if (!exceptions.isEmpty()) {
                    this.totalMetrics.failedN(exceptions.size());
                }
                if (!dropped.isEmpty()) {
                    dropped.forEach(t -> itemDroppedHandler.accept(t.getSlot()));
                }
                for (IngestDocumentWrapper ingestDocumentWrapper : succeeded) {
                    SlotKey slotKey = new SlotKey(ingestDocumentWrapper.getSlot(), ingestDocumentWrapper.getChildSlot());
                    IngestService.updateIndexRequestWithIngestDocument((IndexRequest)slotToindexRequestMap.get(slotKey), ingestDocumentWrapper.getIngestDocument());
                }
                handler.accept(allResults);
            }
            assert (counter.get() >= 0);
        });
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        this.invalidateSystemIngestPipeline(event);
        this.state = event.state();
        if (this.state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        this.ingestClusterStateListeners.forEach(consumer -> consumer.accept(this.state));
        IngestMetadata newIngestMetadata = (IngestMetadata)this.state.getMetadata().custom(INGEST_ORIGIN);
        if (newIngestMetadata == null) {
            return;
        }
        try {
            this.innerUpdatePipelines(newIngestMetadata);
        }
        catch (OpenSearchParseException e) {
            logger.warn("failed to update ingest pipelines", (Throwable)e);
        }
    }

    private void invalidateSystemIngestPipeline(@NonNull ClusterChangedEvent event) {
        Map<String, IndexMetadata> currentIndices = event.state().metadata().indices();
        Map<String, IndexMetadata> previousIndices = event.previousState().metadata().indices();
        for (Map.Entry<String, IndexMetadata> entry : previousIndices.entrySet()) {
            String indexName = entry.getKey();
            IndexMetadata previousIndexMetadata = entry.getValue();
            assert (previousIndexMetadata != null) : "IndexMetadata in the previous state metadata indices should not be null.";
            IndexMetadata currentIndexMetadata = currentIndices.get(indexName);
            if (currentIndexMetadata != null && !ClusterChangedEvent.indexMetadataChanged(previousIndexMetadata, currentIndexMetadata)) continue;
            this.systemIngestPipelineCache.invalidateCacheForIndex(previousIndexMetadata.getIndex().toString());
            this.systemIngestPipelineCache.invalidateCacheForIndex(this.createIndexIdWithTemplateSuffix(previousIndexMetadata.getIndex().getName()));
        }
    }

    void innerUpdatePipelines(IngestMetadata newIngestMetadata) {
        Map<String, PipelineHolder> existingPipelines = this.pipelines;
        HashMap<String, PipelineHolder> newPipelines = null;
        ArrayList<OpenSearchParseException> exceptions = null;
        for (PipelineConfiguration pipelineConfiguration : newIngestMetadata.getPipelines().values()) {
            PipelineHolder previous = existingPipelines.get(pipelineConfiguration.getId());
            if (previous != null && previous.configuration.equals(pipelineConfiguration)) continue;
            if (newPipelines == null) {
                newPipelines = new HashMap<String, PipelineHolder>(existingPipelines);
            }
            try {
                Pipeline newPipeline = Pipeline.create(pipelineConfiguration.getId(), pipelineConfiguration.getConfigAsMap(), this.processorFactories, this.scriptService);
                newPipelines.put(pipelineConfiguration.getId(), new PipelineHolder(pipelineConfiguration, newPipeline));
                if (previous == null) continue;
                Pipeline oldPipeline = previous.pipeline;
                newPipeline.getMetrics().add(oldPipeline.getMetrics());
                ArrayList<Tuple<Processor, OperationMetrics>> oldPerProcessMetrics = new ArrayList<Tuple<Processor, OperationMetrics>>();
                ArrayList<Tuple<Processor, OperationMetrics>> newPerProcessMetrics = new ArrayList<Tuple<Processor, OperationMetrics>>();
                IngestService.getProcessorMetrics(oldPipeline.getCompoundProcessor(), oldPerProcessMetrics);
                IngestService.getProcessorMetrics(newPipeline.getCompoundProcessor(), newPerProcessMetrics);
                if (newPerProcessMetrics.size() != oldPerProcessMetrics.size()) continue;
                Iterator oldMetricsIterator = oldPerProcessMetrics.iterator();
                for (Tuple tuple : newPerProcessMetrics) {
                    String type = ((Processor)tuple.v1()).getType();
                    OperationMetrics metric = (OperationMetrics)tuple.v2();
                    if (!oldMetricsIterator.hasNext()) continue;
                    Tuple oldCompositeMetric = (Tuple)oldMetricsIterator.next();
                    String oldType = ((Processor)oldCompositeMetric.v1()).getType();
                    OperationMetrics oldMetric = (OperationMetrics)oldCompositeMetric.v2();
                    if (!type.equals(oldType)) continue;
                    metric.add(oldMetric);
                }
            }
            catch (OpenSearchParseException e) {
                Pipeline pipeline = IngestService.substitutePipeline(pipelineConfiguration.getId(), e);
                newPipelines.put(pipelineConfiguration.getId(), new PipelineHolder(pipelineConfiguration, pipeline));
                if (exceptions == null) {
                    exceptions = new ArrayList<OpenSearchParseException>();
                }
                exceptions.add(e);
            }
            catch (Exception e) {
                OpenSearchParseException parseException = new OpenSearchParseException("Error updating pipeline with id [" + pipelineConfiguration.getId() + "]", (Throwable)e, new Object[0]);
                Pipeline pipeline = IngestService.substitutePipeline(pipelineConfiguration.getId(), parseException);
                newPipelines.put(pipelineConfiguration.getId(), new PipelineHolder(pipelineConfiguration, pipeline));
                if (exceptions == null) {
                    exceptions = new ArrayList();
                }
                exceptions.add(parseException);
            }
        }
        for (Map.Entry entry : existingPipelines.entrySet()) {
            if (newIngestMetadata.getPipelines().get(entry.getKey()) != null) continue;
            if (newPipelines == null) {
                newPipelines = new HashMap<String, PipelineHolder>(existingPipelines);
            }
            newPipelines.remove(entry.getKey());
        }
        if (newPipelines != null) {
            this.pipelines = Collections.unmodifiableMap(newPipelines);
            if (exceptions != null) {
                ExceptionsHelper.rethrowAndSuppress(exceptions);
            }
        }
    }

    public <P extends Processor> List<P> getProcessorsInPipeline(String pipelineId, Class<P> clazz) {
        Pipeline pipeline = this.getPipeline(pipelineId);
        if (pipeline == null) {
            throw new IllegalArgumentException("pipeline with id [" + pipelineId + "] does not exist");
        }
        ArrayList<Processor> processors = new ArrayList<Processor>();
        block0: for (Processor processor : pipeline.flattenAllProcessors()) {
            if (clazz.isAssignableFrom(processor.getClass())) {
                processors.add((Processor)clazz.cast(processor));
            }
            while (processor instanceof WrappingProcessor) {
                WrappingProcessor wrappingProcessor = (WrappingProcessor)processor;
                if (clazz.isAssignableFrom(wrappingProcessor.getInnerProcessor().getClass())) {
                    processors.add((Processor)clazz.cast(wrappingProcessor.getInnerProcessor()));
                }
                if (wrappingProcessor != (processor = wrappingProcessor.getInnerProcessor())) continue;
                continue block0;
            }
        }
        return processors;
    }

    private static Pipeline substitutePipeline(String id, OpenSearchParseException e) {
        String tag = e.getHeaderKeys().contains("processor_tag") ? (String)e.getHeader("processor_tag").get(0) : null;
        final String type = e.getHeaderKeys().contains("processor_type") ? (String)e.getHeader("processor_type").get(0) : "unknown";
        final String errorMessage = "pipeline with id [" + id + "] could not be loaded, caused by [" + e.getDetailedMessage() + "]";
        AbstractProcessor failureProcessor = new AbstractProcessor(tag, "this is a placeholder processor"){

            @Override
            public IngestDocument execute(IngestDocument ingestDocument) {
                throw new IllegalStateException(errorMessage);
            }

            @Override
            public String getType() {
                return type;
            }
        };
        String description = "this is a place holder pipeline, because pipeline with id [" + id + "] could not be loaded";
        return new Pipeline(id, description, null, new CompoundProcessor(failureProcessor));
    }

    public static void updateIndexRequestWithIngestDocument(IndexRequest indexRequest, IngestDocument ingestDocument) {
        Map<IngestDocument.Metadata, Object> metadataMap = ingestDocument.extractMetadata();
        indexRequest.index((String)metadataMap.get((Object)IngestDocument.Metadata.INDEX));
        indexRequest.id((String)metadataMap.get((Object)IngestDocument.Metadata.ID));
        indexRequest.routing((String)metadataMap.get((Object)IngestDocument.Metadata.ROUTING));
        indexRequest.version(((Number)metadataMap.get((Object)IngestDocument.Metadata.VERSION)).longValue());
        if (metadataMap.get((Object)IngestDocument.Metadata.VERSION_TYPE) != null) {
            indexRequest.versionType(VersionType.fromString((String)metadataMap.get((Object)IngestDocument.Metadata.VERSION_TYPE)));
        }
        if (metadataMap.get((Object)IngestDocument.Metadata.IF_SEQ_NO) != null) {
            indexRequest.setIfSeqNo(((Number)metadataMap.get((Object)IngestDocument.Metadata.IF_SEQ_NO)).longValue());
        }
        if (metadataMap.get((Object)IngestDocument.Metadata.IF_PRIMARY_TERM) != null) {
            indexRequest.setIfPrimaryTerm(((Number)metadataMap.get((Object)IngestDocument.Metadata.IF_PRIMARY_TERM)).longValue());
        }
        indexRequest.source(ingestDocument.getSourceAndMetadata(), indexRequest.getContentType());
    }

    static IngestDocument toIngestDocument(IndexRequest indexRequest) {
        return new IngestDocument(indexRequest.index(), indexRequest.id(), indexRequest.routing(), indexRequest.version(), indexRequest.versionType(), indexRequest.sourceAsMap());
    }

    private static IngestDocumentWrapper toIngestDocumentWrapper(int slot, int childSlot, IndexRequest indexRequest) {
        return new IngestDocumentWrapper(slot, childSlot, IngestService.toIngestDocument(indexRequest), null);
    }

    private static List<IngestDocumentWrapper> toIngestDocumentWrappers(List<Integer> slots, List<Integer> childSlots, List<IndexRequest> indexRequests) {
        ArrayList<IngestDocumentWrapper> ingestDocumentWrappers = new ArrayList<IngestDocumentWrapper>();
        for (int i = 0; i < slots.size(); ++i) {
            ingestDocumentWrappers.add(IngestService.toIngestDocumentWrapper(slots.get(i), childSlots.get(i), indexRequests.get(i)));
        }
        return ingestDocumentWrappers;
    }

    private static Map<SlotKey, IndexRequest> createSlotIndexRequestMap(List<Integer> slots, List<Integer> childSlots, List<IndexRequest> indexRequests) {
        HashMap<SlotKey, IndexRequest> slotIndexRequestMap = new HashMap<SlotKey, IndexRequest>();
        for (int i = 0; i < slots.size(); ++i) {
            slotIndexRequestMap.put(new SlotKey(slots.get(i), childSlots.get(i)), indexRequests.get(i));
        }
        return slotIndexRequestMap;
    }

    static class PipelineHolder {
        final PipelineConfiguration configuration;
        final Pipeline pipeline;

        PipelineHolder(PipelineConfiguration configuration, Pipeline pipeline) {
            this.configuration = Objects.requireNonNull(configuration);
            this.pipeline = Objects.requireNonNull(pipeline);
        }
    }

    private record SlotKey(int slot, int childSlot) {
    }
}

