/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.mutiny;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import io.smallrye.mutiny.Uni;
import java.util.Optional;
import java.util.concurrent.CancellationException;

public class MutinyTracingHelper {
    public static <T> Uni<T> wrapWithSpan(Tracer tracer, String spanName, Uni<T> pipeline) {
        return MutinyTracingHelper.wrapWithSpan(tracer, Optional.of(Context.current()), spanName, pipeline);
    }

    public static <T> Uni<T> wrapWithSpan(Tracer tracer, Optional<Context> parentContext, String spanName, Uni<T> pipeline) {
        return MutinyTracingHelper.runOnDuplicatedContext(Uni.createFrom().deferred(() -> {
            SpanBuilder spanBuilder = tracer.spanBuilder(spanName);
            if (parentContext.isPresent()) {
                spanBuilder.setParent((Context)parentContext.get());
            } else {
                spanBuilder.setNoParent();
            }
            Span span = spanBuilder.startSpan();
            Scope scope = span.makeCurrent();
            return pipeline.onTermination().invoke((o, throwable, isCancelled) -> {
                try {
                    if (Boolean.TRUE.equals(isCancelled)) {
                        span.recordException((Throwable)new CancellationException());
                    } else if (throwable != null) {
                        span.recordException(throwable);
                    }
                    span.end();
                }
                finally {
                    scope.close();
                }
            });
        }));
    }

    private static <T> Uni<T> runOnDuplicatedContext(Uni<T> deferred) {
        io.vertx.core.Context context = QuarkusContextStorage.getVertxContext();
        return deferred.runSubscriptionOn(runnable -> {
            if (context != null) {
                context.runOnContext(v -> runnable.run());
            } else {
                runnable.run();
            }
        });
    }
}

