/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.io.OsmApiException;

public class OsmApiPrimitiveGoneException
extends OsmApiException {
    public static final String ERROR_HEADER_PATTERN = "The (\\S+) with the id (\\d+) has already been deleted";
    private final OsmPrimitiveType type;
    private final long id;

    public OsmApiPrimitiveGoneException(String errorHeader, String errorBody) {
        super(410, errorHeader, errorBody);
        if (errorHeader != null) {
            Matcher m = Pattern.compile(ERROR_HEADER_PATTERN).matcher(errorHeader);
            if (m.matches()) {
                this.type = OsmPrimitiveType.from(m.group(1));
                this.id = Long.parseLong(m.group(2));
            } else {
                this.type = null;
                this.id = 0L;
            }
        } else {
            this.type = null;
            this.id = 0L;
        }
    }

    public boolean isKnownPrimitive() {
        return this.id > 0L && this.type != null;
    }

    public OsmPrimitiveType getPrimitiveType() {
        return this.type;
    }

    public long getPrimitiveId() {
        return this.id;
    }
}

