/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

class SortedProperties
extends Properties {
    private static final long serialVersionUID = 7567765340218227372L;

    SortedProperties(Properties defaults) {
        super(defaults);
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return Collections.enumeration(new TreeSet<Object>(super.keySet()));
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        TreeSet<Map.Entry<Object, Object>> treeSet = new TreeSet<Map.Entry<Object, Object>>(Comparator.comparing(e -> (Comparable)e.getKey()));
        treeSet.addAll(super.entrySet());
        return treeSet;
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        super.store(new StripFirstLineStream(out), null);
    }

    private static class StripFirstLineStream
    extends FilterOutputStream {
        private boolean firstlineseen = false;

        public StripFirstLineStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            if (this.firstlineseen) {
                super.write(b);
            } else if (b == 10) {
                this.firstlineseen = true;
            }
        }
    }
}

