/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "xdg-desktop-portal-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringStringStringVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_handle,
        const gchar *arg_app_id,
        const gchar *arg_parent_window,
        const gchar *arg_title,
        GVariant *arg_options,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringStringStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 7);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringStringStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              g_marshal_value_peek_string (param_values + 5),
              g_marshal_value_peek_variant (param_values + 6),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_STRING_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringStringStringVariantFunc)
       (void *data1,
        const gchar *arg_app_id,
        const gchar *arg_id,
        const gchar *arg_action,
        GVariant *arg_parameter,
        void *data2);
  _GDbusCodegenMarshalVoid_StringStringStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringStringStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            g_marshal_value_peek_string (param_values + 3),
            g_marshal_value_peek_variant (param_values + 4),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_STRING_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectObjectStringStringVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GUnixFDList *arg_fd_list,
        const gchar *arg_app_id,
        const gchar *arg_id,
        GVariant *arg_notification,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectObjectStringStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectObjectStringStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_object (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              g_marshal_value_peek_variant (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_app_id,
        const gchar *arg_id,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringStringVariantFunc)
       (void *data1,
        const gchar *arg_namespace,
        const gchar *arg_key,
        GVariant *arg_value,
        void *data2);
  _GDbusCodegenMarshalVoid_StringStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            g_marshal_value_peek_variant (param_values + 3),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBoxedFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *const *arg_namespaces,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBoxedFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBoxedFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boxed (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.FileChooser
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:PmpImplFileChooser
 * @title: PmpImplFileChooser
 * @short_description: Generated C code for the org.freedesktop.impl.portal.FileChooser D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.FileChooser ---- */

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_open_file_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_open_file_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_open_file_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_open_file_IN_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_open_file_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _pmp_impl_file_chooser_method_info_open_file_IN_ARG_pointers[] =
{
  &_pmp_impl_file_chooser_method_info_open_file_IN_ARG_handle.parent_struct,
  &_pmp_impl_file_chooser_method_info_open_file_IN_ARG_app_id.parent_struct,
  &_pmp_impl_file_chooser_method_info_open_file_IN_ARG_parent_window.parent_struct,
  &_pmp_impl_file_chooser_method_info_open_file_IN_ARG_title.parent_struct,
  &_pmp_impl_file_chooser_method_info_open_file_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_open_file_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_open_file_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _pmp_impl_file_chooser_method_info_open_file_OUT_ARG_pointers[] =
{
  &_pmp_impl_file_chooser_method_info_open_file_OUT_ARG_response.parent_struct,
  &_pmp_impl_file_chooser_method_info_open_file_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _pmp_impl_file_chooser_method_open_file_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _pmp_impl_file_chooser_method_open_file_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _pmp_impl_file_chooser_method_open_file_annotation_info_pointers[] =
{
  &_pmp_impl_file_chooser_method_open_file_annotation_info_0,
  &_pmp_impl_file_chooser_method_open_file_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _pmp_impl_file_chooser_method_info_open_file =
{
  {
    -1,
    (gchar *) "OpenFile",
    (GDBusArgInfo **) &_pmp_impl_file_chooser_method_info_open_file_IN_ARG_pointers,
    (GDBusArgInfo **) &_pmp_impl_file_chooser_method_info_open_file_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_pmp_impl_file_chooser_method_open_file_annotation_info_pointers
  },
  "handle-open-file",
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_save_file_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_save_file_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_save_file_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_save_file_IN_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_save_file_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _pmp_impl_file_chooser_method_info_save_file_IN_ARG_pointers[] =
{
  &_pmp_impl_file_chooser_method_info_save_file_IN_ARG_handle.parent_struct,
  &_pmp_impl_file_chooser_method_info_save_file_IN_ARG_app_id.parent_struct,
  &_pmp_impl_file_chooser_method_info_save_file_IN_ARG_parent_window.parent_struct,
  &_pmp_impl_file_chooser_method_info_save_file_IN_ARG_title.parent_struct,
  &_pmp_impl_file_chooser_method_info_save_file_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_save_file_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_save_file_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _pmp_impl_file_chooser_method_info_save_file_OUT_ARG_pointers[] =
{
  &_pmp_impl_file_chooser_method_info_save_file_OUT_ARG_response.parent_struct,
  &_pmp_impl_file_chooser_method_info_save_file_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _pmp_impl_file_chooser_method_save_file_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _pmp_impl_file_chooser_method_save_file_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _pmp_impl_file_chooser_method_save_file_annotation_info_pointers[] =
{
  &_pmp_impl_file_chooser_method_save_file_annotation_info_0,
  &_pmp_impl_file_chooser_method_save_file_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _pmp_impl_file_chooser_method_info_save_file =
{
  {
    -1,
    (gchar *) "SaveFile",
    (GDBusArgInfo **) &_pmp_impl_file_chooser_method_info_save_file_IN_ARG_pointers,
    (GDBusArgInfo **) &_pmp_impl_file_chooser_method_info_save_file_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_pmp_impl_file_chooser_method_save_file_annotation_info_pointers
  },
  "handle-save-file",
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_save_files_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_save_files_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_save_files_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_save_files_IN_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_save_files_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _pmp_impl_file_chooser_method_info_save_files_IN_ARG_pointers[] =
{
  &_pmp_impl_file_chooser_method_info_save_files_IN_ARG_handle.parent_struct,
  &_pmp_impl_file_chooser_method_info_save_files_IN_ARG_app_id.parent_struct,
  &_pmp_impl_file_chooser_method_info_save_files_IN_ARG_parent_window.parent_struct,
  &_pmp_impl_file_chooser_method_info_save_files_IN_ARG_title.parent_struct,
  &_pmp_impl_file_chooser_method_info_save_files_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_save_files_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_file_chooser_method_info_save_files_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _pmp_impl_file_chooser_method_info_save_files_OUT_ARG_pointers[] =
{
  &_pmp_impl_file_chooser_method_info_save_files_OUT_ARG_response.parent_struct,
  &_pmp_impl_file_chooser_method_info_save_files_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _pmp_impl_file_chooser_method_save_files_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _pmp_impl_file_chooser_method_save_files_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _pmp_impl_file_chooser_method_save_files_annotation_info_pointers[] =
{
  &_pmp_impl_file_chooser_method_save_files_annotation_info_0,
  &_pmp_impl_file_chooser_method_save_files_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _pmp_impl_file_chooser_method_info_save_files =
{
  {
    -1,
    (gchar *) "SaveFiles",
    (GDBusArgInfo **) &_pmp_impl_file_chooser_method_info_save_files_IN_ARG_pointers,
    (GDBusArgInfo **) &_pmp_impl_file_chooser_method_info_save_files_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_pmp_impl_file_chooser_method_save_files_annotation_info_pointers
  },
  "handle-save-files",
  FALSE
};

static const GDBusMethodInfo * const _pmp_impl_file_chooser_method_info_pointers[] =
{
  &_pmp_impl_file_chooser_method_info_open_file.parent_struct,
  &_pmp_impl_file_chooser_method_info_save_file.parent_struct,
  &_pmp_impl_file_chooser_method_info_save_files.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _pmp_impl_file_chooser_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.FileChooser",
    (GDBusMethodInfo **) &_pmp_impl_file_chooser_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "file-chooser",
};


/**
 * pmp_impl_file_chooser_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
pmp_impl_file_chooser_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_pmp_impl_file_chooser_interface_info.parent_struct;
}

/**
 * pmp_impl_file_chooser_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #PmpImplFileChooser interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
pmp_impl_file_chooser_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
pmp_impl_file_chooser_method_marshal_open_file (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
pmp_impl_file_chooser_method_marshal_save_file (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
pmp_impl_file_chooser_method_marshal_save_files (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * PmpImplFileChooser:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link>.
 */

/**
 * PmpImplFileChooserIface:
 * @parent_iface: The parent interface.
 * @handle_open_file: Handler for the #PmpImplFileChooser::handle-open-file signal.
 * @handle_save_file: Handler for the #PmpImplFileChooser::handle-save-file signal.
 * @handle_save_files: Handler for the #PmpImplFileChooser::handle-save-files signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link>.
 */

typedef PmpImplFileChooserIface PmpImplFileChooserInterface;
G_DEFINE_INTERFACE (PmpImplFileChooser, pmp_impl_file_chooser, G_TYPE_OBJECT)

static void
pmp_impl_file_chooser_default_init (PmpImplFileChooserIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * PmpImplFileChooser::handle-open-file:
   * @object: A #PmpImplFileChooser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_title: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.OpenFile">OpenFile()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call pmp_impl_file_chooser_complete_open_file() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-file",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PmpImplFileChooserIface, handle_open_file),
    g_signal_accumulator_true_handled,
    NULL,
      pmp_impl_file_chooser_method_marshal_open_file,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * PmpImplFileChooser::handle-save-file:
   * @object: A #PmpImplFileChooser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_title: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFile">SaveFile()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call pmp_impl_file_chooser_complete_save_file() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-save-file",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PmpImplFileChooserIface, handle_save_file),
    g_signal_accumulator_true_handled,
    NULL,
      pmp_impl_file_chooser_method_marshal_save_file,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * PmpImplFileChooser::handle-save-files:
   * @object: A #PmpImplFileChooser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_title: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFiles">SaveFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call pmp_impl_file_chooser_complete_save_files() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-save-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PmpImplFileChooserIface, handle_save_files),
    g_signal_accumulator_true_handled,
    NULL,
      pmp_impl_file_chooser_method_marshal_save_files,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * pmp_impl_file_chooser_call_open_file:
 * @proxy: A #PmpImplFileChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.OpenFile">OpenFile()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_file_chooser_call_open_file_finish() to get the result of the operation.
 *
 * See pmp_impl_file_chooser_call_open_file_sync() for the synchronous, blocking version of this method.
 */
void
pmp_impl_file_chooser_call_open_file (
    PmpImplFileChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "OpenFile",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * pmp_impl_file_chooser_call_open_file_finish:
 * @proxy: A #PmpImplFileChooserProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_file_chooser_call_open_file().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with pmp_impl_file_chooser_call_open_file().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_file_chooser_call_open_file_finish (
    PmpImplFileChooser *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_file_chooser_call_open_file_sync:
 * @proxy: A #PmpImplFileChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.OpenFile">OpenFile()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_file_chooser_call_open_file() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_file_chooser_call_open_file_sync (
    PmpImplFileChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "OpenFile",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_file_chooser_call_save_file:
 * @proxy: A #PmpImplFileChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFile">SaveFile()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_file_chooser_call_save_file_finish() to get the result of the operation.
 *
 * See pmp_impl_file_chooser_call_save_file_sync() for the synchronous, blocking version of this method.
 */
void
pmp_impl_file_chooser_call_save_file (
    PmpImplFileChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SaveFile",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * pmp_impl_file_chooser_call_save_file_finish:
 * @proxy: A #PmpImplFileChooserProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_file_chooser_call_save_file().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with pmp_impl_file_chooser_call_save_file().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_file_chooser_call_save_file_finish (
    PmpImplFileChooser *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_file_chooser_call_save_file_sync:
 * @proxy: A #PmpImplFileChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFile">SaveFile()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_file_chooser_call_save_file() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_file_chooser_call_save_file_sync (
    PmpImplFileChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SaveFile",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_file_chooser_call_save_files:
 * @proxy: A #PmpImplFileChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFiles">SaveFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_file_chooser_call_save_files_finish() to get the result of the operation.
 *
 * See pmp_impl_file_chooser_call_save_files_sync() for the synchronous, blocking version of this method.
 */
void
pmp_impl_file_chooser_call_save_files (
    PmpImplFileChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SaveFiles",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * pmp_impl_file_chooser_call_save_files_finish:
 * @proxy: A #PmpImplFileChooserProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_file_chooser_call_save_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with pmp_impl_file_chooser_call_save_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_file_chooser_call_save_files_finish (
    PmpImplFileChooser *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_file_chooser_call_save_files_sync:
 * @proxy: A #PmpImplFileChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFiles">SaveFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_file_chooser_call_save_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_file_chooser_call_save_files_sync (
    PmpImplFileChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SaveFiles",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_file_chooser_complete_open_file:
 * @object: A #PmpImplFileChooser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.OpenFile">OpenFile()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
pmp_impl_file_chooser_complete_open_file (
    PmpImplFileChooser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * pmp_impl_file_chooser_complete_save_file:
 * @object: A #PmpImplFileChooser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFile">SaveFile()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
pmp_impl_file_chooser_complete_save_file (
    PmpImplFileChooser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * pmp_impl_file_chooser_complete_save_files:
 * @object: A #PmpImplFileChooser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFiles">SaveFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
pmp_impl_file_chooser_complete_save_files (
    PmpImplFileChooser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/* ------------------------------------------------------------------------ */

/**
 * PmpImplFileChooserProxy:
 *
 * The #PmpImplFileChooserProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PmpImplFileChooserProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PmpImplFileChooserProxy.
 */

struct _PmpImplFileChooserProxyPrivate
{
  GData *qdata;
};

static void pmp_impl_file_chooser_proxy_iface_init (PmpImplFileChooserIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PmpImplFileChooserProxy, pmp_impl_file_chooser_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (PmpImplFileChooserProxy)
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_FILE_CHOOSER, pmp_impl_file_chooser_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PmpImplFileChooserProxy, pmp_impl_file_chooser_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_FILE_CHOOSER, pmp_impl_file_chooser_proxy_iface_init))

#endif
static void
pmp_impl_file_chooser_proxy_finalize (GObject *object)
{
  PmpImplFileChooserProxy *proxy = PMP_IMPL_FILE_CHOOSER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (pmp_impl_file_chooser_proxy_parent_class)->finalize (object);
}

static void
pmp_impl_file_chooser_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
pmp_impl_file_chooser_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
pmp_impl_file_chooser_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_pmp_impl_file_chooser_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], PMP_IMPL_TYPE_FILE_CHOOSER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PMP_IMPL_TYPE_FILE_CHOOSER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
pmp_impl_file_chooser_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  PmpImplFileChooserProxy *proxy = PMP_IMPL_FILE_CHOOSER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_file_chooser_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_file_chooser_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
pmp_impl_file_chooser_proxy_init (PmpImplFileChooserProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = pmp_impl_file_chooser_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, PMP_IMPL_TYPE_FILE_CHOOSER_PROXY, PmpImplFileChooserProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), pmp_impl_file_chooser_interface_info ());
}

static void
pmp_impl_file_chooser_proxy_class_init (PmpImplFileChooserProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = pmp_impl_file_chooser_proxy_finalize;
  gobject_class->get_property = pmp_impl_file_chooser_proxy_get_property;
  gobject_class->set_property = pmp_impl_file_chooser_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = pmp_impl_file_chooser_proxy_g_signal;
  proxy_class->g_properties_changed = pmp_impl_file_chooser_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PmpImplFileChooserProxyPrivate));
#endif
}

static void
pmp_impl_file_chooser_proxy_iface_init (PmpImplFileChooserIface *iface G_GNUC_UNUSED)
{
}

/**
 * pmp_impl_file_chooser_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_file_chooser_proxy_new_finish() to get the result of the operation.
 *
 * See pmp_impl_file_chooser_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
pmp_impl_file_chooser_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PMP_IMPL_TYPE_FILE_CHOOSER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.FileChooser", NULL);
}

/**
 * pmp_impl_file_chooser_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_file_chooser_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with pmp_impl_file_chooser_proxy_new().
 *
 * Returns: (transfer full) (type PmpImplFileChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplFileChooser *
pmp_impl_file_chooser_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PMP_IMPL_FILE_CHOOSER (ret);
  else
    return NULL;
}

/**
 * pmp_impl_file_chooser_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_file_chooser_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PmpImplFileChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplFileChooser *
pmp_impl_file_chooser_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PMP_IMPL_TYPE_FILE_CHOOSER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.FileChooser", NULL);
  if (ret != NULL)
    return PMP_IMPL_FILE_CHOOSER (ret);
  else
    return NULL;
}


/**
 * pmp_impl_file_chooser_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like pmp_impl_file_chooser_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_file_chooser_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See pmp_impl_file_chooser_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
pmp_impl_file_chooser_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PMP_IMPL_TYPE_FILE_CHOOSER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.FileChooser", NULL);
}

/**
 * pmp_impl_file_chooser_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_file_chooser_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with pmp_impl_file_chooser_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type PmpImplFileChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplFileChooser *
pmp_impl_file_chooser_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PMP_IMPL_FILE_CHOOSER (ret);
  else
    return NULL;
}

/**
 * pmp_impl_file_chooser_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like pmp_impl_file_chooser_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_file_chooser_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PmpImplFileChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplFileChooser *
pmp_impl_file_chooser_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PMP_IMPL_TYPE_FILE_CHOOSER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.FileChooser", NULL);
  if (ret != NULL)
    return PMP_IMPL_FILE_CHOOSER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * PmpImplFileChooserSkeleton:
 *
 * The #PmpImplFileChooserSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PmpImplFileChooserSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PmpImplFileChooserSkeleton.
 */

struct _PmpImplFileChooserSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_pmp_impl_file_chooser_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  PmpImplFileChooserSkeleton *skeleton = PMP_IMPL_FILE_CHOOSER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], PMP_IMPL_TYPE_FILE_CHOOSER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PMP_IMPL_TYPE_FILE_CHOOSER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_pmp_impl_file_chooser_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  PmpImplFileChooserSkeleton *skeleton = PMP_IMPL_FILE_CHOOSER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_file_chooser_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_pmp_impl_file_chooser_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  PmpImplFileChooserSkeleton *skeleton = PMP_IMPL_FILE_CHOOSER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_file_chooser_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _pmp_impl_file_chooser_skeleton_vtable =
{
  _pmp_impl_file_chooser_skeleton_handle_method_call,
  _pmp_impl_file_chooser_skeleton_handle_get_property,
  _pmp_impl_file_chooser_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
pmp_impl_file_chooser_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return pmp_impl_file_chooser_interface_info ();
}

static GDBusInterfaceVTable *
pmp_impl_file_chooser_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_pmp_impl_file_chooser_skeleton_vtable;
}

static GVariant *
pmp_impl_file_chooser_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  PmpImplFileChooserSkeleton *skeleton = PMP_IMPL_FILE_CHOOSER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_pmp_impl_file_chooser_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _pmp_impl_file_chooser_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _pmp_impl_file_chooser_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _pmp_impl_file_chooser_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.FileChooser", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
pmp_impl_file_chooser_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void pmp_impl_file_chooser_skeleton_iface_init (PmpImplFileChooserIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PmpImplFileChooserSkeleton, pmp_impl_file_chooser_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (PmpImplFileChooserSkeleton)
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_FILE_CHOOSER, pmp_impl_file_chooser_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PmpImplFileChooserSkeleton, pmp_impl_file_chooser_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_FILE_CHOOSER, pmp_impl_file_chooser_skeleton_iface_init))

#endif
static void
pmp_impl_file_chooser_skeleton_finalize (GObject *object)
{
  PmpImplFileChooserSkeleton *skeleton = PMP_IMPL_FILE_CHOOSER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (pmp_impl_file_chooser_skeleton_parent_class)->finalize (object);
}

static void
pmp_impl_file_chooser_skeleton_init (PmpImplFileChooserSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = pmp_impl_file_chooser_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, PMP_IMPL_TYPE_FILE_CHOOSER_SKELETON, PmpImplFileChooserSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
pmp_impl_file_chooser_skeleton_class_init (PmpImplFileChooserSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = pmp_impl_file_chooser_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = pmp_impl_file_chooser_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = pmp_impl_file_chooser_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = pmp_impl_file_chooser_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = pmp_impl_file_chooser_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PmpImplFileChooserSkeletonPrivate));
#endif
}

static void
pmp_impl_file_chooser_skeleton_iface_init (PmpImplFileChooserIface *iface G_GNUC_UNUSED)
{
}

/**
 * pmp_impl_file_chooser_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link>.
 *
 * Returns: (transfer full) (type PmpImplFileChooserSkeleton): The skeleton object.
 */
PmpImplFileChooser *
pmp_impl_file_chooser_skeleton_new (void)
{
  return PMP_IMPL_FILE_CHOOSER (g_object_new (PMP_IMPL_TYPE_FILE_CHOOSER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Notification
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:PmpImplNotification
 * @title: PmpImplNotification
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Notification D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link> D-Bus interface in C.
 */

enum
{
  PMP_IMPL__NOTIFICATION_ACTION_INVOKED,
};

static unsigned PMP_IMPL__NOTIFICATION_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.freedesktop.impl.portal.Notification ---- */

static const _ExtendedGDBusArgInfo _pmp_impl_notification_method_info_add_notification_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_notification_method_info_add_notification_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_notification_method_info_add_notification_IN_ARG_notification =
{
  {
    -1,
    (gchar *) "notification",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _pmp_impl_notification_method_info_add_notification_IN_ARG_pointers[] =
{
  &_pmp_impl_notification_method_info_add_notification_IN_ARG_app_id.parent_struct,
  &_pmp_impl_notification_method_info_add_notification_IN_ARG_id.parent_struct,
  &_pmp_impl_notification_method_info_add_notification_IN_ARG_notification.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _pmp_impl_notification_method_add_notification_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In2",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _pmp_impl_notification_method_add_notification_annotation_info_pointers[] =
{
  &_pmp_impl_notification_method_add_notification_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _pmp_impl_notification_method_info_add_notification =
{
  {
    -1,
    (gchar *) "AddNotification",
    (GDBusArgInfo **) &_pmp_impl_notification_method_info_add_notification_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_pmp_impl_notification_method_add_notification_annotation_info_pointers
  },
  "handle-add-notification",
  TRUE
};

static const _ExtendedGDBusArgInfo _pmp_impl_notification_method_info_remove_notification_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_notification_method_info_remove_notification_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _pmp_impl_notification_method_info_remove_notification_IN_ARG_pointers[] =
{
  &_pmp_impl_notification_method_info_remove_notification_IN_ARG_app_id.parent_struct,
  &_pmp_impl_notification_method_info_remove_notification_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _pmp_impl_notification_method_info_remove_notification =
{
  {
    -1,
    (gchar *) "RemoveNotification",
    (GDBusArgInfo **) &_pmp_impl_notification_method_info_remove_notification_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-remove-notification",
  FALSE
};

static const GDBusMethodInfo * const _pmp_impl_notification_method_info_pointers[] =
{
  &_pmp_impl_notification_method_info_add_notification.parent_struct,
  &_pmp_impl_notification_method_info_remove_notification.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _pmp_impl_notification_signal_info_action_invoked_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_notification_signal_info_action_invoked_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_notification_signal_info_action_invoked_ARG_action =
{
  {
    -1,
    (gchar *) "action",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_notification_signal_info_action_invoked_ARG_parameter =
{
  {
    -1,
    (gchar *) "parameter",
    (gchar *) "av",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _pmp_impl_notification_signal_info_action_invoked_ARG_pointers[] =
{
  &_pmp_impl_notification_signal_info_action_invoked_ARG_app_id.parent_struct,
  &_pmp_impl_notification_signal_info_action_invoked_ARG_id.parent_struct,
  &_pmp_impl_notification_signal_info_action_invoked_ARG_action.parent_struct,
  &_pmp_impl_notification_signal_info_action_invoked_ARG_parameter.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _pmp_impl_notification_signal_info_action_invoked =
{
  {
    -1,
    (gchar *) "ActionInvoked",
    (GDBusArgInfo **) &_pmp_impl_notification_signal_info_action_invoked_ARG_pointers,
    NULL
  },
  "action-invoked"
};

static const GDBusSignalInfo * const _pmp_impl_notification_signal_info_pointers[] =
{
  &_pmp_impl_notification_signal_info_action_invoked.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _pmp_impl_notification_property_supported_options_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _pmp_impl_notification_property_supported_options_annotation_info_pointers[] =
{
  &_pmp_impl_notification_property_supported_options_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _pmp_impl_notification_property_info_supported_options =
{
  {
    -1,
    (gchar *) "SupportedOptions",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_pmp_impl_notification_property_supported_options_annotation_info_pointers
  },
  "supported-options",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _pmp_impl_notification_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _pmp_impl_notification_property_info_pointers[] =
{
  &_pmp_impl_notification_property_info_supported_options.parent_struct,
  &_pmp_impl_notification_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _pmp_impl_notification_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Notification",
    (GDBusMethodInfo **) &_pmp_impl_notification_method_info_pointers,
    (GDBusSignalInfo **) &_pmp_impl_notification_signal_info_pointers,
    (GDBusPropertyInfo **) &_pmp_impl_notification_property_info_pointers,
    NULL
  },
  "notification",
};


/**
 * pmp_impl_notification_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
pmp_impl_notification_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_pmp_impl_notification_interface_info.parent_struct;
}

/**
 * pmp_impl_notification_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #PmpImplNotification interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
pmp_impl_notification_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "supported-options");
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}


inline static void
pmp_impl_notification_signal_marshal_action_invoked (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
pmp_impl_notification_method_marshal_add_notification (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
pmp_impl_notification_method_marshal_remove_notification (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * PmpImplNotification:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link>.
 */

/**
 * PmpImplNotificationIface:
 * @parent_iface: The parent interface.
 * @handle_add_notification: Handler for the #PmpImplNotification::handle-add-notification signal.
 * @handle_remove_notification: Handler for the #PmpImplNotification::handle-remove-notification signal.
 * @get_supported_options: Getter for the #PmpImplNotification:supported-options property.
 * @get_version: Getter for the #PmpImplNotification:version property.
 * @action_invoked: Handler for the #PmpImplNotification::action-invoked signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link>.
 */

typedef PmpImplNotificationIface PmpImplNotificationInterface;
G_DEFINE_INTERFACE (PmpImplNotification, pmp_impl_notification, G_TYPE_OBJECT)

static void
pmp_impl_notification_default_init (PmpImplNotificationIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * PmpImplNotification::handle-add-notification:
   * @object: A #PmpImplNotification.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   * @arg_notification: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.AddNotification">AddNotification()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call pmp_impl_notification_complete_add_notification() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-notification",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PmpImplNotificationIface, handle_add_notification),
    g_signal_accumulator_true_handled,
    NULL,
      pmp_impl_notification_method_marshal_add_notification,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * PmpImplNotification::handle-remove-notification:
   * @object: A #PmpImplNotification.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.RemoveNotification">RemoveNotification()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call pmp_impl_notification_complete_remove_notification() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-remove-notification",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PmpImplNotificationIface, handle_remove_notification),
    g_signal_accumulator_true_handled,
    NULL,
      pmp_impl_notification_method_marshal_remove_notification,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * PmpImplNotification::action-invoked:
   * @object: A #PmpImplNotification.
   * @arg_app_id: Argument.
   * @arg_id: Argument.
   * @arg_action: Argument.
   * @arg_parameter: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-impl-portal-Notification.ActionInvoked">"ActionInvoked"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PMP_IMPL__NOTIFICATION_SIGNALS[PMP_IMPL__NOTIFICATION_ACTION_INVOKED] =
    g_signal_new ("action-invoked",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PmpImplNotificationIface, action_invoked),
      NULL,
      NULL,
      pmp_impl_notification_signal_marshal_action_invoked,
      G_TYPE_NONE,
      4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * PmpImplNotification:supported-options:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Notification.SupportedOptions">"SupportedOptions"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("supported-options", "SupportedOptions", "SupportedOptions", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * PmpImplNotification:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Notification.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * pmp_impl_notification_get_supported_options: (skip)
 * @object: A #PmpImplNotification.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Notification.SupportedOptions">"SupportedOptions"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use pmp_impl_notification_dup_supported_options() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
pmp_impl_notification_get_supported_options (PmpImplNotification *object)
{
  g_return_val_if_fail (PMP_IMPL_IS_NOTIFICATION (object), NULL);

  return PMP_IMPL_NOTIFICATION_GET_IFACE (object)->get_supported_options (object);
}

/**
 * pmp_impl_notification_dup_supported_options: (skip)
 * @object: A #PmpImplNotification.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Notification.SupportedOptions">"SupportedOptions"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
pmp_impl_notification_dup_supported_options (PmpImplNotification *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "supported-options", &value, NULL);
  return value;
}

/**
 * pmp_impl_notification_set_supported_options: (skip)
 * @object: A #PmpImplNotification.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Notification.SupportedOptions">"SupportedOptions"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
pmp_impl_notification_set_supported_options (PmpImplNotification *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "supported-options", value, NULL);
}

/**
 * pmp_impl_notification_get_version: (skip)
 * @object: A #PmpImplNotification.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Notification.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
pmp_impl_notification_get_version (PmpImplNotification *object)
{
  g_return_val_if_fail (PMP_IMPL_IS_NOTIFICATION (object), 0);

  return PMP_IMPL_NOTIFICATION_GET_IFACE (object)->get_version (object);
}

/**
 * pmp_impl_notification_set_version: (skip)
 * @object: A #PmpImplNotification.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Notification.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
pmp_impl_notification_set_version (PmpImplNotification *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * pmp_impl_notification_emit_action_invoked:
 * @object: A #PmpImplNotification.
 * @arg_app_id: Argument to pass with the signal.
 * @arg_id: Argument to pass with the signal.
 * @arg_action: Argument to pass with the signal.
 * @arg_parameter: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-impl-portal-Notification.ActionInvoked">"ActionInvoked"</link> D-Bus signal.
 */
void
pmp_impl_notification_emit_action_invoked (
    PmpImplNotification *object,
    const gchar *arg_app_id,
    const gchar *arg_id,
    const gchar *arg_action,
    GVariant *arg_parameter)
{
  g_signal_emit (object, PMP_IMPL__NOTIFICATION_SIGNALS[PMP_IMPL__NOTIFICATION_ACTION_INVOKED], 0, arg_app_id, arg_id, arg_action, arg_parameter);
}

/**
 * pmp_impl_notification_call_add_notification:
 * @proxy: A #PmpImplNotificationProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_notification: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.AddNotification">AddNotification()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_notification_call_add_notification_finish() to get the result of the operation.
 *
 * See pmp_impl_notification_call_add_notification_sync() for the synchronous, blocking version of this method.
 */
void
pmp_impl_notification_call_add_notification (
    PmpImplNotification *proxy,
    const gchar *arg_app_id,
    const gchar *arg_id,
    GVariant *arg_notification,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "AddNotification",
    g_variant_new ("(ss@a{sv})",
                   arg_app_id,
                   arg_id,
                   arg_notification),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * pmp_impl_notification_call_add_notification_finish:
 * @proxy: A #PmpImplNotificationProxy.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_notification_call_add_notification().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with pmp_impl_notification_call_add_notification().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_notification_call_add_notification_finish (
    PmpImplNotification *proxy,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_notification_call_add_notification_sync:
 * @proxy: A #PmpImplNotificationProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_notification: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.AddNotification">AddNotification()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_notification_call_add_notification() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_notification_call_add_notification_sync (
    PmpImplNotification *proxy,
    const gchar *arg_app_id,
    const gchar *arg_id,
    GVariant *arg_notification,
    GUnixFDList  *fd_list,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "AddNotification",
    g_variant_new ("(ss@a{sv})",
                   arg_app_id,
                   arg_id,
                   arg_notification),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_notification_call_remove_notification:
 * @proxy: A #PmpImplNotificationProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.RemoveNotification">RemoveNotification()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_notification_call_remove_notification_finish() to get the result of the operation.
 *
 * See pmp_impl_notification_call_remove_notification_sync() for the synchronous, blocking version of this method.
 */
void
pmp_impl_notification_call_remove_notification (
    PmpImplNotification *proxy,
    const gchar *arg_app_id,
    const gchar *arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RemoveNotification",
    g_variant_new ("(ss)",
                   arg_app_id,
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * pmp_impl_notification_call_remove_notification_finish:
 * @proxy: A #PmpImplNotificationProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_notification_call_remove_notification().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with pmp_impl_notification_call_remove_notification().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_notification_call_remove_notification_finish (
    PmpImplNotification *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_notification_call_remove_notification_sync:
 * @proxy: A #PmpImplNotificationProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.RemoveNotification">RemoveNotification()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_notification_call_remove_notification() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_notification_call_remove_notification_sync (
    PmpImplNotification *proxy,
    const gchar *arg_app_id,
    const gchar *arg_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RemoveNotification",
    g_variant_new ("(ss)",
                   arg_app_id,
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_notification_complete_add_notification:
 * @object: A #PmpImplNotification.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.AddNotification">AddNotification()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
pmp_impl_notification_complete_add_notification (
    PmpImplNotification *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("()"),
    fd_list);
}

/**
 * pmp_impl_notification_complete_remove_notification:
 * @object: A #PmpImplNotification.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.RemoveNotification">RemoveNotification()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
pmp_impl_notification_complete_remove_notification (
    PmpImplNotification *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * PmpImplNotificationProxy:
 *
 * The #PmpImplNotificationProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PmpImplNotificationProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PmpImplNotificationProxy.
 */

struct _PmpImplNotificationProxyPrivate
{
  GData *qdata;
};

static void pmp_impl_notification_proxy_iface_init (PmpImplNotificationIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PmpImplNotificationProxy, pmp_impl_notification_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (PmpImplNotificationProxy)
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_NOTIFICATION, pmp_impl_notification_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PmpImplNotificationProxy, pmp_impl_notification_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_NOTIFICATION, pmp_impl_notification_proxy_iface_init))

#endif
static void
pmp_impl_notification_proxy_finalize (GObject *object)
{
  PmpImplNotificationProxy *proxy = PMP_IMPL_NOTIFICATION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (pmp_impl_notification_proxy_parent_class)->finalize (object);
}

static void
pmp_impl_notification_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _pmp_impl_notification_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
pmp_impl_notification_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.Notification: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
pmp_impl_notification_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _pmp_impl_notification_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.Notification", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) pmp_impl_notification_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
pmp_impl_notification_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_pmp_impl_notification_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], PMP_IMPL_TYPE_NOTIFICATION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PMP_IMPL_TYPE_NOTIFICATION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
pmp_impl_notification_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  PmpImplNotificationProxy *proxy = PMP_IMPL_NOTIFICATION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_notification_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_notification_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static GVariant *
pmp_impl_notification_proxy_get_supported_options (PmpImplNotification *object)
{
  PmpImplNotificationProxy *proxy = PMP_IMPL_NOTIFICATION_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedOptions");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static guint 
pmp_impl_notification_proxy_get_version (PmpImplNotification *object)
{
  PmpImplNotificationProxy *proxy = PMP_IMPL_NOTIFICATION_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
pmp_impl_notification_proxy_init (PmpImplNotificationProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = pmp_impl_notification_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, PMP_IMPL_TYPE_NOTIFICATION_PROXY, PmpImplNotificationProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), pmp_impl_notification_interface_info ());
}

static void
pmp_impl_notification_proxy_class_init (PmpImplNotificationProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = pmp_impl_notification_proxy_finalize;
  gobject_class->get_property = pmp_impl_notification_proxy_get_property;
  gobject_class->set_property = pmp_impl_notification_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = pmp_impl_notification_proxy_g_signal;
  proxy_class->g_properties_changed = pmp_impl_notification_proxy_g_properties_changed;

  pmp_impl_notification_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PmpImplNotificationProxyPrivate));
#endif
}

static void
pmp_impl_notification_proxy_iface_init (PmpImplNotificationIface *iface)
{
  iface->get_supported_options = pmp_impl_notification_proxy_get_supported_options;
  iface->get_version = pmp_impl_notification_proxy_get_version;
}

/**
 * pmp_impl_notification_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_notification_proxy_new_finish() to get the result of the operation.
 *
 * See pmp_impl_notification_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
pmp_impl_notification_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PMP_IMPL_TYPE_NOTIFICATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Notification", NULL);
}

/**
 * pmp_impl_notification_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_notification_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with pmp_impl_notification_proxy_new().
 *
 * Returns: (transfer full) (type PmpImplNotificationProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplNotification *
pmp_impl_notification_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PMP_IMPL_NOTIFICATION (ret);
  else
    return NULL;
}

/**
 * pmp_impl_notification_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_notification_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PmpImplNotificationProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplNotification *
pmp_impl_notification_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PMP_IMPL_TYPE_NOTIFICATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Notification", NULL);
  if (ret != NULL)
    return PMP_IMPL_NOTIFICATION (ret);
  else
    return NULL;
}


/**
 * pmp_impl_notification_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like pmp_impl_notification_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_notification_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See pmp_impl_notification_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
pmp_impl_notification_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PMP_IMPL_TYPE_NOTIFICATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Notification", NULL);
}

/**
 * pmp_impl_notification_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_notification_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with pmp_impl_notification_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type PmpImplNotificationProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplNotification *
pmp_impl_notification_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PMP_IMPL_NOTIFICATION (ret);
  else
    return NULL;
}

/**
 * pmp_impl_notification_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like pmp_impl_notification_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_notification_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PmpImplNotificationProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplNotification *
pmp_impl_notification_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PMP_IMPL_TYPE_NOTIFICATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Notification", NULL);
  if (ret != NULL)
    return PMP_IMPL_NOTIFICATION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * PmpImplNotificationSkeleton:
 *
 * The #PmpImplNotificationSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PmpImplNotificationSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PmpImplNotificationSkeleton.
 */

struct _PmpImplNotificationSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_pmp_impl_notification_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  PmpImplNotificationSkeleton *skeleton = PMP_IMPL_NOTIFICATION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], PMP_IMPL_TYPE_NOTIFICATION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PMP_IMPL_TYPE_NOTIFICATION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_pmp_impl_notification_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  PmpImplNotificationSkeleton *skeleton = PMP_IMPL_NOTIFICATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_notification_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_pmp_impl_notification_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  PmpImplNotificationSkeleton *skeleton = PMP_IMPL_NOTIFICATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_notification_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _pmp_impl_notification_skeleton_vtable =
{
  _pmp_impl_notification_skeleton_handle_method_call,
  _pmp_impl_notification_skeleton_handle_get_property,
  _pmp_impl_notification_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
pmp_impl_notification_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return pmp_impl_notification_interface_info ();
}

static GDBusInterfaceVTable *
pmp_impl_notification_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_pmp_impl_notification_skeleton_vtable;
}

static GVariant *
pmp_impl_notification_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  PmpImplNotificationSkeleton *skeleton = PMP_IMPL_NOTIFICATION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_pmp_impl_notification_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _pmp_impl_notification_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _pmp_impl_notification_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _pmp_impl_notification_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Notification", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _pmp_impl_notification_emit_changed (gpointer user_data);

static void
pmp_impl_notification_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  PmpImplNotificationSkeleton *skeleton = PMP_IMPL_NOTIFICATION_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _pmp_impl_notification_emit_changed (skeleton);
}

static void
_pmp_impl_notification_on_signal_action_invoked (
    PmpImplNotification *object,
    const gchar *arg_app_id,
    const gchar *arg_id,
    const gchar *arg_action,
    GVariant *arg_parameter)
{
  PmpImplNotificationSkeleton *skeleton = PMP_IMPL_NOTIFICATION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(sss@av)",
                   arg_app_id,
                   arg_id,
                   arg_action,
                   arg_parameter));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Notification", "ActionInvoked",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void pmp_impl_notification_skeleton_iface_init (PmpImplNotificationIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PmpImplNotificationSkeleton, pmp_impl_notification_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (PmpImplNotificationSkeleton)
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_NOTIFICATION, pmp_impl_notification_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PmpImplNotificationSkeleton, pmp_impl_notification_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_NOTIFICATION, pmp_impl_notification_skeleton_iface_init))

#endif
static void
pmp_impl_notification_skeleton_finalize (GObject *object)
{
  PmpImplNotificationSkeleton *skeleton = PMP_IMPL_NOTIFICATION_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (pmp_impl_notification_skeleton_parent_class)->finalize (object);
}

static void
pmp_impl_notification_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  PmpImplNotificationSkeleton *skeleton = PMP_IMPL_NOTIFICATION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_pmp_impl_notification_emit_changed (gpointer user_data)
{
  PmpImplNotificationSkeleton *skeleton = PMP_IMPL_NOTIFICATION_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.Notification",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_pmp_impl_notification_schedule_emit_changed (PmpImplNotificationSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
pmp_impl_notification_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  PmpImplNotificationSkeleton *skeleton = PMP_IMPL_NOTIFICATION_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _pmp_impl_notification_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _pmp_impl_notification_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
pmp_impl_notification_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  PmpImplNotificationSkeleton *skeleton = PMP_IMPL_NOTIFICATION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _pmp_impl_notification_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _pmp_impl_notification_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
pmp_impl_notification_skeleton_init (PmpImplNotificationSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = pmp_impl_notification_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, PMP_IMPL_TYPE_NOTIFICATION_SKELETON, PmpImplNotificationSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
}

static GVariant *
pmp_impl_notification_skeleton_get_supported_options (PmpImplNotification *object)
{
  PmpImplNotificationSkeleton *skeleton = PMP_IMPL_NOTIFICATION_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
pmp_impl_notification_skeleton_get_version (PmpImplNotification *object)
{
  PmpImplNotificationSkeleton *skeleton = PMP_IMPL_NOTIFICATION_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
pmp_impl_notification_skeleton_class_init (PmpImplNotificationSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = pmp_impl_notification_skeleton_finalize;
  gobject_class->get_property = pmp_impl_notification_skeleton_get_property;
  gobject_class->set_property = pmp_impl_notification_skeleton_set_property;
  gobject_class->notify       = pmp_impl_notification_skeleton_notify;


  pmp_impl_notification_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = pmp_impl_notification_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = pmp_impl_notification_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = pmp_impl_notification_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = pmp_impl_notification_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PmpImplNotificationSkeletonPrivate));
#endif
}

static void
pmp_impl_notification_skeleton_iface_init (PmpImplNotificationIface *iface)
{
  iface->action_invoked = _pmp_impl_notification_on_signal_action_invoked;
  iface->get_supported_options = pmp_impl_notification_skeleton_get_supported_options;
  iface->get_version = pmp_impl_notification_skeleton_get_version;
}

/**
 * pmp_impl_notification_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link>.
 *
 * Returns: (transfer full) (type PmpImplNotificationSkeleton): The skeleton object.
 */
PmpImplNotification *
pmp_impl_notification_skeleton_new (void)
{
  return PMP_IMPL_NOTIFICATION (g_object_new (PMP_IMPL_TYPE_NOTIFICATION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Request
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:PmpImplRequest
 * @title: PmpImplRequest
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Request D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Request ---- */

static const _ExtendedGDBusMethodInfo _pmp_impl_request_method_info_close =
{
  {
    -1,
    (gchar *) "Close",
    NULL,
    NULL,
    NULL
  },
  "handle-close",
  FALSE
};

static const GDBusMethodInfo * const _pmp_impl_request_method_info_pointers[] =
{
  &_pmp_impl_request_method_info_close.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _pmp_impl_request_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Request",
    (GDBusMethodInfo **) &_pmp_impl_request_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "request",
};


/**
 * pmp_impl_request_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
pmp_impl_request_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_pmp_impl_request_interface_info.parent_struct;
}

/**
 * pmp_impl_request_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #PmpImplRequest interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
pmp_impl_request_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
pmp_impl_request_method_marshal_close (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * PmpImplRequest:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>.
 */

/**
 * PmpImplRequestIface:
 * @parent_iface: The parent interface.
 * @handle_close: Handler for the #PmpImplRequest::handle-close signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>.
 */

typedef PmpImplRequestIface PmpImplRequestInterface;
G_DEFINE_INTERFACE (PmpImplRequest, pmp_impl_request, G_TYPE_OBJECT)

static void
pmp_impl_request_default_init (PmpImplRequestIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * PmpImplRequest::handle-close:
   * @object: A #PmpImplRequest.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Request.Close">Close()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call pmp_impl_request_complete_close() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-close",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PmpImplRequestIface, handle_close),
    g_signal_accumulator_true_handled,
    NULL,
      pmp_impl_request_method_marshal_close,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * pmp_impl_request_call_close:
 * @proxy: A #PmpImplRequestProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Request.Close">Close()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_request_call_close_finish() to get the result of the operation.
 *
 * See pmp_impl_request_call_close_sync() for the synchronous, blocking version of this method.
 */
void
pmp_impl_request_call_close (
    PmpImplRequest *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * pmp_impl_request_call_close_finish:
 * @proxy: A #PmpImplRequestProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_request_call_close().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with pmp_impl_request_call_close().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_request_call_close_finish (
    PmpImplRequest *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_request_call_close_sync:
 * @proxy: A #PmpImplRequestProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Request.Close">Close()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_request_call_close() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_request_call_close_sync (
    PmpImplRequest *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_request_complete_close:
 * @object: A #PmpImplRequest.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Request.Close">Close()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
pmp_impl_request_complete_close (
    PmpImplRequest *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * PmpImplRequestProxy:
 *
 * The #PmpImplRequestProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PmpImplRequestProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PmpImplRequestProxy.
 */

struct _PmpImplRequestProxyPrivate
{
  GData *qdata;
};

static void pmp_impl_request_proxy_iface_init (PmpImplRequestIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PmpImplRequestProxy, pmp_impl_request_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (PmpImplRequestProxy)
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_REQUEST, pmp_impl_request_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PmpImplRequestProxy, pmp_impl_request_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_REQUEST, pmp_impl_request_proxy_iface_init))

#endif
static void
pmp_impl_request_proxy_finalize (GObject *object)
{
  PmpImplRequestProxy *proxy = PMP_IMPL_REQUEST_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (pmp_impl_request_proxy_parent_class)->finalize (object);
}

static void
pmp_impl_request_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
pmp_impl_request_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
pmp_impl_request_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_pmp_impl_request_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], PMP_IMPL_TYPE_REQUEST);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PMP_IMPL_TYPE_REQUEST);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
pmp_impl_request_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  PmpImplRequestProxy *proxy = PMP_IMPL_REQUEST_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_request_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_request_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
pmp_impl_request_proxy_init (PmpImplRequestProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = pmp_impl_request_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, PMP_IMPL_TYPE_REQUEST_PROXY, PmpImplRequestProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), pmp_impl_request_interface_info ());
}

static void
pmp_impl_request_proxy_class_init (PmpImplRequestProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = pmp_impl_request_proxy_finalize;
  gobject_class->get_property = pmp_impl_request_proxy_get_property;
  gobject_class->set_property = pmp_impl_request_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = pmp_impl_request_proxy_g_signal;
  proxy_class->g_properties_changed = pmp_impl_request_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PmpImplRequestProxyPrivate));
#endif
}

static void
pmp_impl_request_proxy_iface_init (PmpImplRequestIface *iface G_GNUC_UNUSED)
{
}

/**
 * pmp_impl_request_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_request_proxy_new_finish() to get the result of the operation.
 *
 * See pmp_impl_request_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
pmp_impl_request_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PMP_IMPL_TYPE_REQUEST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Request", NULL);
}

/**
 * pmp_impl_request_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_request_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with pmp_impl_request_proxy_new().
 *
 * Returns: (transfer full) (type PmpImplRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplRequest *
pmp_impl_request_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PMP_IMPL_REQUEST (ret);
  else
    return NULL;
}

/**
 * pmp_impl_request_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_request_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PmpImplRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplRequest *
pmp_impl_request_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PMP_IMPL_TYPE_REQUEST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Request", NULL);
  if (ret != NULL)
    return PMP_IMPL_REQUEST (ret);
  else
    return NULL;
}


/**
 * pmp_impl_request_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like pmp_impl_request_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_request_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See pmp_impl_request_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
pmp_impl_request_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PMP_IMPL_TYPE_REQUEST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Request", NULL);
}

/**
 * pmp_impl_request_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_request_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with pmp_impl_request_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type PmpImplRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplRequest *
pmp_impl_request_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PMP_IMPL_REQUEST (ret);
  else
    return NULL;
}

/**
 * pmp_impl_request_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like pmp_impl_request_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_request_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PmpImplRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplRequest *
pmp_impl_request_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PMP_IMPL_TYPE_REQUEST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Request", NULL);
  if (ret != NULL)
    return PMP_IMPL_REQUEST (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * PmpImplRequestSkeleton:
 *
 * The #PmpImplRequestSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PmpImplRequestSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PmpImplRequestSkeleton.
 */

struct _PmpImplRequestSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_pmp_impl_request_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  PmpImplRequestSkeleton *skeleton = PMP_IMPL_REQUEST_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], PMP_IMPL_TYPE_REQUEST);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PMP_IMPL_TYPE_REQUEST);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_pmp_impl_request_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  PmpImplRequestSkeleton *skeleton = PMP_IMPL_REQUEST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_request_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_pmp_impl_request_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  PmpImplRequestSkeleton *skeleton = PMP_IMPL_REQUEST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_request_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _pmp_impl_request_skeleton_vtable =
{
  _pmp_impl_request_skeleton_handle_method_call,
  _pmp_impl_request_skeleton_handle_get_property,
  _pmp_impl_request_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
pmp_impl_request_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return pmp_impl_request_interface_info ();
}

static GDBusInterfaceVTable *
pmp_impl_request_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_pmp_impl_request_skeleton_vtable;
}

static GVariant *
pmp_impl_request_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  PmpImplRequestSkeleton *skeleton = PMP_IMPL_REQUEST_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_pmp_impl_request_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _pmp_impl_request_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _pmp_impl_request_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _pmp_impl_request_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Request", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
pmp_impl_request_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void pmp_impl_request_skeleton_iface_init (PmpImplRequestIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PmpImplRequestSkeleton, pmp_impl_request_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (PmpImplRequestSkeleton)
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_REQUEST, pmp_impl_request_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PmpImplRequestSkeleton, pmp_impl_request_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_REQUEST, pmp_impl_request_skeleton_iface_init))

#endif
static void
pmp_impl_request_skeleton_finalize (GObject *object)
{
  PmpImplRequestSkeleton *skeleton = PMP_IMPL_REQUEST_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (pmp_impl_request_skeleton_parent_class)->finalize (object);
}

static void
pmp_impl_request_skeleton_init (PmpImplRequestSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = pmp_impl_request_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, PMP_IMPL_TYPE_REQUEST_SKELETON, PmpImplRequestSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
pmp_impl_request_skeleton_class_init (PmpImplRequestSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = pmp_impl_request_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = pmp_impl_request_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = pmp_impl_request_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = pmp_impl_request_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = pmp_impl_request_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PmpImplRequestSkeletonPrivate));
#endif
}

static void
pmp_impl_request_skeleton_iface_init (PmpImplRequestIface *iface G_GNUC_UNUSED)
{
}

/**
 * pmp_impl_request_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>.
 *
 * Returns: (transfer full) (type PmpImplRequestSkeleton): The skeleton object.
 */
PmpImplRequest *
pmp_impl_request_skeleton_new (void)
{
  return PMP_IMPL_REQUEST (g_object_new (PMP_IMPL_TYPE_REQUEST_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Session
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:PmpImplSession
 * @title: PmpImplSession
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Session D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Session.top_of_page">org.freedesktop.impl.portal.Session</link> D-Bus interface in C.
 */

enum
{
  PMP_IMPL__SESSION_CLOSED,
};

static unsigned PMP_IMPL__SESSION_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.freedesktop.impl.portal.Session ---- */

static const _ExtendedGDBusMethodInfo _pmp_impl_session_method_info_close =
{
  {
    -1,
    (gchar *) "Close",
    NULL,
    NULL,
    NULL
  },
  "handle-close",
  FALSE
};

static const GDBusMethodInfo * const _pmp_impl_session_method_info_pointers[] =
{
  &_pmp_impl_session_method_info_close.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _pmp_impl_session_signal_info_closed =
{
  {
    -1,
    (gchar *) "Closed",
    NULL,
    NULL
  },
  "closed"
};

static const GDBusSignalInfo * const _pmp_impl_session_signal_info_pointers[] =
{
  &_pmp_impl_session_signal_info_closed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _pmp_impl_session_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _pmp_impl_session_property_info_pointers[] =
{
  &_pmp_impl_session_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _pmp_impl_session_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Session",
    (GDBusMethodInfo **) &_pmp_impl_session_method_info_pointers,
    (GDBusSignalInfo **) &_pmp_impl_session_signal_info_pointers,
    (GDBusPropertyInfo **) &_pmp_impl_session_property_info_pointers,
    NULL
  },
  "session",
};


/**
 * pmp_impl_session_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Session.top_of_page">org.freedesktop.impl.portal.Session</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
pmp_impl_session_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_pmp_impl_session_interface_info.parent_struct;
}

/**
 * pmp_impl_session_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #PmpImplSession interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
pmp_impl_session_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}


inline static void
pmp_impl_session_signal_marshal_closed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
pmp_impl_session_method_marshal_close (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * PmpImplSession:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Session.top_of_page">org.freedesktop.impl.portal.Session</link>.
 */

/**
 * PmpImplSessionIface:
 * @parent_iface: The parent interface.
 * @handle_close: Handler for the #PmpImplSession::handle-close signal.
 * @get_version: Getter for the #PmpImplSession:version property.
 * @closed: Handler for the #PmpImplSession::closed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Session.top_of_page">org.freedesktop.impl.portal.Session</link>.
 */

typedef PmpImplSessionIface PmpImplSessionInterface;
G_DEFINE_INTERFACE (PmpImplSession, pmp_impl_session, G_TYPE_OBJECT)

static void
pmp_impl_session_default_init (PmpImplSessionIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * PmpImplSession::handle-close:
   * @object: A #PmpImplSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Session.Close">Close()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call pmp_impl_session_complete_close() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-close",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PmpImplSessionIface, handle_close),
    g_signal_accumulator_true_handled,
    NULL,
      pmp_impl_session_method_marshal_close,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * PmpImplSession::closed:
   * @object: A #PmpImplSession.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-impl-portal-Session.Closed">"Closed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PMP_IMPL__SESSION_SIGNALS[PMP_IMPL__SESSION_CLOSED] =
    g_signal_new ("closed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PmpImplSessionIface, closed),
      NULL,
      NULL,
      pmp_impl_session_signal_marshal_closed,
      G_TYPE_NONE,
      0);

  /* GObject properties for D-Bus properties: */
  /**
   * PmpImplSession:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Session.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * pmp_impl_session_get_version: (skip)
 * @object: A #PmpImplSession.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Session.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
pmp_impl_session_get_version (PmpImplSession *object)
{
  g_return_val_if_fail (PMP_IMPL_IS_SESSION (object), 0);

  return PMP_IMPL_SESSION_GET_IFACE (object)->get_version (object);
}

/**
 * pmp_impl_session_set_version: (skip)
 * @object: A #PmpImplSession.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Session.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
pmp_impl_session_set_version (PmpImplSession *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * pmp_impl_session_emit_closed:
 * @object: A #PmpImplSession.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-impl-portal-Session.Closed">"Closed"</link> D-Bus signal.
 */
void
pmp_impl_session_emit_closed (
    PmpImplSession *object)
{
  g_signal_emit (object, PMP_IMPL__SESSION_SIGNALS[PMP_IMPL__SESSION_CLOSED], 0);
}

/**
 * pmp_impl_session_call_close:
 * @proxy: A #PmpImplSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Session.Close">Close()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_session_call_close_finish() to get the result of the operation.
 *
 * See pmp_impl_session_call_close_sync() for the synchronous, blocking version of this method.
 */
void
pmp_impl_session_call_close (
    PmpImplSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * pmp_impl_session_call_close_finish:
 * @proxy: A #PmpImplSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_session_call_close().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with pmp_impl_session_call_close().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_session_call_close_finish (
    PmpImplSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_session_call_close_sync:
 * @proxy: A #PmpImplSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Session.Close">Close()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_session_call_close() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_session_call_close_sync (
    PmpImplSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_session_complete_close:
 * @object: A #PmpImplSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Session.Close">Close()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
pmp_impl_session_complete_close (
    PmpImplSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * PmpImplSessionProxy:
 *
 * The #PmpImplSessionProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PmpImplSessionProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PmpImplSessionProxy.
 */

struct _PmpImplSessionProxyPrivate
{
  GData *qdata;
};

static void pmp_impl_session_proxy_iface_init (PmpImplSessionIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PmpImplSessionProxy, pmp_impl_session_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (PmpImplSessionProxy)
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_SESSION, pmp_impl_session_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PmpImplSessionProxy, pmp_impl_session_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_SESSION, pmp_impl_session_proxy_iface_init))

#endif
static void
pmp_impl_session_proxy_finalize (GObject *object)
{
  PmpImplSessionProxy *proxy = PMP_IMPL_SESSION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (pmp_impl_session_proxy_parent_class)->finalize (object);
}

static void
pmp_impl_session_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _pmp_impl_session_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
pmp_impl_session_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.Session: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
pmp_impl_session_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _pmp_impl_session_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.Session", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) pmp_impl_session_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
pmp_impl_session_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_pmp_impl_session_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], PMP_IMPL_TYPE_SESSION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PMP_IMPL_TYPE_SESSION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
pmp_impl_session_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  PmpImplSessionProxy *proxy = PMP_IMPL_SESSION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_session_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_session_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
pmp_impl_session_proxy_get_version (PmpImplSession *object)
{
  PmpImplSessionProxy *proxy = PMP_IMPL_SESSION_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
pmp_impl_session_proxy_init (PmpImplSessionProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = pmp_impl_session_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, PMP_IMPL_TYPE_SESSION_PROXY, PmpImplSessionProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), pmp_impl_session_interface_info ());
}

static void
pmp_impl_session_proxy_class_init (PmpImplSessionProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = pmp_impl_session_proxy_finalize;
  gobject_class->get_property = pmp_impl_session_proxy_get_property;
  gobject_class->set_property = pmp_impl_session_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = pmp_impl_session_proxy_g_signal;
  proxy_class->g_properties_changed = pmp_impl_session_proxy_g_properties_changed;

  pmp_impl_session_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PmpImplSessionProxyPrivate));
#endif
}

static void
pmp_impl_session_proxy_iface_init (PmpImplSessionIface *iface)
{
  iface->get_version = pmp_impl_session_proxy_get_version;
}

/**
 * pmp_impl_session_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Session.top_of_page">org.freedesktop.impl.portal.Session</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_session_proxy_new_finish() to get the result of the operation.
 *
 * See pmp_impl_session_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
pmp_impl_session_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PMP_IMPL_TYPE_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Session", NULL);
}

/**
 * pmp_impl_session_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_session_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with pmp_impl_session_proxy_new().
 *
 * Returns: (transfer full) (type PmpImplSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplSession *
pmp_impl_session_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PMP_IMPL_SESSION (ret);
  else
    return NULL;
}

/**
 * pmp_impl_session_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Session.top_of_page">org.freedesktop.impl.portal.Session</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_session_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PmpImplSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplSession *
pmp_impl_session_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PMP_IMPL_TYPE_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Session", NULL);
  if (ret != NULL)
    return PMP_IMPL_SESSION (ret);
  else
    return NULL;
}


/**
 * pmp_impl_session_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like pmp_impl_session_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_session_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See pmp_impl_session_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
pmp_impl_session_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PMP_IMPL_TYPE_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Session", NULL);
}

/**
 * pmp_impl_session_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_session_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with pmp_impl_session_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type PmpImplSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplSession *
pmp_impl_session_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PMP_IMPL_SESSION (ret);
  else
    return NULL;
}

/**
 * pmp_impl_session_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like pmp_impl_session_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_session_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PmpImplSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplSession *
pmp_impl_session_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PMP_IMPL_TYPE_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Session", NULL);
  if (ret != NULL)
    return PMP_IMPL_SESSION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * PmpImplSessionSkeleton:
 *
 * The #PmpImplSessionSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PmpImplSessionSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PmpImplSessionSkeleton.
 */

struct _PmpImplSessionSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_pmp_impl_session_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  PmpImplSessionSkeleton *skeleton = PMP_IMPL_SESSION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], PMP_IMPL_TYPE_SESSION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PMP_IMPL_TYPE_SESSION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_pmp_impl_session_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  PmpImplSessionSkeleton *skeleton = PMP_IMPL_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_pmp_impl_session_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  PmpImplSessionSkeleton *skeleton = PMP_IMPL_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _pmp_impl_session_skeleton_vtable =
{
  _pmp_impl_session_skeleton_handle_method_call,
  _pmp_impl_session_skeleton_handle_get_property,
  _pmp_impl_session_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
pmp_impl_session_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return pmp_impl_session_interface_info ();
}

static GDBusInterfaceVTable *
pmp_impl_session_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_pmp_impl_session_skeleton_vtable;
}

static GVariant *
pmp_impl_session_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  PmpImplSessionSkeleton *skeleton = PMP_IMPL_SESSION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_pmp_impl_session_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _pmp_impl_session_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _pmp_impl_session_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _pmp_impl_session_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Session", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _pmp_impl_session_emit_changed (gpointer user_data);

static void
pmp_impl_session_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  PmpImplSessionSkeleton *skeleton = PMP_IMPL_SESSION_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _pmp_impl_session_emit_changed (skeleton);
}

static void
_pmp_impl_session_on_signal_closed (
    PmpImplSession *object)
{
  PmpImplSessionSkeleton *skeleton = PMP_IMPL_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Session", "Closed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void pmp_impl_session_skeleton_iface_init (PmpImplSessionIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PmpImplSessionSkeleton, pmp_impl_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (PmpImplSessionSkeleton)
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_SESSION, pmp_impl_session_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PmpImplSessionSkeleton, pmp_impl_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_SESSION, pmp_impl_session_skeleton_iface_init))

#endif
static void
pmp_impl_session_skeleton_finalize (GObject *object)
{
  PmpImplSessionSkeleton *skeleton = PMP_IMPL_SESSION_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (pmp_impl_session_skeleton_parent_class)->finalize (object);
}

static void
pmp_impl_session_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  PmpImplSessionSkeleton *skeleton = PMP_IMPL_SESSION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_pmp_impl_session_emit_changed (gpointer user_data)
{
  PmpImplSessionSkeleton *skeleton = PMP_IMPL_SESSION_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.Session",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_pmp_impl_session_schedule_emit_changed (PmpImplSessionSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
pmp_impl_session_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  PmpImplSessionSkeleton *skeleton = PMP_IMPL_SESSION_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _pmp_impl_session_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _pmp_impl_session_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
pmp_impl_session_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  PmpImplSessionSkeleton *skeleton = PMP_IMPL_SESSION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _pmp_impl_session_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _pmp_impl_session_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
pmp_impl_session_skeleton_init (PmpImplSessionSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = pmp_impl_session_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, PMP_IMPL_TYPE_SESSION_SKELETON, PmpImplSessionSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
pmp_impl_session_skeleton_get_version (PmpImplSession *object)
{
  PmpImplSessionSkeleton *skeleton = PMP_IMPL_SESSION_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
pmp_impl_session_skeleton_class_init (PmpImplSessionSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = pmp_impl_session_skeleton_finalize;
  gobject_class->get_property = pmp_impl_session_skeleton_get_property;
  gobject_class->set_property = pmp_impl_session_skeleton_set_property;
  gobject_class->notify       = pmp_impl_session_skeleton_notify;


  pmp_impl_session_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = pmp_impl_session_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = pmp_impl_session_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = pmp_impl_session_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = pmp_impl_session_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PmpImplSessionSkeletonPrivate));
#endif
}

static void
pmp_impl_session_skeleton_iface_init (PmpImplSessionIface *iface)
{
  iface->closed = _pmp_impl_session_on_signal_closed;
  iface->get_version = pmp_impl_session_skeleton_get_version;
}

/**
 * pmp_impl_session_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Session.top_of_page">org.freedesktop.impl.portal.Session</link>.
 *
 * Returns: (transfer full) (type PmpImplSessionSkeleton): The skeleton object.
 */
PmpImplSession *
pmp_impl_session_skeleton_new (void)
{
  return PMP_IMPL_SESSION (g_object_new (PMP_IMPL_TYPE_SESSION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Settings
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:PmpImplSettings
 * @title: PmpImplSettings
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Settings D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Settings.top_of_page">org.freedesktop.impl.portal.Settings</link> D-Bus interface in C.
 */

enum
{
  PMP_IMPL__SETTINGS_SETTING_CHANGED,
};

static unsigned PMP_IMPL__SETTINGS_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.freedesktop.impl.portal.Settings ---- */

static const _ExtendedGDBusArgInfo _pmp_impl_settings_method_info_read_all_IN_ARG_namespaces =
{
  {
    -1,
    (gchar *) "namespaces",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _pmp_impl_settings_method_info_read_all_IN_ARG_pointers[] =
{
  &_pmp_impl_settings_method_info_read_all_IN_ARG_namespaces.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _pmp_impl_settings_method_info_read_all_OUT_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "a{sa{sv}}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _pmp_impl_settings_method_info_read_all_OUT_ARG_pointers[] =
{
  &_pmp_impl_settings_method_info_read_all_OUT_ARG_value.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _pmp_impl_settings_method_read_all_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out0",
  (gchar *) "QMap<QString,QVariantMap>",
  NULL
};

static const GDBusAnnotationInfo * const _pmp_impl_settings_method_read_all_annotation_info_pointers[] =
{
  &_pmp_impl_settings_method_read_all_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _pmp_impl_settings_method_info_read_all =
{
  {
    -1,
    (gchar *) "ReadAll",
    (GDBusArgInfo **) &_pmp_impl_settings_method_info_read_all_IN_ARG_pointers,
    (GDBusArgInfo **) &_pmp_impl_settings_method_info_read_all_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_pmp_impl_settings_method_read_all_annotation_info_pointers
  },
  "handle-read-all",
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_settings_method_info_read_IN_ARG_namespace =
{
  {
    -1,
    (gchar *) "namespace",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_settings_method_info_read_IN_ARG_key =
{
  {
    -1,
    (gchar *) "key",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _pmp_impl_settings_method_info_read_IN_ARG_pointers[] =
{
  &_pmp_impl_settings_method_info_read_IN_ARG_namespace.parent_struct,
  &_pmp_impl_settings_method_info_read_IN_ARG_key.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _pmp_impl_settings_method_info_read_OUT_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _pmp_impl_settings_method_info_read_OUT_ARG_pointers[] =
{
  &_pmp_impl_settings_method_info_read_OUT_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _pmp_impl_settings_method_info_read =
{
  {
    -1,
    (gchar *) "Read",
    (GDBusArgInfo **) &_pmp_impl_settings_method_info_read_IN_ARG_pointers,
    (GDBusArgInfo **) &_pmp_impl_settings_method_info_read_OUT_ARG_pointers,
    NULL
  },
  "handle-read",
  FALSE
};

static const GDBusMethodInfo * const _pmp_impl_settings_method_info_pointers[] =
{
  &_pmp_impl_settings_method_info_read_all.parent_struct,
  &_pmp_impl_settings_method_info_read.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _pmp_impl_settings_signal_info_setting_changed_ARG_namespace =
{
  {
    -1,
    (gchar *) "namespace",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_settings_signal_info_setting_changed_ARG_key =
{
  {
    -1,
    (gchar *) "key",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_settings_signal_info_setting_changed_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _pmp_impl_settings_signal_info_setting_changed_ARG_pointers[] =
{
  &_pmp_impl_settings_signal_info_setting_changed_ARG_namespace.parent_struct,
  &_pmp_impl_settings_signal_info_setting_changed_ARG_key.parent_struct,
  &_pmp_impl_settings_signal_info_setting_changed_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _pmp_impl_settings_signal_info_setting_changed =
{
  {
    -1,
    (gchar *) "SettingChanged",
    (GDBusArgInfo **) &_pmp_impl_settings_signal_info_setting_changed_ARG_pointers,
    NULL
  },
  "setting-changed"
};

static const GDBusSignalInfo * const _pmp_impl_settings_signal_info_pointers[] =
{
  &_pmp_impl_settings_signal_info_setting_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _pmp_impl_settings_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _pmp_impl_settings_property_info_pointers[] =
{
  &_pmp_impl_settings_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _pmp_impl_settings_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Settings",
    (GDBusMethodInfo **) &_pmp_impl_settings_method_info_pointers,
    (GDBusSignalInfo **) &_pmp_impl_settings_signal_info_pointers,
    (GDBusPropertyInfo **) &_pmp_impl_settings_property_info_pointers,
    NULL
  },
  "settings",
};


/**
 * pmp_impl_settings_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Settings.top_of_page">org.freedesktop.impl.portal.Settings</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
pmp_impl_settings_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_pmp_impl_settings_interface_info.parent_struct;
}

/**
 * pmp_impl_settings_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #PmpImplSettings interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
pmp_impl_settings_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}


inline static void
pmp_impl_settings_signal_marshal_setting_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
pmp_impl_settings_method_marshal_read_all (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
pmp_impl_settings_method_marshal_read (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * PmpImplSettings:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Settings.top_of_page">org.freedesktop.impl.portal.Settings</link>.
 */

/**
 * PmpImplSettingsIface:
 * @parent_iface: The parent interface.
 * @handle_read: Handler for the #PmpImplSettings::handle-read signal.
 * @handle_read_all: Handler for the #PmpImplSettings::handle-read-all signal.
 * @get_version: Getter for the #PmpImplSettings:version property.
 * @setting_changed: Handler for the #PmpImplSettings::setting-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Settings.top_of_page">org.freedesktop.impl.portal.Settings</link>.
 */

typedef PmpImplSettingsIface PmpImplSettingsInterface;
G_DEFINE_INTERFACE (PmpImplSettings, pmp_impl_settings, G_TYPE_OBJECT)

static void
pmp_impl_settings_default_init (PmpImplSettingsIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * PmpImplSettings::handle-read-all:
   * @object: A #PmpImplSettings.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_namespaces: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Settings.ReadAll">ReadAll()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call pmp_impl_settings_complete_read_all() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-read-all",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PmpImplSettingsIface, handle_read_all),
    g_signal_accumulator_true_handled,
    NULL,
      pmp_impl_settings_method_marshal_read_all,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * PmpImplSettings::handle-read:
   * @object: A #PmpImplSettings.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_namespace: Argument passed by remote caller.
   * @arg_key: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Settings.Read">Read()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call pmp_impl_settings_complete_read() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-read",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PmpImplSettingsIface, handle_read),
    g_signal_accumulator_true_handled,
    NULL,
      pmp_impl_settings_method_marshal_read,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * PmpImplSettings::setting-changed:
   * @object: A #PmpImplSettings.
   * @arg_namespace: Argument.
   * @arg_key: Argument.
   * @arg_value: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-impl-portal-Settings.SettingChanged">"SettingChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PMP_IMPL__SETTINGS_SIGNALS[PMP_IMPL__SETTINGS_SETTING_CHANGED] =
    g_signal_new ("setting-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PmpImplSettingsIface, setting_changed),
      NULL,
      NULL,
      pmp_impl_settings_signal_marshal_setting_changed,
      G_TYPE_NONE,
      3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * PmpImplSettings:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Settings.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * pmp_impl_settings_get_version: (skip)
 * @object: A #PmpImplSettings.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Settings.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
pmp_impl_settings_get_version (PmpImplSettings *object)
{
  g_return_val_if_fail (PMP_IMPL_IS_SETTINGS (object), 0);

  return PMP_IMPL_SETTINGS_GET_IFACE (object)->get_version (object);
}

/**
 * pmp_impl_settings_set_version: (skip)
 * @object: A #PmpImplSettings.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Settings.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
pmp_impl_settings_set_version (PmpImplSettings *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * pmp_impl_settings_emit_setting_changed:
 * @object: A #PmpImplSettings.
 * @arg_namespace: Argument to pass with the signal.
 * @arg_key: Argument to pass with the signal.
 * @arg_value: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-impl-portal-Settings.SettingChanged">"SettingChanged"</link> D-Bus signal.
 */
void
pmp_impl_settings_emit_setting_changed (
    PmpImplSettings *object,
    const gchar *arg_namespace,
    const gchar *arg_key,
    GVariant *arg_value)
{
  g_signal_emit (object, PMP_IMPL__SETTINGS_SIGNALS[PMP_IMPL__SETTINGS_SETTING_CHANGED], 0, arg_namespace, arg_key, arg_value);
}

/**
 * pmp_impl_settings_call_read_all:
 * @proxy: A #PmpImplSettingsProxy.
 * @arg_namespaces: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Settings.ReadAll">ReadAll()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_settings_call_read_all_finish() to get the result of the operation.
 *
 * See pmp_impl_settings_call_read_all_sync() for the synchronous, blocking version of this method.
 */
void
pmp_impl_settings_call_read_all (
    PmpImplSettings *proxy,
    const gchar *const *arg_namespaces,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReadAll",
    g_variant_new ("(^as)",
                   arg_namespaces),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * pmp_impl_settings_call_read_all_finish:
 * @proxy: A #PmpImplSettingsProxy.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_settings_call_read_all().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with pmp_impl_settings_call_read_all().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_settings_call_read_all_finish (
    PmpImplSettings *proxy,
    GVariant **out_value,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sa{sv}})",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_settings_call_read_all_sync:
 * @proxy: A #PmpImplSettingsProxy.
 * @arg_namespaces: Argument to pass with the method invocation.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Settings.ReadAll">ReadAll()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_settings_call_read_all() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_settings_call_read_all_sync (
    PmpImplSettings *proxy,
    const gchar *const *arg_namespaces,
    GVariant **out_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReadAll",
    g_variant_new ("(^as)",
                   arg_namespaces),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sa{sv}})",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_settings_call_read:
 * @proxy: A #PmpImplSettingsProxy.
 * @arg_namespace: Argument to pass with the method invocation.
 * @arg_key: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Settings.Read">Read()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_settings_call_read_finish() to get the result of the operation.
 *
 * See pmp_impl_settings_call_read_sync() for the synchronous, blocking version of this method.
 */
void
pmp_impl_settings_call_read (
    PmpImplSettings *proxy,
    const gchar *arg_namespace,
    const gchar *arg_key,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Read",
    g_variant_new ("(ss)",
                   arg_namespace,
                   arg_key),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * pmp_impl_settings_call_read_finish:
 * @proxy: A #PmpImplSettingsProxy.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_settings_call_read().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with pmp_impl_settings_call_read().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_settings_call_read_finish (
    PmpImplSettings *proxy,
    GVariant **out_value,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@v)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_settings_call_read_sync:
 * @proxy: A #PmpImplSettingsProxy.
 * @arg_namespace: Argument to pass with the method invocation.
 * @arg_key: Argument to pass with the method invocation.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Settings.Read">Read()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_settings_call_read() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_settings_call_read_sync (
    PmpImplSettings *proxy,
    const gchar *arg_namespace,
    const gchar *arg_key,
    GVariant **out_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Read",
    g_variant_new ("(ss)",
                   arg_namespace,
                   arg_key),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@v)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_settings_complete_read_all:
 * @object: A #PmpImplSettings.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @value: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Settings.ReadAll">ReadAll()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
pmp_impl_settings_complete_read_all (
    PmpImplSettings *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *value)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sa{sv}})",
                   value));
}

/**
 * pmp_impl_settings_complete_read:
 * @object: A #PmpImplSettings.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @value: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Settings.Read">Read()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
pmp_impl_settings_complete_read (
    PmpImplSettings *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *value)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@v)",
                   value));
}

/* ------------------------------------------------------------------------ */

/**
 * PmpImplSettingsProxy:
 *
 * The #PmpImplSettingsProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PmpImplSettingsProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PmpImplSettingsProxy.
 */

struct _PmpImplSettingsProxyPrivate
{
  GData *qdata;
};

static void pmp_impl_settings_proxy_iface_init (PmpImplSettingsIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PmpImplSettingsProxy, pmp_impl_settings_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (PmpImplSettingsProxy)
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_SETTINGS, pmp_impl_settings_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PmpImplSettingsProxy, pmp_impl_settings_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_SETTINGS, pmp_impl_settings_proxy_iface_init))

#endif
static void
pmp_impl_settings_proxy_finalize (GObject *object)
{
  PmpImplSettingsProxy *proxy = PMP_IMPL_SETTINGS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (pmp_impl_settings_proxy_parent_class)->finalize (object);
}

static void
pmp_impl_settings_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _pmp_impl_settings_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
pmp_impl_settings_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.Settings: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
pmp_impl_settings_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _pmp_impl_settings_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.Settings", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) pmp_impl_settings_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
pmp_impl_settings_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_pmp_impl_settings_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], PMP_IMPL_TYPE_SETTINGS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PMP_IMPL_TYPE_SETTINGS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
pmp_impl_settings_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  PmpImplSettingsProxy *proxy = PMP_IMPL_SETTINGS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_settings_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_settings_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
pmp_impl_settings_proxy_get_version (PmpImplSettings *object)
{
  PmpImplSettingsProxy *proxy = PMP_IMPL_SETTINGS_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
pmp_impl_settings_proxy_init (PmpImplSettingsProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = pmp_impl_settings_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, PMP_IMPL_TYPE_SETTINGS_PROXY, PmpImplSettingsProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), pmp_impl_settings_interface_info ());
}

static void
pmp_impl_settings_proxy_class_init (PmpImplSettingsProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = pmp_impl_settings_proxy_finalize;
  gobject_class->get_property = pmp_impl_settings_proxy_get_property;
  gobject_class->set_property = pmp_impl_settings_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = pmp_impl_settings_proxy_g_signal;
  proxy_class->g_properties_changed = pmp_impl_settings_proxy_g_properties_changed;

  pmp_impl_settings_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PmpImplSettingsProxyPrivate));
#endif
}

static void
pmp_impl_settings_proxy_iface_init (PmpImplSettingsIface *iface)
{
  iface->get_version = pmp_impl_settings_proxy_get_version;
}

/**
 * pmp_impl_settings_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Settings.top_of_page">org.freedesktop.impl.portal.Settings</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_settings_proxy_new_finish() to get the result of the operation.
 *
 * See pmp_impl_settings_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
pmp_impl_settings_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PMP_IMPL_TYPE_SETTINGS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Settings", NULL);
}

/**
 * pmp_impl_settings_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_settings_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with pmp_impl_settings_proxy_new().
 *
 * Returns: (transfer full) (type PmpImplSettingsProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplSettings *
pmp_impl_settings_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PMP_IMPL_SETTINGS (ret);
  else
    return NULL;
}

/**
 * pmp_impl_settings_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Settings.top_of_page">org.freedesktop.impl.portal.Settings</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_settings_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PmpImplSettingsProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplSettings *
pmp_impl_settings_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PMP_IMPL_TYPE_SETTINGS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Settings", NULL);
  if (ret != NULL)
    return PMP_IMPL_SETTINGS (ret);
  else
    return NULL;
}


/**
 * pmp_impl_settings_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like pmp_impl_settings_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_settings_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See pmp_impl_settings_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
pmp_impl_settings_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PMP_IMPL_TYPE_SETTINGS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Settings", NULL);
}

/**
 * pmp_impl_settings_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_settings_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with pmp_impl_settings_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type PmpImplSettingsProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplSettings *
pmp_impl_settings_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PMP_IMPL_SETTINGS (ret);
  else
    return NULL;
}

/**
 * pmp_impl_settings_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like pmp_impl_settings_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_settings_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PmpImplSettingsProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplSettings *
pmp_impl_settings_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PMP_IMPL_TYPE_SETTINGS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Settings", NULL);
  if (ret != NULL)
    return PMP_IMPL_SETTINGS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * PmpImplSettingsSkeleton:
 *
 * The #PmpImplSettingsSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PmpImplSettingsSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PmpImplSettingsSkeleton.
 */

struct _PmpImplSettingsSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_pmp_impl_settings_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  PmpImplSettingsSkeleton *skeleton = PMP_IMPL_SETTINGS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], PMP_IMPL_TYPE_SETTINGS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PMP_IMPL_TYPE_SETTINGS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_pmp_impl_settings_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  PmpImplSettingsSkeleton *skeleton = PMP_IMPL_SETTINGS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_settings_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_pmp_impl_settings_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  PmpImplSettingsSkeleton *skeleton = PMP_IMPL_SETTINGS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_settings_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _pmp_impl_settings_skeleton_vtable =
{
  _pmp_impl_settings_skeleton_handle_method_call,
  _pmp_impl_settings_skeleton_handle_get_property,
  _pmp_impl_settings_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
pmp_impl_settings_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return pmp_impl_settings_interface_info ();
}

static GDBusInterfaceVTable *
pmp_impl_settings_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_pmp_impl_settings_skeleton_vtable;
}

static GVariant *
pmp_impl_settings_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  PmpImplSettingsSkeleton *skeleton = PMP_IMPL_SETTINGS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_pmp_impl_settings_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _pmp_impl_settings_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _pmp_impl_settings_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _pmp_impl_settings_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Settings", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _pmp_impl_settings_emit_changed (gpointer user_data);

static void
pmp_impl_settings_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  PmpImplSettingsSkeleton *skeleton = PMP_IMPL_SETTINGS_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _pmp_impl_settings_emit_changed (skeleton);
}

static void
_pmp_impl_settings_on_signal_setting_changed (
    PmpImplSettings *object,
    const gchar *arg_namespace,
    const gchar *arg_key,
    GVariant *arg_value)
{
  PmpImplSettingsSkeleton *skeleton = PMP_IMPL_SETTINGS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss@v)",
                   arg_namespace,
                   arg_key,
                   arg_value));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Settings", "SettingChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void pmp_impl_settings_skeleton_iface_init (PmpImplSettingsIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PmpImplSettingsSkeleton, pmp_impl_settings_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (PmpImplSettingsSkeleton)
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_SETTINGS, pmp_impl_settings_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PmpImplSettingsSkeleton, pmp_impl_settings_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_SETTINGS, pmp_impl_settings_skeleton_iface_init))

#endif
static void
pmp_impl_settings_skeleton_finalize (GObject *object)
{
  PmpImplSettingsSkeleton *skeleton = PMP_IMPL_SETTINGS_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (pmp_impl_settings_skeleton_parent_class)->finalize (object);
}

static void
pmp_impl_settings_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  PmpImplSettingsSkeleton *skeleton = PMP_IMPL_SETTINGS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_pmp_impl_settings_emit_changed (gpointer user_data)
{
  PmpImplSettingsSkeleton *skeleton = PMP_IMPL_SETTINGS_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.Settings",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_pmp_impl_settings_schedule_emit_changed (PmpImplSettingsSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
pmp_impl_settings_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  PmpImplSettingsSkeleton *skeleton = PMP_IMPL_SETTINGS_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _pmp_impl_settings_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _pmp_impl_settings_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
pmp_impl_settings_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  PmpImplSettingsSkeleton *skeleton = PMP_IMPL_SETTINGS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _pmp_impl_settings_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _pmp_impl_settings_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
pmp_impl_settings_skeleton_init (PmpImplSettingsSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = pmp_impl_settings_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, PMP_IMPL_TYPE_SETTINGS_SKELETON, PmpImplSettingsSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
pmp_impl_settings_skeleton_get_version (PmpImplSettings *object)
{
  PmpImplSettingsSkeleton *skeleton = PMP_IMPL_SETTINGS_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
pmp_impl_settings_skeleton_class_init (PmpImplSettingsSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = pmp_impl_settings_skeleton_finalize;
  gobject_class->get_property = pmp_impl_settings_skeleton_get_property;
  gobject_class->set_property = pmp_impl_settings_skeleton_set_property;
  gobject_class->notify       = pmp_impl_settings_skeleton_notify;


  pmp_impl_settings_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = pmp_impl_settings_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = pmp_impl_settings_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = pmp_impl_settings_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = pmp_impl_settings_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PmpImplSettingsSkeletonPrivate));
#endif
}

static void
pmp_impl_settings_skeleton_iface_init (PmpImplSettingsIface *iface)
{
  iface->setting_changed = _pmp_impl_settings_on_signal_setting_changed;
  iface->get_version = pmp_impl_settings_skeleton_get_version;
}

/**
 * pmp_impl_settings_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Settings.top_of_page">org.freedesktop.impl.portal.Settings</link>.
 *
 * Returns: (transfer full) (type PmpImplSettingsSkeleton): The skeleton object.
 */
PmpImplSettings *
pmp_impl_settings_skeleton_new (void)
{
  return PMP_IMPL_SETTINGS (g_object_new (PMP_IMPL_TYPE_SETTINGS_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Wallpaper
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:PmpImplWallpaper
 * @title: PmpImplWallpaper
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Wallpaper D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Wallpaper.top_of_page">org.freedesktop.impl.portal.Wallpaper</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Wallpaper ---- */

static const _ExtendedGDBusArgInfo _pmp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_uri =
{
  {
    -1,
    (gchar *) "uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _pmp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _pmp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_pointers[] =
{
  &_pmp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_handle.parent_struct,
  &_pmp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_app_id.parent_struct,
  &_pmp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_parent_window.parent_struct,
  &_pmp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_uri.parent_struct,
  &_pmp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _pmp_impl_wallpaper_method_info_set_wallpaper_uri_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _pmp_impl_wallpaper_method_info_set_wallpaper_uri_OUT_ARG_pointers[] =
{
  &_pmp_impl_wallpaper_method_info_set_wallpaper_uri_OUT_ARG_response.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _pmp_impl_wallpaper_method_set_wallpaper_uri_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _pmp_impl_wallpaper_method_set_wallpaper_uri_annotation_info_pointers[] =
{
  &_pmp_impl_wallpaper_method_set_wallpaper_uri_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _pmp_impl_wallpaper_method_info_set_wallpaper_uri =
{
  {
    -1,
    (gchar *) "SetWallpaperURI",
    (GDBusArgInfo **) &_pmp_impl_wallpaper_method_info_set_wallpaper_uri_IN_ARG_pointers,
    (GDBusArgInfo **) &_pmp_impl_wallpaper_method_info_set_wallpaper_uri_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_pmp_impl_wallpaper_method_set_wallpaper_uri_annotation_info_pointers
  },
  "handle-set-wallpaper-uri",
  FALSE
};

static const GDBusMethodInfo * const _pmp_impl_wallpaper_method_info_pointers[] =
{
  &_pmp_impl_wallpaper_method_info_set_wallpaper_uri.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _pmp_impl_wallpaper_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Wallpaper",
    (GDBusMethodInfo **) &_pmp_impl_wallpaper_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "wallpaper",
};


/**
 * pmp_impl_wallpaper_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Wallpaper.top_of_page">org.freedesktop.impl.portal.Wallpaper</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
pmp_impl_wallpaper_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_pmp_impl_wallpaper_interface_info.parent_struct;
}

/**
 * pmp_impl_wallpaper_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #PmpImplWallpaper interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
pmp_impl_wallpaper_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
pmp_impl_wallpaper_method_marshal_set_wallpaper_uri (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * PmpImplWallpaper:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Wallpaper.top_of_page">org.freedesktop.impl.portal.Wallpaper</link>.
 */

/**
 * PmpImplWallpaperIface:
 * @parent_iface: The parent interface.
 * @handle_set_wallpaper_uri: Handler for the #PmpImplWallpaper::handle-set-wallpaper-uri signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Wallpaper.top_of_page">org.freedesktop.impl.portal.Wallpaper</link>.
 */

typedef PmpImplWallpaperIface PmpImplWallpaperInterface;
G_DEFINE_INTERFACE (PmpImplWallpaper, pmp_impl_wallpaper, G_TYPE_OBJECT)

static void
pmp_impl_wallpaper_default_init (PmpImplWallpaperIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * PmpImplWallpaper::handle-set-wallpaper-uri:
   * @object: A #PmpImplWallpaper.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_uri: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Wallpaper.SetWallpaperURI">SetWallpaperURI()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call pmp_impl_wallpaper_complete_set_wallpaper_uri() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-wallpaper-uri",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PmpImplWallpaperIface, handle_set_wallpaper_uri),
    g_signal_accumulator_true_handled,
    NULL,
      pmp_impl_wallpaper_method_marshal_set_wallpaper_uri,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * pmp_impl_wallpaper_call_set_wallpaper_uri:
 * @proxy: A #PmpImplWallpaperProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Wallpaper.SetWallpaperURI">SetWallpaperURI()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_wallpaper_call_set_wallpaper_uri_finish() to get the result of the operation.
 *
 * See pmp_impl_wallpaper_call_set_wallpaper_uri_sync() for the synchronous, blocking version of this method.
 */
void
pmp_impl_wallpaper_call_set_wallpaper_uri (
    PmpImplWallpaper *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_uri,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetWallpaperURI",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_uri,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * pmp_impl_wallpaper_call_set_wallpaper_uri_finish:
 * @proxy: A #PmpImplWallpaperProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_wallpaper_call_set_wallpaper_uri().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with pmp_impl_wallpaper_call_set_wallpaper_uri().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_wallpaper_call_set_wallpaper_uri_finish (
    PmpImplWallpaper *proxy,
    guint *out_response,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_wallpaper_call_set_wallpaper_uri_sync:
 * @proxy: A #PmpImplWallpaperProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Wallpaper.SetWallpaperURI">SetWallpaperURI()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_wallpaper_call_set_wallpaper_uri() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
pmp_impl_wallpaper_call_set_wallpaper_uri_sync (
    PmpImplWallpaper *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_uri,
    GVariant *arg_options,
    guint *out_response,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetWallpaperURI",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_uri,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * pmp_impl_wallpaper_complete_set_wallpaper_uri:
 * @object: A #PmpImplWallpaper.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Wallpaper.SetWallpaperURI">SetWallpaperURI()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
pmp_impl_wallpaper_complete_set_wallpaper_uri (
    PmpImplWallpaper *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   response));
}

/* ------------------------------------------------------------------------ */

/**
 * PmpImplWallpaperProxy:
 *
 * The #PmpImplWallpaperProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PmpImplWallpaperProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PmpImplWallpaperProxy.
 */

struct _PmpImplWallpaperProxyPrivate
{
  GData *qdata;
};

static void pmp_impl_wallpaper_proxy_iface_init (PmpImplWallpaperIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PmpImplWallpaperProxy, pmp_impl_wallpaper_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (PmpImplWallpaperProxy)
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_WALLPAPER, pmp_impl_wallpaper_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PmpImplWallpaperProxy, pmp_impl_wallpaper_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_WALLPAPER, pmp_impl_wallpaper_proxy_iface_init))

#endif
static void
pmp_impl_wallpaper_proxy_finalize (GObject *object)
{
  PmpImplWallpaperProxy *proxy = PMP_IMPL_WALLPAPER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (pmp_impl_wallpaper_proxy_parent_class)->finalize (object);
}

static void
pmp_impl_wallpaper_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
pmp_impl_wallpaper_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
pmp_impl_wallpaper_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_pmp_impl_wallpaper_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], PMP_IMPL_TYPE_WALLPAPER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PMP_IMPL_TYPE_WALLPAPER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
pmp_impl_wallpaper_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  PmpImplWallpaperProxy *proxy = PMP_IMPL_WALLPAPER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_wallpaper_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_wallpaper_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
pmp_impl_wallpaper_proxy_init (PmpImplWallpaperProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = pmp_impl_wallpaper_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, PMP_IMPL_TYPE_WALLPAPER_PROXY, PmpImplWallpaperProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), pmp_impl_wallpaper_interface_info ());
}

static void
pmp_impl_wallpaper_proxy_class_init (PmpImplWallpaperProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = pmp_impl_wallpaper_proxy_finalize;
  gobject_class->get_property = pmp_impl_wallpaper_proxy_get_property;
  gobject_class->set_property = pmp_impl_wallpaper_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = pmp_impl_wallpaper_proxy_g_signal;
  proxy_class->g_properties_changed = pmp_impl_wallpaper_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PmpImplWallpaperProxyPrivate));
#endif
}

static void
pmp_impl_wallpaper_proxy_iface_init (PmpImplWallpaperIface *iface G_GNUC_UNUSED)
{
}

/**
 * pmp_impl_wallpaper_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Wallpaper.top_of_page">org.freedesktop.impl.portal.Wallpaper</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_wallpaper_proxy_new_finish() to get the result of the operation.
 *
 * See pmp_impl_wallpaper_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
pmp_impl_wallpaper_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PMP_IMPL_TYPE_WALLPAPER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Wallpaper", NULL);
}

/**
 * pmp_impl_wallpaper_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_wallpaper_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with pmp_impl_wallpaper_proxy_new().
 *
 * Returns: (transfer full) (type PmpImplWallpaperProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplWallpaper *
pmp_impl_wallpaper_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PMP_IMPL_WALLPAPER (ret);
  else
    return NULL;
}

/**
 * pmp_impl_wallpaper_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Wallpaper.top_of_page">org.freedesktop.impl.portal.Wallpaper</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_wallpaper_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PmpImplWallpaperProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplWallpaper *
pmp_impl_wallpaper_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PMP_IMPL_TYPE_WALLPAPER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Wallpaper", NULL);
  if (ret != NULL)
    return PMP_IMPL_WALLPAPER (ret);
  else
    return NULL;
}


/**
 * pmp_impl_wallpaper_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like pmp_impl_wallpaper_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call pmp_impl_wallpaper_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See pmp_impl_wallpaper_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
pmp_impl_wallpaper_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PMP_IMPL_TYPE_WALLPAPER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Wallpaper", NULL);
}

/**
 * pmp_impl_wallpaper_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to pmp_impl_wallpaper_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with pmp_impl_wallpaper_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type PmpImplWallpaperProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplWallpaper *
pmp_impl_wallpaper_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PMP_IMPL_WALLPAPER (ret);
  else
    return NULL;
}

/**
 * pmp_impl_wallpaper_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like pmp_impl_wallpaper_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See pmp_impl_wallpaper_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PmpImplWallpaperProxy): The constructed proxy object or %NULL if @error is set.
 */
PmpImplWallpaper *
pmp_impl_wallpaper_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PMP_IMPL_TYPE_WALLPAPER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Wallpaper", NULL);
  if (ret != NULL)
    return PMP_IMPL_WALLPAPER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * PmpImplWallpaperSkeleton:
 *
 * The #PmpImplWallpaperSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PmpImplWallpaperSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PmpImplWallpaperSkeleton.
 */

struct _PmpImplWallpaperSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_pmp_impl_wallpaper_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  PmpImplWallpaperSkeleton *skeleton = PMP_IMPL_WALLPAPER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], PMP_IMPL_TYPE_WALLPAPER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PMP_IMPL_TYPE_WALLPAPER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_pmp_impl_wallpaper_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  PmpImplWallpaperSkeleton *skeleton = PMP_IMPL_WALLPAPER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_wallpaper_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_pmp_impl_wallpaper_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  PmpImplWallpaperSkeleton *skeleton = PMP_IMPL_WALLPAPER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_pmp_impl_wallpaper_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _pmp_impl_wallpaper_skeleton_vtable =
{
  _pmp_impl_wallpaper_skeleton_handle_method_call,
  _pmp_impl_wallpaper_skeleton_handle_get_property,
  _pmp_impl_wallpaper_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
pmp_impl_wallpaper_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return pmp_impl_wallpaper_interface_info ();
}

static GDBusInterfaceVTable *
pmp_impl_wallpaper_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_pmp_impl_wallpaper_skeleton_vtable;
}

static GVariant *
pmp_impl_wallpaper_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  PmpImplWallpaperSkeleton *skeleton = PMP_IMPL_WALLPAPER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_pmp_impl_wallpaper_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _pmp_impl_wallpaper_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _pmp_impl_wallpaper_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _pmp_impl_wallpaper_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Wallpaper", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
pmp_impl_wallpaper_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void pmp_impl_wallpaper_skeleton_iface_init (PmpImplWallpaperIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PmpImplWallpaperSkeleton, pmp_impl_wallpaper_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (PmpImplWallpaperSkeleton)
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_WALLPAPER, pmp_impl_wallpaper_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PmpImplWallpaperSkeleton, pmp_impl_wallpaper_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (PMP_IMPL_TYPE_WALLPAPER, pmp_impl_wallpaper_skeleton_iface_init))

#endif
static void
pmp_impl_wallpaper_skeleton_finalize (GObject *object)
{
  PmpImplWallpaperSkeleton *skeleton = PMP_IMPL_WALLPAPER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (pmp_impl_wallpaper_skeleton_parent_class)->finalize (object);
}

static void
pmp_impl_wallpaper_skeleton_init (PmpImplWallpaperSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = pmp_impl_wallpaper_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, PMP_IMPL_TYPE_WALLPAPER_SKELETON, PmpImplWallpaperSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
pmp_impl_wallpaper_skeleton_class_init (PmpImplWallpaperSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = pmp_impl_wallpaper_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = pmp_impl_wallpaper_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = pmp_impl_wallpaper_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = pmp_impl_wallpaper_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = pmp_impl_wallpaper_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PmpImplWallpaperSkeletonPrivate));
#endif
}

static void
pmp_impl_wallpaper_skeleton_iface_init (PmpImplWallpaperIface *iface G_GNUC_UNUSED)
{
}

/**
 * pmp_impl_wallpaper_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Wallpaper.top_of_page">org.freedesktop.impl.portal.Wallpaper</link>.
 *
 * Returns: (transfer full) (type PmpImplWallpaperSkeleton): The skeleton object.
 */
PmpImplWallpaper *
pmp_impl_wallpaper_skeleton_new (void)
{
  return PMP_IMPL_WALLPAPER (g_object_new (PMP_IMPL_TYPE_WALLPAPER_SKELETON, NULL));
}

