/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

// CompressApplyConfiguration represents a declarative configuration of the Compress type for use
// with apply.
type CompressApplyConfiguration struct {
	ExcludedContentTypes []string `json:"excludedContentTypes,omitempty"`
	IncludedContentTypes []string `json:"includedContentTypes,omitempty"`
	MinResponseBodyBytes *int     `json:"minResponseBodyBytes,omitempty"`
	Encodings            []string `json:"encodings,omitempty"`
	DefaultEncoding      *string  `json:"defaultEncoding,omitempty"`
}

// CompressApplyConfiguration constructs a declarative configuration of the Compress type for use with
// apply.
func Compress() *CompressApplyConfiguration {
	return &CompressApplyConfiguration{}
}

// WithExcludedContentTypes adds the given value to the ExcludedContentTypes field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ExcludedContentTypes field.
func (b *CompressApplyConfiguration) WithExcludedContentTypes(values ...string) *CompressApplyConfiguration {
	for i := range values {
		b.ExcludedContentTypes = append(b.ExcludedContentTypes, values[i])
	}
	return b
}

// WithIncludedContentTypes adds the given value to the IncludedContentTypes field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the IncludedContentTypes field.
func (b *CompressApplyConfiguration) WithIncludedContentTypes(values ...string) *CompressApplyConfiguration {
	for i := range values {
		b.IncludedContentTypes = append(b.IncludedContentTypes, values[i])
	}
	return b
}

// WithMinResponseBodyBytes sets the MinResponseBodyBytes field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MinResponseBodyBytes field is set to the value of the last call.
func (b *CompressApplyConfiguration) WithMinResponseBodyBytes(value int) *CompressApplyConfiguration {
	b.MinResponseBodyBytes = &value
	return b
}

// WithEncodings adds the given value to the Encodings field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Encodings field.
func (b *CompressApplyConfiguration) WithEncodings(values ...string) *CompressApplyConfiguration {
	for i := range values {
		b.Encodings = append(b.Encodings, values[i])
	}
	return b
}

// WithDefaultEncoding sets the DefaultEncoding field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DefaultEncoding field is set to the value of the last call.
func (b *CompressApplyConfiguration) WithDefaultEncoding(value string) *CompressApplyConfiguration {
	b.DefaultEncoding = &value
	return b
}
