/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "thunar-thumbnailer-proxy.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__UINT_BOXED (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_UintBoxedFunc)
       (void *data1,
        guint arg_handle,
        const gchar *const *arg_uris,
        void *data2);
  _GDbusCodegenMarshalVoid_UintBoxedFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_UintBoxedFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_uint (param_values + 1),
            g_marshal_value_peek_boxed (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_VOID__UINT_BOXED_INT_STRING (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_UintBoxedIntStringFunc)
       (void *data1,
        guint arg_handle,
        const gchar *const *arg_failed_uris,
        gint arg_error_code,
        const gchar *arg_message,
        void *data2);
  _GDbusCodegenMarshalVoid_UintBoxedIntStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_UintBoxedIntStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_uint (param_values + 1),
            g_marshal_value_peek_boxed (param_values + 2),
            g_marshal_value_peek_int (param_values + 3),
            g_marshal_value_peek_string (param_values + 4),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED_BOXED_STRING_STRING_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBoxedBoxedStringStringUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *const *arg_uris,
        const gchar *const *arg_mime_hints,
        const gchar *arg_flavor,
        const gchar *arg_scheduler,
        guint arg_handle_to_unqueue,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBoxedBoxedStringStringUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 7);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBoxedBoxedStringStringUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boxed (param_values + 2),
              g_marshal_value_peek_boxed (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              g_marshal_value_peek_string (param_values + 5),
              g_marshal_value_peek_uint (param_values + 6),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_handle,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.thumbnails.Thumbnailer1
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:ThunarThumbnailerDBus
 * @title: ThunarThumbnailerDBus
 * @short_description: Generated C code for the org.freedesktop.thumbnails.Thumbnailer1 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-thumbnails-Thumbnailer1.top_of_page">org.freedesktop.thumbnails.Thumbnailer1</link> D-Bus interface in C.
 */

enum
{
  THUNAR__THUMBNAILER_DBUS_STARTED,
  THUNAR__THUMBNAILER_DBUS_FINISHED,
  THUNAR__THUMBNAILER_DBUS_READY,
  THUNAR__THUMBNAILER_DBUS_ERROR,
};

static unsigned THUNAR__THUMBNAILER_DBUS_SIGNALS[4] = { 0 };

/* ---- Introspection data for org.freedesktop.thumbnails.Thumbnailer1 ---- */

static const _ExtendedGDBusArgInfo _thunar_thumbnailer_dbus_method_info_queue_IN_ARG_uris =
{
  {
    -1,
    (gchar *) "uris",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _thunar_thumbnailer_dbus_method_info_queue_IN_ARG_mime_hints =
{
  {
    -1,
    (gchar *) "mime_hints",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _thunar_thumbnailer_dbus_method_info_queue_IN_ARG_flavor =
{
  {
    -1,
    (gchar *) "flavor",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _thunar_thumbnailer_dbus_method_info_queue_IN_ARG_scheduler =
{
  {
    -1,
    (gchar *) "scheduler",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _thunar_thumbnailer_dbus_method_info_queue_IN_ARG_handle_to_unqueue =
{
  {
    -1,
    (gchar *) "handle_to_unqueue",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _thunar_thumbnailer_dbus_method_info_queue_IN_ARG_pointers[] =
{
  &_thunar_thumbnailer_dbus_method_info_queue_IN_ARG_uris.parent_struct,
  &_thunar_thumbnailer_dbus_method_info_queue_IN_ARG_mime_hints.parent_struct,
  &_thunar_thumbnailer_dbus_method_info_queue_IN_ARG_flavor.parent_struct,
  &_thunar_thumbnailer_dbus_method_info_queue_IN_ARG_scheduler.parent_struct,
  &_thunar_thumbnailer_dbus_method_info_queue_IN_ARG_handle_to_unqueue.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _thunar_thumbnailer_dbus_method_info_queue_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _thunar_thumbnailer_dbus_method_info_queue_OUT_ARG_pointers[] =
{
  &_thunar_thumbnailer_dbus_method_info_queue_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _thunar_thumbnailer_dbus_method_info_queue =
{
  {
    -1,
    (gchar *) "Queue",
    (GDBusArgInfo **) &_thunar_thumbnailer_dbus_method_info_queue_IN_ARG_pointers,
    (GDBusArgInfo **) &_thunar_thumbnailer_dbus_method_info_queue_OUT_ARG_pointers,
    NULL
  },
  "handle-queue",
  FALSE
};

static const _ExtendedGDBusArgInfo _thunar_thumbnailer_dbus_method_info_dequeue_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _thunar_thumbnailer_dbus_method_info_dequeue_IN_ARG_pointers[] =
{
  &_thunar_thumbnailer_dbus_method_info_dequeue_IN_ARG_handle.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _thunar_thumbnailer_dbus_method_dequeue_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _thunar_thumbnailer_dbus_method_dequeue_annotation_info_pointers[] =
{
  &_thunar_thumbnailer_dbus_method_dequeue_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _thunar_thumbnailer_dbus_method_info_dequeue =
{
  {
    -1,
    (gchar *) "Dequeue",
    (GDBusArgInfo **) &_thunar_thumbnailer_dbus_method_info_dequeue_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_thunar_thumbnailer_dbus_method_dequeue_annotation_info_pointers
  },
  "handle-dequeue",
  FALSE
};

static const _ExtendedGDBusArgInfo _thunar_thumbnailer_dbus_method_info_get_supported_OUT_ARG_uri_schemes =
{
  {
    -1,
    (gchar *) "uri_schemes",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _thunar_thumbnailer_dbus_method_info_get_supported_OUT_ARG_mime_types =
{
  {
    -1,
    (gchar *) "mime_types",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _thunar_thumbnailer_dbus_method_info_get_supported_OUT_ARG_pointers[] =
{
  &_thunar_thumbnailer_dbus_method_info_get_supported_OUT_ARG_uri_schemes.parent_struct,
  &_thunar_thumbnailer_dbus_method_info_get_supported_OUT_ARG_mime_types.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _thunar_thumbnailer_dbus_method_get_supported_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _thunar_thumbnailer_dbus_method_get_supported_annotation_info_pointers[] =
{
  &_thunar_thumbnailer_dbus_method_get_supported_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _thunar_thumbnailer_dbus_method_info_get_supported =
{
  {
    -1,
    (gchar *) "GetSupported",
    NULL,
    (GDBusArgInfo **) &_thunar_thumbnailer_dbus_method_info_get_supported_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_thunar_thumbnailer_dbus_method_get_supported_annotation_info_pointers
  },
  "handle-get-supported",
  FALSE
};

static const _ExtendedGDBusArgInfo _thunar_thumbnailer_dbus_method_info_get_schedulers_OUT_ARG_schedulers =
{
  {
    -1,
    (gchar *) "schedulers",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _thunar_thumbnailer_dbus_method_info_get_schedulers_OUT_ARG_pointers[] =
{
  &_thunar_thumbnailer_dbus_method_info_get_schedulers_OUT_ARG_schedulers.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _thunar_thumbnailer_dbus_method_get_schedulers_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _thunar_thumbnailer_dbus_method_get_schedulers_annotation_info_pointers[] =
{
  &_thunar_thumbnailer_dbus_method_get_schedulers_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _thunar_thumbnailer_dbus_method_info_get_schedulers =
{
  {
    -1,
    (gchar *) "GetSchedulers",
    NULL,
    (GDBusArgInfo **) &_thunar_thumbnailer_dbus_method_info_get_schedulers_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_thunar_thumbnailer_dbus_method_get_schedulers_annotation_info_pointers
  },
  "handle-get-schedulers",
  FALSE
};

static const GDBusMethodInfo * const _thunar_thumbnailer_dbus_method_info_pointers[] =
{
  &_thunar_thumbnailer_dbus_method_info_queue.parent_struct,
  &_thunar_thumbnailer_dbus_method_info_dequeue.parent_struct,
  &_thunar_thumbnailer_dbus_method_info_get_supported.parent_struct,
  &_thunar_thumbnailer_dbus_method_info_get_schedulers.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _thunar_thumbnailer_dbus_signal_info_started_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _thunar_thumbnailer_dbus_signal_info_started_ARG_pointers[] =
{
  &_thunar_thumbnailer_dbus_signal_info_started_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _thunar_thumbnailer_dbus_signal_info_started =
{
  {
    -1,
    (gchar *) "Started",
    (GDBusArgInfo **) &_thunar_thumbnailer_dbus_signal_info_started_ARG_pointers,
    NULL
  },
  "started"
};

static const _ExtendedGDBusArgInfo _thunar_thumbnailer_dbus_signal_info_finished_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _thunar_thumbnailer_dbus_signal_info_finished_ARG_pointers[] =
{
  &_thunar_thumbnailer_dbus_signal_info_finished_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _thunar_thumbnailer_dbus_signal_info_finished =
{
  {
    -1,
    (gchar *) "Finished",
    (GDBusArgInfo **) &_thunar_thumbnailer_dbus_signal_info_finished_ARG_pointers,
    NULL
  },
  "finished"
};

static const _ExtendedGDBusArgInfo _thunar_thumbnailer_dbus_signal_info_ready_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _thunar_thumbnailer_dbus_signal_info_ready_ARG_uris =
{
  {
    -1,
    (gchar *) "uris",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _thunar_thumbnailer_dbus_signal_info_ready_ARG_pointers[] =
{
  &_thunar_thumbnailer_dbus_signal_info_ready_ARG_handle.parent_struct,
  &_thunar_thumbnailer_dbus_signal_info_ready_ARG_uris.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _thunar_thumbnailer_dbus_signal_info_ready =
{
  {
    -1,
    (gchar *) "Ready",
    (GDBusArgInfo **) &_thunar_thumbnailer_dbus_signal_info_ready_ARG_pointers,
    NULL
  },
  "ready"
};

static const _ExtendedGDBusArgInfo _thunar_thumbnailer_dbus_signal_info_error_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _thunar_thumbnailer_dbus_signal_info_error_ARG_failed_uris =
{
  {
    -1,
    (gchar *) "failed_uris",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _thunar_thumbnailer_dbus_signal_info_error_ARG_error_code =
{
  {
    -1,
    (gchar *) "error_code",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _thunar_thumbnailer_dbus_signal_info_error_ARG_message =
{
  {
    -1,
    (gchar *) "message",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _thunar_thumbnailer_dbus_signal_info_error_ARG_pointers[] =
{
  &_thunar_thumbnailer_dbus_signal_info_error_ARG_handle.parent_struct,
  &_thunar_thumbnailer_dbus_signal_info_error_ARG_failed_uris.parent_struct,
  &_thunar_thumbnailer_dbus_signal_info_error_ARG_error_code.parent_struct,
  &_thunar_thumbnailer_dbus_signal_info_error_ARG_message.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _thunar_thumbnailer_dbus_signal_info_error =
{
  {
    -1,
    (gchar *) "Error",
    (GDBusArgInfo **) &_thunar_thumbnailer_dbus_signal_info_error_ARG_pointers,
    NULL
  },
  "error"
};

static const GDBusSignalInfo * const _thunar_thumbnailer_dbus_signal_info_pointers[] =
{
  &_thunar_thumbnailer_dbus_signal_info_started.parent_struct,
  &_thunar_thumbnailer_dbus_signal_info_finished.parent_struct,
  &_thunar_thumbnailer_dbus_signal_info_ready.parent_struct,
  &_thunar_thumbnailer_dbus_signal_info_error.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _thunar_thumbnailer_dbus_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.thumbnails.Thumbnailer1",
    (GDBusMethodInfo **) &_thunar_thumbnailer_dbus_method_info_pointers,
    (GDBusSignalInfo **) &_thunar_thumbnailer_dbus_signal_info_pointers,
    NULL,
    NULL
  },
  "thumbnailer-dbus",
};


/**
 * thunar_thumbnailer_dbus_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-thumbnails-Thumbnailer1.top_of_page">org.freedesktop.thumbnails.Thumbnailer1</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
thunar_thumbnailer_dbus_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_thunar_thumbnailer_dbus_interface_info.parent_struct;
}

/**
 * thunar_thumbnailer_dbus_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #ThunarThumbnailerDBus interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
thunar_thumbnailer_dbus_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
thunar_thumbnailer_dbus_signal_marshal_started (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
thunar_thumbnailer_dbus_signal_marshal_finished (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
thunar_thumbnailer_dbus_signal_marshal_ready (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__UINT_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
thunar_thumbnailer_dbus_signal_marshal_error (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__UINT_BOXED_INT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
thunar_thumbnailer_dbus_method_marshal_queue (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED_BOXED_STRING_STRING_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
thunar_thumbnailer_dbus_method_marshal_dequeue (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
thunar_thumbnailer_dbus_method_marshal_get_supported (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
thunar_thumbnailer_dbus_method_marshal_get_schedulers (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * ThunarThumbnailerDBus:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-thumbnails-Thumbnailer1.top_of_page">org.freedesktop.thumbnails.Thumbnailer1</link>.
 */

/**
 * ThunarThumbnailerDBusIface:
 * @parent_iface: The parent interface.
 * @handle_dequeue: Handler for the #ThunarThumbnailerDBus::handle-dequeue signal.
 * @handle_get_schedulers: Handler for the #ThunarThumbnailerDBus::handle-get-schedulers signal.
 * @handle_get_supported: Handler for the #ThunarThumbnailerDBus::handle-get-supported signal.
 * @handle_queue: Handler for the #ThunarThumbnailerDBus::handle-queue signal.
 * @error: Handler for the #ThunarThumbnailerDBus::error signal.
 * @finished: Handler for the #ThunarThumbnailerDBus::finished signal.
 * @ready: Handler for the #ThunarThumbnailerDBus::ready signal.
 * @started: Handler for the #ThunarThumbnailerDBus::started signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-thumbnails-Thumbnailer1.top_of_page">org.freedesktop.thumbnails.Thumbnailer1</link>.
 */

typedef ThunarThumbnailerDBusIface ThunarThumbnailerDBusInterface;
G_DEFINE_INTERFACE (ThunarThumbnailerDBus, thunar_thumbnailer_dbus, G_TYPE_OBJECT)

static void
thunar_thumbnailer_dbus_default_init (ThunarThumbnailerDBusIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * ThunarThumbnailerDBus::handle-queue:
   * @object: A #ThunarThumbnailerDBus.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uris: Argument passed by remote caller.
   * @arg_mime_hints: Argument passed by remote caller.
   * @arg_flavor: Argument passed by remote caller.
   * @arg_scheduler: Argument passed by remote caller.
   * @arg_handle_to_unqueue: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-thumbnails-Thumbnailer1.Queue">Queue()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call thunar_thumbnailer_dbus_complete_queue() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-queue",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ThunarThumbnailerDBusIface, handle_queue),
    g_signal_accumulator_true_handled,
    NULL,
      thunar_thumbnailer_dbus_method_marshal_queue,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_STRV, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT);

  /**
   * ThunarThumbnailerDBus::handle-dequeue:
   * @object: A #ThunarThumbnailerDBus.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-thumbnails-Thumbnailer1.Dequeue">Dequeue()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call thunar_thumbnailer_dbus_complete_dequeue() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-dequeue",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ThunarThumbnailerDBusIface, handle_dequeue),
    g_signal_accumulator_true_handled,
    NULL,
      thunar_thumbnailer_dbus_method_marshal_dequeue,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * ThunarThumbnailerDBus::handle-get-supported:
   * @object: A #ThunarThumbnailerDBus.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-thumbnails-Thumbnailer1.GetSupported">GetSupported()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call thunar_thumbnailer_dbus_complete_get_supported() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-supported",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ThunarThumbnailerDBusIface, handle_get_supported),
    g_signal_accumulator_true_handled,
    NULL,
      thunar_thumbnailer_dbus_method_marshal_get_supported,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ThunarThumbnailerDBus::handle-get-schedulers:
   * @object: A #ThunarThumbnailerDBus.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-thumbnails-Thumbnailer1.GetSchedulers">GetSchedulers()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call thunar_thumbnailer_dbus_complete_get_schedulers() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-schedulers",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ThunarThumbnailerDBusIface, handle_get_schedulers),
    g_signal_accumulator_true_handled,
    NULL,
      thunar_thumbnailer_dbus_method_marshal_get_schedulers,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * ThunarThumbnailerDBus::started:
   * @object: A #ThunarThumbnailerDBus.
   * @arg_handle: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-thumbnails-Thumbnailer1.Started">"Started"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  THUNAR__THUMBNAILER_DBUS_SIGNALS[THUNAR__THUMBNAILER_DBUS_STARTED] =
    g_signal_new ("started",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (ThunarThumbnailerDBusIface, started),
      NULL,
      NULL,
      thunar_thumbnailer_dbus_signal_marshal_started,
      G_TYPE_NONE,
      1, G_TYPE_UINT);

  /**
   * ThunarThumbnailerDBus::finished:
   * @object: A #ThunarThumbnailerDBus.
   * @arg_handle: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-thumbnails-Thumbnailer1.Finished">"Finished"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  THUNAR__THUMBNAILER_DBUS_SIGNALS[THUNAR__THUMBNAILER_DBUS_FINISHED] =
    g_signal_new ("finished",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (ThunarThumbnailerDBusIface, finished),
      NULL,
      NULL,
      thunar_thumbnailer_dbus_signal_marshal_finished,
      G_TYPE_NONE,
      1, G_TYPE_UINT);

  /**
   * ThunarThumbnailerDBus::ready:
   * @object: A #ThunarThumbnailerDBus.
   * @arg_handle: Argument.
   * @arg_uris: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-thumbnails-Thumbnailer1.Ready">"Ready"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  THUNAR__THUMBNAILER_DBUS_SIGNALS[THUNAR__THUMBNAILER_DBUS_READY] =
    g_signal_new ("ready",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (ThunarThumbnailerDBusIface, ready),
      NULL,
      NULL,
      thunar_thumbnailer_dbus_signal_marshal_ready,
      G_TYPE_NONE,
      2, G_TYPE_UINT, G_TYPE_STRV);

  /**
   * ThunarThumbnailerDBus::error:
   * @object: A #ThunarThumbnailerDBus.
   * @arg_handle: Argument.
   * @arg_failed_uris: Argument.
   * @arg_error_code: Argument.
   * @arg_message: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-thumbnails-Thumbnailer1.Error">"Error"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  THUNAR__THUMBNAILER_DBUS_SIGNALS[THUNAR__THUMBNAILER_DBUS_ERROR] =
    g_signal_new ("error",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (ThunarThumbnailerDBusIface, error),
      NULL,
      NULL,
      thunar_thumbnailer_dbus_signal_marshal_error,
      G_TYPE_NONE,
      4, G_TYPE_UINT, G_TYPE_STRV, G_TYPE_INT, G_TYPE_STRING);

}

/**
 * thunar_thumbnailer_dbus_emit_started:
 * @object: A #ThunarThumbnailerDBus.
 * @arg_handle: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-thumbnails-Thumbnailer1.Started">"Started"</link> D-Bus signal.
 */
void
thunar_thumbnailer_dbus_emit_started (
    ThunarThumbnailerDBus *object,
    guint arg_handle)
{
  g_signal_emit (object, THUNAR__THUMBNAILER_DBUS_SIGNALS[THUNAR__THUMBNAILER_DBUS_STARTED], 0, arg_handle);
}

/**
 * thunar_thumbnailer_dbus_emit_finished:
 * @object: A #ThunarThumbnailerDBus.
 * @arg_handle: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-thumbnails-Thumbnailer1.Finished">"Finished"</link> D-Bus signal.
 */
void
thunar_thumbnailer_dbus_emit_finished (
    ThunarThumbnailerDBus *object,
    guint arg_handle)
{
  g_signal_emit (object, THUNAR__THUMBNAILER_DBUS_SIGNALS[THUNAR__THUMBNAILER_DBUS_FINISHED], 0, arg_handle);
}

/**
 * thunar_thumbnailer_dbus_emit_ready:
 * @object: A #ThunarThumbnailerDBus.
 * @arg_handle: Argument to pass with the signal.
 * @arg_uris: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-thumbnails-Thumbnailer1.Ready">"Ready"</link> D-Bus signal.
 */
void
thunar_thumbnailer_dbus_emit_ready (
    ThunarThumbnailerDBus *object,
    guint arg_handle,
    const gchar *const *arg_uris)
{
  g_signal_emit (object, THUNAR__THUMBNAILER_DBUS_SIGNALS[THUNAR__THUMBNAILER_DBUS_READY], 0, arg_handle, arg_uris);
}

/**
 * thunar_thumbnailer_dbus_emit_error:
 * @object: A #ThunarThumbnailerDBus.
 * @arg_handle: Argument to pass with the signal.
 * @arg_failed_uris: Argument to pass with the signal.
 * @arg_error_code: Argument to pass with the signal.
 * @arg_message: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-thumbnails-Thumbnailer1.Error">"Error"</link> D-Bus signal.
 */
void
thunar_thumbnailer_dbus_emit_error (
    ThunarThumbnailerDBus *object,
    guint arg_handle,
    const gchar *const *arg_failed_uris,
    gint arg_error_code,
    const gchar *arg_message)
{
  g_signal_emit (object, THUNAR__THUMBNAILER_DBUS_SIGNALS[THUNAR__THUMBNAILER_DBUS_ERROR], 0, arg_handle, arg_failed_uris, arg_error_code, arg_message);
}

/**
 * thunar_thumbnailer_dbus_call_queue:
 * @proxy: A #ThunarThumbnailerDBusProxy.
 * @arg_uris: Argument to pass with the method invocation.
 * @arg_mime_hints: Argument to pass with the method invocation.
 * @arg_flavor: Argument to pass with the method invocation.
 * @arg_scheduler: Argument to pass with the method invocation.
 * @arg_handle_to_unqueue: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-thumbnails-Thumbnailer1.Queue">Queue()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call thunar_thumbnailer_dbus_call_queue_finish() to get the result of the operation.
 *
 * See thunar_thumbnailer_dbus_call_queue_sync() for the synchronous, blocking version of this method.
 */
void
thunar_thumbnailer_dbus_call_queue (
    ThunarThumbnailerDBus *proxy,
    const gchar *const *arg_uris,
    const gchar *const *arg_mime_hints,
    const gchar *arg_flavor,
    const gchar *arg_scheduler,
    guint arg_handle_to_unqueue,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Queue",
    g_variant_new ("(^as^asssu)",
                   arg_uris,
                   arg_mime_hints,
                   arg_flavor,
                   arg_scheduler,
                   arg_handle_to_unqueue),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * thunar_thumbnailer_dbus_call_queue_finish:
 * @proxy: A #ThunarThumbnailerDBusProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to thunar_thumbnailer_dbus_call_queue().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with thunar_thumbnailer_dbus_call_queue().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
thunar_thumbnailer_dbus_call_queue_finish (
    ThunarThumbnailerDBus *proxy,
    guint *out_handle,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * thunar_thumbnailer_dbus_call_queue_sync:
 * @proxy: A #ThunarThumbnailerDBusProxy.
 * @arg_uris: Argument to pass with the method invocation.
 * @arg_mime_hints: Argument to pass with the method invocation.
 * @arg_flavor: Argument to pass with the method invocation.
 * @arg_scheduler: Argument to pass with the method invocation.
 * @arg_handle_to_unqueue: Argument to pass with the method invocation.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-thumbnails-Thumbnailer1.Queue">Queue()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See thunar_thumbnailer_dbus_call_queue() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
thunar_thumbnailer_dbus_call_queue_sync (
    ThunarThumbnailerDBus *proxy,
    const gchar *const *arg_uris,
    const gchar *const *arg_mime_hints,
    const gchar *arg_flavor,
    const gchar *arg_scheduler,
    guint arg_handle_to_unqueue,
    guint *out_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Queue",
    g_variant_new ("(^as^asssu)",
                   arg_uris,
                   arg_mime_hints,
                   arg_flavor,
                   arg_scheduler,
                   arg_handle_to_unqueue),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * thunar_thumbnailer_dbus_call_dequeue:
 * @proxy: A #ThunarThumbnailerDBusProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-thumbnails-Thumbnailer1.Dequeue">Dequeue()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call thunar_thumbnailer_dbus_call_dequeue_finish() to get the result of the operation.
 *
 * See thunar_thumbnailer_dbus_call_dequeue_sync() for the synchronous, blocking version of this method.
 */
void
thunar_thumbnailer_dbus_call_dequeue (
    ThunarThumbnailerDBus *proxy,
    guint arg_handle,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Dequeue",
    g_variant_new ("(u)",
                   arg_handle),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * thunar_thumbnailer_dbus_call_dequeue_finish:
 * @proxy: A #ThunarThumbnailerDBusProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to thunar_thumbnailer_dbus_call_dequeue().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with thunar_thumbnailer_dbus_call_dequeue().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
thunar_thumbnailer_dbus_call_dequeue_finish (
    ThunarThumbnailerDBus *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * thunar_thumbnailer_dbus_call_dequeue_sync:
 * @proxy: A #ThunarThumbnailerDBusProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-thumbnails-Thumbnailer1.Dequeue">Dequeue()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See thunar_thumbnailer_dbus_call_dequeue() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
thunar_thumbnailer_dbus_call_dequeue_sync (
    ThunarThumbnailerDBus *proxy,
    guint arg_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Dequeue",
    g_variant_new ("(u)",
                   arg_handle),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * thunar_thumbnailer_dbus_call_get_supported:
 * @proxy: A #ThunarThumbnailerDBusProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-thumbnails-Thumbnailer1.GetSupported">GetSupported()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call thunar_thumbnailer_dbus_call_get_supported_finish() to get the result of the operation.
 *
 * See thunar_thumbnailer_dbus_call_get_supported_sync() for the synchronous, blocking version of this method.
 */
void
thunar_thumbnailer_dbus_call_get_supported (
    ThunarThumbnailerDBus *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetSupported",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * thunar_thumbnailer_dbus_call_get_supported_finish:
 * @proxy: A #ThunarThumbnailerDBusProxy.
 * @out_uri_schemes: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_mime_types: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to thunar_thumbnailer_dbus_call_get_supported().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with thunar_thumbnailer_dbus_call_get_supported().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
thunar_thumbnailer_dbus_call_get_supported_finish (
    ThunarThumbnailerDBus *proxy,
    gchar ***out_uri_schemes,
    gchar ***out_mime_types,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as^as)",
                 out_uri_schemes,
                 out_mime_types);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * thunar_thumbnailer_dbus_call_get_supported_sync:
 * @proxy: A #ThunarThumbnailerDBusProxy.
 * @out_uri_schemes: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_mime_types: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-thumbnails-Thumbnailer1.GetSupported">GetSupported()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See thunar_thumbnailer_dbus_call_get_supported() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
thunar_thumbnailer_dbus_call_get_supported_sync (
    ThunarThumbnailerDBus *proxy,
    gchar ***out_uri_schemes,
    gchar ***out_mime_types,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetSupported",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as^as)",
                 out_uri_schemes,
                 out_mime_types);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * thunar_thumbnailer_dbus_call_get_schedulers:
 * @proxy: A #ThunarThumbnailerDBusProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-thumbnails-Thumbnailer1.GetSchedulers">GetSchedulers()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call thunar_thumbnailer_dbus_call_get_schedulers_finish() to get the result of the operation.
 *
 * See thunar_thumbnailer_dbus_call_get_schedulers_sync() for the synchronous, blocking version of this method.
 */
void
thunar_thumbnailer_dbus_call_get_schedulers (
    ThunarThumbnailerDBus *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetSchedulers",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * thunar_thumbnailer_dbus_call_get_schedulers_finish:
 * @proxy: A #ThunarThumbnailerDBusProxy.
 * @out_schedulers: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to thunar_thumbnailer_dbus_call_get_schedulers().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with thunar_thumbnailer_dbus_call_get_schedulers().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
thunar_thumbnailer_dbus_call_get_schedulers_finish (
    ThunarThumbnailerDBus *proxy,
    gchar ***out_schedulers,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_schedulers);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * thunar_thumbnailer_dbus_call_get_schedulers_sync:
 * @proxy: A #ThunarThumbnailerDBusProxy.
 * @out_schedulers: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-thumbnails-Thumbnailer1.GetSchedulers">GetSchedulers()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See thunar_thumbnailer_dbus_call_get_schedulers() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
thunar_thumbnailer_dbus_call_get_schedulers_sync (
    ThunarThumbnailerDBus *proxy,
    gchar ***out_schedulers,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetSchedulers",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_schedulers);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * thunar_thumbnailer_dbus_complete_queue:
 * @object: A #ThunarThumbnailerDBus.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-thumbnails-Thumbnailer1.Queue">Queue()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
thunar_thumbnailer_dbus_complete_queue (
    ThunarThumbnailerDBus *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint handle)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   handle));
}

/**
 * thunar_thumbnailer_dbus_complete_dequeue:
 * @object: A #ThunarThumbnailerDBus.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-thumbnails-Thumbnailer1.Dequeue">Dequeue()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
thunar_thumbnailer_dbus_complete_dequeue (
    ThunarThumbnailerDBus *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * thunar_thumbnailer_dbus_complete_get_supported:
 * @object: A #ThunarThumbnailerDBus.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @uri_schemes: Parameter to return.
 * @mime_types: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-thumbnails-Thumbnailer1.GetSupported">GetSupported()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
thunar_thumbnailer_dbus_complete_get_supported (
    ThunarThumbnailerDBus *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *uri_schemes,
    const gchar *const *mime_types)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as^as)",
                   uri_schemes,
                   mime_types));
}

/**
 * thunar_thumbnailer_dbus_complete_get_schedulers:
 * @object: A #ThunarThumbnailerDBus.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @schedulers: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-thumbnails-Thumbnailer1.GetSchedulers">GetSchedulers()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
thunar_thumbnailer_dbus_complete_get_schedulers (
    ThunarThumbnailerDBus *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *schedulers)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   schedulers));
}

/* ------------------------------------------------------------------------ */

/**
 * ThunarThumbnailerDBusProxy:
 *
 * The #ThunarThumbnailerDBusProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ThunarThumbnailerDBusProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ThunarThumbnailerDBusProxy.
 */

struct _ThunarThumbnailerDBusProxyPrivate
{
  GData *qdata;
};

static void thunar_thumbnailer_dbus_proxy_iface_init (ThunarThumbnailerDBusIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ThunarThumbnailerDBusProxy, thunar_thumbnailer_dbus_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (ThunarThumbnailerDBusProxy)
                         G_IMPLEMENT_INTERFACE (THUNAR_TYPE_THUMBNAILER_DBUS, thunar_thumbnailer_dbus_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ThunarThumbnailerDBusProxy, thunar_thumbnailer_dbus_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (THUNAR_TYPE_THUMBNAILER_DBUS, thunar_thumbnailer_dbus_proxy_iface_init))

#endif
static void
thunar_thumbnailer_dbus_proxy_finalize (GObject *object)
{
  ThunarThumbnailerDBusProxy *proxy = THUNAR_THUMBNAILER_DBUS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (thunar_thumbnailer_dbus_proxy_parent_class)->finalize (object);
}

static void
thunar_thumbnailer_dbus_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
thunar_thumbnailer_dbus_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
thunar_thumbnailer_dbus_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_thunar_thumbnailer_dbus_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], THUNAR_TYPE_THUMBNAILER_DBUS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, THUNAR_TYPE_THUMBNAILER_DBUS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
thunar_thumbnailer_dbus_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  ThunarThumbnailerDBusProxy *proxy = THUNAR_THUMBNAILER_DBUS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_thunar_thumbnailer_dbus_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_thunar_thumbnailer_dbus_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
thunar_thumbnailer_dbus_proxy_init (ThunarThumbnailerDBusProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = thunar_thumbnailer_dbus_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, THUNAR_TYPE_THUMBNAILER_DBUS_PROXY, ThunarThumbnailerDBusProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), thunar_thumbnailer_dbus_interface_info ());
}

static void
thunar_thumbnailer_dbus_proxy_class_init (ThunarThumbnailerDBusProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = thunar_thumbnailer_dbus_proxy_finalize;
  gobject_class->get_property = thunar_thumbnailer_dbus_proxy_get_property;
  gobject_class->set_property = thunar_thumbnailer_dbus_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = thunar_thumbnailer_dbus_proxy_g_signal;
  proxy_class->g_properties_changed = thunar_thumbnailer_dbus_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ThunarThumbnailerDBusProxyPrivate));
#endif
}

static void
thunar_thumbnailer_dbus_proxy_iface_init (ThunarThumbnailerDBusIface *iface G_GNUC_UNUSED)
{
}

/**
 * thunar_thumbnailer_dbus_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-thumbnails-Thumbnailer1.top_of_page">org.freedesktop.thumbnails.Thumbnailer1</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call thunar_thumbnailer_dbus_proxy_new_finish() to get the result of the operation.
 *
 * See thunar_thumbnailer_dbus_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
thunar_thumbnailer_dbus_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (THUNAR_TYPE_THUMBNAILER_DBUS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.thumbnails.Thumbnailer1", NULL);
}

/**
 * thunar_thumbnailer_dbus_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to thunar_thumbnailer_dbus_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with thunar_thumbnailer_dbus_proxy_new().
 *
 * Returns: (transfer full) (type ThunarThumbnailerDBusProxy): The constructed proxy object or %NULL if @error is set.
 */
ThunarThumbnailerDBus *
thunar_thumbnailer_dbus_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return THUNAR_THUMBNAILER_DBUS (ret);
  else
    return NULL;
}

/**
 * thunar_thumbnailer_dbus_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-thumbnails-Thumbnailer1.top_of_page">org.freedesktop.thumbnails.Thumbnailer1</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See thunar_thumbnailer_dbus_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ThunarThumbnailerDBusProxy): The constructed proxy object or %NULL if @error is set.
 */
ThunarThumbnailerDBus *
thunar_thumbnailer_dbus_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (THUNAR_TYPE_THUMBNAILER_DBUS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.thumbnails.Thumbnailer1", NULL);
  if (ret != NULL)
    return THUNAR_THUMBNAILER_DBUS (ret);
  else
    return NULL;
}


/**
 * thunar_thumbnailer_dbus_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like thunar_thumbnailer_dbus_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call thunar_thumbnailer_dbus_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See thunar_thumbnailer_dbus_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
thunar_thumbnailer_dbus_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (THUNAR_TYPE_THUMBNAILER_DBUS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.thumbnails.Thumbnailer1", NULL);
}

/**
 * thunar_thumbnailer_dbus_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to thunar_thumbnailer_dbus_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with thunar_thumbnailer_dbus_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type ThunarThumbnailerDBusProxy): The constructed proxy object or %NULL if @error is set.
 */
ThunarThumbnailerDBus *
thunar_thumbnailer_dbus_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return THUNAR_THUMBNAILER_DBUS (ret);
  else
    return NULL;
}

/**
 * thunar_thumbnailer_dbus_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like thunar_thumbnailer_dbus_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See thunar_thumbnailer_dbus_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ThunarThumbnailerDBusProxy): The constructed proxy object or %NULL if @error is set.
 */
ThunarThumbnailerDBus *
thunar_thumbnailer_dbus_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (THUNAR_TYPE_THUMBNAILER_DBUS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.thumbnails.Thumbnailer1", NULL);
  if (ret != NULL)
    return THUNAR_THUMBNAILER_DBUS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * ThunarThumbnailerDBusSkeleton:
 *
 * The #ThunarThumbnailerDBusSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ThunarThumbnailerDBusSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ThunarThumbnailerDBusSkeleton.
 */

struct _ThunarThumbnailerDBusSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_thunar_thumbnailer_dbus_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  ThunarThumbnailerDBusSkeleton *skeleton = THUNAR_THUMBNAILER_DBUS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], THUNAR_TYPE_THUMBNAILER_DBUS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, THUNAR_TYPE_THUMBNAILER_DBUS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_thunar_thumbnailer_dbus_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  ThunarThumbnailerDBusSkeleton *skeleton = THUNAR_THUMBNAILER_DBUS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_thunar_thumbnailer_dbus_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_thunar_thumbnailer_dbus_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  ThunarThumbnailerDBusSkeleton *skeleton = THUNAR_THUMBNAILER_DBUS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_thunar_thumbnailer_dbus_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _thunar_thumbnailer_dbus_skeleton_vtable =
{
  _thunar_thumbnailer_dbus_skeleton_handle_method_call,
  _thunar_thumbnailer_dbus_skeleton_handle_get_property,
  _thunar_thumbnailer_dbus_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
thunar_thumbnailer_dbus_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return thunar_thumbnailer_dbus_interface_info ();
}

static GDBusInterfaceVTable *
thunar_thumbnailer_dbus_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_thunar_thumbnailer_dbus_skeleton_vtable;
}

static GVariant *
thunar_thumbnailer_dbus_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  ThunarThumbnailerDBusSkeleton *skeleton = THUNAR_THUMBNAILER_DBUS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_thunar_thumbnailer_dbus_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _thunar_thumbnailer_dbus_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _thunar_thumbnailer_dbus_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _thunar_thumbnailer_dbus_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.thumbnails.Thumbnailer1", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
thunar_thumbnailer_dbus_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_thunar_thumbnailer_dbus_on_signal_started (
    ThunarThumbnailerDBus *object,
    guint arg_handle)
{
  ThunarThumbnailerDBusSkeleton *skeleton = THUNAR_THUMBNAILER_DBUS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(u)",
                   arg_handle));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.thumbnails.Thumbnailer1", "Started",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_thunar_thumbnailer_dbus_on_signal_finished (
    ThunarThumbnailerDBus *object,
    guint arg_handle)
{
  ThunarThumbnailerDBusSkeleton *skeleton = THUNAR_THUMBNAILER_DBUS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(u)",
                   arg_handle));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.thumbnails.Thumbnailer1", "Finished",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_thunar_thumbnailer_dbus_on_signal_ready (
    ThunarThumbnailerDBus *object,
    guint arg_handle,
    const gchar *const *arg_uris)
{
  ThunarThumbnailerDBusSkeleton *skeleton = THUNAR_THUMBNAILER_DBUS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(u^as)",
                   arg_handle,
                   arg_uris));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.thumbnails.Thumbnailer1", "Ready",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_thunar_thumbnailer_dbus_on_signal_error (
    ThunarThumbnailerDBus *object,
    guint arg_handle,
    const gchar *const *arg_failed_uris,
    gint arg_error_code,
    const gchar *arg_message)
{
  ThunarThumbnailerDBusSkeleton *skeleton = THUNAR_THUMBNAILER_DBUS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(u^asis)",
                   arg_handle,
                   arg_failed_uris,
                   arg_error_code,
                   arg_message));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.thumbnails.Thumbnailer1", "Error",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void thunar_thumbnailer_dbus_skeleton_iface_init (ThunarThumbnailerDBusIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ThunarThumbnailerDBusSkeleton, thunar_thumbnailer_dbus_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (ThunarThumbnailerDBusSkeleton)
                         G_IMPLEMENT_INTERFACE (THUNAR_TYPE_THUMBNAILER_DBUS, thunar_thumbnailer_dbus_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ThunarThumbnailerDBusSkeleton, thunar_thumbnailer_dbus_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (THUNAR_TYPE_THUMBNAILER_DBUS, thunar_thumbnailer_dbus_skeleton_iface_init))

#endif
static void
thunar_thumbnailer_dbus_skeleton_finalize (GObject *object)
{
  ThunarThumbnailerDBusSkeleton *skeleton = THUNAR_THUMBNAILER_DBUS_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (thunar_thumbnailer_dbus_skeleton_parent_class)->finalize (object);
}

static void
thunar_thumbnailer_dbus_skeleton_init (ThunarThumbnailerDBusSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = thunar_thumbnailer_dbus_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, THUNAR_TYPE_THUMBNAILER_DBUS_SKELETON, ThunarThumbnailerDBusSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
thunar_thumbnailer_dbus_skeleton_class_init (ThunarThumbnailerDBusSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = thunar_thumbnailer_dbus_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = thunar_thumbnailer_dbus_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = thunar_thumbnailer_dbus_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = thunar_thumbnailer_dbus_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = thunar_thumbnailer_dbus_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ThunarThumbnailerDBusSkeletonPrivate));
#endif
}

static void
thunar_thumbnailer_dbus_skeleton_iface_init (ThunarThumbnailerDBusIface *iface)
{
  iface->started = _thunar_thumbnailer_dbus_on_signal_started;
  iface->finished = _thunar_thumbnailer_dbus_on_signal_finished;
  iface->ready = _thunar_thumbnailer_dbus_on_signal_ready;
  iface->error = _thunar_thumbnailer_dbus_on_signal_error;
}

/**
 * thunar_thumbnailer_dbus_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-thumbnails-Thumbnailer1.top_of_page">org.freedesktop.thumbnails.Thumbnailer1</link>.
 *
 * Returns: (transfer full) (type ThunarThumbnailerDBusSkeleton): The skeleton object.
 */
ThunarThumbnailerDBus *
thunar_thumbnailer_dbus_skeleton_new (void)
{
  return THUNAR_THUMBNAILER_DBUS (g_object_new (THUNAR_TYPE_THUMBNAILER_DBUS_SKELETON, NULL));
}

