/* RedEyeTool.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from RedEyeTool.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*               2016 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include "io.elementary.photos.h"
#include <string.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <glib/gi18n-lib.h>

#define EDITING_TOOLS_REDEYE_TOOL_REDEYE_TOOL_WINDOW_CONTROL_SPACING 8
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define EDITING_TOOLS_REDEYE_TOOL_TYPE_REDEYE_TOOL_WINDOW (editing_tools_redeye_tool_redeye_tool_window_get_type ())
#define EDITING_TOOLS_REDEYE_TOOL_REDEYE_TOOL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDITING_TOOLS_REDEYE_TOOL_TYPE_REDEYE_TOOL_WINDOW, EditingToolsRedeyeToolRedeyeToolWindow))
#define EDITING_TOOLS_REDEYE_TOOL_REDEYE_TOOL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDITING_TOOLS_REDEYE_TOOL_TYPE_REDEYE_TOOL_WINDOW, EditingToolsRedeyeToolRedeyeToolWindowClass))
#define EDITING_TOOLS_REDEYE_TOOL_IS_REDEYE_TOOL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDITING_TOOLS_REDEYE_TOOL_TYPE_REDEYE_TOOL_WINDOW))
#define EDITING_TOOLS_REDEYE_TOOL_IS_REDEYE_TOOL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDITING_TOOLS_REDEYE_TOOL_TYPE_REDEYE_TOOL_WINDOW))
#define EDITING_TOOLS_REDEYE_TOOL_REDEYE_TOOL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDITING_TOOLS_REDEYE_TOOL_TYPE_REDEYE_TOOL_WINDOW, EditingToolsRedeyeToolRedeyeToolWindowClass))

typedef struct _EditingToolsRedeyeToolRedeyeToolWindow EditingToolsRedeyeToolRedeyeToolWindow;
typedef struct _EditingToolsRedeyeToolRedeyeToolWindowClass EditingToolsRedeyeToolRedeyeToolWindowClass;
enum  {
	EDITING_TOOLS_REDEYE_TOOL_0_PROPERTY,
	EDITING_TOOLS_REDEYE_TOOL_NUM_PROPERTIES
};
static GParamSpec* editing_tools_redeye_tool_properties[EDITING_TOOLS_REDEYE_TOOL_NUM_PROPERTIES];
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _EditingToolsRedeyeToolRedeyeToolWindowPrivate EditingToolsRedeyeToolRedeyeToolWindowPrivate;
#define _command_manager_unref0(var) ((var == NULL) ? NULL : (var = (command_manager_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
enum  {
	EDITING_TOOLS_REDEYE_TOOL_REDEYE_TOOL_WINDOW_0_PROPERTY,
	EDITING_TOOLS_REDEYE_TOOL_REDEYE_TOOL_WINDOW_NUM_PROPERTIES
};
static GParamSpec* editing_tools_redeye_tool_redeye_tool_window_properties[EDITING_TOOLS_REDEYE_TOOL_REDEYE_TOOL_WINDOW_NUM_PROPERTIES];

struct _EditingToolsRedeyeToolPrivate {
	cairo_t* thin_white_ctx;
	cairo_t* wider_gray_ctx;
	EditingToolsRedeyeToolRedeyeToolWindow* redeye_tool_window;
	EditingToolsRedeyeInstance user_interaction_instance;
	gboolean is_reticle_move_in_progress;
	GdkPoint reticle_move_mouse_start_point;
	GdkPoint reticle_move_anchor;
	GdkCursor* cached_arrow_cursor;
	GdkCursor* cached_grab_cursor;
	GdkRectangle old_scaled_position;
	GdkPixbuf* current_pixbuf;
	gint scale_factor;
};

struct _EditingToolsRedeyeToolRedeyeToolWindow {
	EditingToolsEditingToolWindow parent_instance;
	EditingToolsRedeyeToolRedeyeToolWindowPrivate * priv;
	GtkButton* apply_button;
	GtkButton* close_button;
	GtkScale* slider;
};

struct _EditingToolsRedeyeToolRedeyeToolWindowClass {
	EditingToolsEditingToolWindowClass parent_class;
};

struct _EditingToolsRedeyeToolRedeyeToolWindowPrivate {
	GtkLabel* slider_label;
};

static gint EditingToolsRedeyeTool_private_offset;
static gpointer editing_tools_redeye_tool_parent_class = NULL;
static gint EditingToolsRedeyeToolRedeyeToolWindow_private_offset;
static gpointer editing_tools_redeye_tool_redeye_tool_window_parent_class = NULL;

static void editing_tools_redeye_instance_init (EditingToolsRedeyeInstance *self);
static GType editing_tools_redeye_tool_redeye_tool_window_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static EditingToolsRedeyeTool* editing_tools_redeye_tool_new (void);
static EditingToolsRedeyeTool* editing_tools_redeye_tool_construct (GType object_type);
static void editing_tools_redeye_tool_new_interaction_instance (EditingToolsRedeyeTool* self,
                                                         EditingToolsPhotoCanvas* canvas,
                                                         EditingToolsRedeyeInstance* result);
static void editing_tools_redeye_tool_prepare_ctx (EditingToolsRedeyeTool* self,
                                            cairo_t* ctx,
                                            Dimensions* dim);
VALA_EXTERN void set_source_color_from_string (cairo_t* ctx,
                                   const gchar* spec);
static void editing_tools_redeye_tool_draw_redeye_instance (EditingToolsRedeyeTool* self,
                                                     EditingToolsRedeyeInstance* inst);
static gboolean editing_tools_redeye_tool_on_size_slider_adjust (EditingToolsRedeyeTool* self,
                                                          GtkScrollType type);
static void editing_tools_redeye_tool_on_apply (EditingToolsRedeyeTool* self);
VALA_EXTERN void derotate_point_arb (GdkPoint* source_point,
                         gint img_w,
                         gint img_h,
                         gdouble angle,
                         GdkPoint* result);
static void editing_tools_redeye_tool_on_photos_altered (EditingToolsRedeyeTool* self,
                                                  GeeMap* map);
static void editing_tools_redeye_tool_on_close (EditingToolsRedeyeTool* self);
static void editing_tools_redeye_tool_on_canvas_resize (EditingToolsRedeyeTool* self);
static void editing_tools_redeye_tool_real_activate (EditingToolsEditingTool* base,
                                              EditingToolsPhotoCanvas* canvas);
static void editing_tools_redeye_tool_bind_canvas_handlers (EditingToolsRedeyeTool* self,
                                                     EditingToolsPhotoCanvas* canvas);
static EditingToolsRedeyeToolRedeyeToolWindow* editing_tools_redeye_tool_redeye_tool_window_new (GtkWindow* container);
static EditingToolsRedeyeToolRedeyeToolWindow* editing_tools_redeye_tool_redeye_tool_window_construct (GType object_type,
                                                                                                GtkWindow* container);
static void editing_tools_redeye_tool_bind_window_handlers (EditingToolsRedeyeTool* self);
static void _editing_tools_redeye_tool_on_photos_altered_data_collection_items_altered (DataCollection* _sender,
                                                                                 GeeMap* items,
                                                                                 gpointer self);
static void editing_tools_redeye_tool_real_deactivate (EditingToolsEditingTool* base);
static void editing_tools_redeye_tool_unbind_canvas_handlers (EditingToolsRedeyeTool* self,
                                                       EditingToolsPhotoCanvas* canvas);
static void editing_tools_redeye_tool_unbind_window_handlers (EditingToolsRedeyeTool* self);
static void _editing_tools_redeye_tool_prepare_ctx_editing_tools_photo_canvas_new_surface (EditingToolsPhotoCanvas* _sender,
                                                                                    cairo_t* ctx,
                                                                                    Dimensions* dim,
                                                                                    gpointer self);
static void _editing_tools_redeye_tool_on_canvas_resize_editing_tools_photo_canvas_resized_scaled_pixbuf (EditingToolsPhotoCanvas* _sender,
                                                                                                   Dimensions* old_dim,
                                                                                                   GdkPixbuf* scaled,
                                                                                                   GdkRectangle* scaled_position,
                                                                                                   gpointer self);
static void _editing_tools_redeye_tool_on_apply_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void _editing_tools_redeye_tool_on_close_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static gboolean _editing_tools_redeye_tool_on_size_slider_adjust_gtk_range_change_value (GtkRange* _sender,
                                                                                  GtkScrollType scroll,
                                                                                  gdouble new_value,
                                                                                  gpointer self);
static EditingToolsEditingToolWindow* editing_tools_redeye_tool_real_get_tool_window (EditingToolsEditingTool* base);
static void editing_tools_redeye_tool_real_paint (EditingToolsEditingTool* base,
                                           cairo_t* ctx);
static void editing_tools_redeye_tool_real_on_left_click (EditingToolsEditingTool* base,
                                                   gint x,
                                                   gint y);
VALA_EXTERN gboolean coord_in_rectangle (gint x,
                             gint y,
                             GdkRectangle* rect);
static void editing_tools_redeye_tool_real_on_left_released (EditingToolsEditingTool* base,
                                                      gint x,
                                                      gint y);
static void editing_tools_redeye_tool_real_on_motion (EditingToolsEditingTool* base,
                                               gint x,
                                               gint y,
                                               GdkModifierType mask);
static gboolean editing_tools_redeye_tool_real_on_keypress (EditingToolsEditingTool* base,
                                                     GdkEventKey* event);
static GObject * editing_tools_redeye_tool_redeye_tool_window_constructor (GType type,
                                                                    guint n_construct_properties,
                                                                    GObjectConstructParam * construct_properties);
static void editing_tools_redeye_tool_redeye_tool_window_finalize (GObject * obj);
static GType editing_tools_redeye_tool_redeye_tool_window_get_type_once (void);
static void editing_tools_redeye_tool_finalize (GObject * obj);
static GType editing_tools_redeye_tool_get_type_once (void);

static void
editing_tools_redeye_instance_init (EditingToolsRedeyeInstance *self)
{
	GdkPoint default_center = {0};
	GdkPoint _tmp0_;
	memset (self, 0, sizeof (EditingToolsRedeyeInstance));
	memset (&default_center, 0, sizeof (GdkPoint));
	_tmp0_ = default_center;
	(*self).center = _tmp0_;
	(*self).radius = EDITING_TOOLS_REDEYE_INSTANCE_DEFAULT_RADIUS;
}

void
editing_tools_redeye_instance_to_bounds_rect (EditingToolsRedeyeInstance* inst,
                                              GdkRectangle* result)
{
	GdkRectangle _result_ = {0};
	EditingToolsRedeyeInstance _tmp0_;
	GdkPoint _tmp1_;
	EditingToolsRedeyeInstance _tmp2_;
	EditingToolsRedeyeInstance _tmp3_;
	GdkPoint _tmp4_;
	EditingToolsRedeyeInstance _tmp5_;
	EditingToolsRedeyeInstance _tmp6_;
	GdkRectangle _tmp7_;
	g_return_if_fail (inst != NULL);
	memset (&_result_, 0, sizeof (GdkRectangle));
	_tmp0_ = *inst;
	_tmp1_ = _tmp0_.center;
	_tmp2_ = *inst;
	_result_.x = _tmp1_.x - _tmp2_.radius;
	_tmp3_ = *inst;
	_tmp4_ = _tmp3_.center;
	_tmp5_ = *inst;
	_result_.y = _tmp4_.y - _tmp5_.radius;
	_tmp6_ = *inst;
	_result_.width = 2 * _tmp6_.radius;
	_tmp7_ = _result_;
	_result_.height = _tmp7_.width;
	*result = _result_;
	return;
}

void
editing_tools_redeye_instance_from_bounds_rect (GdkRectangle* rect,
                                                EditingToolsRedeyeInstance* result)
{
	EditingToolsRedeyeInstance _result_ = {0};
	GdkRectangle _tmp0_;
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	EditingToolsRedeyeInstance _tmp3_;
	GdkRectangle _tmp4_;
	EditingToolsRedeyeInstance _tmp5_;
	g_return_if_fail (rect != NULL);
	editing_tools_redeye_instance_init (&_result_);
	_tmp0_ = *rect;
	_tmp1_ = *rect;
	_result_.radius = (_tmp0_.width + _tmp1_.height) / 4;
	_tmp2_ = *rect;
	_tmp3_ = _result_;
	_result_.center.x = _tmp2_.x + _tmp3_.radius;
	_tmp4_ = *rect;
	_tmp5_ = _result_;
	_result_.center.y = _tmp4_.y + _tmp5_.radius;
	*result = _result_;
	return;
}

EditingToolsRedeyeInstance*
editing_tools_redeye_instance_dup (const EditingToolsRedeyeInstance* self)
{
	EditingToolsRedeyeInstance* dup;
	dup = g_new0 (EditingToolsRedeyeInstance, 1);
	memcpy (dup, self, sizeof (EditingToolsRedeyeInstance));
	return dup;
}

void
editing_tools_redeye_instance_free (EditingToolsRedeyeInstance* self)
{
	g_free (self);
}

static GType
editing_tools_redeye_instance_get_type_once (void)
{
	GType editing_tools_redeye_instance_type_id;
	editing_tools_redeye_instance_type_id = g_boxed_type_register_static ("EditingToolsRedeyeInstance", (GBoxedCopyFunc) editing_tools_redeye_instance_dup, (GBoxedFreeFunc) editing_tools_redeye_instance_free);
	return editing_tools_redeye_instance_type_id;
}

GType
editing_tools_redeye_instance_get_type (void)
{
	static volatile gsize editing_tools_redeye_instance_type_id__once = 0;
	if (g_once_init_enter (&editing_tools_redeye_instance_type_id__once)) {
		GType editing_tools_redeye_instance_type_id;
		editing_tools_redeye_instance_type_id = editing_tools_redeye_instance_get_type_once ();
		g_once_init_leave (&editing_tools_redeye_instance_type_id__once, editing_tools_redeye_instance_type_id);
	}
	return editing_tools_redeye_instance_type_id__once;
}

static inline gpointer
editing_tools_redeye_tool_get_instance_private (EditingToolsRedeyeTool* self)
{
	return G_STRUCT_MEMBER_P (self, EditingToolsRedeyeTool_private_offset);
}

static EditingToolsRedeyeTool*
editing_tools_redeye_tool_construct (GType object_type)
{
	EditingToolsRedeyeTool * self = NULL;
	self = (EditingToolsRedeyeTool*) g_object_new (object_type, "name", "RedeyeTool", NULL);
	return self;
}

static EditingToolsRedeyeTool*
editing_tools_redeye_tool_new (void)
{
	return editing_tools_redeye_tool_construct (EDITING_TOOLS_TYPE_REDEYE_TOOL);
}

EditingToolsRedeyeTool*
editing_tools_redeye_tool_factory (void)
{
	EditingToolsRedeyeTool* _tmp0_;
	EditingToolsRedeyeTool* result;
	_tmp0_ = editing_tools_redeye_tool_new ();
	result = _tmp0_;
	return result;
}

gboolean
editing_tools_redeye_tool_is_available (Photo* photo,
                                        Scaling* scaling)
{
	Dimensions dim = {0};
	Dimensions _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	Dimensions _tmp3_;
	gboolean result;
	g_return_val_if_fail (photo != NULL, FALSE);
	g_return_val_if_fail (scaling != NULL, FALSE);
	media_source_get_dimensions ((MediaSource*) photo, PHOTO_EXCEPTION_NONE, &_tmp0_);
	scaling_get_scaled_dimensions (scaling, &_tmp0_, &_tmp1_);
	dim = _tmp1_;
	_tmp3_ = dim;
	if (_tmp3_.width >= (EDITING_TOOLS_REDEYE_INSTANCE_MAX_RADIUS * 2)) {
		Dimensions _tmp4_;
		_tmp4_ = dim;
		_tmp2_ = _tmp4_.height >= (EDITING_TOOLS_REDEYE_INSTANCE_MAX_RADIUS * 2);
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	return result;
}

static void
editing_tools_redeye_tool_new_interaction_instance (EditingToolsRedeyeTool* self,
                                                    EditingToolsPhotoCanvas* canvas,
                                                    EditingToolsRedeyeInstance* result)
{
	GdkRectangle photo_bounds = {0};
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _tmp1_;
	GdkPoint photo_center = {0};
	GdkPoint _tmp2_ = {0};
	GdkRectangle _tmp3_;
	GdkRectangle _tmp4_;
	GdkRectangle _tmp5_;
	GdkRectangle _tmp6_;
	EditingToolsRedeyeInstance _result_ = {0};
	GdkPoint _tmp7_;
	GdkPoint _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (canvas != NULL);
	editing_tools_photo_canvas_get_scaled_position (canvas, &_tmp0_);
	_tmp1_ = _tmp0_;
	photo_bounds = _tmp1_;
	_tmp2_.x = 0;
	photo_center = _tmp2_;
	_tmp3_ = photo_bounds;
	_tmp4_ = photo_bounds;
	photo_center.x = _tmp3_.x + (_tmp4_.width / (2 * self->priv->scale_factor));
	_tmp5_ = photo_bounds;
	_tmp6_ = photo_bounds;
	photo_center.y = _tmp5_.y + (_tmp6_.height / (2 * self->priv->scale_factor));
	editing_tools_redeye_instance_init (&_result_);
	_tmp7_ = photo_center;
	_result_.center.x = _tmp7_.x;
	_tmp8_ = photo_center;
	_result_.center.y = _tmp8_.y;
	_result_.radius = EDITING_TOOLS_REDEYE_INSTANCE_DEFAULT_RADIUS;
	*result = _result_;
	return;
}

static void
editing_tools_redeye_tool_prepare_ctx (EditingToolsRedeyeTool* self,
                                       cairo_t* ctx,
                                       Dimensions* dim)
{
	cairo_surface_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_t* _tmp5_;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (dim != NULL);
	_tmp0_ = cairo_get_target (ctx);
	_tmp1_ = cairo_create (_tmp0_);
	_cairo_destroy0 (self->priv->wider_gray_ctx);
	self->priv->wider_gray_ctx = _tmp1_;
	_tmp2_ = self->priv->wider_gray_ctx;
	set_source_color_from_string (_tmp2_, "#111");
	_tmp3_ = self->priv->wider_gray_ctx;
	cairo_set_line_width (_tmp3_, (gdouble) (3 * self->priv->scale_factor));
	_tmp4_ = cairo_get_target (ctx);
	_tmp5_ = cairo_create (_tmp4_);
	_cairo_destroy0 (self->priv->thin_white_ctx);
	self->priv->thin_white_ctx = _tmp5_;
	_tmp6_ = self->priv->thin_white_ctx;
	set_source_color_from_string (_tmp6_, "#FFF");
	_tmp7_ = self->priv->thin_white_ctx;
	cairo_set_line_width (_tmp7_, (gdouble) (1 * self->priv->scale_factor));
}

static void
editing_tools_redeye_tool_draw_redeye_instance (EditingToolsRedeyeTool* self,
                                                EditingToolsRedeyeInstance* inst)
{
	EditingToolsPhotoCanvas* _tmp0_;
	cairo_t* _tmp1_;
	EditingToolsRedeyeInstance _tmp2_;
	GdkPoint _tmp3_;
	EditingToolsRedeyeInstance _tmp4_;
	GdkPoint _tmp5_;
	EditingToolsRedeyeInstance _tmp6_;
	EditingToolsPhotoCanvas* _tmp7_;
	cairo_t* _tmp8_;
	EditingToolsRedeyeInstance _tmp9_;
	GdkPoint _tmp10_;
	EditingToolsRedeyeInstance _tmp11_;
	GdkPoint _tmp12_;
	EditingToolsRedeyeInstance _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (inst != NULL);
	_tmp0_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp1_ = self->priv->wider_gray_ctx;
	_tmp2_ = *inst;
	_tmp3_ = _tmp2_.center;
	_tmp4_ = *inst;
	_tmp5_ = _tmp4_.center;
	_tmp6_ = *inst;
	editing_tools_photo_canvas_draw_circle (_tmp0_, _tmp1_, _tmp3_.x, _tmp5_.y, _tmp6_.radius);
	_tmp7_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp8_ = self->priv->thin_white_ctx;
	_tmp9_ = *inst;
	_tmp10_ = _tmp9_.center;
	_tmp11_ = *inst;
	_tmp12_ = _tmp11_.center;
	_tmp13_ = *inst;
	editing_tools_photo_canvas_draw_circle (_tmp7_, _tmp8_, _tmp10_.x, _tmp12_.y, _tmp13_.radius);
}

static gboolean
editing_tools_redeye_tool_on_size_slider_adjust (EditingToolsRedeyeTool* self,
                                                 GtkScrollType type)
{
	EditingToolsRedeyeToolRedeyeToolWindow* _tmp0_;
	GtkScale* _tmp1_;
	EditingToolsPhotoCanvas* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->redeye_tool_window;
	_tmp1_ = _tmp0_->slider;
	self->priv->user_interaction_instance.radius = (gint) gtk_range_get_value ((GtkRange*) _tmp1_);
	_tmp2_ = ((EditingToolsEditingTool*) self)->canvas;
	editing_tools_photo_canvas_repaint (_tmp2_);
	result = FALSE;
	return result;
}

static void
editing_tools_redeye_tool_on_apply (EditingToolsRedeyeTool* self)
{
	GdkRectangle bounds_rect_user = {0};
	EditingToolsRedeyeInstance _tmp0_;
	GdkRectangle _tmp1_ = {0};
	GdkRectangle bounds_rect_active = {0};
	EditingToolsPhotoCanvas* _tmp2_;
	GdkRectangle _tmp3_;
	GdkRectangle _tmp4_ = {0};
	GdkRectangle bounds_rect_unscaled = {0};
	EditingToolsPhotoCanvas* _tmp5_;
	GdkRectangle _tmp6_;
	GdkRectangle _tmp7_ = {0};
	GdkRectangle bounds_rect_raw = {0};
	EditingToolsPhotoCanvas* _tmp8_;
	GdkRectangle _tmp9_;
	GdkRectangle _tmp10_ = {0};
	EditingToolsRedeyeInstance instance_raw = {0};
	GdkRectangle _tmp11_;
	EditingToolsRedeyeInstance _tmp12_ = {0};
	Dimensions dimensions = {0};
	EditingToolsPhotoCanvas* _tmp13_;
	Photo* _tmp14_;
	Photo* _tmp15_;
	Dimensions _tmp16_ = {0};
	gdouble theta = 0.0;
	EditingToolsPhotoCanvas* _tmp17_;
	Photo* _tmp18_;
	Photo* _tmp19_;
	gdouble _tmp20_ = 0.0;
	EditingToolsRedeyeInstance _tmp21_;
	GdkPoint _tmp22_;
	Dimensions _tmp23_;
	Dimensions _tmp24_;
	GdkPoint _tmp25_ = {0};
	RedeyeCommand* command = NULL;
	EditingToolsPhotoCanvas* _tmp26_;
	Photo* _tmp27_;
	Photo* _tmp28_;
	EditingToolsRedeyeInstance _tmp29_;
	RedeyeCommand* _tmp30_;
	CommandManager* _tmp31_;
	CommandManager* _tmp32_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->user_interaction_instance;
	editing_tools_redeye_instance_to_bounds_rect (&_tmp0_, &_tmp1_);
	bounds_rect_user = _tmp1_;
	_tmp2_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp3_ = bounds_rect_user;
	editing_tools_photo_canvas_user_to_active_rect (_tmp2_, &_tmp3_, &_tmp4_);
	bounds_rect_active = _tmp4_;
	_tmp5_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp6_ = bounds_rect_active;
	editing_tools_photo_canvas_active_to_unscaled_rect (_tmp5_, &_tmp6_, &_tmp7_);
	bounds_rect_unscaled = _tmp7_;
	_tmp8_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp9_ = bounds_rect_unscaled;
	editing_tools_photo_canvas_unscaled_to_raw_rect (_tmp8_, &_tmp9_, &_tmp10_);
	bounds_rect_raw = _tmp10_;
	_tmp11_ = bounds_rect_raw;
	editing_tools_redeye_instance_from_bounds_rect (&_tmp11_, &_tmp12_);
	instance_raw = _tmp12_;
	_tmp13_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp14_ = editing_tools_photo_canvas_get_photo (_tmp13_);
	_tmp15_ = _tmp14_;
	media_source_get_dimensions ((MediaSource*) _tmp15_, PHOTO_EXCEPTION_STRAIGHTEN | PHOTO_EXCEPTION_CROP, &_tmp16_);
	dimensions = _tmp16_;
	theta = 0.0;
	_tmp17_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp18_ = editing_tools_photo_canvas_get_photo (_tmp17_);
	_tmp19_ = _tmp18_;
	photo_get_straighten (_tmp19_, &_tmp20_);
	theta = _tmp20_;
	_tmp21_ = instance_raw;
	_tmp22_ = _tmp21_.center;
	_tmp23_ = dimensions;
	_tmp24_ = dimensions;
	derotate_point_arb (&_tmp22_, _tmp23_.width, _tmp24_.height, theta, &_tmp25_);
	instance_raw.center = _tmp25_;
	_tmp26_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp27_ = editing_tools_photo_canvas_get_photo (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = instance_raw;
	_tmp30_ = redeye_command_new (_tmp28_, &_tmp29_, RESOURCES_RED_EYE_LABEL, RESOURCES_RED_EYE_TOOLTIP);
	command = _tmp30_;
	_tmp31_ = app_window_get_command_manager ();
	_tmp32_ = _tmp31_;
	command_manager_execute (_tmp32_, (Command*) command);
	_command_manager_unref0 (_tmp32_);
	_g_object_unref0 (command);
}

static void
editing_tools_redeye_tool_on_photos_altered (EditingToolsRedeyeTool* self,
                                             GeeMap* map)
{
	EditingToolsPhotoCanvas* _tmp0_;
	Photo* _tmp1_;
	Photo* _tmp2_;
	EditingToolsPhotoCanvas* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (map != NULL);
	_tmp0_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp1_ = editing_tools_photo_canvas_get_photo (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!gee_map_has_key (map, (DataObject*) _tmp2_)) {
		return;
	}
	{
		GdkPixbuf* _tmp3_ = NULL;
		EditingToolsPhotoCanvas* _tmp4_;
		Photo* _tmp5_;
		Photo* _tmp6_;
		EditingToolsPhotoCanvas* _tmp7_;
		Scaling _tmp8_ = {0};
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		_tmp4_ = ((EditingToolsEditingTool*) self)->canvas;
		_tmp5_ = editing_tools_photo_canvas_get_photo (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = ((EditingToolsEditingTool*) self)->canvas;
		editing_tools_photo_canvas_get_scaling (_tmp7_, &_tmp8_);
		_tmp9_ = photo_source_get_pixbuf ((PhotoSource*) _tmp6_, &_tmp8_, &_inner_error0_);
		_tmp3_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (self->priv->current_pixbuf);
		self->priv->current_pixbuf = _tmp10_;
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = err;
		_tmp12_ = _tmp11_->message;
		g_warning ("RedEyeTool.vala:200: %s", _tmp12_);
		g_signal_emit_by_name ((EditingToolsEditingTool*) self, "aborted");
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp13_ = ((EditingToolsEditingTool*) self)->canvas;
	editing_tools_photo_canvas_repaint (_tmp13_);
}

static void
editing_tools_redeye_tool_on_close (EditingToolsRedeyeTool* self)
{
	GdkPixbuf* _tmp0_;
	EditingToolsPhotoCanvas* _tmp1_;
	Photo* _tmp2_;
	Photo* _tmp3_;
	Dimensions _tmp4_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_pixbuf;
	_tmp1_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp2_ = editing_tools_photo_canvas_get_photo (_tmp1_);
	_tmp3_ = _tmp2_;
	media_source_get_dimensions ((MediaSource*) _tmp3_, PHOTO_EXCEPTION_NONE, &_tmp4_);
	g_signal_emit_by_name ((EditingToolsEditingTool*) self, "applied", NULL, _tmp0_, &_tmp4_, FALSE);
}

static void
editing_tools_redeye_tool_on_canvas_resize (EditingToolsRedeyeTool* self)
{
	GdkRectangle scaled_position = {0};
	EditingToolsPhotoCanvas* _tmp0_;
	GdkRectangle _tmp1_ = {0};
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	GdkRectangle _tmp4_;
	gdouble scale_factor = 0.0;
	GdkRectangle _tmp5_;
	GdkRectangle _tmp6_;
	EditingToolsRedeyeInstance _tmp7_;
	GdkPoint _tmp8_;
	EditingToolsRedeyeInstance _tmp9_;
	GdkPoint _tmp10_;
	GdkRectangle _tmp11_;
	GdkRectangle _tmp12_;
	GdkRectangle _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((EditingToolsEditingTool*) self)->canvas;
	editing_tools_photo_canvas_get_scaled_position (_tmp0_, &_tmp1_);
	_tmp2_ = _tmp1_;
	scaled_position = _tmp2_;
	_tmp3_ = self->priv->old_scaled_position;
	self->priv->user_interaction_instance.center.x = self->priv->user_interaction_instance.center.x - _tmp3_.x;
	_tmp4_ = self->priv->old_scaled_position;
	self->priv->user_interaction_instance.center.y = self->priv->user_interaction_instance.center.y - _tmp4_.y;
	_tmp5_ = scaled_position;
	_tmp6_ = self->priv->old_scaled_position;
	scale_factor = ((gdouble) _tmp5_.width) / ((gdouble) _tmp6_.width);
	_tmp7_ = self->priv->user_interaction_instance;
	_tmp8_ = _tmp7_.center;
	self->priv->user_interaction_instance.center.x = (gint) ((((gdouble) _tmp8_.x) * scale_factor) + 0.5);
	_tmp9_ = self->priv->user_interaction_instance;
	_tmp10_ = _tmp9_.center;
	self->priv->user_interaction_instance.center.y = (gint) ((((gdouble) _tmp10_.y) * scale_factor) + 0.5);
	_tmp11_ = scaled_position;
	self->priv->user_interaction_instance.center.x = self->priv->user_interaction_instance.center.x + _tmp11_.x;
	_tmp12_ = scaled_position;
	self->priv->user_interaction_instance.center.y = self->priv->user_interaction_instance.center.y + _tmp12_.y;
	_tmp13_ = scaled_position;
	self->priv->old_scaled_position = _tmp13_;
	_g_object_unref0 (self->priv->current_pixbuf);
	self->priv->current_pixbuf = NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_editing_tools_redeye_tool_on_photos_altered_data_collection_items_altered (DataCollection* _sender,
                                                                            GeeMap* items,
                                                                            gpointer self)
{
	editing_tools_redeye_tool_on_photos_altered ((EditingToolsRedeyeTool*) self, items);
}

static void
editing_tools_redeye_tool_real_activate (EditingToolsEditingTool* base,
                                         EditingToolsPhotoCanvas* canvas)
{
	EditingToolsRedeyeTool * self;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	EditingToolsRedeyeInstance _tmp4_ = {0};
	cairo_t* _tmp5_;
	cairo_t* _tmp6_;
	Dimensions _tmp7_ = {0};
	Dimensions _tmp8_;
	GdkRectangle _tmp9_ = {0};
	GdkRectangle _tmp10_;
	GdkPixbuf* _tmp11_;
	GdkPixbuf* _tmp12_;
	GdkPixbuf* _tmp13_;
	GtkWindow* _tmp14_;
	GtkWindow* _tmp15_;
	EditingToolsRedeyeToolRedeyeToolWindow* _tmp16_;
	EditingToolsRedeyeToolRedeyeToolWindow* _tmp17_;
	GtkScale* _tmp18_;
	EditingToolsRedeyeInstance _tmp19_;
	GdkDisplay* _tmp20_;
	GdkCursor* _tmp21_;
	GdkDisplay* _tmp22_;
	GdkCursor* _tmp23_;
	DataCollection* owner = NULL;
	Photo* _tmp24_;
	Photo* _tmp25_;
	DataCollection* _tmp26_;
	DataCollection* _tmp27_;
	self = (EditingToolsRedeyeTool*) base;
	g_return_if_fail (canvas != NULL);
	_tmp0_ = editing_tools_photo_canvas_get_container (canvas);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_widget_get_scale_factor ((GtkWidget*) _tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->scale_factor = _tmp3_;
	editing_tools_redeye_tool_new_interaction_instance (self, canvas, &_tmp4_);
	self->priv->user_interaction_instance = _tmp4_;
	_tmp5_ = editing_tools_photo_canvas_get_default_ctx (canvas);
	_tmp6_ = _tmp5_;
	editing_tools_photo_canvas_get_surface_dim (canvas, &_tmp7_);
	_tmp8_ = _tmp7_;
	editing_tools_redeye_tool_prepare_ctx (self, _tmp6_, &_tmp8_);
	editing_tools_redeye_tool_bind_canvas_handlers (self, canvas);
	editing_tools_photo_canvas_get_scaled_position (canvas, &_tmp9_);
	_tmp10_ = _tmp9_;
	self->priv->old_scaled_position = _tmp10_;
	_tmp11_ = editing_tools_photo_canvas_get_scaled_pixbuf (canvas);
	_tmp12_ = _tmp11_;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (self->priv->current_pixbuf);
	self->priv->current_pixbuf = _tmp13_;
	_tmp14_ = editing_tools_photo_canvas_get_container (canvas);
	_tmp15_ = _tmp14_;
	_tmp16_ = editing_tools_redeye_tool_redeye_tool_window_new (_tmp15_);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->redeye_tool_window);
	self->priv->redeye_tool_window = _tmp16_;
	_tmp17_ = self->priv->redeye_tool_window;
	_tmp18_ = _tmp17_->slider;
	_tmp19_ = self->priv->user_interaction_instance;
	gtk_range_set_value ((GtkRange*) _tmp18_, (gdouble) _tmp19_.radius);
	editing_tools_redeye_tool_bind_window_handlers (self);
	_tmp20_ = gdk_display_get_default ();
	_tmp21_ = gdk_cursor_new_for_display (_tmp20_, GDK_LEFT_PTR);
	_g_object_unref0 (self->priv->cached_arrow_cursor);
	self->priv->cached_arrow_cursor = _tmp21_;
	_tmp22_ = gdk_display_get_default ();
	_tmp23_ = gdk_cursor_new_for_display (_tmp22_, GDK_FLEUR);
	_g_object_unref0 (self->priv->cached_grab_cursor);
	self->priv->cached_grab_cursor = _tmp23_;
	_tmp24_ = editing_tools_photo_canvas_get_photo (canvas);
	_tmp25_ = _tmp24_;
	_tmp26_ = data_object_get_membership ((DataObject*) _tmp25_);
	owner = _tmp26_;
	_tmp27_ = owner;
	if (_tmp27_ != NULL) {
		DataCollection* _tmp28_;
		_tmp28_ = owner;
		g_signal_connect_object (_tmp28_, "items-altered", (GCallback) _editing_tools_redeye_tool_on_photos_altered_data_collection_items_altered, self, 0);
	}
	EDITING_TOOLS_EDITING_TOOL_CLASS (editing_tools_redeye_tool_parent_class)->activate (G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool), canvas);
	_data_collection_unref0 (owner);
}

static void
editing_tools_redeye_tool_real_deactivate (EditingToolsEditingTool* base)
{
	EditingToolsRedeyeTool * self;
	EditingToolsPhotoCanvas* _tmp0_;
	EditingToolsRedeyeToolRedeyeToolWindow* _tmp9_;
	self = (EditingToolsRedeyeTool*) base;
	_tmp0_ = ((EditingToolsEditingTool*) self)->canvas;
	if (_tmp0_ != NULL) {
		DataCollection* owner = NULL;
		EditingToolsPhotoCanvas* _tmp1_;
		Photo* _tmp2_;
		Photo* _tmp3_;
		DataCollection* _tmp4_;
		DataCollection* _tmp5_;
		EditingToolsPhotoCanvas* _tmp8_;
		_tmp1_ = ((EditingToolsEditingTool*) self)->canvas;
		_tmp2_ = editing_tools_photo_canvas_get_photo (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = data_object_get_membership ((DataObject*) _tmp3_);
		owner = _tmp4_;
		_tmp5_ = owner;
		if (_tmp5_ != NULL) {
			DataCollection* _tmp6_;
			guint _tmp7_;
			_tmp6_ = owner;
			g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp7_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _editing_tools_redeye_tool_on_photos_altered_data_collection_items_altered, self);
		}
		_tmp8_ = ((EditingToolsEditingTool*) self)->canvas;
		editing_tools_redeye_tool_unbind_canvas_handlers (self, _tmp8_);
		_data_collection_unref0 (owner);
	}
	_tmp9_ = self->priv->redeye_tool_window;
	if (_tmp9_ != NULL) {
		EditingToolsRedeyeToolRedeyeToolWindow* _tmp10_;
		EditingToolsRedeyeToolRedeyeToolWindow* _tmp11_;
		editing_tools_redeye_tool_unbind_window_handlers (self);
		_tmp10_ = self->priv->redeye_tool_window;
		gtk_widget_hide ((GtkWidget*) _tmp10_);
		_tmp11_ = self->priv->redeye_tool_window;
		gtk_widget_destroy ((GtkWidget*) _tmp11_);
		_g_object_unref0 (self->priv->redeye_tool_window);
		self->priv->redeye_tool_window = NULL;
	}
	EDITING_TOOLS_EDITING_TOOL_CLASS (editing_tools_redeye_tool_parent_class)->deactivate (G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool));
}

static void
_editing_tools_redeye_tool_prepare_ctx_editing_tools_photo_canvas_new_surface (EditingToolsPhotoCanvas* _sender,
                                                                               cairo_t* ctx,
                                                                               Dimensions* dim,
                                                                               gpointer self)
{
	editing_tools_redeye_tool_prepare_ctx ((EditingToolsRedeyeTool*) self, ctx, dim);
}

static void
_editing_tools_redeye_tool_on_canvas_resize_editing_tools_photo_canvas_resized_scaled_pixbuf (EditingToolsPhotoCanvas* _sender,
                                                                                              Dimensions* old_dim,
                                                                                              GdkPixbuf* scaled,
                                                                                              GdkRectangle* scaled_position,
                                                                                              gpointer self)
{
	editing_tools_redeye_tool_on_canvas_resize ((EditingToolsRedeyeTool*) self);
}

static void
editing_tools_redeye_tool_bind_canvas_handlers (EditingToolsRedeyeTool* self,
                                                EditingToolsPhotoCanvas* canvas)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (canvas != NULL);
	g_signal_connect_object (canvas, "new-surface", (GCallback) _editing_tools_redeye_tool_prepare_ctx_editing_tools_photo_canvas_new_surface, self, 0);
	g_signal_connect_object (canvas, "resized-scaled-pixbuf", (GCallback) _editing_tools_redeye_tool_on_canvas_resize_editing_tools_photo_canvas_resized_scaled_pixbuf, self, 0);
}

static void
editing_tools_redeye_tool_unbind_canvas_handlers (EditingToolsRedeyeTool* self,
                                                  EditingToolsPhotoCanvas* canvas)
{
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (canvas != NULL);
	g_signal_parse_name ("new-surface", EDITING_TOOLS_TYPE_PHOTO_CANVAS, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (canvas, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _editing_tools_redeye_tool_prepare_ctx_editing_tools_photo_canvas_new_surface, self);
	g_signal_parse_name ("resized-scaled-pixbuf", EDITING_TOOLS_TYPE_PHOTO_CANVAS, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (canvas, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _editing_tools_redeye_tool_on_canvas_resize_editing_tools_photo_canvas_resized_scaled_pixbuf, self);
}

static void
_editing_tools_redeye_tool_on_apply_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
	editing_tools_redeye_tool_on_apply ((EditingToolsRedeyeTool*) self);
}

static void
_editing_tools_redeye_tool_on_close_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
	editing_tools_redeye_tool_on_close ((EditingToolsRedeyeTool*) self);
}

static gboolean
_editing_tools_redeye_tool_on_size_slider_adjust_gtk_range_change_value (GtkRange* _sender,
                                                                         GtkScrollType scroll,
                                                                         gdouble new_value,
                                                                         gpointer self)
{
	gboolean result;
	result = editing_tools_redeye_tool_on_size_slider_adjust ((EditingToolsRedeyeTool*) self, scroll);
	return result;
}

static void
editing_tools_redeye_tool_bind_window_handlers (EditingToolsRedeyeTool* self)
{
	EditingToolsRedeyeToolRedeyeToolWindow* _tmp0_;
	GtkButton* _tmp1_;
	EditingToolsRedeyeToolRedeyeToolWindow* _tmp2_;
	GtkButton* _tmp3_;
	EditingToolsRedeyeToolRedeyeToolWindow* _tmp4_;
	GtkScale* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->redeye_tool_window;
	_tmp1_ = _tmp0_->apply_button;
	g_signal_connect_object (_tmp1_, "clicked", (GCallback) _editing_tools_redeye_tool_on_apply_gtk_button_clicked, self, 0);
	_tmp2_ = self->priv->redeye_tool_window;
	_tmp3_ = _tmp2_->close_button;
	g_signal_connect_object (_tmp3_, "clicked", (GCallback) _editing_tools_redeye_tool_on_close_gtk_button_clicked, self, 0);
	_tmp4_ = self->priv->redeye_tool_window;
	_tmp5_ = _tmp4_->slider;
	g_signal_connect_object ((GtkRange*) _tmp5_, "change-value", (GCallback) _editing_tools_redeye_tool_on_size_slider_adjust_gtk_range_change_value, self, 0);
}

static void
editing_tools_redeye_tool_unbind_window_handlers (EditingToolsRedeyeTool* self)
{
	EditingToolsRedeyeToolRedeyeToolWindow* _tmp0_;
	GtkButton* _tmp1_;
	guint _tmp2_;
	EditingToolsRedeyeToolRedeyeToolWindow* _tmp3_;
	GtkButton* _tmp4_;
	guint _tmp5_;
	EditingToolsRedeyeToolRedeyeToolWindow* _tmp6_;
	GtkScale* _tmp7_;
	guint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->redeye_tool_window;
	_tmp1_ = _tmp0_->apply_button;
	g_signal_parse_name ("clicked", gtk_button_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _editing_tools_redeye_tool_on_apply_gtk_button_clicked, self);
	_tmp3_ = self->priv->redeye_tool_window;
	_tmp4_ = _tmp3_->close_button;
	g_signal_parse_name ("clicked", gtk_button_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _editing_tools_redeye_tool_on_close_gtk_button_clicked, self);
	_tmp6_ = self->priv->redeye_tool_window;
	_tmp7_ = _tmp6_->slider;
	g_signal_parse_name ("change-value", gtk_range_get_type (), &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkRange*) _tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _editing_tools_redeye_tool_on_size_slider_adjust_gtk_range_change_value, self);
}

static EditingToolsEditingToolWindow*
editing_tools_redeye_tool_real_get_tool_window (EditingToolsEditingTool* base)
{
	EditingToolsRedeyeTool * self;
	EditingToolsRedeyeToolRedeyeToolWindow* _tmp0_;
	EditingToolsEditingToolWindow* _tmp1_;
	EditingToolsEditingToolWindow* result;
	self = (EditingToolsRedeyeTool*) base;
	_tmp0_ = self->priv->redeye_tool_window;
	_tmp1_ = _g_object_ref0 ((EditingToolsEditingToolWindow*) _tmp0_);
	result = _tmp1_;
	return result;
}

static void
editing_tools_redeye_tool_real_paint (EditingToolsEditingTool* base,
                                      cairo_t* ctx)
{
	EditingToolsRedeyeTool * self;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_;
	EditingToolsPhotoCanvas* _tmp6_;
	EditingToolsRedeyeInstance active_inst = {0};
	EditingToolsRedeyeInstance _tmp7_;
	EditingToolsPhotoCanvas* _tmp8_;
	EditingToolsRedeyeInstance _tmp9_;
	GdkPoint _tmp10_;
	GdkPoint _tmp11_ = {0};
	EditingToolsRedeyeInstance _tmp12_;
	self = (EditingToolsRedeyeTool*) base;
	g_return_if_fail (ctx != NULL);
	_tmp1_ = self->priv->current_pixbuf;
	if (_tmp1_ != NULL) {
		GdkPixbuf* _tmp2_;
		_tmp2_ = self->priv->current_pixbuf;
		_tmp0_ = _tmp2_;
	} else {
		EditingToolsPhotoCanvas* _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		_tmp3_ = ((EditingToolsEditingTool*) self)->canvas;
		_tmp4_ = editing_tools_photo_canvas_get_scaled_pixbuf (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = ((EditingToolsEditingTool*) self)->canvas;
	editing_tools_photo_canvas_paint_pixbuf (_tmp6_, _tmp0_);
	_tmp7_ = self->priv->user_interaction_instance;
	active_inst = _tmp7_;
	_tmp8_ = ((EditingToolsEditingTool*) self)->canvas;
	_tmp9_ = self->priv->user_interaction_instance;
	_tmp10_ = _tmp9_.center;
	editing_tools_photo_canvas_user_to_active_point (_tmp8_, &_tmp10_, &_tmp11_);
	active_inst.center = _tmp11_;
	_tmp12_ = active_inst;
	editing_tools_redeye_tool_draw_redeye_instance (self, &_tmp12_);
}

static void
editing_tools_redeye_tool_real_on_left_click (EditingToolsEditingTool* base,
                                              gint x,
                                              gint y)
{
	EditingToolsRedeyeTool * self;
	GdkRectangle bounds_rect = {0};
	EditingToolsRedeyeInstance _tmp0_;
	GdkRectangle _tmp1_ = {0};
	GdkRectangle _tmp2_;
	self = (EditingToolsRedeyeTool*) base;
	_tmp0_ = self->priv->user_interaction_instance;
	editing_tools_redeye_instance_to_bounds_rect (&_tmp0_, &_tmp1_);
	bounds_rect = _tmp1_;
	_tmp2_ = bounds_rect;
	if (coord_in_rectangle (x, y, &_tmp2_)) {
		EditingToolsRedeyeInstance _tmp3_;
		GdkPoint _tmp4_;
		self->priv->is_reticle_move_in_progress = TRUE;
		self->priv->reticle_move_mouse_start_point.x = x;
		self->priv->reticle_move_mouse_start_point.y = y;
		_tmp3_ = self->priv->user_interaction_instance;
		_tmp4_ = _tmp3_.center;
		self->priv->reticle_move_anchor = _tmp4_;
	}
}

static void
editing_tools_redeye_tool_real_on_left_released (EditingToolsEditingTool* base,
                                                 gint x,
                                                 gint y)
{
	EditingToolsRedeyeTool * self;
	self = (EditingToolsRedeyeTool*) base;
	self->priv->is_reticle_move_in_progress = FALSE;
}

static void
editing_tools_redeye_tool_real_on_motion (EditingToolsEditingTool* base,
                                          gint x,
                                          gint y,
                                          GdkModifierType mask)
{
	EditingToolsRedeyeTool * self;
	self = (EditingToolsRedeyeTool*) base;
	if (self->priv->is_reticle_move_in_progress) {
		GdkRectangle active_region_rect = {0};
		EditingToolsPhotoCanvas* _tmp0_;
		GdkRectangle _tmp1_ = {0};
		GdkRectangle _tmp2_;
		gint x_clamp_low = 0;
		GdkRectangle _tmp3_;
		EditingToolsRedeyeInstance _tmp4_;
		gint y_clamp_low = 0;
		GdkRectangle _tmp5_;
		EditingToolsRedeyeInstance _tmp6_;
		gint x_clamp_high = 0;
		GdkRectangle _tmp7_;
		GdkRectangle _tmp8_;
		EditingToolsRedeyeInstance _tmp9_;
		gint y_clamp_high = 0;
		GdkRectangle _tmp10_;
		GdkRectangle _tmp11_;
		EditingToolsRedeyeInstance _tmp12_;
		gint delta_x = 0;
		GdkPoint _tmp13_;
		gint delta_y = 0;
		GdkPoint _tmp14_;
		GdkPoint _tmp15_;
		GdkPoint _tmp16_;
		GdkPoint _tmp17_;
		GdkPoint _tmp18_;
		EditingToolsPhotoCanvas* _tmp19_;
		_tmp0_ = ((EditingToolsEditingTool*) self)->canvas;
		editing_tools_photo_canvas_get_scaled_position (_tmp0_, &_tmp1_);
		_tmp2_ = _tmp1_;
		active_region_rect = _tmp2_;
		_tmp3_ = active_region_rect;
		_tmp4_ = self->priv->user_interaction_instance;
		x_clamp_low = (_tmp3_.x + _tmp4_.radius) + 1;
		_tmp5_ = active_region_rect;
		_tmp6_ = self->priv->user_interaction_instance;
		y_clamp_low = (_tmp5_.y + _tmp6_.radius) + 1;
		_tmp7_ = active_region_rect;
		_tmp8_ = active_region_rect;
		_tmp9_ = self->priv->user_interaction_instance;
		x_clamp_high = ((_tmp7_.x + _tmp8_.width) - _tmp9_.radius) - 1;
		_tmp10_ = active_region_rect;
		_tmp11_ = active_region_rect;
		_tmp12_ = self->priv->user_interaction_instance;
		y_clamp_high = ((_tmp10_.y + _tmp11_.height) - _tmp12_.radius) - 1;
		_tmp13_ = self->priv->reticle_move_mouse_start_point;
		delta_x = x - _tmp13_.x;
		_tmp14_ = self->priv->reticle_move_mouse_start_point;
		delta_y = y - _tmp14_.y;
		_tmp15_ = self->priv->reticle_move_anchor;
		self->priv->user_interaction_instance.center.x = _tmp15_.x + delta_x;
		_tmp16_ = self->priv->reticle_move_anchor;
		self->priv->user_interaction_instance.center.y = _tmp16_.y + delta_y;
		_tmp17_ = self->priv->reticle_move_anchor;
		self->priv->user_interaction_instance.center.x = CLAMP (_tmp17_.x + delta_x, x_clamp_low, x_clamp_high);
		_tmp18_ = self->priv->reticle_move_anchor;
		self->priv->user_interaction_instance.center.y = CLAMP (_tmp18_.y + delta_y, y_clamp_low, y_clamp_high);
		_tmp19_ = ((EditingToolsEditingTool*) self)->canvas;
		editing_tools_photo_canvas_repaint (_tmp19_);
	} else {
		GdkRectangle bounds = {0};
		EditingToolsRedeyeInstance _tmp20_;
		GdkRectangle _tmp21_ = {0};
		GdkRectangle _tmp22_;
		_tmp20_ = self->priv->user_interaction_instance;
		editing_tools_redeye_instance_to_bounds_rect (&_tmp20_, &_tmp21_);
		bounds = _tmp21_;
		_tmp22_ = bounds;
		if (coord_in_rectangle (x, y, &_tmp22_)) {
			EditingToolsPhotoCanvas* _tmp23_;
			GdkWindow* _tmp24_;
			GdkWindow* _tmp25_;
			GdkCursor* _tmp26_;
			_tmp23_ = ((EditingToolsEditingTool*) self)->canvas;
			_tmp24_ = editing_tools_photo_canvas_get_drawing_window (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = self->priv->cached_grab_cursor;
			gdk_window_set_cursor (_tmp25_, _tmp26_);
		} else {
			EditingToolsPhotoCanvas* _tmp27_;
			GdkWindow* _tmp28_;
			GdkWindow* _tmp29_;
			GdkCursor* _tmp30_;
			_tmp27_ = ((EditingToolsEditingTool*) self)->canvas;
			_tmp28_ = editing_tools_photo_canvas_get_drawing_window (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = self->priv->cached_arrow_cursor;
			gdk_window_set_cursor (_tmp29_, _tmp30_);
		}
	}
}

static gboolean
editing_tools_redeye_tool_real_on_keypress (EditingToolsEditingTool* base,
                                            GdkEventKey* event)
{
	EditingToolsRedeyeTool * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean result;
	self = (EditingToolsRedeyeTool*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = gdk_keyval_name (event->keyval);
	if (g_strcmp0 (_tmp2_, "KP_Enter") == 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = gdk_keyval_name (event->keyval);
		_tmp1_ = g_strcmp0 (_tmp3_, "Enter") == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = gdk_keyval_name (event->keyval);
		_tmp0_ = g_strcmp0 (_tmp4_, "Return") == 0;
	}
	if (_tmp0_) {
		editing_tools_redeye_tool_on_close (self);
		result = TRUE;
		return result;
	}
	result = EDITING_TOOLS_EDITING_TOOL_CLASS (editing_tools_redeye_tool_parent_class)->on_keypress (G_TYPE_CHECK_INSTANCE_CAST (self, EDITING_TOOLS_TYPE_EDITING_TOOL, EditingToolsEditingTool), event);
	return result;
}

static inline gpointer
editing_tools_redeye_tool_redeye_tool_window_get_instance_private (EditingToolsRedeyeToolRedeyeToolWindow* self)
{
	return G_STRUCT_MEMBER_P (self, EditingToolsRedeyeToolRedeyeToolWindow_private_offset);
}

static EditingToolsRedeyeToolRedeyeToolWindow*
editing_tools_redeye_tool_redeye_tool_window_construct (GType object_type,
                                                        GtkWindow* container)
{
	EditingToolsRedeyeToolRedeyeToolWindow * self = NULL;
	g_return_val_if_fail (container != NULL, NULL);
	self = (EditingToolsRedeyeToolRedeyeToolWindow*) g_object_new (object_type, "transient-for", container, NULL);
	return self;
}

static EditingToolsRedeyeToolRedeyeToolWindow*
editing_tools_redeye_tool_redeye_tool_window_new (GtkWindow* container)
{
	return editing_tools_redeye_tool_redeye_tool_window_construct (EDITING_TOOLS_REDEYE_TOOL_TYPE_REDEYE_TOOL_WINDOW, container);
}

static GObject *
editing_tools_redeye_tool_redeye_tool_window_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	EditingToolsRedeyeToolRedeyeToolWindow * self;
	GtkScale* _tmp0_;
	GtkScale* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkBox* layout = NULL;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkLabel* _tmp6_;
	GtkBox* _tmp7_;
	GtkScale* _tmp8_;
	GtkBox* _tmp9_;
	GtkButton* _tmp10_;
	GtkBox* _tmp11_;
	GtkButton* _tmp12_;
	GtkGrid* _tmp13_;
	GtkGrid* _tmp14_;
	GtkBox* _tmp15_;
	parent_class = G_OBJECT_CLASS (editing_tools_redeye_tool_redeye_tool_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDITING_TOOLS_REDEYE_TOOL_TYPE_REDEYE_TOOL_WINDOW, EditingToolsRedeyeToolRedeyeToolWindow);
	_tmp0_ = self->slider;
	gtk_widget_set_size_request ((GtkWidget*) _tmp0_, 80, -1);
	_tmp1_ = self->slider;
	gtk_scale_set_draw_value (_tmp1_, FALSE);
	_tmp2_ = self->close_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _ ("Close the red-eye tool"));
	_tmp3_ = self->apply_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp3_, _ ("Remove any red-eye effects in the selected region"));
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, EDITING_TOOLS_REDEYE_TOOL_REDEYE_TOOL_WINDOW_CONTROL_SPACING);
	g_object_ref_sink (_tmp4_);
	layout = _tmp4_;
	_tmp5_ = layout;
	_tmp6_ = self->priv->slider_label;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = layout;
	_tmp8_ = self->slider;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = layout;
	_tmp10_ = self->close_button;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = layout;
	_tmp12_ = self->apply_button;
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = editing_tools_editing_tool_window_get_content_area ((EditingToolsEditingToolWindow*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = layout;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_g_object_unref0 (layout);
	return obj;
}

static void
editing_tools_redeye_tool_redeye_tool_window_class_init (EditingToolsRedeyeToolRedeyeToolWindowClass * klass,
                                                         gpointer klass_data)
{
	editing_tools_redeye_tool_redeye_tool_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EditingToolsRedeyeToolRedeyeToolWindow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = editing_tools_redeye_tool_redeye_tool_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = editing_tools_redeye_tool_redeye_tool_window_finalize;
}

static void
editing_tools_redeye_tool_redeye_tool_window_instance_init (EditingToolsRedeyeToolRedeyeToolWindow * self,
                                                            gpointer klass)
{
	GtkLabel* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkScale* _tmp3_;
	self->priv = editing_tools_redeye_tool_redeye_tool_window_get_instance_private (self);
	_tmp0_ = (GtkLabel*) gtk_label_new_with_mnemonic (_ ("Size:"));
	g_object_ref_sink (_tmp0_);
	self->priv->slider_label = _tmp0_;
	_tmp1_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Apply"));
	g_object_ref_sink (_tmp1_);
	self->apply_button = _tmp1_;
	_tmp2_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Close"));
	g_object_ref_sink (_tmp2_);
	self->close_button = _tmp2_;
	_tmp3_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) EDITING_TOOLS_REDEYE_INSTANCE_MIN_RADIUS, (gdouble) EDITING_TOOLS_REDEYE_INSTANCE_MAX_RADIUS, 1.0);
	g_object_ref_sink (_tmp3_);
	self->slider = _tmp3_;
}

static void
editing_tools_redeye_tool_redeye_tool_window_finalize (GObject * obj)
{
	EditingToolsRedeyeToolRedeyeToolWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDITING_TOOLS_REDEYE_TOOL_TYPE_REDEYE_TOOL_WINDOW, EditingToolsRedeyeToolRedeyeToolWindow);
	_g_object_unref0 (self->priv->slider_label);
	_g_object_unref0 (self->apply_button);
	_g_object_unref0 (self->close_button);
	_g_object_unref0 (self->slider);
	G_OBJECT_CLASS (editing_tools_redeye_tool_redeye_tool_window_parent_class)->finalize (obj);
}

static GType
editing_tools_redeye_tool_redeye_tool_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EditingToolsRedeyeToolRedeyeToolWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) editing_tools_redeye_tool_redeye_tool_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditingToolsRedeyeToolRedeyeToolWindow), 0, (GInstanceInitFunc) editing_tools_redeye_tool_redeye_tool_window_instance_init, NULL };
	GType editing_tools_redeye_tool_redeye_tool_window_type_id;
	editing_tools_redeye_tool_redeye_tool_window_type_id = g_type_register_static (EDITING_TOOLS_TYPE_EDITING_TOOL_WINDOW, "EditingToolsRedeyeToolRedeyeToolWindow", &g_define_type_info, 0);
	EditingToolsRedeyeToolRedeyeToolWindow_private_offset = g_type_add_instance_private (editing_tools_redeye_tool_redeye_tool_window_type_id, sizeof (EditingToolsRedeyeToolRedeyeToolWindowPrivate));
	return editing_tools_redeye_tool_redeye_tool_window_type_id;
}

static GType
editing_tools_redeye_tool_redeye_tool_window_get_type (void)
{
	static volatile gsize editing_tools_redeye_tool_redeye_tool_window_type_id__once = 0;
	if (g_once_init_enter (&editing_tools_redeye_tool_redeye_tool_window_type_id__once)) {
		GType editing_tools_redeye_tool_redeye_tool_window_type_id;
		editing_tools_redeye_tool_redeye_tool_window_type_id = editing_tools_redeye_tool_redeye_tool_window_get_type_once ();
		g_once_init_leave (&editing_tools_redeye_tool_redeye_tool_window_type_id__once, editing_tools_redeye_tool_redeye_tool_window_type_id);
	}
	return editing_tools_redeye_tool_redeye_tool_window_type_id__once;
}

static void
editing_tools_redeye_tool_class_init (EditingToolsRedeyeToolClass * klass,
                                      gpointer klass_data)
{
	editing_tools_redeye_tool_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EditingToolsRedeyeTool_private_offset);
	((EditingToolsEditingToolClass *) klass)->activate = (void (*) (EditingToolsEditingTool*, EditingToolsPhotoCanvas*)) editing_tools_redeye_tool_real_activate;
	((EditingToolsEditingToolClass *) klass)->deactivate = (void (*) (EditingToolsEditingTool*)) editing_tools_redeye_tool_real_deactivate;
	((EditingToolsEditingToolClass *) klass)->get_tool_window = (EditingToolsEditingToolWindow* (*) (EditingToolsEditingTool*)) editing_tools_redeye_tool_real_get_tool_window;
	((EditingToolsEditingToolClass *) klass)->paint = (void (*) (EditingToolsEditingTool*, cairo_t*)) editing_tools_redeye_tool_real_paint;
	((EditingToolsEditingToolClass *) klass)->on_left_click = (void (*) (EditingToolsEditingTool*, gint, gint)) editing_tools_redeye_tool_real_on_left_click;
	((EditingToolsEditingToolClass *) klass)->on_left_released = (void (*) (EditingToolsEditingTool*, gint, gint)) editing_tools_redeye_tool_real_on_left_released;
	((EditingToolsEditingToolClass *) klass)->on_motion = (void (*) (EditingToolsEditingTool*, gint, gint, GdkModifierType)) editing_tools_redeye_tool_real_on_motion;
	((EditingToolsEditingToolClass *) klass)->on_keypress = (gboolean (*) (EditingToolsEditingTool*, GdkEventKey*)) editing_tools_redeye_tool_real_on_keypress;
	G_OBJECT_CLASS (klass)->finalize = editing_tools_redeye_tool_finalize;
}

static void
editing_tools_redeye_tool_instance_init (EditingToolsRedeyeTool * self,
                                         gpointer klass)
{
	self->priv = editing_tools_redeye_tool_get_instance_private (self);
	self->priv->thin_white_ctx = NULL;
	self->priv->wider_gray_ctx = NULL;
	self->priv->redeye_tool_window = NULL;
	self->priv->is_reticle_move_in_progress = FALSE;
	self->priv->current_pixbuf = NULL;
	self->priv->scale_factor = 1;
}

static void
editing_tools_redeye_tool_finalize (GObject * obj)
{
	EditingToolsRedeyeTool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDITING_TOOLS_TYPE_REDEYE_TOOL, EditingToolsRedeyeTool);
	_cairo_destroy0 (self->priv->thin_white_ctx);
	_cairo_destroy0 (self->priv->wider_gray_ctx);
	_g_object_unref0 (self->priv->redeye_tool_window);
	_g_object_unref0 (self->priv->cached_arrow_cursor);
	_g_object_unref0 (self->priv->cached_grab_cursor);
	_g_object_unref0 (self->priv->current_pixbuf);
	G_OBJECT_CLASS (editing_tools_redeye_tool_parent_class)->finalize (obj);
}

static GType
editing_tools_redeye_tool_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EditingToolsRedeyeToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) editing_tools_redeye_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditingToolsRedeyeTool), 0, (GInstanceInitFunc) editing_tools_redeye_tool_instance_init, NULL };
	GType editing_tools_redeye_tool_type_id;
	editing_tools_redeye_tool_type_id = g_type_register_static (EDITING_TOOLS_TYPE_EDITING_TOOL, "EditingToolsRedeyeTool", &g_define_type_info, 0);
	EditingToolsRedeyeTool_private_offset = g_type_add_instance_private (editing_tools_redeye_tool_type_id, sizeof (EditingToolsRedeyeToolPrivate));
	return editing_tools_redeye_tool_type_id;
}

GType
editing_tools_redeye_tool_get_type (void)
{
	static volatile gsize editing_tools_redeye_tool_type_id__once = 0;
	if (g_once_init_enter (&editing_tools_redeye_tool_type_id__once)) {
		GType editing_tools_redeye_tool_type_id;
		editing_tools_redeye_tool_type_id = editing_tools_redeye_tool_get_type_once ();
		g_once_init_leave (&editing_tools_redeye_tool_type_id__once, editing_tools_redeye_tool_type_id);
	}
	return editing_tools_redeye_tool_type_id__once;
}

