/* SourceDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SourceDialog.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2011-2020 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Jaap Broekhuizen
 *              Corentin Noël <corentin@elementaryos.org>
 */

#include <granite.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "elementary-calendar.h"
#include <gee.h>
#include <libedataserver/libedataserver.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_VIEW_TYPE_SOURCE_DIALOG (maya_view_source_dialog_get_type ())
#define MAYA_VIEW_SOURCE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_SOURCE_DIALOG, MayaViewSourceDialog))
#define MAYA_VIEW_SOURCE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_SOURCE_DIALOG, MayaViewSourceDialogClass))
#define MAYA_VIEW_IS_SOURCE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_SOURCE_DIALOG))
#define MAYA_VIEW_IS_SOURCE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_SOURCE_DIALOG))
#define MAYA_VIEW_SOURCE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_SOURCE_DIALOG, MayaViewSourceDialogClass))

typedef struct _MayaViewSourceDialog MayaViewSourceDialog;
typedef struct _MayaViewSourceDialogClass MayaViewSourceDialogClass;
typedef struct _MayaViewSourceDialogPrivate MayaViewSourceDialogPrivate;
typedef enum  {
	MAYA_VIEW_EVENT_TYPE_ADD,
	MAYA_VIEW_EVENT_TYPE_EDIT
} MayaViewEventType;

#define MAYA_VIEW_TYPE_EVENT_TYPE (maya_view_event_type_get_type ())
enum  {
	MAYA_VIEW_SOURCE_DIALOG_0_PROPERTY,
	MAYA_VIEW_SOURCE_DIALOG_EVENT_TYPE_PROPERTY,
	MAYA_VIEW_SOURCE_DIALOG_NUM_PROPERTIES
};
static GParamSpec* maya_view_source_dialog_properties[MAYA_VIEW_SOURCE_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block27Data Block27Data;
enum  {
	MAYA_VIEW_SOURCE_DIALOG_GO_BACK_SIGNAL,
	MAYA_VIEW_SOURCE_DIALOG_NUM_SIGNALS
};
static guint maya_view_source_dialog_signals[MAYA_VIEW_SOURCE_DIALOG_NUM_SIGNALS] = {0};

struct _MayaViewSourceDialog {
	GraniteDialog parent_instance;
	MayaViewSourceDialogPrivate * priv;
};

struct _MayaViewSourceDialogClass {
	GraniteDialogClass parent_class;
};

struct _MayaViewSourceDialogPrivate {
	MayaViewEventType _event_type;
	GtkEntry* name_entry;
	gchar* hex_color;
	MayaBackend* current_backend;
	GeeCollection* backend_widgets;
	GtkGrid* main_grid;
	GeeHashMap* widgets_checked;
	GtkButton* create_button;
	GtkComboBox* type_combobox;
	GtkListStore* list_store;
	GtkCheckButton* is_default_check;
	ESource* source;
	GtkRadioButton* color_button_blue;
	GtkRadioButton* color_button_mint;
	GtkRadioButton* color_button_green;
	GtkRadioButton* color_button_yellow;
	GtkRadioButton* color_button_orange;
	GtkRadioButton* color_button_red;
	GtkRadioButton* color_button_pink;
	GtkRadioButton* color_button_purple;
	GtkRadioButton* color_button_brown;
	GtkRadioButton* color_button_slate;
	GtkRadioButton* color_button_none;
};

struct _Block27Data {
	int _ref_count_;
	MayaViewSourceDialog* self;
	MayaPlacementWidget* widget;
};

static gint MayaViewSourceDialog_private_offset;
static gpointer maya_view_source_dialog_parent_class = NULL;

VALA_EXTERN GType maya_view_source_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewSourceDialog, g_object_unref)
VALA_EXTERN GType maya_view_event_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void maya_view_source_dialog_set_source (MayaViewSourceDialog* self,
                                         ESource* source);
static void maya_view_source_dialog_set_event_type (MayaViewSourceDialog* self,
                                             MayaViewEventType value);
static gboolean maya_view_source_dialog_tree_foreach (MayaViewSourceDialog* self,
                                               GtkTreeModel* model,
                                               GtkTreePath* path,
                                               GtkTreeIter* iter);
static gboolean _maya_view_source_dialog_tree_foreach_gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                                            GtkTreePath* path,
                                                                            GtkTreeIter* iter,
                                                                            gpointer self);
static void maya_view_source_dialog_remove_backend_widgets (MayaViewSourceDialog* self);
static void maya_view_source_dialog_add_backend_widgets (MayaViewSourceDialog* self);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
static void _____lambda151_ (Block27Data* _data27_);
static void maya_view_source_dialog_entry_changed (MayaViewSourceDialog* self,
                                            MayaPlacementWidget* widget);
static void ______lambda151__gtk_editable_changed (GtkEditable* _sender,
                                            gpointer self);
static void maya_view_source_dialog_check_can_validate (MayaViewSourceDialog* self);
VALA_EXTERN void maya_view_source_dialog_save (MayaViewSourceDialog* self);
VALA_EXTERN MayaViewEventType maya_view_source_dialog_get_event_type (MayaViewSourceDialog* self);
VALA_EXTERN MayaViewSourceDialog* maya_view_source_dialog_new (void);
VALA_EXTERN MayaViewSourceDialog* maya_view_source_dialog_construct (GType object_type);
static GObject * maya_view_source_dialog_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _maya_view_source_dialog_save_gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self);
static void _maya_view_source_dialog___lambda152_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda152__gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static void _maya_view_source_dialog_check_can_validate_gtk_editable_changed (GtkEditable* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda153_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda153__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                   gpointer self);
static void _maya_view_source_dialog___lambda154_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda154__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda155_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda155__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda156_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda156__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda157_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda157__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda158_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda158__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda159_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda159__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda160_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda160__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda161_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda161__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda162_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda162__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda163_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda163__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void maya_view_source_dialog_finalize (GObject * obj);
static GType maya_view_source_dialog_get_type_once (void);
static void _vala_maya_view_source_dialog_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_maya_view_source_dialog_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
maya_view_source_dialog_get_instance_private (MayaViewSourceDialog* self)
{
	return G_STRUCT_MEMBER_P (self, MayaViewSourceDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_maya_view_source_dialog_tree_foreach_gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                                   GtkTreePath* path,
                                                                   GtkTreeIter* iter,
                                                                   gpointer self)
{
	gboolean result;
	result = maya_view_source_dialog_tree_foreach ((MayaViewSourceDialog*) self, model, path, iter);
	return result;
}

void
maya_view_source_dialog_set_source (MayaViewSourceDialog* self,
                                    ESource* source)
{
	ESource* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (self->priv->source);
	self->priv->source = _tmp0_;
	if (source == NULL) {
		GtkEntry* _tmp1_;
		GtkComboBox* _tmp2_;
		GtkRadioButton* _tmp3_;
		GtkButton* _tmp4_;
		GtkCheckButton* _tmp5_;
		GtkCheckButton* _tmp6_;
		maya_view_source_dialog_set_event_type (self, MAYA_VIEW_EVENT_TYPE_ADD);
		_tmp1_ = self->priv->name_entry;
		gtk_entry_set_text (_tmp1_, "");
		_tmp2_ = self->priv->type_combobox;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
		_tmp3_ = self->priv->color_button_red;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp3_, TRUE);
		_tmp4_ = self->priv->create_button;
		gtk_button_set_label (_tmp4_, _ ("Create Calendar"));
		_tmp5_ = self->priv->is_default_check;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, TRUE);
		_tmp6_ = self->priv->is_default_check;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp6_, FALSE);
	} else {
		GtkButton* _tmp7_;
		GtkEntry* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GtkComboBox* _tmp11_;
		GtkComboBox* _tmp12_;
		GtkListStore* _tmp13_;
		ESourceCalendar* cal = NULL;
		ESourceExtension* _tmp28_;
		ESourceCalendar* _tmp29_;
		ESourceCalendar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		GQuark _tmp34_ = 0U;
		static GQuark _tmp33_label0 = 0;
		static GQuark _tmp33_label1 = 0;
		static GQuark _tmp33_label2 = 0;
		static GQuark _tmp33_label3 = 0;
		static GQuark _tmp33_label4 = 0;
		static GQuark _tmp33_label5 = 0;
		static GQuark _tmp33_label6 = 0;
		static GQuark _tmp33_label7 = 0;
		static GQuark _tmp33_label8 = 0;
		static GQuark _tmp33_label9 = 0;
		maya_view_source_dialog_set_event_type (self, MAYA_VIEW_EVENT_TYPE_EDIT);
		_tmp7_ = self->priv->create_button;
		gtk_button_set_label (_tmp7_, _ ("Save"));
		_tmp8_ = self->priv->name_entry;
		_tmp9_ = e_source_get_display_name (source);
		_tmp10_ = _tmp9_;
		gtk_entry_set_text (_tmp8_, _tmp10_);
		_tmp11_ = self->priv->type_combobox;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, FALSE);
		_tmp12_ = self->priv->type_combobox;
		gtk_combo_box_set_active (_tmp12_, 0);
		_tmp13_ = self->priv->list_store;
		gtk_tree_model_foreach ((GtkTreeModel*) _tmp13_, _maya_view_source_dialog_tree_foreach_gtk_tree_model_foreach_func, self);
		{
			ESourceRegistry* registry = NULL;
			ESourceRegistry* _tmp14_;
			gboolean source_is_default = FALSE;
			ESourceRegistry* _tmp15_;
			ESource* _tmp16_;
			ESource* _tmp17_;
			ESource* _tmp18_;
			gboolean _tmp19_;
			gboolean source_is_readonly = FALSE;
			CalendarEventStore* _tmp20_;
			CalendarEventStore* _tmp21_;
			gboolean _tmp22_;
			gboolean _tmp23_ = FALSE;
			GtkCheckButton* _tmp24_;
			GtkCheckButton* _tmp25_;
			_tmp14_ = e_source_registry_new_sync (NULL, &_inner_error0_);
			registry = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp15_ = registry;
			g_object_get (_tmp15_, "default-calendar", &_tmp16_, NULL);
			_tmp17_ = _tmp16_;
			_tmp18_ = _tmp17_;
			_tmp19_ = e_source_equal (source, _tmp18_);
			_g_object_unref0 (_tmp18_);
			source_is_default = _tmp19_;
			_tmp20_ = calendar_event_store_get_default ();
			_tmp21_ = _tmp20_;
			_tmp22_ = calendar_event_store_calclient_is_readonly (_tmp21_, source);
			_g_object_unref0 (_tmp21_);
			source_is_readonly = _tmp22_;
			if (source_is_default) {
				_tmp23_ = TRUE;
			} else {
				_tmp23_ = source_is_readonly;
			}
			_tmp24_ = self->priv->is_default_check;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp24_, !_tmp23_);
			_tmp25_ = self->priv->is_default_check;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp25_, source_is_default);
			_g_object_unref0 (registry);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp26_;
			const gchar* _tmp27_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp26_ = _error_;
			_tmp27_ = _tmp26_->message;
			g_critical ("SourceDialog.vala:289: %s", _tmp27_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp28_ = e_source_get_extension (source, E_SOURCE_EXTENSION_CALENDAR);
		_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, e_source_calendar_get_type (), ESourceCalendar));
		cal = _tmp29_;
		_tmp30_ = cal;
		_tmp31_ = e_source_selectable_dup_color ((ESourceSelectable*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp34_ = (NULL == _tmp32_) ? 0 : g_quark_from_string (_tmp32_);
		g_free (_tmp32_);
		if (_tmp34_ == ((0 != _tmp33_label0) ? _tmp33_label0 : (_tmp33_label0 = g_quark_from_static_string ("#da3d41")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp35_;
					_tmp35_ = self->priv->color_button_red;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp35_, TRUE);
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label1) ? _tmp33_label1 : (_tmp33_label1 = g_quark_from_static_string ("#f37329")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp36_;
					_tmp36_ = self->priv->color_button_orange;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp36_, TRUE);
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label2) ? _tmp33_label2 : (_tmp33_label2 = g_quark_from_static_string ("#e6a92a")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp37_;
					_tmp37_ = self->priv->color_button_yellow;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp37_, TRUE);
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label3) ? _tmp33_label3 : (_tmp33_label3 = g_quark_from_static_string ("#81c837")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp38_;
					_tmp38_ = self->priv->color_button_green;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp38_, TRUE);
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label4) ? _tmp33_label4 : (_tmp33_label4 = g_quark_from_static_string ("#0e9a83")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp39_;
					_tmp39_ = self->priv->color_button_mint;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp39_, TRUE);
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label5) ? _tmp33_label5 : (_tmp33_label5 = g_quark_from_static_string ("#3689e6")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp40_;
					_tmp40_ = self->priv->color_button_blue;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp40_, TRUE);
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label6) ? _tmp33_label6 : (_tmp33_label6 = g_quark_from_static_string ("#a56de2")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp41_;
					_tmp41_ = self->priv->color_button_purple;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp41_, TRUE);
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label7) ? _tmp33_label7 : (_tmp33_label7 = g_quark_from_static_string ("#de3e80")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp42_;
					_tmp42_ = self->priv->color_button_pink;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp42_, TRUE);
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label8) ? _tmp33_label8 : (_tmp33_label8 = g_quark_from_static_string ("#8a715e")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp43_;
					_tmp43_ = self->priv->color_button_brown;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp43_, TRUE);
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label9) ? _tmp33_label9 : (_tmp33_label9 = g_quark_from_static_string ("#667885")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp44_;
					_tmp44_ = self->priv->color_button_slate;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp44_, TRUE);
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp45_;
					ESourceCalendar* _tmp46_;
					gchar* _tmp47_;
					_tmp45_ = self->priv->color_button_none;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp45_, TRUE);
					_tmp46_ = cal;
					_tmp47_ = e_source_selectable_dup_color ((ESourceSelectable*) _tmp46_);
					_g_free0 (self->priv->hex_color);
					self->priv->hex_color = _tmp47_;
					break;
				}
			}
		}
		_g_object_unref0 (cal);
	}
}

static gboolean
maya_view_source_dialog_tree_foreach (MayaViewSourceDialog* self,
                                      GtkTreeModel* model,
                                      GtkTreePath* path,
                                      GtkTreeIter* iter)
{
	GValue backend = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_;
	GValue _tmp2_ = {0};
	MayaBackend* current_backend = NULL;
	GValue _tmp3_;
	MayaBackend* _tmp4_;
	MayaBackend* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ESource* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = self->priv->list_store;
	_tmp1_ = *iter;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp0_, &_tmp1_, 1, &_tmp2_);
	G_IS_VALUE (&backend) ? (g_value_unset (&backend), NULL) : NULL;
	backend = _tmp2_;
	_tmp3_ = backend;
	_tmp4_ = _g_object_ref0 (g_value_get_object (&_tmp3_));
	current_backend = _tmp4_;
	_tmp5_ = current_backend;
	_tmp6_ = maya_backend_get_uid (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->source;
	_tmp9_ = e_source_dup_parent (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strcmp0 (_tmp7_, _tmp10_) == 0;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp7_);
	if (_tmp11_) {
		GtkComboBox* _tmp12_;
		GtkTreeIter _tmp13_;
		GtkComboBox* _tmp14_;
		_tmp12_ = self->priv->type_combobox;
		_tmp13_ = *iter;
		gtk_combo_box_set_active_iter (_tmp12_, &_tmp13_);
		_tmp14_ = self->priv->type_combobox;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, TRUE);
		result = TRUE;
		_g_object_unref0 (current_backend);
		G_IS_VALUE (&backend) ? (g_value_unset (&backend), NULL) : NULL;
		return result;
	}
	result = FALSE;
	_g_object_unref0 (current_backend);
	G_IS_VALUE (&backend) ? (g_value_unset (&backend), NULL) : NULL;
	return result;
}

static void
maya_view_source_dialog_remove_backend_widgets (MayaViewSourceDialog* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->backend_widgets;
	if (_tmp0_ == NULL) {
		return;
	}
	{
		GeeIterator* _widget_it = NULL;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = self->priv->backend_widgets;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_widget_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			MayaPlacementWidget* widget = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			MayaPlacementWidget* _tmp6_;
			GtkWidget* _tmp7_;
			MayaPlacementWidget* _tmp8_;
			GtkWidget* _tmp9_;
			_tmp3_ = _widget_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _widget_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			widget = (MayaPlacementWidget*) _tmp5_;
			_tmp6_ = widget;
			_tmp7_ = _tmp6_->widget;
			gtk_widget_hide (_tmp7_);
			_tmp8_ = widget;
			_tmp9_ = _tmp8_->widget;
			gtk_widget_destroy (_tmp9_);
			_g_object_unref0 (widget);
		}
		_g_object_unref0 (_widget_it);
	}
	_tmp10_ = self->priv->backend_widgets;
	gee_collection_clear (_tmp10_);
}

static Block27Data*
block27_data_ref (Block27Data* _data27_)
{
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}

static void
block27_data_unref (void * _userdata_)
{
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		MayaViewSourceDialog* self;
		self = _data27_->self;
		_g_object_unref0 (_data27_->widget);
		_g_object_unref0 (self);
		g_slice_free (Block27Data, _data27_);
	}
}

static void
_____lambda151_ (Block27Data* _data27_)
{
	MayaViewSourceDialog* self;
	MayaPlacementWidget* _tmp0_;
	self = _data27_->self;
	_tmp0_ = _data27_->widget;
	maya_view_source_dialog_entry_changed (self, _tmp0_);
}

static void
______lambda151__gtk_editable_changed (GtkEditable* _sender,
                                       gpointer self)
{
	_____lambda151_ (self);
}

static void
maya_view_source_dialog_add_backend_widgets (MayaViewSourceDialog* self)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->widgets_checked;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	{
		GeeIterator* _widget_it = NULL;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = self->priv->backend_widgets;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_widget_it = _tmp2_;
		while (TRUE) {
			Block27Data* _data27_;
			GeeIterator* _tmp3_;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			GtkGrid* _tmp6_;
			MayaPlacementWidget* _tmp7_;
			GtkWidget* _tmp8_;
			MayaPlacementWidget* _tmp9_;
			MayaPlacementWidget* _tmp10_;
			gboolean _tmp11_ = FALSE;
			MayaPlacementWidget* _tmp12_;
			MayaPlacementWidget* _tmp26_;
			GtkWidget* _tmp27_;
			_data27_ = g_slice_new0 (Block27Data);
			_data27_->_ref_count_ = 1;
			_data27_->self = g_object_ref (self);
			_tmp3_ = _widget_it;
			if (!gee_iterator_next (_tmp3_)) {
				block27_data_unref (_data27_);
				_data27_ = NULL;
				break;
			}
			_tmp4_ = _widget_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			_data27_->widget = (MayaPlacementWidget*) _tmp5_;
			_tmp6_ = self->priv->main_grid;
			_tmp7_ = _data27_->widget;
			_tmp8_ = _tmp7_->widget;
			_tmp9_ = _data27_->widget;
			_tmp10_ = _data27_->widget;
			gtk_grid_attach (_tmp6_, _tmp8_, _tmp9_->column, 4 + _tmp10_->row, 1, 1);
			_tmp12_ = _data27_->widget;
			if (_tmp12_->needed == TRUE) {
				MayaPlacementWidget* _tmp13_;
				GtkWidget* _tmp14_;
				_tmp13_ = _data27_->widget;
				_tmp14_ = _tmp13_->widget;
				_tmp11_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, gtk_entry_get_type ());
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				GtkEntry* entry = NULL;
				MayaPlacementWidget* _tmp15_;
				GtkWidget* _tmp16_;
				GtkEntry* _tmp17_;
				GtkEntry* _tmp18_;
				GeeHashMap* _tmp19_;
				MayaPlacementWidget* _tmp20_;
				const gchar* _tmp21_;
				MayaPlacementWidget* _tmp22_;
				GtkWidget* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				_tmp15_ = _data27_->widget;
				_tmp16_ = _tmp15_->widget;
				_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp16_) : NULL);
				entry = _tmp17_;
				_tmp18_ = entry;
				g_signal_connect_data ((GtkEditable*) _tmp18_, "changed", (GCallback) ______lambda151__gtk_editable_changed, block27_data_ref (_data27_), (GClosureNotify) block27_data_unref, 0);
				_tmp19_ = self->priv->widgets_checked;
				_tmp20_ = _data27_->widget;
				_tmp21_ = _tmp20_->ref_name;
				_tmp22_ = _data27_->widget;
				_tmp23_ = _tmp22_->widget;
				_tmp24_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_entry_get_type (), GtkEntry));
				_tmp25_ = _tmp24_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, _tmp21_, (gpointer) ((gintptr) (g_strcmp0 (_tmp25_, "") != 0)));
				_g_object_unref0 (entry);
			}
			_tmp26_ = _data27_->widget;
			_tmp27_ = _tmp26_->widget;
			gtk_widget_show (_tmp27_);
			block27_data_unref (_data27_);
			_data27_ = NULL;
		}
		_g_object_unref0 (_widget_it);
	}
	maya_view_source_dialog_check_can_validate (self);
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static void
maya_view_source_dialog_entry_changed (MayaViewSourceDialog* self,
                                       MayaPlacementWidget* widget)
{
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	GtkWidget* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->widgets_checked;
	_tmp1_ = widget->ref_name;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, _tmp1_, NULL);
	_tmp2_ = self->priv->widgets_checked;
	_tmp3_ = widget->ref_name;
	_tmp4_ = widget->widget;
	_tmp5_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_entry_get_type (), GtkEntry));
	_tmp6_ = _tmp5_;
	_tmp7_ = string_chug (_tmp6_);
	_tmp8_ = _tmp7_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, _tmp3_, (gpointer) ((gintptr) (g_utf8_strlen (_tmp8_, (gssize) -1) > 0)));
	_g_free0 (_tmp8_);
	maya_view_source_dialog_check_can_validate (self);
}

static void
maya_view_source_dialog_check_can_validate (MayaViewSourceDialog* self)
{
	GtkEntry* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _valid_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->widgets_checked;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_valid_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean valid = FALSE;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			_tmp6_ = _valid_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _valid_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			valid = (gboolean) ((gintptr) _tmp8_);
			if (valid == FALSE) {
				GtkButton* _tmp9_;
				_tmp9_ = self->priv->create_button;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, FALSE);
				_g_object_unref0 (_valid_it);
				return;
			}
		}
		_g_object_unref0 (_valid_it);
	}
	_tmp10_ = self->priv->name_entry;
	_tmp11_ = gtk_entry_get_text (_tmp10_);
	_tmp12_ = _tmp11_;
	if (g_strcmp0 (_tmp12_, "") != 0) {
		GtkButton* _tmp13_;
		_tmp13_ = self->priv->create_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, TRUE);
	}
}

void
maya_view_source_dialog_save (MayaViewSourceDialog* self)
{
	MayaViewEventType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_event_type;
	if (_tmp0_ == MAYA_VIEW_EVENT_TYPE_ADD) {
		MayaBackend* _tmp1_;
		GtkEntry* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GtkCheckButton* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		GeeCollection* _tmp9_;
		_tmp1_ = self->priv->current_backend;
		_tmp2_ = self->priv->name_entry;
		_tmp3_ = gtk_entry_get_text (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->hex_color;
		_tmp6_ = self->priv->is_default_check;
		_tmp7_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = self->priv->backend_widgets;
		maya_backend_add_new_calendar (_tmp1_, _tmp4_, _tmp5_, _tmp8_, _tmp9_);
		g_signal_emit (self, maya_view_source_dialog_signals[MAYA_VIEW_SOURCE_DIALOG_GO_BACK_SIGNAL], 0);
	} else {
		MayaBackend* _tmp10_;
		GtkEntry* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		GtkCheckButton* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
		GeeCollection* _tmp18_;
		ESource* _tmp19_;
		_tmp10_ = self->priv->current_backend;
		_tmp11_ = self->priv->name_entry;
		_tmp12_ = gtk_entry_get_text (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->priv->hex_color;
		_tmp15_ = self->priv->is_default_check;
		_tmp16_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = self->priv->backend_widgets;
		_tmp19_ = self->priv->source;
		maya_backend_modify_calendar (_tmp10_, _tmp13_, _tmp14_, _tmp17_, _tmp18_, _tmp19_);
		g_signal_emit (self, maya_view_source_dialog_signals[MAYA_VIEW_SOURCE_DIALOG_GO_BACK_SIGNAL], 0);
	}
}

MayaViewSourceDialog*
maya_view_source_dialog_construct (GType object_type)
{
	MayaViewSourceDialog * self = NULL;
	self = (MayaViewSourceDialog*) granite_dialog_construct (object_type);
	return self;
}

MayaViewSourceDialog*
maya_view_source_dialog_new (void)
{
	return maya_view_source_dialog_construct (MAYA_VIEW_TYPE_SOURCE_DIALOG);
}

MayaViewEventType
maya_view_source_dialog_get_event_type (MayaViewSourceDialog* self)
{
	MayaViewEventType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_event_type;
	return result;
}

static void
maya_view_source_dialog_set_event_type (MayaViewSourceDialog* self,
                                        MayaViewEventType value)
{
	MayaViewEventType old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_source_dialog_get_event_type (self);
	if (old_value != value) {
		self->priv->_event_type = value;
		g_object_notify_by_pspec ((GObject *) self, maya_view_source_dialog_properties[MAYA_VIEW_SOURCE_DIALOG_EVENT_TYPE_PROPERTY]);
	}
}

static void
_maya_view_source_dialog_save_gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self)
{
	maya_view_source_dialog_save ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda152_ (MayaViewSourceDialog* self)
{
	g_signal_emit (self, maya_view_source_dialog_signals[MAYA_VIEW_SOURCE_DIALOG_GO_BACK_SIGNAL], 0);
}

static void
__maya_view_source_dialog___lambda152__gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	_maya_view_source_dialog___lambda152_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog_check_can_validate_gtk_editable_changed (GtkEditable* _sender,
                                                                  gpointer self)
{
	maya_view_source_dialog_check_can_validate ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda153_ (MayaViewSourceDialog* self)
{
	GValue backend = {0};
	GtkTreeIter b_iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	GValue _tmp4_ = {0};
	GValue _tmp5_;
	MayaBackend* _tmp6_;
	GValue _tmp7_;
	ESource* _tmp8_;
	GeeCollection* _tmp9_;
	_tmp0_ = self->priv->type_combobox;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	b_iter = _tmp1_;
	_tmp2_ = self->priv->list_store;
	_tmp3_ = b_iter;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp2_, &_tmp3_, 1, &_tmp4_);
	G_IS_VALUE (&backend) ? (g_value_unset (&backend), NULL) : NULL;
	backend = _tmp4_;
	_tmp5_ = backend;
	_tmp6_ = _g_object_ref0 (g_value_get_object (&_tmp5_));
	_g_object_unref0 (self->priv->current_backend);
	self->priv->current_backend = _tmp6_;
	maya_view_source_dialog_remove_backend_widgets (self);
	_tmp7_ = backend;
	_tmp8_ = self->priv->source;
	_tmp9_ = maya_backend_get_new_calendar_widget (g_value_get_object (&_tmp7_), _tmp8_);
	_g_object_unref0 (self->priv->backend_widgets);
	self->priv->backend_widgets = _tmp9_;
	maya_view_source_dialog_add_backend_widgets (self);
	G_IS_VALUE (&backend) ? (g_value_unset (&backend), NULL) : NULL;
}

static void
__maya_view_source_dialog___lambda153__gtk_combo_box_changed (GtkComboBox* _sender,
                                                              gpointer self)
{
	_maya_view_source_dialog___lambda153_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda154_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#da3d41");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda154__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda154_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda155_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#f37329");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda155__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda155_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda156_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#e6a92a");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda156__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda156_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda157_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#81c837");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda157__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda157_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda158_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#0e9a83");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda158__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda158_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda159_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#3689e6");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda159__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda159_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda160_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#a56de2");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda160__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda160_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda161_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#de3e80");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda161__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda161_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda162_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#8a715e");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda162__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda162_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda163_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#667885");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda163__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda163_ ((MayaViewSourceDialog*) self);
}

static GObject *
maya_view_source_dialog_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MayaViewSourceDialog * self;
	GeeHashMap* _tmp0_;
	GtkButton* cancel_button = NULL;
	GtkWidget* _tmp1_;
	GtkButton* _tmp2_;
	GtkWidget* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	gchar* _tmp7_;
	GtkEntry* _tmp8_ = NULL;
	GtkEntry* _tmp9_;
	GtkLabel* name_label = NULL;
	GtkEntry* _tmp10_;
	GtkWidget* _tmp11_;
	GtkLabel* _tmp12_ = NULL;
	GtkListStore* _tmp13_;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp14_;
	GtkListStore* _tmp15_;
	GtkComboBox* _tmp16_;
	GtkComboBox* _tmp17_;
	GtkComboBox* _tmp18_;
	GtkCellRendererText* _tmp19_;
	GtkComboBox* _tmp20_;
	GtkCellRendererText* _tmp21_;
	GtkComboBox* _tmp22_;
	GtkLabel* type_label = NULL;
	GtkComboBox* _tmp23_;
	GtkWidget* _tmp24_;
	GtkLabel* _tmp25_ = NULL;
	GtkTreeIter iter = {0};
	MayaBackendsManager* backends_manager = NULL;
	MayaBackendsManager* _tmp26_;
	MayaBackendsManager* _tmp45_;
	GeeArrayList* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	GtkComboBox* _tmp51_;
	gchar* _tmp52_;
	GtkRadioButton* _tmp53_ = NULL;
	GtkRadioButton* _tmp54_;
	GtkStyleContext* _tmp55_;
	GtkRadioButton* _tmp56_;
	GtkStyleContext* _tmp57_;
	GtkRadioButton* _tmp58_;
	GtkRadioButton* _tmp59_;
	gchar* _tmp60_;
	GtkRadioButton* _tmp61_ = NULL;
	GtkRadioButton* _tmp62_;
	GtkStyleContext* _tmp63_;
	GtkRadioButton* _tmp64_;
	GtkStyleContext* _tmp65_;
	GtkRadioButton* _tmp66_;
	GtkRadioButton* _tmp67_;
	gchar* _tmp68_;
	GtkRadioButton* _tmp69_ = NULL;
	GtkRadioButton* _tmp70_;
	GtkStyleContext* _tmp71_;
	GtkRadioButton* _tmp72_;
	GtkStyleContext* _tmp73_;
	GtkRadioButton* _tmp74_;
	GtkRadioButton* _tmp75_;
	gchar* _tmp76_;
	GtkRadioButton* _tmp77_ = NULL;
	GtkRadioButton* _tmp78_;
	GtkStyleContext* _tmp79_;
	GtkRadioButton* _tmp80_;
	GtkStyleContext* _tmp81_;
	GtkRadioButton* _tmp82_;
	GtkRadioButton* _tmp83_;
	gchar* _tmp84_;
	GtkRadioButton* _tmp85_ = NULL;
	GtkRadioButton* _tmp86_;
	GtkStyleContext* _tmp87_;
	GtkRadioButton* _tmp88_;
	GtkStyleContext* _tmp89_;
	GtkRadioButton* _tmp90_;
	GtkRadioButton* _tmp91_;
	gchar* _tmp92_;
	GtkRadioButton* _tmp93_ = NULL;
	GtkRadioButton* _tmp94_;
	GtkStyleContext* _tmp95_;
	GtkRadioButton* _tmp96_;
	GtkStyleContext* _tmp97_;
	GtkRadioButton* _tmp98_;
	GtkRadioButton* _tmp99_;
	gchar* _tmp100_;
	GtkRadioButton* _tmp101_ = NULL;
	GtkRadioButton* _tmp102_;
	GtkStyleContext* _tmp103_;
	GtkRadioButton* _tmp104_;
	GtkStyleContext* _tmp105_;
	GtkRadioButton* _tmp106_;
	GtkRadioButton* _tmp107_;
	gchar* _tmp108_;
	GtkRadioButton* _tmp109_ = NULL;
	GtkRadioButton* _tmp110_;
	GtkStyleContext* _tmp111_;
	GtkRadioButton* _tmp112_;
	GtkStyleContext* _tmp113_;
	GtkRadioButton* _tmp114_;
	GtkRadioButton* _tmp115_;
	gchar* _tmp116_;
	GtkRadioButton* _tmp117_ = NULL;
	GtkRadioButton* _tmp118_;
	GtkStyleContext* _tmp119_;
	GtkRadioButton* _tmp120_;
	GtkStyleContext* _tmp121_;
	GtkRadioButton* _tmp122_;
	GtkRadioButton* _tmp123_;
	gchar* _tmp124_;
	GtkRadioButton* _tmp125_ = NULL;
	GtkRadioButton* _tmp126_;
	GtkStyleContext* _tmp127_;
	GtkRadioButton* _tmp128_;
	GtkStyleContext* _tmp129_;
	GtkRadioButton* _tmp130_;
	GtkRadioButton* _tmp131_;
	GtkRadioButton* _tmp132_ = NULL;
	GtkBox* color_box = NULL;
	GtkBox* _tmp133_;
	GtkBox* _tmp134_;
	GtkRadioButton* _tmp135_;
	GtkBox* _tmp136_;
	GtkRadioButton* _tmp137_;
	GtkBox* _tmp138_;
	GtkRadioButton* _tmp139_;
	GtkBox* _tmp140_;
	GtkRadioButton* _tmp141_;
	GtkBox* _tmp142_;
	GtkRadioButton* _tmp143_;
	GtkBox* _tmp144_;
	GtkRadioButton* _tmp145_;
	GtkBox* _tmp146_;
	GtkRadioButton* _tmp147_;
	GtkBox* _tmp148_;
	GtkRadioButton* _tmp149_;
	GtkBox* _tmp150_;
	GtkRadioButton* _tmp151_;
	GtkBox* _tmp152_;
	GtkRadioButton* _tmp153_;
	GtkLabel* color_label = NULL;
	GtkBox* _tmp154_;
	GtkWidget* _tmp155_;
	GtkLabel* _tmp156_ = NULL;
	GtkCheckButton* _tmp157_;
	GtkRadioButton* _tmp158_;
	GtkRadioButton* _tmp159_;
	GtkRadioButton* _tmp160_;
	GtkRadioButton* _tmp161_;
	GtkRadioButton* _tmp162_;
	GtkRadioButton* _tmp163_;
	GtkRadioButton* _tmp164_;
	GtkRadioButton* _tmp165_;
	GtkRadioButton* _tmp166_;
	GtkRadioButton* _tmp167_;
	GtkGrid* _tmp168_ = NULL;
	GtkGrid* _tmp169_;
	GtkLabel* _tmp170_;
	GtkGrid* _tmp171_;
	GtkComboBox* _tmp172_;
	GtkGrid* _tmp173_;
	GtkLabel* _tmp174_;
	GtkGrid* _tmp175_;
	GtkEntry* _tmp176_;
	GtkGrid* _tmp177_;
	GtkLabel* _tmp178_;
	GtkGrid* _tmp179_;
	GtkBox* _tmp180_;
	GtkGrid* _tmp181_;
	GtkCheckButton* _tmp182_;
	GtkGrid* _tmp183_;
	GtkBox* _tmp184_;
	GtkGrid* _tmp185_;
	parent_class = G_OBJECT_CLASS (maya_view_source_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_SOURCE_DIALOG, MayaViewSourceDialog);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_BOOLEAN, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->widgets_checked);
	self->priv->widgets_checked = _tmp0_;
	_tmp1_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_button_get_type (), GtkButton));
	cancel_button = _tmp2_;
	_tmp3_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Create"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->create_button);
	self->priv->create_button = _tmp4_;
	_tmp5_ = self->priv->create_button;
	g_signal_connect_object (_tmp5_, "clicked", (GCallback) _maya_view_source_dialog_save_gtk_button_clicked, self, 0);
	_tmp6_ = cancel_button;
	g_signal_connect_object (_tmp6_, "clicked", (GCallback) __maya_view_source_dialog___lambda152__gtk_button_clicked, self, 0);
	_tmp7_ = g_strdup (_ ("Calendar Name"));
	_tmp8_ = (GtkEntry*) gtk_entry_new ();
	gtk_entry_set_placeholder_text (_tmp8_, _tmp7_);
	_g_free0 (_tmp7_);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->name_entry);
	self->priv->name_entry = _tmp8_;
	_tmp9_ = self->priv->name_entry;
	g_signal_connect_object ((GtkEditable*) _tmp9_, "changed", (GCallback) _maya_view_source_dialog_check_can_validate_gtk_editable_changed, self, 0);
	_tmp10_ = self->priv->name_entry;
	_tmp11_ = _g_object_ref0 ((GtkWidget*) _tmp10_);
	_tmp12_ = (GtkLabel*) gtk_label_new (_ ("Name"));
	gtk_label_set_mnemonic_widget (_tmp12_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	gtk_label_set_xalign (_tmp12_, (gfloat) 1);
	g_object_ref_sink (_tmp12_);
	name_label = _tmp12_;
	_tmp13_ = gtk_list_store_new (2, G_TYPE_STRING, MAYA_TYPE_BACKEND, -1);
	_g_object_unref0 (self->priv->list_store);
	self->priv->list_store = _tmp13_;
	_tmp14_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp14_);
	renderer = _tmp14_;
	_tmp15_ = self->priv->list_store;
	_tmp16_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp15_);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->type_combobox);
	self->priv->type_combobox = _tmp16_;
	_tmp17_ = self->priv->type_combobox;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp17_, TRUE);
	_tmp18_ = self->priv->type_combobox;
	_tmp19_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp18_, (GtkCellRenderer*) _tmp19_, TRUE);
	_tmp20_ = self->priv->type_combobox;
	_tmp21_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp20_, (GtkCellRenderer*) _tmp21_, "text", 0);
	_tmp22_ = self->priv->type_combobox;
	g_signal_connect_object (_tmp22_, "changed", (GCallback) __maya_view_source_dialog___lambda153__gtk_combo_box_changed, self, 0);
	_tmp23_ = self->priv->type_combobox;
	_tmp24_ = _g_object_ref0 ((GtkWidget*) _tmp23_);
	_tmp25_ = (GtkLabel*) gtk_label_new (_ ("Type"));
	gtk_label_set_mnemonic_widget (_tmp25_, _tmp24_);
	_g_object_unref0 (_tmp24_);
	gtk_label_set_xalign (_tmp25_, 1.0f);
	g_object_ref_sink (_tmp25_);
	type_label = _tmp25_;
	_tmp26_ = maya_backends_manager_get_default ();
	backends_manager = _tmp26_;
	{
		GeeArrayList* _backend_list = NULL;
		MayaBackendsManager* _tmp27_;
		GeeArrayList* _tmp28_;
		gint _backend_size = 0;
		GeeArrayList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _backend_index = 0;
		_tmp27_ = backends_manager;
		_tmp28_ = _tmp27_->backends;
		_backend_list = _tmp28_;
		_tmp29_ = _backend_list;
		_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_backend_size = _tmp31_;
		_backend_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			MayaBackend* backend = NULL;
			GeeArrayList* _tmp34_;
			gpointer _tmp35_;
			MayaBackend* _tmp36_;
			GtkListStore* _tmp37_;
			GtkTreeIter _tmp38_ = {0};
			GtkListStore* _tmp39_;
			GtkTreeIter _tmp40_;
			MayaBackend* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			MayaBackend* _tmp44_;
			_backend_index = _backend_index + 1;
			_tmp32_ = _backend_index;
			_tmp33_ = _backend_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = _backend_list;
			_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _backend_index);
			_tmp36_ = _g_object_ref0 ((MayaBackend*) _tmp35_);
			backend = _tmp36_;
			_tmp37_ = self->priv->list_store;
			gtk_list_store_append (_tmp37_, &_tmp38_);
			iter = _tmp38_;
			_tmp39_ = self->priv->list_store;
			_tmp40_ = iter;
			_tmp41_ = backend;
			_tmp42_ = maya_backend_get_name (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = backend;
			gtk_list_store_set (_tmp39_, &_tmp40_, 0, _tmp43_, 1, _tmp44_, -1);
			_g_free0 (_tmp43_);
			_g_object_unref0 (backend);
		}
	}
	_tmp45_ = backends_manager;
	_tmp46_ = _tmp45_->backends;
	_tmp47_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp46_);
	_tmp48_ = _tmp47_;
	if (_tmp48_ <= 1) {
		GtkComboBox* _tmp49_;
		GtkLabel* _tmp50_;
		_tmp49_ = self->priv->type_combobox;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp49_, TRUE);
		_tmp50_ = type_label;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp50_, TRUE);
	}
	_tmp51_ = self->priv->type_combobox;
	gtk_combo_box_set_active (_tmp51_, 0);
	_tmp52_ = g_strdup (_ ("Blueberry"));
	_tmp53_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp53_, _tmp52_);
	_g_free0 (_tmp52_);
	g_object_ref_sink (_tmp53_);
	_g_object_unref0 (self->priv->color_button_blue);
	self->priv->color_button_blue = _tmp53_;
	_tmp54_ = self->priv->color_button_blue;
	_tmp55_ = gtk_widget_get_style_context ((GtkWidget*) _tmp54_);
	gtk_style_context_add_class (_tmp55_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp56_ = self->priv->color_button_blue;
	_tmp57_ = gtk_widget_get_style_context ((GtkWidget*) _tmp56_);
	gtk_style_context_add_class (_tmp57_, "blue");
	_tmp58_ = self->priv->color_button_blue;
	_tmp59_ = _g_object_ref0 (_tmp58_);
	_tmp60_ = g_strdup (_ ("Mint"));
	_tmp61_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_set (_tmp61_, "group", _tmp59_, NULL);
	_g_object_unref0 (_tmp59_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp61_, _tmp60_);
	_g_free0 (_tmp60_);
	g_object_ref_sink (_tmp61_);
	_g_object_unref0 (self->priv->color_button_mint);
	self->priv->color_button_mint = _tmp61_;
	_tmp62_ = self->priv->color_button_mint;
	_tmp63_ = gtk_widget_get_style_context ((GtkWidget*) _tmp62_);
	gtk_style_context_add_class (_tmp63_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp64_ = self->priv->color_button_mint;
	_tmp65_ = gtk_widget_get_style_context ((GtkWidget*) _tmp64_);
	gtk_style_context_add_class (_tmp65_, "mint");
	_tmp66_ = self->priv->color_button_blue;
	_tmp67_ = _g_object_ref0 (_tmp66_);
	_tmp68_ = g_strdup (_ ("Lime"));
	_tmp69_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_set (_tmp69_, "group", _tmp67_, NULL);
	_g_object_unref0 (_tmp67_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp69_, _tmp68_);
	_g_free0 (_tmp68_);
	g_object_ref_sink (_tmp69_);
	_g_object_unref0 (self->priv->color_button_green);
	self->priv->color_button_green = _tmp69_;
	_tmp70_ = self->priv->color_button_green;
	_tmp71_ = gtk_widget_get_style_context ((GtkWidget*) _tmp70_);
	gtk_style_context_add_class (_tmp71_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp72_ = self->priv->color_button_green;
	_tmp73_ = gtk_widget_get_style_context ((GtkWidget*) _tmp72_);
	gtk_style_context_add_class (_tmp73_, "green");
	_tmp74_ = self->priv->color_button_blue;
	_tmp75_ = _g_object_ref0 (_tmp74_);
	_tmp76_ = g_strdup (_ ("Banana"));
	_tmp77_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_set (_tmp77_, "group", _tmp75_, NULL);
	_g_object_unref0 (_tmp75_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp77_, _tmp76_);
	_g_free0 (_tmp76_);
	g_object_ref_sink (_tmp77_);
	_g_object_unref0 (self->priv->color_button_yellow);
	self->priv->color_button_yellow = _tmp77_;
	_tmp78_ = self->priv->color_button_yellow;
	_tmp79_ = gtk_widget_get_style_context ((GtkWidget*) _tmp78_);
	gtk_style_context_add_class (_tmp79_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp80_ = self->priv->color_button_yellow;
	_tmp81_ = gtk_widget_get_style_context ((GtkWidget*) _tmp80_);
	gtk_style_context_add_class (_tmp81_, "yellow");
	_tmp82_ = self->priv->color_button_blue;
	_tmp83_ = _g_object_ref0 (_tmp82_);
	_tmp84_ = g_strdup (_ ("Orange"));
	_tmp85_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_set (_tmp85_, "group", _tmp83_, NULL);
	_g_object_unref0 (_tmp83_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp85_, _tmp84_);
	_g_free0 (_tmp84_);
	g_object_ref_sink (_tmp85_);
	_g_object_unref0 (self->priv->color_button_orange);
	self->priv->color_button_orange = _tmp85_;
	_tmp86_ = self->priv->color_button_orange;
	_tmp87_ = gtk_widget_get_style_context ((GtkWidget*) _tmp86_);
	gtk_style_context_add_class (_tmp87_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp88_ = self->priv->color_button_orange;
	_tmp89_ = gtk_widget_get_style_context ((GtkWidget*) _tmp88_);
	gtk_style_context_add_class (_tmp89_, "orange");
	_tmp90_ = self->priv->color_button_blue;
	_tmp91_ = _g_object_ref0 (_tmp90_);
	_tmp92_ = g_strdup (_ ("Strawberry"));
	_tmp93_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_set (_tmp93_, "group", _tmp91_, NULL);
	_g_object_unref0 (_tmp91_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp93_, _tmp92_);
	_g_free0 (_tmp92_);
	g_object_ref_sink (_tmp93_);
	_g_object_unref0 (self->priv->color_button_red);
	self->priv->color_button_red = _tmp93_;
	_tmp94_ = self->priv->color_button_red;
	_tmp95_ = gtk_widget_get_style_context ((GtkWidget*) _tmp94_);
	gtk_style_context_add_class (_tmp95_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp96_ = self->priv->color_button_red;
	_tmp97_ = gtk_widget_get_style_context ((GtkWidget*) _tmp96_);
	gtk_style_context_add_class (_tmp97_, "red");
	_tmp98_ = self->priv->color_button_blue;
	_tmp99_ = _g_object_ref0 (_tmp98_);
	_tmp100_ = g_strdup (_ ("Bubblegum"));
	_tmp101_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_set (_tmp101_, "group", _tmp99_, NULL);
	_g_object_unref0 (_tmp99_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp101_, _tmp100_);
	_g_free0 (_tmp100_);
	g_object_ref_sink (_tmp101_);
	_g_object_unref0 (self->priv->color_button_pink);
	self->priv->color_button_pink = _tmp101_;
	_tmp102_ = self->priv->color_button_pink;
	_tmp103_ = gtk_widget_get_style_context ((GtkWidget*) _tmp102_);
	gtk_style_context_add_class (_tmp103_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp104_ = self->priv->color_button_pink;
	_tmp105_ = gtk_widget_get_style_context ((GtkWidget*) _tmp104_);
	gtk_style_context_add_class (_tmp105_, "pink");
	_tmp106_ = self->priv->color_button_blue;
	_tmp107_ = _g_object_ref0 (_tmp106_);
	_tmp108_ = g_strdup (_ ("Grape"));
	_tmp109_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_set (_tmp109_, "group", _tmp107_, NULL);
	_g_object_unref0 (_tmp107_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp109_, _tmp108_);
	_g_free0 (_tmp108_);
	g_object_ref_sink (_tmp109_);
	_g_object_unref0 (self->priv->color_button_purple);
	self->priv->color_button_purple = _tmp109_;
	_tmp110_ = self->priv->color_button_purple;
	_tmp111_ = gtk_widget_get_style_context ((GtkWidget*) _tmp110_);
	gtk_style_context_add_class (_tmp111_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp112_ = self->priv->color_button_purple;
	_tmp113_ = gtk_widget_get_style_context ((GtkWidget*) _tmp112_);
	gtk_style_context_add_class (_tmp113_, "purple");
	_tmp114_ = self->priv->color_button_blue;
	_tmp115_ = _g_object_ref0 (_tmp114_);
	_tmp116_ = g_strdup (_ ("Cocoa"));
	_tmp117_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_set (_tmp117_, "group", _tmp115_, NULL);
	_g_object_unref0 (_tmp115_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp117_, _tmp116_);
	_g_free0 (_tmp116_);
	g_object_ref_sink (_tmp117_);
	_g_object_unref0 (self->priv->color_button_brown);
	self->priv->color_button_brown = _tmp117_;
	_tmp118_ = self->priv->color_button_brown;
	_tmp119_ = gtk_widget_get_style_context ((GtkWidget*) _tmp118_);
	gtk_style_context_add_class (_tmp119_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp120_ = self->priv->color_button_brown;
	_tmp121_ = gtk_widget_get_style_context ((GtkWidget*) _tmp120_);
	gtk_style_context_add_class (_tmp121_, "brown");
	_tmp122_ = self->priv->color_button_blue;
	_tmp123_ = _g_object_ref0 (_tmp122_);
	_tmp124_ = g_strdup (_ ("Slate"));
	_tmp125_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_set (_tmp125_, "group", _tmp123_, NULL);
	_g_object_unref0 (_tmp123_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp125_, _tmp124_);
	_g_free0 (_tmp124_);
	g_object_ref_sink (_tmp125_);
	_g_object_unref0 (self->priv->color_button_slate);
	self->priv->color_button_slate = _tmp125_;
	_tmp126_ = self->priv->color_button_slate;
	_tmp127_ = gtk_widget_get_style_context ((GtkWidget*) _tmp126_);
	gtk_style_context_add_class (_tmp127_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp128_ = self->priv->color_button_slate;
	_tmp129_ = gtk_widget_get_style_context ((GtkWidget*) _tmp128_);
	gtk_style_context_add_class (_tmp129_, "slate");
	_tmp130_ = self->priv->color_button_blue;
	_tmp131_ = _g_object_ref0 (_tmp130_);
	_tmp132_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_set (_tmp132_, "group", _tmp131_, NULL);
	_g_object_unref0 (_tmp131_);
	g_object_ref_sink (_tmp132_);
	_g_object_unref0 (self->priv->color_button_none);
	self->priv->color_button_none = _tmp132_;
	_tmp133_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp133_);
	color_box = _tmp133_;
	_tmp134_ = color_box;
	_tmp135_ = self->priv->color_button_blue;
	gtk_container_add ((GtkContainer*) _tmp134_, (GtkWidget*) _tmp135_);
	_tmp136_ = color_box;
	_tmp137_ = self->priv->color_button_mint;
	gtk_container_add ((GtkContainer*) _tmp136_, (GtkWidget*) _tmp137_);
	_tmp138_ = color_box;
	_tmp139_ = self->priv->color_button_green;
	gtk_container_add ((GtkContainer*) _tmp138_, (GtkWidget*) _tmp139_);
	_tmp140_ = color_box;
	_tmp141_ = self->priv->color_button_yellow;
	gtk_container_add ((GtkContainer*) _tmp140_, (GtkWidget*) _tmp141_);
	_tmp142_ = color_box;
	_tmp143_ = self->priv->color_button_orange;
	gtk_container_add ((GtkContainer*) _tmp142_, (GtkWidget*) _tmp143_);
	_tmp144_ = color_box;
	_tmp145_ = self->priv->color_button_red;
	gtk_container_add ((GtkContainer*) _tmp144_, (GtkWidget*) _tmp145_);
	_tmp146_ = color_box;
	_tmp147_ = self->priv->color_button_pink;
	gtk_container_add ((GtkContainer*) _tmp146_, (GtkWidget*) _tmp147_);
	_tmp148_ = color_box;
	_tmp149_ = self->priv->color_button_purple;
	gtk_container_add ((GtkContainer*) _tmp148_, (GtkWidget*) _tmp149_);
	_tmp150_ = color_box;
	_tmp151_ = self->priv->color_button_brown;
	gtk_container_add ((GtkContainer*) _tmp150_, (GtkWidget*) _tmp151_);
	_tmp152_ = color_box;
	_tmp153_ = self->priv->color_button_slate;
	gtk_container_add ((GtkContainer*) _tmp152_, (GtkWidget*) _tmp153_);
	_tmp154_ = color_box;
	_tmp155_ = _g_object_ref0 ((GtkWidget*) _tmp154_);
	_tmp156_ = (GtkLabel*) gtk_label_new (_ ("Color"));
	gtk_label_set_mnemonic_widget (_tmp156_, _tmp155_);
	_g_object_unref0 (_tmp155_);
	gtk_label_set_xalign (_tmp156_, (gfloat) 1);
	g_object_ref_sink (_tmp156_);
	color_label = _tmp156_;
	_tmp157_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Mark as default calendar"));
	g_object_ref_sink (_tmp157_);
	_g_object_unref0 (self->priv->is_default_check);
	self->priv->is_default_check = _tmp157_;
	_tmp158_ = self->priv->color_button_red;
	g_signal_connect_object ((GtkToggleButton*) _tmp158_, "toggled", (GCallback) __maya_view_source_dialog___lambda154__gtk_toggle_button_toggled, self, 0);
	_tmp159_ = self->priv->color_button_orange;
	g_signal_connect_object ((GtkToggleButton*) _tmp159_, "toggled", (GCallback) __maya_view_source_dialog___lambda155__gtk_toggle_button_toggled, self, 0);
	_tmp160_ = self->priv->color_button_yellow;
	g_signal_connect_object ((GtkToggleButton*) _tmp160_, "toggled", (GCallback) __maya_view_source_dialog___lambda156__gtk_toggle_button_toggled, self, 0);
	_tmp161_ = self->priv->color_button_green;
	g_signal_connect_object ((GtkToggleButton*) _tmp161_, "toggled", (GCallback) __maya_view_source_dialog___lambda157__gtk_toggle_button_toggled, self, 0);
	_tmp162_ = self->priv->color_button_mint;
	g_signal_connect_object ((GtkToggleButton*) _tmp162_, "toggled", (GCallback) __maya_view_source_dialog___lambda158__gtk_toggle_button_toggled, self, 0);
	_tmp163_ = self->priv->color_button_blue;
	g_signal_connect_object ((GtkToggleButton*) _tmp163_, "toggled", (GCallback) __maya_view_source_dialog___lambda159__gtk_toggle_button_toggled, self, 0);
	_tmp164_ = self->priv->color_button_purple;
	g_signal_connect_object ((GtkToggleButton*) _tmp164_, "toggled", (GCallback) __maya_view_source_dialog___lambda160__gtk_toggle_button_toggled, self, 0);
	_tmp165_ = self->priv->color_button_pink;
	g_signal_connect_object ((GtkToggleButton*) _tmp165_, "toggled", (GCallback) __maya_view_source_dialog___lambda161__gtk_toggle_button_toggled, self, 0);
	_tmp166_ = self->priv->color_button_brown;
	g_signal_connect_object ((GtkToggleButton*) _tmp166_, "toggled", (GCallback) __maya_view_source_dialog___lambda162__gtk_toggle_button_toggled, self, 0);
	_tmp167_ = self->priv->color_button_slate;
	g_signal_connect_object ((GtkToggleButton*) _tmp167_, "toggled", (GCallback) __maya_view_source_dialog___lambda163__gtk_toggle_button_toggled, self, 0);
	_tmp168_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp168_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp168_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp168_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp168_, 24);
	gtk_grid_set_column_spacing (_tmp168_, 12);
	gtk_grid_set_row_spacing (_tmp168_, 12);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp168_, TRUE);
	g_object_ref_sink (_tmp168_);
	_g_object_unref0 (self->priv->main_grid);
	self->priv->main_grid = _tmp168_;
	_tmp169_ = self->priv->main_grid;
	_tmp170_ = type_label;
	gtk_grid_attach (_tmp169_, (GtkWidget*) _tmp170_, 0, 0, 1, 1);
	_tmp171_ = self->priv->main_grid;
	_tmp172_ = self->priv->type_combobox;
	gtk_grid_attach (_tmp171_, (GtkWidget*) _tmp172_, 1, 0, 1, 1);
	_tmp173_ = self->priv->main_grid;
	_tmp174_ = name_label;
	gtk_grid_attach (_tmp173_, (GtkWidget*) _tmp174_, 0, 1, 1, 1);
	_tmp175_ = self->priv->main_grid;
	_tmp176_ = self->priv->name_entry;
	gtk_grid_attach (_tmp175_, (GtkWidget*) _tmp176_, 1, 1, 1, 1);
	_tmp177_ = self->priv->main_grid;
	_tmp178_ = color_label;
	gtk_grid_attach (_tmp177_, (GtkWidget*) _tmp178_, 0, 2, 1, 1);
	_tmp179_ = self->priv->main_grid;
	_tmp180_ = color_box;
	gtk_grid_attach (_tmp179_, (GtkWidget*) _tmp180_, 1, 2, 1, 1);
	_tmp181_ = self->priv->main_grid;
	_tmp182_ = self->priv->is_default_check;
	gtk_grid_attach (_tmp181_, (GtkWidget*) _tmp182_, 1, 3, 1, 1);
	_tmp183_ = self->priv->main_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp183_);
	_tmp184_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp185_ = self->priv->main_grid;
	gtk_container_add ((GtkContainer*) _tmp184_, (GtkWidget*) _tmp185_);
	_g_object_unref0 (color_label);
	_g_object_unref0 (color_box);
	_g_object_unref0 (backends_manager);
	_g_object_unref0 (type_label);
	_g_object_unref0 (renderer);
	_g_object_unref0 (name_label);
	_g_object_unref0 (cancel_button);
	return obj;
}

static void
maya_view_source_dialog_class_init (MayaViewSourceDialogClass * klass,
                                    gpointer klass_data)
{
	maya_view_source_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaViewSourceDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_maya_view_source_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_maya_view_source_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = maya_view_source_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = maya_view_source_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_SOURCE_DIALOG_EVENT_TYPE_PROPERTY, maya_view_source_dialog_properties[MAYA_VIEW_SOURCE_DIALOG_EVENT_TYPE_PROPERTY] = g_param_spec_enum ("event-type", "event-type", "event-type", MAYA_VIEW_TYPE_EVENT_TYPE, MAYA_VIEW_EVENT_TYPE_EDIT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	maya_view_source_dialog_signals[MAYA_VIEW_SOURCE_DIALOG_GO_BACK_SIGNAL] = g_signal_new ("go-back", MAYA_VIEW_TYPE_SOURCE_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
maya_view_source_dialog_instance_init (MayaViewSourceDialog * self,
                                       gpointer klass)
{
	gchar* _tmp0_;
	self->priv = maya_view_source_dialog_get_instance_private (self);
	self->priv->_event_type = MAYA_VIEW_EVENT_TYPE_EDIT;
	_tmp0_ = g_strdup ("#da3d41");
	self->priv->hex_color = _tmp0_;
	self->priv->source = NULL;
}

static void
maya_view_source_dialog_finalize (GObject * obj)
{
	MayaViewSourceDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_SOURCE_DIALOG, MayaViewSourceDialog);
	_g_object_unref0 (self->priv->name_entry);
	_g_free0 (self->priv->hex_color);
	_g_object_unref0 (self->priv->current_backend);
	_g_object_unref0 (self->priv->backend_widgets);
	_g_object_unref0 (self->priv->main_grid);
	_g_object_unref0 (self->priv->widgets_checked);
	_g_object_unref0 (self->priv->create_button);
	_g_object_unref0 (self->priv->type_combobox);
	_g_object_unref0 (self->priv->list_store);
	_g_object_unref0 (self->priv->is_default_check);
	_g_object_unref0 (self->priv->source);
	_g_object_unref0 (self->priv->color_button_blue);
	_g_object_unref0 (self->priv->color_button_mint);
	_g_object_unref0 (self->priv->color_button_green);
	_g_object_unref0 (self->priv->color_button_yellow);
	_g_object_unref0 (self->priv->color_button_orange);
	_g_object_unref0 (self->priv->color_button_red);
	_g_object_unref0 (self->priv->color_button_pink);
	_g_object_unref0 (self->priv->color_button_purple);
	_g_object_unref0 (self->priv->color_button_brown);
	_g_object_unref0 (self->priv->color_button_slate);
	_g_object_unref0 (self->priv->color_button_none);
	G_OBJECT_CLASS (maya_view_source_dialog_parent_class)->finalize (obj);
}

static GType
maya_view_source_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaViewSourceDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_view_source_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaViewSourceDialog), 0, (GInstanceInitFunc) maya_view_source_dialog_instance_init, NULL };
	GType maya_view_source_dialog_type_id;
	maya_view_source_dialog_type_id = g_type_register_static (GRANITE_TYPE_DIALOG, "MayaViewSourceDialog", &g_define_type_info, 0);
	MayaViewSourceDialog_private_offset = g_type_add_instance_private (maya_view_source_dialog_type_id, sizeof (MayaViewSourceDialogPrivate));
	return maya_view_source_dialog_type_id;
}

GType
maya_view_source_dialog_get_type (void)
{
	static volatile gsize maya_view_source_dialog_type_id__once = 0;
	if (g_once_init_enter (&maya_view_source_dialog_type_id__once)) {
		GType maya_view_source_dialog_type_id;
		maya_view_source_dialog_type_id = maya_view_source_dialog_get_type_once ();
		g_once_init_leave (&maya_view_source_dialog_type_id__once, maya_view_source_dialog_type_id);
	}
	return maya_view_source_dialog_type_id__once;
}

static void
_vala_maya_view_source_dialog_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	MayaViewSourceDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_SOURCE_DIALOG, MayaViewSourceDialog);
	switch (property_id) {
		case MAYA_VIEW_SOURCE_DIALOG_EVENT_TYPE_PROPERTY:
		g_value_set_enum (value, maya_view_source_dialog_get_event_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_maya_view_source_dialog_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	MayaViewSourceDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_SOURCE_DIALOG, MayaViewSourceDialog);
	switch (property_id) {
		case MAYA_VIEW_SOURCE_DIALOG_EVENT_TYPE_PROPERTY:
		maya_view_source_dialog_set_event_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

