#include "nv_push_clc197.h"

#include <stdio.h>





const char *P_PARSE_NVC097_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVC097_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVC197_MTHD(uint16_t idx)
{
    switch (idx) {

  
    default:

    return P_PARSE_NVC097_MTHD(idx);

                                                                                case NVC197_FE_ATOMIC_SEQUENCE_BEGIN:
        return "NVC197_FE_ATOMIC_SEQUENCE_BEGIN";
    case NVC197_FE_ATOMIC_SEQUENCE_END:
        return "NVC197_FE_ATOMIC_SEQUENCE_END";
                                                                                                        case NVC197_SET_GS_MODE:
        return "NVC197_SET_GS_MODE";
                        case NVC197_SET_INSTANCE_COUNT:
        return "NVC197_SET_INSTANCE_COUNT";
    case NVC197_SET_POSITION_W_SCALED_OFFSET_ENABLE:
        return "NVC197_SET_POSITION_W_SCALED_OFFSET_ENABLE";
    case NVC197_SET_MULTI_VIEW:
        return "NVC197_SET_MULTI_VIEW";
    case NVC197_SET_GO_IDLE_TIMEOUT:
        return "NVC197_SET_GO_IDLE_TIMEOUT";
                    case NVC197_SET_ALPHA_CIRCULAR_BUFFER_SIZE:
        return "NVC197_SET_ALPHA_CIRCULAR_BUFFER_SIZE";
                                                                                                                                                        case NVC197_SET_BALANCED_PRIMITIVE_WORKLOAD:
        return "NVC197_SET_BALANCED_PRIMITIVE_WORKLOAD";
                                                                                                                    case NVC197_SET_STENCIL_ZERO_BANDWIDTH_CLEAR:
        return "NVC197_SET_STENCIL_ZERO_BANDWIDTH_CLEAR";
                                                                                                                                                                    case NVC197_SET_STATISTICS_COUNTER:
        return "NVC197_SET_STATISTICS_COUNTER";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case NVC197_SET_CIRCULAR_BUFFER_SIZE:
        return "NVC197_SET_CIRCULAR_BUFFER_SIZE";
                                                                                                                                                                                                                                                                                                        case NVC197_CLEAR_REPORT_VALUE:
        return "NVC197_CLEAR_REPORT_VALUE";
                                                                                                                                                            case NVC197_BEGIN:
        return "NVC197_BEGIN";
                                                                                                                                                                                                                                                                                                                                case NVC197_SET_REPORT_SEMAPHORE_D:
        return "NVC197_SET_REPORT_SEMAPHORE_D";
                                                                                                                                                                                                                                                                                                                                                        
    }
}

void
P_DUMP_NVC197_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
    default:

    P_DUMP_NVC097_MTHD_DATA(fp, idx, data, prefix);
    break;

                                                                              
    case NVC197_FE_ATOMIC_SEQUENCE_BEGIN:

    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC197_FE_ATOMIC_SEQUENCE_END:

    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                                      
    case NVC197_SET_GS_MODE:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVC197_SET_GS_MODE_TYPE_ANY:
            fprintf(fp, "ANY\n");
            break;
        case NVC197_SET_GS_MODE_TYPE_FAST_GS:
            fprintf(fp, "FAST_GS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                      
    case NVC197_SET_INSTANCE_COUNT:

    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NVC197_SET_POSITION_W_SCALED_OFFSET_ENABLE:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_POSITION_W_SCALED_OFFSET_ENABLE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_POSITION_W_SCALED_OFFSET_ENABLE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVC197_SET_MULTI_VIEW:

    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.VIEW_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 11) - 1);
        fprintf(fp, "%s.RENDER_TARGET_INDEX_OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.INDEPENDENT_VIEWPORT_MASK_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_MULTI_VIEW_INDEPENDENT_VIEWPORT_MASK_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_MULTI_VIEW_INDEPENDENT_VIEWPORT_MASK_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NVC197_SET_GO_IDLE_TIMEOUT:

    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                  
    case NVC197_SET_ALPHA_CIRCULAR_BUFFER_SIZE:

    
        parsed = (data >> 0) & ((1u << 14) - 1);
        fprintf(fp, "%s.CACHE_LINES_PER_SM = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                                                                                      
    case NVC197_SET_BALANCED_PRIMITIVE_WORKLOAD:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.IN_UNPARTITIONED_MODE = ", prefix);
        switch (parsed) {
        case NVC197_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_UNPARTITIONED_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_UNPARTITIONED_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.IN_TIMESLICED_MODE = ", prefix);
        switch (parsed) {
        case NVC197_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_TIMESLICED_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_TIMESLICED_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.BY_PES_IN_UNPARTITIONED_MODE = ", prefix);
        switch (parsed) {
        case NVC197_SET_BALANCED_PRIMITIVE_WORKLOAD_BY_PES_IN_UNPARTITIONED_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_BALANCED_PRIMITIVE_WORKLOAD_BY_PES_IN_UNPARTITIONED_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.BY_PES_IN_TIMESLICED_MODE = ", prefix);
        switch (parsed) {
        case NVC197_SET_BALANCED_PRIMITIVE_WORKLOAD_BY_PES_IN_TIMESLICED_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_BALANCED_PRIMITIVE_WORKLOAD_BY_PES_IN_TIMESLICED_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                                                                                                  
    case NVC197_SET_STENCIL_ZERO_BANDWIDTH_CLEAR:

    
        parsed = (data >> 0) & ((1u << 15) - 1);
        fprintf(fp, "%s.SLOT_DISABLE_MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                                                                                                  
    case NVC197_SET_STATISTICS_COUNTER:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.DA_VERTICES_GENERATED_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_STATISTICS_COUNTER_DA_VERTICES_GENERATED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_STATISTICS_COUNTER_DA_VERTICES_GENERATED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.DA_PRIMITIVES_GENERATED_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_STATISTICS_COUNTER_DA_PRIMITIVES_GENERATED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_STATISTICS_COUNTER_DA_PRIMITIVES_GENERATED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.VS_INVOCATIONS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_STATISTICS_COUNTER_VS_INVOCATIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_STATISTICS_COUNTER_VS_INVOCATIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.GS_INVOCATIONS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_STATISTICS_COUNTER_GS_INVOCATIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_STATISTICS_COUNTER_GS_INVOCATIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.GS_PRIMITIVES_GENERATED_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_STATISTICS_COUNTER_GS_PRIMITIVES_GENERATED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_STATISTICS_COUNTER_GS_PRIMITIVES_GENERATED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.STREAMING_PRIMITIVES_SUCCEEDED_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_SUCCEEDED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_SUCCEEDED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.STREAMING_PRIMITIVES_NEEDED_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_NEEDED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_NEEDED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLIPPER_INVOCATIONS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_STATISTICS_COUNTER_CLIPPER_INVOCATIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_STATISTICS_COUNTER_CLIPPER_INVOCATIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLIPPER_PRIMITIVES_GENERATED_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_STATISTICS_COUNTER_CLIPPER_PRIMITIVES_GENERATED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_STATISTICS_COUNTER_CLIPPER_PRIMITIVES_GENERATED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.PS_INVOCATIONS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_STATISTICS_COUNTER_PS_INVOCATIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_STATISTICS_COUNTER_PS_INVOCATIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 11) & ((1u << 1) - 1);
        fprintf(fp, "%s.TI_INVOCATIONS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_STATISTICS_COUNTER_TI_INVOCATIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_STATISTICS_COUNTER_TI_INVOCATIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.TS_INVOCATIONS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_STATISTICS_COUNTER_TS_INVOCATIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_STATISTICS_COUNTER_TS_INVOCATIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 13) & ((1u << 1) - 1);
        fprintf(fp, "%s.TS_PRIMITIVES_GENERATED_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_STATISTICS_COUNTER_TS_PRIMITIVES_GENERATED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_STATISTICS_COUNTER_TS_PRIMITIVES_GENERATED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 14) & ((1u << 1) - 1);
        fprintf(fp, "%s.TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_STATISTICS_COUNTER_TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_STATISTICS_COUNTER_TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 1) - 1);
        fprintf(fp, "%s.VTG_PRIMITIVES_OUT_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_STATISTICS_COUNTER_VTG_PRIMITIVES_OUT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_STATISTICS_COUNTER_VTG_PRIMITIVES_OUT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 15) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALPHA_BETA_CLOCKS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_STATISTICS_COUNTER_ALPHA_BETA_CLOCKS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_STATISTICS_COUNTER_ALPHA_BETA_CLOCKS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.SCG_CLOCKS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_STATISTICS_COUNTER_SCG_CLOCKS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_STATISTICS_COUNTER_SCG_CLOCKS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      
    case NVC197_SET_CIRCULAR_BUFFER_SIZE:

    
        parsed = (data >> 0) & ((1u << 20) - 1);
        fprintf(fp, "%s.CACHE_LINES_PER_SM = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                                                                                                                                                                                                                                      
    case NVC197_CLEAR_REPORT_VALUE:

    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVC197_CLEAR_REPORT_VALUE_TYPE_DA_VERTICES_GENERATED:
            fprintf(fp, "DA_VERTICES_GENERATED\n");
            break;
        case NVC197_CLEAR_REPORT_VALUE_TYPE_DA_PRIMITIVES_GENERATED:
            fprintf(fp, "DA_PRIMITIVES_GENERATED\n");
            break;
        case NVC197_CLEAR_REPORT_VALUE_TYPE_VS_INVOCATIONS:
            fprintf(fp, "VS_INVOCATIONS\n");
            break;
        case NVC197_CLEAR_REPORT_VALUE_TYPE_TI_INVOCATIONS:
            fprintf(fp, "TI_INVOCATIONS\n");
            break;
        case NVC197_CLEAR_REPORT_VALUE_TYPE_TS_INVOCATIONS:
            fprintf(fp, "TS_INVOCATIONS\n");
            break;
        case NVC197_CLEAR_REPORT_VALUE_TYPE_TS_PRIMITIVES_GENERATED:
            fprintf(fp, "TS_PRIMITIVES_GENERATED\n");
            break;
        case NVC197_CLEAR_REPORT_VALUE_TYPE_GS_INVOCATIONS:
            fprintf(fp, "GS_INVOCATIONS\n");
            break;
        case NVC197_CLEAR_REPORT_VALUE_TYPE_GS_PRIMITIVES_GENERATED:
            fprintf(fp, "GS_PRIMITIVES_GENERATED\n");
            break;
        case NVC197_CLEAR_REPORT_VALUE_TYPE_VTG_PRIMITIVES_OUT:
            fprintf(fp, "VTG_PRIMITIVES_OUT\n");
            break;
        case NVC197_CLEAR_REPORT_VALUE_TYPE_STREAMING_PRIMITIVES_SUCCEEDED:
            fprintf(fp, "STREAMING_PRIMITIVES_SUCCEEDED\n");
            break;
        case NVC197_CLEAR_REPORT_VALUE_TYPE_STREAMING_PRIMITIVES_NEEDED:
            fprintf(fp, "STREAMING_PRIMITIVES_NEEDED\n");
            break;
        case NVC197_CLEAR_REPORT_VALUE_TYPE_TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED:
            fprintf(fp, "TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED\n");
            break;
        case NVC197_CLEAR_REPORT_VALUE_TYPE_CLIPPER_INVOCATIONS:
            fprintf(fp, "CLIPPER_INVOCATIONS\n");
            break;
        case NVC197_CLEAR_REPORT_VALUE_TYPE_CLIPPER_PRIMITIVES_GENERATED:
            fprintf(fp, "CLIPPER_PRIMITIVES_GENERATED\n");
            break;
        case NVC197_CLEAR_REPORT_VALUE_TYPE_ZCULL_STATS:
            fprintf(fp, "ZCULL_STATS\n");
            break;
        case NVC197_CLEAR_REPORT_VALUE_TYPE_PS_INVOCATIONS:
            fprintf(fp, "PS_INVOCATIONS\n");
            break;
        case NVC197_CLEAR_REPORT_VALUE_TYPE_ZPASS_PIXEL_CNT:
            fprintf(fp, "ZPASS_PIXEL_CNT\n");
            break;
        case NVC197_CLEAR_REPORT_VALUE_TYPE_ALPHA_BETA_CLOCKS:
            fprintf(fp, "ALPHA_BETA_CLOCKS\n");
            break;
        case NVC197_CLEAR_REPORT_VALUE_TYPE_SCG_CLOCKS:
            fprintf(fp, "SCG_CLOCKS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                                                                                                                                          
    case NVC197_BEGIN:

    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.OP = ", prefix);
        switch (parsed) {
        case NVC197_BEGIN_OP_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVC197_BEGIN_OP_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVC197_BEGIN_OP_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVC197_BEGIN_OP_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVC197_BEGIN_OP_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVC197_BEGIN_OP_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVC197_BEGIN_OP_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVC197_BEGIN_OP_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVC197_BEGIN_OP_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVC197_BEGIN_OP_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVC197_BEGIN_OP_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVC197_BEGIN_OP_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVC197_BEGIN_OP_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVC197_BEGIN_OP_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVC197_BEGIN_OP_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.PRIMITIVE_ID = ", prefix);
        switch (parsed) {
        case NVC197_BEGIN_PRIMITIVE_ID_FIRST:
            fprintf(fp, "FIRST\n");
            break;
        case NVC197_BEGIN_PRIMITIVE_ID_UNCHANGED:
            fprintf(fp, "UNCHANGED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 26) & ((1u << 2) - 1);
        fprintf(fp, "%s.INSTANCE_ID = ", prefix);
        switch (parsed) {
        case NVC197_BEGIN_INSTANCE_ID_FIRST:
            fprintf(fp, "FIRST\n");
            break;
        case NVC197_BEGIN_INSTANCE_ID_SUBSEQUENT:
            fprintf(fp, "SUBSEQUENT\n");
            break;
        case NVC197_BEGIN_INSTANCE_ID_UNCHANGED:
            fprintf(fp, "UNCHANGED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 29) & ((1u << 2) - 1);
        fprintf(fp, "%s.SPLIT_MODE = ", prefix);
        switch (parsed) {
        case NVC197_BEGIN_SPLIT_MODE_NORMAL_BEGIN_NORMAL_END:
            fprintf(fp, "NORMAL_BEGIN_NORMAL_END\n");
            break;
        case NVC197_BEGIN_SPLIT_MODE_NORMAL_BEGIN_OPEN_END:
            fprintf(fp, "NORMAL_BEGIN_OPEN_END\n");
            break;
        case NVC197_BEGIN_SPLIT_MODE_OPEN_BEGIN_OPEN_END:
            fprintf(fp, "OPEN_BEGIN_OPEN_END\n");
            break;
        case NVC197_BEGIN_SPLIT_MODE_OPEN_BEGIN_NORMAL_END:
            fprintf(fp, "OPEN_BEGIN_NORMAL_END\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.INSTANCE_ITERATE_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_BEGIN_INSTANCE_ITERATE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_BEGIN_INSTANCE_ITERATE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                                                                                                                                                                                                                                                                                                              
    case NVC197_SET_REPORT_SEMAPHORE_D:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC197_SET_REPORT_SEMAPHORE_D_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_OPERATION_ACQUIRE:
            fprintf(fp, "ACQUIRE\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_OPERATION_REPORT_ONLY:
            fprintf(fp, "REPORT_ONLY\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_OPERATION_TRAP:
            fprintf(fp, "TRAP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE = ", prefix);
        switch (parsed) {
        case NVC197_SET_REPORT_SEMAPHORE_D_RELEASE_AFTER_ALL_PRECEEDING_READS_COMPLETE:
            fprintf(fp, "AFTER_ALL_PRECEEDING_READS_COMPLETE\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_RELEASE_AFTER_ALL_PRECEEDING_WRITES_COMPLETE:
            fprintf(fp, "AFTER_ALL_PRECEEDING_WRITES_COMPLETE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.ACQUIRE = ", prefix);
        switch (parsed) {
        case NVC197_SET_REPORT_SEMAPHORE_D_ACQUIRE_BEFORE_ANY_FOLLOWING_WRITES_START:
            fprintf(fp, "BEFORE_ANY_FOLLOWING_WRITES_START\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_ACQUIRE_BEFORE_ANY_FOLLOWING_READS_START:
            fprintf(fp, "BEFORE_ANY_FOLLOWING_READS_START\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.PIPELINE_LOCATION = ", prefix);
        switch (parsed) {
        case NVC197_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_DATA_ASSEMBLER:
            fprintf(fp, "DATA_ASSEMBLER\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_VERTEX_SHADER:
            fprintf(fp, "VERTEX_SHADER\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_TESSELATION_INIT_SHADER:
            fprintf(fp, "TESSELATION_INIT_SHADER\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_TESSELATION_SHADER:
            fprintf(fp, "TESSELATION_SHADER\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_GEOMETRY_SHADER:
            fprintf(fp, "GEOMETRY_SHADER\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_STREAMING_OUTPUT:
            fprintf(fp, "STREAMING_OUTPUT\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_VPC:
            fprintf(fp, "VPC\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_ZCULL:
            fprintf(fp, "ZCULL\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_PIXEL_SHADER:
            fprintf(fp, "PIXEL_SHADER\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_DEPTH_TEST:
            fprintf(fp, "DEPTH_TEST\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_ALL:
            fprintf(fp, "ALL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.COMPARISON = ", prefix);
        switch (parsed) {
        case NVC197_SET_REPORT_SEMAPHORE_D_COMPARISON_EQ:
            fprintf(fp, "EQ\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_COMPARISON_GE:
            fprintf(fp, "GE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.AWAKEN_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 23) & ((1u << 5) - 1);
        fprintf(fp, "%s.REPORT = ", prefix);
        switch (parsed) {
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_DA_VERTICES_GENERATED:
            fprintf(fp, "DA_VERTICES_GENERATED\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_DA_PRIMITIVES_GENERATED:
            fprintf(fp, "DA_PRIMITIVES_GENERATED\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_VS_INVOCATIONS:
            fprintf(fp, "VS_INVOCATIONS\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_TI_INVOCATIONS:
            fprintf(fp, "TI_INVOCATIONS\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_TS_INVOCATIONS:
            fprintf(fp, "TS_INVOCATIONS\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_TS_PRIMITIVES_GENERATED:
            fprintf(fp, "TS_PRIMITIVES_GENERATED\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_GS_INVOCATIONS:
            fprintf(fp, "GS_INVOCATIONS\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_GS_PRIMITIVES_GENERATED:
            fprintf(fp, "GS_PRIMITIVES_GENERATED\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_ALPHA_BETA_CLOCKS:
            fprintf(fp, "ALPHA_BETA_CLOCKS\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_SCG_CLOCKS:
            fprintf(fp, "SCG_CLOCKS\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_VTG_PRIMITIVES_OUT:
            fprintf(fp, "VTG_PRIMITIVES_OUT\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED:
            fprintf(fp, "TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_SUCCEEDED:
            fprintf(fp, "STREAMING_PRIMITIVES_SUCCEEDED\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_NEEDED:
            fprintf(fp, "STREAMING_PRIMITIVES_NEEDED\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED:
            fprintf(fp, "STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_BYTE_COUNT:
            fprintf(fp, "STREAMING_BYTE_COUNT\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_CLIPPER_INVOCATIONS:
            fprintf(fp, "CLIPPER_INVOCATIONS\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_CLIPPER_PRIMITIVES_GENERATED:
            fprintf(fp, "CLIPPER_PRIMITIVES_GENERATED\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS0:
            fprintf(fp, "ZCULL_STATS0\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS1:
            fprintf(fp, "ZCULL_STATS1\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS2:
            fprintf(fp, "ZCULL_STATS2\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS3:
            fprintf(fp, "ZCULL_STATS3\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_PS_INVOCATIONS:
            fprintf(fp, "PS_INVOCATIONS\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_ZPASS_PIXEL_CNT:
            fprintf(fp, "ZPASS_PIXEL_CNT\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_ZPASS_PIXEL_CNT64:
            fprintf(fp, "ZPASS_PIXEL_CNT64\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_TILED_ZPASS_PIXEL_CNT64:
            fprintf(fp, "TILED_ZPASS_PIXEL_CNT64\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_IEEE_CLEAN_COLOR_TARGET:
            fprintf(fp, "IEEE_CLEAN_COLOR_TARGET\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_IEEE_CLEAN_ZETA_TARGET:
            fprintf(fp, "IEEE_CLEAN_ZETA_TARGET\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REPORT_BOUNDING_RECTANGLE:
            fprintf(fp, "BOUNDING_RECTANGLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 28) & ((1u << 1) - 1);
        fprintf(fp, "%s.STRUCTURE_SIZE = ", prefix);
        switch (parsed) {
        case NVC197_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_FOUR_WORDS:
            fprintf(fp, "FOUR_WORDS\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_ONE_WORD:
            fprintf(fp, "ONE_WORD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 3) - 1);
        fprintf(fp, "%s.SUB_REPORT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 21) & ((1u << 1) - 1);
        fprintf(fp, "%s.REPORT_DWORD_NUMBER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_DISABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_ENABLE = ", prefix);
        switch (parsed) {
        case NVC197_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 3) - 1);
        fprintf(fp, "%s.REDUCTION_OP = ", prefix);
        switch (parsed) {
        case NVC197_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_ADD:
            fprintf(fp, "RED_ADD\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MIN:
            fprintf(fp, "RED_MIN\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MAX:
            fprintf(fp, "RED_MAX\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_INC:
            fprintf(fp, "RED_INC\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_DEC:
            fprintf(fp, "RED_DEC\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_AND:
            fprintf(fp, "RED_AND\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_OR:
            fprintf(fp, "RED_OR\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_XOR:
            fprintf(fp, "RED_XOR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 17) & ((1u << 2) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVC197_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_UNSIGNED_32:
            fprintf(fp, "UNSIGNED_32\n");
            break;
        case NVC197_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_SIGNED_32:
            fprintf(fp, "SIGNED_32\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                                                                                                                                                                                                                                                                                                                                            }
}
