//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/filters/network/ext_proc/v3/ext_proc.proto

package ext_procv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on NetworkExternalProcessor with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *NetworkExternalProcessor) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on NetworkExternalProcessor with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// NetworkExternalProcessorMultiError, or nil if none found.
func (m *NetworkExternalProcessor) ValidateAll() error {
	return m.validate(true)
}

func (m *NetworkExternalProcessor) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetGrpcService()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, NetworkExternalProcessorValidationError{
					field:  "GrpcService",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, NetworkExternalProcessorValidationError{
					field:  "GrpcService",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGrpcService()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return NetworkExternalProcessorValidationError{
				field:  "GrpcService",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for FailureModeAllow

	if all {
		switch v := interface{}(m.GetProcessingMode()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, NetworkExternalProcessorValidationError{
					field:  "ProcessingMode",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, NetworkExternalProcessorValidationError{
					field:  "ProcessingMode",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetProcessingMode()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return NetworkExternalProcessorValidationError{
				field:  "ProcessingMode",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if d := m.GetMessageTimeout(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = NetworkExternalProcessorValidationError{
				field:  "MessageTimeout",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			lte := time.Duration(3600*time.Second + 0*time.Nanosecond)
			gte := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur < gte || dur > lte {
				err := NetworkExternalProcessorValidationError{
					field:  "MessageTimeout",
					reason: "value must be inside range [0s, 1h0m0s]",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if utf8.RuneCountInString(m.GetStatPrefix()) < 1 {
		err := NetworkExternalProcessorValidationError{
			field:  "StatPrefix",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMetadataOptions()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, NetworkExternalProcessorValidationError{
					field:  "MetadataOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, NetworkExternalProcessorValidationError{
					field:  "MetadataOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadataOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return NetworkExternalProcessorValidationError{
				field:  "MetadataOptions",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return NetworkExternalProcessorMultiError(errors)
	}

	return nil
}

// NetworkExternalProcessorMultiError is an error wrapping multiple validation
// errors returned by NetworkExternalProcessor.ValidateAll() if the designated
// constraints aren't met.
type NetworkExternalProcessorMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m NetworkExternalProcessorMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m NetworkExternalProcessorMultiError) AllErrors() []error { return m }

// NetworkExternalProcessorValidationError is the validation error returned by
// NetworkExternalProcessor.Validate if the designated constraints aren't met.
type NetworkExternalProcessorValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e NetworkExternalProcessorValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e NetworkExternalProcessorValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e NetworkExternalProcessorValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e NetworkExternalProcessorValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e NetworkExternalProcessorValidationError) ErrorName() string {
	return "NetworkExternalProcessorValidationError"
}

// Error satisfies the builtin error interface
func (e NetworkExternalProcessorValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sNetworkExternalProcessor.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = NetworkExternalProcessorValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = NetworkExternalProcessorValidationError{}

// Validate checks the field values on ProcessingMode with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ProcessingMode) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ProcessingMode with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ProcessingModeMultiError,
// or nil if none found.
func (m *ProcessingMode) ValidateAll() error {
	return m.validate(true)
}

func (m *ProcessingMode) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for ProcessRead

	// no validation rules for ProcessWrite

	if len(errors) > 0 {
		return ProcessingModeMultiError(errors)
	}

	return nil
}

// ProcessingModeMultiError is an error wrapping multiple validation errors
// returned by ProcessingMode.ValidateAll() if the designated constraints
// aren't met.
type ProcessingModeMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ProcessingModeMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ProcessingModeMultiError) AllErrors() []error { return m }

// ProcessingModeValidationError is the validation error returned by
// ProcessingMode.Validate if the designated constraints aren't met.
type ProcessingModeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ProcessingModeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ProcessingModeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ProcessingModeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ProcessingModeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ProcessingModeValidationError) ErrorName() string { return "ProcessingModeValidationError" }

// Error satisfies the builtin error interface
func (e ProcessingModeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sProcessingMode.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ProcessingModeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ProcessingModeValidationError{}

// Validate checks the field values on MetadataOptions with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *MetadataOptions) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on MetadataOptions with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// MetadataOptionsMultiError, or nil if none found.
func (m *MetadataOptions) ValidateAll() error {
	return m.validate(true)
}

func (m *MetadataOptions) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetForwardingNamespaces()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, MetadataOptionsValidationError{
					field:  "ForwardingNamespaces",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, MetadataOptionsValidationError{
					field:  "ForwardingNamespaces",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetForwardingNamespaces()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return MetadataOptionsValidationError{
				field:  "ForwardingNamespaces",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return MetadataOptionsMultiError(errors)
	}

	return nil
}

// MetadataOptionsMultiError is an error wrapping multiple validation errors
// returned by MetadataOptions.ValidateAll() if the designated constraints
// aren't met.
type MetadataOptionsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m MetadataOptionsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m MetadataOptionsMultiError) AllErrors() []error { return m }

// MetadataOptionsValidationError is the validation error returned by
// MetadataOptions.Validate if the designated constraints aren't met.
type MetadataOptionsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MetadataOptionsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MetadataOptionsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MetadataOptionsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MetadataOptionsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MetadataOptionsValidationError) ErrorName() string { return "MetadataOptionsValidationError" }

// Error satisfies the builtin error interface
func (e MetadataOptionsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMetadataOptions.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MetadataOptionsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MetadataOptionsValidationError{}

// Validate checks the field values on MetadataOptions_MetadataNamespaces with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *MetadataOptions_MetadataNamespaces) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on MetadataOptions_MetadataNamespaces
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// MetadataOptions_MetadataNamespacesMultiError, or nil if none found.
func (m *MetadataOptions_MetadataNamespaces) ValidateAll() error {
	return m.validate(true)
}

func (m *MetadataOptions_MetadataNamespaces) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return MetadataOptions_MetadataNamespacesMultiError(errors)
	}

	return nil
}

// MetadataOptions_MetadataNamespacesMultiError is an error wrapping multiple
// validation errors returned by
// MetadataOptions_MetadataNamespaces.ValidateAll() if the designated
// constraints aren't met.
type MetadataOptions_MetadataNamespacesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m MetadataOptions_MetadataNamespacesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m MetadataOptions_MetadataNamespacesMultiError) AllErrors() []error { return m }

// MetadataOptions_MetadataNamespacesValidationError is the validation error
// returned by MetadataOptions_MetadataNamespaces.Validate if the designated
// constraints aren't met.
type MetadataOptions_MetadataNamespacesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MetadataOptions_MetadataNamespacesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MetadataOptions_MetadataNamespacesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MetadataOptions_MetadataNamespacesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MetadataOptions_MetadataNamespacesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MetadataOptions_MetadataNamespacesValidationError) ErrorName() string {
	return "MetadataOptions_MetadataNamespacesValidationError"
}

// Error satisfies the builtin error interface
func (e MetadataOptions_MetadataNamespacesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMetadataOptions_MetadataNamespaces.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MetadataOptions_MetadataNamespacesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MetadataOptions_MetadataNamespacesValidationError{}
