//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/grpc_service/call_credentials/sts_service/v3/sts_service_credentials.proto

package sts_servicev3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on StsServiceCredentials with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *StsServiceCredentials) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on StsServiceCredentials with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// StsServiceCredentialsMultiError, or nil if none found.
func (m *StsServiceCredentials) ValidateAll() error {
	return m.validate(true)
}

func (m *StsServiceCredentials) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for TokenExchangeServiceUri

	// no validation rules for Resource

	// no validation rules for Audience

	// no validation rules for Scope

	// no validation rules for RequestedTokenType

	if utf8.RuneCountInString(m.GetSubjectTokenPath()) < 1 {
		err := StsServiceCredentialsValidationError{
			field:  "SubjectTokenPath",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if utf8.RuneCountInString(m.GetSubjectTokenType()) < 1 {
		err := StsServiceCredentialsValidationError{
			field:  "SubjectTokenType",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for ActorTokenPath

	// no validation rules for ActorTokenType

	if len(errors) > 0 {
		return StsServiceCredentialsMultiError(errors)
	}

	return nil
}

// StsServiceCredentialsMultiError is an error wrapping multiple validation
// errors returned by StsServiceCredentials.ValidateAll() if the designated
// constraints aren't met.
type StsServiceCredentialsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m StsServiceCredentialsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m StsServiceCredentialsMultiError) AllErrors() []error { return m }

// StsServiceCredentialsValidationError is the validation error returned by
// StsServiceCredentials.Validate if the designated constraints aren't met.
type StsServiceCredentialsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e StsServiceCredentialsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e StsServiceCredentialsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e StsServiceCredentialsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e StsServiceCredentialsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e StsServiceCredentialsValidationError) ErrorName() string {
	return "StsServiceCredentialsValidationError"
}

// Error satisfies the builtin error interface
func (e StsServiceCredentialsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sStsServiceCredentials.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = StsServiceCredentialsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = StsServiceCredentialsValidationError{}
