{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Use t'GI.HarfBuzz.Structs.OtVarAxisInfoT.OtVarAxisInfoT' instead.
-- 
-- /Since: 1.4.2/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.OtVarAxisT
    ( 

-- * Exported types
    OtVarAxisT(..)                          ,
    newZeroOtVarAxisT                       ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveOtVarAxisTMethod                 ,
#endif



 -- * Properties


-- ** defaultValue #attr:defaultValue#
-- | default value of the axis

    getOtVarAxisTDefaultValue               ,
#if defined(ENABLE_OVERLOADING)
    otVarAxisT_defaultValue                 ,
#endif
    setOtVarAxisTDefaultValue               ,


-- ** maxValue #attr:maxValue#
-- | maximum value of the axis

    getOtVarAxisTMaxValue                   ,
#if defined(ENABLE_OVERLOADING)
    otVarAxisT_maxValue                     ,
#endif
    setOtVarAxisTMaxValue                   ,


-- ** minValue #attr:minValue#
-- | minimum value of the axis

    getOtVarAxisTMinValue                   ,
#if defined(ENABLE_OVERLOADING)
    otVarAxisT_minValue                     ,
#endif
    setOtVarAxisTMinValue                   ,


-- ** nameId #attr:nameId#
-- | axis name identifier

    getOtVarAxisTNameId                     ,
#if defined(ENABLE_OVERLOADING)
    otVarAxisT_nameId                       ,
#endif
    setOtVarAxisTNameId                     ,


-- ** tag #attr:tag#
-- | axis tag

    getOtVarAxisTTag                        ,
#if defined(ENABLE_OVERLOADING)
    otVarAxisT_tag                          ,
#endif
    setOtVarAxisTTag                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype OtVarAxisT = OtVarAxisT (SP.ManagedPtr OtVarAxisT)
    deriving (Eq)

instance SP.ManagedPtrNewtype OtVarAxisT where
    toManagedPtr (OtVarAxisT p) = p

instance BoxedPtr OtVarAxisT where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 20 >=> B.ManagedPtr.wrapPtr OtVarAxisT)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr OtVarAxisT where
    boxedPtrCalloc = callocBytes 20


-- | Construct a t'OtVarAxisT' struct initialized to zero.
newZeroOtVarAxisT :: MonadIO m => m OtVarAxisT
newZeroOtVarAxisT = liftIO $ boxedPtrCalloc >>= wrapPtr OtVarAxisT

instance tag ~ 'AttrSet => Constructible OtVarAxisT tag where
    new _ attrs = do
        o <- newZeroOtVarAxisT
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@tag@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otVarAxisT #tag
-- @
getOtVarAxisTTag :: MonadIO m => OtVarAxisT -> m Word32
getOtVarAxisTTag s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@tag@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otVarAxisT [ #tag 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtVarAxisTTag :: MonadIO m => OtVarAxisT -> Word32 -> m ()
setOtVarAxisTTag s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data OtVarAxisTTagFieldInfo
instance AttrInfo OtVarAxisTTagFieldInfo where
    type AttrBaseTypeConstraint OtVarAxisTTagFieldInfo = (~) OtVarAxisT
    type AttrAllowedOps OtVarAxisTTagFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtVarAxisTTagFieldInfo = (~) Word32
    type AttrTransferTypeConstraint OtVarAxisTTagFieldInfo = (~)Word32
    type AttrTransferType OtVarAxisTTagFieldInfo = Word32
    type AttrGetType OtVarAxisTTagFieldInfo = Word32
    type AttrLabel OtVarAxisTTagFieldInfo = "tag"
    type AttrOrigin OtVarAxisTTagFieldInfo = OtVarAxisT
    attrGet = getOtVarAxisTTag
    attrSet = setOtVarAxisTTag
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtVarAxisT.tag"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtVarAxisT.html#g:attr:tag"
        })

otVarAxisT_tag :: AttrLabelProxy "tag"
otVarAxisT_tag = AttrLabelProxy

#endif


-- | Get the value of the “@name_id@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otVarAxisT #nameId
-- @
getOtVarAxisTNameId :: MonadIO m => OtVarAxisT -> m Word32
getOtVarAxisTNameId s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Word32
    return val

-- | Set the value of the “@name_id@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otVarAxisT [ #nameId 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtVarAxisTNameId :: MonadIO m => OtVarAxisT -> Word32 -> m ()
setOtVarAxisTNameId s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data OtVarAxisTNameIdFieldInfo
instance AttrInfo OtVarAxisTNameIdFieldInfo where
    type AttrBaseTypeConstraint OtVarAxisTNameIdFieldInfo = (~) OtVarAxisT
    type AttrAllowedOps OtVarAxisTNameIdFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtVarAxisTNameIdFieldInfo = (~) Word32
    type AttrTransferTypeConstraint OtVarAxisTNameIdFieldInfo = (~)Word32
    type AttrTransferType OtVarAxisTNameIdFieldInfo = Word32
    type AttrGetType OtVarAxisTNameIdFieldInfo = Word32
    type AttrLabel OtVarAxisTNameIdFieldInfo = "name_id"
    type AttrOrigin OtVarAxisTNameIdFieldInfo = OtVarAxisT
    attrGet = getOtVarAxisTNameId
    attrSet = setOtVarAxisTNameId
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtVarAxisT.nameId"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtVarAxisT.html#g:attr:nameId"
        })

otVarAxisT_nameId :: AttrLabelProxy "nameId"
otVarAxisT_nameId = AttrLabelProxy

#endif


-- | Get the value of the “@min_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otVarAxisT #minValue
-- @
getOtVarAxisTMinValue :: MonadIO m => OtVarAxisT -> m Float
getOtVarAxisTMinValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@min_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otVarAxisT [ #minValue 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtVarAxisTMinValue :: MonadIO m => OtVarAxisT -> Float -> m ()
setOtVarAxisTMinValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 8) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data OtVarAxisTMinValueFieldInfo
instance AttrInfo OtVarAxisTMinValueFieldInfo where
    type AttrBaseTypeConstraint OtVarAxisTMinValueFieldInfo = (~) OtVarAxisT
    type AttrAllowedOps OtVarAxisTMinValueFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtVarAxisTMinValueFieldInfo = (~) Float
    type AttrTransferTypeConstraint OtVarAxisTMinValueFieldInfo = (~)Float
    type AttrTransferType OtVarAxisTMinValueFieldInfo = Float
    type AttrGetType OtVarAxisTMinValueFieldInfo = Float
    type AttrLabel OtVarAxisTMinValueFieldInfo = "min_value"
    type AttrOrigin OtVarAxisTMinValueFieldInfo = OtVarAxisT
    attrGet = getOtVarAxisTMinValue
    attrSet = setOtVarAxisTMinValue
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtVarAxisT.minValue"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtVarAxisT.html#g:attr:minValue"
        })

otVarAxisT_minValue :: AttrLabelProxy "minValue"
otVarAxisT_minValue = AttrLabelProxy

#endif


-- | Get the value of the “@default_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otVarAxisT #defaultValue
-- @
getOtVarAxisTDefaultValue :: MonadIO m => OtVarAxisT -> m Float
getOtVarAxisTDefaultValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@default_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otVarAxisT [ #defaultValue 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtVarAxisTDefaultValue :: MonadIO m => OtVarAxisT -> Float -> m ()
setOtVarAxisTDefaultValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 12) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data OtVarAxisTDefaultValueFieldInfo
instance AttrInfo OtVarAxisTDefaultValueFieldInfo where
    type AttrBaseTypeConstraint OtVarAxisTDefaultValueFieldInfo = (~) OtVarAxisT
    type AttrAllowedOps OtVarAxisTDefaultValueFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtVarAxisTDefaultValueFieldInfo = (~) Float
    type AttrTransferTypeConstraint OtVarAxisTDefaultValueFieldInfo = (~)Float
    type AttrTransferType OtVarAxisTDefaultValueFieldInfo = Float
    type AttrGetType OtVarAxisTDefaultValueFieldInfo = Float
    type AttrLabel OtVarAxisTDefaultValueFieldInfo = "default_value"
    type AttrOrigin OtVarAxisTDefaultValueFieldInfo = OtVarAxisT
    attrGet = getOtVarAxisTDefaultValue
    attrSet = setOtVarAxisTDefaultValue
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtVarAxisT.defaultValue"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtVarAxisT.html#g:attr:defaultValue"
        })

otVarAxisT_defaultValue :: AttrLabelProxy "defaultValue"
otVarAxisT_defaultValue = AttrLabelProxy

#endif


-- | Get the value of the “@max_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otVarAxisT #maxValue
-- @
getOtVarAxisTMaxValue :: MonadIO m => OtVarAxisT -> m Float
getOtVarAxisTMaxValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@max_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otVarAxisT [ #maxValue 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtVarAxisTMaxValue :: MonadIO m => OtVarAxisT -> Float -> m ()
setOtVarAxisTMaxValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 16) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data OtVarAxisTMaxValueFieldInfo
instance AttrInfo OtVarAxisTMaxValueFieldInfo where
    type AttrBaseTypeConstraint OtVarAxisTMaxValueFieldInfo = (~) OtVarAxisT
    type AttrAllowedOps OtVarAxisTMaxValueFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtVarAxisTMaxValueFieldInfo = (~) Float
    type AttrTransferTypeConstraint OtVarAxisTMaxValueFieldInfo = (~)Float
    type AttrTransferType OtVarAxisTMaxValueFieldInfo = Float
    type AttrGetType OtVarAxisTMaxValueFieldInfo = Float
    type AttrLabel OtVarAxisTMaxValueFieldInfo = "max_value"
    type AttrOrigin OtVarAxisTMaxValueFieldInfo = OtVarAxisT
    attrGet = getOtVarAxisTMaxValue
    attrSet = setOtVarAxisTMaxValue
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtVarAxisT.maxValue"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtVarAxisT.html#g:attr:maxValue"
        })

otVarAxisT_maxValue :: AttrLabelProxy "maxValue"
otVarAxisT_maxValue = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList OtVarAxisT
type instance O.AttributeList OtVarAxisT = OtVarAxisTAttributeList
type OtVarAxisTAttributeList = ('[ '("tag", OtVarAxisTTagFieldInfo), '("nameId", OtVarAxisTNameIdFieldInfo), '("minValue", OtVarAxisTMinValueFieldInfo), '("defaultValue", OtVarAxisTDefaultValueFieldInfo), '("maxValue", OtVarAxisTMaxValueFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveOtVarAxisTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveOtVarAxisTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveOtVarAxisTMethod t OtVarAxisT, O.OverloadedMethod info OtVarAxisT p) => OL.IsLabel t (OtVarAxisT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveOtVarAxisTMethod t OtVarAxisT, O.OverloadedMethod info OtVarAxisT p, R.HasField t OtVarAxisT p) => R.HasField t OtVarAxisT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveOtVarAxisTMethod t OtVarAxisT, O.OverloadedMethodInfo info OtVarAxisT) => OL.IsLabel t (O.MethodProxy info OtVarAxisT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


