{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Displays an image.
-- 
-- \<picture>
--   \<source srcset=\"image-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkImage\" src=\"image.png\">
-- \<\/picture>
-- 
-- Various kinds of object can be displayed as an image; most typically,
-- you would load a @GdkTexture@ from a file, using the convenience function
-- 'GI.Gtk.Objects.Image.imageNewFromFile', for instance:
-- 
-- 
-- === /c code/
-- >GtkWidget *image = gtk_image_new_from_file ("myfile.png");
-- 
-- 
-- If the file isn’t loaded successfully, the image will contain a
-- “broken image” icon similar to that used in many web browsers.
-- 
-- If you want to handle errors in loading the file yourself, for example
-- by displaying an error message, then load the image with an image
-- loading framework such as libglycin, then create the @GtkImage@ with
-- 'GI.Gtk.Objects.Image.imageNewFromPaintable'.
-- 
-- Sometimes an application will want to avoid depending on external data
-- files, such as image files. See the documentation of @GResource@ inside
-- GIO, for details. In this case, [Image:resource]("GI.Gtk.Objects.Image#g:attr:resource"),
-- 'GI.Gtk.Objects.Image.imageNewFromResource', and 'GI.Gtk.Objects.Image.imageSetFromResource'
-- should be used.
-- 
-- @GtkImage@ displays its image as an icon, with a size that is determined
-- by the application. See t'GI.Gtk.Objects.Picture.Picture' if you want to show an image
-- at is actual size.
-- 
-- == CSS nodes
-- 
-- @GtkImage@ has a single CSS node with the name @image@. The style classes
-- @.normal-icons@ or @.large-icons@ may appear, depending on the
-- [Image:iconSize]("GI.Gtk.Objects.Image#g:attr:iconSize") property.
-- 
-- == Accessibility
-- 
-- @GtkImage@ uses the 'GI.Gtk.Enums.AccessibleRoleImg' role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Image
    ( 

-- * Exported types
    Image(..)                               ,
    IsImage                                 ,
    toImage                                 ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [clear]("GI.Gtk.Objects.Image#g:method:clear"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getGicon]("GI.Gtk.Objects.Image#g:method:getGicon"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getIconName]("GI.Gtk.Objects.Image#g:method:getIconName"), [getIconSize]("GI.Gtk.Objects.Image#g:method:getIconSize"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPaintable]("GI.Gtk.Objects.Image#g:method:getPaintable"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPixelSize]("GI.Gtk.Objects.Image#g:method:getPixelSize"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStorageType]("GI.Gtk.Objects.Image#g:method:getStorageType"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setFromFile]("GI.Gtk.Objects.Image#g:method:setFromFile"), [setFromGicon]("GI.Gtk.Objects.Image#g:method:setFromGicon"), [setFromIconName]("GI.Gtk.Objects.Image#g:method:setFromIconName"), [setFromPaintable]("GI.Gtk.Objects.Image#g:method:setFromPaintable"), [setFromPixbuf]("GI.Gtk.Objects.Image#g:method:setFromPixbuf"), [setFromResource]("GI.Gtk.Objects.Image#g:method:setFromResource"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setIconSize]("GI.Gtk.Objects.Image#g:method:setIconSize"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setPixelSize]("GI.Gtk.Objects.Image#g:method:setPixelSize"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveImageMethod                      ,
#endif

-- ** clear #method:clear#

#if defined(ENABLE_OVERLOADING)
    ImageClearMethodInfo                    ,
#endif
    imageClear                              ,


-- ** getGicon #method:getGicon#

#if defined(ENABLE_OVERLOADING)
    ImageGetGiconMethodInfo                 ,
#endif
    imageGetGicon                           ,


-- ** getIconName #method:getIconName#

#if defined(ENABLE_OVERLOADING)
    ImageGetIconNameMethodInfo              ,
#endif
    imageGetIconName                        ,


-- ** getIconSize #method:getIconSize#

#if defined(ENABLE_OVERLOADING)
    ImageGetIconSizeMethodInfo              ,
#endif
    imageGetIconSize                        ,


-- ** getPaintable #method:getPaintable#

#if defined(ENABLE_OVERLOADING)
    ImageGetPaintableMethodInfo             ,
#endif
    imageGetPaintable                       ,


-- ** getPixelSize #method:getPixelSize#

#if defined(ENABLE_OVERLOADING)
    ImageGetPixelSizeMethodInfo             ,
#endif
    imageGetPixelSize                       ,


-- ** getStorageType #method:getStorageType#

#if defined(ENABLE_OVERLOADING)
    ImageGetStorageTypeMethodInfo           ,
#endif
    imageGetStorageType                     ,


-- ** new #method:new#

    imageNew                                ,


-- ** newFromFile #method:newFromFile#

    imageNewFromFile                        ,


-- ** newFromGicon #method:newFromGicon#

    imageNewFromGicon                       ,


-- ** newFromIconName #method:newFromIconName#

    imageNewFromIconName                    ,


-- ** newFromPaintable #method:newFromPaintable#

    imageNewFromPaintable                   ,


-- ** newFromPixbuf #method:newFromPixbuf#

    imageNewFromPixbuf                      ,


-- ** newFromResource #method:newFromResource#

    imageNewFromResource                    ,


-- ** setFromFile #method:setFromFile#

#if defined(ENABLE_OVERLOADING)
    ImageSetFromFileMethodInfo              ,
#endif
    imageSetFromFile                        ,


-- ** setFromGicon #method:setFromGicon#

#if defined(ENABLE_OVERLOADING)
    ImageSetFromGiconMethodInfo             ,
#endif
    imageSetFromGicon                       ,


-- ** setFromIconName #method:setFromIconName#

#if defined(ENABLE_OVERLOADING)
    ImageSetFromIconNameMethodInfo          ,
#endif
    imageSetFromIconName                    ,


-- ** setFromPaintable #method:setFromPaintable#

#if defined(ENABLE_OVERLOADING)
    ImageSetFromPaintableMethodInfo         ,
#endif
    imageSetFromPaintable                   ,


-- ** setFromPixbuf #method:setFromPixbuf#

#if defined(ENABLE_OVERLOADING)
    ImageSetFromPixbufMethodInfo            ,
#endif
    imageSetFromPixbuf                      ,


-- ** setFromResource #method:setFromResource#

#if defined(ENABLE_OVERLOADING)
    ImageSetFromResourceMethodInfo          ,
#endif
    imageSetFromResource                    ,


-- ** setIconSize #method:setIconSize#

#if defined(ENABLE_OVERLOADING)
    ImageSetIconSizeMethodInfo              ,
#endif
    imageSetIconSize                        ,


-- ** setPixelSize #method:setPixelSize#

#if defined(ENABLE_OVERLOADING)
    ImageSetPixelSizeMethodInfo             ,
#endif
    imageSetPixelSize                       ,




 -- * Properties


-- ** file #attr:file#
-- | A path to the file to display.

#if defined(ENABLE_OVERLOADING)
    ImageFilePropertyInfo                   ,
#endif
    clearImageFile                          ,
    constructImageFile                      ,
    getImageFile                            ,
#if defined(ENABLE_OVERLOADING)
    imageFile                               ,
#endif
    setImageFile                            ,


-- ** gicon #attr:gicon#
-- | The @GIcon@ displayed in the GtkImage.
-- 
-- For themed icons, If the icon theme is changed, the image will be updated
-- automatically.

#if defined(ENABLE_OVERLOADING)
    ImageGiconPropertyInfo                  ,
#endif
    constructImageGicon                     ,
    getImageGicon                           ,
#if defined(ENABLE_OVERLOADING)
    imageGicon                              ,
#endif
    setImageGicon                           ,


-- ** iconName #attr:iconName#
-- | The name of the icon in the icon theme.
-- 
-- If the icon theme is changed, the image will be updated automatically.

#if defined(ENABLE_OVERLOADING)
    ImageIconNamePropertyInfo               ,
#endif
    clearImageIconName                      ,
    constructImageIconName                  ,
    getImageIconName                        ,
#if defined(ENABLE_OVERLOADING)
    imageIconName                           ,
#endif
    setImageIconName                        ,


-- ** iconSize #attr:iconSize#
-- | The symbolic size to display icons at.

#if defined(ENABLE_OVERLOADING)
    ImageIconSizePropertyInfo               ,
#endif
    constructImageIconSize                  ,
    getImageIconSize                        ,
#if defined(ENABLE_OVERLOADING)
    imageIconSize                           ,
#endif
    setImageIconSize                        ,


-- ** paintable #attr:paintable#
-- | The @GdkPaintable@ to display.

#if defined(ENABLE_OVERLOADING)
    ImagePaintablePropertyInfo              ,
#endif
    clearImagePaintable                     ,
    constructImagePaintable                 ,
    getImagePaintable                       ,
#if defined(ENABLE_OVERLOADING)
    imagePaintable                          ,
#endif
    setImagePaintable                       ,


-- ** pixelSize #attr:pixelSize#
-- | The size in pixels to display icons at.
-- 
-- If set to a value != -1, this property overrides the
-- [Image:iconSize]("GI.Gtk.Objects.Image#g:attr:iconSize") property for images of type
-- @GTK_IMAGE_ICON_NAME@.

#if defined(ENABLE_OVERLOADING)
    ImagePixelSizePropertyInfo              ,
#endif
    constructImagePixelSize                 ,
    getImagePixelSize                       ,
#if defined(ENABLE_OVERLOADING)
    imagePixelSize                          ,
#endif
    setImagePixelSize                       ,


-- ** resource #attr:resource#
-- | A path to a resource file to display.

#if defined(ENABLE_OVERLOADING)
    ImageResourcePropertyInfo               ,
#endif
    clearImageResource                      ,
    constructImageResource                  ,
    getImageResource                        ,
#if defined(ENABLE_OVERLOADING)
    imageResource                           ,
#endif
    setImageResource                        ,


-- ** storageType #attr:storageType#
-- | The representation being used for image data.

#if defined(ENABLE_OVERLOADING)
    ImageStorageTypePropertyInfo            ,
#endif
    getImageStorageType                     ,
#if defined(ENABLE_OVERLOADING)
    imageStorageType                        ,
#endif


-- ** useFallback #attr:useFallback#
-- | Whether the icon displayed in the @GtkImage@ will use
-- standard icon names fallback.
-- 
-- The value of this property is only relevant for images of type
-- 'GI.Gtk.Enums.ImageTypeIconName' and 'GI.Gtk.Enums.ImageTypeGicon'.

#if defined(ENABLE_OVERLOADING)
    ImageUseFallbackPropertyInfo            ,
#endif
    constructImageUseFallback               ,
    getImageUseFallback                     ,
#if defined(ENABLE_OVERLOADING)
    imageUseFallback                        ,
#endif
    setImageUseFallback                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype Image = Image (SP.ManagedPtr Image)
    deriving (Eq)

instance SP.ManagedPtrNewtype Image where
    toManagedPtr (Image p) = p

foreign import ccall "gtk_image_get_type"
    c_gtk_image_get_type :: IO B.Types.GType

instance B.Types.TypedObject Image where
    glibType = c_gtk_image_get_type

instance B.Types.GObject Image

-- | Type class for types which can be safely cast to t'Image', for instance with `toImage`.
class (SP.GObject o, O.IsDescendantOf Image o) => IsImage o
instance (SP.GObject o, O.IsDescendantOf Image o) => IsImage o

instance O.HasParentTypes Image
type instance O.ParentTypes Image = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'Image', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toImage :: (MIO.MonadIO m, IsImage o) => o -> m Image
toImage = MIO.liftIO . B.ManagedPtr.unsafeCastTo Image

-- | Convert t'Image' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Image) where
    gvalueGType_ = c_gtk_image_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Image)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Image)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Image ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveImageMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveImageMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveImageMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveImageMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveImageMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveImageMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveImageMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveImageMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveImageMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveImageMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveImageMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveImageMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveImageMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveImageMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveImageMethod "clear" o = ImageClearMethodInfo
    ResolveImageMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveImageMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveImageMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveImageMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveImageMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveImageMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveImageMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveImageMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveImageMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveImageMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveImageMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveImageMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveImageMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveImageMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveImageMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveImageMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveImageMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveImageMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveImageMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveImageMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveImageMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveImageMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveImageMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveImageMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveImageMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveImageMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveImageMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveImageMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveImageMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveImageMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveImageMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveImageMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveImageMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveImageMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveImageMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveImageMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveImageMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveImageMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveImageMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveImageMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveImageMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveImageMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveImageMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveImageMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveImageMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveImageMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveImageMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveImageMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveImageMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveImageMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveImageMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveImageMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveImageMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveImageMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveImageMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveImageMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveImageMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveImageMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveImageMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveImageMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveImageMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveImageMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveImageMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveImageMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveImageMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveImageMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveImageMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveImageMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveImageMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveImageMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveImageMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveImageMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveImageMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveImageMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveImageMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveImageMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveImageMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveImageMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveImageMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveImageMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveImageMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveImageMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveImageMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveImageMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveImageMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveImageMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveImageMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveImageMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveImageMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveImageMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveImageMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveImageMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveImageMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveImageMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveImageMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveImageMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveImageMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveImageMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveImageMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveImageMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveImageMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveImageMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveImageMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveImageMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveImageMethod "getGicon" o = ImageGetGiconMethodInfo
    ResolveImageMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveImageMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveImageMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveImageMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveImageMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveImageMethod "getIconName" o = ImageGetIconNameMethodInfo
    ResolveImageMethod "getIconSize" o = ImageGetIconSizeMethodInfo
    ResolveImageMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveImageMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveImageMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveImageMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveImageMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveImageMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveImageMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveImageMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveImageMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveImageMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveImageMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveImageMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveImageMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveImageMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveImageMethod "getPaintable" o = ImageGetPaintableMethodInfo
    ResolveImageMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveImageMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveImageMethod "getPixelSize" o = ImageGetPixelSizeMethodInfo
    ResolveImageMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveImageMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveImageMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveImageMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveImageMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveImageMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveImageMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveImageMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveImageMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveImageMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveImageMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveImageMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveImageMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveImageMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveImageMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveImageMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveImageMethod "getStorageType" o = ImageGetStorageTypeMethodInfo
    ResolveImageMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveImageMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveImageMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveImageMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveImageMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveImageMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveImageMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveImageMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveImageMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveImageMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveImageMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveImageMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveImageMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveImageMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveImageMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveImageMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveImageMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveImageMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveImageMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveImageMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveImageMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveImageMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveImageMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveImageMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveImageMethod "setFromFile" o = ImageSetFromFileMethodInfo
    ResolveImageMethod "setFromGicon" o = ImageSetFromGiconMethodInfo
    ResolveImageMethod "setFromIconName" o = ImageSetFromIconNameMethodInfo
    ResolveImageMethod "setFromPaintable" o = ImageSetFromPaintableMethodInfo
    ResolveImageMethod "setFromPixbuf" o = ImageSetFromPixbufMethodInfo
    ResolveImageMethod "setFromResource" o = ImageSetFromResourceMethodInfo
    ResolveImageMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveImageMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveImageMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveImageMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveImageMethod "setIconSize" o = ImageSetIconSizeMethodInfo
    ResolveImageMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveImageMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveImageMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveImageMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveImageMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveImageMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveImageMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveImageMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveImageMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveImageMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveImageMethod "setPixelSize" o = ImageSetPixelSizeMethodInfo
    ResolveImageMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveImageMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveImageMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveImageMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveImageMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveImageMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveImageMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveImageMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveImageMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveImageMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveImageMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveImageMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveImageMethod t Image, O.OverloadedMethod info Image p) => OL.IsLabel t (Image -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveImageMethod t Image, O.OverloadedMethod info Image p, R.HasField t Image p) => R.HasField t Image p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveImageMethod t Image, O.OverloadedMethodInfo info Image) => OL.IsLabel t (O.MethodProxy info Image) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "file"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@file@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' image #file
-- @
getImageFile :: (MonadIO m, IsImage o) => o -> m (Maybe T.Text)
getImageFile obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "file"

-- | Set the value of the “@file@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' image [ #file 'Data.GI.Base.Attributes.:=' value ]
-- @
setImageFile :: (MonadIO m, IsImage o) => o -> T.Text -> m ()
setImageFile obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "file" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@file@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructImageFile :: (IsImage o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructImageFile val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "file" (P.Just val)

-- | Set the value of the “@file@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #file
-- @
clearImageFile :: (MonadIO m, IsImage o) => o -> m ()
clearImageFile obj = liftIO $ B.Properties.setObjectPropertyString obj "file" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data ImageFilePropertyInfo
instance AttrInfo ImageFilePropertyInfo where
    type AttrAllowedOps ImageFilePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ImageFilePropertyInfo = IsImage
    type AttrSetTypeConstraint ImageFilePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ImageFilePropertyInfo = (~) T.Text
    type AttrTransferType ImageFilePropertyInfo = T.Text
    type AttrGetType ImageFilePropertyInfo = (Maybe T.Text)
    type AttrLabel ImageFilePropertyInfo = "file"
    type AttrOrigin ImageFilePropertyInfo = Image
    attrGet = getImageFile
    attrSet = setImageFile
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructImageFile
    attrClear = clearImageFile
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.file"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#g:attr:file"
        })
#endif

-- VVV Prop "gicon"
   -- Type: TInterface (Name {namespace = "Gio", name = "Icon"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@gicon@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' image #gicon
-- @
getImageGicon :: (MonadIO m, IsImage o) => o -> m (Maybe Gio.Icon.Icon)
getImageGicon obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "gicon" Gio.Icon.Icon

-- | Set the value of the “@gicon@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' image [ #gicon 'Data.GI.Base.Attributes.:=' value ]
-- @
setImageGicon :: (MonadIO m, IsImage o, Gio.Icon.IsIcon a) => o -> a -> m ()
setImageGicon obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "gicon" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@gicon@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructImageGicon :: (IsImage o, MIO.MonadIO m, Gio.Icon.IsIcon a) => a -> m (GValueConstruct o)
constructImageGicon val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "gicon" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ImageGiconPropertyInfo
instance AttrInfo ImageGiconPropertyInfo where
    type AttrAllowedOps ImageGiconPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ImageGiconPropertyInfo = IsImage
    type AttrSetTypeConstraint ImageGiconPropertyInfo = Gio.Icon.IsIcon
    type AttrTransferTypeConstraint ImageGiconPropertyInfo = Gio.Icon.IsIcon
    type AttrTransferType ImageGiconPropertyInfo = Gio.Icon.Icon
    type AttrGetType ImageGiconPropertyInfo = (Maybe Gio.Icon.Icon)
    type AttrLabel ImageGiconPropertyInfo = "gicon"
    type AttrOrigin ImageGiconPropertyInfo = Image
    attrGet = getImageGicon
    attrSet = setImageGicon
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.Icon.Icon v
    attrConstruct = constructImageGicon
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.gicon"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#g:attr:gicon"
        })
#endif

-- VVV Prop "icon-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@icon-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' image #iconName
-- @
getImageIconName :: (MonadIO m, IsImage o) => o -> m (Maybe T.Text)
getImageIconName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "icon-name"

-- | Set the value of the “@icon-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' image [ #iconName 'Data.GI.Base.Attributes.:=' value ]
-- @
setImageIconName :: (MonadIO m, IsImage o) => o -> T.Text -> m ()
setImageIconName obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "icon-name" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@icon-name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructImageIconName :: (IsImage o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructImageIconName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "icon-name" (P.Just val)

-- | Set the value of the “@icon-name@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #iconName
-- @
clearImageIconName :: (MonadIO m, IsImage o) => o -> m ()
clearImageIconName obj = liftIO $ B.Properties.setObjectPropertyString obj "icon-name" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data ImageIconNamePropertyInfo
instance AttrInfo ImageIconNamePropertyInfo where
    type AttrAllowedOps ImageIconNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ImageIconNamePropertyInfo = IsImage
    type AttrSetTypeConstraint ImageIconNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ImageIconNamePropertyInfo = (~) T.Text
    type AttrTransferType ImageIconNamePropertyInfo = T.Text
    type AttrGetType ImageIconNamePropertyInfo = (Maybe T.Text)
    type AttrLabel ImageIconNamePropertyInfo = "icon-name"
    type AttrOrigin ImageIconNamePropertyInfo = Image
    attrGet = getImageIconName
    attrSet = setImageIconName
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructImageIconName
    attrClear = clearImageIconName
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.iconName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#g:attr:iconName"
        })
#endif

-- VVV Prop "icon-size"
   -- Type: TInterface (Name {namespace = "Gtk", name = "IconSize"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@icon-size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' image #iconSize
-- @
getImageIconSize :: (MonadIO m, IsImage o) => o -> m Gtk.Enums.IconSize
getImageIconSize obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "icon-size"

-- | Set the value of the “@icon-size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' image [ #iconSize 'Data.GI.Base.Attributes.:=' value ]
-- @
setImageIconSize :: (MonadIO m, IsImage o) => o -> Gtk.Enums.IconSize -> m ()
setImageIconSize obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "icon-size" val

-- | Construct a t'GValueConstruct' with valid value for the “@icon-size@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructImageIconSize :: (IsImage o, MIO.MonadIO m) => Gtk.Enums.IconSize -> m (GValueConstruct o)
constructImageIconSize val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "icon-size" val

#if defined(ENABLE_OVERLOADING)
data ImageIconSizePropertyInfo
instance AttrInfo ImageIconSizePropertyInfo where
    type AttrAllowedOps ImageIconSizePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ImageIconSizePropertyInfo = IsImage
    type AttrSetTypeConstraint ImageIconSizePropertyInfo = (~) Gtk.Enums.IconSize
    type AttrTransferTypeConstraint ImageIconSizePropertyInfo = (~) Gtk.Enums.IconSize
    type AttrTransferType ImageIconSizePropertyInfo = Gtk.Enums.IconSize
    type AttrGetType ImageIconSizePropertyInfo = Gtk.Enums.IconSize
    type AttrLabel ImageIconSizePropertyInfo = "icon-size"
    type AttrOrigin ImageIconSizePropertyInfo = Image
    attrGet = getImageIconSize
    attrSet = setImageIconSize
    attrPut = setImageIconSize
    attrTransfer _ v = do
        return v
    attrConstruct = constructImageIconSize
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.iconSize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#g:attr:iconSize"
        })
#endif

-- VVV Prop "paintable"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Paintable"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@paintable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' image #paintable
-- @
getImagePaintable :: (MonadIO m, IsImage o) => o -> m (Maybe Gdk.Paintable.Paintable)
getImagePaintable obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "paintable" Gdk.Paintable.Paintable

-- | Set the value of the “@paintable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' image [ #paintable 'Data.GI.Base.Attributes.:=' value ]
-- @
setImagePaintable :: (MonadIO m, IsImage o, Gdk.Paintable.IsPaintable a) => o -> a -> m ()
setImagePaintable obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "paintable" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@paintable@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructImagePaintable :: (IsImage o, MIO.MonadIO m, Gdk.Paintable.IsPaintable a) => a -> m (GValueConstruct o)
constructImagePaintable val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "paintable" (P.Just val)

-- | Set the value of the “@paintable@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #paintable
-- @
clearImagePaintable :: (MonadIO m, IsImage o) => o -> m ()
clearImagePaintable obj = liftIO $ B.Properties.setObjectPropertyObject obj "paintable" (Nothing :: Maybe Gdk.Paintable.Paintable)

#if defined(ENABLE_OVERLOADING)
data ImagePaintablePropertyInfo
instance AttrInfo ImagePaintablePropertyInfo where
    type AttrAllowedOps ImagePaintablePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ImagePaintablePropertyInfo = IsImage
    type AttrSetTypeConstraint ImagePaintablePropertyInfo = Gdk.Paintable.IsPaintable
    type AttrTransferTypeConstraint ImagePaintablePropertyInfo = Gdk.Paintable.IsPaintable
    type AttrTransferType ImagePaintablePropertyInfo = Gdk.Paintable.Paintable
    type AttrGetType ImagePaintablePropertyInfo = (Maybe Gdk.Paintable.Paintable)
    type AttrLabel ImagePaintablePropertyInfo = "paintable"
    type AttrOrigin ImagePaintablePropertyInfo = Image
    attrGet = getImagePaintable
    attrSet = setImagePaintable
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Paintable.Paintable v
    attrConstruct = constructImagePaintable
    attrClear = clearImagePaintable
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.paintable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#g:attr:paintable"
        })
#endif

-- VVV Prop "pixel-size"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@pixel-size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' image #pixelSize
-- @
getImagePixelSize :: (MonadIO m, IsImage o) => o -> m Int32
getImagePixelSize obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "pixel-size"

-- | Set the value of the “@pixel-size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' image [ #pixelSize 'Data.GI.Base.Attributes.:=' value ]
-- @
setImagePixelSize :: (MonadIO m, IsImage o) => o -> Int32 -> m ()
setImagePixelSize obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "pixel-size" val

-- | Construct a t'GValueConstruct' with valid value for the “@pixel-size@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructImagePixelSize :: (IsImage o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructImagePixelSize val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "pixel-size" val

#if defined(ENABLE_OVERLOADING)
data ImagePixelSizePropertyInfo
instance AttrInfo ImagePixelSizePropertyInfo where
    type AttrAllowedOps ImagePixelSizePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ImagePixelSizePropertyInfo = IsImage
    type AttrSetTypeConstraint ImagePixelSizePropertyInfo = (~) Int32
    type AttrTransferTypeConstraint ImagePixelSizePropertyInfo = (~) Int32
    type AttrTransferType ImagePixelSizePropertyInfo = Int32
    type AttrGetType ImagePixelSizePropertyInfo = Int32
    type AttrLabel ImagePixelSizePropertyInfo = "pixel-size"
    type AttrOrigin ImagePixelSizePropertyInfo = Image
    attrGet = getImagePixelSize
    attrSet = setImagePixelSize
    attrPut = setImagePixelSize
    attrTransfer _ v = do
        return v
    attrConstruct = constructImagePixelSize
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.pixelSize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#g:attr:pixelSize"
        })
#endif

-- VVV Prop "resource"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@resource@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' image #resource
-- @
getImageResource :: (MonadIO m, IsImage o) => o -> m (Maybe T.Text)
getImageResource obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "resource"

-- | Set the value of the “@resource@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' image [ #resource 'Data.GI.Base.Attributes.:=' value ]
-- @
setImageResource :: (MonadIO m, IsImage o) => o -> T.Text -> m ()
setImageResource obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "resource" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@resource@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructImageResource :: (IsImage o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructImageResource val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "resource" (P.Just val)

-- | Set the value of the “@resource@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #resource
-- @
clearImageResource :: (MonadIO m, IsImage o) => o -> m ()
clearImageResource obj = liftIO $ B.Properties.setObjectPropertyString obj "resource" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data ImageResourcePropertyInfo
instance AttrInfo ImageResourcePropertyInfo where
    type AttrAllowedOps ImageResourcePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ImageResourcePropertyInfo = IsImage
    type AttrSetTypeConstraint ImageResourcePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ImageResourcePropertyInfo = (~) T.Text
    type AttrTransferType ImageResourcePropertyInfo = T.Text
    type AttrGetType ImageResourcePropertyInfo = (Maybe T.Text)
    type AttrLabel ImageResourcePropertyInfo = "resource"
    type AttrOrigin ImageResourcePropertyInfo = Image
    attrGet = getImageResource
    attrSet = setImageResource
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructImageResource
    attrClear = clearImageResource
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.resource"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#g:attr:resource"
        })
#endif

-- VVV Prop "storage-type"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ImageType"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@storage-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' image #storageType
-- @
getImageStorageType :: (MonadIO m, IsImage o) => o -> m Gtk.Enums.ImageType
getImageStorageType obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "storage-type"

#if defined(ENABLE_OVERLOADING)
data ImageStorageTypePropertyInfo
instance AttrInfo ImageStorageTypePropertyInfo where
    type AttrAllowedOps ImageStorageTypePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint ImageStorageTypePropertyInfo = IsImage
    type AttrSetTypeConstraint ImageStorageTypePropertyInfo = (~) ()
    type AttrTransferTypeConstraint ImageStorageTypePropertyInfo = (~) ()
    type AttrTransferType ImageStorageTypePropertyInfo = ()
    type AttrGetType ImageStorageTypePropertyInfo = Gtk.Enums.ImageType
    type AttrLabel ImageStorageTypePropertyInfo = "storage-type"
    type AttrOrigin ImageStorageTypePropertyInfo = Image
    attrGet = getImageStorageType
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.storageType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#g:attr:storageType"
        })
#endif

-- VVV Prop "use-fallback"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@use-fallback@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' image #useFallback
-- @
getImageUseFallback :: (MonadIO m, IsImage o) => o -> m Bool
getImageUseFallback obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "use-fallback"

-- | Set the value of the “@use-fallback@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' image [ #useFallback 'Data.GI.Base.Attributes.:=' value ]
-- @
setImageUseFallback :: (MonadIO m, IsImage o) => o -> Bool -> m ()
setImageUseFallback obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "use-fallback" val

-- | Construct a t'GValueConstruct' with valid value for the “@use-fallback@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructImageUseFallback :: (IsImage o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructImageUseFallback val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "use-fallback" val

#if defined(ENABLE_OVERLOADING)
data ImageUseFallbackPropertyInfo
instance AttrInfo ImageUseFallbackPropertyInfo where
    type AttrAllowedOps ImageUseFallbackPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ImageUseFallbackPropertyInfo = IsImage
    type AttrSetTypeConstraint ImageUseFallbackPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ImageUseFallbackPropertyInfo = (~) Bool
    type AttrTransferType ImageUseFallbackPropertyInfo = Bool
    type AttrGetType ImageUseFallbackPropertyInfo = Bool
    type AttrLabel ImageUseFallbackPropertyInfo = "use-fallback"
    type AttrOrigin ImageUseFallbackPropertyInfo = Image
    attrGet = getImageUseFallback
    attrSet = setImageUseFallback
    attrPut = setImageUseFallback
    attrTransfer _ v = do
        return v
    attrConstruct = constructImageUseFallback
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.useFallback"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#g:attr:useFallback"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Image
type instance O.AttributeList Image = ImageAttributeList
type ImageAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("file", ImageFilePropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("gicon", ImageGiconPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("iconName", ImageIconNamePropertyInfo), '("iconSize", ImageIconSizePropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("paintable", ImagePaintablePropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("pixelSize", ImagePixelSizePropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("resource", ImageResourcePropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("storageType", ImageStorageTypePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("useFallback", ImageUseFallbackPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
imageFile :: AttrLabelProxy "file"
imageFile = AttrLabelProxy

imageGicon :: AttrLabelProxy "gicon"
imageGicon = AttrLabelProxy

imageIconName :: AttrLabelProxy "iconName"
imageIconName = AttrLabelProxy

imageIconSize :: AttrLabelProxy "iconSize"
imageIconSize = AttrLabelProxy

imagePaintable :: AttrLabelProxy "paintable"
imagePaintable = AttrLabelProxy

imagePixelSize :: AttrLabelProxy "pixelSize"
imagePixelSize = AttrLabelProxy

imageResource :: AttrLabelProxy "resource"
imageResource = AttrLabelProxy

imageStorageType :: AttrLabelProxy "storageType"
imageStorageType = AttrLabelProxy

imageUseFallback :: AttrLabelProxy "useFallback"
imageUseFallback = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Image = ImageSignalList
type ImageSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Image::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Image" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_new" gtk_image_new :: 
    IO (Ptr Image)

-- | Creates a new empty @GtkImage@ widget.
imageNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Image
    -- ^ __Returns:__ a newly created @GtkImage@ widget.
imageNew  = liftIO $ do
    result <- gtk_image_new
    checkUnexpectedReturnNULL "imageNew" result
    result' <- (newObject Image) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Image::new_from_file
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a filename" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Image" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_new_from_file" gtk_image_new_from_file :: 
    CString ->                              -- filename : TBasicType TFileName
    IO (Ptr Image)

-- | Creates a new @GtkImage@ displaying the file /@filename@/.
-- 
-- If the file isn’t found or can’t be loaded, the resulting @GtkImage@
-- will display a “broken image” icon. This function never returns 'P.Nothing',
-- it always returns a valid @GtkImage@ widget.
-- 
-- If you need to detect failures to load the file, use an
-- image loading framework such as libglycin to load the file
-- yourself, then create the @GtkImage@ from the texture.
-- 
-- The storage type (see 'GI.Gtk.Objects.Image.imageGetStorageType')
-- of the returned image is not defined, it will be whatever
-- is appropriate for displaying the file.
imageNewFromFile ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: a filename
    -> m Image
    -- ^ __Returns:__ a new @GtkImage@
imageNewFromFile filename = liftIO $ do
    filename' <- stringToCString filename
    result <- gtk_image_new_from_file filename'
    checkUnexpectedReturnNULL "imageNewFromFile" result
    result' <- (newObject Image) result
    freeMem filename'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Image::new_from_gicon
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "icon"
--           , argType = TInterface Name { namespace = "Gio" , name = "Icon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an icon" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Image" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_new_from_gicon" gtk_image_new_from_gicon :: 
    Ptr Gio.Icon.Icon ->                    -- icon : TInterface (Name {namespace = "Gio", name = "Icon"})
    IO (Ptr Image)

-- | Creates a @GtkImage@ displaying an icon from the current icon theme.
-- 
-- If the icon name isn’t known, a “broken image” icon will be
-- displayed instead. If the current icon theme is changed, the icon
-- will be updated appropriately.
imageNewFromGicon ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Icon.IsIcon a) =>
    a
    -- ^ /@icon@/: an icon
    -> m Image
    -- ^ __Returns:__ a new @GtkImage@ displaying the themed icon
imageNewFromGicon icon = liftIO $ do
    icon' <- unsafeManagedPtrCastPtr icon
    result <- gtk_image_new_from_gicon icon'
    checkUnexpectedReturnNULL "imageNewFromGicon" result
    result' <- (newObject Image) result
    touchManagedPtr icon
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Image::new_from_icon_name
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "icon_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an icon name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Image" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_new_from_icon_name" gtk_image_new_from_icon_name :: 
    CString ->                              -- icon_name : TBasicType TUTF8
    IO (Ptr Image)

-- | Creates a @GtkImage@ displaying an icon from the current icon theme.
-- 
-- If the icon name isn’t known, a “broken image” icon will be
-- displayed instead. If the current icon theme is changed, the icon
-- will be updated appropriately.
imageNewFromIconName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@iconName@/: an icon name
    -> m Image
    -- ^ __Returns:__ a new @GtkImage@ displaying the themed icon
imageNewFromIconName iconName = liftIO $ do
    maybeIconName <- case iconName of
        Nothing -> return FP.nullPtr
        Just jIconName -> do
            jIconName' <- textToCString jIconName
            return jIconName'
    result <- gtk_image_new_from_icon_name maybeIconName
    checkUnexpectedReturnNULL "imageNewFromIconName" result
    result' <- (newObject Image) result
    freeMem maybeIconName
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Image::new_from_paintable
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "paintable"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Paintable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPaintable`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Image" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_new_from_paintable" gtk_image_new_from_paintable :: 
    Ptr Gdk.Paintable.Paintable ->          -- paintable : TInterface (Name {namespace = "Gdk", name = "Paintable"})
    IO (Ptr Image)

-- | Creates a new @GtkImage@ displaying /@paintable@/.
-- 
-- The @GtkImage@ does not assume a reference to the paintable; you still
-- need to unref it if you own references. @GtkImage@ will add its own
-- reference rather than adopting yours.
-- 
-- The @GtkImage@ will track changes to the /@paintable@/ and update
-- its size and contents in response to it.
-- 
-- Note that paintables are still subject to the icon size that is
-- set on the image. If you want to display a paintable at its intrinsic
-- size, use t'GI.Gtk.Objects.Picture.Picture' instead.
-- 
-- If /@paintable@/ is a t'GI.Gtk.Interfaces.SymbolicPaintable.SymbolicPaintable', then it will be
-- recolored with the symbolic palette from the theme.
imageNewFromPaintable ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Paintable.IsPaintable a) =>
    Maybe (a)
    -- ^ /@paintable@/: a @GdkPaintable@
    -> m Image
    -- ^ __Returns:__ a new @GtkImage@
imageNewFromPaintable paintable = liftIO $ do
    maybePaintable <- case paintable of
        Nothing -> return FP.nullPtr
        Just jPaintable -> do
            jPaintable' <- unsafeManagedPtrCastPtr jPaintable
            return jPaintable'
    result <- gtk_image_new_from_paintable maybePaintable
    checkUnexpectedReturnNULL "imageNewFromPaintable" result
    result' <- (newObject Image) result
    whenJust paintable touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Image::new_from_pixbuf
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "pixbuf"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPixbuf`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Image" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_new_from_pixbuf" gtk_image_new_from_pixbuf :: 
    Ptr GdkPixbuf.Pixbuf.Pixbuf ->          -- pixbuf : TInterface (Name {namespace = "GdkPixbuf", name = "Pixbuf"})
    IO (Ptr Image)

{-# DEPRECATED imageNewFromPixbuf ["(Since version 4.12)","Use 'GI.Gtk.Objects.Image.imageNewFromPaintable' and","  'GI.Gdk.Objects.Texture.textureNewForPixbuf' instead"] #-}
-- | Creates a new @GtkImage@ displaying /@pixbuf@/.
-- 
-- The @GtkImage@ does not assume a reference to the pixbuf; you still
-- need to unref it if you own references. @GtkImage@ will add its own
-- reference rather than adopting yours.
-- 
-- This is a helper for 'GI.Gtk.Objects.Image.imageNewFromPaintable', and you can\'t
-- get back the exact pixbuf once this is called, only a texture.
-- 
-- Note that this function just creates an @GtkImage@ from the pixbuf.
-- The @GtkImage@ created will not react to state changes. Should you
-- want that, you should use 'GI.Gtk.Objects.Image.imageNewFromIconName'.
imageNewFromPixbuf ::
    (B.CallStack.HasCallStack, MonadIO m, GdkPixbuf.Pixbuf.IsPixbuf a) =>
    Maybe (a)
    -- ^ /@pixbuf@/: a @GdkPixbuf@
    -> m Image
    -- ^ __Returns:__ a new @GtkImage@
imageNewFromPixbuf pixbuf = liftIO $ do
    maybePixbuf <- case pixbuf of
        Nothing -> return FP.nullPtr
        Just jPixbuf -> do
            jPixbuf' <- unsafeManagedPtrCastPtr jPixbuf
            return jPixbuf'
    result <- gtk_image_new_from_pixbuf maybePixbuf
    checkUnexpectedReturnNULL "imageNewFromPixbuf" result
    result' <- (newObject Image) result
    whenJust pixbuf touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Image::new_from_resource
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "resource_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a resource path" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Image" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_new_from_resource" gtk_image_new_from_resource :: 
    CString ->                              -- resource_path : TBasicType TUTF8
    IO (Ptr Image)

-- | Creates a new @GtkImage@ displaying the resource file /@resourcePath@/.
-- 
-- If the file isn’t found or can’t be loaded, the resulting @GtkImage@ will
-- display a “broken image” icon. This function never returns 'P.Nothing',
-- it always returns a valid @GtkImage@ widget.
-- 
-- If you need to detect failures to load the file, use an
-- image loading framework such as libglycin to load the file
-- yourself, then create the @GtkImage@ from the texture.
-- 
-- The storage type (see 'GI.Gtk.Objects.Image.imageGetStorageType') of
-- the returned image is not defined, it will be whatever is
-- appropriate for displaying the file.
imageNewFromResource ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@resourcePath@/: a resource path
    -> m Image
    -- ^ __Returns:__ a new @GtkImage@
imageNewFromResource resourcePath = liftIO $ do
    resourcePath' <- textToCString resourcePath
    result <- gtk_image_new_from_resource resourcePath'
    checkUnexpectedReturnNULL "imageNewFromResource" result
    result' <- (newObject Image) result
    freeMem resourcePath'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Image::clear
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkImage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_clear" gtk_image_clear :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Gtk", name = "Image"})
    IO ()

-- | Resets the image to be empty.
imageClear ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a) =>
    a
    -- ^ /@image@/: a @GtkImage@
    -> m ()
imageClear image = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    gtk_image_clear image'
    touchManagedPtr image
    return ()

#if defined(ENABLE_OVERLOADING)
data ImageClearMethodInfo
instance (signature ~ (m ()), MonadIO m, IsImage a) => O.OverloadedMethod ImageClearMethodInfo a signature where
    overloadedMethod = imageClear

instance O.OverloadedMethodInfo ImageClearMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.imageClear",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#v:imageClear"
        })


#endif

-- method Image::get_gicon
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkImage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Icon" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_get_gicon" gtk_image_get_gicon :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Gtk", name = "Image"})
    IO (Ptr Gio.Icon.Icon)

-- | Gets the @GIcon@ being displayed by the @GtkImage@.
-- 
-- The storage type of the image must be 'GI.Gtk.Enums.ImageTypeEmpty' or
-- 'GI.Gtk.Enums.ImageTypeGicon' (see 'GI.Gtk.Objects.Image.imageGetStorageType').
-- The caller of this function does not own a reference to the
-- returned @GIcon@.
imageGetGicon ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a) =>
    a
    -- ^ /@image@/: a @GtkImage@
    -> m (Maybe Gio.Icon.Icon)
    -- ^ __Returns:__ a @GIcon@
imageGetGicon image = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    result <- gtk_image_get_gicon image'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.Icon.Icon) result'
        return result''
    touchManagedPtr image
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ImageGetGiconMethodInfo
instance (signature ~ (m (Maybe Gio.Icon.Icon)), MonadIO m, IsImage a) => O.OverloadedMethod ImageGetGiconMethodInfo a signature where
    overloadedMethod = imageGetGicon

instance O.OverloadedMethodInfo ImageGetGiconMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.imageGetGicon",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#v:imageGetGicon"
        })


#endif

-- method Image::get_icon_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkImage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_get_icon_name" gtk_image_get_icon_name :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Gtk", name = "Image"})
    IO CString

-- | Gets the icon name and size being displayed by the @GtkImage@.
-- 
-- The storage type of the image must be 'GI.Gtk.Enums.ImageTypeEmpty' or
-- 'GI.Gtk.Enums.ImageTypeIconName' (see 'GI.Gtk.Objects.Image.imageGetStorageType').
-- The returned string is owned by the @GtkImage@ and should not
-- be freed.
imageGetIconName ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a) =>
    a
    -- ^ /@image@/: a @GtkImage@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the icon name
imageGetIconName image = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    result <- gtk_image_get_icon_name image'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr image
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ImageGetIconNameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsImage a) => O.OverloadedMethod ImageGetIconNameMethodInfo a signature where
    overloadedMethod = imageGetIconName

instance O.OverloadedMethodInfo ImageGetIconNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.imageGetIconName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#v:imageGetIconName"
        })


#endif

-- method Image::get_icon_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkImage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "IconSize" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_get_icon_size" gtk_image_get_icon_size :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Gtk", name = "Image"})
    IO CUInt

-- | Gets the icon size used by the /@image@/ when rendering icons.
imageGetIconSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a) =>
    a
    -- ^ /@image@/: a @GtkImage@
    -> m Gtk.Enums.IconSize
    -- ^ __Returns:__ the image size used by icons
imageGetIconSize image = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    result <- gtk_image_get_icon_size image'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr image
    return result'

#if defined(ENABLE_OVERLOADING)
data ImageGetIconSizeMethodInfo
instance (signature ~ (m Gtk.Enums.IconSize), MonadIO m, IsImage a) => O.OverloadedMethod ImageGetIconSizeMethodInfo a signature where
    overloadedMethod = imageGetIconSize

instance O.OverloadedMethodInfo ImageGetIconSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.imageGetIconSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#v:imageGetIconSize"
        })


#endif

-- method Image::get_paintable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkImage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Paintable" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_get_paintable" gtk_image_get_paintable :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Gtk", name = "Image"})
    IO (Ptr Gdk.Paintable.Paintable)

-- | Gets the image @GdkPaintable@ being displayed by the @GtkImage@.
-- 
-- The storage type of the image must be 'GI.Gtk.Enums.ImageTypeEmpty' or
-- 'GI.Gtk.Enums.ImageTypePaintable' (see 'GI.Gtk.Objects.Image.imageGetStorageType').
-- The caller of this function does not own a reference to the
-- returned paintable.
imageGetPaintable ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a) =>
    a
    -- ^ /@image@/: a @GtkImage@
    -> m (Maybe Gdk.Paintable.Paintable)
    -- ^ __Returns:__ the displayed paintable
imageGetPaintable image = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    result <- gtk_image_get_paintable image'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Paintable.Paintable) result'
        return result''
    touchManagedPtr image
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ImageGetPaintableMethodInfo
instance (signature ~ (m (Maybe Gdk.Paintable.Paintable)), MonadIO m, IsImage a) => O.OverloadedMethod ImageGetPaintableMethodInfo a signature where
    overloadedMethod = imageGetPaintable

instance O.OverloadedMethodInfo ImageGetPaintableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.imageGetPaintable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#v:imageGetPaintable"
        })


#endif

-- method Image::get_pixel_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkImage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_get_pixel_size" gtk_image_get_pixel_size :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Gtk", name = "Image"})
    IO Int32

-- | Gets the pixel size used for named icons.
imageGetPixelSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a) =>
    a
    -- ^ /@image@/: a @GtkImage@
    -> m Int32
    -- ^ __Returns:__ the pixel size used for named icons.
imageGetPixelSize image = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    result <- gtk_image_get_pixel_size image'
    touchManagedPtr image
    return result

#if defined(ENABLE_OVERLOADING)
data ImageGetPixelSizeMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsImage a) => O.OverloadedMethod ImageGetPixelSizeMethodInfo a signature where
    overloadedMethod = imageGetPixelSize

instance O.OverloadedMethodInfo ImageGetPixelSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.imageGetPixelSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#v:imageGetPixelSize"
        })


#endif

-- method Image::get_storage_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkImage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ImageType" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_get_storage_type" gtk_image_get_storage_type :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Gtk", name = "Image"})
    IO CUInt

-- | Gets the type of representation being used by the @GtkImage@
-- to store image data.
-- 
-- If the @GtkImage@ has no image data, the return value will
-- be 'GI.Gtk.Enums.ImageTypeEmpty'.
imageGetStorageType ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a) =>
    a
    -- ^ /@image@/: a @GtkImage@
    -> m Gtk.Enums.ImageType
    -- ^ __Returns:__ image representation being used
imageGetStorageType image = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    result <- gtk_image_get_storage_type image'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr image
    return result'

#if defined(ENABLE_OVERLOADING)
data ImageGetStorageTypeMethodInfo
instance (signature ~ (m Gtk.Enums.ImageType), MonadIO m, IsImage a) => O.OverloadedMethod ImageGetStorageTypeMethodInfo a signature where
    overloadedMethod = imageGetStorageType

instance O.OverloadedMethodInfo ImageGetStorageTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.imageGetStorageType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#v:imageGetStorageType"
        })


#endif

-- method Image::set_from_file
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkImage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a filename" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_set_from_file" gtk_image_set_from_file :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Gtk", name = "Image"})
    CString ->                              -- filename : TBasicType TFileName
    IO ()

-- | Sets a @GtkImage@ to show a file.
-- 
-- See 'GI.Gtk.Objects.Image.imageNewFromFile' for details.
-- 
-- ::: warning
--     Note that this function should not be used with untrusted data.
--     Use a proper image loading framework such as libglycin, which can
--     load many image formats into a @GdkTexture@, and then use
--     'GI.Gtk.Objects.Image.imageSetFromPaintable'.
imageSetFromFile ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a) =>
    a
    -- ^ /@image@/: a @GtkImage@
    -> Maybe ([Char])
    -- ^ /@filename@/: a filename
    -> m ()
imageSetFromFile image filename = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    maybeFilename <- case filename of
        Nothing -> return FP.nullPtr
        Just jFilename -> do
            jFilename' <- stringToCString jFilename
            return jFilename'
    gtk_image_set_from_file image' maybeFilename
    touchManagedPtr image
    freeMem maybeFilename
    return ()

#if defined(ENABLE_OVERLOADING)
data ImageSetFromFileMethodInfo
instance (signature ~ (Maybe ([Char]) -> m ()), MonadIO m, IsImage a) => O.OverloadedMethod ImageSetFromFileMethodInfo a signature where
    overloadedMethod = imageSetFromFile

instance O.OverloadedMethodInfo ImageSetFromFileMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.imageSetFromFile",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#v:imageSetFromFile"
        })


#endif

-- method Image::set_from_gicon
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkImage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "icon"
--           , argType = TInterface Name { namespace = "Gio" , name = "Icon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an icon" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_set_from_gicon" gtk_image_set_from_gicon :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Gtk", name = "Image"})
    Ptr Gio.Icon.Icon ->                    -- icon : TInterface (Name {namespace = "Gio", name = "Icon"})
    IO ()

-- | Sets a @GtkImage@ to show a @GIcon@.
-- 
-- See 'GI.Gtk.Objects.Image.imageNewFromGicon' for details.
imageSetFromGicon ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a, Gio.Icon.IsIcon b) =>
    a
    -- ^ /@image@/: a @GtkImage@
    -> b
    -- ^ /@icon@/: an icon
    -> m ()
imageSetFromGicon image icon = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    icon' <- unsafeManagedPtrCastPtr icon
    gtk_image_set_from_gicon image' icon'
    touchManagedPtr image
    touchManagedPtr icon
    return ()

#if defined(ENABLE_OVERLOADING)
data ImageSetFromGiconMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsImage a, Gio.Icon.IsIcon b) => O.OverloadedMethod ImageSetFromGiconMethodInfo a signature where
    overloadedMethod = imageSetFromGicon

instance O.OverloadedMethodInfo ImageSetFromGiconMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.imageSetFromGicon",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#v:imageSetFromGicon"
        })


#endif

-- method Image::set_from_icon_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkImage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "icon_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an icon name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_set_from_icon_name" gtk_image_set_from_icon_name :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Gtk", name = "Image"})
    CString ->                              -- icon_name : TBasicType TUTF8
    IO ()

-- | Sets a @GtkImage@ to show a named icon.
-- 
-- See 'GI.Gtk.Objects.Image.imageNewFromIconName' for details.
imageSetFromIconName ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a) =>
    a
    -- ^ /@image@/: a @GtkImage@
    -> Maybe (T.Text)
    -- ^ /@iconName@/: an icon name
    -> m ()
imageSetFromIconName image iconName = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    maybeIconName <- case iconName of
        Nothing -> return FP.nullPtr
        Just jIconName -> do
            jIconName' <- textToCString jIconName
            return jIconName'
    gtk_image_set_from_icon_name image' maybeIconName
    touchManagedPtr image
    freeMem maybeIconName
    return ()

#if defined(ENABLE_OVERLOADING)
data ImageSetFromIconNameMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsImage a) => O.OverloadedMethod ImageSetFromIconNameMethodInfo a signature where
    overloadedMethod = imageSetFromIconName

instance O.OverloadedMethodInfo ImageSetFromIconNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.imageSetFromIconName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#v:imageSetFromIconName"
        })


#endif

-- method Image::set_from_paintable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkImage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "paintable"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Paintable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPaintable`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_set_from_paintable" gtk_image_set_from_paintable :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Gtk", name = "Image"})
    Ptr Gdk.Paintable.Paintable ->          -- paintable : TInterface (Name {namespace = "Gdk", name = "Paintable"})
    IO ()

-- | Sets a @GtkImage@ to show a @GdkPaintable@.
-- 
-- See 'GI.Gtk.Objects.Image.imageNewFromPaintable' for details.
imageSetFromPaintable ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a, Gdk.Paintable.IsPaintable b) =>
    a
    -- ^ /@image@/: a @GtkImage@
    -> Maybe (b)
    -- ^ /@paintable@/: a @GdkPaintable@
    -> m ()
imageSetFromPaintable image paintable = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    maybePaintable <- case paintable of
        Nothing -> return FP.nullPtr
        Just jPaintable -> do
            jPaintable' <- unsafeManagedPtrCastPtr jPaintable
            return jPaintable'
    gtk_image_set_from_paintable image' maybePaintable
    touchManagedPtr image
    whenJust paintable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ImageSetFromPaintableMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsImage a, Gdk.Paintable.IsPaintable b) => O.OverloadedMethod ImageSetFromPaintableMethodInfo a signature where
    overloadedMethod = imageSetFromPaintable

instance O.OverloadedMethodInfo ImageSetFromPaintableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.imageSetFromPaintable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#v:imageSetFromPaintable"
        })


#endif

-- method Image::set_from_pixbuf
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkImage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pixbuf"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPixbuf` or `NULL`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_set_from_pixbuf" gtk_image_set_from_pixbuf :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Gtk", name = "Image"})
    Ptr GdkPixbuf.Pixbuf.Pixbuf ->          -- pixbuf : TInterface (Name {namespace = "GdkPixbuf", name = "Pixbuf"})
    IO ()

{-# DEPRECATED imageSetFromPixbuf ["(Since version 4.12)","Use 'GI.Gtk.Objects.Image.imageSetFromPaintable' instead"] #-}
-- | Sets a @GtkImage@ to show a @GdkPixbuf@.
-- 
-- See 'GI.Gtk.Objects.Image.imageNewFromPixbuf' for details.
-- 
-- Note: This is a helper for 'GI.Gtk.Objects.Image.imageSetFromPaintable',
-- and you can\'t get back the exact pixbuf once this is called,
-- only a paintable.
imageSetFromPixbuf ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a, GdkPixbuf.Pixbuf.IsPixbuf b) =>
    a
    -- ^ /@image@/: a @GtkImage@
    -> Maybe (b)
    -- ^ /@pixbuf@/: a @GdkPixbuf@ or @NULL@
    -> m ()
imageSetFromPixbuf image pixbuf = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    maybePixbuf <- case pixbuf of
        Nothing -> return FP.nullPtr
        Just jPixbuf -> do
            jPixbuf' <- unsafeManagedPtrCastPtr jPixbuf
            return jPixbuf'
    gtk_image_set_from_pixbuf image' maybePixbuf
    touchManagedPtr image
    whenJust pixbuf touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ImageSetFromPixbufMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsImage a, GdkPixbuf.Pixbuf.IsPixbuf b) => O.OverloadedMethod ImageSetFromPixbufMethodInfo a signature where
    overloadedMethod = imageSetFromPixbuf

instance O.OverloadedMethodInfo ImageSetFromPixbufMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.imageSetFromPixbuf",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#v:imageSetFromPixbuf"
        })


#endif

-- method Image::set_from_resource
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkImage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "resource_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a resource path" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_set_from_resource" gtk_image_set_from_resource :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Gtk", name = "Image"})
    CString ->                              -- resource_path : TBasicType TUTF8
    IO ()

-- | Sets a @GtkImage@ to show a resource.
-- 
-- See 'GI.Gtk.Objects.Image.imageNewFromResource' for details.
imageSetFromResource ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a) =>
    a
    -- ^ /@image@/: a @GtkImage@
    -> Maybe (T.Text)
    -- ^ /@resourcePath@/: a resource path
    -> m ()
imageSetFromResource image resourcePath = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    maybeResourcePath <- case resourcePath of
        Nothing -> return FP.nullPtr
        Just jResourcePath -> do
            jResourcePath' <- textToCString jResourcePath
            return jResourcePath'
    gtk_image_set_from_resource image' maybeResourcePath
    touchManagedPtr image
    freeMem maybeResourcePath
    return ()

#if defined(ENABLE_OVERLOADING)
data ImageSetFromResourceMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsImage a) => O.OverloadedMethod ImageSetFromResourceMethodInfo a signature where
    overloadedMethod = imageSetFromResource

instance O.OverloadedMethodInfo ImageSetFromResourceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.imageSetFromResource",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#v:imageSetFromResource"
        })


#endif

-- method Image::set_icon_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkImage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "icon_size"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IconSize" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new icon size" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_set_icon_size" gtk_image_set_icon_size :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Gtk", name = "Image"})
    CUInt ->                                -- icon_size : TInterface (Name {namespace = "Gtk", name = "IconSize"})
    IO ()

-- | Suggests an icon size to the theme for named icons.
imageSetIconSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a) =>
    a
    -- ^ /@image@/: a @GtkImage@
    -> Gtk.Enums.IconSize
    -- ^ /@iconSize@/: the new icon size
    -> m ()
imageSetIconSize image iconSize = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    let iconSize' = (fromIntegral . fromEnum) iconSize
    gtk_image_set_icon_size image' iconSize'
    touchManagedPtr image
    return ()

#if defined(ENABLE_OVERLOADING)
data ImageSetIconSizeMethodInfo
instance (signature ~ (Gtk.Enums.IconSize -> m ()), MonadIO m, IsImage a) => O.OverloadedMethod ImageSetIconSizeMethodInfo a signature where
    overloadedMethod = imageSetIconSize

instance O.OverloadedMethodInfo ImageSetIconSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.imageSetIconSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#v:imageSetIconSize"
        })


#endif

-- method Image::set_pixel_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "image"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Image" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkImage`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pixel_size"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new pixel size" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_image_set_pixel_size" gtk_image_set_pixel_size :: 
    Ptr Image ->                            -- image : TInterface (Name {namespace = "Gtk", name = "Image"})
    Int32 ->                                -- pixel_size : TBasicType TInt
    IO ()

-- | Sets the pixel size to use for named icons.
-- 
-- If the pixel size is set to a value != -1, it is used instead
-- of the icon size set by 'GI.Gtk.Objects.Image.imageSetIconSize'.
imageSetPixelSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsImage a) =>
    a
    -- ^ /@image@/: a @GtkImage@
    -> Int32
    -- ^ /@pixelSize@/: the new pixel size
    -> m ()
imageSetPixelSize image pixelSize = liftIO $ do
    image' <- unsafeManagedPtrCastPtr image
    gtk_image_set_pixel_size image' pixelSize
    touchManagedPtr image
    return ()

#if defined(ENABLE_OVERLOADING)
data ImageSetPixelSizeMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsImage a) => O.OverloadedMethod ImageSetPixelSizeMethodInfo a signature where
    overloadedMethod = imageSetPixelSize

instance O.OverloadedMethodInfo ImageSetPixelSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Image.imageSetPixelSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Image.html#v:imageSetPixelSize"
        })


#endif


