{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An interface that is used to implement shortcut scopes.
-- 
-- This is important for t'GI.Gtk.Interfaces.Native.Native' widgets that have their
-- own surface, since the event controllers that are used to implement
-- managed and global scopes are limited to the same native.
-- 
-- Examples for widgets implementing @GtkShortcutManager@ are
-- t'GI.Gtk.Objects.Window.Window' and t'GI.Gtk.Objects.Popover.Popover'.
-- 
-- Every widget that implements @GtkShortcutManager@ will be used as a
-- @GTK_SHORTCUT_SCOPE_MANAGED@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Interfaces.ShortcutManager
    ( 

-- * Exported types
    ShortcutManager(..)                     ,
    IsShortcutManager                       ,
    toShortcutManager                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveShortcutManagerMethod            ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- interface ShortcutManager 
-- | Memory-managed wrapper type.
newtype ShortcutManager = ShortcutManager (SP.ManagedPtr ShortcutManager)
    deriving (Eq)

instance SP.ManagedPtrNewtype ShortcutManager where
    toManagedPtr (ShortcutManager p) = p

foreign import ccall "gtk_shortcut_manager_get_type"
    c_gtk_shortcut_manager_get_type :: IO B.Types.GType

instance B.Types.TypedObject ShortcutManager where
    glibType = c_gtk_shortcut_manager_get_type

instance B.Types.GObject ShortcutManager

-- | Type class for types which can be safely cast to t'ShortcutManager', for instance with `toShortcutManager`.
class (SP.GObject o, O.IsDescendantOf ShortcutManager o) => IsShortcutManager o
instance (SP.GObject o, O.IsDescendantOf ShortcutManager o) => IsShortcutManager o

instance O.HasParentTypes ShortcutManager
type instance O.ParentTypes ShortcutManager = '[GObject.Object.Object]

-- | Cast to t'ShortcutManager', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toShortcutManager :: (MIO.MonadIO m, IsShortcutManager o) => o -> m ShortcutManager
toShortcutManager = MIO.liftIO . B.ManagedPtr.unsafeCastTo ShortcutManager

-- | Convert t'ShortcutManager' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ShortcutManager) where
    gvalueGType_ = c_gtk_shortcut_manager_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ShortcutManager)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ShortcutManager)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ShortcutManager ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ShortcutManager
type instance O.AttributeList ShortcutManager = ShortcutManagerAttributeList
type ShortcutManagerAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveShortcutManagerMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveShortcutManagerMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveShortcutManagerMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveShortcutManagerMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveShortcutManagerMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveShortcutManagerMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveShortcutManagerMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveShortcutManagerMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveShortcutManagerMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveShortcutManagerMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveShortcutManagerMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveShortcutManagerMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveShortcutManagerMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveShortcutManagerMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveShortcutManagerMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveShortcutManagerMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveShortcutManagerMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveShortcutManagerMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveShortcutManagerMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveShortcutManagerMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveShortcutManagerMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveShortcutManagerMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveShortcutManagerMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveShortcutManagerMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveShortcutManagerMethod t ShortcutManager, O.OverloadedMethod info ShortcutManager p) => OL.IsLabel t (ShortcutManager -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveShortcutManagerMethod t ShortcutManager, O.OverloadedMethod info ShortcutManager p, R.HasField t ShortcutManager p) => R.HasField t ShortcutManager p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveShortcutManagerMethod t ShortcutManager, O.OverloadedMethodInfo info ShortcutManager) => OL.IsLabel t (O.MethodProxy info ShortcutManager) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ShortcutManager = ShortcutManagerSignalList
type ShortcutManagerSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


