{-# LANGUAGE OverloadedStrings #-}
-- | Build time configuration used during code generation.
module GI.GdkPixbuf.Config ( overrides, modules ) where

import qualified Data.Text as T
import Data.Text (Text)

-- | Overrides used when generating these bindings.
overrides :: Text
overrides = T.unlines
 [ "namespace GdkPixbuf"
 , ""
 , "# Not supported on Windows."
 , "if windows"
 , "   set-attr GdkPixbuf/Pixbuf/save c:identifier gdk_pixbuf_save_utf8"
 , "   # See https://github.com/haskell-gi/haskell-gi/issues/63"
 , "   if pkg-config-version gdk-pixbuf-2.0 < 2.36"
 , "      set-attr GdkPixbuf/Pixbuf/new_from_file c:identifier gdk_pixbuf_new_from_file_utf8"
 , "      set-attr GdkPixbuf/Pixbuf/new_from_file_at_scale c:identifier gdk_pixbuf_new_from_file_at_scale_utf8"
 , "      set-attr GdkPixbuf/Pixbuf/new_from_file_at_size c:identifier gdk_pixbuf_new_from_file_at_size_utf8"
 , "      set-attr GdkPixbuf/Pixbuf/savev c:identifier gdk_pixbuf_savev_utf8"
 , "      set-attr GdkPixbuf/PixbufAnimation/new_from_file c:identifier gdk_pixbuf_animation_new_from_file_utf8"
 , "   endif"
 , "endif"
 , ""
 , "# The return value is nullable, but not marked as such, see"
 , "# https://github.com/haskell-gi/haskell-gi/issues/210"
 , "set-attr GdkPixbuf/PixbufLoader/get_pixbuf/@return-value nullable 1"
 , ""
 , "# The return value is nullable, but not marked as such"
 , "set-attr GdkPixbuf/Pixbuf/new_from_file/@return-value nullable 1"
 , ""
 , "# See https://github.com/haskell-gi/haskell-gi/issues/16"
 , "set-attr GdkPixbuf/PixbufAnimation/new_from_file/@parameters/filename/@type name filename"
 , "set-attr GdkPixbuf/PixbufAnimation/new_from_file_utf8/@parameters/filename/@type name filename"
 , "set-attr GdkPixbuf/Pixbuf/new_from_file/@parameters/filename/@type name filename"
 , "set-attr GdkPixbuf/Pixbuf/new_from_file_utf8/@parameters/filename/@type name filename"
 , "set-attr GdkPixbuf/Pixbuf/new_from_file_at_size/@parameters/filename/@type name filename"
 , "set-attr GdkPixbuf/Pixbuf/new_from_file_at_size_utf8/@parameters/filename/@type name filename"
 , "set-attr GdkPixbuf/Pixbuf/new_from_file_at_scale/@parameters/filename/@type name filename"
 , "set-attr GdkPixbuf/Pixbuf/new_from_file_at_scale_utf8/@parameters/filename/@type name filename"
 , "set-attr GdkPixbuf/Pixbuf/get_file_info/@parameters/filename/@type name filename"
 , "set-attr GdkPixbuf/Pixbuf/get_file_info_async/@parameters/filename/@type name filename"
 , "set-attr GdkPixbuf/Pixbuf/savev/@parameters/filename/@type name filename"
 , ""
 , "# Missing from the introspection data, see"
 , "# https://github.com/haskell-gi/haskell-gi/issues/127"
 , "set-attr GdkPixbuf/Pixbuf/new/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/copy/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/scale_simple/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/composite_color_simple/@return-value nullable 1"
 , ""
 , "# Generated from gdk-pixbuf 2.42.6 with xsltproc Nullable.xslt GdkPixbuf-2.0.gir"
 , "set-attr GdkPixbuf/Pixbuf/new/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/new_from_data/@parameters/destroy_fn nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/new_from_data/@parameters/destroy_fn_data nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/new_from_file/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/new_from_file_at_scale/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/new_from_file_at_size/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/new_from_resource/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/new_from_resource_at_scale/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/new_from_stream/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/new_from_stream/@parameters/cancellable nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/new_from_stream_at_scale/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/new_from_stream_at_scale/@parameters/cancellable nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/new_from_stream_finish/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/get_file_info/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/get_file_info_async/@parameters/cancellable nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/get_file_info_async/@parameters/callback nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/get_file_info_async/@parameters/user_data nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/get_file_info_finish/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/new_from_stream_async/@parameters/cancellable nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/new_from_stream_async/@parameters/callback nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/new_from_stream_async/@parameters/user_data nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/new_from_stream_at_scale_async/@parameters/cancellable nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/new_from_stream_at_scale_async/@parameters/callback nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/new_from_stream_at_scale_async/@parameters/user_data nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/apply_embedded_orientation/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/composite_color_simple/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/copy/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/flip/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/get_option/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/rotate_simple/@return-value nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save/@parameters/error nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_buffer/@parameters/error nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_bufferv/@parameters/option_keys nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_bufferv/@parameters/option_values nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_callback/@parameters/user_data nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_callback/@parameters/error nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_callbackv/@parameters/user_data nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_callbackv/@parameters/option_keys nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_callbackv/@parameters/option_values nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_stream/@parameters/cancellable nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_stream/@parameters/error nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_stream_async/@parameters/cancellable nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_stream_async/@parameters/callback nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_stream_async/@parameters/user_data nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_streamv/@parameters/option_keys nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_streamv/@parameters/option_values nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_streamv/@parameters/cancellable nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_streamv_async/@parameters/option_keys nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_streamv_async/@parameters/option_values nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_streamv_async/@parameters/cancellable nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_streamv_async/@parameters/callback nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/save_to_streamv_async/@parameters/user_data nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/savev/@parameters/option_keys nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/savev/@parameters/option_values nullable 1"
 , "set-attr GdkPixbuf/Pixbuf/scale_simple/@return-value nullable 1"
 , "set-attr GdkPixbuf/PixbufAnimation/new_from_file/@return-value nullable 1"
 , "set-attr GdkPixbuf/PixbufAnimation/new_from_resource/@return-value nullable 1"
 , "set-attr GdkPixbuf/PixbufAnimation/new_from_stream/@return-value nullable 1"
 , "set-attr GdkPixbuf/PixbufAnimation/new_from_stream/@parameters/cancellable nullable 1"
 , "set-attr GdkPixbuf/PixbufAnimation/new_from_stream_finish/@return-value nullable 1"
 , "set-attr GdkPixbuf/PixbufAnimation/new_from_stream_async/@parameters/cancellable nullable 1"
 , "set-attr GdkPixbuf/PixbufAnimation/new_from_stream_async/@parameters/callback nullable 1"
 , "set-attr GdkPixbuf/PixbufAnimation/new_from_stream_async/@parameters/user_data nullable 1"
 , "set-attr GdkPixbuf/PixbufAnimation/get_iter/@parameters/start_time nullable 1"
 , "set-attr GdkPixbuf/PixbufAnimation/get_iter/@parameters/start_time nullable 1"
 , "set-attr GdkPixbuf/PixbufAnimationClass/get_iter/get_iter/@parameters/start_time nullable 1"
 , "set-attr GdkPixbuf/PixbufAnimationIter/advance/@parameters/current_time nullable 1"
 , "set-attr GdkPixbuf/PixbufAnimationIter/advance/@parameters/current_time nullable 1"
 , "set-attr GdkPixbuf/PixbufAnimationIterClass/advance/advance/@parameters/current_time nullable 1"
 , "set-attr GdkPixbuf/PixbufDestroyNotify/@parameters/data nullable 1"
 , "set-attr GdkPixbuf/PixbufLoader/get_animation/@return-value nullable 1"
 , "set-attr GdkPixbuf/PixbufLoader/get_format/@return-value nullable 1"
 , "set-attr GdkPixbuf/PixbufLoader/get_pixbuf/@return-value nullable 1"
 , "set-attr GdkPixbuf/PixbufModule/begin_load/begin_load/@parameters/user_data nullable 1"
 , "set-attr GdkPixbuf/PixbufModule/save_to_callback/save_to_callback/@parameters/user_data nullable 1"
 , "set-attr GdkPixbuf/PixbufModulePreparedFunc/@parameters/user_data nullable 1"
 , "set-attr GdkPixbuf/PixbufModuleSizeFunc/@parameters/user_data nullable 1"
 , "set-attr GdkPixbuf/PixbufModuleUpdatedFunc/@parameters/user_data nullable 1"
 , "set-attr GdkPixbuf/PixbufSaveFunc/@parameters/data nullable 1"]

-- | Modules in this package
modules :: [Text]
modules =  [ "GI.GdkPixbuf.Config"
 , "GI.GdkPixbuf"
 , "GI.GdkPixbuf.Callbacks"
 , "GI.GdkPixbuf.Constants"
 , "GI.GdkPixbuf.Enums"
 , "GI.GdkPixbuf.Flags"
 , "GI.GdkPixbuf.Objects"
 , "GI.GdkPixbuf.Objects.Pixbuf"
 , "GI.GdkPixbuf.Objects.PixbufAnimation"
 , "GI.GdkPixbuf.Objects.PixbufAnimationIter"
 , "GI.GdkPixbuf.Objects.PixbufLoader"
 , "GI.GdkPixbuf.Objects.PixbufNonAnim"
 , "GI.GdkPixbuf.Objects.PixbufSimpleAnim"
 , "GI.GdkPixbuf.Objects.PixbufSimpleAnimIter"
 , "GI.GdkPixbuf.Structs"
 , "GI.GdkPixbuf.Structs.PixbufFormat"
 , "GI.GdkPixbuf.Structs.PixbufModule"
 , "GI.GdkPixbuf.Structs.PixbufModulePattern"]
