// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	monitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	applyconfigurationmonitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/client/applyconfiguration/monitoring/v1"
	scheme "github.com/prometheus-operator/prometheus-operator/pkg/client/versioned/scheme"
	autoscalingv1 "k8s.io/api/autoscaling/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// PrometheusesGetter has a method to return a PrometheusInterface.
// A group's client should implement this interface.
type PrometheusesGetter interface {
	Prometheuses(namespace string) PrometheusInterface
}

// PrometheusInterface has methods to work with Prometheus resources.
type PrometheusInterface interface {
	Create(ctx context.Context, prometheus *monitoringv1.Prometheus, opts metav1.CreateOptions) (*monitoringv1.Prometheus, error)
	Update(ctx context.Context, prometheus *monitoringv1.Prometheus, opts metav1.UpdateOptions) (*monitoringv1.Prometheus, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, prometheus *monitoringv1.Prometheus, opts metav1.UpdateOptions) (*monitoringv1.Prometheus, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*monitoringv1.Prometheus, error)
	List(ctx context.Context, opts metav1.ListOptions) (*monitoringv1.PrometheusList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *monitoringv1.Prometheus, err error)
	Apply(ctx context.Context, prometheus *applyconfigurationmonitoringv1.PrometheusApplyConfiguration, opts metav1.ApplyOptions) (result *monitoringv1.Prometheus, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, prometheus *applyconfigurationmonitoringv1.PrometheusApplyConfiguration, opts metav1.ApplyOptions) (result *monitoringv1.Prometheus, err error)
	GetScale(ctx context.Context, prometheusName string, options metav1.GetOptions) (*autoscalingv1.Scale, error)
	UpdateScale(ctx context.Context, prometheusName string, scale *autoscalingv1.Scale, opts metav1.UpdateOptions) (*autoscalingv1.Scale, error)

	PrometheusExpansion
}

// prometheuses implements PrometheusInterface
type prometheuses struct {
	*gentype.ClientWithListAndApply[*monitoringv1.Prometheus, *monitoringv1.PrometheusList, *applyconfigurationmonitoringv1.PrometheusApplyConfiguration]
}

// newPrometheuses returns a Prometheuses
func newPrometheuses(c *MonitoringV1Client, namespace string) *prometheuses {
	return &prometheuses{
		gentype.NewClientWithListAndApply[*monitoringv1.Prometheus, *monitoringv1.PrometheusList, *applyconfigurationmonitoringv1.PrometheusApplyConfiguration](
			"prometheuses",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *monitoringv1.Prometheus { return &monitoringv1.Prometheus{} },
			func() *monitoringv1.PrometheusList { return &monitoringv1.PrometheusList{} },
		),
	}
}

// GetScale takes name of the prometheus, and returns the corresponding autoscalingv1.Scale object, and an error if there is any.
func (c *prometheuses) GetScale(ctx context.Context, prometheusName string, options metav1.GetOptions) (result *autoscalingv1.Scale, err error) {
	result = &autoscalingv1.Scale{}
	err = c.GetClient().Get().
		Namespace(c.GetNamespace()).
		Resource("prometheuses").
		Name(prometheusName).
		SubResource("scale").
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// UpdateScale takes the top resource name and the representation of a scale and updates it. Returns the server's representation of the scale, and an error, if there is any.
func (c *prometheuses) UpdateScale(ctx context.Context, prometheusName string, scale *autoscalingv1.Scale, opts metav1.UpdateOptions) (result *autoscalingv1.Scale, err error) {
	result = &autoscalingv1.Scale{}
	err = c.GetClient().Put().
		Namespace(c.GetNamespace()).
		Resource("prometheuses").
		Name(prometheusName).
		SubResource("scale").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(scale).
		Do(ctx).
		Into(result)
	return
}
