/* SPDX-FileCopyrightText: 2025 - Sébastien Wilmet
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#pragma once

#include "gedit-tab.h"

G_BEGIN_DECLS

#define GEDIT_TYPE_TAB_LOADER             (_gedit_tab_loader_get_type ())
#define GEDIT_TAB_LOADER(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEDIT_TYPE_TAB_LOADER, GeditTabLoader))
#define GEDIT_TAB_LOADER_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GEDIT_TYPE_TAB_LOADER, GeditTabLoaderClass))
#define GEDIT_IS_TAB_LOADER(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEDIT_TYPE_TAB_LOADER))
#define GEDIT_IS_TAB_LOADER_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GEDIT_TYPE_TAB_LOADER))
#define GEDIT_TAB_LOADER_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GEDIT_TYPE_TAB_LOADER, GeditTabLoaderClass))

typedef struct _GeditTabLoader         GeditTabLoader;
typedef struct _GeditTabLoaderClass    GeditTabLoaderClass;
typedef struct _GeditTabLoaderPrivate  GeditTabLoaderPrivate;

struct _GeditTabLoader
{
	GObject parent;

	GeditTabLoaderPrivate *priv;
};

struct _GeditTabLoaderClass
{
	GObjectClass parent_class;
};

G_GNUC_INTERNAL
GType			_gedit_tab_loader_get_type		(void) G_GNUC_CONST;

G_GNUC_INTERNAL
GeditTabLoader *	_gedit_tab_loader_new			(GeditTab *tab);

G_GNUC_INTERNAL
GtkSourceFileLoader *	_gedit_tab_loader_get_file_loader	(GeditTabLoader *tab_loader);

G_GNUC_INTERNAL
void			_gedit_tab_loader_set_file_loader	(GeditTabLoader      *tab_loader,
								 GtkSourceFileLoader *file_loader);

G_GNUC_INTERNAL
void			_gedit_tab_loader_set_line_position	(GeditTabLoader *tab_loader,
								 gint            line_position);

G_GNUC_INTERNAL
void			_gedit_tab_loader_set_column_position	(GeditTabLoader *tab_loader,
								 gint            column_position);

G_GNUC_INTERNAL
void			_gedit_tab_loader_place_cursor		(GeditTabLoader *tab_loader);

G_GNUC_INTERNAL
void			_gedit_tab_loader_set_encoding		(GeditTabLoader          *tab_loader,
								 const GtkSourceEncoding *encoding);

G_GNUC_INTERNAL
void			_gedit_tab_loader_save_encoding_metadata (GeditTabLoader *tab_loader);

G_END_DECLS
