/* nightlight.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from nightlight.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>

#define BUDGIE_NIGHT_LIGHT_MANAGER_local_config_file "budgie_config.ini"
#define BUDGIE_NIGHT_LIGHT_MANAGER_search_config_file "gammastep.config"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_NIGHT_LIGHT_MANAGER (budgie_night_light_manager_get_type ())
#define BUDGIE_NIGHT_LIGHT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_NIGHT_LIGHT_MANAGER, BudgieNightLightManager))
#define BUDGIE_NIGHT_LIGHT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_NIGHT_LIGHT_MANAGER, BudgieNightLightManagerClass))
#define BUDGIE_IS_NIGHT_LIGHT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_NIGHT_LIGHT_MANAGER))
#define BUDGIE_IS_NIGHT_LIGHT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_NIGHT_LIGHT_MANAGER))
#define BUDGIE_NIGHT_LIGHT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_NIGHT_LIGHT_MANAGER, BudgieNightLightManagerClass))

typedef struct _BudgieNightLightManager BudgieNightLightManager;
typedef struct _BudgieNightLightManagerClass BudgieNightLightManagerClass;
typedef struct _BudgieNightLightManagerPrivate BudgieNightLightManagerPrivate;
enum  {
	BUDGIE_NIGHT_LIGHT_MANAGER_0_PROPERTY,
	BUDGIE_NIGHT_LIGHT_MANAGER_NUM_PROPERTIES
};
static GParamSpec* budgie_night_light_manager_properties[BUDGIE_NIGHT_LIGHT_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

struct _BudgieNightLightManager {
	GObject parent_instance;
	BudgieNightLightManagerPrivate * priv;
};

struct _BudgieNightLightManagerClass {
	GObjectClass parent_class;
};

struct _BudgieNightLightManagerPrivate {
	GSettings* settings;
	gchar* local_config_path;
};

static gint BudgieNightLightManager_private_offset;
static gpointer budgie_night_light_manager_parent_class = NULL;

VALA_EXTERN GType budgie_night_light_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieNightLightManager, g_object_unref)
VALA_EXTERN BudgieNightLightManager* budgie_night_light_manager_new (void);
VALA_EXTERN BudgieNightLightManager* budgie_night_light_manager_construct (GType object_type);
static void budgie_night_light_manager_ensure_local_config_exists (BudgieNightLightManager* self);
static void budgie_night_light_manager_on_settings_changed (BudgieNightLightManager* self,
                                                     GSettings* settings,
                                                     const gchar* key);
static void _budgie_night_light_manager_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                         const gchar* key,
                                                                         gpointer self);
static void budgie_night_light_manager_update_gammastep_config (BudgieNightLightManager* self);
static void budgie_night_light_manager_run_gammastep (BudgieNightLightManager* self);
static void budgie_night_light_manager_stop_gammastep (BudgieNightLightManager* self);
static gchar* budgie_night_light_manager_search_for_config (BudgieNightLightManager* self);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void budgie_night_light_manager_finalize (GObject * obj);
static GType budgie_night_light_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
budgie_night_light_manager_get_instance_private (BudgieNightLightManager* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieNightLightManager_private_offset);
}

static void
_budgie_night_light_manager_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                    const gchar* key,
                                                                    gpointer self)
{
	budgie_night_light_manager_on_settings_changed ((BudgieNightLightManager*) self, _sender, key);
}

BudgieNightLightManager*
budgie_night_light_manager_construct (GType object_type)
{
	BudgieNightLightManager * self = NULL;
	GSettings* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	self = (BudgieNightLightManager*) g_object_new (object_type, NULL);
	_tmp0_ = g_settings_new ("org.gnome.settings-daemon.plugins.color");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = g_get_user_config_dir ();
	_tmp2_ = g_build_filename (_tmp1_, "gammastep", BUDGIE_NIGHT_LIGHT_MANAGER_local_config_file, NULL);
	_g_free0 (self->priv->local_config_path);
	self->priv->local_config_path = _tmp2_;
	budgie_night_light_manager_ensure_local_config_exists (self);
	_tmp3_ = self->priv->settings;
	g_signal_connect_object (_tmp3_, "changed", (GCallback) _budgie_night_light_manager_on_settings_changed_g_settings_changed, self, 0);
	_tmp4_ = self->priv->settings;
	budgie_night_light_manager_on_settings_changed (self, _tmp4_, "");
	return self;
}

BudgieNightLightManager*
budgie_night_light_manager_new (void)
{
	return budgie_night_light_manager_construct (BUDGIE_TYPE_NIGHT_LIGHT_MANAGER);
}

static void
budgie_night_light_manager_on_settings_changed (BudgieNightLightManager* self,
                                                GSettings* settings,
                                                const gchar* key)
{
	gboolean night_light_enabled = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	night_light_enabled = g_settings_get_boolean (settings, "night-light-enabled");
	if (night_light_enabled) {
		budgie_night_light_manager_update_gammastep_config (self);
		budgie_night_light_manager_run_gammastep (self);
	} else {
		budgie_night_light_manager_stop_gammastep (self);
	}
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
budgie_night_light_manager_search_for_config (BudgieNightLightManager* self)
{
	gchar** search_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint search_path_length1;
	gint _search_path_size_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gchar* path = NULL;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp17_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->local_config_path;
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	search_path = _tmp2_;
	search_path_length1 = 1;
	_search_path_size_ = search_path_length1;
	_tmp4_ = _tmp3_ = g_get_system_data_dirs ();
	{
		gchar** system_dir_collection = NULL;
		gint system_dir_collection_length1 = 0;
		gint _system_dir_collection_size_ = 0;
		gint system_dir_it = 0;
		system_dir_collection = _tmp4_;
		system_dir_collection_length1 = _vala_array_length (_tmp3_);
		for (system_dir_it = 0; system_dir_it < system_dir_collection_length1; system_dir_it = system_dir_it + 1) {
			gchar* _tmp5_;
			gchar* system_dir = NULL;
			_tmp5_ = g_strdup (system_dir_collection[system_dir_it]);
			system_dir = _tmp5_;
			{
				const gchar* _tmp6_;
				gchar* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp6_ = system_dir;
				_tmp7_ = g_build_filename (_tmp6_, "budgie-desktop", "distro-" BUDGIE_NIGHT_LIGHT_MANAGER_search_config_file, NULL);
				_vala_array_add3 (&search_path, &search_path_length1, &_search_path_size_, _tmp7_);
				_tmp8_ = system_dir;
				_tmp9_ = g_build_filename (_tmp8_, "budgie-desktop", BUDGIE_NIGHT_LIGHT_MANAGER_search_config_file, NULL);
				_vala_array_add4 (&search_path, &search_path_length1, &_search_path_size_, _tmp9_);
				_g_free0 (system_dir);
			}
		}
	}
	_tmp10_ = g_strdup ("");
	path = _tmp10_;
	_tmp11_ = search_path;
	_tmp11__length1 = search_path_length1;
	{
		gchar** p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp11_;
		p_collection_length1 = _tmp11__length1;
		for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
			const gchar* p = NULL;
			p = p_collection[p_it];
			{
				GFile* search_config_file = NULL;
				const gchar* _tmp12_;
				GFile* _tmp13_;
				GFile* _tmp14_;
				_tmp12_ = p;
				_tmp13_ = g_file_new_for_path (_tmp12_);
				search_config_file = _tmp13_;
				_tmp14_ = search_config_file;
				if (g_file_query_exists (_tmp14_, NULL)) {
					const gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp15_ = p;
					_tmp16_ = g_strdup (_tmp15_);
					_g_free0 (path);
					path = _tmp16_;
					_g_object_unref0 (search_config_file);
					break;
				}
				_g_object_unref0 (search_config_file);
			}
		}
	}
	_tmp17_ = path;
	if (g_strcmp0 (_tmp17_, "") == 0) {
		g_critical ("nightlight.vala:64: %s", "Could not find an existing " BUDGIE_NIGHT_LIGHT_MANAGER_search_config_file " or a shipped budgie equivalent");
		result = NULL;
		_g_free0 (path);
		search_path = (_vala_array_free (search_path, search_path_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	result = path;
	search_path = (_vala_array_free (search_path, search_path_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
budgie_night_light_manager_ensure_local_config_exists (BudgieNightLightManager* self)
{
	gchar* default_config_path = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_night_light_manager_search_for_config (self);
	default_config_path = _tmp0_;
	_tmp2_ = default_config_path;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = default_config_path;
		_tmp4_ = self->priv->local_config_path;
		_tmp1_ = g_strcmp0 (_tmp3_, _tmp4_) != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			GFile* dir = NULL;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			GFile* _tmp8_;
			GFile* _tmp9_;
			GFile* _tmp10_;
			_tmp5_ = self->priv->local_config_path;
			_tmp6_ = g_path_get_dirname (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_file_new_for_path (_tmp7_);
			_tmp9_ = _tmp8_;
			_g_free0 (_tmp7_);
			dir = _tmp9_;
			_tmp10_ = dir;
			g_file_make_directory_with_parents (_tmp10_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (dir);
				if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
					goto __catch0_g_io_error_exists;
				}
				goto __catch0_g_error;
			}
			_g_object_unref0 (dir);
		}
		goto __finally0;
		__catch0_g_io_error_exists:
		{
			g_clear_error (&_inner_error0_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp11_;
			const gchar* _tmp12_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			g_warning ("nightlight.vala:83: Failed to create local folder: %s\n", _tmp12_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (default_config_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		{
			GFile* default_config_file = NULL;
			const gchar* _tmp13_;
			GFile* _tmp14_;
			GFile* local_config_file = NULL;
			const gchar* _tmp15_;
			GFile* _tmp16_;
			GFile* _tmp17_;
			GFile* _tmp18_;
			_tmp13_ = default_config_path;
			_tmp14_ = g_file_new_for_path (_tmp13_);
			default_config_file = _tmp14_;
			_tmp15_ = self->priv->local_config_path;
			_tmp16_ = g_file_new_for_path (_tmp15_);
			local_config_file = _tmp16_;
			_tmp17_ = default_config_file;
			_tmp18_ = local_config_file;
			g_file_copy (_tmp17_, _tmp18_, G_FILE_COPY_NONE, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (local_config_file);
				_g_object_unref0 (default_config_file);
				goto __catch1_g_error;
			}
			_g_object_unref0 (local_config_file);
			_g_object_unref0 (default_config_file);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp19_;
			const gchar* _tmp20_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp19_ = e;
			_tmp20_ = _tmp19_->message;
			g_warning ("nightlight.vala:92: Failed to copy configuration file: %s\n", _tmp20_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (default_config_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_free0 (default_config_path);
}

static void
budgie_night_light_manager_update_gammastep_config (BudgieNightLightManager* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GKeyFile* key_file = NULL;
		GKeyFile* _tmp0_;
		GKeyFile* _tmp1_;
		const gchar* _tmp2_;
		guint night_light_temperature = 0U;
		GSettings* _tmp3_;
		GKeyFile* _tmp4_;
		gboolean schedule_automatic = FALSE;
		GSettings* _tmp5_;
		gdouble night_light_schedule_from = 0.0;
		GSettings* _tmp8_;
		gint dusk_hour = 0;
		GKeyFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gdouble night_light_schedule_to = 0.0;
		GSettings* _tmp14_;
		gint dawn_hour = 0;
		GKeyFile* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GKeyFile* _tmp20_;
		const gchar* _tmp21_;
		budgie_night_light_manager_ensure_local_config_exists (self);
		_tmp0_ = g_key_file_new ();
		key_file = _tmp0_;
		_tmp1_ = key_file;
		_tmp2_ = self->priv->local_config_path;
		g_key_file_load_from_file (_tmp1_, _tmp2_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (key_file);
			goto __catch0_g_error;
		}
		_tmp3_ = self->priv->settings;
		night_light_temperature = g_settings_get_uint (_tmp3_, "night-light-temperature");
		_tmp4_ = key_file;
		g_key_file_set_uint64 (_tmp4_, "general", "temp-night", (guint64) night_light_temperature);
		_tmp5_ = self->priv->settings;
		schedule_automatic = g_settings_get_boolean (_tmp5_, "night-light-schedule-automatic");
		if (schedule_automatic) {
			GKeyFile* _tmp6_;
			_tmp6_ = key_file;
			g_key_file_set_string (_tmp6_, "general", "location-provider", "geoclue2");
		} else {
			GKeyFile* _tmp7_;
			_tmp7_ = key_file;
			g_key_file_set_string (_tmp7_, "general", "location-provider", "manual");
		}
		_tmp8_ = self->priv->settings;
		night_light_schedule_from = g_settings_get_double (_tmp8_, "night-light-schedule-from");
		dusk_hour = (gint) night_light_schedule_from;
		_tmp9_ = key_file;
		_tmp10_ = g_strdup_printf ("%i", dusk_hour);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, ":00", NULL);
		_tmp13_ = _tmp12_;
		g_key_file_set_string (_tmp9_, "general", "dusk-time", _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_tmp14_ = self->priv->settings;
		night_light_schedule_to = g_settings_get_double (_tmp14_, "night-light-schedule-to");
		dawn_hour = (gint) night_light_schedule_to;
		_tmp15_ = key_file;
		_tmp16_ = g_strdup_printf ("%i", dawn_hour);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat (_tmp17_, ":00", NULL);
		_tmp19_ = _tmp18_;
		g_key_file_set_string (_tmp15_, "general", "dawn-time", _tmp19_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		_tmp20_ = key_file;
		_tmp21_ = self->priv->local_config_path;
		g_key_file_save_to_file (_tmp20_, _tmp21_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (key_file);
			goto __catch0_g_error;
		}
		_g_key_file_unref0 (key_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		const gchar* _tmp23_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		g_warning ("nightlight.vala:139: Failed to update Gammastep configuration file: %s" \
"\n", _tmp23_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_night_light_manager_run_gammastep (BudgieNightLightManager* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar** spawn_args = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar** _tmp6_;
		gint spawn_args_length1;
		gint _spawn_args_size_;
		gchar** spawn_env = NULL;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint spawn_env_length1;
		gint _spawn_env_size_;
		_tmp0_ = g_strdup ("gammastep");
		_tmp1_ = g_strdup ("-o");
		_tmp2_ = g_strdup ("-P");
		_tmp3_ = g_strdup ("-c");
		_tmp4_ = self->priv->local_config_path;
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = g_new0 (gchar*, 5 + 1);
		_tmp6_[0] = _tmp0_;
		_tmp6_[1] = _tmp1_;
		_tmp6_[2] = _tmp2_;
		_tmp6_[3] = _tmp3_;
		_tmp6_[4] = _tmp5_;
		spawn_args = _tmp6_;
		spawn_args_length1 = 5;
		_spawn_args_size_ = spawn_args_length1;
		_tmp8_ = _tmp7_ = g_get_environ ();
		spawn_env = _tmp8_;
		spawn_env_length1 = _vala_array_length (_tmp7_);
		_spawn_env_size_ = spawn_env_length1;
		g_spawn_async ("/", spawn_args, spawn_env, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
			spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
			goto __catch0_g_error;
		}
		spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
		spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("nightlight.vala:156: Failed to start gammastep: %s\n", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_night_light_manager_stop_gammastep (BudgieNightLightManager* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar** spawn_args = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar** _tmp4_;
		gint spawn_args_length1;
		gint _spawn_args_size_;
		gchar** spawn_env = NULL;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint spawn_env_length1;
		gint _spawn_env_size_;
		_tmp0_ = g_strdup ("killall");
		_tmp1_ = g_strdup ("-s");
		_tmp2_ = g_strdup ("SIGHUP");
		_tmp3_ = g_strdup ("gammastep");
		_tmp4_ = g_new0 (gchar*, 4 + 1);
		_tmp4_[0] = _tmp0_;
		_tmp4_[1] = _tmp1_;
		_tmp4_[2] = _tmp2_;
		_tmp4_[3] = _tmp3_;
		spawn_args = _tmp4_;
		spawn_args_length1 = 4;
		_spawn_args_size_ = spawn_args_length1;
		_tmp6_ = _tmp5_ = g_get_environ ();
		spawn_env = _tmp6_;
		spawn_env_length1 = _vala_array_length (_tmp5_);
		_spawn_env_size_ = spawn_env_length1;
		g_spawn_sync ("/", spawn_args, spawn_env, (G_SPAWN_SEARCH_PATH | G_SPAWN_STDERR_TO_DEV_NULL) | G_SPAWN_STDOUT_TO_DEV_NULL, NULL, NULL, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
			spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
			goto __catch0_g_error;
		}
		spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
		spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("nightlight.vala:176: Failed to stop gammastep process: %s\n", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_night_light_manager_class_init (BudgieNightLightManagerClass * klass,
                                       gpointer klass_data)
{
	budgie_night_light_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieNightLightManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_night_light_manager_finalize;
}

static void
budgie_night_light_manager_instance_init (BudgieNightLightManager * self,
                                          gpointer klass)
{
	self->priv = budgie_night_light_manager_get_instance_private (self);
}

static void
budgie_night_light_manager_finalize (GObject * obj)
{
	BudgieNightLightManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_NIGHT_LIGHT_MANAGER, BudgieNightLightManager);
	_g_object_unref0 (self->priv->settings);
	_g_free0 (self->priv->local_config_path);
	G_OBJECT_CLASS (budgie_night_light_manager_parent_class)->finalize (obj);
}

static GType
budgie_night_light_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieNightLightManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_night_light_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieNightLightManager), 0, (GInstanceInitFunc) budgie_night_light_manager_instance_init, NULL };
	GType budgie_night_light_manager_type_id;
	budgie_night_light_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieNightLightManager", &g_define_type_info, 0);
	BudgieNightLightManager_private_offset = g_type_add_instance_private (budgie_night_light_manager_type_id, sizeof (BudgieNightLightManagerPrivate));
	return budgie_night_light_manager_type_id;
}

GType
budgie_night_light_manager_get_type (void)
{
	static volatile gsize budgie_night_light_manager_type_id__once = 0;
	if (g_once_init_enter (&budgie_night_light_manager_type_id__once)) {
		GType budgie_night_light_manager_type_id;
		budgie_night_light_manager_type_id = budgie_night_light_manager_get_type_once ();
		g_once_init_leave (&budgie_night_light_manager_type_id__once, budgie_night_light_manager_type_id);
	}
	return budgie_night_light_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

