/* brightness-util.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from brightness-util.vala, do not modify */

/*
* This file is part of budgie-desktop
*
* Copyright Budgie Desktop Developers
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <unistd.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_BRIGHTNESS_UTIL (budgie_brightness_util_get_type ())
#define BUDGIE_BRIGHTNESS_UTIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BRIGHTNESS_UTIL, BudgieBrightnessUtil))
#define BUDGIE_BRIGHTNESS_UTIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BRIGHTNESS_UTIL, BudgieBrightnessUtilClass))
#define BUDGIE_IS_BRIGHTNESS_UTIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BRIGHTNESS_UTIL))
#define BUDGIE_IS_BRIGHTNESS_UTIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BRIGHTNESS_UTIL))
#define BUDGIE_BRIGHTNESS_UTIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BRIGHTNESS_UTIL, BudgieBrightnessUtilClass))

typedef struct _BudgieBrightnessUtil BudgieBrightnessUtil;
typedef struct _BudgieBrightnessUtilClass BudgieBrightnessUtilClass;
typedef struct _BudgieBrightnessUtilPrivate BudgieBrightnessUtilPrivate;
enum  {
	BUDGIE_BRIGHTNESS_UTIL_0_PROPERTY,
	BUDGIE_BRIGHTNESS_UTIL_BACKLIGHT_DEVICE_PROPERTY,
	BUDGIE_BRIGHTNESS_UTIL_BACKLIGHT_PATH_PROPERTY,
	BUDGIE_BRIGHTNESS_UTIL_MAX_BRIGHTNESS_PROPERTY,
	BUDGIE_BRIGHTNESS_UTIL_CURRENT_BRIGHTNESS_PROPERTY,
	BUDGIE_BRIGHTNESS_UTIL_NUM_PROPERTIES
};
static GParamSpec* budgie_brightness_util_properties[BUDGIE_BRIGHTNESS_UTIL_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _BudgieBrightnessUtil {
	GObject parent_instance;
	BudgieBrightnessUtilPrivate * priv;
};

struct _BudgieBrightnessUtilClass {
	GObjectClass parent_class;
};

struct _BudgieBrightnessUtilPrivate {
	gchar* _backlight_device;
	gchar* _backlight_path;
	gint _max_brightness;
	gint _current_brightness;
};

static gint BudgieBrightnessUtil_private_offset;
static gpointer budgie_brightness_util_parent_class = NULL;

VALA_EXTERN GType budgie_brightness_util_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieBrightnessUtil, g_object_unref)
VALA_EXTERN gboolean budgie_brightness_util_find_backlight_device (BudgieBrightnessUtil* self);
static void budgie_brightness_util_set_backlight_device (BudgieBrightnessUtil* self,
                                                  const gchar* value);
VALA_EXTERN const gchar* budgie_brightness_util_get_backlight_device (BudgieBrightnessUtil* self);
static void budgie_brightness_util_set_backlight_path (BudgieBrightnessUtil* self,
                                                const gchar* value);
VALA_EXTERN const gchar* budgie_brightness_util_get_backlight_path (BudgieBrightnessUtil* self);
static void budgie_brightness_util_set_max_brightness (BudgieBrightnessUtil* self,
                                                gint value);
VALA_EXTERN gint budgie_brightness_util_get_max_brightness (BudgieBrightnessUtil* self);
VALA_EXTERN void budgie_brightness_util_update_current_brightness (BudgieBrightnessUtil* self);
static void budgie_brightness_util_set_current_brightness (BudgieBrightnessUtil* self,
                                                    gint value);
VALA_EXTERN gchar* budgie_brightness_util_get_session_from_logind (void);
VALA_EXTERN gchar* budgie_brightness_util_get_session_id (void);
VALA_EXTERN BudgieBrightnessUtil* budgie_brightness_util_new (void);
VALA_EXTERN BudgieBrightnessUtil* budgie_brightness_util_construct (GType object_type);
VALA_EXTERN gint budgie_brightness_util_get_current_brightness (BudgieBrightnessUtil* self);
static void budgie_brightness_util_finalize (GObject * obj);
static GType budgie_brightness_util_get_type_once (void);
static void _vala_budgie_brightness_util_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_budgie_brightness_util_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
budgie_brightness_util_get_instance_private (BudgieBrightnessUtil* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieBrightnessUtil_private_offset);
}

/**
        * Find the first available backlight device
        */
gboolean
budgie_brightness_util_find_backlight_device (BudgieBrightnessUtil* self)
{
	gboolean _tmp31_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GFile* backlight_dir = NULL;
		GFile* _tmp0_;
		GFile* _tmp1_;
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp2_;
		GFileEnumerator* _tmp3_;
		GFileInfo* info = NULL;
		const gchar* _tmp15_;
		GFile* max_file = NULL;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GFile* _tmp19_;
		GFile* _tmp20_;
		guint8* contents = NULL;
		gint contents_length1 = 0;
		gint _contents_size_ = 0;
		gboolean _tmp21_ = FALSE;
		GFile* _tmp22_;
		guint8* _tmp23_ = NULL;
		gsize _tmp24_ = 0;
		gboolean _tmp25_;
		_tmp0_ = g_file_new_for_path ("/sys/class/backlight");
		backlight_dir = _tmp0_;
		_tmp1_ = backlight_dir;
		if (!g_file_query_exists (_tmp1_, NULL)) {
			g_warning ("brightness-util.vala:30: No /sys/class/backlight directory found");
			result = FALSE;
			_g_object_unref0 (backlight_dir);
			return result;
		}
		g_debug ("brightness-util.vala:34: Searching for backlight devices in /sys/class" \
"/backlight");
		_tmp2_ = backlight_dir;
		_tmp3_ = g_file_enumerate_children (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		enumerator = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (backlight_dir);
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp4_ = NULL;
			GFileEnumerator* _tmp5_;
			GFileInfo* _tmp6_;
			GFileInfo* _tmp7_;
			GFileInfo* _tmp8_;
			GFileInfo* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp5_ = enumerator;
			_tmp6_ = g_file_enumerator_next_file (_tmp5_, NULL, &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (backlight_dir);
				goto __catch0_g_error;
			}
			_tmp7_ = _tmp4_;
			_tmp4_ = NULL;
			_g_object_unref0 (info);
			info = _tmp7_;
			_tmp8_ = info;
			if (!(_tmp8_ != NULL)) {
				_g_object_unref0 (_tmp4_);
				break;
			}
			_tmp9_ = info;
			_tmp10_ = g_file_info_get_name (_tmp9_);
			budgie_brightness_util_set_backlight_device (self, _tmp10_);
			_tmp11_ = self->priv->_backlight_device;
			_tmp12_ = g_build_filename ("/sys/class/backlight", _tmp11_, NULL);
			_tmp13_ = _tmp12_;
			budgie_brightness_util_set_backlight_path (self, _tmp13_);
			_g_free0 (_tmp13_);
			_tmp14_ = self->priv->_backlight_device;
			g_debug ("brightness-util.vala:44: Found backlight device: %s", _tmp14_);
			_g_object_unref0 (_tmp4_);
			break;
		}
		_tmp15_ = self->priv->_backlight_device;
		if (_tmp15_ == NULL) {
			g_warning ("brightness-util.vala:49: No backlight device found in /sys/class/backl" \
"ight");
			result = FALSE;
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (backlight_dir);
			return result;
		}
		_tmp16_ = self->priv->_backlight_path;
		_tmp17_ = g_build_filename (_tmp16_, "max_brightness", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_file_new_for_path (_tmp18_);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp18_);
		max_file = _tmp20_;
		_tmp22_ = max_file;
		_tmp25_ = g_file_load_contents (_tmp22_, NULL, &_tmp23_, &_tmp24_, NULL, &_inner_error0_);
		contents = (g_free (contents), NULL);
		contents = _tmp23_;
		contents_length1 = _tmp24_;
		_contents_size_ = contents_length1;
		_tmp21_ = _tmp25_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			contents = (g_free (contents), NULL);
			_g_object_unref0 (max_file);
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (backlight_dir);
			goto __catch0_g_error;
		}
		if (_tmp21_) {
			guint8* _tmp26_;
			gint _tmp26__length1;
			const gchar* _tmp27_;
			gint _tmp28_;
			_tmp26_ = contents;
			_tmp26__length1 = contents_length1;
			budgie_brightness_util_set_max_brightness (self, atoi ((const gchar*) _tmp26_));
			_tmp27_ = self->priv->_backlight_device;
			_tmp28_ = self->priv->_max_brightness;
			g_debug ("brightness-util.vala:58: Device %s has max_brightness: %d", _tmp27_, _tmp28_);
		}
		budgie_brightness_util_update_current_brightness (self);
		result = TRUE;
		contents = (g_free (contents), NULL);
		_g_object_unref0 (max_file);
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (backlight_dir);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_warning ("brightness-util.vala:67: Error finding backlight device: %s", _tmp30_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp31_;
}

/**
        * Read current brightness from sysfs
        */
void
budgie_brightness_util_update_current_brightness (BudgieBrightnessUtil* self)
{
	const gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_backlight_path;
	if (_tmp0_ == NULL) {
		return;
	}
	{
		GFile* brightness_file = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		guint8* contents = NULL;
		gint contents_length1 = 0;
		gint _contents_size_ = 0;
		gboolean _tmp6_ = FALSE;
		GFile* _tmp7_;
		guint8* _tmp8_ = NULL;
		gsize _tmp9_ = 0;
		gboolean _tmp10_;
		_tmp1_ = self->priv->_backlight_path;
		_tmp2_ = g_build_filename (_tmp1_, "brightness", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_new_for_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		brightness_file = _tmp5_;
		_tmp7_ = brightness_file;
		_tmp10_ = g_file_load_contents (_tmp7_, NULL, &_tmp8_, &_tmp9_, NULL, &_inner_error0_);
		contents = (g_free (contents), NULL);
		contents = _tmp8_;
		contents_length1 = _tmp9_;
		_contents_size_ = contents_length1;
		_tmp6_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			contents = (g_free (contents), NULL);
			_g_object_unref0 (brightness_file);
			goto __catch0_g_error;
		}
		if (_tmp6_) {
			guint8* _tmp11_;
			gint _tmp11__length1;
			_tmp11_ = contents;
			_tmp11__length1 = contents_length1;
			budgie_brightness_util_set_current_brightness (self, atoi ((const gchar*) _tmp11_));
		}
		contents = (g_free (contents), NULL);
		_g_object_unref0 (brightness_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("brightness-util.vala:85: Error reading brightness: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
        * Get session ID from logind using the proper D-Bus API
        * This is equivalent to sd_pid_get_session()
        */
gchar*
budgie_brightness_util_get_session_from_logind (void)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	{
		gint pid = 0;
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp0_;
		GVariant* reply = NULL;
		GDBusConnection* _tmp1_;
		GVariant* _tmp2_;
		GVariant* _tmp3_;
		GVariantType* _tmp4_;
		GVariantType* _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_;
		gchar* session_object_path = NULL;
		GVariant* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar** parts = NULL;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint parts_length1;
		gint _parts_size_;
		pid = (gint) getpid ();
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &_inner_error0_);
		connection = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = connection;
		_tmp2_ = g_variant_new ("(u)", (guint32) pid, NULL);
		g_variant_ref_sink (_tmp2_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_variant_type_new ("(o)");
		_tmp5_ = _tmp4_;
		_tmp6_ = g_dbus_connection_call_sync (_tmp1_, "org.freedesktop.login1", "/org/freedesktop/login1", "org.freedesktop.login1.Manager", "GetSessionByPID", _tmp3_, _tmp5_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, &_inner_error0_);
		_tmp7_ = _tmp6_;
		_g_variant_type_free0 (_tmp5_);
		_g_variant_unref0 (_tmp3_);
		reply = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (connection);
			goto __catch0_g_error;
		}
		_tmp8_ = reply;
		g_variant_get (_tmp8_, "(o)", &_tmp9_, NULL);
		_g_free0 (session_object_path);
		session_object_path = _tmp9_;
		_tmp11_ = _tmp10_ = g_strsplit (session_object_path, "/", 0);
		parts = _tmp11_;
		parts_length1 = _vala_array_length (_tmp10_);
		_parts_size_ = parts_length1;
		if (parts_length1 > 0) {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = parts[parts_length1 - 1];
			_tmp13_ = g_strdup (_tmp12_);
			result = _tmp13_;
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (session_object_path);
			_g_variant_unref0 (reply);
			_g_object_unref0 (connection);
			return result;
		}
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (session_object_path);
		_g_variant_unref0 (reply);
		_g_object_unref0 (connection);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("brightness-util.vala:120: Failed to get session from logind: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

/**
        * Get session ID
        */
gchar*
budgie_brightness_util_get_session_id (void)
{
	gchar* session_id = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* result;
	_tmp0_ = g_getenv ("XDG_SESSION_ID");
	_tmp1_ = g_strdup (_tmp0_);
	session_id = _tmp1_;
	_tmp3_ = session_id;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = session_id;
		_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp5_;
		_tmp5_ = session_id;
		g_debug ("brightness-util.vala:134: Using XDG_SESSION_ID: %s", _tmp5_);
		result = session_id;
		return result;
	}
	g_debug ("brightness-util.vala:139: XDG_SESSION_ID not set, querying logind...");
	_tmp6_ = budgie_brightness_util_get_session_from_logind ();
	_g_free0 (session_id);
	session_id = _tmp6_;
	_tmp7_ = session_id;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		_tmp8_ = session_id;
		g_debug ("brightness-util.vala:143: Got session ID from logind: %s", _tmp8_);
	} else {
		g_warning ("brightness-util.vala:145: Could not determine session ID");
	}
	result = session_id;
	return result;
}

BudgieBrightnessUtil*
budgie_brightness_util_construct (GType object_type)
{
	BudgieBrightnessUtil * self = NULL;
	self = (BudgieBrightnessUtil*) g_object_new (object_type, NULL);
	return self;
}

BudgieBrightnessUtil*
budgie_brightness_util_new (void)
{
	return budgie_brightness_util_construct (BUDGIE_TYPE_BRIGHTNESS_UTIL);
}

const gchar*
budgie_brightness_util_get_backlight_device (BudgieBrightnessUtil* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_backlight_device;
	result = _tmp0_;
	return result;
}

static void
budgie_brightness_util_set_backlight_device (BudgieBrightnessUtil* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_brightness_util_get_backlight_device (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_backlight_device);
		self->priv->_backlight_device = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_brightness_util_properties[BUDGIE_BRIGHTNESS_UTIL_BACKLIGHT_DEVICE_PROPERTY]);
	}
}

const gchar*
budgie_brightness_util_get_backlight_path (BudgieBrightnessUtil* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_backlight_path;
	result = _tmp0_;
	return result;
}

static void
budgie_brightness_util_set_backlight_path (BudgieBrightnessUtil* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_brightness_util_get_backlight_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_backlight_path);
		self->priv->_backlight_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_brightness_util_properties[BUDGIE_BRIGHTNESS_UTIL_BACKLIGHT_PATH_PROPERTY]);
	}
}

gint
budgie_brightness_util_get_max_brightness (BudgieBrightnessUtil* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_max_brightness;
	return result;
}

static void
budgie_brightness_util_set_max_brightness (BudgieBrightnessUtil* self,
                                           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_brightness_util_get_max_brightness (self);
	if (old_value != value) {
		self->priv->_max_brightness = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_brightness_util_properties[BUDGIE_BRIGHTNESS_UTIL_MAX_BRIGHTNESS_PROPERTY]);
	}
}

gint
budgie_brightness_util_get_current_brightness (BudgieBrightnessUtil* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_current_brightness;
	return result;
}

static void
budgie_brightness_util_set_current_brightness (BudgieBrightnessUtil* self,
                                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_brightness_util_get_current_brightness (self);
	if (old_value != value) {
		self->priv->_current_brightness = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_brightness_util_properties[BUDGIE_BRIGHTNESS_UTIL_CURRENT_BRIGHTNESS_PROPERTY]);
	}
}

static void
budgie_brightness_util_class_init (BudgieBrightnessUtilClass * klass,
                                   gpointer klass_data)
{
	budgie_brightness_util_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieBrightnessUtil_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_brightness_util_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_brightness_util_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_brightness_util_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_BRIGHTNESS_UTIL_BACKLIGHT_DEVICE_PROPERTY, budgie_brightness_util_properties[BUDGIE_BRIGHTNESS_UTIL_BACKLIGHT_DEVICE_PROPERTY] = g_param_spec_string ("backlight-device", "backlight-device", "backlight-device", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_BRIGHTNESS_UTIL_BACKLIGHT_PATH_PROPERTY, budgie_brightness_util_properties[BUDGIE_BRIGHTNESS_UTIL_BACKLIGHT_PATH_PROPERTY] = g_param_spec_string ("backlight-path", "backlight-path", "backlight-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_BRIGHTNESS_UTIL_MAX_BRIGHTNESS_PROPERTY, budgie_brightness_util_properties[BUDGIE_BRIGHTNESS_UTIL_MAX_BRIGHTNESS_PROPERTY] = g_param_spec_int ("max-brightness", "max-brightness", "max-brightness", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_BRIGHTNESS_UTIL_CURRENT_BRIGHTNESS_PROPERTY, budgie_brightness_util_properties[BUDGIE_BRIGHTNESS_UTIL_CURRENT_BRIGHTNESS_PROPERTY] = g_param_spec_int ("current-brightness", "current-brightness", "current-brightness", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
budgie_brightness_util_instance_init (BudgieBrightnessUtil * self,
                                      gpointer klass)
{
	self->priv = budgie_brightness_util_get_instance_private (self);
	self->priv->_backlight_device = NULL;
	self->priv->_backlight_path = NULL;
	self->priv->_max_brightness = 0;
	self->priv->_current_brightness = 0;
}

static void
budgie_brightness_util_finalize (GObject * obj)
{
	BudgieBrightnessUtil * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_BRIGHTNESS_UTIL, BudgieBrightnessUtil);
	_g_free0 (self->priv->_backlight_device);
	_g_free0 (self->priv->_backlight_path);
	G_OBJECT_CLASS (budgie_brightness_util_parent_class)->finalize (obj);
}

/**
    * Shared brightness utilities used by both BrightnessManager and BrightnessHelper
    */
static GType
budgie_brightness_util_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieBrightnessUtilClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_brightness_util_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieBrightnessUtil), 0, (GInstanceInitFunc) budgie_brightness_util_instance_init, NULL };
	GType budgie_brightness_util_type_id;
	budgie_brightness_util_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieBrightnessUtil", &g_define_type_info, 0);
	BudgieBrightnessUtil_private_offset = g_type_add_instance_private (budgie_brightness_util_type_id, sizeof (BudgieBrightnessUtilPrivate));
	return budgie_brightness_util_type_id;
}

GType
budgie_brightness_util_get_type (void)
{
	static volatile gsize budgie_brightness_util_type_id__once = 0;
	if (g_once_init_enter (&budgie_brightness_util_type_id__once)) {
		GType budgie_brightness_util_type_id;
		budgie_brightness_util_type_id = budgie_brightness_util_get_type_once ();
		g_once_init_leave (&budgie_brightness_util_type_id__once, budgie_brightness_util_type_id);
	}
	return budgie_brightness_util_type_id__once;
}

static void
_vala_budgie_brightness_util_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	BudgieBrightnessUtil * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_BRIGHTNESS_UTIL, BudgieBrightnessUtil);
	switch (property_id) {
		case BUDGIE_BRIGHTNESS_UTIL_BACKLIGHT_DEVICE_PROPERTY:
		g_value_set_string (value, budgie_brightness_util_get_backlight_device (self));
		break;
		case BUDGIE_BRIGHTNESS_UTIL_BACKLIGHT_PATH_PROPERTY:
		g_value_set_string (value, budgie_brightness_util_get_backlight_path (self));
		break;
		case BUDGIE_BRIGHTNESS_UTIL_MAX_BRIGHTNESS_PROPERTY:
		g_value_set_int (value, budgie_brightness_util_get_max_brightness (self));
		break;
		case BUDGIE_BRIGHTNESS_UTIL_CURRENT_BRIGHTNESS_PROPERTY:
		g_value_set_int (value, budgie_brightness_util_get_current_brightness (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_brightness_util_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	BudgieBrightnessUtil * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_BRIGHTNESS_UTIL, BudgieBrightnessUtil);
	switch (property_id) {
		case BUDGIE_BRIGHTNESS_UTIL_BACKLIGHT_DEVICE_PROPERTY:
		budgie_brightness_util_set_backlight_device (self, g_value_get_string (value));
		break;
		case BUDGIE_BRIGHTNESS_UTIL_BACKLIGHT_PATH_PROPERTY:
		budgie_brightness_util_set_backlight_path (self, g_value_get_string (value));
		break;
		case BUDGIE_BRIGHTNESS_UTIL_MAX_BRIGHTNESS_PROPERTY:
		budgie_brightness_util_set_max_brightness (self, g_value_get_int (value));
		break;
		case BUDGIE_BRIGHTNESS_UTIL_CURRENT_BRIGHTNESS_PROPERTY:
		budgie_brightness_util_set_current_brightness (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

