/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.exception;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.EmptyStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionAttrNode;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionBuiltins;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.ImportErrorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.exception.ImportErrorBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.lib.PyUnicodeCheckExactNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.ImportError})
public final class ImportErrorBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ImportErrorBuiltinsSlotsGen.SLOTS;
    protected static final int IDX_MSG = 0;
    protected static final int IDX_NAME = 1;
    protected static final int IDX_PATH = 2;
    public static final int IMPORT_ERR_NUM_ATTRS = 3;
    public static final BaseExceptionAttrNode.StorageFactory IMPORT_ERROR_ATTR_FACTORY = args -> {
        Object[] attrs = new Object[3];
        if (args.length == 1) {
            attrs[0] = args[0];
        }
        return attrs;
    };

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ImportErrorBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_str, isComplex=true)
    @GenerateNodeFactory
    public static abstract class ImportErrorStrNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object str(VirtualFrame frame, PBaseException self, @Bind Node inliningTarget, @Cached BaseExceptionAttrNode attrNode, @Cached BaseExceptionBuiltins.StrNode exStrNode, @Cached PyUnicodeCheckExactNode unicodeCheckExactNode) {
            Object msg = attrNode.get(self, 0, IMPORT_ERROR_ATTR_FACTORY);
            if (msg != PNone.NONE && unicodeCheckExactNode.execute(inliningTarget, msg)) {
                return msg;
            }
            return exStrNode.execute(frame, self);
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ImportErrorReduceNode
    extends PythonUnaryBuiltinNode {
        private static Object getState(Node inliningTarget, PBaseException self, GetDictIfExistsNode getDictIfExistsNode, HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, HashingStorageNodes.HashingStorageCopy copyStorageNode, BaseExceptionAttrNode attrNode, PythonLanguage language) {
            PDict dict = getDictIfExistsNode.execute(self);
            Object name = attrNode.get(self, 1, IMPORT_ERROR_ATTR_FACTORY);
            Object path = attrNode.get(self, 2, IMPORT_ERROR_ATTR_FACTORY);
            if (name != null || path != null) {
                HashingStorage storage;
                HashingStorage hashingStorage = storage = dict != null ? copyStorageNode.execute(inliningTarget, dict.getDictStorage()) : EmptyStorage.INSTANCE;
                if (name != null) {
                    storage = setHashingStorageItem.execute(inliningTarget, storage, StringLiterals.T_NAME, name);
                }
                if (path != null) {
                    storage = setHashingStorageItem.execute(inliningTarget, storage, StringLiterals.T_PATH, path);
                }
                return PFactory.createDict(language, storage);
            }
            if (dict != null) {
                return dict;
            }
            return PNone.NONE;
        }

        @Specialization
        static Object reduce(PBaseException self, @Bind Node inliningTarget, @Cached BaseExceptionAttrNode attrNode, @Cached GetClassNode getClassNode, @Cached GetDictIfExistsNode getDictIfExistsNode, @Cached ExceptionNodes.GetArgsNode getArgsNode, @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached HashingStorageNodes.HashingStorageCopy copyStorageNode, @Bind PythonLanguage language) {
            Object clazz = getClassNode.execute(inliningTarget, self);
            PTuple args = getArgsNode.execute(inliningTarget, self);
            Object state = ImportErrorReduceNode.getState(inliningTarget, self, getDictIfExistsNode, setHashingStorageItem, copyStorageNode, attrNode, language);
            if (state == PNone.NONE) {
                return PFactory.createTuple(language, new Object[]{clazz, args});
            }
            return PFactory.createTuple(language, new Object[]{clazz, args, state});
        }
    }

    @Builtin(name="path", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="module path")
    @GenerateNodeFactory
    public static abstract class ImportErrorPathNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 2, IMPORT_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="name", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="module name")
    @GenerateNodeFactory
    public static abstract class ImportErrorNameNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 1, IMPORT_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="msg", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="exception message")
    @GenerateNodeFactory
    public static abstract class ImportErrorMsgNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 0, IMPORT_ERROR_ATTR_FACTORY);
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class ImportErrorInitNode
    extends PythonVarargsBuiltinNode {
        private static final TruffleString NAME = PythonUtils.tsLiteral("name");
        private static final TruffleString PATH = PythonUtils.tsLiteral("path");

        @Specialization
        static Object init(PBaseException self, Object[] args, PKeyword[] kwargs, @Bind Node inliningTarget, @Cached BaseExceptionBuiltins.BaseExceptionInitNode baseExceptionInitNode, @Cached TruffleString.EqualNode equalNode, @Cached PRaiseNode raiseNode) {
            baseExceptionInitNode.execute(self, args);
            Object[] attrs = IMPORT_ERROR_ATTR_FACTORY.create(args);
            for (PKeyword kw : kwargs) {
                TruffleString kwName = kw.getName();
                if (equalNode.execute((AbstractTruffleString)kwName, (AbstractTruffleString)NAME, PythonUtils.TS_ENCODING)) {
                    attrs[1] = kw.getValue();
                    continue;
                }
                if (equalNode.execute((AbstractTruffleString)kwName, (AbstractTruffleString)PATH, PythonUtils.TS_ENCODING)) {
                    attrs[2] = kw.getValue();
                    continue;
                }
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_IS_AN_INVALID_ARG_FOR_S, kw.getName(), "ImportError");
            }
            self.setExceptionAttributes(attrs);
            return PNone.NONE;
        }
    }
}

